/*
 * Decompiled with CFR 0.152.
 */
package leonii;

import java.util.ArrayList;
import leonii.DirichletMixture;
import leonii.ReadAlignment;
import leonii.Sequence;
import leonii.groupcoreblock;

public class Bscore {
    ReadAlignment alignment;
    String fileDichletMixture;
    ArrayList<ArrayList<Double>> results;
    int cluster;
    double scoreresiduconserver = 0.0;

    public Bscore(ReadAlignment alignment, String fileDichletMixture, int cluster) {
        this.alignment = alignment;
        this.fileDichletMixture = fileDichletMixture;
        this.results = new ArrayList();
        this.cluster = cluster;
    }

    ArrayList<Double> scoreColumns() {
        ArrayList<Double> columnscores = new ArrayList<Double>();
        int sizesequence = this.alignment.sequenceArray.get((int)1).Seq.size();
        for (int c = 0; c < sizesequence; ++c) {
            double score = this.columnscore(c, this.cluster);
            columnscores.add(score);
        }
        return columnscores;
    }

    ArrayList column(int number, int cluster) {
        ArrayList<String> column = new ArrayList<String>();
        for (int i = 0; i < this.alignment.sequenceArray.size(); ++i) {
            Sequence sequence = this.alignment.sequenceArray.get(i);
            if (sequence.Cluster != cluster) continue;
            column.add(sequence.Seq.get(number));
        }
        return column;
    }

    ArrayList column(int number, int cluster, Sequence seq) {
        ArrayList<String> column = new ArrayList<String>();
        for (int i = 0; i < this.alignment.sequenceArray.size(); ++i) {
            Sequence sequence = this.alignment.sequenceArray.get(i);
            if (sequence.Cluster != cluster || sequence.equals(seq)) continue;
            column.add(sequence.Seq.get(number));
        }
        return column;
    }

    double columnscore(int number, int cluster) {
        DirichletMixture dirichletMixture = new DirichletMixture(this.fileDichletMixture);
        ArrayList column = this.column(number, cluster);
        double score = 1.0;
        for (int naa = 0; naa < column.size(); ++naa) {
            double a = dirichletMixture.Prob((String)column.get(naa), true);
            score *= a;
        }
        double nscore = this.normalisescore(score, column.size());
        return nscore;
    }

    double normalisescore(double score, double longueur) {
        return 100.0 * Math.pow(score, 1.0 / longueur);
    }

    double relatedcolumnscore(int number, int cluster1) {
        DirichletMixture dirichletMixture = new DirichletMixture(this.fileDichletMixture);
        ArrayList column = this.column(number, cluster1);
        double score = 1.0;
        for (int naa = 0; naa < column.size(); ++naa) {
            double a = dirichletMixture.Prob((String)column.get(naa), false);
            score *= a;
        }
        return score;
    }

    double relatedcolumnscore(int number, int cluster1, int cluster2) {
        DirichletMixture dirichletMixture = new DirichletMixture(this.fileDichletMixture);
        ArrayList column = this.column(number, cluster1);
        column.addAll(this.column(number, cluster2));
        double score = 1.0;
        for (int naa = 0; naa < column.size(); ++naa) {
            double a = dirichletMixture.Prob((String)column.get(naa), false);
            score *= a;
        }
        return score;
    }

    double scoreResidueInColumn(int number, int numberresidu) {
        DirichletMixture dirichletMixture = new DirichletMixture(this.fileDichletMixture);
        ArrayList column = this.column(number, this.cluster);
        for (int naa = 0; naa < column.size(); ++naa) {
            if (naa == numberresidu) continue;
            dirichletMixture.Prob((String)column.get(naa), false);
        }
        double prob = dirichletMixture.Prob((String)column.get(numberresidu), false);
        return prob;
    }

    ArrayList<Double> scoreWindows(ArrayList scoreColumns, int sizeWindows, int numcluster) {
        int col;
        ArrayList<Double> scoreWindows = new ArrayList<Double>();
        for (col = 0; col < sizeWindows; ++col) {
            scoreWindows.add(0.0);
        }
        for (col = sizeWindows; col < scoreColumns.size() - sizeWindows; ++col) {
            scoreWindows.add(this.scorewindow(scoreColumns, col - sizeWindows, col + sizeWindows));
        }
        return scoreWindows;
    }

    double scorewindow(ArrayList scoreColumns, int start, int end) {
        double sumscore = 0.0;
        for (int i = start; i < end + 1; ++i) {
            double scorewindow = (Double)scoreColumns.get(i);
            if (scorewindow < 0.0) {
                scorewindow = 0.0;
            }
            sumscore += scorewindow;
        }
        double meanscore = sumscore / (double)(end - start);
        return meanscore;
    }

    ArrayList<int[]> coreblocks(ArrayList windowScores, ArrayList columnScores, int numcluster) {
        ArrayList<int[]> blocks = new ArrayList<int[]>();
        Boolean incb = false;
        int start = 0;
        int end = 0;
        double score = 0.0;
        double cscore = 0.0;
        for (int col = 0; col < windowScores.size(); ++col) {
            score = (Double)windowScores.get(col);
            cscore = (Double)columnScores.get(col);
            if (score > 5.0) {
                if (!incb.booleanValue()) {
                    start = end = col;
                    incb = true;
                    continue;
                }
                end = col;
                continue;
            }
            if (!incb.booleanValue()) continue;
            int[] position = new int[]{start, end};
            if (end - start > 3) {
                blocks.add(position);
            }
            incb = false;
        }
        if (incb.booleanValue()) {
            int[] position = new int[]{start, end};
            if (end - start > 3) {
                blocks.add(position);
            }
        }
        return blocks;
    }

    Sequence numbertosequence(int numerosequence, int numerocluster) {
        int numbertofind = 0;
        for (int i = 0; i < this.alignment.sequenceArray.size(); ++i) {
            Sequence sequence = this.alignment.sequenceArray.get(i);
            if (sequence.Cluster != this.cluster) continue;
            if (numbertofind == numerosequence) {
                return sequence;
            }
            ++numbertofind;
        }
        return null;
    }

    Sequence sequencequery() {
        for (Sequence seq : this.alignment.sequenceArray) {
            if (!seq.Name.equals(this.alignment.sequenceQuery)) continue;
            return seq;
        }
        System.out.println("ERROR: Sequence query not found");
        return null;
    }

    boolean coreblockvscoreblock(int[] startend, int cluster1, int cluster2) {
        double related = 0.0;
        double unrelated = 0.0;
        double sumrelated = 0.0;
        double sumunrelated = 0.0;
        for (int i = startend[0]; i <= startend[1]; ++i) {
            related = this.relatedcolumnscore(i, cluster1, cluster2);
            sumrelated += related;
            unrelated = this.relatedcolumnscore(i, cluster1) * this.relatedcolumnscore(i, cluster2);
            sumunrelated += unrelated;
        }
        return sumrelated >= sumunrelated;
    }

    void checkcoreblock() {
        groupcoreblock coreblockquery;
        Sequence query = this.sequencequery();
        int color = 0;
        int lcolor = 0;
        for (groupcoreblock cb : this.alignment.coreblocks) {
            if (cb.cluster != query.Cluster) continue;
            coreblockquery = cb;
            for (int[] querycb : coreblockquery.coreblock) {
                if (!this.coreblockIsinQuery(querycb, query.Cluster, query)) continue;
                ++color;
            }
        }
        lcolor = color + 1;
        color = 0;
        for (groupcoreblock cb : this.alignment.coreblocks) {
            if (cb.cluster != query.Cluster) continue;
            coreblockquery = cb;
            for (int[] querycb : coreblockquery.coreblock) {
                if (!this.coreblockIsinQuery(querycb, query.Cluster, query)) continue;
                this.ScoresegmentsAgainstcluster(querycb, query.Cluster, -1, ++color);
                this.ScoresegmentsAgainstcluster(querycb, query.Cluster, query.Cluster, color);
                for (groupcoreblock othercb : this.alignment.coreblocks) {
                    if (othercb.cluster == query.Cluster) continue;
                    for (int[] cba : othercb.coreblock) {
                        if (!(cba[0] >= querycb[0] && cba[0] <= querycb[1] || cba[1] >= querycb[0] && cba[1] <= querycb[1] || querycb[0] >= cba[0] && querycb[0] <= cba[1]) && (querycb[1] < cba[0] || querycb[1] > cba[1])) continue;
                        int start = cba[0] > querycb[0] ? cba[0] : querycb[0];
                        int end = cba[1] > querycb[1] ? querycb[1] : cba[1];
                        int[] startend = new int[]{start, end};
                        if (end - start <= 3) continue;
                        if (this.coreblockvscoreblock(startend, query.Cluster, othercb.cluster)) {
                            for (Sequence seq : this.alignment.sequenceArray) {
                                Boolean status;
                                if (seq.Cluster != othercb.cluster || (status = this.ScoresegmentAgainstcluster(startend, othercb.cluster, seq, color)).booleanValue()) continue;
                                status = this.ScoresegmentAgainstcluster(startend, query.Cluster, seq, color);
                            }
                            continue;
                        }
                        this.ScoresegmentsAgainstcluster(startend, othercb.cluster, othercb.cluster, ++lcolor);
                    }
                }
            }
        }
    }

    void ScoresegmentsAgainstcluster(int[] startend, int querycluster, int clustertocompare, int color) {
        for (Sequence seq : this.alignment.sequenceArray) {
            if (seq.Cluster != clustertocompare) continue;
            Boolean bl = this.ScoresegmentAgainstcluster(startend, querycluster, seq, color);
        }
    }

    Boolean ScoresegmentAgainstcluster(int[] startend, int querycluster, Sequence seqtocompare, int color) {
        double scoreseg = 1.0;
        double random = this.randomsegment(seqtocompare, startend[0], startend[1]);
        for (int c = startend[0]; c < startend[1] + 1; ++c) {
            DirichletMixture dirichletMixture = new DirichletMixture(this.fileDichletMixture);
            ArrayList column = seqtocompare.Cluster == querycluster ? this.column(c, querycluster, seqtocompare) : this.column(c, querycluster);
            for (int naa = 0; naa < column.size(); ++naa) {
                dirichletMixture.Prob((String)column.get(naa), false);
            }
            double score = dirichletMixture.Prob(seqtocompare.Seq.get(c), false);
            scoreseg *= score;
        }
        if (scoreseg > random) {
            seqtocompare.AddCoreBlock(startend[0], startend[1], this.normalisescore(scoreseg, startend[1] - startend[0]), color);
            return true;
        }
        return false;
    }

    boolean coreblockIsinQuery(int[] startend, int querycluster, Sequence seqtocompare) {
        double scoreseg = 1.0;
        double random = this.randomsegment(seqtocompare, startend[0], startend[1]);
        for (int c = startend[0]; c < startend[1] + 1; ++c) {
            DirichletMixture dirichletMixture = new DirichletMixture(this.fileDichletMixture);
            ArrayList column = this.column(c, querycluster, seqtocompare);
            for (int naa = 0; naa < column.size(); ++naa) {
                dirichletMixture.Prob((String)column.get(naa), false);
            }
            scoreseg *= dirichletMixture.Prob(seqtocompare.Seq.get(c), false);
        }
        return scoreseg > random;
    }

    double randomsegment(Sequence seq, int debut, int fin) {
        double randomscore = 1.0;
        for (int i = debut; i <= fin; ++i) {
            randomscore *= this.randomaa(seq.Seq.get(i));
        }
        return randomscore;
    }

    double randomaa(String aa) {
        double scoreaa = 0.05;
        String[] ArrayOfResidues = new String[]{"A", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "V", "W", "Y"};
        double[] Arrayscore = new double[]{0.0825, 0.0137, 0.0545, 0.0675, 0.0386, 0.0707, 0.0227, 0.0596, 0.0584, 0.0966, 0.0242, 0.0406, 0.047, 0.0393, 0.0553, 0.0656, 0.0534, 0.0687, 0.0108, 0.0292};
        for (int i = 0; i < ArrayOfResidues.length; ++i) {
            if (!aa.equals(ArrayOfResidues[i])) continue;
            scoreaa = Arrayscore[i];
        }
        return scoreaa;
    }
}

