/*
 * Decompiled with CFR 0.152.
 */
package leonii;

public class DirichletDistribution {
    double sum;
    String[] ArrayOfResidu;
    double[] ArrayOfScore;
    int NumberOfResidu;
    double Mixture;

    public DirichletDistribution(double Mixture, String[] ArrayOfResidu) {
        this.Mixture = Mixture;
        this.ArrayOfResidu = ArrayOfResidu;
    }

    void addResidu(String residu) {
        for (int i = 0; i < this.ArrayOfResidu.length; ++i) {
            if (!this.ArrayOfResidu[i].equals(residu)) continue;
            int n = i;
            this.ArrayOfScore[n] = this.ArrayOfScore[n] + 1.0;
            this.sum += 1.0;
        }
    }

    void setMixture(double m) {
        this.Mixture = m;
    }

    public void setArrayOfScore(double[] ArrayOfScore) {
        this.ArrayOfScore = ArrayOfScore;
        this.calculSum();
    }

    double probabilityOfAminoAcidCorrected(String residu) {
        for (int i = 0; i < this.ArrayOfResidu.length; ++i) {
            if (!this.ArrayOfResidu[i].equals(residu)) continue;
            return this.Mixture * (this.ArrayOfScore[i] / this.sum);
        }
        return 0.01;
    }

    double scoreOfAminoAcid(String AminoAcid) {
        for (int i = 0; i < this.ArrayOfResidu.length; ++i) {
            if (!this.ArrayOfResidu[i].equals(AminoAcid)) continue;
            return this.ArrayOfScore[i];
        }
        return 0.01;
    }

    private void calculSum() {
        this.sum = 0.0;
        for (int i = 0; i < this.ArrayOfScore.length; ++i) {
            this.sum += this.ArrayOfScore[i];
        }
    }

    void printdirichlet() {
        System.out.println("Poid=" + this.Mixture);
        for (String R : this.ArrayOfResidu) {
            System.out.print(R);
        }
        System.out.println(" ");
        double[] dArray = this.ArrayOfScore;
        int len$ = dArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double d = dArray[i$];
            System.out.print(d);
        }
        System.out.println(" ");
    }
}

