/*
 * Decompiled with CFR 0.152.
 */
package leonii;

import java.util.ArrayList;
import leonii.Bscore;
import leonii.ReadAlignment;
import leonii.coreblocktoxml;
import leonii.readcluspack;

public class Leonii {
    private static ReadAlignment ReadAlignment;
    static Bscore bscore;

    public static void main(String[] args) {
        String fileAlignment = "";
        String filecluspack = "";
        String fileDichletMixture = null;
        Boolean PrintScores = false;
        Boolean cluspack = true;
        String filexml = "";
        String nameAlignment = "";
        String query = "";
        if (args.length == 0) {
            Leonii.printHelp();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-file".equals(args[i])) {
                fileAlignment = args[i + 1];
                continue;
            }
            if ("-dirichlet".equals(args[i])) {
                fileDichletMixture = args[i + 1];
                continue;
            }
            if ("-help".equals(args[i])) {
                Leonii.printHelp();
                return;
            }
            if ("-scores".equals(args[i])) {
                PrintScores = true;
                continue;
            }
            if ("-clu".equals(args[i])) {
                filecluspack = args[i + 1];
                continue;
            }
            if ("-xml".equals(args[i])) {
                filexml = args[i + 1];
                continue;
            }
            if (!"-query".equals(args[i])) continue;
            query = args[i + 1];
        }
        ReadAlignment = new ReadAlignment(fileAlignment, nameAlignment);
        if (cluspack.booleanValue()) {
            readcluspack groups = new readcluspack(filecluspack, ReadAlignment);
            groups.AddGroup();
            for (int n = 0; n < groups.numCluster + 1; ++n) {
                bscore = new Bscore(ReadAlignment, fileDichletMixture, n);
                ArrayList<Double> columnscores = bscore.scoreColumns();
                ArrayList<Double> windowscores = bscore.scoreWindows(columnscores, 2, n);
                ArrayList<int[]> coreblocks = bscore.coreblocks(windowscores, columnscores, n);
                ReadAlignment.addgroupcoreblock(coreblocks, n);
                ReadAlignment.setsequencequery(query);
            }
            bscore.checkcoreblock();
            coreblocktoxml cxml = new coreblocktoxml(ReadAlignment, filexml);
            cxml.generatexml();
        }
        if (!cluspack.booleanValue()) {
            bscore = new Bscore(ReadAlignment, fileDichletMixture, 0);
            ArrayList<Double> scoreAlignment = bscore.scoreColumns();
            if (PrintScores.booleanValue()) {
                System.out.println(scoreAlignment.toString());
            }
        }
    }

    static void printHelp() {
        System.out.println("Enter the options:");
        System.out.println("required:");
        System.out.println("-file <file containing the alignment> ");
        System.out.println("-clu <cluspack file>");
        System.out.println("-xml <output xml file>");
        System.out.println("-name <name_of_alignment>");
        System.out.println("-query <query>");
        System.out.println("optional:");
        System.out.println("-dirichlet <dirichlet file> #recod3.20.comp by default");
        System.out.println("-cutofmin <cutofmin> # 0.2 by default");
    }
}

