/*
 * Decompiled with CFR 0.152.
 */
package leonii;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import leonii.Sequence;
import leonii.groupcoreblock;

public class ReadAlignment {
    String file;
    ArrayList<Sequence> sequenceArray;
    boolean bname;
    String name;
    String sequenceQuery;
    ArrayList<groupcoreblock> coreblocks;

    public ReadAlignment(String file, String name) {
        this.file = file;
        this.sequenceArray = new ArrayList();
        this.name = name;
        this.sequenceQuery = "";
        this.coreblocks = new ArrayList();
        this.fastaormsf();
        this.codeterminalgaps();
    }

    String codeterminalgaps() {
        for (Sequence seq : this.sequenceArray) {
            String c;
            int i;
            int sizesequence = seq.Seq.size();
            for (i = 1; i < sizesequence && ("-".equals(c = seq.Seq.get(i)) || ".".equals(c)); ++i) {
                seq.Seq.set(i, ".");
            }
            for (i = sizesequence - 1; i >= 0 && ("-".equals(c = seq.Seq.get(i)) || ".".equals(c)); --i) {
                seq.Seq.set(i, ".");
            }
        }
        return null;
    }

    String fastaormsf() {
        boolean endOfFile = false;
        try {
            int count = 0;
            FileReader fileAlignment = new FileReader(this.file);
            BufferedReader fileBuffer = new BufferedReader(fileAlignment);
            while (!endOfFile) {
                String fileLine = fileBuffer.readLine();
                if (fileLine == null) {
                    endOfFile = true;
                    continue;
                }
                String[] fileLineArray = fileLine.split("");
                try {
                    if (++count > 5) {
                        this.msfToSequence();
                        return null;
                    }
                    if (!">".equals(fileLineArray[1])) continue;
                    this.fastaToSequence();
                    return null;
                }
                catch (Exception exception) {
                }
            }
            fileBuffer.close();
        }
        catch (IOException e) {
            System.out.println("ERREUR lecture fichier alignment");
        }
        return null;
    }

    void fastaToSequence() {
        boolean endOfFile = false;
        try {
            FileReader fileAlignment = new FileReader(this.file);
            BufferedReader fileBuffer = new BufferedReader(fileAlignment);
            while (!endOfFile) {
                String fileLine = fileBuffer.readLine();
                if (fileLine == null) {
                    endOfFile = true;
                    continue;
                }
                String[] fileLineArray = fileLine.split("");
                try {
                    if (">".equals(fileLineArray[1])) {
                        String nomSequence = "";
                        for (int i = 2; i < fileLineArray.length; ++i) {
                            nomSequence = nomSequence + fileLineArray[i];
                        }
                        this.sequenceArray.add(new Sequence(nomSequence));
                        continue;
                    }
                    if (" ".equals(fileLineArray[1])) continue;
                    for (int i = 1; i < fileLineArray.length; ++i) {
                        Sequence lastSequence = this.sequenceArray.get(this.sequenceArray.size() - 1);
                        lastSequence.AddResidu(fileLineArray[i].toUpperCase());
                    }
                }
                catch (Exception exception) {
                }
            }
            fileBuffer.close();
        }
        catch (IOException e) {
            System.out.println("ERROR reading file Fasta");
        }
    }

    void msfToSequence() {
        boolean endOfFile = false;
        try {
            FileReader fileAlignment = new FileReader(this.file);
            BufferedReader fileBuffer = new BufferedReader(fileAlignment);
            while (!endOfFile) {
                String fileLine = fileBuffer.readLine();
                if (fileLine == null) {
                    endOfFile = true;
                    continue;
                }
                String[] fileLineArray = fileLine.split(" ");
                try {
                    if ("Name:".equals(fileLineArray[1])) {
                        this.sequenceArray.add(new Sequence(fileLineArray[2]));
                    }
                    for (int i = 0; i < this.sequenceArray.size(); ++i) {
                        if (!this.sequenceArray.get((int)i).Name.equals(fileLineArray[0])) continue;
                        for (int x = 1; x < fileLineArray.length; ++x) {
                            String[] residu = fileLineArray[x].split("");
                            for (int z = 0; z < residu.length; ++z) {
                                if (residu[z].length() != 1) continue;
                                this.sequenceArray.get(i).AddResidu(residu[z]);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
            fileBuffer.close();
        }
        catch (IOException e) {
            System.out.println("ERROR reading file MSF");
        }
    }

    void setsequencequery(String namequerry) {
        this.sequenceQuery = namequerry;
    }

    String nameofalignment() {
        String name = this.file;
        Pattern pattern = Pattern.compile(".*/(.*)(#|$)");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            name = matcher.group(1);
        }
        if (name.indexOf(".") > 0) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return "\"" + this.file + "\"";
    }

    String nameofallignement() {
        return this.name;
    }

    void AddClusterToSequence(String nomsequence, int numCluster) {
        for (int i = 0; i < this.sequenceArray.size() + 1; ++i) {
            if (!this.sequenceArray.get((int)i).Name.equals(nomsequence)) continue;
            this.sequenceArray.get(i).AddCluster(numCluster);
            return;
        }
    }

    void addgroupcoreblock(ArrayList<int[]> coreblock2, int cluster) {
        groupcoreblock gb = new groupcoreblock(cluster, coreblock2);
        this.coreblocks.add(gb);
    }
}

