/*
 * Decompiled with CFR 0.152.
 */
package leonii;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import leonii.ReadAlignment;
import leonii.Sequence;
import leonii.coreblock;

public class coreblocktoxml {
    ReadAlignment alignment;
    String fichier;

    public coreblocktoxml(ReadAlignment alignment, String fichier) {
        this.alignment = alignment;
        this.fichier = fichier;
    }

    void generatexml() {
        String debut = "<?xml version=\"1.0\"?>\n <!DOCTYPE macsim SYSTEM \"http://www-bio3d-igbmc.u-strasbg.fr/macsim.dtd\">\n<macsim>\n<alignment>";
        debut = debut + "<aln-name>" + this.alignment.nameofalignment() + ".int3</aln-name>\n";
        for (Sequence seq : this.alignment.sequenceArray) {
            debut = debut + "<sequence seq-type=\"Protein\">\n";
            debut = debut + "<seq-name>" + seq.Name + "</seq-name>\n";
            debut = debut + "<seq-info>\n";
            debut = debut + "<accession>" + seq.Name + "</accession>\n";
            debut = debut + "<nid>" + seq.Name + "</nid>\n";
            debut = debut + "<ec>0.0.0.0</ec>\n";
            debut = debut + "<group>" + seq.Cluster + "</group>\n";
            debut = debut + "<ftable>\n";
            for (coreblock cb : seq.Coreblock) {
                debut = debut + "<fitem><ftype>BLOCK</ftype><fstart>" + cb.debut + "</fstart><fstop>" + cb.fin + "</fstop><fcolor>" + cb.color + "</fcolor><fscore>" + cb.score + "</fscore><fnote>SBLOCK</fnote></fitem>\n";
            }
            debut = debut + "</ftable>\n";
            debut = debut + "<length>" + seq.Seq.size() + "</length>\n";
            debut = debut + "<weight>100</weight>\n";
            debut = debut + "<group>" + seq.Cluster + "</group>\n";
            debut = debut + "</seq-info>\n";
            debut = debut + "<seq-data>" + seq.sequencetostring() + "\n";
            debut = debut + "</seq-data></sequence>\n";
        }
        debut = debut + "</alignment>\n";
        debut = debut + "</macsim>\n";
        this.tofile(debut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tofile(String text) {
        try {
            System.out.println(this.fichier + " " + this.alignment.nameofalignment());
            File file = new File(this.fichier);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
            BufferedWriter bw = new BufferedWriter(fw);
            try {
                bw.write(text);
            }
            catch (Exception exception) {
            }
            finally {
                bw.close();
                fw.close();
                System.out.println(" xml file created:" + this.fichier);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

