#!/bin/tcsh


if ( $# != 4 ) then
echo "Usage:leon-bis.tcsh input_file query_sequence_name output_aln_file output_log_file"
exit
endif

# You may need to edit these lines to point to cluspack and chain_blocks PATH.

setenv LEON1PATH leon_src
setenv CLUSPACKPATH cluspack_src

# convert input alignment to suitable format for external programs
$LEON1PATH/convseq $1 $$.tfa fasta

#launch cluspack
$CLUSPACKPATH/cluspack $$.tfa -dt=alignment -cm=bionj -nbc=secator -fd=0.01 -oclu=$$.clu
$LEON1PATH/readclusters $$.tfa $2 $$.clu > $$.clu1

#launch leon-bis.jar
java -jar leon-bis.jar -file $$.tfa -clu $$.clu1 -xml $$.xml -query $2 

#chain blocks into regions  min_blockscore max_blockdist min_regionscore min_regionlength 
#$LEON1PATH/chain_blocks $$.xml $2 $3 0 40 0 21 -keep>$4
$LEON1PATH/chain_blocks $$.xml $2 $3 0 40 0 21 >$4

\rm $$*



