#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "leon.h"

/* reads an alignment in one format and outputs it in another */

/* global data */

Boolean verbose;

int main(int argc, char **argv)
{
	FILE *ifd,*ofd;
	char c;
	sint  i,j;
        char infile[FILENAMELEN+1];
        char outfile[FILENAMELEN+1];
	char format[20];
	int temp;
	ALN mult_aln;
	OPT opt;

	if(argc!=4) {
		fprintf(stderr,"Usage: %s in_file out_file format\n",argv[0]);
		fprintf(stderr,"\twhere format=gcg/pir/rsf/fasta/macsims\n");
		return 1;
	}
        strcpy(infile,argv[1]);
        strcpy(outfile,argv[2]);
        strcpy(format,argv[3]);

        init_options(&opt);

/* open the aln file */
        seq_input(infile,opt.explicit_type,FALSE,&mult_aln);

        if(mult_aln.nseqs<=0) exit(1);

        (*opt.alnout_opt).output_clustal=FALSE;

	temp=0;
	if(strcasecmp(format,"gcg")==0) temp=1;
	else if(strcasecmp(format,"pir")==0) temp=2;
	else if(strcasecmp(format,"rsf")==0) temp=3;
	else if(strcasecmp(format,"fasta")==0) temp=4;
	else if(strcasecmp(format,"macsims")==0) temp=5;
	
	switch (temp) {
                case 1: /* GCG */
                        (*opt.alnout_opt).output_gcg     = TRUE;
        		strcpy((*opt.alnout_opt).gcg_outname, outfile);
                        break;
                case 2: /* PIR */
                        (*opt.alnout_opt).output_nbrf     = TRUE;
        		strcpy((*opt.alnout_opt).nbrf_outname, outfile);
                        break;
                case 3: /* RSF */
                        (*opt.alnout_opt).output_rsf     = TRUE;
        		strcpy((*opt.alnout_opt).rsf_outname, outfile);
                        break;
                case 4: /* TFA */
                        (*opt.alnout_opt).output_tfa     = TRUE;
        		strcpy((*opt.alnout_opt).tfa_outname, outfile);
                        break;
                case 5: /* RELACS */
			for(i=0;i<mult_aln.nseqs;i++)
				mult_aln.ft[i].nentries[COREBLOCK]=0;
                        (*opt.alnout_opt).output_relacs     = TRUE;
        		strcpy((*opt.alnout_opt).relacs_outname, outfile);
                        break;
                default:
                        fprintf(stdout,"\nUnknown OUTPUT type: %s\n",format);
	}


/* write out in requested format */
        if(!open_alignment_output(infile,opt.alnout_opt)) exit(1);
        create_alignment_output(mult_aln,*opt.alnout_opt);

}


