#!/usr/local/bin/wish

package require biotext-dev
#package require biotext
source /home/moumou/ordali/src/ordali_source.tcl

### DATA ###############
# Create mapping
set Lignes "I white magenta
J white magenta
L white magenta
M white magenta
V white magenta
R white blue
K white blue
F white red
Y white red
W white red
D white forestgreen
B white forestgreen
E white forestgreen
Z black green1
Q black green1
P white black
G black orange
H black cyan
N black cyan
S white darkviolet
T white darkviolet
A white darkviolet
U white darkviolet
C white darkviolet
X black dimgrey
. black dimgrey
0 black white
1 black white
2 black white
3 black white
4 black white
5 black white
6 black white
7 black white
8 black white
9 black white
Space white white"
set Lmap [list]
foreach l [split $Lignes \n] {
    lassign [split [string trim $l] " "] n f b
    if {$n eq "Space"} {set n " "}
    lappend Lmap [list $n $f $b]
}

proc CoupleY {args} {
    .f.b yview {*}$args
    .f.t yview {*}$args

    return
}

proc RandSeq {{nlines 50} {len 100}} {
    set Lseq [list]
    set Lnom [list]
    set a ".A.CDEFGH.I.KLMN.PQRST.VW.Y.A.CDEFGH.I.KLMN.PQRST.VW.Y."
    set la [string length $a]
    # create first sequence
    set s ""
    for {set j 0} {$j < $len} {incr j} {
	if {! ($j%1000)} {
	    puts "  $j done ..."
	}
	set x [expr {int($la*rand())}]
	append s [string index $a $x]
    }
    lappend Lseq $s
    lappend Lnom "Seq-0"
    for {set i 1} {$i < $nlines} {incr i} {
	set ix [expr {int($len*rand())}]
	set n "[string range $s $ix end][string range $s 0 $ix-1]"
	lappend Lseq $n
	lappend Lnom "Seq-$i"
    }
    
    return [list $Lseq $Lnom]
}

##########################
font create Luc -family CourierNew -size 20 

proc FromScrollYBiotext2Names {args} {
    # lululu
    # le widget biotext envoie un ordre pour que la scrollbar 
    # se reajuste EN TANT QUE WIDGET, pas qu'elle renvoie les 
    # infos aux widget auxquels elle est attach, sinon on 
    # ferait une boucle ! 
    # mais il faut quand meme mettre  jour le widget noms

    .f.t yview moveto [lindex $args 0]
    .f.sv set {*}$args

    return
}

puts "argc $argc argv $argv"
if {$argc == 1} {
    set o [open [lindex $argv 0] r]
    set l [read -nonewline $o]
    close $o
    set Ll [split $l "\n"]
    foreach {n s} $Ll {
	lappend Lnom [string range $n 1 end]
	lappend Lseq $s
    }
} else {
    lassign [RandSeq 200 5000] Lseq Lnom
}
puts "[llength $Lseq] of length [string length [lindex $Lseq 0]]"
set o [open rand.tfa w]
foreach n $Lnom s $Lseq {
    puts $o ">$n"
    puts $o $s
}
close $o
#exit

frame .f
grid .f -row 0 -column 0 -sticky news
grid columnconfig . 0 -weight 1
grid rowconfig    . 0 -weight 1

text .f.t \
    -width 6 \
    -height 10 \
    -font Luc \
    -wrap none
biotext .f.b \
    -bd 2 \
    -yscrollcommand "FromScrollYBiotext2Names" \
    -xscrollcommand ".f.sh set" \
    -width 20 \
    -height 10 \
    -class Biotext
scrollbar .f.sh \
    -bg blue \
    -orient horiz \
    -command ".f.b xview "
scrollbar .f.sv \
    -bg blue \
    -command "CoupleY "
set Bmap 1
set Btag 0
button .f.bt \
    -text "toggle TAG" \
    -background blue \
    -foreground white \
    -command [list if {$Btag == 0} {
	.f.b tag state on
	set Btag 1
    } else {
	set Btag 0
	.f.b tag state off
    }
	     ]
button .f.bm \
    -text "toggle MAP" \
    -background green1 \
    -foreground white \
    -text " Reset " \
    -command [list if {$Bmap == 0} {
	.f.b map on
	set Bmap 1
    } else {
	set Bmap 0
	.f.b map off
    }
	     ]
button .f.br \
    -fg white \
    -bg magenta \
    -command {.f.b clean
	.f.b sequences $Lseq
	.f.b mapping $Lmap
	.f.b map on
	#.f.b map off
	.f.b tag configure toto -foreground yellow -background blue
	.f.b tag add toto 1.2 1.7 3.3 3.8 5.4 5.9 9.0 9.4 12.0 12.5 48.80 end
	.f.b tag configure titi -foreground green -background magenta
	.f.b tag add titi 2.2 2.7 6.3 6.12 8.0 8.4 11.0 11.5 40.80 43.90
	.f.b tag state off
	
    }

grid .f.t   -row 0 -column 0 -sticky ns
grid .f.b   -row 0 -column 1 -sticky news
grid .f.sv  -row 0 -column 2 -sticky ns
grid .f.sh  -row 1 -column 1 -sticky ew
grid .f.bm  -row 2 -column 0
grid .f.bt  -row 2 -column 1
grid .f.br  -row 3 -column 1
grid columnconfig .f 1 -weight 1
grid rowconfig    .f 0 -weight 1

bind .f.b <4> {%W yview scroll -1 units ; break}
bind .f.b <5> {%W yview scroll  1 units ; break}
bind .f.b <Control-4> {%W xview scroll -10 units ; break}
bind .f.b <Control-5> {%W xview scroll  10 units ; break}

update idletasks


#.f.b configure -state normal
.f.b configure -fg white -bg black
.f.b font family CourierNew size 20 weight normal

.f.t configure -state normal
.f.t insert end "[join $Lnom \n]"
.f.t configure -state disabled
.f.t tag configure toto -foreground white -background blue
.f.t tag configure titi -foreground green -background magenta
.f.t tag add toto 1.2 1.5 3.3 3.4 9.0 9.5 11.0 11.6
.f.t tag add titi 12.0 12.6




