package require Tk

set LignesCoul "I white magenta
L white magenta
M white magenta
V white magenta
R white blue
K white blue
F white red
Y white red
W white red
D white forestgreen
E white forestgreen
Q white green
P white black
G black orange
H black cyan
N black cyan
S white darkviolet
T white darkviolet
A white darkviolet
C white darkviolet
. black darkslategrey"

proc JunkData {nseq len} {
    global dta
    
    set Lc [list A C D E F G H I K L M N P Q R S T V W Y . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .]
    set nv [llength $Lc]
    for {set i 0} {$i < $nseq} {incr i} {
        set l [list]
        for {set j 0} {$j < $len} {incr j} {
            set c [lindex $Lc [expr {int(rand()*$nv)}]]
	    lappend l $c $c
        }
        lappend dta $l
    }

    return $dta
}

font create MyFont -family Courier -size 10
set Ch [lindex [font metrics MyFont] 5]
set Cw [font measure MyFont "Z"]

grid [canvas .t] [scrollbar .sy -orient vertical -command yset] -sticky ewns
grid [scrollbar .sx -orient horizontal -command xset] -sticky ewns
grid [entry .x -textvariable x]
grid [entry .y -textvariable y]
grid [button .a -text Adjust -command adjust]

grid rowconfigure . 0 -weight 1
grid columnconfigure . 0 -weight 1

set wx 150
set wy 30

set dta {}
set nx 10000
set ny 500
set dta [JunkData $ny $nx]

set CanW [expr {$wx*$Cw}]
set CanH [expr {$wy*$Ch}]
.t configure -width $CanW -height $CanH

foreach l [split $LignesCoul \n] {
    lassign [split $l " "] t f b
    set fill(Bg,$t) $b
    set fill(Fg,$t) $f 
}

proc xset {cmd n {unit ""}} {
    global x nx wx
    switch -exact -- $cmd {
        scroll {
            switch -exact -- $unit {
                units {
                    incr x $n
                }
                pages {
                    incr x [expr {$n*$wx}]
                }
            }
        }
        moveto {
            set x [expr {int($n*$nx)}]
        }
    }
    if {$x < 0} {
        set x 0
    }
    if {$x+$wx > $nx} {
        set x [expr {$nx-$wx}]
    }
    adjust
}

proc yset {cmd n {unit ""}} {
    global y ny wy
    switch -exact -- $cmd {
        scroll {
            switch -exact -- $unit {
                units {
                    incr y $n
                }
                pages {
                    incr y [expr {$n*$wy}]
                }
            }
        }
        moveto {
            set y [expr {int($n*$ny)}]
        }
    }
    if {$y < 0} {
        set y 0
    }
    if {$y+$wy > $ny} {
        set y [expr {$ny-$wy}]
    }
    adjust
}


proc adjust {} {
    global x y dta nx ny wx wy fill id Cw Ch
    
    set s [clock clicks -milli]
    #.t delete b
    set by $Ch
    set idx  0
    for {set i $y} {$i < $y+$wy} {incr i} {
        set l [lindex $dta $i]
        set l [lrange $l [expr {$x*2}] [expr {($x+$wx)*2-1}]]
        set bx $Cw
        foreach {b t} $l {
	    .t itemconfigure $id($idx,r) \
		    -fill $fill(Bg,$b) \
		    -outline $fill(Bg,$b)
	    .t itemconfigure $id($idx,t) \
		    -text $b \
		    -fill $fill(Fg,$b)
            #incr bx 12
	    incr idx
        }
        incr by $Ch
    }
    .sx set [expr {double($x)/$nx}] [expr {double($x+$wx-1)/$nx}]
    .sy set [expr {double($y)/$ny}] [expr {double($y+$wy-1)/$ny}]
    set e [clock clicks -milli]
    puts "Ticks [expr {$e - $s}]"
}

proc make {} {
    global x y dta nx ny wx wy fill id Cw Ch

    set s [clock clicks -milli]
    .t delete b
    set by $Ch
    set idx 0
    for {set i $y} {$i < $y+$wy} {incr i} {
        set l [lindex $dta $i]
        set l [lrange $l [expr {$x*2}] [expr {($x+$wx)*2-1}]]
        set bx $Cw
        foreach {b t} $l {
            set id($idx,r) [.t create rectangle \
		    $bx $by [expr {$bx+$Cw}] [expr {$by+$Ch}] \
		    -outline $fill(Bg,$t) \
		    -fill $fill(Bg,$t)]
            set id($idx,t) [.t create text $bx $by \
		    -font MyFont \
		    -anchor nw \
		    -text $b \
		    -fill $fill(Fg,$t)]
            incr bx $Cw
	    incr idx
        }
        incr by $Ch
    }
    .sx set [expr {double($x)/$nx}] [expr {double($x+$wx-1)/$nx}]
    .sy set [expr {double($y)/$ny}] [expr {double($y+$wy-1)/$ny}]
    set e [clock clicks -milli]
    puts "Ticks make [expr {$e - $s}]"
}

set x 0
set y 0

make

