#!/home/moumou/tcl8.6b1/lubin/bin/wish8.6
 ##!/usr/local/bin/wish


if {$tcl_platform(platform) == "windows"} {
	console show
}

set auto_path [linsert $auto_path 0 .]

set LignesCoul "I white magenta
L white magenta
M white magenta
V white magenta
R white blue
K white blue
F white red
Y white red
W white red
D white forestgreen
E white forestgreen
Q black green
P white black
G black orange
H black cyan
N black cyan
S white darkviolet
T white darkviolet
A white darkviolet
C white darkviolet
. black darkslategrey
0 black white
1 black white
2 black white
3 black white
4 black white
5 black white
6 black white
7 black white
8 black white
9 black white"

package require biotext

proc LesLignesDuFichier {file} {
    set f [open $file r]
    set Ll [split [read -nonewline $f] \n]
    close $f

    return $Ll
}

proc LitLeTFA {file aNom aSeq} {
    upvar $aNom Nom
    upvar $aSeq Seq
    global Long Haut

    set Lignes [LesLignesDuFichier $file]
    lappend Lignes ">"
    set n 0
    set laseq ""
    foreach l $Lignes {
	set l [string trim $l]
	if {$l eq ""} {continue}
	if {[string index $l 0] eq ">"} {
	    if {$laseq ne ""} {
		regsub -all " "  $laseq ""  laseq
		regsub -all {\-} $laseq "." laseq
		regsub -all {\n} $laseq ""  laseq
		lappend Nom $lenom
		set Seq($lenom) $laseq
		set laseq ""
		incr n
	    }

	    set l [string trim [string range $l 1 end]]
	    set ib [string first " " $l]
	    if {$ib == -1} {
		set ib end
	    } else {
		incr ib -1
	    }
	    set lenom [file rootname [string range $l 0 $ib]]
	} else {
	    append laseq $l
	}
    }
    set Haut $n
    set Long [string length [set Seq([lindex $Nom 0])]]
    
    return $n
}

# tfa file
proc TfaData {{f ""}} {
    global dta

    LitLeTFA $f Nom Seq
    set dta [list]
    foreach n $Nom {
	lappend dta [set Seq($n)]
    }

    return $dta
}


proc JunkData {nseq len} {
    global dta
    
    set Lc [list A C D E F G H I K L M N P Q R S T V W Y . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .]
    set nv [llength $Lc]
    
    # ligne de chiffres
    set l ""
    set i 0
    for {set j 0} {$j < ($len+4)} {incr j} {
	if {$i != 0 && ! ($i % 10)} {set i 0}
	append l $i
	incr i
    }
    lappend dta $l

    # fausses sequences
    for {set i 0} {$i < $nseq} {incr i} {
	# set l ""
        set l [format "%03d" $i]
        for {set j 0} {$j < $len} {incr j} {
            set c [lindex $Lc [expr {int(rand()*$nv)}]]
	    append l $c
        }
	append l "P"
        lappend dta $l
    }

    return $dta
}

proc InsereCols {n} {    
    $::top.b insert cols 1 $n

    return
}

proc RemoveCols {n} {
    if {$n == "colgaps"} {
	$::top.b delete colsgaps
    } else {
	$::top.b delete cols $n
    }

    return
}

proc Sauve {} {
    set toto [$::top.b output [list 0 1 2 3 123]]
    puts "[join $toto \n]"

    return
}

set top ".t[string range [clock clicks] 10 end]"
toplevel $top

biotext $top.b -xscrollcommand "$top.sx set" -yscrollcommand "$top.sy set" 
scrollbar $top.sx -orien horiz -command "$top.b xview "
scrollbar $top.sy -command "$top.b yview "
button $top.b1 -text "Ins COLS + 5" -command [list InsereCol 5] -bg green
button $top.b2 -text "Ins COLS - 5" -command [list InsereCol -5] -bg green
button $top.b3 -text "rem.col.gaps" -command [list RemoveCols colgaps] -bg green
button $top.b4 -text "Group" -command [list $top.b group 1 [list 3 4 5 6 7 8]] -bg green
button $top.b5 -text " Cut " -command [list $top.b cut [list 3 5 2 6 1]] -bg green
button $top.b6 -text " Paste " -command [list $top.b paste 0] -bg green
button $top.b7 -text " Sauve " -bg green -command [list Sauve]
button $top.b8 -text " Fonte " -bg cyan -command [list $top.b font smaller]

grid $top.b  -row 0 -column 0 -columnspan 4 -sticky news -padx 10 -pady 10
grid $top.sy -row 0 -column 4 -sticky news
grid $top.sx -row 1 -column 0 -columnspan 4 -sticky ew
grid $top.b1 -row 2 -column 0 
grid $top.b2 -row 2 -column 1
grid $top.b3 -row 2 -column 2
grid $top.b4 -row 2 -column 3
grid $top.b5 -row 3 -column 0
grid $top.b6 -row 3 -column 1
grid $top.b7 -row 3 -column 2
grid $top.b8 -row 3 -column 3

grid columnconfig $top 0 -weight 1
grid rowconfig    $top 0 -weight 1

#############
$top.b configure -background darkslategrey -foreground black -width 40 -height 20

set Lmap [list]
foreach l [split $LignesCoul \n] {
    lassign [split $l] n f b
    lappend Lmap [list $n $f $b]
}
$top.b mapping $Lmap

if {[llength $argv] == 1} {
    puts "gen data [time {set Ls [TfaData [lindex $argv 0]]}]"
} else {
    puts "gen data [time {set Ls [JunkData 300 5000]}]"
}
puts "ins seqs [time {$top.b sequences $Ls}]"
$top.b map on
#$top.b font family courier size 14 weight bold
$top.b configure -state normal

puts "100, 100 [$top.b index @100,100]"
puts "index [$top.b cursor]"






