'\"
'\" Generated from file 'ooutil\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2011-2015 Andreas Kupries, BSD licensed
'\"
.TH "oo::util" n 1\&.2\&.2 tcllib "Utility commands for TclOO"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
oo::util \- Utility commands for TclOO
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTclOO \fR
.sp
package require \fBoo::util  ?1\&.2\&.2?\fR
.sp
\fBmymethod\fR \fImethod\fR ?\fIarg\fR\&.\&.\&.?
.sp
\fBclassmethod\fR \fIname\fR \fIarguments\fR \fIbody\fR
.sp
\fBclassvariable\fR ?\fIarg\fR\&.\&.\&.?
.sp
\fBlink\fR \fImethod\fR\&.\&.\&.
.sp
\fBlink\fR {\fIalias\fR \fImethod\fR}\&.\&.\&.
.sp
\fBooutil::singleton\fR ?\fIarg\fR\&.\&.\&.?
.sp
.BE
.SH DESCRIPTION
.PP
This package provides a convenience command for the easy specification
of instance methods as callback commands, like timers, file events, Tk
bindings, etc\&.
.SH COMMANDS
.TP
\fBmymethod\fR \fImethod\fR ?\fIarg\fR\&.\&.\&.?
This command is available within instance methods\&. It takes a method
name and, possibly, arguments for the method and returns a command
prefix which, when executed, will invoke the named method of the
object we are in, with the provided arguments, and any others supplied
at the time of actual invokation\&.
.sp
Note: The command is equivalent to and named after the command
provided by the OO package \fBsnit\fR for the same purpose\&.
.TP
\fBclassmethod\fR \fIname\fR \fIarguments\fR \fIbody\fR
This command is available within class definitions\&. It takes a method
name and, possibly, arguments for the method and creates a method on the
class, available to a user of the class and of derived classes\&.
.sp
Note: The command is equivalent to the command \fBtypemethod\fR
provided by the OO package \fBsnit\fR for the same purpose\&.
.sp
Example
.CS


oo::class create ActiveRecord {
    classmethod find args { puts "[self] called with arguments: $args" }
}
oo::class create Table {
    superclass ActiveRecord
}
puts [Table find foo bar]
# ======
# which will write
# ======
# ::Table called with arguments: foo bar

.CE
.TP
\fBclassvariable\fR ?\fIarg\fR\&.\&.\&.?
This command is available within instance methods\&. It takes a series
of variable names and makes them available in the method's scope\&. The
originating scope for the variables is the class (instance) the object
instance belongs to\&. In other words, the referenced variables are shared
between all instances of their class\&.
.sp
Note: The command is roughly equivalent to the command
\fBtypevariable\fR provided by the OO package \fBsnit\fR for the
same purpose\&. The difference is that it cannot be used in the class
definition itself\&.
.sp
Example:
.CS


% oo::class create Foo {
    method bar {z} {
        classvariable x y
        return [incr x $z],[incr y]
    }
}
::Foo
% Foo create a
::a
% Foo create b
::b
% a bar 2
2,1
% a bar 3
5,2
% b bar 7
12,3
% b bar -1
11,4
% a bar 0
11,5

.CE
.TP
\fBlink\fR \fImethod\fR\&.\&.\&.
.TP
\fBlink\fR {\fIalias\fR \fImethod\fR}\&.\&.\&.
This command is available within instance methods\&. It takes a list of
method names and/or pairs of alias- and method-name and makes the
named methods available to all instance methods without requiring the
\fBmy\fR command\&.
.sp
The alias name under which the method becomes available defaults
to the method name, except where explicitly specified through an
alias/method pair\&.
.sp
Examples:
.CS


    link foo
    # The method foo is now directly accessible as foo instead of my foo\&.

    link {bar foo}
    # The method foo is now directly accessible as bar\&.

    link a b c
    # The methods a, b, and c all become directly acessible under their
    # own names\&.

.CE
.IP
The main use of this command is expected to be in instance constructors,
for convenience, or to set up some methods for use in a mini DSL\&.
.TP
\fBooutil::singleton\fR ?\fIarg\fR\&.\&.\&.?
This command is a meta-class, i\&.e\&. a variant of the builtin
\fBoo::class\fR which ensures that it creates only a single
instance of the classes defined with it\&.
.sp
Syntax and results are like for \fBoo::class\fR\&.
.sp
Example:
.CS


% oo::class create example {
   self mixin singleton
   method foo {} {self}
}
::example
% [example new] foo
::oo::Obj22
% [example new] foo
::oo::Obj22

.CE
.PP
.SH AUTHORS
Donal Fellows, Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIoo::util\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH "SEE ALSO"
snit(n)
.SH KEYWORDS
TclOO, callback, class methods, class variables, command prefix, currying, method reference, my method, singleton
.SH CATEGORY
Utility
.SH COPYRIGHT
.nf
Copyright (c) 2011-2015 Andreas Kupries, BSD licensed

.fi