#!/usr/bin/tclsh





puts "\n\n\n"
puts "    ORDALIE Installation :"
puts "\n\n"

# choice of installaion folder
puts "Choose installation folder :"
puts "----------------------------"
puts "- (U) By default, ORDALIE is installed in /usr/local/. Be sure you have privileges to install into this directory."
puts "- (H) You can also install ORDALIE in your HOME directory."
puts "Alternatively, you can defined an alternative directory."
set ok 0
while {! $ok} {
    puts -nonewline "\n(U/H/O) : "
    flush stdout
    set rep [gets stdin]
    after 100
    switch $rep {
	"U" {
	    set instDir "/usr/local/"
	    set ok 1
	}
	"H" {
	    if {! [info exists env(HOME)]} {
		puts "Error ! The HOME environment variable does not exists !\nChoose 'O' and type the absolute path to your home directory"
	    } else {
		set instDir $env(HOME)
		set ok 1
	    }
	}
	"O" {
	    set ok2 0
	    while {! $ok2} {
		puts -nonewline "\nDirectory : "
		flush stdout
		set dir [gets stdin]
		after 100
		
		if {! [file exists $dir]} {
		    puts "Error ! Directory $dir does not exists !"
		} else {
		    set ok2 1
		    set ok 1
		    set instDir $dir
		}
	    }
	}
    }
}

set OrdalieDir [file join $instDir ordalie]
puts "Copying files ..."
puts ""

file mkdir $OrdalieDir
file rename -force lib [file join $OrdalieDir lib]
file rename -force doc [file join $OrdalieDir doc]
file rename -force etc [file join $OrdalieDir etc]
file rename license.txt [file join $OrdalieDir license.txt]
file rename ordalie [file join $OrdalieDir ordalie]

if {! [file exists [file join $instDir bin]]} {
    puts "$instDir/bin does not exists !\nShould I create it ?"
    set ok 0
    while {! $ok} {
	puts -nonewline "(y/n) : "
	flush stdout
	set rep [gets stdin]
	switch [string tolower $rep] {
	    "y" -
	    "Yes" {
		set ok 1
	    }
	    "n" -
	    "no" {
		set ok 0
	    }
	}
    }
    
    if {$ok} {
	file mkdir [file join $instDir bin]
    }
}
if {[catch {file link -symbolic [file join $instDir bin ordalie] [file join $OrdalieDir ordalie]}]} {
    puts "Error !\nUnable to create a link to the executable!"
}

puts "\n\n"
puts "ORDALIE is installed and ready to run "
puts ""

exit

