#!/usr/local/bin/wish

#package require biotext
#source /home/moumou/ordali/src/ordali_sequence.tcl

#oload Windows/biotext0.1.dll
#load biotext01.dll
#load libbiotext0.1.so
load libbiotext0.1.dylib
#package require biotext
puts "livrary  loaded"

package require platform
if {[string range [platform::generic] 0 4] eq "win32"} {
    set OrdaliDir [file join o:/ ordali]
    set GscopeDir [file join m:/ ripp gscope]
} elseif {[string range [platform::generic] 0 4] eq "macos"} {
    set OrdaliDir /Users/Luc/moumou/ordali/
    set GscopeDir /Users/Luc/moumou/ordali/src
} else {
    set OrdaliDir $env(ORDALIDIR)
    set GscopeDir /home/ripp/gscope
}
puts "ordalidir : $OrdaliDir"
source [file join $OrdaliDir src ordali_source.tcl]
source [file join $GscopeDir gscope_outils.tcl]
puts "sources done"

set tfa ">seq-1
GACDEF...GHIKLM.NPQRS.TVWY
>seq-2
GACDEF...GHIKLM.NPQRS.TVWY
>seq-3
GACDEF...GHIKLM.NPQRS.TVWY
>seq-4
GACDEF...GHIKLM.NPQRS.TVWY
>seq-5
GACDEF...GHIKLM.NPQRS.TVWY
>seq-6
GACDEF...GHIKLM.NPQRS.TVWY
>seq-7
GACDEF...GHIKLM.NPQRS.TVWY
>seq-8
GACDEF...GHIKLM.NPQRS.TVWY
>seq-9
GACDEF...GHIKLM.NPQRS.TVWY
>seq-10
GACDEF...GHIKLM.NPQRS.TVWY
>seq-11
GACDEF...GHIKLM.NPQRS.TVWY
>seq-12
GACDEF...GHIKLM.NPQRS.TVWY"

### DATA ###############
# Create mapping
set Lignes "I white magenta
J white magenta
L white magenta
M white magenta
V white magenta
R white blue
K white blue
F white red
Y white red
W white red
D white forestgreen
B white forestgreen
E white forestgreen
Z black green
Q black green
P white black
G black orange
H black cyan
N black cyan
S white darkviolet
T white darkviolet
A white darkviolet
U white darkviolet
C white darkviolet
X black dimgrey
. black dimgrey
0 black white
1 black white
2 black white
3 black white
4 black white
5 black white
6 black white
7 black white
8 black white
9 black white
Space white white"

set Lmap [list]
foreach l [split $Lignes \n] {
    lassign [split [string trim $l] " "] n f b
    if {$n eq "Space"} {set n " "}
    lappend Lmap [list $n $f $b]
}

proc CoupleY {args} {
    .f.b yview {*}$args
    .f.t yview {*}$args

    return
}

proc RandSeq {{nlines 50} {len 1000}} {
    set Lseq [list]
    set Lnom [list]
    set a ".A.CDEFGH.I.KLMN.PQRST.VW.Y.A.CDEFGH.I.KLMN.PQRST.VW.Y."
    set la [string length $a]
    # create first sequence
    set s ""
    for {set j 0} {$j < $len} {incr j} {
	if {! ($j%1000)} {
	    puts "  $j done ..."
	}
	set x [expr {int($la*rand())}]
	append s [string index $a $x]
    }
    lappend Lseq $s
    lappend Lnom "Seq-0"
    for {set i 1} {$i < $nlines} {incr i} {
	set ix [expr {int($len*rand())}]
	set n "[string range $s $ix end][string range $s 0 $ix-1]"
	lappend Lseq $n
	lappend Lnom "Seq-$i"
    }
    
    return [list $Lseq $Lnom]
}

##########################
font create Luc -family Courier -size 10

grid columnconfig . 0 -weight 1
grid rowconfig    . 0 -weight 1

frame .f -background black
grid .f -row 0 -column 0 -sticky news

text .f.t \
    -width 10 \
    -height 10 \
    -font Luc \
    -wrap none \
    -yscrollcommand ".f.sv set"
biotext .f.b \
    -bd 0 \
    -yscrollcommand ".f.sv set" \
    -xscrollcommand ".f.sh set" \
    -width 20 \
    -height 10 \
    -class Biotext
.f.b font family Courier size 10 weight normal
scrollbar .f.sh \
    -bg blue \
    -orient horiz \
    -command ".f.b xview "
scrollbar .f.sv \
    -bg blue \
    -command "CoupleY "

grid .f.t  -row 0 -column 0 -sticky ns
grid .f.b  -row 0 -column 1 -sticky news
grid .f.sv -row 0 -column 2 -sticky ns
grid .f.sh -row 1 -column 1 -sticky ew
grid columnconfig .f 1 -weight 1
grid rowconfig    .f 0 -weight 1

lassign [RandSeq] Lseq Lnom
if {0 && [llength $argv]} {
    set tfa $argv
    LitLeTFA $tfa Lnom Tseq
    set Lseq [list]
    foreach n $Lnom {lappend Lseq $Tseq($n)}
}

.f.b sequences $Lseq
.f.b mapping $Lmap
.f.b map on
.f.b configure -state normal

.f.t configure -state normal
.f.t insert end "[join $Lnom \n]"
.f.t configure -state disabled

proc BindSpace {w} {
    set idx [$w cursor]
    lassign [split $idx .] y x
    $w chars "." $idx 1
}

#bind .f.b <Control-Key-c> {%W delete colsgaps}
#bind .f.b <Key-space> {BindSpace %W}


