#include "tkBiotext.h"
#include <tkFont.h>
#include <tkWinInt.h>

/* Taken from tk8.6.0b1/win/tkWinFont.c */
/*
 * The following structure represents a font family. It is assumed that all
 * screen fonts constructed from the same "font family" share certain
 * properties; all screen fonts with the same "font family" point to a shared
 * instance of this structure. The most important shared property is the
 * character existence metrics, used to determine if a screen font can display
 * a given Unicode character.
 *
 * Under Windows, a "font family" is uniquely identified by its face name.
 */

#define FONTMAP_SHIFT	    10

#define FONTMAP_PAGES	    	(1 << (sizeof(Tcl_UniChar)*8 - FONTMAP_SHIFT))
#define FONTMAP_BITSPERPAGE	(1 << FONTMAP_SHIFT)

typedef struct FontFamily {
    struct FontFamily *nextPtr;	/* Next in list of all known font families. */
    int refCount;		/* How many SubFonts are referring to this
				 * FontFamily. When the refCount drops to
				 * zero, this FontFamily may be freed. */
    /*
     * Key.
     */

    Tk_Uid faceName;		/* Face name key for this FontFamily. */

    /*
     * Derived properties.
     */

    Tcl_Encoding encoding;	/* Encoding for this font family. */
    int isSymbolFont;		/* Non-zero if this is a symbol font. */
    int isWideFont;		/* 1 if this is a double-byte font, 0
				 * otherwise. */
    BOOL (WINAPI *textOutProc)(HDC hdc, int x, int y, TCHAR *str, int len);
				/* The procedure to use to draw text after it
				 * has been converted from UTF-8 to the
				 * encoding of this font. */
    BOOL (WINAPI *getTextExtentPoint32Proc)(HDC, TCHAR *, int, LPSIZE);
				/* The procedure to use to measure text after
				 * it has been converted from UTF-8 to the
				 * encoding of this font. */

    char *fontMap[FONTMAP_PAGES];
				/* Two-level sparse table used to determine
				 * quickly if the specified character exists.
				 * As characters are encountered, more pages
				 * in this table are dynamically added. The
				 * contents of each page is a bitmask
				 * consisting of FONTMAP_BITSPERPAGE bits,
				 * representing whether this font can be used
				 * to display the given character at the
				 * corresponding bit position. The high bits
				 * of the character are used to pick which
				 * page of the table is used. */

    /*
     * Cached Truetype font info.
     */

    int segCount;		/* The length of the following arrays. */
    USHORT *startCount;		/* Truetype information about the font, */
    USHORT *endCount;		/* indicating which characters this font can
				 * display (malloced). The format of this
				 * information is (relatively) compact, but
				 * would take longer to search than indexing
				 * into the fontMap[][] table. */
} FontFamily;

/*
 * The following structure encapsulates an individual screen font. A font
 * object is made up of however many SubFonts are necessary to display a
 * stream of multilingual characters.
 */

typedef struct SubFont {
    char **fontMap;		/* Pointer to font map from the FontFamily,
				 * cached here to save a dereference. */
    HFONT hFont0;		/* The specific screen font that will be used
				 * when displaying/measuring chars belonging
				 * to the FontFamily. */
    FontFamily *familyPtr;	/* The FontFamily for this SubFont. */
    HFONT hFontAngled;
    double angle;
} SubFont;

/*
 * The following structure represents Windows' implementation of a font
 * object.
 */

#define SUBFONT_SPACE		3
#define BASE_CHARS		128

typedef struct WinFont {
    TkFont font;		/* Stuff used by generic font package. Must be
				 * first in structure. */
    SubFont staticSubFonts[SUBFONT_SPACE];
				/* Builtin space for a limited number of
				 * SubFonts. */
    int numSubFonts;		/* Length of following array. */
    SubFont *subFontArray;	/* Array of SubFonts that have been loaded in
				 * order to draw/measure all the characters
				 * encountered by this font so far. All fonts
				 * start off with one SubFont initialized by
				 * AllocFont() from the original set of font
				 * attributes. Usually points to
				 * staticSubFonts, but may point to malloced
				 * space if there are lots of SubFonts. */
    HWND hwnd;			/* Toplevel window of application that owns
				 * this font, used for getting HDC for
				 * offscreen measurements. */
    int pixelSize;		/* Original pixel size used when font was
				 * constructed. */
    int widths[BASE_CHARS];	/* Widths of first 128 chars in the base font,
				 * for handling common case. The base font is
				 * always used to draw characters between
				 * 0x0000 and 0x007f. */
} WinFont;

/*
 *--------------------------------------------------------------
 *
 * Tk_DrawImageString --
 *	Draw a character with a given color, and
 *      draws the underlying background of the bbox 
 *      containing those characters with a given 
 *      color.
 *
 * Results:
 *      None. 
 *
 * Side effects:
 *      None.      
 *
 *--------------------------------------------------------------
 */
void
Tk_DrawImageString(Display *display,
		   Drawable d,
		   Tk_Font tkfont,
		   GC gc,
		   int x, int y, 
		   char *string,
		   int length) 
{    
  if (d == None) {
    return;
  }
    
  HDC hdc;
  HFONT oldFont;
  LPTSTR lpchText;
  WinFont *fontPtr;
  SubFont *lastSubFontPtr;
  TkWinDCState state;

  lpchText = string;

  fontPtr = (WinFont *) tkfont;
  lastSubFontPtr = &(fontPtr->subFontArray[0]);
  hdc = TkWinGetDrawableDC(display, d, &state);
  SetROP2(hdc, SRCCOPY);

  SetBkMode(hdc, OPAQUE);
  SetBkColor(hdc, gc->background);
  SetTextColor(hdc, gc->foreground);

  oldFont = SelectObject(hdc, lastSubFontPtr->hFont0);
  
  TextOut(hdc, x, y, lpchText, 1);

  SelectObject(hdc, oldFont);
  TkWinReleaseDrawableDC(d, hdc, &state);

  return;
}

/*
 *--------------------------------------------------------------
 *
 * MyFontInfo --
 *      Gives font information. Only use non-Xft fonts
 *
 * Results:
 *      None. 
 *
 * Side effects:
 *     .      
 *
 *--------------------------------------------------------------
 */
void
MyFontInfo(Biotext *BiotextPtr) 
{
  Tk_FontMetrics fm;
  Tk_Font tkfont = BiotextPtr->tkfont;

  Tk_GetFontMetrics(tkfont, &fm);
  BiotextPtr->charWidth = Tk_TextWidth(tkfont,"0", 1);
  BiotextPtr->charHeight  = fm.ascent+fm.descent;
  BiotextPtr->ascent = fm.ascent;
  BiotextPtr->descent = fm.descent;

  return;
}


void BiotextDrawAlignment(register Biotext *BiotextPtr,
			  Drawable d) 
{
  int hc, wc, LinesPerPage, ResPerPage, startXC;
  int startYC, yP, xP, i, j, k, finYC, finXC,tagPrev, tagCurr;
  Display *display = BiotextPtr->display;

  HDC hdc;
  HFONT oldFont;
  WinFont *fontPtr;
  SubFont *lastSubFontPtr;
  TkWinDCState state;

  fontPtr = (WinFont *) BiotextPtr->tkfont;
  lastSubFontPtr = &(fontPtr->subFontArray[0]);
  hdc = TkWinGetDrawableDC(display, d, &state);
  SetROP2(hdc, SRCCOPY);

  SetBkMode(hdc, OPAQUE);
  oldFont = SelectObject(hdc, lastSubFontPtr->hFont0);

  LinesPerPage = MIN(BiotextPtr->nbSeqs,BiotextPtr->heightChar);
  ResPerPage   = MIN(BiotextPtr->lgSeqs,BiotextPtr->widthChar);

  Tag *TM = BiotextPtr->Mapping;
  Tag *TG = BiotextPtr->Tags;
  char **SM = BiotextPtr->SeqMat;
  int k0, lg, xP0, **ST = BiotextPtr->MapSeq;
  int **TS = BiotextPtr->TagSeq;
  char *Str = NULL;
  Str = (char *)ckalloc(ResPerPage+1);
  unsigned long fg, bg;

  startXC = BiotextPtr->leftIndex;
  finXC   = MIN(startXC+ResPerPage,BiotextPtr->lgSeqs);
  startYC = BiotextPtr->topIndex;
  finYC   = MIN(startYC+LinesPerPage,BiotextPtr->nbSeqs);

  wc = BiotextPtr->charWidth;
  hc = BiotextPtr->charHeight;
  yP = BiotextPtr->borderWidth + BiotextPtr->inset + BiotextPtr->ascent;

  /* do we use mapping or not */
  if (! (BiotextPtr->flags & MAP_RESIDUES)) {
    SetBkColor(hdc,Tk_3DBorderColor(BiotextPtr->bgBorder)->pixel);
    SetTextColor(hdc,Tk_3DBorderColor(BiotextPtr->fgBorder)->pixel);
    for (i=startYC;i<finYC;i++) {
      xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      for (j=startXC;j<finXC;j++) {
	TextOut(hdc, xP, yP, (LPTSTR) SM[i]+j, 1);
	xP += wc;
      }
      yP += hc;
    }
  } else {
    /* mapping residues */
    for (i=startYC;i<finYC;i++) {
      xP0 = xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      lg  = 0;
      Str[0]='\0';
      k0  = ST[i][startXC];
      fg  = TM[k0].fg;
      bg  = TM[k0].bg;
      for (j=startXC;j<finXC;j++) {
	k = ST[i][j];
	if (TM[k].fg != fg || TM[k].bg != bg) {
	  SetBkColor(hdc,bg);
	  SetTextColor(hdc,fg);
	  TextOut(hdc, xP0, yP, (LPTSTR) Str, lg);
	  lg=0;
	  xP0 = xP;
	}
	Str[lg] = SM[i][j];
	bg = TM[k].bg;
	fg = TM[k].fg;
	lg++;
	
	xP += wc;
      }
      SetBkColor(hdc,bg);
      SetTextColor(hdc,fg);
      TextOut(hdc, xP0, yP, (LPTSTR) Str, lg);
      yP += hc;
    } 
  }

  /* treat tagging */
  if (BiotextPtr->flags & TAG_ALIGNMENT) {
    /* check if there are tags */
    if (BiotextPtr->nbTags > 0) {
      yP = BiotextPtr->borderWidth + BiotextPtr->inset + BiotextPtr->ascent;
      for (i=startYC;i<finYC;i++) {
	tagPrev = -1;
	xP0 = xP = BiotextPtr->borderWidth+BiotextPtr->inset;
	lg = 0;
	Str[0]='\0';
	for (j=startXC;j<finXC;j++) {
	  tagCurr = TS[i][j];
	  if (tagCurr != -1) {
	    if (tagCurr == tagPrev) {
	      Str[lg]=SM[i][j];
	      lg++;
	    } else {
	      if (strlen(Str) > 0) {
		SetBkColor(hdc,bg);
		SetTextColor(hdc,fg);
		TextOut(hdc, xP0, yP-BiotextPtr->ascent, (LPTSTR) Str, lg);
	      }
	      fg = TG[tagCurr].fg;
	      bg = TG[tagCurr].bg;
	      Str[0]=SM[i][j];
	      lg=1;
	      xP0=xP;
	    }
	  } else {
	    /* is there a running tag ? */
	    if (strlen(Str) > 0) {
	      SetBkColor(hdc,bg);
	      SetTextColor(hdc,fg);
	      TextOut(hdc, xP0, yP-BiotextPtr->ascent, (LPTSTR) Str, lg);
	      Str[0]='\0';
	      lg=0;
	    }
	  }
	  tagPrev = tagCurr;
	  xP += wc;
	}
	/* is there a running tag here ? */
	if (strlen(Str) > 0) {
	  SetBkColor(hdc,bg);
	  SetTextColor(hdc,fg);
	  TextOut(hdc, xP0, yP-BiotextPtr->ascent, (LPTSTR) Str, lg);
	}
	yP += hc;
      }
    }
  }

  SelectObject(hdc, oldFont);
  TkWinReleaseDrawableDC(d, hdc, &state);

  return;
}





