#!/usr/local/bin/wish

#
# Example of the biotext widget
#

proc BindSpace {w} {
    set idx [$w cursor]
    lassign [split $idx .] y x
    $w chars "." $idx 1
}
puts [file normalize [pwd]]
set auto_path [file normalize [pwd]]
package require biotext
source ordalie.tcl

### DATA ###############
# amino acid mapping
set Lignes "I white magenta
J white magenta
L white magenta
M white magenta
V white magenta
R white blue
K white blue
F white red
Y white red
W white red
D white forestgreen
B white forestgreen
E white forestgreen
Z black green
Q black green
P white black
G black orange
H black cyan
N black cyan
S white darkviolet
T white darkviolet
A white darkviolet
U white darkviolet
C white darkviolet
X black dimgrey
. black dimgrey
0 black white
1 black white
2 black white
3 black white
4 black white
5 black white
6 black white
7 black white
8 black white
9 black white
Space white white"

set Lmap [list]
foreach l [split $Lignes \n] {
    lassign [split [string trim $l] " "] n f b
    if {$n eq "Space"} {set n " "}
    lappend Lmap [list $n $f $b]
}


proc CoupleY {args} {
    .f.b yview {*}$args
    .f.t yview {*}$args

    return
}
DecortiqueUnTFA alignment.tfa Lnom Tseq
set Lseq [lmap n $Lnom {set Tseq($n)}]

puts "\nAlignment file loaded.\n[llength $Lnom] sequences of [string length [lindex $Lseq 2]] aminoacids\n"
font create SeqFont -family Courier -size 32

frame .f
grid .f -row 0 -column 0 -sticky news
grid columnconfig . 0 -weight 1
grid rowconfig    . 0 -weight 1

text .f.t \
    -bd 0 -relief flat \
    -width 10 \
    -height 10 \
    -font SeqFont \
    -wrap none
biotext .f.b \
    -bd 0 -relief flat \
    -yscrollcommand ".f.sv set" \
    -xscrollcommand ".f.sh set" \
    -width 20 \
    -height 10 \
    -class Biotext
scrollbar .f.sh \
    -bg blue \
    -orient horiz \
    -command ".f.b xview "
scrollbar .f.sv \
    -bg blue \
    -command "CoupleY "
grid .f.t  -row 0 -column 0 -sticky ns
grid .f.b  -row 0 -column 1 -sticky news
grid .f.sv -row 0 -column 2 -sticky ns
grid .f.sh -row 1 -column 1 -sticky ew
grid columnconfig .f 1 -weight 1
grid rowconfig    .f 0 -weight 1


# fill biotext widget
.f.b configure -state normal
.f.b sequences $Lseq
.f.b mapping $Lmap
.f.b map on
.f.b font family Courier size 32 weight normal

.f.t configure -state normal
.f.t insert end "[join $Lnom \n]"
.f.t configure -state disabled

#bind .f.b <Control-Key-c> {%W delete colsgaps}
#bind .f.b <Key-space> {BindSpace %W}


