proc 2GO {args} {


    #Load
    #LesTypesDeRequetes
    #LesRequetes
    #LesGO
    #$Requete WhatIsIt
    #$Requete LesLiens -> LesGO
    #$GO      LesLiens -> LesRequetes

    global TableauInterrogation2GO

    if {[string equal -nocase $args "Load"] && ![info exists TableauInterrogation2GO(EstCharge)]} {
	if {[info exists TableauInterrogation2GO]} {unset TableauInterrogation2GO}
	set TableauInterrogation2GO(EstCharge) 1
	Load2GO TableauInterrogation2GO
	return
    }

    if {[string equal -nocase $args "unset"]} {
	if {[info exists TableauInterrogation2GO]} {unset TableauInterrogation2GO}
	return
    }
    set Quoi [join $args ","]
    if {[info exists TableauInterrogation2GO($Quoi)]} {
	return [lsort -unique [set TableauInterrogation2GO($Quoi)]] 
    }
    ###################CHARGE Fichier2GO###################
    if {![info exists TableauInterrogation2GO(EstCharge)]} {
	set TableauInterrogation2GO(EstCharge) 1
	Load2GO TableauInterrogation2GO
    }
    if {![info exists TableauInterrogation2GO($Quoi)]} {return}
    return [lsort -unique [set TableauInterrogation2GO($Quoi)]] 


}

proc 2Pi {} {

    return [expr {2.*acos(-1.)}]

}

proc 54yg {} {

    set Lf [lrange [glob *.fasta.out] 0 4]
    set o [open 5yg.tfa w]
    foreach f $Lf {
	set Ll [LesLignesDuFichier $f]
	puts $o [join $Ll \n]
    }
    close $o

    exit

}

proc AADansPil {file} {


    global Sequences
    global LNOrdali
    global ListeDesPiliersDuGroupe


    DecortiqueUnMSF
    CreeLesPiliers

    set Nt [llength $LNOrdali]
    foreach seuil {60 65 70 75 80 85 90 95 100} {
	set NIndi($seuil) 0
    }

    foreach p [set ListeDesPiliersDuGroupe(GroupeToutLeMonde)] {
	foreach seuil {60 65 70 75 80 85 90 95 100} {
	    set Nb [regsub -all {\.} $p "" tmp]
	    if {[expr ($Nt.-$Nb.)/$Nt*100] > $seuil} {incr NIndi($seuil)}
	}
    }



    return

}

proc AADuNomDuFichier {NomDuFichier {AvecAlias AvecAlias}} {


    global AAAlias

    if { ! [info exists AAAlias] } {
	set AAAlias(ly1) lys
	set AAAlias(ly2) lys
	set AAAlias(pha) phe
	set AAAlias(phb) phe
	set AAAlias(gla) gly
	set AAAlias(glb) gly
    }
    set AA3 [string range $NomDuFichier 0 2]
    if { $AvecAlias != "AvecAlias" && [info exists AAAlias($AA3)]} {
	return [set AAAlias($AA3)]
    } else {
	return $AA3
    }


}

proc AAFrequents2 {FichierCod} {


    if {![file exist $FichierCod]} {return}
    set Nom [file tail $FichierCod]
    append First "$Nom\t"
    set LesFreq [CreeListeCodonFrequency $FichierCod]
    set LesFreqTrie [lsort -index 2 -decreasing $LesFreq]
    set LesFirst [lrange $LesFreqTrie 0 2]
    foreach AA $LesFirst {
	set aa [lindex $AA 0]
	set Codon [lindex $AA 1]
	append First "$aa\($Codon\)\t"
    }
    return $First


}

proc AAFrequents2PourTous {} {


    foreach Nom [ListeDesPABs] {
	set FichierCod "[RepertoireDuGenome]/codonfrequency/tables_codonfrequency/$Nom.cod"
	set AA [AAFrequents2 $FichierCod]
	append Tous "$AA\n"
    }
    return $Tous


}

proc AALePlusDifferent {FichierCodMusRef FichierCodSeq} {


    set LesDifferences [CompareDeuxTablesCodonFrequency $FichierCodMusRef $FichierCodSeq]
    set LePlus [lrange $LesDifferences 0 0]
    return $LePlus


}

proc AALePlusFrequent {FichierCod} {


    set LesFreq [CreeListeCodonFrequency $FichierCod]
    set LesFreqTrie [lsort -index 2 -decreasing $LesFreq]
    set LesFirst [lrange $LesFreqTrie 0 0]
    foreach AA $LesFirst {
	set f [lindex $AA 2]
	set fa [format "%.2f" $f]
	set AA [lreplace $AA 2 2 $fa]
	lappend LesFirstArr $AA
    }
    return $LesFirstArr


}

proc AALesPlusDifferents2 {FichierCodMusRef FichierCodSeq} {


    set Nom [file tail $FichierCodSeq]
    set LesDifferences [CompareDeuxTablesCodonFrequency $FichierCodMusRef $FichierCodSeq]
    set LesPlus [lrange $LesDifferences 0 2]
    append Plus "$Nom\t"
    foreach PlusDifferent $LesPlus {
	set aa [lindex $PlusDifferent 1]
	set codon [lindex $PlusDifferent 2]
	append Plus "$aa\($codon\)\t"
    }
    return $Plus


}

proc AALesPlusDifferents2PourTous {} {


    set FichierCodMusRef "[RepertoireDuGenome]/codonfrequency/mus.cod"
    foreach Nom [ListeDesPABs] {
	set FichierCodSeq "[RepertoireDuGenome]/codonfrequency/tables_codonfrequency/$Nom.cod"
	set Plus [AALesPlusDifferents2 $FichierCodMusRef $FichierCodSeq]
	append Tous "$Plus\n"
    }
    return $Tous


}

proc AALesPlusDifferentsPourTous {} {


    set FichierCodMusRef "[RepertoireDuGenome]/codonfrequency/mus.cod"
    foreach Nom [ListeDesPABs] {
	set FichierCodSeq "[RepertoireDuGenome]/codonfrequency/tables_codonfrequency/$Nom.cod"
	set LePlus [AALePlusDifferent $FichierCodMusRef $FichierCodSeq]
	append Tous "$LePlus\n"
    }
    return $Tous


}

proc AARares {FichierCod} {


    if {![file exist $FichierCod]} {return}
    set Nom [file tail $FichierCod]
    append First "$Nom\t"
    set LesFreq [CreeListeCodonFrequency $FichierCod]
    set LesFreqTrie [lsort -index 2 -increasing $LesFreq]
    set LesFreqTrieSansEnd {}
    foreach Ligne $LesFreqTrie {
	set Type [lindex $Ligne 0]
	if {$Type=="End"} {
	    continue
	} else {
	    lappend LesFreqTrieSansEnd $Ligne
	}
    }
    set LesFirst [lrange $LesFreqTrieSansEnd 0 2]
    foreach AA $LesFirst {
	set aa [lindex $AA 0]
	set Codon [lindex $AA 1]
	append First "$aa\($Codon\)\t"
    }
    return $First


}

proc AARaresPourTous {} {


    foreach Nom [ListeDesPABs] {
	set FichierCod "[RepertoireDuGenome]/codonfrequency/tables_codonfrequency/$Nom.cod"
	set AA [AARares $FichierCod]
	append Tous "$AA\n"
    }
    return $Tous


}

proc AAStart {Nom} {


    global LesAAsStart
    if {[info exists LesAAsStart($Nom)]} { return LesAAsStart($Nom) }
    if {[info exists LesAAsStart("EstCharge")]} { return "" }
    set LesAAsStart("EstCharge") 1
    ChargeLesCodonsStart
    return [AAsStart $Nom]


}

proc AAType {{Qui ""}} {


    global AAType

    if {[info exists AAType($Qui)]} { return $AAType($Qui) }
    if {[info exists AAType("EstCharge")]} { return "" }

    set AAType(aliphatic)  [list I L M V]
    set AAType(aromatic)   [list F Y W]
    set AAType(acidic)     [list D E Q N]
    set AAType(basic)      [list H K R]
    set AAType(scmall)     [list P A G S T]
    set AAType(cystein)    [list C]
    foreach K [lsort [array names AAType]] {
	set V $AAType($K)
	lappend AAType(Types) $K
	foreach A $V {
	    lappend AAType(ListOfA) $A
	    set AAType($A) $K
	}
    }
    set Ordonnes {}
    set AAType(AlphabeticListOfAA) [lsort $AAType(ListOfA)]
    set AAType("EstCharge") 1
    return [AAType $Qui]


}

proc AAduCodon {Codon {AA ""}} {


    global CodonToAminoAcid
    global FichierTranslate

    if {$Codon=="Reset" && [info exists CodonToAminoAcid]} {unset CodonToAminoAcid ; return ""}

    if {[string length $Codon] != 3 } { return "-" }

    if {[regexp -nocase {[^ATGC]} $Codon]} { return "X" }

    if { ! [info exists CodonToAminoAcid("EstCharge")]} {
	set CodonToAminoAcid("EstCharge") 1
	set ListeDesLignes [split [ContenuDuFichier $FichierTranslate] "\n"]
	set IndexPointPoint [lsearch -regexp $ListeDesLignes {\.\.}]
	if { $IndexPointPoint == -1 } { Warne "$FichierTranslate merde."; exit}
	set PartieCodage [lrange $ListeDesLignes [incr IndexPointPoint 2] end]
	foreach Ligne $PartieCodage {
	    set fin [expr [string first "\!" $Ligne]-1]
	    set Interet [string range $Ligne 0 $fin]
	    if {[info exists a]} { unset a }
	    if {[info exists b]} { unset b }
	    if {[info exists c]} { unset c }
	    if {[info exists d]} { unset d }
	    if {[info exists e]} { unset e }
	    if {[info exists f]} { unset f }
	    if {[info exists g]} { unset g }
	    if {[info exists h]} { unset h }
	    scan $Interet "%s %s %s %s %s %s %s %s %s %s" A AAA a b c d e f g h
	    if {[info exists a]} { set CodonToAminoAcid([string toupper $a]) $A}
	    if {[info exists b]} { set CodonToAminoAcid([string toupper $b]) $A}
	    if {[info exists c]} { set CodonToAminoAcid([string toupper $c]) $A}
	    if {[info exists d]} { set CodonToAminoAcid([string toupper $d]) $A}
	    if {[info exists e]} { set CodonToAminoAcid([string toupper $e]) $A}
	    if {[info exists f]} { set CodonToAminoAcid([string toupper $f]) $A}
	    if {[info exists g]} { set CodonToAminoAcid([string toupper $g]) $A}
	    if {[info exists h]} { set CodonToAminoAcid([string toupper $h]) $A}
	}
	
	if { ![CodonStopPossible "TGA"] } { set CodonToAminoAcid(TGA) "W" }
    }
    set CODON [string toupper $Codon]
    if {$AA!=""} { set CodonToAminoAcid($CODON) $AA }
    if { ! [info exists CodonToAminoAcid($CODON)]} { return "X" }
    return [set CodonToAminoAcid($CODON)]


}

proc ACTAYRfinder {} {



# Recherche un motif en générant un mismatch (adapté récepteurs nucléaires)

set FichierEntree [open "/genomics/link/STAF/fiches/Bidir/SequencesTotales.bidir" "r"] 
set FichierSortie [open "/genomics/link/STAF/fiches/Bidir/ACTAYRdansLesPromoteurs.bidir" "w"] 
Espionne "ACTAYR : Start"	
	set J 0
	set I 0
	while { [gets $FichierEntree Ligne]  >=0 } {
	incr J
	set Entete $Ligne
	gets $FichierEntree Ligne
	set Acc [lindex $SeqTFA(index) 0]
	set RegExp {ACTA[CT][AG]|[AG][GA]TAGT}
	set ListeDesPositions [regexp -indices -all -inline "$RegExp" $Ligne]
	
	foreach PaireDeBornes $ListeDesPositions {
		set NewStart [expr [lindex $PaireDeBornes 0] + 1]
		set NewEnd [expr [lindex $PaireDeBornes 1] + 1]
		puts $FichierSortie "$Entete $NewStart $NewEnd"
		incr I
	}
}
	Espionne "ACTAYR : End ($I ACTAYR trouves dans $J promoteurs)"
	close $FichierEntree
	close $FichierSortie


}

proc ACetDRdansTREMBL {} {


    global RepertoireDuGenome

    foreach Ligne [LesLignesDuFichier "$RepertoireDuGenome/fiches/narcisse"] {
	scan $Ligne "%s %s %s" Nom BanqueId Access
	set Narcisse([string toupper $Access]) $Nom
	set Narcisse($Nom) $Access
    }

    set F [open "/prot/trembl/sp_tr_nrdb/trembl.dat" "r"]

    while {[gets $F Ligne]>=0} {
	if {[regexp "^AC" $Ligne]} { set AC $Ligne }
	if {[regexp "^OS" $Ligne]} { set OS $Ligne }
	if {[regexp "^DR   EMBL" $Ligne]} {
	    set DR $Ligne
	    if { ! [regexp "Pyrococcus abyssi" $OS]} { continue }
	    scan $DR "%s %s %s %s" a b c Access
	    if { ! [regexp -nocase {Cab[0-9][0-9][0-9][0-9][0-9]} $Ligne Access]} { continue }
	    scan $AC "%s %s" Bidon AC
	    regsub {;} $AC "" AC
	    set Nom "???????????????"
	    set ACCESS [string toupper $Access]
	    if {[info exists Narcisse($ACCESS)]} { set Nom [set Narcisse($ACCESS)] }
	    lappend Sortie "$Nom $Access $AC"
	    Espionne "$Nom $Access $AC"
	}
    }
    SauveLesLignes $Sortie dans "$RepertoireDuGenome/fiches/narcisse-a-trois"



}

proc ALaMain {Quoi} {


    global ALaMain

    if {[info exists ALaMain($Quoi)]} { return $ALaMain($Quoi) }
    if {[info exists ALaMain("EstCharge")]} { return "" }
    set ALaMain("EstCharge") 1

    set ALaMain(gi_bsdc1_sp_q9nw68.1_) "Unknown unknown SP:q9nw68"
    set ALaMain(gi_26332042_dbj_bac29751.1_) "Unknown unknown dbj:bac29751"
    set ALaMain(gi_160703882_gb_eat79375.2_) "Unknown unknown gb:eat79375"
    set ALaMain(gi_157336387_emb_cao71072.1_) "Unknown unknown emb:cao71072"
    set ALaMain(gi_predict_edq55772.1_) "Unknown unknown edq55772"
    set ALaMain(gi_125525362_gb_eay73476.1_) "Unknown unknown gb_eay73476"
    set ALaMain(gi_116000504_emb_cal50184.1_) "Unknown unknown emb_cal50184"
    set ALaMain(gi_sap_dm_emb_caa56416.1_b) "Unknown unknown emb_caa56416"
    set ALaMain(gi_74191837_dbj_bae32869.1_) "Unknown unknown dbj_bae32869"
    set ALaMain(gi_30580527_sp_q9d5v6.1_syap1_) "Unknown unknown sp_q9d5v6.1_syap1"
    set ALaMain(gi_149035828_gb_edl90495.1_) "Unknown unknown gb_edl90495"
    set ALaMain(gi_14042052_dbj_bab55087.1_) "Unknown unknown dbj_bab55087"
    set ALaMain(gi_15779193_gb_aah14657.1_) "Unknown unknown gb_aah14657"
    set ALaMain(gi_62897271_dbj_bad96576.1_) "Unknown unknown dbj_bad96576"
    set ALaMain(gi_14189980_gb_aak55531.1_af30) "Unknown unknown gb_aak55531"
    set ALaMain(gi_47215840_emb_cag00695.1_) "Unknown unknown emb_cag00695"
    set ALaMain(gi_sap_danio_p_957236.1_) "Brachidanio rerio  p_957236"
    set ALaMain(gi_edp29796.1_bsd-bruggia) "Brugia  malayi edp29796"
    set ALaMain(gi_schistosoma_gb_aaw25233.1_) "schistosoma_ gb:aaw25233"
    set ALaMain(gi_bsd_oris_aba94285.2_) "oris_ aba94285"
    set ALaMain(gi_147818233_emb_can73547.1_) "Unknown unknown emb_can73547"
    set ALaMain(gi_162674980_gb_edq61481.1_) "Unknown unknown gb_edq61481"
    set ALaMain(gi_162683699_gb_edq70107.1_) "Unknown unknown gb_edq70107"
    set ALaMain(gi_29841361_gb_aap06393.1_) "Unknown unknown gb_aap06393"
    set ALaMain(gi_56753973_gb_aaw25179.1_) "Unknown unknown gb_aaw25179"
    set ALaMain(gi_114636465_ref_xp_001173050.) "Unknown unknown YYY:xp_001173050"
    set ALaMain(gi_predictprot_macala_xp_001085333.) "Unknown unknown YYY:xp_001085333"
    set ALaMain(gi_114052006_ref_np_001039615.) "Unknown unknown YYY:np_001039615"
    set ALaMain(gi_114636455_ref_xp_001173101.) "Unknown unknown YYY:xp_001173101"
    set ALaMain(gi_149719503_ref_xp_001505012.) "Unknown unknown YYY:xp_001505012"
    set ALaMain(gi_p62_hom_s_ref_np_005307.1) "Unknown unknown YYY:np_005307"
    set ALaMain(gi_126332087_ref_xp_001366557.) "Unknown unknown YYY:xp_001366557"
    set ALaMain(gi_57102734_ref_xp_534083.1) "Unknown unknown YYY:xp_534083"
    set ALaMain(gi_p62_mousemgb_aah52837.1) "Unknown unknown GB:aah52837"
    set ALaMain(gi_157816977_ref_np_001101955.) "Unknown unknown YYY:np_001101955"
    set ALaMain(gi_31982313_ref_np_032212.2) "Unknown unknown YYY:np_032212"
    set ALaMain(gi_p62_xenopustrop_np_001006921.1) "Unknown unknown YYY:np_001006921"
    set ALaMain(gi_118091234_ref_xp_421013.2) "Unknown unknown YYY:xp_421013"
    set ALaMain(gi_52219046_ref_np_001004596.1) "Unknown unknown YYY:np_001004596"
    set ALaMain(gi_125880724_ref_xp_001342123.) "Unknown unknown YYY:xp_001342123"
    set ALaMain(gi_p62putative_ref_xp_798784.1) "Unknown unknown YYY:xp_798784"
    set ALaMain(gi_p62_sc__010597.1) "Saccharomyces cerevisiae YYY:010597"
    set ALaMain(gi_45184782_ref_np_982500.1) "Unknown unknown YYY:np_982500"
    set ALaMain(gi_156837512_ref_xp_001642780.) "Unknown unknown YYY:xp_001642780"
    set ALaMain(gi_bsd_gallusgallusp_001012860) "Gallus gallus YYY:NP_001012860"
    set ALaMain(gi_pdb_syap1_humana_structure) "Unknown unknown PDB:1X3A_a"
    set ALaMain(gi_pdb_syap1_humanb_structure) "Unknown unknown PDB:1X3A_b"
    set ALaMain(gi_cryptosporidium_ref_xp_6660) "Unknown unknown YYY:xp_6660"
    set ALaMain(gi_cryptosporidium_xp_625548.1) "Unknown unknown YYY:xp_625548"
    set ALaMain(gi_58261118_ref_xp_567969.1) "Unknown unknown YYY:xp_567969"
    set ALaMain(gi_115692152_ref_xp_780429.2) "Unknown unknown YYY:xp_780429"
    set ALaMain(gi_158287538_ref_xp_309535.4) "Unknown unknown YYY:xp_309535"
    set ALaMain(gi_15233107_ref_np_191701.1) "Unknown unknown YYY:np_191701"
    set ALaMain(gi_149237456_ref_xp_001524605.) "Unknown unknown YYY:xp_001524605"
    set ALaMain(gi_159474828_ref_xp_001695527.) "Unknown unknown YYY:xp_001695527"

    set ALaMain(gi_predict_EDQ55772.1) "Unknown unknown YYY:EDQ55772"
    set ALaMain(gi_BSD_gallusgallusP_001012860.1) "Gallus gallus YYY:NP_001012860"
    set ALaMain(gi_PDB_syap1_HUMANa_structure_1X3A_A_1) "Homo sapiens PDB:1X3A"
    set ALaMain(gi_PDB_syap1_HUMANb_structure_1X3A_A_2) "Homo sapiens PDB:1X3A"
    set ALaMain(gi_SAP_danio_P_957236.1) "Brachydanio rerio YYY:NP_957236"
    set ALaMain(gi_EDP29796.1_bsd-bruggia) "Brugia malayi YYY:EDP29796"
    set ALaMain(gi_BSD_ORIS_ABA94285.2) "Oryza sativa SPT:ABA94285"
    set ALaMain(gi_bsdputat_Orizaesativ_BAD53348.1) "Oryza sativa SPT:BAD53348"
    return [ALaMain $Quoi]


}

proc ANGLES {aB aANGLE aU} {


    upvar $aB B
    upvar $aANGLE ANGLE
    upvar $aU U

    # A partir de la matrice de rotation, calcule les angles d'Euler,
    # l'angle de rotation et coord. spheriques de l'axe, et les cos.
    # directeurs de l'axe
    #
    set PI [Pi]
    #    set PI 3.1415926
    set PIS2 [expr {0.5 * $PI}]
    set DEGRAD [expr {$PI/180.}]
    set DETERM 0.

    set DETERM [S_deterM [M_T B]]

    if {$DETERM <= 0.99 || $DETERM > 1.01} {
	puts " =======> Determinant = $DETERM "
	return -1
    }

    # Angles d'Euler
    set TH2 [ARCTG [expr {sqrt(pow($B(1,3),2)+pow($B(2,3),2))}] $B(3,3)]
    set ZETA [expr {1.-cos($TH2)}]

    if {$ZETA > 0.001 && $ZETA < 1.9999} {
	set TH1 [ARCTG $B(3,1) [expr {-$B(3,2)}]]
	set TH3 [ARCTG $B(1,3) $B(2,3)]
    } else {
	# Valeur arbitraire de TH3
	set TH3 0.
	if {$ZETA <= 0.001} {
	    set TH1 [ARCTG [expr {$B(1,2)-$B(2,1)}] [expr {$B(1,1)+$B(2,2)}]]
	} else {
	    set TH1 [ARCTG [expr {$B(1,2)+$B(2,1)}] [expr {$B(1,1)-$B(2,2)}]]
	}
    }

    set ALPHA    [expr {fmod(($TH1-$PIS2)/$DEGRAD+360.,360.)}]
    set BETA     [expr {$TH2/$DEGRAD}]
    set GAMMA    [expr {fmod(($TH3+$PIS2)/$DEGRAD,360.)}]
    set ANGLE(1) $ALPHA
    set ANGLE(2) $BETA
    set ANGLE(3) $GAMMA

    # ANGLE DE ROTATION ET COS. DIRECTEURS DE L'AXE
    set CKAPPA [expr {0.5*($B(1,1)+$B(2,2)+$B(3,3)-1.)}]
    set AKAPPA [ARCOS $CKAPPA]

    if {$CKAPPA > 0.9999} {
	# ROTATION NULLE. DIRECTION ARBITRAIRE
	set U(1) 0.
	set U(2) 0.
	set U(3) 1.
    } elseif {$CKAPPA < -0.999} {
	# ROTATION PROCHE DE 180
	foreach I {1 2 3} {
	    set ARG [expr {[set B($I,$I)]-$CKAPPA}]
	    if {$ARG < 0.} {
		if {$ARG < -0.01} {
		    puts "sqrt of zero "
		    return -1
		    #		    exit
		}
		set ARG 0.
	    }
	    set U($I) [expr {sqrt($ARG/(1.-$CKAPPA))}]
	}
	# DETERMINER LE SIGNE DU PLUS GRAND COS.DIR.

	set I 1
	foreach K {2 3} {
	    if {[set U($K)] > [set U($I)]} {set I $K}
	}
	set K [expr {($I%3)+1}]
	set L [expr {($K%3)+1}]

	set U($I) [SIGN [set U($I)] [expr {([set B($K,$L)]-[set B($L,$K)])}]]
	set U($K) [SIGN [set U($K)] [expr {[set U($I)]*([set B($K,$I)]+[set B($I,$K)])}]]
	set U($L) [SIGN [set U($L)] [expr {[set U($I)]*([set B($L,$I)]+[set B($I,$L)])}]]
    } else {
	# ROTATION GENERALE

	set DSK [expr {2.*sin($AKAPPA)}]
	foreach I {1 2 3} {
	    set K [expr {($I%3)+1}]
	    set L [expr {($K%3)+1}]
	    set U($I) [expr {([set B($K,$L)]-[set B($L,$K)])/$DSK}]
	}
    }

    set PSIZ [ARCOS $U(3)]
    set PHIZ [ARCTG $U(2) $U(1)]

    set ANGLE(4) [expr {$AKAPPA/$DEGRAD}]
    set ANGLE(5) [expr {$PSIZ/$DEGRAD}]
    set ANGLE(6) [expr {$PHIZ/$DEGRAD}]

    # Ramener a l'hemisphere nord
    if {$ANGLE(5) > 90.} {
	foreach i {1 2 3} {
	    set U($i) [expr {-[set U($i)]}]
	}
	set ANGLE(4) [expr {-$ANGLE(4)}]
	set ANGLE(5) [expr {180.-$ANGLE(5)}]
	set ANGLE(6) [expr {$ANGLE(6)+180.}]
    }

    set ANGLE(6) [expr {fmod(($ANGLE(6)+360.),360.)}]

    return

}

proc ARCOS {A} {


    set absa [expr {abs($A)}]
    if {$absa > 1.} {
	if {$absa > 1.00001} {
	    # pourrait mettre un puts pour dire ....
	}
	if {$absa > 1.01} {
	    puts " =====> ARCOS"
	    return
	    #	    exit
	}
	set A [SIGN 1. $A]
    }

    set LARCOS [expr {acos($A)}]

    return $LARCOS

}

proc ARCTG {B A} {


    set ARCTG 0.

    if {abs($A) >= 0.00001 || abs($B) >= 0.00001} {
	set ARCTG [expr {atan2($B,$A)}]
    }

    return $ARCTG

}

proc ARPAnno {{LesFichiersTFA ""} {LesFamilles ""} {Verbose 0}} {



    Wup "Programme de d annotation des sous Familles D ARPs"
    Wup "ARPAnno: ARP Annotation Server"
    Wup "v 1.0"
    Wup "      Based on BLAST,"
    Wup "      clustalw,"
    Wup "      aln_pos aln_res aln_insert,"
    Wup "      Domaines.txt Residus.txt"
    Wup "Jean Muller IGBMC/LBMAGM"

    #Repertoire contenant les banques Blast, Macs et Domaines et Residus de reference
    set RepARP          "[RepARPAnno]"
    set RepTFA          "$RepARP/ARP_TFA"
    set RepBanque       "$RepARP/ARP_BLAST"
    set RepMACS         "$RepARP/ARP_MACS"
    set RepSignature    "$RepARP/ARP_Signature"

    #Repertoire contenant les resultats
    set RepARP_Results  "[RepARPAnnoWeb]"
    set RepTFAResults   "$RepARP_Results"
    set RepBlastResults "$RepARP_Results"
    set RepMACSResults  "$RepARP_Results"
 
    #Passage au mode Verbose
    if {   $Verbose != "0"} {
	set Verbose 1
    }
    Verbose_Mode $Verbose
    
    if {$LesFichiersTFA==""} {
	set LesFichiersTFA [glob -nocomplain -directory "${RepTFA}_lesarps"    "*.tfa"]
	set LesFichiersTFA [glob -nocomplain -directory "${RepTFA}_validation" "*.tfa"]
    }
    set LesFichiersASupprimer ""
    set LesFichiersBLASTs     ""
    set NewMACS               ""

    #Les Familles de proteines (Actin Orphan ARP1-11)
    #################################################
    set LesVraisFamilles ""
    set LesVraisFamilles [LesFamillesDARPs]
    LesResultatsARPAnalyses "LesFamilles" $LesVraisFamilles "Positionne"

    foreach TFA $LesFichiersTFA {
	set AccessQuery "query_protein"
	set AccessDeRef "P02568"
	
	#1 Traitement du fichier d entree au format TFA
	###############################################
	#On recupere l access (premier mot apres le chevron ">")
	#On ajoute query_protein a la place qui sera utilise par clustalw
	#On reecrit le fichier TFA dans RepTFAResults
	set FileName   [file tail $TFA]
	set FichierTFA "$RepTFAResults/${FileName}"

	if {[regexp -nocase {^ARPAnno_[0-9]{4}_[0-9]{2}[0-9]{2}_} $FileName]} {
	    #On vient du web on garde pour VraiAccess le nom du fichier (utilise apres pour nom.msf)
	    set  VraiAccess [string tolower [FormateLeFichierTFA $TFA $FichierTFA 1]]
	    set  VraiAccess $FileName
	} else {
	    #set  VraiAccess [string tolower [FormateLeFichierTFA $TFA $FichierTFA 0]]
	    set  VraiAccess [string tolower [FormateLeFichierTFA $TFA $FichierTFA 1]]
	    if {$VraiAccess=="-1"} {Espionne "Pb FormateLeFichierTFA: $FichierTFA does not exists or is empty";return ""}
	    set  VraiAccess $FileName
	}
	set FichierLog "${FichierTFA}.log"
	AjouteAuARPLog "" $FichierLog
	LesResultatsARPAnalyses "VraiAccess" $VraiAccess "Positionne"

	set     Categorie [InterrogeLesInfosDesARPs [string toupper $VraiAccess] Categorie]
	if {   $Categorie == ""} {
	    set Categorie "Unknown"
	} else {
	    regsub -all {\-\-\-\-} $Categorie "" Categorie
	    regsub           "Les" $Categorie "" Categorie
	}
	if {[Verbose_Mode]} {
	    set    TextLog "><ARPAnno request><"
	    AjouteAuARPLog "$TextLog"
	    set    TextLog ">Access $VraiAccess -- $Categorie"
	    AjouteAuARPLog "$TextLog"
	}

	#2 Identificaction des meilleures familles d ARPs pour la query
	###############################################################
	if {$LesFamilles != ""} {
	    set MaxIDCutOffBlast "0.1"
	} else {		
	    set MaxIDCutOffBlast "0.25"
	}
	#2 On fait les Blasts contre toutes les banques blast des ARPs
	set LesFichiersBLASTs   [BlastQueryVsARPs $FichierTFA $LesFamilles]
	#2 1er Filtrage des sorties BLAST dont ne retient que les meilleurs P Identity
	set LesFamillesIdentity [IdentifieLeMeilleurBLAST $LesFichiersBLASTs $VraiAccess $FichierLog]
	#2 2eme Filtrage pour se separer des identite limites
	set LesFamillesRetenues ""
	set FPIdC               ""
	foreach FPIdC $LesFamillesIdentity {
	    set Famille ""
	    set PId     ""
	    set Cover   ""
	    foreach {Famille PId Cover} $FPIdC {
		if {$PId >= $MaxIDCutOffBlast} { 
		    LesResultatsARPAnalyses "$Famille,PId,$VraiAccess"   $PId   "Positionne"
		    LesResultatsARPAnalyses "$Famille,Cover,$VraiAccess" $Cover "Positionne"
		    lappend LesFamillesRetenues $Famille
		    if {$PId>="0.8" && $Cover>="0.8"} {
			if {[regexp -nocase "actin" $Famille]} {
			    set Texte "Your query protein is a conventional actin with [expr {$PId*100.0}]% identity shared among [expr ${Cover}*100.0]% of the sequence."
			    LesResultatsARPAnalyses "Result" $Texte "Positionne"
			    LesResultatsARPAnalyses "BestFamily" $Famille "Positionne"
			} elseif {[regexp -nocase "orphan" $Famille]} {
			    set Texte "Your query protein is a orphan with [expr {$PId*100.0}]% identity shared among [expr ${Cover}*100.0]% of the sequence."
			    LesResultatsARPAnalyses "Result" $Texte "Positionne"
			    LesResultatsARPAnalyses "BestFamily" $Famille "Positionne"
			}
		    }
		}
	    }     
	}
	if {[Verbose_Mode]} {
	    set    TextLog ">>>For $VraiAccess ($Categorie) selected family:$LesFamillesRetenues"
	    AjouteAuARPLog "$TextLog"
	}
	#On supprime les fichiers BLASTs de toutes les familles non retenues
	foreach FBlast $LesFichiersBLASTs {
	    #Q78DQ1.tfa_ARP6.blastp"
	    set Famille     ""
	    set Famille_tmp ""
	    set tmp         ""

	    set Famille     [file tail $FBlast]
	    regsub -nocase  {.blastp$} $Famille "" Famille
	    regexp -nocase  {_([a-z]{2,4}[0-9]{1,2}|actin|orphans)$} $Famille tmp Famille_tmp
	    if {$Famille_tmp != ""} {set Famille $Famille_tmp}
	    if {$Famille     != "" && [regexp -nocase $Famille $LesFamillesRetenues]} {continue}
	    lappend LesFichiersASupprimer $FBlast
	}
	
	if {$LesFamillesRetenues == ""} {
	    #Aucune famille n a ete retenue pour chercher si elle fait partie des ARPs
	    set Texte "No family could be selected. Your query may not be part of Actin superfamily."
	    LesResultatsARPAnalyses "Result" $Texte "Positionne"
	    continue
	} else {
	    #On a des resultats et on check si on a deja une famille (actin ou orphan)
	    if {[LesResultatsARPAnalyses "Result" "LaValeurMerci"] != ""} {
		continue
	    }
	}
	
	#3 Test de la sequence contre les alignements de references
	###########################################################
	set AccessDeRef_OLD ""
	foreach Famille $LesFamillesRetenues {
	    if {$AccessDeRef_OLD != "" && $AccessDeRef_OLD != $AccessDeRef } {
		set AccessDeRef $AccessDeRef_OLD
		set AccessDeRef_OLD ""
	    }
	    #On ne teste pas la famille des Actin
	    if {[regexp -nocase "actin" $Famille]} {continue}
	    
	    set MACSDeRef   "$RepMACS/${Famille}.rsf"
	    set NewMACS     "$RepMACSResults/${VraiAccess}_${Famille}.msf"
	    set Res         ""
	    set Dom         ""
	    set AligneOuPas "-1"
	    
	    if {[Verbose_Mode]} {
		set    TextLog ">< 2- Check $Famille family in progress (multiple alignment)><"
		AjouteAuARPLog "$TextLog"
	    }

	    #3-1 Alignement de la sequence contre les alignements de references
	    ###################################################################
	    set  AligneOuPas [AlignQueryVsMACS $FichierTFA $MACSDeRef $NewMACS]
	    if {$AligneOuPas=="-1"} {
		Espionne "Pb AlignQueryVsMACS"
		continue
	    } 
	    if {    [file exists $NewMACS]} {
		if {[file size   $NewMACS]=="0"} {
		    #Le fichier MACS est vide
		    Espionne "Pb AlignQueryVsMACS $NewMACS, empty file."
		    continue
		}
	    } else {
		#Le fichier MACS n existe pas
		Espionne "Pb AlignQueryVsMACS $NewMACS, no file exists."
		Espionne "$FichierTFA $MACSDeRef $NewMACS"
		continue
	    }
	    #lappend LesFichiersASupprimer $NewMACS

	    #3-2 Verification des Residus
	    #############################
	    #Choix des access de ref de familles differentes
	    if {$Famille == "ARP2"} {
		#PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
		#ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
		set AccessDeRef_OLD $AccessDeRef
		set AccessDeRef     "ARP05"
	    }
	    if {[Verbose_Mode]} {
		set    TextLog ">< 2-1 Specific Residues Filter ><"
		AjouteAuARPLog "$TextLog"
	    }
	    set Res [CheckARPSpecificResiduesForQuery query_protein $VraiAccess $AccessDeRef $NewMACS $Famille]
	    switch -exact -- $Res {
		"-2" {
		    #No residues yet determined
		    if {[Verbose_Mode]} {
			set    TextLog "No residues yet determined for $Famille"
			AjouteAuARPLog "$TextLog"
		    }
		}
		"-1" {
		    #Probleme d alignement
		    Espionne "Pb avec $NewMACS"
		}
		"1" {
		    #La sequence possede tous les groupes de residus de cette famille testee
		    #Espionne "$VraiAccess is an $Famille"
		}
		"2" {
		    #La sequence possede les groupes de residus de cette famille testee mais egalement des Gaps
		    #Espionne "$VraiAccess could have be an $Famille but there is too much GAP or missing sequences"
		}
		"0" {
		    #La sequence ne possede pas les groupes de residus de cette famille testee
		    #Espionne "$VraiAccess is not an $Famille"
		}
	    }

	    #3-3 Verification des Domaines
	    ##############################
	    if {$Famille == "ARP2"} {
		#ATTENTION ON REVIENT A LA NORMALE CAR C PAS BON POUR LES DOMAINES
		set AccessDeRef "$AccessDeRef_OLD"
	    }
	    if {[Verbose_Mode]} {
		set    TextLog ">< 2-1 Specific Insertions Filter ><"
		AjouteAuARPLog "$TextLog"
	    }
	    set Dom [CheckARPSpecificDomainsForQuery query_protein $VraiAccess $AccessDeRef $NewMACS $Famille]
	    switch -exact -- $Dom {
		"-2" {
		    #No insertions yet determined
		    if {[Verbose_Mode]} {
			set    TextLog "No specific insertions yet determined for $Famille"
			AjouteAuARPLog "$TextLog"
		    }
		}
		"-1" {
		    #Probleme d alignement
		    Espionne "Pb avec $NewMACS"
		}
		"1" {
		    #La sequence possede tous les groupes de domaines de cette famille testee
		    #Espionne "$VraiAccess is an $Famille"
		}
		"2" {
		    #La sequence possede les groupes de domaines de cette famille testee mais egalement des Gaps
		    #Espionne "$VraiAccess could have be an $Famille but there is too much GAP or missing sequences"
		}
		"0" {
		    #La sequence ne possede pas les groupes de domaines de cette famille testee
		    #Espionne "$VraiAccess is not an $Famille"
		}
	    }
	}

	#4 Choix de l ARP
	#################
	set Score_PId     ""
	set Score_Cover   ""
	set Score_Residue ""
	set Score_Domain  ""
	set NbGroupOk     ""
	set NbGroupTotal  ""
	set NbGroupGap    ""
	set NbDomainOk    ""
	set NbDomainTotal ""
	set NbDomainGap   ""

	if {[Verbose_Mode]} {
	    set    TextLog ">< 3- Final score calculation ><"
	    AjouteAuARPLog "$TextLog"
	}

	set Best_Score    "0.0"
	set Best_Family   ""
	foreach Famille $LesFamillesRetenues {
	    #On sort de toutes les familles il faut decider a quelle on appartient
	    #Score          est le score final d un parametre
	    #Impact_Score   est le poids d un parametre dans la decision finale
	    #Le score final est la somme des score individuels ponderes par leur impact score
	    #Si un score n est pas disponible sa part de score est redistribuee

	    set Score                "0.0"
	    set Score_PId            "" 
	    set Score_Cover          ""
	    set Score_Residue        ""
	    set Score_Domain         ""
	    set Impact_Score_PId     "0.2"
	    set Impact_Score_Cover   "0.1"
	    set Impact_Score_Residue "0.4"
	    set Impact_Score_Domain  "0.3"
	    set Impact_Score_Redis   "0.0"
	    set Nb_Redis             "0"
	    set ListeImpactScores    [list Impact_Score_PId Impact_Score_Cover Impact_Score_Residue Impact_Score_Domain]
	    set Nb_Score             [llength $ListeImpactScores]

	    set Score_PId     [LesResultatsARPAnalyses "$Famille,PId,$VraiAccess"   PId   "LaValeurMerci"]
	    set Score_Cover   [LesResultatsARPAnalyses "$Famille,Cover,$VraiAccess" Cover "LaValeurMerci"]
	    set NbGroupOk     [LesResultatsARPAnalyses "$Famille,NbGroupOk"               "LaValeurMerci"]
	    set NbGroupTotal  [LesResultatsARPAnalyses "$Famille,NbGroupTotal"            "LaValeurMerci"]
	    set NbGroupGap    [LesResultatsARPAnalyses "$Famille,NbGroupGap"              "LaValeurMerci"]
	    set NbDomainOk    [LesResultatsARPAnalyses "$Famille,NbDomainOk"              "LaValeurMerci"]
	    set NbDomainTotal [LesResultatsARPAnalyses "$Famille,NbDomainTotal"           "LaValeurMerci"]
	    set NbDomainGap   [LesResultatsARPAnalyses "$Famille,NbDomainGap"             "LaValeurMerci"]
	
	    #Dans le cas ou un des scores n est pas calcule.
	    #On ne retient pas son score et on redistribue son Impact_score
	    if {$NbGroupTotal  == "" || $NbGroupTotal  == "0"} {
		set Score_Residue        0
		set Impact_Score_Redis   [expr {$Impact_Score_Redis + 0.4}]
		set Impact_Score_Residue "0.0"
		incr Nb_Redis
	    } else {
		#Espionne "Res  $NbGroupOk -- $NbGroupTotal"
		#Espionne "[expr (($NbGroupOk*1.0) / $NbGroupTotal)]"
		set Score_Residue "[expr {($NbGroupOk*1.0)  / $NbGroupTotal}]"
	    }
	    if {$NbDomainTotal == "" || $NbDomainTotal == "0"} {
		set Score_Domain         0
		set Impact_Score_Redis   [expr {$Impact_Score_Redis + 0.3}] 
		set Impact_Score_Domain  "0.0"
		incr Nb_Redis
	    } else {
		#Espionne "Domain  $NbDomainOk -- $NbDomainTotal"
		#Espionne "[expr (($NbDomainOk*1.0) / $NbDomainTotal)]"
		#ATTENTION ON CONSIDERE QUE UNE SEULE SEQUENCE SUFFIE POUR DIRE SI UN GROUPE EST OK
		##if {$NbDomainOk != "0" && [expr $NbDomainOk + $NbDomainGap]>=[expr $NbDomainTotal]} {}
		if {[expr {$NbDomainOk + $NbDomainGap}]>=[expr $NbDomainTotal]} {
		    set NbDomainOk [expr {$NbDomainOk + $NbDomainGap}]
		}
		set Score_Domain  "[expr {($NbDomainOk*1.0) / $NbDomainTotal}]"
	    }
	    	    
	    #Si on doit redistribuer l impact score sur les autres
	    if {$Nb_Redis!="0"} {
		set Impact_Score_Redis [expr {($Impact_Score_Redis * 1.0) / ($Nb_Score - $Nb_Redis)}]
		foreach Score $ListeImpactScores {
		    if {[set $Score]=="0.0"} {
			continue
		    } else {
			set $Score [expr [set $Score] + $Impact_Score_Redis]
		    }
		}
	    }
	    #Espionne "[format "Impact Score: %5.1f %5.1f %5.1f %5.1f | %5.1f %2d" $Impact_Score_PId $Impact_Score_Cover $Impact_Score_Residue $Impact_Score_Domain $Impact_Score_Redis $Nb_Redis]"

	    #Calcul du score final
	    set Score_PId     [expr  {$Score_PId     * 100.0}]
	    set Score_Cover   [expr  {$Score_Cover   * 100.0}]
	    set Score_Residue [expr  {$Score_Residue * 100.0}]
	    set Score_Domain  [expr  {$Score_Domain  * 100.0}]

	    LesResultatsARPAnalyses "$Famille,Score_PId_ini"     $Score_PId     "Positionne"
	    LesResultatsARPAnalyses "$Famille,Score_Cover_ini"   $Score_Cover   "Positionne"
	    LesResultatsARPAnalyses "$Famille,Score_Residue_ini" $Score_Residue "Positionne"
	    LesResultatsARPAnalyses "$Famille,Score_Domain_ini"  $Score_Domain  "Positionne"
	    #LesResultatsARPAnalyses "$Famille,Score_ini"         $Score         "Positionne"

	    set Score_PId     [expr {$Score_PId     * $Impact_Score_PId}]
	    set Score_Cover   [expr {$Score_Cover   * $Impact_Score_Cover}]
	    set Score_Residue [expr {$Score_Residue * $Impact_Score_Residue}]
	    set Score_Domain  [expr {$Score_Domain  * $Impact_Score_Domain}]
	    set Score         [expr {($Score_PId + $Score_Cover + $Score_Residue + $Score_Domain) * 1.0}]
	    set Score         [format "%5.1f" $Score]

	    if {[Verbose_Mode]} {
		set    TextLog "[format "%7s score: %5.1f %1s | %5.1f %5.1f %5.1f %5.1f" $Famille $Score % $Score_PId $Score_Cover $Score_Residue $Score_Domain]"
		AjouteAuARPLog "$TextLog"
	    }

	    set TabResultat($Famille,Score_PId)     $Score_PId
	    set TabResultat($Famille,Score_Cover)   $Score_Cover
	    set TabResultat($Famille,Score_Residue) $Score_Residue
	    set TabResultat($Famille,Score_Domain)  $Score_Domain
	    set TabResultat($Famille,Score)         $Score
	    
	    LesResultatsARPAnalyses "$Famille,Score_PId"     $Score_PId     "Positionne"
	    LesResultatsARPAnalyses "$Famille,Score_Cover"   $Score_Cover   "Positionne"
	    LesResultatsARPAnalyses "$Famille,Score_Residue" $Score_Residue "Positionne"
	    LesResultatsARPAnalyses "$Famille,Score_Domain"  $Score_Domain  "Positionne"
	    LesResultatsARPAnalyses "$Famille,Score"         $Score         "Positionne"
	    
	    if {[expr $Best_Score < $Score]} {
		set Best_Score  $Score
		set Best_Family $Famille
	    } 
	}
	set Texte "The best family chosen for your query is $Best_Family with score = $Best_Score."
	LesResultatsARPAnalyses "Result"     $Texte       "Positionne"
	LesResultatsARPAnalyses "BestScore"  $Best_Score  "Positionne"
	LesResultatsARPAnalyses "BestFamily" $Best_Family "Positionne"

	foreach F $LesVraisFamilles {
	    if {! [info exists TabResultat($F,Score)]} {
		LesResultatsARPAnalyses "$F,Score_PId"     "No" "Positionne"
		LesResultatsARPAnalyses "$F,Score_Cover"   "No" "Positionne"
		LesResultatsARPAnalyses "$F,Score_Residue" "No" "Positionne"
		LesResultatsARPAnalyses "$F,Score_Domain"  "No" "Positionne"
		LesResultatsARPAnalyses "$F,Score"         "No" "Positionne"
	    }
	}
	if {[info exists TabResultat]} {array unset TabResultat "*"}
    }

    #5 Fin du programme on vide la memoire (fait dans ARPAnno.tcl) et on supprime les fichiers
    ##########################################################################################
    set        LesFichiersASupprimer ""
    foreach F $LesFichiersASupprimer {
	if {[file exists $F]} {file delete -force $F}
    }
    #LesResultatsARPAnalyses UnsetAll
    #DechargeLesResidusDesARPs
    #DechargeLesDomainesDesARPs

    return ""    


}

proc ARPAnno_Result_HTML {} {



    Wup "Permet de presenter les resultats sous une forme plus jolie"
    Wup "Affichage sous la forme d un tableau au format HTML"

    #On recupere le resultat final
    #si c une actin on le dit et c tout
    #si c une orphan on ajoute le lien vers le blastp contre les banques dediees
    set BestFam  [LesResultatsARPAnalyses "BestFamily" "LaValeurMerci"]
    set Resultat [LesResultatsARPAnalyses "Result" "LaValeurMerci"]
    if {[regexp -nocase "actin" $BestFam]} {
	return "[join $Resultat "\n"]"
    } elseif {[regexp  -nocase "orphan" $BestFam]} {
	set VraiAccess   "[LesResultatsARPAnalyses "VraiAccess" "LaValeurMerci"]"
	set T            "Orphans"
	set FichierBlast "${VraiAccess}_${T}.blastp"
	if {[file exists "[RepARPAnnoWeb]/$FichierBlast"]} {
	    set Texte "The blast result is available <a  style=\"color: #799AE0\" href=\"/ARPAnno/results/$FichierBlast\" TARGET=\"_blank\">here</a>"
	}
	lappend Resultat $Texte
	return "[join $Resultat "\n"]"
    }

    set     TexteResultat ""
    lappend TexteResultat "<br>"
    lappend TexteResultat "<table border=\"1\">"
    lappend TexteResultat "<tr>"
    foreach F [list Family Score GID pCover pDR pDI] {
	lappend TexteResultat "<th>$F</th>"
    }
    lappend     TexteResultat "</tr>"

    set VraiAccess "[LesResultatsARPAnalyses "VraiAccess" "LaValeurMerci"]"

    set LesVraisFamilles  [LesResultatsARPAnalyses "LesFamilles" "LaValeurMerci"]
    foreach Famille $LesVraisFamilles {
	lappend TexteResultat "<tr>"

	set Score_PId     [LesResultatsARPAnalyses "$Famille,Score_PId"         "LaValeurMerci"]
	set Score_Cover   [LesResultatsARPAnalyses "$Famille,Score_Cover"       "LaValeurMerci"]
	set Score_Residue [LesResultatsARPAnalyses "$Famille,Score_Residue"     "LaValeurMerci"]
	set Score_Domain  [LesResultatsARPAnalyses "$Famille,Score_Domain"      "LaValeurMerci"]
	set Score         [LesResultatsARPAnalyses "$Famille,Score"             "LaValeurMerci"]
	set Score_PId     [LesResultatsARPAnalyses "$Famille,Score_PId_ini"     "LaValeurMerci"]
	set Score_Cover   [LesResultatsARPAnalyses "$Famille,Score_Cover_ini"   "LaValeurMerci"]
	set Score_Residue [LesResultatsARPAnalyses "$Famille,Score_Residue_ini" "LaValeurMerci"]
	set Score_Domain  [LesResultatsARPAnalyses "$Famille,Score_Domain_ini"  "LaValeurMerci"]


	foreach V [list Score_PId Score_Cover Score_Residue Score_Domain Score] {
	    if {      [set $V] == "No"} {
		continue
	    } elseif {[set $V] == ""} {
		set   [set  V]    "No"
	    } else {
		set   [set  V]    [format "%5.1f" [set $V]]
	    }
	}

	if {$Famille==[LesResultatsARPAnalyses "BestFamily" "LaValeurMerci"]} {
	    set GoodColor "orange"
	} else {
	    set GoodColor "gainsboro"
	}
	set i 0
	foreach R [list $Famille $Score $Score_PId $Score_Cover $Score_Residue $Score_Domain] {
	    incr i
	    set Color $GoodColor
	    if {$i=="1"} {
		#set FichierMSF   "${VraiAccess}_${R}.xml"
		set FichierMSF   "${VraiAccess}_${R}.msf"
		set FichierMSF   "${VraiAccess}_${R}.html"
		set FichierBlast "${VraiAccess}_${R}.blastp"
		if {[file exists "[RepARPAnnoWeb]/$FichierMSF"]} {
		    set R "<a href=\"/ARPAnno/results/$FichierMSF\" TARGET=\"_blank\">$R</a>"
		} elseif {[file exists "[RepARPAnnoWeb]/$FichierBlast"]} {
		    set R "<a href=\"/ARPAnno/results/$FichierBlast\" TARGET=\"_blank\">$R</a>"
		}
	    }
	    if {$i=="2"} {
		if {   $Color != "orange"} {
		    set Color    "skyblue"
		}
		set R "<b>$R</b>"
	    }
	    lappend TexteResultat "<td bgcolor=\"$Color\" align=\"center\">$R</td>"
	}
	lappend TexteResultat "</tr>"
    }
    lappend TexteResultat "</table>"

    if {$Resultat != ""} {
	lappend TexteResultat "<br>"
	lappend TexteResultat "<b>$Resultat</b>"
    }

    return "[join $TexteResultat "\n"]"


}

proc ARPAnno_Result_Text {} {



    Wup "Permet de presenter les resultats sous une forme plus jolie"
    Wup "Affichage sous la forme d un tableau separe par des tabulations"

    #On recupere le resultat final
    #si c est une actin ou une orphan on le dit et c est tout
    set          Resultat [LesResultatsARPAnalyses "Result" "LaValeurMerci"]
    if {[regexp "actin|orphan" $Resultat]} {
	return "$Resultat"
    }
    
    set     TexteResultat ""
    set LesNoms [list Family Score GID pCover pDR pDI]
    set LesNoms [join $LesNoms "\t"]
    lappend TexteResultat "$LesNoms"

    set LesVraisFamilles  [LesResultatsARPAnalyses "LesFamilles"            "LaValeurMerci"]
    foreach Famille $LesVraisFamilles {
	set Score_PId     [LesResultatsARPAnalyses "$Famille,Score_PId"     "LaValeurMerci"]
	set Score_Cover   [LesResultatsARPAnalyses "$Famille,Score_Cover"   "LaValeurMerci"]
	set Score_Residue [LesResultatsARPAnalyses "$Famille,Score_Residue" "LaValeurMerci"]
	set Score_Domain  [LesResultatsARPAnalyses "$Famille,Score_Domain"  "LaValeurMerci"]
	set Score         [LesResultatsARPAnalyses "$Famille,Score"         "LaValeurMerci"]

	foreach V [list Score_PId Score_Cover Score_Residue Score_Domain Score] {
	    if {      [set $V] == "No"} {
		continue
	    } elseif {[set $V] == ""} {
		set   [set  V]    "No"
	    } else {
		set   [set  V]    [format "%5.1f" [set $V]]
	    }
	}

	set Resultat [list $Famille $Score $Score_PId $Score_Cover $Score_Residue $Score_Domain]
	lappend TexteResultat "[join $Resultat "\t"]"
    }

    set     Liste ""
    lappend Liste "Access"
    foreach F $LesVraisFamilles {
	lappend Liste $F
    }
    lappend TexteResultat "[join $Liste "\t"]"

    set VraiAccess       [LesResultatsARPAnalyses "VraiAccess" "LaValeurMerci"]
    set     Liste ""
    lappend Liste $VraiAccess
    foreach F $LesVraisFamilles {
	set        Score [LesResultatsARPAnalyses "$F,Score"   "LaValeurMerci"]
	if {      $Score == ""} {
	    set    Score    "No"
	} elseif {$Score != "No"} {
	    set    Score [format "%5.1f" $Score]
	}
	lappend Liste $Score
    }
    lappend TexteResultat "[join $Liste "\t"]"

    return "[join $TexteResultat "\n"]"
    
    
    #Obsolete au cas ou on veuille afficher les nombre de residus sur Max residus et pareil pour insertions
    #3-2 Affiche les resultats
    ##########################
    #protein|q9gzn1|arp6_human is an ARP6
    #         PId    NbGroupOk  NbGroupTotal   
    #       : 1.00   2          2              
    #Group  : 1    2    
    #Result : 1/1  3/3  
    set PId          ""
    set Cover        ""
    set NbGroupOk    ""
    set NbGroupTotal ""
    if {0 && $Res != "-1"} {
	#On recupere les donnees stockees en memoire
	set PId          [LesResultatsARPAnalyses "$Famille,PId,$VraiAccess"   PId   "LaValeurMerci"]
	set Cover        [LesResultatsARPAnalyses "$Famille,Cover,$VraiAccess" Cover "LaValeurMerci"]
	set NbGroupOk    [LesResultatsARPAnalyses "$Famille,NbGroupOk"               "LaValeurMerci"]
	set NbGroupTotal [LesResultatsARPAnalyses "$Famille,NbGroupTotal"            "LaValeurMerci"]
	
	set Ligne   [format "%-7s  %-6s %-10s %-15s" ""  PId  NbGroupOk  NbGroupTotal]
	Espionne    "$Ligne"
	set Ligne   [format "%-7s: %-6s %-10s %-15s" "" $PId $NbGroupOk $NbGroupTotal]
	Espionne    "$Ligne"
	set Ligne1  [format "%-7s: " Group]
	set Ligne2  [format "%-7s: " Result]
	
	set NbGroup [LesResultatsARPAnalyses $Famille,NbGroupTotal "LaValeurMerci"]
	for {set Gr 1} {$Gr<=$NbGroup} {incr Gr} {
	    append Ligne1 [format "%-5s" $Gr]
	    set NbResiduOk    [LesResultatsARPAnalyses $Famille,$Gr,NbResiduOk    "LaValeurMerci"]
	    set NbResiduTotal [LesResultatsARPAnalyses $Famille,$Gr,NbResiduTotal "LaValeurMerci"]
	    append Ligne2 [format "%-5s" "$NbResiduOk/$NbResiduTotal"]
	}
	Espionne "$Ligne1"
	Espionne "$Ligne2"
	Espionne ""
    }
    
    #3-3 Affiche les resultats
    ##########################
    #protein|q9gzn1|arp6_human is an ARP6
    #         PId    NbGroupOk  NbGroupTotal   
    #       : 1.00   2          2              
    #Group  : 1    2    
    #Result : 1/1  3/3  
    #On recupere les donnees stockees en memoire
    set NbDomainOk    ""
    set NbDomainTotal ""
    if {0 && $Dom != "-1"} {
	set NbDomainOk    [LesResultatsARPAnalyses "$Famille,NbDomainOk"    "LaValeurMerci"]
	set NbDomainTotal [LesResultatsARPAnalyses "$Famille,NbDomainTotal" "LaValeurMerci"]
	
	set Ligne  [format "%-7s  %-11s %-15s" ""  NbDomainOk  NbDomainTotal]
	Espionne   "$Ligne"
	set Ligne  [format "%-7s  %-10s %-15s" "" $NbDomainOk $NbDomainTotal]
	Espionne   "$Ligne"
	
	set Ligne1 [format "%-7s: " Domain]
	set Ligne2 [format "%-7s: " Result]
	
	#set NbDomainTotal  [LesResultatsARPAnalyses $Famille,NbDomainTotal  "LaValeurMerci"]
	for {set Do 1} {$Do<=$NbDomainTotal} {incr Do} {
	    append Ligne1  [format "%-5s" $Do]
	    set NbAccOk    [LesResultatsARPAnalyses "$Famille,$Do,NbAccOk"    "LaValeurMerci"]
	    set NbAccTeste [LesResultatsARPAnalyses "$Famille,$Do,NbAccTeste" "LaValeurMerci"]
	    append Ligne2  [format "%-5s" "$NbAccOk/$NbAccTeste"]
	}
	Espionne "$Ligne1"
	Espionne "$Ligne2"
	Espionne ""
    }


}

proc ARPAnno_Stat {} {


    
    Wup "Permet de recuperer un certain nombre de stat sur le fontionnement de ARPAnno"

    #24.7.237.137	ARPAnno_0624_2338_0486
    #24.7.237.137	ARPAnno_0624_2340_0723
    
    #set LogFile "/srs6/WebTempFiles/ARPAnno/ARPAnno.log"
    set LogFile "[RepARPAnnoWeb]/ARPAnno.log"

    set Tab(Date)     ""
    set Tab(LesDates) ""

    set F [open "$LogFile"]
    while {[gets $F Ligne]>=0} {
	if {! [regexp -nocase {[a-z0-9]+} $Ligne]} {continue}
	
	set LigneSplitee [split $Ligne "\t"]
	
	set ID        [lindex $LigneSplitee 0]
	set ARPAnnoID [lindex $LigneSplitee 1]
    
	#Date 
	set Date ""
	regexp {^ARPAnno_([0-9][0-9])} $ARPAnnoID tmp Date

	if {[info exists Tab(Date,$Date)]} {
	    #Cas ou a deja vu cette date
	    if {[set Tab(Date)]==$Date || [set Tab(Date)]==""} {
		#ok pas de probleme on continue une serie de date en cours
	    } else {
		set i 0
		while {1} {
		    incr i
		    set Datetmp "${Date}_${i}"
		    if {[info exists Tab(Date,$Datetmp)]} {
			continue
		    } else {
			set Tab(Date) $Date
			
			set Date $Datetmp
			set     Tab(Date,$Date) 1
			lappend Tab(LesDates)   $Date
			break
		    }
		}
	    }
	} else {
	    set Tab(Date,$Date) 1
	    lappend Tab(LesDates) $Date
	    Espionne ">>>>>>>>>>$Date"
	    set Tab(Date) $Date
	}

	#Nombre de requete par date
	if {! [info exists TabDate($Date,request)]} {
	    set TabDate($Date,request) "0"
	}
	incr TabDate($Date,request)

	#Liste des utilisateurs par date
	if {! [info exists TabDate($Date,user)]} {
	    set TabDate($Date,user) ""
	}
	lappend TabDate($Date,user) $ID
    }
    close $F
    
    set ToSave ""
    foreach Date [set Tab(LesDates)] {
	set NbUser    [llength [lsort -unique [set TabDate($Date,user)]]]
	set NbRequest [set TabDate($Date,request)]

	Espionne "$Date $NbRequest $NbUser"

	lappend ToSave [join [list $Date $NbRequest $NbUser] "\t"]
    }

    AppendAuFichier "/home/jmuller/ARPAnno.stat" [join $ToSave "\n"]

    return 


}

proc ATGAenOverlap {} {



    set OneFour [Entre 4]

    set n 0
    set nATGA 0
    set nGTGA 0
    set nTTGA 0
    set nOver4A 0
    set nOver4G 0
    set nOver4T 0
    foreach Nom [ListeDesPABs] {
	incr n
	set FN "[RepertoireDuGenome]/nuctfa/$Nom"
	if { ! [file exists $FN]} { continue }
	set SeqNuc [QueLaSequenceDuFichierTFA $FN]
	set Quatre [string range $SeqNuc 0 5]
	if { ! [info exists Cumul($Quatre)]} { set Cumul($Quatre) 0 }
	incr Cumul($Quatre)
	if {[regexp -nocase "^ATGA" $SeqNuc] } {
	    incr nATGA
	    set Ov [Overlap $Nom]
	    if { ! [regexp "$OneFour bases. I begin" $Ov Match N] } { continue }
	    incr nOver4A
	}
	if {[regexp -nocase "^GTGA" $SeqNuc] } {
	    incr nGTGA
	    set Ov [Overlap $Nom]
	    if { ! [regexp "$OneFour bases. I begin" $Ov Match N] } { continue }
	    incr nOver4G
	}
	if {[regexp -nocase "^TTGA" $SeqNuc] } {
	    incr nTTGA
	    set Ov [Overlap $Nom]
	    if { ! [regexp "$OneFour bases. I begin" $Ov Match N] } { continue }
	    incr nOver4T
	}
    }
    foreach {Q C} [array get Cumul] {
	set U [string range $Q 0 2]
	set D [string range $Q 3 5]
	lappend LL [list $Q $C [AAduCodon $U][AAduCodon $D]]
    }
    EspionneL [lsort -index 1 -integer $LL]
    return "$n $nATGA $nOver4A $nGTGA $nOver4G $nTTGA $nOver4T [file tail [RepertoireDuGenome]]"


}

proc ATV {NomFichierOuUrlPhylo {EnExec ""}} {



    if {$EnExec==""} { set EnExec "EnHtml" }
    if {$EnExec=="EnExec"} { set EnExec 1 } else { set EnExec 0 }

    set Nom          $NomFichierOuUrlPhylo
    set FichierPhylo $NomFichierOuUrlPhylo
    if {[regexp "/" $FichierPhylo]} {
	set RepPhylo [file dirname $FichierPhylo]
    } else {
	if {[EstUnPAB $Nom]} {
	    while 1 {
		set RepPhylo "phylosOrg"
		set FichierPhylo "[RepertoireDuGenome]/$RepPhylo/$Nom"
		if {[file exists $FichierPhylo]} { break }
		set RepPhylo "phylos"
		set FichierPhylo "[RepertoireDuGenome]/$RepPhylo/$Nom"
		if {[file exists $FichierPhylo]} { break }
		return ""
	    }
	}
    }
    if {$EnExec} {
	if {$FichierPhylo!="" && ! [file exists $FichierPhylo]} { return "" }
	if {[catch {exec atv $FichierPhylo &} Message]} {
	    return 0
	}
	return 1
    }

    if {[EstUnPAB $Nom]} {
	set UrlPhylo "[WscopeScience]&FileMoi&$RepPhylo&$Nom"
    } else {
	set UrlPhylo $NomFichierOuUrlPhylo
    }


    Html_ZeroToBody
    Html_Append "<applet code='forester.atv_awt.ATVapplet.class'" 
    Html_Append "     archive='[WscopeApplet]/ATVapplet.jar' width='200' height='50'>"
    Html_Append " <param name='url_of_tree_to_load' value='$UrlPhylo'>"
    Html_Append "</applet>"
    Html_BodyToEnd
    return [Html_Get]


}

proc A_Voir_LesBanquesDesEntetesDeFrag {FichierFrag {Rep ""}} {



    if {$Rep==""} { set Rep "SameDir" }
    if {$Rep=="SameDir"} { set Rep "[file dirname $FichierFrag]" }

    set LesBanques {}
    foreach Ligne [LesLignesDuFichier $FichierFrag] {
	regsub {\:} $Ligne " " Ligne
	scan $Ligne "%s" Banque
	lappend LesBanques $Banque
    }
    set LesBonnesBanques {}
    foreach Banque $LesBanques {
	set Banque [file tail $Banque]
	set BonneBanque "$Rep/$Banque"
	set Nhr "$BonneBanque.nhr"
	if { ! [file exists $Nhr]} { FaireLire "$Nhr n'existe pas" }
	if {[catch {set Name [exec name $Banque]} Message]} {
	    FaireLire "Problem with 'exec name $Banque'\ I got message \n$Message"
	    continue
	}
	if {[regexp "^@GenDBConfigFiles" $Name]} {
	    regsub "^@" $Name "" Name
	    set NameDir [lindex [split $Name ":"] 0]
	    set Ferme   [lindex [split $Name ":"] 1]
	    if {[catch {set Dir [exec name $NameDir]} Message]} {
		FaireLire "Problem with 'exec name $NameDir'\ I got message \n$Message"
		continue
	    }
	    set Farm "$Dir/$Ferme"
	    if { ! [file exists $Farm]} { FaireLire "$Farm doesn't exists" ; continue }
	    foreach B [LesBanquesDeLaFerme $Farm] {
		Espionne "B $B"
		if {[catch {set NameDeB [exec name $B]} Message]} {
		    FaireLire "Problem with 'exec name $Banque'\ I got message \n$Message"
		    continue
		}
		set NameDirDeB [lindex [split $NameDeB ":"] 0]
		if {[catch {set DirDeB [exec name $NameDirDeB]} Message]} {
		    FaireLire "Problem with 'exec name $NameDirDeB'\ I got message \n$Message"
		    continue
		}
		lappend LesBonnesBanques "$BonneBanque $DirDeB $NameDeB"
	    }
	} else {
	    set NameDir [lindex [split $Name ":"] 0]
	    if {[catch {set Dir [exec name $NameDir]} Message]} {
		FaireLire "Problem with 'exec name $NameDir'\ I got message \n$Message"
		continue
	    }
	    lappend LesBonnesBanques "$BonneBanque $Dir $Name"
	}
    }
    return $LesBonnesBanques


}

proc AamForCilioPathyGenes {} {


    foreach Gn [CilioPathyGenes ListOf Gn] {
	set Trouve 0
	set Acs [QuestionDeScience GeneQuid "ret GnAc $Gn"]
	foreach Ac [split $Acs " "] {
	    set OX [QuestionDeScience GeneQuid "ret UniprotData $Ac OX"]
	    if { ! [regexp {NCBI_TaxID=9606( |;)} $OX]} { continue }
	    #set GnLu [QuestionDeScience GeneQuid "ret AcGn $Ac"]
	    set GnLu ""
	    set N [NIAG $Ac N]
	    if {$N==""} { continue }
	    set Trouve 1
	    #Espionne "$Gn $Ac $GnLu $N"
	    lappend LesNoms $N
	}
	if { ! $Trouve } { Espionne "Je ne trouve rien pour $Gn" }
    }
    Espionne $LesNoms
#    Espionne [AllAboutMacsimPourTous "[RepertoireDuGenome]/AAM_CilioPathyGenes_OK.tsv" [join $LesNoms ","]]
    Espionne [AllAboutMacsimPourTous "[RepertoireDuGenome]/AAM_CilioPathyGenes_1759.tsv" [join $LesNoms ","]]
    return $LesNoms


}

proc AberrationParPatient {LimInf LimSup {LesPos ""} {LesNoms ""}} {


    # -> Compter le nb d'aberrations par patient

    # liste des cas 
    #set LesCas {Oligo806 Oligo807 Oligo809 Oligo810 Oligo811 Oligo812 Oligo814 Oligo815 Oligo816 Oligo817 Oligo818 Oligo819 Oligo820 Oligo821 Oligo822 Oligo823 Oligo825 Oligo826 Oligo827}
    #set LesCas {BAC806 BAC807 BAC809 BAC810 BAC811 BAC812 BAC814 BAC815 BAC816 BAC817 BAC818 BAC819 BAC820 BAC821 BAC822 BAC823 BAC825 BAC826 BAC827}
    set LesCas {BAC806 BAC807 BAC809 BAC810 BAC811 BAC812 BAC814 BAC815 BAC816 BAC817 BAC818 BAC819 BAC820 BAC821 BAC822 BAC823 BAC825 BAC826 BAC827 Oligo806 Oligo807 Oligo809 Oligo810 Oligo811 Oligo812 Oligo814 Oligo815 Oligo816 Oligo817 Oligo818 Oligo819 Oligo820 Oligo821 Oligo822 Oligo823 Oligo825 Oligo826 Oligo827}
    
    Espionne [llength $LesCas]
    
    set ListeChro {HS01 HS02 HS03 HS04 HS05 HS06 HS07 HS08 HS09 HS10 HS11 HS12 HS13 HS14 HS15 HS16 HS17 HS18 HS19 HS20 HS21 HS22 HSX HSY}
    # pour comparaison BAC vs oligo: pas possible sur chro X et Y a cause du mismatch fait pour BAC mais pas pour Oligo...
    #set ListeChro {HS01 HS02 HS03 HS04 HS05 HS06 HS07 HS08 HS09 HS10 HS11 HS12 HS13 HS14 HS15 HS16 HS17 HS18 HS19 HS20 HS21 HS22}


    ### pour chaque fichier CGH Segmente ###
    foreach NomFichier $LesCas {

	set NomFichierSeg "$NomFichier\.seg"
	set FichierSeg "[RepertoireDuGenome]/PRIMA_CGH_SEG/$NomFichierSeg"
	#Espionne $FichierSeg
	
	set LesAberrations ""
	#### Pour chaque chromosome ###
	foreach Chromosome $ListeChro {

	    #Espionne $Chromosome
	    set x [InterrogeFichierSEG $FichierSeg "unset"]
	    ChargeFichierSEG TabS $FichierSeg $Chromosome $LesPos
	    if {[info exists TabS($FichierSeg,Chromosome,$Chromosome,LesPos)]} {
		foreach Pos [set TabS($FichierSeg,Chromosome,$Chromosome,LesPos)] {
		    foreach LInfo [set TabS($FichierSeg,Chromosome,$Chromosome,$Pos)] {
			set PosInf [lindex $LInfo 3]
			set PosSup [lindex $LInfo 4]
			set Val [lindex $LInfo 6]
			set Val [format "%.2f" [expr $Val*1.0]]
			if {($Val>0 && $Val>=$LimSup) || ($Val<0 && $Val<=$LimInf)} {
			    lappend LesAberrations "$NomFichier\t$Chromosome\t$PosInf\t$PosSup\t$Val"
			}
		    }
		}
	    }
	}
	#Espionne [llength $LesAberrations]
	lappend ListeTotale "$NomFichier\t[llength $LesAberrations]"
	SauveLesLignes $LesAberrations dans "[RepertoireDuGenome]/aberrations/$NomFichier$LimSup"
    }
    SauveLesLignes [lsort -decreasing -index 1 -integer $ListeTotale] dans "[RepertoireDuGenome]/aberrations/total$LimSup"
    return 


}

proc AbsRef2Seq {n pos} {

    #set s [set ::Sequences($n)]
    set s [set ::Sref($n)]
    set s [string range $s 0 $pos]
    set s [string map {"." ""} $s]
    set pseq [expr {[string length $s] - 1}]
    #set pseq [string length $s]

    return $pseq

}

proc Ac1Ac2vide {} {


    set total 0; set D 0; set M 0; set N 0; set O 0; set P 0
    set cas1 0; set cas1a 0; set cas1b 0; 
    set cas2 0; set cas3 0; set cas4 0
    foreach I [RetChip5 ListOf Index] {
	incr total

	set LesAcProt {}
	set TousLesGenresProt {}
	array unset LesGenresProt
	set onasourisprot 0

	set ListAcsParGn {}; set BigList {}
	set LesAcsDna {}
	set genenamefait 0
	set LesAcsDeLaLigne "" 

	set Des1 [RetChip5 $I "description_customer"]
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1 [RetChip5 $I "DNA_acc"]
	set Ac2 [RetChip5 $I "refseq_PIQOR"]
	set Ac3 [RetChip5 $I "prot_acc"]
	set Ac4 [RetChip5 $I "prot_acc_PIQOR"]

	if { ($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && (($Ac3!="" && ![regexp {\?} $Ac3]) || $Ac4!="")} {
	    Espionne ""
	    #Ac3=prot_acc Ac4=prot_acc_piqor
	    incr D
	    Espionne "ligne $I Ac3=$Ac3 Ac4=$Ac4"
	    set Ac3 [string trim $Ac3]
	    regsub -all " " $Ac3 "" Ac3
	    set Ac4 [string trim $Ac4]
	    regsub -all " " $Ac4 "" Ac4
	    
	    if {$Ac3!="" && $Ac4!=""} {
		incr M
		set Ac3Ac4 "$Ac3,$Ac4"
		set LesAcProt [split $Ac3Ac4 ","]
	    } elseif {$Ac3!="" && ![regexp {\?} $Ac3]} {
		incr N
		set LesAcProt [split $Ac3 ","]
	    } elseif {$Ac4!=""} {
		incr O
		set LesAcProt [split $Ac4 ","]
	    } 
	    set LesAcProt [ListeSansDoublon $LesAcProt]
	    Espionne $LesAcProt
	    
	    foreach AcProt $LesAcProt {
		set GenreProt [OrgDuProt $AcProt]
		Espionne "AcProt $AcProt GenreProt $GenreProt"
		if {$GenreProt==""} {
		    #peut mettre toutes les variables a vide 
		    Espionne "attention pas fiche"
		    set pasfiche 1
		}
		LConcat TousLesGenresProt $GenreProt
		set LesGenresProt($AcProt) $GenreProt
	    }
	    set TousLesGenresProt [ListeSansDoublon $TousLesGenresProt]
	    
	    foreach ChaqueGenreProt $TousLesGenresProt {
		if {[regexp {^Mus} $ChaqueGenreProt]} {
		    set onasourisprot 1
		}
	    }
	    if {$onasourisprot} {
		Espionne "cas1"; incr cas1
		foreach AcProt $LesAcProt {
		    set ListeDesAcs1 {}; set ListeDesAcs2 {}; set LesAcsDnaProv {}
		    if {[regexp {^Mus} $LesGenresProt($AcProt)]} {
			set ResultParProt [AttriDesAcDnaParProt $AcProt]
			Espionne "ResultParProt $ResultParProt"
			set ResultParGb   [AttriDesAcDnaParGb $AcProt]
			Espionne "ResultParGb $ResultParGb"
			if {$ResultParProt != ""} {
			   Espionne "cas1a"; incr cas1a
			    set ListeDesAcs1 [split $ResultParProt " "]
			}
			if {$ResultParGb != ""} {
			   Espionne "cas1b"; incr cas1b
			    set ListeDesAcs2 [split $ResultParGb " "]
			}
			set LesAcsDnaProv [concat $ListeDesAcs1 $ListeDesAcs2]
			foreach elmt $LesAcsDnaProv {
			    LConcat LesAcsDna $elmt
			}
		    }
		}
		set LesAcsDna [ListeSansDoublon $LesAcsDna]
	    }
	    if {!$onasourisprot} {
		Espionne "cas2"; incr cas2
		set genenamefait 1
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    if {!$genenamefait} {
		Espionne "cas3"; incr cas3
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    set BigList [concat $LesAcsDna $ListAcsParGn]
	    set BigList [ListeSansDoublon $BigList]
	    if {$BigList == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set BigList [ListeSsElmtVide $BigList]
		set LesAcsDeLaLigne [join $BigList " "]
	    }
	   Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}

	if {($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && ($Ac3=="" || [regexp {\?} $Ac3])  && $Ac4==""} {
	   Espionne ""
	    incr P
	   Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	   Espionne "cas4"; incr cas4
	    set genenamefait 1
	   Espionne "$Des1 $Des2"
	    set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    if {$ListAcsParGn == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set ListAcsParGn [ListeSansDoublon $ListAcsParGn]
		set ListAcsParGn [ListeSsElmtVide $ListAcsParGn]
		set LesAcsDeLaLigne [join $ListAcsParGn " "]
	    }
	   Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}
    }
   Espionne "nombre de lignes= $total"
   Espionne "D $D";Espionne "M $M";Espionne "N $N";Espionne "O $O";Espionne "P $P"
   Espionne "cas1 $cas1";Espionne "cas1a $cas1a";Espionne "cas1b $cas1b" 
   Espionne "cas2 $cas2";Espionne "cas3 $cas3";Espionne "cas4 $cas4"


}

proc Ac1Plein {} {


    set total 0; set C 0; set W 0; set X 0
    set cas1 0; set cas1a 0; set cas1b 0; set cas1c 0 
    set cas2 0; set cas2a 0; set cas2b 0; set cas2c 0; set cas2d 0
    set cas3 0; set cas4 0; set cas5 0; set cas6 0
    foreach I [RetChip5 ListOf Index] {  
	incr total

	set LesAc {}
	set Genre ""
	set TousLesGenres {}
	array unset LesGenres
	set onasouris 0
	set LesAcsDna {}

	set LesAcProt {}
	set TousLesGenresProt {}
	array unset LesGenreAcProt
	set onasourisprot 0

	set genenamefait 0
	set ListAcsParGn {}; set BigList {}
	set LesAcsDeLaLigne ""

	set Des1 [RetChip5 $I "description_customer"]
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1 [RetChip5 $I "DNA_acc"]
	set Ac2 [RetChip5 $I "refseq_PIQOR"]
	set Ac3 [RetChip5 $I "prot_acc"]
	set Ac4 [RetChip5 $I "prot_acc_PIQOR"]

	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	   Espionne ""
	    set Ac1 [string trim $Ac1]
	    regsub -all " " $Ac1 "" Ac1
	    incr C
	    Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"

	    if {$Ac2==""} {
		incr W
		set LesAc [split $Ac1 ","]
	    }
	    if {$Ac2!=""} {
		set Ac2 [string trim $Ac2]
		regsub -all " " $Ac2 "" Ac2
		incr X
		set Ac1Ac2 "$Ac1,$Ac2"
		set LesAc [split $Ac1Ac2 ","]
	    }
	    set LesAc [ListeSansDoublon $LesAc]
	    set LesAc [ListeSsElmtVide $LesAc]
	    Espionne $LesAc

	    foreach Ac $LesAc {
		set Genre [OrgDuNmOuGb $Ac]
		Espionne "Ac $Ac Genre $Genre"
		if {$Genre == ""} {Espionne "attention pas fiches"}
		LConcat TousLesGenres $Genre
		set LesGenres($Ac) $Genre
	    }
	    set TousLesGenres [ListeSansDoublon $TousLesGenres]
	    foreach ChaqueGenre $TousLesGenres {
		if {[regexp {^Mus} $ChaqueGenre]} {
		    set onasouris 1
		}
	    }
	    if {$onasouris} {
		Espionne "cas1"; incr cas1
		foreach Ac $LesAc {
		    set LesNmRefSeq {}; set LesNvxNm {}
		    if {[regexp {^Mus} $LesGenres($Ac)]} {
			Espionne "Ac $Ac"
			if { ![regexp {^NM_} $Ac] && ![regexp {^XM_} $Ac] && ![regexp {^NR_} $Ac]} {
			    set NM [MrnaRefseqUcscMouse $Ac "Nm"]
			    Espionne "NM $NM"
			    if { $NM != "" } {
				Espionne "cas1a"; incr cas1a
				set LesNmRefSeq [split $NM " "]
				foreach NmRefSeq $LesNmRefSeq {
				    set GenreNmRefSeq [OrgDuNmOuGb $NmRefSeq]
				    Espionne "$NmRefSeq $GenreNmRefSeq"
				    if {[regexp {^Mus} $GenreNmRefSeq]} {
					LConcat LesNvxNm $NmRefSeq
				    } 
				}
				set LesNvxNm [ListeSansDoublon $LesNvxNm]
				set NMjoint [join $LesNvxNm " "]
				Espionne "NMjoint $NMjoint"
				LConcat LesAcsDna "$Ac $NMjoint"
			    } else { 
				Espionne "cas1b"; incr cas1b
				LConcat LesAcsDna $Ac
			    }
			} else { 
			    Espionne "cas1c"; incr cas1c
			    LConcat LesAcsDna $Ac
			}
		    }
		}
	    }
	    Espionne "cas2"
	    incr cas2
	    #travail sur prot Ac3=$Ac3 Ac4=$Ac4
	    if {$Ac3!="" || $Ac4!=""} {
		Espionne "cas2a"; incr cas2a
		if {$Ac3!="" && $Ac4!=""} {
		    Espionne "cas2b"; incr cas2b
		    set Ac3 [string trim $Ac3]
		    regsub -all " " $Ac3 "" Ac3
		    set Ac4 [string trim $Ac4]
		    regsub -all " " $Ac4 "" Ac4
		    set Ac3Ac4 "$Ac3,$Ac4"
		    set LesAcProt [split $Ac3Ac4 ","]
		} elseif {$Ac3!=""} {
		    set Ac3 [string trim $Ac3]
		    regsub -all " " $Ac3 "" Ac3
		   Espionne "cas2c"; incr cas2c
		    set LesAcProt [split $Ac3 ","]
		} elseif {$Ac4!=""} {
		    set Ac4 [string trim $Ac4]
		    regsub -all " " $Ac4 "" Ac4
		    Espionne "cas2d"; incr cas2d 
		    set LesAcProt [split $Ac4 ","]
		}
		set LesAcProt [ListeSansDoublon $LesAcProt]
		set LesAcProt [ListeSsElmtVide $LesAcProt]
		EspionneL $LesAcProt
		foreach AcProt $LesAcProt {
		    set GenreAcProt [OrgDuProt $AcProt]
		    Espionne "$AcProt $GenreAcProt"
		    if {$GenreAcProt==""} {Espionne "attention pas fiches" }
		    LConcat TousLesGenresProt $GenreAcProt
		    set LesGenreAcProt($AcProt) $GenreAcProt
		}
		set TousLesGenresProt [ListeSansDoublon $TousLesGenresProt]
		foreach ChaqueGenreProt $TousLesGenresProt {
		    if {[regexp {^Mus} $ChaqueGenreProt]} {
			set onasourisprot 1
		    }
		}
		if {$onasourisprot} {
		    Espionne "cas3"; incr cas3
		    foreach AcProt $LesAcProt {
			set ListeDesAcs1 {}; set ListeDesAcs2 {}; set LesAcsDnaProv {}
			if {[regexp {^Mus} $LesGenreAcProt($AcProt)]} {
			    set ResultParProt [AttriDesAcDnaParProt $AcProt]
			    Espionne "ResultParProt $ResultParProt"
			    set ResultParGb   [AttriDesAcDnaParGb $AcProt]
			    Espionne "ResultParGb $ResultParGb"
			    if {$ResultParProt != ""} {
				set ListeDesAcs1 [split $ResultParProt " "]
			    }
			    if {$ResultParGb != ""} {
				set ListeDesAcs2 [split $ResultParGb " "]
			    }
			    set LesAcsDnaProv [concat $ListeDesAcs1 $ListeDesAcs2]
			    foreach elmt $LesAcsDnaProv {
				LConcat LesAcsDna $elmt
			    }
			}
		    }
		}
		set LesAcsDna [ListeSansDoublon $LesAcsDna]
		Espionne "cas4"; incr cas4
		set genenamefait 1
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	   
	    if {!$genenamefait && $Ac3=="" && $Ac4==""} {
		Espionne "cas5"; incr cas5
		set genenamefait 1
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    if {!$genenamefait} {
		Espionne "cas6"; incr cas6
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    set BigList [concat $LesAcsDna $ListAcsParGn]
	    set BigList [ListeSansDoublon $BigList]
	    if {$BigList == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set BigList [ListeSsElmtVide $BigList]
		set LesAcsDeLaLigne [join $BigList " "]
	    }
	    Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}
    }
    Espionne "nb de lignes= $total"
    Espionne "C $C";Espionne "W $W";Espionne "X $X"
    Espionne "cas1 $cas1";Espionne "cas1a $cas1a";Espionne "cas1b $cas1b";Espionne "cas1c $cas1c" 
    Espionne "cas2 $cas2";Espionne "cas2a $cas2a";Espionne "cas2b $cas2b";Espionne "cas2c $cas2c";Espionne "cas2d $cas2d"
    Espionne "cas3 $cas3";Espionne "cas4 $cas4";Espionne "cas5 $cas5";Espionne "cas6 $cas6"


}

proc Ac1videAc2plein {} {


    set total 0; set B 0
    foreach I [RetChip5 ListOf Index] { 
	incr total
	set Des1 [RetChip5 $I "description_customer"]
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1 [RetChip5 $I "DNA_acc"]
	set Ac2 [RetChip5 $I "refseq_PIQOR"]
	set Ac3 [RetChip5 $I "prot_acc"]
	set Ac4 [RetChip5 $I "prot_acc_PIQOR"]
	set LesNMs {}

	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	    Espionne "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	    set LesNMs [split $Ac2 ","]
	    foreach NM $LesNMs { 
		set GetzOut ""
		#set Commande "getz \"\(\\\[refseqrelease-acc:$NM\\\]\|\\\[refseqnew-acc:$NM\\\]\)\!\(\\\[refseqnew-acc:$NM\\\]>\\\[refseqrelease-acc:$NM\\\]\)\" \-view FastaSeqs"
		set Commande "getz \"\\\[refseq-acc:$NM\\\]\" \-view FastaSeqs" 
		set GetzOut [eval exec $Commande]
		if {$GetzOut == ""} {Espionne ">bidon ficherefseqpiqor n'existe plus\natgc" }
		if {$GetzOut != ""} { 
		    set GetzOut [string range $GetzOut [string last ">" $GetzOut] end]
		    if { [regexp {^>ref.+>ref} $GetzOut] } {
			Espionne "ATTENTION AU - 2 SEQ FASTA"
		    }
		   Espionne $GetzOut
		}
	    }
	    continue
	}
    }
   Espionne "total= $total"
   Espionne "B=$B"


}

proc AcDuId {ID {Fichier ""}} {


    global AcDuId

    if {$Fichier==""} { set Fichier "[Fiches]/IDAC.txt" }

    if {[info exists AcDuId($ID)]} { return $AcDuId($ID) }
    if {[info exists AcDuId("EstCharge")]} { return "" }
    set AcDuId("EstCharge") 1
    foreach {N I A B} [LesLignesDuFichier $Fichier] {
	scan $N "%s %s" Bidon Nom
	if {[regexp "_" $Nom]} { continue }
	scan $I "%s %s" Bidon Id
	scan $A "%s %s" Bidon Ac
	regsub {\;} $Ac "" Ac
	set AcDuId($Id) $Ac
    }
    return [AcDuId $ID]


}

proc AcDuIdProt {ID} {


    set Commande "getz \"\\\[protein-id:$ID\\\]\" \-f acc"
    set GetzOut [eval exec $Commande]
    if { $GetzOut == "" } { 
	set AccLu ""	
	return $AccLu
    }
    set AccLu ""
    set AccLu [StringSuivant "AC" dans $GetzOut]
    regsub -all "\t" $AccLu"" AccLu
    regsub -all " " $AccLu "" AccLu
    return $AccLu


}

proc AcGnDeDesAccess {{FichierOuLesAccess ""} {FichierSortie ""}} {


    if {[llength $FichierOuLesAccess]==1 && [file exists $FichierOuLesAccess]} {
        set LesAccess {}
        foreach Access [LesLignesDuFichier $FichierOuLesAccess] {
            regsub -nocase {[^A-Z0-9\-_].*} $Access "" Access
            lappend LesAccess $Access
        }
    } else {
        set LesAccess $FichierOuLesAccess
    }
#   if {$LesAccess==""} { set LesAccess {C9K029 D3DX37 D3DX38 P0C7P4 P47985 Q13546 Q6ZNS2 Q8NBI3 Q8TCM3 Q96LT6 Q9NX33} }
    set I 0
    while { $I < [llength $LesAccess]} {
        set LesA [lrange $LesAccess $I [expr [incr I 100] - 1]]
        foreach A $LesA G [GenenameDesAccess $LesA] D [DescriptionDesAccess $LesA] {
            lappend LeR "$A;$G;$D"
        }
        Espionne "$I $A;$G;$D"
    }
    if {$FichierSortie!=""} { return [SauveLesLignes $LeR dans $FichierSortie] }
    return $LeR


}

proc AccProtEtBanqueProt {} {


    set RepertoireProtEmbl "/genomics/link/EVImm/protembl"
    foreach F [lsort [glob -nocomplain "$RepertoireProtEmbl/EVI*"]] {
	if {![regexp {EVI0932} $F]} {continue}
	set Texte1 ""; set Texte2 ""; set Bq ""
	set Queue [file tail $F]
	Espionne "$Queue"
	foreach Ligne [LesLignesDuFichier $F] {
	   Espionne "$Ligne"
	    if {[regexp {^LOCUS} $Ligne]} {break}
	    if {[regexp {^AC} $Ligne]} {
		scan $Ligne "%s %s" bidon AccProt
		regsub ";" $AccProt "" AccProt
		Espionne "$Queue $AccProt"
		set Commande1 "getz \"\\\[swissprot-acc:$AccProt\\\]\" \-vf id"
		set Texte1 [eval exec $Commande1]
		if {$Texte1!=""} {
		    Espionne "1"
		    set LesMots1 [split $Texte1 ":"]
		    set Bq [lindex $LesMots1 0]
		    set Tab($Queue) $Bq
		    Espionne "$Bq"
		}
		if {$Texte1==""} {
		    Espionne "2"
		    set Commande2 "getz \"\\\[sptrembl-acc:$AccProt\\\]\" \-vf id"
		    set Texte2 [eval exec $Commande2]
		    set LesMots2 [split $Texte2 ":"]
		    set Bq [lindex $LesMots2 0]
		    set Tab($Queue) $Bq
		    Espionne "$Bq"
		}
		break
	    }
	}
    }
    #SauveLesLignes [array get Tab] dans TabCorres
    #array set Tab [LesLignesDuFichier toto]


}

proc AcceptInfoSeq {w} {

    global Defauts TEdit {*}[info globals "TD*"]

    InfosDeLaSeq toto ""

    set nseq [set TEdit(corr,$nseqIn)]
    if {$nseq in $LNOrdali} {
	FaireLire "Warning !\nSequence Name already exists ! Sequence Name should be unique !"
	return
    }

    foreach e [lsort [array names TEdit "*,*"]] {
	lassign [split $e ,] k nseqIn
	if {$k eq "corr" || $k eq "compaa" || $k eq "compGrp" || $k eq "compAll"} {continue}

	set r [set TEdit($e)]
	switch $k {
	    "seqname" {set TDesSeqnames($nseq) $r}
	    "access" {set TDesAccess($nseq) $r}
	    "bid"    {set TDesBId($nseq) $r}
	    "desc"   {set TDesDescriptifs($nseq) $r}
	    "ec"     {
		if {! [EstUnEC $r]} {
		    FaireLire "Warning !\nThe E.C. number of sequence $nseq is badly formatted !\n It should be made of 4 positives numbers,\nseparated by a point character (.)."
		    return
		}
		set TDesEC($nseq) $r
	    }
	    "taxid"  {set TDesTaxId($nseq) $r}
	    "groupe" {set TDuGroupeDesSeqs($nseq) $r}
	    "orga"   {set TDesOrganismes($nseq) $r}
	    "frag"   {set TDesFragment($nseq) $r}
	    "lifed"  {set TDesPhylum($nseq) $r}
	}
    }

    destroy $w
    
    EnregistreInfosSeqs
    ChangeNomsAff $Defauts(NomsAffiches)
    AfficheNomsEtSeqs
    RepeintNomsEtSeqs

    return

}

proc AcceptNewValues {w type what} {

    global EFeat LNOrdali TabSF ListeTypesDeFeatures NomTextSeq Sequences
    
    set EFeat(COk) 0
    if {$what eq "dismiss"} {
	destroy [winfo toplevel $w]
	
	#ChangeFeatureForEditing 
	
	return
    }

    set nc "" ; set nn "" ; set ns ""
    set nx1 "" ; set nx2 ""
    # residue ranges
    if {$type eq "newf"} {
	# residue range corresponds to selection
	set Lt [$NomTextSeq tag ranges slct]
	if {$Lt == {}} {
	    FaireLire "Please do a selection first !"
	    
	    return
	}
	set Lpos $Lt
    } else {
	set nx1 "" ; set nx2 ""
	if {$EFeat(ZoneX1) != ""} {
	    if {! [string is integer $EFeat(ZoneX1)] || ! [string is integer $EFeat(ZoneX2)]} {
		FaireLire "Beware !\nRange should contain integer values"
		return
	    }
	    set nx1 $EFeat(ZoneX1)
	    set nx2 $EFeat(ZoneX2)
	}
	set Lpos $EFeat(LRanges)
    }
    
    # check color
    if {$EFeat(Color) != ""} {
	if {[CouleurPlusProcheDeTkCol $EFeat(Color)] == -1} {
	    FaireLire "Beware !\nThe color specified does not exist !"
	    return
	}
	set nc $EFeat(Color)
    }
    
    # check score
    if {$EFeat(Score) != ""} {
	if {! [string is double $EFeat(Score)] || ! [string is integer $EFeat(Score)]} {
	    FaireLire "Beware !\n Score should be a real number"
	    return
	}
	set ns $EFeat(Score)
    }
    
    # Note
    if {$EFeat(Note) != ""} {
	set nn [string trim $EFeat(Note)]
    }
    
    # current feature
    if {$type eq "newf"} {
	set ft $EFeat(Name)
	if {$ft eq ""} {
	    FaireLire "Beware !\nA feature should have a name !"
	    return
	}
	set ft [string map [list " " "_"] $ft]
	
	# update combo if necessary
	if {$ft ni $ListeTypesDeFeatures} {
	    lappend ListeTypesDeFeatures $ft
	    set ListeTypesDeFeatures [lsort -unique $ListeTypesDeFeatures]
	    set EFeat(FTypes) [linsert $ListeTypesDeFeatures 0 "None"]
	    $EFeat(FeatCombo) configure -values $EFeat(FTypes)
	    set EFeat(Feat) $ft
	}
    } else {
	set ft $EFeat(Feat)
    }

    foreach {p1 p2} $Lpos {
	lassign [split $p1 .] y x1
	lassign [split $p2 .] y x2
	incr x2 -1
	set nom [lindex $LNOrdali $y-1]
	
	if {$type eq "newf"} {
	    # New Featue
	    set nx1 $x1 ; set nx2 $x2
	    if {[string index [set Sequences($nom)] $nx1] eq "." || [string index [set Sequences($nom)] $nx2] eq "."} {set cs "global"} {set cs "local"}
	    lappend TabSF(${nom},$ft) [list fstart $nx1 fstop $nx2 fcolor $nc fscore $ns fnote $nn fcsys $cs]
	} else {
	    # New Item
	    set Lf [set TabSF(${nom},$ft)]
	    set i 0
	    foreach e $Lf {
		DecortiqueUneFeature $e d f c s n cs
		if {$d == $x1 && $f == $x2} {
		    if {$nx1 eq ""} {set nx1 $x1}
		    if {$nx2 eq ""} {set nx2 $x2}
		    if {$nc eq ""} {set nc $c}
		    if {$ns eq ""} {set ns $s}
		    if {$nn eq ""} {set nn $n}
		    if {$cs eq "local"} {
			if {[string index [set Sequences($nom)] $nx1] eq "." || [string index [set Sequences($nom)] $nx2] eq "."} {set cs "global"} {set cs "local"}
		    }
		    set new [list fstart $nx1 fstop $nx2 fcolor $nc fscore $ns fnote $nn fcsys $cs]
		    break
		}
		incr i
	    }
	    set Lf [lreplace $Lf $i $i $new]
	    set TabSF($nom,$ft) $Lf
	}
    }
    if {$type eq "edit"} {
	set EFeat(LItemSel) [list]
    } else {
    }
    set Efeat(COk) 1
    
    destroy [winfo toplevel $w]

    $NomTextSeq configure -state normal
    $NomTextSeq tag remove slct 1.0 end
    $NomTextSeq configure -state disabled
	
    ChangeFeatureForEditing 
    VueEditee 1

    return

}

proc AccepteEtSauveDefauts {w} {

    global env OrdEtcDir Couleurs Defauts CoulTmp TmpDef TmpMap

    # Mapping
    if {[info exists TmpMap]} {
	set Lmap [list]
	set Le [list]
	foreach e [array names TmpMap "*,fg"] {
	    lappend Le [lindex [split $e ,] 0]
	}
	foreach e [lsort $Le] {
	    lappend Lmap [list $e [set TmpMap($e,fg)] [set TmpMap($e,bg)]]
	}
	set TmpDef(Mapping) $Lmap
    }

    array set Defauts  [array get TmpDef]
    array set Couleurs [array get CoulTmp]
    unset -nocomplain TmpDef CoulTmp

    set f [file join $env(HOME) ".ordalierc"]
    if {! [catch {file copy -force -- [file join $OrdEtcDir .ordalierc] $f}]} {
	SauveOrdalieDefauts $f
    }

    destroy [winfo toplevel $w]

    font configure SeqFont -size [set Defauts(SeqFontSize)] -family [set Defauts(SeqFontFaml)] -weight [set Defauts(SeqFontWght)]
    SeqlabFont

    set Threshold [set Defauts(Threshold)]
   
    update idletasks

    return

}

proc Access2GO {Access} {


    if {[EstUnAccessPDB $Access]} {return}
    set AccessCourt    $Access
    regsub {\-[0-9]+$} $Access "" AccessCourt
    set TousLesGO {}
    foreach Requete   [Access2Requetes $AccessCourt] {
	if {[regexp -nocase "^go:" $Requete]} {
	    lappend TousLesGO [string toupper $Requete]
	    continue
	}
	foreach GO [2GO $Requete LesLiens] {
	    set Type [GODB GO $GO LesTypes] 
	    set Def [GODB Type $Type GO $GO LesDefinitions]
	    lappend TousLesGO [string toupper $GO]
	}
    }
    #Espionne "LesGODeRefDesGO [LesGODeRefDesGO $TousLesGO]"
    #Espionne "EnterrerLesAn [EnterrerLesAncetresGO [LesGODeRefDesGO $TousLesGO]]"
    #Espionne "result"
    return [ElimineLesRedondancesDansUneListe [EnterrerLesAncetresGO [LesGODeRefDesGO $TousLesGO]]]


}

proc Access2Kegg {Access} {


    return [PageInfo2Kegg [PageInfo $Access protein "id acc des dr"]]


}

proc Access2Requetes {Access} {


    if {[EstUnAccessPDB $Access]} {return}
    set AccessCourt    $Access
    regsub {\-[0-9]+$} $Access "" AccessCourt

    #nG set Page [PageInfo $AccessCourt protein "DES DR Key"]
    set Page [PageInfo $AccessCourt uniprot "DES DR Key"]
    #set Page [join [LaSequenceDesBanques $Access $Access AccessOK "OnVeutNature"] "\n"]
    return [PageInfo2Requetes $Page]


}

proc AccessAlternatif {Access} {


    global AccessAlternatif
    global RepertoireDuGenome

    if {[info exists AccessAlternatif($Access)]} { return [set AccessAlternatif($Access)] }

    if {[info exists AccessAlternatif("EstCharge")]} {
	if {[regexp {[a-z]} $Access]} {
	    return [AccessAlternatif [string toupper $Access]]
	} else {
	    return ""
	}
    }

    set FichierAccessAlternatif "$RepertoireDuGenome/../accessalternatif"
    if { ! [file exists $FichierAccessAlternatif]} { return "" }

    foreach Ligne [LesLignesDuFichier $FichierAccessAlternatif] {
	scan $Ligne "%s %s" Ancien Nouveau
	set AccessAlternatif($Ancien) $Nouveau
	set AccessAlternatif([string toupper $Ancien]) $Nouveau
	set AccessAlternatif($Nouveau) $Ancien
	set AccessAlternatif([string toupper $Nouveau]) $Ancien
    }
    set AccessAlternatif("EstCharge") "EstCharge"
    return [AccessAlternatif $Access]


}

proc AccessCorrespondantAuxARPs {ARP} {



    Wup "Permet de recuperer les correspondances entre les sequences originelles et les boites gscope"

    global ARP2Acc

    if {[info exists ARP2Acc] && [info exists ARP2Acc($ARP)]} {
	return [set ARP2Acc($ARP)]
    } else {
	set ARP2Acc(ARP01) P42024
	set ARP2Acc(ARP02) P42025
	set ARP2Acc(ARP03) P38696
	set ARP2Acc(ARP04) P45889
	set ARP2Acc(ARP05) O15142
	set ARP2Acc(ARP06) P32381
	set ARP2Acc(ARP07) P45888
	set ARP2Acc(ARP08) P32391
	set ARP2Acc(ARP09) P47117
	set ARP2Acc(ARP10) P32392
	set ARP2Acc(ARP11) O96019
	set ARP2Acc(ARP12) O94805
	set ARP2Acc(ARP13) P80428
	set ARP2Acc(ARP14) Q9V814
	set ARP2Acc(ARP15) Q8N724
	set ARP2Acc(ARP16) P53946
	set ARP2Acc(ARP17) Q9VEC3
	set ARP2Acc(ARP18) Q9GZN1
	set ARP2Acc(ARP19) Q12509
	set ARP2Acc(ARP20) P45890
	set ARP2Acc(ARP21) Q12406
	set ARP2Acc(ARP22) Q9H981
	set ARP2Acc(ARP23) Q12386
	set ARP2Acc(ARP24) Q9VX09
	set ARP2Acc(ARP25) Q05123
	set ARP2Acc(ARP26) Q9UTQ7
	set ARP2Acc(ARP27) Q9NZ32
	set ARP2Acc(ARP28) Q04549
	set ARP2Acc(ARP29) Q9VWE8
	set ARP2Acc(ARP30) Q9BYD9
	set ARP2Acc(ARP31) Q9D9A6
	set ARP2Acc(ARP32) Q9D9J3
	set ARP2Acc(ARP33) Q9D9L5
	set ARP2Acc(ARP34) Q9H568
	set ARP2Acc(ARP35) Q9Y615
	set ARP2Acc(ARP36) Q9Y614
	set ARP2Acc(ARP37) Q9QY84
	set ARP2Acc(ARP38) Q9QY83
	set ARP2Acc(ARP39) Q20329
	set ARP2Acc(ARP40) Q9LZY1
	set ARP2Acc(ARP41) P02568
	set ARP2Acc(ARP42) Q8RYC2
	set ARP2Acc(ARP43) O96621
    }
    if {[info exists ARP2Acc] && [info exists ARP2Acc($ARP)]} {
	return  [set ARP2Acc($ARP)]
    }
    return ""


}

proc AccessDUneLigneBlast {Ligne {Nom ""}} {


    global RepertoireDuGenome

    Wup "Certains blast ont ! entre Access0 et Access1"
    regsub "!" $Ligne " " Ligne

    scan $Ligne "%s %s" Access0 Access1

    if {[regexp {^AFF[0-9]{5}$} $Access0]} {
	if {[file exists "$RepertoireDuGenome/../AffyHS/nucembl/$Access0"]} {
	    return "$RepertoireDuGenome/../AffyHS/nucembl/$Access0"
	}
    }
    if {[regexp "ClonV:" $Access0]} {
	set Vec [lindex [split $Access0 ":"] 1]
	if {[file exists "$RepertoireDuGenome/vecteurs/$Vec"]} {
	    return "$RepertoireDuGenome/vecteurs/$Vec"
	}
    }
    if {[regexp "PABY:" $Access0]} {
	set PAB [lindex [split $Access0 ":"] 1]
	if {[file exists "$RepertoireDuGenome/../casimir/protembl/$PAB"]} {
	    return "$RepertoireDuGenome/../casimir/protembl/$PAB"
	}
    }
    if {[regexp -nocase "PAE:" $Access0]} {
	set PAE [lindex [split $Access0 ":"] 1]
	if {[file exists "$RepertoireDuGenome/../Pyrobac/protembl/$PAE"]} {
	    return "$RepertoireDuGenome/../Pyrobac/protembl/$PAE"
	}
    }
    if {[regexp -nocase "PFUR:" $Access0]} {
	set PFUR [lindex [split $Access0 ":"] 1]
	if {[file exists "$RepertoireDuGenome/../Pfuriosus/protembl/$PFUR"]} {
	    return "$RepertoireDuGenome/../Pfuriok/protembl/$PFUR"
	}
    }
    if {[regexp "PFUR:" $Access0]} {
	set PFOK [lindex [split $Access0 ":"] 1]
	if {[file exists "$RepertoireDuGenome/../Pfuriok/protembl/$PFOK"]} {
	    return "$RepertoireDuGenome/../Pfuriok/protembl/$PFOK"
	}
    }

    if { ! [info exists Access1]} { return $Access0 }

    Wup "Les copains"
    if { $Nom != "" && $Access1 != "" && [file exists "$RepertoireDuGenome/copains/$Nom/$Access1"]} {
	return "$Access1"
    }
    if { $Access1 != "" && [FetchTest "protein:$Access1"]} {
	return "protein:$Access1"
    }
    if { $Access1 != "" && [FetchTest "$Access1"]} {
	return "$Access1"
    }
    return $Access0


}

proc AccessDeLaBoite {PAB {Quoi ""} {DefOuNon ""}} {



    Wup "Retourne l Access de la boite Prot mrna ou tfa originel ou boite"
    Wup "Attention que pour Homo sapiens"

    #Prot puis mrna puis nuctfa puis PAB
    set Access ""
    set OnATrouve 0
  
    if {$Quoi=="protein"} {set OnATrouve 1}

    if {! $OnATrouve || $Quoi=="protein" || [string equal -nocase $Access ""]} {
	set Access [InterrogeBestProteinAndmRNAForeachOrga $PAB Organisme "Homo sapiens" Protein Access]
    }
    if {! $OnATrouve || $Quoi=="mRNA" || [string equal -nocase $Access ""]} {
	set Access [InterrogeBestProteinAndmRNAForeachOrga $PAB Organisme "Homo sapiens" mRNA Access]
	if {$Quoi=="mRNA"} {set OnATrouve 1}
    }
    if {! $OnATrouve && $Access == ""} {
	set FichierNuctfa "[RepertoireDuGenome]/nuctfa/$PAB"
	if {[file exists $FichierNuctfa]} {
	    set Access [EnteteDuFichierTFA $FichierNuctfa "access"]
	}
    }
    if {$Access == "" } {set Access $PAB}
    if {$DefOuNon=="Definition"} {
	set Access [InterrogeBestProteinAndmRNAForeachOrga Access $Access Definition]
    }
    return "$Access" 


}

proc AccessDeMonOrganisme {Nom} {


    set Fichier "[RepertoireDuGenome]/macsims/$Nom.xml"
    if {! [file exists $Fichier]} {return}
    ParseMACSIMS $Fichier macsims
    set Sequences $macsims(Noms)
    set MonOS [NotreOS]
    foreach Sequence $Sequences {
        set Organisme $macsims($Sequence,Organisme)
        if {[regexp "$MonOS" $Organisme]} {
            return $Sequence
        }
    }
    return ""


}

proc AccessDesPremieresProteines {} {



    set Access ""
    append Access "S55507\tPDIP protein disulfide-isomerase (EC 5.3.4.1) ER60 precursor - human\n"
    append Access "P06576\tATPB_HUMAN\n"
    append Access "XP_028869\tIDH1 isocitrate dehydrogenase 1 (NADP+), soluble\n"
    append Access "AAA52688\tHP haptoglobin precursor\n"
    append Access "NP_000282\tPGK1 phosphoglycerate kinase 1\n"
    append Access "NP_061819\tCMAS N-acetylneuraminic acid phosphate synthase; sialic acid synthase; sialic acid phosphate synthase\n"
    append Access "AAH03119\tATP5A1 Similar to ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit, isoform1, cardiac muscle\n"
    append Access "NP_004030\tANXA2 annexin A2; annexin II; lipocortin II\n"
    append Access "NP_005909\tMDH2 malate dehydrogenase 2, NAD (mitochondrial)\n"
    append Access "NP_002809\tPSME2 proteasome (prosome, macropain) activator subunit 2 (PA28 beta); Proteasome activator subunit-2\n"
    append Access "1403294A\tMSMB gamma seminoprotein\n"
    append Access "1HTI_A \tTPI1 ChainA, Triosephosphate Isomerase (Tim) (E.C.5.3.1.1) complexed with 2-Phosphoglycolic Acid\n"
    append Access "NP_003177\tTAGLN transgelin; smooth muscle protein 22-alpha; 22kDA actin-binding protein; SM22-alpha\n"
    append Access "NP_006699\tGLO1 glyoxalase I; lactoyl glutathione lyase; lactoylglutathione lyase\n"
    append Access "NP_002558\tPBP prostatic binding protein; phosphatidylethanolamine binding protein\n"
    append Access "BAA21139\tKNP-I beta protein\n"
    append Access "NP_005070\tTPD52 tumor protein D52\n"
    append Access "NP_005498\tCFL1 cofilin 1 (non-muscle)\n"
    append Access "NP_003188\tTCEB1L transcription elongation factor B polypeptide 1-like; organ of Corti protein 2\n"
    append Access "NP_001961\tEIF5A eukaryotic translation initiation factor 5A; eIF5AI; eIF5A\n"
    append Access "1E3F_A\tTTR Chain A, Structure Of Human Transthyretin Complexed With BromoPhenols: A New Mode Of Binding\n"
    append Access "NP_001435\tFABP5 fatty acid binding protein 5 (psoriasis-associated); E-FABP\n"

    return $Access 


}

proc AccessDuBanqueId {BanqueId} {


    regsub {^[^:]+:} $BanqueId "" BanqueId

    set Fiche [PageInfo $BanqueId "" acc]
    scan $Fiche "%s %s" ACC Access
    if {![info exists Access]} {return}
    regsub "\;$" $Access "" Access
    return $Access


}

proc AccessDuContigDuFragment {AccessDuFragment} {


    regsub {_[0-9]+$} $AccessDuFragment "" AccessDuContig
    return $AccessDuContig


}

proc AccessDuGI {GI} {


    set GI [string trim $GI]
    regsub "GI:" $GI "" GI

    set Page  [PageInfo  $GI genbankfull acc]
    if {$Page == ""} {return}
    scan $Page "%s %s" ACCESSION Access
    return $Access


}

proc AccessDuMiRNA {Nom} {


    set Fichier "[RepertoireDuGenome]/nuctfa/$Nom"
    set LesLignes [LesLignesDuFichier $Fichier]
    set Entete [lindex $LesLignes 0]
    set LesMots [split $Entete " "] 
    set GN [lindex $LesMots 1]
    set DE [join [lrange $LesMots 2 end] " "]
    set Access [lindex $LesMots end]

    set BonDE [ExtractFromRefseq $Access AllMiRNA2907 [RepertoireDuGenome] GetDefinition]
    set GeneName $GN
    if { ! [regexp {\-V[0-9]+$} $GeneName] && [regexp {transcript variant ([0-9]+)} $BonDE Match V]} {
        append GeneName "-V$V"
    }
    append BonDE " from $Access"

    set BonneEntete ">$Nom $GeneName $BonDE"
    set LaSeq [lrange $LesLignes 1 end]
    SauveLesLignes [concat [list $BonneEntete] $LaSeq] dans "[RepertoireDuGenome]/nuctfaNew/$Nom"
    InformeSansDemander $Nom "ValiDE: $BonDE"
    InformeSansDemander $Nom "AccessRefseq: $Access"    
    return $BonneEntete


}

proc AccessDuMiRNAPourTous {} {


    foreach Nom [ListeDesPABs] {
        Espionne [AccessDuMiRNA $Nom] 
    }


}

proc AccessDuPlusProcheDansDisphy {Nom OrgaCherche} {


    global RepertoireDuGenome

    foreach Ligne [LesLignesDuFichier "$RepertoireDuGenome/disphy/$Nom"] {
	scan $Ligne "%s %d %s" Orga Distance Access
	if {$Orga == $OrgaCherche} { return $Access }
    }
    return ""


}

proc AccessDuTFADeLaProteine {PAB} {



    Wup "Rend le banque Id du TFA"

    if {! [file exists $PAB]} {return ""}

    set F [open "$PAB"]
    while {[gets $F Ligne]>=0} {
	if {! [regexp -nocase {[a-z]+ || [0-9]+} $Ligne]} {continue}
	if {  [string range $Ligne 0 0] != ">"}           {continue}
	regsub "^>" $Ligne "" Ligne
	set AccessLu ""
	set BanqueId ""
	set bidon    ""
	scan $Ligne "%s %s %s" bidon BanqueId AccessLu
    }
    if {  ($BanqueId==":" || $BanqueId=="Protein" || $BanqueId=="PROTEIN") && $AccessLu!=""} {set BanqueId $AccessLu} 
    return $BanqueId


}

proc AccessDuTFADumRNA {PAB} {



    Wup "Rend le banque Id du TFA"

    if {! [file exists $PAB]} {return ""}

    set F [open "$PAB"]
    while {[gets $F Ligne]>=0} {
	if {! [regexp -nocase {[a-z]+ || [0-9]+} $Ligne]} {continue}
	if {  [string range $Ligne 0 0] != ">"}           {continue}

	regsub "^>" $Ligne "" Ligne
	set AccessLu ""
	set BanqueId ""
	set bidon    ""
	scan $Ligne "%s %s %s" bidon BanqueId AccessLu
    }
    if {  ($BanqueId==":" || $BanqueId=="mRNA") && $AccessLu!=""} {set BanqueId $AccessLu} 
    return $BanqueId


}

proc AccessEvi {Nom} {


    set BAcc [ExtraitInfo $Nom "BAcc"]
    set Access ""
    ScanLaListe [split $BAcc ":"] Banque Access
    return $Access


}

proc AccessFromHeader {Nom} {


    set Fichier "[RepertoireDuGenome]/prottfa/$Nom"
    if {[FileAbsent $Fichier]} { return "" }
    set Header [EnteteDuFichierTFA $Fichier]
    set Access [StringApres " from " dans $Header]
    return $Access


}

proc AccessHNR {} {


    foreach Nom [ListeDesPABs] {
	set Entete [EnteteDuFichierTFA [GscopeFile $Nom nuctfa]]
	set Access [lindex [LesMotsDeLaLigne $Entete] 5]
	InformeSansDemander $Nom "AccessProt: $Access"
    }
    exit


}

proc AccessNuc2GO {AccessNuc} {


    set LesGO {}
    foreach AccessProt [LesIdDeLaBanqueRelieALAccess $AccessNuc de genbankfull dans protein] {
	foreach GO [Access2GO $AccessProt] {lappend LesGO $GO}
    }
    return [EnterrerLesAncetresGO [LesGODeRefDesGO $LesGO]]


}

proc AccessOlida {access} {


    array set LesSequences {index {}}

    if {0} {
    # Récup les variants protéiques
    set varsplic ""
    catch {set varsplic [exec getz -e "(\[libs={varsplic}-ID:${access}*\] | \[libs-AccNumber:${access}*\])"]}
    foreach entry [splitFastaOlida $varsplic] {
	puts $entry

	regexp -nocase {^>((\w+)-(\d+))\|(\w+)\s+(.*)} [lindex [split $entry "\n"] 0] regMatch index protAccess variant id de
#	puts $index
#	puts $protAccess
#	puts $variant
#	puts $id
#	puts $entry

	lappend LesSequences(index) $index
	set LesSequences($index,access) $index
	set LesSequences($index,banque) "varsplic"
	set LesSequences($index,definition) [string trim $de]
	set LesSequences($index,protein) ">$entry"
    }
    exit
    }
    
    # Récupère les protéines
    set protein ""
    catch {set protein [exec getz -e "(\[libs={refseqp protein}-ID:${access}*\] | \[libs-AccNumber:${access}*\])"]}
    foreach entry [splitEmblOlida $protein] {
	puts $entry

	if {[regexp -lineanchor {^ID} $entry]} {
	    # Entrée uniprot/embl
	    if {[regexp -line {^DR\s+EMBL;\s+(\w+).*;\s+(\w+)\.} $entry regMatch nucAccess nucType]} {
		puts $nucAccess
		puts $nucType
		set nucEntry [exec getz -e "(\[libs={genbank}-AccNumber:${nucAccess}*\])"]
		puts $nucEntry
	    }
	}
    }

    parray LesSequences



#    set getzOut [exec getz -e "(\[libs={genbankfull refseq refseqp protein varsplic pdb}-ID:${access}*\] | \[libs={genbankfull refseq refseqp protein varsplic}-AccNumber:${access}*\])"]


}

proc AccessRefseq {Nom} {


    return [ExtraitInfo $Nom "AccessRefseq"]


}

proc AccessToKeepOrNotToKeep {Access} {



    global MesAccessInterressants

    if {! [info exists MesAccessInterressants]} {MesAccessInterressants}
    
    if {[info exists MesAccessInterressants($Access)]} {return 0} else {return 1}


}

proc AccessionDuMacsimXml {Name {FichierXml ""}} {


    if {$FichierXml==""} { set FichierXml "/home/ripp/msp/data/alignments/[string index $Name 0]_WithModules.xml" }
    if {[regexp "<seq-name>$Name</seq-name>.+?<seq-info>.+?<accession>(.+?)</accession>" [ContenuDuFichier $FichierXml] Match Accession]} { return $Accession }
    regsub mito $Name cyto Name
    if {[regexp "<seq-name>$Name</seq-name>.+?<seq-info>.+?<accession>(.+?)</accession>" [ContenuDuFichier $FichierXml] Match Accession]} { return $Accession }
    return ""


}

proc AceSubset {aAce contigIdx} {


  upvar $aAce ace

  set subset(contigIdx) $contigIdx
  set subset(alignmentName) $ace(alignmentName)
  set subset(name) $ace($contigIdx,name)
  set subset(length) $ace($contigIdx,length)
  set subset(reads) $ace($contigIdx,reads)
  set subset(segments) $ace($contigIdx,segments)
  set subset(strand) $ace($contigIdx,strand)
  set subset(consensus) $ace($contigIdx,consensus)
  set subset(basesQuality) $ace($contigIdx,basesQuality)
  set subset(index) $ace($contigIdx,index)
  set subset(lowestRelativeConsensusPosition) $ace($contigIdx,lowestRelativeConsensusPosition)

  foreach readIdx $ace($contigIdx,index) {
    set subset($readIdx,name) $ace($contigIdx,$readIdx,name)
    set subset($readIdx,strand) $ace($contigIdx,$readIdx,strand)
    set subset($readIdx,consensusPosition) $ace($contigIdx,$readIdx,consensusPosition)
    set subset($readIdx,length) $ace($contigIdx,$readIdx,length)
    set subset($readIdx,numWholeReads) $ace($contigIdx,$readIdx,numWholeReads)
    set subset($readIdx,numTagReads) $ace($contigIdx,$readIdx,numTagReads)
    set subset($readIdx,sequence) $ace($contigIdx,$readIdx,sequence)
    set subset($readIdx,qualityStart) $ace($contigIdx,$readIdx,qualityStart)
    set subset($readIdx,qualityEnd) $ace($contigIdx,$readIdx,qualityEnd)
    set subset($readIdx,alignmentStart) $ace($contigIdx,$readIdx,alignmentStart)
    set subset($readIdx,alignmentEnd) $ace($contigIdx,$readIdx,alignmentEnd)
  }

  return [array get subset]


}

proc AceToMacSim {inputFile {outputDir XmlContigs}} {


  set prefix [PreFixe]
  set numerotation [FormatDesNumerosPourCollection]

  if { ! [file isdirectory [RepertoireDuGenome]/$outputDir] } {
    puts "Creating [RepertoireDuGenome]/$outputDir"
    file mkdir [RepertoireDuGenome]/$outputDir
  }

  # Read ACE file and store results in ace array
  array set ace [readACEfile $inputFile]

  set ORFnumber 1

  foreach contigIdx $ace(index) {
    puts $contigIdx
    array set contig [AceSubset ace $contigIdx]

    # Align sequences in the ace subset array
    puts "Aligning reads to consensus..."
    alignSequencesToConsensus contig

    # Generate XmlMacSim
    puts "Generating XmlMacSim..."
    set xml [generateXMLmacsim contig]

    # Writing...
    set fh [open [format "%s/%s/%s%${numerotation}" [RepertoireDuGenome] $outputDir $prefix $ORFnumber] w]
    puts $fh $xml
    close $fh
    
    incr ORFnumber
  }

  # Well done !
  puts "Finished."

#  quickConvert $outputDir


}

proc ActaClusFilter {Cluster} {



#Permet de retrouver dans un fichier de SBS quels sont ceux qui dans le fichier d'origine avaient un ACTACAN en 5'


set FichierClu [open "/genomics/link/UCSCAlignements/g11/STAF/fiches/Cluster4/Cluster$Cluster.tfa" "r"]

set I 0
if { [file exists $ActaCluster] } {
		file delete $ActaCluster
}
while { [gets $FichierDes25 Ligne25]  >=0 } {
			ScanLaListe $Ligne25 Sequence25
			lappend Liste25 $Sequence25
}
while { [gets $FichierClu LigneClu] >=0 } {
		incr I
		ScanLaListe $LigneClu SequenceClu
		foreach Seq $Liste25 {
			ScanLaListe $Seq Sequence 
			set SBS [string range $Sequence 7 24]
			if { $SequenceClu == $SBS } {
				AppendAuFichier $ActaCluster ">Act$I"
				AppendAuFichier $ActaCluster "$Sequence"
			}

		}
	}		


}

proc ActiChip1_0 {} {


   
    Wup "Permet de rendre la liste des PAB des oligos commandes pour ActiChip1_0"

    set Fichier "[RepertoireDuGenome]/fiches/ActiChip1_0.txt"

    global Oligo_ActiChip1_0

    if {[info exists Oligo_ActiChip1_0]} {
	return $Oligo_ActiChip1_0
    }

    if {! [file exists $Fichier]} {return ""}

    set Oligo_ActiChip1_0 ""

    set F [open "$Fichier"]
    while {[gets $F Ligne]>=0} {
	if {! [regexp -nocase {[a-z0-9]+} $Ligne]} {continue}
	set  PAB ""
	scan $Ligne "%s" PAB
	lappend Oligo_ActiChip1_0 $PAB
    }
    close $F

    set     Oligo_ActiChip1_0 [lsort -unique $Oligo_ActiChip1_0]
    return $Oligo_ActiChip1_0


}

proc ActiChip2_0 {} {


   
    Wup "Permet de rendre la liste des PAB des oligos commandes pour ActiChip2_0"

    set Fichier "[RepertoireDuGenome]/fiches/ActiChip2_1.txt"

    global Oligo_ActiChip2_0

    if {[info exists Oligo_ActiChip2_0]} {
	return $Oligo_ActiChip2_0
    }

    if {! [file exists $Fichier]} {return ""}

    set Oligo_ActiChip2_0 ""

    set F [open "$Fichier"]
    while {[gets $F Ligne]>=0} {
	if {! [regexp -nocase {[a-z0-9]+} $Ligne]} {continue}
	set  PAB ""
	scan $Ligne "%s" PAB
	lappend Oligo_ActiChip2_0 $PAB
    }
    close $F

    set     Oligo_ActiChip2_0 [lsort -unique $Oligo_ActiChip2_0]
    return $Oligo_ActiChip2_0


}

proc ActiChip2_0_Reference {File} {



    Wup "Cree un fichier avec la liste des PAB et des definitions"

    set RepmRNA   "[RepertoireDuGenome]/mrnatfa_Homo_sapiens"
    set RepNuctfa "[RepertoireDuGenome]/nuctfa"

    set LesLignes ""
    foreach PAB [ActiChip2_0] {
	
	#On annote en recherchant les definitions
	set ProteinAccess ""
	set DesignAccess  ""
	set Definition    ""
	#Access utilise lors du design
	#un mRNA ou sequence originale (nuctfa)
	#######################################
	set Query     "$RepmRNA/$PAB"
	if {[file exists $Query]} {
	    set         DesignAccess [AccessDeLaBoite $PAB mRNA]
	} else {
	    set Query "$RepNuctfa/$PAB"
	    if {[file exists $Query]} {
		set     DesignAccess [AccessDuTFADumRNA $Query]
	    } else {set DesignAccess "$PAB"}
	}
	#Access et definition de la proteine correspondante
	###################################################
	set ProteinAccess [AccessDeLaBoite $PAB protein]
	set Definition    [AccessDeLaBoite $PAB protein Definition]
	#Definition de secours (mRNA ou access)
	#######################################
	if {       $Definition == "" && $DesignAccess != ""} {
	    set     Definition [AccessDeLaBoite $PAB mRNA Definition]
	    if {   $Definition == ""} {
		set Definition [lrange [DefDeAcc $DesignAccess genbankfull Def] 1 end]
	    }
	} 
	lappend LesLignes "$PAB\t$Definition"
    }
    AppendAuFichier $File [join $LesLignes "\n"]

    return ""


}

proc ActiChip3_0 {} {


   
    Wup "Permet de rendre la liste des PAB des oligos commandes pour ActiChip3_0"

    set Fichier "[RepertoireDuGenome]/fiches/ActiChip3_0.txt"

    global Oligo_ActiChip3_0

    if {[info exists Oligo_ActiChip3_0]} {
	return $Oligo_ActiChip3_0
    }

    if {! [file exists $Fichier]} {return ""}

    set Oligo_ActiChip3_0 ""

    set F [open "$Fichier"]
    while {[gets $F Ligne]>=0} {
	if {! [regexp -nocase {[a-z0-9]+} $Ligne]} {continue}
	set  PAB ""
	scan $Ligne "%s" PAB
	lappend Oligo_ActiChip3_0 $PAB
    }
    close $F

    set     Oligo_ActiChip3_0 [lsort -unique $Oligo_ActiChip3_0]
    return $Oligo_ActiChip3_0


}

proc ActiChipGenesOnWeb {{ListeDesNoms ""} {TitreSummary ""} args} {


    set LesHeadSup {}
    set I 0
    foreach {PH LesV} $args {
	regsub "_" $PH " " PH
	scan $PH "%s %s" Pos Head
	incr Pos $I
	lappend LesHeadSup $Head
	set PosSup($Head) $Pos
	set K 0
	foreach V $LesV {
	    set ValSup($Head,$K) $V
	    incr K
	}
	incr I
    }
    set FichierActinome "[RepertoireDuGenome]/TableauActiChip"
    set LesLignes  [LesLignesDuFichier $FichierActinome]
    set LigneDeTete [lindex $LesLignes 0]
    set LesHeaders [split $LigneDeTete ";"]

    foreach Head $LesHeadSup {
	set LesHeaders [linsert $LesHeaders $PosSup($Head) $Head]
    }
    set NbHeaders  [llength $LesHeaders]

    set Titre "Actinome Database <i>$TitreSummary</i>"
    set HeaderDuHtml ""
    #Html_ZeroToBody $Titre $HeaderDuHtml
    #Html_Append [H_Balise $Titre "h2"]

    Html_Append "<!Doctype HTML public \"-//w3c//dtd HTML 4.01 Transitional//EN\">"
    Html_BaliseOpen "html"
    Html_BaliseOpen "head"
    Html_Title  "$Titre"
    
    Html_Append "<STYLE TYPE=\"text/css\">"
    Html_Append "body {"
    Html_Append "   margin: 0;"
    Html_Append "   margin-top: 5px;"
    Html_Append "   margin-left: 10px;"
    Html_Append "   margin-right: 10px;"
    Html_Append "   padding: 0;"
    Html_Append "   background-color:#F4F0D8;"
    #Html_Append "   background-color:lightGrey;"
    #Html_Append "   background-image:url(/logos/WscopeBackground.png);"
    Html_Append "   background-repeat:repeat;"
    Html_Append "   background-position:top center;"
    #Html_Append "   margin-left:20px;"
    Html_Append "}"
    Html_Append ".title {"
    Html_Append "   font-weight: bold ; font-family: Arial, Helvetica, sans-serif ;"
    Html_Append "   background: #799AE0 ; color: #FFFFFF;"
    Html_Append "}"
    Html_Append ".frame {background: #799AE0}"
    Html_Append ".chapter {"
    Html_Append "   font-weight: bold ; font-family: Arial, Helvetica, sans-serif;"
    Html_Append "   background: #F4F0D8 ;color: #799AE0;"
    Html_Append "}"
    Html_Append ".text {"
    Html_Append "   font-family: Arial, Helvetica, sans-serif;"
    Html_Append "   background: #FFFFFF ; color: #000000;"
    Html_Append "}	"
    Html_Append "h1 {text-align:center; color: DarkGreen;}"
    Html_Append "h2 {text-align:center; color: DarkGreen;}"
    Html_Append "</STYLE>"

    Html_Append "<img src='/logos/LogoActinome188x92.png' align='middle' alt='Actinome'>"
    Html_Append "<br>"
    Html_Append "<br>"

    Html_Append "<a style=\"color: #799AE0\" href='http://www-bio3d-igbmc.u-strasbg.fr/~ripp/cgi-bin/gscope_html_server.tcsh?Actinome&FicheMoi&help.txt'>Get Help</a>"
    Html_Append "<br>"
    Html_Append "<br>"

    Html_Append "<table style=\"text-align: left; margin-left: 0px; margin-right: 0px;\" class=\"frame\" bgcolor=\"white\" width=\"100%\">"
    Html_Append "<tbody>"
    Html_Append "<tr>"
  
    Html_Append "<td class=text>"

    set NbCol $NbHeaders
    CouleurDegradee $NbCol
    set Liste {}
    lappend Liste $NbCol
    lappend Liste "border='1' cellpadding='3' cellspacing='1'"
    lappend Liste ""
    foreach Header $LesHeaders {
	lappend Liste "bgcolor='[CouleurDegradee]' nowrap='nowrap'"
    }
    foreach Header $LesHeaders {
	lappend Liste $Header
    }
    
    set K 0
    foreach Ligne $LesLignes {
	Espionne "Debut$Ligne FIN"
	set LesValeurs [split $Ligne ";"]
	foreach Head $LesHeadSup {
	    set P $PosSup($Head)
	    set V $ValSup($Head,$K)
	    set LesValeurs [linsert $LesValeurs $P $V]
	}
	incr I
	set Nom [lindex $LesValeurs 0]
	if { ! [EstUnPAB $Nom]} { continue }
	foreach H $LesHeaders V $LesValeurs {
	    if {$H=="ProbeSet" || $H=="Pathway"} {
		set LongV [string length $V]
		if {$LongV>=200} {
		    set Milieu [expr $LongV / 2]
		    set V "[string range $V 0 $Milieu]<br/>[string range $V [expr $Milieu+1] end]"
		}
	    }
	    set Vue [BelleVueJean $H $V $Nom]
	    lappend Liste $Vue
	}
	incr K
    }
    Html_TableFromList $Liste

    Html_Append "<tr>"
    Html_Append "<td></td>"
    Html_Append "</tr>"
    Html_Append "<tr>"
    Html_Append "<td>"
    Html_Append "<table style=\"text-align: left; margin-left: 0px; margin-right: 0px;\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">"
    Html_Append "<tbody>"
    Html_Append "<tr>"
    Html_Append "<td class=\"chapter\">"
    Html_Append "<div style=\"text-align: left;\">"
    Html_Append "<font size=\"-1\">"
    Html_Append "Muller et al (2007) <i>BMC Genomics</i> <b><a style=\"color: #799AE0\" href=\"http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=pubmed&amp;cmd=Retrieve&amp;dopt=AbstractPlus&amp;list_uids=17727702&amp;query_hl=1&amp;itool=pubmed_docsum\" target=\"_blank\">doi: 10.1186/1471-2164-8-294</a></b>"
    Html_Append "</font>"
    Html_Append "</div>"
    Html_Append "</td>"
    Html_Append "</tr>"
    Html_Append "</tbody>"
    Html_Append "</table>"
    Html_Append "</td>"
    Html_Append "</tr>"
    
    Html_Append "<tr>"
    Html_Append "<td>"
    Html_Append "<table style=\"text-align: left; margin-left: 0px; margin-right: 0px;\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">"
    Html_Append "<tbody>"
    Html_Append "<tr>"
    Html_Append "<td class=\"chapter\">"
    Html_Append "<hr style=\"margin-left: 0px; margin-right: 0px;\" width=\"100%\">"
    Html_Append "<div style=\"text-align: left;\">"
    Html_Append "<font size=\"-1\">"
    Html_Append "<i>If you have any problems or questions, please, feel free to contact us at <a style=\"color: #799AE0\" href=\"mailto:jean.muller@igbmc.u-strasbg.fr\">jean.muller@igbmc.u-strasbg.fr</a></i>"
    Html_Append "</font>"
    Html_Append "</div>"
    Html_Append "<hr style=\"margin-left: 0px; margin-right: 0px;\" width=\"100%\">"
    Html_Append "</td>"
    Html_Append "</tr>"
    Html_Append "</tbody>"
    Html_Append "</table>"
    Html_Append "</td>"
    Html_Append "</tr>"

    Html_Append "</tbody>"
    Html_Append "</table>"

    
    Html_BaliseClose "body"
    Html_BaliseClose "html"
    
    return [Html_Get "ZeroIt"]


}

proc AddACorrectedProteome {args} {



	#Telechargement des proteomes
	eval DownloadProteomes $args
	#Conversion pour Gscope 
	FastaProteomeConverter "completeProteome.fasta" "completeConvertedProteome"
	#Lancement de Gscope pour la creation du projet
	puts "##########################################################"
	puts "Gscope va se lancer, réalisez les opération suivantes :"
	puts "    - 'i need the file with all complete genomes' -->YES"
	puts "    - 2eme fentre --> Acknowlegde"
	puts "    - 'c'est pour un genome?' --> NO"
	puts "    - 'c'est pour une collection?' --> YES"
	puts "    - 'prefixe des ORFs' --> mettre un code 4 lettre (ex:AGAM pour anopheles gambiae)"
	puts "    - 'Does it concern only one organism?' --> YES"
	puts "    - Rentrez le nom de l'organisme"
	puts "    - Verifiez la taxinomie"
	puts "    - fenetre suivante --> Acknowlegde"
	puts "    - Choisissez 'Prot: protein for blastp tblastn etc.'"
	puts "    - Aux fenetre suivantes répondre oui pour celle demandant de charger un FASTA"
	puts "    - CHARGEZ completeConvertedProteome.fasta !!!!! Et pas autre chose !!!"
	puts "    - 'Do we handle DNA ?' --> NO"
	puts "    - 'Could you browse a TFA file with all sequences?' --> YES"
	puts "    - 'Do i keep information following each > ?' --> YES"
	puts "    - 'Do I use Access to create Narcisse ?' --> NO"
	puts "    - 'Do I force Access to be in position 1 ?' --> YES"
	puts "    - Ouvrir le fichier completeConvertedProteome.fasta créé."
	puts "    - Mettre 5 pour le nombre de Digits (ca devrait suffire, un proteome > 99999 proteine, c rare ^^)"
	puts "    - 'I will create sequences from a TFA file, are the header as follow ...' --> YES"
	puts "    - 'Do i use access as genename ?' --> YES"
	puts "    - 'Do all following definitions always start with the organism name ?' --> NO"
	puts "    - 'Can i use the Access as alias ?' --> YES"
	puts "    - Patience ... (~12 min pour 14000 proteines)"
	puts "    - répondre non jusqu'à la fin"
	puts "	  - quitter gscope, les instructions se relancent..."
	puts "##########################################################"
	exec gscope


}

proc AddACorrectedProteomeFromFile {fileName} {



	puts "##### ATTENTION !!!!! ###############################"
	puts "vos entetes doivent être sous la forme :"
	puts ">NUM_D_ACCESS genre espece Description_quelconque"
	puts "#####################################################"
	#recup du fichier fasta
	file rename $fileName "completeConvertedProteome.fasta"
	#Lancement de Gscope pour la creation du projet
	puts "##########################################################"
	puts "Gscope va se lancer, réalisez les opération suivantes :"
	puts "    - 'i need the file with all complete genomes' -->YES"
	puts "    - 2eme fentre --> Acknowlegde"
	puts "    - 'c'est pour un genome?' --> NO"
	puts "    - 'c'est pour une collection?' --> YES"
	puts "    - 'prefixe des ORFs' --> mettre un code 4 lettre (ex:AGAM pour anopheles gambiae)"
	puts "    - 'Does it concern only one organism?' --> YES"
	puts "    - Rentrez le nom de l'organisme"
	puts "    - Verifiez la taxinomie"
	puts "    - fenetre suivante --> Acknowlegde"
	puts "    - Choisissez 'Prot: protein for blastp tblastn etc.'"
	puts "    - Aux fenetre suivantes répondre oui pour celle demandant de charger un FASTA"
	puts "    - CHARGEZ completeConvertedProteome.fasta !!!!! Et pas autre chose !!!"
	puts "    - 'Do we handle DNA ?' --> NO"
	puts "    - 'Could you browse a TFA file with all sequences?' --> YES"
	puts "    - 'Do i keep information following each > ?' --> YES"
	puts "    - 'Do I use Access to create Narcisse ?' --> NO"
	puts "    - 'Do I force Access to be in position 1 ?' --> YES"
	puts "    - Ouvrir le fichier completeConvertedProteome.fasta créé."
	puts "    - Mettre 5 pour le nombre de Digits (ca devrait suffire, un proteome > 99999 proteine, c rare ^^)"
	puts "    - 'I will create sequences from a TFA file, are the header as follow ...' --> YES"
	puts "    - 'Do i use access as genename ?' --> YES"
	puts "    - 'Do all following definitions always start with the organism name ?' --> NO"
	puts "    - 'Can i use the Access as alias ?' --> YES"
	puts "    - Patience ... (~12 min pour 14000 proteines)"
	puts "    - répondre non jusqu'à la fin"
	puts "	  - quitter gscope, les instructions se relancent..."
	puts "##########################################################"
	exec gscope


}

proc AddARedundant {redundantSequencesL currentHit} {



	upvar $redundantSequencesL redundantSequences
	upvar $currentHit hit

	# on a une redondance entre A et B
	# on cree le couple  {A B} si il n'existe pas encore
	#set detected 0
	#set where 0
	set A [lindex $hit 0]
	set B [NomDuAlias [lindex $hit 2]]
	#set leCouple [list [lindex $hit 0] [NomDuAlias [lindex $hit 2]]]
	#puts "'$leCouple'"
	#si le couple existe , on le zappe
	#for {set x 0} {$x<[llength $redundantSequences]} {incr x} {
	#	if { [lindex $redundantSequences $x 0]==[lindex $leCouple 0]  #			&& [lindex $redundantSequences $x 1]==[lindex $leCouple 1] } {
	#		set detected 1
	#		continue
	#	}
	#}

	if {![info exists redundantSequences($A,$B)]} {
		set redundantSequences($A,$B) 1
	}
	#if {$detected==0} {
	#	lappend redundantSequences $leCouple
	#}
	


}

proc AddAliasPourMiRNA {} {

    
    foreach F [LesLignesDuFichier /genomics/link/MiRNA/ExtractFromRefseqAllMiRNA2907.fof] {
        set Access [file tail $F]
        regsub ".nuctfa" $Access "" Access
        
        scan [PremiereLigneDuFichier $F] "%s" Alias
        regsub ">" $Alias "" Alias
        set N "$Alias $F"
        Espionne $N
        lappend LesN $N
    }
    SauveLesLignes $LesN dans /genomics/link/MiRNA/ExtractFromRefseqAllMiRNA2907.fofnew
    exit


}

proc AddAnOrganismInCSV {fileName} {


	set output [open "paralogy" "w"]
	set input [open "$fileName" "r"]
	while {[gets $input line]!=-1} {
		if {$line=="" || $line=="\n" || ([string index $line 0]=="#")} {continue}
		set infos [split $line ";"]
		puts $output "[lindex $infos 0];[lindex $infos 1];[lindex $infos 2];[lindex $infos 3];[GetOrga [lindex $infos 2]];[lindex $infos 5];[lindex $infos 6]"
	}
	close $output
	close $input


}

proc AddBranch {B Tree {Index end}} {


    set NewBranches [linsert [Branches $Tree] $Index $B]
    return [NewTree [ValueOfTree $Tree] $NewBranches]


}

proc AddConservationToMacsims {{Liste ""} {Destin ""}} {


    if {$Destin==""} { set Destin "macsimXmlConservation" }
    if {$Liste=={}} { set Liste [ListeDesPABs] }
    NousAllonsAuBoulot
    set LesCrees {}
    foreach Nom $Liste {
	Espionne $Nom
	set FicOri [GscopeFile $Nom "macsimXml"]
	if {[FileAbsent $FicOri]} { continue }
	set FicDes [GscopeFile $Nom $Destin]
	if {[FileExists $FicDes]} { continue }
	if {[FileExists "toto.xml"]} { file delete "toto.xml" }
	if {[catch {exec ordali $FicOri -batch -exe ComputeConservation} Message]} {
	    Espionne "$Nom planté avec message\n$Message"
	    continue
	}
	if {[FileAbsent "toto.xml"]} { Espionne "Bouhhhhh pas de toto.xml pour $Nom" ; continue }
	file rename -force toto.xml $FicDes
	lappend LesCrees $FicDes
    }
    OnRevientDuBoulot
    return $LesCrees


}

proc AddFObj {nom} {

    global pgl

    # proc is called to create the frame or 
    # to update the objects buttons
    set frObjc $pgl(frObjc)
    set c 0
    if {! [winfo exists $frObjc.f${nom}]} {
	set i [lindex [grid size $frObjc] 1]
	frame $frObjc.f${nom} -bg black -relief flat -bd 0 -highlightthickness 0
	
	button $frObjc.f${nom}.b$c  -text "- $nom" -font FontOgTitle  -bg black -fg white  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -pady 0 -padx 0  -highlightthickness 0  -anchor w -justify left  -command [list ToggleTabBouton $frObjc.f${nom}.b$c]
	button $frObjc.f${nom}.n$c  -text "New" -font FontOg  -bg DarkSlateGrey -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -pady 0 -padx 0  -highlightthickness 0  -anchor w -justify left  -command [list DefineNewObj $nom]

	grid $frObjc.f${nom}.b$c  -row $c -column 0 -sticky w  -ipady 0 -pady 0 -padx {0 5}
	grid $frObjc.f${nom}.n$c  -row $c -column 2 -sticky e  -ipady 0 -pady 0 -padx {5 0}

	grid columnconfig $frObjc.f${nom} all -weight 1
	# grid the whole frame
	grid $frObjc.f${nom}  -row $i -column 0 -sticky nwe  -pady 0 -ipady 0 -padx {20 1}
    } else {
	# if the frame exists , expand it if necassary
	if {[llength [grid slaves $frObjc.f${nom}]] == 2} {
	    $frObjc.f${nom}.b0 invoke
	}
    }

    # objects buttons
    set Lb [winfo children $frObjc.f${nom}]
    set Li [lsearch -all -regexp $Lb {\.b0|\.n0}]
    foreach i [lreverse $Li] {
	set Lb [lreplace $Lb $i $i]
    }
    destroy {*}$Lb
    foreach objI [$nom _ListeObjets] {
	if {$objI eq "Index"} {continue}
	incr c

	if {[$nom _EtatDeObjet $objI]} {
	    set col green1
	} else {
	    set col red
	}
	set obj [string range $objI 4 end]
	button $frObjc.f${nom}.bto$obj  -text "$obj" -font FontOg  -bg black -fg $col  -activeforeground $col  -activebackground black  -bd 0 -relief flat  -highlightthickness 0  -padx 0 -pady 0  -anchor w -justify left  -command [list AfficheObjet $frObjc.f${nom}.bto$obj $nom $obj]
	button $frObjc.f${nom}.bte$obj  -text "Edit" -font FontOg  -bg DarkSlateGrey -fg green1  -bd 0 -relief flat  -highlightthickness 0  -activeforeground green1  -activebackground black  -padx 0 -pady 0  -anchor e -justify left  -command [list DefineNewObj $nom $objI]
	button $frObjc.f${nom}.btd$obj  -text "Del" -font FontOg  -bg DarkSlateGrey -fg red  -bd 0 -relief flat  -highlightthickness 0  -activeforeground red  -activebackground black  -padx 0 -pady 0  -anchor e -justify left  -command [list DeleteObjet $nom $objI]
	grid $frObjc.f${nom}.bto$obj  -row $c -column 0 -sticky w  -pady 0 -ipady 0 -padx {5 0}
	grid $frObjc.f${nom}.bte$obj  -row $c -column 1 -sticky e  -pady 0 -ipady 0 -padx {5 5}
	grid $frObjc.f${nom}.btd$obj  -row $c -column 2 -sticky we  -pady 0 -ipady 0
    }

    return

}

proc AddFeatures {Nom FichierXml {CC ""} {FeaturesDirs ""}} {


    #rR 20180329 I changed the order CC FeaturesDirs
    #rR Est appele par ordali uniquement 
    global TabSF
    #CreeLesPiliers
    #RunOrdali

    if {$FeaturesDirs==""} { set FeaturesDirs [list [X0MotifsFeaturesDir $CC] [X1MotifsFeaturesDir $CC] [X2MotifsFeaturesDir $CC]] }
    foreach FeaturesDir $FeaturesDirs {
        Espionne $FeaturesDir/$Nom
	array unset TabSF "*,$FeaturesDir"
	ReadRawFeatureFile $FeaturesDir/$Nom
    }
    SauveLAlignement XML $FichierXml
    exit


}

proc AddGC {Path Organism Chrox bigZips} {


	set FichierIn [open "$Path.coord" "r"]
	set FichierOut [open "$Path.coo" "w"]
	while { [gets $FichierIn Ligne]  >=0 } {
		ScanLaListe $Ligne nbMatchs sequenceNumber start end matchType hs1Mistake hs2Mistake matchOut repeat
		if { $matchType == "F"} {
			set strand "+"
		} else {
			set strand "-"
		}
		set SequenceRallongee [BoutAdnDeUcscBoost [expr $start - 20] [expr $end + 20] $strand $Organism $Chrox $bigZips] 
		set Upstream [string range $SequenceRallongee 0 19]
		set Downstream [string range $SequenceRallongee [expr 19 + [string length $matchOut]] [expr 41 + [string length $matchOut]]]
		Espionne "$SequenceRallongee $Upstream $matchOut $Downstream"
	}
	close $FichierIn
	close $FichierOut


}

proc AddInFile {Text File} {


    set Channel [open $File "a"]
    puts $Channel $Text
    close $Channel
    return $File


}

proc AddInfo {GscopeCode} {


    #set Directory [RepertoireDuGenome]
    #si la sequence n'est pas une sequene protein entière mais un domain ou autre avec un code perso....? que se passe t-il?
    set LL [LaSequenceDesBanques $GscopeCode]
    DecortiqueLesLignesEMBL $LL ID AC DE GN OS OC OX SequenceBrute LaDETotal
    InformeSansDemander $GscopeCode "ID: $ID"
    InformeSansDemander $GscopeCode "AC: $AC"
    InformeSansDemander $GscopeCode "DE: $DE"
    InformeSansDemander $GscopeCode "OS: $OS"
    InformeSansDemander $GscopeCode "OC: $OC"
    InformeSansDemander $GscopeCode "OX: $OX"


}

proc AddLabel {c elt index} {

    global Vrp

    set pos [$c coords $elt]
    set x1 [lindex $pos 2]
    set y1 [lindex $pos 3]
    # add if does not already exist
    if {[llength [$c find withtag t_$index]] == 0 } {
	$c create text $x1 $y1 -fill $Vrp(colLabel)  -font $Vrp(font)  -text "[lindex $Vrp(AA1) $index][lindex $Vrp(Nb) $index]"  -tags [list label t_$index]  -justify right -anchor sw
    }

    return

}

proc AddLeaf {Value Tree {Index end}} {


    return [AddBranch [NewLeaf $Value] $Tree $Index]


}

proc AddLinx {{Login ""} {LinkName ""} {Link ""} {Description ""} {Belongs ""}} {


    if {$LinkName==""} { set LinkName [Entre "FromGscope"] }
    if {$Login==""} { set Login [Login] }
    if {$Link==""}        { set Link64 "" } else { set Link64 [Base64Encode $Link] }
    if {$Description==""} { set Desc64 "" } else { set Desc64 [Base64Encode $Description] }
    if {$Belongs==""}     { set Belo64 "" } else { set Belo64 [Base64Encode $Belongs] }
    set Url "[LbgiUrl]/MyLinx.php?do=addlinx&lo=$Login&ln=$LinkName&li=$Link64&de=$Desc64&be=$Belo64"
    set Status [ContenuDuFichier $Url]
#rR faut il le faire ici   ????????????????????????
    MyLinx ResetMyLinx
    return $Status


}

proc AddLinxTest {} {


    return [AddLinx "poch" "" "http://raymondripp.fr" "Le site de RR" "public"]


}

proc AddModules {file} {

    global TabSF

    array unset TabSF "*,MODULE"
    update

    ReadRawFeatureFile $file

    set Old $::Defauts(FichierXML)
    set root [file rootname $Old]
    set New "${root}_new.xml"

    SauveLAlignement XML $New
    puts "on sauve $New"

    exit

}

proc AddNarcisse {inputFile} {


	#variables globales
    global RepertoireDuGenome
    set repInfos "$RepertoireDuGenome/infos"
	#puts "$repInfos"
	#open input file
	set fasta_file [open $inputFile "r"]
	#reads input line by line
	set compteur 0
	while {[gets $fasta_file line]!=-1} {
    	if {$line==""} { continue }
		#header, correct it
    	if {[string index $line 0]==">"} {
			#separation by |
			set infos1 [split $line "|"]
			lassign $infos1 origin accessNumber description
			regexp {>(.*)} $origin -> origin2
			#puts $origin2
			#pour le fasta de Alvinella pompejana
			if {[string length $origin2]>3} {
				set infos2 [split $origin2 " "]
				set accessNumber [lindex $infos2 0]
				set origin2 "file"
			}
			if {$origin2=="gi"} {
				set origin2 "ref"
			}
			#puts "'$origin2' '$accessNumber'"
			#recuperation de l'accession
			set numGScope [NomDuAlias $accessNumber]
			#puts "'$numGScope'  'Narcisse: $origin2:$accessNumber'"
			InformeSansDemander $numGScope "Narcisse: $origin2:$accessNumber "
			incr compteur
		}
	}
	puts "    -->$compteur infos modifie"


}

proc AddNewAARSPDB {id Lf} {

    global db Tpdb

    if {0} {
	# save file in structure directory
	set fout [file join [MiSynPatDir] data structures ${id}.pdb]
	set o [open $fout w]
	puts $o [join $Lf \n]
	close $o
    }

    # Organism :
    # look into SOURCE cards to find the scientific name and 
    # TaxId of the organism.
    set TaxId ""
    set Gene  ""
    set Li [lsearch -all -regexp $Lf {^SOURCE }]
    foreach i $Li {
	set l [lindex $Lf $i]
	if {[regexp {ORGANISM\_TAXID\:} $l]} {
	    set dTax [string first "TAXID:" $l]
	    set fTax [string first ";" $l]
	    set TaxId [string range $l $dTax+6 $fTax-1]
	}
	if {[regexp {GENE\:} $l]} {
	    set dGen [string first "GENE:" $l]
	    set fGen [string first ";" $l]
	    set Gene [string range $l $dGen+5 $fGen-1]
	}
    }
    set Tpdb($id,taxid) $TaxId
    set Tpdb($id,gene) $Gene
    puts "taxid $TaxId"
    puts "gene $Gene"

    # check if we have a mitochondrial human structure
    set tMit 0
    if {$TaxId == 9606} {
	# double check : in the title and the card
	set LiTitle [lsearch -all -regexp $Lf {^TITLE }]
	set titre ""
	foreach i $LiTitle {
	    append titre [string tolower [lindex $Lf $i]]
	}
	set tMit [regexp {mitochondr} $titre]
	if {$tMit} {
	    puts "==> HUMAN MITO !"
	}
    }
    set Tpdb($id,mito) $tMit
    
    return 1

}

proc AddNewFeatEntry {n db fb code name note score} {

    global CpB 

    lassign [set CpB(startstop,$n)] start stop

    if {$fb < $db} {return}
    if {$fb < $start || $db > $stop} {return}
    if {$db < $start} {set db $start}
    if {$fb > $stop} {set fb $stop}

    set dr [DonnePosGS $n $db]
    set fr [DonnePosGS $n $fb]
    
    switch $name {
	"BLOCK" {
	    if($fr - $dr<4) return;
	    if {$note eq "SBLOCK"} {
		set color $code
	    } elseif {note eq "LBLOCK"} {
		set color 12
	    }
	}
	"REGION" {
	    set color 10
	}
	"SEQERR" {
	    set color 3
	}
	"ANCHOR" {
	    set color $code
	}
	"REPEAT" {
	    set color $code
	}
	"STRUCT" {
	    switch $note {
		"PRED_HELIX" {set color VLRED}
		"PRED_STRAND" {set color VLGREEN}
		"PROP_HELIX" {set color LRED}
		"PROP_STRAND" {set color LGREEN}
		"HELIX" {set color RED}
		"STRAND" {set color GREEN}
	    }
	}
	"TRANSMEM" {
	    if {[regexp {^PRED\_} $note]} {
		set note "$note_$score"
		set color 10
	    } elseif {[regexp {^PROP\_} $note]} {
		,set color GRAY
	    } else {
		set color 1
	    }
	}
	"COIL" -
	"LOWCOMP" {
	    if {[regexp {^PRED\_} $note]} {
		set color LGRAY
	    } elseif {[regexp {^PROP\_} $note]} {
		set color GRAY
	    } else {
		set color 6
	    }
	}
	"DOMAIN" {
	    switch -regexp $note {
		{^PRED\_} {set color LGRAY}
		{^PROP\_} {set color GRAY}
		{^DNA\_BIND} {set color 2}
		{^ZN_FING} {set color 3}
		default {set color 1}
	    }
	}
	"PFAM-A" -
	"PFAM-B" -
	"PROSITE" -
	"ELM" -
	"DISORDER" {
	    if {[regexp {^PRED\_} $note]} {
		set color LGRAY
	    } elseif {[regexp {^PROP\_} $note]} {
		set color GRAY
	    } else {
		set color $code
	    }
	}
	"SIGNAL" {
	    switch -regexp {
		{^PRED\_} {
		    set note "$note_$score"
		    set color LGRAY
		}
		{PROP\_} {set color GRAY}
		"NUCLEAR" {set color 1}
		"CHLOROPLAST" {set color 2}
		"MITOCHONDRION" {set color 3}
		"MICROBODY" {set color 4}
		default {set color 5}
	    }
	}
	"VARSPLIC" {
	    if {[regexp {^PRED\_} $note]} {
		set color LGRAY
	    } elseif {[regexp {^PROP\_} $note]} {
		set color GRAY
	    } else {
		set color 5
	    }
	}
	"MOD_RES" {
	    set color 0
	    switch $note {
		"PRED_" {set color LGRAY}
		"PROP_" {set color GRAY}
		"ACETYLATION" {set color 1}
		"ALKYLATION" {set color 2}
		"HYDROXYLATION" {set color 3}
		"METHYLATION" {set color 4}
		"PHOSPHORYLATION" {set color 5}
		"SULFATION" {set color 6}
		"PYRROLIDONE" {set color 7}
		"MYRISTATE" {set color 8}
		"PALMITATE" {set color 9}
		"FARNESYL" {set color 10}
		"GERANYL" {set color 11}
		"GPI-ANCHOR" {set set color 12}
		"N-ACYL" {set color 13}
	    }
	}
	"SITE" {
	    set color 0
	    switch -regexp $note {
		{^PRED\_} {set color LGRAY}
		{^PROP\_} {set color GRAY}
		"SITE" {set color 0}
		"ACT_SITE" {set color 1}
		"CARBOHYD" {set color 2}
		"DISULFID" {set color 3}
		"BINDING" {set color 4}
		"NP_BIND" {set color 5}
		"CA_BIND" {set color 6}
		"TRANSIT" {set color 7}
		"LIPID" {set color 8}
		"METAL" {set color 9}
	    }
	}
    }
    
    
    lappend CpB(tb,$n) [list ftype $name fstart $start fstop $stop fcolor $color fscore $score fnote $note]
    
    return

}

proc AddObjToFObj {nom obj} {

    global pgl

    set frO "$pgl(frObjc).f${nom}"
    # open the "menu" corresponding to the pdb
    if {[llength [grid slaves $frO]] == 2} {
	$frO.b0 invoke
    }
    set c [lindex [grid size $frO] 1]
    button $frO.bto$obj  -text "$obj" -font FontOg  -bg black -fg green1  -activeforeground red  -activebackground black  -bd 0 -relief flat  -highlightthickness 0  -padx 0 -pady 0  -anchor w -justify left  -command [list AfficheObjet $frO.bto$obj $nom $obj]
    grid $frO.bto$obj  -row $c -column 0 -sticky ""  -columnspan 2  -pady 0 -ipady 0 -padx 0
    
    return

}

proc AddOrganismToOrgaCode {{NewOrga ""} {NewOrga2 ""}} {


JeMeSignale
    if {$NewOrga2!=""} { set NewOrga "$NewOrga $NewOrga2" }
    regsub "_" $NewOrga " " NewOrga

    
    set FichierOrganismes "[GscopeEtc]/gscope_listedesorganismes.txt"
    set FichierGlossaire  "[GscopeEtc]/gscope_glossaire"

    set Organismes [ContenuDuFichier $FichierOrganismes]
    if {$NewOrga!=""} {
	set Organismes "$NewOrga\n$Organismes"
    }
    if { ! [PourWscope]} {
	set Original $Organismes
	FaireLire "You can add other organisms 'Genus species' ... \n Doesn't matter for the alphabetical order or duplicates\n if it's a virus please enter 'Virus homo-sapiens-hiv'" 
	set  Organismes [EntreTexte $Organismes]
	if {$Organismes==""} { return "" }
    }
    set  Organismes [join [lsort -unique [split $Organismes "\n"]] "\n"]
    if {$Original!=$Organismes} {
	Garde $FichierOrganismes
	Sauve $Organismes dans $FichierOrganismes 
	file attribute $FichierGlossaire -permissions 0775
    }
    
    set LesOrganismes [split $Organismes "\n"]
    foreach Ligne $LesOrganismes {
	regsub -all { +} $Ligne " " Ligne
	set Ligne [string trim $Ligne]	
	if { ! [regexp -nocase {[a-z0-9\-]+ [a-z0-9\-]+\.?} $Ligne]} {
	    FaireLire "Invalid organism\n$Ligne\nOnly 2 words please : 'Homo sapiens'" 
	    continue
	}
	set Genre   [string tolower [lindex [split $Ligne " "] 0]]
	set espece  [string tolower [lindex [split $Ligne " "] 1]]
	set G	    [string toupper [string range $Genre 0 0]]
	set esp     [string range $espece 0 2]
	set gesp    [string tolower $G]$esp
	set Complet "$G[string range $Genre 1 end] $espece"
	set Pointe  "$G.$espece"
	set Demi    "$G[string range $Genre 1 3].[string range $espece 0 4]"
	lappend LeGlossaire "$gesp\t$Complet\t$Pointe\t$Demi"
    }
    
    Garde $FichierGlossaire
    SauveLesLignes $LeGlossaire dans $FichierGlossaire
    file attribute $FichierGlossaire -permissions 0775
    Glossaire "Reset"
    return [Glossaire]


}

proc AddPV {} {


    foreach Ligne [LesLignesDuFichier /planbis/commun/dbsql/backups/PRIVILEGES_201602071520.sql] {
        append Ligne ";"
        lappend LeNew $Ligne
    }
    SauveLesLignes $LeNew dans /planbis/commun/dbsql/backups/MYSQL_PRIVILEGES_201602071520.sql


}

proc AddRemoveLabel {c elt} {

    global Vrp

    set t $Vrp(WText)

    set index [lindex [split $elt "_"] 1]

    set item [$c find withtag t_$index]
    #check if label exists
    if {[llength $item] == 0} {
	# add text
	AddLabel $c $elt $index
    } else {
	$c delete $item
    }
    $t see [$t index 1.$index]
    HighlightChar $t $index

    return

}

proc AddSeq {ID {Sequence ""}} {


    #UneNouvelleSequencePourGscope P12346 Auto
    #Normalement la procedure UneNouvelleSequencePourGscope verifie si il y aou non une nouvelle sequence.
    #verification que cette sequence n'existe pas deja. Dans un premier temps
    #Si oui reprends les resultats précédement calcule
    Espionne "ID: $ID"
    Espionne "Sequence: $Sequence"
    
    if {$Sequence!=""} {
	set TFAQuery ">$ID\n$Sequence"
	set information [UneNouvelleSequencePourGscope $TFAQuery Auto]
	scan $information "%s" CodeGscope
	AddInfo $CodeGscope
    } else {
	#Espionne "Avant UneNouvelleSequencePourGscope"
	set information [UneNouvelleSequencePourGscope $ID Auto]
	#Espionne "apres UneNouvelleSequencePourGscope"
	scan $information "%s" CodeGscope
	AddInfo $CodeGscope
    }   
    return $CodeGscope


}

proc AddTaxToSelection {} {


    global LTaxSelected LShowId Tx
    
    puts "AddTo"
    set PAD $Tx(PAD)
    set n $Tx(ItemSel)
    puts "n= $n"
    if {$n eq ""} {return}

    set ix [lsearch $LShowId $n]
    puts "ix show $ix sel [lsearch $::LTaxSelected $n] user [lsearch $::LUserId $n]"
    puts ""
    if {$ix == -1} {return}

    set LShowId [lreplace $LShowId $ix $ix]
    lappend LTaxSelected $n
    
    # change outline of taxId
    $PAD itemconfig "R$n" -outline $Tx(fgCan)

    return


}

proc AddUser {{Login ""} {Uid ""} {Gid ""} {Prenom ""} {Nom ""} {HomeDir ""} {Shell ""} {Hash ""} {CreateDir ""}} {


    if {$Login==""}   { set Login   [Entre "Login="] }
    if {$Uid==""}     { set Uid     [Entre "Uid="] }
    if {$Gid==""}     { set Gid     [Entre "Gid=3000"] }
    if {$Prenom==""}  { set Prenom  [Entre "Prenom="] }
    if {$Nom==""}     { set Nom     [string toupper [Entre "NOM="]] }
    if {$HomeDir==""} { set HomeDir [Entre "Home=/maison"] }
    if {$Shell==""}   { set Shell   [Entre "Shell=/bin/bash"] }
    set Secret "[string tolower [string index $Prenom end][string index $Nom end]]2016"
    if {$Hash==""}    { set Hash    [Entre "Password=$Secret"] ; regsub "Password=" $Hash "" Hash ; set Hash [string trim $Hash] }
    if {$CreateDir==""} { set CreateDir "CreateDir" }
    
    if { ! [regexp {^\{} $Hash]} { set Hash [exec slappasswd -h "{SSHA}" -s $Hash] }

    set CreateDir [string equal -nocase "CreateDir" $CreateDir]

    foreach K {Login Uid Gid Prenom Nom HomeDir Shell} {
        regsub {[^=]*=} [set $K] "" $K
        set $K [string trim [set $K]]
        regsub { } [set $K] "-" $K
        if {$K=="Nom"} { set $K [string toupper [set $K]] }
        Espionne "$K [set $K]"
    }
    
    set LesNouveaux [list "$Login $Uid $Gid $Prenom $Nom $HomeDir $Shell"]
    
    set LesInfos {}
    set LeLdap {}
    foreach Ligne $LesNouveaux {
        lassign [split $Ligne " "] Login Uid Gid Prenom Nom HomeDir Shell
        Espionne $Ligne
        lappend LesInfos $Ligne
        if {$CreateDir || [OuiOuNonMemo "Je crée les répertoires ?" 0]} {
            file mkdir "$HomeDir/$Login"
            if { ! [file exists /home/$Login]} { exec ln -s $HomeDir/$Login /home/ }
        }
        lappend LeLdap "dn: uid=$Login,ou=users,dc=lbgi,dc=fr"
        lappend LeLdap "objectClass: inetOrgPerson"
        lappend LeLdap "objectClass: posixAccount"
        lappend LeLdap "cn: $Login"
        lappend LeLdap "sn: $Nom"
        lappend LeLdap "givenName: $Prenom"
        lappend LeLdap "homeDirectory: /home/$Login"
        lappend LeLdap "loginShell: $Shell"
        lappend LeLdap "uidNumber: $Uid"
        lappend LeLdap "gidNumber: $Gid"
        lappend LeLdap "userPassword: $Hash"
        lappend LeLdap ""
        incr UID
    }
    return [join $LeLdap "\n"]


}

proc AddUsers {} {


    set LesU {}
#   lappend LesU [AddUser collet       3356 3000 Pierre    Collet       /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser schreiner    3357 3000 Clément   Schreiner    /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser abotsi       3358 3000 Isaac     Abotsi       /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser julio        3359 3000 Julio     Navarra-Lara /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser cardosi      3360 3000 Paul      Cardosi      /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser raaj         3361 3000 Raaj      Seereekisson /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser michel       3362 3000 Christian Michel       /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser parrend      3363 3000 Pierre    Parrend      /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser karim        3364 3000 Karim     El-Soufi     /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser willaume     3365 3000 Pierre    Willaume     /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser colin        3366 3000 Florent   Colin        /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser deruyver     3367 3000 Aline     Deruyver     /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser guigou       3368 3000 Fabio     Guigou       /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser masai        3369 3000 Pierre    Masai        /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser mazzu        3370 3000 Timothée  Mazzucotelli /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser toussaint    3371 3000 Nicholas  Toussaint    /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser pasquier     3372 3000 Jean-Yves Pasquier     /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser chene        3373 3000 Jocelyn   Chene        /maison /bin/bash "" CreateDir]
#   lappend LesU [AddUser mesny        3374 3000 Fantin    Mesny        /maison /usr/bin/tcsh "" CreateDir]     
#   lappend LesU [AddUser joly         3375 3000 Mickael   Joly         /maison /usr/bin/tcsh "" CreateDir]     
#   lappend LesU [AddUser leonteva     3376 3000 Anna      Leonteva     /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser huber        3377 3000 Laurine   Huber        /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser jeannin      3378 3000 Anne      Jeannin      /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser pupka        3379 3000 Cedric    Pupka        /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser lmary        3380 3000 Lora      Mary         /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser guth         3381 3000 Catherine Guth         /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser haegelin     3382 3000 Marc      Haegelin     /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser bruyant      3383 3000 Alexandre Bruyant      /maison /bin/bash "" CreateDir] 
#   lappend LesU [AddUser mayer        3386 3000 Claudine Mayer         /maison /usr/bin/tcsh "" CreateDir]     
#   lappend LesU [AddUser durand       3387 3000 Dylan Durand           /maison /usr/bin/tcsh "" CreateDir]     
#   lappend LesU [AddUser michaud      3388 3000 Paul-Armand Michaud    /maison /bin/bash     "" CreateDir]     
#   lappend LesU [AddUser jaafra       3389 3000 Yasmina Jaafra         /maison /bin/bash     "" CreateDir]     
#   lappend LesU [AddUser lecompte     3390 3000 Odile Lecompte         /maison /usr/bin/tcsh "" CreateDir]     
#   lappend LesU [AddUser lenz         3391 3000 Birger Lenz            /maison /usr/bin/tcsh "" CreateDir]     
#   lappend LesU [AddUser grosjean     3393 3000 Maxime Grosjean        /maison /usr/bin/tcsh "" CreateDir]     
#   lappend LesU [AddUser delhomme     3394 3000 X Delhomme             /maison /bin/bash     "" CreateDir]     
#   lappend LesU [AddUser sereni       3395 3000 Jean-Sebastien Sereni  /maison /bin/bash     "" CreateDir]     
#   lappend LesU [AddUser gopal        3396 3000 Gopal Dila             /maison /bin/bash     "" CreateDir]     
#   lappend LesU [AddUser pirot        3397 3000 François Pirot         /maison /bin/bash     "" CreateDir]     
#   lappend LesU [AddUser biancalana   3398 3000 Valérie Biancalana     /maison /bin/bash     "" CreateDir]     
#   lappend LesU [AddUser baguette     3939 3017 Audrey Baguette        /maison /bin/tcsh     "" CreateDir]     
    
    set FichierLdap [SauveLesLignes $LesU dans "[HomeRipp]/rh/Ldap_[Date Seconds].txt"]
    return $FichierLdap


}

proc AdieuOrdali {} {

    global StrucAVoir tmpdebut NomFenetreOrdali Defauts

    if {[set olog [set Defauts(SaveLog)]] != 0} {
	SauveLeLog $olog
    }
    
    FinDBProfile

    if {[VueEditee]} {
	if {[ModeI]} {
	    set chx [tk_dialog .chx "Warning" "Warning !\nThis alignment has not been saved !\nDo you want to save it before to quit Ordalie ?" "" 0 "Yes" "No" "Cancel"]
	} else {
	    set chx 0
	}
	switch $chx {
	    0 {
		SauveLAlignement
	    }
	    1 {
		if {[TypeAli] eq "ORD"} {
		    file rename -force $Defauts(FichierOBK) $Defauts(FichierORD)
		}
	    }
	    2 {return}
	}
    }
    
    catch {$::db close}
    NettoieLeTmp

    if {[ModeI]} {
	if {[winfo exists .lulu]} {
	    QuitteViandox
	}
	destroy $NomFenetreOrdali
    }

    if {! [ModeI]} {
	exit
    } else {
	if {$NomFenetreOrdali eq ".ordali"} {
	    exit
	} else {
	    return
	}
    }

}

proc AdjustFog {what} {

    puts "what $what"
    flush stdout
    update idletasks

    if {$what eq "up"} {
	set dadd  0.01
    } else {
	set dadd -0.01
    }
    if {$::fogsys ne "::GL_LINEAR"} {
	set den [tcl3dOglGetFloatState GL_FOG_DENSITY]
	set den [expr {$den + $dadd}]
	if {$den < 0.001} {set den 0.001}
	glFogf GL_FOG_DENSITY $den
	puts "   density $den"
    } else {
	set ::fact [expr {$::fact + $dadd}]
	if {$::fact < 0.005} {set ::fact 0.005}
	#if {$::fact > 2.} {set ::fact 2.}
	set end [expr {$::fact*2.*$::Rad}]
	glFogf GL_FOG_START 0.
	glFogf GL_FOG_END   $end
	puts "   end $end"
    }

    $::pgl(wogl) postredisplay

    return

}

proc AdnDesCopainsAlignes {} {


    set RepTfasDesCopains "[RepertoireDuGenome]/tfasdescopainsnuc"
    file mkdir $RepTfasDesCopains
    set LesFichierCrees {}
    foreach Nom [ListeDesPABs] {
	set FicCopains "$RepTfasDesCopains/$Nom"
	if {[file exists $FicCopains]} { continue }
	set LesTFAs {}
	set I -1
	set LeTout {}
	foreach Copain [YeastFriends $Nom] {
	    incr I
	    if {$I%10!=0} { continue }
	    set FicNuc [YeastFile $Copain nuctfa]
	    if {$FicNuc==""} { Warne "no file $FicNuc"; continue }
	    set TFA [ContenuDuFichier $FicNuc]

	    set FicPro [YeastFile $Copain prottfa]
	    if {$FicPro==""} { Warne "no file $FicPro"; continue }
	    set PRO [ContenuDuFichier $FicPro]
	    set SeqPro [QueLaSequenceDuTexteTFA $PRO]
	    set SeqPro [string range $SeqPro 20 end]

	    set Seq [QueLaSequenceDuTexteTFA $TFA]
	    set Seq [string range $Seq 60 end]
	    set L [string length $Seq]
	    set LesCodons {}
	    foreach R [split $SeqPro ""] {a b c} [split $Seq ""]  {
		lappend LesCodons "$R-$a$b$c"
	    }
	    set Codons [format "%-16s %5d %s" $Copain $L [join $LesCodons " "]]
	    lappend LeTout [string range $Codons 0 220]		
	}
	Espionne
	EspionneL $LeTout
	continue
	if {$LesTFAs=={}} { Warne "$Nom no TFA"; continue }
	Espionne $Nom
	lappend LesFichiersCrees [SauveLesLignes $LesTFAs dans $FicCopains]
    }
    return $LesFichierCrees


}

proc AdnFictifPourCollection {{Liste ""} {Rep ""} {Zoom ""} {GetWhat ""} {Max ""}} {


    global RepertoireDuGenome
    global ADN TDN RAC
    global DerniereBase LongueurADN

    Wup "Si Zoom est negatif c'est la valeur qu'on prend pour une sequence"
    Wup "Ca marche aussi si Rep est prottfa. Sauf pour ADN TDN et RAC (qui ne sert pas encore)"
    Wup "Attention ca marche aussi pour un autre projet Gscope ... mais sans creer de fichiers"

    if {$Liste==""} { set Liste [ListeDesPABs] }
    if {$GetWhat==""} { set GetWhat "SaveAndGetFilename" }

    if {$Rep==""} { set Rep nuctfa }
    if { ! [regexp "/" $Rep]} { set Rep "[RepertoireDuGenome]/$Rep" }


    set LongSeqConstante 999
    if {$Zoom!="" && $Zoom<0} { set LongSeqConstante $Zoom; set Zoom 1 }
    if {$Zoom==""} { set Zoom 1 }
    set LongSeqConstante [expr -$LongSeqConstante]
    #si elle est negative on l'oublie

    set LongInconnu   300
    if {[OuiOuNon "Do I keep frame 1 for all ORFs ?" 0]} {
	set LongIntergene  99
    } else {
	set LongIntergene 100
    }
    set i [expr ($LongIntergene/3)*3]
    set ADN [string repeat "n" $i]
    set TDN [string repeat "n" $i]
    set RAC [string repeat "n" $i]
    set LesNouvellesBornesSansMutants {}
    foreach PAB $Liste {
	if {[EstUnPABMute $PAB]} {
#	    lappend LesNouvellesBornes "$PAB $Bornes"
	    continue
	}
	set FiNucTFA "$Rep/$PAB"
	if {[file exists $FiNucTFA]} {
	    set SeqNuc [QueLaSequenceDuFichierTFA $FiNucTFA]
	} else {
	    set SeqNuc [string repeat "n" $LongInconnu]
	}
	set Orient [Box $PAB orient]
	if {$Orient=="F"} {
	    set SeqF $SeqNuc
	} else {
	    set SeqF [NucToReverseAndComplementNuc $SeqNuc]
	}
	append ADN $SeqF

	if {$LongSeqConstante<0} {
	    set LongSeq [string length $SeqNuc]
	    set LongSeq [expr round($LongSeq * $Zoom)]
	} else {
	    set LongSeq $LongSeqConstante
	}
	if {[regexp "prottfa" $Rep]} { set LongSeq [expr $LongSeq*3] }
	if {$Max!=""} { set LongSeq [Maxi $Max $LongSeq] }

	set LongReste [expr (3-$LongSeq%3)%3]

	set Fin   [expr $i+$LongSeq]
	set Debut [incr i]

	Box $PAB debut $Debut
	Box $PAB fin   $Fin
	set Bornes "$Debut $Fin $Orient"
	lappend LesNouvellesBornesSansMutants "$PAB $Bornes"
	set i $Fin
	append ADN [string repeat "n" $LongReste]
	incr i $LongReste
	append ADN [string repeat "n" $LongIntergene]
	incr i $LongIntergene
    }
    set TDN "n[NucToReverseNuc $ADN]"
    set RAC "n[NucToReverseAndComplementNuc $ADN]"

    set LesNouvellesBornes {} 
    foreach Ligne $LesNouvellesBornesSansMutants {
	lappend LesNouvellesBornes $Ligne
	scan $Ligne "%s" Nom
	foreach Mutant [LesMutantsDe $Nom "Names"] {
	    regsub $Nom $Ligne $Mutant  LigneMutant
	    lappend LesNouvellesBornes $LigneMutant
	}
    }

    if {[string equal $GetWhat "GetBornesDesPABs"]} { return $LesNouvellesBornes }
    
    set FichierBornes "[RepertoireDuGenome]/fiches/bornesdespabs"
    if { ! [OuiOuNon "Do I modify $FichierBornes ?"]} { return "" }
    
    Garde $FichierBornes
    set FBPab [SauveLesLignes $LesNouvellesBornes dans $FichierBornes]
    return $FBPab


}

proc AdressesIsabelle {{GetWhat ""}} {



    set LesGroupes {}
    NousAllonsAuBoulot "/home/ripp/AdressesIsabelle"
    foreach Ligne [LesLignesDuFichier "AdressesIsabelle.txt"] {
        if {[string trim $Ligne]==""} { continue }
        if {[regexp "^Groupe" $Ligne]} {
            regsub -all " " $Ligne "" Groupe
            lappend LesGroupes $Groupe
            continue
        } 
        set LesMots [LesMotsDuTexte $Ligne]
        lassign $LesMots N P A S
        set Nom    [MultiWordToTitle $N]
        set Prenom [MultiWordToTitle $P]
        set Mail "$A$S"
        set MailMembre [format "%-20s %-20s %s" $Nom $Prenom $Mail]
        lappend LesMailsDuGroupe($Groupe) $Mail
        lappend LesMembresDuGroupe($Groupe) "$Prenom $Nom"
        lappend LesMailsMembresDuGroupe($Groupe) $MailMembre
        Espionne $MailMembre
    }

    set LesCrees {}
    foreach Groupe $LesGroupes {
        set Virgule [join $LesMailsDuGroupe($Groupe) ", "]
        lappend LesCrees [Sauve $Virgule dans MailsAvecVirgule-$Groupe.txt]
        lappend LesCrees [SauveLesLignes $LesMailsDuGroupe($Groupe)         dans Mails-$Groupe.txt]
        lappend LesCrees [SauveLesLignes $LesMembresDuGroupe($Groupe)       dans Membres-$Groupe.txt]
        lappend LesCrees [SauveLesLignes $LesMailsMembresDuGroupe($Groupe)  dans MembresMails-$Groupe.txt]
    }
    OnRevientDuBoulot
    return $LesCrees


}

proc AffecteLesVariablesDeLaListe {Liste {Level 1}} {


#    JeMeSignale
    foreach Ligne $Liste {
	if { ! [regexp {^(Text|List|Array): } $Ligne]} { continue }
	set Type ""
	set NomDeVariable ""
	scan $Ligne "%s %s" Type NomDeVariable
	if { ! [regexp -nocase {^[a-z_]} $NomDeVariable] } { continue }
	lappend LesVariables $NomDeVariable
	regsub {\(} $NomDeVariable {\\(} NomDeVariable
	regsub {\)} $NomDeVariable {\\)} NomDeVariable
	regsub "^$Type $NomDeVariable " $Ligne "" Ligne
#	puts stderr [string range $Ligne 0 80]
	
	set Commande ""
	switch $Type {
	    "Text:"  {
		set Commande "set $NomDeVariable $Ligne"
	    }
	    "List:"  {
		set Commande "set $NomDeVariable [ListSeria $Ligne]"
	    }
	    "Array:" {
		regsub "^_x_" $NomDeVariable "" NomDeVariable
		set Commande "array set $NomDeVariable [ListSeria $Ligne]"
	    }
	}
	if {[regexp bonjour $Commande]} { Espionne $Commande }
	if {$Commande!=""} { uplevel $Level $Commande }
    }
    return $LesVariables


}

proc AffecteLesVariablesDeReponse {Reponse {Level ""}} {


    if {$Level==""} {
	set Level 2
    } else {
	if { ! [regexp {^\#} $Level]} {
	    incr Level
	}
    }
    return [AffecteLesVariablesDeLaListe [split $Reponse "\n"] $Level]


}

proc AffecteListeDesPABs {Liste} {


    global MemoAffecteListeDesPABs
    global ListeDesPABs

    if {$Liste=="Reset"} {
	if { ! [info exists MemoAffecteListeDesPABs]} {
	    return [ListeDesPABs]
	}
	set ListeDesPABs $MemoAffecteListeDesPABs
	unset MemoAffecteListeDesPABs
	return $ListeDesPABs
    }

    if { ! [info exists MemoAffecteListeDesPABs]} {
	set MemoAffecteListeDesPABs [ListeDesPABs]
    }
    set ListeDesPABs $Liste
    return $ListeDesPABs    


}

proc Affichage {LesNoms aProteines aTabSeq} {


    global GpeCases 2_cluster LesCases
    upvar $aProteines Proteines
    upvar $aTabSeq TabSeq
    set w .text
    frame $w
    pack $w -expand yes -fill both

    #boutons
    frame $w.buttons
    pack $w.buttons -side bottom -fill x -pady 2m
    button $w.buttons.sortie -text Exit -command "exit"
    pack $w.buttons.sortie -side left -expand 1

    #fenetre centrale
    frame $w.text -bd 2
    text $w.text.seq -relief sunken -bd 2 -xscrollcommand "$w.scrollx set" -yscrollcommand "$w.scrolly set"  -height 60 -wrap none
    text $w.text.noms -relief sunken -bd 2 -yscrollcommand "$w.scrolly set" -height 60 -width 20 -wrap none
    scrollbar $w.scrolly -command "CoupleYview $w.text.noms $w.text.seq"
    scrollbar $w.scrollx -orient horiz -command "$w.text.seq xview" 
    pack $w.scrolly -side right -fill y
    pack $w.scrollx -side bottom -expand yes -fill x
    pack $w.text -expand yes -fill both
    
    #ecriture des noms
    set chaine_noms ""
    foreach ns $LesNoms {
	append chaine_noms "$ns \n"
    }
    $w.text.noms insert end $chaine_noms

    #ecriture des sequences
    $w.text.seq tag configure c00 -background bisque1
    $w.text.seq tag configure c01 -background honeydew2
    $w.text.seq tag configure c02 -background LemonChiffon1
    $w.text.seq tag configure c03 -background MistyRose2
    $w.text.seq tag configure c04 -background azure2
    $w.text.seq tag configure c10 -background SlateGray1
    $w.text.seq tag configure c11 -background SteelBlue1
    $w.text.seq tag configure c12 -background PaleTurquoise2
    $w.text.seq tag configure c13 -background SkyBlue1
    $w.text.seq tag configure c14 -background aquamarine1
    $w.text.seq tag configure c20 -background gold1
    $w.text.seq tag configure c21 -background RosyBrown1
    $w.text.seq tag configure c22 -background Indianred1
    $w.text.seq tag configure c23 -background LightSalmon1
    $w.text.seq tag configure c24 -background LightPink1
    $w.text.seq tag configure c30 -background MediumPurple1
    $w.text.seq tag configure c31 -background orchid1
    $w.text.seq tag configure c32 -background VioletRed1
    $w.text.seq tag configure c33 -background HotPink2
    $w.text.seq tag configure c34 -background thistle3
    $w.text.seq tag configure c40 -background white
    $w.text.seq tag configure c41 -background yellow
    $w.text.seq tag configure c42 -background blue
    $w.text.seq tag configure c43 -background grey
    $w.text.seq tag configure c44 -background orange
    #test
    $w.text.seq tag configure c05 -background red
    $w.text.seq tag configure c15 -background red
    $w.text.seq tag configure c25 -background red
    $w.text.seq tag configure c35 -background red
    $w.text.seq tag configure c06 -background green
    $w.text.seq tag configure c16 -background green
    $w.text.seq tag configure c26 -background green
    $w.text.seq tag configure c36 -background green


    $w.text.seq delete 0.0 end 
    foreach ns $LesNoms {
	foreach Case $LesCases gpe_case $GpeCases {
	    set Deb [expr [lindex $Case 0]-1]
	    set Fin [expr [lindex $Case end]-1]
	    $w.text.seq insert end [join [lrange [set Proteines($ns)] $Deb $Fin] ""] "c[set TabSeq($ns)]$gpe_case"
	}
	$w.text.seq insert end \n
    }

    #coloration
    pack $w.text.seq -side right -expand yes -fill both
    pack $w.text.noms -side left -fill y


}

proc AffichageHDACroises {aLesPABs aBilan LesFamilles LesOrgCibles} {


    upvar $aLesPABs LesPABs
    upvar $aBilan Bilan
    global RepertoireDuGenome
    set lFam 0
    foreach Fam $LesFamilles {
	set lFam [Maxi [string length $Fam] $lFam]
    }
    incr lFam 1
    set lOrg 0
    foreach Org $LesOrgCibles {
	set lOrg [Maxi [string length $Org] $lOrg]
    }
    incr lOrg 1
    set BlancFam [string repeat " " $lFam]
    set BlancOrg [string repeat " " $lOrg]

    append Sortie $BlancOrg
    foreach Fam $LesFamilles {
	append Sortie [format "%${lFam}s" [llength [set LesPABs($Fam)]]]
    }
    append Sortie "\n" $BlancOrg
    foreach Fam $LesFamilles {
	append Sortie [format "%${lFam}s" $Fam]
    }
    append Sortie "\n"
    foreach Org $LesOrgCibles {
	append Sortie [format "%${lOrg}s" $Org]
	set NbHitsTblastn 0
	foreach Fam $LesFamilles {
	    set Tblastn [lindex [set Bilan($Fam,$Org)] 0]
	    puts "$Org $Fam Tblastn: $Tblastn"
	    set Couleur [CouleurHDACroises [set Bilan($Fam,$Org)]]
	    if {$Tblastn} {
		incr NbHitsTblastn 
	    }
	    if {$Couleur=="O"} {
		append Sortie [format "%${lFam}s" $Tblastn]
	    } else {
		append Sortie [format "%${lFam}s" $Couleur]
	    }
	}
	append Sortie  "      $NbHitsTblastn" "\n" $BlancOrg
	set NbHitsBlastp 0
	foreach Fam $LesFamilles {
	    set Blastp [lindex [set Bilan($Fam,$Org)] 1]
	    if {$Blastp} {
		incr NbHitsBlastp
	    }
	    if {$Couleur=="O"} {
		append Sortie [format "%${lFam}s" $Blastp] 
	    } else {
		append Sortie $BlancFam
	    }
	}
	append Sortie "      $NbHitsBlastp" "\n" $BlancOrg
	set NbJaunes 0
	foreach Fam $LesFamilles {
	    set Jaune [lindex [set Bilan($Fam,$Org)] 2]
	    if {$Jaune} {
		incr NbJaunes
	    }
	    if {$Couleur=="O"} {
		append Sortie [format "%${lFam}s" $Jaune] 
	    } else {
		append Sortie $BlancFam
	    } 
	}
	append Sortie "      $NbJaunes" "\n"
    }
    AfficheVariable $Sortie "GrandeLargeurSansRien" 
    EcritFichier [split $Sortie "\n"] "$RepertoireDuGenome/fiches/bilanHDAcroises_tableau"


}

proc Affiche {Page {Maniere ""} {NomDuFichierOrigine ""}} {


    return [AfficheVariable $Page $Maniere $NomDuFichierOrigine]


}

proc AfficheAliEnPage {Page LigneAccess Fichier} {



    return [AfficheVariable [PartieSegAli $Page $LigneAccess] " " $Fichier]


}

proc AfficheAliInOut {Nom} {


    global RepertoireDuGenome

    set Fichier "$RepertoireDuGenome/aliinout/$Nom"
    if { ! [file exists $Fichier]} { return "" } 
    set Fen [AfficheFichier $Fichier]
    return [Illumine "accepted" $Fen]


}

proc AfficheArbre {Arbre} {


    global AfficheArbreIndent
    if {[EstUneFeuille $Arbre]} {
	Espionne "[string repeat " " $AfficheArbreIndent]+ $Arbre"
	return
    }
    set A1 [lindex $Arbre 0] 
    set D1 [lindex $Arbre 1] 
    set A2 [lindex $Arbre 2] 
    set D2 [lindex $Arbre 3] 
    Espionne "[string repeat " " $AfficheArbreIndent]+ $D1"
    incr AfficheArbreIndent
    AfficheArbre $A1
    incr AfficheArbreIndent -1
    Espionne "[string repeat " " $AfficheArbreIndent]+ $D2"
    incr AfficheArbreIndent
    AfficheArbre $A2
    incr AfficheArbreIndent -1


}

proc AfficheAskAddSeq {aTAddS} {

    global TAddS LNDG

    array set TAddS $aTAddS

    if {[winfo exists .affas]} {
	raise .affas

	return
    }

    set w .affas
    toplevel $w
    wm title $w "Add Sequences"
    wm protocol $w WM_DELETE_WINDOW KillParLaCroix
    grid columnconfig $w 0 -weight 1
    grid rowconfig    $w 0 -weight 1

    frame $w.f
    grid $w.f -row 0 -column 0 -sticky news
    grid columnconfig $w.f 0 -weight 1

    # row index iR
    set iR 0
    set wf "$w.f"
    label $wf.title  -text "Add sequences to the alignment"  -font "Helvetica 16 bold"  -relief groove
    grid $wf.title -row $iR -column 0 -sticky w -padx 5 -pady {5 15}
    
    label $wf.lbfile  -text "Sequences File name : "  -relief flat
    grid $wf.lbfile -row [incr iR] -column 0 -sticky w -padx 5 -pady {15 5}
    frame $wf.ffile
    grid $wf.ffile -row [incr iR] -column 0 -sticky ew -padx 5
    grid columnconfig $wf.ffile 0 -weight 1
    entry $wf.ffile.enfile  -background white  -font [$wf.lbfile cget -font]  -textvariable TAddS(File)
    button $wf.ffile.bufile  -text "Browse"  -background cyan  -command "set TAddS(File) \[DemandeEtOuvreFichier *\]"
    grid $wf.ffile.enfile -row 0 -column 0 -sticky ew
    grid $wf.ffile.bufile -row 0 -column 1 -sticky e -padx {20 0}

    # align Sequences
    label $wf.lbali  -relief flat  -text "The imported sequences should be "
    grid $wf.lbali -row [incr iR] -column 0 -sticky w -padx 5 -pady {15 5}
    frame $wf.fali
    grid $wf.fali -row [incr iR] -column 0 -sticky ew -padx 5
    grid columnconfig $wf.fali {0 1} -weight 1
    radiobutton $wf.fali.align  -text "aligned against the alignment (using MAFFT)"  -relief flat  -value 1  -variable TAddS(Align)
    radiobutton $wf.fali.alone  -text "kept unchanged"  -relief flat  -value 0  -variable TAddS(Align)
    grid $wf.fali.align -row 0 -column 0 -sticky w -padx {30 5}
    grid $wf.fali.alone -row 0 -column 1 -sticky w
    if {[llength $LNDG] > 1} {
	checkbutton $wf.chkc  -text "keep existing clusters"  -relief flat  -onvalue 1  -offvalue 0  -variable TAddS(KeepClus)
	grid $wf.chkc -row [incr iR] -column 0 -sticky w -padx {30 5}
    }

    # what to do with seqs already here ?
    label $wf.lbdup  -text "If a sequence name already exists in the alignment,"
    grid $wf.lbdup -row [incr iR] -column 0 -sticky w -pady {15 5} -padx 5
    frame $wf.fck
    grid $wf.fck -row [incr iR] -column 0 -sticky ew -padx 5
    grid columnconfig $wf.fck {0 1} -weight 1
    radiobutton $wf.fck.copy  -text "create a copy"  -relief flat  -value 0  -variable TAddS(CopySkip)
    radiobutton $wf.fck.skip  -text "skip the imported sequence"  -relief flat  -value 1  -variable TAddS(CopySkip)
    grid $wf.fck.copy -row 0 -column 0 -sticky w -padx {30 5}
    grid $wf.fck.skip -row 0 -column 1 -sticky w

    # assign cluster
    label $wf.lbclu  -text "The imported sequences should be :"  -relief flat
    grid $wf.lbclu -row  [incr iR] -column 0 -sticky w -pady {15 5} -padx 5
    radiobutton $wf.bott  -relief flat  -text "inserted at the bottom of the alignment"  -value "end"  -variable TAddS(Position)
    grid $wf.bott  -row [incr iR] -column 0 -sticky w -padx {30 5}
    frame $wf.faf
    grid $wf.faf -row [incr iR] -column 0 -sticky ew -padx {30 5} 
    #grid columnconfig $wf.faf 0 -weight 1
    radiobutton $wf.faf.afse  -relief flat  -text "inserted after this sequence :"  -value "afterseq"  -variable TAddS(Position)
    set Lseqnames [list]
    foreach n $::LNOrdali {
	if {$n ne ""} {lappend Lseqnames $n}
    }
    set width [PlusLongEltDe $Lseqnames]
    ttk::combobox $wf.faf.cbs  -state readonly  -background white  -width $width -values $Lseqnames
    bind $wf.faf.cbs <<ComboboxSelected>> {set TAddS(seqInsert) [%W get]}
    grid $wf.faf.afse -row 0 -column 0 -sticky w
    grid $wf.faf.cbs  -row 0 -column 1 -sticky w -padx {10 0}

    if {[llength $LNDG] > 1} {
	radiobutton $wf.clus  -relief flat  -text "inserted into their corresponding cluster \naccording to sequences identity"  -justify left  -value "cluster"  -variable TAddS(Position)
	grid $wf.clus  -row [incr iR] -column 0 -sticky w -padx {30 5}
    }
    
    frame $wf.but 
    grid $wf.but -row [incr iR] -column 0 -sticky ew -pady {40 10} -padx 5
    grid columnconfig $wf.but {0 1} -weigh 1

    button $wf.but.dis  -background red  -text "Dismiss"  -command [list FinAfficheAskAddSeq dismiss]
    button $wf.but.ok  -background green1  -text " OK "  -command [list FinAfficheAskAddSeq ok]
    grid $wf.but.dis -row 0 -column 0 -sticky w -padx 5
    grid $wf.but.ok  -row 0 -column 1 -sticky e -padx 5

    bind $wf.but.ok <Return> "$wf.but.ok invoke"

    FenetreAuCentre $w

    $wf.but.ok configure -default active
    focus $wf.but.ok

    tkwait window $w


    if {$TAddS(ok)} {
	return [array get TAddS]
    } else {
	return ""
    }

}

proc AfficheAssocie {Source CoRepertoire {Maniere ""}} {


    global RepertoireDuGenome

    regsub -nocase {\.[a-z_]*$} $Source "" Source

    set Nom [file tail $Source]
    set CheminSource [file dirname $Source]
    set CheminCheminSource [file dirname $CheminSource]
    set RepSource [file tail $CheminCheminSource]
    regsub "$RepSource" $Source "$CoRepertoire" Nouveau

    Wup "If Nouveau not found we try CoRepertoire/Nom"
    foreach Nouveau [list $Nouveau "$RepertoireDuGenome/$CoRepertoire/$Nom"] {
	if { ! [file exists $Nouveau]} { continue }
	if {$Maniere=="" && [regexp "bla" $CoRepertoire]} {
	    set Maniere "AvecAligneursAvecSegAlignement"
	}
	return [AfficheFichier $Nouveau $Maniere]
    }
    FaireLire "Sorry, no file associated to\n$Source $CoRepertoire"
    return ""


}

proc AfficheBallastDuBlastP {FichierBlastP Nom} {


    set TexteBallast [Ballast $FichierBlastP [RepertoireDeTravail] "" "TexteSansFichier"]
    return [AfficheVariable $TexteBallast  "AvecGrapheAvecSegAlignementAvecAligneurs" $Nom]


}

proc AfficheBarreBoutons {} {

    global OrdEtcDir OrdMeth ListeOrdMeth FrmToolBar NomFenetreOrdali

    set FrmToolBar $NomFenetreOrdali.tbb
    frame $FrmToolBar
    grid $FrmToolBar -row 0 -column 0 -sticky ew -padx 5

    set frm $FrmToolBar

    set fbopen [file join $OrdEtcDir open.gif]
    image create photo bopen -file $fbopen
    button $frm.btopen -image bopen -command OuvrirFichierAlignementDansOrdali

    set fbclose [file join $OrdEtcDir file_close.gif]
    image create photo bclose -file $fbclose
    button $frm.btclose -image bclose -command FermeFichier

    set freload [file join $OrdEtcDir file_reload.gif]
    image create photo breload -file $freload
    button $frm.btreload -image breload -command ReLoadFichier

    set fsave [file join $OrdEtcDir "save.gif"]
    image create photo bsave -file $fsave
    button $frm.btsave -image bsave -command SauveLAlignement

    set fbcut [file join $OrdEtcDir "cut.gif"]
    image create photo bcut -file $fbcut
    button $frm.btcut -image bcut -command CutLesNoms

    set fbcopy [file join $OrdEtcDir "copy.gif"]
    image create photo bcopy -file $fbcopy
    button $frm.btcopy -image bcopy -command CopyLesNoms

    set fbpaste [file join $OrdEtcDir "paste.gif"]
    image create photo bpaste -file $fbpaste
    button $frm.btpaste -image bpaste -command PasteLesNoms

    set fbinsp [file join $OrdEtcDir "inssep.gif"]
    image create photo binsp -file $fbinsp
    button $frm.btinsp -image binsp -command "AjouteSpaceSeq"

    set fbrems [file join $OrdEtcDir "remsep.gif"]
    image create photo brems -file $fbrems
    button $frm.btrems -image brems -command "EnleveSpaceSeq"

    set fboverview [file join $OrdEtcDir overview.gif]
    image create photo boverview -file $fboverview
    button $frm.btoverview -image boverview -command AfficheOverview

    set fbannote [file join $OrdEtcDir "notepad.gif"]
    image create photo bannote -file $fbannote
    #button $frm.btannote -image bannote -command [list ChangeMode annotation]

    set fbfind [file join $OrdEtcDir "find.gif"]
    image create photo bfind -file $fbfind
    button $frm.btfind -image bfind -command [list ChangeMode search]

    set fbprint [file join $OrdEtcDir "print.gif"]
    image create photo bprint -file $fbprint
    button $frm.btprint -image bprint -command PrintSetup

    set fbtree [file join $OrdEtcDir "buildtree.gif"]
    image create photo btree -file $fbtree
set ::WOrdali(BtnArbres) $frm.bttree
    button $frm.bttree -image btree -command [list ChangeMode arbres]

    set fbclus [file join $OrdEtcDir "cluster.png"]
    image create photo bclus -file $fbclus
    button $frm.btclus -image bclus -command [list ChangeMode arbres]

    set fbeditor [file join $OrdEtcDir "editor.gif"]
    image create photo beditor -file $fbeditor
    button $frm.bteditor -image beditor -command [list ChangeMode seqlab]

    set fbo3d [file join $OrdEtcDir "ord3d.gif"]
    image create photo bo3d -file $fbo3d
    button $frm.bto3d -image bo3d -command [list ChangeMode superpose]

    grid $frm.btopen     -row 0 -column  0 -sticky w
    grid $frm.btclose    -row 0 -column  1 -sticky w
    grid $frm.btreload   -row 0 -column  2 -sticky w
    grid $frm.btsave     -row 0 -column  3 -sticky w 
    grid $frm.btprint    -row 0 -column  4 -sticky w -padx {1 5}

    grid $frm.btcut      -row 0 -column  5 -sticky w -padx {5 1}
    grid $frm.btcopy     -row 0 -column  6 -sticky w
    grid $frm.btpaste    -row 0 -column  7 -sticky w -padx {1 5}

    grid $frm.btclus     -row 0 -column  8 -sticky w -padx {5 1}
    grid $frm.btinsp     -row 0 -column  9 -sticky w
    grid $frm.btrems     -row 0 -column 10 -sticky w
    grid $frm.bttree     -row 0 -column 11 -sticky w
    grid $frm.bteditor   -row 0 -column 12 -sticky w
    grid $frm.bto3d      -row 0 -column 13 -sticky w -padx {1 5}

    grid $frm.btfind     -row 0 -column 14 -sticky w -padx {5 1}
    grid $frm.btoverview -row 0 -column 15 -sticky w
    #grid $frm.btannote   -row 0 -column 16 -sticky w

#    grid rowconfig    $frm 0   -weight 0
#    grid columnconfig $frm all -weight 1
#    grid columnconfig $frm {16 17} -weight 1
#    grid columnconfig $frm 16 -minsize $wdt

    setTooltip $frm.btopen     "Open"
    setTooltip $frm.btclose    "Close"
    setTooltip $frm.btreload   "Reload"
    setTooltip $frm.btsave     "Save"
    setTooltip $frm.btcut      "Cut"
    setTooltip $frm.btcopy     "Copy"
    setTooltip $frm.btpaste    "Paste"
    #setTooltip $frm.btundo     "Edit backward"
    #setTooltip $frm.btredo     "Edit forward"
    setTooltip $frm.btinsp     "Add separator"
    setTooltip $frm.btrems     "Remove separator"
    setTooltip $frm.btoverview "Alignment overview"
    #setTooltip $frm.btannote   "Annotate alignment"
    setTooltip $frm.btfind     "Search"
    setTooltip $frm.btprint    "Print"
    setTooltip $frm.btclus     "Cluster mode"
    setTooltip $frm.bttree     "Tree building"
    setTooltip $frm.bteditor   "Alignment Editor"
    setTooltip $frm.bto3d      "3D display"

    #update idletasks

    #MesCouleurs $frm

    return

}

proc AfficheBarreMac {} {

    global NomFenetreOrdali FrmVues WOrdali NomTextSeq ListeDesMacs

    set wv $NomFenetreOrdali.fmac
    set FrmVues $wv
    frame $FrmVues
    grid $FrmVues -row 1 -column 0 -sticky ew -padx 5 -pady {1 3}
    
    frame $wv.fcx
    grid $wv.fcx -row 0 -column 0 -sticky w
    label $wv.fcx.lmac  -text "Snapshot "  -justify left  -anchor w
    set WOrdali(combomac) $wv.fcx.cmac
    ttk::combobox $wv.fcx.cmac  -background white  -state readonly  -width 40  -textvariable ::Defauts(NmMacCourant)
    bind $WOrdali(combomac) <<ComboboxSelected>> [list MiseAJourMac]

    grid $wv.fcx.lmac -row 0 -column 0 -sticky w -padx {1 2}
    grid $wv.fcx.cmac -row 0 -column 1 -sticky w -padx {2 5}
    
    frame $wv.fbt
    grid $wv.fbt -row 0 -column 1 -sticky w -padx 20
    set WOrdali(BoutAnno) $wv.fbt.bann
    button $wv.fbt.bann  -text "Annotations"  -bg cyan  -command AfficheSnapshotAnnotations
    set WOrdali(BoutZones) $wv.fbt.bzon
    button $wv.fbt.bzon  -text "View Zone"  -bg cyan  -command [list AfficheZonesClustering]
    button $wv.fbt.binf  -text "Info"  -bg white  -command [list InfosDuMac]
    button $wv.fbt.bsav  -text "Overwrite"  -bg green1  -command [list SauveLeMac 0]
    button $wv.fbt.bres  -text "Reset"  -bg cyan  -command [list MiseAJourMac reset]
    button $wv.fbt.bkip  -text "New !"  -bg green1  -command [list SauveLeMac 1]
    
    grid $wv.fbt.bann -row 0 -column 0 -sticky w -padx {10 1}
    grid $wv.fbt.bzon -row 0 -column 1 -sticky w -padx {10 1}
    grid $wv.fbt.binf -row 0 -column 3 -sticky w -padx {1 15}
    grid $wv.fbt.bres -row 0 -column 4 -sticky w -padx 15 
    grid $wv.fbt.bsav -row 0 -column 5 -sticky w -padx {15 1}
    grid $wv.fbt.bkip -row 0 -column 6 -sticky w -padx {1 5}
    grid rowconfigure $wv 0   -weight 0
    grid columnconfig $wv all -weight 0

    return

}

proc AfficheBarreMenus {} {

    global Defauts NomFenetreOrdali Toggle FrmMenu
    global MenuFile MenuEdit MenuView MenuGroups MenuDisplay MenuStructure Toggle
    
    set bgm [set Defauts(BackAppli)]
    
    set w [winfo toplevel $NomFenetreOrdali]
    if {$w eq "."} {
	set mb ".menuBar"
    } else {
	set mb $w.menuBar
    }
    menu $mb -tearoff 0
    
    set mfi $mb.file
    set med $mb.edit
    set mvw $mb.view
    set mse $mb.sequence
    set mal $mb.alignement
    set mst $mb.structure
    set mto $mb.tools
    set min $mb.info
    set mhe $mb.help
    
    set MenuFile       $mfi
    set MenuEdit       $med
    set MenuView       $mvw
    set MenuSequence   $mse
    set MenuAlignement $mal
    set MenuStructure  $mst
    set MenuTools      $mst
    
    # create sub-menus
    menu $mfi -activebackground "#0083ffff0000" -foreground black
    menu $med -activebackground "#0083ffff0000" -foreground black
    menu $mvw -activebackground "#0083ffff0000" -foreground black
    menu $mse -activebackground "#0083ffff0000" -foreground black
    menu $mal -activebackground "#0083ffff0000" -foreground black
    menu $mst -activebackground "#0083ffff0000" -foreground black
    menu $mto -activebackground "#0083ffff0000" -foreground black
    menu $min -activebackground "#0083ffff0000" -foreground black
    menu $mhe -activebackground "#0083ffff0000" -foreground black

    # Create the munu bar itself
    $mb add cascade -label File -menu $mfi -underline 0
    $mb add cascade -label Edit -menu $med -underline 0
    $mb add cascade -label View -menu $mvw -underline 0
    $mb add cascade -label Sequences -menu $mse -underline 0
    $mb add cascade -label Alignment -menu $mal -underline 0
    $mb add cascade -label Structures -menu $mst -underline 0
    $mb add cascade -label Tools -menu $mto -underline 0
    $mb add cascade -label " ? " -menu $min -underline 1
    $mb add cascade -label Help -menu $mhe -underline 0

    # 
    # Menu file
    set mfiti "$mfi.typefilein"
    menu $mfiti -tearoff 0 -background $bgm
    $mfiti add command -label "a MSF file" -command "OuvrirFichierAlignementDansOrdali MSF"
    $mfiti add command -label "a Macsim/XML file" -command "OuvrirFichierAlignementDansOrdali XML"
    $mfiti add command -label "a TFA file" -command "OuvrirFichierAlignementDansOrdali TFA"
    $mfiti add command -label "a Clustal ALN file" -command "OuvrirFichierAlignementDansOrdali ALN"
    $mfiti add command -label "a RSF file" -command "OuvrirFichierAlignementDansOrdali RSF"
    $mfi add cascade -label "Open ..." -menu $mfiti -underline 0 -background $bgm
    $mfi add command -label "Save" -command "SauveLAlignement"
    # cascade "save as ..."
    set mfito "$mfi.typefileout"
    menu $mfito -tearoff 0
    $mfito add command -label "MSF file" -command "SauveLAlignement MSF JLeSauveAs"
    $mfito add command -label "Macsim/XML file" -command "SauveLAlignement XML JLeSauveAs"
    $mfito add command -label "TFA file" -command "SauveLAlignement TFA JLeSauveAs"
    $mfito add command -label "ALN (ClustalW) file" -command "SauveLAlignement ALN JLeSauveAs"
    $mfito add command -label "ORD file" -command "SauveLAlignement ORD JLeSauveAs"
    $mfi add cascade -label "Save as ..." -menu $mfito -underline 0
    # save window as ..
    set mfitw "$mfi.windowfileout"
    menu $mfitw -tearoff 0 -background $bgm
    $mfitw add command -label "a MSF file" -command "CreeLAlignementDeLaFenetre MSF"
    $mfitw add command -label "a TFA file" -command "CreeLAlignementDeLaFenetre TFA"
    $mfi add cascade -label "Save window as" -menu $mfitw -underline 0
    $mfi add command -label "Close" -command "FermeFichier"
    $mfi add separator
    $mfi add command -label "Add sequences ..." -command "AjouteSeqs"
    $mfi add command -label "Add PDB ..." -command "FenetreAjoutePDB"
    $mfi add separator
    $mfi add command -label "Print" -command "PrintSetup"
    $mfi add separator
    $mfi add command -label "Quit Ordalie" -command "AdieuOrdali"

    # Menu edition
    $med add command -label "Cut"   -accelerator "Ctrl-x" -command "CutLesNoms"
    $med add command -label "Copy"  -accelerator "Ctrl-c" -command "CopyLesNoms"
    $med add command -label "Paste" -accelerator "Ctrl-v" -command "PasteLesNoms"
    $med add separator
    $med add command -label "Preferences" -command "AffichePreferences2"

    # Menu View
    $mvw add command -label "Bigger font" -accelerator "Ctrl-plus" -command "TailleFonte +2"
    $mvw add command -label "Smaller font" -accelerator "Ctrl-minus" -command "TailleFonte -2"
    $mvw add separator
    $mvw add command -label "Open Log Console" -command "ToggleAuLog"
    # output log cascade
    set mvwol $mvw.outlog
    menu $mvwol -tearoff 0 -background $bgm
    $mvwol add command -label "HTML" -command {AuLog LOutput HTML}
    $mvwol add command -label "Text" -command {AuLog LOutput Text}
    $mvw add cascade -label "Output Log as ..." -menu $mvwol
    $mvw add separator
    $mvw add command -label "Toggle Full-screen mode" -command "ToggleFullScreen"
    $mvw add separator

    set Toggle(AllSeqs) [set Defauts(ToggleAllSeqs)]
    set Toggle(ToolBar) [set Defauts(ToggleToolBar)]
    set Toggle(Feature) [set Defauts(ToggleFeature)]
    set Toggle(Scores)  [set Defauts(ToggleScores)]
    set Toggle(AuLog)   [set Defauts(ToggleAuLog)]
    set Toggle(ColRes)  [set Defauts(ToggleColRes)]

    $mvw add checkbutton -label "Show/Hide Icon Bar" -variable Toggle(ToolBar) -command ToggleToolbar
    $mvw add checkbutton -label "Show/Hide Scores" -variable Toggle(Scores) -command ToggleScores
    $mvw add checkbutton -label "Show/Hide Features" -variable Toggle(Feature) -command ToggleFeature

    #
    # Menu sequence
    #
    set msena "$mvw.nomsaff"
    $mse add cascade -label "Names as " -menu $msena -underline 0 -background $bgm
    menu $msena -tearoff 0 -background [set Defauts(BackAppli)]
    $msena add command -label "Seq. Name" -command "AutresNomsAff seqname"
    $msena add command -label "Accession Number" -command "AutresNomsAff access"
    $msena add command -label "Bank Id" -command "AutresNomsAff bid"
    $msena add command -label "Organism" -command "AutresNomsAff organism"
    $msena add command -label "Gen.sp" -command "AutresNomsAff gen.sp"
    $mse add separator
    $mse add command -label "Identity tool" -command "ChangeMode donnepci" -accelerator "Shift I"
    $mse add command -label "Search motif"  -command "ChangeMode search"
    $mse add separator
    $mse add command -label "Retrieve Seq. info" -command "CheckInfosSeqs"
    $mse add command -label "Browse Seq. info" -command "MontreInfoSeq"
    $mse add command -label "Edit Seq. info" -command "EditInfoSeq"
    $mse add command -label "Sequence VRP" -command "Ordali_Vrp"
    $mse add separator
    $mse add checkbutton -label "Show/Hide Phylum" -variable Defauts(AffPhy) -command "ColorieNomsSelonPhylum"
    $mse add checkbutton -label "Show/Hide group colors" -variable Defauts(AffGrp) -command "ColorieNomsSelonGroupes"
    $mse add checkbutton -label "Show/Hide Sec. Str." -variable Defauts(AffSS) -command ToggleSecStr

    #
    # Menu alignement
    #
    $mal add command -label "Create Macsims ..." -command CreateAndDisplayMacsims
    ##$mal add command -label "Names Of Clusters" -command "NamesOfClusters"
    $mal add separator
    $mal add command -label "Re-align sequences" -command ReAlignSeqs 
    $mal add separator
    $mal add command -label "Editor" -command "ChangeMode seqlab" -accelerator "Shift E"
    $mal add command -label "Overview" -command "AfficheOverview"
    $mal add command -label "Conservation" -command "ChangeMode conservation" -accelerator "Shift C"
    $mal add command -label "Tree Mode" -command "ChangeMode arbres" -accelerator "Shift T"
    $mal add command -label "Features Summary" -command "FeatureSummary"
    $mal add command -label "Features Editor" -command "ChangeMode feateditor"
    $mal add command -label "Annotate snapshot" -command "ChangeMode annotation"
    $mal add command -label "Barcode" -command BarcodeAlignment
    $mal add separator
    $mal add command -label "Clustering" -command "ChangeMode cluster" -accelerator "Shift G"
    $mal add command -label "Add separator" -command "AjouteSpaceSeq"
    $mal add command -label "Remove separator" -command "EnleveSpaceSeq"
    $mal add command -label "Remove All separators" -command "NettoieAffichage"
    $mal add separator
    $mal add command -label "Toggle physicochem. col." -command "ToggleCouleursResidues"

    #
    # Menu structure
    #
    $mst add command -label "Superpose Structures" -command [list ChangeMode superpose]
    $mst add separator
    $mst add command -label "Display Structures" -command "VisualiseStructure"
    $mst add separator
    $mst add command -label "Color Sec. Str by identity" -command "ColorieSSSelonConservation"
    $mst add separator
    $mst add command -label "Save PDB" -command "SauveLesPDB"
    
    # menu tools
    $mto add command -label "Profile identity" -command IdentityProfileGUI

    # Menu info
    $min add command -label "About Ordali" -command "InfosSurOrdali"

    # Menu help
    #$mhe add command -label "Help on Ordali" -command "LanceDoc"
    $mhe add command -label "local Ordalie documentation" -command "LanceDoc local"
    $mhe add command -label "On-line Ordalie documentation" -command "LanceDoc internet"
    $mhe add command -label "Ordalie PDF documentation" -command "LanceDoc"

    [winfo toplevel $NomFenetreOrdali] configure -menu $mb
    
    return

}

proc AfficheBilanXHda {{Selection ""}} {



    global RepertoireDuGenome
 
    Wup "Affiche parmi la liste des bilans, ceux voulus"
   
    set RepBilan "$RepertoireDuGenome/bilan_xhda"
    
    if {$Selection==""} {
	foreach FichierBilan [glob -nocomplain "$RepBilan/*"] {
	    set LeBilan [File tail $FichierBilan]
	    lappend LesBilans $LeBilan
	}
	set Selection [ChoixDesPresents [lsort $LesBilans]]
    }
    set Selection [join $Selection "\n"]

    return [CreeEtAfficheUnBilanHDACroises $Selection]


}

proc AfficheBootstrap {AId n} {


    set t   [set ::Abr(Arbre,$AId)]
    if {[$t isleaf $n]} {return}

    foreach e [$t children $n] {
	AfficheBootstrap $AId $e
    }
    if {$n eq "root"} {return}

    set PAD  [set ::Abr($AId,PAD)]
    set ir   [$t get $n IdRot]
    set Lbox [$PAD bbox $ir]

    MarqueBootstrap $AId $n $Lbox $ir

    return

}

proc AfficheBoutonsAnnotation {} {

    global FrmBouton Anno NomTextSeq WOrdali

    if {[TypeAli] eq "pasdali"} {return}

    set wp "${FrmBouton}.fanno"
    frame $wp -relief sunken  -bd 2
    grid $wp -row 0 -column 1 -sticky ew

    grid rowconfig    $wp all       -weight 0
    grid columnconfig $wp {0 2 3 4} -weight 0
    grid columnconfig $wp 1         -weight 1

    # Inits
    UpdateVisibleAnnotations
    set Lcol [set ::Couleurs(Stock)]
    set Anno(Color) [lindex $Lcol 0]
    set Anno(NtagCou) ""

    # GUI
    frame $wp.fshow
    label $wp.fshow.label  -text "Show : "
    set wdt [PlusLongEltDe $Anno(Lnoms)]
    ttk::combobox $wp.fshow.combo  -state readonly  -values $Anno(Lnoms)  -width $wdt  -textvariable Anno(Nom)
    bind $wp.fshow.combo <<ComboboxSelected>> [list ShowAnnotation]

    grid $wp.fshow.label -row 0 -column 0
    grid $wp.fshow.combo -row 0 -column 1
    
    set wcol [PlusLongEltDe $Lcol]
    set WaOrdali(ComboColAnno) $wp.ccol
    ttk::combobox $wp.ccol  -state readonly  -width $wcol  -values $Lcol  -textvariable Anno(Color)
    #bind $wp.ccol <<ComboboxSelected>> [list ChangeCouleurAnnotation]
    button $wp.bcre  -text "Create"  -bg cyan  -command [list AjouteAnnotation]
    button $wp.bedt  -text "Edit"  -bg cyan  -command [list EditeAnnotation]
    frame $wp.tmp1
    label $wp.tmp1.lnom  -text "Name "  -relief flat
    entry $wp.tmp1.enom  -font "Helvetica 10"  -width 16  -bg white -fg black  -textvariable Anno(Nom)
    label $wp.lano  -text "Annotation : "  
    frame $wp.tmp2
    grid rowconfig $wp.tmp2 0 -weight 1
    set Anno(WText) $wp.tmp2.txt
    text $wp.tmp2.txt  -width 10 -height 3  -font "Helvetica 10"  -bg white  -yscrollcommand "$wp.tmp2.scr set"  -state normal
    scrollbar $wp.tmp2.scr  -width 8  -command "$wp.tmp2.A1AAAtxt yview "
    button $wp.badd  -bg yellow  -text " Add "  -command [list AjouteAnnotation %W]
    button $wp.bdel  -bg red  -text "Delete"  -command [list DetruitAnnotation]
    button $wp.bret  -bg green1  -text "Return"  -command [list QuitteAnnotation]
    
    grid columnconfig $wp.tmp1 1 -weight 1
    grid $wp.tmp1.lnom -row 0 -column 0 -sticky w
    grid $wp.tmp1.enom -row 0 -column 1 -sticky ew

    grid columnconfig $wp.tmp2 0 -weight 1
    grid $wp.tmp2.txt  -row 0 -column 0 -sticky news 
    grid $wp.tmp2.scr  -row 0 -column 1 -sticky ns
    
    grid $wp.lano -row 0 -column 0 -sticky w
    #grid $wp.tmp1 -row 0 -column 0 -sticky ew
    grid $wp.tmp2 -row 0 -column 1 -rowspan 3 -sticky ew

    grid $wp.ccol -row 0 -column 2 -sticky w -padx {30 60}
    grid $wp.bcre -row 1 -column 2 -rowspan 2 -sticky news -padx {30 60}

    #grid $wp.fshow -row 0 -column 2 -sticky w -padx 10
    #grid $wp.bedt  -row 1 -column 2 -sticky w -padx 10

    #grid $wp.badd -row 0 -column 4 -sticky e
    #grid $wp.bdel -row 1 -column 4 -sticky e
    grid $wp.bret -row 0 -column 3 -rowspan 3 -sticky e -padx 10

    $::NomTextSeq tag configure selZone -background lightblue

    bind $NomTextSeq <ButtonPress-1> [list PositionAnnotation %W %x %y "debut"]
    bind $NomTextSeq <B1-Motion>     [list PositionAnnotation %W %x %y "move"]
    bind $NomTextSeq <ButtonRelease-1> [list PositionAnnotation %W %x %y termine]
    bind $NomTextSeq <Control-1> {PositionAnnotation %W %x %y delete ; break}

    tkwait window $wp
    
    return

}

proc AfficheBoutonsArbres {} {

    global Defauts FrmBouton NomTextSeq ZoneTree ZoneSelect ListeTypesDeFeatures WOrdali
    
    # pre-definit variables
    set lg [LongueurAlignement]
    set lgd [expr {double($lg)}]
    set Defauts(TreeNBoot) [expr {int($lgd*1.15)}]
    while {$Defauts(TreeNBoot) % 10} {
	incr Defauts(TreeNBoot)
    }
    
    # mise en place boutons
    set w $FrmBouton
    set ws $w.treesel
    frame $ws -relief sunken -bd 2
    grid $ws -row 0 -column 1 -sticky news -pady 5
    
    frame $ws.falcl
    grid $ws.falcl -row 0 -column 0 -sticky nw -padx 5 -pady 5
    
    label $ws.falcl.lbf  -anchor w  -justify left  -text "Feature :"
    if {! [info exists ListeTypesDeFeatures]} {
	set ListeTypesDeFeatures {}
    }
    set wdt [PlusLongEltDe $ListeTypesDeFeatures]
    set LesTypes [linsert $ListeTypesDeFeatures 0 "None"]
    set Tree(Combo) $ws.falcl.cft
    ttk::combobox $ws.falcl.cft  -state readonly  -width $wdt  -background white  -values $LesTypes  -textvariable TreeFeat
    set WOrdali(Tree,SelectAll) $ws.falcl.sal 
    $ws.falcl.cft current 0
    bind $ws.falcl.cft <<ComboboxSelected>> [list ChangeFeature %W]
    button $ws.falcl.cle  -text "Clear"  -background white  -command "DeselectToutesLesColonnes "
    button $ws.falcl.sal  -text "Select All"  -background cyan  -command "SelectionneToutesColonnes"
    
    grid $ws.falcl.lbf -row 0 -column 0 -sticky ew
    grid $ws.falcl.cft -row 0 -column 1 -sticky ew
    grid $ws.falcl.cle -row 1 -column 0 -sticky ew
    grid $ws.falcl.sal -row 1 -column 1 -sticky ew
    grid columnconfig $ws.falcl 1 -weight 1
    
    frame $ws.frmsst
    grid $ws.frmsst -row 0 -column 1 -sticky nw -padx 5 -pady 5
    checkbutton $ws.frmsst.pdb  -text "with PDB seq"  -anchor w -justify left  -variable Defauts(PDBTree)  -onvalue 1  -offvalue 0
    checkbutton $ws.frmsst.gap  -text "Pairwise / Global"  -anchor w -justify left  -variable Defauts(TypeGapTree)  -onvalue "pairwise"  -offvalue "global"
    button $ws.frmsst.loe  -text "Load Tree"  -background white  -command LoadUnArbre
    grid $ws.frmsst.pdb -row 0 -column 0 -sticky ew
    grid $ws.frmsst.gap -row 1 -column 0 -sticky ew
    grid $ws.frmsst.loe -row 0 -column 1 -sticky ew -padx 20
    grid columnconfig $ws.frmsst 0 -weight 1
    
    frame $ws.fbtp
    grid $ws.fbtp -row 0 -column 2 -sticky nw -padx 5 -pady 5
    set WOrdali(Tree,Bootstrap) $ws.fbtp.ynbtp 
    checkbutton $ws.fbtp.ynbtp  -text "Bootstrap"  -anchor w -justify left  -variable Defauts(TreeBoot)  -onvalue 1  -offvalue 0
    entry $ws.fbtp.nbbtp  -justify right  -width 5 -bg white  -textvariable Defauts(TreeNBoot)
    grid $ws.fbtp.ynbtp -row 0 -column 0 -sticky ew
    grid $ws.fbtp.nbbtp -row 1 -column 0 -sticky ew
    grid columnconfig $ws.fbtp 0 -weight 1
    
    set wc "$ws.control"
    frame $wc
    grid $wc -row 0 -column 3 -sticky ne -padx 5 -pady 5
    set WOrdali(Tree,Draw) $wc.fin
    button $wc.fin  -text "Draw"  -background green1  -command "CalculeUnArbre"
    button $wc.dis  -text "Return"  -background orange  -command "destroy $ws"
    grid $wc.fin -row 0 -column 0 -sticky news -padx 20
    grid $wc.dis -row 0 -column 1 -sticky news
    grid columnconfig $wc 0 -weight 1

    grid columnconfig $ws all -weight 1
    
    # bindings
    BindModeSelection
    if {! [info exists ZoneTree]} {
	set ZoneTree {}
    } else {
	set ZoneSelect $ZoneTree
    }
    AfficheZonesSelectionnees $ZoneTree
    StockPosition

    MesCouleurs $FrmBouton

    tkwait window $ws

    $NomTextSeq tag remove slct 1.0 end

    return

}

proc AfficheBoutonsCherche {{prevMode ""}} {

    global FrmBouton Chrc

    # setup window pour AfficheModeCherche
    set Chrc(NbrOccus)  "0 found"
    set Chrc(Motif)    ""
    set Chrc(LOccus)   {}
    set Chrc(IdxMotif) {}
    set Chrc(prevMode) $prevMode
    
    set ws "$FrmBouton.fsearch"
    frame $ws -relief sunken -bd 2
    grid $ws -row 0 -column 1 -sticky news -pady 5
    
    frame $ws.fse
    label $ws.fse.lbl1  -text "Search a sequence motif"  -justify left -anchor w
    label $ws.fse.lbl2  -text "Motif :"  -anchor w -justify left
    entry $ws.fse.ent  -background white  -width 20  -textvariable Chrc(Motif)
    button $ws.fse.sea  -text "Search"  -background yellow  -command "ChercheMotif"
    label $ws.fse.lbnb  -anchor w -justify right  -textvariable Chrc(NbrOccus)
    grid $ws.fse.lbl1 -row 0 -column 0 -columnspan 2 -sticky nw
    grid $ws.fse.lbl2 -row 1 -column 0 -sticky nw
    grid $ws.fse.ent  -row 1 -column 1 -sticky nw 
    grid $ws.fse.sea  -row 0 -rowspan 2 -column 2 -sticky nsw
    grid $ws.fse.lbnb -row 0 -rowspan 2 -column 3 -sticky nsw -ipadx 5
    grid $ws.fse -row 0 -column 0 -sticky nw -pady 2 -padx 2 -ipadx 5
    grid columnconfig $ws.fse 1 -weight 1
    
    frame $ws.frbt
    button $ws.frbt.next  -text "Find Next"  -background cyan  -command ChercheMotifSuivant
    button $ws.frbt.dismiss  -text "Return"  -background orange  -command "FinCherche"
    grid $ws.frbt.next    -row 0 -column 0 -sticky nsw
    grid $ws.frbt.dismiss -row 0 -column 1 -sticky nse
    grid $ws.frbt -row 0 -column 1 -sticky news -padx {20 2}
    grid columnconfig $ws.frbt 1   -weight 1
    grid rowconfig    $ws.frbt all -weight 1
    grid columnconfig $ws 1 -weight 1 
    
    bind $ws.fse.ent <Return> {$FrmBouton.fsearch.fse.sea invoke}
    
    MesCouleurs $FrmBouton
    focus $ws.fse.ent
    
    tkwait window $ws

    return

}

proc AfficheBoutonsClusters {} {

    global FrmBouton NomTextSeq ZoneClusterisation ListeTypesDeFeatures Clus

    set ws $FrmBouton.clusel
    frame $ws  -relief sunken  -bd 2
    grid $ws -row 0 -column 1 -sticky news -pady 5
    grid columnconfig $FrmBouton 1 -weight 1

    set Clus(Title) "Give a Title to your clustering"
    set Clus(ShowSeqOut) 1
    set Clus(NewEntry) 1

    # Features/Clear/Select All
    frame $ws.fs
    grid $ws.fs -row 0 -column 0 -sticky w -padx 5 -pady 5
    label $ws.fs.lbf  -anchor w -justify left  -text "Feature :"
    if {! [info exists ListeTypesDeFeatures]} {
	set ListeTypesDeFeatures {}
    }
    set LesTypes [linsert $ListeTypesDeFeatures 0 "None"]
    set wdt [PlusLongEltDe $LesTypes]
    set Clus(Combo) $ws.fs.cft
    ttk::combobox $ws.fs.cft  -state readonly  -width $wdt  -background white  -values $LesTypes  -textvariable ClusFeat
    button $ws.fs.sal  -text "Select All"  -background cyan  -command [list SelectionneToutesColonnes]
    button $ws.fs.cle  -text "Clear"  -background white  -command [list DeselectToutesLesColonnes]
    grid $ws.fs.lbf -row 0 -column 0 -sticky we
    grid $ws.fs.cft -row 0 -column 1 -sticky we
    grid $ws.fs.cle -row 1 -column 0 -sticky we
    grid $ws.fs.sal -row 1 -column 1 -sticky we
    grid columnconfig $ws.fs 0 -weight 1
    
    # Criterion
    frame $ws.fv
    grid $ws.fv -row 0 -column 1 -sticky e -padx 5 -pady 5
    label $ws.fv.lctr  -text "Criterions : "  -relief flat  -anchor w -justify right
    menubutton $ws.fv.mctr  -relief raised  -text "Choose ..."  -direction above  -menu $ws.fv.mctr.criteres
    menu $ws.fv.mctr.criteres -tearoff 0
    foreach f {"% identity" "length" "hydrophobicity" "pI" "aa composition"} {
	$ws.fv.mctr.criteres add checkbutton -label "$f" -variable Clus(LCrit,$f) -onvalue 1 -offvalue 0 
    }
    set lfdm "Life Domain"
    set Clus(LCrit,$lfdm) 0
    $ws.fv.mctr.criteres add separator
    $ws.fv.mctr.criteres add command -label "Life Domain" -command {set lfdm "Life Domain" ; set ::Clus(LCrit,$lfdm) [expr {! [set ::Clus(LCrit,$lfdm)]}] ; update}
    # clustering methods
    label $ws.fv.lmet  -text "Method : "  -relief flat  -anchor w -justify right
    set Lmeth [list "kmeans / DPC" "hierarchic / secator" "mixture model / AIC" "mixture model / BIC"]
    ttk::combobox $ws.fv.cmet  -state readonly  -values $Lmeth  -textvariable Clus(Method)
    #bind $ws.fv.cmet <<ComboboxSelected>> NouveauClustering

    grid $ws.fv.lctr -row 0 -column 0 -sticky e
    grid $ws.fv.mctr -row 0 -column 1 -sticky ew
    grid $ws.fv.lmet -row 1 -column 0 -sticky e
    grid $ws.fv.cmet -row 1 -column 1 -sticky ew
    
    # Run
    button $ws.run  -text "Compute"  -background yellow  -command NouveauClustering
    grid $ws.run -row 0 -column 2 -rowspan 2 -sticky ns -padx 5 -pady 5

    # controls
    frame $ws.fc 
    grid $ws.fc -row 0 -column 3 -sticky e -padx 5 -pady 5
    grid columnconfig $ws.fc 0 -weight 1
    button $ws.fc.ori  -text "Reset"  -background green1  -command [list DefinitionGroupes integral]
    button $ws.fc.noc  -text "No Clusters"  -background yellow  -command [list NouveauClustering nogroups]

    grid $ws.fc.ori -row 0 -column 0 -sticky we -padx 5
    grid $ws.fc.noc -row 1 -column 0 -sticky ns -padx 5

    # Dismiss/New/Overwrite
    frame $ws.fb    
    grid $ws.fb -row 0 -column 4 -sticky e -padx 5 -pady 5
    grid columnconfig $ws.fb 0 -weight 1
    button $ws.fb.cnm  -text "Clusters\nNames"  -bg cyan  -command {NamesOfClusters}
    button $ws.fb.fin  -text " Save "  -background green1  -command GardeClustering
    button $ws.fb.dis  -text "Return"  -background green1  -command [list QuitteModeClusters $ws]
    grid $ws.fb.cnm -row 0 -column 0 -rowspan 2 -sticky ns -padx 5
    grid $ws.fb.fin -row 0 -column 1 -sticky ew -padx 5
    grid $ws.fb.dis -row 1 -column 1 -sticky ew -padx 5

    grid columnconfig $ws all -weight 1
    grid rowconfig    $ws all -weight 0

    $ws.fs.cft current 0
    bind $ws.fs.cft <<ComboboxSelected>> [list ChangeFeature %W]

    #update idletasks

    # bindings
    if {! [info exists ZoneClusterisation]} {set ZoneClusterisation ""}
    AfficheZonesSelectionneesCluster
    StockPosition
    BindModeSelection

    # Tags Specifiques
    $::NomNomSeq tag configure SLock -foreground black -background grey

    MesCouleurs $FrmBouton
    
    tkwait window $ws

    BindModeNormal
    
    return

}

proc AfficheBoutonsConservation {} {

    global FrmBouton Cons Defauts
    
    set ws $FrmBouton.cons
    frame $ws -relief sunken -bd 2
    grid $ws -row 0 -column 1 -sticky news -pady 5
    grid columnconfig $ws 1 -weight 1
    
    set wx "$ws.chx"
    frame $wx
    grid $wx -row 0 -column 0 -sticky nw -padx 2 -pady {2 5}
    grid columnconfig $wx 1 -weight 1
    
    label $wx.lmth  -text "Method : "  -anchor w -justify left
    set ListeOrdMeth [list "Threshold" "Liu" "Mean Distances" "Vector Norm" "Multi" "BILD"]
    set wdt [PlusLongEltDe $ListeOrdMeth]
    ttk::combobox $wx.smth  -width $wdt  -background white  -state readonly  -textvariable Cons(Method)  -values $ListeOrdMeth
    $wx.smth current 0
    bind $wx.smth <<ComboboxSelected>> [list set ::Cons(Title) ""]
    label $wx.ltt  -text "Title : "  -anchor w -justify left 
    set Cons(Entry) $wx.tit
    entry $wx.tit  -bg white  -textvariable Cons(Title)  -width 20
    
    set Cons(OnlyGlobal) 0
    checkbutton $wx.glo  -text "only global"  -anchor w -justify left  -relief flat  -onvalue 1  -offvalue 0  -variable Cons(OnlyGlobal)
    
    set Cons(PDB) 0
    checkbutton $wx.pdb  -text "include PDB"  -anchor w -justify left  -relief flat  -variable Cons(PDB)  -onvalue 1  -offvalue 0
    
    grid $wx.lmth -row 0 -column 0 -sticky new
    grid $wx.smth -row 0 -column 1 -sticky new
    grid $wx.ltt  -row 1 -column 0 -sticky new
    grid $wx.tit  -row 1 -column 1 -sticky new
    grid $wx.pdb  -row 0 -column 2 -sticky new
    grid $wx.glo  -row 1 -column 2 -sticky new
    
    set wc "$ws.control"
    frame $wc
    grid $wc -row 0 -column 1 -sticky nsw -padx 2 -pady 2
    grid columnconfig $wc 2   -weight 1
    button $wc.run  -text "Compute"  -bg yellow  -command [list LanceCalculConservation]
    set Cons(Show) [set ::Toggle(Scores)]
    update
    checkbutton $wc.shh  -text "Show scores "  -anchor w -justify left  -relief flat  -onvalue 1  -offvalue 0  -variable Cons(Show)
    label $wc.lal  -text "Show : "  -anchor w -justify left
    set Cons(ConsCou) "None"
    set Cons(ListeCons) [list "None"]
    set wdt [PlusLongEltDe $Cons(ListeCons)]
    set Cons(ComboSel) $wc.call
    ttk::combobox $wc.call  -width $wdt  -background white  -state readonly  -textvariable Cons(ConsCou)  -values $Cons(ListeCons)
    $wc.call current 0
    bind $wc.call <<ComboboxSelected>> [list ChangeConservation]
    
    grid $wc.run  -row 0 -rowspan 2 -column 0 -sticky nsw -ipadx 5
    grid $wc.lal  -row 0 -column 1 -sticky nw 
    grid $wc.call -row 0 -column 2 -sticky new 
    grid $wc.shh  -row 1 -column 1 -columnspan 2 -sticky new -ipadx 5
    grid rowconfig    $wc all -weight 1

    # frame save/return
    set wb "$ws.sds"
    frame $wb
    grid $wb -row 0 -column 2 -sticky nse -padx 2 -pady 2
    button $wb.save  -text " Save "  -bg green1  -command [list SauveConservation]
    button $wb.dis  -text "Return"  -background green1  -command [list QuitteModeConservation $ws]
    grid $wb.save -row 0 -column 0 -sticky new
    grid $wb.dis  -row 1 -column 0 -sticky new

    update idletasks
    trace add variable Cons(PDB) write PrendPDBDansPilier
    trace add variable Cons(Show) write ToggleScores
    trace add variable Cons(ConsCou) write ToggleScores

    tkwait window $ws

    return

}

proc AfficheBoutonsFeateditor {} {

    global FrmBouton ListeTypesDeFeatures EFeat TabSF TSFori LTFori NomTextSeq

    if {! [ModeI]} {return}

    if {[info exists TabSF]} {
	# TSFori est une sauvegarde !!
	array set TSFori [array get TabSF]
	set LTFori $ListeTypesDeFeatures
    } else {
	array set TSFori {}
	set LTFori [list]
    }

    set wb $FrmBouton
    set ws "$wb.select"
    frame $ws -relief sunken -bd 2
    grid $ws -row 0 -column 1 -sticky news -pady 5 -padx 5

    # Utilise features presentes
    label $ws.lbf  -anchor w  -justify left  -text "Feature :"
    if {! [info exists ListeTypesDeFeatures]} {
	set ListeTypesDeFeatures {}
    }
    set EFeat(FTypes) [linsert $ListeTypesDeFeatures 0 "None"]
    set wdt [PlusLongEltDe $ListeTypesDeFeatures]
    set EFeat(FeatCombo) $ws.cft
    ttk::combobox $ws.cft  -state readonly  -width $wdt  -background white  -values $EFeat(FTypes)  -textvariable EFeat(Feat)
    $ws.cft current 0
    bind $ws.cft <<ComboboxSelected>> [list ChangeFeatureForEditing %W]
    button $ws.bnw  -text "Clear selection"  -bg cyan -anchor w  -command [list CmdsMenuFeatures "clearsel"]
    button $ws.bdf  -text "Delete Feature"  -bg yellow  -command {DeleteFeature all ""}

    grid $ws.lbf -row 0 -column 0 -sticky ew
    grid $ws.cft -row 0 -column 1 -sticky ew
    grid $ws.bnw -row 1 -column 0 -sticky ew -columnspan 2
    grid $ws.bdf -row 0 -column 2 -sticky ew -padx 3

    # frame boutons fichier feat/fet summary
    frame $wb.fffs
    set wff $wb.fffs
    grid $wff -row 0 -column 2 -rowspan 2 -sticky nws -padx 10 -pady 5
    button $wff.ff  -text "Load feat. file"  -background white  -command [list ReadRawFeatureFile]
    button $wff.sm  -text "Feature summary"  -background cyan  -command [list FeatureSummary]

    grid $wff.ff -row 0 -column 0 -sticky nsw -padx 5
    grid $wff.sm -row 0 -column 1 -sticky nse -padx 5

    # frame boutons OK / dismiss
    frame $wb.fokdm
    set wok $wb.fokdm
    grid $wok -row 0 -column 3 -sticky ne -padx 5 -pady 5
    button $wok.ok  -text " Save "  -background green1  -command [list RetourEditFeatures save]
    button $wok.dismiss  -text "Cancel"  -background red  -command [list RetourEditFeatures dismiss]

    grid $wok.ok      -row 0 -column 0 -sticky ew
    grid $wok.dismiss -row 1 -column 0 -sticky ew
    grid columnconfig $wok all -weight 0
    grid rowconfig    $wok all -weight 1

    # bindings pour edit features
    # menu contextuel
    BindingsFeatEditor
    set EFeat(LItemSel) [list]
    set EFeat(ContextMenu) $NomTextSeq.ctxm
    CreateContextMenuFeature 
    bind $NomTextSeq <Button-3> [list ShowContextMenuFeat]

    # Selection de zones 
    $NomTextSeq configure -state normal
    $NomTextSeq tag configure slct -background LightGrey -foreground black
    $NomTextSeq configure -state disabled

    # some inits
    set EFeat(BindInit) [bindtags $NomTextSeq]
    set EFeat(Score) ""
    set EFeat(Note) ""
    set EFeat(Color) ""
    set EFeat(Name) ""
    set EFeat(Lx1x2) ""
    set EFeat(ZoneX1) ""
    set EFeat(ZoneX2) ""
    set EFeat(LItemSel) ""

    tkwait window $ws

    return

}

proc AfficheBoutonsFeatures {} {

    global FrmBouton FrmBtnFea ListeTypesDeFeatures Defauts OrdEtcDir NomNomSeq NomTextSeq EtatBtnFeat

    if {! [ModeI]} {return}

    set law $FrmBouton
    set wb "$FrmBouton.lesbt"
    set FrmBtnFea $wb
    frame $wb -relief sunken -bd 2
    grid $wb -row 0 -column 1 -sticky news -pady 5

    set LFeature [lsort -unique $ListeTypesDeFeatures]
    if {"Clear" ni $LFeature} {
	lappend LFeature "Clear"
    }

    set NFeat [llength $LFeature]
    set wdt [winfo reqwidth $NomTextSeq]
    set lg 0
    foreach f $LFeature {
	incr lg [expr {[string length $f] + 2}]
    }

    set Fs [font measure BtnFeatFont "Z"]
    set Npl [expr {floor($wdt/(($lg/$NFeat)*$Fs))}]

    set i 0 ; set j 0
    foreach f $LFeature {
	set flo [string tolower $f]
	regsub -all " " $flo "" fnsp
	if {[regexp {^Score\-} $f]} {
	    set bg yellow
	} else {
	    set bg green1
	}

	button ${wb}.$fnsp  -background $bg  -foreground black  -font BtnFeatFont  -text "$f"  -command [list ColorieSelonFeature $f $wb.$fnsp]
	grid $wb.$fnsp  -padx 2 -pady 1  -row $i -column $j  -sticky ew
	update

	incr j
	if {$j >= $Npl} {
	    set j 0
	    incr i
	}
	if {! [info exists EtatBtnFeat($wb.$fnsp)]} {
	    set EtatBtnFeat($wb.$fnsp) 0
	} elseif {[EtatDuBouton "$wb.$fnsp"]} {
	    EnfonceBtnFeature $wb.$fnsp
	}
    }
    grid rowconfig    $wb all -weight 0 -minsize 0
    grid columnconfig $wb all -weight 1 -minsize 0
    update

    lassign [grid bbox $wb] t a x y 
    lassign [grid size $wb] c r 
    if {$c == 1} {set c 2}
    set wdt [winfo width $FrmBtnFea]
    set px [expr {floor(($wdt-$x)/($c-1)/2)}]
    foreach e [grid slaves $wb] {
	#grid configure $e -ipadx $px
	if {[$e cget -text] eq "Clear"} {$e configure -background white}
    }

    MesCouleurs $FrmBouton

    return

}

proc AfficheBoutonsOrdali {} {

    global boutordali boutreport FrmBouton menustatus

    if {! [ModeI]} {return}

    set wb "$FrmBouton.flab"
    frame $wb -relief sunken -bd 2
    grid $wb -row 0 -column 1 -sticky news -pady 5

    set boutordali $wb.label

    label $wb.label  -textvariable menustatus  -relief sunken  -bd 2  -anchor w  -bg white  -justify left  -font "Helvetica 12"
    grid $wb.label -row 0 -column 0 -sticky ew -padx 2 -pady 1
    grid columnconfig $wb all -weight 1 -minsize 0

    set menustatus "Hummm ..... \nEverything seems OK ....\nLet's go !"

    MesCouleurs $FrmBouton

    return

}

proc AfficheBoutonsPCI {} {

    global LNOrdali FrmBouton OrdEtcDir nsq1 nsq2 pciLbl pl1Lbl pl2Lbl LesPCI ListeTypesDeFeatures ZoneSelect ZonePCI

    if {[TypeAli] eq "pasdali"} {return}
    
    set LNoms "Select"
    foreach n $LNOrdali {
	if {$n ne ""} {lappend LNoms $n}
    }
    set LMx [PlusLongEltDe $LNoms]
    
    set wp "$FrmBouton.fpci"
    frame $wp  -relief sunken  -bd 2
    grid $wp -row 0 -column 1 -sticky ew -pady 5
    grid columnconfig $wp {1 2 3} -weight 1
    
    frame $wp.falcl
    label $wp.falcl.lbf  -anchor w  -justify left  -text "Feature :"
    if {! [info exists ListeTypesDeFeatures]} {
	set ListeTypesDeFeatures {}
    }
    set EPCI(FTypes) [linsert $ListeTypesDeFeatures 0 "None"]
    set wdt [PlusLongEltDe $EPCI(FTypes)]
    set EPCI(FeatCombo) $wp.falcl.cft
    ttk::combobox $wp.falcl.cft  -state readonly  -width $wdt  -background white  -values $EPCI(FTypes)  -textvariable EPCI(Feat)
    $wp.falcl.cft current 0
    bind $wp.falcl.cft <<ComboboxSelected>> [list ChangeFeatureForEditing %W]
    button $wp.falcl.cle  -text "Clear"  -background white  -command "DeselectToutesLesColonnes "
    button $wp.falcl.sal  -text "Select All"  -background cyan  -command "SelectionneToutesColonnes"
    grid $wp.falcl.lbf -row 0 -column 0 -sticky ew
    grid $wp.falcl.cft -row 0 -column 1 -sticky ew
    grid $wp.falcl.cle -row 1 -column 0 -sticky ew
    grid $wp.falcl.sal -row 1 -column 1 -sticky ew
    grid $wp.falcl -row 0 -column 0 -sticky nw -padx 2
    grid columnconfig $wp.falcl 1 -weight 1
    
    button $wp.bdo  -background yellow  -text "Compute"  -command [list ComputeIdentity]
    grid $wp.bdo -row 0 -column 1 -sticky nsw -padx 20 -pady 5
    
    set nsq1 [lindex $LNoms 0]
    set nsq2 [lindex $LNoms 0]
    set pciLbl "Identity :"
    set pl1Lbl "length 1 :"
    set pl2Lbl "length 2 :"
    
    frame $wp.fse
    ttk::combobox $wp.fse.sq1  -background white  -width $LMx -height 10  -state readonly  -values $LNoms  -textvariable nsq1
    $wp.fse.sq1 current 0
    bind $wp.fse.sq1 <<ComboboxSelected>> {CherchePCI %W}
    ttk::combobox $wp.fse.sq2  -background white  -width $LMx -height 10  -state readonly  -values $LNoms  -textvariable nsq2
    $wp.fse.sq2 current 0
    bind $wp.fse.sq2 <<ComboboxSelected>> {CherchePCI %W}
    label $wp.fse.lpci  -textvariable pciLbl  -justify left  -anchor w
    label $wp.fse.lpl1  -textvariable pl1Lbl  -justify left  -anchor w
    label $wp.fse.lpl2  -textvariable pl2Lbl  -justify left  -anchor w
    grid $wp.fse.sq1  -row 0 -column 0 -sticky ew
    grid $wp.fse.sq2  -row 1 -column 0 -sticky ew
    grid $wp.fse.lpci -row 0 -column 1 -padx 5 -sticky ew
    grid $wp.fse.lpl1 -row 1 -column 1 -padx 5 -sticky ew
    grid $wp.fse.lpl2 -row 2 -column 1 -padx 5 -sticky ew
    
    grid $wp.fse -row 0 -column 2 -sticky nw -padx 5 -pady 5
    
    frame $wp.frbt
    grid rowconfig $wp.frbt 0 -weight 1
    button $wp.frbt.sum  -text "Summary"  -bg cyan  -command [list SummaryPCI]
    button $wp.frbt.dis  -text "Return"  -background orange  -command "DetruitBoutonsOrdali"
    grid $wp.frbt.sum -row 0 -column 0 -sticky nsew -padx 20
    grid $wp.frbt.dis -row 0 -column 1 -sticky nsew
    grid $wp.frbt -row 0 -column 3 -sticky nse -padx 5 -pady 5
    
    BindModeSelection
    if {! [info exists ZonePCI]} {
	set ZonePCI {}
    } else {
	set ZoneSelect $ZonePCI
    }
    AfficheZonesSelectionnees $ZonePCI
    StockPosition
    
    tkwait window $FrmBouton.fpci
    
    return

}

proc AfficheBoutonsSeqLab {} {

    global FrmBouton

    if {! [ModeI]} {return}

    set wb $FrmBouton.sl
    frame $wb  -relief sunken  -bd 2
    grid $wb -row 0 -column 1 -sticky news -pady 5

    frame $wb.frmgp
    grid $wb.frmgp -row 0 -column 0 -sticky w -padx 2

    button $wb.frmgp.clear  -text "Clear"  -background white  -width 10  -command "ClearSelections"
    button $wb.frmgp.ungroup  -text "Ungroup"  -background cyan  -width 10  -command "DegroupeLesSequences"
    button $wb.frmgp.group  -text "Group"  -background cyan  -width 10  -command "GroupeLesSequences"
    grid $wb.frmgp.clear   -row 0 -column 0 -rowspan 2 -sticky news -padx {2 5} 
    grid $wb.frmgp.group   -row 0 -column 1 -sticky ew
    grid $wb.frmgp.ungroup -row 1 -column 1 -sticky ew
    grid columnconfig $wb.frmgp 0   -weight 1
    grid rowconfig    $wb.frmgp all -weight 0

    frame $wb.frmnet
    grid $wb.frmnet -row 0 -column 1 -sticky w -padx 2
    button $wb.frmnet.col  -text "Rem col gap"  -background pink  -width 10  -command RemoveColumnsOfGaps
    checkbutton $wb.frmnet.ulock  -text "Lock/Unlock Seq"  -anchor w -justify left  -variable ::LockSeqs -onvalue 1  -offvalue 0  -command "EtatLockSeqs"
    grid $wb.frmnet.ulock  -row 0 -column 0 -sticky ew
    grid $wb.frmnet.col    -row 1 -column 0 -sticky ew
    grid columnconfig $wb.frmnet 0 -weight 1

    frame $wb.frmsv
    grid $wb.frmsv -row 0 -column 2 -sticky e -padx 2
    button $wb.frmsv.search  -text "Search Motif"  -background yellow  -command [list ChangeMode "search"]
    button $wb.frmsv.save  -text "temp. save"  -background cyan  -command SauveTempSeqlab
    set bdismiss $wb.frmsv.dismiss
    set breturn  $wb.frmsv.return
    button $wb.frmsv.return  -text "Save & Return"  -background orange  -command [list RetourFenetreOrdali $wb save $breturn]
    button $wb.frmsv.dismiss  -text "Cancel"  -background red  -command "RetourFenetreOrdali $wb dismiss $bdismiss"
    grid $wb.frmsv.save    -row 0 -column 0 -sticky ew -padx {2 20}
    grid $wb.frmsv.search  -row 1 -column 0 -sticky ew -padx {2 20}
    grid $wb.frmsv.return  -row 0 -column 1 -sticky ew
    grid $wb.frmsv.dismiss -row 1 -column 1 -sticky ew
    grid columnconfig $wb.frmsv all -weight 1
    grid rowconfig    $wb.frmsv all -weight 0
    
    grid columnconfig $wb all -weight 1
    grid rowconfig    $wb all -weight 1 
    
    MesCouleurs $FrmBouton

    update idletasks
    
    tkwait window $wb

    return

}

proc AfficheBoutonsSuperposition {} {

    global FrmBouton NomTextSeq ListeTypesDeFeatures

    if {! [ModeI]} {return}

    set w $FrmBouton
    set ws "$w.select"
    frame $ws -relief sunken -bd 2
    grid $ws -row 0 -column 1 -sticky news -pady 5

    frame $ws.falcl
    grid $ws.falcl -row 0 -column 0 -sticky w -padx 2

    label $ws.falcl.lbf  -anchor w  -justify left  -text "Feature :"
    if {! [info exists ListeTypesDeFeatures]} {
	set ListeTypesDeFeatures {}
    }
    set wdt [PlusLongEltDe $ListeTypesDeFeatures]
    set LesTypes [linsert $ListeTypesDeFeatures 0 "None"]
    ttk::combobox $ws.falcl.cft  -state readonly  -width $wdt  -background white  -values $LesTypes  -textvariable SupFeat
    $ws.falcl.cft current 0
    bind $ws.falcl.cft <<ComboboxSelected>> [list ChangeFeature %W]
    button $ws.falcl.cle  -text "Clear"  -background white  -command "DeselectToutesLesColonnes "

    button $ws.falcl.sal  -text "Select All"  -background cyan  -command "SelectionneToutesColonnes"
    grid $ws.falcl.lbf -row 0 -column 0 -sticky ew
    grid $ws.falcl.cft -row 0 -column 1 -sticky ew
    grid $ws.falcl.cle -row 1 -column 0 -sticky ew
    grid $ws.falcl.sal -row 1 -column 1 -sticky ew
    grid columnconfig $ws.falcl 1 -weight 1

    frame $ws.frmsst
    grid $ws.frmsst -row 0 -column 1 -sticky nw -padx 2 -pady 2
    # buttons for helix and sheet
    button $ws.frmsst.hel  -text "All Helices"  -background red  -width 10  -command [list SelectSSDeType helix]
    button $ws.frmsst.she  -text "All Strands"  -background green1  -width 10  -command [list SelectSSDeType sheet]
    button $ws.frmsst.fin  -text "Superpose"  -background yellow  -width 9 -height 2  -command "FaitSuperposition 1"
    button $ws.frmsst.dpl  -text "Display"  -background green1  -width 7 -height 2  -command "VisualiseStructure"
    grid $ws.frmsst.hel -row 0 -column 0 -sticky new
    grid $ws.frmsst.she -row 1 -column 0 -sticky new -ipadx 5
    grid $ws.frmsst.fin -row 0 -rowspan 2 -column 1 -sticky news -ipady 5
    grid $ws.frmsst.dpl -row 0 -rowspan 2 -column 2 -sticky news -ipady 5
    grid $ws.frmsst -row 0 -column 1 -sticky news -padx 2 -pady 2 

    button $ws.dis  -text "Return"  -background orange  -command "DismissSuper"
    grid $ws.dis -row 0 -column 2 -rowspan 2 -sticky news -padx 2 -pady 2 

    grid rowconfig $ws 0 -weight 0
    grid columnconfig $ws all -weight 1

    # bindings
    BindModeSelection

    $NomTextSeq tag bind Hel <Control-1> [list SelectLaFeature @%x,%y]
    $NomTextSeq tag bind H31 <Control-1> [list SelectLaFeature @%x,%y]
    $NomTextSeq tag bind She <Control-1> [list SelectLaFeature @%x,%y]
    $NomTextSeq tag bind Tur <Control-1> [list SelectLaFeature @%x,%y]

    AfficheZonesSelectionneesSuper
    StockPosition

    tkwait window $ws

    $NomTextSeq tag remove slct 1.0 end
    $NomTextSeq tag remove Marque 1.0 end

    return

}

proc AfficheChaqueSegmentDuBlastN {Nom {FichierBlast ""} {Selection ""}} {


    global RepertoireDuGenome

    Wup "Shows only these from Selection, all if empty"

    if {$FichierBlast==""} { set FichierBlast "$RepertoireDuGenome/blastn/$Nom" }
    if { ! [file exists $FichierBlast]} { return "" }

    set SeuilDuBlastN 0.001
    set LesVoulus {}
    if {$Selection!=""} {
	foreach Ligne [split $Selection "\n"] {
	    scan $Ligne "%s" Voulu
	    lappend LesVoulus $Voulu
	}
	if {$LesVoulus=={}} { return "" }
	set SeuilDuBlastN 9999.9
    }

    set LesSegments [ChaqueSegmentDuBlastN $FichierBlast $SeuilDuBlastN $LesVoulus]
    set Fen [AfficheVariable [join $LesSegments "\n"] "GrandeLargeur" "ChaqueSegmentDuBlast_$Nom"]
    if { ! [regexp "blastn" $FichierBlast]} { return "" }
    set B [BoutonneLaFenetre $Fen "Locs on Chromos\nGenScan output" ""]
    bind $B <1> "VoirLesLocalisationsDuCDNA $Nom \[selection get\]"
    bind $B <Shift-1>    "AfficheGenscanDuContig \[selection get\]"
    return 


}

proc AfficheCompare {{FichierCompare ""} {FichierTFA1 Absent} {FichierTFA2 Absent} {NbPointsMinDansDiag 10}} {


    global RepertoireDuGenome
    if {$FichierCompare == ""} {
	set FichierCompare [ButineArborescence All [pwd]]
    } elseif {![file exists $FichierCompare]} {
	return ""
    }
    if {![file exists $FichierTFA2]} {set FichierTFA2 "Absent"}
    if {![file exists $FichierTFA1]} {set FichierTFA1 "Absent"}

    if {$FichierTFA1 != "Absent" && $FichierTFA2 != "Absent"} {
	set Seq1    [QueLaSequenceDuTFA     $FichierTFA1]
	set Seq2    [QueLaSequenceDuTFA     $FichierTFA2]
    }
    
    set BordX 100
    set BordY 100
    set ResVerti [winfo screenwidth .]
    set HauteurFenetre   [expr ($ResVerti*1.0)*2/3]
    set LargeurFenetre   $HauteurFenetre
    set HauteurAffichage [expr ($HauteurFenetre - 2*$BordY ) * 1.0]
    set LargeurAffichage $HauteurAffichage
    
    set TailleMaxNomQuery 100
    
    LitFichierCompare TabCompare $FichierCompare
    set DQ1          [set TabCompare(DebutQuery1) ]
    set FQ1          [set TabCompare(FinQuery1)   ]
    set DQ2          [set TabCompare(DebutQuery2) ]
    set FQ2          [set TabCompare(FinQuery2)   ]
    set Points       [set TabCompare(Points)      ]
    set Input1       [set TabCompare(Input1)      ]
    set Input2       [set TabCompare(Input2)      ]
    if {[info exists TabCompare(Description1)]} {
	set NameQuery1 [set TabCompare(Description1)]
    } else {
	set NameQuery1 $Input1
    }
    if {[info exists TabCompare(Description2)]} {
	set NameQuery2 [set TabCompare(Description2)]
    } else {
	set NameQuery2 $Input2
    }
    if {[info exists TabCompare(Window)    ]} {set Window     [set TabCompare(Window)    ]}
    if {[info exists TabCompare(Stringency)]} {set Stringency [set TabCompare(Stringency)]}
    if {[info exists TabCompare(WordSize)  ]} {set WordSize   [set TabCompare(WordSize)  ]}
    if {[info exists TabCompare(Alphabet)  ]} {set Alphabet   [set TabCompare(Alphabet)  ]} 
    set LesPoints [set TabCompare(LesPoints)]

    set LargeurNuage   [expr (abs($FQ1 - $DQ1)+1)*1.0]
    set HauteurNuage   [expr (abs($FQ2 - $DQ2)+1)*1.0]

    if {$LargeurNuage <= $HauteurNuage} {
	set Rapport [expr $LargeurAffichage/$LargeurNuage]
	set LargeurMax $LargeurFenetre
	set HauteurMax [expr $HauteurNuage*$Rapport + 2*$BordY]
    } else {
	set Rapport [expr $HauteurAffichage/$HauteurNuage]
	set HauteurMax $HauteurFenetre
	set LargeurMax [expr $LargeurNuage*$Rapport + 2*$BordY]
    }
    set K [UnCanva $LargeurMax $HauteurMax $LargeurFenetre $HauteurFenetre WithY]
    $K configure -background white

    $K create rectangle $BordX $BordY [expr $LargeurNuage*$Rapport + $BordX] [expr $HauteurNuage*$Rapport + $BordY] -outline red

    if {$TailleMaxNomQuery < [string length $NameQuery1]} { 
	set NameQ1 [string range $NameQuery1 0 $TailleMaxNomQuery]
	append NameQ1 "..."
    } else {
	set NameQ1 $NameQuery1
    }
    $K create text [expr $LargeurFenetre/2] [expr $BordY*2/3              ] -text "$NameQ1"
    $K create text [expr $LargeurFenetre/2] [expr $HauteurMax - $BordY*2/3] -text "$NameQ1"
    $K create text $BordX [expr $BordY/2              ] -text "$DQ1"
    $K create text $BordX [expr $HauteurMax - $BordY/2] -text "$DQ1"
    $K create text [expr $LargeurMax - $BordX] [expr $BordY/2              ] -text "$FQ1"
    $K create text [expr $LargeurMax - $BordX] [expr $HauteurMax - $BordY/2] -text "$FQ1"
    
    if {$TailleMaxNomQuery < [string length $NameQuery2]} { 
	set NameQ2 [string range $NameQuery2 0 $TailleMaxNomQuery]
	append NameQ2 "..."
    } else {
	set NameQ2 $NameQuery2
    }
    regsub -all "" $NameQ2 "\n" NameQ2
    regsub "^\n" $NameQ2 "" NameQ2
    regsub "\n$" $NameQ2 "" NameQ2
    $K create text [expr $BordX*2/3              ] [expr $HauteurFenetre/2] -text "$NameQ2"
    $K create text [expr $LargeurMax - $BordX*2/3] [expr $HauteurFenetre/2] -text "$NameQ2"
    $K create text [expr $BordX/2              ] $BordY -text "$DQ2"
    $K create text [expr $LargeurMax - $BordX/2] $BordY -text "$DQ2"
    $K create text [expr $BordX/2              ] [expr $HauteurMax - $BordY] -text "$FQ2"
    $K create text [expr $LargeurMax - $BordX/2] [expr $HauteurMax - $BordY] -text "$FQ2"

    foreach LePoint $LesPoints {
	set PosQ1 [lindex $LePoint 0]
	set PosQ2 [lindex $LePoint 1]
	set NbVoisins 0
	set PosQ1p [expr $PosQ1 + 1 ]
	set PosQ1m [expr $PosQ1 - 1 ]
	set PosQ2p [expr $PosQ2 + 1 ]
	set PosQ2m [expr $PosQ2 - 1 ]
	if {[info exists TabCompare($PosQ1,$PosQ2p) ]} {incr NbVoisins}
	if {[info exists TabCompare($PosQ1p,$PosQ2p)]} {incr NbVoisins}
	if {[info exists TabCompare($PosQ1p,$PosQ2) ]} {incr NbVoisins}
	if {[info exists TabCompare($PosQ1p,$PosQ2m)]} {incr NbVoisins}
	if {[info exists TabCompare($PosQ1,$PosQ2m) ]} {incr NbVoisins}
	if {[info exists TabCompare($PosQ1m,$PosQ2m)]} {incr NbVoisins}
	if {[info exists TabCompare($PosQ1m,$PosQ2) ]} {incr NbVoisins}
	if {[info exists TabCompare($PosQ1m,$PosQ2p)]} {incr NbVoisins}
	if {$NbVoisins == 0 && $NbPointsMinDansDiag !=0} {
	    continue
	} elseif {$NbVoisins == 0 && $NbPointsMinDansDiag ==0} {
	    set XMin [expr ($PosQ1 - $DQ1 + 1) * $Rapport + $BordX]
	    set YMin [expr ($PosQ2 - $DQ2 + 1) * $Rapport + $BordY]
	    set XMax [expr ($PosQ1 - $DQ1 + 1) * $Rapport + $BordX]
	    set YMax [expr ($PosQ2 - $DQ2 + 1) * $Rapport + $BordY]
	    $K create rectangle $XMin $YMin $XMax $YMax -fill $Couleur -width 2 -tags [list "$NameQuery1" "$PosXMinDiag1" "$PosXMaxDiag1" "$NameQuery2" "$PosYMinDiag1" "$PosYMaxDiag1" "AvecPosition"]
	} else {
	    if {![info exists DejaVuSurUneDiag1($PosQ1,$PosQ2)]} {
		set NbPointsAvantSurDiag1 0
		while {[info exists TabCompare($PosQ1m,$PosQ2m)]} {
		    incr NbPointsAvantSurDiag1
		    set PosQ2m [expr $PosQ2m - 1]
		    set PosQ1m [expr $PosQ1m - 1]
		    set DejaVuSurUneDiag1($PosQ1m,$PosQ2m) 1
		}
		set PosXMinDiag1 [expr $PosQ1 - $NbPointsAvantSurDiag1]
		set PosYMinDiag1 [expr $PosQ2 - $NbPointsAvantSurDiag1]
		set NbPointsApresSurDiag1 0
		while {[info exists TabCompare($PosQ1p,$PosQ2p)]} {
		    incr NbPointsApresSurDiag1
		    set PosQ2p [expr $PosQ2p + 1]
		    set PosQ1p [expr $PosQ1p + 1]
		    set DejaVuSurUneDiag1($PosQ1p,$PosQ2p) 1
		}
		set PosXMaxDiag1 [expr $PosQ1 + $NbPointsApresSurDiag1]
		set PosYMaxDiag1 [expr $PosQ2 + $NbPointsApresSurDiag1]
		
		if {[info exists LaDiagExiste($PosXMinDiag1,$PosYMinDiag1,$PosXMaxDiag1,$PosYMaxDiag1)]} {continue}
		set LaDiagExiste($PosXMinDiag1,$PosYMinDiag1,$PosXMaxDiag1,$PosYMaxDiag1) 1
		
		set NbPointsSurDiag1 [expr 1 + $NbPointsApresSurDiag1 + $NbPointsAvantSurDiag1]
		if {$NbPointsSurDiag1 < $NbPointsMinDansDiag} {continue}
		set Couleur "blue"
		set XMin [expr ($PosXMinDiag1 - $DQ1 + 1) * $Rapport + $BordX]
		set YMin [expr ($PosYMinDiag1 - $DQ2 + 1) * $Rapport + $BordY]
		set XMax [expr ($PosXMaxDiag1 - $DQ1 + 1) * $Rapport + $BordX]
		set YMax [expr ($PosYMaxDiag1 - $DQ2 + 1) * $Rapport + $BordY]
		$K create line $XMin $YMin $XMax $YMax -fill $Couleur -width 2 -tags [list "$NameQuery1" "$PosXMinDiag1"  "$PosXMaxDiag1" "$NameQuery2" "$PosYMinDiag1" "$PosYMaxDiag1" "AvecPosition"]
	    }
	    if {![info exists DejaVuSurUneDiag2($PosQ1,$PosQ2)]} {
		set NbPointsAvantSurDiag2 0 
		while {[info exists TabCompare($PosQ1m,$PosQ2p)]} {
		    incr NbPointsAvantSurDiag2
		    set PosQ2p [expr $PosQ2p + 1]
		    set PosQ1m [expr $PosQ1m - 1]
		    set DejaVuSurUneDiag1($PosQ1m,$PosQ2p) 1
		}
		set PosXMinDiag2 [expr $PosQ1 - $NbPointsAvantSurDiag2]
		set PosYMinDiag2 [expr $PosQ2 + $NbPointsAvantSurDiag2]
		set NbPointsApresSurDiag2 0
		while {[info exists TabCompare($PosQ1p,$PosQ2m)]} {
		    incr NbPointsApresSurDiag2
		    set PosQ2m [expr $PosQ2m - 1]
		    set PosQ1p [expr $PosQ1p + 1]
		    set DejaVuSurUneDiag1($PosQ1p,$PosQ2m) 1
		}
		set PosXMaxDiag2 [expr $PosQ1 + $NbPointsApresSurDiag2]
		set PosYMaxDiag2 [expr $PosQ2 - $NbPointsApresSurDiag2]
		
		if {[info exists LaDiagExiste($PosXMinDiag2,$PosYMinDiag2,$PosXMaxDiag2,$PosYMaxDiag2)]} {continue}
		set LaDiagExiste($PosXMinDiag2,$PosYMinDiag2,$PosXMaxDiag2,$PosYMaxDiag2) 1
		
		set NbPointsSurDiag2 [expr 1 + $NbPointsApresSurDiag2 + $NbPointsAvantSurDiag2]
		if {$NbPointsSurDiag2 < $NbPointsMinDansDiag} {continue}
		set Couleur "green"
		set XMin [expr ($PosXMinDiag2 - $DQ1 + 1) * $Rapport + $BordX]
		set YMin [expr ($PosYMinDiag2 - $DQ2 + 1) * $Rapport + $BordY]
		set XMax [expr ($PosXMaxDiag2 - $DQ1 + 1) * $Rapport + $BordX]
		set YMax [expr ($PosYMaxDiag2 - $DQ2 + 1) * $Rapport + $BordY]
		$K create line $XMin $YMin $XMax $YMax -fill $Couleur -width 2 -tags [list "$NameQuery1" "$PosXMinDiag1" "$PosXMaxDiag1" "$NameQuery2" "$PosYMinDiag1" "$PosYMaxDiag1" "AvecPosition"]
	    }
	}
    }
    regsub {\.canvas} $K "" w
    set B [BoutonneLaFenetre $w "TailleMinDesDiags Default / NoLimit / X"]
    bind $B <1> "AfficheCompare $FichierCompare $FichierTFA1 $FichierTFA2 10"
    bind $B <2> "AfficheCompare $FichierCompare $FichierTFA1 $FichierTFA2 0"
    bind $B <3> "AfficheCompare $FichierCompare $FichierTFA1 $FichierTFA2 \[Entre\]"

    if {$FichierTFA1 != "Absent" && $FichierTFA2 != "Absent"} {
	if {$Seq1 != "" && $Seq2 != ""} {
	    $K bind "AvecPosition"     <1> "AfficheDiagonaleCorrespondante $K $Seq1 $Seq2"
	}
    }
    return $K


}

proc AfficheContigComplet {Selection} {


    foreach Ligne [split $Selection "\n"] {
	set Ligne [OteSuperfluPourFetch $Ligne]
	scan $Ligne "%s" AccessDuFragment
	set F [AfficheVariable [ContigComplet $AccessDuFragment] "AvecBlaste" $AccessDuFragment]
    }
    return $F


}

proc AfficheCorrelationClustersOperons {} {


    global TableauOrf2Cluster2Operon

    set CO [CorrelationClustersOperons TCCO]
    set LesXs [lindex $CO 0]
    set LesYs [lindex $CO 1]

    DessineBilanHDACroises $LesXs $LesYs TCCO "CorrelationClustersOperons"


}

proc AfficheDansOmac {} {


global COmac
global Defauts
global EquivalenceZone
global OrdEtcDir
global StrucAVoir
global NomEtSeqAssPDB

DefinitStructuresAVoir
if {$StrucAVoir == "return"} {return}

OuvreFichierSortieO
if {$COmac == ""} {return}

FaireAttendre "Please wait ...\nSuperposing structures ..."
IlFautVoir "! "
IlFautVoir "! To execute the Ordali macro, type :"
IlFautVoir "! "
IlFautVoir "! @ord"
IlFautVoir "! "
IlFautVoir "! [DonneDateEtHeure] "
IlFautVoir "! "
IlFautVoir "DebutMc ord"
IlFautVoir "read [file join $OrdEtcDir color_rgb.dat]"
IlFautVoir "read [file join $OrdEtcDir color_names.dat]"
IlFautVoir "sketch_setup sphere solid 1"

set CmdSup {}
if {[info exists EquivalenceZone]} {
if {[set Defauts(MethodeSuper)]=="lsq"} {
set CmdSup [SuperAvecO]
} else {
SuperAvecOrdali
AppliqueSuperposition
}
}

foreach elt $StrucAVoir {
set idx [lsearch -regexp $NomEtSeqAssPDB $elt]
set cible [lindex $NomEtSeqAssPDB $idx]
scan $cible "%s %s %s" pdb NSAss MolId
set chn [string index $MolId 5]
set MolId [string range $MolId 0 3]
set RepS [CalculeSpheres $chn $MolId]
}

foreach elt $StrucAVoir {
set idx [lsearch -regexp $NomEtSeqAssPDB $elt]
set cible [lindex $NomEtSeqAssPDB $idx]
scan $cible "%s %s %s" pdb NomSeqAss MolId
set chn [string index $MolId 5]
set MolId [string range $MolId 0 3]
set fpdb [file tail [SigneFichier $pdb]]
file copy -force $pdb $fpdb

IlFautVoir "s_a_i"
IlFautVoir "[pwd]/$fpdb"
IlFautVoir "$MolId"
IlFautVoir "PDB"
if {$RepS} {IlFautVoir "draw ${elt}sf"}
}

foreach c $CmdSup {
foreach sousc [split $c \n] {
IlFautVoir $sousc
}
}

TraceObjetDansO $StrucAVoir

set mref [lindex $StrucAVoir 0]
if {[set Defauts(MethodeSuper)] == "lsq"} {
foreach elt $StrucAVoir {
if {$elt != $mref} {
IlFautVoir "rot_tran_obj .lsq_rt_${elt}2$mref ${elt}sf"
}
}
}

if {$RepS} {
foreach elt $StrucAVoir {
set idx [lsearch -regexp $NomEtSeqAssPDB $elt]
set cible [lindex $NomEtSeqAssPDB $idx]
scan $cible "%s %s %s" pdb NSAss MolId
set chn [string index $MolId 5]
set MolId [string range $MolId 0 3]
CalculeSpheres $chn $MolId
EcritSpheres $MolId
}
}

if {[set Defauts(Balibase)]} {PeintCAEnCouleur}

IlFautVoir "FinDbMc"
IlFautVoir "FinOMac"
FaireLaSuite .superpopo

return

}

proc AfficheDansPyMOL {} {


    DefinitStructuresAVoir
    if {$StrucAVoir == "return"} {return}
    update

    foreach elt $StrucAVoir {
	set idx [lsearch -regexp $NomEtSeqAssPDB $elt]
	set cible [lindex $NomEtSeqAssPDB $idx]
	scan $cible "%s %s %s" pdb NomSeqAss MolId
	set chn [string index $MolId 5]
	set MolId [string range $MolId 0 3]
	set deja -1
	if {[info exists DisplayMolecule]} {
	    set deja [lsearch $DisplayMolecule $MolId]
	}
	if {$deja == -1} {
	    set fpdb [file tail [SigneFichier $pdb]]
	    puts "on regarde $fpdb"
	    file copy -force $pdb $fpdb
	    IlFautVoir "load $fpdb"
	    lappend DisplayMolecule $MolId
	}
    }

    #    load $pdb , object-name
    #    show cartoon , object-name
    #    hide lines , object-name
    #    set smooth_loops=0 , object-name # de-smooth le cartoon --> Ca trave
    #    color cyan , object-name # tout en cyan
    #    color cyan , object-name/<Chain>/res1:res2/
    #    color cyan , (resi <resn> and chain <chain>)
    return

}

proc AfficheDansRasMol {} {

    global ListePDB
    global StrucAVoir
    global InitRasMol
    global Defauts
    global ReponseRasmol
    global RasM

    set InitRasMol 1

    FenetreControlesRasMol

    IlFautVoir "zap"
    IlFautVoir "rotate all"
    IlFautVoir "background [set Defauts(Background)]"
    IlFautVoir "set cartoons 6"
    IlFautVoir "set menus off"

    set i 1
    set r 0
    foreach mold $StrucAVoir {
	set idx [lsearch [ExtraitListeDeListe $ListePDB 0] $mold]
	lassign [lindex $ListePDB $idx] mol fpdb

	IlFautVoir "load pdb $fpdb"
	if {[info exists ReponseRasmol]} {
	    set nfois 0
	    while {[lsearch -regexp $ReponseRasmol "Experiment"] == -1} {
		update
		incr nfois
		if {$nfois >= 10} {break}
	    }
	    set inmr [string first " NMR" $ReponseRasmol]
	    if {$inmr != -1} {
		set RasM(mol$r,Exp) "NMR"
		set RasM(mol$r,Sel) "restrict */1"
	    } else {
		set RasM(mol$r,Exp) "X-RAY"
		set RasM(mol$r,Sel) "select all"
	    }
	}
	IlFautVoir "molecule $i"
	IlFautVoir [set RasM(mol$r,Sel)]
	IlFautVoir "colour grey"
	TraceObjetDansRasMol $mol

	incr i
	incr r
    }

    return

}

proc AfficheDansVMD {} {

    global StrucAVoir
    global ListePDB

    if {$StrucAVoir eq "return"} {return}
    if {$StrucAVoir eq {}} {return}

    foreach mold $StrucAVoir {
	set idx [lsearch [ExtraitListeDeListe $ListePDB 0] $mold]
	lassign [lindex $ListePDB $idx] mol fpdb

	set chn   [DonneChainDeAccessPDB $mol]
	set MolId [DonneIdDeAccessPDB $mol]

	IlFautVoir "NouvelleMolecule $fpdb $MolId $chn"
    }

    return

}

proc AfficheDansViandox {} {

    global pgl Rad OrdaliDir StrucAVoir Liste3dMol

    # Deja passe par la
    if {[info exists pgl(wogl)]} {
	raise [winfo toplevel $pgl(wogl)]
	update idletasks
	return
    }

    # On y va !
    InitialisationViandox

    set ObjDone [expr {[LoadObjFromDB] > 0}]
    
    # Liste des structures pour la combobox
    set Liste3dMol [list]
    foreach e $StrucAVoir {
	lappend Liste3dMol [DonneIdDeAccessPDB $e]
    }

    set cx 0. ; set cy 0. ; set cz 0.
    set zmin 999999. ; set zmax -999999.
    set ymin 999999. ; set ymax -999999.
    set xmin 999999. ; set xmax -999999.
    set cmp 0 ; set ZeRad 1.

    set xm 0 ; set ym 0 ; set zm 0
    set xx 0 ; set yx 0 ; set zx 0
    foreach mold $StrucAVoir {
	set nom [DonneIdDeAccessPDB $mold]
	set chn [DonneChainDeAccessPDB $mold]
	lappend ListeObjPDB $nom

	lassign [$nom bbox] xm ym zm xx yx zx 
	if {$zm < $zmin} {set zmin $zm}
	if {$zx > $zmax} {set zmax $zx}
	if {$ym < $ymin} {set ymin $ym}
	if {$yx > $ymax} {set ymax $yx}
	if {$xm < $xmin} {set xmin $xm}
	if {$xx > $xmax} {set xmax $xx}
	#if {$zeRad < [$nom radius]} {set ZeRad [$nom radius]}

	if {! $ObjDone} {
	    if {$::Defauts(PrecomputeSrf)} {
		$nom newObj "SF${nom}$chn"
		$nom select chain $chn
		$nom ribbons "SF${nom}$chn"
		$nom surface "SF${nom}$chn"
		$nom render "SF${nom}$chn"
	    }

	    #$nom newObj "CP${nom}$chn"
	    #$nom select chain $chn
	    #$nom CPK "CP${nom}$chn"
	    #$nom render "CP${nom}$chn"
	}

	if {1} {
	    $nom newObj "CT${nom}$chn"
	    $nom select chain $chn
	    $nom catrace "CT${nom}$chn"
	    $nom render "CT${nom}$chn"
	}

	if {1} {
	    if {! $ObjDone} {
		$nom newObj "AL${nom}$chn"
		$nom select chain $chn
		$nom atomes "AL${nom}$chn"
		$nom render "AL${nom}$chn"
		update

		$nom newObj "CA${nom}$chn"
		$nom select chain $chn
		$nom ribbons "CA${nom}$chn"
		#$nom setboite "CA${nom}$chn" $chn
		$nom render "CA${nom}$chn"
	    }
	}

	if {0} {
	    $nom newObj "CP${nom}$chn"
	    $nom select chain $chn
	    $nom CPK "CP${nom}$chn"
	    $nom render "CP${nom}$chn"
	}
    }

    set pgl(xCen) [expr {($xx+$xm)/2.}]
    set pgl(yCen) [expr {($yx+$ym)/2.}]
    set pgl(zCen) [expr {($zx+$zm)/2.}]

    set Rad [expr {sqrt(  ($xmax-$xmin)**2 +  ($ymax-$ymin)**2 +  ($zmax-$zmin)**2)  / 2.}]


    set pgl(Rad)       $Rad

    # backclip = z near (z neg)
    set pgl(backclip)  [expr {-0.1 * $Rad}]
    # frontclip = z far 
    set pgl(frontclip) [expr { 2.1 * $Rad}]

    set pgl(eyeX)      0.0
    set pgl(eyeY)      0.0
    set pgl(eyeZ)      $pgl(frontclip)

    set pgl(fogStart)  [expr {0.3*$Rad}]
    set pgl(fogEnd)    [expr {0.6*$Rad}]
    
    puts "AVANT fenetre" ; flush stdout ; update idletasks
    AfficheFenetreOpengl
    puts "Apres fenetre" ; flush stdout ; update idletasks
    
    
    set LFPDB {}
    foreach mold $StrucAVoir {
	set nom [DonneIdDeAccessPDB $mold]
	set chn [DonneChainDeAccessPDB $mold]

	if {$nom ni $LFPDB} {
	    AddFObj $nom
	    lappend LFPDB $nom
	}

	lassign [$nom center] x y z
	set cx  [expr {$cx + $x}]
	set cy  [expr {$cy + $y}]
	set cz  [expr {$cz + $z}]

	incr cmp
    }
    if {$cmp != 0} {
	set cx [expr {$cx/$cmp}]
	set cy [expr {$cy/$cmp}]
	set cz [expr {$cz/$cmp}]
    }

    TousObjetsOff
    #ToggleAllOff
    update

    set pgl(xCen) $cx
    set pgl(yCen) $cy
    set pgl(zCen) $cz

    set pgl(fogStart) [expr {abs($cz)}]
    set pgl(fogEnd)   [expr {0.9*($Rad-abs($cz))}]
    
    Update3DMatrices
    $pgl(wogl) postredisplay

    return

}

proc AfficheDiagonaleCorrespondante {K Seq1 Seq2} {


    set Liste [$K find withtag current]
    set Blanc ""
    set NbBaseParLigne 50

    foreach Diag $Liste {
	set NameQuery1 [lindex [$K gettags $Diag] 0]
	set PosMin1    [lindex [$K gettags $Diag] 1]
	set PosMax1    [lindex [$K gettags $Diag] 2]
	set NameQuery2 [lindex [$K gettags $Diag] 3]
	set PosMin2    [lindex [$K gettags $Diag] 4]
	set PosMax2    [lindex [$K gettags $Diag] 5]

	set FragSeq1   [string range [string trim $Seq1] [expr $PosMin1-11] [expr $PosMax1+9] ]
	set LeFragSeq1 [split $FragSeq1 ""]
	
	set FragSeq2 [string range [string trim $Seq2] [expr $PosMin2-11] [expr $PosMax2+9] ]
	set LeFragSeq2 [split $FragSeq2 ""]

	set NBaseTotale [string length $FragSeq1]
	set InterSeq ""
	for {set i 0} {$i < $NBaseTotale} {incr i} {
	    set Base1 [lindex $LeFragSeq1 $i]
	    set Base2 [lindex $LeFragSeq2 $i]
	    if {$Base1 == $Base2} {
		if {$Base1 != "N"} {
		    append InterSeq "\|"
		} else {
		    append InterSeq " "
		}
	    } else {
		append InterSeq " "
	    }
	}
	
	set ResteDeSeq1     $FragSeq1
	set ResteDeSeq2     $FragSeq2
	set ResteDeInterSeq $InterSeq
	set Debut1 [expr $PosMin1-10]
	set Debut2 [expr $PosMin2-10]
	set PosMin1 "$PosMin1-10"
	set PosMax1 "$PosMax1+10"
	set PosMin2 "$PosMin2-10"
	set PosMax2 "$PosMax2+10"
	set Alignement ""
	if {1<[expr ($NBaseTotale*1.0)/($NbBaseParLigne*1.0)]} { 
	    if {[expr $NBaseTotale/$NbBaseParLigne]== [expr ($NBaseTotale*1.0)/($NbBaseParLigne*1.0)] } {
		set NbLignes [expr $NBaseTotale/$NbBaseParLigne]
	    } else {
		set NbLignes [expr $NBaseTotale/$NbBaseParLigne + 1]
	    }
	   
	    for {set Ligne 1} {$Ligne <= $NbLignes} {incr Ligne} {
		set LigneSeq1     [string range $ResteDeSeq1     0 [expr $NbBaseParLigne-1]]
		set LigneSeq2     [string range $ResteDeSeq2     0 [expr $NbBaseParLigne-1]]
		set LigneInterSeq [string range $ResteDeInterSeq 0 [expr $NbBaseParLigne-1]]
		if {$Ligne == 1} {
		    set LigneSeq1 [format "%11s %s %-11s\n" $PosMin1 $LigneSeq1 $NbBaseParLigne]
		    set LigneSeq2 [format "%11s %s %-11s\n" $PosMin2 $LigneSeq2 $NbBaseParLigne]
		    set LigneInterSeq [format "%11s %s\n" $Blanc $LigneInterSeq]
		    append Alignement "$NameQuery1\n"
		    append Alignement $LigneSeq1
		    append Alignement $LigneInterSeq
		    append Alignement $LigneSeq2
		    append Alignement "$NameQuery2\n\n\n"
		    
		    set ResteDeSeq1     [string range $ResteDeSeq1 $NbBaseParLigne end]
		    set ResteDeSeq2     [string range $ResteDeSeq2 $NbBaseParLigne end]
		    set ResteDeInterSeq [string range $ResteDeInterSeq $NbBaseParLigne end]
		} elseif {$Ligne == $NbLignes} {
		    set Min1 [expr $Debut1  + ($Ligne-1)*$NbBaseParLigne]
		    set Min2 [expr $Debut2  + ($Ligne-1)*$NbBaseParLigne]
		    set LigneSeq1 [format "%11s %s %-11s\n" $Min1 $LigneSeq1 $PosMax1]
		    set LigneSeq2 [format "%11s %s %-11s\n" $Min2 $LigneSeq2 $PosMax2]
		    set LigneInterSeq [format "%11s %s\n" $Blanc $LigneInterSeq]
		    append Alignement $LigneSeq1
		    append Alignement $LigneInterSeq
		    append Alignement $LigneSeq2
		    break
		} else {
		    set Min1 [expr $Debut1  + ($Ligne-1)*$NbBaseParLigne]
		    set Min2 [expr $Debut2  + ($Ligne-1)*$NbBaseParLigne]
		    set Max1 [expr $Min1 + $NbBaseParLigne]
		    set Max2 [expr $Min2 + $NbBaseParLigne]
		    
		    set LigneSeq1 [format "%11s %s %-11s\n" $Min1 $LigneSeq1 $Max1]
		    set LigneSeq2 [format "%11s %s %-11s\n" $Min2 $LigneSeq2 $Max2]
		    set LigneInterSeq [format "%11s %s\n" $Blanc $LigneInterSeq]
		    append Alignement $LigneSeq1
		    append Alignement $LigneInterSeq
		    append Alignement "$LigneSeq2\n\n\n"
		    		    
		    set ResteDeSeq1     [string range $ResteDeSeq1 $NbBaseParLigne end]
		    set ResteDeSeq2     [string range $ResteDeSeq2 $NbBaseParLigne end]
		    set ResteDeInterSeq [string range $ResteDeInterSeq $NbBaseParLigne end]
		}
	    }
	} else {
	    set LigneFrag1 [format "%11s %s %-11s\n" $PosMin1 $FragSeq1 $PosMax1]
	    set LigneFrag2 [format "%11s %s %-11s\n" $PosMin2 $FragSeq2 $PosMax2]
	    set Ali [format "%11s %s\n" $Blanc $InterSeq]
	    append Alignement "$NameQuery1\n"
	    append Alignement $LigneFrag1
	    append Alignement $Ali
	    append Alignement $LigneFrag2
	    append Alignement "$NameQuery2\n"
	}
	AfficheVariable "$Alignement" "AvecRien" "Input1 - Input2"
    }


}

proc AfficheDistances {} {

    global pgl

    set $pgl(TextDeDist) [list]
    if {$pgl(Dist2Show) == {} } {return}

    glColor3fv $pgl(DistColor)
    glLineStipple 3 0xAAAA
    glEnable GL_LINE_STIPPLE
    foreach e $pgl(Dist2Show) {
	lassign $e v1 v2 dst
	glBegin GL_LINES
	glVertex3fv $v1
	glVertex3fv $v2
	glEnd
	
	lappend pgl(TextDeDist) {*}[V_VV $v1 + [V_SV 0.5 * [V_VV $v2 - $v1]]] [format " %4.1f A" $dst]
    }
    glDisable GL_LINE_STIPPLE
    
    return

    # recup de la matrice de modelisation
    set mvmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
    set modmat [tcl3dVectorToList $mvmatrix 16]

    # recup de la matrice de projection
    set pjmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_PROJECTION_MATRIX $pjmatrix
    set projmat [tcl3dVectorToList $pjmatrix 16]

    # Recup du viewport
    set viewmat [tcl3dVector GLint 4]
    glGetIntegerv GL_VIEWPORT $viewmat
    set viewport [tcl3dVectorToList $viewmat 4]

    # print the string
    glMatrixMode GL_MODELVIEW
    glPushMatrix
    glLoadIdentity

    foreach v $Lx text $Lt {
	lassign $v x y z

	set xa [expr {[lindex $modmat 0]*$x + [lindex $modmat 4]*$y + [lindex $modmat 8]*$z + [lindex $modmat 12]}]
	set ya [expr {[lindex $modmat 1]*$x + [lindex $modmat 5]*$y + [lindex $modmat 9]*$z + [lindex $modmat 13]}]
	set za [expr {[lindex $modmat 2]*$x + [lindex $modmat 6]*$y + [lindex $modmat 10]*$z + [lindex $modmat 14]}]

	glRasterPos3f $xa $ya $za

	printString $text
    }

    glPopMatrix
    glFlush

    return

}

proc AfficheDownloadPDB {} {

    global StrucAVoir DwnPDB

    set w ".dwnpdb"
    toplevel $w
    wm protocol $w WM_DELETE_WINDOW KillParLaCroix

    grid rowconfig    $w 0 -weight 1 -minsize 0
    grid columnconfig $w 0 -weight 0 -minsize 0
    grid columnconfig $w 1 -weight 1 -minsize 0
    grid columnconfig $w 2 -weight 0 -minsize 0

    label $w.l -text "Please specify PDB files to be used" -anchor w
    set i 1
    foreach s $StrucAVoir {
	label $w.l$i -text "$s"
	entry $w.e$i -bg white -width 25 -textvariable DwnPDB($i)
	button $w.b$i -text "browse ..."  -bg cyan -width 10  -command [list eval set DwnPDB($i) \[DemandeEtOuvreFichier pdb 1\]]
	grid $w.l$i -padx 10 -pady 1  -row $i -column 0 -rowspan 1 -columnspan 1 -sticky news
	grid $w.e$i -padx 1 -pady 1  -row $i -column 1 -rowspan 1 -columnspan 1 -sticky news
	grid $w.b$i -padx 10 -pady 1  -row $i -column 2 -rowspan 1 -columnspan 1 -sticky news
	incr i
    }
    frame $w.f
    button $w.f.ok  -background green1  -text " OK "  -command [list FinAfficheDownloadPDB "" $w]
    button $w.f.dis -bg red  -text "Cancel"  -command [list FinAfficheDownloadPDB dismiss $w]
    pack $w.f.dis $w.f.ok -side left -expand 1

    grid $w.l -padx 10 -pady 10  -row 0 -column 0 -rowspan 1 -columnspan 3 -sticky news
    grid $w.f -padx 10 -pady 10  -row $i -column 0 -rowspan 1 -columnspan 3 -sticky news

    FenetreAuCentre $w
    MesCouleurs $w

    tkwait window $w

    return

}

proc AfficheExtraitOligoDuTFA {K PAB} {



    Wup "Affiche la sequence tfa de l oligo du PAB voulu"
        
    set Id         [$K find withtag current]
    set MesTags    [$K gettags $Id]
    set NomOligo   [lindex $MesTags 4]
    set Dir        [lindex $MesTags 5]
    set TFADeOligo [ExtraitOligoDuTFA $PAB $NomOligo $Dir]

    return [AfficheVariable [join $TFADeOligo "\n"] "AvecFormateAvecBlaste" "$Dir/$PAB"]


}

proc AfficheFenetreOpengl {} {

    global OrdEtcDir pgl

    InitTestGL

    # define fonts
    if {"FontOg" ni [font names]} {
	font create FontOg -family Helvetica -size 10 -weight normal
    }
    if {"FontOgTitle" ni [font names]} {
	font create FontOgTitle -family Helvetica -size 10 -weight bold
    }

    #rename EnvoieLesObjets EnvoieLesObjets_wait
    #rename EnvoieLesObjetsTmp EnvoieLesObjets

    # define window
    set wgl .ordogl
    toplevel $wgl
    wm title $wgl $pgl(appName)
    wm protocol $wgl WM_DELETE_WINDOW KillParLaCroix
    wm withdraw $wgl
    $wgl configure -background black

    # put FaireAttendre window on top
    if {[winfo exists .fattendre]} {
	focus -force .fattendre
	raise .fattendre
	wm attributes .fattendre -topmost 1
	update idletasks
    }

    set frInfo [frame $wgl.f1 -bg black -bd 0 -relief flat -highlightthickness 0]
    grid $frInfo -row 0 -column 0 -columnspan 3 -sticky ew
    set frCtrl [frame $wgl.f2 -bg black -bd 0 -relief flat -highlightthickness 0]
    grid $frCtrl -row 1 -column 0 -columnspan 3 -sticky ew
    set frObjc [frame $wgl.f3 -bg black -bd 0 -relief flat -highlightthickness 0]
    grid $frObjc -row 2 -column 0 -sticky news -pady 15
    set frTogl [frame $wgl.f4 -bg black -bd 0 -relief flat -highlightthickness 0]
    grid $frTogl -row 2 -column 1 -sticky news -pady 15
    set frFonc [frame $wgl.f5 -bg black -bd 0 -relief flat -highlightthickness 0]
    grid $frFonc -row 2 -column 2 -sticky news -pady 15
    
    set pgl(frInfo) $frInfo
    set pgl(frCtrl) $frCtrl
    set pgl(frTogl) $frTogl
    set pgl(frObjc) $frObjc
    set pgl(frFonc) $frFonc

    # frame Banniere
    set fmacsim [file join $OrdEtcDir "MACSIM_30px_cut_transparent.gif"]
    image create photo macsim
    #    macsim read $fmacsim -shrink
    macsim read $fmacsim
    set pgl(TextInfo) "Ordalie Structure Viewer"
    label $frInfo.imgm  -image macsim -anchor w  -bd 0 -bg black -padx 30 -pady 10
    label $frInfo.linf  -bg black -fg magenta  -anchor w -justify left  -bd 0  -textvariable pgl(TextInfo)
    grid $frInfo.imgm -row 0 -column 0 -padx {20 10}
    grid $frInfo.linf -row 0 -column 1 -padx {1 20} -sticky ew
    grid columnconfig $frInfo 1 -weight 1
    
    # frame Control
    global Mol3dCou Obj3dCou Feat3dCou
    global ListeTypesDeFeatures ListeFeat43d
    global Liste3dMol

    if {! [info exists Liste3dMol]} {
	set Liste3dMol {}
    }
    set Mol3dCou ""
    set Obj3dCou ""
    set Feat3dCou "None"
    set ListeFeat43d [MetAJourFeaturesViandox]

    puts "avant frame CTRL" ; flush stdout ; update idletasks
    
    label $frCtrl.label  -text "Quick Mapping :"  -fg white -bg black
    frame $frCtrl.f1 -bd 0 -highlightthickness 0 -relief flat -bg black
    label $frCtrl.f1.txt1  -relief flat -bd 0  -bg black -fg white  -text "Molecule "  -anchor w -justify left  -highlightthickness 0
    combobox::combobox $frCtrl.f1.co1  -background black  -foreground white  -width 6  -editable false  -textvariable Mol3dCou  -listvar Liste3dMol
    grid $frCtrl.f1.txt1 -row 0 -column 0 -sticky ""
    grid $frCtrl.f1.co1  -row 0 -column 1 -sticky ew
    trace add variable Mol3dCou write UpdateMol3dObjets
    
    frame $frCtrl.f2  -bd 0 -highlightthickness 0  -relief flat -bg black
    label $frCtrl.f2.txt2  -anchor e -bg black -fg white  -text "Object "  -relief flat -bd 0  -anchor w -justify left  -highlightthickness 0
    global ListeMol3dObjets
    combobox::combobox $frCtrl.f2.co2  -background black -foreground white  -width 6  -editable false  -textvariable Obj3dCou  -listvar ListeMol3dObjets
    grid $frCtrl.f2.txt2 -row 0 -column 0 -sticky ""
    grid $frCtrl.f2.co2  -row 0 -column 1 -sticky ew

    frame $frCtrl.f3 -bd 0 -highlightthickness 0 -relief flat -bg black
    label $frCtrl.f3.txt3  -bg black -fg white  -text "Feature 1 "  -anchor w -justify left  -highlightthickness 0
    combobox::combobox $frCtrl.f3.co3  -background black -foreground white  -width 10  -editable false  -textvariable Feat3dCou  -command [list UpdateMolObjFeat]  -listvar ListeFeat43d
    grid $frCtrl.f3.txt3 -row 0 -column 0 -sticky ""
    grid $frCtrl.f3.co3  -row 0 -column 1 -sticky ew
    bind $frCtrl.f3.co3 <<ComboboxSelected>> [list UpdateMolObjFeat]

    frame $frCtrl.f4 -bd 0 -highlightthickness 0 -relief flat -bg black
    label $frCtrl.f4.txt4  -bg black -fg white  -anchor w -justify left  -highlightthickness 0  -text "Feature 2 "
    combobox::combobox $frCtrl.f4.co4  -background black -foreground white  -width 10  -editable false  -textvariable Feat3dCou2  -command [list UpdateMolObjFeat]  -listvar ListeFeat43d
    grid $frCtrl.f4.txt4 -row 0 -column 0 -sticky ""
    grid $frCtrl.f4.co4  -row 0 -column 1 -sticky ew
    bind $frCtrl.f4.co4 <<ComboboxSelected>> [list UpdateMolObjFeat]

    grid $frCtrl.label -row 0 -column 0  -sticky w -padx 10
    grid $frCtrl.f1    -row 0 -column 1  -sticky w -padx 20
    grid $frCtrl.f2    -row 0 -column 2  -sticky "" -padx 20
    grid $frCtrl.f3    -row 0 -column 3  -sticky "" -padx 20
    grid $frCtrl.f4  -row 0 -column 4  -sticky e -padx 20
    grid columnconfig $frCtrl {1 2 3 4} -weight 1

    puts "APRES frame CTRL" ; flush stdout ; update idletasks

    # frame OpenGL
    # Fenetre Togl
    set pgl(wogl) $frTogl.c 
    togl $frTogl.c  -width $pgl(width)  -height $pgl(height)  -double true  -depth true  -createproc  Togl_CreateFonct  -reshapeproc Togl_ReshapeFonct  -displayproc Togl_DisplayFonct
    grid $frTogl.c -row 0 -column 0 -sticky news
    grid columnconfig $frTogl 0 -weight 1
    grid rowconfig    $frTogl 0 -weight 1
    puts "APRES OPENGL" ; flush stdout ; update idletasks
    
    # Frame Fonctions
    button $frFonc.ca -text "\u2022Reset"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command {ResetFonctions}
    button $frFonc.ci -text "\u2022Clear Ids"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command [list ClearIDs]
    button $frFonc.cd  -text "\u2022Clear Distances"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command [list ClearDistances]
    set pgl(BoutonDistance) "$frFonc.ds"
    button $frFonc.ds  -text "\u2022Distance"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command [list MeasureDistance]
    
    
    set pgl(BoutonCenter) "$frFonc.ct"
    button $frFonc.ct  -text "\u2022Centre On Atom"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command [list CentreOnAtome $frFonc.ct]
    button $frFonc.pr  -text "\u2022Print"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command {PrintOgl}
    button $frFonc.fs  -text "\u2022Full Screen"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command {ToggleWindowMode}
    button $frFonc.st  -text "\u2022Stereo"  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -bd 0 -relief flat  -highlightthickness 0 -anchor w  -command [list NYI]
    
    button $frFonc.cl  -text "Close"  -bg forestgreen -fg white  -activeforeground red  -activebackground forestgreen  -highlightthickness 0 -anchor w  -command [list QuitteViandox]
    
    grid $frFonc.ca -row 0 -column 0 -pady 0 -sticky nwe
    grid $frFonc.ci -row 1 -column 0 -pady 0 -sticky nwe
    grid $frFonc.cd -row 2 -column 0 -pady 0 -sticky nwe
    grid $frFonc.ds -row 3 -column 0 -pady 0 -sticky nwe
    grid $frFonc.ct -row 4 -column 0 -pady 0 -sticky nwe
    grid $frFonc.pr -row 5 -column 0 -pady 0 -sticky nwe
    grid $frFonc.fs -row 6 -column 0 -pady 0 -sticky nwe
    grid $frFonc.st -row 7 -column 0 -pady 0 -sticky nwe
    grid $frFonc.cl -row 8 -column 0 -pady 20 -sticky swe
    grid rowconfig $frFonc 8 -weight 1

    puts "Avant frame obj" ; flush stdout ; update idletasks
    # Frame Objects
    frame $frObjc.onoff  -bg black  -relief flat  -bd 0  -highlightthickness 0

    button $frObjc.onoff.allon  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -text "All On"  -font FontOg  -bd 0 -highlightthickness 0  -anchor w -justify left  -padx 0 -relief flat  -command [list TousObjetsOn]
    
    button $frObjc.onoff.alloff  -bg black -fg cyan  -activeforeground yellow  -activebackground black  -font FontOg  -text "All Off"  -anchor e -justify right  -padx 0 -relief flat  -bd 0 -highlightthickness 0  -command [list TousObjetsOff]
    
    grid $frObjc.onoff.allon  -row 0 -column 0 -sticky w -ipadx 10
    grid $frObjc.onoff.alloff -row 0 -column 1 -sticky e -ipadx 10
    grid columnconfig $frObjc.onoff all -weight 1
    grid $frObjc.onoff -row 0 -column 0 -sticky we -pady 0 -ipady 0 -padx {20 1}
    
    grid columnconfig $frObjc all -weight 1

    # Grille Generale

    grid rowconfigure $wgl 2 -weight 1
    grid columnconfig $wgl 1 -weight 1

    # Bindings 
    bind $frTogl.c <Control-ButtonPress-1> {PickAtom %x %y %W}
    #    bind $frFonc.c.c <Shift-1>   {CenterAtom %x %y %W}

    set ::BQx [expr {$pgl(width)/2}]
    set ::BQy [expr {$pgl(height)/2}]
    bind $frTogl.c <ButtonPress-1> {set ::BQx %x ; set ::BQy %y}
    #bind $frTogl.c <1>         "LClick %x %y"
    #bind $frTogl.c <B1-Motion> "LDrag %x %y %W"
    bind $frTogl.c <B1-Motion> {QDrag %x %y}

    bind $frTogl.c <2> {set cx %x; set cy %y}
    bind $frTogl.c <3> {set cx %x; set cy %y}

    bind $frTogl.c <B3-Motion> {Mouse TraXY %x %y %W}

    bind $frTogl.c <4> {HandleZoom  0.03 %W}
    bind $frTogl.c <5> {HandleZoom -0.03 %W}

    #bind $wgl <Escape> {AdieuOrdali}
    bind $wgl <Key-F1> [list ToggleWindowMode]
    bind $wgl <Key-F2> [list ToggleShowFrame]
    bind $wgl <Control-Key-p> {PrintOgl}
    bind $wgl <Escape> {ToggleWindowMode escape}

    set ::fact 0.1
    bind $wgl <Control-Key-f> {AdjustFog up}
    bind $wgl <Control-Key-g> {AdjustFog down}
    set ::fogon 1
    bind $wgl <Control-Key-F1> {FogOnOff}
    set ::fogsys "::GL_EXP2"
    bind $wgl <Control-Key-F2> {ChangeFogSys}
    set ::fogcoords "fog"
    bind $wgl <Control-Key-F3> {FogCoords}
    set ::eyepos "zero"
    #bind $wgl <Control-Key-F4> {EyePos}
    
    wm deiconify $wgl
    FenetreAuCentre $wgl

    # put FaireAttendre window on top
    if {[winfo exists .fattendre]} {
	focus -force .fattendre
	raise .fattendre
	wm attributes .fattendre -topmost 1
	update idletasks
    }

    update idletasks

    #rename EnvoieLesObjets EnvoieLesObjetsTmp
    #rename EnvoieLesObjets_wait EnvoieLesObjets

    Update3DMatrices
    EnvoieLesObjets

    #glFlush
    #$pgl(Wogl) postredisplay

    return

}

proc AfficheFenetreOrdali {} {

    global Defauts NomFenetreOrdali

    set menustatus    "    "
    set w [winfo toplevel $NomFenetreOrdali]

    grid rowconfig    $w 2             -weight 1
    grid columnconfig $w 0             -weight 1

    AfficheBarreMenus
    AfficheBarreBoutons
    AfficheBarreMac
    AfficheFrameSequences
    AfficheFrameScores
    AfficheFrameFeatures
    AfficheFrameDebug

    AfficheBoutonsOrdali

    LesDefauts BackAppliOri [$w cget -background]

    return

}

proc AfficheFenetreOverview {Id} {

    global Ovw

    set w ".overview$Id"
    toplevel $w
    wm title $w "Overview No $Id"
    wm iconname $w "Overview $Id"
    wm protocol $w WM_DELETE_WINDOW KillParLaCroix
    wm resizable $w 0 0

    grid columnconfig $w 0 -weight 1
    grid rowconfig    $w 0 -weight 1
    
    set Ovw(O$Id,w) "$w.c"
    set wc "$w.c"
    canvas $w.c  -height 300  -width 500  -background white
    frame $w.btn
    grid $w.c   -row 0 -column 0 -sticky news
    grid $w.btn -row 1 -column 0 -sticky ew -pady 10

    grid columnconfig $w.btn all -weight 0
    ttk::combobox $w.btn.combo  -background white  -state readonly  -height 0  -textvariable Ovw(O$Id,Feat)  -values $Ovw(LFeat)  -width $Ovw(FeatWidth)
    $w.btn.combo index 0
    bind $w.btn.combo <<ComboboxSelected>> "MetAJourDessinOverview $Id %W"
    frame $w.btn.fpm
    button $w.btn.fpm.btm  -text "-"  -background cyan  -command [list ChangeEchelleOverview $Id "moins"]
    button $w.btn.fpm.btp  -text "+"  -background cyan  -command [list ChangeEchelleOverview $Id "plus"]
    grid $w.btn.fpm.btm -row 0 -column 0
    grid $w.btn.fpm.btp -row 0 -column 1

    button $w.btn.btprt  -text "Print"  -background yellow  -command "PrintOverview $wc png"



    button $w.btn.btclose  -text "Close"  -background green1  -command [list DetruitOverview $Id]
    grid $w.btn.combo   -row 0 -column 0
    grid $w.btn.fpm     -row 0 -column 1
    grid $w.btn.btprt   -row 0 -column 2
    grid $w.btn.btclose -row 0 -column 3
    grid columnconfig $w.btn all -weight 1

    return $w

}

proc AfficheFenetreSeqlab {} {

    global TScrollX TScrollY FrmSequence LNOrdali
    global NomNomSeq NomTextSeq wtx wxx LongueurTotale

    set width  [$NomTextSeq cget -width]
    set height [$NomTextSeq cget -height]
    $FrmSequence.biotextsequence configure  -width $width  -height $height

    grid forget $FrmSequence.textsequence
    grid $FrmSequence.biotextsequence  -row 0 -column 1  -rowspan 1 -columnspan 2  -sticky news

    set NomTextSeq $FrmSequence.biotextsequence

    $TScrollX configure -command {CoupleX}
    $TScrollY configure -command {CoupleY}

    update idletasks
    FenetreAuCentre [winfo toplevel $NomTextSeq]

    return

}

proc AfficheFetch {Selection {NomDuFichierOrigine ""}} {


    global RepertoireDuGenome
    global AccessDejaVus

    LogWscope "AfficheFetch $Selection"
    Wup "On cherche la sequence et on l'affiche"
    
    Gs "Frame"

    if {[regexp " " $NomDuFichierOrigine]} {
	foreach Mot [split $NomDuFichierOrigine " "] {
	    if {[regexp "/" $Mot]} { set NomDuFichierOrigine $Mot ; break }
	}
    }
    if {[regexp " " $NomDuFichierOrigine]} { scan $NomDuFichierOrigine "%s" NomDuFichierOrigine }
	
    
    set FormatVoulu ""
    if {$NomDuFichierOrigine=="OnVeutNature"} {
	set FormatVoulu "OnVeutNature"
	set NomDuFichierOrigine ""
    }
    if {[regexp "^OnVeut" $NomDuFichierOrigine]} {
	set FormatVoulu $NomDuFichierOrigine
	set NomDuFichierOrigine ""
    }


    set Nom ""
    if {$NomDuFichierOrigine != "" } {
	set Nom [file tail $NomDuFichierOrigine]
	Wup "NomDuFichierOrigine peut finir par Nom (de PAB)"
	if { ! [YaPABdans $Nom]} {
	    Wup "Recherche du pab si c'est un copain"
	    set Nom [file tail [file dirname $NomDuFichierOrigine]]
	}
	if { ! [YaPABdans $Nom]} { set Nom "" }
    }
    Wup "Si Nom n'est pas vide c'est qu'on a affaire a un PAB"
    
    set LesFramesFetchees {}
    
    set Liste [split $Selection "\n"]
    foreach Ligne $Liste {
	if { ! [regexp -nocase {[a-z0-9_]} $Ligne]} { continue }
	set Ligne [OteSuperfluPourFetch $Ligne]
	scan $Ligne "%s" aPDB
	if {[EstUnAccessPDB $aPDB]} {
	    if {[info exists DejaVu($aPDB)]} { continue }
	    set  DejaVu($aPDB) 1
	    if {[set LaFramePDB [AffichePDB $aPDB]]!=""} { 
		lappend LesFramesFetchees $LaFramePDB
		continue
	    } 
	}

	set BanqueId ""
	set Access ""
	Wup "On cherche d'abord Access dans la ligne"
	if { [regexp "^Query=" $Ligne] } {
	    Wup "C'est une ligne Query"
	    set Access [QueryDeLaLigne $Ligne]
	} elseif  { [regexp "^Name:" $Ligne] } {
	    Wup "C'est une ligne d'un MSF"
	    set Access [lindex [split $Ligne " "] 1]
	} elseif  { [regexp {^(AC|ID) } $Ligne] } {
	    Wup "C'est une ligne d'un EMBL"
	    scan $Ligne "%s %s" AC Access
	} elseif {[regexp -nocase {^[a-z0-9_]+=[a-z0-9_]+ } $Ligne]} {
	    Wup "Ligne descriptif"
	    regsub "=" $Ligne " " Access_BanqueId
	    scan $Access_BanqueId "%s %s" Access BanqueId
	} elseif {[regexp {^[a-zA-Z0-9_]+:[a-zA-Z0-9_]+[ !]* [a-zA-Z0-9_]+} $Ligne]} {
	    Wup "Ligne blast"
	    regsub "!" $Ligne " " BanqueId_Access
	    scan $BanqueId_Access "%s %s" BanqueId Access
	} elseif { [regexp {^[a-zA-Z0-9_]+: +[a-zA-Z0-9_]+} $Ligne]} {
	    Wup "Ligne du type 'Clef: access'"
	    scan $Ligne "%s %s" Bidon Access
	} else {
	    scan $Ligne "%s" Access
	}
	if {$BanqueId==""} { set BanqueId $Access }

	if {$Nom!="" && [OnTraiteUneCollection]} {
	    set FichierCopain "$RepertoireDuGenome/coembl/$Nom/$Access"
	    if {[file exists $FichierCopain]} {
		if {[info exists DejaVu($FichierCopain)]} { continue }
		set  DejaVu($FichierCopain) 1
		lappend LesFramesFetchees [AfficheVariable [ContenuDuFichier $FichierCopain] "AvecBlasteAvecFormate" "$FichierCopain"]
		continue
	    }
	}
	if {[info exists DejaVu($BanqueId,$Access)]} { continue }
	set AccessOk ""
	set LaSeqDesBan [LaSequenceDesBanques $BanqueId $Access AccessOk $FormatVoulu]
	set Sequence [join $LaSeqDesBan "\n"]
	if {$Sequence!=""} {
	    set  DejaVu($BanqueId,$Access) 1
	    lappend LesFramesFetchees [AfficheVariable $Sequence "AvecBlasteAvecFormate" $AccessOk]
	    continue
	}
	Wup "Ici on n'a toujours rien trouve ... "
	set FichierMSF "$RepertoireDuGenome/msf/$Nom"
	if {[info exists DejaVu($FichierMSF)]} { continue }
	if {[YaPABdans $Nom] && [file exists $FichierMSF]} {
	    set Sequence [UneSequenceDuMSF $FichierMSF $Access]
	    set TFA [SequenceFormatTFA $Sequence $Access "protbrut"]
	    if {$TFA!=""} { 
		set  DejaVu($FichierMSF) 1
		lappend LesFramesFetchees [AfficheVariable $TFA "AvecBlasteAvecFormate"]
		continue
	    }
	}
    }
    
    if {[llength $LesFramesFetchees]>0} {
	return [lindex $LesFramesFetchees 0]
    }


}

proc AfficheFetchFromTaxoLine {Ligne {Titre ""}} {


    if {[regexp "\n" $Ligne]} {
	set LesFen {}
	foreach Li [split $Ligne "\n"] {
	    lappend LesFen [AfficheFetchFromTaxoLine $Li $Titre] 
	}
	return $LesFen
    }
    set iDernierDoubleBlanc [string last "  " $Ligne]
    set Access ""
    scan [string range $Ligne $iDernierDoubleBlanc end] "%s" Access
    return [AfficheFetch $Access $Titre]


}

proc AfficheFicheInfo {K} {


    global RepertoireDuGenome
    set Id      [$K find withtag current]
    set MesTags [$K gettags $Id]
    set Nom     [lindex $MesTags 0]

    set Fichier "$RepertoireDuGenome/bilan/$Nom"
    if {![file exists $Fichier]} {
	set Fichier "$RepertoireDuGenome/ProtAndmRNA/$Nom"
    }
    if {[file exists $Fichier]} {
	set Texte [ContenuDuFichier $Fichier]
	AfficheVariable $Texte "" $Fichier
    } else {
	SeeAby Show $Nom
    }
    return


}

proc AfficheFichier {Fichier {Maniere ""}} {


    
    if { $Fichier == "" } return ""
    if { [FileAbsent $Fichier]} {
	if { ! [regexp {.gz$} $Fichier] && [FileExists "$Fichier.gz"]} {
	    return [AfficheFichier "$Fichier.gz" $Maniere]
	}
	FaireLire "I wanted to show the file \n$Fichier\n It doesn't exist. Sorry."
	return ""
    }
    if {[file isdirectory $Fichier]} {
	set Page "[file dirname $Fichier]\n"
	if { ! [regexp "/" $Page]} { set Page "./$Page" }
	append Page [join [lsort [glob -nocomplain "$Fichier/*"]] "\n"]
    } else {
	if {[EstUnFichierImage $Fichier]} { return [ShowImage $Fichier] }
	set Page [ContenuDuFichier $Fichier]
    }
    return [Affiche $Page $Maniere $Fichier]


}

proc AfficheFournisseur {Selection} {


    if {[regexp "\n" $Selection]} {
	foreach Ligne $Selection {
	    AfficheFournisseur $Ligne
	}
	return ""
    }
    if { ! [regexp {P[0-9]+} $Selection P]} { return "" }
    set Fournis [Fournisseur $P]
    if {$Fournis==""} {
	return [AfficheVariable "Sorry. No order file was found for $P" "" "OrderFileOf_$P"]
    }
    scan $Fournis "%s %s" Lieu Fichier
    set Page "$Fichier\n$Lieu"
    if {[file exists $Fichier]} { append Page "\n[ContenuDuFichier $Fichier]" }
    set Fen [AfficheVariable $Page "AvecOli" "OrderFileOf_$P"]
    Illumine $P $Fen
    return $Fen


}

proc AfficheFrameDebug {} {

    # Debuggage
    # Permet de resourcer un fichier (merci rR)
    # Permet d'executer une commande

    global FAS CAE NomFenetreOrdali FrmDebug

    set FrmDebug "$NomFenetreOrdali.fdev"
    frame $FrmDebug
    grid $FrmDebug -row 5 -column 0 -sticky ew -padx 10 -pady 1

    grid columnconfig $FrmDebug {0 2} -weight 0
    grid columnconfig $FrmDebug 1     -weight 1
    grid rowconfig    $FrmDebug 0     -weight 0

    if {! [Devlpt]} {return}

    label $FrmDebug.lblc -text "Command"
    entry $FrmDebug.entc -background white -textvariable CAE
    button $FrmDebug.okc -text " OK " -bg green1 -command "uplevel #0 \[$FrmDebug.entc get\]"

    grid $FrmDebug.lblc -column 0 -row 0 -sticky e
    grid $FrmDebug.entc -column 1 -row 0 -sticky ew
    grid $FrmDebug.okc  -column 2 -row 0 -sticky w

    update

    return

}

proc AfficheFrameFeatures {} {

    global FrmBouton FrmImgM NomNomSeq NomFenetreOrdali OrdEtcDir

    set FrmBouton $NomFenetreOrdali.fbout
    frame $FrmBouton
    grid $FrmBouton -row 4 -column 0 -padx 10 -pady 10 -sticky news

    frame $FrmBouton.fimg
    grid $FrmBouton.fimg -row 0 -column 0 -sticky ""
    
    grid columnconfig $FrmBouton 0 -weight 0
    grid columnconfig $FrmBouton 1 -weight 1
    grid rowconfig    $FrmBouton 0 -weight 1

    set wmac "$FrmBouton.fimg.limg"
    set Wdt [expr {[winfo reqwidth $NomNomSeq] - 10}]
    set fmacsim [file join $OrdEtcDir "MACSIM_50px_cut_transparent.gif"]
    image create photo macsim
    macsim read $fmacsim -shrink
    label $wmac  -image macsim  -anchor n  -width $Wdt
    grid $wmac -row 0 -column 0 -sticky news
    grid columnconfig $FrmBouton.fimg 0 -weight 0
    grid rowconfig    $FrmBouton.fimg 0 -weight 0
    
    return

}

proc AfficheFrameScores {} {

    global FrmScores NomFenetreOrdali

    set w $NomFenetreOrdali
    set FrmScores "$w.scores"
    frame $FrmScores
    grid $FrmScores -row 3 -column 0 -sticky ew

    return

}

proc AfficheFrameSequences {} {

    global LNOrdali Defauts TScrollX TScrollY NomFenetreOrdali
    global NomNomSeq NomTextSeq FrmSequence SearchNom
    global wtn wtx wxx wxn

    set w $NomFenetreOrdali
    set FrmSequence "$w.lessequences"
    frame $FrmSequence
    grid $FrmSequence -row 2 -column 0 -padx 5 -sticky news

    #
    # widgets to display names of sequences, and
    # sequences, with their scrollbars
    #
    set TScrollX   $w.lessequences.scrollxseq
    set TScrollY   $w.lessequences.scrolly
    set NomNomSeq  $w.lessequences.textnomseq
    set NomTextSeq $w.lessequences.textsequence
    set wxn $NomNomSeq
    set wxx $NomTextSeq
    set wtx "$FrmSequence.biotextsequence"

    # Names
    if {[info exists LNOrdali]} {
	set WdtNom [expr {[PlusLongEltDe $LNOrdali]+1}]
	if {$WdtNom > [set Defauts(LongNom)]} {
	    set WdtNom [set Defauts(LongNom)]
	}
    } else {
	set WdtNom 10
    }

    text $w.lessequences.textnomseq  -relief sunken  -bd 2  -font SeqFont  -cursor left_ptr  -yscrollcommand [list .ordali.lessequences.scrolly set]  -setgrid 1  -width $WdtNom  -wrap none  -foreground black  -background white  -selectforeground black  -selectbackground white  -inactiveselectbackground white  -state disabled  -selectborderwidth 0  -autoseparators 0  -undo 1  -highlightthickness 0
    
    # Sequences : biotext widget for seqlab , 
    #             text    widget otherwise
    biotext $FrmSequence.biotextsequence  -yscrollcommand FromScrollYBiotext2Names  -xscrollcommand [list .ordali.lessequences.scrollxseq set]  -height 20  -width 60  -relief sunken  -class Biotext  -bd 0 
    
    text $w.lessequences.textsequence  -xscrollcommand [list .ordali.lessequences.scrollxseq set]  -yscrollcommand [list .ordali.lessequences.scrolly set]  -relief sunken  -height 20  -width 60  -bd 2  -cursor left_ptr  -font SeqFont  -wrap none  -state disabled  -foreground black  -background white  -insertwidth 6  -insertbackground yellow  -selectborderwidth 0  -autoseparators 0  -undo 1  -highlightthickness 0
    
    # position ruler
    text $w.lessequences.regle  -bd 0  -state disabled  -font SeqFont  -cursor left_ptr  -foreground black  -background white  -xscrollcommand [list .ordali.lessequences.scrollxseq set]  -setgrid 1  -wrap none  -height 2
    
    scrollbar $w.lessequences.scrollxseq  -orient horiz  -command [list CoupleX]  -width 8  -bd 2
    scrollbar $w.lessequences.scrolly  -width 8  -command "CoupleY"  -bd 2
    
    # Frame to display cursor position in sequence 
    frame $w.lessequences.fpos  -width 17  -relief sunken  -bd 1
    label $w.lessequences.fpos.tposg  -text "gen "  -relief flat  -width 4  -anchor w
    label $w.lessequences.fpos.vposg  -textvariable XGen  -relief flat  -width 4  -anchor w
    label $w.lessequences.fpos.tposs  -text " seq "  -relief flat  -width 5  -anchor w
    label $w.lessequences.fpos.vposs  -textvariable XSeq  -relief flat  -width 4  -anchor w
    grid $w.lessequences.fpos.tposg -row 0 -column 0 -sticky w
    grid $w.lessequences.fpos.vposg -row 0 -column 1 -sticky w
    grid $w.lessequences.fpos.tposs -row 0 -column 2 -sticky w
    grid $w.lessequences.fpos.vposs -row 0 -column 3 -sticky w
    
    grid columnconfig $w.lessequences.fpos all -weight 0
    grid rowconfig    $w.lessequences.fpos 0 -weight 0

    # entry to search for a sequence name
    entry $w.lessequences.srcnom  -width [expr {$WdtNom-2}]  -textvariable SearchNom  -relief groove -bd 2  -background white
    bind $w.lessequences.srcnom <Return> [list ChercheNom]
    
    # then gridify all that !
    grid $w.lessequences.textnomseq  -row 0 -column 0  -sticky ns
    grid $w.lessequences.textsequence  -row 0 -column 1  -columnspan 2  -sticky news
    grid $w.lessequences.scrolly  -row 0 -column 3  -sticky ns
    grid $w.lessequences.srcnom  -row 1 -column 0  -sticky ew -padx 5
    grid $w.lessequences.regle  -row 1 -column 1  -columnspan 2  -sticky ew
    # ATTENTION
    # on laisse la row 2 vide pour y mettre 
    # le profil de conservation si besoin !
    grid $w.lessequences.fpos  -row 3 -column 1  -sticky w
    grid $w.lessequences.scrollxseq  -row 3 -column 2  -sticky ew

    grid rowconfig    $FrmSequence 0 -weight 1
    grid rowconfig    $FrmSequence {1 2 3} -weight 0
    grid columnconfig $FrmSequence {0 1 3} -weight 0
    grid columnconfig $FrmSequence 2 -weight 1

    $NomTextSeq tag configure TagZoneClus -background green1 -foreground red

    update idletasks

    return

}

proc AfficheGenscanDuContig {Selection} {



    Wup "Shows Genscan output for all contig of selection"

    if {$Selection==""} { return "" }

    set F ""
    foreach Ligne [split $Selection "\n"] {
	scan $Ligne "%s" ChroContig
	set FichierGSC [GenScanEnStock $ChroContig "FileNamePlease"]
	if {$FichierGSC==""} { continue }
	set F [AfficheFichier $FichierGSC "AvecRien"]
	set B [BoutonneLaFenetre $F "See DNA of sel.\nBlastP sel. prot" ""]
	$B configure -background "green"
	bind $B <1> "VoirADNduContig $ChroContig \[selection get\]"
	bind $B <Shift-1> "Blaste P \[selection get\]"
    }
    return $F


}

proc AfficheGroupesDansSeqlab {} {


    global LNSeqlab
    global LSSeqlab
    global NomTextSeq
    global NomNomSeq
    global LNDG
    global SDG

    $NomNomSeq configure -state normal

    set Q 1
    set P 0
    set LStmp {}
    set LNtmp {}
    foreach g $LNDG {
	if {$g == "GroupeToutLeMonde"} {continue}
	$NomTextSeq insert $Q.0 " \n"
	$NomNomSeq  insert $Q.0 " \n"
	set LNSeqlab [linsert $LNSeqlab $P " "]
	lappend LStmp " "
	lappend LNtmp " "
	incr Q
	incr P

	foreach s [set SDG($g)] {
	    set i [lsearch $LNSeqlab $s]
	    set y [expr {$i+1}]
	    set dmpT  [$NomTextSeq dump -tag $y.0 $y.0 lineend]
	    set LtagT [TagsDuDump $dmpT]
	    set Seq   [$NomTextSeq get $y.0 "$y.0 lineend"]

	    lappend LNtmp $s
	    lappend LStmp $Seq

	    set LNSeqlab [lreplace $LNSeqlab $i $i]
	    set LNSeqlab [linsert $LNSeqlab $P $s]
	    $NomTextSeq delete $y.0 [expr {$y+1}].0
	    $NomTextSeq insert $Q.0 "${Seq}\n"
	    $NomNomSeq  delete $y.0 [expr {$y+1}].0
	    if {[regexp {^PDB_[0-9]} $s]} {
		set t PDB
	    } else {
		set t ""
	    }
	    $NomNomSeq  insert $Q.0 "$s\n" $t
	    foreach {t x1 x2} $LtagT {
		$NomTextSeq tag add $t $Q.$x1 $Q.$x2
	    }
	    incr Q
	    incr P
	}
    }

    set LNSeqlab $LNtmp
    set LSSeqlab $LStmp

    $NomNomSeq configure -state disabled

    return

}

proc AfficheHelp {{Quoi ""}} {



    Wup "Permet de donner une petite aide pour les commandes disponibles"

    set    Texte ""
    append Texte "Graph Panel:\n"
    append Texte "------------\n"
    append Texte "   Panel that allows you display or hide,\n"
    append Texte "   \tGraph itself\n"
    append Texte "   \tAverage\n"
    append Texte "   \tAll or none\n\n"
    append Texte "GC Content:\n"
    append Texte "-----------\n"
    append Texte "   Upper  Value: 100% GC bases\n"
    append Texte "   Middle Value: Average composition in GC bases\n"
    append Texte "   Lower  Value: 100% AT bases\n"
    append Texte "   Enter  Display the %GC of the current Position\n\n"
    append Texte "Tm Content:\n"
    append Texte "-----------\n"
    append Texte "   Upper  Value: maximum Tm value\n"
    append Texte "   Middle Value: Average Tm value\n"
    append Texte "   Lower  Value: minimum Tm value\n"
    append Texte "   Enter  Display the Tm of the current Position\n\n"
    append Texte "Identity Percent (Blastn):\n"
    append Texte "--------------------------\n"
    append Texte "   Upper  Value: 100% Id\n"
    append Texte "   Middle Value: Average Id percent\n"
    append Texte "   Lower  Value: 0%   Id\n"
    append Texte "   Enter  Display the %Id of the current Position\n\n"
    append Texte "Sequence Content (Blastn):\n"
    append Texte "--------------------------\n"
    append Texte "   Upper  Value: maximum number of sequence\n"
    append Texte "   Middle Value: Average number of sequence\n"
    append Texte "   Lower  Value: minimum number of sequence\n"
    append Texte "   Enter  Display the number of sequence under the current Position\n\n"
    append Texte "Query:\n"
    append Texte "------\n"
    append Texte "   Mouse 1 Basic nucleic informations (GC, length, Tm ...)\n"
    append Texte "   Mouse 2 Fetch Sequence (informations from the bank)\n"
    append Texte "   Mouse 3 Display Query s Sequence in fasta format\n\n"
    append Texte "Oligonucleotide (Probe):\n"
    append Texte "------------------------\n"
    append Texte "   Enter   Display Information about the current Oligo\n"
    append Texte "   Mouse 1 Display the Position regarding the Query\n"
    append Texte "   Mouse 2 Display Oligo s specificity\n"
    append Texte "   Mouse 3 Display Oligo s Sequence (fasta format)\n"
    append Texte "   Shift  -2 Display Oligo s specificity in detail\n"
    append Texte "   Control-1 Select the oligonucleotide for that database\n"
    append Texte "   Control-2 Select the oligonucleotide as X-Selection"

    if {$Quoi=="DuBouton"} {
	after idle {   .fairelire.msg configure -wraplength 10i -background red -font "Courier 12"}
	tk_dialog      .fairelire "Please press OK" "$Texte" {} 0 Acknowledge
	catch {destroy .fairelire}
	return ""
    } else {return $Texte}


}

proc AfficheHelpDuPrimer {{Quoi ""}} {



    Wup "Permet de donner une petite aide pour les commandes disponibles"

    set    Texte ""
    append Texte "Graph Panel:\n"
    append Texte "------------\n"
    append Texte "   Panel that allows you display or hide,\n"
    append Texte "   \tGraph itself\n"
    append Texte "   \tAverage\n"
    append Texte "   \tAll or none\n\n"
    append Texte "GC Content:\n"
    append Texte "-----------\n"
    append Texte "   Upper  Value: 100% GC bases\n"
    append Texte "   Middle Value: Average composition in GC bases\n"
    append Texte "   Lower  Value: 100% AT bases\n"
    append Texte "   Enter  Display the %GC of the current Position\n\n"
    append Texte "Tm Content:\n"
    append Texte "-----------\n"
    append Texte "   Upper  Value: maximum Tm value\n"
    append Texte "   Middle Value: Average Tm value\n"
    append Texte "   Lower  Value: minimum Tm value\n"
    append Texte "   Enter  Display the Tm of the current Position\n\n"
    append Texte "Query:\n"
    append Texte "------\n"
    append Texte "   Mouse 1 Basic nucleic informations (GC, length, Tm ...)\n"
    append Texte "   Mouse 2 Fetch Sequence (informations from the bank)\n"
    append Texte "   Mouse 3 Display Query s Sequence in fasta format\n\n"
    append Texte "Primer:\n"
    append Texte "-------\n"
    append Texte "   Enter   Display Information about the current Primer\n"
    append Texte "   Mouse 1 Display the Position regarding the Query\n"
    append Texte "   Mouse 2 Display Primer s informations\n\n"
    append Texte "Amplified Region:\n"
    append Texte "-----------------\n"
    append Texte "   Enter   Display Information about the current Region\n"
    append Texte "   Mouse 1 Display the Position regarding the Query\n"
    append Texte "   Mouse 2 Display Region s sequence"

    if {$Quoi=="DuBouton"} {
	after idle {.fairelire.msg configure -wraplength 10i -background red -font "Courier 12"}
	tk_dialog      .fairelire "Please press OK" "$Texte" {} 0 Acknowledge
	catch {destroy .fairelire}
	return ""
    } else {return $Texte}


}

proc AfficheHelpInfoDeMaSequence {{Quoi ""}} {



    Wup "Permet de donner une petite aide pour les commandes disponibles"

    set Texte ""
    append Texte "Designing Help:\n"
    append Texte "---------------\n"
    append Texte "You are able to display, select and save designing area(s).\n"
    append Texte "   Shift  -1             Show position on the query\n"
    append Texte "   Control-1             Put one Flag for area selection\n\n"
    append Texte "   Mouse 1(Green button) Show previously areas (in the Panel)\n"
    append Texte "   Mouse 2(Green button) Save areas (!!It overwrite previous!!)\n"
    append Texte "   Mouse 3(Green button) Clear areas\n"

    append Texte "Graph Panel:\n"
    append Texte "------------\n"
    append Texte "   Panel that allows you display or hide,\n"
    append Texte "   \tGraph itself\n"
    append Texte "   \tAverage\n"
    append Texte "   \tAll or none\n\n"

    append Texte "GC Content:\n"
    append Texte "-----------\n"
    append Texte "   Upper  Value: 100% GC bases\n"
    append Texte "   Middle Value: Average composition in GC bases\n"
    append Texte "   Lower  Value: 100% AT bases\n"
    append Texte "   Enter  Display the %GC of the current Position\n\n"

    append Texte "Tm Content:\n"
    append Texte "-----------\n"
    append Texte "   Upper  Value: maximum Tm value\n"
    append Texte "   Middle Value: Average Tm value\n"
    append Texte "   Lower  Value: minimum Tm value\n"
    append Texte "   Enter  Display the Tm of the current Position\n\n"
		  
    append Texte "Query:\n"
    append Texte "------\n"
    append Texte "   Mouse 2 Fetch Sequence (informations from the bank)\n"
    append Texte "   Mouse 3 Display Query s Sequence in fasta format"
		  
    if {$Quoi=="DuBouton"} {
	after idle {.fairelire.msg configure -wraplength 10i -background red -font "Courier 12"}
	tk_dialog .fairelire "Please press OK" "$Texte" {} 0 Acknowledge
	catch {destroy .fairelire}
	return ""
    } else {return $Texte}


}

proc AfficheHelpOligoArray {{Quoi ""}} {



    Wup "Permet de donner une petite aide pour les commandes disponibles"

    set Texte ""
    append Texte "GC Content:\n"
    append Texte "   Upper  Value: 100% GC bases\n"
    append Texte "   Middle Value: Average composition in GC bases\n"
    append Texte "   Lower  Value: 100% AT bases\n"
    append Texte "   Enter  Display the %GC of the current Position\n"
		  
    append Texte "Query:\n"
    append Texte "   Mouse 2 Fetch Sequence (informations from the bank)\n"
    append Texte "   Mouse 3 Display Query's Sequence in fasta format\n"
		  
    append Texte "Oligonucleotide (Probe):\n"
    append Texte "   Mouse 1 Display the Position regarding the Query\n"
    append Texte "   Mouse 2 Display Oligo's specificity\n"
    append Texte "   Mouse 3 Display Oligo's Sequence (fasta format)\n"
    append Texte "   Enter   Display Information about the current Oligo"

    if {$Quoi=="DuBouton"} {
	return "[AfficheVariable $Texte "SansRien" "Help"]"
    } else {return $Texte}


}

proc AfficheInfoBulle {K X Y Action} {



    Wup "Permet d avoir des InfoBulles pour des Id dans un canvas"    
    Wup "Ces InfosBulles sont independantes du canvas"
    
    catch {destroy .infobulle}

    if {$Action=="Leave"} {return ""}
    
    set Id      [$K find withtag current]
    set MesTags [$K gettags $Id]
    set Texte   [lindex $MesTags 1]

    #Les coordonnees de l Id a InfoBuller
    set MesCoords [$K coords $Id]
    set Xmin      [lindex $MesCoords 0]
    set Xmax      [lindex $MesCoords 2]
    set Ymin      [lindex $MesCoords 1]
    set Ymax      [lindex $MesCoords 3]

    #Cas particulier des lignes verticales on prend comme repere la position de la souris
    if {$Ymin==$Ymax} {set Xmin $X;set Xmax $X}
    #Correction pour ceux avec seulement 2 coordonnees
    if {$Xmax==""} {set Xmax $Xmin}
    if {$Ymax==""} {set Ymax $Ymin}

    #Il nous faut les mensurations de l objet a InfoBuller
    if {$Xmax>$Xmin} {
	set TagLargeur [expr $Xmax-$Xmin]
    } else {
	set TagLargeur [expr $Xmin-$Xmax]
	set Xtmp $Xmin
	set Xmin $Xmax
	set Xmax $Xtmp
    }
    if {$Ymax>$Ymin} {
	set TagHauteur [expr $Ymax-$Ymin]
    } else {
	set TagHauteur [expr $Ymin-$Ymax]
	set Ytmp $Ymin
	set Ymin $Ymax
	set Ymax $Ytmp
    }

    #Les positions initiales du canvas contenant Id
    set PosX [winfo rootx $K]
    set PosY [winfo rooty $K]

    #Correction pour le facteur de Zoom
    set Facteurx [ZoomFacteur $K X]
    #set Facteury [ZoomFacteur $K Y]
    set Xmin     [expr $Xmin/$Facteurx]
    set Xmax     [expr $Xmax/$Facteurx]

    #Creation du InfoBulle independant du canvas
    toplevel .infobulle -background "black"
    wm overrideredirect .infobulle 1
    label .infobulle.label  -text       "$Texte"  -relief     "flat"  -font       {Courier 8}  -background "lightyellow"  -foreground "black"  -padx       "2"  -pady       "0"  -anchor     "w"  -justify    "left"

    #1 Creation
    pack .infobulle.label -side "left" -padx "1" -pady "1"
    #2 On Oublie
    wm withdraw .infobulle
    update
    if {! [winfo exists .infobulle]} {return ""} 
    #3 Recuperation des mensurations
    set MessageLargeur [winfo width  .infobulle]
    set MessageHauteur [winfo height .infobulle]
    if {$MessageLargeur=="1" && $MessageHauteur=="1"} {
	set MessageLargeur [winfo reqwidth  .infobulle]
	set MessageHauteur [winfo reqheight .infobulle] 
    }
    
    #4 Ajustement des positions de l InfoBulle
    #4 Par rapport a l objet a infobuller
    #4 Par rapport a sa position sur l ecran
    #Sur Beaufort le withdraw empeche d avoir la taille de la fenetre voir mise a jour
    #Mais le reqwidth et le reqheight contourne le pb
    set OnForceADroite 1
    set OnForceEnBas   0
    if {$MessageHauteur==1} {set OnForceADroite 0}
    if {$MessageLargeur==1} {set OnForceEnBas   1}

    set EcranHauteur [winfo screenheight .]
    set EcranLargeur [winfo screenwidth  .]
    if {$OnForceADroite && $X > [expr $EcranLargeur/2]} {
	#On affiche a gauche
	incr X -15
	while {$X>$Xmin} {incr X -15}
	set PosX [expr $PosX - $MessageLargeur +$X]
    } else {
	#On affiche a droite
	incr X 15
	while {$X<$Xmax} {incr X 15}
	set PosX [expr $PosX + $X]
    }
    if {$OnForceEnBas || $Y< 50} {
	#On affiche en bas
	incr Y 10 
	set PosY [expr $PosY + $Y]
    } else {
	#On affiche en haut
	incr Y -10 
	set PosY [expr $PosY - $MessageHauteur +$Y]
    }

    set PosX [format "%.0f" $PosX]
    set PosY [format "%.0f" $PosY]

    #Ajustement final des positions de l InfoBulle et positionnement
    if {$PosX<0} {
	#On sort de l ecran par la gauche
	set PosX 0
    } elseif {[expr $PosX + $MessageLargeur]> $EcranLargeur} {
	#On sort de l ecran par le droite
	set PosX [expr $EcranLargeur - $MessageLargeur]
    }
    if {$PosY<0} {
	#On sort de l ecran par le dessus
	set PosY 0
    } elseif {[expr $PosY + $MessageHauteur]> $EcranHauteur} {
	#On sort de l ecran par le dessous
	set PosY [expr $EcranHauteur - $MessageHauteur]
    }

    wm geometry .infobulle +${PosX}+${PosY}
           bind .infobulle <Leave>   "destroy .infobulle"
           bind .infobulle <1>       "destroy .infobulle"
           bind $K         <Destroy> "destroy .infobulle"
    #5 Apres avoir oublie la fenetre on se souvient
    wm deiconify .infobulle
    return ""


}

proc AfficheLEnvironnementDeGscope {{Comment ""} {Quoi ""}} {


    global env
    global InfoScript
    global FichierGscopeSource
    global WithPackage

    if {$Comment==""} { set Comment "Show" }

    set LaPage {}
    catch {lappend LaPage [format "%-30s %s" RunningSince "[CaVa RunningSinceDate] as [CaVa Science]"] } 
    catch {lappend LaPage [format "%-30s %s" HostName [Hostname]]}
    catch {lappend LaPage [format "%-30s %s" Dialog [DialogPort "GetAll"]]}
    catch {lappend LaPage [format "%-30s %s" GscopeDir [GscopeDir]]} 
    catch {lappend LaPage [format "%-30s %s" GscopeContrib [GscopeContrib]] }
    catch {lappend LaPage [format "%-30s %s" GscopeSource $FichierGscopeSource]} 
    catch {lappend LaPage [format "%-30s %s" RepertoireDuGenome [RepertoireDuGenome]]} 
    catch {lappend LaPage [format "%-30s %s" RepertoireDeTravail [RepertoireDeTravail]]}
    catch {lappend LaPage [format "%-30s %s" HumanGenomeDir [HumanGenomeDir]]}
    catch {lappend LaPage [format "%-30s %s" OntologyDir [OntologyDir]]}
    catch {lappend LaPage ""}
    catch {lappend LaPage [format "%-30s %s" script [InfoScript]] }
    catch {lappend LaPage ""}
    catch {lappend LaPage [format "%-30s %s" OutsideCSTB [OutsideCSTB]] }
    lappend LaPage ""
    foreach P [array names WithPackage] {
	if {[regexp "Default" $P]} { continue }
	lappend LaPage [format "%-30s %s" "Pack $P" [WithPackage $P]] 
    }
    if {$Quoi!="WithoutEnv"} {
	lappend LaPage ""
	foreach V [array names env] {
	    lappend LaPage [format "%-30s %s" $V [set env($V)]] 
	}
    }
    set Display "not set"
    if {[info exists env(DISPLAY)]} { set Display $env(DISPLAY) }
    lappend LaPage [format "%-30s %s" DISPLAY $Display]

    set Page [join $LaPage "\n"]
    if {$Comment=="GetItAsText"} { return $Page }
    if {[PourWscope]} { return [Html_DuTexteTelQuel $Page] }
    if {$Comment=="GetIt"} { return $Page }
    return [AfficheVariable $Page "" "Gscope's environment"]


}

proc AfficheLaProc {Procedure} {



    Wup "Shows the proc Procedure or lappend to the called procs"

    scan [string trim $Procedure] "%s" Procedure

    if {[info procs $Procedure]=={}} { return "" }
 
    set Args [info args $Procedure]
    set Body [info body $Procedure]
    set TexteProc "$Procedure {$Args} {\n$Body\n}"

    if {[PourWscope]} { return [Html_DuTexteTelQuel $TexteProc] }

    return [ShowText $TexteProc "SansFetchAvecRienAvecCallProcGrandeLargeur" $Procedure]


}

proc AfficheLaQuery {K FichierQuery} {



    Wup "Permet d afficher la sequence tfa de la query"
    
    if {!  [file exists $FichierQuery]} {
	if {[regexp {/} $FichierQuery]} {
	    set PAB [file tail $FichierQuery]
	} else {
	    set PAB $FichierQuery
	}
	set RepmRNA   "[RepertoireDuGenome]/mrnatfa_Homo_sapiens"
	set Repnuctfa "[RepertoireDuGenome]/nuctfa"
	if {      [file exists "$RepmRNA/$PAB"]} {
	    set FichierQuery   "$RepmRNA/$PAB"
	} elseif {[file exists "$Repnuctfa/$PAB"]} {
	    set FichierQuery   "$Repnuctfa/$PAB"
	} else {set FichierQuery ""}
    }
    if {$FichierQuery == ""} {return [AfficheVariable "No sequence file for $FichierQuery"]}
    set LeTFADeLaQuery [join [LesLignesDuFichier $FichierQuery] "\n"]

    return "[AfficheVariable $LeTFADeLaQuery "" "$FichierQuery"]"


}

proc AfficheLaRechercheDansLesBody {{Texte ""}} {


    set LesTrouvees [RechercheDansLesBody $Texte]
    if {$LesTrouvees=={}} { return "" }
    return [ShowText [join $LesTrouvees "\n"]  "SansFetchAvecRienAvecAffiProc" "Procs containing your text."]


}

proc AfficheLaSeqTFA {K Action} {


    global RepertoireDuGenome

    regsub ".canvas" $K ".message" M
    catch {destroy $M}

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set DQ     [lindex $MesTags 0]
    set FQ     [lindex $MesTags 1]
    set DS     [lindex $MesTags 2]
    set FS     [lindex $MesTags 3]
    set Strand [lindex $MesTags 4]
    set Type   [lindex $MesTags 5]
    set nType  [lindex $MesTags 6]
    set SeqTFA [lindex $MesTags 7]
 
    AfficheVariable $SeqTFA "AvecFormateAvecBlaste"
    return ""


}

proc AfficheLaSequenceDeLOligo {K PAB} {



    Wup "Affiche la sequence tfa de l oligo du PAB voulu"
    Wup "Mise a jour pour InterrogeInfoDeOligo"
        
    set Id       [$K find withtag current]
    set MesTags  [$K gettags $Id]
    set NomOligo [lindex $MesTags 4]
    set Dir      [lindex $MesTags 5]

    set Fichier "$Dir/${PAB}.oligo"
    if {! [file exists $Fichier]} {
	set Fichier "$Dir/$PAB"
	if {! [file exists $Fichier]} {return ""}
    }
    set Entete     ">$PAB $NomOligo"
    set Sequence   [InterrogeInfoDeLOligo $Fichier $NomOligo Sequence]
    set TFADeOligo [join [list $Entete $Sequence] "\n"]
    
    return [AfficheVariable $TFADeOligo "AvecFormateAvecBlaste" "$Dir/$PAB"]


}

proc AfficheLabels {} {

    if {$::pgl(Text2Show) == {} } {
	return
    } else {
	set Lxt $::pgl(Text2Show)
	if {$::pgl(TextDeDist) != {}} {
	    lappend Lxt {*}$::pgl(TextDeDist)
	}
    }

    # recup de la matrice de modelisation
    set mvmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
    set modmat [tcl3dVectorToList $mvmatrix 16]

    # recup de la matrice de projection
    set pjmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_PROJECTION_MATRIX $pjmatrix
    set pgl(projmat) [tcl3dVectorToList $pjmatrix 16]
    set projmat $pgl(projmat)

    # Recup du viewport
    set viewmat [tcl3dVector GLint 4]
    glGetIntegerv GL_VIEWPORT $viewmat
    set pgl(viewport) [tcl3dVectorToList $viewmat 4]
    set viewport $pgl(viewport)

    # print the string
    glMatrixMode GL_MODELVIEW
    glPushMatrix
    glLoadIdentity

    foreach {x y z text} $Lxt {
	set xa [expr {[lindex $modmat 0]*$x + [lindex $modmat 4]*$y + [lindex $modmat 8]*$z + [lindex $modmat 12]}]
	set ya [expr {[lindex $modmat 1]*$x + [lindex $modmat 5]*$y + [lindex $modmat 9]*$z + [lindex $modmat 13]}]
	set za [expr {[lindex $modmat 2]*$x + [lindex $modmat 6]*$y + [lindex $modmat 10]*$z + [lindex $modmat 14]}]

	glRasterPos3f $xa $ya $za

	printString $text
    }

    glPopMatrix

    return

}

proc AfficheLeBlastNDuContig {K x y} {


    global RepertoireDuGenome

    set Id [$K find withtag current]
    set QueryFraction   [lindex [$K gettags $Id] 0]
    scan $QueryFraction "%s %s" Contig Fraction

    set w [AfficheFichier "$RepertoireDuGenome/blastn/TTH-$Contig" "AvecRien"]
    Illumine $Fraction $w


}

proc AfficheLeClusterXHda {Nom} {



    set LeClusterXHda [LeClusterXHda $Nom]
  
    if {$LeClusterXHda=={}} {
	FaireLire "No cluster available"
	return ""
    }
    foreach PAB $LeClusterXHda {
	set DE [DefinitionApproximative $PAB]
	lappend LeTexte "$PAB $DE"
    }

    #Jean a rajoute Tri et bind3
    set Texte [join $LeTexte "\n"]
    set Fen [AfficheVariable $Texte "AvecRien" "${Nom}_X-HDA_cluster"]
    set   B [BoutonneLaFenetre $Fen "X-HDA Sel/Sort\nAll/Sort\nInfoClust/OntoClust/Dpc"]
    bind $B <1>       "CreeEtAfficheUnBilanHDACroises \[selection get\]"
    bind $B <2>       "CreeEtAfficheUnBilanHDACroises \[selection get\] AvecTri"
    bind $B <Shift-1> "CreeEtAfficheUnBilanHDACroises \[set PagePropre($Fen)\]"
    bind $B <Shift-2> "CreeEtAfficheUnBilanHDACroises \[set PagePropre($Fen)\] AvecTri"
    bind $B <Control-1> "AfficheLesInfosDuCluster"
    bind $B <Control-2> "OntologyDesClusters \[set PagePropre($Fen)\]"
    bind $B <Control-3> "DpcShow"
         $B configure -background "green"

    return $Fen


}

proc AfficheLeNombreDeResidusDansLesDomaines {FichierMSF FichierBornes} {


    foreach Ligne [LesLignesDuFichier $FichierBornes] {
	scan $Ligne "%s %s" D F 
	set LesComptes [LeNombreDeResidusDansLeDomaine $FichierMSF $D $F]
	EspionneL $LesComptes
	foreach Compte $LesComptes {
	    scan $Compte "%s %d" Access nRes
	    if { ! [info exists DejaVu($Access)]} { lappend LesAccess $Access }
	    set DejaVu($Access) 1
	    lappend LesResultats($Access) $D $F $nRes 
	}
    }
    foreach Access $LesAccess {
	set Ligne [format "%-10s" $Access]
	foreach {D F nRes} [set LesResultats($Access)] {
	    append Ligne [format "%5s-%4s=%4s  " $D $F $nRes]
	}
	lappend LesLignes $Ligne
    }
    return [AfficheVariable [join $LesLignes "\n"] "" "ResidueCountOf_$FichierMSF"]
    


}

proc AfficheLePlot {K} {


    global RepertoireDuGenome

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set Chro [lindex $MesTags 0]
    set TypeCGH [lindex $MesTags 4]
    ### transformation de la val en log base 10 (oligo CGH) en log base 2
    if {$TypeCGH!="CGH"} {
	set Val [format "%.2f" [expr [lindex $MesTags 3] *1.0]]
	set Val [format "%.2f" [expr $Val*log(10)/log(2)] *1.0]
	set Posinf [lindex $MesTags 1]
	set Possup [lindex $MesTags 2]
	regsub -all {^0*} $Posinf "" Posinf
	regsub -all {^0*} $Possup "" Possup
	set PosMid [expr $Posinf + (($Possup*1.0 - $Posinf*1.0)/2)]
    } else {
	set Val [format "%.2f" [expr [lindex $MesTags 2] *1.0]]
	set PosMid [lindex $MesTags 1]
    }
    set Texte "$Chro\nPosMid: $PosMid\nLog2ratio: $Val"

    ac_AfficheVariable "$Texte" "" "Summary"

    return "$Texte"


}

proc AfficheLePlotAffy {K} {


    global RepertoireDuGenome

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set ProbeSet [lindex $MesTags 0]
    set PosMid [lindex $MesTags 1]
    set Val [format "%.2f" [expr [lindex $MesTags 2] *1.0]]
    if {[lindex $MesTags 3]!="Affy"} {
	set C [lindex $MesTags 3]
	regsub -all "chr" $C " chr" C
	set Texte "$ProbeSet\nPosMid: $PosMid\nVal: $Val\n!!! This probeset is multi-located ($C)!!!"
	ac_AfficheVariable "$Texte" "" "Warning"
    } else {
	set Texte "$ProbeSet\nPosMid: $PosMid\nVal: $Val"
	ac_AfficheVariable "$Texte" "" "Summary"
    }
    return "$Texte"


}

proc AfficheLeSpectreGC {K MinSpectreY MaxSpectreY} {


    global RepertoireDuGenome

    set FichierSpectre "$RepertoireDuGenome/fiches/spectregcxy"

    if { ! [file exists $FichierSpectre]} { return }

    set HauteurDuSpectreY [expr $MaxSpectreY-$MinSpectreY]
    
    set LesCoordonnees ""
    set n 0
    set PremiereLigne 1
    foreach Ligne [LesLignesDuFichier $FichierSpectre] {
	if {$PremiereLigne} {
	    scan $Ligne "%d %d" xMin yMin
	    set PremiereLigne 0
	    set DeuxiemeLigne 1
	    continue
	}
	if {$DeuxiemeLigne} {
	    scan $Ligne "%d %d" xMax yMax
	    set DeuxiemeLigne 0
	    set TroisiemeLigne 1
	    continue
	}
	if {$TroisiemeLigne} {
	    scan $Ligne "%d %d" x yMoyen
	    set TroisiemeLigne 0
	    $K create line  $xMin [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $xMax [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]
	    $K create line  $xMin [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $xMax [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]
	    $K create line  $xMin [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $xMax [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]
	    continue
	}

	scan $Ligne "%d %d" x y
	set XY " $x [expr $MaxSpectreY-($y-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)] "
	append LesCoordonnees $XY
	if {[incr n] > 100} {
	    eval $K create line $LesCoordonnees
	    set LesCoordonnees $XY
	    set n 1
	}
    }
    if { $n > 1 } { 
	    eval $K create line $LesCoordonnees
    }


}

proc AfficheLeSpectreGCDUneListe {K UneListe XDebutQuery XFinQuery MinSpectreY MaxSpectreY {OneNtPixel ""} {ColorLine black} {TagDuGraph GC}} {


    global RepertoireDuGenome

    Wup "Affiche le spectre GC pour IllustreOligo"

    if {$OneNtPixel==""} {set OneNtPixel 1}

    set HauteurDuSpectreY [expr $MaxSpectreY-$MinSpectreY]
     
    set n 0
    set PremiereLigne 1
    foreach Ligne $UneListe {
	if {$PremiereLigne} {
	    scan $Ligne "%d %d" xMin yMin
	    #Mise a l echelle plus debut de la query
	    #set xMin [expr $XDebutQuery + [expr $xMin * $OneNtPixel]]
	    set VraiyMin [expr $yMin*1.0]
	    set yMin 0

	    set PremiereLigne 0
	    set DeuxiemeLigne 1
	    continue
	}
	if {$DeuxiemeLigne} {
	    scan $Ligne "%d %d" xMax yMax
	    #set xMax [expr $XFinQuery   + [expr $xMax * $OneNtPixel]]
	    #set xMax [expr $XDebutQuery + [expr $xMax * $OneNtPixel]]
	    set VraiyMax [expr $yMax*1.0]
	    set yMax 100	    
	    
	    set DeuxiemeLigne 0
	    set TroisiemeLigne 1
	    continue
	}
	if {$TroisiemeLigne} {
	    scan $Ligne "%f %f" x yMoyen
	    #set xMin   [expr $x * $OneNtPixel]
	    
	    set TroisiemeLigne 0
	    $K create text [expr $XDebutQuery-5] [expr $MaxSpectreY-($HauteurDuSpectreY/4)+(($HauteurDuSpectreY/4)/2)]  -text "% GC"  -tags [list "" "Echelle $yMin a $yMax\nMin $VraiyMin Max $VraiyMax" "Affichable" "OligoGraph" "$TagDuGraph"]  -fill $ColorLine -anchor e
	    
	    #Ligne 0% de GC
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]  -fill $ColorLine
	    
	    #Ligne Moyenne
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "Moy GC [format "%4.1f" $yMoyen]%" "Affichable" "OligoGraph" "$TagDuGraph" "AverageGC"]  -fill $ColorLine  -dash {6 4}
	    
	    #Ligne 100% de GC
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]  -fill $ColorLine
	    continue
	}
	scan $Ligne "%f %f" x y
	
	set X [expr $XDebutQuery + [expr $x * $OneNtPixel]]
	set Y [expr $MaxSpectreY-((($y-$yMin)*($HauteurDuSpectreY))/($yMax-$yMin))]
	
	incr n
	if { $n > 1 } { 
	    $K create line [set Coordonnees(LastX)] [set Coordonnees(LastY)] $X $Y  -tags [list "" "[format "%.1f" [expr ([set Coordonnees(VraiY)]+$y)/2]] % GC" "Affichable" "OligoGraph" "$TagDuGraph"]  -fill $ColorLine
	    set n 1
	}
	set Coordonnees(VraiY) $y
	set Coordonnees(LastX) $X
	set Coordonnees(LastY) $Y
	lappend LesPoints "$X $Y $y"
    }
 
    foreach Coord $LesPoints {
	set X  [lindex $Coord 0]
	set Y  [lindex $Coord 1]
	set GC [lindex $Coord 2]
	$K create line $X $Y $X $Y  -fill "$ColorLine"  -tags [list "" "[format "%.1f" $GC] % GC" "Affichable" "OligoGraph" "$TagDuGraph"] 
    }

    if {[info exists Coordonnees]} {array unset Coordonnees}
    return ""


}

proc AfficheLeSpectreGCenCouleur {K PosLineY} {


    global RepertoireDuGenome
    
    foreach Ligne [LesLignesDuFichier "$RepertoireDuGenome/fiches/spectregc"] {
	scan $Ligne "%d %d %s" d f Couleur
	if {[regexp "green" $Couleur]} { continue }
	$K create line $d $PosLineY $f $PosLineY -fill $Couleur -width 5
    }


}

proc AfficheLeSpectreIdDUneListe {K UneListe XDebutQuery XFinQuery MinSpectreY MaxSpectreY {OneNtPixel ""} {ColorLine black} {TagDuGraph ""}} {


    global RepertoireDuGenome

    Wup "Affiche le spectre du Nb de sequence pour IllustreOligo"

    if {$OneNtPixel==""} {set OneNtPixel 1}

    set HauteurDuSpectreY [expr $MaxSpectreY-$MinSpectreY]

    set n 0
    set PremiereLigne 1
    foreach Ligne $UneListe {
	if {$PremiereLigne} {
	    scan $Ligne "%d %f" yMin VraiyMin
	    set PremiereLigne 0
	    set DeuxiemeLigne 1
	    continue
	}
	if {$DeuxiemeLigne} {
	    scan $Ligne "%d %f" yMax VraiyMax
	    set DeuxiemeLigne 0
	    set TroisiemeLigne 1
	    continue
	}
	if {$TroisiemeLigne} {
	    scan $Ligne "%d %f" yMoyen VraiyMoyen
	    	    	    
	    set TroisiemeLigne 0

	    $K create text [expr $XDebutQuery-5] [expr $MaxSpectreY-(2*$HauteurDuSpectreY/4)+(($HauteurDuSpectreY/4)/2)]  -text "% Id"  -tags [list "" "$TagDuGraph\nEchelle $yMin a $yMax\nMin $VraiyMin Max $VraiyMax" "Affichable" "OligoGraph" "$TagDuGraph"]  -fill $ColorLine -anchor e
        
	    #Ligne min de nb seq 0
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]
	    
	    #Ligne Moyenne
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "Moy Id [format "%4.1f" $yMoyen]%" "Affichable" "OligoGraph" "$TagDuGraph" "Average$TagDuGraph"]  -fill "$ColorLine"  -dash {6 4}

	    #Ligne de max nbseq
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]
	    continue
	}
	scan $Ligne "%f %f" x y
	
	set X [expr $XDebutQuery + [expr $x * $OneNtPixel]]
	set Y [expr $MaxSpectreY-((($y-$yMin)*($HauteurDuSpectreY))/($yMax-$yMin))]
	
	incr n
	if {$n > 1} { 
	    $K create line [set Coordonnees(LastX)] [set Coordonnees(LastY)] $X $Y  -tags [list "" "[format "%.1f" [expr ([set Coordonnees(VraiY)]+$y)/2]] % Id" "Affichable" "OligoGraph" "$TagDuGraph"]  -fill "$ColorLine"
	    set n 1
	}
	set Coordonnees(VraiY) $y
	set Coordonnees(LastX) $X
	set Coordonnees(LastY) $Y
	lappend LesPoints "$X $Y $y"
    }
 
    foreach Coord $LesPoints {
	set X  [lindex $Coord 0]
	set Y  [lindex $Coord 1]
	set Id [lindex $Coord 2]
	$K create line $X $Y $X $Y  -fill "$ColorLine"  -tags [list "" "[format "%.1f" $Id] % Id" "Affichable" "OligoGraph" "$TagDuGraph"] 
    }
    if {[info exists Coordonnees]} {array unset Coordonnees}
    return ""


}

proc AfficheLeSpectreNbSequenceDUneListe {K UneListe XDebutQuery XFinQuery MinSpectreY MaxSpectreY {OneNtPixel ""} {ColorLine black} {TagDuGraph ""}} {


    global RepertoireDuGenome

    Wup "Affiche le spectre du Nb de sequence pour IllustreOligo"

    if {$OneNtPixel==""} {set OneNtPixel 1}

    set HauteurDuSpectreY [expr $MaxSpectreY-$MinSpectreY]

    set n 0
    set PremiereLigne 1
    foreach Ligne $UneListe {
	if {$PremiereLigne} {
	    scan $Ligne "%d %f" yMin VraiyMin
	    set PremiereLigne 0
	    set DeuxiemeLigne 1
	    continue
	}
	if {$DeuxiemeLigne} {
	    scan $Ligne "%d %f" yMax VraiyMax
	    set DeuxiemeLigne 0
	    set TroisiemeLigne 1
	    continue
	}
	if {$TroisiemeLigne} {
	    scan $Ligne "%d %f" yMoyen VraiyMoyen
	    	    	    
	    set TroisiemeLigne 0
	    $K create text [expr $XDebutQuery-5] [expr $MaxSpectreY-(4*$HauteurDuSpectreY/4)+(($HauteurDuSpectreY/4)/2)]  -text "nSeq"  -tags [list "" "$TagDuGraph\nEchelle $yMin a $yMax\nMin $VraiyMin Max $VraiyMax" "Affichable" "OligoGraph" "$TagDuGraph"]  -fill $ColorLine -anchor e

	    #Ligne min de nb seq 0
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]
	    
	    #Ligne Moyenne
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "Moy NbSeq [format "%3.1f" $yMoyen]" "Affichable" "OligoGraph" "$TagDuGraph" "Average$TagDuGraph"]  -fill "$ColorLine"  -dash {6 4}
	    
	    #Ligne de max nbseq
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]
	    continue
	}
	scan $Ligne "%d %d" x y
	
	set X [expr $XDebutQuery + [expr $x * $OneNtPixel]]
	set Y [expr $MaxSpectreY-((($y-$yMin)*($HauteurDuSpectreY))/($yMax-$yMin))]
	
	incr n
	if {$n > 1} { 
	    $K create line [set Coordonnees(LastX)] [set Coordonnees(LastY)] $X $Y  -tags [list "" "[expr ([set Coordonnees(VraiY)]+$y)/2] seq(s)" "Affichable" "OligoGraph" "$TagDuGraph"]  -fill "$ColorLine"
	    set n 1
	}
	set Coordonnees(VraiY) $y
	set Coordonnees(LastX) $X
	set Coordonnees(LastY) $Y
	lappend LesPoints "$X $Y $y"
    }
 
    foreach Coord $LesPoints {
	set X    [lindex $Coord 0]
	set Y    [lindex $Coord 1]
	set NbSq [lindex $Coord 2]
	$K create line $X $Y $X $Y  -fill "$ColorLine"  -tags [list "" "$NbSq seq(s)" "Affichable" "OligoGraph" "$TagDuGraph"] 
    }
    if {[info exists Coordonnees]} {array unset Coordonnees}
    return ""


}

proc AfficheLeSpectreTmDUneListe {K UneListe XDebutQuery XFinQuery MinSpectreY MaxSpectreY {OneNtPixel ""} {ColorLine black} {TagDuGraph ""}} {


    global RepertoireDuGenome

    Wup "Affiche le spectre du Tm pour IllustreOligo"

    if {$OneNtPixel==""} {set OneNtPixel 1}

    set HauteurDuSpectreY [expr $MaxSpectreY-$MinSpectreY]

    set n 0
    set PremiereLigne 1
    foreach Ligne $UneListe {
	if {$PremiereLigne} {
	    scan $Ligne "%f %f" yMin VraiyMin
	    set PremiereLigne 0
	    set DeuxiemeLigne 1
	    continue
	}
	if {$DeuxiemeLigne} {
	    scan $Ligne "%f %f" yMax VraiyMax
	    set DeuxiemeLigne 0
	    set TroisiemeLigne 1
	    continue
	}
	if {$TroisiemeLigne} {
	    scan $Ligne "%f %f" yMoyen VraiyMoyen
	    	    	    
	    set TroisiemeLigne 0
	    $K create text [expr $XDebutQuery-5] [expr $MaxSpectreY-(3*$HauteurDuSpectreY/4)+(($HauteurDuSpectreY/4)/2)]  -text "Tm"  -tags [list "" "$TagDuGraph\nMin $VraiyMin Max $VraiyMax " "Affichable" "OligoGraph" "$TagDuGraph"]  -fill $ColorLine -anchor e
	    
	    #Ligne min de nb seq 0
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMin-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]
	    
	    #Ligne Moyenne
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMoyen-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "Moy Tm [format "%4.1f" $yMoyen]°C" "Affichable" "OligoGraph" "$TagDuGraph" "Average$TagDuGraph"]  -fill "$ColorLine"  -dash {6 4}

	    #Ligne de max nbseq
	    $K create line  $XDebutQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  $XFinQuery  [expr $MaxSpectreY-($yMax-$yMin)*($HauteurDuSpectreY)/($yMax-$yMin)]  -tags [list "" "OligoGraph" "$TagDuGraph"]
	    continue
	}
	scan $Ligne "%f %f" x y
	
	set X [expr $XDebutQuery + [expr $x * $OneNtPixel]]
	set Y [expr $MaxSpectreY-($y-$yMin)*($HauteurDuSpectreY*1.0)/($yMax-$yMin)]
	
	incr n
	if {$n > 1} { 
	    $K create line [set Coordonnees(LastX)] [set Coordonnees(LastY)] $X $Y  -tags [list "" "[format "%.1f" [expr ([set Coordonnees(VraiY)]+$y)/2]] °C" "Affichable" "OligoGraph" "$TagDuGraph"]  -fill "$ColorLine"
	    set n 1
	}
	set Coordonnees(VraiY) $y
	set Coordonnees(LastX) $X
	set Coordonnees(LastY) $Y
	lappend LesPoints "$X $Y $y"
    }
 
    foreach Coord $LesPoints {
	set X  [lindex $Coord 0]
	set Y  [lindex $Coord 1]
	set Tm [lindex $Coord 2]
	$K create line $X $Y $X $Y  -fill "$ColorLine"  -tags [list "" "[format "%.1f" $Tm] °C" "Affichable" "OligoGraph" "$TagDuGraph"] 
    }
    if {[info exists Coordonnees]} {array unset Coordonnees}
    return ""


}

proc AfficheLesAliEnPage {Page Selection Fichier} {


    set LesSel [split $Selection "\n"]
    if {[PourWscope]} {
	set s [lindex $LesSel 0]
	return [AfficheAliEnPage $Page $s $Fichier]
    }
    foreach s $LesSel {
	AfficheAliEnPage $Page $s $Fichier
    }


}

proc AfficheLesAutresCandidats {K PAB} {



    Wup "Permet d afficher les candidats de l oligo"
    Wup "On ajoute les boutons pour les liens vers les banques"

    set Id           [$K find withtag current]
    set MesTags      [$K gettags $Id]
    set NomOligo     [lindex $MesTags 4]
    set Dir          [lindex $MesTags 5]

    set  LesAccessDef [LesAccessDefDeLOligo $PAB $NomOligo $Dir]
    if {$LesAccessDef==""} {return ""}

    set Fen  [AfficheVariable [join $LesAccessDef "\n"] "" "$NomOligo de $PAB dans [file tail $Dir]"]
    set FenB "$Fen.buttons"

    TouchePour $FenB NouvelleGamme
    TouchePour $FenB NouvelleCouleur "white"
    set D [TouchePour $FenB "FastaCmd" ""]
    TouchePour $FenB NouvelleCouleur "green"
    TouchePour $FenB     "Sel" "catch {SauveLesInfosDe $K Win \[FastaCmd \[selection get\]\]}"
    TouchePour <2>      "/All" "catch {SauveLesInfosDe $K Win \[FastaCmd \[set PagePropre($Fen)\]\]}"
    TouchePour <3> "/Complete" "catch {SauveLesInfosDe $K Win \[FastaCmd \[selection get\] Complet\]}"
    set    Texte [format   "%-10s" "Buttons below:"]
    append Texte [format "\n%-10s" "To retrieve sequence in fasta format from blast database"]
    append Texte [format "\n%-10s" "To retrieve sequence header (access and definition)"]
    set_balloon $D "$Texte"
    $D configure -state disabled -disabledforeground "black"

    TouchePour $FenB NouvelleGamme
    TouchePour $FenB NouvelleCouleur  "white"
    set B [TouchePour $FenB "Link Uniseq To" ""]
    TouchePour $FenB NouvelleCouleur  "green"
    TouchePour $FenB "Unigene ID Sel" "catch {SauveLesInfosDe $K Win \[LeUnigeneDeUniseq_GUI \[selection get\]\]}" 
    TouchePour <2>             "/All" "catch {SauveLesInfosDe $K Win \[LeUnigeneDeUniseq_GUI \[set PagePropre($Fen)\]\]}"
    
    TouchePour $FenB NouvelleGamme
    TouchePour $FenB NouvelleCouleur "green"
    TouchePour $FenB "Genbank Sel" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]        uniseq genbank All\]}"
    TouchePour <2>           "/Id" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]\]}"
    TouchePour <3>          "/All" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[set PagePropre($Fen)\]\]}"
    
    TouchePour $FenB "Protein Sel" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]        uniseq protein All\]}"
    TouchePour <2>           "/Id" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]        uniseq protein\]}"
    TouchePour <3>          "/All" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[set PagePropre($Fen)\] uniseq protein\]}"

    set    Texte [format   "%-10s" "Buttons below:"]
    append Texte [format "\n%-10s" "To Link Unigene to Genbank or to Protein database"]
    append Texte [format "\n%-10s" "Allows to retrieve access only (Id and all) or complete entry (Sel.)"]
    append Texte [format "\n%-10s" "Allows to retrieve also Unigene (Ug.xxx) id from Uniseq (HS#xxx)"]
    set_balloon $B "$Texte"
    $B configure -state disabled -disabledforeground "black"

    return $Fen


}

proc AfficheLesAutresCandidatsComplet {K PAB} {



    Wup "Permet d afficher les candidats de l oligo avec leur pourcentages d identite et leur nb bases contigues"
    Wup "On ajoute les boutons pour les liens vers les banques"

    set Id       [$K find withtag current]
    set MesTags  [$K gettags $Id]
    set NomOligo [lindex $MesTags 4]
    set Dir      [lindex $MesTags 5]
    set Debut    [lindex $MesTags 2]
    set Fin      [lindex $MesTags 3]

    set  LesAccessDef [LesAccessStatCompletes "$Dir/${PAB}.log" $Debut $Fin]
    if {$LesAccessDef==""} {return ""}
    
    set Fen  [AfficheVariable [join $LesAccessDef "\n"] "" "$NomOligo de $PAB dans [file tail $Dir]"]
    set FenB "$Fen.buttons"

    TouchePour $FenB NouvelleGamme
    TouchePour $FenB NouvelleCouleur "white"
    set D [TouchePour $FenB "FastaCmd" ""]
    TouchePour $FenB NouvelleCouleur "green"
    TouchePour $FenB     "Sel" "catch {SauveLesInfosDe $K Win \[FastaCmd \[selection get\]\]}"
    TouchePour <2>      "/All" "catch {SauveLesInfosDe $K Win \[FastaCmd \[set PagePropre($Fen)\]\]}"
    TouchePour <3> "/Complete" "catch {SauveLesInfosDe $K Win \[FastaCmd \[selection get\] Complet\]}"
    set    Texte [format   "%-10s" "Buttons below:"]
    append Texte [format "\n%-10s" "To retrieve sequence in fasta format from blast database"]
    append Texte [format "\n%-10s" "To retrieve sequence header (access and definition)"]
    set_balloon $D "$Texte"
    $D configure -state disabled -disabledforeground "black"

    TouchePour $FenB NouvelleGamme
    TouchePour $FenB NouvelleCouleur  "white"
    set B [TouchePour $FenB "Link Uniseq To" ""]
    TouchePour $FenB NouvelleCouleur  "green"
    TouchePour $FenB "Unigene ID Sel" "catch {SauveLesInfosDe $K Win \[LeUnigeneDeUniseq_GUI \[selection get\]\]}" 
    TouchePour <2>             "/All" "catch {SauveLesInfosDe $K Win \[LeUnigeneDeUniseq_GUI \[set PagePropre($Fen)\]\]}"
    
    TouchePour $FenB NouvelleGamme
    TouchePour $FenB NouvelleCouleur "green"
    TouchePour $FenB "Genbank Sel" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]        uniseq genbank All\]}"
    TouchePour <2>           "/Id" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]\]}"
    TouchePour <3>          "/All" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[set PagePropre($Fen)\]\]}"
    
    TouchePour $FenB "Protein Sel" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]        uniseq protein All\]}"
    TouchePour <2>           "/Id" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[selection get\]        uniseq protein\]}"
    TouchePour <3>          "/All" "catch {SauveLesInfosDe $K Win \[GetzUniseq_GUI $K \[set PagePropre($Fen)\] uniseq protein\]}"

    set    Texte [format   "%-10s" "Buttons below:"]
    append Texte [format "\n%-10s" "To Link Unigene to Genbank or to Protein database"]
    append Texte [format "\n%-10s" "Allows to retrieve access only (Id and all) or complete entry (Sel.)"]
    append Texte [format "\n%-10s" "Allows to retrieve also Unigene (Ug.xxx) id from Uniseq (HS#xxx)"]
    set_balloon $B "$Texte"
    $B configure -state disabled -disabledforeground "black"
    
    return $Fen


}

proc AfficheLesAutresCandidatsOligoArray {K PAB} {



    Wup "Permet d'afficher les candidats de l'oligo"

    set Id           [$K find withtag current]
    set MesTags      [$K gettags $Id]
    set NomOligo     [lindex $MesTags 4]
    set Dir          [lindex $MesTags 5]

    set LesAccessDef [LesAccessDefDeLOligoArray $PAB $NomOligo $Dir]
    set Fen          [AfficheVariable [join $LesAccessDef "\n"] "" "$NomOligo de $PAB dans $Dir"]

    #set texte ["$Fen.frame.list" get 0 end]
    set B [BoutonneLaFenetre $Fen "Getz\nuniseq > genbank Sel/Id/All Id\nuniseq > protein   Sel/Id/All Id\ngenbank > protein Sel/Id/All Id"]
 
       bind $B <1>         "GetzUniseq_GUI $K \[selection get\]        uniseq  genbank EntreeComplete"
       bind $B <2>         "GetzUniseq_GUI $K \[selection get\]        uniseq  genbank AccessDef"
       bind $B <3>         "GetzUniseq_GUI $K \[set PagePropre($Fen)\] uniseq  genbank AccessDef"
    					  
       bind $B <Shift-1>   "GetzUniseq_GUI $K \[selection get\]        uniseq  protein EntreeComplete"
       bind $B <Shift-2>   "GetzUniseq_GUI $K \[selection get\]        uniseq  protein AccessDef"
       bind $B <Shift-3>   "GetzUniseq_GUI $K \[set PagePropre($Fen)\] uniseq  protein AccessDef"
					  
       bind $B <Control-1> "GetzUniseq_GUI $K \[selection get\]        genbank protein EntreeComplete"
       bind $B <Control-2> "GetzUniseq_GUI $K \[selection get\]        genbank protein AccessDef"
       bind $B <Control-3> "GetzUniseq_GUI $K \[set PagePropre($Fen)\] genbank protein AccessDef"
  
    $B configure -background "green"
    return $Fen
    #return "[AfficheVariable [join $LesAccessDef "\n"] "" "$NomOligo de $PAB dans $Dir"]"


}

proc AfficheLesBAC {K} {


    global RepertoireDuGenome

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set Chro [lindex $MesTags 0]
    set Deb [lindex $MesTags 1]
    set Fin [lindex $MesTags 2]
    set Nom [lindex $MesTags 3]
    set Id [lindex $MesTags 4]
    set IntId [lindex $MesTags 5]

    set Texte "$Nom\n$Chro\nFrom $Deb\nTo $Fin\nName: $Nom\nID: $Id\nInternationalID: $IntId"

    ac_AfficheVariable "$Texte" "" "Summary"

    return "$Texte"


}

proc AfficheLesBlastXDesHitsMultiples {Nom} {


    foreach Fichier [LesBlastXDesHitsMultiples $Nom] {
	AfficheFichier $Fichier "AvecSegAlignement"
    }
    return


}

proc AfficheLesBoutonsNonOpen {{V ""}} {


    global LesBoutonsNonOpen

#    if {$V==""} { set V [Vitrine "GetVitrine"] }
    foreach b $LesBoutonsNonOpen {
	pack $b -fill both
    }


}

proc AfficheLesConcernesDeCeRang {K X Y Fichier} {


    global RepertoireDuGenome
    global NotreOS
    global PABRetenus

    Wup "if K is an Organism then return LesAtteints (for PourGif)"
    if {[regexp {^\.} $K]} {
	set PourGif 0
    } else {
	set PourGif 1
    }

    regsub "orgaetsesplaces" $Fichier "distancesphylo.[Glossaire $NotreOS Court]" FichierDPh
    regsub "orgaetsesplaces" $Fichier "pabretenus"     FichierDesRetenus

    set TailFDR [file tail $FichierDesRetenus]

    if { ! [info exists PABRetenus($TailFDR)] && [file exists $FichierDesRetenus]} {
	set  PABRetenus($TailFDR) 1
	foreach Ligne [LesLignesDuFichier $FichierDesRetenus] {
	    scan $Ligne "%s" Nom
	    set PABRetenus($TailFDR,$Nom) 1
	}
    }

    if { ! [file exists $FichierDPh]} {
	FaireLire "I can't find $FichierDPh"
	return ""
    }
    if {$PourGif} {
	set Orga  [Glossaire $K Court]
	set Score $X
	set Rang  $Y
	set Rep ""
    } else {
	set Id [$K find withtag current]
	set Orga [Glossaire [lindex [$K gettags $Id] 0] Court]
	set Score [lindex [$K gettags $Id] 1]
	set Rang  [lindex [$K gettags $Id] 2]
	set Rep "$RepertoireDuGenome/"
    }

    set LesAtteints {}
    foreach Ligne [LesLignesDuFichier $FichierDPh] {
	set LesMots [split $Ligne " "]
	set Nom [lindex $LesMots 0]
	set Ieme [lsearch -exact $LesMots $Orga]
	if { [expr ($Ieme-1)/3] == [expr $Rang-1] } {
	    if { ! [info exists PABRetenus($TailFDR)] ||  [info exists PABRetenus($TailFDR)] && [info exists PABRetenus($TailFDR,$Nom)]} {
		lappend LesAtteints "${Rep}msf/$Nom $Ligne"
	    }
	}
    }

    if {$PourGif} { return $LesAtteints }

    if {[llength $LesAtteints]>0} {
	AfficheVariable [join $LesAtteints "\n"] "AvecShowSansFetch"
    } else {
	FaireLire "Sorry I can't find the associated alignments ... I'm so messy ..."
    }


}

proc AfficheLesConditionsDeTmEtDeTaille {{PAB ""} {Taille ""} {Tm ""} {AvecAffiche 0}} {



    Wup "Affiche les resultats du Test pour tous les PABs et dans plusieurs conditions de Tm et de taille" 
    
    #ChargeLeTableauDesTestsSurLeTmEtLaTaille   TabRes "StatOligoPossible" $PAB $Taille $Tm
    ChargeLeTableauDesTestsSurLeTmEtLaTaille   TabRes "StatOligoPossible_60.new" $PAB $Taille $Tm
    CalculLesMeilleursConditionsDeTmEtDeTaille TabRes
    
    if {$PAB==""} {set LesPABs [set TabRes(LesPABs)]} else {set LesPABs $PAB}
    
    Espionne "Test pour les PABs des meilleures conditions de Tm ([set TabRes(LesTms)]) et de Taille ([set TabRes(LesLongueurs)]) qui genere le plus grand nombre de sondes." 

    foreach PAB $LesPABs {
	if {$PAB=="ACT1165"} {continue}
	if {$AvecAffiche} {Espionne "\nMeilleur Tm pour toutes les conditions de Taille"}
	foreach Length [set TabRes(LesLongueurs)] {
	    set LeMeilleurTm [set TabRes($PAB,$Length,LeMeilleurTm)]

	    #Incremente le nb des meilleurs pour chaque Tm de toutes les conditions
	    incr    TabRes(nbMeilleurTm,$LeMeilleurTm) 
	    incr    TabRes($Length,$LeMeilleurTm,nbMeilleurTm) 
	    lappend TabRes($Length,$LeMeilleurTm,nbMeilleurTm,LesPABs) $PAB

	    if {$AvecAffiche} {
		set PerAccept  [set TabRes($PAB,$Length,$LeMeilleurTm,PercentAccepted)]
		set PerRej     [set TabRes($PAB,$Length,$LeMeilleurTm,PercentRejected)]
		set Accepted   [set TabRes($PAB,$Length,$LeMeilleurTm,NbAccepted)]
		set Rejected   [set TabRes($PAB,$Length,$LeMeilleurTm,NbRejected)]  
		set GCAccepted [set TabRes($PAB,$Length,$LeMeilleurTm,GCAccept)]
		set GCRejected [set TabRes($PAB,$Length,$LeMeilleurTm,GCReject)]
		Espionne "$PAB $Length $LeMeilleurTm $Accepted $PerAccept $Rejected $PerRej $GCAccepted $GCRejected"
	    }
	}
	
	if {$AvecAffiche} {Espionne "\nMeilleur Taille pour toutes les conditions de Tm"}
	foreach Tm [set TabRes(LesTms)] {
	    set LaMeilleureTaille [set TabRes($PAB,$Tm,LaMeilleureTaille)]
	    
	    #Incremente le nb des meilleurs pour chaque Taille de toutes les conditions
	    incr TabRes(nbMeilleureTaille,$LaMeilleureTaille) 
	    #incr    TabRes($LaMeilleureTaille,$Tm,nbMeilleureTaille) 
	    #lappend TabRes($LaMeilleureTaille,$Tm,nbMeilleureTaille,LesPABs) $PAB
	    
	    if {$AvecAffiche} {
		set PerAccept  [set TabRes($PAB,$LaMeilleureTaille,$Tm,PercentAccepted)]
		set PerRej     [set TabRes($PAB,$LaMeilleureTaille,$Tm,PercentRejected)]
		set Accepted   [set TabRes($PAB,$LaMeilleureTaille,$Tm,NbAccepted)]
		set Rejected   [set TabRes($PAB,$LaMeilleureTaille,$Tm,NbRejected)]  
		set GCAccepted [set TabRes($PAB,$LaMeilleureTaille,$Tm,GCAccept)]
		set GCRejected [set TabRes($PAB,$LaMeilleureTaille,$Tm,GCReject)]
		Espionne "$PAB $LaMeilleureTaille $Tm $Accepted $PerAccept $Rejected $PerRej $GCAccepted $GCRejected"
	    }
	}
	
	#Calcul des meilleures conditions pour chaque PAB
	#Taille vs Tm     actif
	#Tm     vs Taille inactif
	set LeMeilleurTmDuPAB      [set TabRes($PAB,LeMeilleurTm)]
	set LaTailleDeLeMeilleurTm [set TabRes($PAB,LaTailleDeLeMeilleurTm)]
	#Espionne "$PAB $LaTailleDeLeMeilleurTm $LeMeilleurTmDuPAB"

	if {![info exists TabRes($LaTailleDeLeMeilleurTm,$LeMeilleurTmDuPAB,nbMeilleurTmDeTous)]} {
	    set  TabRes($LaTailleDeLeMeilleurTm,$LeMeilleurTmDuPAB,nbMeilleurTmDeTous) 1
	} else {			       
	    incr TabRes($LaTailleDeLeMeilleurTm,$LeMeilleurTmDuPAB,nbMeilleurTmDeTous) 1
	}
	lappend TabRes($LaTailleDeLeMeilleurTm,$LeMeilleurTmDuPAB,nbMeilleurTmDeTous,LesPABs) $PAB

#	set LaMeilleureTailleDuPAB       [set TabRes($PAB,LaMeilleureTaille)]
#	set LeTmDeLaMeilleureTailleDuPAB [set TabRes($PAB,LeTmDeLaMeilleureTaille)]
#	if {![info exists TabRes($LaMeilleureTailleDuPAB,$LeTmDeLaMeilleureTailleDuPAB,nbMeilleurTailleDeTous)]} {
#	    set  TabRes($LaMeilleureTailleDuPAB,$LeTmDeLaMeilleureTailleDuPAB,nbMeilleurTailleDeTous) 1
#	} else {			       				     
#	    incr TabRes($LaMeilleureTailleDuPAB,$LeTmDeLaMeilleureTailleDuPAB,nbMeilleurTailleDeTous) 1
#	}
    }
    
    set NbTotalPAB    [set TabRes(nbPAB)]
    set NbTotalTaille [set TabRes(nbTaille)]
    set NbTotalTm     [set TabRes(nbTm)]

    Espionne "Nombre de fois que le Tm est le meilleur:"
    #Rq:On divise par le nombre de Taille
    foreach Tm [set TabRes(LesTms)] {
	set Valeur  [set TabRes(nbMeilleurTm,$Tm)]
	set Percent [expr 100.0*$Valeur/$NbTotalTaille]
	Espionne "$Tm\t[format "%6d\t%2.1f" $Valeur $Percent] %"
    }
    Espionne "Total: $NbTotalTaille = PAB ($NbTotalPAB) * NbTaille ([llength [set TabRes(LesLongueurs)]])\n"
   
    Espionne "Nombre de fois que la Taille est la meilleure:"
    #Rq:On divise par le nombre de Tm
    foreach Taille [set TabRes(LesLongueurs)] {
	set Valeur  [set TabRes(nbMeilleureTaille,$Taille)]
	set Percent [expr (100.0*$Valeur)/$NbTotalTm]
	Espionne "$Taille\t[format "%6d\t%2.1f" $Valeur $Percent] %"
    }
    Espionne "Total: $NbTotalTm = PAB ($NbTotalPAB) * NbTm ([llength [set TabRes(LesTms)]])\n"
 
    Espionne "Meilleures conditions (Tm pour chaque Taille) en considerant a chaque fois tous les PABs:"
    foreach Taille [set TabRes(LesLongueurs)] {
	set Valeur  "Nombre" 
	set Percent "Pourcent"
	
	Espionne "$Taille\t--\t$Valeur\t$Percent\txGC Total\txGC Accepted"
	set Total 0
	foreach Tm [set TabRes(LesTms)] {
	    if {! [info exists TabRes($Taille,$Tm,nbMeilleurTm)]} {
		set Nb 0
	    } else {
		set Nb [set TabRes($Taille,$Tm,nbMeilleurTm)]
	    }
	    
	    set Total [expr $Total+$Nb]

	    if {! [info exists TabRes($Taille,$Tm,nbMeilleurTm,LesPABs)]} {
		set MoyenneDuGCDesPAB      0.0
		set MoyenneDuGCDesAccepted 0.0
	    } else {
		set ListePABs       [set TabRes($Taille,$Tm,nbMeilleurTm,LesPABs)]
		set NbPAB           [llength $ListePABs]
		set ATGCDesPABTotal 0
		set GCAcceptedTotal 0
	
		foreach PAB $ListePABs {
		    set ATGC            [CompositionATGCDuPAB $PAB GC]
		    set ATGCDesPABTotal [expr $ATGCDesPABTotal+$ATGC]
		    
		    set GCAccepted      [set TabRes($PAB,$Taille,$Tm,GCAccept)]
		    #set GCRejected [set TabRes($PAB,$Taille,$Tm,GCReject)]
		    set GCAcceptedTotal [expr $GCAcceptedTotal+$GCAccepted]
		}
		if {$NbPAB=="0"} {
		    set MoyenneDuGCDesPAB      0.0
		    set MoyenneDuGCDesAccepted 0.0
		} else {
		    set MoyenneDuGCDesPAB      [format " %.1f" [expr (1.0*$ATGCDesPABTotal)/$NbPAB]]
		    set MoyenneDuGCDesAccepted [format " %.1f" [expr (1.0*$GCAcceptedTotal)/$NbPAB]] 
		}
		
	    }
	    Espionne "--\t$Tm\t$Nb\t--\t$MoyenneDuGCDesPAB\t$MoyenneDuGCDesAccepted"
	}
	Espionne "--\t--\t$Total\t[format "%.1f" [expr 100.0*($Total*1.0)/($NbTotalPAB)]]"
    }
    Espionne "PAB au total: $NbTotalPAB PAB(s)"

    Espionne "\n"
    Espionne "Meilleures conditions (Tm pour chaque Taille) ultimes:"
    set CompteurDePAB 0
    foreach Taille [set TabRes(LesLongueurs)] {
	set Valeur  "Nombre" 
	set Percent "Pourcent"
	
	Espionne "$Taille\t--\t$Valeur\t$Percent\txGC Total\txGC Accepted"
	set Total 0
	foreach Tm [set TabRes(LesTms)] {
	    if {! [info exists TabRes($Taille,$Tm,nbMeilleurTmDeTous)]} {
		set Nb 0
	    } else {
		set Nb [set TabRes($Taille,$Tm,nbMeilleurTmDeTous)]
	    }
	    
	    set Total [expr $Total+$Nb]
	    if {! [info exists TabRes($Taille,$Tm,nbMeilleurTmDeTous,LesPABs)]} {
		set MoyenneDuGCDesPAB      0.0
		set MoyenneDuGCDesAccepted 0.0
	    } else {
		set ListePABs       [set TabRes($Taille,$Tm,nbMeilleurTmDeTous,LesPABs)]
		set NbPAB           [llength $ListePABs]
		set ATGCDesPABTotal 0
		set GCAcceptedTotal 0
	
		foreach PAB $ListePABs {
		    incr CompteurDePAB 1
		    set ATGC            [CompositionATGCDuPAB $PAB GC]
		    set ATGCDesPABTotal [expr $ATGCDesPABTotal+$ATGC]
		    
		    set GCAccepted      [set TabRes($PAB,$Taille,$Tm,GCAccept)]
		    #set GCRejected [set TabRes($PAB,$Taille,$Tm,GCReject)]
		    set GCAcceptedTotal [expr $GCAcceptedTotal+$GCAccepted]
		}
		if {$NbPAB=="0"} {
		    set MoyenneDuGCDesPAB      0.0
		    set MoyenneDuGCDesAccepted 0.0
		} else {
		    set MoyenneDuGCDesPAB      [format " %.1f" [expr (1.0*$ATGCDesPABTotal)/$NbPAB]]
		    set MoyenneDuGCDesAccepted [format " %.1f" [expr (1.0*$GCAcceptedTotal)/$NbPAB]] 
		}
	    }
	    Espionne "--\t$Tm\t$Nb\t--\t$MoyenneDuGCDesPAB\t$MoyenneDuGCDesAccepted"
	}
	Espionne "--\t--\t$Total\t[format "%.1f" [expr 100.0*($Total*1.0)/($NbTotalPAB)]]"
    }
    Espionne "PAB au total: $CompteurDePAB PAB(s)"

    return ""


}

proc AfficheLesConditionsDeTmEtDeTailleDePAB {PAB} {



    Wup "Affiche les resultats du Test pour un PAB en particulier et dans plusieurs conditions de Tm et de taille" 
    
    ChargeLeTableauDesTestsSurLeTmEtLaTaille  TabRes "StatOligoPossible" $PAB

    if {$PAB==""} {set LesPABs [set TabRes(LesPABs)]} else {set LesPABs $PAB}
    
    set ListeSortie {}
    foreach PAB $LesPABs {
	foreach Length [set TabRes(LesLongueurs)] {
	    foreach Tm [set TabRes(LesTms)] {
		set PerAccept       [set TabRes($PAB,$Length,$Tm,PercentAccepted)]
		set PerRej          [set TabRes($PAB,$Length,$Tm,PercentRejected)]
		set Accepted        [set TabRes($PAB,$Length,$Tm,NbAccepted)]
		set Rejected        [set TabRes($PAB,$Length,$Tm,NbRejected)]  
		lappend ListeSortie [list $PAB $Length $Tm $Accepted $PerAccept $Rejected $PerRej]
	    }
	}
    }
    return $ListeSortie


}

proc AfficheLesCouleursEtSignifications {K} {


    global TypeCouleur

    set LesNomSignif [LesSignificationsAssocieesAuxORFs $K]

    set OldSignif "trululuyoupiii"
    set LaSortie {}
    foreach Ligne $LesNomSignif {
	scan $Ligne "%s" Nom
	set Signif [StringSuivant " " dans $Ligne]
	if {$Signif!=$OldSignif} { set N 0 }
	lappend LaSortie "$Nom [incr N] $Signif"
	set OldSignif $Signif
    }
    return [AfficheVariable [join $LaSortie "\n"] "AvecShow"] 


}

proc AfficheLesDescriptifs {Source {Ordre MemeOrdre} {QuoiRetourner ""} {LesAccessOrdonnes ""} {LesClefs ""} {NomOrigine ""}} {


    #rR Source can be Texte, a file or descriptif/Nom msf/Nom rsf/Nom blast/Nom etc.
    #rR il y a une petite confusion a regler pour LesAccessOrdonnees

    #rR attention je croyais que ca marcherait si on donne une source qui n'est pas du même projet !!!
    #rR ca ne marche pas si on prend MemeOrdre qu'un fichier Macsim par exemple car LeDescriptif est trop spécfique au projet Gscope :'( A VOIR  

    Wup "Attention: blast doesn't rearrange the order of the file"

    if {[regexp "\n" $Source]} {
	set TmpMSF "[TmpFile].msf"
	Sauve $Source dans $TmpMSF
	set NomOuFichier $TmpMSF
    } else {
	set NomOuFichier $Source
	while {[FileAbsent $NomOuFichier]} {
	    set Possible "[RepertoireDuGenome]/$NomOuFichier"
	    if {[FileExists $Possible]} { set NomOuFichier $Possible; break }
	    if {[EstUnPAB $NomOuFichier]} {
		#rR on priviligie le MSF
		set Possible "[RepertoireDuGenome]/msf/$NomOuFichier"
		if {[FileExists $Possible]} { set NomOuFichier $Possible; break }
	    }
	    if {[regexp "rsf" $NomOuFichier]} {
		set Queue [file tail $NomOuFichier]
		set Possible "[RepertoireDuGenome]/macsimRsf/$Queue"
		if {[FileExists $Possible]} { set NomOuFichier $Possible; break }
	    }
	    FaireLire "I can not find $NomOuFichier"
	    return ""
	}
    }

    if {$NomOrigine==""} { set NomOrigine $NomOuFichier }
    set Nom [file tail $NomOrigine]

    set RepDesc "[RepertoireDuGenome]/descriptifs"
    set PossibleRepDesc "[file dirname [file dirname $Source]]/descriptifs"
    if {[file exists $PossibleRepDesc/$Nom]} { set RepDesc $PossibleRepDesc }

    if { 0 && [regexp "/" $NomOuFichier] && [file exists $NomOuFichier]} {
	#rR a mis 0 ... 20150521 ..................................................... ca merde ... si le projet n'est pas le RepertoireDuGenome
	set FichierDescriptif $NomOuFichier
    } else {
	set FichierDescriptif "$RepDesc/$Nom"
    }
    set FichierModele "NeDoitPasExister"

    if {[FileAbsent $FichierDescriptif]} { return "" }

    if {$Ordre=="Natif"} { set LesDes [LesLignesDuFichier $FichierDescriptif] ; set NomOuFichier $FichierDescriptif }
    if {$Ordre=="MemeOrdre" && [regexp -nocase "msf|clustal" $NomOuFichier]} {
	DecortiqueUnMSF $NomOuFichier LesAccessOrdonnes
    }
    if {$Ordre=="MemeOrdre" && [regexp -nocase "rsf" $NomOuFichier]} {
	DecortiqueUnRSF $NomOuFichier LesAccessOrdonnes
    }
    if {$Ordre=="MemeOrdre" && [regexp -nocase "blast" $NomOuFichier]} {
	DecortiqueBlast $NomOuFichier 0.001 "SansLimiteDeNombre" Query lBA LesAccessOrdonnes lDE lProfil lPN
    }
    if {$Ordre=="MemeOrdre" && [regexp -nocase "aliinout" $NomOuFichier]} {
	set LesAccessOrdonnes [LesAccessDuAliInOut $NomOuFichier]
    }
    if {$Ordre=="MemeOrdre" && [regexp -nocase "disphy" $NomOuFichier]} {
	set LesAccessOrdonnes [FromDisphy $NomOuFichier]
    }
    if {$Ordre=="MemeOrdre" && [regexp -nocase "apns" $NomOuFichier]} {
	set LesAccessOrdonnes [LesAccessDuAPN $NomOuFichier]
    }
    if {[info exists LesAccessOrdonnes] && $LesAccessOrdonnes!=""} {
	if { ! [info exists lBA]} { set lBA $LesAccessOrdonnes }
	foreach Access $LesAccessOrdonnes BA $lBA {
	    set Des [LeDescriptif $Access $Nom]
	    if {[regexp "no description" $Des]} {
		regsub {^PDB_} $BA "PDB:" BA
		set Des [LeDescriptif $BA $Nom]
	    }
	    if {[regexp "no description" $Des]} {
		regsub {^[^\:]+:} $BA "" BA
		set Des [LeDescriptif $BA $Nom]
	    }
	    lappend LesDes $Des 
	}
    } else {
	set LesDes [LesLignesDuFichier $FichierDescriptif]
    }
    foreach Descriptif $LesDes {
	set BeauDes [MiseEnPageDuDescriptif $Descriptif $LesClefs]
	lappend LesBeauxDes $BeauDes
    }

    if {[info exists TmpMSF] && [file exists $TmpMSF]} { file delete -force $TmpMSF }

    if { $QuoiRetourner == "PourGif" } {
	return [join $LesBeauxDes "\n"]
    } elseif { $QuoiRetourner == "LaListe" } {
	return $LesBeauxDes
    } else {
	return [AfficheVariable [join $LesBeauxDes "\n"] "GrandeLargeurAvecAligneurs" $NomOrigine] 
    }


}

proc AfficheLesDescriptifsDuMSF {NomOuFichier} {


    global LesDescriptifs

    set Nom [file tail $NomOuFichier]
    if {[regexp "/" $NomOuFichier] && [file exists $NomOuFichier]} {
	set Fichier $NomOuFichier
    } else {
	set Fichier "[RepertoireDuGenome]/msf/$Nom"
    }
    if { ! [file exists $Fichier]} { return "" }

    set MSFdesCopains [expr [OnTraiteUneCollection] && [YaPABdans $Nom]]

    set LesAccess {}
    foreach Ligne [LesLignesDuFichier $Fichier] {
	if {[regexp "//" $Ligne]} { break }
	if { ! [regexp "Name\:" $Ligne]} { continue }
	scan $Ligne "%s %s" Name Access
	if {[info exists LesDescriptifs($Access)]} { continue }
	lappend LesAccess $Access
    }
    if {$LesAccess!={} && ! $MSFdesCopains} {
	PrepareLesSequencesDesBanques $LesAccess $LesAccess
    }
    set AuMoinsUneDescription 0
    foreach Access $LesAccess {
	if {[info exists LesDescriptifs($Access)]} {
	    set Descriptif [set LesDescriptifs($Access)]
	} else {
	    if {0 && $MSFdesCopains} {
		set LesLignesEMBL [split [CoCherche "embl" $Nom $Access] "\n"]
	    } else {
		set LesLignesEMBL [LaSequenceDesBanques $Access $Access AccessOK "OnVeutEMBL"]
	    }
	    if {$LesLignesEMBL=={} } {
		lappend Liste "$Access (no description)"
		continue
	    }
	    DecortiqueLesLignesEMBL $LesLignesEMBL ID AC DE GN OS OC OX
	    set Descriptif "$Access OS:$OS GN:$GN DE:$DE ID:$ID AC:$AC OC:$OC OX: $OX"
	    set LesDescriptifs($Access) $Descriptif
	}
	lappend Liste [MiseEnPageDuDescriptif $Descriptif]
	set AuMoinsUneDescription 1
    }

    if { ! $AuMoinsUneDescription || ! [info exists Liste]} { return "" }

    return [AfficheVariable [join $Liste "\n"] "AvecAligneurs" $Fichier]


}

proc AfficheLesFichiers {Selection {Maniere ""}} {


    set Dernier ""
    foreach Ligne [split $Selection "\n"] {
	foreach Fichier [split $Ligne " "] {
	    if {[FileAbsent $Fichier]} {continue}
	    set Dernier [AfficheFichier $Fichier $Maniere]
	}
    }
    return $Dernier


}

proc AfficheLesFichiersApresSplit {Selection {Maniere ""}} {


    FaireLire "AfficheLesFichiersApresSplit obsolete, use AfficheLesFichiers"
    return [AfficheLesFichiers $Selection $Maniere]


}

proc AfficheLesFragmentsDeMutation {Nom} {


    set LesFragments [CombineLesFragments $Nom "MutationFragments"]
    Espionne $LesFragments
    while {[OuiOuNon "Do we continue to combine these fragments ?"]} {
	set LesFragments [CombineLesFragments $Nom $LesFragments]
    }
    return $LesFragments


}

proc AfficheLesGenes {K} {


    global RepertoireDuGenome

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set Chro [lindex $MesTags 0]
    set Deb [lindex $MesTags 1]
    set Fin [lindex $MesTags 2]
    set Nom [lindex $MesTags 3]
    set Brin [lindex $MesTags 4]
    set Debcds [lindex $MesTags 5]
    set Fincds [lindex $MesTags 6]
    set NbExons [lindex $MesTags 7]
    set ExonStarts [lindex $MesTags 8]
    set ExonEnds [lindex $MesTags 9]
    set ProtID [lindex $MesTags 10]
    set DefProt [lindex $MesTags [expr [llength $MesTags] -3]]

    set Texte "$Nom\n$Chro\nFrom: $Deb\nTo: $Fin\nStrand: $Brin\nStart_cds: $Debcds\nEnd_cds: $Fincds\nNbExons: $NbExons\nProtein_ID: $ProtID\nDef: $DefProt"

    ac_AfficheVariable "$Texte" "" "Summary"
    return "$Texte"


}

proc AfficheLesInfosDeMaSequence {PAB} {


    
    Wup "Montre les regions interessantes"

    set Indice [file tail $PAB]
    regsub -all  {\.} $Indice "" Indice
    
    set w ".lesinfosdemaseq$Indice"
    if {[winfo exists $w]} {wm deiconify $w;raise $w;return ""} else {toplevel $w}
    
    wm geometry  $w +300+100
    wm title     $w "Information for $PAB"
    wm resizable $w false false

    set    FInfo "$w.frameinfo"
    frame $FInfo -borderwidth "3" -relief "groove"
    pack  $FInfo -fill both       -expand true
    
    #Attention il faut une query, sinon pas de taille ....
    set RepmRNA   "[RepertoireDuGenome]/mrnatfa_Homo_sapiens"
    set Repnuctfa "[RepertoireDuGenome]/nuctfa"
        
    set FichierQuery $PAB
    if {[regexp {/} $PAB]} {set PAB [file tail $PAB]}

    if {    [file exists $FichierQuery]} {
	set FichierQuery $FichierQuery
    } elseif {[file exists "$RepmRNA/$PAB"]} {
	set FichierQuery   "$RepmRNA/$PAB"
    } elseif {[file exists "$Repnuctfa/$PAB"]} {
	set FichierQuery   "$Repnuctfa/$PAB"
    } else {Espionne "No Input File for the Query ($PAB)";destroy $w;return ""}

    set Police         {-family "arial" -size 12 -weight bold}
    set CouleurOutline "black"
    set LargeurMax     [expr [winfo screenwidth  .] * 2/3]
    set HauteurMax     [expr [winfo screenheight .] * 1/2]
    set LargeurFenetre [expr [winfo screenwidth  .] * 2/3]
    set HauteurFenetre [expr [winfo screenheight .] * 1/2]
    set XMilieu        [expr $LargeurMax/2]
    
    set BordureX       50.0
    set BordureY       50.0
    set Intervalle     10.0
    set EpaisseurBoite 15.0

    #Position du Graph content
    set YDebutGraph    [expr 0 + $BordureY]
    set YFinGraph      [expr $YDebutGraph + 100]

    #Position de la query
    set XDebutQuery    [expr 0            + $BordureX]
    set YDebutQuery    [expr $YFinGraph   + 10]
    set XFinQuery      [expr $LargeurMax  - $BordureX] 
    set YFinQuery      [expr $YDebutQuery + $EpaisseurBoite]
    
    #Besoin de la taille de la query pour conversion et affichage
    set AccessQuery    [AccessDuTFADumRNA         $FichierQuery]
    set  SeqQuery      [QueLaSequenceDuFichierTFA $FichierQuery]
    if {$SeqQuery==""} {Espionne "$FichierQuery no sequence available";return ""}
    set TailleQueryNt  [string length $SeqQuery]
    #Rapport du nombre de pixel pour un nt
    set OneNtPixel     [expr ($XFinQuery-$XDebutQuery)/($TailleQueryNt - 1)] 

    #Debut des Oligos
    set YDebutDeOligo  [expr $YFinQuery + $Intervalle]
        
    set     K "$FInfo.canvas"
    canvas $K    -width      $LargeurFenetre -height $HauteurFenetre 
    $K configure -height     $YDebutDeOligo
    $K configure -background "grey" 

    SauveLesInfosDe $K MonPAB $PAB
    #On modifie le comportement lors de la destruction de la fenetre principale
    #Ceci pour vider les infos stockees
    wm protocol $w WM_DELETE_WINDOW "DetruitLesInfosDe $K;after 10 destroy $w"

    #Le Masque pour les graphes
    $K create rectangle [expr $XDebutQuery-40] [expr $YDebutGraph-4] [expr $XFinQuery+40] [expr $YFinGraph+4]  -fill    "gray97"  -outline "gray97"  -tags    [list "" "Masque"]

    #Affiche la petite aide
    $K create oval [expr $XDebutQuery-30] [expr $YDebutGraph-30] [expr $XDebutQuery-10] [expr $YDebutGraph-10]  -fill    "green"  -outline "white"
    $K create text [expr $XDebutQuery-20] [expr $YDebutGraph-20]  -text    "?"  -tags    [list "" "[AfficheHelpInfoDeMaSequence]" "Affichable"]  -anchor  "center" 

    #Affichage du Tm content
    #On recupere la methode de Tm par defaut choisie et on la remet apres
    set TmDefault [LesParametresDuDesign TmMethod "LaValeurMerci"]
    LesParametresDuDesign TmMethod "NearestNeighbor" "Positionne"

    set  TmResults [PosEtTmDeLaRegion $SeqQuery $TailleQueryNt] 
    if {$TmResults !=""} {
	AfficheLeSpectreTmDUneListe $K $TmResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "orange" "TmNN"
    }
    LesParametresDuDesign TmMethod $TmDefault "Positionne"

    #Affichage du GC content
    set  GCResults [PosEtGCDeLaRegion $SeqQuery $TailleQueryNt]
    if {$GCResults !=""} {
	AfficheLeSpectreGCDUneListe $K $GCResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel
    }

    #Affiche la query
    $K create rectangle $XDebutQuery $YDebutQuery $XFinQuery $YFinQuery  -outline "$CouleurOutline"  -fill    "red"  -tags    "Query"
    $K create text [expr $XDebutQuery-5.0] [expr $YDebutQuery + ($EpaisseurBoite/2.0)]  -text    "1"  -font    "$Police"  -anchor  "e"
    $K create text [expr $XFinQuery  +5.0] [expr $YDebutQuery + ($EpaisseurBoite/2.0)]  -text    "$TailleQueryNt"  -font    "$Police"  -anchor  "w"
    $K create text $XMilieu [expr 1*$BordureY/3]  -text    "Sequence Informations from $PAB"  -font    "$Police"  -anchor  "center"  -justify "center"

    #La fiche contenant les infos
    set  FicheInfo  ""
    set  Text       "$FInfo.text"
    set  ListBoxSBH "$FInfo.xscroll"
    set  ListBoxSBV "$FInfo.yscroll"

    scrollbar $ListBoxSBH -orient "horizontal" -command "$Text xview"
    scrollbar $ListBoxSBV -orient   "vertical" -command "$Text yview"
    text $Text  -state          "disabled"  -wrap           "word"  -font           "courier 10"  -xscrollcommand "$ListBoxSBH set"  -yscrollcommand "$ListBoxSBV set"
    
    set FicheInfo [LesInfosDeBaseDeMaSequence $SeqQuery]
    foreach element [split $FicheInfo "\n"] {
	$Text configure -state normal
	$Text insert    "end"  "$element\n"
	$Text configure -state disabled
    }

    #Les boutons
    set ButtonFrame    "$FInfo.buttonframe"
    set  ActionButton  "$ButtonFrame.button1"
    set  DestroyButton "$ButtonFrame.button2"
    set  LCharpente1   "$ButtonFrame.lcharpente1" 
    set  LCharpente2   "$ButtonFrame.lcharpente2" 
    set  ZoneButton1   "$ButtonFrame.zbutton1"
    set  ZoneButton2   "$ButtonFrame.zbutton2"
    #set  ZoneButton3   "$ButtonFrame.zbutton3"

    frame  $ButtonFrame  -borderwidth "3"      -relief "groove"
    button $ActionButton -background  "yellow" -text "Graph Panel / Add / Delete" 
      bind $ActionButton  <1> "Graph_Panel     $K"
      bind $ActionButton  <2> "AjouteUnGraph   $K $FichierQuery $XDebutQuery $XFinQuery $YDebutGraph $YFinGraph $OneNtPixel"
      bind $ActionButton  <3> "SupprimeUnGraph $K"
    set    Texte [format     "%-10s" "Panel to change graph display (order,color)"]
    append Texte [format   "\n%-10s" "Allow to add or delete graph"]
    append Texte [format   "\n%-10s" "Allow to search items in oligo display text"]
    set_balloon $ActionButton "$Texte"

    button $DestroyButton -background "red"    -text "Close / Help"  -command "eval \[wm protocol $w WM_DELETE_WINDOW\]"
      bind $DestroyButton <2> "AfficheHelpInfoDeMaSequence DuBouton"

    button $ZoneButton1  -background "green"   -text "Area(s) Draw / Clear / Save" 
      bind $ZoneButton1   <1> "MontreLesZones $K $XDebutQuery $XFinQuery $YDebutGraph $OneNtPixel"
      bind $ZoneButton1   <2> "ClearLesZones  $K"
      bind $ZoneButton1   <3> "SauveLesZones  $K"
    set Texte   [format      "%-10s" "Allow to show (defined), clear or save designing area(s)"]
    set_balloon $ZoneButton1 "$Texte"

    button $ZoneButton2  -background "green"   -text "Reset for $PAB / all" 
      bind $ZoneButton2   <1> "ResetLesZones    $K"
      bind $ZoneButton2   <2> "ResetAllLesZones $K"
    set Texte   [format      "%-10s" "Allow to clear saved design areas"]
    set_balloon $ZoneButton2 "$Texte"

    #button $ZoneButton3  -background "yellow"  -text "Zoom In / Out / Reset"
    #  bind $ZoneButton3  <1> "zoom $K 1.25 1.25"
    #  bind $ZoneButton3  <2> "zoom $K 0.8 0.8"
    #  bind $ZoneButton3  <3> "ResetZoom $K"

    label  $LCharpente1 -background "#808FFF" -relief "groove" 
    label  $LCharpente2 -background "#808FFF" -relief "groove" 

    pack $K             -fill both -side top
    pack $ButtonFrame   -fill both -side top    -expand true
    pack $LCharpente1   -fill both -side left   -expand true
    pack $DestroyButton -fill y    -side left
    #pack $ZoneButton3   -fill y    -side left
    pack $ActionButton  -fill y    -side left
    pack $ZoneButton1   -fill y    -side left
    pack $ZoneButton2   -fill y    -side left
    pack $LCharpente2   -fill both -side left   -expand true

    pack $ListBoxSBV    -fill y    -side right 
    pack $Text          -fill both              -expand true
    pack $ListBoxSBH    -fill x    -side bottom 

    $K bind "Affichable" <Enter> "AfficheInfoBulle $K %x %y Enter"
    $K bind "Affichable" <Leave> "AfficheInfoBulle $K %x %y Leave"
			
    $K bind "Query"      <2>     "AfficheFetch   $AccessQuery OnVeutNature"
    $K bind "Query"      <3>     "AfficheLaQuery $K $FichierQuery"

    bind $K <Control-1>       "PositionneLesZones $K %x %y $XDebutQuery $XFinQuery $YDebutGraph $OneNtPixel"
    bind $K <Shift-B1-Motion> "ViseurDeSeq        $K %x %y $XDebutQuery $XFinQuery $YDebutGraph $YFinQuery $OneNtPixel"
    bind $K <Shift-1>         "ViseurDeSeq        $K %x %y $XDebutQuery $XFinQuery $YDebutGraph $YFinQuery $OneNtPixel"
    return ""


}

proc AfficheLesInfosDuCluster {} {


    
    set ClusterOuNom [Entre "ClusterOuNom: "] 

    if {[regexp "^ClusterOuNom:" $ClusterOuNom]} {
	regsub "^ClusterOuNom: " $ClusterOuNom "" ClusterOuNom  
    }
    scan $ClusterOuNom "%s" ClusterOuNom 
    
    Espionne "Question $ClusterOuNom"
    
    set Fen [AfficheVariable [LesInfosDuCluster $ClusterOuNom] "" "Les Info de $ClusterOuNom"] 

    return $Fen


}

proc AfficheLesMembresDeLaFamille {Nom} {


    
    set MembresDeLaFamille [LesMembresDeLaFamille $Nom]

    set Texte [join $MembresDeLaFamille "\n"]
    
    set Fen [AfficheVariable $Texte "AvecRien" "${Nom}Les Membres de sa Famille"]
    
    #Jean a rajoute 
    set   B [BoutonneLaFenetre $Fen "X-HDA Sel/Sort\nAll/Sort\nInfo Cluster//DpcShow"]
    #set   B [BoutonneLaFenetre $Fen "Show X-HDA sel/all"]
    bind $B <1>       "CreeEtAfficheUnBilanHDACroises \[selection get\]"
    bind $B <2>       "CreeEtAfficheUnBilanHDACroises \[selection get\] AvecTri"
    bind $B <Shift-1> "CreeEtAfficheUnBilanHDACroises \[set PagePropre($Fen)\]"
    bind $B <Shift-2> "CreeEtAfficheUnBilanHDACroises \[set PagePropre($Fen)\] AvecTri"
    bind $B <Control-1> "AfficheLesInfosDuCluster"
    bind $B <Control-3> "DpcShow"
    
         $B configure -background "green"

    return $Fen


}

proc AfficheLesOligo {K} {


    global RepertoireDuGenome

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set Chro [lindex $MesTags 0]
    set Deb [lindex $MesTags 1]
    set Fin [lindex $MesTags 2]
    set Nom [lindex $MesTags 3]
    set Id [lindex $MesTags 4]
    set Access [lindex $MesTags 5]
    set GN [lindex $MesTags 6]
    set Des [lindex $MesTags 7]

    set Texte "$Nom\n$Chro\nFrom $Deb\nTo $Fin\nName: $Nom\nID: $Id\nAccessions: $Access\nGeneName: $GN\nDescription: $Des"

    ac_AfficheVariable "$Texte" "" "Summary"
    return "$Texte"


}

proc AfficheLesOrthologuesFamiliersDuBlastP {Nom} {


    set LesOF [LesOrthologuesFamiliersDuBlastP $Nom]
    return [AfficheVariable [join $LesOF "\n"] "AvecRien" $Nom]


}

proc AfficheLesPartsDeCamembert {K X Y Action} {


    set H [winfo screenheight .]
    set L [winfo screenwidth  .]

    regsub ".canvas" $K ".message" M
    catch {destroy $M}

    if {$Action=="Leave"} { return "" }

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set PetiteLegende             [lindex $MesTags 1]
    set GrandeLegende             [lindex $MesTags 2]

    if {$GrandeLegende != ""} {set Texte $GrandeLegende} else {set Texte $PetiteLegende}

    return [AfficheVariable $Texte]


}

proc AfficheLesPoints {} {

    global LongueurTotale LNDG SDG NomTextSeq LesPointsDuGroupe Couleurs

    set NbrGrp [expr {[llength $LNDG] - 2}]

    if {$NbrGrp <= 1} {return}

    $NomTextSeq configure -state normal
    $NomTextSeq tag configure PtBack -background LightGray

    set Idx 1
    set ng 1
    set NbrSeq 0
    set IdxGrp 1
    foreach NmGrp $LNDG {
	if {$NmGrp eq "GroupeToutLeMonde"} {continue}
	if {$NmGrp eq "bidon"} {continue}
	if {$NmGrp eq "grise"} {continue}

	set col [RGBDeLaCouleur [CouleurDuGroupe $IdxGrp]]
	$NomTextSeq tag configure Pt$NmGrp -foreground $col -background LightGray
	set y [expr {$Idx+$NbrSeq+($ng-1)*2}]

	#	$NomTextSeq delete $y.0 "$y.0 lineend - 1c"
	$NomTextSeq delete $y.0 "$y.0 lineend"
	$NomTextSeq insert $y.0 [set LesPointsDuGroupe($NmGrp)]
	$NomTextSeq tag add PtBack $y.0 "$y.0 lineend"
	set Li [regexp -all -indices -inline {\*} [set LesPointsDuGroupe($NmGrp)]]
	foreach c $Li {
	    lassign $c d f 
	    $NomTextSeq tag add Pt$NmGrp $y.$d
	}

	set NbrSeq [expr {$NbrSeq + [llength [set SDG($NmGrp)]]}]
	incr ng
	incr IdxGrp
    }

    $NomTextSeq configure -state disabled

    return

}

proc AfficheLesProcs {{LesQuelles ""} {Liste ""}} {


    Wup "Shows the names and args of all Procs"
    
    Gs "Frame"
    
    if { ! [PourWscope] && ! [AutorisationPourPsy] } { return "" }

    set WithRef [PourWscope]

    set LesBonnes {}
    foreach Procedure [LesProceduresExistantes] {
	set Args [info args $Procedure]
#AAAAAAAAAAAAAAAAAAAAAAAAAAFFFFFFFFFFFFFFFFFIIIIIIIIIIIIIIIIIINNNNNNNNNNNNNNNNNNNIIIIIIIIIIIIIRRR	set MotProc $Procedure
#	if {$WithRef} { set MotProc "<a href='[WscopeScience]/" }
	set UneBonne "$Procedure \{$Args\}"
	if {[regexp "^ArgsContain" $LesQuelles]} {
	    regsub "^ArgsContain\:" $LesQuelles "" ArgsVoulus
	    if {$ArgsVoulus!="" && ! [regexp $ArgsVoulus $Args]} { continue }
	}
	if {[regexp "^NameIsIn" $LesQuelles]} {
	    if {[lsearch -exact $Liste $Procedure]==-1} { continue }
	}
	lappend LesBonnes $UneBonne
    }

    if {$LesBonnes=={}} {
	return ""
    }

    set Bonnes [join $LesBonnes "\n"]

    if {[PourWscope]} { return [Html_DuTexteTelQuel $Bonnes] }

    set Fenetre [ShowText $Bonnes "SansFetchAvecRienAvecAffiProc" "LesProcs"]
    set Bouton [BoutonneLaFenetre $Fenetre "New" CreeUneNouvelleProcedure]
       $Bouton configure -background "orange"
    set Bouton [BoutonneLaFenetre $Fenetre "Search" AfficheLaRechercheDansLesBody]
       $Bouton configure -background "yellow"
    return $Fenetre


}

proc AfficheLesProfileSegments {Fichier} {


    set LesProfileSegments [DecortiqueProfileSegments $Fichier]
    set LesProfileSegmentsTries [lsort -decreasing -real -index 1 $LesProfileSegments]
    return [AfficheVariable [join $LesProfileSegmentsTries "\n"] "AvecProfileSegments" $Fichier]


}

proc AfficheLesRec1 {{UnRec ""}} {



    if {$UnRec==""} { set Liste [Rec1 LaListeDes Rec1] } else { set Liste [list $UnRec] }

    set LaPage {}
    foreach R $Liste {
	lappend LaPage [Rec1 $R "Description"]
    }
    set Page [join $LaPage "\n"]
    set Fen [AfficheVariable $Page "AvecRec1" ListOfRec1]
    if {$Fen==""} { return "" }
    set Clavier "$Fen.buttons"
    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "magenta"
    TouchePour $Clavier "It's File" "AfficheRec1 \[selection get\] Fichier"
    TouchePour <2>      "/Ppcr"     "AfficheRec1 \[selection get\] Ppcr"
    TouchePour <3>      "/Vect"     "AfficheRec1 \[selection get\] Vecteur"
    return $Fen


}

proc AfficheLesRec2 {{UnRec ""}} {



    if {$UnRec==""} { set Liste [Rec2 LaListeDes Rec2] } else { set Liste [list $UnRec] }

    set LaPage {}
    foreach R $Liste {
	lappend LaPage "[format %-27s $R] Rec2 in [Rec2 $R Vecteur] of [Rec2 $R R1] Rec1 [Rec2 $R Rec1Description]"
    }
    set Page [join $LaPage "\n"]
    set Fen [AfficheVariable $Page "AvecRec2" ListOfRec2]
    if {$Fen==""} { return "" }
    set Clavier "$Fen.buttons"
    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "magenta"
    TouchePour $Clavier "It's File" "AfficheRec2 \[selection get\] Fichier"
    TouchePour <2>      "/Rec1"     "AfficheRec2 \[selection get\] Rec1"
    TouchePour <3>      "/Vector"   "AfficheRec2 \[selection get\] Vecteur"
    return $Fen


}

proc AfficheLesSortiesBlast {Selection} {


    foreach NomDuFichierBlast [split $Selection "\n"] {
	AfficheUneSortieBlast $NomDuFichierBlast
    }


}

proc AfficheLesSortiesDuBallast {FichierBlastP {Quoi rsf}} {


    regsub {/co[a-z]+/} $FichierBlastP "/coballast/" FichiersBallast
    regsub -nocase {\.[a-z_]*$} $FichiersBallast "" FichiersBallast
    set Fichier "$FichiersBallast.$Quoi"
    Espionne $Fichier
    if { ! [file exists $Fichier]} { return "" }
    return [AfficheFichier $Fichier "Avec$Quoi"]


}

proc AfficheLesSourcesDeGscope {{PathType ""} {AvecMain ""} {WithoutOrdali ""}} {


    set LesSourcesDeGscope [LesSourcesDeGscope $PathType $AvecMain]
    set Page [join $LesSourcesDeGscope "\n"]
    set Fen [AfficheVariable $Page "AvecShowFile" "LesSourcesDeGscope_$PathType"]
    set B [BoutonneLaFenetre $Fen "Path exact/abs/rel" ""]
    bind $B <1> "AfficheLesSourcesDeGscope Exact    $AvecMain"
    bind $B <2> "AfficheLesSourcesDeGscope Absolute $AvecMain"
    bind $B <3> "AfficheLesSourcesDeGscope Relativ  $AvecMain"
    $B configure -background "green"


}

proc AfficheLesSpines {Page {KO ""}} {


    foreach Ligne [split $Page "\n"] {
	if { ! [regexp -nocase {[a-z]} $Ligne]} { continue }
	ScanLaLigneSpine $Ligne X Al Ac SpOk 
	if {$SpOk} {
	    lappend LesBons $Ligne
	} else {
	    lappend LesMauvais $Ligne
	}	
    }
    if {$KO=="KO"} {
	set NewPage [join $LesMauvais "\n"]
    } else {
	set NewPage [join $LesBons "\n"]
    }
    return [AfficheVariable $NewPage]


}

proc AfficheLesStructuresSecondairesDeLActin {} {



    Wup "Article ARP permet d afficher la numerotation des elements de structures secondaires et leur positions"

    set NbHelix [LePCIDuResidu Helix Number]
    for {set i 1} {$i<=$NbHelix} {incr i} {
	set D [LePCIDuResidu Helix $i Reference Debut]
	set F [LePCIDuResidu Helix $i Reference Fin]

	Espionne "H${i} ${D}-${F}" 
    }
    set NbSheet [LePCIDuResidu Sheet Number]
    for {set i 1} {$i<=$NbSheet} {incr i} {
	set D [LePCIDuResidu Sheet $i Reference Debut]
	set F [LePCIDuResidu Sheet $i Reference Fin]

	Espionne "S${i} ${D}-${F}" 
    }
    return ""


}

proc AfficheLesmiRNAs {K} {


    global RepertoireDuGenome

    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]

    set Chro [lindex $MesTags 0]
    set Deb [lindex $MesTags 1]
    set Fin [lindex $MesTags 2]
    set Nom [lindex $MesTags 3]

    set Texte "$Nom\n$Chro\nFrom $Deb\nTo $Fin"
    ac_AfficheVariable "$Texte" "" "Summary"
    return "$Texte"


}

proc AfficheListe {Liste {Maniere ""} {NomDuFichierOrigine ""}} {


    return [Affiche [join $Liste "\n"] $Maniere $NomDuFichierOrigine]


}

proc AfficheLogDesMSF {Selection} {


    foreach MSF [split $Selection "\n"] {
	AfficheLogDuMSF $MSF
    }


}

proc AfficheLogDuMSF {MSF} {


    global LogDuMSF
    if {[info exists LogDuMSF($MSF)]} {
	set Log [set LogDuMSF($MSF)]
    } else {
	regsub {.out} $MSF {.log} logmsf
	regsub {.msf$} $logmsf {} Log
    }
    if {[info exists Log]} {
	AfficheFichier $Log "AvecRien"
    }


}

proc AfficheMapping {FichierBlast {BanquesId ""} {SensGeneralDeS ""} {ExpectDeRef ""} {TailleMaxDesRAS NoCompress}} {


    global RepertoireDuGenome
    set Repertoire [RepertoireDeTravail]

    if {$ExpectDeRef == "" } {set ExpectDeRef "100"}

    if {![file exists $FichierBlast]} {return "toto"}
    
    set FichierTFA ""
    if {[EstUnPAB [file tail $FichierBlast]]} {
	set Nom [file tail    $FichierBlast]
	set Dir [file dirname $FichierBlast]
	if {$Dir == "."} {set Dir [pwd]}
	set DirDuRepertoireDuGenome [lindex [split $Dir "/"] end]
	if {[regexp "^blastn|^blastx" $DirDuRepertoireDuGenome]} {
	    set FichierTFA "$RepertoireDuGenome/nucmask/$Nom"
	    if {![file exists $FichierTFA]} {
		set FichierTFA "$RepertoireDuGenome/nuctfa/$Nom"
	    } 
	} elseif {[regexp "^blastp|^tblastn" $DirDuRepertoireDuGenome]} {
	    if {[file exists "$RepertoireDuGenome/genscanpredictions/$Nom"]} {
		set FichierTFA "$RepertoireDuGenome/genscanpredictions/$Nom"
	    } else {
		set FichierTFA "$RepertoireDuGenome/prottfa/$Nom"
	    }
	} elseif {[regexp "^mrnablast" $DirDuRepertoireDuGenome]} {
	    set FichierTFA "$RepertoireDuGenome/mrnahuman/$Nom"
	}
    }
    if {![file exists $FichierTFA]} {set FichierTFA ""}

    set LargeurMax      [expr [winfo screenwidth .] - 200]
    set HauteurMax      [expr [winfo screenheight .]*3/4]
    set LargeurFenetre  [expr [winfo screenwidth .] - 200]
    set HauteurFenetre  [expr [winfo screenheight .]*3/4]
    
    set HBox            25.0
    set HSmallBox       10.0
    set BordY           50.0
    set BordX           125.0
    set EcartY          1.0
    set CentreX [expr $LargeurMax/2]
    set PosYEnteteDeQ 8
    set PosYEnteteDeS [expr $HauteurMax - $PosYEnteteDeQ]
    set Police "Courier 10"
    set YNomQuery       [expr $BordY*2/3]
    set YTypeDeBlast    [expr $BordY/4]
    set TailleMaxNomQuery 100
    set XTexteGauche [expr $BordX/2]
    set XTexteDroite [expr $LargeurMax - $BordX/2]
    set YTailleQ [expr $BordY + $HBox/2]
    set YTailleS [expr $HauteurMax - $BordY - $HBox/2]

    set LesBanquesId [split $BanquesId "\n"]
    if {$BanquesId==""} {set BId [set tab(1)];set LesBanquesId [list "$BId"]}

    DepouilleLeBlast tab $FichierBlast "" "" $LesBanquesId
    set Database    [set tab(Database)   ]
    set TypeDeBlast [set tab(TypeDeBlast)]
    set TypeDeBlast "$TypeDeBlast: $Database"
    set NomQuery    [set tab(Query)]
    if {$TailleMaxNomQuery < [string length $NomQuery]} { 
	set PetitNomQuery [string range $NomQuery 0 $TailleMaxNomQuery]
	append PetitNomQuery "..."
    } else {
	set PetitNomQuery $NomQuery
    }

    if {$TailleMaxDesRAS == ""} {
	set TailleMaxDesRAS 500
    } elseif {$TailleMaxDesRAS == "NoCompress"} {
	set TailleMaxDesRAS "1e200"
    } else {
	if {![EstCeUnNombre $TailleMaxDesRAS]} {
	    set TailleMaxDesRAS "500"
	}
    }
    foreach BanqueId $LesBanquesId {
	scan $BanqueId "%s" BanqueId
	set ToutesLesRegions [ToutesLesRegionsDeLaQuery tab $FichierBlast $BanqueId $FichierTFA]
	set K [UnCanva $LargeurMax $HauteurMax $LargeurFenetre $HauteurFenetre]
	$K configure -background white   
	
	if {[lindex [lindex $ToutesLesRegions 0] 5] != ""} {
	    set PresenceDUnSubject 1
	} else {
	    set PresenceDUnSubject 0
	}
	
	set TailleQ [lindex [lindex $ToutesLesRegions 0] 2]
	set TailleS [lindex [lindex $ToutesLesRegions 0] 5]
	
	set TailleReduiteS $TailleS
	set TailleReduiteQ $TailleQ
	set LesRegionsDeLaQuery {}
	set LesRegionsDuSubject {}
	set LesRegionsAvecLesDeux {}
	set CalculSensS 0
	foreach UneRegion $ToutesLesRegions {
	    set DebutQ [lindex $UneRegion 0] 
	    set FinQ [lindex $UneRegion 1]
	    set DebutS [lindex $UneRegion 3]
	    set FinS [lindex $UneRegion 4] 
	    set TypeRegion [lindex $UneRegion 6]
	    set Sens [SensDeLaRegion $TypeRegion]
	    
	    if {  $DebutS != "" && $FinS != ""} {
		set Diffs [expr $FinS - $DebutS + 1]
		if {$Sens == "+"} {
		    set CalculSensS [expr $CalculSensS + $Diffs]
		} elseif {$Sens == "-"} {
		    set CalculSensS [expr $CalculSensS + $Diffs]
		}
	    }
	    if {$DebutQ != "" && $FinQ != ""} {
		lappend LesRegionsDeLaQuery $UneRegion
	    }
	    if {$DebutS != "" && $FinS != ""} {
		lappend LesRegionsDuSubject $UneRegion
	    }
	    if {$DebutS != "" && $FinS != "" && $DebutQ != "" && $FinQ != ""} {
		lappend LesRegionsAvecLesDeux $UneRegion
	    }
	    
	    if {      $DebutS != "" && $FinS != "" && $TypeRegion == "RAS"} {
		set DiffS [expr $FinS - $DebutS + 1]
		if {$TailleMaxDesRAS<$DiffS} {
		    set TailleReduiteS [expr $TailleReduiteS - $DiffS + $TailleMaxDesRAS]
		}
		
	    } elseif {$DebutQ != "" && $FinQ != "" && $TypeRegion == "RAS"} {
		set DiffQ [expr $FinQ - $DebutQ + 1]
		if {$TailleMaxDesRAS<$DiffQ} {
		    set TailleReduiteQ [expr $TailleReduiteQ - $DiffQ + $TailleMaxDesRAS]
		}
	    } 
	}

	if {$SensGeneralDeS == ""} {
	    if {$CalculSensS < 0} {
		set SensGeneralDeS "-"
	    } else {
		set SensGeneralDeS "+"
	    }
	}
	#########QUERY##############################
	#########QUERY##############################
	set OldXDebutQ ""
	set OldXFinQ ""
	set OldYDebutQ ""
	set OldYFinQ ""
	
	set RapportQ [expr ($LargeurMax - 2 * $BordX) / $TailleReduiteQ]
	set ModifTailleQ 0
	set LesRegionsOccupees {}
	foreach Region $LesRegionsDeLaQuery {
	    ######### COLORING########################
	    set ColorOutLine "white"
	    set TypeRegion [lindex $Region 6]
	    if {$TypeRegion == "" && [regexp "BLASTP" $TypeDeBlast]} {
		set TypeRegion "Prot / Prot"
	    }
	    set Sens [SensDeLaRegion $TypeRegion]	    
	    set ColorFill [ColoriageDuMapping $TypeRegion]
	    #########QUERY##############################
	    if {[lindex $Region 0] == "" || [lindex $Region 1] == ""} {continue}
	    
	    set DebutQ [lindex $Region 0]
	    set FinQ [lindex $Region 1]
	    
	    if {$DebutQ == $FinQ} {
		set XDebutQ [expr $BordX + ($DebutQ - 0.5  - $ModifTailleQ) * $RapportQ ]
		set XFinQ [expr $BordX + ($FinQ + 0.5 - $ModifTailleQ) * $RapportQ ]
	    } else {
		set XDebutQ [expr $BordX + ($DebutQ - $ModifTailleQ) * $RapportQ ]
		set XFinQ [expr $BordX + ($FinQ - $ModifTailleQ) * $RapportQ ]
	    }
	    
	    if {$TypeRegion == "RAS"} {
		set DiffQ [expr $FinQ - $DebutQ + 1]
		if {$DiffQ > $TailleMaxDesRAS} {
		    set ColorFill "darkgrey"
		    set XFinQ [expr $BordX + ([lindex $Region 0] - $ModifTailleQ + $TailleMaxDesRAS) * $RapportQ ]
		    set ModifTailleQ [expr $ModifTailleQ + $DiffQ - $TailleMaxDesRAS]
		}
	    }
	    
	    set NbRecouvrement [RecouvrementDeLaRegion $DebutQ $FinQ $LesRegionsOccupees "Etendre"]
	    if {$NbRecouvrement >= 40} {set NbRecouvrement 40}
	    if {$NbRecouvrement == 0} {
		set YDebutQ $BordY
		set YFinQ   [expr $YDebutQ + $HBox]
	    } else {
		set YDebutQ [expr $BordY + $HBox + ($NbRecouvrement * $EcartY) + ($NbRecouvrement-1) * $HSmallBox]
		set YFinQ   [expr $YDebutQ + $HSmallBox]
	    }
	    
	    set LesCoordonnees [list "$XDebutQ" "$XFinQ" "$YDebutQ" "$YFinQ" "$ColorFill"]
	    set TabQ($DebutQ,$FinQ) $LesCoordonnees
	    
	    set LeDebutEtLaFin [list "$DebutQ" "$FinQ"]
	    lappend LesRegionsOccupees $LeDebutEtLaFin
	}
	
	set LesRegionsDuSubject [lsort -increasing -integer -index 3 [lsort -decreasing -integer -index 4 $LesRegionsDuSubject]]
	#######SUBJECT###############################	
	#######SUBJECT###############################
	if {[lindex [lindex $ToutesLesRegions 0] 5]!= ""} { 
	    set RapportS [expr ($LargeurMax - 2 * $BordX) / $TailleReduiteS]
	    set YFinS [expr $HauteurMax - $BordY]
	    set YDebutS [expr $YFinS - $HBox]	
	}
	set ModifTailleS 0
	set ModifTailleQ 0
	foreach Region $LesRegionsDuSubject {
	    ######### COLORING########################
	    set ColorOutLine "white"
	    set TypeRegion [lindex $Region 6]
	    if {$TypeRegion == "" && [regexp "BLASTP" $TypeDeBlast]} {
		set TypeRegion "Prot / Prot"
	    }
	    set ColorFill [ColoriageDuMapping $TypeRegion]
	    
	    #######SUBJECT###############################
	    if {[lindex $Region 3] == "" || [lindex $Region 4] == ""} {continue}
	    set DebutS [lindex $Region 3]
	    set FinS [lindex $Region 4]
	    
	    set XDebutS [expr $BordX + ($DebutS - $ModifTailleS) * $RapportS ]
	    set XFinS [expr $BordX + ($FinS - $ModifTailleS) * $RapportS ]
	    if {$TypeRegion == "RAS"} {
		set DiffS [expr $FinS - $DebutS + 1]
		if {$DiffS > $TailleMaxDesRAS} {
		    set ColorFill "darkgrey"
		    set XFinS [expr $BordX + ($DebutS - $ModifTailleS + $TailleMaxDesRAS) * $RapportS ]
		    set ModifTailleS [expr $ModifTailleS + $DiffS - $TailleMaxDesRAS]
		}
	    }		
	    set LesCoordonnees [list "$XDebutS" "$XFinS" "$YDebutS" "$YFinS" "$ColorFill"]
	    set TabS($DebutS,$FinS) $LesCoordonnees
	}

	$K create text $CentreX $YTypeDeBlast -text "$TypeDeBlast" -font "$Police"
	$K create text $CentreX $YNomQuery -text "$PetitNomQuery" -font "$Police"
	
	$K create text $XTexteGauche $YTailleQ -text "1" -font "$Police"
	$K create text $XTexteDroite $YTailleQ -text "$TailleQ" -font "$Police"
	
	if {$PresenceDUnSubject} {
	    $K create text $CentreX [expr $HauteurMax - $YNomQuery] -text "$BanqueId" -font "$Police"
	    if {$SensGeneralDeS == "+"} {
		$K create text $XTexteGauche $YTailleS -text "1" -font "$Police" -anchor w
		$K create text $XTexteDroite $YTailleS -text "$TailleS" -font "$Police" -anchor e
	    } else {
		$K create text $XTexteDroite $YTailleS -text "1" -font "$Police" -anchor e
		$K create text $XTexteGauche $YTailleS -text "$TailleS" -font "$Police" -anchor w
	    }
	}
	
	foreach UneRegion $ToutesLesRegions {
	    set XDebutQ ""
	    set XFinQ ""
	    set XDebutS ""
	    set XFinS ""
	    set DebutQ      [lindex $UneRegion 0] 
	    set FinQ      [lindex $UneRegion 1]
	    set DebutS      [lindex $UneRegion 3]
	    set FinS      [lindex $UneRegion 4] 
	    set TypeRegion [lindex $UneRegion 5]
	    set Sens [SensDeLaRegion $TypeRegion]
	    
	    if {    $DebutQ != "" && $FinQ != "" &&  $DebutS == "" && $FinS == "" } {
		set LesCoordonnees [set TabQ($DebutQ,$FinQ)]
		set XDebutQ [lindex $LesCoordonnees 0]
		set XFinQ [lindex $LesCoordonnees 1]
		set YDebutQ [lindex $LesCoordonnees 2]
		set YFinQ [lindex $LesCoordonnees 3]
		set ColorFill [lindex $LesCoordonnees 4]
		
		$K create rectangle $XDebutQ $YDebutQ $XFinQ $YFinQ -outline $ColorOutLine -fill $ColorFill
	    }  elseif {$DebutS != "" && $FinS != "" &&  $DebutQ == "" && $FinQ == "" } {
		set LesCoordonnees [set TabS($DebutS,$FinS)]
		
		if {$SensGeneralDeS == "+"} {
		    set XDebutS [lindex $LesCoordonnees 0]
		    set XFinS [lindex $LesCoordonnees 1]
		} else {
		    set XDebutS [expr $LargeurMax - [lindex $LesCoordonnees 0]]
		    set XFinS   [expr $LargeurMax - [lindex $LesCoordonnees 1]]
		}
		
		set YDebutS [lindex $LesCoordonnees 2]
		set YFinS [lindex $LesCoordonnees 3]
		
		set ColorFill [lindex $LesCoordonnees 4]
		
		$K create rectangle $XDebutS $YDebutS $XFinS $YFinS -outline $ColorOutLine -fill $ColorFill
	    } elseif {$DebutS != "" && $FinS != "" &&  $DebutQ != "" && $FinQ != "" } {
		
		set LesCoordonnees [set TabQ($DebutQ,$FinQ)]
		set XDebutQ [lindex $LesCoordonnees 0]
		set XFinQ [lindex $LesCoordonnees 1]
		set YDebutQ [lindex $LesCoordonnees 2]
		set YFinQ [lindex $LesCoordonnees 3]
		set ColorFill [lindex $LesCoordonnees 4]
		
		set LesCoordonnees [set TabS($DebutS,$FinS)]
		set YDebutS [lindex $LesCoordonnees 2]
		set YFinS [lindex $LesCoordonnees 3]
		if {$SensGeneralDeS == "+"} {
		    set XDebutS [lindex $LesCoordonnees 0]
		    set XFinS [lindex $LesCoordonnees 1]
		} else {
		    set XDebutS [expr $LargeurMax - [lindex $LesCoordonnees 0]]
		    set XFinS   [expr $LargeurMax - [lindex $LesCoordonnees 1]]
		}
		
		set ColorFill [lindex $LesCoordonnees 4]
		
		$K create rectangle $XDebutQ $YDebutQ $XFinQ $YFinQ -outline $ColorOutLine -fill $ColorFill
		$K create rectangle $XDebutS $YDebutS $XFinS $YFinS -outline $ColorOutLine -fill $ColorFill
		$K create line $XDebutQ $YFinQ $XDebutS $YDebutS -fill $ColorFill
		$K create line $XFinQ $YFinQ $XFinS $YDebutS -fill $ColorFill
	    }
	}
	regsub {\.canvas} $K "" w
	set B [BoutonneLaFenetre $w "Show Blast/Subject/Fetch\nMosaic"]
	bind $B <1> "AfficheFichier $FichierBlast AvecSegAlignementAvecAligneurs"
	bind $B <2> "AfficheLesAliEnPage \[ContenuDuFichier $FichierBlast\] $BanqueId $FichierBlast"
	bind $B <3> "AfficheFetch  $BanqueId OnVeutNature"
	bind $B <Shift-1> "IllustreLeBlast $FichierBlast"

	set C [BoutonneLaFenetre $w "Color" "CouleursDesBoites"]
	set S [BoutonneLaFenetre $w "Direction      +    / - / Default\n Compression Default / x /  None"]
	bind $S <1>       "AfficheMapping $FichierBlast $BanqueId + $ExpectDeRef $TailleMaxDesRAS"
	bind $S <2>       "AfficheMapping $FichierBlast $BanqueId - $ExpectDeRef $TailleMaxDesRAS"
	bind $S <3>       "AfficheMapping $FichierBlast $BanqueId \"\" $ExpectDeRef $TailleMaxDesRAS"
	bind $S <Shift-1> "AfficheMapping $FichierBlast $BanqueId $SensGeneralDeS $ExpectDeRef \"\""
	bind $S <Shift-2> "AfficheMapping $FichierBlast $BanqueId $SensGeneralDeS $ExpectDeRef \[Entre\]"
	bind $S <Shift-3> "AfficheMapping $FichierBlast $BanqueId $SensGeneralDeS $ExpectDeRef NoCompress"
    }
    return $K


}

proc AfficheMedline {Selection} {


    Wup "Calls Jean-Marie Wurtz's program to fetch medline's http file."
    foreach Ligne [split $Selection "\n"] {
	catch {unset Uid}
	if {[regexp "^RX" $Ligne]} {
	    catch {set Uid [IntegerApres "MEDLINE;" dans $Ligne]}
	} elseif {[regexp "PMID:" $Ligne]} {
	    catch {set Uid [IntegerApres "PMID:" dans $Ligne]}
	} else {
	    continue
	}
	if { ! [info exists Uid] || ! [regexp {^[0-9]+$} $Uid] } { continue }
	AfficheVariable [exec medhttp $Uid] "AvecRien"
    }


}

proc AfficheMesPABs {} {



    foreach PAB [ListeDesPABs] {
	Espionne "$PAB [Alias $PAB]"
    }


}

proc AfficheModeAnnotation {} {

    if {! [EtatBouton $::WOrdali(BoutAnno)]} {
	AfficheSnapshotAnnotations
    }

    AfficheBoutonsAnnotation

    if {[EtatBouton $::WOrdali(BoutAnno)]} {
	AfficheSnapshotAnnotations
    }

    return

}

proc AfficheModeArbres {} {


    AfficheBoutonsArbres
    BindModeNormal

    return

}

proc AfficheModeCherche {{prevMode ""}} {


    AfficheBoutonsCherche $prevMode

    return

}

proc AfficheModeClusters {} {


    InitSeqsOut 0
    AfficheBoutonsClusters
    
    return

}

proc AfficheModeConservation {} {


    AfficheBoutonsConservation

    return

}

proc AfficheModeFeateditor {} {

    array set ::Tori [array get ::TabSF]
    AfficheBoutonsFeateditor
    unset -nocomplain ::Tori

    return

}

proc AfficheModeFeatures {} {

    global LFeatCourantes

    if {! [info exists LFeatCourantes]} {
	set LFeatCourantes [list]
    }
    AfficheBoutonsFeatures

    return

}

proc AfficheModeOrdali {} {

    AfficheBoutonsOrdali
    BindModeNormal

    return

}

proc AfficheModePCI {} {


    AfficheBoutonsPCI
    BindModeNormal

    return

}

proc AfficheModeSeqlab {} {

    global NomTextSeq Toggle NomNOmSeq

    LesDefauts AffSS 1
    CacheStrSecDansAlignement
    if {$Toggle(Scores)} {
	set Toggle(Scores) 0
	ToggleScores
    }

    EmulationSeqLab
    BindModeSeqlab
    AfficheBoutonsSeqLab

    return

}

proc AfficheModeSuperposition {} {

    global ListePDB

    if {[TypeAli] eq "pasdali"} {return}

    # pas , ou 1 seul , pdb
    if {! [info exists ListePDB] || $ListePDB == {}} {
	FaireLire "No 3D structures in this alignment !"
	return
    }

    if {[llength $ListePDB] == 1} {
	set ::StrucAVoir $ListePDB
	VisualiseStructure
    } else {
	AfficheBoutonsSuperposition
    }

    BindModeNormal

    return

}

proc AfficheMoi {args} {


    set Pro [lindex $args 0]
    if { ! [HtmlAuthorize $Pro]} { Expe "Error from Gscope : $Pro isn't authorized" ; return "" }
    set Retour [eval $args]
    return [Html_DuTexteTelQuel $Retour] 


}

proc AfficheMsfFamily {Nom} {


    global RepertoireDuGenome
    set Famille [NomDeFamille $Nom]
    if {$Famille=="UnknownFamily"} { return "" }
    set Fichier "$RepertoireDuGenome/msffamily/$Famille.msf"

    if { ! [file exists $Fichier]} { return "" }

    return [AfficheFichier $Fichier "GrandeLargeurAvecEtudeMSF"]


}

proc AfficheMsfOfFamiliarOrganisms {NomOrigine} {


    
    set Nom [file tail $NomOrigine]
    set FamMsf [MsfOfFamiliarOrganisms $Nom]
    if {$FamMsf==""} { return "" }
    return [AfficheVariable $FamMsf "AvecEtudeMSFGrandeLargeur" $NomOrigine]


}

proc AfficheNomsEtSeqs {} {

    global Defauts NomsAffiches LSOrdali NomNomSeq NomTextSeq TScrollY

    if {! [ModeI]} {return}

    set YPos [$TScrollY get]
    EffaceWNomsWSeqs

    $NomNomSeq configure -state normal
    $NomNomSeq tag configure PDB -foreground black -background red -underline 1
    $NomNomSeq insert end [join $NomsAffiches "\n"]
    $NomNomSeq configure -state disabled

    if {[QuelMode] ne "seqlab"} {
	$NomTextSeq configure -state normal
	$NomTextSeq insert end [join $LSOrdali "\n"]
	$NomTextSeq configure -state disabled
    }

    $TScrollY set {*}$YPos

    return

}

proc AfficheNuc {Boite} {


    set Nom [Box $Boite nom]
    if { $Nom=="" } { return "" }
    set Debut  [Box $Boite debut]
    set Fin    [Box $Boite fin]
    set Orient [Box $Boite orient]
    set SeqNuc [BoutADN $Debut $Fin $Orient]
    set NucTFA [SequenceFormatTFA $SeqNuc "$Nom $Debut $Fin $Orient" "nucbrut"]
    return [AfficheVariable $NucTFA "AvecBlasteAvecFormateAvecVoisinsSansFetch" $Nom]


}

proc AfficheORGAorgaDesMSFs {{Etat ""}} {


    foreach Nom [ListeDesPABs] {
	lappend LesORGAorga "$Nom [ORGAorgaDesMSFs $Nom $Etat]"
    }
    AfficheVariable [join $LesORGAorga "\n"] "AvecRien" "OrthologuesInCompleteGenomes"


}

proc AfficheObjet {w nom obj} {

    global pgl

    if {[$w cget -foreground] eq "green1"} {
	$nom ObjetOff $obj
	$w configure -foreground red
    } else {
	$nom ObjetOn $obj
	$w configure -foreground green1
    }

    DefineLabels2Show
    set pgl(SelectionList) ""

    $pgl(wogl) postredisplay

    return

}

proc AfficheOperonsCommunsAuxClusters {} {


    set Fichier "[RepertoireDuGenome]/fiches/operons_communs"
    set Texte [ContenuDuFichier $Fichier]
    regsub -all "\t" $Texte " " Texte
    while {[regexp "  " $Texte]} { regsub -all "  " $Texte " " Texte }
    return [AfficheVariable $Texte "AvecOpCom" $Fichier]


}

proc AfficheOverview {} {

    global Ovw FrmBtnFea LNDG ListeTypesDeFeatures NomTextSeq

    # alignement vide
    if {[TypeAli] eq "pasdali"} {return}
    if {[QuelMode] eq "seqlab"} {
	FaireLire "Not available in Editor mode !"
	return
    }
    
    FaireAttendre "Please wait ...\nDrawing alignment overview ..."

    # configure features
    if {! [info exists Ovw(Liste)]} {
	set Id 1
	set Ovw(Groupes) $LNDG
	set Ovw(Liste) [list $Id]
    } else {
	set Id [expr {[lindex [set Ovw(Liste)] end] + 1}]
    }
    MetAJourFeaturesOverview

    # define new overview
    set Ovw(O$Id,Feat) "automatic"
    set Ovw(O$Id,Mac) [MacCourant]

    # Create overview window
    set w [AfficheFenetreOverview $Id]

    CalculeOverview $Id

    # Display the feautres currently displayed on the 
    # alignment (if any) on the overview
    if {[info exists FrmBtnFea] && [QuelMode] eq "feature"} {
	foreach c [winfo children $FrmBtnFea] {
	    if {[EtatDuBouton $c]} {
		set f [lindex [$c cget -command] 1]
		DessineFeatureSurOverview $Id "" $f 1
	    }
	}
    }

    FaireLaSuite .wover

    trace add execution RepeintNomsEtSeqs leave MetAJourOverview
    trace add variable ListeTypesDeFeatures write MetAJourFeaturesOverview

    # position new window
    set h 0
    foreach top [winfo children .] {
	if {[string first ".overview" $top] != 0} {
	    continue
	}
	if {$top eq $w} {
	    continue
	}
	incr h [winfo height $top]
    }
    wm geometry $w +0+$h

    update idletasks

    return $Id

}

proc AffichePDB {aPDB} {


    regsub "PDB_" $aPDB "" aPDB   ; #rR 2017/10/07
JeMeSignale
    set TextePDB [TextePDB $aPDB "Ref"]

    if {$TextePDB==""} { return "" }

    return [AfficheVariable $TextePDB "AvecPDB"]



}

proc AffichePeptideSort {Nom {Page ""} {ShowEnzymes ""}} {


    if {[EstUnPAB $Nom]} {
	set Texte [PeptideSort $Nom $ShowEnzymes]
    } elseif {$Page!=""} {
	set Texte [PeptideSort $Page $ShowEnzymes]
    } elseif {$Nom!=""} {
	set Texte [PeptideSort $Nom $ShowEnzymes]
    } else { 
	return ""
    }
    if {$Texte==""} { return "" }
    scan $Nom "%s" Titre
    return [AfficheVariable $Texte "AvecRien" $Titre] 


}

proc AffichePeptideSortPourLesFusions {{LesFiFu ""} {ChoixPourCoupure ""} {AvecAffichage ""}} {



    if {$AvecAffichage=="SansAffichage"} { set AvecAffichage 0 } else { set AvecAffichage 1 }

    if {$LesFiFu==""} {
	set LesFiFu [glob -nocomplain "[RepertoireDuGenome]/fusion/*.nuctfa"]
	set LesFiFu [ChoixDesPresents $LesFiFu]
    }
    if {$LesFiFu=="AllFusion"} {
	set LesFiFu [glob -nocomplain "[RepertoireDuGenome]/fusion/*.nuctfa"]
    }
    if {$LesFiFu==""} { return "" }

    if {[llength [split $ChoixPourCoupure " "]]==5} {
	set ChoixCoupure $ChoixPourCoupure
    } else {
	set ChoixCoupure [ChoixDUnSiteDeCoupure $ChoixPourCoupure]
    }
    set LongCoupP ""
    scan $ChoixCoupure "%s %s %d %s %d" Coupure CoupN LongCoupN CoupP LongCoupP
#    if {$LongCoupP==""} { return {} }
    foreach FiFu $LesFiFu {
	set Nom [file tail $FiFu]
	regsub ".nuctfa" $Nom "" Nom
	regsub ".prottfa" $FiFu ".nuctfa" FiFuN

	lappend LesNoms $Nom

	set SeqN [QueLaSequenceDuTFA $FiFuN]
	set SeqP [SeqNucToSeqPro $SeqN]
	set Zone(Seq) "Full"
	set LesVariablesSeq [list "Seq"]
	if {$Coupure!="SansCoupure"} {
	    set iDebutCoupure [string first $CoupN [string toupper $SeqN]]
	    set lastDebutCoupure [string last $CoupN [string toupper $SeqN]]
	    if {$iDebutCoupure!=$lastDebutCoupure} {
		FaireLire "At least two sites for $Coupure are possible. \nI'll take the first one : $iDebutCoupure"
	    }
	    if {$iDebutCoupure>=0} {
		set GaucheSeqN [string range $SeqN 0 [expr $iDebutCoupure+$LongCoupN-1]]
		set DroiteSeqN [string range $SeqN [expr $iDebutCoupure+$LongCoupN] end]
	    }
	    set GaucheSeqP [SeqNucToSeqPro $GaucheSeqN]
	    set DroiteSeqP [SeqNucToSeqPro $DroiteSeqN]
	    lappend LesVariablesSeq "GaucheSeq" "DroiteSeq"
	    set Zone(GaucheSeq) "Left"
	    set Zone(DroiteSeq) "Righ"
	}
	foreach VariableSeq $LesVariablesSeq {
	    set CR      [CodonsRares [set [set VariableSeq]N] "AvecBlanc"]
	    set PepSort [PeptideSort [set [set VariableSeq]P]]
	    if {[info exists TPep]} { unset TPep }
	    DecortiquePeptideSort $PepSort "" TPep
	    set Residues         [set TPep(Residues)]
	    set Molecularweight  [set TPep(Molecularweight)]
	    set Charged          [set TPep(Charged)]
	    set Isoelectricpoint [set TPep(Isoelectricpoint)]
	    
	    set SeqCompressee ""
	    append SeqCompressee [string range [set [set VariableSeq]P] 0 5]
	    append SeqCompressee "..."
	    append SeqCompressee [string range [set [set VariableSeq]P] end-5 end]
	    set ZoNom [string range "[set Zone($VariableSeq)]_$Nom" 0 36]
	    lappend LesFragments [format "%-40.40s %4d %3d %10.2f %5.2f %s %s"  $ZoNom  $Residues $Charged  $Molecularweight $Isoelectricpoint  $SeqCompressee  $CR ]
	}
    }
    set LesFragments [LesLignesTrieesSurUneClefEntete $LesFragments [list 0 3 1]]
    if {$AvecAffichage} {
	FaireLire "I'll show you the report. Please don't forget to save it."
	AfficheVariable [join $LesFragments "\n"] "AvecTriFragments" PeptideSortSurFusion
    } else {
	set LesNR1 {}
	foreach Nom $LesNoms {
	    regsub {_[^_]+$} $Nom "" NR1
	    lappend LesNR1 $NR1
	}
	set NomFusRep [join [lsort -unique $LesNR1] "-"]
	set FichierReport "[RepertoireDuGenome]/fusionreport/${NomFusRep}_[Date].txt"
	return [SauveLesLignes $LesFragments dans $FichierReport]
    }
    return $LesFragments


}

proc AffichePof {{Quoi ""}} {


    if {$Quoi==""} { set Quoi "PofOl_PofPPCR_PofMut_PofSeq" }
    set Retour {}
    if {[regexp "AllPs" $Quoi]} {
	set LesPofOl  [PofOl  "LesPofOl"]
	set LesPofMut [PofMut "LesPofMut"]
	set LesPofSeq [PofSeq "LesPofSeq"]
	set LesPs [lsort [concat $LesPofOl $LesPofMut $LesPofSeq]]
	foreach TextP $LesPs {
	    scan $TextP "%s" P
	    set DejaVu($P) 1
	}
	foreach P [Oli "LaListeMerci"] {
	    if {[info exists DejaVu($P)]} { continue }
	    lappend LesPs [Oli $P "AllOnOneLine"]
	}

	set FO [AfficheListe $LesPs "AvecOliAvecFiOl" "PofOl_PofMut_PofSeq"]
	lappend Retour $FO
    }
    if {[regexp "PofOl" $Quoi]} {
	set FO [AfficheListe [PofOl  "LesPofOl"] "AvecOliAvecFiOl" "PofOligos"]
	lappend Retour $FO
    }
    if {[regexp "PofMut" $Quoi]} {
	set FO [AfficheListe [PofMut "LesPofMut"] "AvecOliAvecFiOl" "PofMutation"]
	lappend Retour $FO
    }
    if {[regexp "PofSeq" $Quoi]} {
	set FO [AfficheListe [PofSeq "LesPofSeq"] "AvecOliAvecFiOl" "PofSequencing"]
	lappend Retour $FO
    }
    if {[regexp "PofPPCR" $Quoi]} {
	set FP [AfficheListe [PofPPCR "5_3"]      "AvecOliAvecFiPPCR" "PofPPCR"]
	lappend Retour $FP
    }
    return $Retour


}

proc AffichePosGenSeq {w {pos ""}} {

    # return conditions
    if {[TypeAli] eq "pasdali" || [QuelMode] eq "seqlab" || $pos eq ""} {return}

    lassign [split [$w index $pos] .] y x 
    if {! [string is integer -strict $y]} {return}

    if {[set nom [lindex $::LNOrdali $y-1]] eq ""} {return}

    set ::XGen [expr {$x+1}]
    set ::XSeq [DonnePosGS $nom $x]

    return

}

proc AffichePosGenSeqSL {w {pos ""}} {

    # ==> Pour le Mode SeqLab !!
    #
    # return conditions
    if {[TypeAli] eq "pasdali"} {return}
    update idletasks
    
    lassign [split [$w index $pos] .] y x 
    if {! [string is integer -strict $y]} {return}

    if {[set nom [lindex $::LNSeqlab $y-1]] eq ""} {return}

    set ::XGen [expr {$x+1}]
    set ::XSeq [DonnePosGS_SL $nom $w $y $x]

    return

}

proc AffichePositionOligo {K X Y Action {Id ""}} {


    
    Wup "Affiche a droite et a gauche la position de l oligo sur la query"

    global PositionExisteDeja 

    if {$Id == ""} {set Id [$K find withtag current]}
    
    set MesTags   [$K gettags $Id]
    set MesCoords [$K coords  $Id]
    set Nom       [lindex $MesTags 4]
    set Banque    [lindex $MesTags 5]

    if {! [info exists PositionExisteDeja($K,$Id)]} {set PositionExisteDeja($K,$Id) 0}  
    if {$Action=="Hide" || [set PositionExisteDeja($K,$Id)]=="1"} { 
	set PositionExisteDeja($K,$Id) 0
	set Texte " "
	set Id    ""
	foreach Id [$K find withtag "Position"] {
	    if {[lindex [$K gettags $Id] 0] != $Nom || [lindex [$K gettags $Id] 1] !=$Banque} {continue}
	    $K itemconfigure $Id -text $Texte
	}
	return ""
    }
    set PositionExisteDeja($K,$Id) 1

    set Xmin [lindex $MesCoords 0]
    set Xmax [lindex $MesCoords 2]
    set Ymin [lindex $MesCoords 1]
    set Ymax [lindex $MesCoords 3]
    $K create text [expr $Xmin-3] [expr (($Ymax-$Ymin)/2)+$Ymin]  -text [lindex $MesTags 2]  -tags [list $Nom $Banque "Position"]  -anchor "e"

    $K create text [expr $Xmax+3] [expr (($Ymax-$Ymin)/2)+$Ymin]  -text [lindex $MesTags 3]  -tags [list $Nom $Banque "Position"]  -anchor "w"
    return ""


}

proc AffichePositionOligoPourTous {K X Y Action} {


    
    Wup "Affiche a droite et a gauche la position de tous les oligos par rapport a la query"

    EffacePositionOligoPourTous $K $X $Y
    
    set         LesId [$K find withtag "Positionner"]
    foreach Id $LesId {
	AffichePositionOligo $K $X $Y $Action $Id
    }
    return ""


}

proc AffichePourLaFamilleHDACroises {K Quoi} {


    set Id [$K find withtag current]
    set MesTags [$K gettags $Id]
    set Famille [lindex $MesTags 1]

    if {$Quoi==1} {
	if {[EstUnPAB $Famille]} {return [SearchOnBoard $Famille]}
	set LesMembres [LesMembresDeLaFamilleHDACroises $Famille]
	return [AfficheVariable [join $LesMembres "\n"] "" "HDA_family_members_$Famille"]
    }

    if {$Quoi==2} {
	if {[EstUnPAB $Famille]} {return [AfficheLesMembresDeLaFamille $Famille]}
    }

    if {$Quoi==3} {
	if {[EstUnPAB $Famille]} {return [AfficheLeClusterXHda $Famille]}
    }
    return ""


}

proc AffichePreferences {} {

    global Defauts
    global TmpDef
    global TypeCons
    global Couleurs
    global TypeText

    if {[winfo exists .prf]} {return}

    set oldGrab [grab current]
    if {$oldGrab ne ""} {set oldStatus [grab status $oldGrab]}
    set oldFocus [focus]

    array set TmpDef [array get Defauts]

    toplevel .prf
    wm title .prf "Preferences"
    wm protocol .prf WM_DELETE_WINDOW KillParLaCroix

    frame .prf.fnb
    pack .prf.fnb -side top -expand 1 -fill both

    set w ".prf.fnb.nb"
    NoteBook $w -side top  -activebackground green  -bd 2 -arcradius 4  -bg [set Defauts(BackAppli)]


    $w insert 0 gen -text "General"
    $w insert 1 col -text "Colors"
    $w insert 2 cns -text "Conservation"
    $w insert 3 dbs -text "Databases"
    $w insert 4 str -text "Structure"

    # Frame General

    set pgen [$w getframe gen]

    label $pgen.lbl -text "Ordalie appearance parameters" -font "Helvetica 14 bold" -anchor w -justify left

    label $pgen.lac -text "Application background color : " -anchor w -justify left
    button $pgen.bac -bg [set TmpDef(BackAppli)] -command "ChangeCouleurAppli $pgen.bac" -height 1
    button $pgen.bca -text "Apply" -bg green1 -command "AppliqueBackColor" -height 1

    label $pgen.whl -text "Mouse Wheel controls :" -anchor w -justify left
    label $pgen.lwy -text "Vertical scrolling " -anchor w -justify left
    entry $pgen.ewy -width 3 -bg white -textvariable TmpDef(DeltaYScroll) -justify right
    label $pgen.wuy -text " line(s)" -anchor w -justify left

    label $pgen.lwx -text "Horizontal scrolling " -anchor w -justify left
    entry $pgen.ewx -width 3 -bg white -textvariable TmpDef(DeltaXScroll) -justify right
    label $pgen.wux -text " character(s)" -anchor w -justify left


    grid $pgen.lbl  -row 0 -column 0 -columnspan 4 -pady {10 20} -sticky ew
    grid $pgen.fntl -row 1 -column 0 -sticky news
    grid $pgen.ffml -row 1 -column 1 -sticky news
    grid $pgen.fsiz -row 1 -column 2 -sticky news
    grid $pgen.fwgh -row 1 -column 3 -sticky news
    grid $pgen.lac  -row 2 -column 0 -columnspan 2 -ipady 30 -sticky ew
    grid $pgen.bac  -row 2 -column 2 -sticky ew
    grid $pgen.bca  -row 2 -column 3 -sticky ew
    grid $pgen.whl  -row 3 -column 0 -columnspan 4 -pady {30 5} -sticky news
    grid $pgen.lwy  -row 4 -column 1 -sticky news
    grid $pgen.ewy  -row 4 -column 2 -sticky news
    grid $pgen.wuy  -row 4 -column 3 -sticky news
    grid $pgen.lwx  -row 5 -column 1 -sticky news
    grid $pgen.ewx  -row 5 -column 2 -sticky news
    grid $pgen.wux  -row 5 -column 3 -sticky news

    # Frame couleurs d'ordalie

    set pcol [$w getframe col]

    # Frame Conservation

    set pcns [$w getframe cns]
    grid columnconfig $pcns {1 2} -weight 1

    label $pcns.lbl -text "Click on the buttons to change the colors assigned\nto the different conservation types" -anchor w -justify left
    set i 0
    foreach Type [lrange $TypeCons 0 2] {
	incr i
	scan [set Couleurs($Type)] "%s %s" fg bg
	label  $pcns.l$Type -text [set TypeText($Type)] -anchor w
	button $pcns.f$Type -bg $fg -activebackground $fg -width 4 -command "ChangeCouleur $Type $fg $pcns.f$Type"
	button $pcns.b$Type -bg $bg -activebackground $bg -width 4 -command "ChangeCouleur $Type $bg $pcns.b$Type"

	grid $pcns.l$Type -row $i -column 0 -sticky w
	grid $pcns.f$Type -row $i -column 1 -sticky w
	grid $pcns.b$Type -row $i -column 2 -sticky w
    }
    grid $pcns.lbl -row 0 -column 0 -columnspan 3 -sticky we -pady {10 0}

    label $pcns.lblm -text "For the Threshold Method :\nDefine the threshold above which a column is said\nto be conserved" -justify left
    label $pcns.sclb -text "Threshold " -anchor w -justify left
    scale $pcns.scal -from 0 -to 100  -orient horiz -showvalue true  -variable TmpDef(Threshold)  -width 8 -length 75
    grid $pcns.lblm -row 4 -column 0 -columnspan 3 -sticky ew -pady {20 5}

    grid $pcns.sclb -row 5 -column 0 -columnspan 1 -sticky w
    grid $pcns.scal -row 5 -column 1 -columnspan 2 -sticky news

    label $pcns.sim -text "Use similarity" -anchor w -justify left
    radiobutton $pcns.simy -text "Yes" -variable Defauts(SimiGris) -relief flat -value "1"
    radiobutton $pcns.simn -text "No" -variable Defauts(SimiGris) -relief flat -value "0"

    grid $pcns.sim  -row 6 -column 0 -sticky w
    grid $pcns.simy -row 6 -column 1
    grid $pcns.simn -row 6 -column 2

    # Frame Databases

    set pdbs [$w getframe dbs]
    label $pdbs.ldbs -justify left -anchor w -text "Ordalie retrieves some information using distant\n databases. You may change the defaults ones to\n yours. IMPORTANT ! The XXXX stands for the Id\n to be retrieved, and it must be specified in your url !" -font "Helvetica 14 bold"

    label $pdbs.lpdb -text "Protein Data Bank (PDB) location :" -justify left -anchor w
    entry $pdbs.epd1 -bg white -textvariable TmpDef(UrlPdbWorld)
    entry $pdbs.epd2 -bg white -textvariable TmpDef(UrlPdbHome)

    label $pdbs.lsrs -text "Sequence Retrieval System (SRS) location :" -justify left -anchor w
    entry $pdbs.esr1 -bg white -textvariable TmpDef(UrlSRSWorld)
    entry $pdbs.esr2 -bg white -textvariable TmpDef(UrlSRSHome)

    label $pdbs.lbrd -text "Biological Information Retrieval Database (BIRD) location :" -justify left -anchor w
    entry $pdbs.ebr1 -bg white -textvariable TmpDef(UrlPdbHoan)

    grid $pdbs.ldbs -row 0 -column 0 -sticky news -pady {10 5}
    grid $pdbs.lpdb -row 1 -column 0 -sticky news -pady {20 1}
    grid $pdbs.epd1 -row 2 -column 0 -sticky news
    grid $pdbs.epd2 -row 3 -column 0 -sticky news
    grid $pdbs.lsrs -row 4 -column 0 -sticky news -pady {20 1}
    grid $pdbs.esr1 -row 5 -column 0 -sticky news
    grid $pdbs.esr2 -row 6 -column 0 -sticky news
    grid $pdbs.lbrd -row 7 -column 0 -sticky news -pady {20 1}
    grid $pdbs.ebr1 -row 8 -column 0 -sticky news -pady {0 10}

    # Frame Structure

    set pstr [$w getframe str]

    # Fin notebook

    pack $w -fill both -expand yes
    $w compute_size
    $w raise gen

    # Frame boutons OK, Dismiss, etc ...

    frame .prf.fbt -relief flat
    pack .prf.fbt -side bottom -fill x -expand 1
    set w ".prf.fbt"
    button $w.dis -text "Dismiss" -bg red -command [list DismissDefauts .prf]
    button $w.sav -text "Save" -bg yellow -command [list SauveLesDefauts]
    button $w.ok  -text " OK " -bg green1 -command [list AccepteDefauts .prf]
    pack $w.dis $w.sav $w.ok -side left -expand 1 -padx 10 -pady 10

    #    MesCouleurs .prf
    FenetreAuCentre .prf

    grab -global .prf
    focus .prf

    tkwait window .prf

    focus $oldFocus
    if {$oldGrab ne ""} {
	if {$oldStatus eq "global"} {
	    grab -global $oldGrab
	} else {
	    grab $Grab
	}
    }

    return

}

proc AffichePreferences2 {} {

    global PrfListe LesItems OldPrf FrmPref TmpDef CoulTmp Couleurs Defauts

    if {[winfo exists .prf]} {
	raise .prf
	return
    }

    set oldGrab [grab current]
    if {$oldGrab ne ""} {set oldStatus [grab status $oldGrab]}
    set oldFocus [focus]

    array set TmpDef  [array get Defauts]
    array set CoulTmp [array get Couleurs]

    toplevel .prf
    wm title .prf "Preferences"
    wm protocol .prf WM_DELETE_WINDOW KillParLaCroix
    raise .prf

    set LesItems {General Sequences Databases Conservation Editor "3D Display" Trees}
    set Larg [PlusLongEltDe $LesItems]

    frame .prf.fnb
    pack .prf.fnb -side top -expand 0 -fill both -pady 5 -padx 5

    set w ".prf.fnb"
    set PrfListe ".prf.fnb.lst"
    listbox $w.lst  -width $Larg -height 20  -selectmode single  -borderwidth 3  -highlightthickness 0  -disabledforeground black  -bg white -fg black

    # Frame pref
    labelframe $w.frm  -relief groove  -font "Helvetica 14 bold"
    
    set FrmPref "$w.frm"
    
    # Frame Boutons OK dismiss default
    frame $w.btn
    button $w.btn.cancel  -text "Cancel"  -background red  -command [list DismissDefauts $w]
    button $w.btn.defaut  -text "Default"  -background yellow  -command [list RemetDefauts $PrfListe]
    button $w.btn.cebon  -text " OK "  -background green1  -command [list AccepteEtSauveDefauts $w]
    
    grid $w.btn.cancel -row 0 -column 0
    grid $w.btn.defaut -row 0 -column 1
    grid $w.btn.cebon  -row 0 -column 2
    grid columnconfig $w.btn {0 1 2} -weight 1
    grid rowconfig    $w.btn 0       -weight 0

    grid $w.lst -row 0 -column 0 -rowspan 2 -sticky ns -padx 5 -pady 5
    grid $w.frm -row 0 -column 1 -sticky news -pady {5 1} -padx 5 -ipady 5
    grid $w.btn -row 1 -column 1 -sticky wes -padx 10 -pady 10
    grid columnconfig $w 0 -weight 0
    grid columnconfig $w 1 -weight 0
    grid rowconfig    $w 0 -weight 0
    grid rowconfig    $w 1 -weight 0

    $w.lst insert 0 {*}$LesItems
    $w.lst selection set 0

    update
    set h1 [winfo height $w.lst]
    set h2 [winfo height $w.btn]
    $w.frm configure -height [expr {$h1-$h2}]

    set OldPrf "General"
    EnvoiePrfGeneral

    wm protocol .prf WM_DELETE_WINDOW AdieuOrdali
    MesCouleurs .prf
    FenetreAuCentre .prf

    bind $w.lst <1> {}
    #bind $w.lst <Double-1> "DefinitPrfItem %W \[selection get\]"
    bind $w.lst <<ListboxSelect>> "DefinitPrfItem %W \[selection get\]"

    return

}

proc AfficheProfileResults {} {

    global WProfile

    package require Tk
    
    set w .prfrst
    catch {destroy $w}
    toplevel $w

    set WProfile "$w.f.text"
    set wp "$w.f"
    frame $wp
    scrollbar $wp.scroll  -width 8  -command "$wp.text yview "
    text $wp.text -height 25 -width 80 -yscrollcommand "$wp.scroll set" -font "courier 14 bold" -bg black -fg white
    pack $wp.text   -fill both -side left -expand 1
    pack $wp.scroll -side left -fill y
    pack $wp -side top
    set wb "$w.b"
    frame $wb -bg black
    button $wb.calls -text "Nb Calls" -bg cyan -command {SortBy calls}
    button $wb.avgrn -text "avgRunTime" -bg cyan -command {SortBy avgRn}
    button $wb.total -text "totalTime" -bg cyan -command {SortBy total}
    button $wb.exclu -text "exclusiveTime" -bg cyan -command {SortBy exclu}
    button $wb.avgex -text "avgExcTime" -bg cyan -command {SortBy avgEx}
    button $wb.print -text "Save" -bg yellow -command {SauveProfile}
    button $wb.close -text " Close " -bg green1 -command {CloseProfileResults}
    pack $wb.calls $wb.avgrn $wb.total $wb.exclu $wb.avgex $wb.print $wb.close -side left -expand 1
    pack $wb -side bottom -expand 1 -fill x -pady 20

    InitDataProfile
    $wb.calls invoke

    bind $wp.text <Control-1> [list DumpFunction %W @%x,%y]

    tkwait window $w

    return

}

proc AfficheProfileSegment {Selection Maniere Fichier} {


    scan $Selection "%s" Access
    set Page [ProfileSegment "$Access,$Fichier"]
    return [AfficheVariable $Page "" "${Access}_of_$Fichier"]


}

proc AfficheRec1 {Selection {Quoi ""}} {


    JeMeSignale
    if {$Quoi==""} { set Quoi "Description" }
    if {[regexp "\n" $Selection]} {
	foreach Ligne [split $Selection "\n"] {
	    AfficheRec1 $Ligne $Quoi
	}
	return
    }
    scan $Selection "%s" R
    if {$Quoi=="Description"} { return [AfficheLesRec1 $R] }
    if {$Quoi=="Fichier"} { return [AfficheFichier [Rec1 $R $Quoi] "AvecFormate"] }
    if {$Quoi=="Ppcr"}    {
	set N [Rec1 $R "N"]
	return [ShowVirtualPPCR $N]
    }
    if {$Quoi=="Vecteur"}    {
	set V [Rec1 $R "Vecteur"]
	set Fichier "[RepertoireDuGenome]/vecteurs/pDONR/$V"
	Espionne $Fichier
	return [AfficheFichier $Fichier "AvecFormate"]
    }
    return [AfficheVariable [Rec2 $R $Quoi]]


}

proc AfficheRec2 {Selection {Quoi ""}} {


    if {$Quoi==""} { set Quoi "Description" }
    if {[regexp "\n" $Selection]} {
	foreach Ligne [split $Selection "\n"] {
	    AfficheRec2 $Ligne $Quoi
	}
	return
    }
    scan $Selection "%s" R
    if {$Quoi=="Fichier"} { return [AfficheFichier [Rec2 $R $Quoi]] }
    scan $Selection "%s" R
    if {$Quoi=="Fichier"} { return [AfficheFichier [Rec2 $R $Quoi] "AvecFormate"] }
    if {$Quoi=="Rec1"}    {
	set R1 [Rec2 $R "R1"]
	return [AfficheLesRec1 $R1]
    }
    if {$Quoi=="Vecteur"}    {
	set V [Rec2 $R "Vecteur"]
	set Fichier "[RepertoireDuGenome]/vecteurs/pDEST/$V.tfa"
	Espionne $Fichier
	return [AfficheFichier $Fichier "AvecFormate"]
    }
    return [AfficheVariable [Rec2 $R $Quoi]]


}

proc AfficheReduceMsf {NomOuFichier {MinAB ""}} {


    set MSF [ReduceMsf $NomOuFichier "GetText" $MinAB]
    return [AfficheVariable $MSF "AvecEtudeMSFGrandeLargeur" $NomOuFichier]


}

proc AfficheRegle {{w .ordali.lessequences}} {

    global WTexteRegle TexteWRegle Defauts

    if {! [ModeI]} {return}

    set WTexteRegle "$w.regle"

    $WTexteRegle configure -state normal
    $WTexteRegle configure -font SeqFont
    $WTexteRegle delete 1.0 end

    $WTexteRegle insert end [set TexteWRegle(Tirets)]
    $WTexteRegle insert end "\n"
    $WTexteRegle insert end [set TexteWRegle(Comptr)]
    $WTexteRegle tag remove sel 1.0 end

    $WTexteRegle configure -state disabled

    return

}

proc AfficheReordonneMSF {MSF {LesAccess ""} {FichierOrigine ""}} {



    if {$LesAccess=="" || $LesAccess=="Ask"} { 
	set LesAccess [ChoixParmi {"Disphy" "Secator" "Dpc" "Oumy" "ShowSecator"}]
	if {$LesAccess==""} { return "" }
    }

    if {$LesAccess=="ShowSecator"} {
	MontreSecator $MSF
    }

    set Nom [file tail $FichierOrigine]

    set Fenetre [AfficheVariable [ReordonneMSF $MSF $LesAccess $Nom] "AvecEtudeMSFGrandeLargeur" "$FichierOrigine"]
    if {$LesAccess=="Disphy"} { return $Fenetre }
    set LesAGs [MontreSecator $MSF]
    IllumineSuivantLesGroupes $LesAGs $Fenetre
    MemoSelection $Fenetre Memorize
    return $Fenetre


}

proc AfficheRequeteSurLaMeilleureLocalisation {K Fichier {Qui OnlyTheBest} {LesNoms ""}} {


    global RepertoireDuGenome

    set Id      [$K find withtag current]
    set MesTags [$K gettags $Id         ]
    set Requete [lindex $MesTags 0      ]

    set LesResultats [RequeteSurLaMeilleureLocalisation $Requete $Fichier $Qui $LesNoms]
    if {$LesResultats != {}} {
	set Texte [join $LesResultats "\n"]
    } else {
	set Texte "Nothing"
    }

    AfficheVariable "$Texte" "" "Results"

    return "$Texte"


}

proc AfficheRognure {Page Selection Maniere NomDuFichierOrigine {InOut In}} {



    if {$InOut=="Alone"} {
	if {$Maniere=="Retour"} { return $Selection }
	return [AfficheVariable $Selection $Maniere $NomDuFichierOrigine]
    }

    set LesAccess {}
    foreach Ligne [split $Selection "\n"] {
	regsub "Name:" $Ligne "" Ligne
	set Access ""
	scan $Ligne "%s" Access
	if {$Access==""} { continue }
	lappend LesAccess $Access
    }
    set NouvellePage [MSFSelection $Page $LesAccess $InOut]

    if {$Maniere=="Retour"} { return $NouvellePage }
    return [AfficheVariable $NouvellePage $Maniere "$NomDuFichierOrigine"]


}

proc AfficheSequencesCorrelees {Fichier {Groupe ""}} {


    global RepertoireDuGenome
    
    JeMeSignale

    set Nom [file tail $Fichier]
    set Fichier "$RepertoireDuGenome/correlator/$Nom"
    if { ! [file exists $Fichier]} { return "" }
    set VasY 0
    set DejaVu 0
    set LesBons {}
    foreach Ligne [LesLignesDuFichier $Fichier] {
	if { ! [regexp -nocase {[a-z]} $Ligne]} { continue }
	if {$Groupe!=""} {
	    if {[regexp "groupe :" $Ligne]} {
		scan $Ligne "%s %s %d" Bidon DP GroupeLu
		if {$GroupeLu == $Groupe} {
		    set VasY 1
		    set DejaVu 1
		    continue
		} else {
		    if {$DejaVu} { break }
		}
	    }
	    if { ! $VasY } { continue }
	}
	regsub "^>" $Ligne "" Ligne
	lappend LesBons $Ligne
    }
    return [AfficheVariable [join $LesBons "\n"] ""]


}

proc AfficheSlidingCodonRare {Page {WindowSize ""}} {


    set SCR [SlidingCodonRare $Page]
    return [AfficheVariable [join $SCR "\n"] "AvecRienGrandeLargeur" "SlidingCodonRare"] 


}

proc AfficheSlidingCodonRarePour {{Liste ""}} {


    if {$Liste==""} {
	set Liste [MorceauxChoisis [PresentationDesPABs]]
    }
    if {$Liste=={}} { return "" }

    set WindowSize [ChoisisWindowSizePourSlidingCodonRare]

    foreach Ligne $Liste {
	scan $Ligne "%s" Nom
	set FichierTFA "[RepertoireDuGenome]/nuctfa/$Nom"
	if { ! [file exists $FichierTFA]} { continue }
	set SCR [SlidingCodonRare $FichierTFA $WindowSize]
	lappend LesSCRs $Ligne
	lappend LesSCRs [join $SCR "\n"]
	lappend LesSCRs ""
    }
    
    return [AfficheVariable [join $LesSCRs "\n"] "AvecRienGrandeLargeur" "SlidingCodonRare"] 


}

proc AfficheSnapshotAnnotations {} {

    global NomTextSeq Anano WOrdali
    
    if {[TypeAli] eq "pasdali"} {
	return
    }
    if {! [info exists Anno(Lanno)]} {
	return
    }
    
    $NomTextSeq configure -state normal
    set bt $WOrdali(BoutAnno)
    if {! [EtatBouton $bt]} {
	set Anno(Ltags) [list]
	foreach ann $Anno(Lanno) {
	    lassign $ann ian pka txt col zone
	    set txt "$ian - $txt"
	    set txtnsp [string map {_ @ " " "_"} $txt]
	    set tag "FDisp_$txtnsp"
	    $NomTextSeq tag configure $tag -background [CouleurO2Ordali $col] -foreground black
	    $NomTextSeq tag add $tag {*}$zone
	    lappend Anno(Ltags) "FDisp_$txtnsp"
	}

	$bt configure -relief sunken -background red -foreground white
    } else {
	foreach tag $Anno(Ltags) {
	    $NomTextSeq tag remove $tag 1.0 end
	}
	$bt configure -relief raised -background cyan -foreground black
    }

    update idletasks
    $NomTextSeq configure -state disabled

    return

}

proc AfficheSortedDistances {NomOuFichier} {


    set LesDistances [PairwizeDistancesInMsf "SortedDistances" $NomOuFichier]
    return [Graphe $LesDistances]


}

proc AfficheSpineDefinitions {} {


    set Page [SpineSummary "RetourneTexte"]
    foreach Ligne [split $Page "\n"] {
	if { ! [regexp -nocase {[a-z]} $Ligne]} { continue }
	ScanLaLigneSpine $Ligne X Al Ac SpOk SpTsk Owner Or
	set DE [SpineDefinition $X]
	set BelleDE [format "%-50s" $DE]
#	regsub "$Or" $Ligne "$BelleDE $Or" Texte
	set Texte "$Ligne $BelleDE"
	lappend LeTout $Texte
    }
    return [AfficheVariable [join $LeTout "\n"] "" coucou]


}

proc AfficheTaxoFromTaxoLine {Ligne {Titre ""}} {


    set LeMessage {}
    foreach Li [split $Ligne "\n"] {
	set TaxId [lindex [LesMotsDeLaLigne $Li] 2]
	set Message "[format %-7s $TaxId] [TaxClass $TaxId Name]"
	lappend LeMessage $Message
    }
    return [AfficheListe $LeMessage "" $Titre]


}

proc AfficheTexte {Texte {Titre ""} {X ""} {Y ""}} {


    
    set w [NomDe fenetre]
    toplevel $w
    if {$Titre==""} { set Titre [string range $Texte 0 19] }
    wm title $w $Titre
    wm iconname $w $Titre

    set LesLignesDuTexte [split $Texte "\n"]
    set PremiereLigne [lindex $LesLignesDuTexte 0]

    set Hauteur [Mini 12 [Maxi 30 [llength $LesLignesDuTexte]]]
    set Largeur 80
    foreach Ligne $LesLignesDuTexte {
	set Largeur [Maxi $Largeur [string length $Ligne]]
    }
    set Largeur [Mini $Largeur 180]

    text  $w.text -wrap none -relief sunken -bd 2  -xscrollcommand "$w.scrollx set" -setgrid 1  -yscrollcommand "$w.scrolly set" -setgrid 1  -width $Largeur -height $Hauteur
          $w.text insert 0.0 $Texte
    $w.text configure -state "disable"
    focus $w.text
    
    frame  $w.buttons
    pack   $w.buttons -side bottom -fill x -pady 2m

    button $w.buttons.dismiss -background red -text "Dismiss" -command "destroy $w"
      pack $w.buttons.dismiss -side left -expand 1
    button $w.buttons.saveas -text "Save All/Sel."
      bind $w.buttons.saveas <1> "SaveAs \[$w.text get 1.0 end\]"
      bind $w.buttons.saveas <2> "SaveAs \[$w.text get sel.first sel.last\]"
      pack $w.buttons.saveas -side left -expand 1
    button $w.buttons.medline -text "Medline"
      bind $w.buttons.medline <1> "AfficheMedline \[$w.text get 1.0 end\]"
      pack $w.buttons.medline -side left -expand 1
    
    scrollbar $w.scrollx -command "$w.text xview" -orient "horizontal"
         pack $w.scrollx -side bottom -fill x
    scrollbar $w.scrolly -command "$w.text yview"
         pack $w.scrolly -side right -fill y

    pack $w.text -expand yes -fill both
    if {$X!=""} {
	$w.text xview scroll $X units
    }
    if {$Y!=""} {
	$w.text yview scroll $Y units
    }
    return $w


}

proc AfficheTousLesMedlinesDeLaSequence {Sequence} {


    Wup "Calls Jean-Marie Wurtz's program to fetch medline's http file."
    
    Gs "Frame"
    
    set LesLignes [split $Sequence "\n"]
    if {[llength $LesLignes] < 1} {
        FaireLire "$Sequence\nis n't a sequence."
        return ""
    }
    set iAccess [lsearch -regexp $LesLignes {^AC}]
    if {$iAccess<0} {
        FaireLire "Sorry I can't find the Access of the sequence"
        return ""
    }
    scan [lindex $LesLignes $iAccess] "%s %s" AC Access
    regsub ";" $Access "" Access
    return [AfficheVariable [exec meddata $Access] "AvecRien"]


}

proc AfficheToutesLesDefinitions {} {


#rR je sais pas si ca marche ....???????????????
    set Sortie {} 
    foreach Operon [lrange [LesOperons] 0 10] {
        set Premier [lindex $Operon 0]
        set LesDefs [Operon $Premier "Definitions"]
        lappend Sortie ""
        lappend Sortie  $Operon
        foreach Def $LesDefs {
            lappend Sortie "    $Def"
        }
    }
    return [AfficheVariable [join $Sortie "\n"] "" ""]


}

proc AfficheUnArbre {AId} {

    global Abr Defauts WOrdali

    set w ".arbre$AId"
    if {[winfo exists $w]} {
	destroy $w
    }

    toplevel $w
    wm title $w "Tree No $AId"
    wm iconname $w "Tree $AId"
    wm protocol $w WM_DELETE_WINDOW KillParLaCroix
    if {[winfo exists .fattendre]} {
	lower $w .fattendre
    }

    frame $w.fc
    frame $w.fb
    # packing des deux frames principales
    grid $w.fc -row 0 -column 0 -sticky news
    grid $w.fb -row 1 -column 0 -sticky news
    grid rowconfig    $w 0 -weight 1
    grid columnconfig $w 0 -weight 1

    # Frame canvas + ascenceurs
    set wc "$w.fc.c"
    set Abr($AId,PAD) $wc
    set Abr($AId,ContextMenu) $w.fc.c.menu
    canvas $w.fc.c  -height [set Abr($AId,FHeight)]  -width  [set Abr($AId,FWidth)]  -scrollregion [list 0 0 [set Abr($AId,PADWdt)] [set Abr($AId,PADHgt)]]  -cursor hand2  -background white  -relief groove  -xscrollcommand "$w.fc.hs set"  -yscrollcommand "$w.fc.vs set"
    
    scrollbar $w.fc.vs -command "$wc yview" -width 8
    scrollbar $w.fc.hs -orient horiz -command "$wc xview" -width 8
    
    grid $w.fc.c  -row 0 -column 0 -sticky news
    grid $w.fc.vs -row 0 -column 1 -sticky ns
    grid $w.fc.hs -row 1 -column 0 -sticky ew
    grid rowconfig    $w.fc 0 -weight 1
    grid columnconfig $w.fc 0 -weight 1
    grid columnconfig $w.fc 1 -weight 0
    
    # Frame des fonctions 
    frame $w.fb.fsrp -relief groove -borderwidth 2
    set WOrdali(Tree,DenRad) $w.fb.fsrp.esra
    checkbutton $w.fb.fsrp.esra  -text "Dendro/Radial"  -anchor w -justify left  -onvalue dendrogram  -offvalue radial  -variable Abr($AId,TypeTree)  -command [list OnReDessineArbre $AId]
    checkbutton $w.fb.fsrp.swap  -text "swap nodes"  -anchor w -justify left  -variable Abr($AId,Swap)  -relief flat  -onvalue 1  -offvalue 0  -command [list ModeSwap $AId]
    set Abr($AId,BReroot) "$w.fb.fsrp.reroot"
    checkbutton $w.fb.fsrp.reroot  -text "re-root tree"  -anchor w -justify left  -disabledforeground dimgrey  -variable Abr($AId,Reroot)  -relief flat  -onvalue 1  -offvalue 0  -command [list ModeReroot $AId]
    set Abr($AId,BCollapse) $w.fb.fsrp.col
    checkbutton $w.fb.fsrp.col  -text "collapse tree"  -anchor w -justify left  -variable Abr($AId,CollapseTree)  -onvalue 1  -offvalue 0  -command [list CollapseTree $AId]
    
    
    grid $w.fb.fsrp.esra   -row 0 -column 0 -sticky we
    grid $w.fb.fsrp.swap   -row 1 -column 0 -sticky we
    grid $w.fb.fsrp.reroot -row 2 -column 0 -sticky we
    grid rowconfig    $w.fb.fsrp all -weight 0
    grid columnconfig $w.fb.fsrp all -weight 1
    
    # Frame de display infos
    frame $w.fb.fa -relief groove -borderwidth 2
    checkbutton $w.fb.fa.phylum  -text "show phylum"  -anchor w -justify left  -variable Abr($AId,Phylum)  -onvalue 1  -offvalue 0  -command [list PeintParPhylum $AId]
    # show bootstrap :
    # different cases if dendro or radial
    set Abr($AId,ShowBootDen) $w.fb.fa.boots
    checkbutton $w.fb.fa.boots  -text "show bootstrap"  -anchor w -justify left  -variable Abr($AId,BootShow)  -onvalue 1  -offvalue 0  -command [list MontreBootstrap $AId]
    set Abr($AId,ShowBootRad) $w.fb.fa.fboo
    frame $w.fb.fa.fboo
    set Abr($AId,ThresBootPC) [set Defauts(ThresBootPC)]
    set Abr($AId,ThresBoot) [expr {1.0*$Abr($AId,ThresBootPC)*[set Defauts(TreeNBoot)]/100.}]
    checkbutton $w.fb.fa.fboo.b1  -text "show boot"  -anchor w -justify left  -variable Abr($AId,BootShow)  -onvalue 1  -offvalue 0  -command [list MontreBootstrap $AId]
    set Abr($AId,ThrBootEnt) $w.fb.fa.fboo.e1 
    entry $w.fb.fa.fboo.e1  -background white  -textvariable Abr($AId,ThresBootPC)  -justify right  -width 3  -validate none
    grid $w.fb.fa.fboo.b1 -row 0 -column 0
    grid $w.fb.fa.fboo.e1 -row 0 -column 1
    grid rowconfig    $w.fb.fa.fboo 0   -weight 0
    grid columnconfig $w.fb.fa.fboo all -weight 0
    
    checkbutton $w.fb.fa.shclus  -text "show clusters"  -anchor w -justify left  -variable Abr($AId,ShClusters)  -onvalue 1  -offvalue 0  -command [list PeintParClusters $AId]
    
    grid $w.fb.fa.phylum -row 0 -column 0 -sticky we
    grid $w.fb.fa.fboo   -row 1 -column 0 -sticky we
    #grid $w.fb.fa.boots  -row 1 -column 0 -sticky we
    grid $w.fb.fa.shclus -row 2 -column 0 -sticky we
    grid rowconfig    $w.fb.fa all -weight 0
    grid columnconfig $w.fb.fa 0 -weight 1 -minsize 0
    if {[TypeAli] ne "XML" && [TypeAli] ne "ORD"} {
	$w.fb.fa.phylum configure -state disabled
    }
    bind [set Abr($AId,ThrBootEnt)] <Return> [list ChangeThresholdBoot $AId]
    if {! [set Abr($AId,BootDone)]} {
	#$w.fb.fa.boots configure -state disabled
	$w.fb.fa.fboo.b1 configure -state disabled
	bind [set Abr($AId,ThrBootEnt)] <Return> ""
    }

    # Frame de redimentionnement de l'arbre
    # Deux frames :
    #    - cartesienne pour dendrgramme (width/height)
    #    - rotation    pour radial (rot/zoom)
    #
    # Pour dendogramme
    set Abr($AId,FDimXY) "$w.fb.fd"
    frame $w.fb.ft -relief groove -borderwidth 2

    set Abr($AId,FDimRZ) "$w.fb.fr"
    frame $w.fb.ft.f1
    checkbutton $w.fb.ft.f1.tnode  -text "Tag node"  -variable Abr($AId,DoTagNode)  -onvalue 1  -offvalue 0  -command [list ModeTagNode $AId]
    
    frame $w.fb.ft.f2
    set Wdt [PlusLongEltDe [set Abr($AId,LSeq)]]
    set Abr($AId,DoTagleaf) 0
    set Abr($AId,LeafSelOld) [lindex $Abr($AId,LSeq) 0]
    checkbutton $w.fb.ft.f2.ctag  -text "Tag"  -variable Abr($AId,DoTagLeaf)  -onvalue 1  -offvalue 0
    set Abr($AId,CbLTag) $w.fb.ft.f2.stag
    ttk::combobox $w.fb.ft.f2.stag  -background white  -width $Wdt  -height 15  -textvariable Abr($AId,LeafSel)  -state readonly  -values $Abr($AId,LSeq)
    $w.fb.ft.f2.stag index 0
    bind $w.fb.ft.f2.stag <<ComboboxSelected>> [list ModeTagLeaf $AId]
    frame $w.fb.ft.f3
    set Abr($AId,AddLeg)   0
    set Abr($AId,LegText)   ""
    set Abr($AId,LegBoot)  1
    set Abr($AId,LegCoul)  0
    set Abr($AId,LegGap)   1
    set Abr($AId,LegSites) 1
    set Abr($AId,Legend)   ""
    set Abr($AId,LegWText)  ""
    checkbutton $w.fb.ft.f3.ckleg  -text "Caption"  -anchor w -justify left  -onvalue 1 -offvalue 0  -variable Abr($AId,AddLeg)  -command [list DefineLegend $AId define]
    button $w.fb.ft.f3.clr  -text "Clear"  -bg white  -command [list DefineLegend $AId clear]
    
    grid columnconfig $w.fb.ft.f1 all -weight 1
    grid rowconfig    $w.fb.ft.f1 all -weight 1
    grid $w.fb.ft.f1.tnode -row 0 -column 0 -sticky ew
    
    grid $w.fb.ft.f2.ctag -row 0 -column 0 -sticky ew
    grid $w.fb.ft.f2.stag -row 0 -column 1 -sticky ew
    grid columnconfig $w.fb.ft.f2 all -weight 1
    grid rowconfig    $w.fb.ft.f2 all -weight 1
    
    grid $w.fb.ft.f3.ckleg -row 0 -column 0 -sticky ew
    grid $w.fb.ft.f3.clr   -row 0 -column 1 -sticky ew
    grid columnconfig $w.fb.ft.f3 all -weight 1
    grid rowconfig    $w.fb.ft.f3 all -weight 1
    
    #grid $w.fb.ft.f1 -row 0 -column 0 -sticky ew
    grid $w.fb.ft.f2 -row 1 -column 0 -sticky ew
    grid $w.fb.ft.f3 -row 2 -column 0 -sticky ew
    grid rowconfig    $w.fb.ft all -weight 0
    grid columnconfig $w.fb.ft all -weight 0
    
    #
    # gestion labels : on ecrit quoi
    frame $w.fb.ff -relief groove -borderwidth 2
    label $w.fb.ff.name  -text "Label"  -anchor w -justify left
    set cbw [PlusLongEltDe [set Abr(TypeAff)]]
    ttk::combobox $w.fb.ff.chnm  -background white  -height 0 -width $cbw  -textvariable Abr($AId,TAff)  -state readonly  -values $Abr(TypeAff)
    bind $w.fb.ff.chnm <<ComboboxSelected>> [list ChangeLabelTree $AId]
    
    # gestion fonte
    label $w.fb.ff.ftsize  -text "font size"  -anchor w -justify left
    spinbox $w.fb.ff.fsz  -readonlybackground white  -width 6  -state readonly  -values {6 8 10 12 14 16 18 20 22 24}  -command [list FonteMode $AId size %s]
    label $w.fb.ff.ftwght  -text "font weight"  -anchor w -justify left
    spinbox $w.fb.ff.fwh  -readonlybackground white  -width 6  -state readonly  -values [list normal bold]  -command [list FonteMode $AId weight %s]
    grid $w.fb.ff.ftsize -row 0 -column 0 -sticky w
    grid $w.fb.ff.fsz    -row 0 -column 1 -sticky ew
    grid $w.fb.ff.ftwght -row 1 -column 0 -sticky w
    grid $w.fb.ff.fwh    -row 1 -column 1 -sticky ew
    if {[TypeAli] eq "XML" || [TypeAli] eq "ORD"} {
	grid $w.fb.ff.name -row 2 -column 0 -sticky w
	grid $w.fb.ff.chnm -row 2 -column 1
    }
    grid rowconfig    $w.fb.ff all -weight 0
    grid columnconfig $w.fb.ff all -weight 0
    
    # Print, save, close, reset
    frame $w.fb.fprc
    button $w.fb.fprc.print  -text "Print"  -background yellow  -command [list PrintCanvas $wc png]
    button $w.fb.fprc.save  -text "Save"  -background cyan  -command [list SaveTree $AId]
    button $w.fb.fprc.reset  -text "Reset"  -background white  -command [list ResetArbre $AId $wc]
    button $w.fb.fprc.close  -text "Close"  -background red  -command "DetruitArbre $AId"
    
    grid $w.fb.fprc.print -row 0 -column 0
    grid $w.fb.fprc.save  -row 1 -column 0
    grid $w.fb.fprc.reset -row 0 -column 1 -pady {1 5}
    grid $w.fb.fprc.close -row 1 -column 1 -pady {1 5}
    grid rowconfig    $w.fb.fprc all -weight 0
    grid columnconfig $w.fb.fprc all -weight 0
    
    #
    # Packing
    #
    grid $w.fb.fsrp -row 0 -column 0 -padx 5 -sticky news
    grid $w.fb.fa   -row 0 -column 1 -padx 5 -sticky news
    grid $w.fb.ft   -row 0 -column 2 -padx 5 -sticky news
    grid $w.fb.ff   -row 0 -column 3 -padx 5 -sticky news
    grid $w.fb.fprc -row 0 -column 4 -padx 5 -sticky ne -pady {1 5}
    grid columnconfig $w.fb 4   -weight 1
    grid rowconfig    $w.fb all -weight 1
    
    
    $w.fb.ff.fsz set [set Abr($AId,FontSize)]
    $w.fb.ff.fwh set [set Abr($AId,FontWght)]
    
    # bindings, trace , etc ...
    InitContextMenu
    CreateContextMenu $AId [set Abr($AId,ContextMenu)]
    bind $wc <Button-3> [list ShowContextMenu $AId [set Abr($AId,ContextMenu)]]
    
    bind $wc <ButtonPress-1> {%W scan mark %x %y}
    bind $wc <B1-Motion> {%W scan dragto %x %y 1}
    
    bind $wc <4> {eval %W yview scroll -1 units}
    bind $wc <5> {eval %W yview scroll  1 units}
    bind $wc <Control-4> {eval %W xview scroll -1 units}
    bind $wc <Control-5> {eval %W xview scroll  1 units}

    trace add variable Abr($AId,TypeTree) write ChangeConfigFenetre
    trace add variable Abr($AId,DoTagNode) write ModeTagNode
    trace add variable Abr($AId,DoTagLeaf) write ModeTagLeaf

    DefineLegend $AId clear
    ChangeCurseur $AId normal
    MesCouleurs $w
    FenetreAuCentre $w

    OnReDessineArbre $AId

    return

}

proc AfficheUneSequence {{NomDuFichier ""} {AvecManiere ""}} {


    global RepertoireDuGenome
    Gs "Frame"
    
    if { $NomDuFichier == ""} {
	set NomDuFichier [ButineArborescence "All"]
	if { $NomDuFichier == "" } { return }
    }
    return [AfficheFichier $NomDuFichier "AvecFormate$AvecManiere"]


}

proc AfficheUneSortieBlast {{NomDuFichier ""} {AvecManiere ""}} {


    global RepertoireDuGenome
    Gs "Frame"
    
    if { $NomDuFichier == ""} {
	set NomDuFichier [ButineArborescence "All"]
	if { $NomDuFichier == "" } { return }
    }

    if { ! [regexp "/" $NomDuFichier] && [EstUnPAB $NomDuFichier]} {
	set Nom $NomDuFichier
	set NomDuFichier "[RepertoireDuGenome]/blastp/$Nom"
    }

    return [AfficheFichier $NomDuFichier "AvecGrapheAvecSegAlignementAvecAligneurs$AvecManiere"]


}

proc AfficheUsageDesCodons {{Nom ""}} {


    if {$Nom==""} { set Nom [Entre [PreFixe]] }

    set UC [UsageDesCodons $Nom]
    set YaEuEntete 0
    set YaEuPourCent 0
    set LesA {}
    set LesCodons {}
    foreach Ligne [split $UC "\n"] {
	regsub -all {[ \t]+} $Ligne " " Ligne
	set Ligne [string trim $Ligne]
	if {$Ligne==""} { continue }
	set LesMots [LesMotsDuTexte $Ligne]
	if {[regexp -nocase {[A-Z]} $Ligne]} {
	    set LesADeLaLigne {}
	    set LesCodonsDeLaLigne {}
	    foreach {A Codon} $LesMots {
		lappend LesA $A
		lappend LesCodons $Codon
		lappend LesADeLaLigne $A
		lappend LesCodonsDeLaLigne $Codon
	    }
	    set YaEuEntete 1
	    continue
	}
	if {$YaEuEntete} {
	    set YaEuEntete 0
	    foreach A $LesADeLaLigne Codon $LesCodonsDeLaLigne P $LesMots {
		set Gde($A)     $P
		set Gde($Codon) $P
		lappend LesG  $P
		lappend LesADeG($P) $A
		lappend LesCodonDdeG($P) $Codon
	    }
	    set YaEuPourCent 1
	    continue
	}
	if {$YaEuPourCent} {
	    set YaEuPourCent 0
	    foreach A $LesADeLaLigne Codon $LesCodonsDeLaLigne P $LesMots {
		set Lde($A)     $P
		set Lde($Codon) $P
		lappend LesL  $P
		lappend LesADeL($P) $A
		lappend LesCodonDdeL($P) $Codon
	    }
	    continue
	}
    }
    set LesG [lsort -integer -unique -decreasing $LesG]
    set LesL [lsort -integer -unique -decreasing $LesL]

    foreach Codon [list AAC AAT ACC ATC ATT CAG CTC CTG GAA GAC GAG GAT GCC GGC GGT GTA GTC GTT TAC TTC] {
	set X($Codon) 1
    }

    set CodonsG ""
    set PourCentG ""
    foreach G $LesG {
	foreach Codon $LesCodonDdeG($G) {
	    if {[info exists X($Codon)]} {
		append CircuG   [format " %s %s" [AAduCodon $Codon] $Codon]
	    } else {
		append CircuG   [format " %s %s" " " "   "]
	    }
	    set PourCent $G
	    append CodonsG   [format " %s %s" [AAduCodon $Codon] $Codon]
	    append PourCentG [format " %5d" $PourCent]
	}
    }

    set Codons ""
    set PourCent ""
    foreach L $LesL {
	foreach Codon $LesCodonDdeL($L) {
	    if {[info exists X($Codon)]} {
		append CircuL   [format " %s %s" [AAduCodon $Codon] $Codon]
	    } else {
		append CircuL   [format " %s %s" " " "   "]
	    }
	    set PourCent $L
	    append CodonsL   [format " %s %s" [AAduCodon $Codon] $Codon]
	    append PourCentL [format " %5d" $PourCent]
	}
    }

    
    set Message $UC
    append Message "\n"
    append Message "\n"
    append Message $CircuG
    append Message "\n"
    append Message $CodonsG
    append Message "\n"
    append Message $PourCentG
    append Message "\n"
    append Message "\n"
    append Message $CircuL
    append Message "\n"
    append Message $CodonsL
    append Message "\n"
    append Message $PourCentL

    set Circu ""
    append Message "\n"
    append Message $Circu

    return [Affiche $Message "" "CodonUsageOf_$Nom"]


}

proc AfficheVariable {Page {Maniere ""} {NomDuFichierOrigine ""}} {


    Wup "Cette proc est le coeur de Gscope"
    Wup "Most used procedure ... : "
    Wup "Shows the text Page in a listbox, with a lot of buttons."
    Wup "Copyright 1999 Raymond Ripp"
    
    Gs "Frame"
    
    if {$Page==""} { return "" }
    
    global VariableDeRetour
    global LesFenetresDePAB
    global PagePropre
    global CurrentGenome
    
    
    regsub -all {[;\[\]]} $NomDuFichierOrigine " " NomDuFichierOrigine ; #rR pour éviter les mauvaises surprises car il rique d'être interprété
	
	
    set Nom ""
    set Queue [file tail $NomDuFichierOrigine]
    
    set w [NomDe fenetre]
    
    set PagePropre($w) $Page
    regsub -all {\t} $PagePropre($w) "       " PagePropre($w)
    if {[info procs EstPABouTROUouTRNAouARN]!=""} {
	set NomPossible [file tail $NomDuFichierOrigine]
	if {$Nom==""} {
	    set NomPossible [file tail $NomDuFichierOrigine]
	    if { [EstPABouTROUouTRNAouARN $NomPossible] } { set Nom $NomPossible }
	}
	if {$Nom==""} {
	    set NomPossible [lindex [split $NomDuFichierOrigine "_"] 0]
	    if { [EstPABouTROUouTRNAouARN $NomPossible] } { set Nom $NomPossible }
	}
	if {$Nom==""} {
	    set NomPossible [lindex [split $NomDuFichierOrigine "_"] end]
	    if { [EstPABouTROUouTRNAouARN $NomPossible] } { set Nom $NomPossible }
	}
    }
    
    #    if {[PourWscope]} { return [Html_DuTexteTelQuel [set PagePropre($w)]] } 
    
    lappend LesFenetresDePAB($Queue) $w
    
    regsub -all " " $NomDuFichierOrigine "_" NomDuFichierOrigine
    
    if { $NomDuFichierOrigine == "" } {
	set NomDuFichierOrigine "Tsointsoin"
    }
    if {$Maniere=="AutoManiere" || $Maniere==""} {
	set Maniere [LaManierePourAffiche $NomDuFichierOrigine]
    }
    if {$Nom!="" && [info procs NomDeScene]!="" && [NomDeScene $Nom]!=""} {
	set Titre "[NomDeScene $Nom]   $NomDuFichierOrigine"
    } else {
	set Titre "$NomDuFichierOrigine"
    }
    set Header ""
    #    if { ! [OnTraite "RetGene"]&& [PourWscope]} { return [Html_TextToListbox  [set PagePropre($w)] $Titre $Header "" "ResetAndWaqqqitForButtons"] } 
    
    set Clavier $w.buttons
    if { ! [PourWscope]} {
	toplevel $w
	wm title $w "$Titre"
	wm iconname $w "$Titre"
	
	label $w.msg -wraplength 4i -justify left -text "$Titre"
	pack  $w.msg -side top
	
	frame  $Clavier
	pack   $Clavier -side bottom -fill x -padx 3m -pady 1m
    }
    
    set ForValidateOnly 0
    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "red"
    if { [regexp "AvecRetour" $Maniere] } {
	if {[regexp "AvecRetourPourInforme" $Maniere]} {
	    TouchePour $Clavier "Validate" "InformeSansDemanderParWscope $Nom \[selection get\]" "" "green"
	} else {
	    TouchePour $Clavier "Validate sel." "set VariableDeRetour($w) \[selection get\]"      "" "green"
	    TouchePour <2>      " /All"         "set VariableDeRetour($w) \[set PagePropre($w)\]" ""
	    TouchePour <3>      " / No!"        "set VariableDeRetour($w) {}"
	}
	if {[PourWscope]} { set ForValidateOnly 1 }
	TouchePour $Clavier NouvelleCouleur "pink"
    }
    TouchePour $Clavier "Dismiss"     "Dismiss $w" 
    TouchePour $Clavier "Dismiss_all" "DismissToutCePAB $Queue" "NoWeb"
    
    TouchePour $Clavier NouvelleCouleur "grey"
    TouchePour $Clavier "Display sel." "SendToWeb \[selection get\]"      "WebOnly"
    TouchePour <2>      "/Select all"   "onclick='return selectAll();'"   "WebOnly"
    TouchePour $Clavier "Save all"   "SaveAs      \[set PagePropre($w)\]" "NoWeb"
    TouchePour <2>      "/sel."      "SaveAs      \[selection get\]"      "NoWeb"
    TouchePour <3>      " /Edit"     "EditAndShow \[set PagePropre($w)\]" "NoWeb"
    TouchePour $Clavier "Memorize sel." "MemoSelection $w Memorize"       "NoWeb" "lightyellow"
    TouchePour <2>      "/Recall"       "MemoSelection $w Recall"         "NoWeb"
    TouchePour $Clavier NouvelleCouleur "grey"
    TouchePour $Clavier "Print"         "ImprimeLeTexte \[set PagePropre($w)\]"
    TouchePour <2>      "/Sort"         "TrieEtAffiche \[set PagePropre($w)\] Alpha $Maniere $NomDuFichierOrigine"
    TouchePour <3>      "/ask"          "TrieEtAffiche \[set PagePropre($w)\] Ask   $Maniere $NomDuFichierOrigine"
    TouchePour $Clavier "Copy"          "clipboard clear ; clipboard append \[selection get\]" "NoWeb"
    TouchePour <2>      "/Append"       "clipboard append \[selection get\]"                   "NoWeb"
    TouchePour <3>      " /Font"        "PolicePourListBox Ask $w"                             "NoWeb"
    TouchePour $Clavier "Exec"          "ExecuteUnBoutonDe $w"                                 "NoWeb"
    TouchePour <2>      "/Small"        "RapetisseLesBoutonsDe $w"                             "NoWeb"
    TouchePour <3>      "/Kill"         "DetruitUnBoutonDe $w"                                 "NoWeb"

    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "grey"
    
    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "yellow"
    TouchePour $Clavier "Next"  "Focalise $w"     "NoWeb"
    TouchePour <2>      "/Top"  "Focalise $w top" "NoWeb" 
    TouchePour <3>      "/New"  "Focalise $w ask" "NoWeb"
    TouchePour $Clavier "Highlight [PreFixe]" "Illumine $Nom $w"                        "NoWeb"
    TouchePour <2>      "/Query"              "Illumine QUERY $w"                       "NoWeb"
    TouchePour $Clavier "High word"           "Illumine \[Entre\] $w"                   "NoWeb"
    TouchePour <2>      "/group"              "IllumineLeGroupeDe $Nom $w"              "NoWeb"
    TouchePour <3>      "/?"                  "IllumineLeGroupeDe $Nom $w Ask $Maniere" "NoWeb"
    TouchePour $Clavier "Sel. In"   "AfficheRognure \[set PagePropre($w)\] \[selection get\] $Maniere $NomDuFichierOrigine In"  
    TouchePour <2>      "/Out"      "AfficheRognure \[set PagePropre($w)\] \[selection get\] $Maniere $NomDuFichierOrigine Out"  
    TouchePour <3>      "/Alone"    "AfficheRognure \[set PagePropre($w)\] \[selection get\] $Maniere $NomDuFichierOrigine Alone"  
    
    if { $Nom!="" } {
	TouchePour $Clavier "Informe $Nom" "Informe $Nom"
	TouchePour $Clavier "Narcisse"   "FaireLire \[Narcisse $Nom\]"
	TouchePour <2>      "/fetch it"  "AfficheFetch \[Narcisse $Nom\]"
	TouchePour $Clavier "Ghost it "  "Fantomise $Nom ParDecret"
	TouchePour <2>      "/ask"       "Fantomise $Nom Ask"
	TouchePour $Clavier "Met it "    "MetIt $Nom ParDecret"
	TouchePour <2>      "/ask"       "MetIt $Nom Ask"
	TouchePour $Clavier "Reject it " "RejectIt $Nom ParDecret"
	TouchePour <2>      "/ask"       "RejectIt $Nom Ask"
	TouchePour <3>      "/NoRej"     "RejectIt $Nom {NoRejected ParDecret}"
    }
    TouchePour $Clavier "Search on board ..."   "SearchOnBoard \[selection get\]"
    if {$Nom==""} { set NomX x } else { set NomX $Nom } 
    TouchePour $Clavier "NewButton" "NouveauBouton $w New  $NomX $NomDuFichierOrigine" "NoWeb"
    TouchePour <2>      "/same"     "NouveauBouton $w Same $NomX $NomDuFichierOrigine" "NoWeb"
    TouchePour <3>      "/auto"     "NouveauBouton $w Auto $NomX $NomDuFichierOrigine" "NoWeb"
    
    if {$ForValidateOnly} { TouchePour $Clavier "RefuseAll" }
    
    TouchePour $Clavier NouvelleGamme
    TouchePour $Clavier NouvelleCouleur "lightgrey"
    TouchePour $Clavier "Description"       "AfficheLesDescriptifs $NomDuFichierOrigine   MemeOrdre"
    TouchePour <2>      "/all"              "AfficheLesDescriptifs $NomDuFichierOrigine   Natif"
    TouchePour <3>      "/page"             "AfficheLesDescriptifs \[set PagePropre($w)\] MemeOrdre {} {} {} $Nom"
    TouchePour $Clavier "Taxonomy"          "DessineMoiLaTaxonomy $NomDuFichierOrigine"
    TouchePour <2>      "/all"              "AfficheLesDescriptifs $NomDuFichierOrigine   Natif     {} {} {OX OC} $Nom"
    TouchePour <3>      "/page"             "AfficheLesDescriptifs \[set PagePropre($w)\] MemeOrdre {} {} {OX OC} $Nom"
    TouchePour $Clavier "FragFrom"          "FragFrom $Nom"	  
    TouchePour $Clavier "SeeDNA"            "SeeADN $NomDuFichierOrigine"
    TouchePour <2>      "/6PAB"             "VoisinADN $Nom"
    TouchePour <3>      "/6txt"             "VoisinADN \[set PagePropre($w)\]"
    TouchePour $Clavier "Compare to other"  "CompareADN \[set PagePropre($w)\]"
    TouchePour $Clavier "Frag"              "IsoleUnDomaine $Nom"	  
    TouchePour <2>      "/from page"        "IsoleUnDomaine \[set PagePropre($w)\]"	  
    TouchePour <3>      "/nuc"              "IsoleEtAfficheUnDomaineNucleique \[set PagePropre($w)\]"	  
    TouchePour $Clavier "PeptidSort"        "AffichePeptideSort $Nom \[set PagePropre($w)\]"	  
    TouchePour <2>      "/Enzym"            "AffichePeptideSort $Nom \[set PagePropre($w)\] ShowEnzymes"	  
    TouchePour $Clavier "Res Enzym"         "CheckRestrictionEnzymes for_$Nom All \[set PagePropre($w)\]"
    TouchePour <2>      "/Sign"             "CheckRestrictionEnzymes for_$Nom Signals \[set PagePropre($w)\]"
    TouchePour <3>      "/Ask"              "CheckRestrictionEnzymes for_$Nom \[Entre NdeI\] \[set PagePropre($w)\]"
    TouchePour $Clavier "Res Map $Nom"      "RestrictionMap $Nom"	  
    TouchePour <3>      "/Page"             "RestrictionMap \[set PagePropre($w)\]"	  
    TouchePour $Clavier "Codon usage"       "AfficheUsageDesCodons $Nom"
    TouchePour <2>      "/Rare"             "AfficheSlidingCodonRare \[set PagePropre($w)\]"
    TouchePour <3>      "/CPS"              "Cps \[selection get\] {} {} Show"
    TouchePour $Clavier "Hydrophobicities"  "AfficheVariable \[Hydrophobicities $NomDuFichierOrigine\] AutoManiere"
    TouchePour $Clavier "OrthoFamily"       "AfficheLesOrthologuesFamiliersDuBlastP $Nom"
    TouchePour $Clavier "Cluster X-HDA"     "AfficheLeClusterXHda $Nom"
    TouchePour <2>      "/MSF"              "AfficheMsfFamily $Nom"
    
    TouchePour $Clavier NouvelleGamme
    if { $Nom!="" && ! [regexp "SansSeeAby" $Maniere]} {
	TouchePour $Clavier NouvelleCouleur "lightgreen"
	set Nicolas "Nicolas"
	set Moumou  "Ordali"
	if {[OnTraiteUnGenome]}      { set SecondMSF "Para" }
	if {[OnTraiteUneCollection]} { set SecondMSF "MSF2" }
	if {[OnTraiteDesCDNAs]}      { set SecondMSF "Loc" ; set Moumou "allBN" ; set Nicolas "allBP"}
	if {[PreFixe]=="PEROX"}      { set SecondMSF "Loc" ; set Moumou "allBN" ; set Nicolas "allBP"}
	if {[OnTraiteBalibase]} {
	    TouchePour $Clavier "Macsim Rsf" "DessineMoiUnRSF     $Nom" "" "cyan"
	    TouchePour <2>      "/Xml"       "SeeAby MacsimXml $Nom"	    
	    TouchePour <3>      "/Html"      "HtmlFromXmlMacsim $Nom {} ShowHtml"	    
	}
	TouchePour $Clavier "Seq"          "SeeAby Seq         $NomDuFichierOrigine"
	TouchePour <2>      " /nuc"        "SeeAby Nuc         $NomDuFichierOrigine"
	TouchePour <3>      " /Show"       "SeeAby Show        $NomDuFichierOrigine"
	TouchePour $Clavier "Any"          "SeeAby MemoAny     $NomDuFichierOrigine"
	TouchePour <2>      "/choose"      "SeeAby ChooseAny   $NomDuFichierOrigine"
	TouchePour <3>      "/all"         "SeeAby AllAny      $NomDuFichierOrigine"
	TouchePour $Clavier "Blast"        "SeeAby MemoBlast   $NomDuFichierOrigine"
	TouchePour <2>      "/choose"      "SeeAby ChooseBlast $NomDuFichierOrigine"
	TouchePour <3>      "/all"         "SeeAby AllBlast    $NomDuFichierOrigine"
	TouchePour $Clavier "Msf"          "SeeAby MemoMsf     $NomDuFichierOrigine"
	TouchePour <2>      "/choose"      "SeeAby ChooseMsf   $NomDuFichierOrigine"
	TouchePour <3>      "/all"         "SeeAby AllMsf      $NomDuFichierOrigine"
	TouchePour $Clavier "ChangeDefaultDirs" "ReParDefaut"
	TouchePour $Clavier "Ordali"       "Ordali $Nom"
	if {[OnTraite "MAMA"] || [OnTraite "MAMB"]} {
	    TouchePour $Clavier "ShowXMotifs 0" "ShowXMotifs $Nom 0"	
	    TouchePour <2>      " /1"           "ShowXMotifs $Nom 1"	
	    TouchePour <3>      " /2"           "ShowXMotifs $Nom 2"	
	}
	if {[file exists "[RepertoireDuGenome]/taxobla"]} {
	    TouchePour <2>      " /Taxo"       "TaxonomyDuBlast $Nom"
	    TouchePour <3>      "/Outliers"    "OutlierOrganismInBlast $Nom"
	}	
	if {[PourWscope]} {
	    TouchePour $Clavier  "Jalview" "JalviewHtml $Nom"
	}
	if {[file exists "[RepertoireDuGenome]/blastxmultiples"]} {
	    TouchePour $Clavier "Frameshift BlastX" "AfficheLesBlastXDesHitsMultiples $Nom"
	    TouchePour <2>      "/Loc"              "FaireLire \[PossibleFrameshift $Nom\]"
	}
	if {[file exists "[RepertoireDuGenome]/fiches/Domaines"]} {
	    TouchePour $Clavier "Show Domains" "IllustreLesDomaines $Nom"
	}
	TouchePour $Clavier "Files"        "SeeAby Other       $NomDuFichierOrigine"
	TouchePour <2>      "/Other"       "SeeAby OnList      $NomDuFichierOrigine"
	TouchePour <3>      "/WithDir"     "ShowDirectories \[set PagePropre($w)\] $NomDuFichierOrigine"
	if {[OnTraiteSpine]} {
	    TouchePour $Clavier "Xml Spine"  "SeeAby SpineXml $NomDuFichierOrigine" "" "Purple"
	    TouchePour <2>      "/Macsim"    "SeeAby MacsimXml $NomDuFichierOrigine"	    
	    TouchePour <3>      "/Html"      "HtmlFromXmlMacsim $Nom {} ShowHtml"	    
	}
    }
    if { [regexp "AvecBlaste" $Maniere] || [regexp "AvecFormate" $Maniere] } {
	TouchePour $Clavier NouvelleCouleur "lightgreen"
	TouchePour $Clavier "Run BlastP"   "Blaste P  \[set PagePropre($w)\]"
	TouchePour <2>      "/tN"          "Blaste tN \[set PagePropre($w)\]"
	TouchePour <3>      "/Choose"      "Blaste Choix \[set PagePropre($w)\]"
	TouchePour $Clavier "GenScan"      "RunGenScanEtAffiche      \[set PagePropre($w)\]"
	TouchePour <2>      "/RepMasker"   "RunRepeatMaskerEtAffiche \[set PagePropre($w)\]"
	
	TouchePour $Clavier NouvelleCouleur "lightgreen"
	TouchePour $Clavier "Change format" "AfficheVariable \[FormateSequence \[set PagePropre($w)\]\] AvecFormateAvecBlasteSansFetch [file tail $NomDuFichierOrigine]"
	TouchePour <2> "/sel."              "AfficheVariable \[FormateSequence \[selection get\]\] AvecFormateAvecBlasteSansFetch part_of_[file tail $NomDuFichierOrigine]"
	TouchePour $Clavier "Medline all"   "AfficheTousLesMedlinesDeLaSequence \[set PagePropre($w)\]\]"
	TouchePour <2>      "/sel."  "AfficheMedline \[selection get\]"
    }
    if { [regexp "AvecAligneurs" $Maniere] } {
	TouchePour $Clavier "DbCl +Anchors"     "RunDbClustal \[selection get\] $NomDuFichierOrigine"
	TouchePour <2>      " / -"              "RunDbClustal \[selection get\]"
	TouchePour $Clavier "Tfas of selection" "CreeUnTFAs \[selection get\] ShowIt"
	TouchePour $Clavier "BlastBase sel"     "CreeUneBanqueBlast \[selection get\] [file tail $NomDuFichierOrigine]"
	TouchePour <2>      "/all"              "CreeUneBanqueBlastDuBlast $NomDuFichierOrigine"
	TouchePour <3>      "/+q"               "CreeUneBanqueBlastDuBlast $NomDuFichierOrigine AvecQuery"
    }
    if { [regexp "AvecShow" $Maniere] } {
	TouchePour $Clavier "Show"   "AfficheLesFichiers \[selection get\] AutoManiereAvecShow"
	TouchePour <2>      "/File"  "AfficheLesFichiers \[selection get\] AutoManiereAvecShow"
	TouchePour <3>      "/Split" "OffreLesMots       \[selection get\]"
    }
    
    if { [regexp "AvecEtudeMSF" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur  "lightblue"
	TouchePour $Clavier "Msfcolor"       "DessineMoiUnMSF \[set PagePropre($w)\] $NomDuFichierOrigine Ask" 
	TouchePour <2>      " /Xml"          "Ordali $Nom ForceXml"
	TouchePour <3>      " /RSF"          "DessineMoiUnRSF $NomDuFichierOrigine"
	TouchePour $Clavier "ClustalX"       "ClustalX \[set PagePropre($w)\] $NomDuFichierOrigine" 
	TouchePour <2>      " /NJPlot"       "NJPlotMSF \[set PagePropre($w)\] $NomDuFichierOrigine" 
	TouchePour <3>      " /ATV"          "ATV $NomDuFichierOrigine EnExec" 
	TouchePour $Clavier "NorMD"          "FaireLire \"memorized NorMD \[MDScore $NomDuFichierOrigine\]\"" 
	TouchePour <2>      "/Comput"        "FaireLire \"just computed NorMD \[MDScore \[set PagePropre($w)\] IsText\]\"" 
	TouchePour <3>      "/2Word"         "MSF2WordML $NomDuFichierOrigine" 
	TouchePour $Clavier "StartStop"      "TestCodonStartEtDeletionDuMSF $NomDuFichierOrigine"
	TouchePour <2>      " /Sort"         "AfficheReordonneMSF \[set PagePropre($w)\] Ask $NomDuFichierOrigine"
	TouchePour $Clavier "Ordali"         "Ordali $Nom [RepertoireDuGenome]/macsimXml/$Nom.xml {} {} ForceXml"
	TouchePour <2>      " /fromPage"     "OrdaliDuTexteMSF \[set PagePropre($w)\] $NomDuFichierOrigine -viewer"
	TouchePour <3>      " /sel."         "OrdaliDeLaSelection \[set PagePropre($w)\] \[selection get\] $NomDuFichierOrigine"
	TouchePour $Clavier "MSF familiar orgs" "AfficheMsfOfFamiliarOrganisms $NomDuFichierOrigine"	
	TouchePour $Clavier "MSF Reduce"        "AfficheReduceMsf              $NomDuFichierOrigine"	
	TouchePour <2>      "/Dist"             "AfficheSortedDistances        $NomDuFichierOrigine"	
	TouchePour <3>      "AliInOut"          "AfficheAliInOut $Nom"
	if {[PreFixe]=="TFIIH"} {
	    TouchePour $Clavier "Pid2a2" "Pid2a2 $Nom $NomDuFichierOrigine"
	}
    }
    if { [regexp "AvecGenoret" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "ForestGreen"
	TouchePour $Clavier "Show All Uploads" "ShowUploads"
	if {[regexp "AvecAllUploads" $Maniere]} { 
	    TouchePour $Clavier "Show sel. Upload" "ShowUpload \[selection get\]"
	}
	if {[regexp "AvecUpload" $Maniere]} { 
	    TouchePour $Clavier " SetGUs of sel."       "SetGUsWithUpload $NomDuFichierOrigine"
	}
	
	TouchePour $Clavier "ShowGUs" "ShowGUs"
	if {[regexp "AvecGUsList" $Maniere]} { 
	    TouchePour <2>      "/RemGUs"     "RemGUs \[selection get\]"
	}
    }
    if { [regexp "AvecXbgs" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "Magenta"
	TouchePour $Clavier "Spine"             "SpineSummary Show"
	TouchePour $Clavier "XML File"          "CreateSpineXML"
	TouchePour <2>      "/Show"             "CreateSpineXML Show"
	TouchePour <3>      "/sel"              "CreateSpineXML \[selection get\] Show"
	TouchePour $Clavier "Search Organisms"  "OrganismeDesXGSs"
	TouchePour $Clavier "Show SpineOnly"    "AfficheLesSpines \[set PagePropre($w)\]"
	TouchePour <2>      " /No"              "AfficheLesSpines \[set PagePropre($w)\] KO"
	TouchePour $Clavier "Change Owner"      "MemeOwner \[selection get\]"
	TouchePour <2>      "/XGS"              "XGSPourOwner \[selection get\]"
	TouchePour $Clavier "Def"               "AfficheSpineDefinitions"
	TouchePour <2>      " /Stat"            "HistoDesSpineTasks AllToGether Show"
	TouchePour <3>      " /SpOk"            "HistoDesSpineTasks SpineOnly Show"
    }
    
    if { [regexp "AvecLog" $Maniere] } {
	TouchePour $Clavier "Log" "AfficheLogDuMSF $NomDuFichierOrigine"
    }
    
    if { [regexp "AvecAide" $Maniere] } {
	TouchePour $Clavier "?" "AideEnLigne \[selection get\]" "" "blue"
    }
    
    if { [regexp "AvecSmallMSF" $Maniere] } {
	TouchePour $Clavier "Small align" "ShowDifferentielBlastAlignement \[selection get\]" "" "green"
    }
    
    if { [regexp "AvecProfileSegments" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "green"
	TouchePour $Clavier "ProfilSeg align"  "AfficheProfileSegment \[selection get\] $Maniere $NomDuFichierOrigine"
    }
    if { [regexp "AvecSegAlignement" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "lightblue"
	TouchePour $Clavier "Blast segment align"  "AfficheLesAliEnPage \[set PagePropre($w)\] \[selection get\] $NomDuFichierOrigine"
	TouchePour $Clavier "Mosaic"         "IllustreLeBlast $NomDuFichierOrigine"
	TouchePour <2>      "/Map"           "AfficheMapping $NomDuFichierOrigine \[selection get\]"
	TouchePour <3>      "/DrawBlast"     "DrawBlast $NomDuFichierOrigine"
	TouchePour $Clavier "Localise 0.001" "AfficheChaqueSegmentDuBlastN $Nom $NomDuFichierOrigine"
	TouchePour <2>      "/sel."          "AfficheChaqueSegmentDuBlastN $Nom $NomDuFichierOrigine \[selection get\]" 
	TouchePour $Clavier "Chromos"        "IllustreLesChromosomes"
	TouchePour <2>      "/Histo"         "ChoixHistogramme"
	
	TouchePour $Clavier "HitsPN"    "LesBandelettesDuBlast $NomDuFichierOrigine {} {} OnGraphe"
	TouchePour <2>      "/SeqSizes" "TailleDesSequencesAAligner $Nom"
	TouchePour <3>      "/ All"     "LesEntetesChevronneesDuBlast \[set PagePropre($w)\] Show $NomDuFichierOrigine"
	TouchePour $Clavier "Bandes"     "LesElusDuBlastPParBandelettes $NomDuFichierOrigine {} Show"
	TouchePour <2>      "/Mounir"    "LesElusDuBlastPParMounir $NomDuFichierOrigine {} Show"
	TouchePour <3>      "/AuChoix"   "LesElusDuBlastPParAuChoix $NomDuFichierOrigine {} Show"
	
	TouchePour $Clavier "Ballast" "AfficheBallastDuBlastP $NomDuFichierOrigine $Nom"
	TouchePour $Clavier "Rsf"     "AfficheLesSortiesDuBallast $NomDuFichierOrigine rsf"
	TouchePour <2>      "/lmsp"   "AfficheLesSortiesDuBallast $NomDuFichierOrigine lmsp"
	TouchePour <3>      "/pssm"   "AfficheLesSortiesDuBallast $NomDuFichierOrigine pssm"
	TouchePour $Clavier "TopSeq"  "AfficheLesSortiesDuBallast $NomDuFichierOrigine topseq"
	TouchePour <2>      "/Tabl"   "AfficheLesSortiesDuBallast $NomDuFichierOrigine table"
	TouchePour <3>      "/Anch"   "AfficheLesSortiesDuBallast $NomDuFichierOrigine anchors"
	if {[regexp -nocase "psiblast" $NomDuFichierOrigine]} {
	    TouchePour $Clavier "SplitPsiBlast" "ShowLesBlastsDuPsiBlast $NomDuFichierOrigine" "lightgreen"
	    TouchePour <2>      "/first"        "ShowLesBlastsDuPsiBlast $NomDuFichierOrigine 1"
	    TouchePour <3>      "/last"         "ShowLesBlastsDuPsiBlast $NomDuFichierOrigine end"
	}
	regsub {\.blast[pn]?$} $NomDuFichierOrigine "" NomDuFasta
	append NomDuFasta ".fasta"
	if {[file exists $NomDuFasta]} {
	    TouchePour $Clavier "Show fasta"  "AfficheVariable \[ContenuDuFichier $NomDuFasta\]" "blue"
	}
    }
    
    if { [regexp "AvecOpCom" $Maniere] } {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur  "pink"
	TouchePour $Clavier "Operon ORFs" "ORFsDesOperonsCommuns \[selection get\] ORFsOfOperon"
    }
    
    if { ! [regexp "SansFetch" $Maniere]} {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "orange"
	set FichierAussi ""
	if {[OnTraiteUneCollection]} { set FichierAussi "$NomDuFichierOrigine" }
	if {[OnTraiteDesCDNAs]}      { set FichierAussi "OnVeutNucEMBL" } 
	
	TouchePour $Clavier "Fetch"          "AfficheFetch  \[selection get\] $FichierAussi"
	TouchePour <2>      " /nature"       "AfficheFetch  \[selection get\] OnVeutNature"
	TouchePour <3>      "/seq"           "AfficheFetch  \[selection get\] $NomDuFichierOrigine"
	TouchePour $Clavier "Split in words"     "OffreLesMots  \[selection get\]"
	TouchePour $Clavier "Contig"             "AfficheContigComplet \[selection get\]"
	TouchePour <2>      "/GenScan"           "AfficheGenscanDuContig \[selection get\]"
	TouchePour $Clavier "Kegg"               "IllustreLesPathwayDeLaBoite $Nom"
	TouchePour <2>      "/Dev"               "IllustreDevStage \[list $Nom\] 3 [Fiches]/SelectedEST" 
	TouchePour <3>      "/Tissue"            "IllustreTissueType \[list $Nom\] {} 3 \[Fiches\]/SelectedEST" 
	TouchePour $Clavier "Gene Identity Card" "GeneIdentityCard $Nom"
	TouchePour $Clavier "Show GOs"           "ShowGOs $Nom"
	TouchePour $Clavier NouvelleCouleur "cyan"
	if {[regexp "Tparva" [RepertoireDuGenome]]} {
	    TouchePour $Clavier "BlastP Sc" "ShowBlastFromSelection \[selection get\] blastpScReciproc"
	    TouchePour <2>        "/Yeast"  "YEAHshowYeast \[selection get\]"
	    TouchePour <3>        " /Info"  "Reciproc $Nom ShowInfo"
	    TouchePour $Clavier "BlastP Eh" "ShowBlastFromSelection \[selection get\] blastpEhistolica"
	    TouchePour <2>           "/ Pf" "ShowBlastFromSelection \[selection get\] blastpPfalciparumReciproc"
	    TouchePour <3>           "/ Tb" "ShowBlastFromSelection \[selection get\] blastpTbruceiReciproc"
	}
	
    }
    if { [regexp "AvecRecap" $Maniere]} {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "ForestGreen"
	TouchePour $Clavier "Blast"          "SeeAby MemoBlast   \[selection get\]"
	TouchePour <2>      "/choose"        "SeeAby ChooseBlast \[selection get\]"
	TouchePour <3>      "/all"           "SeeAby AllBlast    \[selection get\]"
	TouchePour $Clavier "BlastP"         "SeeAby blastp            \[selection get\]"
	TouchePour <2>      "/RefseqP"       "SeeAby blastprefseq-prot \[selection get\]"
	TouchePour $Clavier "Blastn wgs"     "SeeAby blastnwgs         \[selection get\]"
	TouchePour $Clavier "TBlastN wgs"    "SeeAby tblastnwgs        \[selection get\]"
	TouchePour <2>      "/Genomes"       "SeeAby tblastncompletegenomes \[selection get\]"
    }
    if {[OnTraiteDesClones]} {
	TouchePour $Clavier "My Oligos"  "IllustreLesPrimers $Nom" "" "Magenta"
	TouchePour <2>      "/vPPCR" "ShowLesVirtualPPCRsDuPGS $Nom"
	TouchePour <3>      "/VEs"   "ShowLesVEDidierDuPGS $Nom"
	if {1} {
	    TouchePour $Clavier "vPpcr "        "ShowVirtualPPCR \[selection get\]" "" "Magenta"
	    TouchePour <2>      "/choose"       "ShowVirtualPPCR \[selection get\] Choose"
	    TouchePour <3>      "/all"          "ShowVirtualPPCR \[selection get\] All"
	    TouchePour $Clavier "Rec1 of vPPCR" "ShowLesRec1DuVirtualPPCR \[selection get \]" "" "Magenta"
	    TouchePour $Clavier "Rec1 or 2 or fusion "  "ShowCorrespondingFile   \[selection get\]" "" "Magenta"
	    TouchePour $Clavier "ShowVEDidier"  "VEDidier \[selection get\] Show" "" "Magenta"	    
	}
    }
    if { ! [regexp "SansFetch" $Maniere] &&  [OnTraiteUneCollection] && ! [OnTraiteDesCDNAs] &&  [file tail $NomDuFichierOrigine]!=$Nom} {
	TouchePour $Clavier "Co-Fetch"    "AfficheAssocie $NomDuFichierOrigine copains"
	TouchePour <2>      "/BlastP"     "AfficheAssocie $NomDuFichierOrigine coblastp"
	TouchePour <3>      "/MSF"        "AfficheAssocie $NomDuFichierOrigine coclustalw"
	TouchePour $Clavier "Co-Info"     "AfficheAssocie $NomDuFichierOrigine coinfos"
	TouchePour <2>      "/tBlastN"    "AfficheAssocie $NomDuFichierOrigine cotblastn"
	TouchePour $Clavier "Co-modify"   "InformeLeCopain $NomDuFichierOrigine"
	TouchePour $Clavier "Co-rsf"      "AfficheLesSortiesDuBallast $NomDuFichierOrigine rsf"
	TouchePour <2>      "/lmsp"       "AfficheLesSortiesDuBallast $NomDuFichierOrigine lmsp"
	TouchePour <3>      "/pssm"       "AfficheLesSortiesDuBallast $NomDuFichierOrigine pssm"
    }
    
    if {[OnTraite "MSP"]} {
	TouchePour $Clavier NouvelleCouleur "magenta"
	TouchePour $Clavier "SeqCalage"  "SeqCalage $Nom"
    }
    if {[OnTraite "CilioCode"]} {
	TouchePour $Clavier NouvelleCouleur "magenta"
	TouchePour $Clavier "Cilio ForCilio"  "CilioBlastSummary     $Nom Show  blastpForCilio"
	TouchePour <2>      "/Expect"         "OrganismsInCilioBlast $Nom Graph blastpForCilio"
	TouchePour $Clavier "Cilio Protall"   "CilioBlastSummary     $Nom Show  blastpProtall"
	TouchePour <2>      "/Expect"         "OrganismsInCilioBlast $Nom Graph blastpProtall"
	TouchePour $Clavier "Cilio Ortholog"  "CilioBlastSummary     $Nom Show  blastpBanqueOrthologs"
	TouchePour <2>      "/Expect"         "OrganismsInCilioBlast $Nom Graph blastpBanqueOrthologs"
    }
    if {[OnTraiteDesClones]} {
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "magenta"
	if {[regexp "AvecOli" $Maniere]} {
	    TouchePour $Clavier "Oligo "  "ShowOli \[selection get\]"
	    TouchePour <2>      "/choose" "ShowOli \[selection get\] Choose"
	    TouchePour <3>      "/all"    "ShowOli \[selection get\] All"
	    TouchePour $Clavier "ShowBlastN"  "ShowBlastOfOligo \[selection get\]"
	    TouchePour <2>      "/Order"      "AfficheFournisseur \[selection get\]"
	}
	if {[regexp "AvecShowItsOligos" $Maniere]} {
	    set NA ""
	    if {[regexp "AvecShowItsOligos_NA" $Maniere]} { set NA "_NA" }
	    TouchePour $Clavier "Show its oligos" "ShowItsOligos \[selection get\] $NA"
	}
	if {[regexp "AvecFiOl" $Maniere]} {
	    TouchePour $Clavier "ShowOligosFiles" "ShowOligosFiles \[selection get\]"
	}
	if {[regexp "AvecVirtualPPCR" $Maniere]} {
	    TouchePour $Clavier "vPpcr "        "ShowVirtualPPCR \[selection get\]"
	    TouchePour <2>      "/choose"       "ShowVirtualPPCR \[selection get\] Choose"
	    TouchePour <3>      "/all"          "ShowVirtualPPCR \[selection get\] All"
	    TouchePour $Clavier "Rec1 of vPPCR" "ShowLesRec1DuVirtualPPCR \[selection get \]"
	}
	if {[regexp "AvecShowItsPPCR" $Maniere]} {
	    set NA ""
	    if {[regexp "AvecShowItsPPCR_NA" $Maniere]} { set NA "_NA" }
	    TouchePour $Clavier "Show its PPCR" "ShowItsPPCR \[selection get\] $NA"
	}
	if {[regexp "AvecTriFragments" $Maniere]} {
	    TouchePour $Clavier "SortFragments all" "TriFragments \[set PagePropre($w)\] Ask"
	    TouchePour <2>      "/sel."             "TriFragments \[selection get\] Ask"
	}
    }
    if {[regexp "AvecTaxNCBI" $Maniere]} { 
	TouchePour $Clavier NouvelleGamme
	TouchePour $Clavier NouvelleCouleur "lightgreen"
	TouchePour $Clavier "BrowseTaxNCBI" "BrowseTaxNCBI"
	TouchePour $Clavier "Sel. Parent"   "BrowseTaxNCBI \[selection get\] Parent"
	TouchePour <2>      "/Children"     "BrowseTaxNCBI \[selection get\] Children"
	TouchePour <3>      "/?"            "BrowseTaxNCBI \[selection get\]"
	TouchePour $Clavier "All Parent"    "BrowseTaxNCBI \[set PagePropre($w)\] Parent"
	TouchePour <2>      "/Children"     "BrowseTaxNCBI \[set PagePropre($w)\] Children"
	TouchePour <3>      "/?"            "BrowseTaxNCBI \[set PagePropre($w)\]"
    }
    if {$ForValidateOnly} { TouchePour $Clavier "ReAcceptAll" }
    

    #rR 2016/02/02 On a peut-être Postponé des TouchePour ;)
    set LesPostpone [TouchePour "GetPostponeAndReset"]
    set Cla $w.buttons
    foreach Action $LesPostpone {
	regsub -all "@F@" $Action $w Action
	if {[regexp "<" [lindex $Action 0]]} {
	    TouchePour {*}$Action
	} else {
	    TouchePour $Cla {*}$Action
	}
    }
    
    set Largeur 80
    set Hauteur 35
    if { [regexp "GrandeLargeur" $Maniere] } { set Largeur 128 }
    if { [regexp {SetWidth([0-9]+)}  $Maniere Match Width] }  { set Largeur $Width }
    if { [regexp {SetHeight([0-9]+)} $Maniere Match Height] } { set Hauteur $Height }
    if { ! [PourWscope]} {
	frame $w.frame -borderwidth 10
	pack  $w.frame -side top -expand yes -fill both
	
	
	scrollbar $w.frame.yscroll -command "$w.frame.list yview"
	scrollbar $w.frame.xscroll -command "$w.frame.list xview"  -orient horizontal
	listbox $w.frame.list -width $Largeur -height $Hauteur -setgrid 1  -yscroll "$w.frame.yscroll set"  -xscroll "$w.frame.xscroll set"  -selectmode extended  -background "LightGrey"  -foreground "Black"  -selectbackground "LightYellow"  -selectforeground "Black"  -font [list Courier [PolicePourListBox]]

	bind $w.frame.list "<4>"         "%W yview scroll  1 units"
	bind $w.frame.list "<5>"         "%W yview scroll -1 units"
	bind $w.frame.list "<Control-4>" "%W xview scroll  1 units"
	bind $w.frame.list "<Control-5>" "%W xview scroll -1 units"
	
	grid $w.frame.list    -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky nsew
	grid $w.frame.yscroll -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky nsew
	grid $w.frame.xscroll -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky nsew
	grid rowconfig    $w.frame 0 -weight 1 -minsize 0
	grid columnconfig $w.frame 0 -weight 1 -minsize 0
	
	set nLignes 0
	foreach Ligne [split [set PagePropre($w)] "\n"] {
	    incr nLignes
	    if { [regexp "AvecSegAlignement" $Maniere] && [regexp {^>[\./a-zA-Z]} $Ligne]  && ! [regexp "AvecTout" $Maniere]} { break }
	    $w.frame.list insert end $Ligne
	}
    }
    if {[PourWscope]} {
	set R [Html_TextToListbox [set PagePropre($w)] $w $Titre $Header "" $Maniere]
	if { [regexp "AvecRetour" $Maniere] } {
	    return $R

	    global VariableDeRetour
	    package require Tk
	    tkwait variable VariableDeRetour($w)
	    set v $VariableDeRetour($w)
	    LogWscope "apres tkwait de $Var valeur $v"
	    unset  VariableDeRetour($w)
#	    catch {destroy $w}
	    return $v
	}
	return $R
    }
    if {$nLignes<30} { $w.frame.list configure -height [expr $nLignes+3] }
    
    if {[regexp "AvecEtude" $Maniere] && $Nom!=""} {
	Illumine $Nom $w
    }
    
    bind $w.frame.list <3>               "DecrisLaLigne %W %x %y"
    bind $w.frame.list <ButtonRelease-3> "DecrisLaLigne %W %x %y Efface"
    
    if {[regexp "AvecRetour" $Maniere]} {
	$w.frame.list configure -background "lightgreen"
    }
    if { [regexp "AvecRetourMaisSansWait" $Maniere] } {
	return $w
    }

    if { [regexp "AvecRetour" $Maniere] } {
	tkwait variable VariableDeRetour($w)
	set v $VariableDeRetour($w)
	unset  VariableDeRetour($w)
	catch {destroy $w}
	return $v
    } else {
	return $w
    }


}

proc AfficheVirtualPPCR {} {


    set Page [join [VirtualPPCREnStock LesResumes] "\n"]
    set LesQuois [VirtualPPCREnStock LesQuois]
    return [AfficheVariable $Page "AvecVirtualPPCR" AllVirtualPPCRs]


}

proc AfficheZoneContigue {Fichier {Selection ""}} {


    if {$Selection==""} { set Selection "FirstOnly" }
    if {[regexp "\n" $Selection]} {
	set AliasALaFin ""
	foreach Access [split $Selection "\n"] {
	    if {[regexp {^ *Alias } $Access]} {
		set AliasALaFin $Access
		continue
	    }
	    AfficheZoneContigue $Fichier $Access 
	}
	if {$AliasALaFin!=""} { AfficheZoneContigue $Fichier $AliasALaFin }
	return
    }
    
    set Access ""
    scan $Selection "%s %s" Nature Access
    if {$Access==""} { set Access $Nature }
    
    set LesHomologues [LesHomologiesDuBlastN $Fichier "AvecLaSeq" "" "SansOrga" $Access]
    foreach Homo $LesHomologues {
	set lHomo [split $Homo "\t"]
	set i -1
	set Nom        [lindex $lHomo [incr i]]
	set nCops      [lindex $lHomo [incr i]]
	set nCopsSeq   [lindex $lHomo [incr i]]
	set BanqueId   [lindex $lHomo [incr i]]
	set OrgaHomo   [lindex $lHomo [incr i]]
	set Identities [lindex $lHomo [incr i]]
	set Expect     [lindex $lHomo [incr i]]
	set DebutQuery [lindex $lHomo [incr i]]
	set FinQuery   [lindex $lHomo [incr i]]
	set DebutSbjct [lindex $lHomo [incr i]]
	set FinSbjct   [lindex $lHomo [incr i]]
	set SeqQuery   [lindex $lHomo [incr i]]
	set SeqSbjct   [lindex $lHomo [incr i]]

	set SensSbjct 1
	if {$FinSbjct < $DebutSbjct} { set SensSbjct -1 }

	set iQ $DebutQuery
	set iQTexte ""
	set iQTexteEstVide 1
	set iS $DebutSbjct
	set iSTexte ""
	set iSTexteEstVide 1
	set ConMax -1
	set ConCourant 0
	set ConDebCourantQ -1
	set ConDebCourantS -1
	set Peigne  ""
	set PeigneN ""
	set ConDebQ -3
	set iP 1
	foreach Q [split $SeqQuery ""] S [split $SeqSbjct ""] {
	    if {[expr $iQ%10==0] && $Q!="-" } {
		set iQTexteEstVide 0
		append iQTexte [string range "$iQ          " 0 9]
	    } else {
		if {$iQTexteEstVide} { append iQTexte " " }
	    }
	    if {[expr $iS%10==0] && $S!="-" } {
		set iSTexteEstVide 0
		append iSTexte [string range "$iS          " 0 9]
	    } else {
		if {$iSTexteEstVide} { append iSTexte " " }
	    }
	    if {[string equal -nocase "N" $Q]} { append PeigneN "N" } else { append PeigneN " " }
	    if {[string equal -nocase $Q $S] || [string equal -nocase "N" $Q]} {
		append Peigne "|"
		incr ConCourant
		if {$ConDebCourantQ==-1} {
		    set ConDebCourantP $iP
		    set ConDebCourantQ $iQ
		    set ConDebCourantS $iS
		} 
		if { ! [info exists ConFinQ]} {
		    set ConFinP $iP
		    set ConFinQ $iQ
		    set ConFinS $iS
		}
		if {$ConCourant>$ConMax} {
		    set ConMax  $ConCourant
		    set ConFinP $iP
		    set ConFinQ $iQ
		    set ConFinS $iS
		    if {$ConDebQ!=$ConDebCourantQ} {
			set ConDebP $ConDebCourantP
			set ConDebQ $ConDebCourantQ
			set ConDebS $ConDebCourantS
		    }
		}
	    } else {
		set ConCourant 0
		append Peigne " "
		set ConDebCourantP -1
		set ConDebCourantQ -1
		set ConDebCourantS -1
	    }
	    incr iP
	    if {$Q!="-"} { incr iQ            } else { append iQTexte " " }
	    if {$S!="-"} { incr iS $SensSbjct } else { append iSTexte " " }
	}

	set iDebPeigne [expr $ConDebP - 1]
	set iFinPeigne [expr $ConFinP - 1]
	set lPeigne [expr $iFinPeigne - $iDebPeigne +1]
	set Peigne [string replace $Peigne $iDebPeigne $iFinPeigne [string repeat "+" $lPeigne]]

	if {$SensSbjct==1} {
	    set BonConDebS $ConDebS
	    set BonConFinS $ConFinS
	    set EtLeSens ""
	} else {
	    set BonConDebS $ConFinS
	    set BonConFinS $ConDebS
	    set EtLeSens "CAUTION: reverse"
	}
	lappend LaPage "$Access hit in $Fichier : $lPeigne contigous identical bases"
	lappend LaPage [format "%5d %5d %s"    $ConDebQ    $ConFinQ "from sequenced"]
	lappend LaPage [format "%5d %5d %s" $BonConDebS $BonConFinS "from $Access $EtLeSens"]
	global TextePourInformeVerificationSequencage
	set TextePourInformeVerificationSequencage "$BonConDebS-$BonConFinS"
	lappend LaPage $PeigneN
	lappend LaPage $iQTexte 
	lappend LaPage $SeqQuery
	lappend LaPage $Peigne
	lappend LaPage $SeqSbjct
	lappend LaPage $iSTexte
	set Page [join $LaPage "\n"]
	AfficheVariable $Page "" "${Fichier}_$Access"
    }


}

proc AfficheZonesClustering {} {

    global Defauts WOrdali NomTextSeq LNOrdali

    if {[TypeAli] eq "pasdali"} {return}
    if {[QuelMode] eq "seqlab"} {
	FaireLire "Not available in Editor Mode !"

	return
    }
    
    $NomTextSeq configure -state normal
    $NomTextSeq tag configure TagZoneClus -background cyan

    set bt $WOrdali(BoutZones)
    if {! [EtatBouton $bt]} {
	set Lz [lindex [ZonesClustering] 0]
	if {$Lz eq "all"} {set Lz [list [list 0 end]]}
	set Ltag {}
	foreach z $Lz {
	    lassign $z x1 x2
	    set i 1
	    foreach n $LNOrdali {
		if {$n ne ""} {
		    lappend Ltag $i.$x1 $i.$x2
		}
		incr i
	    }
	}
	if {$Ltag != {}} {
	    $NomTextSeq tag add TagZoneClus {*}$Ltag
	}

	$bt configure -relief sunken -background red -foreground white
    } else {
	$NomTextSeq tag remove TagZoneClus 1.0 end
	$bt configure -relief raised -background cyan -foreground black
    }

    update idletasks
    $NomTextSeq configure -state disabled

    return

}

proc AfficheZonesSelectionnees {zone} {

    global PositionInitiale

    if {$zone == {}} {return}
    foreach z $zone {
	lassign $z d f
	set PositionInitiale "1.$d"
	set fin "1.$f"
	SelectLesColonnes $fin
    }
    unset PositionInitiale

    return

}

proc AfficheZonesSelectionneesCluster {} {

    global ZoneClusterisation

    if {! [info exists ZoneClusterisation]} {return}

    AfficheZonesSelectionnees $ZoneClusterisation

    return

}

proc AfficheZonesSelectionneesSuper {} {

    global ZoneSuperposition

    if {! [info exists ZoneSuperposition]} {return}

    AfficheZonesSelectionnees $ZoneSuperposition

    return

}

proc AffyAnno {{Ligne ""} {Colonne ""}} {


    #attention un nouvelle version
    global AffyAnno

    if {$Ligne==""} { set Ligne "ListOf" }
    if {$Colonne==""} { set Colonne "Header" }

    if {[info exists AffyAnno($Ligne,$Colonne)]} { return $AffyAnno($Ligne,$Colonne) }
    if {[info exists AffyAnno("EstCharge")]} { return "" }
    set AffyAnno("EstCharge") 1

    set FichierAffyAnno "[RepertoireDuGenome]/fiches/AffyAnno"
    if {[file exists $FichierAffyAnno]} {
	array set AffyAnno [LesLignesDuFichier $FichierAffyAnno]
	return [AffyAnno $Ligne $Colonne]
    }

    set CreeFichierAffyAnno [OuiOuNon "Do I create $FichierAffyAnno ?"]

    set AffyAnno(ListOf,Header) {}
    set AffyAnno(ListOf,Index)  {}

    set LesFichiersAffyAnno [list  "/genomics/link/affyArrayAnnot/AffyAnno20070309/MGU74v2/MG_U74Av2.na22.annot.csv"  "/genomics/link/affyArrayAnnot/AffyAnno20070309/MGU74v2/MG_U74Bv2.na22.annot.csv"  "/genomics/link/affyArrayAnnot/AffyAnno20070309/MGU74v2/MG_U74Cv2.na22.annot.csv"  "/genomics/link/affyArrayAnnot/AffyAnno20070309/MG430_2.0/Mouse430_2.na22.annot.csv"  "/genomics/link/affyArrayAnnot/AffyAnno20070309/MG430A_2.0/Mouse430A_2.na22.annot.csv" ]

    set LesTetes {}
    set LesIndex {}
    foreach CurrentFichierAffyAnno $LesFichiersAffyAnno {
	Espionne "$CurrentFichierAffyAnno"
	set Queue [file tail $CurrentFichierAffyAnno]
	Espionne "$Queue"
	regsub -nocase {\.[^\.]+$} $Queue "" Queue
	Espionne "$Queue"
	
	LoadTxlAffy $CurrentFichierAffyAnno AffyAnno 0 ","  
	set LesNouvellesTetes $AffyAnno(ListHeaderPlease,$Queue)
	Espionne "$LesTetes"
	Espionne "++"
	Espionne "$LesNouvellesTetes"
	if {$LesTetes=={}} { set LesTetes $LesNouvellesTetes }
	if {$LesTetes!=$LesNouvellesTetes} { FaireLire "The headers are different in [join $LesFichiersAffyAnno "\n"]" }
	LConcat LesIndex $AffyAnno(ListAllPlease,$Queue)
    }	
    set AffyAnno(ListOf,Header) $LesTetes
    set AffyAnno(ListOf,Index)  $LesIndex

    if {$CreeFichierAffyAnno} {
	SauveLesLignes [array get AffyAnno] dans $FichierAffyAnno
    }
	
    return [AffyAnno $Ligne $Colonne]


}

proc AffyAnnoAllFields {Probe} {


    foreach Tete [AffyAnno ListOf Header] {
	lappend LaSortie "[format %33s $Tete] [AffyAnno $Probe $Tete]"
    }
    return [join $LaSortie "\n"]


}

proc AffyAnnoChicken {{Ligne ""} {Colonne ""}} {


    global AffyAnnoChicken

    if {$Ligne==""} { set Ligne "ListOf" }
    if {$Colonne==""} { set Colonne "Header" }

    if {[info exists AffyAnnoChicken($Ligne,$Colonne)]} { return $AffyAnnoChicken($Ligne,$Colonne) }
    if {[info exists AffyAnnoChicken("EstCharge")]} { return "" }
    set AffyAnnoChicken("EstCharge") 1

    set version "na27"
    set FichierAffyAnnoChicken "[RepertoireAffyAnnot $version]/Chicken/AffyAnnoChicken"
    if {[file exists $FichierAffyAnnoChicken]} {
	array set AffyAnnoChicken [LesLignesDuFichier $FichierAffyAnnoChicken]
	return [AffyAnnoChicken $Ligne $Colonne]
    }

    set CreeFichierAffyAnnoChicken [OuiOuNon "Do I create $FichierAffyAnnoChicken ?"]

    set AffyAnnoChicken(ListOf,Header) {}
    set AffyAnnoChicken(ListOf,Index)  {}

    set LeFichierAffyAnnoChicken "[RepertoireAffyAnnot $version]/Chicken/Chicken.na27.annot.csv"
	   
    set LesTetes {}
    set LesIndex {}
    
    set Queue [file tail $LeFichierAffyAnnoChicken]
    regsub -nocase {\.[^\.]+$} $Queue "" Queue
    LoadTxlAffy $LeFichierAffyAnnoChicken AffyAnnoChicken 0 ","  
    set LesTetes $AffyAnnoChicken(ListHeaderPlease,$Queue)
    LConcat LesIndex $AffyAnnoChicken(ListAllPlease,$Queue)

    set AffyAnnoChicken(ListOf,Header) $LesTetes
    set AffyAnnoChicken(ListOf,Index)  $LesIndex

    if {$CreeFichierAffyAnnoChicken} {
	SauveLesLignes [array get AffyAnnoChicken] dans $FichierAffyAnnoChicken
    }
	
    return [AffyAnnoChicken $Ligne $Colonne]


}

proc AffyAnnoHGU133 {{Ligne ""} {Colonne ""}} {


    global AffyAnnoHGU133

    if {$Ligne==""} { set Ligne "ListOf" }
    if {$Colonne==""} { set Colonne "Header" }

    if {[info exists AffyAnnoHGU133($Ligne,$Colonne)]} { return $AffyAnnoHGU133($Ligne,$Colonne) }
    if {[info exists AffyAnnoHGU133("EstCharge")]} { return "" }
    set AffyAnnoHGU133("EstCharge") 1

    set version "na27"
    set FichierAffyAnnoHGU133 "[RepertoireAffyAnnot $version]/HG-U133+2/AffyAnnoHGU133"
    if {[file exists $FichierAffyAnnoHGU133]} {
	array set AffyAnnoHGU133 [LesLignesDuFichier $FichierAffyAnnoHGU133]
	return [AffyAnnoHGU133 $Ligne $Colonne]
    }

    set CreeFichierAffyAnnoHGU133 [OuiOuNon "Do I create $FichierAffyAnnoHGU133 ?"]

    set AffyAnnoHGU133(ListOf,Header) {}
    set AffyAnnoHGU133(ListOf,Index)  {}

    set LeFichierAffyAnnoHGU133 "[RepertoireAffyAnnot $version]/HG-U133+2/HG-U133_Plus_2.na27.annot.csv"
	  
    set LesTetes {}
    set LesIndex {}
    
    Espionne "LeFichierAffyAnnoHGU133 $LeFichierAffyAnnoHGU133"

    set Queue [file tail $LeFichierAffyAnnoHGU133]
    regsub -nocase {\.[^\.]+$} $Queue "" Queue
    LoadTxlAffy $LeFichierAffyAnnoHGU133 AffyAnnoHGU133 0 ","  
    set LesTetes $AffyAnnoHGU133(ListHeaderPlease,$Queue)
    LConcat LesIndex $AffyAnnoHGU133(ListAllPlease,$Queue)

    set AffyAnnoHGU133(ListOf,Header) $LesTetes
    set AffyAnnoHGU133(ListOf,Index)  $LesIndex

    if {$CreeFichierAffyAnnoHGU133} {
	SauveLesLignes [array get AffyAnnoHGU133] dans $FichierAffyAnnoHGU133
    }
	
    return [AffyAnnoHGU133 $Ligne $Colonne]


}

proc AffyAnnoMG430 {{Ligne ""} {Colonne ""}} {


    global AffyAnnoMG430

    if {$Ligne==""} { set Ligne "ListOf" }
    if {$Colonne==""} { set Colonne "Header" }

    if {[info exists AffyAnnoMG430($Ligne,$Colonne)]} { return $AffyAnnoMG430($Ligne,$Colonne) }
    if {[info exists AffyAnnoMG430("EstCharge")]} { return "" }
    set AffyAnnoMG430("EstCharge") 1

    set version "na27"
    set FichierAffyAnnoMG430 "[RepertoireAffyAnnot $version]/MG430_2.0/AffyAnnoMG430"
    if {[file exists $FichierAffyAnnoMG430]} {
	array set AffyAnnoMG430 [LesLignesDuFichier $FichierAffyAnnoMG430]
	return [AffyAnnoMG430 $Ligne $Colonne]
    }

    set CreeFichierAffyAnnoMG430 [OuiOuNon "Do I create $FichierAffyAnnoMG430 ?"]

    set AffyAnnoMG430(ListOf,Header) {}
    set AffyAnnoMG430(ListOf,Index)  {}

    set LeFichierAffyAnnoMG430 "[RepertoireAffyAnnot $version]/MG430_2.0/Mouse430_2.na27.annot.csv"
	  
    set LesTetes {}
    set LesIndex {}

    set Queue [file tail $LeFichierAffyAnnoMG430]
    regsub -nocase {\.[^\.]+$} $Queue "" Queue
    LoadTxlAffy $LeFichierAffyAnnoMG430 AffyAnnoMG430 0 ","  
    set LesTetes $AffyAnnoMG430(ListHeaderPlease,$Queue)
    LConcat LesIndex $AffyAnnoMG430(ListAllPlease,$Queue)

    set AffyAnnoMG430(ListOf,Header) $LesTetes
    set AffyAnnoMG430(ListOf,Index)  $LesIndex

    if {$CreeFichierAffyAnnoMG430} {
	SauveLesLignes [array get AffyAnnoMG430] dans $FichierAffyAnnoMG430
    }
	
    return [AffyAnnoMG430 $Ligne $Colonne]


}

proc AffyAnnot {{Value ""}} {


    global AffyAnnot
    if {$Value!=""} { set AffyAnnot $Value }
    if { ! [info exists AffyAnnot]} { AffyAnnot  "[GxHome]/AffyAnnot" }
    return $AffyAnnot


}

proc AffyDsRefGene {FichierAffyAnnot} {


    #marche pas car affy ne donne pas les coordonnes de la target sequence mais de la consensus/exemplar sequence
    set Version [InterrogeFichierAffyAnnotRapide $FichierAffyAnnot "genome-version-ucsc" "version"]
    set FichierRefGene [CorresVersionGenomeEtFichierRefGene $Version]  
    Espionne "Version $Version"
    Espionne "FichierRefGene $FichierRefGene"

    foreach Ps [InterrogeFichierAffyAnnot $FichierAffyAnnot ListOf Id] {
	set ResultCur {}
	set Align [InterrogeFichierAffyAnnot $FichierAffyAnnot $Ps Alignments]
	Espionne ""
	Espionne "$Ps $Align"
	if {$Align=="---"} {lappend ResultCur "Pas Loc"; Espionne "ResultCur $ResultCur"; continue}
	regsub -all "///" $Align "#" Align
	regsub -all "//" $Align "@" Align
	set LesLocCompletes [split $Align "#"]
	foreach LocComplete $LesLocCompletes {
	    set ResultCur {}
	    set Loc [lindex [split [string trim $LocComplete] "@"] 0]
	    set Loc [string trim $Loc]
	    Espionne "$Loc"
	    set DetailLoc  [split $Loc ": -"]
	    set DetailLoc2 [split $Loc "\(\)"]
	    set ChromAffy [lindex $DetailLoc 0]
	    set StartAffy [lindex $DetailLoc 1]
	    set StopAffy  [lindex $DetailLoc 2]
	    set SensAffy  [lindex $DetailLoc2 1]
	    Espionne "LocInBetween $StartAffy $Version $ChromAffy Vide $StopAffy :"
	    set Result [LocInBetween $StartAffy $Version $ChromAffy "" $StopAffy]
	    Espionne "Result $Result"

	    if {[regexp "^Between" $Result]} {
		lappend ResultCur "Outside from Refseq"
	    } else  {
		foreach In $Result {
		    set SensIn [lindex [split $In " "] 3]
		    if {$SensIn==$SensAffy} {lappend ResultCur $In}
		}
	    }
	    Espionne "ResultCur $ResultCur"
	}
    }


}

proc AffyFileToMySql {AffyFile organism} {


	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "AffyFileToMySql|$timestamp : Start"
	# Prepare un fichier CSV avec des ";" en remplacant les espaces par des "_" et les ";" par des tabulations
	set FichierIn [open "$Path.csv" "r"]
	set FichierOut [open "/tmp/Affy.txt" "w"]
	set Alire [read $FichierIn]
	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "AffyFileToMySql|$timestamp : Replacements"
	set Alire [regsub -all -nocase -line "\",\"" $Alire ";"]
	set Alire [regsub -all -nocase -line "\"" $Alire ""]
	set Alire [regsub -all -nocase -line "Jun 30, 2009" $Alire "200907"]
	set Alire [regsub -all -nocase -line "///" $Alire ","]
	set Aecrire [regsub -all -nocase -line " // " $Alire ","]
	puts $FichierOut $Aecrire
	close $FichierIn
	close $FichierOut
	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "AffyFileToMySql|$timestamp : Import into mySQL"
	exec "/usr/bin/mysqlimport --delete --user=anno --password=ceji387. --host=[LbgiHost] --fields-terminated-by=';' ucsc$organism /home/anno/Affy.txt"
	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "AffyFileToMySql|$timestamp : End"


}

proc AffymetrixAccess {Nom} {


    return [ExtraitInfo $Nom "AffymetrixAccess"]


}

proc AffymetrixAssocie {} {


    global AffymetrixAssocie
    global RepertoireDuGenome

    if {[info exists AffymetrixAssocie]} {
	if {$AffymetrixAssocie=="NoAssociatedAffymetrix"} { return "" }
	return $AffymetrixAssocie
    }
    set FichierAA "$RepertoireDuGenome/fiches/affymetrixassocie"
    if {[file exists $FichierAA]} {
	scan [ContenuDuFichier $FichierAA] "%s" AffymetrixAssocie
	if {$AffymetrixAssocie=="NoAssociatedAffymetrix"} { return "" }
	return $AffymetrixAssocie
    }
    set D ""
    while {$D==""} {
	if { ! [OuiOuNon "Do You want to correlate with an associated Affymetrix Gscope ?" 0]} {
	    set D "NoAssociatedAffymetrix"
	    break
	}
	FaireLire "I need to know the associated Affymetrix directory.\nPlease browse for it."
	set D [tk_chooseDirectory -mustexist 1 -initialdir "$RepertoireDuGenome/.."]
	if {$D==""} {
	    set D [Entre "NoAssociatedAffymetrix"]
	}
    }
    set AffymetrixAssocie [file tail $D]
    Sauve $AffymetrixAssocie dans $FichierAA
    if {$AffymetrixAssocie=="NoAssociatedAffymetrix"} { return "" }
    return $AffymetrixAssocie


}

proc Affymetrix_Chips {} {



    Wup "Permet de rendre le nom des repertoires des puces disponibles"

    global RepAffy

    set RepAffy [Affymetrix_Dir]
    
    if {! [file exists $RepAffy]} {
	set RepAffy "/genomics/g1/AffyProbes/Affymetrix/Full"
	if {! [file exists $RepAffy]} {
	    return ""
	}
    }

    set LesPuces [glob -nocomplain -directory "$RepAffy" -tails -types "d" "*"]
        
    return "$LesPuces"


}

proc Affymetrix_Dir {{Dir ""}} {



    #Localisation du repertoire contenant les projets ou donnees fournis par Affymetrix
    
    global Affymetrix_Dir

    if {$Dir == ""} {  
	if {[info exists Affymetrix_Dir] && [file exists $Affymetrix_Dir]} {return $Affymetrix_Dir}
	set     Affymetrix_Dir "/genomics/g1/AffyProbes/Affymetrix/Full"
    } else {
	if {[file exists $Dir]} {
	    set Affymetrix_Dir "$Dir"
	}
    }
    #if {[info exists Affymetrix_Dir] && [file exists $Affymetrix_Dir]} {return $Affymetrix_Dir}

    return $Affymetrix_Dir



}

proc AgentsDuBlock {d f {n ""}} {

    global TAg T LNOrdali MotifLen Sequences Sref
    
    if {$n eq ""} {
	set Lnoms $LNOrdali
    } else {
	set Lnoms $n
    }
      
    set LLag {}
    set nOk [expr {[llength $Lnoms] * 2}]
    for {set i $d} {$i <= ($f - $MotifLen + 1)} {incr i} {
	#lappend log "\n$i:"
	set Lag {}
	foreach n $Lnoms {
	    # check if gaps between d and f
	    set s [string range [set Sref($n)] $d $f]
	    if {[set ig [string first "." $s]] > -1} {
		puts "gap in $n pos $ig :\n$s"
		break
	    } else {
		set pos [AbsRef2Seq $n $i]
		foreach ag $TAg($n) {
		    if {$TAg($ag,$n,dep) == $pos} {
			lappend Lag $n $ag
			break
		    }
		}
	    }
	}
	if {[llength $Lag] == $nOk} {
	    lappend LLag $Lag
	} else {
	    puts "manque block !!"
	}
    }

    return $LLag

}

proc AgentsRemoveColsGaps {} {

    global Sequences LNOrdali LSOrdali
    
    #DonneMemeLongueur Sequences

    #puts "\nEntre :"
    #ShowAlignmentAgent

    set Lseq [list]
    foreach n $LNOrdali {
	lappend Lseq [set Sequences($n)]
    }
    set lmax [string length [lindex $Lseq 0]]
    unset Sequences LSOrdali

    for {set i 0} {$i < $lmax} {incr i} {
	set p$i 1
    }
    
    foreach s $Lseq {
	for {set i 0} {$i < $lmax} {incr i} {
	    if {[string index $s $i] ne "."} {
		set p$i 0
	    }
	}
    }

    set Li [list]
    for {set i 0} {$i < $lmax} {incr i} {
	if {[set p$i]} {lappend Li $i}
    }
    set Li [lsort -decreasing -integer $Li]

    set LSOrdali [list]
    foreach n $LNOrdali s $Lseq {
	foreach i $Li {
	    set s [string replace $s $i $i]
	}
	
	set Sequences($n) $s
	lappend LSOrdali $s
	incr lgout [string length $s]
    }
    update

    return

}

proc AideEnLigne {Selection} {


    global GscopeDir

    set LesMots [split [join [split $Selection "\n"] " "] " "]

    set Aucun 1
    foreach Mot $LesMots {
	set FichierHelp "$GscopeDir/help/gscope_[string tolower $Mot]_help.txt" 
	if {[file exists "$FichierHelp"]} {
	    AfficheFichier "$FichierHelp" "AvecAide"
	    set Aucun 0
	}
    }
    if { $Aucun } {
	FaireLire "Pas d'aide disponible.\nSelectionner une ligne avec des mots en MAJUSCULE"
    } 


}

proc Aiguille {Nom Couleur K Type {MilieuOuAngle milieu} {RapportAuRayonMin 0.1} {RapportAuRayonMax 0.7}} {


    global ParametresDuBoard
    global LesAutresTagsPourAiguilles

    set PI 3.14159

    set xFin           [set ParametresDuBoard($K,xFin)]
    set CentreX        [set ParametresDuBoard($K,CentreX)]
    set CentreY        [set ParametresDuBoard($K,CentreY)]
    set RayonMoyen     [set ParametresDuBoard($K,RayonMoyen)]
    set OffsetRayonMin [set ParametresDuBoard($K,OffsetRayonMin)]
    set OffsetRayonMax [set ParametresDuBoard($K,OffsetRayonMax)]

    set RayonMin [expr $RayonMoyen*$RapportAuRayonMin]
    set RayonMax [expr $RayonMoyen*$RapportAuRayonMax]


    if {$Type == "Zero" } {
	set Angle [expr $PI/2]
	set RayonMax $RayonMoyen
    } else {
	if { $MilieuOuAngle == "angle" } {
	    set Angle $Nom
	} elseif { $MilieuOuAngle == "milieu"} {
	    set Debut  [Box $Nom debut]
	    set Fin    [Box $Nom fin]
	    set Milieu [expr ($Debut+$Fin)/2]
	    if {$Type=="RepereBox"} {
		set Orient [Box $Nom orient]
		if {$Orient == "F"} { set Sens 1 } else { set Sens -1 }
		set RayonMax [expr $RayonMoyen+$Sens*($OffsetRayonMin+$OffsetRayonMax)/2]
	    }
	    set Angle [expr [DecalageAngulaireRosace] + 3.14159/2 - $Milieu*2*3.14159/$xFin]
	} else { 
	    FaireLire "Illegal\nJeMeSignale"
	    return 
	}
    }
    set PosMinX [PositionCanvaActuelleX $K [expr $CentreX+$RayonMin*cos($Angle)]]
    set PosMinY [PositionCanvaActuelleY $K [expr $CentreY-$RayonMin*sin($Angle)]]
    set PosMaxX [PositionCanvaActuelleX $K [expr $CentreX+$RayonMax*cos($Angle)]]
    set PosMaxY [PositionCanvaActuelleY $K [expr $CentreY-$RayonMax*sin($Angle)]]

    if {$Type == "RepereBox"} {
	set Couleur "black"
	$K create text $PosMinX $PosMinY -text $Nom -anchor c -tag "Txt $Type"
    }

    set BindBouton3 0
    set LesTags [list "Aiguille" "$Type"]
    if {[info exists LesAutresTagsPourAiguilles]} {
	set LesTags [concat $LesTags $LesAutresTagsPourAiguilles]
	if {[set i [lsearch $LesAutresTagsPourAiguilles "RosaceArcEnCiel"]] >= 0} {
	    set Tag [lindex $LesAutresTagsPourAiguilles 1]
	    set BindBouton3 1
	}
    }
    $K create line $PosMinX $PosMinY $PosMaxX $PosMaxY -fill $Couleur -tag $LesTags
    if {$BindBouton3} {
	$K bind "$Tag" <3>               "ManipuleLaRosace Point   $K $Tag %x %y"  
	$K bind "$Tag" <ButtonRelease-3> "ManipuleLaRosace Release $K $Tag %x %y"  
	$K bind "$Tag" <Control-3>       "ManipuleLaRosace Switch  $K $Tag %x %y"  
    }


}

proc AiguilleLaListe {ListeNomCouleur K Type {Po ""} {Min ""} {Max ""}} {


    if { ! [regexp "EnPlus$" $Type]} {
        foreach Id [$K find withtag $Type] {
            $K delete $Id
        }
    } else {
        regsub "EnPlus$" $Type "" Type
    }
    foreach {Nom Couleur} $ListeNomCouleur {
        Aiguille $Nom $Couleur $K $Type $Po $Min $Max
    }


}

proc AjoutConservationMacsims {ficXml meth} {


    
    global Defauts
    global LNOrdali
    global LSOrdali
    global TabSF
    global TPosSG
    global TPosGS
    
    if {! [info exists Defauts]} {LesDefauts}
    LesDefauts Mode Batch
    
    set lgMacsims [LesLignesDuFichier $ficXml]
    if {[lsearch -regexp $lgMacsims "<ftype>CONS_RES"] != -1} {
	puts "Conservations are already listed in the xml file"
	return 0
    }

    DefinitionPreferences
  
    DecortiqueEtAfficheUnXML $ficXml
    catch {[RunMethode $meth]} Message
 
    switch $meth {
	"Cluster"      { set ft "Cons-Multi" }
	"VectorNorm"   { set ft "Cons-VectorN" }
	"MeanDistance" { set ft "Cons-MeanD" }
	"Ranganathan"  { set ft "Cons-Ranga" }
	default        { set ft "Cons-Multi" }
    }
    set LesCpl [array get TabSF "*,$ft"]
    # initialise la liste des couleurs utilisées...
    # je dois les fournir en tant que chiffre et non en tant que couleur!
    set lCol ""
    foreach {s e} $LesCpl {
	set seq [lindex [split $s ","] 0]
	set lgMacsD ""
	foreach el $e {
	    DecortiqueUneFeature $el dg fg col score note
	    if {[string index [lindex $LSOrdali [lsearch $LNOrdali $seq]] [expr $dg - 1]] != "."} {
		set pos [expr [set TPosGS($seq,[expr $dg - 1])] + 1]
		if {[lsearch $lCol $col] == -1} {
		    set color [llength $lCol]
		    lappend lCol $col
		} else {
		    set color [lsearch $lCol $col]
		}
		if {$note eq "IdenGlob"} {
		    set type "Global - rank 1"
		} elseif {$note eq "ConsGlob"} {
		    set type "Global - rank 2"
		} else {
		    set type "Intragroup - $note"
		}
		lappend lgMacsD "<fitem><ftype>CONS_RES</ftype><fstart>$pos</fstart><fstop>$pos</fstop><fcolor>$color</fcolor><fscore>0.00</fscore><fnote>$ft $type</fnote></fitem>"
	    }
	}
	set lgMacsims [AjouteFeatAuMacsims $lgMacsims $seq $lgMacsD]
    }

    set fOut "$ficXml"
    set f [open $fOut w]

    foreach l $lgMacsims {
	puts $f $l
    }
    close $f

    return 1


}

proc AjouteAnnotation {} {

    set zon [$::NomTextSeq tag ranges selZone]
    if {$zon == {} } {
	FaireLire "No alignment zones defined !"
	
	return
    }

    $::NomTextSeq tag remove selZone 1.0 end
    
    set txt [$::Anno(WText) get 1.0 end]
    set txt [string map {"'" " "} $txt]
    $::Anno(WText) delete 1.0 end
    
    set col $::Anno(Color)   
    set colAff [CouleurO2Ordali $::Anno(Color)]
    set nom $::Anno(Nom)

    set txt "$::Anno(iAnno) - $txt"
    set txtnsp [string map {_ @ " " _} $txt]
    set Ntag "FDisp_$txtnsp"
    $::NomTextSeq tag configure $Ntag -background $colAff
    $::NomTextSeq tag add $Ntag {*}$zon

    ManageAnnotation "record" [MacCourant] $nom $txt $col $zon
    return

}

proc AjouteAuARPLog {{Texte ""} {Fichier ""}} {



    Wup "Permet de sauver dans un fichier Log les infos des resultats du process"

    global ARPLog

    if {  [info exists ARPLog] && $ARPLog  == ""} {return ""}
    if {! [info exists ARPLog] && $Fichier == ""} {return ""}
    if {$Fichier   != ""} {
	set ARPLog $Fichier
	if {$Texte == ""} {return ""}
    }

    AppendAuFichier $ARPLog "$Texte"

    return ""


}

proc AjouteAuDumpNoms {k v i} {


    global DumpNoms

    append DumpNoms $v
    return

}

proc AjouteAuDumpText {k v i} {


    global DumpText

    append DumpText $v
    return

}

proc AjouteAuLog {Log} {


  
    Wup "Permet d ecrire dans le log du panel general (GUI) ou par defaut d ecrire sur la sortie terminal"

    global LBLog

    if {! [info exists LBLog] || $Log==""} {Espionne "$Log";return ""}

    $LBLog configure -state normal
    $LBLog insert    "end"  "$Log\n"
    $LBLog configure -state disabled
    #Pour se positionner a la fin du texte
    $LBLog see end
    return ""


}

proc AjouteAuLogPipe {txt} {



    global DefautsPipe
    global TexteDuLog
    global Defauts 
        
    if {[set DefautsPipe(File,log)] == "verbose"} {
	if {! [info exists TexteDuLog]} {set TexteDuLog ""}
	append TexteDuLog "$txt\n"
    }
    return 1


}

proc AjouteBoutonFeature {bt cmd} {

    global FrmBouton FrmBtnFea

    # Attention ! Indices de grid commencent a 0 !

    set nc [expr {[lindex [grid size $FrmBtnFea] 0] - 1}]
    set nr [expr {[lindex [grid size $FrmBtnFea] 1] - 1}]

    regsub -all " " $bt "" btns
    set btns [string tolower $btns]
    button $FrmBtnFea.$btns   -text "$bt"  -command "$cmd"  -width [string length $bt]  -background green1

    grid $FrmBtnFea.$btns -in $FrmBtnFea  -pady 1 -padx 1  -row $nr -column $nc  -rowspan 1 -columnspan 1 -sticky news

    return

}

proc AjouteDefAListeDD {FichierListeDD} {


    #FichierListeDD: ANALYSE/ListeDDoverlapMABAffy (45+59) 104 redondance...5 DD
    
    #Les 45 prot DD en overlap avec MAB 
    set FichierLes45 "[RepertoireDuGenome]/ANALYSE/GO_45_MA/Les45DD"
    foreach Nom [CreeListePourFichierAUneColonne $FichierLes45] {
	set VuMAB($Nom) 1
    }
    #Les 59 prot DD en overlap avec Affy 
    set FichierLes59 "[RepertoireDuGenome]/ANALYSE/GO_59_Affy/Les59DD"
    foreach Nom [CreeListePourFichierAUneColonne $FichierLes59] {
	set VuAffy($Nom) 1
    }

    set FichierTot "[RepertoireDuGenome]/ANALYSE/Tous_6july05"
    set FichierUniq "[RepertoireDuGenome]/ANALYSE/JR_6july05"
    set FichierGO "[RepertoireDuGenome]/fiches/GeneOntology_GPO"
    set ListeDesUniques [lsort -unique [CreeListePourFichierAUneColonne $FichierListeDD]]
    foreach Nom $ListeDesUniques {
	set JR [JumeauRepresentatif $Nom]
	if {$JR!=$Nom} {Espionne "$Nom a pour JR $JR"}
	
	set OverlapMAB 0; set OverlapAffy 0
	#def 
	set NumGeneDD [InterrogeFichierTotalDataDD $FichierTot $JR N]
	set AccBestProtHuman [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD AccProt]
	set DefBestProt [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD DefProt]
	#expr reg pour exclure ce qui suit les premieres ()

	set AccBestmRNA [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD AccRNA]
	set DefBestmRNA [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD DefRNA]
	#GO
	set LesGO [InterrogeGeneOntology $FichierGO $JR LesGO]
	if {$AccBestProtHuman!=""} {
	    if {$LesGO==""} {set Ontology ""} else {
		set Ontology ""
		foreach GO $LesGO {
		    set LaDefinitionGO [InterrogeGeneOntology $FichierGO GO $GO LaDefinition]
		    #append Ontology "$GO $LaDefinitionGO /"
		    set Ontology "$GO $LaDefinitionGO"
		    break
		}
	    } 
	} else {set Ontology ""}
	if {[info exists VuMAB($Nom)]} {set OverlapMAB 1}
	if {[info exists VuAffy($Nom)]} {set OverlapAffy 1}
	lappend L "$Nom\t$JR\t$DefBestProt\t$AccBestmRNA\t$DefBestmRNA\t$Ontology\t$OverlapMAB\t$OverlapAffy"
    }
    return $L


}

proc AjouteDesGaps {{idp ""} {nb 1}} {

    global NomTextSeq LNSeqlab LSSeqlab ListeSeqsGroupees

    if {$idp eq ""} {set idp [$NomTextSeq index active]}
    lassign [split $idp ,] il ic

    set seqass [lindex $LNSeqlab $il]
    if {$seqass eq ""} {return}

    set Lseq [SeqsGroupeSeqlabDe $seqass]
    foreach s $Lseq {
	lappend LIxSeq [lsearch $LNSeqlab $s]
    }

    AjouteDesGapsATous end $nb

    set Rs [lrepeat $nb "."]
    foreach i $LIxSeq {
	set s [lindex $LSSeqlab $i]
	set s [linsert $s $ic {*}$Rs]
	set s [lrange $s 0 end-$nb]
	lset LSSeqlab $i $s
    }

    EnleveColonnesGaps

    return

}

proc AjouteDesGapsATous {pos {nb 1}} {

    global LSSeqlab LNSeqlab NomTextSeq

    $NomTextSeq insert cols $pos $nb

    set Rs [lrepeat $nb "."]
    foreach s $LSSeqlab n $LNSeqlab {
	if {[string trim $n] ne ""} {
	    set s [linsert $s $pos {*}$Rs]
	}
	lappend new $s
    }

    set LSSeqlab $new

    return

}

proc AjouteEntreesBiblio {{db ""}} {


    if {$db==""} {
	set Fichier "[MiSynPatDir]/misynpat.sql"
	set db "root"
	sqlite3 $db $Fichier
    }

    set pmids [$db eval {select pmid from biblio where accepted=-1}]
    foreach pmid $pmids {
	set Linfo [eFetchREST pubmed $pmid]
	array set Tinfo $Linfo
	if { ! [info exists Tinfo($pmid,Title)] && ! [info exists Tinfo($pmid,Abstract)] && ! [info exists Tinfo($pmid,PubYear)]} {
	    continue
	}
	lappend LesOk $pmid

	set titre    $Tinfo($pmid,Title)
	set abstract $Tinfo($pmid,Abstract)
	set year     $Tinfo($pmid,PubYear)
	set month ""
	if {[info exists Tinfo($pmid,PubMonth)]} { set month $Tinfo($pmid,PubMonth) }

	Espionne "$pmid $year $month $titre"
	Espionne "$abstract"

	set titre [string map {"'" "''"} $titre]
	set abstract [string map {"'" "''"} $abstract]
	
	$db eval {update biblio set abstract=$abstract,titre=$titre,datey=$year,datem=$month where pmid=$pmid}
    }

    return $LesOk


}

proc AjouteExtension {Extension} {



    set Rep [pwd]
    Espionne $Rep
    if {[OuiOuNon "Do you want to rename all files from\n$Rep with $Extension"]} {
	
	foreach PAB [ListeDesPABs] {
	    set NewName "$Rep/${PAB}${Extension}"
	    set OldName "$Rep/${PAB}"
	    if {[file exists $OldName]} {
		file rename -force $OldName $NewName
	    }
	}
    }


}

proc AjouteFeatAuMacsims {lgMacsims seq features} {


    
    if {[regexp {^PDB_} $seq] == 1} {
	set sequ [string range $seq 4 end]
    } else {
	set sequ $seq
    }
    set idx [lsearch $lgMacsims "<seq-name>${sequ}</seq-name>"]
    set idxD [lsearch -start $idx $lgMacsims "</ftable>"] 
    if {$idxD != -1} {
	set lgMacsD [lrange $lgMacsims 0 [expr $idxD - 1]]
	set lgMacsF [lrange $lgMacsims $idxD end]
	
	foreach feat $features {
	    lappend lgMacsD $feat
	}
	foreach l $lgMacsF {
	    lappend lgMacsD $l
	}
	return $lgMacsD
    } else {    
	return $lgMacsims
    }   


}

proc AjouteFils {pid par tid} {


    set Lp [set ::ATree($pid)]
    set Lt [set ::ATree($tid)]
    unset ::ATree($tid)

    set idx [lsearch -exact $Lp $par]
    set ls [llength [lrange $Lp $idx end]]
    lset Lt 1 $idx
    lappend Lp {*}[lrange $Lt 0 2]
    foreach {k i p} [lrange $Lt 3 end] {
	lappend Lp $k [incr i $ls] $p
    }
    set ::ATree($pid) $Lp

    return


}

proc AjouteGroupeToutLeMonde {} {

    global SDG LNDG

    # already here
    if {"GroupeToutLeMonde" in $LNDG} {
	return
    }

    set LNDG [linsert $LNDG 0 "GroupeToutLeMonde"]
    set Lt {}
    foreach e [array names SDG] {
	lappend Lt {*}[set SDG($e)]
    }
    set SDG(GroupeToutLeMonde) $Lt
    
    return

}

proc AjouteHS {Fichier FichierNew} {


    foreach Ligne [LesLignesDuFichier $Fichier] {
	#Espionne $Ligne
	if {$Ligne==""} {continue}
	if {[regexp -nocase "N/A" $Ligne]} {Espionne $Ligne;continue}
	set LesInfos [split $Ligne "\t"]
	set chro [lindex $LesInfos 0]
	if {$chro==0} {FaireLire $Ligne}
	if {$chro==""} {FaireLire $Ligne}
	if {$chro<10} {set NewChro "HS0$chro"} else {set NewChro "HS$chro"}
	set NewL [lreplace $LesInfos 0 0 $NewChro]
	#FaireLire $NewL
	set NewL [join $NewL "\t"]
	lappend L $NewL
    }
    SauveLesLignes $L dans $FichierNew


}

proc AjouteLesInfoDansLaListeBox {KListBox LesInfo} {


    foreach Elet $LesInfo {$KListBox insert end $Elet}
    return


}

proc AjouteLesTaxonsAuFichierDeClassificationTaxonomique {aTabTaxon LesTaxonsAncestraux {LeTexte ""}} {


    upvar $aTabTaxon TabTaxon

    set     Blanc                   " "
    set     DernierAncetre          [lindex  $LesTaxonsAncestraux end]
    set     NiveauDuDernierAncetre  [llength $LesTaxonsAncestraux]
    lappend LeTexte                 "[string repeat $Blanc [expr $NiveauDuDernierAncetre - 1]]$NiveauDuDernierAncetre\t$DernierAncetre"

    set     IndexAncetres            [join $LesTaxonsAncestraux ","]
    if {![info exists  TabTaxon($IndexAncetres,LesDescendants)]} {return $LeTexte}
    foreach Taxon [lsort [set TabTaxon($IndexAncetres,LesDescendants)]] {
	set LesTaxons [linsert $LesTaxonsAncestraux end $Taxon]
	set LeTexte [AjouteLesTaxonsAuFichierDeClassificationTaxonomique TabTaxon $LesTaxons $LeTexte]
    }
    return $LeTexte


}

proc AjouteNouveauPrefixe {we wl} {

    global TmpDef

    set e [string trim [$we get]]
    if {$e eq ""} {return}

    lappend TmpDef(PrefixesBank) $e
    $wl configure -state normal
    $wl delete 0 end
    $wl insert end {*}[set TmpDef(PrefixesBank)]
    $wl configure -state disabled
    $wl see end

    $we delete 0 end

    return

}

proc AjoutePDB {{what ok}} {

    global WAP LNOrdali ListePDB

    if {$what ne "ok"} {
	destroy $WAP(Win)
	unset WAP

	return
    }

    if {$WAP(File) eq ""} {
	FaireLire "Please supply a file name !"

	return
    }

    if {! [file exists $WAP(File)]} {
	FaireLire "The file\n$WAP(File)\ndoes not exists !"
	return
    }

    if {$WAP(Replace) eq ""} {
	FaireLire "Please select <<Replace>> or give the new PDB Id"

	return
    }
    
    if {$WAP(Replace)} {
	if {$WAP(Id) eq "Choose"} {
	    FaireLire "Please choose a PDB Id"

	    return
	}

	DetruitUnPDB $WAP(Id)
	set pdbid $WAP(Id)
    } else {
	if {! [EstUnAccessPDB $WAP(NewId)]} {
	    FaireLire "Please give a valid PDB Id for this structure\nIt should be on the form : NXXX_Y where N is a number (0-9), X can be a number or a letter, and Y an alphanumaric character"

	    return
	}
	set pdbid $WAP(NewId)
    }
    LoadNouveauPDB $WAP(File) $pdbid

    foreach c [$pdbid _chains] {
	set nom [BonNomPDB ${pdbid}_$c]
	if {$nom in $LNOrdali && $nom ni $ListePDB} {
	    lappend ListePDB $nom
	}
    }

    destroy $WAP(Win)
    unset WAP

    return

}

proc AjoutePourcentageMRMDansInfos {Nom} {


    set PourcentMasque [QuelPourcentageApresMRM $Nom]
    if {$PourcentMasque!="" && $PourcentMasque!=0} {
	InformeSansDemander $Nom "MRMPourcent: $PourcentMasque"
    }


}

proc AjoutePourcentageMRMDansInfosPourTous {} {


    foreach Nom [ListeDesPABs] {
	AjoutePourcentageMRMDansInfos $Nom
    }


}

proc AjouteProfilMoyEtRN {FichierRegine FichierSortie} {


    set FichierTot "[RepertoireDuGenome]/OVERLAP931/TotalData"
    set FichierUniq "[RepertoireDuGenome]/OVERLAP931/DataUniques"
    #Profil DD
    foreach Ligne [LesLignesDuFichier "[RepertoireDuGenome]/fiches/FoldExpression_tous"] {
	set LesChamps [split $Ligne "\t"]
	set DD [lindex $LesChamps 0]
	set Prof [lindex $LesChamps 1]
	if {$Prof=="+"} {set P($DD) "T"}
	if {$Prof=="-"} {set P($DD) "N"}
	if {$Prof=="0"} {set P($DD) "C"}
    }
    #Profil Virtual Northern et Northern
    set FichierProfilDDValidation "[RepertoireDuGenome]/totalite/ValidationProfil.txt"
    if {![file exists $FichierProfilDDValidation]} {return}
    foreach Ligne [LesLignesDuFichier $FichierProfilDDValidation] {
	if {$Ligne=="" || [regexp "user" $Ligne]} {continue}
	set LesChamps [split $Ligne "\t"]
	set Owner [lindex $Ligne 0]
	set CC [lindex $Ligne 2]
	if {$Owner=="F"} {set CC [string toupper $CC]}
	if {$Owner=="I"} {regsub -all "\'" $CC "_" CC}
	set ProfVN [lindex $Ligne 3]
	set ProfNorthern [lindex $Ligne 5]
	
	set PVN($Owner,$CC) $ProfVN
	set PN($Owner,$CC) $ProfNorthern
    }
    #profil Macroarray
    set FichierMacroarray "[RepertoireDuGenome]/MembranesRegine/compar_profils_mb_gscope"
    foreach Ligne [LesLignesDuFichier $FichierMacroarray] {
	if {$Ligne==""} {continue}
	set LesChamps [split $Ligne "\t"]
	set DD [lindex $LesChamps 1]
	set ProfMb [lindex $LesChamps 2]
	set PMb($DD) $ProfMb
    }
    #correspondance HNK DD
    set FichierCorres "[RepertoireDuGenome]/lacorrespondance"
    foreach Ligne [LesLignesDuFichier $FichierCorres] {
	if {$Ligne==""} {continue}
	set Ligne [split $Ligne "\t"]
	set New [lindex $Ligne 0]; set Old [lindex $Ligne 1]
	set N($Old) $New
    }
    foreach Ligne [LesLignesDuFichier $FichierRegine] {
	if {$Ligne==""} {continue}
	if {[regexp "GscopeCode" $Ligne]} {continue}
	set Ligne [split $Ligne "\t"]
	#HNK -> DD
	set HNK [string trim [lindex $Ligne 0]]
	if {$HNK!=""} {
	    if {[info exists N($HNK)]} {
		set DD $N($HNK)
		Espionne $DD
		#fiches/jumeaux est une copie de 931 (931 avec jum)
		set JR [JumeauRepresentatif $DD]
		#DD -> jumeaux
		set FichierJumeaux "[RepertoireDuGenome]/fiches/jumeaux"
		set LesJumeauxDuJR [LesJumeauxDuPAB $DD $FichierJumeaux]
		set LesJumeaux [TousLesJumeauxDuPAB $DD $FichierJumeaux]
		set LesJumeaux [split $LesJumeaux " "]
		#jumeaux -> VN Northern du cluster
		set ProfilVN ""; set ProfilNorthern ""; set ProfilMb ""
		foreach Jumeau $LesJumeaux {
		    set CodeClone [InterrogeFichierTotalDataDD $FichierTot $Jumeau Code]
		    set User [InterrogeFichierTotalDataDD $FichierTot $Jumeau User]
		    set Band [InterrogeFichierTotalDataDD $FichierTot $Jumeau Bande]
		    #virtual northern
		    if {[info exists PVN($User,$CodeClone)] && $ProfilVN==""} {set ProfilVN $PVN($User,$CodeClone)} 
		    set ProfilVN [string trim $ProfilVN]
		    if {[info exists PVN($User,$CodeClone)] && $ProfilVN!="" && [string trim $PVN($User,$CodeClone)]!="" && $ProfilVN!=$PVN($User,$CodeClone)} {
			#Espionne "VN: $ProfilVN dif de $PVN($User,$CodeClone) de $Jumeau"
			if {$ProfilVN==0 && $PVN($User,$CodeClone)!=0} {
			    set ProfilVN $PVN($User,$CodeClone)
			    #Espionne $Jumeau
			}
		    } 
		    #northern
		    if {[info exists PN($User,$CodeClone)] && $ProfilNorthern==""} {set ProfilNorthern $PN($User,$CodeClone)}
		    set ProfilNorthern [string trim $ProfilNorthern]
		    if {[info exists PN($User,$CodeClone)] && $ProfilNorthern!="" && [string trim $PN($User,$CodeClone)]!="" && $ProfilNorthern!=$PN($User,$CodeClone)} {
			#Espionne "Northern: $ProfilNorthern et $PN($User,$CodeClone) de $jumeau"
		    }
		    
		    #membrane nylon Regine
		    if {[info exists PMb($Jumeau)] && $ProfilMb==""} {set ProfilMb $PMb($Jumeau)} 
		    set ProfilMb [string trim $ProfilMb]
		    #if {$ProfilMb==" "} {set ProfilMb ""}
		    if {[info exists PMb($Jumeau)] && $ProfilMb!="" && [string trim $PMb($Jumeau)]!="" && $ProfilMb!=$PMb($Jumeau)} {
			#Espionne "Mb: $ProfilMb et $PMb($Jumeau)"
		    } 
		}
		if {$JR!=""} {
		    set NumGeneDD [InterrogeFichierTotalDataDD $FichierTot $DD N]
		    set ProfilCalc [InterrogeFichierTotalDataDD $FichierTot $DD Profil]
		    set ProfilConsensus [InterrogeFichierTotalDataDD $FichierTot $DD ProfCons]
		    
		    set DifE [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD DifE]
		    set ProfE [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD ProfE]
		    set DifS [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD DifS]
		    set ProfS [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD ProfS]
		    set DifU [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD DifU]
		    set ProfU [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD ProfU]
		    set DifMoy [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD DifMoy]
		    set ProfMoy [InterrogeFichierDDUniques3T $FichierUniq $NumGeneDD Pmoy]
		    
		    AppendAuFichier $FichierSortie "$CodeClone\t$Band\t$User\t$NumGeneDD\t$HNK\t$DD\t$JR\t$LesJumeauxDuJR\t$DifE\t$ProfE\t$DifS\t$ProfS\t$DifU\t$ProfU\t$DifMoy\t$ProfMoy\t$ProfilCalc\t$ProfilConsensus\t$ProfilVN\t$ProfilNorthern\t$ProfilMb"
		} else {
		    #si pas de JR, c'est un court ou conta ou nohomolog
		    #Espionne "$DD n'est pas dans les 931avecjum"
		    lappend Liste $DD
		    #VN
		    #if {[info exists PVN($User,$CodeClone)]} {set ProfilVN $PVN($User,$CodeClone)}
		    #Profil DD
		    #if {[info exists P($DD)]} {set ProfilCalc $P($DD)}
		    #Profil_consensus
		    #if {[info exists Pc($DD)]} {set ProfilConsensus $Pc($DD)}
		    #PMoy
		}
	    } else {Espionne "pb pour $HNK"}
	}
    }
    SauveLesLignes $Liste dans "[RepertoireDuGenome]/Regine/pbs_out"


}

proc AjouteRepeatDansInfos {Nom} {


    set Repeat [QuelRepeat $Nom]
    if {$Repeat!=""} {
	InformeSansDemander $Nom "MRM: $Repeat"
    }


}

proc AjouteRepeatDansInfosPourTous {} {


    foreach Nom [ListeDesPABs] {
	AjouteRepeatDansInfos $Nom
    }


}

proc AjouteRepeatDansInfos_old {Nom} {


    set Repeat [QuelRepeatApresReMasking $Nom]
    if {$Repeat!=""} {
	InformeSansDemander $Nom "MRM: $Repeat"
    }


}

proc AjouteSeqs {} {

    global LNSeqlab LSSeqlab LNOrdali LSOrdali LongueurTotale ListePDB HashPDB Sequences NomSeqSel TAddS LNDG SDG
    
    if {[TypeAli] eq "pasdali"} {
	FaireLire "There are no sequences yet.\nPlease load an alignment first."
	
	return
    }
    
    # not in editor mode
    if {[QuelMode] eq "seqlab"} {
	FaireLire "You can't add sequences in Editor mode !\nLeave the Editor to add sequences."
	
	return
    }
    
    if {! [info exists TAddS]} {
	set res [AskAddSeqs]	
    }
    # repere position ascenceur
    set yscr ""
    set tmp ""
    if {[info exists ::TScrollY]} { lassign [$::TScrollY get] yscr tmp }
    
    FaireAttendre "Please wait ...\nLoading and parsing new sequences ..."
    
    # Load sequences et verif format
    set file $TAddS(File)
    set LNTank {}
    if {[EstLeBonFormat $file TFA]} {
	DecortiqueUnTFA $file LNTank TTank
    } elseif {[EstLeBonFormat $file ALN]} {
	DecortiqueUnALN $file LNTank TTank
    } else {
	DecortiqueUnMSF $file LNTank TTank
    }
    # Nothing read ...
    if {[llength $LNTank] == 0} {
	FaireLire "Error !\nNothing was read from the file $file !"
	FaireLaSuite

	return
    }
    
    # ok let's go
    VueEditee 1
    
    # reference sequences
    if {[QuelMode] eq "seqlab"} {
	set LNomsAli $LNSeqlab
	set LSeqsAli [list]
	foreach s $LSSeqlab {
	    lappend LSeqsAli [join $s ""]
	}
    } else {
	set LNomsAli $LNOrdali
	set LSeqsAli $LSOrdali
    }
    set y [lsearch -exact $LNomsAli $TAddS(seqInsert)]
    
    # Nettoyages divers (ou d'ete)
    set lgsadd 0
    set LNAddSeq [list]
    set LSAddSeq [list]
    foreach n $LNTank {
	set s [set TTank($n)]
	set n [BonAccess $n]
	set s [BonneSequencePourAlignement $s]
	set nogap [string map {" " "" "~" "" "-" "" "." ""} $s]
	if {! [string length $nogap]} {
	    if {[ModeI]} {
		FaireLire "You have empty sequences !\n>$n< will be left out !"
	    }
	    continue
	}
	
	if {$n in $LNomsAli} {
	    # on ne duplique pas les pdb
	    if {$n in $ListePDB} {
		continue
	    }
	    
	    # sequence already exists
	    switch $TAddS(CopySkip) {
		1 {
		    continue
		}
		0 {
		    set pi 1
		    while {"${n}__$pi" in $LNomsAli} {
			incr pi
		    }
		    set n "${n}__$pi"
		}
	    }
	}
	set l [string length $s]
	set lgsadd [expr {$l>$lgsadd?$l:$lgsadd}]
	set n [string trim $n]
	set newS($n) $s
	lappend LNAddSeq $n
	lappend LSAddSeq $s
    }
    # no sequences to add
    if {$LNAddSeq == {} } {
	FaireLaSuite
	
	return
    }
    
    # should we align the new sequences ?
    set DoAlign $TAddS(Align)
    if {$DoAlign} {
	# create a TFA from alignment
	set aliTfa [list]
	foreach n $LNomsAli s $LSeqsAli {
	    if {$n ne ""} {
		set s [string map {. -} $s]
		lappend aliTfa ">$n" $s
	    }
	}
	set aliTfa [join $aliTfa "\n"]
	# create a TFA with seqs to be added
	set addTfa [list]
	foreach n $LNAddSeq s $LSAddSeq {
	    set s [string map {. -} $s]
	    lappend addTfa ">$n" $s
	}
	set addTfa [join $addTfa "\n"]
	
	# create MAFFT alignement
	if {[OutsideCSTB]} {
	    set LnewAli [Mafft_AddSequences $aliTfa $addTfa]
	} else {
	    set LnewAli [Mafft_AddSequences_local $aliTfa $addTfa]
	}
	
	if {$LnewAli eq ""} {
	    if {[ModeI]} {
		FaireLire "Something went wrong while computing alignment !\nSequences will be added unaligned"
	    }
	    set DoAlign 0
	}
    }
    
    if {! $DoAlign} {
	set lgsadd [DonneMemeLongueur newS]
	set LSAddSeq [list]
	foreach n $LNAddSeq {
	    lappend LSAddSeq $newS($n)
	}
	
	
	# Ajuste longueur alignement - seq add
	set lscou [LongueurAlignement [QuelMode]]
	set d [expr {$lgsadd - $lscou}]
	set add [string repeat "." [expr {abs($d)}]]
	if {$d < 0} {
	    # added sequences are shorter
	    set Ltmp [list]
	    foreach n $LNAddSeq s $LSAddSeq {
		append s $add
		set newS($n) $s
		lappend Ltmp $s
	    }
	    set LSAddSeq $Ltmp
	} elseif {$d > 0} {
	    # added sequences are longer
	    # -> adjust alignment sequences
	    set LongueurTotale $lgsadd
	    set Lnew [list]
	    foreach s $LSeqsAli {
		if {[string trim $s] ne ""} {
		    append s $add
		}
		lappend Lnew $s
	    }
	    set LSeqsAli $Lnew
	}
    } else {
	# sequences aligned by MAFFT
	DecortiqueUnTFA $LnewAli LNAligned SAligned
	# record aligned sequences
	set Lnew [list]
	set Ltmp [list]
	set Lall [concat $LNomsAli $LNAddSeq]
	foreach n $Lall {
	    if {$n eq ""} {
		set s ""
	    } else {
		set s $SAligned($n)
	    }

	    if {$n in $LNAddSeq} {
		lappend Ltmp $s
	    } else {
		lappend Lnew $s
	    }
	}
	set LSeqsAli $Lnew
	set LSAddSeq $Ltmp
    }
	
    # On traite les PDB ajoutes
    set ix -1
    set BadPDB [list]
    set Sprsde [list]
    foreach s $LNAddSeq {
	incr ix
	if {! [EstUnAccessPDB $s]} {
	    continue
	}
	
	set pdbid [DonneIdDeAccessPDB $s]
	set chn   [DonneChainDeAccessPDB $s]
	
	if {$pdbid ni [info commands]} {
	    set cok [LoadNouveauPDB $pdbid]
	    if {$cok == 0} {
		lappend BadPDB $ix
		continue
	    } elseif {$cok != 1} {
		# superseeded name ! 
		# Should change
		set nwnm $cok
		set cok 1
		lappend Sprsde [list $nwnm $ix]
	    }
	}
	lappend ListePDB $s
    }
    
    # Bad PDBs
    foreach i [lsort -integer -decreasing $BadPDB] {
	set e [lindex $LNAddSeq $i]
	set Molid [DonneIdDeAccessPDB $e]
	set Chn   [DonneChainDeAccessPDB $e]
	set newe "bsq${Molid}_$Chn"
	lset LNAddSeq $i $newe
    }

    # Superseeded names
    foreach e [lsort -integer -decreasing -index 1 $Sprsde] {
	lassign $e nwnm i
	set old [lindex $LNAddSeq $i]
	set Molid $nwnm
	set Chn   [DonneChainDeAccessPDB $old]
	set newe [BonNomPDB ${Molid}_$Chn]
	lset LNAddSeq $i $newe
    }

    # sequences have been checked
    # initialise new seqs, and insert them
    InitInfoSeqs $LNAddSeq
    
    # insertion of new sequences
    if {$TAddS(Position) eq "cluster"} {
	# choose closest cluster to insert 
	# each new sequence
	lassign [InsertionSequencesDansGroupes $LNomsAli $LSeqsAli $LNAddSeq $LSAddSeq] LNomsAli LSeqsAli
    } else {
	if {$TAddS(Position) eq "afterseq"} {
	    set i [lsearch -exact $LNomsAli $TAddS(seqInsert)]
	} else {
	    set i "end"
	}
	lassign [InsertionSequencesAPosition $LNomsAli $LSeqsAli $LNAddSeq $LSAddSeq $i] LNomsAli LSeqsAli
    }
    
    # recreate lists according to mode
    if {[QuelMode] ne "seqlab"} {
	set LNOrdali $LNomsAli
	set LSOrdali $LSeqsAli
	unset -nocomplain Sequences
	foreach n $LNOrdali s $LSOrdali {
	    if {$n ne ""} {
		set Sequences($n) $s
	    }
	}
    } else {
	set LNSeqlab $LNomsAli
	set LSSeqlab [list]
	foreach n $LNomsAli s $LSeqsAli {
	    lappend LSSeqlab [split $s ""]
	}
    }

    InitPosSeqGenGenSeq
    InfosDesPDB
    
    # Calculs divers
    AssigneLesPoids
    TraiteAABizarres
    CalculeLength
    CalculeComposition
    CalculePI
    CalculeMolecularWeight
    
    # Update Fenetre alignement
    MetAJourGroupes
    if {[QuelMode] ne "seqlab"} {
	set WdtNom [PlusLongEltDe $LNOrdali]
	InitWRegle
	AfficheRegle
    } else {
	set WdtNom [PlusLongEltDe $LNSeqlab]
	set y [expr {$y-1}]
	$::NomTextSeq addseqs $LIN $y
    }
    
    if {$WdtNom > $::Defauts(LongNom)} {
	LesDefauts LongNom $WdtNom
    }
    if {[info exists ::NomNomSeq]} { 
	$::NomNomSeq configure -width $WdtNom 
    }
    
    ChangeNomsAff $::Defauts(NomsAffiches)
    AfficheNomsEtSeqs
    RepeintNomsEtSeqs
    update idletasks
    
    # remet ascenceur
    if {$yscr!=""} { CoupleY moveto $yscr }
    
    FaireLaSuite

    return

}

proc AjouteSpaceSeq {} {

    global LNSeqlab LSSeqlab LNOrdali LSOrdali NomTextSeq NomNomSeq NomSeqSel Defauts TScrollY

    if {[TypeAli] eq "pasdali"} {return}
    if {[llength $NomSeqSel] != 1} {
	FaireLire "Please select one sequence below\nwhich a separator should be inserted !"
	return
    }

    # strore Y-scroll position
    lassign [$TScrollY get] ysc tmp

    lassign [split $NomSeqSel .] y x 
    set i [expr {$y+1}]
    $NomNomSeq  configure -state normal
    $NomNomSeq  insert $i.0 "\n"
    $NomNomSeq  configure -state disabled

    if {[QuelMode] ne "seqlab"} {
	VueEditee 1
	$NomTextSeq configure -state normal
	$NomTextSeq insert $i.0 "\n"
	$NomTextSeq configure -state disabled

	set LNOrdali [linsert $LNOrdali $y {}]
	set LSOrdali [linsert $LSOrdali $y {}]
    } else {
	set LNSeqlab [linsert $LNSeqlab $y {}]
	set LSSeqlab [linsert $LSSeqlab $y {}]

	# Insert AFTER Index ...
	$NomTextSeq insert rows [expr {$y-1}] 1
    }

    MetAJourGroupes
    #ChangeNomsAff $Defauts(NomsAffiches)
    #AfficheNomsEtSeqs
    #RepeintNomsEtSeqs

    # re-position at original Y
    CoupleY moveto $ysc

    return

}

proc AjouteUnGraph {K FichierQuery XDebutQuery XFinQuery YDebutGraph YFinGraph OneNtPixel} {


    
    Wup "Ajoute un graph a un canvas"
    Wup "Ex Id et NbSeq lie au blastn et Tm et GC lie a une sequence donnee"
    
    set AvecTm        0
    set AvecGC        0
    set AvecId        0
    set AvecNbSeq     0
    set AvecTmNN      0
    set AvecTmWallace 0
    set AvecTmDNADNA  0
    set AvecTmDNARNA  0
    set AvecTmRNARNA  0
    set TmDefault    ""

    FaireLire "Choose between available graph to add."
    set  LesChoix [EntreDeux [list TmNN TmWallace TmDNADNA TmDNARNA TmRNARNA GC Id NbSeq]]
    if {$LesChoix == ""} {return ""}
    #On recupere la methode de Tm par defaut choisie et on la remet apres
    if {[regexp -nocase "tm" $LesChoix]} {set TmDefault [LesParametresDuDesign TmMethod "LaValeurMerci"]}

    foreach Choix $LesChoix {
	if {$Choix=="TmNN"}      {set AvecTm    1;set AvecTmNN      1}
	if {$Choix=="TmWallace"} {set AvecTm    1;set AvecTmWallace 1}
	if {$Choix=="TmDNADNA"}  {set AvecTm    1;set AvecTmDNADNA  1}
	if {$Choix=="TmDNARNA"}  {set AvecTm    1;set AvecTmDNARNA  1}
	if {$Choix=="TmRNARNA"}  {set AvecTm    1;set AvecTmRNARNA  1}
	if {$Choix=="GC"}        {set AvecGC    1}
	if {$Choix=="Id"}        {set AvecId    1}
	if {$Choix=="NbSeq"}     {set AvecNbSeq 1}
    }
    
    if {$AvecNbSeq || $AvecId} {
	set FichierBlastN ""
	set MesBlasts     "" 
	
	set PAB           "[file tail $FichierQuery]"
	regsub {.[a-zA-Z]+$} $PAB "" PAB

	set MesBlasts [LesInfosDe $K MesBlasts]
	while {1} {
	    if {[OuiOuNon "We need a related blastn file to build graph.\nCan I use one of these blasts ?\n$MesBlasts"]} {
		set FichierBlastN [ChoixParmi $MesBlasts]
		if {! [regexp -nocase $PAB $FichierBlastN]} {
		    FaireLire "Choose a correct blastn file according to your query sequence"
		} else {break}
		if {![OuiOuNon "Do you want to continue ?"]} {break}
	    } else {
		break
	    } 
	}
	if {$FichierBlastN=="" || ! [file exists $FichierBlastN]} {
	    FaireLire "Choose a blastn file to add two new graph to display."
	    while {1} {
		#Les types de fichier autorises
		set types {
		    {{Blastn Files} {.blastn}}
		    {{All Files}    *        }
		}
		set FichierBlastN [tk_getOpenFile -title "Choose a blastn file" -initialdir "[RepertoireDuGenome]" -filetypes $types]
		if {! [regexp -nocase $PAB $FichierBlastN]} {
		    FaireLire "Choose a correct blastn file according to your query sequence"
		} else {break}
		if {![OuiOuNon "Do you want to continue ?"]} {return ""}
	    }  
	}
	if {[file exists $FichierBlastN]} {
	    if {$AvecId} {
		#Affichage du Id content du blast
		set IdDuGraph ""
		while {1} {
		    if {[$K find withtag "Id$IdDuGraph"] != ""} {
			if {$IdDuGraph == ""} {set IdDuGraph 1} else {incr IdDuGraph}
		    } else {break}
		}
		set  IdResults [PosEtPIdAligneeDeLaRegion $FichierBlastN] 
		if {$IdResults !=""} {
		    AfficheLeSpectreIdDUneListe $K $IdResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "red" "Id$IdDuGraph"
		}
	    }
	    if {$AvecNbSeq} {
		#Affichage du nb de sequence du blast
		set IdDuGraph ""
		while {1} {
		    if {[$K find withtag "NbSeq$IdDuGraph"] != ""} {
			if {$IdDuGraph == ""} {set IdDuGraph 1} else {incr IdDuGraph}
		    } else {break}
		}
		set  NbSeqResults [PosEtNbSequenceAligneeDeLaRegion $FichierBlastN] 
		if {$NbSeqResults !=""} {
		    AfficheLeSpectreNbSequenceDUneListe $K $NbSeqResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "deepskyblue2" "NbSeq$IdDuGraph"
		}
	    }
	    UnsetLesTableauxDesGraphAvecBlast
	}
    }
    if {$AvecGC || $AvecTm} {
	set SeqQuery       [QueLaSequenceDuFichierTFA $FichierQuery]
	if {$SeqQuery==""} {Espionne "$FichierQuery no sequence available";return ""}
	set TailleQueryNt  [string length $SeqQuery]
    }
    if {$AvecTm && $AvecTmNN && [$K find withtag {"OligoGraph" && "TmNN"}] == ""} {
	LesParametresDuDesign TmMethod "NearestNeighbor" "Positionne"
	#Affichage du Tm content
	set  TmResults [PosEtTmDeLaRegion $SeqQuery $TailleQueryNt] 
	if {$TmResults !=""} {
	    AfficheLeSpectreTmDUneListe $K $TmResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "orange" "TmNN"
	}
    }
    if {$AvecTm && $AvecTmWallace && [$K find withtag {"OligoGraph" && "TmWallace"}] == ""} {
	LesParametresDuDesign TmMethod "Wallace" "Positionne"
	#Affichage du Tm content
	set  TmResults [PosEtTmDeLaRegion $SeqQuery $TailleQueryNt] 
	if {$TmResults !=""} {
	    AfficheLeSpectreTmDUneListe $K $TmResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "orange1" "TmWallace"
	}
    }
    if {$AvecTm && $AvecTmDNADNA && [$K find withtag {"OligoGraph" && "TmDNADNA"}] == ""} {
	LesParametresDuDesign TmMethod "DNADNA" "Positionne"
	#Affichage du Tm content
	set  TmResults [PosEtTmDeLaRegion $SeqQuery $TailleQueryNt] 
	if {$TmResults !=""} {
	    AfficheLeSpectreTmDUneListe $K $TmResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "orange2" "TmDNADNA"
	}
    }
    if {$AvecTm && $AvecTmDNARNA && [$K find withtag {"OligoGraph" && "TmDNARNA"}] == ""} {
	LesParametresDuDesign TmMethod "DNARNA" "Positionne"
	#Affichage du Tm content
	set  TmResults [PosEtTmDeLaRegion $SeqQuery $TailleQueryNt] 
	if {$TmResults !=""} {
	    AfficheLeSpectreTmDUneListe $K $TmResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "orange3" "TmDNARNA"
	}
    }
    if {$AvecTm && $AvecTmRNARNA && [$K find withtag {"OligoGraph" && "TmRNARNA"}] == ""} {
	LesParametresDuDesign TmMethod "RNARNA" "Positionne"
	#Affichage du Tm content
	set  TmResults [PosEtTmDeLaRegion $SeqQuery $TailleQueryNt] 
	if {$TmResults !=""} {
	    AfficheLeSpectreTmDUneListe $K $TmResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel "orange4" "TmRNARNA"
	}
    }
    if {$AvecGC && [$K find withtag {"OligoGraph" && "GC"}] == ""} {
	#Affichage du GC content
	set  GCResults [PosEtGCDeLaRegion $SeqQuery $TailleQueryNt]
	if {$GCResults !=""} {
	    AfficheLeSpectreGCDUneListe $K $GCResults  $XDebutQuery $XFinQuery  $YDebutGraph $YFinGraph $OneNtPixel
	}
    }
    
    #On recupere la methode de Tm par defaut choisie et on la remet apres
    LesParametresDuDesign TmMethod $TmDefault "Positionne"

    return ""


}

proc AjouteUnLien {Fichier_html {Texte ""} {URL ""}} {


    if {$Texte=="" || $URL==""}  {return}
    set Ref [Html_Href $URL $Texte]
    set Page [ContenuDuFichierAvecReferences $Fichier_html $Texte $Ref]
    return $Page


}

proc AjouteUnOligoPourCeuxDejaFait {PAB1 PAB2 Dir1 Dir2 Quoi} {


    
    Wup "Ajoute un oligo a la liste de ceux deja designe de dir1 a dir2"
    Wup "Cas particulier pour un redesign et completer la liste ou faire un update de l oligo"
    Wup "Quoi peut etre ref de oligo ou coordonnees debut fin"
    Wup "Rq: on teste si un oligo existe deja si oui on propose de changer de nom ou pas (update ou pas)"

    set FichierACharger1 "$Dir1/${PAB1}.oligo"
    set FichierACharger2 "$Dir2/${PAB2}.oligo"
    set NomAncienOligo   ""
    
    #Espionne ">>>>Try to complete $PAB1 with $Quoi<<<<"
    
    #Liste des oligos a partir de laquelle on va en rajouter un
    set  LesOligos1 [InterrogeInfoDeLOligo $FichierACharger1 LesNoms]
    if {$LesOligos1 == ""} {
	if {[InterrogeInfoDeLOligo $FichierACharger1 NotDone]=="1"} {
	    #Oligo non calcules
	    Espionne "Try to complete $PAB1 but no Oligo yet designed in $Dir1"
	    return ""
	} elseif {[InterrogeInfoDeLOligo $FichierACharger1 NoOligo]=="1"} {
	    #Oligo non trouves
	    Espionne "Try to complete $PAB1 but no Oligo found"
	    return ""
	} else {Espionne "Petit probleme";return ""}
    }

    #Liste des oligos auquel on veut en rajouter un
    set  LesOligos2 [InterrogeInfoDeLOligo $FichierACharger2 LesNoms]
    if {$LesOligos2 == ""} {
	if {[InterrogeInfoDeLOligo $FichierACharger2 NotDone]=="1"} {
	    #Oligo non calcules
	    Espionne "Try to complete $PAB2 but no Oligo yet designed in $Dir2"
	    return ""
	} elseif {[InterrogeInfoDeLOligo $FichierACharger2 NoOligo]=="1"} {
	    #Oligo non trouves
	    Espionne "Try to complete $PAB2 but no Oligo found"
	    return ""
	} else {Espionne "Petit probleme";return ""}
    }

    #Le nom de l oligo a ajouter
    set     LeNomOligo ""
    if {[llength $Quoi]>1} {
	set LeNomOligo [InterrogeInfoDeLOligo $FichierACharger1 [lindex $Quoi 0] [lindex $Quoi 1] NomOligo]
    } else {
	set LeNomOligo $Quoi
    }

    if {          $LeNomOligo  == ""}        {return ""}
    if {![regexp "$LeNomOligo" $LesOligos1]} {Espionne "No $LeNomOligo in $FichierACharger1";return ""}

    #On recupere les infos de l oligo a ajouter
    set Debut     [InterrogeInfoDeLOligo $FichierACharger1 $LeNomOligo Debut]
    set Fin       [InterrogeInfoDeLOligo $FichierACharger1 $LeNomOligo Fin]
    set Selection [join [ExtraitOligoDuTFA $PAB1 $LeNomOligo $Dir1] "\n"]

    #On teste dans la vieille liste si il existe deja
    if {[InterrogeInfoDeLOligo $FichierACharger2 $Debut $Fin NomOligo]!=""} {
	if {! [OuiOuNon "The Oligo for $Debut $Fin already exists\nDo I replace it ?"]} {return ""}
	set NomAncienOligo [InterrogeInfoDeLOligo $FichierACharger2 $Debut $Fin NomOligo]
	
	#On peut decider de faire un update simplement en gardant le nom de l oligo
	if {! [OuiOuNon "Should I keep the previous oligo reference (name) ?\n(Yes just for properties update)"]} {set NomAncienOligo ""}
	SupprimeUnOligoPourCeuxDejaFait $FichierACharger2 [InterrogeInfoDeLOligo $FichierACharger2 $Debut $Fin NomOligo]
	#SupprimeLeLogFileDeLOligo "$Debut $Fin" "$Dir2/${PAB2}.log"
    }

    #On change ou pas le nom de l oligo a ajouter (ou updater)
    set OldNom $LeNomOligo
    if {$NomAncienOligo!=""} {
	#On conserve le nom de l ancien oligo (juste un update)
	set LeNomOligo $NomAncienOligo
    } else {
	#On change le nom si il existe deja on incremente
	while {1} {
	    if {[regexp $LeNomOligo $LesOligos2]} {	
		regexp {Oligo([0-9]+)_} $LeNomOligo tmp Nb
		set OldNb $Nb
		incr Nb
		regsub "${OldNb}_" $LeNomOligo "${Nb}_" LeNomOligo
	    } else {break} 
	}
    }
    #Espionne "Ancien $OldNom -- Nouveau $LeNomOligo"
    regsub "$OldNom" $Selection "$LeNomOligo" Selection

    AppendAuFichier $FichierACharger2 $Selection
    #Espionne ">>>>Adding<<<<" 
    #Espionne "$Selection"
    #Espionne ">>>>>>To<<<<<<" 
    #Espionne "$FichierACharger2\n"
    return ""


}

proc AjouteUnOligoPourCeuxDejaFaitAuFichier {FichierACharger1 FichierACharger2 Quoi} {


    
    Wup "WARNING PROC NON TESTEES"

    Wup "Ajoute un oligo a la liste de ceux deja designe de dir1 a dir2"
    Wup "Cas particulier pour un redesign et completer la liste"
    Wup "Quoi peut etre ref de oligo ou coordonnees debut fin"

    #set FichierACharger1 "$Dir1/${PAB1}.oligo"
    #set FichierACharger2 "$Dir2/${PAB2}.oligo"

    set PAB1 [file tail $FichierACharger1]
    if {[regexp {\.[a-z]{3,}$} $PAB1]} {regsub {\.[a-z]{3,}$} $PAB1 "" PAB1}
    set Dir1 [file dirname $FichierACharger1]

    Espionne "$FichierACharger1 $PAB1 $Dir1"
    return ""
    Espionne ">>>>Try to complete $PAB1 with $Quoi<<<<"
    
    set  LesOligos1 [InterrogeInfoDeLOligo $FichierACharger1 LesNoms]
    if {$LesOligos1 == ""} {
	if {[InterrogeInfoDeLOligo $FichierACharger1 NotDone]=="1"} {
	    #Oligo non calcules
	    Espionne "Try to complete $PAB1 but no Oligo yet designed in $Dir1"
	    return ""
	} elseif {[InterrogeInfoDeLOligo $FichierACharger1 NoOligo]=="1"} {
	    #Oligo non trouves
	    Espionne "Try to complete $PAB1 but no Oligo found"
	    return ""
	} else {Espionne "Petit probleme";return ""}
    }

    set  LesOligos2 [InterrogeInfoDeLOligo $FichierACharger2 LesNoms]
    if {$LesOligos2 == ""} {
	if {[InterrogeInfoDeLOligo $FichierACharger2 NotDone]=="1"} {
	    #Oligo non calcules
	    Espionne "Try to complete $PAB2 but no Oligo yet designed in $Dir2"
	    return ""
	} elseif {[InterrogeInfoDeLOligo $FichierACharger2 NoOligo]=="1"} {
	    #Oligo non trouves
	    Espionne "Try to complete $PAB2 but no Oligo found"
	    return ""
	} else {Espionne "Petit probleme";return ""}
    }

    set     LeNomOligo ""
    if {[llength $Quoi]>1} {
	set LeNomOligo [InterrogeInfoDeLOligo $FichierACharger1 [lindex $Quoi 0] [lindex $Quoi 1] NomOligo]
    } else {
	set LeNomOligo $Quoi
    }

    #Espionne "Quoi $Quoi - NomOligo $LeNomOligo"

    if {          $LeNomOligo  == ""}        {return ""}
    if {![regexp "$LeNomOligo" $LesOligos1]} {Espionne "No $LeNomOligo in $FichierACharger1";return ""}

    set Debut     [InterrogeInfoDeLOligo $FichierACharger1 $LeNomOligo Debut]
    set Fin       [InterrogeInfoDeLOligo $FichierACharger1 $LeNomOligo Fin]
    #set Selection [join [ExtraitOligoDuTFA $PAB1 $LeNomOligo $Dir1] "\n"]
    set Selection [join [ExtraitOligoDuTFA2 $PAB $LeNomOligo $Dir1 [file tail $FichierACharger1]] "\n"]

    if {[InterrogeInfoDeLOligo $FichierACharger2 $Debut $Fin NomOligo]!=""} {
	if {! [OuiOuNon "Oligo for $Debut $Fin already exists\nDo I replace it ?"]} {return ""}
	set NomAncienOligo [InterrogeInfoDeLOligo $FichierACharger2 $Debut $Fin NomOligo]
	SupprimeUnOligoPourCeuxDejaFait $FichierACharger2 $NomAncienOligo
	#SupprimeLeLogFileDeLOligo "$Debut $Fin" "$Dir2/${PAB2}.log"
    }
    
    set OldNom $LeNomOligo
    #Espionne "NomOligo $LeNomOligo - OldNom $LeNomOligo"
    while {1} {
	if {[regexp $LeNomOligo $LesOligos2]} {	
	    #Espionne "NOmOligo $LeNomOligo - $LesOligos2"

	    regexp {Oligo([0-9]+)_} $LeNomOligo tmp Nb
	    #Espionne "NOmOligo $LeNomOligo - $tmp - $Nb"
	    set OldNb $Nb
	    incr Nb
	    regsub "${OldNb}_" $LeNomOligo "${Nb}_" LeNomOligo
	} else {break} 
    }
    regsub "$OldNom" $Selection "$LeNomOligo" Selection

    Espionne "Ajoute a $FichierACharger2 $Selection"
    #AppendAuFichier $FichierACharger2 $Selection
    
    #Espionne ">>>>Adding<<<<" 
    #Espionne "$Selection"
    #Espionne ">>>>>>To<<<<<<" 
    #Espionne "$FichierACharger2\n"

    Espionne "SupprimeUnOligoPourCeuxDejaFait $FichierACharger1 $OldNom"
    Espionne "Ajoute a $FichierACharger1 $Selection"

    #SupprimeUnOligoPourCeuxDejaFait $FichierACharger1 $OldNom 
    #AppendAuFichier $FichierACharger1 $Selection
    
    return ""


}

proc AjouteUnUnderscore {Mot Position} {


    set LesLettres [split $Mot ""]
    set LeMotAvecUnderscore [linsert $LesLettres $Position  "_"]
    set MotAvecUnderscore [join $LeMotAvecUnderscore ""]
    return $MotAvecUnderscore


}

proc AjusteAngles {AId n} {

    global Abr sum

    set t [set Abr(Arbre,$AId)]
    if {[$t isleaf $n]} {return $sum}
    if {$n eq "root"} {
	AjusteAnglesRoot $AId root
	return $sum
    }

    set RR [$t get $n RightR]
    set RR [expr {$RR>[Pi]?$RR-[2Pi]:$RR}]
    set RL [$t get $n RightL]
    set RL [expr {$RL>[Pi]?$RL-[2Pi]:$RL}]
    set LR [$t get $n LeftR]
    set LR [expr {$LR>[Pi]?$LR-[2Pi]:$LR}]
    set LL [$t get $n LeftL]
    set LL [expr {$LL>[Pi]?$LL-[2Pi]:$LL}]
    set AR [$t get $n AncesR]
    set AR [expr {$AR>[Pi]?$AR-[2Pi]:$AR}]
    set AL [$t get $n AncesL]
    set AL [expr {$AL>[Pi]?$AL-[2Pi]:$AL}]
    set NdRight [$t get $n NdRight]
    set NdLeft  [$t get $n NdLeft]
    set LRLL [$t get $n LRLL]
    set RRRL [$t get $n RRRL]

    if {abs($RL-$AL) < $RRRL} {
	set RRAL 0.
    } else {
	set RRAL [expr {abs($RR-$AL)}]
	set RRAL [expr {$RRAL>[Pi]?[2Pi]-$RRAL:$RRAL}]
    }
    if {abs($LL-$RL) < $LRLL} {
	set LRRL 0.
    } else {
	set LRRL [expr {abs($LR-$RL)}]
	set LRRL [expr {$LRRL>[Pi]?[2Pi]-$LRRL:$LRRL}]
    }
    if {$LRLL > abs($LR-$AR)} {
	set ARLL 0.
    } else {
	set ARLL [expr {abs($AR-$LL)}]
	set ARLL [expr {$ARLL>[Pi]?[2Pi]-$ARLL:$ARLL}]
    }

    set AngVide [expr {$LRRL + $ARLL + $RRAL}]
    set angeq [expr {$AngVide/3.}]
    set DecTot [expr {abs($angeq-$RRAL) + abs($angeq-$LRRL) + abs($angeq-$ARLL)}]
    set sum [expr {$sum + $DecTot}]

    set tilt1 [expr {$angeq-$RRAL}]
    TiltArbre $AId $n $NdRight $tilt1

    if {$tilt1 < 0.} {
	set LRRL [expr {$LRRL+abs($tilt1)}]
    } else {
	set LRRL [expr {$LRRL-abs($tilt1)}]
    }
    set tilt2 [expr {$angeq-$LRRL}]
    TiltArbre $AId $n $NdLeft $tilt2

    puts "----- Ajsutement --------"
    puts "$n | R $NdRight | L $NdLeft"
    puts [format "RRAL %5.2f RR %5.2f AL %5.2f" $RRAL $RR $AL]
    puts [format "LRRL %5.2f LR %5.2f RL %5.2f" $LRRL $LR $RL]
    puts [format "ARLL %5.2f AR %5.2f LL %5.2f" $ARLL $AR $LL]
    puts [format "Ang Egaux : %6.2f Decal %6.2f" $angeq $DecTot]
    puts [format "tilt RRAL : %6.2f | LRRL %6.2f" $tilt1 $tilt2]
    puts [format "nRRAL %6.2f nLRRL %6.2f" [expr {$RRAL+$tilt1}] [expr {$LRRL+$tilt2}]]
    puts ""

    return $sum

}

proc AjusteAngles2 {AId n} {

    global Abr sum PVmL PVmR

    set t [set Abr(Arbre,$AId)]
    if {[$t isleaf $n]} {return $sum}
    if {$n eq "root"} {
	AjusteAnglesRoot $AId root
	return $sum
    }

    set xn [$t get $n xcoord]
    set yn [$t get $n ycoord]

    set p [$t parent $n]
    set xp [$t get $p xcoord]
    set yp [$t get $p ycoord]
    if {$xn == $xp && $yn == $yp} {
	lassign [$t children $p] e1 e2
	if {$n eq $e1} {set p $e2} {set p $e1}
	set xp [$t get $p xcoord]
	set yp [$t get $p ycoord]
    }

    set NdMaxRight [$t get $n NdRight]
    set NdMaxLeft  [$t get $n NdLeft]
    set NdAncesL   [$t get $n NdAncesL]
    set NdAncesR   [$t get $n NdAncesR]

    lassign [$t children $n] e1 e2
    if {[lsearch [concat $e1 [$t descendants $e1]] $NdMaxRight] != -1} {
	set NdR $e1
	set NdL $e2
    } else {
	set NdR $e2
	set NdL $e1
    }
    puts "NdR $NdR"
    puts "NdL $NdL"
    set NRR [$t get $NdR NdRight]
    set NRL [$t get $NdR NdLeft]
    set NLR [$t get $NdL NdRight]
    set NLL [$t get $NdL NdLeft]
    puts "NRR $NRR NRL $NRL"
    puts "NLR $NLR NLL $NLL"

    if {0} {
	set Ln [concat $NdR [$t descendants $NdR]]
	if {[llength $Ln] == 1} {
	    set NRL $Ln
	    set NRR $Ln
	} else {
	    lassign [NoeudLRDe $AId $n $p $Ln] NRL NRR
	}
    }

    set x1 [$t get $NRL xcoord]
    set y1 [$t get $NRL ycoord]
    set RL [Coords2Angle [expr {$x1-$xn}] [expr {$y1-$yn}]]

    if {0} {
	set Ln [concat $NdL [$t descendants $NdL]]
	if {[llength $Ln] == 1} {
	    set NLL $Ln
	    set NLR $Ln
	} else {
	    lassign [NoeudLRDe $AId $n $p $Ln] NLL NLR
	}
    }
    set x2 [$t get $NLR xcoord]
    set y2 [$t get $NLR ycoord]
    set LR [Coords2Angle [expr {$x2-$xn}] [expr {$y2-$yn}]]

    set LL [$t get $n LeftA]
    while {$LL > [2Pi]} {set LL [expr {$LL - [2Pi]}]}
    set RR [$t get $n RightA]
    while {$RR > [2Pi]} {set RR [expr {$RR - [2Pi]}]}

    set AL [$t get $n AncesL]
    set AR [$t get $n AncesR]

    foreach v {RR RL LR LL AL AR} {
	set $v [expr {[set $v]>[Pi]?[set $v]-[2Pi]:[set $v]}]
    }

    set RRAL [expr {$RR-$AL}]
    if {$RRAL < 0.} {set RRAL [expr {[2Pi]+$RRAL}]}
    set RRAL [expr {$RRAL>[Pi]?[2Pi]-$RRAL:$RRAL}]

    set LRRL [expr {$LR-$RL}]
    if {$LRRL < 0.} {set LRRL [expr {[2Pi]+$LRRL}]}
    set LRRL [expr {$LRRL>[Pi]?[2Pi]-$LRRL:$LRRL}]

    set ARLL [expr {$AR-$LL}]
    if {$ARLL < 0.} {set ARLL [expr {[2Pi]+$ARLL}]}
    set ARLL [expr {$ARLL>[Pi]?[2Pi]-$ARLL:$ARLL}]

    set AngVide [expr {$LRRL + $ARLL + $RRAL}]
    set angeq [expr {$AngVide/3.}]
    set DecTot [expr {abs($angeq-$RRAL) + abs($angeq-$LRRL) + abs($angeq-$ARLL)}]
    set sum [expr {$sum + $DecTot}]

    set tilt1 [expr {$angeq-$RRAL}]
    TiltArbre $AId $n $NdR $tilt1

    if {$tilt1 < 0.} {
	set LRRL [expr {$LRRL+abs($tilt1)}]
    } else {
	set LRRL [expr {$LRRL-abs($tilt1)}]
    }
    set tilt2 [expr {$angeq-$LRRL}]
    TiltArbre $AId $n $NdL $tilt2

    puts "----- Ajsutement --------"
    puts "$n | R $NdR | L $NdL"
    puts [format "Nd RR %6.3f %s Nd RL %6.3f %s" $RR $NRR $RL $NRL]
    puts [format "Nd LR %6.3f %s Nd LL %6.3f %s" $LR $NLR $LL $NLL]
    puts [format "Nd AL %6.3f %s Nd AR %6.3f %s" $AL $NdAncesL $AR $NdAncesR]
    puts [format "RRAL %6.3f RR %6.3f AL %6.3f" $RRAL $RR $AL]
    puts [format "LRRL %6.3f LR %6.3f RL %6.3f" $LRRL $LR $RL]
    puts [format "ARLL %6.3f AR %6.3f LL %6.3f" $ARLL $AR $LL]
    puts [format "Ang Egaux : %6.3f Decal %6.3f" $angeq $DecTot]
    puts [format "tilt RRAL : %6.3f | LRRL %6.3f" $tilt1 $tilt2]
    puts [format "nRRAL %6.3f nLRRL %6.3f" [expr {$RRAL+$tilt1}] [expr {$LRRL+$tilt2}]]

    return $sum

}

proc AjusteAnglesRoot {AId n} {

    global Abr sum

    set t [set Abr(Arbre,$AId)]
    set xp [$t get $n xcoord]
    set yp [$t get $n ycoord]
    lassign [$t children $n] e1 e2

    set x [$t get $e1 xcoord]
    set y [$t get $e1 ycoord]
    if {$x == $xp && $y == $yp} {set p $e2} {set p $e1}

    if {! [$t isleaf $e1]} {
	set Ln [concat $e1 [$t descendants $e1]]
	lassign [NoeudLRDe $AId $e1 $p $Ln] NL1 NR1 
    } else {
	set NL1 $e1
	set NR1 $e1
    }

    if {! [$t isleaf $e2]} {
	set Ln [concat $e2 [$t descendants $e2]]
	lassign [NoeudLRDe $AId $e2 $p $Ln] NL2 NR2
    } else {
	set NR2 $e2
	set NL2 $e2
    }
    lassign [OverlapBranch $AId $NL1 $NR1 $NL2 $NR2] o1 o2 
    #    puts "OverlapBranch $o1 $o2"

    set R1 [$t get $e1 RightA]
    set L1 [$t get $e1 LeftA]
    set R2 [$t get $e2 RightA]
    set L2 [$t get $e2 LeftA]
    foreach v {R1 L1 R2 L2} {
	while {[set $v] > [2Pi]} {set $v [expr {[set $v]-[2Pi]}]}
	set $v [expr {[set $v]>[Pi]?[set $v]-[2Pi]:[set $v]}]
    }

    set L1R2 [expr {abs($L1-$R2)}]
    if {$L1R2 > [Pi]} {set L1R2 [expr {[2Pi]-$L1R2}]}

    set L2R1 [expr {abs($L2-$R1)}]
    if {$L2R1 > [Pi]} {set L2R1 [expr {[2Pi]-$L2R1}]}

    set AngVide [expr {$L1R2 + $L2R1}]
    set angeq [expr {$AngVide/2.}]
    set DecTot [expr {abs($angeq-$L1R2) + abs($angeq-$L2R1)}]
    set sum [expr {$sum + $DecTot}]

    if {[$t size $e1] < [$t size $e2]} {
	set AngT $L1R2
	set NdT $e1
    } else {
	set AngT $L2R1
	set NdT $e2
    }
    set tilt1 [expr {$angeq-$AngT}]
    TiltArbre $AId root $NdT $tilt1

    puts "----- ROOT Ajsutement --------"
    puts "$n | E1 $e1 | E2 $e2"
    puts [format "L1R2 %6.3f L1 %6.3f L2 %6.3f" $L1R2 $L1 $R2]
    puts [format "L2R1 %6.3f L2 %6.3f R1 %6.3f" $L2R1 $L2 $R1]
    puts [format "Ang Egaux : %6.3f Decal %6.3f" $angeq $DecTot]
    puts [format "tilt LRRL : %6.3f Nd tilt %s" $tilt1 $NdT]
    puts [format "nAngT %6.3f" [expr {$AngT+$tilt1}]]

    return $sum

}

proc AjusteCoordonneesInit {AId} {

    global Abr

    set t   [set Abr(Arbre,$AId)]
    set PWd [set Abr($AId,PADWdt)]
    set PHg [set Abr($AId,PADHgt)]
    set Wdt [set Abr($AId,FWidth)]
    set Hgt [set Abr($AId,FHeight)]
    set LongNom [PlusLongNomAff $AId]

    if {! [info exists Abr($AId,DMult)]} {
	#	set mult [expr {($Wdt-2*$LongNom)/[set Abr($AId,Dmax)]}]
	set mult [expr {($Wdt-2*$LongNom)/[set Abr($AId,rmax)]}]
	set Abr($AId,DMult) $mult
    }

    set Xmin  99999999.
    set Ymin  99999999.
    set Xmax -99999999.
    set Ymax -99999999.
    set m [set Abr($AId,DMult)]
    foreach d [$t nodes] {
	set x [expr {[$t get $d xcoord]*$m}]
	set y [expr {[$t get $d ycoord]*$m}]
	$t set $d xdes $x
	$t set $d ydes $y

	set Xmin [expr {$Xmin<$x?$Xmin:$x}]
	set Ymin [expr {$Ymin<$y?$Ymin:$y}]
	set Xmax [expr {$Xmax>$x?$Xmax:$x}]
	set Ymax [expr {$Ymax>$y?$Ymax:$y}]
    }

    set Abr($AId,XminR) $Xmin
    set Abr($AId,YminR) $Ymin
    set Abr($AId,XmaxR) $Xmax
    set Abr($AId,YmaxR) $Ymax

    return

}

proc AjusteCoordonneesInit2 {AId} {

    global Abr

    set t   [set Abr(Arbre,$AId)]
    set PWd [set Abr($AId,PADWdt)]
    set PHg [set Abr($AId,PADHgt)]
    set Wdt [set Abr($AId,FWidth)]
    set Hgt [set Abr($AId,FHeight)]
    set sca [set Abr($AId,ScaleR)]
    set LongNom [PlusLongNomAff $AId]

    #    set HgF   [font metrics "TreeFont$AId" -linespace]
    set HgF  [font configure "TreeFont$AId" -size]
    set rmin [set Abr($AId,rmin)]
    set rmax [set Abr($AId,rmax)]
    set sang [set Abr($AId,subangleMax)]
    set mult [expr {abs($HgF/($rmax*sin($sang)))}]

    if {0} {
	puts "PWd $PWd PHg $PHg Wdt $Wdt Hgt $Hgt"
	puts "HgF $HgF"
	puts "rmin $rmin"
	puts "rmax $rmax"
	puts "sang $sang"
	puts "mult $mult"
	puts "long Nom $LongNom"
	puts ""
    }

    # Taille de arbre sans les noms au bout
    # des feuilles
    set Xmin  99999999.
    set Ymin  99999999.
    set Xmax -99999999.
    set Ymax -99999999.
    foreach d [$t nodes] {
	set x [expr {$mult*[$t get $d xcoord]}]
	set y [expr {$mult*[$t get $d ycoord]}]
	#	set x [expr {$sca*$mult*[$t get $d xcoord]+$LongNom}]
	#	set y [expr {$sca*$mult*[$t get $d ycoord]+$LongNom}]
	$t set $d xcoord $x
	$t set $d ycoord $y

	set Xmin [expr {$Xmin<$x?$Xmin:$x}]
	set Ymin [expr {$Ymin<$y?$Ymin:$y}]
	set Xmax [expr {$Xmax>$x?$Xmax:$x}]
	set Ymax [expr {$Ymax>$y?$Ymax:$y}]
    }

    if {0} {
	puts "Min/Max SANS FEUILLES"
	puts "Xmin $Xmin"
	puts "Ymin $Ymin"
	puts "Xmax $Xmax"
	puts "Ymax $Ymax"
	puts ""
    }

    # Recentre Arbre sans feuille
    foreach d [$t nodes] {
	set x [expr {[$t get $d xcoord]-$Xmin}]
	set y [expr {[$t get $d ycoord]-$Ymin}]
	$t set $d xcoord $x
	$t set $d ycoord $y
    }

    set Xmin 0.
    set Ymin 0.
    set Xmax [expr {$Xmax-$Xmin}]
    set Ymax [expr {$Ymax-$Ymin}]

    set DX [expr {$Xmax-$Xmin}]
    set DY [expr {$Ymax-$Ymin}]
    set PlacePW [expr {$PWd - 2*$LongNom}]
    set PlacePH [expr {$PHg - 2*$LongNom}]
    if {$DX > $PlacePW || $DY > $PlacePH} {
	if {$DX - $PlacePW > $DY - $PlacePH} {
	    set mult [expr {$PlacePW/$DX}]
	} else {
	    set mult [expr {$PlacePH/$DY}]
	}
    }
    set PlaceSW [expr {$Wdt - 2*$LongNom}]
    set PlaceSH [expr {$Hgt - 2*$LongNom}]
    if {$DX < $PlaceSW && $DY < $PlaceSH} {
	if {$PlaceSW-$DX > $PlaceSH-$DY} {
	    set mult [expr {$PlaceSH/$DY}]
	} else {
	    set mult [expr {$PlaceSW/$DX}]
	}
    }
    #    puts "mult apres $mult"

    set NXmin  99999999999.
    set NYmin  99999999999.
    set NXmax -99999999999.
    set NYmax -99999999999.
    foreach d [$t nodes] {
	set OldX [$t get $d xcoord]
	set OldY [$t get $d ycoord]
	set x [expr {$mult*$OldX + $LongNom}]
	set y [expr {$mult*$OldY + $LongNom}]
	$t set $d xcoord $x
	$t set $d ycoord $y
	if {[$t isleaf $d]} {
	    lassign [CoordsNom $AId $d $x $y] x y
	}

	set NXmin [expr {$NXmin<$x?$NXmin:$x}]
	set NYmin [expr {$NYmin<$y?$NYmin:$y}]
	set NXmax [expr {$NXmax>$x?$NXmax:$x}]
	set NYmax [expr {$NYmax>$y?$NYmax:$y}]
    }

    set Abr($AId,XminR) $NXmin
    set Abr($AId,YminR) $NYmin
    set Abr($AId,XmaxR) $NXmax
    set Abr($AId,YmaxR) $NYmax

    if {0} {
	puts "Abr($AId,Xmin) $Xmin"
	puts "Abr($AId,Ymin) $Ymin"
	puts "Abr($AId,Xmax) $Xmax"
	puts "Abr($AId,Ymax) $Ymax"
	puts ""
    }

    return

}

proc AjusteScrollRegion {AId} {

    global Abr

    set PAD [set Abr($AId,PAD)]
    set Lal [$PAD bbox all]
    lassign $Lal x1 y1 x2 y2
    set Dx  [expr {$x2-$x1}]
    set Dy  [expr {$y2-$y1}]
    $PAD configure -scrollregion [list $x1 $y1 $Dx $Dy]

    update idletasks

    return

}

proc AjusteXY {AId n px py {mult 1.}} {

    global Abr

    set t [set Abr(Arbre,$AId)]
    foreach xa {xO xE} ya {yO yE} {
	set x [$t get $n $xa]
	set y [$t get $n $ya]
	set nx [expr {($x+$px)*$mult}]
	set ny [expr {($y+$py)*$mult}]
	$t set $n $xa $nx
	$t set $n $ya $ny
    }

    foreach e [$t children $n] {
	AjusteXY $AId $e $px $py $mult
    }

    return

}

proc AjusteXYCart {AId n mx my {mult 1.}} {

    global Abr
    global Xmin Xmax Ymin Ymax

    set t  [set Abr(Arbre,$AId)]
    set x  [$t get $n xcoord]
    set y  [$t get $n ycoord]
    set nx [expr {(($x+abs($Xmin))*$mx)*$mult}]
    set ny [expr {(($y+abs($Ymin))*$my)*$mult}]
    $t set $n xcoord $nx
    $t set $n ycoord $ny

    set Xmin [expr {$Xmin<$nx?$Xmin:$nx}]
    set Ymin [expr {$Ymin<$ny?$Ymin:$ny}]
    set Xmax [expr {$Xmax>$nx?$Xmax:$nx}]
    set Ymax [expr {$Ymax>$ny?$Ymax:$ny}]

    foreach e [$t children $n] {
	AjusteXYCart $AId $e $mx $my $mult
    }

    return

}

proc AlA {{file ""} args} {

    global LNOrdali Sequences NbSeq Mbl LSOrdali WeightMotif Sref MotifLen Lscores WeightCols LgMax MblNeg Cbl NbSeq

    # positive si 1, matrix , scale 1.
    array set Cbl    [InitPAM35]
    array set Mbl    [InitClustalMatrix blosum62 1 1.]
    array set MblNeg [InitClustalMatrix blosum62 0 1.]

    LesDefsAlA
    
    # inits
    InitSeuils
        
    set RenameSeq   1

    # 1: poids gaussiens, 0 : 1.0 pour chqeue pos
    #InitWg 1
    InitWg 0

    AlACommandLineOptions $args
    puts "Inits done ..."
    
    set Lscores [list]
    
    set ok [SequencesPourAgent $file $RenameSeq]
    if {$ok == 0} {
	return 0
    }
    puts "Sequences :\n[join $LNOrdali \n]"

    puts "\n-------------------------"
    puts "| Score Ref : [ScoreAlignmentAgents Sref]"
    puts "-------------------------\n"
    puts "Nombre seqs   : $NbSeq"
    set LgMax 0
    foreach s $LSOrdali {
	incr LgMax [string length [string map {"." ""} $s]]
    }
    puts "Long. cumulee : $LgMax"

    #PrepareSequencesAgents
    AgentsRemoveColsGaps

    puts "Start init agents ...."
    InitAgents
    puts "done !"

    GUIAgents

    set ::iter 0

    #BruteForceAgents
    BruteForceAgents2
    #exit
    #RunAgents
    
    return 1

}

proc AlACommandLineOptions {args} {

    #puts "args $args"
    set args [lindex $args 0]
    #puts "[llength $args]"
    if {$args == "{}" } {
	return
    }

    if {[llength $args] % 2} {
	puts "Bad number of arguments ! Key-value "
	exit
    }

    foreach {key value} $args {
	switch $key {
	    "-wmotif" {
		set ::WeightMotif $value
	    }
	    "-initw" {
		InitWg $value
	    }
	    "-wcols" {
		set ::WeightCols $value
	    }
	    "-gui" {
		set ::WithGUI $value
		set ::StepMode 1
	    }
	    "-lenmotif" {
		set ::MotifLen $value
	    }
	}
    }

    return

}

proc Aleatoire {{Min 0} {Max 1}} {


    set Alea [expr round(rand() * ($Max - $Min)) + $Min]


}

proc AlgoGenet {NbIndiv NbMilliSecMax} {


    set LesPhrasesIni [LesPhrasesMemorisees]

    #genere une pop aleatoire de NbIndiv
    set LesIndividus  [InitPop $NbIndiv]

    #genere un maximum d'individu aleatoirement en NbMilliSecMax msec
    #lorsque l'un d'entre eux est meilleur que le moins bon de la pop
    #il le remplace alors
    Espionne "Old Best : [lindex [lindex $LesIndividus 0] 0]"

    set LesIndividus  [PopAleatoire  $LesIndividus $NbMilliSecMax]

    ##On ne garde que les meilleurs individus
    set LesPhrasesFinales {}
    set ScoreMax [lindex [lindex $LesIndividus 0] 0]
    foreach LIndiv $LesIndividus {
	set Score [lindex $LIndiv 0]
	if {$Score < $ScoreMax} {continue}
	lappend LesPhrasesFinales [join [lrange $LIndiv 1 end] " "]
    }

    ##On determine parmi les meilleurs celui qui est plus proche des phrases initiales
    return [MeilleurePhrase $LesPhrasesFinales $LesPhrasesIni]


}

proc AliCartoon {} {


    #rR c'est pour faire une petite animation d'un alignement (pour Renaud) 
    #rR  on part de l'alignemnet et on le des-aligne ... ;-)

    set K [UnCanva 200 1600 200 200]

    lappend Ali "..QLKIPV.YV.SLTNQTAKE"
    lappend Ali "TAQVKIQ........NQTAKE"
    lappend Ali "...VKIQVHYVDSLTNQ"

    set LargAli 0
    foreach Seq $Ali {
        set LargAli [expr max($LargAli,[string length $Seq])]
    }
    set I 0
    foreach Seq $Ali {
        set S($I) "$Seq[string repeat . [expr $LargAli-[string length $Seq]]]"
        incr I
    }

    set LesGaps {}
    foreach I [array names S] {
        set J 0
        foreach AA [split $S($I) ""] {
            if { ! [regexp {[^\.]} [string range $S($I) $J end]]} { break }
            if {$AA=="."} { lappend LesGaps "$I $J" }
            incr J
        }
    }

    set N [llength $LesGaps]
    set CSGX 20
    set CSGY [expr 20 + $N*50]

    set DeplacementY 0
    set CSGY [expr 20]

    set Tic 0
    while {1} {
        Cartoon $K S $CSGX $CSGY ;  incr CSGY $DeplacementY
        FaireLire "Au suivant"
        if {$LesGaps=={}} { break }
        set L [llength $LesGaps]
        set Z [expr round(floor(rand()) * $L)]
        lassign [lindex $LesGaps $Z] I J
        set S($I) "[string replace $S($I) $J $J]."
        set LesGaps {}
        foreach I [array names S] {
            set J 0
            foreach AA [split $S($I) ""] {
                if { ! [regexp {[^\.]} [string range $S($I) $J end]]} { break }
                if {$AA=="."} { lappend LesGaps "$I $J" }
                incr J
            }
        }
    }


}

proc AliFastaToAliBlast {AlignementFasta DQuery FQuery DSbjct FSbjct} {


    set NbCaractParLigne 60

    regsub -all ":" $AlignementFasta "\|" AlignementFasta

    set Blanc " "
    set LesLignes [split $AlignementFasta "\n"]
    set LaQuery   [split [string trim [lindex $LesLignes 0]] ""  ]
    set LesBarres [split [string trim [lindex $LesLignes 1]] ""  ]
    set LeSbjct   [split [string trim [lindex $LesLignes 2]] ""  ]

    set TailleDebut [string length [lindex [lsort -integer -decreasing [list $DQuery $DSbjct $FQuery $FSbjct]] 0]]
 
    set PremiereHomologie [lsearch $LesBarres "|"]

    set i 0
    set n $PremiereHomologie
    foreach Barre $LesBarres {
	if {$Barre  == "|"} {set n $i}   
	incr i
    }
    set DerniereHomologie $n

    set LaQuery   [lrange $LaQuery   $PremiereHomologie $DerniereHomologie]
    set LesBarres [lrange $LesBarres $PremiereHomologie $DerniereHomologie]
    set LeSbjct   [lrange $LeSbjct   $PremiereHomologie $DerniereHomologie]

    set i 0
    set AliBlast ""
    set LigneQuery   "" 
    set LigneBarres  ""
    set LigneSbjct   ""

    set DQ $DQuery
    set DS $DSbjct

    foreach ANQuery $LaQuery Barres $LesBarres ANSbjct $LeSbjct {
	incr i
	if {$i == $NbCaractParLigne} {
	    append LigneQuery  $ANQuery
	    append LigneBarres $Barres
	    append LigneSbjct  $ANSbjct

	    set n 0
	    foreach AN [split $LigneQuery ""] {
		if {![regexp -nocase {[ATGCNXMKRSYWVHDB]} $AN]} {continue}
		incr n
	    }
	    if {$DQuery < $FQuery} {set FQ [expr $DQ + $n - 1]} else {set FQ [expr $DQ - $n + 1]}

	    set n 0
	    foreach AN [split $LigneSbjct ""] {
		if {![regexp -nocase {[ATGCNXMKRSYWVHDB]} $AN]} {continue}
		incr n
	    }
	    if {$DSbjct < $FSbjct} {set FS [expr $DS + $n - 1]} else {set FS [expr $DS - $n + 1]}

	    set LigneQuery  [format "Query: %-${TailleDebut}d %s %d" $DQ    $LigneQuery $FQ]
	    set LigneBarres [format "%[expr $TailleDebut + 7]s %s"  $Blanc $LigneBarres   ]
	    set LigneSbjct  [format "Sbjct: %-${TailleDebut}d %s %d" $DS    $LigneSbjct $FS] 


	    if {$DQuery < $FQuery} {set DQ [expr $FQ+1]} else {set DQ [expr $FQ-1]}
	    if {$DSbjct < $FSbjct} {set DS [expr $FS+1]} else {set DS [expr $FS-1]}

	    append AliBlast "$LigneQuery\n$LigneBarres\n$LigneSbjct\n\n\n"

	    set LigneQuery  ""
	    set LigneBarres ""
	    set LigneSbjct  ""
	    set i 0
	    continue
	}
	append LigneQuery  $ANQuery
	append LigneBarres $Barres
	append LigneSbjct  $ANSbjct

    }
    if {$LigneQuery != ""} {
	set LigneQuery  [format "Query: %-${TailleDebut}d %s %d" $DQ    $LigneQuery $FQuery]
	set LigneBarres [format "%[expr $TailleDebut + 7]s %s"  $Blanc $LigneBarres   ]
	set LigneSbjct  [format "Sbjct: %-${TailleDebut}d %s %d" $DS    $LigneSbjct $FSbjct] 
	append AliBlast "$LigneQuery\n$LigneBarres\n$LigneSbjct\n\n"
    }
    return $AliBlast


}

proc AliFromOi {} {


    set RepSrcXml "/genomics/link/EHomsa/macsimXmlVertebrata2017"
    set RepSrcRsf "/genomics/link/EHomsa/macsimRsfVertebrata2017"
    set RepDesXml "/home/ripp/msp/data/alignments/Vertebrata/macsimXml"
    set RepDesRsf "/home/ripp/msp/data/alignments/Vertebrata/macsimRsf"
    set LesElus {}
    foreach A [MSP Syn ListOf A] {
	set Nom [MSP Syn $A Nom]
	set Name "${A}mito_Homo.sapi"
	set Accession [MSPFroMac $Nom TDesAccess $Name]
	set NomHs [QuestionDeScience "EHomsa" "ret NIAG $Accession N"]
	if {$NomHs==""} {
	    set NomHs [QuestionDeScience "EHomsa" "ret NIAG SY${A}M_HUMAN N"]
	}
	if {$NomHs==""} {
	    set NomHs [QuestionDeScience "EHomsa" "ret NIAG SY${A}_HUMAN N"]
	}
	Espionne "$A $Accession $NomHs"
	Espionne [QuestionDeScience "EHomsa" "ret ExtraitInfo $NomHs"]
	if {$NomHs==""} { continue }
	set Xml [ContenuDuFichier $RepSrcXml/$NomHs]
	regsub -all $NomHs $Xml $Name Xml
	Sauve $Xml dans $RepDesXml/$Name.xml
	file copy -force $RepSrcXml/$NomHs $RepDesXml/$NomHs.xml
	foreach Rsf [glob -nocomplain $RepSrcRsf/$NomHs*] {
	    file copy -force $Rsf $RepDesRsf/
	    set Queue [file tail $Rsf]
	    regsub $NomHs $Queue $Name Queue
	    file copy -force $Rsf $RepDesRsf/$Queue
	}
	lappend LesElus "$A $Nom $Name"
    }
    return $LesElus


}

proc AliFromOiPoch {{ListOfA ""}} {


    set RepSrcXml "/home/poch"
    set RepDesXml "/home/ripp/msp/data/alignments/Vertebrata/macsimXmlPoch20170602"
    set LesElus {}

    if {$ListOfA==""} { set ListOfA [MSP Syn ListOf A] }

    foreach A $ListOfA {
	set Nom [MSP Syn $A Nom]
	set Name "${A}mito_Homo.sapi"
	set Accession [MSPFroMac $Nom TDesAccess $Name]
	set NomHs [QuestionDeScience "EHomsa" "ret NIAG $Accession N"]
	if {$NomHs==""} {
	    set NomHs [QuestionDeScience "EHomsa" "ret NIAG SY${A}M_HUMAN N"]
	}
	if {$NomHs==""} {
	    set NomHs [QuestionDeScience "EHomsa" "ret NIAG SY${A}_HUMAN N"]
	}
	Espionne "$A $Accession $NomHs"
#	Espionne [QuestionDeScience "EHomsa" "ret ExtraitInfo $NomHs"]
	if {$NomHs==""} { continue }
	set Queue "${Name}_Poch.xml"
	set FichierSrc "$RepSrcXml/$Queue"
	Espionne $FichierSrc
	set LeXml [LesLignesDuFichier $FichierSrc]
	set LeNew {}
	set OX ""
	if {[info exists DejaVu]} { unset DejaVu }
	set LaSequenceCourante {}
	set DansSequence 0
	set OnGarde 1
	if {$A=="G"} { set Name "P41250" }
	foreach Ligne $LeXml {
	    if {[regexp "</sequence" $Ligne]} {
		lappend LaSequenceCourante $Ligne
		if {$OnGarde} {
		    LConcat LeNew $LaSequenceCourante
		}
		set LaSequenceCourante {}
		set DansSequence 0
		continue
	    }
	    if  {[regexp "<sequence" $Ligne]} {
		lappend LaSequenceCourante $Ligne
		set DansSequence 1
		set OnGarde 1
		continue
	    }
	    if { ! $DansSequence } {
		lappend LeNew $Ligne
		continue
	    }
	    set SeqName ""
	    if {[regexp {<seq\-name>([^<]+)</seq\-name>} $Ligne Match SeqName]} {
		if {$A!="G" && $SeqName==$Name} { set OnGarde 0 }
		if {$A=="G" && $SeqName=="Gmito_Homo.sapi"} { set OnGarde 0 }
		if {$SeqName!="" && ($SeqName!=$Name || $SeqName=="P41250") } {
		    set R [QuestionDeScience GeneQuid "ret UniprotData $SeqName ID,GN,OX"]
		    scan $R "%s" Id
		    set Gn [StringApres "Name=" dans $R]
		    set OX [IntegerApres "NCBI_TaxID=" dans $R]
		    lappend LesOX($A) $OX
		    lappend DejaVu($A,$OX) "$SeqName : \n$R"
		    set OS [OiCodeForDomain Eukaryota $OX OS]
		    lassign [split $OS " "] Ge Es
		    set Es [string trim $Es "."]
		    set Code [string totitle [string range $Ge 0 3]].[string tolower [string range $Es 0 3]]
		    Espionne ""
		    Espionne $OnGarde
		    Espionne "$Id $Gn $Ligne"
		    if {[regexp -nocase "^${A}ARS2" $Gn] || ([regexp -nocase {^[GK]ARS} $Gn] && $SeqName!="P41250") || [regexp -nocase "^SY${A}M" $Id]} {
			if {[regexp {^([^_]+)_(.+)$} $Id Match Ac Os]} {
			    set XmitoGenrespe ${A}mito_$Code
			    if {[info exists DejaVu($XmitoGenrespe)]} { append XmitoGenrespe 2 }
			    set DejaVu($XmitoGenrespe) 1
			    set Ligne "<seq-name>$XmitoGenrespe</seq-name>"
			}
		    } elseif {[regexp -nocase "^SY${A}C" $Id]} {
			set XcytoGenrespe ${A}cyto_$Code
			if {[info exists DejaVu($XcytoGenrespe)]} { append XcytoGenrespe 2 }
			set DejaVu($XcytoGenrespe) 1
			set Ligne "<seq-name>$XcytoGenrespe</seq-name>"
		    } else {
		    }
		    #rR Traitement spécial pour GARS car on ne sait pas s'ils sont cyto ou mito
		    Espionne $Ligne
		    if {$A=="G" && ! [regexp "Homo.sapi" $Ligne] && [regexp {<seq\-name>G(cyto|mito)_} $Ligne]} {
			regsub {<seq\-name>G(cyto|mito)_} $Ligne "<seq-name>G_" Ligne
		    }
		    Espionne "regexp {<seq\-name>P41250</seq\-name>} $Ligne"
		    if {$A=="G" && [regexp {<seq\-name>P41250</seq\-name>} $Ligne]} {
			regsub {<seq\-name>P41250</seq\-name>} $Ligne "<seq-name>Gcyto_Homo.sapi</seq-name>" Ligne
		    } 
		    if {0 && $A=="G" && [regexp {<seq\-name>A0A091E8Q8</seq\-name>} $Ligne]} {
			regsub {<seq\-name>A0A091E8Q8</seq\-name>} $Ligne "<seq-name>Gmito_Homo.sapi</seq-name>" Ligne
		    } 

		}
	    }
	    if {[regexp {<seq\-data>([^<]+)</seq\-data>} $Ligne Match SeqGap]} {
		set SeqGap [string toupper $SeqGap]
		regsub -all {[^A-Z]} $SeqGap "" Seq
		set SeqDe($A,$OX) $Seq
		lappend LesAOXDeSeq($Seq) "$A,$OX"
		lappend LesSeq $Seq
	    }
	    lappend LaSequenceCourante $Ligne
	}
	
	foreach Seq $LesSeq {
	    if {[llength LesAOX($Seq)]>1} {
		Espionne "SequencesDoublons"
		Espionne [join LesAOXDeSeq($Seq) " "]
	    }
	}
	
	lappend LesErreurs ""
	set MessageEntete "$A **************************** "
	Espionne $MessageEntete
	set LesOX($A) [lsort -unique $LesOX($A)]
	foreach OX $LesOX($A) {
	    if {[llength $DejaVu($A,$OX)]>1} {
		lappend LesErreurs ""
		lappend LesErreurs $MessageEntete
		set Message [join $DejaVu($A,$OX) "\n\n"]
		lappend LesErreurs $Message
		Espionne $Message
	    }
	}
	lappend LesElus [SauveLesLignes $LeNew dans $RepDesXml/$Queue]
    }
    SauveLesLignes $LesErreurs dans $RepDesXml/Doubles.txt
    return $LesElus


}

proc AliTest {{Option genomes} {organism mouse} {BirdVersion bird}} {


	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]	
	Espionne "$timestamp|AliTest : Start"
	set Path "/tmp/BirdCird"
#	set FichierDesCoord [open "$Path.txt" "r"]
	set FichierDesRequetes [open "$Path.sql" "w"]
	#ScanLaListe $Ligne Id Chromosome Start End
	#puts $FichierDesRequetes "WH SQLNATIVE SELECT * FROM ucschuman.alignements, ucschuman.alignements_sequences WHERE  ali_startq < $Start AND ali_endq > $End AND (ali_access = as_access) " 
	#puts $FichierDesRequetes "WH SQLNATIVE SELECT as_access FROM ucschuman.alignements_sequences where as_access NOT IN (select ali_access from ucschuman.alignements)" 
	#puts $FichierDesRequetes "WH SQLNATIVE SELECT count(*) FROM ucschuman.alignements where ali_access NOT IN (select as_access from ucschuman.alignements_sequences) " 
	#puts $FichierDesRequetes "WH SQLNATIVE SELECT ali_access, count(*) from ucschuman.alignements group by ali_access having count(*) > 1"
	if { $Option == "count" } {
		#puts $FichierDesRequetes ID * DB UCSC"
		#puts $FichierDesRequetes WH SQLNATIVE SELECT ali_genomet FROM ucsc$Organismet.alignements WHERE ali_access NOT in (select as_access from ucsc$Organismet.alignements_sequences)"
		#puts $FichierDesRequetes LM 30"
		
		puts $FichierDesRequetes "ID * DB UCSC"
		puts $FichierDesRequetes "WH SQLNATIVE SELECT count(*) FROM ucsc$organism.alignements"
		puts $FichierDesRequetes "LM 30"
		puts $FichierDesRequetes "//"

	} else { if { $Option == "genomes" } {
				puts $FichierDesRequetes "ID * DB UCSC"
				puts $FichierDesRequetes "WH SQLNATIVE SELECT ali_organismet FROM ucsc$organism.alignements group by ali_organismet" 
				puts $FichierDesRequetes "LM 30"
				puts $FichierDesRequetes "//"
			}
	}
	close $FichierDesRequetes
	exec /biolo/bird/bin/birdql_client.sh "$Path.sql" bird "$Path.res"
	set FichierDesRequetesExecutees [open "$Path.res" "r"]
	while { [gets $FichierDesRequetesExecutees Ligne]  >=0 } {
		Espionne $Ligne
	}
	close $FichierDesRequetesExecutees
	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]	
	Espionne "$timestamp|AliTest : End"


}

proc Alias {Nom} {


    return [ExtraitInfo $Nom "Alias"]


}

proc AliasAlias {A {Lequel ""} {Append ""}} {


    global AliasAlias

    if {$Append==""} { set Append "NoAppend" }
    set Append [string equal -nocase $Append "Append"]

    if {$Lequel==""} { set Lequel "Gscope" }

    if {[info exists AliasAlias($A,$Lequel)]} { return $AliasAlias($A,$Lequel) }
    if {[info exists AliasAlias("EstCharge")]} { return "" }

    set LesAliasGscope [lsort -dictionary [LesAliasExistants]]
    set FichierAliasAlias "[RepertoireDuGenome]/fiches/AliasAlias"
    if {[FileExists $FichierAliasAlias]} {
	array set AliasAlias [LesLignesDuFichier $FichierAliasAlias]
    }
    set AliasAlias("EstCharge") 1
    if { ! $Append } { return [AliasAlias $A $Lequel] }

    foreach VE [VEDidier ListeDes VE] {
	Espionne $VE
	set ProtName [VEDidier $VE ProtName]
	set Organism [VEDidier $VE Organism]
	set Original $ProtName
	set ProtName [string trim $ProtName]
	regsub { [^ ]$} $ProtName "" ProtName
	set ProtOrga "${ProtName}_$Organism"
	regsub -all " " $ProtOrga "_" ProtOrga
	if {[info exists AliasAlias($ProtOrga,Gscope)]} { continue }
	Espionne "$ProtOrga"
	set LesAliasLesPlusProches [LesAliasLesPlusProches $ProtOrga]
	if {0 && [string equal $ProtName [lindex $LesAliasLesPlusProches 0]]} {
	    set AliasAlias($ProtOrga,Gscope) $AliasGscope
	    set AliasAlias($AliasGscope,Didier) $ProtOrga
	    continue
	}
	set Ligne [VEDidier $VE]
	while 1 {
	    set Meilleur [ChoixParmi [concat [list SaveAndQuit $ProtOrga $Ligne "****"]  $LesAliasLesPlusProches [list "******"] $LesAliasGscope]]
	    if {[regexp "SaveAndQuit" $Meilleur]} {
		if {[OuiOuNon "Do I save and quit ?"]} { break }
		continue
	    }
	    break
	}
	if {[regexp "SaveAndQuit" $Meilleur]} { break }
	set AliasAlias($ProtOrga,Gscope) $Meilleur
	set AliasAlias($Meilleur,Didier) $ProtOrga
    }
    foreach {C V} [array get AliasAlias] {
	ScanLaListe [split $C ","] POA Qui
	if {$Qui=="Gscope"} { lappend LesDidier $POA }
	if {$Qui=="Didier"} { lappend LesGscope $POA }
    }
    set AliasAlias(ListeDes,Gscope) [lsort $LesGscope]
    set AliasAlias(ListeDes,Didier) [lsort $LesDidier]

    SauveLesLignes [array get AliasAlias] dans $FichierAliasAlias
    return [AliasAlias $A $Lequel]


}

proc AliasDansTfaPourTous {} {


    if { ! [OuiOuNon "This proc read the 'alias' in the prottfa file.\n Please verify the source sode if it corresponds to what you need\n Do I continue ?"]} { return }

    foreach Nom [ListeDesPABs] {
	set FichierTfa "[RepertoireDuGenome]/prottfa/$Nom"
	if { ! [file exists $FichierTfa]} { continue }
	set Ent [EnteteDuFichierTFA $FichierTfa]
	if {[OuiOuNonMemo "Do I take the second word of the tfa file as the Alias?"]} {
	    set A ""
	    scan $Ent "%s %s" CN A
	    regsub ">" $CN "" NomLu
	    if {$NomLu!=$Nom} { FaireLire "$Nom has following line\n$Ent" }
	    InformeSansDemander $Nom "Alias: $A"
	    continue
	}
	continue
	set Seq [QueLaSequenceDuFichierTFA $FichierTfa]
	set BonTFA [SequenceFormatTFA [string toupper $Seq] "$Nom $A" "protbrut"]
	Espionne [Sauve $BonTFA dans $FichierTfa]
    }


}

proc AliasGeneNames {Nom} {


    set LesGn {}
    foreach PossibleAlias [list "AliasGnRna:" "AliasGnProt:" "AliasGnHuman:"] {
	LConcat LesGn [split [ExtraitInfo $Nom $PossibleAlias] " "]
    }
    set LesAliasGn {}
    set DejaVu([string toupper [ValiGN $Nom]]) 1
    foreach Gn $LesGn {
	set GN [string toupper $Gn]
	if {[info exists DejaVu($GN)]} { continue }
	set DejaVu($GN) $Gn
	lappend LesAliasGn $Gn
    }
    return $LesAliasGn


}

proc AliasManquants {} {


    foreach VE [VEDidier ListeDes VE] {
	set D [VEDidier $VE "ProtName"]
	set O [VEDidier $VE "Organism"]
	set DO "$D$O"
	regsub -all " " $DO "_" DO
	set VEDuAlias($DO) $VE
    }

    foreach D [AliasAlias ListeDes Didier] {
	set G [AliasAlias $D Gscope]
	if {[AliasAlias $D Gscope]!=""} { continue }
	set Scientist "Scientist unknown" 
	if {[info exists VEDuAlias($D)]} {
	    set VE $VEDuAlias($D)
	    set Scientist [VEDidier $VE Scientist]
	}
	Espionne "$D $Scientist"
    }
    exit


}

proc AliasParNomDuFichier {} {


    set FichierFOF [ButineArborescence All "[RepertoireDuGenome]"]
    foreach Ligne [LesLignesDuFichier $FichierFOF] Nom [ListeDesPABs] {
	scan $Ligne "%s %s" AliasLu FicLu
	set Nouveau [file tail $FicLu]
	if {0 && [Alias $Nom]!=$AliasLu} {
	    FaireLire "Attention pour $Nom $AliasLu != [Alias $Nom]"
	}
	Espionne "InformeSansDemander $Nom =Alias: $Nouveau"
	InformeSansDemander $Nom "=Alias: $Nouveau"
    }
    exit


}

proc AliasPourClonage {Nom} {


    global AliasPourClonage
    if {[info exists AliasPourClonage($Nom)]} { return [set AliasPourClonage($Nom)] }
    set Alias ""
    if {$Alias==""} { set Alias [Alias $Nom] }
    if {$Alias==""} { set Alias [Narcisse $Nom] }
    if {$Alias==""} { set Alias $Nom }
    set AliasPourClonage($Nom) $Alias
    return $Alias


}

proc AliasPourTous {} {


    global RepertoireDuGenome
    
    FaireLire "Please browse for the file .fof containing 'Alias ... ... ...'"
    set FOF [ButineArborescence "All" "$RepertoireDuGenome"]
    set Numero 0
    foreach Ligne [LesLignesDuFichier $FOF] {
	if { ! [regexp -nocase {[A-Z0-9_]} $Ligne]} { continue }
	
	catch {unset Nom}
	catch {unset Ver}
	catch {unset OrigineBlastP}
	catch {unset OrigineBallast}
	catch {unset OrigineMSF}  
	set NbLus [scan $Ligne "%s %s %s %s %s %s" Alias OrigineVer OrigineBlastP OrigineBallast OrigineMSF SecondMSF]
	if {$NbLus < 2} {
	    if {[OuiOuNon "$Ligne\n missing values. Do I stop ?"]} { exit } 
	    continue
	}
	
	set Nom [format "%s%[FormatDesNumerosPourCollection]" [PreFixe] [incr Numero]]

	InformeSansDemander $Nom "=Alias: $Alias"
    }



}

proc AlignAgent {} {

    global iTag 

    set chx [chooseCouple]
    lassign $chx seq1 ag1 seq2
    puts "choose $chx"

    lassign [FindAgentFriend {*}$chx] ag2 score seuil

    if {$::debug} {
	DebugAgents $seq1 $ag1 $seq2 $ag2 $score $seuil
    }
    
    if {$ag2 eq "skip"} {
	#.l configure -background "#770000"
	append ::Lab " ==> SKIP $seq1 $::TAg($ag1,$seq1,seq)"
	return -1
    }

    #.l configure -background black
    append ::Lab " $seq1 $::TAg($ag1,$seq1,seq) $seq2 $::TAg($ag2,$seq2,seq) [format %6.3f $score]"

    if {$::StepMode} {
	puts "\nSHOW 1"
	set iTag 0
	ShowPairGUIAgent $seq1 $ag1 $seq2 $ag2
	MemorisePair $seq1 $ag1 $seq2 $ag2
    }
    
    set move [ShouldMoveAgents $seq1 $ag1 $seq2 $ag2]
    if {$move} {
	SlideAgent $seq1 $ag1 $seq2 $ag2
	if {$::StepMode} {
	    UpdateGUI
	    set iTag 0
	    ShowPairGUIAgent $seq1 $ag1 $seq2 $ag2 2
	}
	AgentsRemoveColsGaps
	UpdateGUI
    }
    
    return $move

}

proc AlignQueryVsMACS {{FichierTFA ""} {FichierMSF ""} {OutputMSF ""}} {



    Wup "Permet d aligner une sequence au format Fasta contre un MACS de reference"
    Wup "L alignement est realise par clustalw et le mode profile"
    
    if {$FichierMSF=="" || $FichierTFA=="" || $OutputMSF==""} {return "-1"}

    #Alignement de la sequence du fichier TFA contre le MACS
    set Output_Profile  ""
    set Clustal_Profile "clustalw"
    #set Clustal_Profile "/biolo/clustal/bin/clustalw"
    if {[catch {set Output_Profile  [exec  $Clustal_Profile  -profile1=$FichierMSF  -profile2=$FichierTFA  -sequences  -output=gcg  -outfile=$OutputMSF ]} Message]} {

	Espionne ">>>AlignQueryVsMACS $FichierMSF"
	Espionne "pb $Message"
	return "-1"
    } else {
	set FichierDND $FichierTFA
	regsub -nocase ".tfa$" $FichierDND ".dnd" FichierDND
	if {[file exists $FichierDND]} {
	    file delete -force $FichierDND
	}
	return "1"
    }


}

proc AlignRDNA2Prot {p r} {

    # first check length
    set pdg [string map [list "." ""] $p]
    # stop codon
    set Lstop [list tag taa tga TAG TAA TGA]
    if {[string range $r end-2 end] in $Lstop} {
	set r [string range $r 0 end-3]
    }

    # diff of 3 may be due to missing initiaor M
    if {abs( ([string length $pdg]*3) - [string length $r]) == 3} {
	# May be a missing leading M
	if {[string index $p 0] ne "M" && [string range $r 0 2] in [list atg ATG]} {
	    set r [string range $r 3 end]
	}
    }
    if {([string length $pdg]*3) != [string length $r]} {
	puts "PB ! RNA [string length $r] Prot [expr {[string length $pdg]*3}]"
	return ""
    }

    set i 0
    set Lc [split $p ""]
    set al ""
    foreach c $Lc {
	if {$c eq "."} {
	    append al "..."
	} else {
	    append al [string range $r [expr {$i*3}] [expr {$i*3+2}]]
	    incr i
	}
    }

    return $al

}

proc Aligne3PdeADN {Nom Devant DebutDevant FinDevant Derriere DebutDerriere FinDerriere Orient} {



    global RepertoireDuGenome
    global Commandes
    global ADN TDN RAC
    global NePlusFaireAligne3P

    if { ! [info exists NePlusFaireAligne3P]} { set NePlusFaireAligne3P 1 }

    if { $Orient == "F" } {
	set ListeDes3Frames {a b c}
    } else {
	set ListeDes3Frames {f e d}
    }

    if { $NePlusFaireAligne3P || ! [OuiOuNon "Je lance 3 alignements ?"]} {
	return "a faire."
    }

    if { ! [info exists ADN]} { ChargeADNetTDNetRAC }

    set NomDesSequences ""

    if {[YaPABdans $Nom]} {
	set FichierBlast "$RepertoireDuGenome/blastp/$Nom"
    }
    if {[regexp "TROU" $Nom]} {
	set FichierBlast "$RepertoireDuGenome/trousblastp/$Nom"
    }

    if { $Devant == "Laisser" } {
	set SequenceDevant [BoutADN $DebutDevant $FinDevant $Orient]
    }
    set LongueurPepDevant [expr ($FinDevant-$DebutDevant+1)/3]

    if { $Derriere == "Laisser" } {
	set SequenceDerriere [BoutADN $DebutDerriere $FinDerriere $Orient]
    }
    set LongueurPepDerriere [expr ($FinDerriere-$DebutDerriere+1)/3]

    set Sens [expr $Orient=="F" ? -1 : 1]
    foreach Frame $ListeDes3Frames {
	set CasseDevant "toupper"
	if { $Devant == "Changer" } {
	    incr DebutDevant $Sens 
	    incr FinDevant $Sens
	    set SequenceDevant [BoutADN $DebutDevant $FinDevant $Orient]
	    set SequenceDevant [string tolower $SequenceDevant]
	    set CasseDevant "tolower"
	    set NomDeLaSequence "${Nom}_${LongueurPepDevant}_${Frame}"
	}
	set CasseDerriere "toupper"
	if { $Derriere == "Changer" } {
	    incr DebutDerriere $Sens 
	    incr FinDerriere $Sens
	    set SequenceDerriere [BoutADN $DebutDerriere $FinDerriere $Orient]
	    set SequenceDerriere [string tolower $SequenceDerriere]
	    set CasseDerriere "tolower"
	    set NomDeLaSequence "${Nom}_${Frame}_${LongueurPepDerriere}"
	}
	append NomDesSequences "$NomDeLaSequence "
	set SequenceADN "$SequenceDevant$SequenceDerriere"

	set SeqGCG [NucToGCG $SequenceADN $NomDeLaSequence]

	set iPP [string first "\.\." $SeqGCG]
	set EncoreDevant $LongueurPepDevant 
	set EncoreDerriere $LongueurPepDerriere 
	catch {unset VraiDebutDevant VraiDebutDerriere}
	for {set i $iPP} {$i < [string length $SeqGCG]} {incr i} {
	    if {[regexp {[a-zA-Z\*]} [string range $SeqGCG $i $i]]} {
		if { $EncoreDevant } {
		    if { ! [info exists VraiDebutDevant]} {
			set VraiDebutDevant $i
		    }
		    set VraiFinDevant $i
		    incr EncoreDevant -1
		} else {
		    if { $EncoreDerriere } {
			if { ! [info exists VraiDebutDerriere]} {
			    set VraiDebutDerriere $i
			}
			set VraiFinDerriere $i
			incr EncoreDerriere -1
		    }
		}
	    }
	}
	set LowerSeqGCG " [string range $SeqGCG  0 [expr $VraiDebutDevant-1]] [string $CasseDevant   [string range $SeqGCG $VraiDebutDevant $VraiFinDevant]] [string $CasseDerriere [string range $SeqGCG $VraiDebutDerriere end]]"
	set iL [expr [string first "Length" $LowerSeqGCG]-1]
	set BonneSeqGCG "$NomDeLaSequence[string range $LowerSeqGCG $iL end]"
	set FichierPEP [Sauve $BonneSeqGCG dans $NomDeLaSequence]
	foreach Aligneur [Aligneurs] {
	    if { [Aligneurs $Aligneur] } {
		set MSF [AligneLesHomologuesDuBlastContreSeq  $Aligneur $FichierBlast $FichierPEP]
		lappend ListeDesMSF $MSF
	    }
	}
    }
    set Fenetre [AfficheVariable [join $ListeDesMSF "\n"]  "AvecShowAvecEtudeMSF" "Wait all be Highlighted ...\nThen reselect and press a function. "]
    BoutonneLaFenetre $Fenetre "Log" "AfficheLogDesMSF \[selection get\]"
    foreach Fichier $ListeDesMSF {
	set LaFenetreDesMSF($Fichier) $Fenetre
    }	    
    return "Aligne3P est lance sur $NomDesSequences"


}

proc AligneContrePDB {Lseqpdb aLbinhe aLbinsh aLbintu aLseqpdn aLseqadn} {


    upvar $aLbinhe Lbinhe $aLbinsh Lbinsh $aLbintu Lbintu $aLseqpdn Lseqpdn $aLseqadn Lseqadn
    
    set i 0
    set Lh [list] ; set Ls [list] ; set Lt [list]
    set Lp [list] ; set La [list]
    foreach a $Lseqpdb {
	if {$a eq "-"} {
	    lappend Lh X
	    lappend Ls X
	    lappend Lt X
	    lappend Lp X
	    lappend La XXX
	} else {
	    lappend Lh [lindex $Lbinhe $i]
	    lappend Ls [lindex $Lbinsh $i]
	    lappend Lt [lindex $Lbintu $i]
	    lappend Lp [lindex $Lseqpdn $i]
	    lappend La [lindex $Lseqadn $i]
	    incr i
	}
    }
    set Lbinhe $Lh
    set Lbinsh $Ls
    set Lbintu $Lt
    set Lseqpdn $Lp
    set Lseqadn $La
    
    return


}

proc AligneLesHomologuesDuBlast {Aligneur FichierBlast} {


    global RepertoireDuGenome

    set SeuilExpect 1e-3
    set MaxLongueurDuBlast 50

    DecortiqueBlast $FichierBlast $SeuilExpect $MaxLongueurDuBlast Query lBanqueId lAccess lDE lProfil lPN
    set Nom [file tail $Query]
    if {[YaPABdans $Nom]} {
	set lHomos "$RepertoireDuGenome/prottfa/$Nom"
    } elseif {[regexp "TROU" $Nom]} {
	set lHomos "$RepertoireDuGenome/trousprottfa/$Nom"
    } else {
	set lHomos $Query
    }
    if { [info exists lBanqueId] && [llength $lBanqueId] > 0 } {
	foreach BanqueId $lBanqueId Access $lAccess {
	    if {[FetchTest $BanqueId]} {
		lappend lHomos $BanqueId
		continue
	    }
	    if {[FetchTest "protein:$Access"]} {
		lappend lHomos "protein:$Access"
		continue
	    }
	    Warne "$BanqueId $Access introuvable"
	}
    }
    set Destination "$RepertoireDuGenome/${Aligneur}/$Nom"
    if { [llength $lHomos] < 2 } {
	Warne "$Aligneur inutile. Pas de sequences a aligner dans $FichierBlast"
	return ""
	return [Sauve "$Aligneur inutile. Pas de sequences a aligner dans $FichierBlast" dans $Destination]
    }
    set Selection [join $lHomos "\n"]
    set MSF [AlignePar $Aligneur $Selection "Interactif" $Nom]
    file rename $MSF $Destination 
    return $Destination


}

proc AligneLesHomologuesDuBlastContreSeq {Aligneur FichierBlast {Seq ""}} {


    global RepertoireDuGenome

    set SeuilExpect 1e-3
    set MaxLongueurDuBlast 50

    DecortiqueBlast $FichierBlast $SeuilExpect $MaxLongueurDuBlast Query lBanqueId lAccess lDE lProfil lPN
    set Nom [file tail $Query]
    if { $Seq == ""} { set Seq $Query }
    set lHomos [linsert $lAccess 0 $Seq]
    if { [llength $lHomos] < 2 } { return "" }
    set Selection [join $lHomos "\n"]
    set MSF [AlignePar $Aligneur $Selection "Batch" $Nom]

    return $MSF


}

proc AlignePar {Aligneur Selection Mode {NomOuNum ""}} {


    global Commandes

    if { $NomOuNum == ""} {
	set NomNum [pid].[NomDe ""]
    }
    if { [regexp {^[a-zA-Z]} $NomOuNum ] } {
	set NomNum ${NomOuNum}[NomDe ""]
    }
    if { [regexp {^[0-9]} $NomOuNum ] } {
	set NomNum $NomOuNum
    }
    if { [regexp {^\.[0-9]} $NomOuNum ] } {
	set NomNum $NomOuNum
    }
    set Tmp tmp.$NomNum
    
	
    if { $Mode == "Batch" } {
	set In  $Tmp.$Aligneur.inp
	set Out $Tmp.$Aligneur.out
	set Log $Tmp.$Aligneur.log
	set FOF [FichierFOF $Selection $Tmp]
	SauveLesLignes [FOFtoTFAs $FOF] dans $In
	catch {set Canal [open "| [set Commandes($Aligneur)] $In $Out $Log"]} Message
	fconfigure $Canal -blocking false -buffering line
	fileevent $Canal readable "ClosCanalEtMontreMSF $Aligneur $Canal $Out.msf $Log"
	Warne "$Aligneur est lance en batch"
	return "$Out.msf"
    }

    if { $Mode == "Interactif" } {
	set In  $Tmp.inp
	Sauve [ConcatLesTFAs $Selection] dans $In
	set LesFichiersCrees [list "$In"]
	foreach Ali [split $Aligneur "+"] {
	    set Out $Tmp.$Ali.out
	    set Log $Tmp.$Ali.log
	    Warne "$Ali lance en interactif ... un peu de patience. Merci."
	    eval exec "[set Commandes($Aligneur)] $In $Out $Log"
	    Warne "                                                            ... j'ai fini."
	    File delete -force $Out
	    File delete -force $Log
	    lappend LesFichiersCrees "$Out.msf"
	}
	if {[regexp "+" $Aligneur]} {
	    return $LesFichierCrees
	} else {
	    return "$Out.msf"
	}
    }


}

proc AlignementDeLaSelection {K} {


    set Liste [$K find withtag current]
    foreach Id $Liste {
	set BId        [lindex [$K gettags $Id] 0]
	set Alignement [lindex [$K gettags $Id] 2]
	AfficheVariable $Alignement "AvecRien" "$BId"
    }


}

proc AlignementDesSelections {{Zone ""} aSAli} {

    upvar $aSAli SAli
    global NomSeqSel Sequences LNOrdali

    set LesNoms {}
    set LesSequences {}
    set LesNomsDesSeqs $LNOrdali

    if {[info exists NomSeqSel] && [llength $NomSeqSel] > 3} {
	set Li {}
	foreach p $NomSeqSel {
	    lassign [split $p .] y x
	    incr y -1
	    lappend Li $y
	}
    } else {
	for {set i 0} {$i < [llength $LesNomsDesSeqs]} {incr i} {
	    lappend Li $i
	}
    }

    if {! [llength $Zone]} {
	set Zone [list [list 0 [expr {[LongueurDeLAlignement]-1}]]]
    }

    set LVide {}
    foreach i $Li {
	set Nm [lindex $LesNomsDesSeqs $i]
	if {$Nm eq ""} {continue}
	set sbrut [set Sequences($Nm)]

	set s ""
	foreach z $Zone {
	    lassign $z x1 x2
	    append s [string range $sbrut $x1 $x2]
	}
	set tmp [string map [list "." "" Z "" " " "" X ""] $s]
	if {[string trim $tmp] eq ""} {
	    lappend LVide $i
	    continue
	}
	lappend LesNoms $Nm
	lappend LesSequences $s
    }

    set SAli {}
    foreach n $LesNoms s $LesSequences {
	lappend SAli $n $s
    }

    return $LVide

}

proc AlignementDuLineage {what} {

    global LNOrdali LSOrdali TDuLineage
    
    set Ln {} ; set Ls {}
    foreach n $LNOrdali s $LSOrdali {
	if {$n eq ""} {continue}
	
	if {$what in $TDuLineage($n)} {
	    lappend Ln $n
	    lappend Ls $s
	}
    }

    return [list $Ln $Ls]

}

proc AlignementDynamique {Liste} {


    if {0} {
	set LesPaires {}
	foreach Ligne [LesLignesDuFichier $Liste] {lappend LesPaires [split $Ligne "\t"]}
	set LesPaires [lsort -index 1 -integer -increasing $LesPaires]
    } else {
	set LesPaires [lsort -index 1 -integer -increasing $Liste]
    }

    set LesRangQ {}
    set LesRangS {}
    foreach LaPaire $LesPaires {
	set RangQ                   [lindex $LaPaire 0]
	set RangS                   [lindex $LaPaire 1]
	lappend LesRangQ $RangQ
	lappend LesRangS $RangS
	set TabScore($RangQ,$RangS) [lindex $LaPaire 2]
    }

    set ScoreMax 0
    set LesRangQ [lsort -unique -increasing -integer $LesRangQ]
    set LesRangS [lsort -unique -increasing -integer $LesRangS]
    set nRangQ   [llength $LesRangQ]
    set nRangS   [llength $LesRangS]

    set LaDernierePaireDuScoreOpt {}
    for {set i 0} {$i < $nRangQ} {incr i} {
	for {set j 0} {$j < $nRangS} {incr j} {
	    set RangQ [lindex $LesRangQ $i]
	    set RangS [lindex $LesRangQ $j]

	    if {![info exists TabScore($RangQ,$RangS)]} {continue}
	    set Score [set TabScore($RangQ,$RangS)]

	    set ScoreOptPrec 0
	    set LaMeilleurePairePrec {}
	    foreach     RangQPrec [lrange $LesRangQ 0 [expr $i - 1]] { 
		foreach RangSPrec [lrange $LesRangS 0 [expr $j - 1]] {
		    if {![info exists TabScore($RangQPrec,$RangSPrec)]} {continue}
		    set ScorePrec [set TabScore($RangQPrec,$RangSPrec)]

		    if {[info exists          TabScoreOpt($RangQPrec,$RangSPrec)]} {
			set ScoreOptDeLaPaire [set TabScoreOpt($RangQPrec,$RangSPrec)]
		    } else {
			set ScoreOptDeLaPaire [set TabScore($RangQPrec,$RangSPrec)]
		    }
		    if {$ScoreOptPrec < $ScoreOptDeLaPaire} {
			set ScoreOptPrec $ScoreOptDeLaPaire
			set LaMeilleurePairePrec [list $RangQPrec $RangSPrec $ScorePrec]
		    }
		}
	    }
	    set TabScoreOpt($RangQ,$RangS,LaMeilleurePairePrec) $LaMeilleurePairePrec
	    set ScoreOpt [expr $Score + $ScoreOptPrec]
	    set TabScoreOpt($RangQ,$RangS) $ScoreOpt

	    if {$ScoreMax < $ScoreOpt} {
		set ScoreMax $ScoreOpt
		set LaDernierePaireDuScoreOpt [list $RangQ $RangS $Score]
	    }
	}
    }
    set LesMeilleursRangs {}
    while {$LaDernierePaireDuScoreOpt != {}} {
	set RangQ [lindex $LaDernierePaireDuScoreOpt 0]
	set RangS [lindex $LaDernierePaireDuScoreOpt 1]
	lappend LesMeilleursRangs     $LaDernierePaireDuScoreOpt
	set LaDernierePaireDuScoreOpt [set TabScoreOpt($RangQ,$RangS,LaMeilleurePairePrec)]
    }
    return [lsort -index 0 -integer $LesMeilleursRangs]


}

proc AlignementEssai {Nom} {


    set Fichier       "[RepertoireDuGenome]/macsims/$Nom.xml"
    set FichierSortie "[RepertoireDuGenome]/annotation/$Nom.ali"
    ParseMACSIMS $Fichier macsims
    set LesNomsSequences $macsims(Noms)
    foreach NomSequence $LesNomsSequences { 
	set Ali $macsims($NomSequence,Sequence)
	Espionne $Ali
    }


}

proc AlignementEssai1 {} {


    foreach Nom [ListeDesPABs] {
	Espionne $Nom
	set FichierMacsims "[RepertoireDuGenome]/macsims2/$Nom.xml"
	if {[file exists $FichierMacsims]} {continue}
	FichierMsfPourGOAnno $Nom "Sans"
	set FichierAlignement "[RepertoireDuGenome]/annotation/$Nom.msf"
	
	if {! [file exists $FichierAlignement]} {continue}
	set RepertoireDuMsf "annotation"
	MacsimManu $Nom $RepertoireDuMsf
    }


}

proc Aligneurs {{LeQuel ""} {Defaut ""}} {


    Wup "Returns array Aligneurs, AligneursCoches or Aligneur($LeQuel)" 
    global Aligneurs AligneursCoches AligneursDefaut

    if { ! [info exists Aligneurs]} {
	set Aligneurs(clustalw) 1
	set Aligneurs(dialign)  0
	set Aligneurs(pileup)   0
	set Aligneurs(prrp)     0
	foreach {a ValAligneurs} [array get Aligneurs] {
	    set AligneursDefaut($a) $ValAligneurs
	    if {$ValAligneurs} {
		set AligneursCoches($a) $ValAligneurs
	    }
	}
    }

    if {$LeQuel==""} {
	return [array names Aligneurs]
    }
    if {$LeQuel=="Coches"} {
	return [array names AligneursCoches]
    }
    if { $Defaut == "" } {
	if {[info exists Aligneurs($LeQuel)]} {
	    return [set Aligneurs($LeQuel)]
	} else {
	    return 0
	}
    } else {
	if {[info exists AligneursDefaut($LeQuel)]} {
	    return [set AligneursDefaut($LeQuel)]
	} else {
	    return 0
	}
    }


}

proc Alignons {PourQui {NomATraiter ""}} {


    global RepertoireDuGenome
    global ListeDesPABs
    global NotreOS

    set OnEffaceBallast 0

    if {$NomATraiter == "" } { 	
	set Liste [ListeDesPABs]
    } else {
	set Liste [list $NomATraiter]
    }

    if {$PourQui=="Paralogues"} {
	set RepertoireMSF "$RepertoireDuGenome/msfparalogues"
	File mkdir $RepertoireMSF
    }
    
    set Conserve 1
    if {[llength [glob -nocomplain "$RepertoireMSF/*"]] > 0} {
	set Conserve [OuiOuNon "Should I keep the existing files in $RepertoireMSF"]
    }

    foreach Nom $Liste {

	Espionne "Je vais traiter $Nom"

	set FichierMSF     "$RepertoireMSF/$Nom"
	set FichierBlastP  "$RepertoireDuGenome/blastp/$Nom"

	if {$PourQui=="Paralogues" && [ParaloguesDe $Nom]=={}} { continue }
	if { ! [file exists $FichierBlastP]} { continue }
	if { $Conserve && [file exists $FichierMSF] } { continue }
	
	if {[file exists "$RepertoireDuGenome/ballast/$Nom"]} {
	    set FichierBallast "$RepertoireDuGenome/ballast/$Nom" 
	} else { 
	    set FichierBallast [Ballast $FichierBlastP]
	}
	if {$FichierBallast != "" &&  [regexp -nocase "fatal error" [join [LesPremieresLignesDuFichier $FichierBallast 10]] "\n"]} {
	    set FichierBallast ""
	}
	if {$PourQui=="Paralogues"} {
	    set LaSelectionUnique [ParaloguesDe $Nom "apn"]
	    EspionneL $LaSelectionUnique
	    Espionne [llength $LaSelectionUnique]
	    if {[llength $LaSelectionUnique] == 0} {
		continue
	    }
	} else {
	    set LaSelectionUnique [CreeLaListeLesCopains $FichierBlastP "blastp"]
	    if {[llength $LaSelectionUnique] == 0} {
		Warne "$Nom pas de sequences a aligner"
		Sauve "NoSequencesToAlign" dans $FichierMSF
		continue
	    }
	}

	set Selection "$RepertoireDuGenome/protembl/$Nom $Nom 0.0 $NotreOS\n"
	append Selection [join $LaSelectionUnique "\n"]

	set StatusDbClustal [DbClustal $Nom $FichierMSF $Selection "AvecSelection"]
	if {$OnEffaceBallast && [file exists $FichierBallast]} {
	    File delete -force $FichierBallast
	    foreach FichierBallastExt [glob -nocomplain "$FichierBallast.*"] { 
		File delete -force $FichierBallastExt
	    }
	}

	if {$StatusDbClustal=="OK"} { continue }
	if {$StatusDbClustal=="PasDeSequencesAAligner"} {
	    Warne "$Nom pas de sequences a aligner ou erreur dans l'alignement."
	    Sauve "NoSequencesToAlignOrError" dans $FichierMSF
	    continue
	}
	if {$StatusDbClustal=="YaLog"} {
	    continue
	}
    }    


}

proc AlignonsLesParalogues {} {


    global RepertoireDuGenome
    global NotreOS
    global NotreOrga

    set FichierParalogues "$RepertoireDuGenome/fiches/paralogues.blastp"
    if { ! [file exists $FichierParalogues]} { LesParaloguesDuBlastP }
    Alignons Paralogues


}

proc AligntSeulContreTous {nm seq} {

    global OrdTmpDir

    set In1  [file join ${OrdTmpDir} tmp1]
    set In2  [file join ${OrdTmpDir} tmp2]
    set Out  [file join ${OrdTmpDir} tmp2g]
    set Log  [file join ${OrdTmpDir} tmp3]

    CreeLeTfa $In1

    set f [open $In2 w]
    puts $f ">$nm"
    set D 0
    while {$D < [string length $seq]} {
	set F [expr {$D + 59}]
	set L [string range $seq $D $F]
	puts $f "$L"
	incr D 60
    }
    close $f

    BatchClustalwProfile $In1 $In2 $Out $Log -outorder=input

    set tmp [DecortiqueUnMSF $Out NomSeq LesSeqAli]
    set LNewSeqAli [array get LesSeqAli]
    catch {file delete -force $In1 $In2 $Log $Out}

    return $LNewSeqAli

}

proc AllAboutMacsim {{Nom ""} {Qui ""} {Quoi ""}} {


    #rR Fait pour Kirsley pour avoir des enrigistrements à charger en une table SQL
    global AAM 
    if {[info exists AAM($Nom,$Qui,$Quoi)]} { return $AAM($Nom,$Qui,$Quoi) } 
    if {[info exists AAM($Nom,EstCharge)]}  { return "" }
    set AAM($Nom,EstCharge) 1

    set AccessReference [NIAG $Nom A]

    if {$Qui=="Unset"} {
	unset AAM
	return ""
    }

    if {$Qui=="" && $Quoi==""} { set Qui "ListOf" ; set Quoi "All" }

    set FicTfaCops [GscopeFile $Nom tfasdescopains]
    if {[FileExists $FicTfaCops]} {
	foreach Ligne [LesLignesDuFichier $FicTfaCops] {
	    append Ligne " ZZ=bidon"
	    if { ! [regexp {^>([^ ]+) } $Ligne Match Access]} { continue } 
	    if {[regexp {\|} $Access]} { lassign [split $Access "|"] Banque Access Id }
	    if {$Access==""} { continue }
	    if {$Access==$Nom} {
		set OX [NotreOX]
		set AAM($Nom,$Access,OX) $OX
		lappend AAM($Nom,$OX,ListOfAc) $Access
		lappend AAM($Nom,ListOf,OX) $OX
		continue
	    }	
	    set OX ""
	    if { ! [regexp { OX=([0-9]+)} $Ligne Match OX]} {
		set OSE ""
		if {[regexp { OS=([^=]+)=} $Ligne Match OSE]} {
		    regsub { [A-Z][A-Z]$} $OSE "" OS
		    set OX [Tax $OS TaxId]
		}
	    }
	    if {$OX==""} { continue }
	    set AAM($Nom,$Access,OX) $OX
	    lappend AAM($Nom,$OX,ListOfAc) $Access
	    lappend AAM($Nom,ListOf,OX) $OX
	}
	set AAM($Nom,ListOf,OX) [lsort -unique -integer $AAM($Nom,ListOf,OX)]
    }
    set LeTout {}
    set LesFT [FromMacsim $Nom ListOfFeatureType]
    foreach Access [FromMacsim $Nom ListOfNames] {
	set OX 0
	if {[info exists AAM($Nom,$Access,OX)]} { set OX $AAM($Nom,$Access,OX) }
	foreach FT $LesFT {
	    set LesFeatures [FromMacsim $Nom $FT $Access]
	    foreach Feature $LesFeatures {
		set LesV {}
		foreach {K V} [split $Feature " "] {
		    lappend LesV $V
		}
		set Valeurs [join $LesV "\t"]
		set Message "$Nom\t$OX\t$AccessReference\t$Access\t$Valeurs"
		lappend LeTout $Message
	    }
	}
    }
    set AAM($Nom,ListOf,All) [join $LeTout "\n"]
    #rR Pour ne pas mémoriser bêtement
    if { $Qui=="OnlyListOf" && $Quoi=="All" }  { set All $AAM($Nom,ListOf,All) ; unset AAM; return $All) } 
    if { $Qui=="ListOf" && $Quoi=="All" }  { return $AAM($Nom,ListOf,All) } 
    return [AllAboutMacsim $Nom $Qui $Quoi]


}

proc AllAboutMacsimPourTous {Fichier {Debut ""} {Fin ""}} {


    #rR Fait pour Kirsley pour avoir des enrigistrements à charger en une table SQL
    set LeTout {} 
    if {[regexp {\,} $Debut ]} {
	set Liste [split $Debut ","]
    } else {
	if {$Debut!=""} { incr Debut -1 }
	if {$Debut==""} { set Debut 0 }
	if {$Fin==""} { set Fin "end" }
	if {[regexp {^[0-9]+$} $Fin]} { incr Fin -1 }
	set Liste [lrange [ListeDesPABs] $Debut $Fin]
    }
    foreach Nom $Liste {
	Espionne $Nom
	set Un [AllAboutMacsim $Nom OnlyListOf All]
	if {$Un==""} { continue }
	AppendAuFichier $Fichier $Un
	AllAboutMacsim $Nom "Unset"
	FromMacsim "UnsetAll"
    }
    return $Fichier


}

proc AllAboutVE {} {


    FaireLire "Je ne sais pas ce que fait AllAboutVE ..."
    set LesLignes [list "VE\tProtein\tVector\tStart\tEnd\tPGS\tRec2\tDescription"]
    foreach VE [VE ListOf VE] {
	set Proteine [VE $VE "Protein"]
	set Vecteur [VE $VE "Vector"]
	set Bornes [VE $VE "Domain_Boundaries"]
	set Debut 1
	set Fin "98765"
	regsub "/" $Bornes " " Bornes
	scan $Bornes "%d %d" Debut Fin
	set Nom [NomDuAlias $Proteine]
	if {$Nom==""} { continue }
	Espionne "$Proteine $Nom"
	set Trouve 0
	foreach R2 [Rec2 $Nom LesRec2] {
	    set V2 [Rec2 $R2 Vecteur]
	    set Descr [Rec2 $R2 Description]
	    set PDF [StringApres " Ppcr for $Nom " dans $Descr]
	    set LesPDF [split $PDF "-"]
	    set D [lindex $LesPDF end-1]
	    set F [lindex $LesPDF end]
	    regsub -- "\\-$D\\-$F$" $PDF "" P
	    regsub ".$" $P "" P
	    if {[string equal -nocase $P $Proteine] && $D==$Debut && $F==$Fin} {
		set Trouve 1
		break
	    }
	}
	if { ! $Trouve} { continue }
	set Ligne "$VE\t$P\t$Vecteur\t$Debut\t$Fin\t$Nom\t$R2\t$Descr"
	lappend LesLignes $Ligne
    }
    return [SauveLesLignes $LesLignes dans "[RepertoireDuGenome]/fiches/AllAboutVE.csv"]


}

proc AllCC {} {


    set Lsys [lsort [glob [MiSynPatDir]/data/alignments/*_WithModules.xml]]
    
    file delete -force logc
    foreach file $Lsys {
	exec ordali $file -exe CompteConsDiscri -downloadpdb 0 >> logc
    }

    set Ll [LesLignesDuFichier logc]
    set Ls [lsearch -all $Ll "System *"]
    set Lres [list]
    foreach {d f} $Ls {
	lappend Lres {*}[lrange $Ll $d $f-1]
	lappend Lres {}
    }

    file delete cd.txt
    set o [open cd.txt w]
    puts $o [join $Lres \n]
    close $o

    exit


}

proc AllClustering {} {


    set Lf [glob ./hubert/mmaic/sel*_50..acc]
    set Lacc [list]
    foreach f $Lf {
	set Lacc [concat $Lacc [LesLignesDuFichier $f]]
    }

    set o [open "All_clustering.acc" w]
    puts $o [join $Lacc \n]
    close $o

    exit


}

proc AllCoMa {{Qui ""} {Quoi ""} {Frame ""} {CirCode ""}} {


    #rR Here we load all CodonMatrix array in one big array AllCoMa.
    global AllCoMa
    set Qui  [string toupper $Qui]
    set Quoi [string toupper $Quoi]
    if {[info exists AllCoMa($Frame,$Qui,$Quoi,$CirCode)]} { return $AllCoMa($Frame,$Qui,$Quoi,$CirCode) }
    if {[info exists AllCoMa("EstCharge")]} {
	if {$CirCode==""} {
	    set LeR {}
	    foreach CC [lrange [CirCode ListOf Index] 1 end] {
		lappend LeH [format "%-6s" $CC]
		lappend LeR [format "%-6s" [AllCoMa $Qui $Quoi $Frame $CC]]
	    }
	    return [join $LeH " "]\n[join $LeR " "]
	}
	return ""
    }
    set AllCoMa("EstCharge") 1
    set AllCoMa(LISTOF,CC) [CirCode ListOf Index]
    foreach CC [CirCode ListOf Index] {
	set CodonMatrixFile [CodonMatrixFileHuman $CC]
	if {[FileAbsent $CodonMatrixFile]} { continue }
	set CM [ContenuDuFichier $CodonMatrixFile]
	foreach {K V} $CM {
            if {[regexp "AAC,AAG" $K]} { Espionne $K $V }
	    set AllCoMa($K,$CC) $V
	}
    }
    return [AllCoMa $Qui $Quoi $Frame $CirCode]


}

proc AllEleGen {{Qui ""} {Quoi ""} {Ou ""}} {


    global AllEleGen
    #rR EleGene permet d'interroger tous les chromosomes en même temps
    #rR Ce n'est qu'une mémorisation de EleGen Chromo par Chromo 
    #rR Attention ! Pour le charger plus vite il exists un fichier Memo
    #rR Si onchange quelque chose (programme ou données de départ il faut le recharger
    #rR   pour cela qds Zero AllEleGen Redo_
    #rR   (doit être fait en qds (donc au nom de ripp) pour avoir les droits !!!!!!)

    set FichierMemo "[AnnotRep]/AllEleGen.txt"

    if {[regexp -nocase "^ReDo_" $Qui]} {
	if {[file exists $FichierMemo]} { file delete $FichierMemo }
	if {[info exists AllEleGen]} { unset AllEleGen } 
	regsub -nocase "^ReDo_" $Qui "" Qui
	return [AllEleGen $Qui $Quoi $Ou]
    }

    if {$Ou!=""} { set Ou [AnnotType $Ou "T"] }

    if {[info exists AllEleGen($Qui,$Quoi,$Ou)]} {
	if { 0 && [PourWscope]} { return "<pre>[join $AllEleGen($Qui,$Quoi,$Ou) \n]\n</pre>" }
	return $AllEleGen($Qui,$Quoi,$Ou)
    }
    if {[info exists AllEleGen("EstCharge")]}  {
	if { 0 && [info exists AllEleGen($Qui,$Quoi,)]} { Espionne coucou;  return $AllEleGen($Qui,$Quoi,) }
	return ""
    }
    set AllEleGen("EstCharge") 1

    if {[file exists $FichierMemo]} {
	array set AllEleGen [ContenuDuFichier $FichierMemo]
	return [AllEleGen $Qui $Quoi $Ou]
    }

    foreach Chr [lrange [ListOfChr] 0 end] {
	set LesGn [EleGen $Chr "F" ListOf Gn]
	set AllEleGen($Chr,ListOfGn,) $LesGn
	foreach Gn $LesGn {
	    lappend AllEleGen(ListOf,Gn,) $Gn
	    set AllEleGen($Gn,Chr,) $Chr
	    set AllEleGen($Gn,ListOfD,) [EleGen $Chr "F" $Gn ListOfD]
	    set AllEleGen($Gn,ListOfF,) [EleGen $Chr "F" $Gn ListOfF]
	    set Left  [lindex $AllEleGen($Gn,ListOfD,) 0]
	    set Right [lindex $AllEleGen($Gn,ListOfF,) end]
	    set AllEleGen($Gn,Cover,) "$Left $Right"
	    set AllEleGen($Gn,Size,) [expr $Right-$Left+1]
	}
	foreach T [AnnotType ListOf T] {
	    foreach Gn [EleGen $Chr $T ListOf Gn] {
		if {$Gn=="" || $Gn=="NA"} { continue }
		lappend AllEleGen(ListOf,Gn,$T) $Gn
		set AllEleGen($Gn,ListOfD,$T) [EleGen $Chr $T $Gn ListOfD]
		set AllEleGen($Gn,ListOfF,$T) [EleGen $Chr $T $Gn ListOfF]
		set Left  [lindex $AllEleGen($Gn,ListOfD,$T) 0]
		set Right [lindex $AllEleGen($Gn,ListOfF,$T) end]
		set AllEleGen($Gn,Cover,$T) "$Left $Right $Chr"
		set AllEleGen($Gn,Size,$T) [expr $Right-$Left+1]
		set AllEleGen($Gn,ListOf,Id) [EleGene $Chr $T $Gn ListOfId]
		foreach Id $AllEleGen($Gn,ListOf,Id) {
		    set AllEleGen($Id,Gn,)
		}
	    }
	    #rR on pourrait encore tout mémoriser pour les Id ...
	}
    }
    Sauve [array get AllEleGen] dans $FichierMemo
    return [AllEleGen $Qui $Quoi $Ou]


}

proc AllForGo {} {


    InformeFromOiPourTous
    InformeGoPourTous
    MyGenesFromGo
    MyGOsFromGene


}

proc AllGenesToTfa {Path} {



#Compteurs :
	set CompteurLus 0
	set CompteurEcrit 0


# Générer les requetes à partir des coordonnées
# =============================================
	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "$timestamp|AllGenesToTfa : Building genes queries"

	set FichierDesAccess [open "$Path.acc" "r"]
	set FichierDesRequetes [open "/tmp/AllGenesToTfa.bql" "w"]

	set CompteurLus 0
	while { [gets $FichierDesAccess Ligne1] >=0 } {
		ScanLaListe $Ligne1 Distance NM

		incr CompteurLus
	 	set Moins "-"
		set Plus "+"
		puts $FichierDesRequetes "ID * DB UCSC"
		puts $FichierDesRequetes "WH SQLNATIVE SELECT name FROM ucsc$Organism.refgene"
		puts $FichierDesRequetes "#"
	}
	close $FichierDesRequetes
	close $FichierDesAccess

	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "$timestamp|AllGenesToTfa : Executing NP queries"

	exec /biolo/bird/bin/birdql_client.sh /tmp/AllGenesToTfa.bql bird /tmp/AllGenesToTfa.res

	set FichierDesRequetesExecutees [open "/tmp/AllGenesToTfa.res" "r"]
	set FichierDesRequetes2 [open "/tmp/AllGenesToTfa2.bql" "w"]
	while { [gets $FichierDesRequetesExecutees Header]  >=0 } {
		gets $FichierDesRequetesExecutees NM
		puts $FichierDesRequetes2 "ID $NM DB REFSEQ"
		puts $FichierDesRequetes2 "FM FASTA"
		puts $FichierDesRequetes2 "LM 1"
		puts $FichierDesRequetes2 "#"
	}

	close $FichierDesRequetesExecutees
	close $FichierDesRequetes2

	exec /biolo/bird/bin/birdql_client.sh /tmp/AllGenesToTfa2.bql bird /tmp/AllGenesToTfa2.res

	set FichierDesRequetesExecutees2 [open "/tmp/AllGenesToTfa2.res" "r"]
	set FichierMiddle [open "$Path.mid" "w"]

	while { [gets $FichierDesRequetesExecutees2 Header]  >=0 } {
		puts $FichierMiddle $Header
		gets $FichierDesRequetesExecutees2 Sequence
		set Sequence [string trim $Sequence]
		puts $FichierMiddle $Sequence
	}

	close $FichierMiddle
	close $FichierDesRequetesExecutees2

	set FichierMiddle [open "$Path.mid" "r"]
	set FichierOut [open "$Path.tfa" "w"]

	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "$timestamp|AllGenesToTfa : Purging bird file"

	while { [gets $FichierMiddle LigneMiddle] >= 0} {
		if { $LigneMiddle != "" } {
			puts $FichierOut $LigneMiddle
		}
	}
	close $FichierOut
	close $FichierMiddle
	
	set timestamp [clock format [clock seconds] -format "%H:%M:%S"]
	Espionne "     - read : $CompteurLus"
	Espionne "     - found proteins : $CompteurProt"
	Espionne "     - blasted : $CompteurBlast"
	Espionne "     - written : $CompteurEcrits"
	Espionne "$timestamp|AllGenesToTfa : End"



}

proc AllGlobals {{Show ""}} {


    set Show [string equal -nocase $Show "Show"]
    set LeTexte {}
    foreach G [lsort [info globals]] {
	global $G
	if {[array exists $G]} {
	    lappend LeTexte "****************************** array $G"
	    foreach {C V} [lrange [array get $G] 0 19] {
		lappend LeTexte "   $C [string range $V 0 60]"
	    }
	    lappend LeTexte "************************************ $G"
	} else {
	    lappend LeTexte "$G [string range [set $G] 0 60]"
	}
    }
    set Texte [join $LeTexte "\n"]
    if {$Show} { return [AfficheVariable $Texte "" "AllGlobals"] }
    return $Texte


}

proc AllInMotif {{Qui ""} {Quoi ""}} {


    global AllInMotif
    if {[info exists AllInMotif($Qui,$Quoi)]} { return $AllInMotif($Qui,$Quoi) }
    if {[info exists AllInMotif("EstCharge")]} { return "" }
    array set AllInMotif [ContenuDuFichier [AllInMotifFile]]

    set Qui  [string toupper $Qui]
    set Quoi [string toupper $Quoi]

    foreach {K V} [array get AllInMotif] {
	lassign [split $K ","] Nom Frame Access Position
	#Espionne  $K $Nom $Frame $Access $Position
	set NOM    [string toupper $Nom]
	set ACCESS [string toupper $Access]
	lappend AllInMotif(LISTOF,NOM)                    $Nom
	lappend AllInMotif($NOM,LISTOFACCESS)             $Access
	lappend AllInMotif($NOM,LISTOFFRAME)              $Frame
	lappend AllInMotif($NOM-$Frame,LISTOFPOS)         "$Position $Access"
	lappend AllInMotif($NOM-$ACCESS-$Frame,LISTOFPOS) $Position
    }
    set AllInMotif(LISTOF,NOM) [lsort -unique $AllInMotif(LISTOF,NOM)]
    foreach Nom $AllInMotif(LISTOF,NOM) {
	set AllInMotif($NOM,LISTOFACCESS) [lsort -unique $AllInMotif($NOM,LISTOFACCESS)]
	set AllInMotif($NOM,LISTOFFRAME)  [lsort -unique $AllInMotif($NOM,LISTOFFRAME)]
	foreach Access $AllInMotif($NOM,LISTOFACCESS) {
	    set ACCESS [string toupper $Access]
	    foreach Frame $AllInMotif($NOM,LISTOFFRAME) {
		set AllInMotif($NOM-$ACCESS-$Frame,LISTOFPOS) [lsort -integer $AllInMotif($NOM-$ACCESS-$Frame,LISTOFPOS)]
	    }
	}
	foreach Frame $AllInMotif($NOM,LISTOFFRAME) {
	    #Espionne $NOM-$Frame,
	    #Espionne $AllInMotif($NOM-$Frame,LISTOFPOS)
	    set AllInMotif($NOM-$Frame,LISTOFPOS) [lsort -integer -index 0 $AllInMotif($NOM-$Frame,LISTOFPOS)]
	    #Espionne $AllInMotif($NOM-$Frame,LISTOFPOS)
	}
    }
    set AllInMotif("EstCharge") 1
    return [AllInMotif $Qui $Quoi]


}

proc AllInMotifFile {{CC ""}} {


    if {$CC==""} { set CC [CirCode "DefaultCirCode"] }
    return "[RepertoireDuGenome]/${CC}_AllInMotif.txt"


}

proc AllInteractions {FichierSortie Org Seuil} {


    CanalSqlString
    set TaxId [TaxIdOrg $Org]   
    regsub " " $Org "_" Org
    foreach {Pi1 Pi2 Cs} [SqlExec "select protein_id_a,
    protein_id_b,
    combined_score
    from 
    network.protein_protein_links
    where
    combined_score >= '$Seuil'
    and protein_id_a in (select protein_id from items.proteins_names where species_id = $TaxId) 
    order by combined_score DESC;" "GetList"] {
	set Pn1 [PreferredName $Pi1 $Org]
	set Pn2 [PreferredName $Pi2 $Org]
	set Ligne "$Pi1\t$Pn1\t$Pi2\t$Pn2\t$Cs"
	lappend LesLignes $Ligne
    }
    SauveLesLignes $LesLignes dans $FichierSortie
    CanalSqlDisconnect  


}

proc AllPromotorsATCGbackground {Path Organism Upstream Downstream {Database GeCo}} {


	
	Espionne "WhatIsMyATCGbackground: Start"
	set FichierDesRequetes [open "/tmp/WhatIsMyATCGbackground.bql" "w"]
	set RequetesExecutees "/tmp/WhatIsMyATCGbackground.res"
	Espionne "WhatIsMyATCGbackground: Building queries"
	puts $FichierDesRequetes "ID * DB UCSC"
	puts $FichierDesRequetes "WH SQLNATIVE SELECT chrom, txStart, txEnd, strand FROM ucsc$Organism.$Database where typegene ='Protein' order by chrom, txStart"
	puts $FichierDesRequetes "LM 35000"
	puts $FichierDesRequetes "//"
	close $FichierDesRequetes
	
	Espionne "WhatIsMyATCGbackground: Executing queries"
	#BirdFetch "/tmp/WhatIsMyATCGbackground.bql" "/tmp/WhatIsMyATCGbackground.res"
	
	set FichierDesRequetesExecutees [open "$RequetesExecutees" "r"]
	set FichierDesCoordonnees [open "$Path.coo" "w"]
	gets $FichierDesRequetesExecutees Ligne
	
	Espionne "WhatIsMyATCGbackground: Writing coordinates"
	set I 0
	while { [gets $FichierDesRequetesExecutees Ligne] > 0 } {
		incr I
		ScanLaPipe $Ligne chrom txStart txEnd strand
		if { $strand == "+"} {
			set TSS $txStart
			set promotorStart [expr $TSS - $Upstream]
			set promotorEnd [expr $TSS + $Downstream]
		} else {
			set TSS $txEnd
			set promotorEnd [expr $TSS + $Upstream]
			set promotorStart [expr $TSS - $Downstream]
		}
		puts $FichierDesCoordonnees "$I $chrom $promotorStart $promotorEnd $strand"
	}
	close $FichierDesCoordonnees
	#GetProm "$Path" 0 0
	set FichierDesSequences [open "$Path.pro" "r"]
	set A 0
	set T 0
	set C 0
	set G 0
	set Chars 0
	Espionne "WhatIsMyATCGbackground: Counting letters"
	while { [gets $FichierDesSequences Header] > 0 } {
			gets $FichierDesSequences Sequence
			set CharArray [split $Sequence ""]
			foreach Char $CharArray {
				
				if { $Char == "A" } {
					incr A
					incr Chars
				}
				if { $Char == "T" } {
					incr T
					incr Chars
				}
				if { $Char == "C" } {
					incr C
					incr Chars
				}
				if { $Char == "G" } {
					incr G
					incr Chars
				}
			}
	}
	set FA [expr (100*$A)/$Chars]
	set FT [expr (100*$T)/$Chars]
	set FC [expr (100*$C)/$Chars]
	set FG [expr (100*$G)/$Chars]
	Espionne "WhatIsMyATCGbackground: A=$FA"
	Espionne "WhatIsMyATCGbackground: T=$FT"
	Espionne "WhatIsMyATCGbackground: C=$FC"
	Espionne "WhatIsMyATCGbackground: G=$FG"
	Espionne "WhatIsMyATCGbackground: End"


}

proc AllToTitle {Texte} {


    set AlphAvant 0
    foreach C [split $Texte ""] {
	if {$AlphAvant} {
	    append Nouveau [string tolower $C]
	} else {
	    append Nouveau [string toupper $C]
	}	    
	set AlphAvant [regexp -nocase {[a-z]} $C]   
    }
    return $Nouveau


}

proc All_bz {PhyloTree All_bzLogFile} {


    ### all_bz program execution from the TBA suite ###
    # generates all blastz commands for pairs of specified sequences #
    Espionne "All_bz ..."
    #set Commande "exec [PATH all_bz] + \"$PhyloTree\" >& $All_bzLogFile" 
    set Commande "exec all_bz + \"$PhyloTree\" >& $All_bzLogFile" 
    puts $Commande
    if {[catch {eval $Commande} Message]} {Espionne $Message;return} 
    return 


}

proc AllerRetour {In {Out ""} {N ""}} {


    if {$Out==""} { set Out "${In}_new" }
    if {$N==""} { set N 1 }
    set Liste [LesLignesDuFichier $In]
    set ListeRetourne [RetourneLaListe $Liste]
    set LiiL [concat $Liste $ListeRetourne]
    set Finale {}
    foreach i [NombresEntre 1 $N] {
	set Finale [concat $Finale $LiiL]
    }
    return [SauveLesLignes $Finale dans $Out]


}

proc AllowIllegalCharactersInTFA {{Valeur ""}} {


    global AllowIllegalCharactersInTFA
    if { $Valeur=="ResetAllValues"} {
	if {[info exists AllowIllegalCharactersInTFA]} { unset AllowIllegalCharactersInTFA }
	set Valeur 0
    }
    if { ! [info exists AllowIllegalCharactersInTFA]} {
	set AllowIllegalCharactersInTFA(Level) 1
	set AllowIllegalCharactersInTFA(1) 0
    }
    if {[regexp "Previous" $Valeur]} {
	if {$AllowIllegalCharactersInTFA(Level)>1} { incr AllowIllegalCharactersInTFA(Level) -1 }
	return [AllowIllegalCharactersInTFA]
    }
    if {$Valeur!=""} {
	if {[regexp -nocase {[1YVA]} $Valeur]} { set Valeur 1 } else { set Valeur 0 }
	incr AllowIllegalCharactersInTFA(Level)
	set AllowIllegalCharactersInTFA($AllowIllegalCharactersInTFA(Level)) $Valeur 
    }
    return $AllowIllegalCharactersInTFA($AllowIllegalCharactersInTFA(Level))


}

proc AllumeLaSelection {K PAB LesDirs} {



    Wup "Highlight les oligos deja selectionnes (fichier .selection) en distinguant les differentes sources" 

    DeselectionneLesSelectionnes $K

    foreach Dir $LesDirs {
	set FichierSelection "$Dir/${PAB}.selection"
	if {![file exists $FichierSelection]} {continue}
	
	set F [open "$FichierSelection"]
	while {[gets $F Ligne]>=0} {
	    if {! [regexp -nocase {[a-z]+ || [0-9]+}  $Ligne]} {continue}
	    if {  [string range $Ligne 0 0] != ">"}            {continue}
	    if {  [regexp -nocase "NoOligo"           $Ligne]} {break}
	    set LigneSplitee [split  $Ligne "\t"]
	    set Entete       [lindex $LigneSplitee 0]
	    set NomOligo     [lindex $Entete 1]
	    
	    set         LesId [$K find withtag "$NomOligo && Boite && $Dir"]
	    foreach Id $LesId {
		set MesTags [$K gettags $Id]
		$K itemconfigure $Id -outline "black" 
		$K itemconfigure $Id -width   "2" 
		$K itemconfigure $Id -dash    {6 4 2 4}
		$K addtag "Selected" withtag $Id
	    }
	}
	close $F
    }
    return ""


}

proc AllumeLaXSelection {K PAB LesDirs} {



    Wup "Highlight les oligos croisee deja selectionnes (fichier .croisee) en distinguant les differentes sources" 

    DeselectionneLesXSelectionnes $K

    foreach Dir $LesDirs {
	set FichierSelection "$Dir/$PAB.croisee"
	if {![file exists $FichierSelection]} {continue}
	set F [open      "$FichierSelection"]
	while {[gets $F Ligne]>=0} {
	    if {! [regexp -nocase {[a-z]+ || [0-9]+}  $Ligne]} {continue}
	    if {  [string range $Ligne 0 0] != ">"}            {continue}
	    if {  [regexp -nocase "NoOligo"           $Ligne]} {break}
	    set LigneSplitee [split  $Ligne "\t"]
	    set Entete       [lindex $LigneSplitee 0]
	    set NomOligo     [lindex $Entete 1]
	    
	    set         LesId [$K find withtag "$NomOligo && Boite && $Dir"]
	    foreach Id $LesId {
		set MesTags   [$K gettags $Id]
		set MesCoords [$K coords $Id]
		set Xmin [lindex $MesCoords 0]
		set Xmax [lindex $MesCoords 2]
		set Ymin [expr [lindex $MesCoords 1]-([lindex $MesCoords 3]-[lindex $MesCoords 1])/4]
		set Ymax [expr [lindex $MesCoords 3]+([lindex $MesCoords 3]-[lindex $MesCoords 1])/4]
		$K create line $Xmin $Ymin $Xmax $Ymax  -tags [list "XSelect" "Trace" "$NomOligo"]  -fill "black" -width 4
		$K create line $Xmin $Ymax $Xmax $Ymin  -tags [list "XSelect" "Trace" "$NomOligo"]  -fill "black" -width 2
		$K addtag "XSelect" withtag $Id
	    }
	}
	close $F
    }
    return ""


}

proc AlphaNum {} {


    global TokCourant
    
    set Courant ""
    if {[regexp -nocase {[a-z_]} $TokCourant]} {
	set Courant $TokCourant
    }
    if {$Courant==""} {	return "AlphaNumNonValideCarNonAlphaEnDebut" }
    while {[regexp -nocase {[a-z_0-9]} [Tok]]} {
	append Courant $TokCourant
    }
    return $Courant


}

proc AlviCreePpcrProt {} {


    set RepPpcrProt "[RepertoireDuGenome]/ppcrprot"
    foreach Nom [ListeDesPABs] {
	set TfaPpcr [ContenuDuFichier [GscopeFile $Nom "ppcr"]]
	set Entete  [EnteteDuTexteTFA $TfaPpcr]
	set PcrNuc  [QueLaSequenceDuTexteTFA $TfaPpcr]
	set PosATG  [string first "ATG" $PcrNuc]
	set PosStop [StopProchain $PcrNuc $PosATG]
	incr PosStop -1
	if {$PosStop <0} { set PosStop "end" } 
	set PcrPro [SeqNucToSeqPro [string range $PcrNuc $PosATG $PosStop]]
	set TfaPpcrProt [SequenceFormatTFA $PcrPro $Entete "protbrut"]
	Espionne $TfaPpcrProt
	Sauve $TfaPpcrProt dans "$RepPpcrProt/$Nom"
    }


}

proc AlviVerif {} {


    foreach Ligne [LesLignesDuFichier "[Fiches]/OligosF.csv"] LigneR [LesLignesDuFichier "[Fiches]/OligosR.csv"] {
	ScanLaListe [split $Ligne ";"]  OligoNameF OligoF Bidon1 Bidon2 Bidon3 NotesF
	regexp {BOX[0-9]+} $NotesF Nom
	ScanLaListe [split $LigneR ";"] OligoNameR OligoR Bidon1 Bidon2 Bidon3 NotesR
	set OligoRSens [NucToReverseAndComplementNuc $OligoR]
	regexp {BOX[0-9]+} $NotesR NomR
	if {$Nom!=$NomR} { FaireLire COUCOU }

	set SeqOliNucF [QueLaSequenceDuFichierTFA [GscopeFile $Nom "nucoligo"]]
	regsub {^ATG} $SeqOliNucF "" SeqF
	regsub {.+CATATG} $OligoF "" SeF

	set SeqOliNucR [QueLaSequenceDuFichierTFA [GscopeFile $Nom "nucoligo"]]
	set SeR [string range $SeqOliNucR end-25 end]

	Espionne
	Espionne "$OligoNameF $OligoF [string range $NotesF 0 60]"
	Espionne "                                 $SeF"
	Espionne "                               [string range $SeqF 0 20]"
	Espionne "$OligoNameR $OligoRSens [string range $NotesR 0 60]"
	if {[regexp "RunOff" $NotesR]} { set SeR "RunOff" }
	Espionne "        $SeR"
    }


}

proc AlwaysTrue {Nom} {


    return 1


}

proc AmontAval {TypeDeSequence NomFichier} {



# Cree deux fichiers avec les SBS avant et apres les genes

# Déclaration des fichiers
set PathIn "/tmp/Conservation/Implications/"

set FichierDes230000enrichi [open "$PathIn$TypeDeSequence/$NomFichier" "r"]
set FichierDesSequencesUpstream "$PathIn$TypeDeSequence/Upstream$NomFichier"
set FichierDesSequencesDownstream "$PathIn$TypeDeSequence/Downstream$NomFichier"
set PathOut1 $FichierDesSequencesUpstream
set PathOut2 $FichierDesSequencesDownstream

# Suppressions des éventuelles versions précédentes des fichiers
if { [file exists $FichierDesSequencesUpstream] } {
	file delete $FichierDesSequencesUpstream
}
if { [file exists $FichierDesSequencesDownstream] } {
	file delete $FichierDesSequencesDownstream
}

while { [gets $FichierDes230000enrichi Ligne]  >=0 } {
	set DistanceAlaBorneDeExonOuIntron -999999999999999
	ScanLaListe $Ligne StafID ChromosomeH StartH EndH Acc Deb Fin Orientation Distance ExonOuIntron CdsOuPas UtrOuPas DebutExonOuIntron FinExonOuIntron DebutOuFinExonOuIntron DistanceAlaBorneDeExonOuIntron OccupationExonOuIntron
if { $DistanceAlaBorneDeExonOuIntron == -999999999999999 } {
		if { $Distance <= 0 } {
			AppendAuFichier $FichierDesSequencesUpstream $Ligne
		} else {
			AppendAuFichier $FichierDesSequencesDownstream $Ligne
		}
	}
}
Espionne ""
Espionne "Execution terminee ! Fichier écrit dans $PathOut1 et $PathOut2"


}

proc AnaBalAgent {} {

    global db

    package require sqlite3
    set db root
    sqlite3 $db res.sql

    set Lmat [ListeDesMatrices]
    set Lsco [ListeDesScores]
    set Lwgt [list 0 1]
    set Llen [ListeDesMotiflen]
    
    $db eval {begin transaction}
    
    set Ldata [ListeDesDatasets]
    lappend Ldata ""
    foreach data $Ldata {
	set Lres {}
	puts "\nDataset $data"

	set Lbck [ListeDesPkBlocksCommuns $data]

	set nbck [llength $Lbck]
	puts "nbck $nbck"
	if {$Lbck == {} } {
	    puts "no files !"
	    continue
	}
	
	foreach {pkana sco mat wgt len} [$db eval {select * from analyse}] {
	    set nns0 0 ; set nns1 0 ; set nns2 0
	    foreach pkbck $Lbck {
		lassign [$db eval {select min(rank), pk_segment, nsup, max from segment where pk_block = $pkbck and pk_analyse = $pkana}] minrk pkseg nsup max
		if {$minrk == ""} {
		    continue
		    puts ">$minrk >$nsup >$max"
		    puts "$pkbck $pkana"
		    puts [$db eval {select * from block where pk_block = $pkbck}]

		    exit
		}
		if {$minrk == 0.0} {
		    incr nns0
		} else {
		    incr nns1 $nsup
		    incr nns2 $max
		}
	    }
	    
	    lappend Lres $sco $mat $wgt $len [expr {100*$nns0/$nbck}] [expr {$nns1/($nbck - $nns0)}] [expr {$nns2/($nbck - $nns0)}] $nbck
	}

	set Lres [lsort -stride 8 -index 4 -integer $Lres]
	set fmt "%8s %12s"
	foreach {sc mat wgt len pc pc1 pc2 ns} $Lres {
	    puts "[format $fmt $sc $mat] $wgt $len | $pc $pc1 $pc2 $ns"
	}
    }
    $db eval {commit}
    $db close
        
    exit

}

proc AnaMeth {} {

    DefinitionPreferences
    set Llim -99999999999.
    set v -2.0
    while {$v < 2.01} {
	lappend Llim $v $v
	set v [expr {$v + 0.1}]
    }
    lappend Llim 99999999999.

    set LMethods [list Norm Thompson Ranganatan VolPol Liu Liu2 RPCA Entrop1 Entrop2 EnpCube]
    foreach meth $LMethods {
	puts "\n$meth"
	set Ll [LesLignesDuFichier ${meth}.dat]
	set ListeV [list]
	foreach l $Ll {
	    lappend ListeV [split $l \t]]
	}
	puts "  ncol in [llength [lindex $ListeV 0]]"
	#set Lgr [Tclcluspack $ListeV -dt coordinates -cm mm -nbc aic -wc]
	exec /biolo/cluspack/binNew/cluspack $meth.dat -dt=coordinates -cm=mm -nbc=aic -wc
	set Ll [LesLignesDuFichier $meth.clu]
	set Lv [list]
	set Lgr [list]
	foreach l [lrange $Ll 2 end] {
	    set l [string trim $l]
	    if {$l eq ""} {continue}
	    if {[regexp {^Cluster} $l]} {
		if {$Lv != {}} {
		    lappend Lgr $Lv
		}
		set Lv [list]
		continue
	    }
	    lappend Lv [split $l \t]
	}
	lappend Lgr $Lv
	puts "  nbr clusters [llength $Lgr]"
	set Nj [llength [lindex [lindex $Lgr 0] 0]]
	puts "  ncol out $Nj"
	set Lx [list]
	for {set x 1} {$x < $Nj} {incr x} {
	    lappend Lx $x
	}
	set i 1
	set Ly [list]
	foreach g $Lgr {	    
	    set Nv [llength $g]
	    puts "  cluster $i : $Nv"
	    set ylab "cluster $i - $Nv"
 	    if {$Nv < 5} {
		continue
	    }
	    set Lyv [list]
	    for {set j 1} {$j < $Nj} {incr j} {
		set Lv [ExtraitListeDeListe $g $j]
		set mx [expr max([join $Lv ,])]
		set S [::tcl::mathop::+ {*}$Lv]
		lappend Lyv [expr {$S/$Nv*100.}]
	    }
	    set sum [expr [join $Lyv +]]
	    set titre "$meth - cluster $i"
	    if {$i == 1} {
		set col black
	    } else {
		set col [CouleurDuGroupe $i]
	    }
	    lappend Ly [list $Lyv $col $ylab]
	    incr i
	}
	DoRPlot $Lx $Ly $titre "${meth}.pdf"
    }
    
    exit

}

proc AnaPfam {} {

    global LNOrdali LSOrdali TDesPCI

    set fmt "%8s %6d %4d %6d %6d %6.2f %6.2f"
    set Ll [LesLignesDuFichier Summary_Pfam.txt]
    set o [open Summary_Pfam2.txt w]
    foreach l $Ll {
	regsub -all { +} [string trim $l] " " l
	lassign [split $l " "] pf nseq lgt maxg ming
	puts "Traite $pf :"
	puts "   nseq $nseq"
	puts "   lgt  $lgt"
	puts "   maxg $maxg"
	puts "   ming $ming"
	set f [file join /home moumou work moumou BenchPfam $pf]
	puts "   file $f"
	set LNOrdali [list]
	DecortiqueUnTFA $f LNOrdali Sequences
	set SAli [list]
	set LSOrdali [list]
	foreach n $LNOrdali {
	    lappend SAli $n [set Sequences($n)]
	    lappend LSOrdali [set Sequences($n)]
	}
	CalculeLesPCIGenerique $SAli TDesPCI
	#CalculeLesPCI "" "" "" "" 1

	# moyenne et ecart-type
	set i 1
	set m 0.
	set s2 0.
	foreach n1 [lrange $LNOrdali 0 end-1] {
	    foreach n2 [lrange $LNOrdali $i end] {
		set v [lindex [set TDesPCI($n1,$n2)] 0]
		set m  [expr {$m + $v}]
		set s2 [expr {$s2 + $v*$v}]
	    }
	    incr i
	}
	set Ni [expr {$nseq*($nseq-1)/2}]
	set m [expr {$m/$Ni}]
	set sd [expr {100.*sqrt($s2/$Ni - $m*$m)}]
	set m  [expr {100.*$m}]
	puts " --> m - sd : [format %6.2f $m] [format %6.2f $sd]"
	puts ""
	puts $o [format $fmt $pf $nseq $lgt $maxg $ming $m $sd]
	unset Sequences
	unset TDesPCI
	update
    }

    close $o
    
    exit

}

proc AnaPrePro {} {

    package require sqlite3
    set db root
    sqlite3 $db dbdg.sql
    $db eval {begin transaction}

    set Ljrn [lsort -integer [$db eval {select distinct jrn from prepro}]]
    set fmt "%1d %1d %4.1f %9s %1d %5.1f %5.1f"
    foreach jrn $Ljrn {
	set Lval [$db eval {select analyse,pca,zero,scale,weight,initval,finalval from prepro where jrn=$jrn order by finalval, initval}]
	puts "\n$jrn [expr {[llength $Lval]/6}]"
	foreach {ana pca zero scale wgt init final} $Lval {
	    puts [format $fmt $ana $pca $zero $scale $wgt $final $init]
	}
    }

    exit

}

proc AnaProsite {} {


    package require sqlite3

    set db root
    sqlite3 $db /home/moumou/Prosite/Prosite.sql

    set Lp [$db eval {select accession, pattern, uniprot_id, uniprot_type from prosite where type = 'PATTERN'}]
    puts "[llength $Lp]"
    set pris 0
    foreach {ac pat lid ltype} $Lp {
	if {! [regexp {\[} $pat]} {continue}
	if {[regexp {\{} $pat]} {continue}
	if {$lid == "NULL"} {continue}
	set Lbid {}
	foreach id $lid ty $ltype {
	    if {$ty eq "N" || $ty eq "P" || $ty eq "T"} {
		lappend Lbid $id
	    }
	}
	if {[llength $Lbid] < 10} {continue}

	incr pris
	puts "$ac"
	puts "$pat"
	puts "lg $ac [llength $Lbid]"
	puts ""
    }

    puts "nb bons prosite : $pris"

    exit

}

proc AnaResKangSoTOL {} {


    global TaxRoot Tx

    set args {-root 2759 -txdb uniprot}
    if {! [CheckSampleTOLParameters {*}$args]} {
	puts "bad checking return"
	
	return ""
    }
    
    InitTaxDB
    puts "[DonneDateEtHeure]"
    AttachTaxonomyToDB
    set TaxRoot [SetTaxRoot]
    puts "TaxRoot $TaxRoot TaxDB2Mem"
    TaxDB2Memory

    puts "Kang :"
    set Lid [LesLignesDuFichier euk.smp]
    set Lk [list]
    foreach id $Lid {
	set Lv [DonneGenealogieMem $id]
	lappend Lk [llength $Lv]
    }

    #set Ll [LesLignesDuFichier sotol-taxids.csv]
    set Ll [LesLignesDuFichier out.tax]
    set Ls [list]
    foreach l $Ll {
	if {! [regexp {^[0-9]} $l]} {
	    continue
	}
        #lassign [split $l \t] id name tmp lin
	set id $l
	set Lv [DonneGenealogieMem $id]
	lappend Ls [llength $Lv]
    }

    lassign [CreeHistogrammeVal $Lk 10] bk yk sk
    lassign [CreeHistogrammeVal $Ls 10] bs ys ss
    puts "kang:"
    #puts "bk $bk\nyk $yk\nsk $sk"
    set fmtB [string repeat " %4.1f" [llength $bk]]
    set fmtY [string repeat " %3d " [llength $yk]]
    puts [format $fmtB {*}$bk]
    puts "  [format $fmtY {*}$yk]"

    puts "sotol"
    puts [format $fmtB {*}$bs]
    puts "  [format $fmtY {*}$ys]"
    
    exit


}

proc AnaTaxId {} {


    source euka.taxid
    foreach a [array names TT] {
	lappend Lt [set TT($a)]
    }

    set Lt [lsort -unique -index 1 $Lt]
    puts "[llength $Lt]"
    puts "[join $Lt \n]"

    return


}

proc AnalyseBalibaseAgent {} {

    global TabSF LNOrdali
    
    CacheStrSecDansAlignement

    foreach b [array names TabSF "*,BLOCK"] {
	lassign [split $b ,] seq tmp
	
	foreach f $TabSF($b) {
	    DecortiqueUneFeature $f dg fg col sc nt
	    lappend Block($dg,$fg) $seq
	}
    }

    # cheche block communs
    set nSeq [llength $LNOrdali]
    set Lbck [list]
    foreach k [array names Block] {
	if {[llength $Block($k)] == $nSeq} {
	    lassign [split $k ,] dg fg
	    puts "=> $k"
	    lappend Lbck $dg $fg
	}
    }

    set lgt [LongueurDeLAlignement]
    for {set i 0} {$i < $lgt} {incr i} {
	set p$i 0
    }
    foreach {d f} $Lbck {
	#lassign [split $k ,] d f
	for {set j $d} {$j <= $f} {incr j} {
	    set p$j 1
	}
    }
    set dep -1 ; set fin -1
    for {set i 0} {$i < $lgt} {incr i} {
	if {[set p$i]} {
	    puts "p$j"
	    if {$dep == -1} {
		set dep $i
	    }
	} else {
	    if {$dep != -1} {
		set fin [expr {$i-1}]
		puts "$dep - $fin"
		set dep -1
	    }
	}
    }
	    


    
    #exit

}

proc AnalyseCoreBlocksAgent {Lblocks} {

    global TAg T LNOrdali MotifLen

    set Lres [list]
    foreach {d f} $Lblocks {
	if {($f - $d + 1) < $MotifLen} {
	    continue
	}
	puts "\nBlock : $d --- $f"
	set Lbck [list Block $d $f]
	set LLag [AgentsDuBlock $d $f]

	set log "Block $d $f"
	set Lseg [list]
	set iDep $d
	foreach Lag $LLag {
	    #puts "Lag: $Lag"
	    #set log [RankBlockChaines $Lag]
	    #set rep [RankBlockAllConnectes $Lag]
	    set rep [RankBlockAllConnectes2 $Lag]
	    if {$rep == -1} {
		lappend log "not all connected"
	    } else {
		lassign $rep srk min max nZero nSup
		lappend log "rank all $iDep [format %8.3f $srk] $min $max $nZero $nSup"
		lappend Lseg [list $MotifLen $srk $min $max $nZero $nSup]
	    }
	    puts [join $log \n]
	    set log {}

	    incr iDep
	}
	lappend Lbck $Lseg
	lappend Lres $Lbck
    }

    return $Lres

}

proc AnalyseFichierBalibase {{args ""}} {

    global Mbl Cbl MotifLen LNOrdali Sequences Lref Sref

    LesDefauts Mode batch
    LesDefauts TypeAli XML
    LesDefsAlA
    #LesDefauts FichierXML $f

    # override MotifLen
    if {$args ne ""} {
	lassign $args f len deb fin matrix typeScore Wgt
	set MotifLen $len

	set Lbornes [list $deb $fin]
    } else {
	# defauts
	set MotifLen 13
	set matrix blosum62
	set deb ""
	set typeScore sop
	set Wgt 0

	set Lbornes [CoreBlocksDuXML]
    }

    set ok [DecortiqueXmlAgent $f]
    if {$ok == 0} {
	puts "Problem loading alignment !"
	puts "file : $f\n"

	return [list]
    }
    
    puts "f= $f MotifLen $MotifLen"
    set lgt [LongueurDeLAlignement]
    set nbS 0
    foreach n $::LNOrdali {
	if {$n ne ""} {incr nbS}
    }

    set Lres [list $f $nbS $lgt $len $matrix $typeScore $Wgt]
    
    InitMatrix $matrix

    set RenameSeq   1

    if {0} {
	array set Sref [array get Sequences]
	set Ltmp {}
	foreach n $LNOrdali {
	    if {$n ne ""} {lappend Ltmp $n}
	}
	set LNOrdali $Ltmp
	foreach n $LNOrdali {
	    set s [string map {"." ""} $Sequences($n)]
	    set Sequences($n) $s
	}
	
	#set ok [SequencesPourAgent "" $RenameSeq]
    }
    
    SequencesPourAgent "" 1

    # 1: poids gaussiens, 0 : 1.0 pour chqeue pos
    #InitWg 1
    #InitWg 0
    InitWg $Wgt

    InitTypeScore $typeScore

    set nAgents [InitAgentsAnaBal]
    set nball [expr {$nAgents * $nAgents}]
    puts "all pairs          $nball"
    puts "n/2 pairs          [expr {$nAgents * $nAgents/2}]"
    set nab 0
    foreach {d f} $Lbornes {
	set LLag [AgentsDuBlock $d $f]
	foreach lag $LLag {
	    incr nab [llength $lag]
	}
    }
    puts "agents dans block  $nab"
    puts "nblock * agents    [expr {$nab * $nAgents}]"
    #exit
    
    #::profiler::reset
    if {$deb eq ""} {
	ComputeScoreAllPairsAgents $Lbornes
    } else {
	ComputeScorePairsDuBlockAgents $deb $fin
    }
    #AfficheProfileResults

    set ok [AnalyseCoreBlocksAgent $Lbornes]
    if {$ok == 0} {
	puts "Problem in dblock !"
	return 0
    } else {
	lappend Lres $ok
    }
    
    if {0} {
	set lor [lsort [lor [info globals] $::VariablesAuDepart]]
	#puts "\nlor\n[join $lor \n]"
	foreach v $lor {
	    if {$v eq "VariablesAuDepart"} {
		puts "FOUND !"
		continue
	    }
	    if {[array exists ::$v]} {
		#puts "delete $v"
		array unset ::$v
	    }
	    unset -nocomplain ::$v
	}
	
	#puts "verif [join [lsort [lor $::VariablesAuDepart [info globals]]] \n]"
	update
    }

    puts "FinalResult\n$Lres"

    #exit
    return $Lres

}

proc AnalyseGlobaleOverlap {FichierOverlap {TumorType 3T} {IntMin 0} {FCAffy 0.0} {FCDD 0.0}} {


    #FichierOverlap=/OVERLAP931NEW/Overlap.final (333 overlaps DD-Affy avec les profils etc...)
    #HOP: a ajouter aux genes correles car la RT-PCR a nie le profil du gel DD
    #aucune target Affy dont les 4 valeurs de detection egales A ou M n'est acceptee
    #TumorType: E, S, ou U, ou 3T (moy des 3 T)

    # ---
    #set Fichier "[RepertoireDuGenome]/OVERLAP931NEW/820DD.27may05"
    #set L [CreeListePourFichierAUneColonne $Fichier] 
    #foreach DD $L {set Vu($DD) 1}
    # ---
    set NbComparaisons 0
    set NbMemeProfil 0
    set NbN 0
    set NbT 0
    set TN 0
    set NT 0
    set LesFaibles ""
    set Liste ""
    set n 0
    set nbcomplexes 0
    foreach Ligne [LesLignesDuFichier $FichierOverlap] {
	set Ligne [string trim $Ligne]
	if {$Ligne ==""} {continue}
	set LesChamps [split $Ligne "\t"]
	incr n
	#1: Exclure les affy non detectes (que des A ou M)
	set dd [lindex $LesChamps 1]
	# Ajout ---
	#if {![info exists Vu($dd)]} {continue}
	# Fin ajout ---
	set TAR [lindex $LesChamps 2]
	set Detn [lindex $LesChamps 22]
	set Dete [lindex $LesChamps 23]
	set Dets [lindex $LesChamps 24]
	set Detu [lindex $LesChamps 25]
	if {($Detn=="A" || $Detn=="M") &&  ($Dete=="A" || $Dete=="M") &&  ($Dets=="A" || $Dets=="M") &&  ($Detu=="A" || $Detu=="M")} {
	    lappend LesAbsents $TAR
	    continue
	}

	#2: Exclure les overlaps avec FC inferieur au seuil fixe
	####a:recup data Fold DD et Affy
	if {$TumorType=="E"} {
	    set FoldAffy [lindex $LesChamps 30]
	    set FoldDD [lindex $LesChamps 10]
	    set ProfilAffy [lindex $LesChamps 31]
	    set ProfilDD [lindex $LesChamps 11]
	}
	if {$TumorType=="S"} {
	    set FoldAffy [lindex $LesChamps 32]
	    set FoldDD [lindex $LesChamps 12]
	    set ProfilAffy [lindex $LesChamps 33]
	    set ProfilDD [lindex $LesChamps 13]
	}
	if {$TumorType=="U"} {
	    set FoldAffy [lindex $LesChamps 34]
	    set FoldDD [lindex $LesChamps 14]
	    set ProfilAffy [lindex $LesChamps 35]
	    set ProfilDD [lindex $LesChamps 15]
	}
	if {$TumorType=="3T"} {
	    set FoldAffy [lindex $LesChamps 36]
	    set FoldDD [lindex $LesChamps 16]
	    set ProfilAffy [lindex $LesChamps 37]
	    set ProfilDD [lindex $LesChamps 17]
	}	
	####b: exclure les genes qui rentrent pas ds les criteres de stringence
	if {$FCAffy!=0 && $FCDD!=0} {
	    #si les cutoff sont differents de zero.
	    if {$FoldAffy>0 && $FoldAffy<=$FCAffy} {continue}
	    if {$FoldAffy<0 && $FoldAffy>=(-$FCAffy)} {continue}
	    if {$FoldDD!="" && $FoldDD!=0} {
		#
		if {$FoldDD>0 && $FoldDD<=$FCDD} {continue}
		if {$FoldDD<0 && $FoldDD>=(-$FCDD)} {continue}
	    }
	}

	#3:Exclure les affy avec les intensites par exemple inferieures a 650
	set Intn [lindex $LesChamps 26]
	set Inte [lindex $LesChamps 27]
	set Ints [lindex $LesChamps 28]
	set Intu [lindex $LesChamps 29]	
	if {$Intn<=$IntMin && $Inte<=$IntMin && $Ints<=$IntMin && $Intu<=$IntMin} {
	    lappend LesFaibles $TAR
	    continue
	}

	#3: Comparer profils du DD (profilgel ou profilcalc ou profilcons) avec profil affy
	set ProfilCalcDD [lindex $LesChamps 18]
	set ProfilConsDD [lindex $LesChamps 19]
	if {$ProfilDD==$ProfilAffy || $ProfilCalcDD==$ProfilAffy || $ProfilConsDD==$ProfilAffy} {
	    incr NbMemeProfil
	    lappend Liste $Ligne
	    if {$ProfilAffy=="N"} {incr NbN}
	    if {$ProfilAffy=="T"} {incr NbT}
	} else {
	    #ne pas compter les complexes
	    if {($ProfilDD=="" || $ProfilDD==0) &&  ($ProfilConsDD=="" || $ProfilConsDD=="?" || $ProfilConsDD=="0") &&  $ProfilCalcDD=="C" } {
		incr nbcomplexes
		continue
	    }
	    if {$ProfilAffy=="N"} {incr TN}
	    if {$ProfilAffy=="T"} {incr NT}
	    lappend ListeProfOpp $Ligne
	}
	incr NbComparaisons
	lappend ListeComplete $Ligne
	#3: compare fc
	#if {$FoldDD>0 && $FoldAffy<0} {incr TN}
	#if {$FoldDD<0 && $FoldAffy>0} {Espionne $dd;incr NT}
    }
    #Espionne $LesAbsents
    Espionne "absents: [llength $LesAbsents]"
    Espionne "lesfaibles: [llength $LesFaibles]"
    Espionne "nb complexes: $nbcomplexes"
    Espionne "$NbMemeProfil sur $NbComparaisons"
    Espionne [llength $Liste]
    SauveLesLignes $Liste dans "[RepertoireDuGenome]/OVERLAP931NEW/ListeDesGenesAuxProfilsCorreles_1et3_pour820final"
    Espionne "$NbN N, $NbT T"
    Espionne "dd T et affy N: $TN - NT: $NT"
    Espionne "nb profils opposes : [llength $ListeProfOpp]"
    #Espionne $ListeProfOpp
    #SauveLesLignes $ListeProfOpp dans "[RepertoireDuGenome]/OVERLAP931NEW/esp_ListeDesGenesAuxProfilsOpposes_3T"
    #set PercentN [expr $NbN*1.0/($NbComparaisons-$NbT)]
    #set PercentT [expr $NbT*1.0/($NbComparaisons-$NbN)]
    #Espionne "percent N: $PercentN -- T: $PercentT"
    set Percent [expr $NbMemeProfil*1.0/$NbComparaisons]
    #Espionne [llength $ListeComplete]
    #SauveLesLignes $ListeComplete dans "[RepertoireDuGenome]/OVERLAP931NEW/PourGraphRatio"
    return $Percent


}

proc AnalyseGlobaleOverlap_pourCorrelFC {FichierOverlap {TumorType 3T} {IntMin 0} {FCAffy 0.0} {FCDD 0.0}} {


    #FichierOverlap ANALYSE/Overlap.final (333 overlaps DD-Affy avec les profils etc..)
    #aucune target Affy dont les 4 valeurs de detection sont egales A ou M n'est acceptee
    #TumorType: E, S, ou U, ou 3T (moy des 3 T)
    set NbComparaisons 0
    set NbMemeProfil 0
    set NbN 0
    set NbT 0
    set TN 0
    set NT 0
    set LesFaibles ""
    set Liste ""
    set n 0
    set nbcomplexes 0
    foreach Ligne [LesLignesDuFichier $FichierOverlap] {
	set Ligne [string trim $Ligne]
	if {$Ligne ==""} {continue}
	set LesChamps [split $Ligne "\t"]
	incr n
	#1: Exclure les affy non detectes (que des A ou M)
	set dd [lindex $LesChamps 1]
	set TAR [lindex $LesChamps 2]
	set Detn [lindex $LesChamps 22]
	set Dete [lindex $LesChamps 23]
	set Dets [lindex $LesChamps 24]
	set Detu [lindex $LesChamps 25]
	if {($Detn=="A" || $Detn=="M") &&  ($Dete=="A" || $Dete=="M") &&  ($Dets=="A" || $Dets=="M") &&  ($Detu=="A" || $Detu=="M")} {
	    lappend LesAbsents $TAR
	    continue
	}
	#correction
	#if {$Detn=="A" || $Detn=="M"} {continue}
	#if {($Dete=="A" || $Dete=="M") &&  #($Dets=="A" || $Dets=="M") &&  #($Detu=="A" || $Detu=="M")} {
	    #continue
	#}

	#2: Exclure les overlaps avec FC inferieur au seuil fixe
	####a:recup data Fold DD et Affy
	if {$TumorType=="E"} {
	    set FoldAffy [lindex $LesChamps 30]
	    set FoldDD [lindex $LesChamps 10]
	    set ProfilAffy [lindex $LesChamps 31]
	    set ProfilDD [lindex $LesChamps 11]
	}
	if {$TumorType=="S"} {
	    set FoldAffy [lindex $LesChamps 32]
	    set FoldDD [lindex $LesChamps 12]
	    set ProfilAffy [lindex $LesChamps 33]
	    set ProfilDD [lindex $LesChamps 13]
	}
	if {$TumorType=="U"} {
	    set FoldAffy [lindex $LesChamps 34]
	    set FoldDD [lindex $LesChamps 14]
	    set ProfilAffy [lindex $LesChamps 35]
	    set ProfilDD [lindex $LesChamps 15]
	}
	if {$TumorType=="3T"} {
	    set FoldAffy [lindex $LesChamps 36]
	    set FoldDD [lindex $LesChamps 16]
	    set ProfilAffy [lindex $LesChamps 37]
	    set ProfilDD [lindex $LesChamps 17]
	}	
	####b: exclure les genes qui rentrent pas ds les criteres de stringence
	#test sur minimum de stringence - arguments fournis: FCAffy et FCDD
	if {$FoldAffy>0 && $FoldAffy<=$FCAffy} {continue}
	if {$FoldAffy<0 && $FoldAffy>=(-$FCAffy)} {continue}
	if {$FoldDD!="" && $FoldDD!=0} {
	    if {$FoldDD>0 && $FoldDD<=$FCDD} {continue}
	    if {$FoldDD<0 && $FoldDD>=(-$FCDD)} {continue}
	}
	#if {[regexp "DD0037" $Ligne]} {FaireLire "$dd dd: $FoldDD affy: $FoldAffy"}
	#3:Exclure les affy avec les intensites inf a 650
	set Intn [lindex $LesChamps 26]
	set Inte [lindex $LesChamps 27]
	set Ints [lindex $LesChamps 28]
	set Intu [lindex $LesChamps 29]	
	if {$Intn<=$IntMin && $Inte<=$IntMin && $Ints<=$IntMin && $Intu<=$IntMin} {
	    lappend LesFaibles $TAR
	    continue
	}
	#voir quand T et N sont faibles alors T/N fort.
	set MoyenneDesT [format "%.3f" [expr ($Inte+ $Ints + $Intu)/3]]

	#if {$Intn<800 && $MoyenneDesT<800} {
	    #set FoldMoy -[expr $In($CodeAffy)*1.0/$MoyenneDesT]; set PMoy "N"
	    #Espionne "$TAR N:$Intn T:$MoyenneDesT -DetN :$Detn"
	    #continue
	#}
	
	#3: Comparer profils du DD (profilgel ou profilcalc ou profilcons) avec profil affy
	set ProfilCalcDD [lindex $LesChamps 18]
	set ProfilConsDD [lindex $LesChamps 19]
	if {$ProfilDD==$ProfilAffy || $ProfilCalcDD==$ProfilAffy || $ProfilConsDD==$ProfilAffy} {
	    #Exclure ceux ou le profildd s'oppose au profil calc ou cons qui est comme le profil affy ...cad s'oppose au profil affy
	    #if {$ProfilDD!=$ProfilCalcDD || $ProfilDD!=$ProfilConsDD} {continue}
	    #if {$ProfilDD!=$ProfilAffy} {continue}
	    #Comment: de toute facon la courbe reste la meme avec une diminution de la correlation qd FCAffy est entre 8 et 12 a peu pres
	    incr NbMemeProfil
	    lappend Liste $Ligne
	    if {$ProfilAffy=="N"} {incr NbN}
	    if {$ProfilAffy=="T"} {incr NbT}
	} else {
	    #ne pas compter les complexes
	    if {($ProfilDD=="" || $ProfilDD==0) &&  ($ProfilConsDD=="" || $ProfilConsDD=="?" || $ProfilConsDD=="0") &&  $ProfilCalcDD=="C" } {
		incr nbcomplexes
		continue
	    }
	    if {$ProfilAffy=="N"} {incr TN}
	    if {$ProfilAffy=="T"} {incr NT}
	    lappend ListeProfOpp $Ligne
	}
	incr NbComparaisons
	lappend ListeComplete $Ligne
	#T/N
	#Espionne "T: $MoyenneDesT"
	#Espionne "N: $Inte"
    }
    #Espionne [llength $ListeComplete]
    EspionneL $ListeComplete
    #Espionne "$NbMemeProfil meme profil - opp: [llength $ListeProfOpp] -nbcompar:$NbComparaisons"
    set Percent [expr $NbMemeProfil*1.0/$NbComparaisons]
    #Espionne $ListeProfOpp
    return "$Percent $NbMemeProfil $NbComparaisons exclus:$nbcomplexes"   


}

proc AnalyseLeBlastN {Fichier {BanqueBlast ""}} {


    global RepertoireDuGenome



    if { ! [file exists $Fichier]} {
	set FichierDeLOrga "$RepertoireDuGenome/blastn/[file tail $Fichier]"
	if { ! [file exists $FichierDeLOrga]} {
	    FaireLire "Sorry, I can't find  \n $Fichier \n nor \n $FichierDeLOrga"
	    return ""
	}
	set Fichier $FichierDeLOrga
    }

    CreeLesBornesDuBlastN     $Fichier $BanqueBlast
    LesZonesDuBlastNEnOverlap $Fichier
    exit


}

proc AnalyseLesDbClustal {} {


    if { [OuiOuNon "Do I run analysis on DBClustal outputs ? "]} {
	set DisPhy [OuiOuNon "CreeDistancesPhyloAvecLesMSFs ?"]
	set PIPS   [OuiOuNon "CreeLesFichiersPIClustalwEtPSClustalw ?"]
	set Oo     [OuiOuNon "ORGAorgaDesMSFs ?"]
	set PhylOr [OuiOuNon "PhylumsOrthologues ?"]
	set Para   [OuiOuNon "AlignonsLesParalogues ?"]
    	set TCSD   [OuiOuNon "TestCodonStartEtDeletionDuMSFPourTous ?"]
	set TCSC   [OuiOuNon "StartCodonClusterPourTous and CreeStartCodonReport ?"]
	set Diff   [OuiOuNon "DifferentielBlastAlignementPourTous ?"]
	if { $DisPhy } { CreeDistancesPhyloAvecLesMSFs }
	if { $PIPS   } { CreeLesFichiersPIClustalwEtPSClustalw}
	if { $Oo     } { ORGAorgaDesMSFs "CreateIt" }
	if { $PhylOr } { PhylumsOrthologues bidon }
	if { $Para   } { AlignonsLesParalogues }
    	if { $TCSD   } { TestCodonStartEtDeletionDuMSFPourTous }
    	if { $TCSC   } { StartCodonClusterPourTous ; CreeStartCodonReport }
	if { $Diff   } { DifferentielBlastAlignementPourTous }
    }


}

proc AnalyseLesTBlastN {{BanqueTBlastN ""}} {


    global RepertoireDuGenome

    set BanqueTBlastN [WhichBanqueTBlastN $BanqueTBlastN]

    set LaTotale 0 
    if {[OuiOuNon "Do I run all analysis for tBlastN ?\n  ouatapetbn, orthotblastn, ootblastn, two genes cluster, ... ?"]} {
	set LaTotale 1
    }
    if {[file exists "$RepertoireDuGenome/tblastn$BanqueTBlastN"] &&  ! [file exists "$RepertoireDuGenome/fiches/ouatapetbn.$BanqueTBlastN"]} {
	if {$LaTotale || [OuiOuNon "Do I create fiches/ouatapetbn.$BanqueTBlastN ?"]} {
	    CreeOuATapeTBlastN $BanqueTBlastN
	}
    }
    if {[file exists "$RepertoireDuGenome/fiches/ouatapetbn.$BanqueTBlastN"] &&  ! [file exists "$RepertoireDuGenome/fiches/orthotblastn"]} {
	if {$LaTotale || [OuiOuNon "Do I create orthotblastn  ?"]} {
	    CreeOrthoTBlastN
	}
    }
    if {[file exists "$RepertoireDuGenome/fiches/orthotblastn"] &&  ! [file exists "$RepertoireDuGenome/fiches/ootblastn"]} {
	if {$LaTotale || [OuiOuNon "Do I create ootblastn ?"]} {
	    ORGAorgaDesTBlastNs "CreateIt"
	}
    }
    if {[file exists "$RepertoireDuGenome/fiches/ouatapetbn.$BanqueTBlastN"] &&  ! [file exists "$RepertoireDuGenome/fiches/organismesayantmemeoperon"]} {
	if {$LaTotale || [OuiOuNon "Do I run TwoGeneClusterAnalysis ?"]} {
	    CreeLeFichierOrganismesAyantMemeOperon genomes
	}
    }
    if {[file exists "$RepertoireDuGenome/fiches/ouatapetbn.$BanqueTBlastN"] &&  [info exists Org1] &&  ! [file exists "$RepertoireDuGenome/fiches/orthologuesdans$Org1"]} {
	if {$LaTotale || [OuiOuNon "Do I check for orthologs in $Org1 and $Org2 ? "]} {
	    foreach Orga [LesOrganismesTresProches] {
		CreeLeFichierOrthologueDans $Orga
	    }
	}
    }


}

proc AnalyseLongueurSequence {} {


    global RepertoireDuGenome
    set LaListeDesPetits {}
    foreach Nom [ListeDesPABs] {
	set longueur [string length [QueLaSequenceDuFichierTFA "$RepertoireDuGenome/nuctfa/$Nom"]]
	if {$longueur < 9} {lappend LaListeDesPetits $Nom}
    }
    Espionne $LaListeDesPetits


}

proc AnalyseMoi {args} {


    PourWscope 1
    return [Html_DuTexteTelQuel [join $args " "]] 


}

proc AnalyseNucMask {{Commentaire ""}} {


    global RepertoireDuGenome
    set Rep "$RepertoireDuGenome/nucmask"
    set LesMasked {}
    set LesPartiellementMasked {}
    set LesTotalementMasked {}
    set N 0
    set n1 0
    set n2 0
    foreach Fichier [ glob -nocomplain "$Rep/*.m" ] {
	set Contenu [ ContenuDuFichier $Fichier]
	scan $Contenu "%s %s %s %s"  CodeGscope TypeMask CodeClone User   
	regsub -all ">" $CodeGscope "" CodeGscope
	if {$TypeMask != "NoRepeatToMask" } {
	    incr N
	    lappend LesMasked $CodeGscope 
	} 
	if {$TypeMask == "PartiallyMasked"} {
	    incr n1
	    lappend LesPartiellementMasked $CodeGscope 
	    continue
	}
	if {$TypeMask == "TotallyMasked"} {
	    incr n2
	    lappend LesTotalementMasked $CodeGscope 
	    continue
	}
    }

    if {$Commentaire== "partiel" } {
	Espionne "Partially Masked cDNAs: $n1"
	Espionne "List of the partially Masked cDNAs: \n $LesPartiellementMasked"
	exit
    }
    if {$Commentaire== "total" } {
	Espionne "Totally Masked cDNAs: $n2"
	Espionne "List of the totally Masked cDNAs: \n $LesTotalementMasked"
	exit
    }
    Espionne "Masked cDNAs: $N"
    set Pourcent [expr round ($N/2899.0 *100)]
    Espionne "Percent/HeadNeck3: $Pourcent %" 
    Espionne "Partially Masked cDNAs: $n1"
    Espionne "Totally Masked cDNAs: $n2"
    Espionne "Total liste: \n $LesMasked "
    FaireLire ok
    return $LesMasked 


}

proc AnalyseNucMaskAndReMask {{Comment ""}} {


    global RepertoireDuGenome
    set Rep "$RepertoireDuGenome/nucMaskAndReMask"
    set LesMRM {}
    set LesPartiellementMRM {}
    set LesTotalementMRM {}
    set N 0
    set n1 0
    set n2 0
    foreach Fichier [ glob -nocomplain "$Rep/*.mrm" ] {
	set Contenu [ ContenuDuFichier $Fichier]
	scan $Contenu "%s %s %s %s %s %s"  CodeGscope CodeClone User TypeMask  Pourcent Fin 
	regsub -all ">" $CodeGscope "" CodeGscope
	regsub -all "%" $Pourcent "" Pourcent
	if {$TypeMask != "NoRepeatToMRM" } {
	    incr N
	    lappend LesMRM $CodeGscope 
	} 
	if {$TypeMask == "PartiallyMRM"} {
	    incr n1
	    lappend LesPartiellementMRM $CodeGscope 
	    continue
	}
	if {$TypeMask == "TotallyMRM"} {
	    incr n2
	    lappend LesTotalementMRM $CodeGscope 
	    continue
	}
    }

    if {$Comment== "partiel" } {
	Espionne "Partially MRM cDNAs: $n1"
	Espionne "List of the partially MRM cDNAs: \n $LesPartiellementMRM"
	exit
    }
    if {$Comment== "total" } {
	Espionne "Totally MRM cDNAs: $n2"
	Espionne "List of the totally MRM cDNAs: \n $LesTotalementMRM"
	exit
    }
    Espionne "MRM cDNAs: $N"
    set Pourcent [expr round ($N/2899.0 *100)]
    Espionne "Percent/HeadNeck3: $Pourcent %" 
    Espionne "Partially MRM cDNAs: $n1"
    Espionne "Totally MRM cDNAs: $n2"
    Espionne "Total liste: \n $LesMRM "
    #SauveLesLignes $LesMRM dans "$RepertoireDuGenome/listeDesPABsMRM" 


}

proc AnalyseNucReMask {{Comment ""}} {


    global RepertoireDuGenome
    set Rep "$RepertoireDuGenome/nucremask"
    set LesRemasques {}
    set LesPartiellementReMasques {}
    set LesTotalementReMasques {}
    set N 0
    set n1 0
    set n2 0
    foreach Fichier [ glob -nocomplain "$Rep/*.rm" ] {
	set Contenu [ ContenuDuFichier $Fichier]
	scan $Contenu "%s %s %s %s %s %s %s"  CodeGscope CodeClone User TypeMask Pourcent TypeRepeat Fin 
	regsub -all ">" $CodeGscope "" CodeGscope
	regsub -all "%" $Pourcent "" Pourcent
	if {$TypeMask != "NoSequenceToReMask" && $TypeMask != "NoRepeatToReMask"  } {
	    incr N
	    lappend LesRemasques $CodeGscope 
	} 
	if {$TypeMask == "PartiallyReMasked"} {
	    incr n1
	    lappend LesPartiellementRemasques $CodeGscope 
	    continue
	}
	if {$TypeMask == "TotallyReMasked"} {
	    incr n2
	    lappend LesTotalementReMasques $CodeGscope 
	    continue
	}
    }

    if {$Comment== "partiel" } {
	Espionne "Partially remasked cDNAs: $n1"
	Espionne "List of the partially remasked cDNAs: \n $LesPartiellementRemasques"
	exit
    }
    if {$Comment== "total" } {
	Espionne "Totally remasked cDNAs: $n2"
	Espionne "List of the totally remasked cDNAs: \n $LesTotalementReMasques"
	exit
    }
    Espionne "Remasked cDNAs: $N"
    set Pourcent [expr round ($N/2899.0 *100)]
    Espionne "Percent/HeadNeck3: $Pourcent %" 
    Espionne "Partially remasked cDNAs: $n1"
    Espionne "Totally remasked cDNAs: $n2"
    Espionne "Total liste: \n $LesRemasques "
    SauveLesLignes $LesRemasques dans "$Rep/lesremasques" 


}

proc AnalyseResAffymetrix_ProbeSet {FichierAffy} {



    Wup "Permet d obtenir des stats sur le resultat des recherche blat et des NM associes aux ProbeSet Affy"

    set nbProbeSet 0

    set F  [open "$FichierAffy"]
    while {[gets $F Ligne]>=0} {
	if {! [regexp -nocase {[a-z0-9]+} $Ligne]} {continue}
	if {! [regexp {^>>>}              $Ligne]} {continue}
	
	#Espionne "$Ligne"

	set LigneSplitee [split $Ligne "\t"]

	set NbRefSeqTrouve   0
	set ProbeSetID       ""
	set LesRefSeqTrouves ""
	set RefSeqAffy       ""
	set DefAffy          ""

	set ProbeSetNoBlat   0
	set ProbeSetNoIds    0
	set RefSeqTrouve     0

	set NbRefSeqTrouve   0
	set ProbeSetID       [lindex $LigneSplitee 0]
	set LesRefSeqTrouves [split  [lindex $LigneSplitee 1] " "]
	set RefSeqAffy       [lindex $LigneSplitee 2]
	set DefAffy          [lindex $LigneSplitee 3]

	#Nombre de RefSeq trouve par ProbeSet
	if {      [regexp -nocase "no ids"  $LesRefSeqTrouves]} {
	    set ProbeSetNoIds    "1"

	    set NbRefSeqTrouve   "0"
	    set LesRefSeqTrouves ""
	    set RefSeqTrouve     "0"
	} elseif {[regexp -nocase "no blat hit" $Ligne]} {
	    set ProbeSetNoBlat   "1"
	    
	    set LesRefSeqTrouves ""
	    set RefSeqTrouve     "0"
	} else {
	    set NbRefSeqTrouve   [llength $LesRefSeqTrouves]
	    set RefSeqTrouve 1

	    set  NbRefSeqTrouve2 [regexp -all "NM_" $LesRefSeqTrouves]
	    if {$NbRefSeqTrouve != $NbRefSeqTrouve2} {
		Espionne "$ProbeSetID\t$NbRefSeqTrouve\t$NbRefSeqTrouve2"
	    }
	}
	
	#Nombre de ProbetSet ou on a pas trouve un RefSeq
	if {! [info exists TabResAffy(nbProbeSetNoIds)]} {
	    set  TabResAffy(nbProbeSetNoIds)  0
	}				       
	if {$ProbeSetNoIds} {
	    incr TabResAffy(nbProbeSetNoIds)
	}
	#Nombre de ProbetSet ou on a pas trouve de genome
	if {! [info exists TabResAffy(nbProbeSetNoBlat)]} {
	    set  TabResAffy(nbProbeSetNoBlat) 0
	}				       
	if {$ProbeSetNoBlat} {
	    incr TabResAffy(nbProbeSetNoBlat)
	}
	#Nombre de ProbetSet ou on a trouve un RefSeq
	if {! [info exists TabResAffy(nbProbeSetTrouve)]} {
	    set  TabResAffy(nbProbeSetTrouve) 0
	}				       
	if {$RefSeqTrouve} {
	    incr TabResAffy(nbProbeSetTrouve)
	}

	#Nombre de ProbeSet Affy a trouve
	if {! [info exists TabResAffy(nbProbeSetAvecNMAffy)]} {
	    set  TabResAffy(nbProbeSetAvecNMAffy) 0
	}				       
	if {[regexp -nocase "NM_" $RefSeqAffy] || [regexp -nocase "NM_" $DefAffy]} {
	    incr TabResAffy(nbProbeSetAvecNMAffy)
	    set NMPourProbeSet 1
	} else {
	    set NMPourProbeSet 0
	}

	#Nombre de ProbetSet ou on a trouve un RefSeq et valide
	set RefSeqValide 0
	if {$NMPourProbeSet} {
	    if {$RefSeqTrouve} {
		foreach Acc $LesRefSeqTrouves {
		    if {[regexp -nocase $Acc $RefSeqAffy] || [regexp -nocase $Acc $DefAffy]} {
			#Espionne "$Acc - $RefSeqAffy"
			set RefSeqValide 1
			break
		    }
		    #Espionne "$ProbeSetID -- $Acc - $RefSeqAffy"
		}
	    }
	} else {
	    if {! [info exists TabResAffy(nbRefSeqEnPlus)]} {
		set  TabResAffy(nbRefSeqEnPlus) 0
	    }
	    if {$RefSeqTrouve} {
		incr TabResAffy(nbRefSeqEnPlus)
	    }
	}
	incr nbProbeSet

	#Nombre de ProbeSet valide entre Affy et RefSeaq trouve
	if {! [info exists TabResAffy(nbValide)]} {
	    set  TabResAffy(nbValide) 0
	}
	if {$RefSeqValide} {
	    incr TabResAffy(nbValide)
	}

	if {! [info exists TabResAffy(nbTrouve,$NbRefSeqTrouve)]} {
	    set TabResAffy(nbTrouve,$NbRefSeqTrouve) 0
	}
	incr    TabResAffy(nbTrouve,$NbRefSeqTrouve)
	
	if {! [info exists TabResAffy(LesnbTrouve)]} {
	    set TabResAffy(LesnbTrouve) ""
	}
	lappend TabResAffy(LesnbTrouve) $NbRefSeqTrouve
    }
    close $F

    set TabResAffy(LesnbTrouve) [lsort -unique -integer -increasing [set TabResAffy(LesnbTrouve)]]

    Espionne "Affymetrix HG-U133 Plus ProbeSet Analysis"
    Espionne "Nb ProbeSet: $nbProbeSet"
    Espionne "Nb ProbeSet avec NM (Affy): [set TabResAffy(nbProbeSetAvecNMAffy)]"
    Espionne "Nb ProbeSet avec NM trouve: [set TabResAffy(nbProbeSetTrouve)]"
    Espionne "Nb ProbeSet sans NM: [set TabResAffy(nbProbeSetNoIds)]"
    Espionne "Nb ProbeSet sans Blat: [set TabResAffy(nbProbeSetNoBlat)]"
    Espionne "Nb ProbeSet Total: [expr [set TabResAffy(nbProbeSetTrouve)]+[set TabResAffy(nbProbeSetNoIds)]+[set TabResAffy(nbProbeSetNoBlat)]]"
    Espionne "Nb ProbeSet valide: [set TabResAffy(nbValide)]"
    #Espionne "Percent Valide: [expr ([set TabResAffy(nbValide)]*100.0)/[set TabResAffy(nbProbeSetTrouve)]]"
    Espionne "Percent Valide par rapport Affy: [expr ([set TabResAffy(nbValide)]*100.0)/[set TabResAffy(nbProbeSetAvecNMAffy)]]"
    Espionne "Nb ProbeSet en plus d Affy: [set TabResAffy(nbRefSeqEnPlus)]"

    foreach Nb [set TabResAffy(LesnbTrouve)] {
	Espionne "$Nb\t[set TabResAffy(nbTrouve,$Nb)]"
    }

    return ""


}

proc AnalyseSelections {outOf} {


    LesDefauts
    DefinitionPreferences
    InitComparaison
    global SDG
    global ListeDesAcidesAmines
    global TableauCouleurEtGroupe
    global Threshold
    global Defauts
    global TypeCons
    global ConsRef
    global ListeDesConsensusDuGroupe
    global Sequences
    global lesTypes

    if {$outOf == ""} {
	set lesTypes [list "_nature" "_mounir" "_bandelettes" "_luc"]
	set repIn "msf_nature/Rascal/Leon"
    } else {
	set lesTypes [list "_Selnature" "_Selmounir" "_Selbandelettes" "_Selluc"]
	set repIn "msf_Selnature"
    }

    set fileOut {}
    set file {}
    puts "Info\tNature\tSelMounir\tSelBandelettes\tSelLuc"
    set Lpab [ListeDesPABs]
    set Lpab [lrange $Lpab 269 end]
    #set Lpab "nPDB054"
    foreach f $Lpab {
	set lNbSeq {}
	set lNbSeqId {}
	set lNbClus {}
	set lNbIdGlob {}
	set lNbCGlob {}
	set lNbSGlob {}
	set lRandInd {}

	if {![file exists [file join [RepertoireDuGenome] ${repIn} $f]]} {continue}
	if {[lsearch [LesLignesDuFichier [file join [RepertoireDuGenome] ${repIn} $f]] "NoSequenceToAlign"] == 0} {continue}

	foreach type $lesTypes {

	    # mode Batch pour travailler sans interface graphique
	    LesDefauts Mode "Batch"
	    LesDefauts CheckSeq 0
	    set Threshold [set Defauts(Threshold)]

	    if {$outOf == ""} {
		set file  [file join [RepertoireDuGenome] "msf$type" "Rascal" "Leon" $f]
		set ficComp "/usr/tmp/${f}_nature.clu"
	    } else {
		set file  [file join [RepertoireDuGenome] "msf$type" $f]
		set ficComp "/usr/tmp/${f}_Selnature.clu"
	    }

	    DecortiqueEtAfficheUnMSF $file
	    DefinitionGroupes "dpc"
	    RunOrdali
	    RecupereReference
	    set grps($type) [array get SDG]
	    set data($type) [RecupereDonneesGlobales $type]

	    lappend lNbSeq [lindex [set data($type)] 0]
	    lappend lNbClus [lindex [set data($type)] 1]
	    lappend lNbIdGlob [lindex [set data($type)] 2]
	    lappend lNbCGlob [lindex [set data($type)] 3]
	    lappend lNbSGlob [lindex [set data($type)] 4]

	    #mise en evidence des residus Globaux (identite, conservation et similarite)
	    set lR$type [TabGlobaux $f [set data($type)] $outOf]

	    # traitement du fichier resu de la clusterisation
	    # comparaison des clusters obtenus pour chacune des selection par rapport a la ref
	    # calcul d un indice de conservation
	    set fileOut "/usr/tmp/${f}.dpc"
	    set fic "/usr/tmp/${f}${type}.clu"
	    file copy -force $fileOut $fic

	    if {![regexp "nature" $type]} {
		set lstat($type) [CompCluster $ficComp $fic]
		lappend lRandInd [string range [lindex [set lstat($type)] 0] 0 3]
		lappend lNbSeqId [lindex [set lstat($type)] 1]
	    } else {
		array set SeqN [array get Sequences]
	    }

	    FermeFichier
	}

	set lCommunsGlobaux [DetermineNbGlobauxCommuns [set lR[lindex $lesTypes 1]] [set lR[lindex $lesTypes 2]] [set lR[lindex $lesTypes 3]] [set lR[lindex $lesTypes 0]]]

	#determination des groupes communs
	set ListeCorrespondance [DetermineGroupesEquivalents [array get grps] [array get data] [array get SeqN]]
	puts "\n"
	puts "${f}_NbSeqTot\t[lindex $lNbSeq 0]\t[lindex $lNbSeq 1]\t[lindex $lNbSeq 2]\t[lindex $lNbSeq 3]"
	puts "${f}_NbSeqIden\t[lindex $lNbSeq 0]\t[lindex $lNbSeqId 0]\t[lindex $lNbSeqId 1]\t[lindex $lNbSeqId 2]"
	puts "${f}_NbIdGlob\t[lindex $lNbIdGlob 0]\t[lindex $lNbIdGlob 1]\t[lindex $lNbIdGlob 2]\t[lindex $lNbIdGlob 3]"
	puts "${f}_NbIdGlobCom\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 0] 0]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 0] 1]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 0] 2]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 0] 3]"
	puts "${f}_NbConsGlob\t[lindex $lNbCGlob 0]\t[lindex $lNbCGlob 1]\t[lindex $lNbCGlob 2]\t[lindex $lNbCGlob 3]"
	puts "${f}_NbConsGlobCom\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 1] 0]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 1] 1]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 1] 2]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 1] 3]"
	puts "${f}_NbSimiGlob\t[lindex $lNbSGlob 0]\t[lindex $lNbSGlob 1]\t[lindex $lNbSGlob 2]\t[lindex $lNbSGlob 3]"
	puts "${f}_NbSimiGlobCom\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 2] 0]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 2] 1]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 2] 2]\t[lindex [ExtraitListeDeListe $lCommunsGlobaux 2] 3]"
	puts "${f}_NbClusTot\t[lindex $lNbClus 0]\t[lindex $lNbClus 1]\t[lindex $lNbClus 2]\t[lindex $lNbClus 3]"
	puts "${f}_aRandIndex\t1\t[lindex $lRandInd 0]\t[lindex $lRandInd 1]\t[lindex $lRandInd 2]"
	for {set i 1} {$i<=[lindex $lNbClus 0]} {incr i} {
	    puts "${f}_Cl${i}-SqId-IdGrCom\t[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 4]] 0]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 3]] 0]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 1]] 0]\t[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 4]] 1]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 3]] 1]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 1]] 1]\t[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 4]] 2]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 3]] 2]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 1]] 2]\t[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 4]] 3]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 3]] 3]-[lindex [ExtraitListeDeListe $ListeCorrespondance [expr $i * 4 - 1]] 3]"
	}

	# efface fichiers crees pour la clusterisation dans /usr/tmp
	foreach fic [glob -nocomplain /usr/tmp/*${f}*] {
	    file delete -force $fic
	}
    }
    return 1

}

proc AnalyseSortieBlastADNc {{Liste ""}} {


    #Attention au gap=> ok
    #Attention aux n

    if {[EstUnPAB $Liste]} { set Liste [list $Liste] }
    if {$Liste==""} { set Liste [ListeDesPABs] }

    set RepertoireSortieBlast "[RepertoireDuGenome]/blastnSuperSouris"
    set total 0; set statcas0 0; set statcas2a 0; set statcas2b 0; set statcas1 0; set lesout 0
    set statcas2c 0; set statcas2d 0; set statcas2cd 0
    foreach Nom $Liste {
	set File "$RepertoireSortieBlast/$Nom"
	set LesBons {}
	incr total
	set Queue [file tail $File]
	#Espionne "$Queue"
	set NbSujet [AskBlast $File NbSubject]
	#Espionne "NbSujet $NbSujet"
	if {$NbSujet==0} {
	    incr statcas0
	    continue
	}
	set cas1 0; set cas2 0; set cas2a 0; set cas2b 0; set cas2c 0; set cas2d 0

	for {set j 1} {$j<=$NbSujet} {incr j} {
	    set BId       [AskBlast $File Subject $j]
	    #Espionne "BId $BId"
	    set NbSegment [AskBlast $File BanqueId $BId NbSegment]
	    #Espionne "NbSegment $NbSegment"
	    for {set i 1} {$i<=$NbSegment} {incr i} {
		set LesLignesFinales {}
		set PId [AskBlast $File BanqueId $BId Segment $i Identities]
		set Gap [AskBlast $File BanqueId $BId Segment $i Gaps]
		regexp {([0-9]+)/([0-9]+) (\([0-9]+%\))} $PId Tmp nbId nbTot Pourcentage
		regsub -all {\(} $Pourcentage "" Pourcentage
		regsub -all {\)} $Pourcentage "" Pourcentage
		regsub % $Pourcentage "" Pourcentage
		#Espionne "PId $PId"
		#Espionne "++$nbId $nbTot $Pourcentage"
		#Espionne "Gap $Gap"
		#Espionne "$nbTot $Pourcentage $Gap"
		
		if {$nbTot<60} {set cas1 1}
		if {$nbTot>60} {
		    set cas2 1
		    if {$Pourcentage == "100"} {
			set cas2a 1
			lappend LesBons $BId
		    } 
		    if {$Pourcentage != "100"} {
			set cas2b 1
			set Align [AskBlast $File BanqueId $BId Segment $i Align]
			Espionne "$Align"
			set LesLignes [split $Align "\n"]
			set LesLignes [ListeSsElmtVide $LesLignes]
			foreach Ligne $LesLignes {
			    if {[regexp {^Query} $Ligne]} {
				set index [string first ":" $Ligne]
				set result [regexp -start $index -inline {[a-z]} $Ligne]
				set indexfinal [string first $result $Ligne $index]
				#Espionne "result $result"
				#Espionne "indexfinal $indexfinal"
				continue
			    }
			    if {[regexp {^Sbjct} $Ligne]} {continue}
			    if {![regexp {\|} $Ligne]} {continue}
			    #Espionne "1$Ligne"
			    set Ligne [string range $Ligne $indexfinal end]
			    #Espionne "2$Ligne"
			    lappend LesLignesFinales $Ligne
			}
			set LeResult [join $LesLignesFinales ""]
			#Espionne $LeResult
			set LesTraits [split $LeResult ""]
			set nombredetrait [llength $LesTraits]
			set Max 0; set nbtrait 0; set nbelmt 0
			foreach Trait $LesTraits {
			    incr nbelmt
			    #Espionne "++$Trait"
			    if {$Trait=="|"} {
				incr nbtrait
			    }
			    if {$Trait!="|"} {
				#Espionne "$nbtrait"
				if {$nbtrait>$Max} {set Max $nbtrait}
				set nbtrait 0
			    }
			    if {$nbelmt==$nombredetrait} {
				#Espionne "$nbtrait"
				if {$nbtrait>$Max} {set Max $nbtrait}
				set nbtrait 0
			    }
			}
			if {$Max>=60} {
			    lappend LesBons $BId
			    set cas2c 1
			} elseif {$Max<60} {
			    set cas2d 1
			}
		    }
		}
		#Espionne "$cas1 $cas2 $cas2a $cas2b $cas2c $cas2d"
	    }
	}
	if {$cas2a} {
	    incr statcas2a
	    #Espionne "$Queue oui"
	} elseif {$cas2b} {
	    incr statcas2b
	    #Espionne "$Queue test"
	    if {$cas2c && $cas2d} {
		incr statcas2cd
		#Espionne "$Queue ouietnonaptest"
	    } elseif {$cas2c && !$cas2d} {
		incr statcas2c
		#Espionne "$Queue ouiaptest"
	    } elseif {!$cas2c && $cas2d} {
		incr statcas2d
		#Espionne "$Queue nonaptest"
	    }
	} elseif {$cas1} {
	    incr statcas1
	    #Espionne "$Queue non"
	} else {
	    incr lesout
	    #Espionne "$Queue out"
	}
	set LesBons [ListeSansDoublon $LesBons]
	set LaChaineBonne [join $LesBons " "]
	if {$LesBons =={}} {
	    Espionne "BanqueADNc: No"
	    InformeSansDemander $Queue "BanqueADNc: No"
	}
	if {$LesBons!={}} {
	    Espionne "BanqueADNc: Yes $LaChaineBonne"
	    InformeSansDemander $Queue "BanqueADNc: Yes $LaChaineBonne"
	}
    }
    #Espionne "total $total"
    #Espionne "statcas0 $statcas0"
    #Espionne "statcas2a $statcas2a"
    #Espionne "statcas2b $statcas2b"
    #Espionne "statcas2cd $statcas2cd"
    #Espionne "statcas2c $statcas2c"
    #Espionne "statcas2d $statcas2d"
    #Espionne "statcas1 $statcas1"
    #Espionne "lesout $lesout"


}

proc AnalyseSortieBlastMagos {} {


    set LesLignesEcrites {}
    set File "/genomics/link/retinalFateForLaetitia/blastponms2phDB/recapResuBlastOnMs2phDB"
    set LesLignes [LesLignesDuFichier $File]
    set total 0; set bon 0; set mauvais 0; set intermediarymauvais 0; set intermediarybon 0; set saispas 0
    foreach Ligne $LesLignes {
	incr total
	set LigneEcrite ""
	if {[regexp {^pab} $Ligne]} {continue}
	set Elmts [split $Ligne "\t"]
	set IdBlast  [lindex $Elmts 0]
	set Query    [AskBlast $IdBlast Query]
	set LesElmtsQuery [split $Query " "]
	set Nom [lindex $LesElmtsQuery 1]
	set AccMouse [lindex $Elmts 1]
	set AccHuman [lindex $Elmts 2]
	set expect   [lindex $Elmts 3]
	set CommandeMouse "getz \"\\\[protein-acc:$AccMouse\\\]\" \-f gen"
	set GetzOutMouse [eval exec $CommandeMouse]
	set CommandeHuman "getz \"\\\[protein-acc:$AccHuman\\\]\" \-f gen"
	set GetzOutHuman [eval exec $CommandeHuman]
	if {$expect=="0.0"} {
	    Espionne "$Ligne => bon"
	    incr bon
	    if {$IdBlast=="evi022" || $IdBlast=="evi030" || $IdBlast=="evi036" || $IdBlast=="evi056"} {
		continue
	    }
	    if {$IdBlast=="evi014"} {
		set LigneEcrite "$IdBlast\t$Nom\tP04001"
		lappend LesLignesEcrites $LigneEcrite
		continue
	    }
	    set LigneEcrite "$IdBlast\t$Nom\t$AccHuman"
	    lappend LesLignesEcrites $LigneEcrite
	} elseif {$expect>"1"} { 
	    Espionne "$Ligne => mauvais"
	    incr mauvais
	} elseif {$expect>1.e-50} {
	    Espionne "$Ligne => intermediarymauvais"
	    incr mauvais
	} elseif {$expect<=1.e-118} {
	    Espionne "$Ligne => intermediarybon"
	    incr intermediarybon
	    if {$IdBlast=="evi005" || $IdBlast=="evi008"} {
		continue
	    }
	    set LigneEcrite "$IdBlast\t$Nom\t$AccHuman"
	    lappend LesLignesEcrites $LigneEcrite
	} else {
	    Espionne "$Ligne => saispas"
	    incr saispas
	    if {$IdBlast=="evi013" || $IdBlast=="evi037" || $IdBlast=="evi046"} {
		continue
	    }
	    set LigneEcrite "$IdBlast\t$Nom\t$AccHuman"
	    lappend LesLignesEcrites $LigneEcrite
	}
	Espionne "LigneEcrite $LigneEcrite"
    }
    Espionne "total $total"
    Espionne "bon $bon"
    Espionne "mauvais $mauvais" 
    Espionne "intermediarybon $intermediarybon"
    Espionne "saispas $saispas"
    SauveLesLignes $LesLignesEcrites dans "[RepertoireDuGenome]/MagosLesRetinalFateHuman"


}

proc AnalyseTabulatedFile {f} {

    set cont [ContenuDuFichier $f]
    set cont [string map {"\t\|\n" "LuCkYlUc67"} $cont]
    set cont [string map {"\n" " "} $cont]
    set cont [string map {"LuCkYlUc67" "\n"} $cont]
    set Ll [split $cont \n]

    foreach l $Ll {
	set Lix [regexp -all -inline -indices {\t\|\t} $l]
	set i 0
	set dp 0
	foreach li $Lix {
	    lassign $li dc fc
	    lappend C($i) [string range $l $dp $dc-1]
	    set dp [expr {$fc+1}]
	    incr i
	}
	lappend C($i) [string range $l $dp end]
    }
    foreach col [lsort -integer [array names C]] {
	#puts "[lrange $C($col) 0 4]"
	set lg [PlusLongEltDe $C($col)]
	set v  [PlusLongEltDe $C($col) val]
	puts "$col $lg $v"
    }
    unset -nocomplain C

    return
    exit

}

proc AnalyseTestClusterPos {f} {

    set Ll [LesLignesDuFichier $f]
    set res {}
    set vutype 0
    foreach l $Ll {
	if {[regexp {^type } $l]} {
	    if {$res != {} } {
		lappend LRes $res
	    }
	    set res [lindex [split $l " "] 1]
	    set vutype 1
	}
	if {[regexp {^\t} $l] && $vutype} {
	    lappend res [lindex [split $l " "] end]
	}
    }
    lappend LRes $res

    set fmt "%14s |[string repeat "%6.3f" 3] |[string repeat "%6.3f" 3]"

    # Trie sur Identite (1er cluster)
    puts "Tri sur Sum (sens+spec) : Identite"
    set LRes [lsort -real -decreasing -index 3 $LRes]
    foreach e $LRes {
	puts [format $fmt {*}$e]
    }

    # Trie sur global (1er et 2eme cluster)
    puts "\nTri sur Sum (sens+spec) : global"
    set LRes [lsort -real -decreasing -index 6 $LRes]
    foreach e $LRes {
	puts [format $fmt {*}$e]
    }

    exit

}

proc AnalyseValeursPropres {Le} {
    
    set s 0.
    foreach e $Le {
	set s [expr {$s+$e}]
    }
    foreach e $Le {
	lappend Ic [expr {$e/$s*100.}]
    }
    puts "\nEignevalues :"
    set fmt "%s |%7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f"
    puts [format $fmt "Abs" {*}[lrange $Le 0 9]]
    puts [format $fmt "Rel" {*}[lrange $Ic 0 9]]
    puts [format $fmt "Abs" {*}[lrange $Le 10 19]]
    puts [format $fmt "Rel" {*}[lrange $Ic 10 19]]
    puts ""

    return

}

proc AnalyseVecteursPropres {Ev {Cen 0}} {

    puts ""
    if {$Cen} {set Ev [CentreVecteur $Ev}

    set iPaaP [CorrelationAxe $Ev]

    set Av [VecteurDeAAIndex $iPaaP]
    set ccp [CoefficientCorrelation $Ev $Av]
    puts [format "%s %6.3f" "Coef.Corr = " $ccp]
    puts ""
	
    return [list $iPaaP $ccp]

}

proc AnalysissoftwareInput {} {


    if { ! [WithWebService "Gx" "TestIfExists"]} { WithWebService "Gx" 1 }
    InfoFromAnalysissoftwareInput
    set LesTetes "name,description,reference"
    foreach Name [InfoFromAnalysissoftwareInput ListOf Name] {
	set Existant [GxDbSqlExec "select pk_analysissoftware from analysissoftware where name='$Name';" "GetFirstValue"]
	if {$Existant!=""} { return "" }
	
	set name        [InfoFromAnalysissoftwareInput $Name "name" ]
	set description [InfoFromAnalysissoftwareInput $Name "description" ]
	set reference   [InfoFromAnalysissoftwareInput $Name "reference" ]

	set Ligne "'$name','$description','$reference'"
	Espionne "$Ligne"
	set Commande "insert into analysissoftware ($LesTetes) values ($Ligne);"
	Espionne "$Commande"
	set status [GxDbSqlExec $Commande]
    }
    return $status


}

proc AncetreCommun {A B {Quoi ""}} {



    Wup "On part des feuilles et on remonte une fois l'un une fois l'autre jusqu'a trouver un commun"

    if {$Quoi==""} { set Quoi "IdCommun" }

    if {[regexp {[^0-9]} $A]} { set A [Tax $A] }
    if {[regexp {[^0-9]} $B]} { set B [Tax $B] }
    if {$A=="" || $B==""} { return "" } 


    if {[TaxSystem]=="AK"} {
	return [Taxo::nearestCommonAncestor $A $B $Quoi]
    }

    set ParentsDeA [list $A]
    set ParentsDeB [list $B]

    set AuTourDeA 1
    while 1 {
	set AncetreA [lindex $ParentsDeA end]
	set AncetreB [lindex $ParentsDeB end]
	#Espionne "A=$ParentsDeA/$AncetreA/[Tax $AncetreA]/ B=$ParentsDeB/$AncetreB/[Tax $AncetreB]/"
	if {[set iA [lsearch -exact $ParentsDeA $AncetreB]]>=0} {
	    if {[string equal -nocase $Quoi "IdCommun" ]} { return $AncetreB }
	    if {[string equal -nocase $Quoi "TwoLists" ]} {
		return [list [lrange $ParentsDeA 0 $iA] $ParentsDeB]
	    }
	    return [Tax $AncetreB $Quoi]
	}
	if {[set iB [lsearch -exact $ParentsDeB $AncetreA]]>=0} {
	    if {[string equal -nocase $Quoi "IdCommun" ]} { return $AncetreA }
	    if {[string equal -nocase $Quoi "TwoLists" ]} {
		return [list $ParentsDeA [lrange $ParentsDeB 0 $iB]]
	    }
	    return [Tax $AncetreA $Quoi]
	}
	if {   $AuTourDeA && $AncetreA<=1} { set AuTourDeA 0 }
	if { ! $AuTourDeA && $AncetreB<=1} { set AuTourDeA 1 }
	
	if {$AuTourDeA} {
	    set  AncetreA [Tax $AncetreA "RankedParent"]
	    if {$AncetreA==""} { return "" } 
	    lappend ParentsDeA $AncetreA
	    set AuTourDeA 0
	} else {
	    set  AncetreB [Tax $AncetreB "RankedParent"]
	    if {$AncetreB==""} { return "" } 
	    lappend ParentsDeB $AncetreB
	    set AuTourDeA 1
	}
    }


}

proc AncetreCommunDeLaListe {Liste {Quoi ""}} {


    if {$Quoi=="" || $Quoi=="IdCommun"} { set Quoi "TaxId" }
    set A [lindex $Liste 0]
    set A [Tax $A "TaxId"]
    set LesAutres [lrange $Liste 1 end]
    while {$LesAutres!={}} {
	set B [lindex $LesAutres 0]
	set LesAutres [lrange $LesAutres 1 end]
	set A [AncetreCommun $A $B]
    }
    set R [Tax $A $Quoi]
    return $R


}

proc AncetresDe {n} {

    global T

   set Lanc $n
    if {[info exists T($n,par)]} {
	set p $T($n,par)
    } else {
	return $n
    }
    while {$p >= -1} {
	lappend Lanc $p
	set f $p
	if {[info exists T($f,par)]} {
	    set p $T($f,par)
	} else {
	    break
	}
    }

    return $Lanc

}

proc AnchorsCoherents {FichierTFA FichierAnchors NomOuFichierBlast} {


    global RepertoireDuGenome

    JeMeSignale

    Wup "If the names in the TFA and Anchors don't correspond I change in the TFA"
    Wup " in Ballast I do otherwize and change in the Anchor file."

    if { ! [regexp -nocase {[0-9a-z_]} $FichierAnchors]} { return "" }

    foreach Ligne [LesLignesDuFichier $FichierTFA] {
	if { ! [regexp "^>" $Ligne]} { continue }
	regsub ">" $Ligne "" Ligne
	scan $Ligne "%s" AccessTFA
	set ACCESSTFA [string toupper $AccessTFA]
	set EstDansTFA($ACCESSTFA) 1
	set Beau($ACCESSTFA) $AccessTFA
    }

    set LesAnchorsAChanger {}
    foreach Ligne [LesLignesDuFichier $FichierAnchors] {
	if { ! [regexp "^seq\:" $Ligne]} { continue }
	set AccessAnchor ""
	scan $Ligne "%s %s %s" Seq Bidon AccessAnchor
	set ACCESSANCHOR [string toupper $AccessAnchor]
	if {[info exists EstDansTFA($ACCESSANCHOR)]} { continue }
	set MauvaisAnchors($ACCESSANCHOR) 1
	lappend LesAnchorsAChanger $AccessAnchor
    }

    if {$LesAnchorsAChanger=={}} { return $FichierAnchors }

    set FichierBlast $NomOuFichierBlast
    if { ! [regexp "/" $NomOuFichierBlast] || ! [file exists $FichierBlast]} {
	set Nom $NomOuFichierBlast
	set FichierBlast "$RepertoireDuGenome/blastp/$Nom"
    }
    if { ! [file exists $FichierBlast]} { return $FichierAnchors }

    DecortiqueBlast $FichierBlast "SansSeuilExpect" "SansLimiteDeNombre" Query lBanqueId lAccess lDE lProfil lPN
    foreach BanqueId $lBanqueId Access $lAccess {
	regsub {\:} $BanqueId "|" BanqueId
	if {[regexp "mol\:protein" $Access]} { set Access $BanqueId }
	set BANQUEID [string toupper $BanqueId]
	set ACCESS   [string toupper $Access]
	if {[info exists DejaVu($BANQUEID)] || [info exists DejaVu($ACCESS)]} {
	    FaireLire "Deja vu $BanqueID $Access !! "
	}
	set Beau($BANQUEID)  $BanqueId
	set Beau($ACCESS)    $Access
	if {$BANQUEID!=$ACCESS} {
	    set Autre($BANQUEID) $ACCESS
	    set Autre($ACCESS)   $BANQUEID
	}
    }

    set NouveauxAnchors {}
    foreach Ligne [LesLignesDuFichier $FichierAnchors] {
	if { ! [regexp "^seq\:" $Ligne]} { lappend NouveauxAnchors $Ligne ; continue }
	set AccessAnchor ""
	scan $Ligne "%s %s %s" Seq Bidon AccessAnchor
	set ACCESSANCHOR [string toupper $AccessAnchor]
	if { ! [info exists MauvaisAnchors($ACCESSANCHOR)]} {
	    lappend NouveauxAnchors $Ligne
	    continue
	}
	if { ! [info exists Autre($ACCESSANCHOR)]} {
	    if { [EstUnAccessPDB $ACCESSANCHOR] && [regexp "_$" $ACCESSANCHOR]} {
		regsub "_$" $ACCESSANCHOR "" AUTREACC
	    } else {
		lappend NouveauxAnchors $Ligne
		continue
	    }
	} else {
	    set AUTREACC [set Autre($ACCESSANCHOR)]
	}
	if { ! [info exists EstDansTFA($AUTREACC)]} {
	    lappend NouveauxAnchors $Ligne
	    continue
	}
	set BeauNouveau [set Beau($AUTREACC)]
	set NouvelleLigne [SubstitueAvecBlancsDevant $Ligne $AccessAnchor $BeauNouveau]
	lappend NouveauxAnchors $NouvelleLigne
    }
    SauveLesLignes $NouveauxAnchors dans "$FichierAnchors.coherent2"
    return [SauveLesLignes $NouveauxAnchors dans "$FichierAnchors.coherent"]


}

proc AnchorsCount {Nom} {


    global AnchorsCount
    global RepertoireDuGenome

    if {[info exists AnchorsCount($Nom)]} { return [set AnchorsCount($Nom)] }
    if {[info exists AnchorsCount("EstCharge")]} { return [set AnchorsCount("EstCharge")] }

    set FichierAnchorsCount "$RepertoireDuGenome/fiches/anchors_count"
    while { ! [file exists $FichierAnchorsCount]} {
	if { ! [OuiOuNon "Do I count, NOW, the anchors in each alignment ?"]} {
	    set AnchorsCount("EstCharge") -2
	    return [AnchorsCount $Nom]
	} else {
	    set LesAnchors {}
	    foreach PAB [ListeDesPABs] {
		set FichierMSF "$RepertoireDuGenome/msf/$PAB"
		if { ! [file exists $FichierMSF]} { continue }
		set Entete [string toupper [LesPremieresLignesDuFichier $FichierMSF 5]]
		if { ! [regexp -nocase "ANCHORS" $Entete]} {
		    set N -3
		} else {
		    set N [IntegerApres "ANCHORS" dans $Entete]
		}
		lappend LesAnchors "$PAB $N"
	    }
	    SauveLesLignes $LesAnchors dans $FichierAnchorsCount
	}
    }

    set AnchorsCount("EstCharge") -1
    foreach Ligne [LesLignesDuFichier $FichierAnchorsCount] {
	scan $Ligne "%s %d" NomLu N
	lappend AnchorsCount(LaListeMerci) $N
	set AnchorsCount($NomLu) $N
    }
    return [AnchorsCount $Nom]


}

proc AncienChangePreferences {} {


    global Couleurs
    global TypeCons
    global TypeText
    global SphDef
    global Defauts

    set w .pref
    toplevel $w
    wm title $w "Preferences"
    wm protocol $w WM_DELETE_WINDOW KillParLaCroix
    wm iconname $w "Preferences"

    frame  $w.colors
    pack $w.colors -side top -fill x
    grid rowconfig    $w.colors 0 -weight 1 -minsize 0
    grid columnconfig $w.colors 0 -weight 0 -minsize 0

    label $w.colors.global -text "Global conservation" -relief sunken
    #    pack $w.colors.global -side top
    grid $w.colors.global -in $w.colors -padx 1 -pady 20  -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky w

    set EltCo 0
    set EltLi 0
    foreach Type $TypeCons {
	if {$EltCo == "9"} {
	    set EltCo 0
	    incr EltLi
	}

	if {[lsearch $TypeCons $Type] == "3"} {
	    incr EltLi
	    label  $w.colors.group -text "Group conservation"
	    grid $w.colors.group -in $w.colors -padx 1 -pady 10  -row $EltLi -column $EltCo -rowspan 1 -columnspan 1 -sticky w
	    incr EltLi
	}

	if {[lsearch $TypeCons $Type] == "9"} {
	    incr EltLi
	    label  $w.colors.inter -text "Inter-Group conservation"
	    grid $w.colors.inter -in $w.colors -padx 1 -pady 10  -row $EltLi -column $EltCo -rowspan 1 -columnspan 1 -sticky w
	    incr EltLi
	}

	if {[lsearch $TypeCons $Type] == "15"} {
	    incr EltLi
	    label  $w.colors.points -text "Points"
	    grid $w.colors.points -in $w.colors -padx 1 -pady 10  -row $EltLi -column $EltCo -rowspan 1 -columnspan 1 -sticky w
	    incr EltLi
	}

	scan [set Couleurs($Type)] "%s %s" fg bg

	label  $w.colors.l$Type -text [set TypeText($Type)]
	grid $w.colors.l$Type -in $w.colors -padx 1 -pady 1  -row $EltLi -column $EltCo -rowspan 1 -columnspan 1 -sticky w
	incr EltCo

	button $w.colors.f$Type -background $fg -activebackground $fg -command "ChangeCouleur $Type $fg $w.colors.f$Type"
	grid $w.colors.f$Type -in $w.colors -padx 1 -pady 1  -row $EltLi -column $EltCo -rowspan 1 -columnspan 1 -sticky w
	incr EltCo

	button $w.colors.b$Type -background $bg -activebackground $bg -command "ChangeCouleur $Type $bg $w.colors.b$Type"
	grid $w.colors.b$Type -in $w.colors -padx 1 -pady 1  -row $EltLi -column $EltCo -rowspan 1 -columnspan 1 -sticky w
	incr EltCo
    }

    labelframe $w.control -relief groove -borderwidth 2 -text "Ordali Control Panel"
    grid rowconfig    $w.control 0 -weight 1 -minsize 0
    grid columnconfig $w.control 0 -weight 0 -minsize 0

    label $w.control.sph -text "Ordali Spheres"
    radiobutton $w.control.sphmean -text "Mean Volume" -variable SphDef -relief flat -value "Mean"
    radiobutton $w.control.sphhbnd -text "Mean Volume + HB" -variable SphDef -relief flat -value "HBond"

    label $w.control.sim -text "Use similarity"
    radiobutton $w.control.simy -text "Yes" -variable Defauts(SimiGris) -relief flat -value "1"
    radiobutton $w.control.simn -text "No" -variable Defauts(SimiGris) -relief flat -value "0"

    label $w.control.slg -text "Select length"
    radiobutton $w.control.slgy -text "Yes"  -variable Defauts(SelectionLong) -relief flat -value "1"
    radiobutton $w.control.slgn -text "No"  -variable Defauts(SelectionLong) -relief flat -value "0"

    label $w.control.sln -text "Select name"
    radiobutton $w.control.slny -text "Yes"  -variable Defauts(SelectionNom) -relief flat -value "1"
    radiobutton $w.control.slnn -text "No"  -variable Defauts(SelectionNom) -relief flat -value "0"

    label $w.control.chk -text "Check sequences"
    radiobutton $w.control.chky -text "Yes"  -variable Defauts(CheckSeq) -relief flat -value "1"
    radiobutton $w.control.chkn -text "No"  -variable Defauts(CheckSeq) -relief flat -value "0"

    label $w.control.grnc -text "Group Consensus 80%"
    radiobutton $w.control.grncy -text "Yes"  -variable Defauts(ConsNGrp) -relief flat -value "1"
    radiobutton $w.control.grncn -text "No"  -variable Defauts(ConsNGrp) -relief flat -value "0"

    set fontsize [lindex [split $fontext] 1]
    set fontsizeold $fontsize
    if {[lindex [split $fontext] 2] != ""} {
	set fontclas [lindex [split $fontext] 2]
	set fontclasold $fontclas
    } else {
	set fontclas "normal"
    }

    label $w.control.fntl -text "Alignment font : CourierNew "
    tk_optionMenu $w.control.fnts fontsize 6 8 10 12 14
    tk_optionMenu $w.control.fntc fontclas normal bold

    label $w.control.pds -text "Weighted sequences "
    radiobutton $w.control.pdsy -text "Yes"  -variable Defauts(Poids) -relief flat -value "1"
    radiobutton $w.control.pdsn -text "No"  -variable Defauts(Poids) -relief flat -value "0"

    grid $w.control.sph -in $w.control -padx 1 -pady 3  -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.sphmean -in $w.control -padx 1 -pady 3  -row 1 -column 1 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.sphhbnd -in $w.control -padx 10 -pady 3  -row 1 -column 2 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.sim -in $w.control -padx 1 -pady 3  -row 1 -column 3 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.simy -in $w.control -padx 1 -pady 3  -row 1 -column 4 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.simn -in $w.control -padx 10 -pady 3  -row 1 -column 5 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.slg -in $w.control -padx 1 -pady 3  -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.slgy -in $w.control -padx 1 -pady 3  -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.slgn -in $w.control -padx 10 -pady 3  -row 2 -column 2 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.sln -in $w.control -padx 1 -pady 3  -row 2 -column 3 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.slny -in $w.control -padx 1 -pady 3  -row 2 -column 4 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.slnn -in $w.control -padx 10 -pady 3  -row 2 -column 5 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.chk -in $w.control -padx 1 -pady 3  -row 3 -column 0 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.chky -in $w.control -padx 1 -pady 3  -row 3 -column 1 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.chkn -in $w.control -padx 10 -pady 3  -row 3 -column 2 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.grnc -in $w.control -padx 1 -pady 3  -row 3 -column 3 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.grncy -in $w.control -padx 1 -pady 3  -row 3 -column 4 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.fntl -in $w.control -padx 10 -pady 3  -row 4 -column 0 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.fnts -in $w.control -padx 10 -pady 3  -row 4 -column 1 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.fntc -in $w.control -padx 10 -pady 3  -row 4 -column 2 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.pds -in $w.control -padx 1 -pady 3  -row 5 -column 0 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.pdsy -in $w.control -padx 1 -pady 3  -row 5 -column 1 -rowspan 1 -columnspan 1 -sticky w
    grid $w.control.pdsn -in $w.control -padx 10 -pady 3  -row 5 -column 2 -rowspan 1 -columnspan 1 -sticky w

    pack  $w.control -side top -anchor w -padx 10 -pady 10

    frame $w.btnstrc
    pack $w.btnstrc -side bottom -pady 10
    button $w.btnstrc.cebon -text " OK " -background green1 -command "TermineChangePreferences $w"
    pack $w.btnstrc.cebon -side left

    MesCouleurs $w

    return

}

proc AncienNom {Nom} {


    foreach Ligne [LesLignesDuFichier "[RepertoireDuGenome]/lacorrespondance"] {
	scan $Ligne "%s %s" new old
	if {$new==$Nom} {
	    return $old
	}
    }


}

proc AncienNomsParmiLes555PCA {FichierCorrespondance} {

   
    foreach Ligne [LesLignesDuFichier $FichierCorrespondance] {
	set Old [lindex $Ligne 0]
	set PCA [lindex $Ligne 1]
	set Datas($PCA) $Old
    }
    set b 0
    foreach Nom [ListeDesPABs] {
	if {[info exists Datas($Nom)]} {
	    set OldNom $Datas($Nom)
	    if {[regexp "PROS" $OldNom]} {
		incr b 
	    }
	}
    }
    return $b


}

proc AngleDansRosace {R X {Y ""} {CentreX ""} {CentreY ""}} {


    global ParametresDuBoard

    set PI 3.14159

    if {[regexp -nocase {[a-z]} $X]} {
	set Nom $X
	set PosADN [Milieu $Nom]
	
	set Heure [expr $PosADN*2*$PI/[LongueurADN]]
	set Angle [expr  -$PI/2 - $Heure]]
	set Angle [expr $Angle + [DecalageAngulaireRosace]]
	set Angle [Entre0Et2PI [expr  -$PI/2 - $Heure]]
	return $Angle
    }

    if {$CentreX == ""} {
	set CentreX [set ParametresDuBoard($R,CentreX)]
	set CentreY [set ParametresDuBoard($R,CentreY)]
    }
    if {$R == "CoordonneesVraies"} {
	set xVrai $X
	set yVrai $Y
    } else {
	set xVrai [$R canvasx $X]
	set yVrai [$R canvasy $Y]
    }

    set x [expr $xVrai-$CentreX]
    set y [expr $yVrai-$CentreY]

    if {[expr abs($x) < 1] && [expr abs($y) < 1]} { return 0.0 }
    if {[expr abs($x) < 1] && [expr $y > 0]} {
	set Angle [expr $PI/2]
    } elseif {[expr abs($x) < 1] && [expr $y < 0]} {
	set Angle [expr 3*$PI/2]
    } else {
	set Angle [expr atan($y*1.0/$x)]
	if {$x<0} { set Angle [expr $Angle + $PI] }
	set Angle [expr $Angle + [DecalageAngulaireRosace]]
	set Angle [Entre0Et2PI $Angle]
    }
    return $Angle


}

proc AngleDeg {Angle {Unite r}} {


    #rR quand il n'y a pas de r on force le r
    if {[regexp -nocase "^r" $Unite]} { set Angle [expr ($Angle*180.)/[Pi]] }
    return $Angle


}

proc AngleEntre {V1 V2} {


    #lM 2014/05/21
    # angle qui ramene V1 sur V2
    set nV1 [V_nV $V1]
    set nV2 [V_nV $V2]

    if {[llength $nV2] == 2} {
	lassign $nV1 x1 y1
	lassign $nV2 x2 y2
	set sca [S_VV $nV1 * $nV2]
	set vct [expr {$x1*$y2-$x2*$y1}]
	set ang [expr {atan2($vct,$sca)}]
	if {$ang < 0.0} {
	    set ang [expr {$ang + [2Pi]}]
	}

	return $ang
    }

    set cos [S_VV $nV1 * $nV2]

    set vec [Vectoriel $nV1 $nV2]
    set sin [S_nV $vec]
    set vec [V_nV $vec]
    set verif [V_nV [Vectoriel $nV1 $vec]]
    set sver [S_VV $verif * $nV2]

    puts "   cos   $cos"
    puts "   sin   $sin"
    puts "   verif $verif"
    puts "   sver  $sver"

    set ang [expr {atan2($sin,$cos)}]
    puts "   ang [AngleDeg $ang]"
    if {$ang < 0.} {
	set ang [expr {$ang + [2Pi]}]
    }

    return $ang


}

proc AngleLRAncetres {AId n} {

    global Abr

    set t [set Abr(Arbre,$AId)]
    if {[$t isleaf $n]} {return}
    if {$n eq "root"} {return}

    set x [$t get $n xcoord]
    set y [$t get $n ycoord]
    set p [$t parent $n]
    lassign [$t children $p] e1 e2
    set xp [$t get $p xcoord]
    set yp [$t get $p ycoord]
    if {$x == $xp && $y == $yp} {
	if {$n eq $e1} {set p $e2} {set p $e1}
    }

    ::struct::tree tmpT
    tmpT deserialize [$t serialize]
    tmpT delete $n

    # ATTENTION ! Ordre inverse ! On regarde VERS la racine !!
    set Ln [tmpT nodes]
    if {[llength $Ln] > 2} {
	lassign [NoeudLRDe $AId $n $p $Ln 1] Nr Nl
    } else {
	lassign $Ln n1 n2
	if {$n1 eq "root"} {set Ln $n2} {set Ln $n1}
	set Nr $Ln
	set Nl $Ln
    }

    set xaR [$t get $Nr xcoord]
    set yaR [$t get $Nr ycoord]
    set Ang [Coords2Angle [expr {$xaR-$x}] [expr {$yaR-$y}]]
    set AR $Ang

    set xaL [$t get $Nl xcoord]
    set yaL [$t get $Nl ycoord]
    set Ang [Coords2Angle [expr {$xaL-$x}] [expr {$yaL-$y}]]
    set AL $Ang

    puts "----- Ancetre Gauche/Droite ----------------"
    puts [format "AL %6.3f AR %6.3f" $AL $AR]
    puts "NdL $Nl NdR $Nr"

    tmpT destroy

    $t set $n AncesR $AR
    $t set $n AncesL $AL
    $t set $n NdAncesL $Nl
    $t set $n NdAncesR $Nr

    return

}

proc AngleMaxGaucheDroite {AId n} {

    global Abr

    set t [set Abr(Arbre,$AId)]
    if {[$t isleaf $n]} {return}
    #    if {$n eq "root"} {exir}

    puts "--- Min Max Gauche/Droit ---------"
    puts [format "Nd n : %s | x=%7.2f y=%7.2f" $n [$t get $n xcoord] [$t get $n ycoord]]

    set NdL [$t get $n NdLeft]
    set NdR [$t get $n NdRight]
    set LNdL [concat $NdL [$t descendants $NdL]]
    set LNdR [concat $NdR [$t descendants $NdR]]

    set LMM [AnglesMinMaxDe $AId $n $LNdL]
    lassign $LMM Am Ax Sum
    set Am2  [expr {$Am>[Pi]?$Am-[2Pi]:$Am}]
    set Ax2  [expr {$Ax>[Pi]?$Ax-[2Pi]:$Ax}]
    set Sum2 [expr {$Sum>[Pi]?$Sum-[2Pi]:$Sum}]
    puts "Am2 $Am2 Ax2 $Ax2 Sum2 $Sum2"
    set LRLL [expr {abs($Sum2-$Am2)+abs($Ax2-$Sum2)}]
    if {$LRLL > [Pi]} {set obtu 1} {set obtu 0}

    if {abs($Ax-$Am) > [Pi] && ! $obtu} {
	if {$Am < $Ax} {
	    $t set $n LeftL $Am
	    $t set $n LeftR $Ax
	} else {
	    $t set $n LeftL $Ax
	    $t set $n LeftR $Am
	}
    } else {
	if {$Am > $Ax} {
	    $t set $n LeftL $Am
	    $t set $n LeftR $Ax
	} else {
	    $t set $n LeftL $Ax
	    $t set $n LeftR $Am
	}
    }

    set LMM [AnglesMinMaxDe $AId $n $LNdR]
    lassign $LMM Am Ax Sum
    set Am2  [expr {$Am>[Pi]?$Am-[2Pi]:$Am}]
    set Ax2  [expr {$Ax>[Pi]?$Ax-[2Pi]:$Ax}]
    set Sum2 [expr {$Sum>[Pi]?$Sum-[2Pi]:$Sum}]
    set RRRL [expr {abs($Sum2-$Am2)+abs($Ax2-$Sum2)}]
    if {$RRRL > [Pi]} {set obtu 1} {set obtu 0}

    if {abs($Ax-$Am) > [Pi] && ! $obtu} {
	if {$Am < $Ax} {
	    $t set $n RightL $Am
	    $t set $n RightR $Ax
	} else {
	    $t set $n RightL $Ax
	    $t set $n RightR $Am
	}
    } else {
	if {$Am > $Ax} {
	    $t set $n RightL $Am
	    $t set $n RightR $Ax
	} else {
	    $t set $n RightL $Ax
	    $t set $n RightR $Am
	}
    }

    $t set $n LRLL $LRLL
    $t set $n RRRL $RRRL

    puts [format "Nd L %s | LL %5.2f LR %5.2f LRLL %5.2f" [$t get $n NdLeft] [$t get $n LeftL] [$t get $n LeftR] [$t get $n LRLL]]
    puts [format "Nd R %s | RL %5.2f RR %5.2f RRRL %5.2f" [$t get $n NdRight] [$t get $n RightL] [$t get $n RightR] [$t get $n RRRL]]
    puts ""

    return

}

proc AngleRad {Angle {Unite d}} {


    #rR quand il n'y a pas de degres on force degre
    if {[regexp -nocase "^d" $Unite]} { set Angle [expr ($Angle*[Pi])/180.] }
    return $Angle


}

proc Angle_R {R} {


    return [lindex $R 0]


}

proc AnglesMinMaxDe {AId n Le} {

    global Abr

    set t [set Abr(Arbre,$AId)]
    set Am  999.
    set Ax -999.
    set x [$t get $n xcoord]
    set y [$t get $n ycoord]
    set p [$t parent $n]
    set xp [$t get $p xcoord]
    set yp [$t get $p ycoord]
    set AnP [Coords2Angle [expr {$x-$xp}] [expr {$y-$yp}]]

    foreach d $Le {
	set xd [$t get $d xcoord]
	set yd [$t get $d ycoord]
	set Ang [Coords2Angle [expr {$xd-$x}] [expr {$yd-$y}]]

	if {$Ang < $Am} {set Am  $Ang}
	if {$Ang > $Ax} {set Ax  $Ang}
    }

    return [list $Am $Ax $AnP]

}

proc AnimateurSVP {IpCafe} {


    global CafeDesSciencesDir
    global Cafe

    DecortiqueIpCafe "$IpCafe" Ip Cafe
    PotinsDeQuestion "AnimateurSVP IpCafe $Ip $Cafe"

    set SocketteAnimateur ""
    while {[catch {set SocketteAnimateur [socket $Ip $Cafe]} Message]  && [regexp "address already in use" $Message]} {
	PotinsDeQuestion "attente Sockette $SocketteAnimateur du $Ip $Cafe already in use ..."
	set SocketteAnimateur ""
	after 1000
    }
    if {$SocketteAnimateur!=""} {
	PotinsDeQuestion "SocketteAnimateur $SocketteAnimateur";
	return $SocketteAnimateur
	#rR on avait un SocketteAnimateur en marche. **************************************
    }


    #rR pas d'animateur, on en cree un. ****************************************************
    set Hostname [info hostname]
    regsub {\..*} $Hostname "" HostnameCourt

    set RemoteShell "rsh $Ip -n"
    if {$Ip==$HostnameCourt || $Ip=="localhost" || [regexp {^127\.0} $Ip]} { set RemoteShell "" }

    set BiolOuQuoi "[string range $CafeDesSciencesDir 0 4]..."
    PotinsDeQuestion "exec $RemoteShell $BiolOuQuoi/cafe_des_sciences.tcl $Ip:$Cafe"

    eval exec $RemoteShell $CafeDesSciencesDir/cafe_des_sciences.tcl "$Ip:$Cafe" &

    after 1000
    set Encore 10
    while { [catch {set SocketteAnimateur [socket $Ip $Cafe]} MessageCafeFerme] } {
	if { ! [incr Encore -1] } {
	    PotinsDeQuestion "erreur: J'abandonne socket $Ip $Cafe"
	    return "erreur: Abandon animateur socket $Ip $Cafe  \nAfter execution of  \nexec $RemoteShell $CafeDesSciencesDir/cafe_des_sciences.tcl $Ip:$Cafe  \n I got the message : $MessageCafeFerme"
	}
	PotinsDeQuestion "$Encore attente socket $Ip $Cafe : $MessageCafeFerme"
	after 1000
    }
    PotinsDeQuestion "SocketteAnimateur $SocketteAnimateur"
    return $SocketteAnimateur


}

proc AnneGraph {args} {


    set file [lindex $args 0]

    set Ll [LesLignesDuFichier $file]
    set fx 1.
    set step 25
    set Diam 50
    set OffX 20
    set Lcol [list red brown orange green yellow dimgrey cyan pink magenta blue]

    toplevel .anne
    canvas .anne.c -width 1000 -height 1000 -background "#0000ff"
    pack .anne.c
    set w ".anne.c"

    set MaxX 0
    set MaxY 0
    set i 0
    foreach l [lrange $Ll 1 end] {
	set j 0
	foreach v [lrange [split $l "\t"] 1 end] {
	    set col [lindex $Lcol $j]
	    set r [expr $v * $Diam / 2]
	    set ym [expr (10-$j)*$step - $r]
	    set yx [expr (10-$j)*$step + $r]
	    set xm [expr $i*$step - $r + $OffX]
	    set xx [expr $i*$step + $r + $OffX]
	    $w create oval $xm $ym $xx $yx -fill $col -outline black
	    incr j
	    if {$yx > $MaxY} {set MaxY $yx}
	    if {$xx > $MaxX} {set MaxX $xx}
	}
	incr i
    }

    set MaxX [expr $MaxX + $OffX]
    $w configure -height $MaxY -width $MaxX

    return

}

proc Anne_CluspackGridChoixSecatorDPC {NomATraiter} {


    # cette proc de Anne utilise les procs de Luc (proc LanceurCluspack)
    # NB: LanceurCluspack peut passer a DPC si secator "plante" ou l'inverse. Ca arrive sur certains alignements.
    
    # !!! il est necessaire de lancer "setgscoperr NomDuProjet" puis "setordalilm" !!!
    
    # version cree mais momentanement non utilisee
    # en effet, problemes observes avec secator :
    # determine parfois des groupes contenant 1 seule sequence
    # a choisi en attendant de travailler avec DPC uniquement!!
    
    #global PipeCollection
    global PipeQuery

    set InInitLeon [file join [RepertoireDuGenome] leon $NomATraiter]
    set InLeon [file join [RepertoireDuGenome] cluspack ${NomATraiter}.msf]
    # placement du fichier d alignement dans le bon repertoire pour n avoir pas 
    # a deplacer les fichiers ensuite
    File copy -force $InInitLeon $InLeon
    
    # fichier ".clu" cree quel que soit la methode de clusterisation utilisee
    set OutClu [file join [RepertoireDuGenome] cluspack ${NomATraiter}.clu]
    # les autres fichiers sont crees uniquement par secator
    set OutNJ [file join [RepertoireDuGenome] cluspack ${NomATraiter}.nj]
    set OutDst [file join [RepertoireDuGenome] cluspack ${NomATraiter}.dst]

    if {! [file exists $InLeon]} {return 0}
    
    set NbAccess 0
    # determination du nombre de sequences dans l alignement
    set cmd "grep -c \"Name\" $InLeon" 
    set NbAccess [eval exec $cmd]
    
    # quel que soit le programme de clusterisation le debut de la commande est la meme
    set commande "LanceurCluspack $InLeon alignment"

    if {$NbAccess > 100} {
	set Moi    "dpc"
	puts $Moi
	set LAutre "secator"
	set arg "dpc kmeans 0.001"
	set FileClustering "${InLeon}.clu"
    } else {
	set Moi    "secator"
	puts $Moi
	set LAutre "dpc"
	set arg "secator bionj"
	set FileClustering "${InLeon}.clu"
	
    }

    if {[catch {eval $commande $arg} Message]} {
	Espionne $Message
	Espionne "Problem with $InLeon with $Moi je vais utiliser $LAutre"
	if {$LAutre == "secator"} {
	    catch {[$commande secator bionj]}
	} else {
	    catch {[$commande dpc kmeans 0.001]}
	}    
    }

    File delete -force $InLeon

    if {[file exists $OutNJ]} { File delete -force $OutNJ }
    if {[file exists $OutDst]} { File delete -force $OutDst }

    return 1


}

proc AnnotRep {} {


    return "/genomics/link/EleGen/code"


}

proc AnnotType {{Qui ""} {Quoi ""}} {


    global AnnotType
    if {[info exists AnnotType($Qui,$Quoi)]}  { return $AnnotType($Qui,$Quoi) }
    if {[info exists AnnotType("EstCharge")]}  {
	set QUI [string range [string toupper $Qui] 0 3]
	if {[info exists AnnotType($QUI,$Quoi)]} { return $AnnotType($QUI,$Quoi) }
	return ""
    }
    set AnnotType("EstCharge") 1

    set LesTypesCodes {}
    lappend LesTypesCodes           "genes_intergenic 1 Intergene"
    lappend LesTypesCodes           "enhancers_fantom 2 Enhancer"
    lappend LesTypesCodes               "genes_1to5kb 3 1to5kb"
    lappend LesTypesCodes              "genes_introns 4 Intron"
    lappend LesTypesCodes            "genes_promoters 5 Promoter"
    lappend LesTypesCodes "genes_intronexonboundaries 6 Boundary"
    lappend LesTypesCodes                "genes_3UTRs 7 3UTR"
    lappend LesTypesCodes                "genes_5UTRs 8 5UTR"
    lappend LesTypesCodes           "genes_firstexons 9 1stExon"
    lappend LesTypesCodes                "genes_exons X Exon"

    foreach TC $LesTypesCodes {
	scan $TC "%s %s %s" Type T Code
	lappend AnnotType(ListOf,Type) $Type
	lappend AnnotType(ListOf,T)    $T
	lappend AnnotType(ListOf,Code) $Code
	set AnnotType($Type,Type) $Type
	set AnnotType($Type,T)    $T
	set AnnotType($Type,Code) $Code
	set AnnotType($T,Type)    $Type
	set AnnotType($T,T)       $T
	set AnnotType($T,Code)    $Code
	set AnnotType($Code,Type) $Type
	set AnnotType($Code,T)    $T
	set AnnotType($Code,Code) $Code
	set AnnotType([string range [string toupper $Code] 0 3],Type) $Type
	set AnnotType([string range [string toupper $Code] 0 3],T)    $T
	set AnnotType([string range [string toupper $Code] 0 3],Code) $Code
    }

    set AnnotType(F,Type) Final
    set AnnotType(F,T)    F
    set AnnotType(F,Code) Final 

    return [AnnotType $Qui $Quoi]


}

proc AnnotVerif {Chr Q} {


    #set Final [ContenuDuFichier "[AnnotRep]/${Chr}_Final"] 
    set Xdn$Q [ContenuDuFichier "[AnnotRep]/${Chr}_Xdn$Q"] 
    set D 0
    set F $D
    set Previous "."
    set LesBornes {}
    foreach X [split [set Xdn$Q] ""] {
	if {$X eq "."} {
	    if {$Previous ne "."} { lappend LesBornes "$D $F" }
	    incr D
	    incr F
	} else {
	    incr F
	}
	set Previous $X
    }
    return $LesBornes


}

proc AnnotXdn {{Chr ""}} {


    set Rep [AnnotRep]
    set FichierAnnot  "$Rep/$Chr.annot"	
    set	FichierTypes  "$Rep/AnnotTypes.txt"
    # "chr19"	481674	481793	120	"*"	"enhancer:28085"	NA	NA	NA	"hg19_enhancers_fantom"
    # "chr19"	10654633	10655632	1000	"+"	"promoter:66212"	"uc010dxj.3"	"84971"	"ATG4D"	"hg19_genes_promoters"
    
    set LesXdn {}
    set Min 999999999999
    set Max -1
    foreach Ligne [LesLignesDuFichier $FichierAnnot] {
	regsub -all {\"} $Ligne "" Ligne		
	set LesMots [LesMotsDeLaLigne $Ligne]
	lassign $LesMots Ch Start Stop Length Brin Id Ucsc Gi Gn Type
	regsub {[a-z]+[0-9]+_} $Type "" Type 
	lappend LesBornes($Type) "$Start $Stop"
	set InfoDe($Type,$Stop) $Ligne
	lappend LesGn $Gn
	set Min [Mini $Start $Min]
	set Max [Maxi $Stop  $Max]
    }
    
    foreach Type [AnnotType ListOf Type] T [AnnotType ListOf T] {
	Espionne 
	Espionne $Type
	if { ! [info exists LesBornes($Type)]} { Espionne "Bornes pour $Type non trouve"; continue }
	set I 0
	set LesDF $LesBornes($Type)
	set LesDFTries [lsort -integer -index 0 $LesDF]

	Espionne "[llength $LesDFTries] element a traiter"

	set LesDFRetenus $LesDFTries
	set Superpose 1
	set I 0
	set J 1
	set DF1 [lindex $LesDFTries $I]
	set DF2 [lindex $LesDFTries $J]
	set LesBons {}
	set LesInfos {}
	Espionne "$J $DF1 $DF2 avant boucle pour $Type"
	while 1 {
	    if {$J%100==1} { Espionne "$J $DF1 $DF2" }
	    lassign $DF1 D1 F1
	    lassign $DF2 D2 F2
	    if {$D1==$D2} {
		set F2 [Maxi $F1 $F2]
		set DF1 "$D1 $F2"
		incr J
		set DF2 [lindex $LesDFTries $J]
		if {$DF2==""} {
#		    Espionne $DF1
		    lappend LesBons $DF1
		    lassign $DF1 D F
		    lappend LesInfos "$DF1\t$InfoDe($Type,$F)"
		    break
		}
#		Espionne "D1=D2"
		continue
	    }
	    if {$D2<=$F1} {
		set DF1 "$D1 [Maxi $F1 $F2]"
		incr J 
		set DF2 [lindex $LesDFTries $J]
		if {$DF2==""} {
#		    Espionne $DF1
		    lappend LesBons $DF1
		    lassign $DF1 D F
		    lappend LesInfos "$DF1\t$InfoDe($Type,$F)"
		    break
		}
#		Espionne "D2<=F1"
		continue
	    }
	    if {$F2<=$F1} {
		incr J
		set DF2 [lindex $LesDFTries $J]
		if {$DF2==""} {
#		    Espionne $DF1
		    lappend LesBons $DF1
		    lassign $DF1 D F
		    lappend LesInfos "$DF1\t$InfoDe($Type,$F)"
		    break
		}
#		Espionne "F2<=F1"
		continue
	    }
	    if {$F1==$D2} {
		set DF1 "$D1 $F2"
		incr J
		set DF2 [lindex $LesDFTries $J]
		if {$DF2==""} {
#		    Espionne $DF1
		    lappend LesBons $DF1
		    lassign $DF1 D F
		    lappend LesInfos "$DF1\t$InfoDe($Type,$F)"
		    break
		}
#		Espionne "F1=D2"
		continue
	    }
	    if {$F1<$D2} {
#		Espionne "$DF1"
		lappend LesBons "$DF1"
		lassign $DF1 D F
		lappend LesInfos "$DF1\t$InfoDe($Type,$F)"
		set DF1 $DF2
		incr J
		set DF2 [lindex $LesDFTries $J]
		if {$DF2==""} {
		    lappend LesBons "$DF1"
		    lassign $DF1 D F
		    lappend LesInfos "$DF1\t$InfoDe($Type,$F)"
		    break
		}
#		Espionne "F1<D2"
		continue
	    }
	    if {$F1<$F2} {
		set DF1 "$D1 $F2"
		incr J
		set DF2 [lindex $LesDFTries $J]
		if {$DF2==""} {
#		    Espionne $DF1
		    lappend LesBons $DF1
		    lassign $DF1 D F
		    lappend LesInfos "$DF1\t$InfoDe($Type,$F)"
		    break
		}
		continue
	    }
	    FaireLire "Cas non traite $DF1 - $DF2"
	}
	SauveLesLignes $LesInfos dans "[AnnotRep]/${Chr}_Infos$T"
	Espionne [SauveLesLignes $LesBons dans "[AnnotRep]/${Chr}_Bornes$T"]

	Espionne [format "%-30s %10d %30s %s %30s" $Type [llength $LesBons] [lindex $LesBons 0] a [lindex $LesBons end]]

	set Xdn ""
	set Precedent -1
	foreach SS $LesBons {
	    lassign $SS D F
	    set LA [expr $D-$Precedent-1]
	    set Avant [string repeat "." $LA]
	    set Bout  [string repeat $T [expr $F-$D+1]]
	    append Xdn "$Avant$Bout"
	    Espionne "$SS [string length $Xdn]"
	    set Precedent $F
	    #Espionne $Xdn
	}
	set LF [expr $Max-$Precedent]
	append Xdn [string repeat "." $LF]
	set FicXdn "$Rep/${Chr}_Xdn$T"
	Espionne "[string length $Xdn] bases a sauver dans $FicXdn"
	#Sauve $Xdn dans $FicXdn
	set o [open $FicXdn "w"]
	puts $o $Xdn
	flush $o
	close $o
	Espionne "fait"
	lappend LesXdn $FicXdn
    }
    return $LesXdn


}

proc AnnotXdnFinal {Chr {Ultime ""}} {



    if {$Ultime==""} { set Ultime "X" }

    foreach FichierXdn [lsort [glob "[AnnotRep]/${Chr}_Xdn*"]] {
	Espionne $FichierXdn
	set Queue [file tail $FichierXdn]
	Espionne $Queue
	regsub {^Chr[0-9]+_} $Queue "" Var
	set $Var [ContenuDuFichier $FichierXdn]
    }

    set Max [string length $XdnX]
    if { ! [info exists Xdn1]} { set Xdn1 [string repeat "." $Max] }
    if { ! [info exists Xdn2]} { set Xdn2 [string repeat "." $Max] }
    if { ! [info exists Xdn3]} { set Xdn3 [string repeat "." $Max] }
    if { ! [info exists Xdn4]} { set Xdn4 [string repeat "." $Max] }
    if { ! [info exists Xdn5]} { set Xdn5 [string repeat "." $Max] }
    if { ! [info exists Xdn6]} { set Xdn6 [string repeat "." $Max] }
    if { ! [info exists Xdn7]} { set Xdn7 [string repeat "." $Max] }
    if { ! [info exists Xdn8]} { set Xdn8 [string repeat "." $Max] }
    if { ! [info exists Xdn9]} { set Xdn9 [string repeat "." $Max] }

    set Final ""
    set I 0
    foreach X1 [split $Xdn1 ""] X2 [split $Xdn2 ""] X3 [split $Xdn3 ""] X4 [split $Xdn4 ""] X5 [split $Xdn5 ""] X6 [split $Xdn6 ""] X7 [split $Xdn7 ""] X8 [split $Xdn8 ""]  X9 [split $Xdn9 ""]  XX [split $XdnX ""] {
	if {[incr I]%10000==1} { Espionne "construction de Final longueur actuelle [string length $Final]" }
	set X "."
	if {$Ultime>="X"} { if {$XX ne "."} { append Final $XX ; continue } }
	if {$Ultime>="9"} { if {$X9 ne "."} { append Final $X9 ; continue } }
	if {$Ultime>="8"} { if {$X8 ne "."} { append Final $X8 ; continue } }
	if {$Ultime>="7"} { if {$X7 ne "."} { append Final $X7 ; continue } }
	if {$Ultime>="6"} { if {$X6 ne "."} { append Final $X6 ; continue } }
	if {$Ultime>="5"} { if {$X5 ne "."} { append Final $X5 ; continue } }
	if {$Ultime>="4"} { if {$X4 ne "."} { append Final $X4 ; continue } }
	if {$Ultime>="3"} { if {$X3 ne "."} { append Final $X3 ; continue } }
	if {$Ultime>="2"} { if {$X2 ne "."} { append Final $X2 ; continue } }
	                                      append Final $X1
    }
    set FicFinal "[AnnotRep]/${Chr}_Final.$Ultime"
    set o [open $FicFinal "w"]
    puts $o $Final
    flush $o
    close $o
    return $FicFinal
    


}

proc AnnotationEC {Nom SequencesDuGroupe} {


    set Fichier  "[RepertoireDuGenome]/macsims/$Nom.xml"

    if {! [file exists $Fichier]} {
	return "none"
    }
    set ListeDesECs {}
    ParseMACSIMS $Fichier macsims
    
    foreach Sequence $SequencesDuGroupe {
	set EC $macsims($Sequence,EC)
	if {$EC == "0.0.0.0"} {continue}
	regsub -all "EC " $EC "" EC
	regsub -all "EC_" $EC "" EC
	lappend ListeDesECs "$EC"
	lappend ListeDesECsAvecAccess [list $Sequence $EC]
    }
    
    set ECRetenu [ECDominant $ListeDesECs 0.7]
    if {$ECRetenu == ""} {set ECRetenu "none"}
    if {$ECRetenu != "none"} {
	set DefinitionEC [EnzymeCommission $ECRetenu]
	return [list $ECRetenu $DefinitionEC $ListeDesECsAvecAccess]
    } else {
	return "$ECRetenu"
    }


}

proc AnnotationGO {Nom AvecOuSansOrganismeEtudie} {


    FichierMsfPourGOAnno $Nom "$AvecOuSansOrganismeEtudie"
    RecreeLeFichierClust $Nom "$AvecOuSansOrganismeEtudie"
    LanceurGOAnno $Nom


}

proc AnnotationXml {FichierAnnotation {Quoi ""} args} {


    #FichierAnnotation "" "FichierMacsims.xml" ?"query"?
    #FichierAnnotation "GO" "FichierGeneOntology.xml"
    #FichierAnnotation "EC" "SortieDeProcedureEC"
    #FichierAnnotation "DE" "SortieDeProcedureMeilleureDef"
    #FichierAnnotation "PFAM" "SortieDeProcedurePFAM"

    # Lit xml existant ou crée document vide
    if {[file isfile $FichierAnnotation]} {
	set fh [open $FichierAnnotation "r"]
	dom parse -channel $fh doc
	close $fh
	$doc documentElement root
    } else {
	dom createDocument "annotation" doc
	$doc documentElement root
	
	#$root appendChild [$doc createElement "macsims"]
	#$root appendChild [$doc createElement "ec"]
	#$root appendChild [$doc createElement "gene_ontology"]
	#$root appendChild [$doc createElement "definition"]
	#$root appendChild [$doc createElement "pfam"]
    }

    # Création des noeuds principaux s'ils n'existent pas encore
    foreach n [list "macsims" "ec" "gene_ontology" "definition" "pfam"] {
	if {[llength [$root selectNodes "/annotation/$n"]] == 0} {
	    $root appendChild [$doc createElement $n]
	}
    }

    if {$Quoi eq ""} {
	set FichierMacsims [lindex $args 0]
	set Query [lindex $args 1]
	if {$Query eq ""} {set Query [regexp -inline {^[^.]+} [file tail $FichierMacsims]]}

	if {[file isfile $FichierMacsims]} {
	    # Tente de parser le fichier MACSIMS
	    set retryCount 5
	    while {$retryCount && [catch {
		ParseMACSIMS $FichierMacsims macsims
	    }]} {
		incr retryCount -1
	    }
	    if {!$retryCount} {error "Probleme avec $FichierMacsims"}
	    
	    # Récupère le groupe de la query
	    set groupeQuery $macsims(Groupe,$macsims($Query,Groupe))

	    # Récupère le noeud macsims
	    set macsimsNode [$root selectNodes "/annotation/macsims"]
	    # Supprime tous les noeud enfants
	    foreach node [$macsimsNode childNodes] {$node delete}
	    # ... et les attributs
	    foreach attrib [$macsimsNode attributes] {$macsimsNode removeAttribute $attrib}
	    
	    # Crée les commandes de creation de noeuds
	    dom createNodeCmd "elementNode" AnnotationXml::normd
	    dom createNodeCmd "elementNode" AnnotationXml::cluster
	    dom createNodeCmd "elementNode" AnnotationXml::query
	    dom createNodeCmd "elementNode" AnnotationXml::access
	    dom createNodeCmd "textNode" AnnotationXml::text

	    $macsimsNode appendFromScript {
		AnnotationXml::normd {AnnotationXml::text $macsims(Alignement,Score)}
		AnnotationXml::cluster "size" [llength $groupeQuery] {
		    AnnotationXml::query {AnnotationXml::text $Query}
		    foreach nom $groupeQuery {
			if {$nom ne $Query} {
			    AnnotationXml::access {AnnotationXml::text $nom}
			}
		    }
		}
	    }
	}
    } elseif {$Quoi eq "EC"} {
	set SortieDeProcedure [lindex $args 0]
	if {[llength $SortieDeProcedure] == 3} {
	    set commun [lindex $SortieDeProcedure 0]
	    set lClasses [lindex $SortieDeProcedure 1]
	    set lECs [lindex $SortieDeProcedure 2]
	} else {
	    set commun ""
	    set lClasses ""
	    set lECs ""
	}
	
	# Récupère le noeud ec
	set ecNode [$root selectNodes "/annotation/ec"]
	# Supprime tous les noeud enfants
	foreach node [$ecNode childNodes] {$node delete}
	# ... et les attributs
	foreach attrib [$ecNode attributes] {$ecNode removeAttribute $attrib}
	
	if {$commun ne "" && $lClasses ne "" && $lECs ne ""} {
	    # Crée les commandes de creation de noeuds
	    dom createNodeCmd "elementNode" AnnotationXml::common
	    dom createNodeCmd "elementNode" AnnotationXml::classes
	    dom createNodeCmd "elementNode" AnnotationXml::class
	    dom createNodeCmd "elementNode" AnnotationXml::sources
	    dom createNodeCmd "elementNode" AnnotationXml::source
	    dom createNodeCmd "textNode" AnnotationXml::text
	    
	    $ecNode appendFromScript {
		AnnotationXml::common {AnnotationXml::text $commun}
		AnnotationXml::classes {
		    foreach {classe def} $lClasses {
			AnnotationXml::class "number" $classe {AnnotationXml::text $def}
		    }
		}
		AnnotationXml::sources {
		    foreach liste $lECs {
			foreach {access ec} $liste {}
			AnnotationXml::source "ec" $ec {
			    AnnotationXml::text $access
			}
		    }
		}
	    }
	}
    } elseif {$Quoi eq "GO"} {
	set FichierGeneOntology [lindex $args 0]

	if {[file isfile $FichierGeneOntology]} {
	    # Parse le fichier GOAnno
	    ParseGOAnno $FichierGeneOntology goanno

	    # Récupère toute la hiérarchie go des parents
	    set ascendants {}
	    foreach go [concat $goanno(GPO,BiologicalProcess,GOs) $goanno(GPO,CellularComponent,GOs) $goanno(GPO,MolecularFunction,GOs)] {
		set ascendants [concat $ascendants [TousLesAscendantsGO $go]]
	    }
	    set ascendants [lsort -dictionary -index 2 [lsort -unique $ascendants]]
	    
	    # Récupère le noeud gene ontology
	    set goNode [$root selectNodes "/annotation/gene_ontology"]
	    # Supprime tous les noeud enfants
	    foreach node [$goNode childNodes] {$node delete}
	    # ... et les attributs
	    foreach attrib [$goNode attributes] {$goNode removeAttribute $attrib}

	    # Crée les commandes de creation de noeuds
	    dom createNodeCmd "elementNode" AnnotationXml::gpo
	    dom createNodeCmd "elementNode" AnnotationXml::hierarchy
	    dom createNodeCmd "elementNode" AnnotationXml::go
	    dom createNodeCmd "textNode" AnnotationXml::text
	    
	    $goNode appendFromScript {
		AnnotationXml::gpo {
		    foreach {type xmlType ontoType} [list "BiologicalProcess" "biological_process" "process" "CellularComponent" "cellular_component" "component" "MolecularFunction" "molecular_function" "function"] {
			foreach go $goanno(GPO,$type,GOs) {
			    set niv [lsort -unique [Onto $ontoType $go "LesNiveaux"]]
			    set parents [Onto $ontoType $go "LesParents"]

			    AnnotationXml::go "id" $go "type" $xmlType "levels" $niv "parents" $parents {
				AnnotationXml::text $goanno(GPO,$type,$go,Definition)
			    }
			}
		    }
		}
		AnnotationXml::hierarchy {
		    foreach goList $ascendants {
			foreach {go type niv def parents} $goList {}
			if {$type == "process"} {
			    set type "biological_process"
			} elseif {$type == "component"} {
			    set type "cellular_component"
			} elseif {$type == "function"} {
			    set type "molecular_function"
			}
			AnnotationXml::go "id" $go "type" $type "levels" $niv "parents" $parents {
			    AnnotationXml::text $def
			}
		    }
		}
	    }
	}
    } elseif {$Quoi eq "DE"} {
	set SortieDeProcedure [lindex $args 0]
	set score [lindex $SortieDeProcedure 0]
	set def [lindex $SortieDeProcedure 1]
	
	# Récupère le noeud gene ontology
	set deNode [$root selectNodes "/annotation/definition"]
	# Supprime tous les noeud enfants
	foreach node [$deNode childNodes] {$node delete}
	# ... et les attributs
	foreach attrib [$deNode attributes] {$deNode removeAttribute $attrib}
	
	if {$score ne "" && $def ne ""} {
	    # Crée les commandes de creation de noeuds
	    dom createNodeCmd "textNode" AnnotationXml::text
	    
	    $deNode setAttribute "score" $score
	    $deNode appendFromScript {
		AnnotationXml::text $def
	    }
	}
    } elseif {$Quoi eq "PFAM"} {
	set SortieDeProcedure [lindex $args 0]
	
	# Récupère le noeud pfam
	set pfNode [$root selectNodes "/annotation/pfam"]
	# Supprime tous les noeud enfants
	foreach node [$pfNode childNodes] {$node delete}
	# ... et les attributs
	foreach attrib [$pfNode attributes] {$pfNode removeAttribute $attrib}
	
	if {[llength $SortieDeProcedure] != 0} {
	    # Crée les commandes de creation de noeuds
	    dom createNodeCmd "elementNode" AnnotationXml::pfam_a
	    dom createNodeCmd "textNode" AnnotationXml::text
	    
	    $pfNode appendFromScript {
		foreach lPf $SortieDeProcedure {
		    foreach {access type accessPf dePf from longueurSeq} $lPf {}
		    AnnotationXml::pfam_a "access" $accessPf "from" $from "length" $longueurSeq {
			AnnotationXml::text $dePf
		    }
		}
	    }
	}
    }

    # Sauve le fichier
    set fh [open $FichierAnnotation "w"]
    puts $fh "<?xml version=\"1.0\"?>"
    $doc asXML -channel $fh -doctypeDeclaration 0
    close $fh
    $doc delete


}

proc AnnotationXmlPourPAB {pab} {


    set RepertoireAnnotation "[RepertoireDuGenome]/annotation"
    if {![file isdirectory $RepertoireAnnotation]} {file mkdir $RepertoireAnnotation}
    set FichierAnnotation "$RepertoireAnnotation/$pab.xml"

    set FichierMacsims "[RepertoireDuGenome]/macsims/$pab.xml"
    if {[file isfile $FichierMacsims]} {
	# Extrait groupe macsims de la query
	ParseMACSIMS $FichierMacsims macsims
	set groupeQuery $macsims(Groupe,$macsims($pab,Groupe))
	set posQuery [lsearch -exact $groupeQuery $pab]
	set groupeQuery [lreplace $groupeQuery $posQuery $posQuery]

	# Annotation MACSIMS
	AnnotationXml $FichierAnnotation "" $FichierMacsims
	
	# Annotation EC
	AnnotationXml $FichierAnnotation "EC" [AnnotationEC $pab $groupeQuery]

	# Annotation GOAnno
	set FichierGOAnno "[RepertoireDuGenome]/GeneOntology/$pab.xml"
	AnnotationXml $FichierAnnotation "GO" $FichierGOAnno

	# Annotation meilleure definition Vero
	AnnotationXml $FichierAnnotation "DE" [MeilleuresDefinitions2_0 $groupeQuery]
    }


}

proc AnnotationcDNAParBlastX {{BlastX2Protein yes} {Overwrite yes} {ForbiddenWord ""} {Liste ""}} {


    # remplissage des fiches infos a partir du BlastX 
    # creation recapitulatif defdublastx.out dans fiches
    # en tenant compte de BlastX2Protein.out si arg1 yes 
    if {$Liste == ""} { set Liste [ListeDesPABs] }
    if {$BlastX2Protein=="yes"} {
    	foreach Ligne [LesLignesDuFichier "[RepertoireDuGenome]/fiches/BlastX2Protein.out"] {
    		scan $Ligne "%s %s %s" ORF toto Homolog
    		if {$Homolog=="no"} {
    			set Homo($ORF) 0
    		} else {
    			set Homo($ORF) 1
    		}
    	}
    }
    foreach ORF $Liste {
	Espionne $ORF
	if {$Overwrite=="no" && [file exists "[RepertoireDuGenome]/infos/$ORF"]} {
	    continue
	} else {
	    set Sortie [BestDefinitionOfBlastX $ORF 0.001 $ForbiddenWord]
	    if {$Sortie=="" || ![set Homo($ORF)]} {
		InformeSansDemander $ORF "=DE_BlastX: unknown"
		InformeSansDemander $ORF "=OS_BlastX: unknown" 
		InformeSansDemander $ORF "=OC_BlastX: unknown"
		continue
	    }
	    if { ! [regexp {(.*)\(from} $Sortie Match Def]} { set Def "unknown" } 
	    set FinSortie [StringSuivant "(from " dans $Sortie]
	    regsub -all {\)[^\)]*$} $FinSortie "" FinSortie
	    scan $FinSortie "%s %s" Genre Espece
	    regsub {\.} $Espece "" Espece
	    set Espece [string tolower $Espece]
	    set Access [lindex [split $FinSortie " "] end-1]
	    InformeSansDemander $ORF "=DE_BlastX: $Def"
	    InformeSansDemander $ORF "=OS_BlastX: $Genre $Espece $Access"
	    if {$Espece=="sp"} {
		InformeSansDemander $ORF "=OC_BlastX: [OCduOS "$Genre"]"
	    } else {
		InformeSansDemander $ORF "=OC_BlastX: [OCduOS "$Genre $Espece"]"
	    }
	}
    }
    FicheDefDuBlastX


}

proc AnnoteBali {{fIn ""}} {

    global VariablesAuDepart

    LesDefauts
    LesDefauts TypeAli XML
    LesDefauts Mode "Batch"
    DefinitionPreferences
    InitialiseCouleurs
    set VariablesAuDepart [info globals]
	
    if {$fIn eq ""} {
	set BDir /home/moumou/Balibase3/bb3_release
	set Ldir [lsort [glob -types d [file join $BDir RV*]]]
    } else {
	set Ldir "."
    }

    foreach d $Ldir {
	puts "\n===================="
	puts "= [file tail $d]"
	puts "====================\n"
	
	if {$fIn eq ""} {
	    set Lf [glob [file join $d *.xml]]
	} else {
	    set Lf $fIn
	}
	foreach f $Lf {
	    if {[regexp {^BBS} [file tail $f]]} {
		continue
	    }

	    puts "\n => [file tail $f]"
	    set fout "[string range $f 0 end-4]_luc.xml"
	    set ford "[string range $f 0 end-4].ord"
	    if {[file exists $fout]} {
		if {[file exists $ford]} {
		    continue
		}
		file delete -force $fout
	    }

	    set FichierXML $f
	    LesDefauts FichierXML $FichierXML
	    puts "\n => [file tail $f]"
	    set fout "[string range $f 0 end-4]_luc.xml"
	    puts "outfile : $fout"
	    
	    LoadingAlignement
	    InitInfoSeqs
	    MetAJourGroupes
	    update

	    set YaSt 0 ; set YaBl 0
	    set ft ActiveSite
	    foreach p $::ListePDB {
		set nom [DonneIdDeAccessPDB $p]
		set chn [DonneChainDeAccessPDB $p]
		set Lsite [$nom GiveVar Site]
		if {$Lsite == {} } {
		    continue
		}

		unset -nocomplain St
		array set St $Lsite
		set Lft [list]
		set Lres [$nom _resnumber -chain $chn -polymer]
		foreach s [array names St] {
		    foreach {r c nm} [set St($s)] {
			if {$c ne $chn} {
			    continue
			}
			if {$r ni $Lres} {
			    continue
			}

			set x [DonnePosSG $p $r]
			if {$x == -1 || $x == ""} {
			    continue
			}
			lappend Lft [list "fstart" $x "fstop" $x "fcolor" magenta "fscore" 0.0 "fnote" $s "fcsys" local] 
		    }
		}

		if {$Lft != {} } {
		    set YaSt 1
		    set ::TabSF(${p},$ft) $Lft
		}
	    }
	    
	    # rajoute BLOCK comme feature
	    # Trash ...
	    set Ll [LesLignesDuFichier $f]
	    set i [lsearch -regexp $Ll {colsco-data}]
	    incr i
	    set l [lindex $Ll $i]
	    if {[set ib [string first "<" $l]] != -1} {
		set l [string range $l 0 $ib-1]
	    }
	    set l [string map [list "\n" ""] $l]
	    regsub -all { +} $l " " l
	    set Lv [split [string trim $l] " "]
	    set ft "BLOCK"
	    set i 0 ; set dg -1 ; set nbb 1
	    set Lft [list]
	    foreach v $Lv {
		if {$v} {
		    if {$dg == -1} {
			set dg $i
		    }
		    set fg $i
		} else {
		    if {$dg != -1} {
			lappend Lft [list "fstart" $dg "fstop" $fg "fcolor" orange "fscore" 0.0 "fnote" Block_$nbb "fcsys" local]
			incr nbb
			set dg -1
		    }
		}
		incr i
	    }
	    if {$dg != -1} {
		lappend Lft [list "fstart" $dg "fstop" [expr {$i-1}] "fcolor" orange "fscore" 0.0 "fnote" Block_$nbb "fcsys" local]
	    }

	    if {$Lft != {} } {
		set YaBl 1
		foreach n $::LNOrdali {
		    if {$n eq ""} {continue}
		    set ::TabSF(${n},$ft) $Lft
		}
	    }

	    if {$YaSt || $YaBl} {
		if {$YaSt} {
		    puts " --> Site"
		}
		if {$YaBl} {
		    puts " --> Blocks"
		}
		CreeLeMacsim $fout
	    }
	    
	    if {$::ListePDB != {} } {
		CreeObjBali $f
	    }
	    VueEditee 1

	    SauveLAlignement ORD JLeSauveAs

	    FermeFichier
	}
    }

    exit

}

proc AnnoteLeXMLDesARPs {{FichierXML ""} {FichierXMLOut ""}} {



    package require tdom

    Wup "Permet de modifier un fichier XML au format macsim pour y ajouter des informations"
    Wup "Ajout des positions des residus discriminants (1 couleur par groupe de residu)"
    Wup "Ajout des domaines (Family Insertion) avec 1 couleur par domaine."

    Wup "PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF POUR LA FAMILLE ARP2"
    Wup "ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES"

    if {$FichierXMLOut == ""} {return ""}

    set Famille ""
    set LesAccessAVirer ""

    #1 Recuperation de la famille d ARP (primordial)
    ################################################
    set Famille [file tail $FichierXML]
    set Famille_tmp ""
    regsub -nocase ".xml" $Famille "" Famille
    regexp -nocase  {_([a-z]{2,4}[0-9]{1,2}|actin|orphans)$} $Famille tmp Famille_tmp
    if {$Famille_tmp != ""} {set Famille $Famille_tmp}

    set AccessDeRef     "P02568"
    set AccessDeRef_OLD ""

    #2 Preparation Parsing XML avec TDOM
    #  Recuperation du noeud initial du XML
    set MacsimXml   [ContenuDuFichier $FichierXML]
    set IdXML       [dom parse $MacsimXml]
    set NoeudMacsim [$IdXML documentElement] 
    set  RId        [$NoeudMacsim selectNodes "alignment"]
    if {$RId == ""} {return ""}

    if {$Famille == "ARP2"} {
	#PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
	#ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
	set AccessDeRef_OLD $AccessDeRef
	set AccessDeRef     "ARP05"
    }
    
    #3   Traitement de la reference 
    #3-1 Recuperation du noeud initial de la Sequence de reference
    #<seq-name>P02568</seq-name>
    set qRef "//*\[string(seq-name)='$AccessDeRef'\]/*\[name(.)='seq-data'\]"
    set nRef [$RId  selectNodes "$qRef"]
    set sRef [$nRef selectNodes string(.)]

    #3-2 Calcul des positions absolue par rapport a l alignement
    ############################################################
    PositionAutreDe Absolue 1 $sRef
    #3-2-1 Pour les RESIDUS discriminants
    set  LesGroupesDeResidus   [InterrogeLesResidusDesARPs $Famille LesGroupes]
    foreach Groupe $LesGroupesDeResidus {
	set LesPositionsDesRes [InterrogeLesResidusDesARPs $Famille Groupe $Groupe Access $AccessDeRef LesPositions]
	#Espionne "Pos: $LesPositionsDesRes"
	foreach Pos $LesPositionsDesRes { 
	    #on veut la position absolue
	    set PosAbs [PositionAutreDe Relative $Pos $sRef]
	    set TabPosAbsDeRel(Absolue,$Groupe,$Pos) $PosAbs
	    #Espionne "$Pos -- $PosAbs"
	}
    }

    if {$AccessDeRef_OLD != ""} {
	#PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
	#ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
	set AccessDeRef $AccessDeRef_OLD

	#3   Traitement de la reference 
	#3-1 Recuperation du noeud initial de la Sequence de reference
	#<seq-name>P02568</seq-name>
 	set qRef ""
	set nRef ""
	set sRef ""

 	set qRef "//*\[string(seq-name)='$AccessDeRef'\]/*\[name(.)='seq-data'\]"
	set nRef [$RId  selectNodes "$qRef"]
	set sRef [$nRef selectNodes string(.)] 

	PositionAutreDe Absolue 1 $sRef
    }
    
    #3-2-2 Pour les DOMAINS discriminants
    set  LesPositionsDesDomaines [InterrogeLesDomainesDesARPs $Famille $AccessDeRef IN LesPositions]
    #1 On ne possede que la borne gauche de l insertion on ajoute donc + 1 pour avoir la fin
    #                 PosD        PosD+1
    #                  |           |
    # TMYPGIADRMQKEITALA...........PSTMKIKIIAPPERKYS
    # TMYPGLPSRLERELKQLYLERVLKGDVEKLSKFKIRIEDPPRRKHM
    #                  |           |
    #                 InD         InF
    set MaxLengthIN "8"
    set               LesDFPositionsDesDomaines ""
    foreach Position $LesPositionsDesDomaines {
	#On test si le domaine est specifique (conserve) pour toutes les proteines de la famille
	set  SpeOuPas [InterrogeLesDomainesDesARPs $Famille $AccessDeRef $Position Remarque]
	if {$SpeOuPas == "" || [regexp -nocase "not specific" $SpeOuPas]} {continue}
	set  Taille   [InterrogeLesDomainesDesARPs $Famille $AccessDeRef $Position Taille]
	if {$Taille   == "" || $Taille < $MaxLengthIN}                    {continue}
	
	lappend LesDFPositionsDesDomaines $Position
	lappend LesDFPositionsDesDomaines [expr {$Position + 1}]
    }
    foreach {PosD PosF} $LesDFPositionsDesDomaines { 
	#on veut la position absolue 
	#set AccessDeRef "P02568"
	#Attention probleme quand on a une insertion en N-terminal (on prend comme valeur absolue 1)
	#Attention on triche
	if {$PosD == "1" && $AccessDeRef == "P02568"} {
	    set PosDAbs "1"
	    set PosFAbs [PositionAutreDe Relative [expr {$PosF -1}] $sRef]
	} else {
	    set PosDAbs [PositionAutreDe Relative $PosD $sRef]
	    set PosFAbs [PositionAutreDe Relative $PosF $sRef]
	}
	set TabPosAbsDeRel(Absolue,Domain,$PosD) $PosDAbs
	set TabPosAbsDeRel(Absolue,Domain,$PosF) $PosFAbs
	#Espionne "$Pos -- $PosAbs"
    }

    #4 Recuperation de l ensemble des Noms de sequence et des sequences elle memes
    #  On va ensuite parcourir en parallel les 2 listes
    set qAcc "//seq-name"
    set nAcc [$RId  selectNodes "$qAcc"]
    foreach Node $nAcc {
	set Acc [$Node selectNodes string(.)]
	lappend LesAcc $Acc
    }
    set qAcc "//seq-data"
    set nAcc [$RId  selectNodes "$qAcc"]
    foreach Node $nAcc {
	set sAcc [$Node selectNodes string(.)]
	lappend LesSeqAcc $sAcc
    }

    #4 Boucle sur les 2 listes en parallele
    #######################################
    foreach Acc $LesAcc Seq $LesSeqAcc {
	#<fitem>
	#<ftype>R</ftype>
	#<fstart>1</fstart><fstop>1</fstop>
	#<fcolor>5</fcolor>
	#<fscore>0.00</fscore>
	#<fnote>R</fnote>
	#</fitem>
	set LesFItems ""
	#Le noeud de la sequence pour ajouter a l arbre
	set qRef "//*\[string(seq-name)='$Acc'\]/descendant::*\[name()='seq-info'\]"
	set nRef     [$RId  selectNodes "$qRef"]
	set VNodeRef [$nRef selectNodes "name(.)"]

	#Stockage des Access des ARPs a ne pas retenir (ex: ARP02)
	if {[regexp -nocase {^arp[0-9]{1,2}} $Acc]} {
	    lappend LesAccessAVirer $Acc
	}
	
	#5 Traitement des donnees sur les residus
	#########################################
	set LesFItems ""
	set i 0
	lappend LesFItems "<ftable>"

	if {$Famille == "ARP2"} {
	    #PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
	    #ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
	    set AccessDeRef_OLD $AccessDeRef
	    set AccessDeRef     "ARP05"
	}
    
	foreach Groupe $LesGroupesDeResidus {
	    set LesPositionsDesRes [InterrogeLesResidusDesARPs $Famille Groupe $Groupe Access $AccessDeRef LesPositions]
	    #Espionne "Pos: $LesPositionsDesRes"
	    incr i
	    #On remet les couleurs a 0
	    if {$i>15} {set i 1}
	    set Color $i

	    foreach Pos $LesPositionsDesRes {
		if {$Pos     == ""} {Espionne "Pos vide"} 
		if {$Color   == ""} {Espionne "Color vide"} 
		if {$Famille == ""} {Espionne "Famille vide"} 
 
		#Recuperation de la valeur du Residu
		set Residu [InterrogeLesResidusDesARPs $Famille $AccessDeRef $Pos Res]

		#Recuperation des positions absolues
		set PosAbs [set TabPosAbsDeRel(Absolue,$Groupe,$Pos)]
		set PosRel [PositionAutreDe Absolue $PosAbs $Seq]
		set PosOk  "$PosAbs"
		#Espionne "$Acc -- $PosAbs - $PosRel -- $Residu"
		
		set    Item ""
		append Item "<fitem>"
		append Item "<ftype>Specific</ftype>"
		append Item "<fstart>$PosOk</fstart>"
		append Item "<fstop>$PosOk</fstop>"
		append Item "<fcolor>$Color</fcolor>"
		append Item "<fscore></fscore>"
		#append Item "<fnote>\"Residue $Residu\"</fnote>"
		append Item "<fnote>AbsolutePosition Residue $Residu in $PosRel</fnote>"
		append Item "</fitem>"
		
		lappend LesFItems "$Item"
	    }
	}

	#6 Traitement des donnees sur les domaines
	##########################################
	if {$AccessDeRef_OLD != ""} {
	    #PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
	    #ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
	    set AccessDeRef $AccessDeRef_OLD
	}
	set i 0
	foreach {PosD PosF} $LesDFPositionsDesDomaines {
	    incr i
	    #On remet les couleurs a 0
	    if {$i>15} {set i 1}
	    set Color $i

	    if {$PosD    == "" || $PosF == ""} {Espionne "Pos vide"} 
	    if {$Color   == ""}                {Espionne "Color vide"} 
	    if {$Famille == ""}                {Espionne "Famille vide"} 

	    #Recuperation des positions absolues pour les relatives
	    set PosAbsD [set TabPosAbsDeRel(Absolue,Domain,$PosD)]
	    set PosRelD [PositionAutreDe Absolue $PosAbsD $Seq]
	    #Pour les problemes de insertions en N-terminal
	    if {$PosRelD== "0"} {set PosRelD "1"} 
	    set PosDOk  "$PosAbsD"

	    set PosAbsF [set TabPosAbsDeRel(Absolue,Domain,$PosF)]
	    set PosRelF [PositionAutreDe Absolue $PosAbsF $Seq]
	    set PosFOk  "$PosAbsF"
	    #Espionne "$Acc -- $PosAbsD + $PosRelD | $PosAbsF + $PosRelF" 
	    
	    set    Item ""
	    append Item "<fitem>"
	    append Item "<ftype>Specific</ftype>"
	    append Item "<fstart>$PosDOk</fstart>"
	    append Item "<fstop>$PosFOk</fstop>"
	    append Item "<fcolor>$Color</fcolor>"
	    append Item "<fscore></fscore>"
	    append Item "<fnote>AbsolutePosition Domain $PosRelD-$PosRelF</fnote>"
	    append Item "</fitem>"
	    
	    lappend LesFItems "$Item"
	}
	lappend LesFItems "</ftable>"
	$nRef appendXML [join $LesFItems "\n"] 
    }

    #7   On se debarasse des sequences qui sont genantes
    #7-1 Les access P02568_*
    set AccessDeRef "P02568"
    set qRef "/macsim/alignment/sequence\[contains(.,'${AccessDeRef}_')\]"
    set nRef [$RId selectNodes "$qRef"]
    foreach Node $nRef {
	set sRef [$Node delete]
    }
    
    #7-2 Les access genants des ARP (ex: ARP02)
    foreach Acc $LesAccessAVirer {
	set qRef "/macsim/alignment/sequence\[contains(.,'${Acc}')\]"
	set nRef [$RId selectNodes "$qRef"]
	foreach Node $nRef {
	    set sRef [$Node delete]
	}
    }

    #8 Sauvegarde du fichier XML
    ############################
    if {[file exists $FichierXMLOut]} {
	file delete -force $FichierXMLOut
    }
    #Attention le fichier XML doit contenir pour etre utilise (clustalw) les 2 entetes suivants
    #<?xml version="1.0"?>
    #<!DOCTYPE macsim SYSTEM "http://www-bio3d-igbmc.u-strasbg.fr/macsim.dtd">
    #Le dernier est obtenue par l option doctypeDeclaration de asXML
    set EnteteXML "<?xml version=\"1.0\" ?>" 
    set    f [open $FichierXMLOut w]
    puts  $f $EnteteXML
    puts  $f [$IdXML asXML -doctypeDeclaration 1 -indent 2]
    close $f

    return "$FichierXMLOut"


}

proc AnnoteLeXMLDesARPs_article {{FichierXML ""} {FichierXMLOut ""}} {



    package require tdom

    Wup "Pour faire le fichier html de l alignement pour l article"
    Wup "Permet de modifier un fichier XML au format macsim pour y ajouter des informations"
    Wup "Ajout des positions des residus discriminants (1 couleur par groupe de residu)"
    Wup "Ajout des domaines (Family Insertion) avec 1 couleur par domaine."

    Wup "PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF POUR LA FAMILLE ARP2"
    Wup "ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES"

    if {$FichierXMLOut == ""} {return ""}

    set Famille ""
    set LesAccessAVirer ""

    #1 Preparation Parsing XML avec TDOM
    #  Recuperation du noeud initial du XML
    set MacsimXml   [ContenuDuFichier $FichierXML]
    set IdXML       [dom parse $MacsimXml]
    set NoeudMacsim [$IdXML documentElement] 
    set  RId        [$NoeudMacsim selectNodes "alignment"]
    if {$RId == ""} {return ""}

    #2 Recuperation de l ensemble des Noms de sequence et des sequences elle memes
    #  On va ensuite parcourir en parallel les 2 listes
    set qAcc "//seq-name"
    set nAcc [$RId  selectNodes "$qAcc"]
    foreach Node $nAcc {
	set Acc [$Node selectNodes string(.)]
	lappend LesAcc $Acc
    }
    set qAcc "//seq-data"
    set nAcc [$RId  selectNodes "$qAcc"]
    foreach Node $nAcc {
	set sAcc [$Node selectNodes string(.)]
	lappend LesSeqAcc $sAcc
    }
    
    #3 Boucle sur les 2 listes en parallele
    #######################################
    foreach Acc $LesAcc Seq $LesSeqAcc {
	set LesDFPositionsDesDomaines ""

	#3-1 Recuperation de la famille d ARP (primordial)
	##################################################
	if {[regexp -nocase {separator}          $Acc]} {
	    #Espionne "$Acc"
	    lappend LesAccessAVirer $Acc
	}
	if {[regexp -nocase {reference\-\-\-\-_} $Acc]} {
	    #Espionne "$Acc"
	    lappend LesAccessAVirer $Acc
	}
	if {[regexp -nocase {1yag_a_2}           $Acc]} {
	    #Espionne "$Acc"
	    lappend LesAccessAVirer $Acc
	}
	if {[regexp -nocase {\-\-\-\-Nt_Kato2001\-\-\-\-}  $Acc]} {
	    #Espionne "$Acc"
	    lappend LesAccessAVirer $Acc
	}
	if {[regexp -nocase {\-\-\-\-Dimerization\-\-\-\-} $Acc]} {
	    #Espionne "$Acc"
	    lappend LesAccessAVirer $Acc
	}
	if {[regexp -nocase {\-\-\-\-NES\-\-\-\-}          $Acc]} {
	    #Espionne "$Acc"
	    lappend LesAccessAVirer $Acc
	}

	if {[regexp {\-\-\-\-} $Acc]} {continue}
	set     Categorie [InterrogeLesInfosDesARPs [string toupper $Acc] Categorie]
	if {   $Categorie == ""} {
	    set Categorie "Unknown"
	    continue
	} else {
	    regsub -all {\-\-\-\-} $Categorie "" Categorie
	    regsub           "Les" $Categorie "" Categorie
	}
	set Famille $Categorie
	
	#Espionne ">> $Acc -- $Famille"

	if {! [info exists TabPosAbsDeRel($Famille)]} {
	    #Espionne "On fait la famille $Famille"
	    #4 Recuperation des positions absolues des differents features (domaines et residus)
	    ####################################################################################
	    set AccessDeRef     "P02568"
	    set AccessDeRef_OLD ""
	    if {$Famille == "ARP2"} {
		#PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
		#ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
		set AccessDeRef_OLD $AccessDeRef
		set AccessDeRef     "ARP05"
	    }

	    #4   Traitement de la reference 
	    #4-1 Recuperation du noeud initial de la Sequence de reference
	    #<seq-name>P02568</seq-name>
	    set qRef "//*\[string(seq-name)='$AccessDeRef'\]/*\[name(.)='seq-data'\]"
	    set nRef [$RId  selectNodes "$qRef"]
	    set sRef [$nRef selectNodes string(.)]
	    
	    #4-2 Calcul des positions absolue par rapport a l alignement
	    ############################################################
	    PositionAutreDe Absolue 1 $sRef
	    #4-2-1 Pour les RESIDUS discriminants
	    set  LesGroupesDeResidus   [InterrogeLesResidusDesARPs $Famille LesGroupes]
	    foreach Groupe $LesGroupesDeResidus {
		set LesPositionsDesRes [InterrogeLesResidusDesARPs $Famille Groupe $Groupe Access $AccessDeRef LesPositions]
		#Espionne "Pos: $LesPositionsDesRes"
		foreach Pos $LesPositionsDesRes { 
		    #on veut la position absolue
		    set PosAbs [PositionAutreDe Relative $Pos $sRef]
		    set TabPosAbsDeRel($Famille,Absolue,$Groupe,$Pos) $PosAbs
		    #Espionne "$Pos -- $PosAbs"
		}
	    }
	    set TabPosAbsDeRel($Famille,LesGroupesDeResidus) $LesGroupesDeResidus

	    if {$AccessDeRef_OLD != ""} {
		#PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
		#ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
		set AccessDeRef $AccessDeRef_OLD
		
		#3   Traitement de la reference 
		#3-1 Recuperation du noeud initial de la Sequence de reference
		#<seq-name>P02568</seq-name>
		set qRef ""
		set nRef ""
		set sRef ""
		
		set qRef "//*\[string(seq-name)='$AccessDeRef'\]/*\[name(.)='seq-data'\]"
		set nRef [$RId  selectNodes "$qRef"]
		set sRef [$nRef selectNodes string(.)] 
		
		PositionAutreDe Absolue 1 $sRef
	    }
	    
	    #4-2-2 Pour les DOMAINS discriminants
	    set  LesPositionsDesDomaines [InterrogeLesDomainesDesARPs $Famille $AccessDeRef IN LesPositions]
	    #1 On ne possede que la borne gauche de l insertion on ajoute donc + 1 pour avoir la fin
	    #                 PosD        PosD+1
	    #                  |           |
	    # TMYPGIADRMQKEITALA...........PSTMKIKIIAPPERKYS
	    # TMYPGLPSRLERELKQLYLERVLKGDVEKLSKFKIRIEDPPRRKHM
	    #                  |           |
	    #                 InD         InF
	    set MaxLengthIN "8"
	    set               LesDFPositionsDesDomaines ""
	    foreach Position $LesPositionsDesDomaines {
		#On test si le domaine est specifique (conserve) pour toutes les proteines de la famille
		set  SpeOuPas [InterrogeLesDomainesDesARPs $Famille $AccessDeRef $Position Remarque]
		if {$SpeOuPas == "" || [regexp -nocase "not specific" $SpeOuPas]} {continue}
		set  Taille   [InterrogeLesDomainesDesARPs $Famille $AccessDeRef $Position Taille]
		if {$Taille   == "" || $Taille < $MaxLengthIN}                    {continue}
		
		lappend LesDFPositionsDesDomaines $Position
		lappend LesDFPositionsDesDomaines [expr {$Position + 1}]
	    }

	    set TabPosAbsDeRel($Famille,LesDFPositionsDesDomaines) $LesDFPositionsDesDomaines

	    foreach {PosD PosF} $LesDFPositionsDesDomaines { 
		#on veut la position absolue 
		#set AccessDeRef "P02568"
		#Attention probleme quand on a une insertion en N-terminal (on prend comme valeur absolue 1)
		#Attention on triche
		if {$PosD == "1" && $AccessDeRef == "P02568"} {
		    set PosDAbs "1"
		    set PosFAbs [PositionAutreDe Relative [expr {$PosF -1}] $sRef]
		} else {
		    set PosDAbs [PositionAutreDe Relative $PosD $sRef]
		    set PosFAbs [PositionAutreDe Relative $PosF $sRef]
		}
		set TabPosAbsDeRel($Famille,Absolue,Domain,$PosD) $PosDAbs
		set TabPosAbsDeRel($Famille,Absolue,Domain,$PosF) $PosFAbs
		#Espionne "$Pos -- $PosAbs"
	    }
	    
	    #Ok la famille est faite
	    set TabPosAbsDeRel($Famille) "1"
	} else {
	    #On recupere les groupes de residus et les Debut/Fin des domaines a checker
	    set LesGroupesDeResidus       [set TabPosAbsDeRel($Famille,LesGroupesDeResidus)] 
	    set LesDFPositionsDesDomaines [set TabPosAbsDeRel($Famille,LesDFPositionsDesDomaines)]
	}
	
	#<fitem>
	#<ftype>R</ftype>
	#<fstart>1</fstart><fstop>1</fstop>
	#<fcolor>5</fcolor>
	#<fscore>0.00</fscore>
	#<fnote>R</fnote>
	#</fitem>
	set LesFItems ""
	#Le noeud de la sequence pour ajouter a l arbre
	set qRef "//*\[string(seq-name)='$Acc'\]/descendant::*\[name()='seq-info'\]"
	set nRef     [$RId selectNodes "$qRef"]
	set VNodeRef [$nRef selectNodes "name(.)"]

	#Stockage des Access des ARPs a ne pas retenir (ex: ARP02)
	if {[regexp -nocase {^arp[0-9]{1,2}} $Acc]} {
	    lappend LesAccessAVirer $Acc
	}
	
	#5 Traitement des donnees sur les residus
	#########################################
	set LesFItems ""
	set i 0
	lappend LesFItems "<ftable>"

	if {$Famille == "ARP2"} {
	    #PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
	    #ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
	    set AccessDeRef_OLD $AccessDeRef
	    set AccessDeRef     "ARP05"
	}
    
	foreach Groupe $LesGroupesDeResidus {
	    set LesPositionsDesRes [InterrogeLesResidusDesARPs $Famille Groupe $Groupe Access $AccessDeRef LesPositions]
	    #Espionne "Pos: $LesPositionsDesRes"
	    incr i
	    #On remet les couleurs a 0
	    if {$i>15} {set i 1}
	    set Color $i

	    foreach Pos $LesPositionsDesRes {
		if {$Pos     == ""} {Espionne "Pos vide"} 
		if {$Color   == ""} {Espionne "Color vide"} 
		if {$Famille == ""} {Espionne "Famille vide"} 
 
		#Recuperation de la valeur du Residu
		set Residu [InterrogeLesResidusDesARPs $Famille $AccessDeRef $Pos Res]

		#Recuperation des positions absolues
		set PosAbs [set TabPosAbsDeRel($Famille,Absolue,$Groupe,$Pos)]
		set PosRel [PositionAutreDe Absolue $PosAbs $Seq]
		set PosOk  "$PosAbs"
		#Espionne "$Acc -- $PosAbs - $PosRel -- $Residu"
		
		set    Item ""
		append Item "<fitem>"
		append Item "<ftype>Specific</ftype>"
		append Item "<fstart>$PosOk</fstart>"
		append Item "<fstop>$PosOk</fstop>"
		append Item "<fcolor>$Color</fcolor>"
		append Item "<fscore></fscore>"
		#append Item "<fnote>\"Residue $Residu\"</fnote>"
		append Item "<fnote>AbsolutePosition Residue $Residu in $PosRel</fnote>"
		append Item "</fitem>"
		
		lappend LesFItems "$Item"
	    }
	}

	#6 Traitement des donnees sur les domaines
	##########################################
	if {$AccessDeRef_OLD != ""} {
	    #PROBLEME DE POSITIONS PAR RAPPORT A L ACTINE DE REF
	    #ATTENTION ON REVIENT A LA NORMALE PAR APRES CAR C PAS BON POUR LES DOMAINES
	    set AccessDeRef $AccessDeRef_OLD
	}
	set i 0
	foreach {PosD PosF} $LesDFPositionsDesDomaines {
	    incr i
	    #On remet les couleurs a 0
	    if {$i>15} {set i 1}
	    set Color $i

	    if {$PosD    == "" || $PosF == ""} {Espionne "Pos vide"} 
	    if {$Color   == ""}                {Espionne "Color vide"} 
	    if {$Famille == ""}                {Espionne "Famille vide"} 

	    #Recuperation des positions absolues pour les relatives
	    set PosAbsD [set TabPosAbsDeRel($Famille,Absolue,Domain,$PosD)]
	    set PosRelD [PositionAutreDe Absolue $PosAbsD $Seq]
	    #Pour les problemes de insertions en N-terminal
	    if {$PosRelD== "0"} {set PosRelD "1"} 
	    set PosDOk  "$PosAbsD"

	    set PosAbsF [set TabPosAbsDeRel($Famille,Absolue,Domain,$PosF)]
	    set PosRelF [PositionAutreDe Absolue $PosAbsF $Seq]
	    set PosFOk  "$PosAbsF"
	    #Espionne "$Acc -- $PosAbsD + $PosRelD | $PosAbsF + $PosRelF" 
	    
	    set    Item ""
	    append Item "<fitem>"
	    append Item "<ftype>Specific</ftype>"
	    append Item "<fstart>$PosDOk</fstart>"
	    append Item "<fstop>$PosFOk</fstop>"
	    append Item "<fcolor>$Color</fcolor>"
	    append Item "<fscore></fscore>"
	    append Item "<fnote>AbsolutePosition Domain $PosRelD-$PosRelF</fnote>"
	    append Item "</fitem>"
	    
	    lappend LesFItems "$Item"
	}
	lappend LesFItems "</ftable>"
	$nRef appendXML [join $LesFItems "\n"] 
    }

    #7   On se debarasse des sequences qui sont genantes
    #7-1 Les access P02568_*
    set AccessDeRef "P02568"
    set qRef "/macsim/alignment/sequence\[contains(.,'${AccessDeRef}_')\]"
    set nRef [$RId selectNodes "$qRef"]
    foreach Node $nRef {
	set sRef [$Node delete]
    }
    
    #7-2 Les access genants des ARP (ex: ARP02)
    foreach Acc $LesAccessAVirer {
	set qRef "/macsim/alignment/sequence\[contains(.,'${Acc}')\]"
	set nRef [$RId selectNodes "$qRef"]
	foreach Node $nRef {
	    set sRef [$Node delete]
	}
    }

    #8 Sauvegarde du fichier XML
    ############################
    if {[file exists $FichierXMLOut]} {
	file delete -force $FichierXMLOut
    }
    #Attention le fichier XML doit contenir pour etre utilise (clustalw) les 2 entetes suivants
    #<?xml version="1.0"?>
    #<!DOCTYPE macsim SYSTEM "http://www-bio3d-igbmc.u-strasbg.fr/macsim.dtd">
    #Le dernier est obtenue par l option doctypeDeclaration de asXML
    set EnteteXML "<?xml version=\"1.0\" ?>" 
    set    f [open $FichierXMLOut w]
    puts  $f $EnteteXML
    puts  $f [$IdXML asXML -doctypeDeclaration 1 -indent 2]
    close $f

    return "$FichierXMLOut"


}

proc AnnoteNonAnnotes {} {

    global LNOrdali TDesDescriptifs TDesOrganismes TDesTaxId TDuLineage TDesPhylum

    set L2gi [list]
    foreach n $LNOrdali {
	if {$n eq ""} {continue}

	if {[EstUnRefseq $n]} {
	    lappend L2gi $n
	}
	if {[set TDesOrganismes($n)] eq ""} {
	    lappend L2gi $n
	}
    }
    set L2gi [lsort -unique $L2gi]
    puts "\nL2gi $L2gi"
    set Lgi [Convert2GI protein $L2gi]
    puts "Lgi $Lgi"

    # retrieve basic information
    array set T [eSummaryREST protein $Lgi]
    set Ltn [list] ; set Lti [list]
    foreach gi $Lgi n $L2gi {
	# GI not found
	if {$gi eq $n} {continue}

	if {[info exists T($gi,Title)]} {
	    set TDesDescriptifs($n) [set T($gi,Title)]
	}
	if {[info exists T($gi,TaxId)]} {
	    set tid [set T($gi,TaxId)]
	    set TDesTaxId($n) $tid
	    lappend Ltn $n
	    lappend Lti $tid
	}
    }

    if {$Ltn != {} } {
	array set X [eFetchREST taxonomy $Lti]
	parray X
	foreach n $Ltn id $Lti {
	    if {[info exists X($id,Lineage)]} {
		set lin [split [set X($id,Lineage)] ;]
		set TDuLineage($n) $lin
		set TDesPhylum($n) [lindex $lin 1]
		set TDesOrganismes($n) [set X($id,ScientificName)]
	    }
	}
    }

    VueEditee 1
    SauveLAlignement XML JLeSauveAs

    puts ""
    foreach n $::LNOrdali {
	if {$n eq ""} {
	    puts ";;"
	    continue
	}
	
	set o [set TDesOrganismes($n)]
	set p [set TDuLineage($n)]
	puts "$n;$o;$p"
    }
    
    exit

}

proc AnnotePfam {} {

    global LNOrdali LSOrdali Rpfm
    
    foreach n $LNOrdali s $LSOrdali {
	if {$n eq ""} {
	    continue
	}
	
	set s [string map {"." ""} $s]
	trace add variable Rpfm($n) write TraitePfamScanResult
	set Rpfm($n,id) [after idle "LaunchPfamScan $n $s"]
    }

    puts "Rpfm"
    foreach k [array names ::Rpfm] {
	puts "$k $::Rpfm($k)"
    }

    return

}

proc AnnoteXml {Qui Quoi AccessDeRef FichierXml FichierResultat} {




    #Espionne "Dans le AnnoteXml: $AccessDeRef"	
    #Espionne "->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->FichierXml: $FichierXml"
    
    package require tdom

    set EnteteXML "<?xml version=\"1.0\" ?>" 

    Wup "Permet de modifier un fichier XML au format macsim pour y ajouter des informations"


    #2 Preparation Parsing XML avec TDOM
    #  Recuperation du noeud initial du XML

    set MacsimXml   [ContenuDuFichier $FichierXml]
    set IdXML       [dom parse $MacsimXml]
    set NoeudMacsim [$IdXML documentElement] 
    set  RId        [$NoeudMacsim selectNodes "alignment"]
    if {$RId == ""} {
	    	$RId delete
		$NoeudMacsim delete
		$IdXML delete
		return ""
    }

    while 1 {
		set qRef "//*\[string(seq-name)='$AccessDeRef'\]/descendant::*\[name()='ftable'\]"
		set nRef     [$RId  selectNodes "$qRef"]
		if {$nRef!=""} { break }	
		set qRef "//*\[string(seq-name)='$AccessDeRef'\]/descendant::*\[name()='seq-info'\]"
		set nRef     [$RId  selectNodes "$qRef"]
		if {$nRef==""} {
	    		$RId delete
			$NoeudMacsim delete
			$IdXML delete		
			return ""
		}	
		$nRef appendXML "<ftable></ftable>"
   }
    
    set LesIndicesDesSegments [Interroge$Qui $FichierResultat $Quoi]
    foreach I $LesIndicesDesSegments {
	
	set DebFin [Interroge$Qui $FichierResultat $Quoi $I]
	set Deb ""
	set Fin ""
	regsub {\-} $DebFin " " DebFin
	scan $DebFin "%d %d" Deb Fin
	
	if {$Deb==""} { 
		$RId delete
		$NoeudMacsim delete
		$IdXML delete
		return "" 
	}
	
	switch ${Qui}_$Quoi {
	    "GlobPlot_Disorder" { 
		set Color 4
		#Espionne "GlobPlot color 1"
	    }
	    "GlobPlot_GlobDoms" {
                set Color 5
                #Espionne "GlobPlot color 1"
            }
	    "DisEMBL_LOOPS" { 
		set Color 11 
		#Espionne "DisEMBL color 2"
	    }
            "DisEMBL_HOTLOOPS" {
                set Color 21
                #Espionne "DisEMBL color 2"
            }
            "DisEMBL_REM465" {
                set Color 19
                #Espionne "DisEMBL color 2"
            }
	    "FoldIndex_pds" { 
		set Color 6
		#Espionne "FoldIndex color 3"
	    }
	    "Ronn_DR" { 
		set Color 13 
		#Espionne "Ronn color 4"
	    }
	    default { set Color 1 }
	}
	
	#Espionne "Color: $Color"
	#set Color 25
	
	set FType "KOANNO"
	if {[regexp "${Qui}$Quoi$" $AccessDeRef]} {
	    set FType "AllPredictions"
	}
	
	set    Item ""
	append Item "<fitem>"
	append Item "<ftype>$FType</ftype>"
	append Item "<fstart>$Deb</fstart>"
	append Item "<fstop>$Fin</fstop>"
	append Item "<fcolor>$Color</fcolor>"
	append Item "<fscore>0</fscore>"
	#$Qui $Quoi
	append Item "<fnote>${Qui}_$Quoi</fnote>"
	append Item "</fitem>"
	
	$nRef appendXML $Item
    }
    
	set Status [SauveTDom $IdXML $EnteteXML $FichierXml]
	$RId delete
	$NoeudMacsim delete
	$IdXML delete
	
	return $Status


}

proc AnnoteXmlParTousPourUnAccess {Access FichierXml LesResultats} {


    foreach FichierResultat $LesResultats {
	if { [FileAbsent $FichierResultat]} { continue }
	set Queue [file tail $FichierResultat]
	regsub -nocase {Resultat\.html$} $Queue "" AP
	set P [StringApres "${Access}_" dans $AP]
	set P [BonneOrthographePour $P]
	set  BonAnnoteXml [QuelAnnoteXmlPour $P]
	if {$BonAnnoteXml==""} { continue }
	set Status [$BonAnnoteXml ${Access}_$P $FichierXml $FichierResultat]
    }
    return $FichierXml


}

proc AnnoteXmlPourDisEMBL {Access FichierXml FichierResultat} {


	set LesTypes [list "LOOPS" "HOTLOOPS" "REM465"]
	if {$Access=="LesTypes"} { return $LesTypes }
	set EtType ""
	foreach Type $LesTypes {
		if {[regexp "_DisEMBL$" $Access]} { set EtType "$Type" }
		AnnoteXml "DisEMBL" $Type ${Access}$EtType $FichierXml $FichierResultat
	}
	#global InfoDisEMBL; if {[info exists InfoDisEMBL]} { 
	#Espionne "Unset InfoDisEMBL"
	#array unset InfoDisEMBL 
	#}
	#ressayer cela mais avec une ,*
	DechargeDisEMBL $FichierResultat


}

proc AnnoteXmlPourDisEMBLX {Access FichierXml FichierResultat} {


    set LesTypes [list "LOOPS" "HOTLOOPS" "REM465"]
    if {$Access=="LesTypes"} { return $LesTypes }
    set EtType ""
    foreach Type $LesTypes {
	if {[regexp "_DisEMBL$" $Access]} { set EtType "$Type" }
	#AnnoteXml "DisEMBL" $Type ${Access}$EtType $FichierXml $FichierResultat
	InterrogeDisEMBL $FichierResultat $Type
    }


}

proc AnnoteXmlPourFoldIndex {Access FichierXml FichierResultat} {


    set LesTypes [list "pds"]
    if {$Access=="LesTypes"} { return $LesTypes }
    set EtType ""
    foreach Type $LesTypes {
	if {[regexp "_FoldIndex$" $Access]} { set EtType "$Type" }
	AnnoteXml "FoldIndex" $Type ${Access}$EtType $FichierXml $FichierResultat
    }
    #global InfoFoldIndex; if {[info exists InfoFoldIndex]} { 
    		#Espionne "Unset InfoFoldIndex"
    	#	array unset InfoFoldIndex 
	#}
	DechargeFoldIndex $FichierResultat


}

proc AnnoteXmlPourFoldIndexX {Access FichierXml FichierResultat} {


    set LesTypes [list "pds"]
    if {$Access=="LesTypes"} { return $LesTypes }
    set EtType ""
    foreach Type $LesTypes {
	if {[regexp "_FoldIndex$" $Access]} { set EtType "$Type" }
	InterrogeFoldIndex $FichierResultat $Type
    }
    #DechargeFoldIndex $FichierResultat


}

proc AnnoteXmlPourGlobPlot {Access FichierXml FichierResultat} {


	set LesTypes [list "Disorder" "GlobDoms"]
	if {$Access=="LesTypes"} { return $LesTypes }
	set EtType ""
	foreach Type $LesTypes {
		if {[regexp "_GlobPlot$" $Access]} { set EtType "$Type" }
		AnnoteXml "GlobPlot" $Type ${Access}$EtType $FichierXml $FichierResultat
	}
	#global InfoGlobPlot; if {[info exists InfoGlobPlot]} { 
		#Espionne "Unset InfoGlobPlot"
	#	array unset InfoGlobPlot 
	#}
	DechargeGlobPlot $FichierResultat



}

proc AnnoteXmlPourGlobPlotX {Access FichierXml FichierResultat} {


    set LesTypes [list "Disorder" "GlobDoms"]
    if {$Access=="LesTypes"} { return $LesTypes }
    set EtType ""
    foreach Type $LesTypes {
	if {[regexp "_GlobPlot$" $Access]} { set EtType "$Type" }
	InterrogeGlobPlot $FichierResultat $Type
    }
    #DechargeGlobPlot $FichierResultat


}

proc AnnoteXmlPourLesAccess {LesAccess RepParent FichierXml} {


	set varGlo [info globals]

	set Status ""
	foreach Access $LesAccess {
		set Rep "$RepParent/$Access"
		if { [FileAbsent $Rep]} { continue }
		set Status [AnnoteXmlPourUnAccess $Access $Rep $FichierXml]
	}

	Espionne "dans AnnoteXMLPourLesAccess"
	foreach v1 [info globals] {
	    if {$v1 in $varGlo} {continue}
	    puts $v1
	}

    return $Status
    #verifie les variable global


}

proc AnnoteXmlPourRonn {Access FichierXml FichierResultat} {


    set LesTypes [list "DR"]
    if {$Access=="LesTypes"} { return $LesTypes }
    set EtType ""
    foreach Type $LesTypes {
	if {[regexp "_Ronn$" $Access]} { set EtType "$Type" }	
	AnnoteXml "Ronn" $Type ${Access}$EtType $FichierXml $FichierResultat
    }
    #global InfoRonn; if {[info exists InfoRonn]} { 
		#Espionne "Unset InfoRonn"
    	#	array unset InfoRonn
    #}
	DechargeRonn $FichierResultat


}

proc AnnoteXmlPourRonnX {Access FichierXml FichierResultat} {


    set LesTypes [list "DR"]
    if {$Access=="LesTypes"} { return $LesTypes }
    set EtType ""
    foreach Type $LesTypes {
	if {[regexp "_Ronn$" $Access]} { set EtType "$Type" }	
	InterrogeRonn $FichierResultat $Type
    }
    #DechargeRonn $FichierResultat


}

proc AnnoteXmlPourUnAccess {Access Rep FichierXml} {


    #set LIGlobals [info globals]

	set Status ""
	foreach FichierResultat [glob -nocomplain "$Rep/{$Access}_*"] {
		regsub -nocase {Resultat\.html$} $FichierResultat "" AP
		set P [StringApres "${Access}_" dans $AP]
		set  BonAnnoteXml [QuelAnnoteXmlPour $P]
		if {$BonAnnoteXml==""} { continue }
		set Status [$BonAnnoteXml $Access $FichierXml $FichierResultat]
	}
	#Espionne "Avant la boucle de globals INfo"
	#foreach v [info globals] {
	 #   if {$v in $LIGlobals} {continue}
	  #  puts "variable tjours presente: $v"
	#}
	
	return $Status


}

proc AnyBal {f} {

    global ListePDB LConsSA
    global LNOrdali LSOrdali Sequences PABCourant OrdTmpDir FichierMSF Defauts SDG NomSeqSel
    global NId NCo NTt NConsDansId NConsDansCo NConsDansTt TableScore LNorMD
    global VariablesAuDepart TNResConsNSA TNResConsSA LongueurTotale LongTot NAli LongTot
    global NBench
    global TResSeeAsId TResSeeAsCo TResSeeAsTt TResId TResCo TResTt

    # Construction du set de residu conserves
    set Lcons [list]
    set Lden [list]
    unset -nocomplain Tden 
    foreach p $ListePDB {
	unset -nocomplain St
	set nom [DonneIdDeAccessPDB $p]
	set chn [DonneChainDeAccessPDB $p]
	set Lsite [$nom GiveVar Site]
	array set St $Lsite
	foreach s [array names St] {
	    foreach {r c nm} [set St($s)] {
		if {$c eq $chn} {
		    set x [DonnePosSG $p $r]
		    if {$x != -1 && $x != ""} {
			incr x
			if {$x ni $Lcons} {
			    lappend Lcons $x
			}
			lappend Tden($x) $p $r $nm
			lappend Lden $x
		    }
		}
	    }
	}
    }
    set l [DenombreLaListe $Lden]
    set LConsSA [list]
    foreach e $l {
	puts "e= $e"
	lassign $e k v
	if {$v != 1} {lappend LConsSA $k}
    }
    if {$LConsSA == {} } {return 0}
    if {$Lcons == {} } {return 0}
    #set LConsSA $Lcons
    puts "Liste cons :"
    puts "[join [DenombreLaListe $Lden] \n]"
    puts "Tableau :"
    parray Tden

    set Ntypes [list Norm Thompson Ranganatan VolPol Liu Liu2 RPCA Entrop1 Entrop2]
    set grp ""
    foreach tnom $Ntypes {
	unset -nocomplain TableScore
	foreach t $tnom {
	    ScoreDe$t $grp
	}
	
	set rep1 [VerificationAvantCalculs]
	if {! $rep1} {
	    puts "Une des methode foireuse !!"
	    puts "skip alignement\n"
	    set BontousTypes 0
	    
	    break
	}
	    
	set BonTousTypes 1
	set rep2 [LanceLesCalculs $tnom $grp 0 bali]
	if {$rep2} {
	    set tmp_TResSeeAsId($tnom) $NConsDansId
	    set tmp_TResSeeAsCo($tnom) $NConsDansCo
	    set tmp_TResSeeAsTt($tnom) $NConsDansTt
	    set tmp_TResId($tnom) $NId
	    set tmp_TResCo($tnom) $NCo
	    set tmp_TResTt($tnom) $NTt
	} else {
	    puts "fail for method $tnom"
	    set BonTousTypes 0
	    break
	}
    }

    if {$BonTousTypes} {
	incr LongTot $LongueurTotale
	incr NAli
	incr NBench [llength $LConsSA]

	foreach tnom $Ntypes {
	    incr TResSeeAsId($tnom) [set tmp_TResSeeAsId($tnom)]
	    incr TResSeeAsCo($tnom) [set tmp_TResSeeAsCo($tnom)]
	    incr TResSeeAsTt($tnom) [set tmp_TResSeeAsTt($tnom)]
	    incr TResId($tnom) [set tmp_TResId($tnom)]
	    incr TResCo($tnom) [set tmp_TResCo($tnom)]
	    incr TResTt($tnom) [set tmp_TResTt($tnom)]
	}
    }
    
    return

}

proc Appartient {LIndividu LesIndividus} {


    set AppartientIlALaPop 0
    foreach UnIndividu $LesIndividus {
	if {$LIndividu == $UnIndividu} {set AppartientIlALaPop 1;break}
    }
    return $AppartientIlALaPop


}

proc Appel {frm index} {


global OrdHlpDir

set tags [$frm tag names $index]
set i [lsearch -glob $tags help-*]

if {$i < 0} {
return
}

set cursor [$frm cget -cursor]
$frm configure -cursor watch
update
set helpfile [string range [lindex $tags $i] 5 end]
uplevel [list source [file join $OrdHlpDir $helpfile.tcl]]
update
$frm configure -cursor $cursor

$frm tag add visited "$index linestart +1 chars" "$index lineend -1 chars"

}

proc AppendAuFichier {Fichier Ligne} {


    set Canal [open $Fichier "a"]
    puts $Canal $Ligne
    close $Canal
    return $Fichier


}

proc AppendAuFichier_CACHEparRR {Fichier Ligne} {


    set Canal [open $Fichier "a"]
    puts $Canal $Ligne
    close $Canal
    return $Fichier


}

proc AppendEtRetourneDistance {Arbre Distance} {


    global ListeDistanceDeChaqueFeuille
    global MiniOuSomme

    JeMeSignale

    if { $Distance == "Inconnue" } {
	if {[EstUneFeuille $Arbre]} {
	    if {[CetteFeuilleEstLaCible $Arbre]} {
		if {$MiniOuSomme == "Mini"} {
		    set Distance 9999999.
		} else {
		    set Distance 0.0
		}
		return $Distance
	    } else {
		return "Inconnue"
	    }
	} else {
	    Dedouble $Arbre G x D y
	    set RetourG [AppendEtRetourneDistance $G "Inconnue"]
	    if { $RetourG != "Inconnue"} {
		if {$MiniOuSomme == "Mini"} {
		    set Dis [Mini $RetourG [Mini $x $y]]
		} else {
		    set Dis [expr $RetourG+$x+$y]
		}
		AppendEtRetourneDistance $D $Dis
		if {$MiniOuSomme == "Mini"} {
		    set Dis [Mini $RetourG $x]
		} else {
		    set Dis [expr $RetourG+$x]
		}
		return $Dis
	    }
	    set RetourD [AppendEtRetourneDistance $D "Inconnue"]
	    if { $RetourD != "Inconnue"} {
		if {$MiniOuSomme == "Mini"} {
		    set Dis [Mini $RetourD [Mini $x $y]]
		} else {
		    set Dis [expr $RetourD+$y+$x]
		}
		AppendEtRetourneDistance $G $Dis
		if {$MiniOuSomme == "Mini"} {
		    set Dis [Mini $RetourD $y]
		} else {
		    set Dis [expr $RetourD+$y]
		}
		return $Dis
	    }
	    return "Inconnue"
	}  
    } else {
	if {[EstUneFeuille $Arbre]} {
	    lappend ListeDistanceDeChaqueFeuille "[NomDeLaFeuille $Arbre] $Distance"
	    return $Distance
	} else {
	    Dedouble $Arbre G x D y
	    if {$MiniOuSomme == "Mini"} {
		set Dis [Mini $Distance $x]
	    } else {
		set Dis [expr $Distance+$x]
	    }
	    AppendEtRetourneDistance $G $Dis
	    if {$MiniOuSomme == "Mini"} {
		set Dis [Mini $Distance $y]
	    } else {
		set Dis [expr $Distance+$y]
	    }
	    AppendEtRetourneDistance $D $Dis
	}
    }


}

proc AppendFOF {{Rep ""} {NewRep ""} {FichierFOF ""}} {



    Wup "Takes all TFA files from Rep and creates a normalised version with the PS as access"

    if {$FichierFOF==""} {
	set Projet [file tail [RepertoireDuGenome]]
	set FichierFOF "[RepertoireDuGenome]/$Projet.fof"
    }
    if {$Rep==""} { set Rep [ChoixDuRepertoire "[RepertoireDuGenome]/"] }
    if { ! [regexp "^/" $Rep]} { set Rep "[RepertoireDuGenome]/$Rep" }
    if {$NewRep==""} {
	set NewRep "[file dirname $Rep]/NewTFA"
    }
    if { ! [regexp "^/" $NewRep]} { set NewRep "[RepertoireDuGenome]/$NewRep" }
    if {[FileAbsent $NewRep]} { file mkdir $NewRep }
    Espionne $Rep
    foreach Fichier [lsort [glob -nocomplain "$Rep/*"]] {
	Espionne $Fichier
	set Queue [file tail $Fichier]
	regsub {^[A-Z]+_[^_]+_} $Queue "" PS
	set Entete [EnteteDuFichierTFA $Fichier]
	set Seq    [QueLaSequenceDuFichierTFA $Fichier]
	regsub {>[^ ]+ } $Entete "" DE
	set TFA [SequenceFormatTFA $Seq "$PS $DE" "nucbrut"]
	Espionne $TFA
	set FicTFA "$NewRep/$Queue"
	Sauve $TFA dans $FicTFA
	lappend LeNouveauFOF "$PS $FicTFA"
    }   
    if {[file exists $FichierFOF]} { Garde $FichierFOF }
    AppendAuFichier $FichierFOF [join $LeNouveauFOF "\n"]
    return $FichierFOF


}

proc AppendLaProc {SousProcedure Procedure} {


    global LesSousProcedures

    if {[info procs $SousProcedure]=={}} { return }

    lappend LesSousProcedures($Procedure) $SousProcedure


}

proc AppendPierre {} {


    global CanalPierre NomDuFichierPierre
    if { [info exists CanalPierre] } {
        ClosPierre
    }
    if { ! [info exists NomDuFichierPierre] } {
        set NomDuFichierPierre "pierre"
    }
    set CanalPierre [open $NomDuFichierPierre a]
    return $CanalPierre


}

proc AppendUneDemarcation {K {NomDuFichier ""}} {



    if {$NomDuFichier == ""} {
	set NomDuFichier [ButineArborescence]
    }
    if {$NomDuFichier == ""} { return "" }

    set Y 100
    set Etiquette "NoValue"
    foreach Ligne [LesLignesDuFichier $NomDuFichier] {
	if {[regexp {"#Don't remove this line it marks the end."} $Ligne]} { break }
	if {[regexp {^\#} $Ligne]} { continue }
	if { ! [regexp -nocase {[a-z0-9]} $Ligne]} { continue }
	set n [scan $Ligne "%s %s %s" Nom Y Etiq]
	DemarcationEnPosition $K "v" $Nom $Y $Etiq
    }
    return $NomDuFichier


}

proc AppletCmd {w arglist} {

    # puts "AppletCmd: w=$w arglist=$arglist"
    label $w -text "The Applet $w" -bd 2 -relief raised

}

proc AppliqueBackColor {} {

    global TmpDef Defauts

    set Defauts(BackAppli) [set TmpDef(BackAppli)]
    ChangeTkOptions

    foreach e [wm stackorder .] {
	wm withdraw $e
	update idletasks
	wm deiconify $e
    }

    return

    LesDefauts BackAppliOri [set Defauts(BackAppli)]
    LesDefauts BackAppli    [set TmpDef(BackAppli)]
    update
    foreach e [winfo children .] {
	if {[regexp "BWIDGET" [string toupper $e]]} {continue}
	MesCouleurs $e
    }
    update idletasks

    return

}

proc AppliqueCouleurs {type w} {

    global NomNomSeq ListePDB

    if {[QuelMode] eq "seqlab"} {
	global LNSeqlab LSSeqlab

	set LesSeqs $LSSeqlab
	set LesNoms $LNSeqlab
    } else {
	global LNOrdali LSOrdali

	set LesSeqs $LSOrdali
	set LesNoms $LNOrdali
    }

    # configuration tags
    set Lgaa [list STAC DE ILMV FYW P RK Q G HN SPC]
    #    set Lfreg [list "S|T|A|C" "D|E" "I|L|M|V" "F|Y|W" "p" "R|K" "Q" "G" "H|N" "\\\."]
    set Lfreg [list "S|T|A|C" "D|E" "I|L|M|V" "F|Y|W" "P" "R|K" "Q" "G" "H|N"]

    set y 0
    foreach s $LesSeqs n $LesNoms {
	incr y
	if {$n eq ""} {continue}
	if {$n in $ListePDB} {continue}
	foreach a $Lgaa freg $Lfreg {
	    set lt {}
	    set lv [regexp -all -inline -indices -- $freg $s]
	    foreach e $lv {
		lassign $e d f 
		lappend lt $y.$d $y.[expr {$f+1}]
	    }
	    if {$lt != {}} {$w tag add Tag$a {*}$lt}
	}
    }

    update idletasks

    return

}

proc AppliqueFeature {ft} {

    global NomTextSeq NomNomSeq ListeTypesDeFeatures LNOrdali LesNomsDesSeqsOld TabSF ScoreMeth Defauts

    if {! [ModeI]} {return}

    $NomTextSeq configure -state normal

    if {$ft eq "Clear" || $ft eq "None"} {
	set Ltags [$NomTextSeq tag names]
	set ToDelete [lsearch -all -inline -regexp $Ltags {^(FX\_|FDisp\_)}]

	if {$ToDelete != {}} {
	    $NomTextSeq tag delete {*}$ToDelete
	}

	ResetDesBoutons
	$NomTextSeq configure -state disabled
	MetAJourDessinOverview -1 "" "None" 1
	if {[lsearch -regexp $ListeTypesDeFeatures "Cons-T"] != -1} {
	    EnleveLesPoints
	}

	return
    }
    
    set ftnsp [string map [list " " ""] $ft]

    set Lt [$NomTextSeq tag names]
    set LaFeat [lsearch -regexp -all -inline $Lt "_${ftnsp}_"]
    if {$LaFeat ne ""} {
	set isPresent 1
    } else {
	set isPresent 0
    }

    if {$isPresent} {
	$NomTextSeq tag delete {*}$LaFeat
	$NomTextSeq configure -state disabled
	MetAJourDessinOverview -1 "" $ft 0

	if {[QuelMode] eq "feature" && [regexp "Cons-" $ft]} {
	    setTooltip [BtnDeLaFeature $ft] ""
	}
	if {[regexp "Cons-T" $ft]} {
	    EnleveLesPoints
	}

	return
    }

    if {[regexp {^Cons\-|^Score\-} $ft]} {
	if {[set ScoreMeth($ft,Edit)]} {
	    $NomTextSeq tag configure "EdtFnd_${ftnsp}_1" -background "#ffdddd"
	    $NomTextSeq tag add "EdtFnd_${ftnsp}_1" 1.0 end
	    if {[QuelMode] eq "feature"} {
		setTooltip [BtnDeLaFeature $ft] "Beware ! Conservation is not valid anymore\nas the alignment has changed !"
	    }
	}
    
	if {[regexp "Cons-T" $ft]} {
	    #AfficheLesPoints
	}
	DessineLesScores $ft
    }

    set LFeatUse {}
    array set ToTag {}
    foreach key [array names TabSF "*,$ft"] {
	lassign [split $key ,] nom tmp
	set i [expr {[lsearch $LNOrdali $nom] + 1}]
	
	foreach f [set TabSF($nom,$ft)] {
	    set fcol "black"
	    DecortiqueUneFeature $f dg fg col sco note

	    if {$Defauts(RemovePropagated) && [string range $note 0 4] eq "PROP_"} {
		continue
	    }

	    incr fg
	    set LeTag "FX_${ftnsp}_$col"
	    lappend ToTag($LeTag) $i.$dg $i.$fg

	    if {$LeTag ni $LFeatUse} {
		if {$col eq "black" || $col eq "DimGray"} {
		    set fcol "white"
		}
		$NomTextSeq tag configure $LeTag -foreground $fcol -background $col
		lappend LFeatUse $LeTag
	    }

	    if {$note ne ""} {
		set lanote [string map {" " "_"} $note]
		$NomTextSeq tag configure "FDisp_$lanote" -foreground black
		lappend ToTag(FDisp_${ftnsp}_$lanote) $i.$dg $i.$fg
	    }
	}
    }
    foreach e [array names ToTag] {
	set Lt [list]
	$NomTextSeq tag add $e {*}$ToTag($e)
    }
    $NomTextSeq configure -state disabled
    
    MetAJourDessinOverview -1 "" $ft 1

    return

}

proc AppliqueRotation {V R T} {

    set Vt [V_MV $R * $V]
    set NewV [V_VV $Vt + $T]

    return $NewV

}

proc AppliqueSuperposition {} {

    global ListePDB StrucAVoir db

    foreach nmch [lrange $StrucAVoir 1 end] {
	set elt [DonneIdDeAccessPDB $nmch]
	set chn [DonneChainDeAccessPDB $nmch]

	array set TM [$elt GiveVar Rot]
	array set TT [$elt GiveVar Trans]
	set M [M_T TM]
	set T [V_T TT]
	lassign $M aM bM cM
	lassign $T t1 t2 t3

	set pdb $elt
	$db eval {begin transaction}
	set Lr [$db eval {select a.x,a.y,a.z,a.pk_atoms from atoms as a, chains as c, pdb as p where  p.name=$pdb and  c.pk_pdb=p.pk_pdb and  c.name=$chn and  a.pk_chains=c.pk_chains}]
	
	foreach {x y z ix} $Lr {
	    set nx [VMT $x $y $z $aM $t1]
	    set ny [VMT $x $y $z $bM $t2]
	    set nz [VMT $x $y $z $cM $t3]
	    $db eval {update atoms set x=$nx, y=$ny, z=$nz where pk_atoms=$ix}
	}

	$db eval {commit}

	$elt _Dimensions
	$elt ResetDrawing
    }

    return

}

proc AppliqueWidth {AId val} {


    set inc [expr {[set ::Abr($AId,Increment)] + $val}]
    if {$inc < 5} {return}
    set ::Abr($AId,Increment) $inc
    
    OnReDessineArbre $AId
    
    return

}

proc AppliqueZoom {AId val x y} {

    global Abr

    if {$val eq "zplus"} {set val 0.1} {set val -0.1}
    set Abr($AId,ScaleR) [expr {$val+[set Abr($AId,ScaleR)]}]
    if {[set Abr($AId,ScaleR)] < 0.1} {set Abr($AId,ScaleR) 0.1}

    OnReDessineArbre $AId

    return

}

proc ArClade {{Qui ""} {Quoi ""}} {


    global ArClade
    if {[info exists ArClade($Qui,$Quoi)]} { return $ArClade($Qui,$Quoi) }
    if {[info exists ArClade("EstCharge")]} {
	if {[info exists ArClade($Qui,OX)]} {
	    set OX $ArClade($Qui,OX)
	    if {[info exists ArClade($OX,$Quoi)]} { return $ArClade($OX,$Quoi) }
	}
	return ""
    }
    set ArClade("EstCharge") 1
    
    set LesClades [LesLignesDuFichier "/genomics/link/OI/fiches/PhylAr_ListOf_PhyOS.txt"]
    set LesClades [OrderedClades $LesClades]

    foreach Name $LesClades {
	set OX [Tax $Name TaxId]
	if {$OX==""} {
	    #FaireLire "$Name has no TaxId. I'll use Archaea instead"
	    set Name "Archaea"
	    set OX [Tax $Name TaxId]
	}
	set ArClade($Name,Name) $Name
	set ArClade($OX,OX)     $OX
	set ArClade($Name,OX)   $OX
	set ArClade($OX,Name)   $Name
	lappend ArClade(ListOf,OX)   $OX
	lappend ArClade(ListOf,Name) $Name
    }
    
    set ArClade(ListOf,AllOX)   $ArClade(ListOf,OX)
    set ArClade(ListOf,AllName) $ArClade(ListOf,Name)
    foreach Name [list Bacteria Eukaryota Viruses] {
	set OX   [Tax $Name TaxId]
	if {$Name=="root"} { set Name "Other" }
	lappend ArClade(ListOf,AllOX)   $OX
	lappend ArClade(ListOf,AllName) $Name
    }

    return [ArClade $Qui $Quoi] 


}

proc ArCladeOLD {{Qui ""} {Quoi ""}} {


    global ArClade
    if {[info exists ArClade($Qui,$Quoi)]} { return $ArClade($Qui,$Quoi) }
    if {[info exists ArClade("EstCharge")]} {
	if {[info exists ArClade($Qui,OX)]} {
	    set OX $ArClade($Qui,OX)
	    if {[info exists ArClade($OX,$Quoi)]} { return $ArClade($OX,$Quoi) }
	}
	return ""
    }
    set ArClade("EstCharge") 1
    
    set Fichier "/home/ripp/vrac/ArClade.txt"
    set ArClade(Filename,) $Fichier
    
    foreach Ligne [LesLignesDuFichier $Fichier] {
	set Name [string trim $Ligne " \t"]
	if {$Name==""} { continue }
	regsub -all " " $Name "_" Name
	set OX [Tax $Name TaxId]
	if {$OX==""} {
	    #FaireLire "$Name has no TaxId. I'll use Archaea instead"
	    set Name "Archaea"
	    set OX [Tax $Name TaxId]
	}
	set ArClade($Name,Name) $Name
	set ArClade($OX,OX)     $OX
	set ArClade($Name,OX)   $OX
	set ArClade($OX,Name)   $Name
	lappend ArClade(ListOf,OX)   $OX
	lappend ArClade(ListOf,Name) $Name
    }
    set ArClade(ListOf,OX)   [lsort -unique $ArClade(ListOf,OX)]
    set ArClade(ListOf,Name) [lsort -unique $ArClade(ListOf,Name)]
    foreach A $ArClade(ListOf,OX) {
	foreach B $ArClade(ListOf,OX) {
	    if {$A==$B} { continue }
	    if {[JeSuisTonAncetre $A $B]} { set ArClade($A,AncestorOf_$B) 1 }
	}
    }
    
    set ArClade(ListOf,OrderedOX) [lsort -command CompareArCladeAncestor $ArClade(ListOf,OX)]
    foreach OX $ArClade(ListOf,OrderedOX) {
	lappend ArClade(ListOf,OrderedName) $ArClade($OX,Name)
    }
    #parray ArClade 

    foreach D [list Bacteria Eukaryota Virus] {
	set N [Tax $D Name]
	if {$N=="root"} { set N "Other" }
	lappend ArClade(ListOf,OrderedOX)   $D
	lappend ArClade(ListOf,OrderedName) $N
    }

    return [ArClade $Qui $Quoi] 


}

proc ArCladeOf {{Qui ""} {Quoi ""}} {


    global ArCladeOf

    if {$Quoi=="Clade"} { set Quoi "Name" }

    if {[regexp -nocase "taxid" $Quoi]} { set Quoi "OX" }

    if {$Quoi=="" &&    [regexp {^[0-9]+$} $Qui]} { set Quoi "OX" }
    if {$Quoi=="" &&  ! [regexp {^[0-9]+$} $Qui]} { set Quoi "Name" }

    if {[info exists ArCladeOf($Qui,Quoi)]} { return $ArCladeOf($Qui,$Quoi) }
    set OX [Tax $Qui TaxId]
    set OS [Tax $Qui Name]
    
    foreach CX [ArClade ListOf OrderedOX] CS [ArClade ListOf OrderedName] {
	if {[JeSuisTonAncetre $CX $OX]} {
	    set ArCladeOf($OX,OX) $CX
	    set ArCladeOf($OS,OX) $CX
	    set ArCladeOf($OX,Name) $CS
	    set ArCladeOf($OS,Name) $CS
	    if {[info exists ArCladeOf($OX,$Quoi)]} { return $ArCladeOf($OX,$Quoi) }
	}
    }
    return ""


}

proc Arboot {} {


    global TokCourant
    if { ! [regexp {^\(} $TokCourant]} {
	set FeuilleDist [FeuilleDist]
	if {[regexp "NonValide" $FeuilleDist]} { return "ArbootNonValideCar$FeuilleDist" }
	return $FeuilleDist
    }
    Tok
    set Gauche [Arboot]
    if {[regexp "NonValide" $Gauche]} { return "ArbootNonValideCar$Gauche" }
    if { ! [regexp {\,} $TokCourant]} { return "ArbootNonValideCarSansVirgule" }
    Tok
    set Droite [Arboot]
    if {[regexp "NonValide" $Droite]} { return "ArbootNonValideCar$Droite" }
    if { ! [regexp {\)} $TokCourant]} { return "ArbootNonValideCarSansFermante" }
    Tok
    set ValeurDist [ValeurDist]
    if {[regexp "NonValide" $ValeurDist]} { return "ArbootNonValideCar$ValeurDist" }
    if {[regexp {^\[} $TokCourant]} {
	set ValeurBoot [ValeurBoot]
	if {[regexp "NonValide" $ValeurBoot]} { return "ArbootNonValideCar$ValeurBoot" }
    } else {
	set ValeurBoot 0
    }
    return [list $Gauche $Droite $ValeurDist $ValeurBoot]


}

proc ArbreAgent {iSeq} {

    global Larbres TAg T DoTour LNOrdali DoTour

    if {$DoTour} {
	return
    }

    set n [lindex $LNOrdali $iSeq]
    if {($iSeq + 1) == [llength $LNOrdali]} {
	set iSeq -1
	set DoTour 1
    }

    # cherche dans seq suivante
    incr iSeq
    set nf [lindex $LNOrdali $iSeq]

    if {$DoTour} {
	foreach agn $TAg($n) {
	    lappend Larbres [list $n $agn]
	}
	return $Larbres
    }

    foreach agn $TAg($n) {
	#set Lp [LiensAgent $n $agn $nf]
	set Lp [lsearch -all -exact -inline -index 0 $T($n,$agn) $nf]
	set Ltmp [list]
	foreach arbre [ArbreAgent $iSeq] {
	    foreach l $Lp {
		lassign $l n2 ag2 sc2
		lappend Ltmp [concat $arbre $n2 $ag2]
	    }
	}
	#lappend Larbres {*}$Ltmp
	set Larbres $Ltmp
    }

    #ArbreAgent $iSeq

    return $Larbres

}

proc ArbreBootstrapEnListe {TextePH} {


    regsub -all "\n" $TextePH "" t
    regsub -all {\:[0-9]\.[0-9]*} $t ":" t
    regsub -all {[\]\[]} $t "" t
    regsub -all {\(} $t {[list } t
    regsub -all ","  $t " " t
    regsub -all ":,"  $t ":" t
    regsub -all {:\)}  $t ":" t
    regsub -all ":"  $t " " t
    regsub -all {\)} $t {]} t
    regsub -all {;}  $t "" t
    exit
    eval set Arbre $t
    if {[llength $Arbre] == 4} {
	set Arbre [list  [list [lindex $Arbre 0] [lindex $Arbre 1] [lindex $Arbre 3]]  [lindex $Arbre 2]  [lindex $Arbre 3]]
    }
    return $Arbre 


}

proc ArbreBootstrapEnListeOld {TextePH} {


    regsub -all "\n" $TextePH "" t
    regsub -all {[0-9]\.[0-9]*} $t "" t
    regsub -all {[\]]} $t "" t
    regsub -all {[\[]} $t "" t
    regsub -all {\:\)} $t ":9999.\)" t
    regsub -all {\(} $t {[list } t
    regsub -all ","  $t " " t
    regsub -all ":"  $t " " t
    regsub -all {\)} $t {]} t
    regsub -all {;}  $t "" t
    eval set Arbre $t
    if {[llength $Arbre] == 6} {
	set Arbre [list [lrange $Arbre 0 3] 0.0 [lindex $Arbre 4] [lindex $Arbre 5]]
    }
    return $Arbre 


}

proc ArbreDesClasses {} {


    Degrave T
    NicePrintOfTree $T
    exit
    if {[]} {}


}

proc ArbreEnListe {TextePH} {


    regsub -all "\n" $TextePH "" t
    regsub -all {\(} $t {[list } t
    regsub -all ","  $t " " t
    regsub -all ":"  $t " " t
    regsub -all {\)} $t {]} t
    regsub -all {;}  $t "" t
    eval set Arbre $t
    if {[llength $Arbre] == 6} {
	set Arbre [list [lrange $Arbre 0 3] 0.0 [lindex $Arbre 4] [lindex $Arbre 5]]
    }
    return $Arbre 


}

proc ArcInit {} {

    global StrucAVoir gDemo

    LoadTkAndPackages

    rename EnvoieLesObjets Envoie_wait
    rename Cubes EnvoieLesObjets

    set StrucAVoir [list]
    Initialisation

    # Font to be used in the Tk listbox.
    set gDemo(listFont) {-family {Courier} -size 18 -weight bold}
    
    # Display mode.
    set gDemo(fullScreen) false
    
    # Window size.
    set gDemo(winWidth)  640
    set gDemo(winHeight) 480

    set ::ArcBall   [tcl3dNewArcBall 640 480]
    set ::Transform [tcl3dVector GLfloat 16]
    set ::ThisRot   [tcl3dVector GLfloat 16]
    set ::LastRot   [tcl3dVector GLfloat 16]
    set ::ThisQuat  [tcl3dVector GLfloat  4]
    update

    ArcStart
    
    .top.fr.toglwin postredisplay

    return

}

proc ArcLaListe {ListeNomCouleur R Type {MilieuOuAngle milieu} {RayonMinimum ""} {RayonMaximum ""}} {


    Wup "Creates the arcs associated to each element of the list"
    global ParametresDuBoard

    Wup "Pour les fleches a l'envers c'est code 'Reverse\NomOuAngle' "

    set PI 3.14159

    set DeltaAnglePourFlecheDeg 1.5
    set DeltaAnglePourFlecheRad [expr $DeltaAnglePourFlecheDeg*$PI/180.]

    set CentreX [set ParametresDuBoard($R,CentreX)]
    set CentreY [set ParametresDuBoard($R,CentreY)]
    set RayonMoyen     [set ParametresDuBoard($R,RayonMoyen)]
    set OffsetRayonMin [set ParametresDuBoard($R,OffsetRayonMin)]
    set OffsetRayonMax [set ParametresDuBoard($R,OffsetRayonMax)]
    set IemeCouche     [set ParametresDuBoard($R,IemeCouche)]
    
    set Rayon  $RayonMinimum
    set Gauche [expr $CentreX-$Rayon]
    set Haut   [expr $CentreY-$Rayon]
    set Droite [expr $CentreX+$Rayon]
    set Bas    [expr $CentreY+$Rayon]

    set InRayon  [expr $Rayon*(1-0.9*$DeltaAnglePourFlecheRad)]
    set OutRayon [expr $Rayon*(1+0.9*$DeltaAnglePourFlecheRad)]

    set n [llength $ListeNomCouleur]

    set CumulF 0
    set CumulR 0
    set OldCouleur "CACADOIE"
    foreach {NomOuAngle Couleur} [concat $ListeNomCouleur [list "NomBidon" "CouleurPourFin"]] {
	if {[regexp {^Reverse_} $NomOuAngle]} {
	    set Orientation "R"
	    incr CumulR
	} else {
	    set Orientation "F"
	    incr CumulF
	}
	regsub {^Reverse_} $NomOuAngle "" NomOuAngle
	set Etiquette " "
	if {$Couleur != $OldCouleur && $OldCouleur != "CACADOIE"} {
	    if {$OldCouleur=="VIDE"} { set NonVide 0 } else { set NonVide 1 }
	    set i_ [string first "_" $OldCouleur]
	    if {$i_ < 0} {
		set VraieCouleur $OldCouleur
	    } else {
		set Etiquette [string range $OldCouleur [incr i_ 1] end] 
		set VraieCouleur [string range $OldCouleur 0 [incr i_ -2]]
	    } 
	    if {$CumulF>=$CumulR} {
		set Orientation "F"
		set NewStart [expr $Start+$DeltaAnglePourFlecheRad]
		set Queue    $NewStart
		set Pointe   $Start
	    } else {
		set Orientation "R"
		set NewStart $Start
		set Pointe [expr $Start+$Extent]
		set Queue  [expr $Pointe-$DeltaAnglePourFlecheRad] 
	    }
	    set NewExtent [expr $Extent-$DeltaAnglePourFlecheRad]

	    set Repeche 0
	    if {$Etiquette=="B" && [expr abs($Extent) < 2*$PI*5000./[LongueurADN]]} {
		set Repeche 1
	    }
	    set Noye 0
	    if {$Etiquette=="D5" && [expr abs($Extent) < 2*$PI*30000./[LongueurADN]]} {
		set Noye 1
	    }
	    Espionne "$Etiquette [expr $Extent*[LongueurADN]/(2*$PI)] $Repeche $Noye"
	    if {$Repeche || (! $Noye && $NonVide && [expr abs($Extent) > 2*$PI*19000./[LongueurADN]])} {
		set IdArc [$R create arc $Gauche $Haut $Droite $Bas -width 7  -start [expr $NewStart*180/$PI] -extent [expr $NewExtent*180/$PI]  -style "arc" -outline $VraieCouleur -tags "Zone"]
		set InQueueX  [expr ($Gauche+$Droite)/2  +  $InRayon*cos($Queue)]
		set InQueueY  [expr ($Haut+$Bas)/2       -  $InRayon*sin($Queue)]
		set OutQueueX [expr ($Gauche+$Droite)/2  + $OutRayon*cos($Queue)]
		set OutQueueY [expr ($Haut+$Bas)/2       - $OutRayon*sin($Queue)]
		set PointeX   [expr ($Gauche+$Droite)/2  +    $Rayon*cos($Pointe)]
		set PointeY   [expr ($Haut+$Bas)/2       -    $Rayon*sin($Pointe)]
		if { 0 } {
		    $R create polygon  $PointeX $PointeY  $InQueueX $InQueueY  $OutQueueX $OutQueueY  $PointeX $PointeY  -fill $VraieCouleur -outline $VraieCouleur -tags "Fleche"
		} else {
		    FlecheSurArc $R $IdArc $Orientation 
		}
		set EtiqX [expr ($Gauche+$Droite)/2  + 1.00*$OutRayon*cos($Start+$Extent/2)]
		set EtiqY [expr ($Haut+$Bas)/2       - 1.00*$OutRayon*sin($Start+$Extent/2)]
		$R create text $EtiqX $EtiqY -text $Etiquette  -anchor c  -font {Courier 10}  -tags "Etiquette"
	    }
	    unset Start
	    set CumulF 0
	    set CumulR 0
	}
	if {$Couleur == "CouleurPourFin"} { break }
	if {$MilieuOuAngle == "angle"} {
	    set Angle $NomOuAngle
	} elseif {$MilieuOuAngle == "milieu"} {
	    set Angle [AngleDansRosace $R $Nom]
	}
	if { ! [info exist Start]} { set Start $Angle }
	set Extent [EntreMinEtMax [expr $Angle-$Start] [expr -$PI] $PI]
	set OldCouleur $Couleur
    }


}

proc ArcStart {} {

    CreateWindow
    ResetRotations
    
    PrintInfo [format "Running on %s with a %s (OpenGL %s, Tcl %s)"  $::tcl_platform(os) [glGetString GL_RENDERER]  [glGetString GL_VERSION] [info patchlevel]]
    
    return

}

proc ArchaeaGenomesDeClaudine {{GetWhat ""}} {


    OiDomain A

    foreach OS [OiCode ListOf OS] {
	scan $OS "%s %s" Ge Es
	set GeEs "$Ge$Es"
	set OX [OiCode $OS OX]
#Espionne "$OX $GeEs \t\t$OS"
	lappend LesOXde($GeEs) $OX
    }

    set LesGS {}
    set Rates 0
    set LesMemes {}
    set LesCommeSoeur {}
    set LesRates {}
    set LesClaudine {}
    set NbAvecSoeur 0
    foreach G [ClaudineArchaea ListOf G] {
	set GX [ClaudineArchaea $G OX]
	set GS [ClaudineArchaea $G "Organism_Name"]
	set OS [OiCode $GX OS]
	set Clade [ArCladeOf $GX Name]
	lappend LesClaudine [format "%s %9d %-50s %s %s %s" $G $GX $GS Clade = $Clade]
	if {$OS!=""} {
	    set Meme($GX) 1
	    lappend LesMemes [format "%-9s %9d %-50s %-80s %s" $G $GX $GS $OS Clade = $Clade]
	    continue
	}
	set LesParents [list $GX]
	set PX $GX
	while {$OS==""} {
	    set PX [Tax $PX Parent]
	    if {$PX=="" || $PX==1} { break } 
	    lappend LesParents $PX
	    set OS [OiCode $PX OS]
	    if {$OS!=""} {  Espionne "$LesParents $OS" }
	}
	set LesSoeurs {}
	set PX [Tax $GX Parent]
	if {$PX!="" && $PX!=1} {
	    foreach OXSoeur [Tax $PX Children] {
		set OS [OiCode $OXSoeur OS]
		if {$OS!=""} {
		    lappend LesSoeurs "$OS OX = $OXSoeur"
		    set YaSoeur($OXSoeur) 1
		}
	    }
	    if {$LesSoeurs!={}} {
		incr NbAvecSoeur
		lappend LesCommeSoeur ""
		lappend LesCommeSoeur "$G $GX $Clade"
		lappend LesCommeSoeur $GS
		foreach Soeur $LesSoeurs {
		    lappend LesCommeSoeur $Soeur
		}
	    }
	    if {$LesSoeurs!={}} { continue }
	}
	lappend LesRates [format "%9s %9d %-40s %s %s %s" $G $GX $GS Clade = $Clade]
    }

    foreach OX [OiCode ListOf OX] {
	if {[info exists Meme($OX)]} {
	    lappend LesMemeQueYannis $OX
	    continue
	}
	lappend LesNouveauxDeYannis "$OX [OiCode $OX OS]"
    }

    set LesNouveauxDeYannis [lsort -index 1 $LesNouveauxDeYannis]

#    return [AfficheListe $LesClaudine   "" "Ceux de Claudine"]

    Espionne "[llength $LesClaudine] de Claudine"
    Espionne "[llength $LesMemes] Memes"
    Espionne "$NbAvecSoeur AvecSoeur"
    Espionne "[llength $LesRates] Rates"
    
    Espionne "[llength [OiCode ListOf OX]] de Yannis"
    Espionne "[llength $LesNouveauxDeYannis] Nouveaux chez Yannis"
    set LesFenetres {}
    lappend LesFenetres [AfficheListe $LesClaudine   "" "Ceux de Claudine"]
    lappend LesFenetres [AfficheListe $LesMemes      "" "LesMemes"]
#    lappend LesFenetres [AfficheListe $LesCommeSoeur "" "LesSoeurs"]
    lappend LesFenetres [AfficheListe $LesRates      "" "LesRates"] 
    lappend LesFenetres [AfficheListe $LesNouveauxDeYannis  "" "LesNouveauxDeYannis"] 
    lappend LesFenetres [AfficheListe [OiCode ListOf Info] "" "Ceux de Yannis"]

    return $LesFenetres


}

proc ArchiveBatch {{batchName ""} {batchDate ""}} {


    # Connect to database
    #canalSqlAssemblyDb
    NSAssemblyDb::getCanal

    # Retrieve pk and names of contigs in batch
    set sql "SELECT c.pk_contig, s.name FROM assembly AS a, contig AS c, sequence AS s WHERE a.pk_assembly = c.pk_assembly AND c.consensus_pk_sequence = s.pk_sequence AND a.name = '$batchName' AND a.date = '$batchDate'"
    set pkContigs [SqlExec $sql GetList]
    if {[llength $pkContigs] < 1} {
	puts "Batch $batchName ($batchDate) does not exists"
	exit 1
    }

    # BEGIN THE TRANSACTION
    SqlExec "BEGIN"

    foreach {pkC nameC} $pkContigs {
	puts "Archiving $nameC"

	# Retrieve read names in contig pkC
	set readNames [SqlExec "SELECT name FROM sequence WHERE pk_contig = $pkC" GetList]
	if {[llength $readNames] < 1} {
	    puts "ERROR: no reads in $nameC"
	    exit 1
	}

	# Insert read names into history table
	foreach rN $readNames {
	    SqlExecWithStatus "INSERT INTO history(pk_contig, read_name) VALUES($pkC, '$rN')"
	}

	# Remove reads of table sequence
	SqlExecWithStatus "DELETE FROM sequence WHERE pk_contig = $pkC"

    }
    
    # Mark the batch as archived
    SqlExecWithStatus "UPDATE assembly SET archived = true WHERE name = '$batchName' AND date = '$batchDate'"
    
    # FINISH THE TRANSACTION
    SqlExec "COMMIT"

    # Disconnect
    CanalSqlDisconnect


}

proc AretesDuCube {a1 b1 c1 d1 a2 b2 c2 d2} {


    # Face haut
    glBegin GL_LINES
    glVertex3fv $a1
    glVertex3fv $b1
    glEnd

    glBegin GL_LINES
    glVertex3fv $b1
    glVertex3fv $c1
    glEnd

    glBegin GL_LINES
    glVertex3fv $c1
    glVertex3fv $d1
    glEnd

    glBegin GL_LINES
    glVertex3fv $d1
    glVertex3fv $a1
    glEnd

    # face bas
    glBegin GL_LINES
    glVertex3fv $a2
    glVertex3fv $b2
    glEnd

    glBegin GL_LINES
    glVertex3fv $b2
    glVertex3fv $c2
    glEnd

    glBegin GL_LINES
    glVertex3fv $c2
    glVertex3fv $d2
    glEnd

    glBegin GL_LINES
    glVertex3fv $d2
    glVertex3fv $a2
    glEnd

    # Poteaux
    glBegin GL_LINES
    glVertex3fv $a1
    glVertex3fv $a2
    glEnd

    glBegin GL_LINES
    glVertex3fv $b1
    glVertex3fv $b2
    glEnd

    glBegin GL_LINES
    glVertex3fv $c1
    glVertex3fv $c2
    glEnd

    glBegin GL_LINES
    glVertex3fv $d1
    glVertex3fv $d2
    glEnd

    return

}

proc ArkaeaLike {Orga} {


    if {[PyroLike $Orga] ||  [regexp "mjan|aful|mthe|aper|ssol|saci|mvan|hsal|hvol|hcut|hhal|damb|dmob|dthe|dsp" $Orga]} {
	return 1
    }
    return 0


}

proc ArrayFromSerial {Texte aT} {


    upvar $aT T
    return [ArrayFromSeriallist [SeriallistFromSerial $Texte] T]


}

proc ArrayFromSeriallist {Liste aT} {


    upvar $aT T
    foreach {K V} [lindex $Liste 1] {
	set T([ValueFromSeriallist $K]) [ValueFromSeriallist $V]
    }
    return $aT


}

proc ArrayRecap {PourCas} {


    set LongPourCas [llength $PourCas]
   Espionne "LongPourCas= $LongPourCas"
    set somme 0
    foreach elmt $PourCas {
	set somme [expr $somme+$elmt] 
	if {[info exists DejaVu($elmt)]} {
	    incr DejaVu($elmt)
	    continue
	}
	set DejaVu($elmt) 1
    }
   Espionne "somme= $somme"
    set MoyPourCas [expr $somme/$LongPourCas]
   Espionne "MoyPourCas= $MoyPourCas"
    set grand 0; set petit 100
    set Resultat [array get DejaVu]
    foreach Cle [array names DejaVu] {
	if {$Cle>$grand} {set grand $Cle}
	if {$Cle<$petit} {set petit $Cle}
    }
    return "$grand $petit\n$Resultat"


}

proc ArrayTree2PH {node} {

    set Lf $::Tx($node,Child)
    if {$Lf != {}} {
	append ::phTree "("
	foreach f $Lf {
	    ArrayTree2PH $f
	}
	set ::phTree [string trimright $::phTree ,]
	append ::phTree "):1,"
    } else {
	append ::phTree "n$node:1,"
    }

    if {$Lf != {}} {
	#append ::phTree "):1"
    }

    return $::phTree

}

proc ArraytypeEnAttente {} {


    set name "Ret13K"
    set type "spotted DNA/cDNA"
    set manufacturer "Cepko lab"
    set probesetcount "12243 mouse clones"
    set description "The Ret13K microarray includes 12,243 mouse clones including BMAP mouse retinal clones and 220 clones from the Incyte mouse unigene 1 collection. The cDNA inserts were amplified from replica plate cultures by PCR, purified and mechanically spotted onto polylysine-coated microscope slides using an OmniGrid robotic spotter (GeneMachines, San Carlo, CA)."
    set url "NA"
    set Ligne "$name;$type;$manufacturer;$probesetcount;$description;$url"
    lappend LesLignes $Ligne
    if {[ArraytypeWithPipeWork]} {
	CreateArray InitValues 1 "New" "0" $name $type $manufacturer $probesetcount $description $url
	set Serial [PhpSerialize InitValues "i"]
	Espionne $Serial
	lappend LesCreations [WebService "Gx" FromPipeWork "pipeworkname" "GXManageArraytype" "serialinitvalues" $Serial]
    }


}

proc ArraytypeInput {{LesFichiers ""}} {


    if { ! [WithWebService "Gx" "TestIfExists"]} { WithWebService "Gx" 1 }

    if {$LesFichiers==""              } { set LesFichiers [LesAffyAnnot] }
    if {$LesFichiers=="DansLeBonOrdre"} { set LesFichiers [LesAffyAnnotDansLeBonOrdre] }

    set LesCreations {}
    foreach File $LesFichiers {
	set Queue [file tail $File]
	set Chip [string range $Queue 0 [expr [string first "." $Queue] -1]]
	LConcat LesCreations [ChargeArraytype $Chip]
	foreach MultiChip [MesMultiChip $Chip] {
	    if {[info exists DejaVu($MultiChip)]} { continue }
	    set DejaVu($MultiChip) 1
	    LConcat LesCreations [ChargeArraytype $MultiChip]
	}
    }
    return $LesCreations


}

proc ArraytypeWithPipeWork {{Qui ""} {Valeur ""}} {


    global ArraytypeWithPipeWork

    if {$Qui==""} { set Qui "Gx" }

    if {$Valeur!=""} { set ArraytypeWithPipeWork($Qui) $Valeur}
    if {[info exists ArraytypeWithPipeWork($Qui)]} { return $ArraytypeWithPipeWork($Qui) }
    set ArraytypeWithPipeWork($Qui) 1
    return [ArraytypeWithPipeWork $Qui]


}

proc AsciiToInteger {A} {


    set I -1
    scan $A "%c" I
    return $I


}

proc AskAddSeqs {} {

    global TAddS LNDG

    set TAddS(File)      ""
    set TAddS(Align)     1
    set TAddS(CopySkip)  0
    set TAddS(Position)  "end"
    set TAddS(seqInsert) ""
    if {[llength $LNDG] > 1} {
	set TAddS(KeepClus) 1
    } else {
	set TAddS(KeepClus) 0
    }

    if {0} {
	set TAddS(File) "add_jaris.tfa"
	set TAddS(Position) "end"
	set TAddS(seqInsert) "Q5ZAV6"
	set TAddS(Align) 1
    }
    set res [array get TAddS]
    if {[ModeI]} {
	set res [AfficheAskAddSeq $res]
    }
    # if result is empty then leave AddSeq

    return $res

}

proc AskAnchors {args} {


    #unset
    #$FileAnchors IdDeRef
    #$FileAnchors LesId
    #$FileAnchors Id $Id NbLMS
    #$FileAnchors Id $Id LMS $n Pos
    #$FileAnchors Id $Id LMS $n Beg
    #$FileAnchors Id $Id LMS $n End
    #$FileAnchors Id $Id LMS $n Len

    global TabDesAnchorsDeBallast

    if {$args == ""} {return}
    set PremArg [lindex $args 0]
    if {[string equal -nocase $PremArg "unset"]} {
	if {[info exists TabDesAnchorsDeBallast ]} {unset TabDesAnchorsDeBallast}
	return
    }
    if {![file exists $PremArg]} {return}
    set Quoi [join $args ","]

    if {[info exists TabDesAnchorsDeBallast($Quoi)]} {return [set TabDesAnchorsDeBallast($Quoi)]}
    if {[info exists TabDesAnchorsDeBallast($PremArg,EstCharge)]} {return}
    
    set         TabDesAnchorsDeBallast($PremArg,EstCharge) 1
    LoadAnchors TabDesAnchorsDeBallast $PremArg

    if {[info exists TabDesAnchorsDeBallast($Quoi)]} {return [set TabDesAnchorsDeBallast($Quoi)]}
    return


}

proc AskBlast {args} {


    #$FileBlast Exists
    #unset 
    #unsetfile  $FileBlast
    #$FileBlast TypeDeBlast
    #$FileBlast Database
    #$FileBlast Query
    #$FileBlast Taille 

    #$FileBlast NbSubject

    #$FileBlast Subject $nSubject
    #$FileBlast BanqueId $BId Access
    #$FileBlast BanqueId $BId Definition
    #$FileBlast BanqueId $BId Taille
    #$FileBlast BanqueId $BId SubjectBrut

    #$FileBlast BanqueId $BId NbSegment
    #$FileBlast BanqueId $BId Segment $nSegment AlignBrut
    #$FileBlast BanqueId $BId Segment $nSegment Score
    #$FileBlast BanqueId $BId Segment $nSegment Expect
    #$FileBlast BanqueId $BId Segment $nSegment Identities
    #$FileBlast BanqueId $BId Segment $nSegment Positives
    #$FileBlast BanqueId $BId Segment $nSegment Gaps
    #$FileBlast BanqueId $BId Segment $nSegment Orientation
    #$FileBlast BanqueId $BId Segment $nSegment Align
    #$FileBlast BanqueId $BId Segment $nSegment AlignLineaire
    #$FileBlast BanqueId $BId Segment $nSegment AlignBrut
    #$FileBlast BanqueId $BId Segment $nSegment DQ
    #$FileBlast BanqueId $BId Segment $nSegment FQ
    #$FileBlast BanqueId $BId Segment $nSegment DS
    #$FileBlast BanqueId $BId Segment $nSegment FS

    global TableauContennantLesInformationsDuBlast

    if {$args == ""} {return}
    if {[string equal -nocase [lindex $args 0] "unset"]} {
	if {[info exists TableauContennantLesInformationsDuBlast]} {unset TableauContennantLesInformationsDuBlast}
	return
    }

    if {[string equal -nocase [lindex $args 0] "unsetfile"]} {
	set File [lindex $args 1]
	if {$File == "" || ![file exists $File] || ![info exists TableauContennantLesInformationsDuBlast]} {return}
	array unset TableauContennantLesInformationsDuBlast "$File*" 
	if {0} {
	    foreach Index [array name TableauContennantLesInformationsDuBlast] {
		if {![regexp "^$File" $Index]} {continue}
		unset TableauContennantLesInformationsDuBlast($Index)
	    }
	}
	return
    }

    set FileBlast [lindex $args 0]
    if {![file exists $FileBlast]} {return}

    set Quoi [join $args ","]

    if {[info exists TableauContennantLesInformationsDuBlast($Quoi)]} {return [set TableauContennantLesInformationsDuBlast($Quoi)]}
    if {[info exists TableauContennantLesInformationsDuBlast($FileBlast,Exists)]} {return}
    set              TableauContennantLesInformationsDuBlast($FileBlast,Exists) 1

    LoadBlast TableauContennantLesInformationsDuBlast $FileBlast
    if {[info exists TableauContennantLesInformationsDuBlast($Quoi)]} {return [set TableauContennantLesInformationsDuBlast($Quoi)]}
    return


}

proc AskBlastMoi {} {


    DecortiqueBlast $Fichier "SansSeuilExpect" "SansLimiteDeNombre" Query lBanqueId lAccess lDE lProfil lPN


}

proc AskClust_Gretta {args} {


    global TabClust_Gretta
    ####PROCEDURE HYPER SPECIFIQUE DE GRETTA####

    set QUOI [join $args ","]

    if {[info exists TabClust_Gretta($QUOI) ]} {return [set TabClust_Gretta($QUOI)]}
    if {[info exists TabClust_Gretta(Loaded)]} {return}
    set TabClust_Gretta(Loaded) 1

    set NbCluster 6 

    set FichierOCADE  "[RepertoireDuGenome]/fiches/Orf2Cluster2Access2Def2Expression"
    set FichierSel    "[RepertoireDuGenome]/Data/20040910_SelectionDesBoites.txt"

    set TabClust_Gretta(LesClusters) {}
    set TabClust_Gretta(LesAffy)     {}
    set TabClust_Gretta(LesNoms)     {}

    set F [open $FichierSel]
    set i 0
    while {[gets $F Ligne]>=0} {
	set Ligne [string trim $Ligne]
	if {$Ligne == ""} {continue}
	set Ligne   [split $Ligne "\t"]

	set Affy    [lindex $Ligne 0]
	set Cluster [lindex $Ligne 1]

	if {![info exists TabClust_Gretta(Cluster,$Cluster,LesAffy)]} {
	    set TabClust_Gretta(Cluster,$Cluster,LesAffy) {}
	    set TabClust_Gretta(Cluster,$Cluster,LesNoms) {}
	    lappend TabClust_Gretta(LesClusters) $Cluster
	}

	if {![info exists TabClust_Gretta(Affy,$Affy,LesClusters)]} {
	    set TabClust_Gretta(Affy,$Affy,LesClusters) {}
	    lappend TabClust_Gretta(LesAffy) $Affy
	}
	lappend TabClust_Gretta(Affy,$Affy,LesClusters) $Cluster

	incr i
	set TabAffy($Cluster,$Affy) 1
    }
    close $F

    foreach Nom            [InterrogeOrf2Cluster2Access2Def2Expression $FichierOCADE LesNoms] {
	set Affy           [InterrogeOrf2Cluster2Access2Def2Expression $FichierOCADE $Nom Access]
	set LesExpressions [InterrogeOrf2Cluster2Access2Def2Expression $FichierOCADE $Nom LesExpressions]

	for {set i 0} {$i < $NbCluster} {incr i} {
	    set Cluster [expr $i + 1]
	    set Expr [lindex $LesExpressions $i]
	    if {$Expr < 0} {continue}
	    if {![info exists TabAffy($Cluster,$Affy)]} {continue}

	    if {![info exists TabClust_Gretta(Nom,$Nom,LesClusters)]} {
		set     TabClust_Gretta(Nom,$Nom,LesClusters) {}
		lappend TabClust_Gretta(LesNoms)              $Nom
	    }

	    lappend TabClust_Gretta(Nom,$Nom,LesClusters)     $Cluster
	    lappend TabClust_Gretta(Cluster,$Cluster,LesNoms) $Nom
	}
    }

    if { [info exists TabClust_Gretta($QUOI) ]} {return [set TabClust_Gretta($QUOI)]}
    return


}

proc AskCorrespondances {args} {


    ### Interroge le fichier de correspondances ###
    global TableauCorrespondances

    #unset
    #FileCorrespondances NbGscopeBox 
    #FileCorrespondances LesClusters
    #FileCorrespondances GscopeBox $GscopeBox
    #...
    #a completer
    #

    set FirstArg [lindex $args 0]
    if {$FirstArg == "unset"} {
	if {[info exists TableauCorrespondances]} {unset TableauCorrespondances}
	return
    } 
    set Quoi [join $args ","]
    if {[info exists TableauCorrespondances($Quoi)]} { return [set TableauCorrespondances($Quoi)]}
    if {![file exists $FirstArg]} { return }
    if {[info exists TableauCorrespondances($FirstArg,EstCharge)]} { return }
    
    set TableauCorrespondences($FirstArg,EstCharge) 1
    LoadCorrespondances TableauCorrespondances $FirstArg

    if {[info exists TableauCorrespondances($Quoi)]} { return [set TableauCorrespondances($Quoi)]}
    return


}

proc AskDBTSS {args} {


    ### Interroge la banque DBTSS ###
    global TableauDBTSS
        
    #unset
    #LesId
    #$Id      Organism
    #$Id      SeqTFA
    #$IdCourt Organism
    #$IdCourt SeqTFA

    set FirstArg [lindex $args 0]

    if {$FirstArg == "unset"} {
	if {[info exists TableauDBTSS]} {unset TableauDBTSS}
	return
    }
    
    set Quoi [join $args ","]
    if {[info exists TableauDBTSS($Quoi)    ]} { return [set TableauDBTSS($Quoi)]}

    if {[info exists TableauDBTSS(EstCharge)]} { return }
    
    set TableauDBTSS(EstCharge) 1
    LoadDBTSS TableauDBTSS

    if {[info exists TableauDBTSS($Quoi)]} { return [set TableauDBTSS($Quoi)]}
    return


}

proc AskEPDIdOrga {args} {


    ### Interroge le fichier EPDIdOrga ###
    global TableauEPDIdOrga
        
    #unset
    #LesEPDIds
    #LesEPDOrgas
    #LesEPDOrganisms
    #LesEPDOrganismsLongs
    #EPDOrga      $EPDOrga      LesEPDIds
    #EPDId        $EPDId        EPDOrga
    #EPDId        $EPDId        EPDOrganism
    #EPDId        $EPDId        EPDOrganismLong

    set FirstArg [lindex $args 0]

    if {$FirstArg == "unset"} {
	if {[info exists TableauEPDIdOrga]} {unset TableauEPDIdOrga}
	return
    }
    
    set Quoi [join $args ","]
    if {[info exists TableauEPDIdOrga($Quoi)]}     { return [set TableauEPDIdOrga($Quoi)]}

    if {[info exists TableauEPDIdOrga(EstCharge)]} { return }
    
    set TableauEPDIdOrga(EstCharge) 1
    LoadEPDIdOrga TableauEPDIdOrga

    if {[info exists TableauEPDIdOrga($Quoi)]}     { return [set TableauEPDIdOrga($Quoi)]}
    return


}

proc AskEPDOrgas {args} {


    ### Interroge le fichier EPDOrgas ###
    global TableauEPDOrgas
        
    #unset
    #LesEPDOrgas
    #LesEPDOrganisms
    #LesEPDOrganismsLongs
    #EPDOrga      $EPDOrga      EPDOrganism
    #EPDOrga      $EPDOrga      EPDOrganismLong
    #EPDOrganism  $EPDOrganism  EPDOrganismLong

    set FirstArg [lindex $args 0]

    if {$FirstArg == "unset"} {
	if {[info exists TableauEPDOrgas]} {unset TableauEPDOrgas}
	return
    }
    
    set Quoi [join $args ","]
    if {[info exists TableauEPDOrgas($Quoi)]} { return [set TableauEPDOrgas($Quoi)]}

    if {[info exists TableauEPDOrgas(EstCharge)]} { return }
    
    set TableauEPDOrgas(EstCharge) 1
    LoadEPDOrgas TableauEPDOrgas

    if {[info exists TableauEPDOrgas($Quoi)]} { return [set TableauEPDOrgas($Quoi)]}
    return


}

proc AskEponine {args} {


    ### Interroge le fichier eponine ###
    global TableauEponine

    #unset
    #FileEponine NbEponines   --> nb eponinepredictions dans le FileEponine
    #FileEponine LesEponines  --> liste des indices des Eponines
    #FileEponine n $n D
    #FileEponine n $n F
    #FileEponine n $n Sens
    #FileEponine n $n Score

    set FirstArg [lindex $args 0]
    
    if {$FirstArg == "unset"} {
	if {[info exists TableauEponine]} {unset TableauEponine}
	return
    }
    set Quoi [join $args ","]
    if {[info exists TableauEponine($Quoi)]} { return [set TableauEponine($Quoi)]}
    if {![file exists $FirstArg]} { return }
    if {[info exists TableauEponine($FirstArg,EstCharge)]} { return }
    
    set TableauEponine($FirstArg,EstCharge) 1
    LoadEponine TableauEponine $FirstArg

    if {[info exists TableauEponine($Quoi)]} { return [set TableauEponine($Quoi)]}
    return


}

proc AskFileInfosDuFileTFAs {args} {


    ### Interroge le fichier FileInfosDuFileTFAs ###
    global TableauInfosDuFileTFAs
        
    #unsetall
    #unsetfile $FileInfosDuFileTFAs
    #$FileInfosDuFileTFAs LesSeqNames
    #$FileInfosDuFileTFAs SeqName $SeqName Id
    #$FileInfosDuFileTFAs SeqName $SeqName SeqLength
    #$FileInfosDuFileTFAs SeqName $SeqName Entete

    set FirstArg [lindex $args 0]

    if {$FirstArg == "unsetall"} {
	if {[info exists TableauInfosDuFileTFAs]} {unset TableauInfosDuFileTFAs}
	return
    }
    
    if {[string equal -nocase $FirstArg "unsetfile"]} {
	set File [lindex $args 1]
	if {$File == "" || ![file exists $File] || ![info exists TableauInfosDuFileTFAs]} {return}
	foreach Index [array name TableauInfosDuFileTFAs] {
	    if {![regexp "^$File" $Index]} {continue}
	    unset TableauInfosDuFileTFAs($Index)
	}

	return
    }
    
    set Quoi [join $args ","]
    if {[info exists TableauInfosDuFileTFAs($Quoi)]}               {return [set TableauInfosDuFileTFAs($Quoi)]}
    if {![file exists $FirstArg]}                                  {return}
    if {[info exists TableauInfosDuFileTFAs($FirstArg,EstCharge)]} {return}
    
    set TableauInfosDuFileTFAs(EstCharge) 1
    LoadFileInfosDuFileTFAs TableauInfosDuFileTFAs $FirstArg
    if {[info exists TableauInfosDuFileTFAs($Quoi)]}               {return [set TableauInfosDuFileTFAs($Quoi)]}
    return


}

proc AskFirstEF {args} {



    #unset
    #FileFirstEF LesSens
    #FileFirstEF Sens $Sens LesPredictions
    #FileFirstEF Sens $Sens Prediction $Prediction LesRangs
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang DPromoter
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang FPromoter
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang PPromoter
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang DExon
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang FExon
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang PExon
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang PDonor
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang InfoCpG
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang DCpG
    #FileFirstEF Sens $Sens Prediction $Prediction Rang $Rang FCpG

    global TableauFirstEF

    set FirstArg [lindex $args 0]

    if {$FirstArg == "unset"} {
	if {[info exists TableauFirstEF]} {unset TableauFirstEF}
	return
    }
    
    set Quoi [join $args ","]
    if {[info exists TableauFirstEF($Quoi)]} { return [set TableauFirstEF($Quoi)]}
    if {![file exists $FirstArg] || [info exists TableauFirstEF($FirstArg,EstCharge)]} { return }
    
    set TableauFirstEF($FirstArg,EstCharge) 1
    LoadFirstEF TableauFirstEF $FirstArg

    if {[info exists TableauFirstEF($Quoi)]} { return [set TableauFirstEF($Quoi)]}
    return


}

proc AskForNumberingGenbank {} {


    global AskForNumberingGenbank
    if {[info exists AskForNumberingGenbank]} { return $AskForNumberingGenbank }
    if {[OuiOuNon "Something is wrong with numbering genbank ORFs\n  Don't panic ... \n Do I stop to ask for your help ?"]} {
	set AskForNumberingGenbank 0
	return 0
    }
    if {[OuiOuNon "Do I always ask for your help ?"]} {
	set AskForNumberingGenbank 1
    }
    return 1


}

proc AskGOAnalyse {args} {


    global TabGOAnalyseXML 
 
    #unset
    #unsetfile $FichierXML
    #$FichierXML IdMin
    #$FichierXML NorMDMin
    #$FichierXML PMin
    #$FichierXML FMin
    #$FichierXML LesMethodes
    #$FichierXML LesAccess
    #$FichierXML Query Id
    #$FichierXML Query Name
    #$FichierXML Fichier MSF
    #$FichierXML Fichier CLUST
    #$FichierXML Methode $Methode LesTypes
    #$FichierXML Methode $Methode Type      $Type   LesGO
    #$FichierXML Methode $Methode Type      $Type   GO       $GO LesAccess
    #$FichierXML Methode $Methode Type      $Type   GO       $GO NbAccess
    #$FichierXML Methode $Methode LesAccess
    #$FichierXML Methode $Methode Access    $Access Types    $Type LesGO
    #$FichierXML Methode $Methode Access    $Access LesTypes
    #$FichierXML Type $Type GO $GO Definition

    set PremierArg [lindex $args 0] 
    if {[string equal -nocase $PremierArg  "unsetall"]} {
	unset TabGOAnalyseXML
	return
    }
    if {[string equal -nocase $PremierArg  "unsetfile"]} {
	set File [lindex $args 1]
	if {$File == "" || ![file exists $File] || ![info exists TabGOAnalyseXML]} {return}
	foreach Index [array name TabGOAnalyseXML] {
	    Espionne $Index
	    if {![regexp "^$File" $Index]} {continue}

	    unset TabGOAnalyseXML($Index)
	}
	return
    }

    set Quoi [join $args ","]

    #Espionne $args

    if {![file exists $PremierArg]} {return}
    if {[info exists TabGOAnalyseXML($Quoi)                ]} {return [set TabGOAnalyseXML($Quoi)]}

    if {[info exists TabGOAnalyseXML($PremierArg,EstCharge)]} {return}
    set TabGOAnalyseXML($PremierArg,EstCharge) 1
    LoadGOAnalyse TabGOAnalyseXML $PremierArg

    if {[info exists TabGOAnalyseXML($Quoi)                ]} {return [set TabGOAnalyseXML($Quoi)]}
    return


}

proc AskGOGraph {args} {


    #AskGOGraph search id $GO
    #AskGOGraph search name $name
    #AskGOGraph search synonym $synonym

    #AskGOGraph $GO get name
    #AskGOGraph $GO get namespace
    #AskGOGraph $GO get alternateIDs
    #AskGOGraph $GO get definition
    #AskGOGraph $GO get synonyms
    #AskGOGraph $GO get xrefs
    #AskGOGraph $GO get parents
    #AskGOGraph $GO get childs
    #AskGOGraph $GO get allParents
    #AskGOGraph $GO get allChilds

    LoadGOGraph

    switch -regexp [lindex $args 0] {
	"^search$" {
	    set search [lindex $args 2]

	    switch -exact [lindex $args 1] {
		"id" {
		    if {[GOGraph node exists $search]} {
			return $search
		    }
		    regsub -all {\"} $search {\\\0} search
		    return [GOGraph nodes -filter "lsearchNodeKeyGraphFilter -exact alternateIDs \"$search\""]
		}
		"name" {
		    return [GOGraph nodes -key name -value $search]
		}
		"synonym" {
		    regsub -all {\"} $search {\\\0} search
		    return [GOGraph nodes -filter "lsearchNodeKeyGraphFilter -exact synonyms \"$search\""]
		}
	    }
	}
	"^GO:\\d+" {
	    set GO [AskGOGraph search id [lindex $args 0]]
	    if {![GOGraph node exists $GO]} {return ""}

	    switch -exact [lindex $args 1] {
		"get" {
		    set key [lindex $args 2]

		    switch -exact $key {
			"name" -
			"namespace" -
			"alternateIDs" -
			"definition" -
			"synonyms" -
			"xrefs" {
			    if {[GOGraph node keyexists $GO $key]} {
				return [GOGraph node get $GO $key]
			    }
			    return ""
			}
			"parents" {
			    return [GOGraph nodes -out $GO]
			}
			"childs" {
			    return [GOGraph nodes -in $GO]
			}
			"allParents" {
			    set allParents {}

			    foreach parent [AskGOGraph $GO get parents] {
				lappend allParents $parent
				set parentParents [AskGOGraph $parent get allParents]
				if {[llength $parentParents] != 0} {
				    set allParents [concat $allParents $parentParents]
				}
			    }

			    return $allParents
			}
			"allChilds" {
			    set allChilds {}

			    foreach child [AskGOGraph $GO get childs] {
				lappend allChilds $child
				set childChilds [AskGOGraph $child get allChilds]
				if {[llength $childChilds] != 0} {
				    set allChilds [concat $allChilds $childChilds]
				}
			    }

			    return $allChilds
			}
		    }
		}
	    }
	}
    }

    error "[lindex [info level 0] 0]: could not parse arguments \"$args\""


}

proc AskLMS {args} {


    global TabDesLMSEtDesMotifsDuBallast

    if {$args == ""} {return}
    set PremArg [lindex $args 0]
    if {[string equal -nocase $PremArg "unset"]} {
	unset TabDesLMSEtDesMotifsDuBallast
	return
    }
    if {![file exists $PremArg]} {return}
    set Quoi [join $args ","]
    if {[info exists TabDesLMSEtDesMotifsDuBallast($Quoi)]} {return [set TabDesLMSEtDesMotifsDuBallast($Quoi)]}
    if {[info exists TabDesLMSEtDesMotifsDuBallast($PremArg,EstCharge)]} {return}
    
    set     TabDesLMSEtDesMotifsDuBallast($PremArg,EstCharge) 1
    LoadLMS TabDesLMSEtDesMotifsDuBallast $PremArg

    if {[info exists TabDesLMSEtDesMotifsDuBallast($Quoi)]} {return [set TabDesLMSEtDesMotifsDuBallast($Quoi)]}
    return


}

proc AskLesPagesInfos {args} {


    global TabDesPagesInfosEnMemoire

    set FirstArg [lindex $args 0]

    if {$FirstArg == "set"} {
	set Access   [lindex $args 1]
	set PageInfo [lindex $args 2]
	set TabDesPagesInfosEnMemoire($Access) $PageInfo
	return
    }
    if {$FirstArg == "unset"} {
	if {[info exists TabDesPagesInfosEnMemoire]} {unset TabDesPagesInfosEnMemoire}
	return
    }
    if {$FirstArg == "ask"} {
	set Id [lindex $args 1]
	if {![info exists TabDesPagesInfosEnMemoire($Id)]} {return}
	return [set TabDesPagesInfosEnMemoire($Id)]
    }
    if {$FirstArg == "load"} {
	set LesId  [lindex $args 1]
	set Banque [lindex $args 2]

	foreach ListeId [LaListeSplittee $LesId "100"] {
	    TabLesPageInfos TabDesPagesInfosEnMemoire $ListeId $Banque
	}
	return
    }
    return


}

proc AskMSF {args} {


    global TabSequencesDesProteinesDansMSF

    #unset 
    #$FileMSF LesAccess
    #$FileMSF $Access -> sequence

    set PremierArg [lindex $args 0]

    if {$PremierArg == "unset"} {
	if {[info exists TabSequencesDesProteinesDansMSF]} {unset TabSequencesDesProteinesDansMSF}
	return
    }

    if {![file exists $PremierArg]} {return}
    if {[info exists TabSequencesDesProteinesDansMSF] && ![info exists TabSequencesDesProteinesDansMSF($PremierArg,EstCharge)]} {
	unset TabSequencesDesProteinesDansMSF
    }

    set Quoi [lindex $args 1]
    if {[info exists TabSequencesDesProteinesDansMSF($Quoi)]} {
	return [set TabSequencesDesProteinesDansMSF($Quoi)]
    }
    if {[info exists TabSequencesDesProteinesDansMSF($PremierArg,EstCharge)]} {return}
    if {[info exists TabSequencesDesProteinesDansMSF]} {unset TabSequencesDesProteinesDansMSF}
    set   TabSequencesDesProteinesDansMSF($PremierArg,EstCharge) 1
    DecortiqueUnMSF $PremierArg TabSequencesDesProteinesDansMSF(LesAccess) TabSequencesDesProteinesDansMSF

    if {![info exists TabSequencesDesProteinesDansMSF($Quoi)]} {return}
    return [set TabSequencesDesProteinesDansMSF($Quoi)]


}

proc AskMatch {args} {


    ### Interroge la sortie du programme match ###
    
    #unset
    #FileMatch LesMotifs
    #FileMatch Motif $MotifId NbPresence
    #FileMatch Motif $MotifId n $i Debut
    #FileMatch Motif $MotifId n $i Fin
    #FileMatch Motif $MotifId n $i Sens
    #FileMatch Motif $MotifId n $i Sequence
    #FileMatch Motif $MotifId n $i ScoreCore
    #FileMatch Motif $MotifId n $i ScoreMotif
    
    global TableauMatchSearches

    set FirstArg [lindex $args 0]

    if {$FirstArg == "unset"} {
	if {[info exists TableauMatchSearches]} {unset TableauMatchSearches}
	return
    }
    
    set Quoi [join $args ","]
    if {[info exists TableauMatchSearches($Quoi)]} { return [set TableauMatchSearches($Quoi)]}
    if {![file exists $FirstArg] || [info exists TableauMatchSearches($FirstArg,EstCharge)]} { return }
    
    set TableauMatchSearches($FirstArg,EstCharge) 1
    LoadMatch TableauMatchSearches $FirstArg

    if {[info exists TableauMatchSearches($Quoi)]} { return [set TableauMatchSearches($Quoi)]}
    return


}

proc AskMatchMatrixAccess2Id2Name {args} {


    ### Interroge le fichier d'informations sur la librairie de matrices de Match ###
    global TableauMatchMatrixAccess2Id2Name

    #unset
    #Access $Access Id
    #Access $Access Name
    #Id     $Id     Access
    #Id     $Id     Name

    set FirstArg [lindex $args 0]
    if {$FirstArg == "unset"} {
	if {[info exists TableauMatchMatrixAccess2Id2Name]} {unset TableauMatchMatrixAccess2Id2Name}
	return
    }
    set File [MatchDir MatrixLibrary]

    set Quoi [join $args ","]  
    if {$FirstArg == "Id"} {regsub -all {\$} $Quoi "_" Quoi}

    if {[info exists TableauMatchMatrixAccess2Id2Name($File,$Quoi)]} { return [set TableauMatchMatrixAccess2Id2Name($File,$Quoi)]}
    if {![file exists $File]} { return }
    if {[info exists TableauMatchMatrixAccess2Id2Name($File,EstCharge)]} { return }
    
    set TableauMatchMatrixAccess2Id2Name($File,EstCharge) 1
    LoadMatchMatrixAccess2Id2Name TableauMatchMatrixAccess2Id2Name $File

    if {[info exists TableauMatchMatrixAccess2Id2Name($File,$Quoi)]} { return [set TableauMatchMatrixAccess2Id2Name($File,$Quoi)]}
    return


}

proc AskOptionsDeDrawBlast {args} {


    global TabOptionsDeDrawBlast

    set FirstArg [lindex $args 0]
    if {[string equal $FirstArg "unsetall"]} {
	if {[info exists TabOptionsDeDrawBlast]} {unset TabOptionsDeDrawBlast}
	return
    }

    if {[string equal $FirstArg "set"]} {
	set Qui [join [lrange $args 1 end-1] ","]
	set Quoi      [lindex $args   end  ]
	set TabOptionsDeDrawBlast($Qui) $Quoi
	return
    }
    if {[string equal $FirstArg "append"]} {
	set Qui [join [lrange $args 1 end-1] ","]
	set Quoi      [lindex $args   end  ]
	if {![info exists TabOptionsDeDrawBlast($Qui)]} {set TabOptionsDeDrawBlast($Qui) {}}
	lappend TabOptionsDeDrawBlast($Qui) $Quoi
	return
    }

    set Qui [join [lrange $args 1 end] ","]
    if {[string equal $FirstArg "unset"]} {
	if {![info exists TabOptionsDeDrawBlast($Qui)]} {return}
	unset TabOptionsDeDrawBlast($Qui)
	return
    }
    if {[string equal $FirstArg "exists"]} {
	if {![info exists TabOptionsDeDrawBlast($Qui)]} {return 0}
	return 1
    }
    if {[string equal $FirstArg "ask"]} {
	if {![info exists TabOptionsDeDrawBlast($Qui)]} {return}
	return [set TabOptionsDeDrawBlast($Qui)]
    }
    return


}

proc AskPrositeScan {Lseq} {

    set result [PrositeWebService -seq $Lseq]
    
    package require json
    set dres [::json::json2dict $result]
    set val [dict get $dres matchset]
    set i 1
    foreach e $val {
	foreach {k v} $e {
	    set Tres($i,$k) $v
	    #puts "\t$k $v"
	}
	incr i
    }

    return [array get Tres]

}

proc AskTOLDBUpdates {} {


    set db [InitTaxDB]
    unset -nocomplain ::db

    set res [list]
    $db eval {begin transaction}
    lappend res [$db eval {select value from admin where var = 'goldUpdate'}]
    lappend res [$db eval {select value from admin where var = 'taxoUpdate'}]
    $db eval {commit}
    $db close
    update

    return $res


}

proc AskUCSC {args} {


    ### Frederic Chalmel, Biozentrum Basel, 2005 ###
    ### ask du fichier refSeqAli.txt ###
    
    ### Liste des access de mRNA RefSeq de l'organisme considere:
    ### $File ListOfID                     --> liste des access de mRNA RefSeq
    ### Localisation des mRNA RefSeq sur le chromosome:
    ### $File ID       $ID ListOfPosition  --> liste          $ID $SeqFrom $SeqTo $Chr $ChrFrom $ChrTo $Strand
    ### Carte exonique:
    ### $File ID       $ID Chrom $Chr From $ChrFrom To $ChrTo Strand $Strand ListOfPosition
    ###                                    --> liste de [list $ID $Start1  $End1  $Chr $Start2  $End2  $Strand]
    
    global TabUCSCLocation
    
    # proc AskUCSC args -> %File ListOfID              -> return the list of the ID
    # proc AskUCSC args -> %File ID %ID ListOfPosition -> return the list of the position of the %ID ID on the genome
    
    set FirstArg [lindex $args 0]
    
    if {$FirstArg == "unset"} {
	if {[info exists TabUCSCLocation]} {unset TabUCSCLocation}
	return
    }
    if {$FirstArg == "unsetfile"} {
	set File [lindex $args 1]
	if {$File == "" || ![file exists $File] || ![info exists TabUCSCLocation]} {return}
	foreach Index [array name TabUCSCLocation] {
	    if {![regexp "^$File" $Index]} {continue}
	    unset TabUCSCLocation($Index)
	}
	return
    }
    
    set File $FirstArg
    
    set ARG [join $args ","]
    
    if {[info exists TabUCSCLocation($ARG)]        } {return [set TabUCSCLocation($ARG)]}
    if {[info exists TabUCSCLocation($File,Loaded)]} {return}
    LoadUCSC TabUCSCLocation $File
    if {[info exists TabUCSCLocation($ARG)]        } {return [set TabUCSCLocation($ARG)]}
    return


}

proc AssemblyDbTools {{dbName ""}} {



    while {$dbName==""} {
	if {[OnTraite Bathy2010]} { set dbName "Bathymodiolus"; break }
    }

    NSAssemblyDb::setCanal $dbName

    set win [toplevel [NomDe fenetre]]
    wm title $win "Assembly database tools"

    set libEditButton [button $win[NomDe button] -text "Library editor" -command "LibraryEditorGui"]
    pack $libEditButton -fill x
    set popDbButton [button $win[NomDe button] -text "Populate database" -command "PopulateAssemblyDbGui"]
    pack $popDbButton -fill x
    #rR Specific Bathyumodiolus !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    if {$dbName!="Bathymodiolus"} { return 0 }
    set popBathyButton [button $win[NomDe button] -text "Populate Bathymodiolus with Bathy2010" -command "PopulateBathy2010"]
    pack $popBathyButton -fill x
    return 0


}

proc AssignNbInternal {n} {


    global Tx

    set Lgen [DonneGenealogieMem $n]
    set cum 0
    foreach g $Lgen {
	set isI $Tx(isInt,$g)
	if {$isI} {
	    set Tx(NbInt,$g) 0
	    incr cum
	} else {
	    set Tx(NbInt,$g) $cum
	    if {$cum} {
		set cum 0
	    }
	}
    }

    return


}

proc AssignSeqToGroup {} {

    global LNDG SDG GroupeDeLaSequence TDuGroupeDesSeqs

    set Lg [lsearch -all -inline -regexp $LNDG {Group[0-9]+}]
    if {[llength $Lg] > 0} {
	set Lg [lrange $LNDG 1 end]
    } else {
	set Lg "GroupeToutLeMonde"
    }
    foreach g $Lg {
	if {$g eq "GroupeToutLeMonde"} {
	    set ng "Group0"
	} else {
	    set ng $g
	}
	foreach n [set SDG($g)] {
	    set GroupeDeLaSequence($n) $ng
	    set TDuGroupeDesSeqs($n) $ng
	}
    }

    if {! [info exists GroupeDeLaSequence]} {
	foreach n [set SDG(GroupeToutLeMonde)] {
	    set GroupeDeLaSequence($n) "Group0"
	}
    }

    return

}

proc AssigneBootstrap {AId} {

    global TSum Abr HashRef

    set t [set Abr(Arbre,$AId)]

    foreach n [$t nodes] {
	if {[$t isleaf $n]} {continue}
	if {$n eq "root"} {
	    set v 1000000
	} elseif {! [info exists TSum($n)]} {
	    puts "no TSum for $n"
	    set v 0
	} else {
	    set v [set TSum($n)]
	}
	$t set $n nboot $v
    }

    set Ser [$t serialize]
    set Abr(ArbreSer,$AId) $Ser

    return

}

proc AssigneGroupesDuRSF {} {


    global NomsGrpIntegral
    global LesNomsSeqGrpIntegral
    global LNOrdali
    global LeGroupeDesSeqs
    global TabRSF

    set NomsGrpIntegral {}
    foreach nom $LNOrdali {
	if {! [info exists TabRSF($nom,group)]} {continue}
	set grp [set TabRSF($nom,group)]
	if {[lsearch $NomsGrpIntegral "Group$grp"]==-1} {
	    lappend NomsGrpIntegral "Group$grp"
	}
	lappend LesNomsSeqGrpIntegral(Group$grp) $nom
    }

    return

}

proc AssigneGroupesIntegral {} {

    global LeGroupeDesSeqs TDuGroupeDesSeqs DocMacsim NomsGrpIntegral LesNomsSeqGrpIntegral LNOrdali TabRSF

    unset -nocomplain NomsGrpIntegral LesNomsSeqGrpIntegral

    if {[info exists TabRSF]} {
	AssigneGroupesDuRSF

	return
    }

    set NomsGrpIntegral [list]
    unset -nocomplain LesNomsSeqGrpIntegral
    foreach nom $LNOrdali {
	if {[string trim $nom] eq ""} {continue}
	set grp [set TDuGroupeDesSeqs($nom)]
	lappend NomsGrpIntegral $grp
	lappend LesNomsSeqGrpIntegral($grp) $nom
    }
    set NomsGrpIntegral [lsort -unique $NomsGrpIntegral]

    return

}

proc AssigneLePoidsDesSeqs {} {


    global LePoidsDesSeqs
    global IdXml
    global LesPoidsDesSequences
    global LNOrdali
    global FichierMSF
    global FichierXML

    set LePoidsDesSeqs {}
    if {[info exists FichierMSF]} {
	LitLesPoidsDuMSF $FichierMSF
	foreach n $LNOrdali {
	    set p [set LesPoidsDesSequences($n)]
	    lappend LePoidsDesSeqs $p
	}
    }
    if {[info exists FichierXML]} {
	ExtraitLesPoids $IdXml LePoidsDesSeqs
    }

    return

}

proc AssigneLePoint {aa NmGrp pos} {

    global LNDG ListeDesPiliersDuGroupe

    set aa [string toupper $aa]
    set YaPoint 1

    foreach groupe [lrange $LNDG 1 end] {
	if {[string compare $groupe $NmGrp] && $YaPoint} {
	    set PilierCompare [lrange [set ListeDesPiliersDuGroupe($groupe)] $pos $pos]
	    set YaPoint [expr {![regexp $aa $PilierCompare]}]
	}
    }

    return $YaPoint

}

proc AssigneLesPoids {{nmgrp ""}} {

    global LesPoidsDesSequences Defauts Sequences LNOrdali OrdTmpDir

    if {! [set Defauts(Poids)] && ![set Defauts(Poids2)] && ![set Defauts(Poids3)]} {
	foreach s $LNOrdali {
	    set LesPoidsDesSequences($s) 1.
	}
	return
    }

    set in [file join $OrdTmpDir "in"]
    set out [file join $OrdTmpDir "out"]

    CreeLeTfa $in $nmgrp

    eval exec "calcule_weight $in $out"

    LitLesPoidsDuMSF $out $nmgrp

    file delete -force $in
    file delete -force $out

    return

}

proc AssigneTagsCouleursDesAA {} {

    global NomTextSeq TagCouleurAA

    foreach t {STAC DE HN G P Q ILMV RK FYW} {
	foreach a [split $t ""] {
	    set TagCouleurAA($a) $t
	    set TagCouleurAA([string tolower $a]) $t
	}
    }

    set conftag [ExtraitTable "[TypeSeq]"]
    foreach c $conftag {
	lassign $c n f b
	$NomTextSeq tag configure Tag$n -foreground $f -background $b
    }
    
    return

}

proc AssigneValParPos {} {

    global TableScore
    global ListeScore
    global LNOrdali
    global SDG
    global LNDG
    global ListeDesPiliersDuGroupe
    global TestCourant

    RecupereReference
    CreeFeaturesOrdali

    foreach g [lrange $LNDG 0 end-1] {
	if {[info exists TableScore]} {
	    array unset TableScore
	    catch {unset TableScore}
	}
	puts "Nom Grp   : $g"
	puts "NSeqs     : [llength $SDG($g)]"
	if {$g == "GroupeToutLeMonde"} {set g ""}

	ScoreDeRosace $g
	ScoreDeThompson   $g
	ScoreDeRanganatan $g

	CreeListeScore $g

	# fait les differentes combinaisons de parametres
	#
	#    norm dsp nVp mcos dist Ranganatan
	#     0    1   2   3    4     5
	#     n    p   v   m    d     g

	LanceLesCalculs 5 $g
	LanceLesCalculs 4 $g
	LanceLesCalculs 0 $g
	LanceLesCalculs 45 $g
	LanceLesCalculs 045 $g
    }

    return

}

proc AtomePicke {Lr} {


    global RasM

    foreach l $Lr {
	if {[string first "Atom: " $l] == 0} {
	    scan $l "Atom: %s %d Group: %s %d  Chain: %s" atName atNb resName resNb chain
	    set RasM(Picked) [list $atName $resName $resNb $chain]
	    set RasM(AtLabel) "$resName $resNb $atName , $chain"
	}
    }

    return

}

proc Atomes2Grille {bbox Lc Lx Lan} {

    SampleVdW
    
    set Step [set ::Defauts(Sampling)]
    set Offset [expr {$::SpS(Offset)+1}]

    set OffX $Offset
    set OffY $Offset
    set OffZ $Offset
    puts "Step $Step"
    puts "Offset $Offset"

    lassign $bbox xm xx ym yx zm zx
    set xmi [expr {int($xm*$Step)-1}]
    set ymi [expr {int($ym*$Step)-1}]
    set zmi [expr {int($zm*$Step)-1}]
    set xxi [expr {int($xx*$Step)+1}]
    set yxi [expr {int($yx*$Step)+1}]
    set zxi [expr {int($zx*$Step)+1}]
    
    lassign $Lc xc yc zc
    set xci [expr {round($xc*$Step)}]
    set yci [expr {round($yc*$Step)}]
    set zci [expr {round($zc*$Step)}]

    # faut Offset sur chaque bord
    set resX [expr {int($xx-$xm+0.5)*$Step+1+2*$Offset}]
    set resY [expr {int($yx-$ym+0.5)*$Step+1+2*$Offset}]
    set resZ [expr {int($zx-$zm+0.5)*$Step+1+2*$Offset}]

    # Faut que la resolution de la grille soit un 
    # multiple de 3
    set k 4
    set Extra 0
    while {$resX % (1*$Step) || $resX % ($k*$Step) } {
	incr Extra
	set resX [expr {int($xx-$xm+0.5)*$Step+1+2*$OffX+$Extra}]
    }
    set Extra 0
    while {$resY % (1*$Step) || $resY % ($k*$Step) } {
	incr Extra
	set resY [expr {int($yx-$ym+0.5)*$Step+1+2*$OffY+$Extra}]
    }
    set Extra 0
    while {$resZ % (1*$Step) || $resZ % ($k*$Step) } {
	incr Extra
	set resZ [expr {int($zx-$zm+0.5)*$Step+1+2*$OffZ+$Extra}]
    }
    puts "\nresX $resX resY $resY resZ $resZ"

    for {set k 0} {$k < $resZ } {incr k} {
	for {set j 0} {$j < $resY } {incr j} {
	    for {set i 0} {$i < $resX } {incr i} {
		set T($i,$j,$k) 0
	    }
	}
    }

    set g [open coord w]
    foreach rx $Lx lna $Lan {
	foreach v $rx an $lna {
	    lassign $v x y z
	    puts $g [format " %8.3f %8.3f %8.3f" $x $y $z]
	    set x [expr {round($x-$xm)*$Step+1+$OffX}]
	    set y [expr {round($y-$ym)*$Step+1+$OffY}]
	    set z [expr {round($z-$zm)*$Step+1+$OffZ}]

	    FillTheBox T $x $y $z $an
	    #set T($x,$y,$z) 1.
	}
    }
    close $g
    puts "fill table T [llength [array names T]]"

    foreach e [array names T] {
	lassign [split $e ,] i j k
	if {($i < 0 || $i >= $resX) || ($j < 0 || $j >= $resY) || ($k < 0 || $k >= $resZ)} {puts $e}
    }

    set Lv [list]
    lappend Lv [list $resX $resY $resZ]
    
    #ExpandMask T $resX $resY $resZ
    #ExpandMask T $resX $resY $resZ
    #ExpandMask T $resX $resY $resZ
    #ExpandMask T $resX $resY $resZ
    #ContractMask T $resX $resY $resZ
    #ContractMask T $resX $resY $resZ
    #ContractMask T $resX $resY $resZ
    #ContractMask T $resX $resY $resZ
    #ExpandMask T $resX $resY $resZ
    #ExpandMask T $resX $resY $resZ
    #ContractMask T $resX $resY $resZ

    set f [open test w]
    #lappend Lv [list 8 8 8]
    puts ""
    for {set k 0} {$k < $resZ } {incr k} {
	for {set j 0} {$j < $resY } {incr j} {
	    for {set i 0} {$i < $resX } {incr i} {
		lappend Lp [set T($i,$j,$k)]
		puts -nonewline $f [set T($i,$j,$k)]
		if {[set T($i,$j,$k)] == 0} {
		    puts -nonewline "."
		} else {
		    puts -nonewline "O"
		}
	    }
	    puts ""
	}
	puts "\n"
    }
    close $f
    puts "$resX $resY $resZ"
    exit
    lappend Lv $Lp
    
    set Ltrg [mctcl $Lv]

    return $Ltrg

}

proc AttachTaxonomyToDB {} {


    global Tx db

    # depending on the database requested
    if {$Tx(-txdb) eq "uniprot"} {
	set dbtaxo "/genomics/link/taxonomy/uniprot_taxonomy/uniprot_taxonomy.sql"
	$db eval {attach database $dbtaxo as tax}
    } else {
	set dbtaxo /genomics/link/taxonomy/ncbi_taxonomy/ncbi_taxonomy.sql
	$db eval {attach database $dbtaxo as taxonomy}
    }

    puts "load taxonomy into memory done ..."

    return


}

proc AttendLeSavant {Animateur Ip Cafe Science Ident} {


    global SavantSpecialise
    
    if { [eof $Animateur] } {
	#PotinsDeQuestion "AttendLeSavant $Animateur $Ip $Cafe $Science recu 'eof'"
	close $Animateur
	return
    }
    if { [gets $Animateur Reponse] == -1 } {
	#PotinsDeQuestion "$Animateur $Ip $Cafe $Science mauvaise reponse"
	return
    }
    if { 0 && ! [EstUnSavant $Reponse]} {
	#PotinsDeQuestion "$Animateur $Ip $Cafe $Science a retourne $Reponse qui n'est pas un savant."
	return
    }

    set SavantSpecialise($Science,$Cafe,$Ident) $Reponse



}

proc AttendreLeFichier {Fichier {TimeOut ""}} {



    set Attente 1000
    while { 1 } {
	if {[file exists $Fichier]} { return $Fichier }
	if {$TimeOut != "" } {
	    set TimeOut [expr $TimeOut-$Attente]
	    if {$TimeOut<0} { return "" }
	}
	after $Attente
    }


}

proc AttendreLeFichierDuServeurWscope {Fichier {TimeOut ""}} {



    set Attente 1000
    while { 1 } {
	if {[file exists $Fichier]} { return $Fichier }
	if {$TimeOut != "" } {
	    set TimeOut [expr $TimeOut-$Attente]
	    if {$TimeOut<0} { return "" }
	}
	after $Attente
    }


}

proc AttendreTantQueExiste {Fichier {TimeOut 60000}} {


    while {[file exists $Fichier]} { after $TimeOut }
    return $Fichier


}

proc AttriCoord {} {


    set Fichier "/genomics/link/EVI0/parser/f2attritoutaccess"
    set LesLignes [LesLignesDuFichier $Fichier]
    set A 0; set B 0
    set AccessSansCoord {}
    set JaiTrouveLigne 0

    foreach Ligne $LesLignes {
	
	if {[regexp {^ligne} $Ligne]} {
	    set JaiTrouveLigne 1
	    set NumLigne [StringApres "ligne" dans $Ligne]
	    puts $NumLigne
	    continue
	} 
	if {$JaiTrouveLigne} {
	    #pr RA
	    if {![regexp {^Les} $Ligne]} {
		incr A
		continue
	    }

	    set LesAccess [string range $Ligne [expr [string first " " $Ligne]+1] end]
	    puts "$LesAccess"

	    #pr SsAccess
	    if {[regexp "vide" $LesAccess]} {
		incr B
		continue
	    }

	    set ListeDesAccess [split $LesAccess " ,"]
	    foreach Access $ListeDesAccess {
		set chr      [LocUcsc $Access chrom]
		set txstart  [LocUcsc $Access txStart]
		set txend    [LocUcsc $Access txEnd]
		set cdsstart [LocUcsc $Access cdsStart]
		set cdsend   [LocUcsc $Access cdsEnd]
		puts "$Access=$chr $txstart - $txend"
		#puts "$Access=$cdsstart - $cdsend"
		if {$txstart==""} {
		    lappend AccessSansCoord "$NumLigne=>$Access"
		}
	    }
	}
	set JaiTrouveLigne 0
    }
    set nb [llength $AccessSansCoord]
    puts "nb d'access sans coord= $nb"
    puts "nb de ra= $A"
    puts "nb ss access= $B"
    SauveLesLignes $AccessSansCoord dans /genomics/link/EVI0/parser/LesLignesSansCoord.txt 


}

proc AttriDesAcDna {} {


    set A 0; set B 0; set C 0; set Pr 0
    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "DNA_acc"]
	set Ac2 [RetChip2 $I "refseq_PIQOR"]
	set Ac3 [RetChip2 $I "prot_acc"]
	set Ac4 [RetChip2 $I "prot_acc_PIQOR"]

	set jaitrouve 0 
	set genenamefait 0
	set AccDna ""
	set LAccDna {}
	set LesAccDna {}

	if { [regexp {^RA[0-9]+} $Des1] } { continue }
	if { [regexp {\?} $Ac1] } { continue }
	

	if { $Ac1!="" } {
	    incr A
	    Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 =>$A"

	    if {$Ac2==""} {
		incr B
		
		set Genre [OrgDuNmOuGb $Ac1]
		
		if {[regexp {^Mus$} $Genre]} {
		    if { ![regexp {^NM_} $Ac1] } {
			set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			if { $NM != "" } {
			    puts "pour $I, prend Ac1=$Ac1 et NM=$NM (A)"
			} else { puts "pour $I, prend Ac1=$Ac1 (Abis)" }
		    } else { puts "pour $I, prend Ac1=$Ac1 (B)" }
		}
		
		if {[regexp {^Homo$} $Genre]} {
		    incr Pr
		    puts "pour ligne $I, travail sur prot Ac3=$Ac3 Ac4=$Ac4=>$Pr (C)"
		    
		    if { [regexp "," $Ac3] } {puts "attention le prog ne prend pas en compte ce cas"}

		    set GenreP3 [OrgDuProt [string trim $Ac3]]
		    
		    if { $GenreP3 == "" } { 
			#jamais ce cas
			puts "pls=>ligne=$I Acc=$Ac3 Id=attention PAS FICHESpls\n"
			if {$Ac4 == ""} { puts "dois prendre la def" }
			if {$Ac4 != ""} { puts "dois prendre prot_acc_piqor"} 
			continue 
		    }
		    
		    if {[regexp {^Homo} $GenreP3]} {
			if {$Ac4!=""} {
			    #cherche nm de prot_acc_piqor
			    if { [regexp "," $Ac4] } {puts "attention2 le prog ne prend pas en compte ce cas"}
			    set ListeAc4 [split $Ac4 ","]
			    foreach ChaqueAc4 $ListeAc4 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc4]
				if {$AccDna!=""} { 
				    puts "pour $I, prend accdna=$AccDna (D)"
				    set LAccDna [split $AccDna " "]
				    foreach Q $LAccDna {LConcat LesAccDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc4] 
				    if {$AccDna!=""} { 
					puts "pour $I, prend accdna=$AccDna (E)"
					set LAccDna [split $AccDna " "]
					foreach S $LAccDna {LConcat LesAccDna $S} 
				    }
				}
			    }
			    set LesAccDna [lsort -unique $LesAccDna]
			    set LesAccDna [join $LesAccDna " "]
			    puts "pour $I, prend accdna=$LesAccDna (Ebis)"
			} else {
			    set genenamefait 1
			    #voir avec la def
			    set AccDna [AttriDesAcDnaParGeneName $Des1 $Des2]
			    if {$AccDna!=""} { puts "pour $I, prend accdna=$AccDna (F)" }
			}
			if {$genenamefait == 0 && $AccDna == ""} {
			    set AccDna [AttriDesAcDnaParGeneName $Des1 $Des2]
			    if {$AccDna!=""} { puts "pour $I, prend accdna=$AccDna (G)" }
			}
			if {$AccDna == ""} {
			    puts "pas d'acccess"
			    lappend LesLignesPauvres $I
			}
		    }

		    if {[regexp {^Mus} $GenreP3]} {
			if {$Ac4!=""} {
			    #jamais ce cas
			    set AccsProt "$Ac3,$Ac4"
			    puts "acess prot=$AccsProt"
			    set ListeAccsProt [split $AccsProt ","]
			    foreach ChaqueAccProt $ListeAccsProt {
				#recupere nm
				set AccDna [AttriDesAcDnaParProt $ChaqueAccProt]
				if {$AccDna!=""} {
				    puts "chaqueaccprot=$ChaqueAccProt a acc dna $AccDna (H)"
				    set LAccDna [split $AccDna " "]
				    foreach Q $LAccDna {LConcat LesAccDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAccProt] 
				    if {$AccDna!=""} { 
					puts "pour $I, prend accdna=$AccDna (I)" 
					set LAccDna [split $AccDna " "]
					foreach S $LAccDna {LConcat LesAccDna $S} 
				    }
				}
			    } 
			    set LesAccDna [lsort -unique $LesAccDna]
			    set LesAccDna [join $LesAccDna " "]
			    puts "pour $I, prend accdna=$LesAccDna (Ibis)"
			} else {
			    #recupere que prot_acc 
			    set AccDna [AttriDesAcDnaParProt $Ac3]
			    if {$AccDna!=""} { 
				puts "pour $I, prend accdna=$AccDna (J)" 
				set LAccDna [split $AccDna " "]
				foreach Q $LAccDna {LConcat LesAccDna $Q} 
			    }
			    if {$AccDna==""} {  
				set AccDna [AttriDesAcDnaParGb $Ac3] 
				if {$AccDna!=""} { 
				    puts "pour $I, prend accdna=$AccDna (K)" 
				    set LAccDna [split $AccDna " "]
				    foreach S $LAccDna {LConcat LesAccDna $S}  
				}
			    }
			    set LesAccDna [lsort -unique $LesAccDna]
			    set LesAccDna [join $LesAccDna " "]
			    puts "pour $I, prend accdna=$LesAccDna (Kbis)"
			}
			if {$AccDna == ""} {
			    set AccDna [AttriDesAcDnaParGeneName $Des1 $Des2]
			    if {$AccDna!=""} { puts "pour $I, prend accdna=$AccDna (L)" }
			}
			if {$AccDna == ""} {
			    puts "pas d'access"
			    lappend LesLignesPauvres $I
			}
		    }
		}
	    }

	    if {$Ac2!=""} {
		incr C

		if { $Ac1==$Ac2 } {
		    puts "pour $I, prend refseq=$Ac2 (meme numero dans DNA_acc et refseq)(1)"
		    set jaitrouve 1
		}
		if { $jaitrouve == 0 && [regexp {.\,.} $Ac2] } {
		    set LesNMs [split $Ac2 ","]
		    foreach LeNM $LesNMs { 
			if { $LeNM==$Ac1 } { 
			    puts "pour $I, prend refseq=$Ac2 (meme numero dans DNA_acc et refseq)(2)"
			    set jaitrouve 1
			}
		    }
		}

		if { $jaitrouve==0 } {

		    set Genre [OrgDuNmOuGb $Ac1]

		    if {[regexp {^Mus$} $Genre]} {
			if { ![regexp {^NM_} $Ac1] } {
			    set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			    if { $NM != "" } {
				puts "pour $I, prend Ac1=$Ac1 et Ac2=$Ac2 et NM=$NM (3)"
				set ListeAc2 [split $Ac2 ","]
				set ListeNM [split $NM " "]
				set Tout [concat $ListeAc2 $ListeNM]
				set Tout [lsort -unique $Tout]
				puts "pour $I, prend Ac1=$Ac1 et Ac2+NM=$Tout (3bis)"
			    } else { puts "pour $I, prend Ac1=$Ac1 et Ac2=$Ac2 (4)" }
			} else { puts "pour $I, prend Ac1=$Ac1 et Ac2=$Ac2 (5)" }
		    }

		    if {[regexp {^Homo$} $Genre]} {
			puts "pour $I, prend que refseq=$Ac2 (6)"
		    }
		}
	    }
	}
    }
    foreach LignePauvre $LesLignesPauvres { puts "lignepauvre=$LignePauvre" }
    set nbdepauvre [llength $LesLignesPauvres]
    Espionne "nbdepauvre=$nbdepauvre"
    Espionne "$Pr=nb de ligne ou on se sert de la prot"
    Espionne "$A=nb de ligne ac dna_acc"
    Espionne "$B=nb de ligne ac dna_acc et ss refseq_piqor"
    Espionne "$C=nb de ligne ac dna_acc et ac refseq_piqor"


}

proc AttriDesAcDnaClient {} {


    set total 0; set D 0; set E 0; set F 0; set G 0
    foreach I [RetChip5 ListOf Index] {
	set AC [RetChip5 $I "DNA_acc"]
	if {[regexp {\?} $AC]} {set AC ""}

	if { $AC!="" } {
	    set LesAc [split $AC ","]
	    foreach Ac $LesAc {
		incr total
		if { [regexp "^NM_" $Ac] || [regexp "^XM_" $Ac] || [regexp "^NR_" $Ac] } { 
		    incr D
		    puts "la ligne $I a deja un no NM=$Ac" 
		} else {
		    incr E
		    set NM [MrnaRefseqUcscMouse $Ac "Nm"]
		    if { $NM != "" } {
			incr F
			puts "pour $I, Ac=$Ac correspond a $NM ($F)"
		    } else {
			incr G
			puts "pour $I, Ac=$Ac correspond a rien"
		    }
		}
	    } 
	}
    }
    Espionne "il y a $total access DNA_acc"
    Espionne "il y a $D access qui ont deja un NM dans DNA_acc"
    Espionne "il y a $E access qui ont un access transforme"
    Espionne "il y a $F access qui ont 1 corresp"
    Espionne "il y a $G access qui ont pas corresp"


}

proc AttriDesAcDnaClient_AEffacer {} {


    set D 0
    set E 0
    set F 0
    foreach I [RetChip2 ListOf Index] {
	set Ac [RetChip2 $I "DNA_acc"]
	if { $Ac!="" } {
	    if { [regexp "," $Ac] } { puts "attention il y a pls access sur une ligne" } 
	    if { [regexp "^NM_" $Ac] } { 
		incr D
		#puts "la ligne $I a deja un no NM=$Ac" 
	    } else {
		incr E
		set NM [MrnaRefseqUcscMouse $Ac "Nm"]
		if { $NM != "" } {
		    puts "pour $I, Ac=$Ac correspond a $NM ($F)"
		    incr F
		} else {
		    lappend LesPauvres $Ac
		}
	    }
	} else { continue }
    }
    SauveLesLignes $LesPauvres dans [Fiches]/lesPauvres.txt
    set nb [llength $LesPauvres]
    Espionne "il y a $D lignes qui ont deja un NM dans DNA_acc"
    Espionne "il y a $E lignes qui ont un access transforme"
    Espionne "il y a $nb lignes qui ont pas corresp"
    Espionne "il y a $F lignes qui ont 1 corresp"


}

proc AttriDesAcDnaParGb {AC} {


    set LesAcsGbDeLaLigne {}
    set GetzOut ""; set GetzOutRs ""
    set CommandeRs "getz \"\\\[protein-acc:$AC\\\] > \(\\\[refseq-mol:mRNA\\\] & \\\[refseq-org:Mus musculus\\\]\)\" \-vf acc"
    set GetzOutRs [eval exec $CommandeRs]

    if { $GetzOutRs != "" } {
	#Espionne "Acc=$AC getzoutRs=$GetzOutRs"
	set LesLignesDeGetzOutRs [split $GetzOutRs "\n"]
	foreach LigneDeGetzOutRs $LesLignesDeGetzOutRs {
	    set AcRs ""
	    scan $LigneDeGetzOutRs "%s %s" Ref AcRs
	    #Espionne "acrs=$AcRs"
	    LConcat LesAcsGbDeLaLigne $AcRs	
	}
    }
    if {$GetzOutRs == ""} {
	set Commande "getz \"\\\[protein-acc:$AC\\\] > \(\\\[genbankfull-mol:mRNA\\\] & \\\[genbankfull-org:Mus musculus\\\]\)\ \" \-vf acc"
	set GetzOut [eval exec $Commande]
	if {$GetzOut!=""} {
	    #Espionne "Acc=$AC getzoutGb=$GetzOut"
	    set LesLignesDeGetzOut [split $GetzOut "\n"]
	    foreach LigneDeGetzOut $LesLignesDeGetzOut {
		set Ref ""; set AcGb ""; set mRNAGb ""
		scan $LigneDeGetzOut "%s %s" Ref AcGb
		#Espionne "acgb=$AcGb"
		LConcat LesAcsGbDeLaLigne $AcGb	
		if {![regexp {^NM_} $AcGb]} {
		    set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
		    #Espionne "mRNAGb $mRNAGb"
		    if {$mRNAGb != ""} { 
			#Espionne "un NM=$mRNAGb correspond a access AcGb=$AcGb" 
			set ListemRNAGb [split $mRNAGb " "]
			foreach ChaqmRNAGb $ListemRNAGb {
			    set GenreChaqmRNAGb [OrgDuNmOuGb $ChaqmRNAGb]
			    #Espionne "$ChaqmRNAGb $GenreChaqmRNAGb"
			    if {[regexp {^Mus} $GenreChaqmRNAGb]} { 
				LConcat LesAcsGbDeLaLigne $ChaqmRNAGb
			    }
			}
		    }
		} 
	    }
	}
	if {$GetzOut == ""} { 
	    set LesAcsGbDeLaLigne ""
	    #Espionne "Acc=$AC getzout=vide pas fiche ou pas mrna" 
	}
    }
    set LesAcsGbDeLaLigne [ListeSansDoublon $LesAcsGbDeLaLigne]
    set LesAcsGbDeLaLigne [join $LesAcsGbDeLaLigne " "]
    return $LesAcsGbDeLaLigne


}

proc AttriDesAcDnaParGb_AEffacer {AC} {


    set LesAcsGbDeLaLigne {}
    set GetzOut ""
    set Commande "getz \"\\\[protein-acc:$AC\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
    set GetzOut [eval exec $Commande]
    if {$GetzOut == ""} { 
	set LesAcsGbDeLaLigne ""
	#puts "Acc=$AC getzout=vide pas fiche ou pas mrna" 
    }
    if {$GetzOut != ""} {
	#puts "Acc=$AC getzout=$GetzOut"
	set LesLignesDeGetzOut [split $GetzOut "\n"]
	foreach LigneDeGetzOut $LesLignesDeGetzOut {
	    set Ref ""
	    set AcGb ""
	    set mRNAGb ""
	    scan $LigneDeGetzOut "%s %s" Ref AcGb
	    #puts "acgb=$AcGb"
	    LConcat LesAcsGbDeLaLigne $AcGb	
	    if {![regexp {^NM_} $AcGb]} {
		set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
		if {$mRNAGb != ""} { 
		    #puts "un NM=$mRNAGb correspond a access AcGb=$AcGb" 
		    set ListemRNAGb [split $mRNAGb " "]
		    foreach ChaqmRNAGb $ListemRNAGb {
			LConcat LesAcsGbDeLaLigne $ChaqmRNAGb
		    }
		} 
	    }
	}
    }
    set LesAcsGbDeLaLigne [ListeSansDoublon $LesAcsGbDeLaLigne]
    set LesAcsGbDeLaLigne [join $LesAcsGbDeLaLigne " "]
    return $LesAcsGbDeLaLigne


}

proc AttriDesAcDnaParGeneName {DescriC DescriM} {

 
    set LesNMsDeLaLigne {}
    set LesGeneNames {}
    set DescriMOri $DescriM
    set ListeNm {}; set ListmRNA {}; set ListmRNA1 {}
    set LesLignes1 {}; set LesLignes2 {}
    set LesNMs2 ""; set ListeNm2 {}; set mRNA12 {}; set ListmRNA12 {}
    #Espionne "descrimori=$DescriMOri"

    set IPF [string first ")" $DescriM]
    if {$IPF>0} {
	set DescriM [string range $DescriM 0 [incr IPF -1]]
	regsub -all {[\(\:]} $DescriM " " DescriM
	regsub -all -nocase { OR } $DescriM " " DescriM
	set LesGeneNames [LesMotsDeLaLigne $DescriM]
	set DescriM [string trim $DescriM]
	#Espionne "descrim=$DescriM" 
    }
    scan $DescriC "%s" DescriC
    set DescriC [string trim $DescriC]
    regsub -all {\(} $DescriC "" DescriC
    regsub -all {\)} $DescriC "" DescriC
    #Espionne "DescriC= $DescriC"
    set LesDescriC [split $DescriC ","]
    foreach LeDescriC $LesDescriC {
	lappend LesGeneNames $LeDescriC
    }

    if {$LesGeneNames == {} } { return "" }

    set LesGeneNames [ListeSsElmtVide $LesGeneNames]
    set LesGeneNames [ListeSansDoublon $LesGeneNames NoCase]
    #Espionne "lesgenenames=$LesGeneNames"

    foreach GN $LesGeneNames {
	if {[regexp {^Neo} $GN]} {continue}
	#if {[regexp {^RA} $GN]} {continue}
	#Espionne "GN $GN"
	set LesNMs [RefLinkUcscMouse $GN NM]
	#Espionne "LesNMs $LesNMs"
	
	if {$LesNMs!=""} {
	    #Espionne "1"
	    set ListeNm [split $LesNMs " "]
	    foreach ChaqueNM $ListeNm {
		set GenreChaqueNM [OrgDuNmOuGb $ChaqueNM]
		#Espionne "$ChaqueNM $GenreChaqueNM"
		if {[regexp {^Mus} $GenreChaqueNM]} {
		    #Espionne "ChaqueNM $ChaqueNM"
		    LConcat LesNMsDeLaLigne $ChaqueNM
		    if { ![regexp {^NM_} $ChaqueNM] || ![regexp {^XM_} $ChaqueNM] || ![regexp {^NR_} $ChaqueNM] } {
			set mRNA1 [MrnaRefseqUcscMouse $ChaqueNM "Nm"]
			#Espionne "mRNA1 $mRNA1"
			if {$mRNA1 != ""} { 
			    #Espionne "un NM=$mRNA1 correspond a access $ChaqueNM"
			    set ListmRNA1 [split $mRNA1 " "]
			    foreach ChaqmRNA1 $ListmRNA1 {
				set GenreChaqmRNA1 [OrgDuNmOuGb $ChaqmRNA1]
				#Espionne "$ChaqmRNA1 $GenreChaqmRNA1"
				if {[regexp {^Mus} $GenreChaqmRNA1]} { 
				    #Espionne "ChaqmRNA1 $ChaqmRNA1"
				    LConcat LesNMsDeLaLigne $ChaqmRNA1
				}
			    }
			}
		    }
		}
	    }
	}
	set LesNMs2 [RefGeneUcscMouse $GN Name]
	#Espionne "LesNMs2 $LesNMs2"
	if {$LesNMs2!=""} {
	    #Espionne "2"
	    set ListeNm2 [split $LesNMs2 " "]
	    foreach ChaqueNM2 $ListeNm2 {
		set GenreChaqueNM2 [OrgDuNmOuGb $ChaqueNM2]
		#Espionne "$ChaqueNM2 $GenreChaqueNM2"
		if {[regexp {^Mus} $GenreChaqueNM2]} {
		    #Espionne "ChaqueNM2 $ChaqueNM2"
		    LConcat LesNMsDeLaLigne $ChaqueNM2
		    if { ![regexp {^NM_} $ChaqueNM2] || ![regexp {^XM_} $ChaqueNM2] || ![regexp {^NR_} $ChaqueNM2] } {
			set mRNA12 [MrnaRefseqUcscMouse $ChaqueNM2 "Nm"]
			#Espionne "mRNA12 $mRNA12"
			if {$mRNA12 != ""} { 
			    #Espionne "un NM=$mRNA12 correspond a access $ChaqueNM2"
			    set ListmRNA12 [split $mRNA12 " "]
			    foreach ChaqmRNA12 $ListmRNA12 {
				set GenreChaqmRNA12 [OrgDuNmOuGb $ChaqmRNA12]
				#Espionne "$ChaqmRNA12 $GenreChaqmRNA12"
				if {[regexp {^Mus} $GenreChaqmRNA12]} { 
				    #Espionne "ChaqmRNA12 $ChaqmRNA12"
				    LConcat LesNMsDeLaLigne $ChaqmRNA12
				}
			    }
			}
		    }
		}
	    }
	}
	#Espionne "GN2 $GN"
	set Commande1 "getz \"\(\(\\\[refseq-Gene:$GN\\\] > parent\) \& \\\[refseq-Organism:mus musculus\\\]\)\" \-f acc"
	set GetzOut1 [eval exec $Commande1]
	set LesLignes1 [split $GetzOut1 "\n"]
	foreach Ligne1 $LesLignes1 {
	    #Espionne "Ligne1 $Ligne1"
	    if {![regexp {^ACCESSION} $Ligne1]} {
		continue
	    } else {
		scan $Ligne1 "%s %s" bidon Acc1
		if {[regexp {^NW} $Acc1] || [regexp {^NT} $Acc1] || [regexp {^NC} $Acc1]} {
		    continue
		} else {
		    #Espionne "Acc1 $Acc1"
		    LConcat LesNMsDeLaLigne $Acc1
		}
	    }
	}
	#Espionne "GN3 $GN"
	set Commande2 "getz \"\(\(\\\[genbankfull-Gene:$GN\\\] > parent\) \& \\\[genbankfull-Organism:mus musculus\\\]\)\" \-f acc"
	set GetzOut2 [eval exec $Commande2]
	set LesLignes2 [split $GetzOut2 "\n"]
	foreach Ligne2 $LesLignes2 {
	    #Espionne "Ligne2 $Ligne2"
	    if {![regexp {^ACCESSION} $Ligne2]} {
		continue
	    } else {
		scan $Ligne2 "%s %s" bidon Acc2
		#Espionne "Acc2 $Acc2"
		LConcat LesNMsDeLaLigne $Acc2
		set mRNA [MrnaRefseqUcscMouse $Acc2 "Nm"]
		if {$mRNA != ""} { 
		    #Espionne "un NM=$mRNA correspond a access $Acc2"
		    set ListmRNA [split $mRNA " "]
		    foreach ChaqmRNA $ListmRNA {
			set GenreChaqmRNA [OrgDuNmOuGb $ChaqmRNA]
			#Espionne "$ChaqmRNA $GenreChaqmRNA"
			if {[regexp {^Mus} $GenreChaqmRNA]} { 
			    #Espionne "ChaqmRNA $ChaqmRNA"
			    LConcat LesNMsDeLaLigne $ChaqmRNA
			}
		    }
		} 
	    }
	}
    }
    set LesNMsDeLaLigne [ListeSansDoublon $LesNMsDeLaLigne]
    #Espionne $LesNMsDeLaLigne
    #set LesNMsDeLaLigne [join $LesNMsDeLaLigne " "]
    return $LesNMsDeLaLigne


}

proc AttriDesAcDnaParGeneName2 {} {


    set LesLignes [NomLigne ListeDes Lignes]
    foreach Ligne $LesLignes {
	set TousLesNoms  [NomLigne $Ligne Noms]
	set ListeDesNoms [split $TousLesNoms " "]
	foreach Nom $ListeDesNoms {
	    set Fichier "[RepertoireDuGenome]/nuctfa/$Nom"
	    set LesLignes [LesLignesDuFichier $Fichier]
	    set premiereligne [lindex $LesLignes 0]
	    if {[regexp "bidon" $premiereligne]} {
		regsub "EVI" $Nom "" NomSsEvi
		set LesElmts [split $NomSsEvi ""]
		set NomSsEvi [string range $NomSsEvi 0 end-1]
		if {[lindex $LesElmts 0]=="0"} {
		    set NomSsEvi [string range $NomSsEvi 1 end]
		}
		lappend LesLignesBidons $NomSsEvi
	    }
	}
    }
    Espionne "$LesLignesBidons"

    foreach Ligne $LesLignesBidons {
	Espionne ""
	Espionne "$Ligne"
	set DescriC [RetChip5 $Ligne "description_customer"]
	set DescriM [RetChip5 $Ligne "description_memorec"]
	set LesNMsDeLaLigne {}
	set LesGeneNames {}
	set DescriMOri $DescriM
	set ListeNm {}; set ListmRNA {}; set ListmRNA1 {}
	set LesLignes1 {}; set LesLignes2 {}
	set LesNMs2 ""; set ListeNm2 {}; set mRNA12 {}; set ListmRNA12 {}
	Espionne "descrimori=$DescriMOri"
    
	set IPF [string first ")" $DescriM]
	if {$IPF>0} {
	    set DescriM [string range $DescriM 0 [incr IPF -1]]
	    regsub -all {[\(\:]} $DescriM " " DescriM
	    regsub -all -nocase { OR } $DescriM " " DescriM
	    set LesGeneNames [LesMotsDeLaLigne $DescriM]
	    set DescriM [string trim $DescriM]
	    Espionne "descrim=$DescriM" 
	}
	scan $DescriC "%s" DescriC
	set DescriC [string trim $DescriC]
	regsub -all {\(} $DescriC "" DescriC
	regsub -all {\)} $DescriC "" DescriC
	Espionne "DescriC= $DescriC"
	set LesDescriC [split $DescriC ","]
	foreach LeDescriC $LesDescriC {
	    lappend LesGeneNames $LeDescriC
	}
	
	if {$LesGeneNames == {} } { 
	    Espionne "pas de genename" 
	    continue
	}
	
	set LesGeneNames [ListeSsElmtVide $LesGeneNames]
	set LesGeneNames [ListeSansDoublon $LesGeneNames NoCase]
	Espionne "lesgenenames=$LesGeneNames"
	
	foreach GN $LesGeneNames {
	    if {[regexp {^Neo} $GN]} {continue}
	    Espionne "GN $GN"
	    set Commande1 "getz \"\(\\\[refseq-AllText:$GN\\\] \& \\\[refseq-Organism:mus musculus\\\]\)\" \-f acc"
	    set GetzOut1 [eval exec $Commande1]
	    Espionne "GetzOut1 $GetzOut1"
	    set LesLignes1 [split $GetzOut1 "\n"]
	    foreach Ligne1 $LesLignes1 {
		#Espionne "Ligne1 $Ligne1"
		if {![regexp {^ACCESSION} $Ligne1]} {
		    continue
		} else {
		    scan $Ligne1 "%s %s" bidon Acc1
		    if {[regexp {^NW} $Acc1] || [regexp {^NT} $Acc1] || [regexp {^NC} $Acc1]} {
			continue
		    } else {
			#Espionne "Acc1 $Acc1"
			LConcat LesNMsDeLaLigne $Acc1
		    }
		}
	    }
	    set Commande2 "getz \"\(\\\[genbankfull-AllText:$GN\\\] \& \\\[genbankfull-Organism:mus musculus\\\]\)\" \-f acc"
	    set GetzOut2 [eval exec $Commande2]
	     Espionne "GetzOut2 $GetzOut2"
	    set LesLignes2 [split $GetzOut2 "\n"]
	    foreach Ligne2 $LesLignes2 {
		#Espionne "Ligne2 $Ligne2"
		if {![regexp {^ACCESSION} $Ligne2]} {
		    continue
		} else {
		    scan $Ligne2 "%s %s" bidon Acc2
		    #Espionne "Acc2 $Acc2"
		    LConcat LesNMsDeLaLigne $Acc2
		    set mRNA [MrnaRefseqUcscMouse $Acc2 "Nm"]
		    if {$mRNA != ""} { 
			Espionne "un NM=$mRNA correspond a access $Acc2"
			set ListmRNA [split $mRNA " "]
			foreach ChaqmRNA $ListmRNA {
			    set GenreChaqmRNA [OrgDuNmOuGb $ChaqmRNA]
			  #  Espionne "$ChaqmRNA $GenreChaqmRNA"
			    if {[regexp {^Mus} $GenreChaqmRNA]} { 
				#Espionne "ChaqmRNA $ChaqmRNA"
				LConcat LesNMsDeLaLigne $ChaqmRNA
			    }
			}
		    } 
		}
	    }
	    Espionne "Chez Homme"
	    set Commande3 "getz \"\(\(\\\[refseq-Gene:$GN\\\] > parent\) \& \\\[refseq-Organism:mus musculus\\\]\)\" \-f acc"
	    set GetzOut3 [eval exec $Commande3]
	    Espionne "GetzOut3 $GetzOut3"
	    
	    set Commande4 "getz \"\(\(\\\[genbankfull-Gene:$GN\\\] > parent\) \& \\\[genbankfull-Organism:mus musculus\\\]\)\" \-f acc"
	    set GetzOut4 [eval exec $Commande4]
	    Espionne "GetzOut4 $GetzOut4"
	    
	    set Commande5 "getz \"\(\\\[refseq-AllText:$GN\\\] \& \\\[refseq-Organism:homo sapiens\\\]\)\" \-f acc"
	    set GetzOut5 [eval exec $Commande5]
	    Espionne "GetzOut5 $GetzOut5"
	    
	    set Commande6 "getz \"\(\\\[genbankfull-AllText:$GN\\\] \& \\\[genbankfull-Organism:homo sapiens\\\]\)\" \-f acc"
	    set GetzOut6 [eval exec $Commande6]
	    Espionne "GetzOut6 $GetzOut6"
	    
	}
	set LesNMsDeLaLigne [ListeSansDoublon $LesNMsDeLaLigne]
	set LesNMsDeLaLigne [join $LesNMsDeLaLigne " "]
	Espionne $LesNMsDeLaLigne
    }


}

proc AttriDesAcDnaParGeneName_AEffacer {DescriC DescriM} {

  
    set LesNMsDeLaLigne {}
    set LesGeneNameMemorec {}
    set DescriMOri $DescriM
   # Espionne "descrimori=$DescriMOri"

    set IPF [string first ")" $DescriM]
    if {$IPF>0} {
	set DescriM [string range $DescriM 0 [incr IPF -1]]
	regsub -all {[\(\:]} $DescriM " " DescriM
	regsub -all -nocase { OR } $DescriM " " DescriM
	set LesGeneNameMemorec [LesMotsDeLaLigne $DescriM]
	#Espionne "descrim=$DescriM" 
	#Espionne "lesgenenamememorec=$LesGeneNameMemorec"
    }
    if {$LesGeneNameMemorec != {}} {
	foreach GN $LesGeneNameMemorec {
	    set LesNMs [RefLinkUcscMouse $GN NM]
	    #puts "++$LesNMs"
	    LConcat LesNMsDeLaLigne $LesNMs
	}
    }
    scan $DescriC "%s" DescriC
    #Espionne "descriC=$DescriC"
    if {$DescriC != ""} {
	set LesNMs [RefLinkUcscMouse $DescriC NM] 
	#puts "--$LesNMs"
	LConcat LesNMsDeLaLigne $LesNMs
    }
    set LesNMsDeLaLigne [ListeSansDoublon $LesNMsDeLaLigne]
    set LesNMsDeLaLigne [join $LesNMsDeLaLigne " "]
    return $LesNMsDeLaLigne


}

proc AttriDesAcDnaParProt {AC} {


    set LesAccDeLaLigne ""
    set IdLu [IdDuProt $AC]
    set Nm [LocUcsc $IdLu]
    #Espionne "$AC $IdLu nm=$Nm"

    if { $Nm=="" } { 
	#Espionne "pas d'accessnm"
	set retour ""
    }

    if { $Nm!="" } {
	set ListNm [split $Nm " "]
	foreach ChaqNm $ListNm {
	    if { [regexp {^NM_} $ChaqNm] || [regexp {^XM_} $ChaqNm] || [regexp {^NR_} $ChaqNm] } {
		#Espionne "cet acc=$ChaqNm a deja un numero nm"
		set GenreChaqNm [OrgDuNmOuGb $ChaqNm]
		#Espionne "GenreChaqNm= $GenreChaqNm"
		if {[regexp {^Mus} $GenreChaqNm]} { 
		    #Espionne "ChaqNm $ChaqNm"
		    LConcat LesAccDeLaLigne $ChaqNm 
		}
	    } else {
		#Espionne "chaqnm=$ChaqNm"
		LConcat LesAccDeLaLigne $ChaqNm
		set mRNA [MrnaRefseqUcscMouse $ChaqNm "Nm"]
		if {$mRNA != ""} { 
		    #Espionne "un NM=$mRNA correspond a access $ChaqNm"
		    set ListmRNA [split $mRNA " "]
		    foreach ChaqmRNA $ListmRNA {
			set GenreChaqmRNA [OrgDuNmOuGb $ChaqmRNA]
			if {[regexp {^Mus} $GenreChaqmRNA]} { 
			    #Espionne "ChaqmRNA $ChaqmRNA"
			    LConcat LesAccDeLaLigne $ChaqmRNA 
			}
		    }
		}
	    }
	}
	set LesAccDeLaLigne [ListeSansDoublon $LesAccDeLaLigne]
	set LesAccDeLaLigne [join $LesAccDeLaLigne " "]
	set retour $LesAccDeLaLigne
    }
    return $retour


}

proc AttriDesAcDnaParProt_AEffacer {AC} {


    #puts "acess=$AC"
    set IdLu [IdDuProt $AC]
    #puts "idlu=$IdLu"
    set Nm [LocUcsc $IdLu]
    #puts "nm=$Nm"

    if { $Nm=="" } { 
	#puts "pas d'accessnm"
	set retour ""
    }

    if { $Nm!="" } {
	set ListNm [split $Nm " "]
	foreach ChaqNm $ListNm {
	    if { [regexp {^NM_} $ChaqNm] } {
		#puts "cet acc=$ChaqNm a deja un numero nm"
		LConcat LesAccDeLaLigne $ChaqNm
	    } else {
		#puts "chaqnm=$ChaqNm"
		LConcat LesAccDeLaLigne $ChaqNm
		set mRNA [MrnaRefseqUcscMouse $ChaqNm "Nm"]
		if {$mRNA != ""} { 
		    #puts "un NM=$mRNA correspond a access $ChaqNm"
		    set ListmRNA [split $mRNA " "]
		    foreach ChaqmRNA $ListmRNA {
			LConcat LesAccDeLaLigne $ChaqmRNA
		    }
		}
	    }
	}
	set LesAccDeLaLigne [ListeSansDoublon $LesAccDeLaLigne]
	set LesAccDeLaLigne [join $LesAccDeLaLigne " "]
	set retour $LesAccDeLaLigne
    }
    return $retour


}

proc AttriDesAcDna_AEffacer {} {


    set A 0
    set B 0
    set C 0
    set Pr 0
    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "DNA_acc"]
	set Ac2 [RetChip2 $I "refseq_PIQOR"]
	set Ac3 [RetChip2 $I "prot_acc"]
	set Ac4 [RetChip2 $I "prot_acc_PIQOR"]

	set jaitrouve 0 
	set genenamefait 0
	set AccDna ""
	set LAccDna {}
	set LesAccDna {}

	if { [regexp {^RA[0-9]+} $Des1] } { continue }
	if { [regexp {\?} $Ac1] } { continue }
	

	if { $Ac1!="" } {
	    incr A
	    puts "ligne $I Ac1=$Ac1 Ac2=$Ac2 =>$A"

	    if {$Ac2==""} {
		incr B
		
		set Genre [OrgDuNmOuGb $Ac1]
		
		if {[regexp {^Mus$} $Genre]} {
		    if { ![regexp {^NM_} $Ac1] } {
			set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			if { $NM != "" } {
			    puts "pour $I, prend Ac1=$Ac1 et NM=$NM (A)"
			} else { puts "pour $I, prend Ac1=$Ac1 (Abis)" }
		    } else { puts "pour $I, prend Ac1=$Ac1 (B)" }
		}
		
		if {[regexp {^Homo$} $Genre]} {
		    incr Pr
		    puts "pour ligne $I, travail sur prot Ac3=$Ac3 Ac4=$Ac4=>$Pr (C)"
		    
		    if { [regexp "," $Ac3] } {puts "attention le prog ne prend pas en compte ce cas"}

		    set GenreP3 [OrgDuProt [string trim $Ac3]]
		    
		    if { $GenreP3 == "" } { 
			#jamais ce cas
			puts "pls=>ligne=$I Acc=$Ac3 Id=attention PAS FICHESpls\n"
			if {$Ac4 == ""} { puts "dois prendre la def" }
			if {$Ac4 != ""} { puts "dois prendre prot_acc_piqor"} 
			continue 
		    }
		    
		    if {[regexp {^Homo} $GenreP3]} {
			if {$Ac4!=""} {
			    #cherche nm de prot_acc_piqor
			    if { [regexp "," $Ac4] } {puts "attention2 le prog ne prend pas en compte ce cas"}
			    set ListeAc4 [split $Ac4 ","]
			    foreach ChaqueAc4 $ListeAc4 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc4]
				if {$AccDna!=""} { 
				    puts "pour $I, prend accdna=$AccDna (D)"
				    set LAccDna [split $AccDna " "]
				    foreach Q $LAccDna {LConcat LesAccDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc4] 
				    if {$AccDna!=""} { 
					puts "pour $I, prend accdna=$AccDna (E)"
					set LAccDna [split $AccDna " "]
					foreach S $LAccDna {LConcat LesAccDna $S} 
				    }
				}
			    }
			    set LesAccDna [lsort -unique $LesAccDna]
			    set LesAccDna [join $LesAccDna " "]
			    puts "pour $I, prend accdna=$LesAccDna (Ebis)"
			} else {
			    set genenamefait 1
			    #voir avec la def
			    set AccDna [AttriDesAcDnaParGeneName $Des1 $Des2]
			    if {$AccDna!=""} { puts "pour $I, prend accdna=$AccDna (F)" }
			}
			if {$genenamefait == 0 && $AccDna == ""} {
			    set AccDna [AttriDesAcDnaParGeneName $Des1 $Des2]
			    if {$AccDna!=""} { puts "pour $I, prend accdna=$AccDna (G)" }
			}
			if {$AccDna == ""} {
			    puts "pas d'acccess"
			    lappend LesLignesPauvres $I
			}
		    }

		    if {[regexp {^Mus} $GenreP3]} {
			if {$Ac4!=""} {
			    #jamais ce cas
			    set AccsProt "$Ac3,$Ac4"
			    puts "acess prot=$AccsProt"
			    set ListeAccsProt [split $AccsProt ","]
			    foreach ChaqueAccProt $ListeAccsProt {
				#recupere nm
				set AccDna [AttriDesAcDnaParProt $ChaqueAccProt]
				if {$AccDna!=""} {
				    puts "chaqueaccprot=$ChaqueAccProt a acc dna $AccDna (H)"
				    set LAccDna [split $AccDna " "]
				    foreach Q $LAccDna {LConcat LesAccDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAccProt] 
				    if {$AccDna!=""} { 
					puts "pour $I, prend accdna=$AccDna (I)" 
					set LAccDna [split $AccDna " "]
					foreach S $LAccDna {LConcat LesAccDna $S} 
				    }
				}
			    } 
			    set LesAccDna [lsort -unique $LesAccDna]
			    set LesAccDna [join $LesAccDna " "]
			    puts "pour $I, prend accdna=$LesAccDna (Ibis)"
			} else {
			    #recupere que prot_acc 
			    set AccDna [AttriDesAcDnaParProt $Ac3]
			    if {$AccDna!=""} { 
				puts "pour $I, prend accdna=$AccDna (J)" 
				set LAccDna [split $AccDna " "]
				foreach Q $LAccDna {LConcat LesAccDna $Q} 
			    }
			    if {$AccDna==""} {  
				set AccDna [AttriDesAcDnaParGb $Ac3] 
				if {$AccDna!=""} { 
				    puts "pour $I, prend accdna=$AccDna (K)" 
				    set LAccDna [split $AccDna " "]
				    foreach S $LAccDna {LConcat LesAccDna $S}  
				}
			    }
			    set LesAccDna [lsort -unique $LesAccDna]
			    set LesAccDna [join $LesAccDna " "]
			    puts "pour $I, prend accdna=$LesAccDna (Kbis)"
			}
			if {$AccDna == ""} {
			    set AccDna [AttriDesAcDnaParGeneName $Des1 $Des2]
			    if {$AccDna!=""} { puts "pour $I, prend accdna=$AccDna (L)" }
			}
			if {$AccDna == ""} {
			    puts "pas d'access"
			    lappend LesLignesPauvres $I
			}
		    }
		}
	    }

	    if {$Ac2!=""} {
		incr C

		if { $Ac1==$Ac2 } {
		    puts "pour $I, prend refseq=$Ac2 (meme numero dans DNA_acc et refseq)(1)"
		    set jaitrouve 1
		}
		if { $jaitrouve == 0 && [regexp {.\,.} $Ac2] } {
		    set LesNMs [split $Ac2 ","]
		    foreach LeNM $LesNMs { 
			if { $LeNM==$Ac1 } { 
			    puts "pour $I, prend refseq=$Ac2 (meme numero dans DNA_acc et refseq)(2)"
			    set jaitrouve 1
			}
		    }
		}

		if { $jaitrouve==0 } {

		    set Genre [OrgDuNmOuGb $Ac1]

		    if {[regexp {^Mus$} $Genre]} {
			if { ![regexp {^NM_} $Ac1] } {
			    set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			    if { $NM != "" } {
				puts "pour $I, prend Ac1=$Ac1 et Ac2=$Ac2 et NM=$NM (3)"
				set ListeAc2 [split $Ac2 ","]
				set ListeNM [split $NM " "]
				set Tout [concat $ListeAc2 $ListeNM]
				set Tout [lsort -unique $Tout]
				puts "pour $I, prend Ac1=$Ac1 et Ac2+NM=$Tout (3bis)"
			    } else { puts "pour $I, prend Ac1=$Ac1 et Ac2=$Ac2 (4)" }
			} else { puts "pour $I, prend Ac1=$Ac1 et Ac2=$Ac2 (5)" }
		    }

		    if {[regexp {^Homo$} $Genre]} {
			puts "pour $I, prend que refseq=$Ac2 (6)"
		    }
		}
	    }
	}
    }
    foreach LignePauvre $LesLignesPauvres { puts "lignepauvre=$LignePauvre" }
    set nbdepauvre [llength $LesLignesPauvres]
    Espionne "nbdepauvre=$nbdepauvre"
    Espionne "$Pr=nb de ligne ou on se sert de la prot"
    Espionne "$A=nb de ligne ac dna_acc"
    Espionne "$B=nb de ligne ac dna_acc et ss refseq_piqor"
    Espionne "$C=nb de ligne ac dna_acc et ac refseq_piqor"


}

proc AttriDesSsDnaAcProt {} {


#pour prot_acc_piqor tous sont souris
    set W 0; set K 0; set J 0
    set pauv 0
    set accpauv 0
    set mixte 0
    set refseq 0
    set genbank 0
    set vraimentpauv 0
    set F 0

    foreach I [RetChip5 ListOf Index] { 
	set Des1 [RetChip5 $I "description_customer"]
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1 [RetChip5 $I "refseq_PIQOR"]
	set Ac2 [RetChip5 $I "DNA_acc"]
	set Ac3 [RetChip5 $I "prot_acc_PIQOR"]
	set Ac4 [RetChip5 $I "prot_acc"]

	set jaitrouvemixte 0
	set ListProt {}
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set G 0
	set pastrouveprtsaccprot 0

	if {$Ac1=="" && $Ac2==""} {

	    if {$Ac3!="" && $Ac4!=""} { 
		set Ac "$Ac3,$Ac4"
		set ListProt [split $Ac ","]
		set ListProt [lsort -unique $ListProt]
		foreach Prot $ListProt {
		    set IdLu1 [IdDuProt $Prot]
		    set NM [LocUcsc $IdLu1]
		    LConcat LesIdsDeLaLigne $IdLu1
		    LConcat LesNmsDeLaLigne $NM  
		}
		set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
		set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
		puts "2col=>ligne=$I Accs=$Ac3 et $Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne"
		continue
	    }

	    if {$Ac3!=""} {		
		incr W
		Espionne "\n$Ac3 de la ligne $I (col prot_acc_piqor)=>$W"
		if {[regexp "," $Ac3]} {incr K} else {incr J}
		set SesAcs [split $Ac3 ","]
		foreach Ac $SesAcs {
		    set IdLu2 ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
		    set IdLu2 [IdDuProt $Ac]
		    LConcat LesIdsDeLaLigne $IdLu2
		    if {$IdLu2 == ""} { 
			puts "ligne=$I Acc=$Ac3 Id=PAS FICHES" 
			set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
			LConcat LesNmsDeLaLigne $NM 
			LConcat LesmRNADeLaLigne $mRNA
			LConcat LesAcsGbDeLaLigne $AcGb	
			LConcat LesmRNAGbDeLaLigne $mRNAGb
			continue
		    }
		    set NM [LocUcsc $IdLu2]
		    if {$NM!=""} {
			set ListNM [split $NM " "]
			foreach ChaqNM $ListNM {
			    LConcat LesNmsDeLaLigne $ChaqNM 
			    if { ![regexp {^NM_} $ChaqNM] } { 
				set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
				if {$mRNA != ""} { 
				    puts "un NM=$mRNA correspond a access chaqnm=$ChaqNM"
				    set ListemRNA [split $mRNA " "]
				    foreach ChaqmRNA $ListemRNA {
					LConcat LesmRNADeLaLigne $ChaqmRNA
				    }	
				}
			    }
			}
		    } 
		    if {$NM==""} {
			set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
			set GetzOut [eval exec $Commande]
			if {$GetzOut == ""} { 
			    puts "ligne=$I Acc=$Ac getzout=vide pas fiche ou pas mrna" 
			}
			if {$GetzOut != ""} {
			    incr G; incr F
			    puts "ligne=$I Acc=$Ac3 getzout=$GetzOut"
			    set LesLignesDeGetzOut [split $GetzOut "\n"]
	    		    foreach LigneDeGetzOut $LesLignesDeGetzOut {
				set Ref ""
				set AcGb ""
				scan $LigneDeGetzOut "%s %s" Ref AcGb
				puts "acgb=$AcGb"
				LConcat LesAcsGbDeLaLigne $AcGb	
				set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
				if {$mRNAGb != ""} { 
				    puts "un NM=$mRNAGb correspond a access AcGb=$AcGb" 
				    set ListemRNAGb [split $mRNAGb " "]
				    foreach ChaqmRNAGb $ListemRNAGb {
					LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				    }
				} 
			    }
			}
		    }
		    if { $NM=="" && $AcGb=="" } {
			incr accpauv
			puts "cet access_prot n'a pas d'access_mrna" 
			lappend LesAccsPauvres $Ac
		    }
		}
		
		if { [llength $SesAcs] != [llength $LesIdsDeLaLigne] } { 
		    puts "tous les access n'ont pas d'ID"
		    #ok 
		}
		if { $LesNmsDeLaLigne != {} && [llength $LesIdsDeLaLigne] > [llength $LesNmsDeLaLigne] } {
		    puts "attention certn id correspondent pas a un nm"
		    #ok
		}
		if { $LesNmsDeLaLigne == {} && $LesAcsGbDeLaLigne != {} &&  [llength $SesAcs] > [llength $LesAcsGbDeLaLigne] } {
		    set pastrouveprtsaccprot 1
		    #ligne 507
		    puts "attention certn acc_prot correspondent pas a un gb"
		}
 
		set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
		set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
		set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
		set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
		set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]

		if { [llength $LesIdsDeLaLigne] > 1 } { puts "plus d'un id" }

		if { $LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {} } {
		    incr mixte
		    set jaitrouvemixte 1 
		    if { $LesmRNADeLaLigne != {} || $LesmRNAGbDeLaLigne !={} } {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne" 
			puts "acgb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne"
		    } else {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne AcGb=$LesAcsGbDeLaLigne"
		    } 
		}

		if { ! $jaitrouvemixte && $LesNmsDeLaLigne != {} } {
		    incr refseq
		    if { $LesmRNADeLaLigne != {} } {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne"
		    } else {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne"
		    }
		}

		if { ! $jaitrouvemixte && $LesAcsGbDeLaLigne != {} } {
		    incr genbank
		    if { $pastrouveprtsaccprot } {
			set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			if { $LesAcsParGNDeLaLigne=={} } {
			    if {$LesmRNAGbDeLaLigne !={}} {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (1)"
			    } else {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne (2)"
			    }
			}
			if { $LesAcsParGNDeLaLigne!={} } {
			    if {$LesmRNAGbDeLaLigne !={}} {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (3)"
			    } else {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (4)"
			    }
			}
		    }
		    if { ! $pastrouveprtsaccprot } {
			if {$LesmRNAGbDeLaLigne !={}} {
			    puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (5)"
			} else {
			    puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne (6)"
			}
		    }
		}

		if { $LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={} } {
		    incr pauv
		    puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne pas d'access"
		    lappend LesLignesPauvres "ligne=$I access=$Ac3"

		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			incr vraimentpauv
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne vraiment pas d'access"
			lappend LesLignesVraimentPauvres "ligne=$I access=$Ac3"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne"
		    }
		}
	    }
	}
    }
    Espionne "\n$W=nombre de lignes avec access prot ds col prot_acc_piqor"
    Espionne "$K=nombre qui ont pls access ds col prot_acc_piqor"
    Espionne "$J=nombre qui ont un access ds col prot_acc_piqor\n"

    Espionne "$accpauv=nb d'acc_prot sans access_mrna"
    Espionne "$mixte=nb de lignes ac mrna_refseq et ac mrna_genbank"
    Espionne "$refseq=nb de lignes ac mrna_refseq"
    Espionne "$genbank=nb de lignes ac mrna_genbank"
    Espionne "$pauv=nb de lignes ou il y a aucun access_mrna qui correspond"
    Espionne "$vraimentpauv=nb de lignes ou il y a vraiment pas d'access_mrna\n"

    foreach x $LesLignesPauvres {puts "x=$x"}
    foreach y $LesLignesVraimentPauvres {puts "y=$y"}


}

proc AttriDesSsDnaAcProt2 {} {


#pour prot_acc dois prendre en compte que les souris
    set W 0
    set K 0
    set J 0
    set A 0
    set B 0
    set Z 0
    set accpauv 0
    set mixte 0
    set refseq 0
    set genbank 0
    set pauv 0
    set vraimentpauv 0
    set pauvSsSouris 0
    set vraimentpauvSsSouris 0

    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "refseq_PIQOR"]
	set Ac2 [RetChip2 $I "DNA_acc"]
	set Ac4 [RetChip2 $I "prot_acc"]

	if { [regexp {^RA[0-9]+} $Des1] } { continue }
	if { [regexp {\?} $Ac4] } { continue }

	set jaitrouvemixte 0
	set pls 0
	set PasSouris 0
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set cont 0
	set LigneQueSouris 0
	set PauvSsSouris 0
	set SsFicheProt 0
	set dejafait1 0
	set dejafait2 0
	set vide 0

	if {$Ac1=="" && $Ac2==""} {

	    if {$Ac4!=""} {		
		incr W
		Espionne "\n$Ac4 de la ligne $I (col prot_acc)=>$W"

		if { [regexp "," $Ac4] } {
		    set pls 1 
		    incr K
		} else { 
		    incr J 
		}
		
		set SesAcs [split $Ac4 ","]
		foreach Ac $SesAcs {
		    set GenreLu ""; set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
		    set GenreLu [OrgDuProt $Ac]
		    if { $GenreLu == "" } { 
			puts "ligne=$I Acc=$Ac Id=PAS FICHES PROT"
			set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
			LConcat LesIdsDeLaLigne $IdLu
			LConcat LesNmsDeLaLigne $NM 
			LConcat LesmRNADeLaLigne $mRNA
			LConcat LesAcsGbDeLaLigne $AcGb	
			LConcat LesmRNAGbDeLaLigne $mRNAGb
			continue
		    }
		    if { $GenreLu != "" && ![regexp -nocase {^Mus} $GenreLu]} {
			if {! $pls} { 
			    incr Z
			    incr PasSouris
			    puts "$Ac4=pas souris=>$Z"
			    set cont 1; break
			}
			if {$pls} { 
			    incr PasSouris
			    puts "$Ac=pas souris passe suivant=>PasSouris=$PasSouris"
			    continue 
			}
		    }
		    
		    set IdLu [IdDuProt $Ac]
		    LConcat LesIdsDeLaLigne $IdLu
		    set NM [LocUcsc $IdLu]

		    if {$NM!=""} {
			set ListNM [split $NM " "]
			foreach ChaqNM $ListNM {
			    LConcat LesNmsDeLaLigne $ChaqNM 
			    if { ![regexp {^NM_} $ChaqNM] } { 
				set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
				if {$mRNA != ""} { 
				    puts "un NM=$mRNA correspond a access chaqnm=$ChaqNM"
				    set ListemRNA [split $mRNA " "]
				    foreach ChaqmRNA $ListemRNA {
					LConcat LesmRNADeLaLigne $ChaqmRNA
				    }	
				}
			    }
			}
		    } 
		    if {$NM==""} {
			set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
			set GetzOut [eval exec $Commande]
			if {$GetzOut == ""} { 
			    puts "ligne=$I Acc=$Ac getzout=PAS FICHES GB ou pas mrna" 
			}
			if {$GetzOut != ""} {
			    puts "ligne=$I Acc=$Ac getzout=$GetzOut"
			    set LesLignesDeGetzOut [split $GetzOut "\n"]
	    		    foreach LigneDeGetzOut $LesLignesDeGetzOut {
				set Ref ""
				set AcGb ""
				scan $LigneDeGetzOut "%s %s" Ref AcGb
				puts "acgb=$AcGb"
				LConcat LesAcsGbDeLaLigne $AcGb	
				set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
				if {$mRNAGb != ""} { 
				    puts "un NM=$mRNAGb correspond a access AcGb=$AcGb" 
				    set ListemRNAGb [split $mRNAGb " "]
				    foreach ChaqmRNAGb $ListemRNAGb {
					LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				    }
				} 
			    }
			}
		    } 
		    if { $NM=="" && $AcGb=="" } {
			incr accpauv
			puts "cet access_prot n'a pas d'access_mrna"
			lappend LesAccsPauvres $Ac
			if {$pls} {incr vide}
		    }
		}

		if { [llength $SesAcs] == $PasSouris } {
		    puts "la ligne $I a que des access non souris"
		    set LigneQueSouris 1
		}
		if { [expr [llength $SesAcs] - $PasSouris] != [llength $LesIdsDeLaLigne] } { 
		    puts "tous les access n'ont pas d'ID"
		    set SsFicheProt 1
		}
		if { $LesNmsDeLaLigne != {} && [llength $LesIdsDeLaLigne] > [llength $LesNmsDeLaLigne] } {
		    puts "attention certn id ne correspondent pas a un nm"
		    incr A
		}
		if { $LesNmsDeLaLigne == {} && $LesAcsGbDeLaLigne != {} && [llength $SesAcs] > [llength $LesAcsGbDeLaLigne] } {
		    puts "attention certn acc_prot correspondent pas a un gb"
		    incr B
		}

		set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
		set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
		set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
		set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
		set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]
 
		if { [llength $LesIdsDeLaLigne] > 1 } { puts "plus d'un id" }

		if { $LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {} } {
		    incr mixte
		    set jaitrouvemixte 1 
		    if { $LesmRNADeLaLigne != {} || $LesmRNAGbDeLaLigne !={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne" 
			puts "acgb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (1)"
		    } else {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne AcGb=$LesAcsGbDeLaLigne (2)"
		    } 
		}

		if { ! $jaitrouvemixte && $LesNmsDeLaLigne != {} } {
		    incr refseq
		    if { $LesmRNADeLaLigne != {} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne (3)"
		    } else {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne (4)"
		    }
		}

		if { ! $jaitrouvemixte && $LesAcsGbDeLaLigne != {} } {
		    incr genbank
		    if {$LesmRNAGbDeLaLigne !={}} {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (5)"
		    } else {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne (6)"
		    }
		}

		if { $cont || $LigneQueSouris } {
		    set dejafait1 1
		    incr pauvSsSouris
		    puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'access souris (8)"
		    lappend LesLignesSsSouris "ligne=$I access=$Ac4"

		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			incr vraimentpauvSsSouris
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne vraiment pas d'access souris (8b)"
			lappend LesLignesVraimentSsSouris "ligne=$I access=$Ac4"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (8t)"
		    }
		}

		if { $LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={} } {
		    set dejafait2 1
		    incr pauv
		    puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'access (7)"
		    lappend LesLignesPauvres "ligne=$I access=$Ac4"

		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			incr vraimentpauv
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne vraiment pas d'access (7b)"
			lappend LesLignesVraimentPauvres "ligne=$I access=$Ac4"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (7t)"
		    }
		}

		if { !$dejafait1 && !$dejafait2 && $SsFicheProt } {
		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'autres infos pr cette ligne (9)"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (9b)"
		    }
		}

		if { !$dejafait1 && !$dejafait2 && !$SsFicheProt && $vide>0 } {
		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'autres infos pr cette ligne (10)"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (10b)"
		    }
		}
	    }
	}
    }
    Espionne "\n$W=nombre de lignes avec access prot ds col prot_acc"
    Espionne "$K=nombre qui ont pls access ds col prot_acc"
    Espionne "$J=nombre qui ont un access ds col prot_acc\n"

    Espionne "$Z=nombre de lignes avec UN access prot non souris"
    Espionne "$A=nombre de lignes ou certn id ne correspondent pas a un nm"
    Espionne "$B=nombre de lignes ou certn acc_prot na correspondent pas a un gb\n"

    Espionne "$accpauv=nb d'acc_prot sans access_mrna"
    Espionne "$mixte=nb de lignes ac mrna_refseq et ac mrna_genbank"
    Espionne "$refseq=nb de lignes ac mrna_refseq"
    Espionne "$genbank=nb de lignes ac mrna_genbank"
    Espionne "$pauv=nb de lignes ou il y a aucun access_mrna qui correspond"
    Espionne "$vraimentpauv=nb de lignes ou il y a vraiment pas d'access_mrna\n"
    foreach x $LesLignesPauvres {puts "x=$x"}
    foreach y $LesLignesVraimentPauvres {puts "y=$y"}
    Espionne "$pauvSsSouris=nb de lignes sans access souris"
    Espionne "$vraimentpauvSsSouris=nb de lignes ou il y a vraiment pas d'access souris"
    foreach v $LesLignesSsSouris {puts "v=$v"}
    foreach w $LesLignesVraimentSsSouris {puts "w=$w"}


}

proc AttriDesSsDnaAcProt2_AEffacer {} {


#pour prot_acc dois prendre en compte que les souris
    set W 0
    set K 0
    set J 0
    set A 0
    set B 0
    set Z 0
    set accpauv 0
    set mixte 0
    set refseq 0
    set genbank 0
    set pauv 0
    set vraimentpauv 0
    set pauvSsSouris 0
    set vraimentpauvSsSouris 0

    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "refseq_PIQOR"]
	set Ac2 [RetChip2 $I "DNA_acc"]
	set Ac4 [RetChip2 $I "prot_acc"]

	if { [regexp {^RA[0-9]+} $Des1] } { continue }
	if { [regexp {\?} $Ac4] } { continue }

	set jaitrouvemixte 0
	set pls 0
	set PasSouris 0
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set cont 0
	set LigneQueSouris 0
	set PauvSsSouris 0
	set SsFicheProt 0
	set dejafait1 0
	set dejafait2 0
	set vide 0

	if {$Ac1=="" && $Ac2==""} {

	    if {$Ac4!=""} {		
		incr W
		Espionne "\n$Ac4 de la ligne $I (col prot_acc)=>$W"

		if { [regexp "," $Ac4] } {
		    set pls 1 
		    incr K
		} else { 
		    incr J 
		}
		
		set SesAcs [split $Ac4 ","]
		foreach Ac $SesAcs {
		    set GenreLu ""
		    set IdLu ""
		    set NM ""
		    set mRNA ""
		    set AcGb ""
		    set mRNAGb ""

		    set GenreLu [OrgDuProt $Ac]

		    if { $GenreLu == "" } { 
			puts "ligne=$I Acc=$Ac Id=PAS FICHES PROT"
			set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
			LConcat LesIdsDeLaLigne $IdLu
			LConcat LesNmsDeLaLigne $NM 
			LConcat LesmRNADeLaLigne $mRNA
			LConcat LesAcsGbDeLaLigne $AcGb	
			LConcat LesmRNAGbDeLaLigne $mRNAGb
			continue
		    }
		    if { $GenreLu != "" && ![regexp -nocase {^Mus} $GenreLu]} {
			if {! $pls} { 
			    incr Z
			    incr PasSouris
			    puts "$Ac4=pas souris=>$Z"
			    set cont 1; break
			}
			if {$pls} { 
			    incr PasSouris
			    puts "$Ac=pas souris passe suivant=>PasSouris=$PasSouris"
			    continue 
			}
		    }
		    
		    set IdLu [IdDuProt $Ac]
		    LConcat LesIdsDeLaLigne $IdLu
		    set NM [LocUcsc $IdLu]

		    if {$NM!=""} {
			set ListNM [split $NM " "]
			foreach ChaqNM $ListNM {
			    LConcat LesNmsDeLaLigne $ChaqNM 
			    if { ![regexp {^NM_} $ChaqNM] } { 
				set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
				if {$mRNA != ""} { 
				    puts "un NM=$mRNA correspond a access chaqnm=$ChaqNM"
				    set ListemRNA [split $mRNA " "]
				    foreach ChaqmRNA $ListemRNA {
					LConcat LesmRNADeLaLigne $ChaqmRNA
				    }	
				}
			    }
			}
		    } 
		    if {$NM==""} {
			set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
			set GetzOut [eval exec $Commande]
			if {$GetzOut == ""} { 
			    puts "ligne=$I Acc=$Ac getzout=PAS FICHES GB ou pas mrna" 
			}
			if {$GetzOut != ""} {
			    puts "ligne=$I Acc=$Ac getzout=$GetzOut"
			    set LesLignesDeGetzOut [split $GetzOut "\n"]
	    		    foreach LigneDeGetzOut $LesLignesDeGetzOut {
				set Ref ""
				set AcGb ""
				scan $LigneDeGetzOut "%s %s" Ref AcGb
				puts "acgb=$AcGb"
				LConcat LesAcsGbDeLaLigne $AcGb	
				set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
				if {$mRNAGb != ""} { 
				    puts "un NM=$mRNAGb correspond a access AcGb=$AcGb" 
				    set ListemRNAGb [split $mRNAGb " "]
				    foreach ChaqmRNAGb $ListemRNAGb {
					LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				    }
				} 
			    }
			}
		    } 
		    if { $NM=="" && $AcGb=="" } {
			incr accpauv
			puts "cet access_prot n'a pas d'access_mrna"
			lappend LesAccsPauvres $Ac
			if {$pls} {incr vide}
		    }
		}

		if { [llength $SesAcs] == $PasSouris } {
		    puts "la ligne $I a que des access non souris"
		    set LigneQueSouris 1
		}
		if { [expr [llength $SesAcs] - $PasSouris] != [llength $LesIdsDeLaLigne] } { 
		    puts "tous les access n'ont pas d'ID"
		    set SsFicheProt 1
		}
		if { $LesNmsDeLaLigne != {} && [llength $LesIdsDeLaLigne] > [llength $LesNmsDeLaLigne] } {
		    puts "attention certn id ne correspondent pas a un nm"
		    incr A
		}
		if { $LesNmsDeLaLigne == {} && $LesAcsGbDeLaLigne != {} && [llength $SesAcs] > [llength $LesAcsGbDeLaLigne] } {
		    puts "attention certn acc_prot correspondent pas a un gb"
		    incr B
		}

		set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
		set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
		set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
		set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
		set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]
 
		if { [llength $LesIdsDeLaLigne] > 1 } { puts "plus d'un id" }

		if { $LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {} } {
		    incr mixte
		    set jaitrouvemixte 1 
		    if { $LesmRNADeLaLigne != {} || $LesmRNAGbDeLaLigne !={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne" 
			puts "acgb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (1)"
		    } else {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne AcGb=$LesAcsGbDeLaLigne (2)"
		    } 
		}

		if { ! $jaitrouvemixte && $LesNmsDeLaLigne != {} } {
		    incr refseq
		    if { $LesmRNADeLaLigne != {} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne (3)"
		    } else {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne (4)"
		    }
		}

		if { ! $jaitrouvemixte && $LesAcsGbDeLaLigne != {} } {
		    incr genbank
		    if {$LesmRNAGbDeLaLigne !={}} {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (5)"
		    } else {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne (6)"
		    }
		}

		if { $cont || $LigneQueSouris } {
		    set dejafait1 1
		    incr pauvSsSouris
		    puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'access souris (8)"
		    lappend LesLignesSsSouris "ligne=$I access=$Ac4"

		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			incr vraimentpauvSsSouris
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne vraiment pas d'access souris (8b)"
			lappend LesLignesVraimentSsSouris "ligne=$I access=$Ac4"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (8t)"
		    }
		}

		if { $LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={} } {
		    set dejafait2 1
		    incr pauv
		    puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'access (7)"
		    lappend LesLignesPauvres "ligne=$I access=$Ac4"

		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			incr vraimentpauv
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne vraiment pas d'access (7b)"
			lappend LesLignesVraimentPauvres "ligne=$I access=$Ac4"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (7t)"
		    }
		}

		if { !$dejafait1 && !$dejafait2 && $SsFicheProt } {
		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'autres infos pr cette ligne (9)"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (9b)"
		    }
		}

		if { !$dejafait1 && !$dejafait2 && !$SsFicheProt && $vide>0 } {
		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne pas d'autres infos pr cette ligne (10)"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac4 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (10b)"
		    }
		}
	    }
	}
    }
    Espionne "\n$W=nombre de lignes avec access prot ds col prot_acc"
    Espionne "$K=nombre qui ont pls access ds col prot_acc"
    Espionne "$J=nombre qui ont un access ds col prot_acc\n"

    Espionne "$Z=nombre de lignes avec UN access prot non souris"
    Espionne "$A=nombre de lignes ou certn id ne correspondent pas a un nm"
    Espionne "$B=nombre de lignes ou certn acc_prot na correspondent pas a un gb\n"

    Espionne "$accpauv=nb d'acc_prot sans access_mrna"
    Espionne "$mixte=nb de lignes ac mrna_refseq et ac mrna_genbank"
    Espionne "$refseq=nb de lignes ac mrna_refseq"
    Espionne "$genbank=nb de lignes ac mrna_genbank"
    Espionne "$pauv=nb de lignes ou il y a aucun access_mrna qui correspond"
    Espionne "$vraimentpauv=nb de lignes ou il y a vraiment pas d'access_mrna\n"
    foreach x $LesLignesPauvres {puts "x=$x"}
    foreach y $LesLignesVraimentPauvres {puts "y=$y"}
    Espionne "$pauvSsSouris=nb de lignes sans access souris"
    Espionne "$vraimentpauvSsSouris=nb de lignes ou il y a vraiment pas d'access souris"
    foreach v $LesLignesSsSouris {puts "v=$v"}
    foreach w $LesLignesVraimentSsSouris {puts "w=$w"}


}

proc AttriDesSsDnaAcProt_AEffacer {} {


#pour prot_acc_piqor tous sont souris
    set W 0
    set K 0
    set J 0
    set pauv 0
    set accpauv 0
    set mixte 0
    set refseq 0
    set genbank 0
    set vraimentpauv 0

    set F 0
    foreach I [RetChip2 ListOf Index] { 
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "refseq_PIQOR"]
	set Ac2 [RetChip2 $I "DNA_acc"]
	set Ac3 [RetChip2 $I "prot_acc_PIQOR"]
	set Ac4 [RetChip2 $I "prot_acc"]

	if { [regexp {^RA[0-9]+} $Des1] } { continue }

	set jaitrouvemixte 0
	set ListProt {}
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set G 0
	set pastrouveprtsaccprot 0

	if {$Ac1=="" && $Ac2==""} {

	    if {$Ac3!="" && $Ac4!=""} { 
		set Ac "$Ac3,$Ac4"
		set ListProt [split $Ac ","]
		set ListProt [lsort -unique $ListProt]
		foreach Prot $ListProt {
		    set IdLu1 [IdDuProt $Prot]
		    set NM [LocUcsc $IdLu1]
		    LConcat LesIdsDeLaLigne $IdLu1
		    LConcat LesNmsDeLaLigne $NM  
		}
		set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
		set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
		#puts "2col=>ligne=$I Accs=$Ac3 et $Ac4 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne"
		continue
	    }

	    if {$Ac3!=""} {		
		incr W
		Espionne "\n$Ac3 de la ligne $I (col prot_acc_piqor)=>$W"
		if {[regexp "," $Ac3]} {
		    incr K
		} else {
		    incr J
		}
		set SesAcs [split $Ac3 ","]
		foreach Ac $SesAcs {
		    set IdLu2 ""
		    set NM ""
		    set mRNA ""
		    set AcGb ""
		    set mRNAGb ""

		    set IdLu2 [IdDuProt $Ac]
		    LConcat LesIdsDeLaLigne $IdLu2
		    if { $IdLu2 == "" } { 
			puts "ligne=$I Acc=$Ac Id=PAS FICHES" 
			set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
			LConcat LesNmsDeLaLigne $NM 
			LConcat LesmRNADeLaLigne $mRNA
			LConcat LesAcsGbDeLaLigne $AcGb	
			LConcat LesmRNAGbDeLaLigne $mRNAGb
			continue
		    }
		    set NM [LocUcsc $IdLu2]
		    if {$NM!=""} {
			set ListNM [split $NM " "]
			foreach ChaqNM $ListNM {
			    LConcat LesNmsDeLaLigne $ChaqNM 
			    if { ![regexp {^NM_} $ChaqNM] } { 
				set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
				if {$mRNA != ""} { 
				    puts "un NM=$mRNA correspond a access chaqnm=$ChaqNM"
				    set ListemRNA [split $mRNA " "]
				    foreach ChaqmRNA $ListemRNA {
					LConcat LesmRNADeLaLigne $ChaqmRNA
				    }	
				}
			    }
			}
		    } 
		    if {$NM==""} {
			set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
			set GetzOut [eval exec $Commande]
			if {$GetzOut == ""} { 
			    puts "ligne=$I Acc=$Ac getzout=vide pas fiche ou pas mrna" 
			}
			if {$GetzOut != ""} {
			    incr G; incr F
			    puts "ligne=$I Acc=$Ac getzout=$GetzOut"
			    set LesLignesDeGetzOut [split $GetzOut "\n"]
	    		    foreach LigneDeGetzOut $LesLignesDeGetzOut {
				set Ref ""
				set AcGb ""
				scan $LigneDeGetzOut "%s %s" Ref AcGb
				puts "acgb=$AcGb"
				LConcat LesAcsGbDeLaLigne $AcGb	
				set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
				if {$mRNAGb != ""} { 
				    puts "un NM=$mRNAGb correspond a access AcGb=$AcGb" 
				    set ListemRNAGb [split $mRNAGb " "]
				    foreach ChaqmRNAGb $ListemRNAGb {
					LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				    }
				} 
			    }
			}
		    }
		    if { $NM=="" && $AcGb=="" } {
			incr accpauv
			puts "cet access_prot n'a pas d'access_mrna" 
			lappend LesAccsPauvres $Ac
		    }
		}
		
		if { [llength $SesAcs] != [llength $LesIdsDeLaLigne] } { 
		    puts "tous les access n'ont pas d'ID"
		    #ok 
		}
		if { $LesNmsDeLaLigne != {} && [llength $LesIdsDeLaLigne] > [llength $LesNmsDeLaLigne] } {
		    puts "attention certn id correspondent pas a un nm"
		    #ok
		}
		if { $LesNmsDeLaLigne == {} && $LesAcsGbDeLaLigne != {} &&  [llength $SesAcs] > [llength $LesAcsGbDeLaLigne] } {
		    set pastrouveprtsaccprot 1
		    #ligne 507
		    puts "attention certn acc_prot correspondent pas a un gb"
		}
 
		set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
		set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
		set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
		set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
		set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]

		if { [llength $LesIdsDeLaLigne] > 1 } { puts "plus d'un id" }

		if { $LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {} } {
		    incr mixte
		    set jaitrouvemixte 1 
		    if { $LesmRNADeLaLigne != {} || $LesmRNAGbDeLaLigne !={} } {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne" 
			puts "acgb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne"
		    } else {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne AcGb=$LesAcsGbDeLaLigne"
		    } 
		}

		if { ! $jaitrouvemixte && $LesNmsDeLaLigne != {} } {
		    incr refseq
		    if { $LesmRNADeLaLigne != {} } {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne mRNA=$LesmRNADeLaLigne"
		    } else {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne NM=$LesNmsDeLaLigne"
		    }
		}

		if { ! $jaitrouvemixte && $LesAcsGbDeLaLigne != {} } {
		    incr genbank
		    if { $pastrouveprtsaccprot } {
			set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			if { $LesAcsParGNDeLaLigne=={} } {
			    if {$LesmRNAGbDeLaLigne !={}} {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (1)"
			    } else {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne (2)"
			    }
			}
			if { $LesAcsParGNDeLaLigne!={} } {
			    if {$LesmRNAGbDeLaLigne !={}} {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (3)"
			    } else {
				puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne AcParGn=$LesAcsParGNDeLaLigne (4)"
			    }
			}
		    }
		    if { ! $pastrouveprtsaccprot } {
			if {$LesmRNAGbDeLaLigne !={}} {
			    puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne mRNAGb=$LesmRNAGbDeLaLigne (5)"
			} else {
			    puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcGb=$LesAcsGbDeLaLigne (6)"
			}
		    }
		}

		if { $LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={} } {
		    incr pauv
		    puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne pas d'access"
		    lappend LesLignesPauvres "ligne=$I access=$Ac3"

		    set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		    if { $LesAcsParGNDeLaLigne=={} } {
			incr vraimentpauv
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne vraiment pas d'access"
			lappend LesLignesVraimentPauvres "ligne=$I access=$Ac3"
		    }
		    if { $LesAcsParGNDeLaLigne!={} } {
			puts "ligne=$I Acc=$Ac3 Id=$LesIdsDeLaLigne AcParGn=$LesAcsParGNDeLaLigne"
		    }
		}
	    }
	}
    }
    Espionne "\n$W=nombre de lignes avec access prot ds col prot_acc_piqor"
    Espionne "$K=nombre qui ont pls access ds col prot_acc_piqor"
    Espionne "$J=nombre qui ont un access ds col prot_acc_piqor\n"

    Espionne "$accpauv=nb d'acc_prot sans access_mrna"
    Espionne "$mixte=nb de lignes ac mrna_refseq et ac mrna_genbank"
    Espionne "$refseq=nb de lignes ac mrna_refseq"
    Espionne "$genbank=nb de lignes ac mrna_genbank"
    Espionne "$pauv=nb de lignes ou il y a aucun access_mrna qui correspond"
    Espionne "$vraimentpauv=nb de lignes ou il y a vraiment pas d'access_mrna\n"

    foreach x $LesLignesPauvres {puts "x=$x"}
    foreach y $LesLignesVraimentPauvres {puts "y=$y"}


}

proc AttriDesSsDnaSsProt {} {


    set LaSortie {}
    set LesVides {}
    #set FichierLigne "[RepertoireDuGenome]/parser/ligssacc2" 
    #ac RA
    set FichierLigne "[RepertoireDuGenome]/parser/ligssacc2ssra"
    #ss RA 
    set LesLignes [LesLignesDuFichier $FichierLigne]
    foreach Ligne $LesLignes {
	Espionne "$Ligne"
#	if {$Ligne != 304 } {continue} 
	set LesNMsDeLaLigne {}
	set LesGeneNameMemorec {}
	set DescriM [RetChip2 $Ligne description_memorec]
	set DescriMOri $DescriM
	set IPF [string first ")" $DescriM]
	#Espionne $IPF
	if {$IPF>0} {
	    set DescriM [string range $DescriM 0 [incr IPF -1]]
	    regsub -all {[\(\:]} $DescriM " " DescriM
	    regsub -all -nocase { OR } $DescriM " " DescriM
	    set LesGeneNameMemorec [LesMotsDeLaLigne $DescriM]
	    #Espionne $DescriM 
	    #Espionne $LesGeneNameMemorec
	}
	if {$LesGeneNameMemorec != {}} {
	    foreach GN $LesGeneNameMemorec {
		set LesNMs [RefLinkUcscMouse $GN NM]
		puts "++$LesNMs"
		LConcat LesNMsDeLaLigne $LesNMs
	    }
	}
	set DescriC [RetChip2 $Ligne description_customer]
	scan $DescriC "%s" DescriC
	Espionne $DescriC
	if {$DescriC != ""} {
	    set LesNMs [RefLinkUcscMouse $DescriC NM] 
	    puts "--$LesNMs"
	    LConcat LesNMsDeLaLigne $LesNMs
	}
	set LesNMsDeLaLigne [ListeSansDoublon $LesNMsDeLaLigne]
	if {$LesNMsDeLaLigne=={}} { lappend LesVides "$Ligne $DescriMOri" ; continue }
	lappend LaSortie "$Ligne [join $LesNMsDeLaLigne " "] $DescriMOri "
    }
    set LongS [llength $LaSortie]
    set LongV [llength $LesVides]
    AfficheVariable [join $LesVides "\n"] "" "Vides"
    AfficheVariable [join $LaSortie "\n"]
    Espionne "longueur de LaSortie = $LongS"
    Espionne "longueur de LesVides = $LongV"
    #pas de puts dans commande dans ce cas


}

proc AttriDesSsDnaSsProt_AEffacer {} {


    set LaSortie {}
    set LesVides {}
    #set FichierLigne "[RepertoireDuGenome]/parser/ligssacc2" 
    #ac RA
    set FichierLigne "[RepertoireDuGenome]/parser/ligssacc2ssra"
    #ss RA 
    set LesLignes [LesLignesDuFichier $FichierLigne]
    foreach Ligne $LesLignes {
	Espionne "$Ligne"
#	if {$Ligne != 304 } {continue} 
	set LesNMsDeLaLigne {}
	set LesGeneNameMemorec {}
	set DescriM [RetChip2 $Ligne description_memorec]
	set DescriMOri $DescriM
	set IPF [string first ")" $DescriM]
	#Espionne $IPF
	if {$IPF>0} {
	    set DescriM [string range $DescriM 0 [incr IPF -1]]
	    regsub -all {[\(\:]} $DescriM " " DescriM
	    regsub -all -nocase { OR } $DescriM " " DescriM
	    set LesGeneNameMemorec [LesMotsDeLaLigne $DescriM]
	    #Espionne $DescriM 
	    #Espionne $LesGeneNameMemorec
	}
	if {$LesGeneNameMemorec != {}} {
	    foreach GN $LesGeneNameMemorec {
		set LesNMs [RefLinkUcscMouse $GN NM]
		puts "++$LesNMs"
		LConcat LesNMsDeLaLigne $LesNMs
	    }
	}
	set DescriC [RetChip2 $Ligne description_customer]
	scan $DescriC "%s" DescriC
	Espionne $DescriC
	if {$DescriC != ""} {
	    set LesNMs [RefLinkUcscMouse $DescriC NM] 
	    puts "--$LesNMs"
	    LConcat LesNMsDeLaLigne $LesNMs
	}
	set LesNMsDeLaLigne [ListeSansDoublon $LesNMsDeLaLigne]
	if {$LesNMsDeLaLigne=={}} { lappend LesVides "$Ligne $DescriMOri" ; continue }
	lappend LaSortie "$Ligne [join $LesNMsDeLaLigne " "] $DescriMOri "
    }
    set LongS [llength $LaSortie]
    set LongV [llength $LesVides]
    AfficheVariable [join $LesVides "\n"] "" "Vides"
    AfficheVariable [join $LaSortie "\n"]
    Espionne "longueur de LaSortie = $LongS"
    Espionne "longueur de LesVides = $LongV"
    #pas de puts dans commande dans ce cas


}

proc AttriTout {} {


    set total 0; set B 0; set C 0; set D 0; set E 0
    set LesLignesPauvres {}

    foreach I [RetChip5 ListOf Index] { 
	incr total
	set Des1 [RetChip5 $I "description_customer"]
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1 [RetChip5 $I "DNA_acc"]
	set Ac2 [RetChip5 $I "refseq_PIQOR"]
	set Ac3 [RetChip5 $I "prot_acc"]
	set Ac4 [RetChip5 $I "prot_acc_PIQOR"]
	set jaitrouvednaacc 0
	set jaitrouve 0
	set jaitrouveRA 0
	set jaitrouvegn 0
	set genenamefait 0
	set jaitrouveprot 0
	set LesGenresP3 {}
	set AccDna ""
	set ListeDesAcs {}
	set LesAcsDna {}

	set LesAcsDeLaLigne ""

	set pls 0
	set PasSouris 0
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set LesAcsParGNDeLaLigne ""
	set LesAcsDeLaLigneList {}
	set cont 0
	set LigneQueSouris 0
	set SsFicheProt 0
	set vide 0
	puts "Ac1 $Ac1 Ac2 $Ac2"
	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	    puts "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	    set LesNMs [split $Ac2 ","]
	    foreach NM $LesNMs { 
		#set Commande "getz \"\(\\\[refseqrelease-acc:$NM\\\]\|\\\[refseqnew-acc:$NM\\\]\)\!\(\\\[refseqnew-acc:$NM\\\]>\\\[refseqrelease-acc:$NM\\\]\)\" \-view FastaSeqs"
		set Commande "getz \"\\\[refseq-acc:$NM\\\]\" \-view FastaSeqs" 
		set GetzOut [eval exec $Commande]
		if {$GetzOut == ""} { puts ">bidon ficherefseqpiqor n'existe plus\natgc" }
		if {$GetzOut != ""} { 
		    set GetzOut [string range $GetzOut [string last ">" $GetzOut] end]
		    if { [regexp {^>ref.+>ref} $GetzOut] } {
			puts "ATTENTION AU - 2 SEQ FASTA"
		    }
		    puts $GetzOut
		}
	    }
	    continue
	}
	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	    set jaitrouvednaacc 1
	    incr C
	    puts "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"

	    if {$Ac2==""} {
		
		set Genre [OrgDuNmOuGb $Ac1]
		
		if {[regexp {^Mus$} $Genre]} {
		    if { ![regexp {^NM_} $Ac1] } {
			set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			if { $NM != "" } {
			    set LesAcsDeLaLigne "$Ac1 $NM"
			} else { 
			    set LesAcsDeLaLigne $Ac1
			}
		    } else { 
			set LesAcsDeLaLigne $Ac1
		    }
		}
		
		if {[regexp {^Homo$} $Genre]} {
		    #travail sur prot Ac3=$Ac3 Ac4=$Ac4
		    
		    set LesAcs3 [split $Ac3 ","]
		    foreach ChaqAc3 $LesAcs3 {
			set GenreAc3 [OrgDuProt $ChaqAc3]
			LConcat LesGenresP3 $GenreAc3
		    }
		    set LesGenresP3 [lsort -unique $LesGenresP3]
		    if { [llength $LesGenresP3] > 1 } { puts "attention ilya pls genres pour cette ligne" }
		    set GenreP3 [join $LesGenresP3 " "]

		    if { $GenreP3 == "" } { 
			#jamais ce cas; je ne le traite pas
			#puts "pls=>ligne=$I Acc=$Ac3 Id=attention PAS FICHESpls\n"
			if {$Ac4 == ""} { puts "dois prendre la def" }
			if {$Ac4 != ""} { puts "dois prendre prot_acc_piqor"} 
			continue 
		    }
		    
		    if {[regexp {^Homo} $GenreP3]} {
			if {$Ac4!=""} {
			    set ListeAc4 [split $Ac4 ","]
			    foreach ChaqueAc4 $ListeAc4 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc4]
				if {$AccDna!=""} {  
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc4]
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach T $ListeDesAcs {LConcat LesAcsDna $T} 
				    }
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set genenamefait 1
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
			if {$genenamefait == 0 && $LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }

		    if {[regexp {^Mus} $GenreP3]} {
			if {$Ac4!=""} {
			    set AccsProt "$Ac3,$Ac4"
			    set ListeAccsProt [split $AccsProt ","]
			    foreach ChaqueAccProt $ListeAccsProt {
				set AccDna [AttriDesAcDnaParProt $ChaqueAccProt]
				if {$AccDna!=""} {
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAccProt] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach S $ListeDesAcs {LConcat LesAcsDna $S} 
				    }
				}
			    } 
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set ListeAc3 [split $Ac3 ","]
			    foreach ChaqueAc3 $ListeAc3 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc3]
				if {$AccDna!=""} { 
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				} 
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc3] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "] 
					foreach S $ListeDesAcs {LConcat LesAcsDna $S}
				    }  
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]
			}
			if {$LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }
		}
	    }

	    if {$Ac2!=""} {

		if { $Ac1==$Ac2 } {
		    set LesAcsDeLaLigne $Ac2
		    set jaitrouve 1
		}
		if { $jaitrouve == 0 && [regexp {.\,.} $Ac2] } {
		    set LesNMs [split $Ac2 ","]
		    foreach LeNM $LesNMs { 
			if { $LeNM==$Ac1 } { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne $Ac2
			    set jaitrouve 1
			    break
			}
		    }
		}

		if { $jaitrouve==0 } {

		    set Genre [OrgDuNmOuGb $Ac1]

		    if {[regexp {^Mus$} $Genre]} {
			if { ![regexp {^NM_} $Ac1] } {
			    set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			    if { $NM != "" } {
				set ListeAc1 [split $Ac1 ","]
				set ListeAc2 [split $Ac2 ","]
				set ListeNM [split $NM " "]
				set Tout [concat $ListeAc1 $ListeAc2 $ListeNM]
				set Tout [ListeSansDoublon $Tout]
				set LesAcsDeLaLigne [join $Tout " "]
			    } else { 
				regsub -all "," $Ac2 " " Ac2
				set LesAcsDeLaLigne "$Ac1 $Ac2"
			    }
			} else { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne "$Ac1 $Ac2"
			}
		    }

		    if {[regexp {^Homo$} $Genre]} {
			regsub -all "," $Ac2 " " Ac2
			set LesAcsDeLaLigne $Ac2
		    }
		}
		#jaitrouve
	    }
	    #refseqpiqorpasvide
	}
	#dnaaccpas vide

	if { $Ac1=="" && $Ac2=="" && ($Ac3!="" || $Ac4!="")} {
	    #Ac3=prot_acc Ac4=prot_acc_piqor
	    incr D
	    set jaitrouveprot 1
	    puts "ligne $I Ac3=$Ac3 Ac4=$Ac4"
	    
	    if { [regexp "," $Ac3] || [regexp "," $Ac4] } {
		set pls 1 
	    }
	    
	    set LesAcs3 [split $Ac3 ","]
	    set LesAcs4 [split $Ac4 ","]
	    set LesAcs3et4 [concat $LesAcs3 $LesAcs4]
	    set SesAcs [split $LesAcs3et4 " "]
	    foreach Ac $SesAcs {
		set GenreLu ""; set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""		
		set GenreLu [OrgDuProt $Ac]
		if { $GenreLu == "" } { 
		    set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
		    LConcat LesIdsDeLaLigne $IdLu
		    LConcat LesNmsDeLaLigne $NM 
		    LConcat LesmRNADeLaLigne $mRNA
		    LConcat LesAcsGbDeLaLigne $AcGb	
		    LConcat LesmRNAGbDeLaLigne $mRNAGb
		    continue
		}
		if { $GenreLu != "" && ![regexp -nocase {^Mus} $GenreLu]} {
		    if {! $pls} { 
			incr PasSouris
			set cont 1; break
		    }
		    if {$pls} { 
			incr PasSouris
			continue 
		    }
		}
		    
		set IdLu [IdDuProt $Ac]
		LConcat LesIdsDeLaLigne $IdLu
		set NM [LocUcsc $IdLu]

		if {$NM!=""} {
		    set ListNM [split $NM " "]
		    foreach ChaqNM $ListNM {
			LConcat LesNmsDeLaLigne $ChaqNM 
			if { ![regexp {^NM_} $ChaqNM] } { 
			    set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
			    if {$mRNA != ""} { 
				set ListemRNA [split $mRNA " "]
				foreach ChaqmRNA $ListemRNA {
				    LConcat LesmRNADeLaLigne $ChaqmRNA
				}	
			    }
			}
		    }
		} 
		if {$NM==""} {
		    set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut != ""} {
			set LesLignesDeGetzOut [split $GetzOut "\n"]
			foreach LigneDeGetzOut $LesLignesDeGetzOut {
			    set Ref ""
			    set AcGb ""
			    scan $LigneDeGetzOut "%s %s" Ref AcGb
			    LConcat LesAcsGbDeLaLigne $AcGb	
			    set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
			    if {$mRNAGb != ""} { 
				set ListemRNAGb [split $mRNAGb " "]
				foreach ChaqmRNAGb $ListemRNAGb {
				    LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				}
			    } 
			}
		    }
		} 
		if { $NM=="" && $AcGb=="" } {
		    if {$pls} {incr vide}
		}
	    }

	    if { [llength $SesAcs] == $PasSouris } {
		set LigneQueSouris 1
	    }
	    if { [expr [llength $SesAcs] - $PasSouris] != [llength $LesIdsDeLaLigne] } { 
		set SsFicheProt 1
	    }

	    set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
	    set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
	    set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
	    set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
	    set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]

	    if { ($cont || $LigneQueSouris) || ($LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={}) || ($SsFicheProt) || ($vide>0) } {
		set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne $LesAcsParGNDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    }

	    if { $LesNmsDeLaLigne != {} || $LesAcsGbDeLaLigne != {} || ($LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {}) } {
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    } 
		
	}

	if {($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && ($Ac3=="" || [regexp {\?} $Ac3]) && $Ac4==""} {
	    puts "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    set jaitrouvegn 1
	    incr E
	    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
	}

	if {$jaitrouvednaacc || $jaitrouveprot || $jaitrouvegn} {
	    if {$LesAcsDeLaLigne != ""} {
		set ListeFinal [split $LesAcsDeLaLigne " "]
		foreach ChaqueFinal $ListeFinal {
		    set GetzOut ""
		    if { [regexp {^NM_} $ChaqueFinal] || [regexp {^NR_} $ChaqueFinal] } {
			set Commande "getz \"\(\\\[refseqrelease-acc:$ChaqueFinal\\\]\|\\\[refseqnew-acc:$ChaqueFinal\\\]\)\!\(\\\[refseqnew-acc:$ChaqueFinal\\\]>\\\[refseqrelease-acc:$ChaqueFinal\\\]\)\" \-view FastaSeqs"
			#set Commande "getz \"\\\[refseq-acc:$ChaqueFinal\\\]\" \-view FastaSeqs" 
			set GetzOut [eval exec $Commande]
			set GetzOut [string range $GetzOut [string last ">r" $GetzOut] end]
			if { [regexp {^>ref.+>ref} $GetzOut] } {
			    puts "ATTENTION AU - 2 SEQ FASTA"
			}
		    }  
		    if { ![regexp {^NM_} $ChaqueFinal] && ![regexp {^NR_} $ChaqueFinal] } {
			set Commande "getz \"\\\[genbankfull-acc:$ChaqueFinal\\\]\" \-view FastaSeqs" 
			set GetzOut [eval exec $Commande]
			if { [regexp {^>gen.+>gen} $GetzOut] } {
			    puts "ATTENTION AU - 2 SEQ FASTA"
			}
		    }
		    if {$GetzOut == ""} { puts ">bidon fichedna n'existe plus\natcg" }
		    if {$GetzOut != ""} { puts $GetzOut }
		}
	    }
	    if {$LesAcsDeLaLigne == ""} {
		puts ">bidon pas d'access\natcg"
		lappend LesLignesPauvres "$I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    }
	}
    }
    #foreach
    set NbPauvres [llength $LesLignesPauvres]
    lappend LesLignesPauvres "$NbPauvres = nb de ligne Pauvres"
    SauveLesLignes $LesLignesPauvres dans [RepertoireDuGenome]/fiches/LesLignesPauvres

    Espionne "$B =nb ac refseq_piqor ms pas dna_acc"
    Espionne "$C =nb ac dna_acc"
    Espionne "$D =nb ac prot"
    Espionne "$E =nb ac rien"


}

proc AttriToutAccess {} {

 
    set A 0; set B 0; set C 0; set D 0; set E 0
    set LesLignesPauvres {}
    foreach I [RetChip2 ListOf Index] {  
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1  [RetChip2 $I "DNA_acc"]
	set Ac2  [RetChip2 $I "refseq_PIQOR"]
	set Ac3  [RetChip2 $I "prot_acc"]
	set Ac4  [RetChip2 $I "prot_acc_PIQOR"]


	set jaitrouvednaacc 0
	set jaitrouve 0
	set jaitrouveRA 0
	set jaitrouvegn 0
	set genenamefait 0
	set jaitrouveprot 0
	set LesGenresP3 {}
	set AccDna ""
	set ListeDesAcs {}
	set LesAcsDna {}

	set LesAcsDeLaLigne ""

	set pls 0
	set PasSouris 0
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set LesAcsParGNDeLaLigne ""
	set LesAcsDeLaLigneList {}
	set cont 0
	set LigneQueSouris 0
	set SsFicheProt 0
	set vide 0

	if { [regexp {^RA[0-9]+} $Des1] } {
	   Espionne "ligne $I Des1=$Des1 Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    incr A
	    set RA1324 ""; set AccmRNA1 ""; set Genre1 ""; set AccmRNA2 ""; set Genre2 ""

	    set Fichier "/genomics/link/Ret1324/fiches/Orf2Cluster2Access2Def2Expression"
	    set LesLignes [LesLignesDuFichier $Fichier]

	    foreach Ligne $LesLignes {
		scan $Ligne "%s %s %s %s" RA1324 x y RA2717
		if {$Des1==$RA2717} {
		    set JaiTrouveCorresEntre1324Et2717 1
		   Espionne "RA1324=$RA1324"

		    if {[file exists "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]} {
			set LAcRa1 [ContenuDuFichier "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]
			scan $LAcRa1 "%s %s %s %s %s" x y AccmRNA1 z Genre1
		    }

		    set Fichier2 "/genomics/link/Ret1324/fiches/AccessDesProteinesEtDesmRNAsChoisis"
		    set LesLignes2 [LesLignesDuFichier $Fichier2]

		    foreach Ligne2 $LesLignes2 {
			scan $Ligne2 "%s %s %s %s" NumRA AccProt AccmRNA Genre
			if {$RA1324==$NumRA} {
			    set jaitrouvecorres 1
			    set AccmRNA2 $AccmRNA
			    set Genre2 $Genre
			    if {[string equal $AccmRNA2 "NomRNA"]} {
				set AccmRNA2 "" 
			    }
			    if {[string equal $Genre2 "NoOrganism"]} {
				set Genre2 "" 
			    }
			}
		    }
		    Espionne "AccmRNA1=$AccmRNA1 Genre1=$Genre1 AccmRNA2=$AccmRNA2 Genre2=$Genre2\n"
		}
	    }
	    if {!$JaiTrouveCorresEntre1324Et2717} { 
		Espionne "pas de corresp"
		Espionne "AccmRNA1=$AccmRNA1 Genre1=$Genre1 AccmRNA2=$AccmRNA2 Genre2=$Genre2\n"
	    }
	    continue
	}

	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	   Espionne "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	   Espionne "LesAcsDeLaLigne= $Ac2"
	    continue
	}
	
	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	    set jaitrouvednaacc 1
	    incr C
	   Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2"

	    if {$Ac2==""} {
		
		set Genre [OrgDuNmOuGb $Ac1]
		
		if {[regexp {^Mus$} $Genre]} {
		    if { ![regexp {^NM_} $Ac1] } {
			set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			if { $NM != "" } {
			    set LesAcsDeLaLigne "$Ac1 $NM"
			} else { 
			    set LesAcsDeLaLigne $Ac1
			}
		    } else { 
			set LesAcsDeLaLigne $Ac1
		    }
		}
		
		if {[regexp {^Homo$} $Genre]} {
		    #travail sur prot Ac3=$Ac3 Ac4=$Ac4
		    
		    set LesAcs3 [split $Ac3 ","]
		    foreach ChaqAc3 $LesAcs3 {
			set GenreAc3 [OrgDuProt $ChaqAc3]
			lappend LesGenresP3 $GenreAc3
		    }
		    set LesGenresP3 [lsort -unique $LesGenresP3]
		    if { [llength $LesGenresP3] > 1 } {Espionne "attention ilya pls genres pour cette ligne" }
		    set GenreP3 [join $LesGenresP3 " "]

		    if { $GenreP3 == "" } { 
			#jamais ce cas; je ne le traite pas
			#Espionne "pls=>ligne=$I Acc=$Ac3 Id=attention PAS FICHESpls\n"
			if {$Ac4 == ""} {Espionne "dois prendre la def" }
			if {$Ac4 != ""} {Espionne "dois prendre prot_acc_piqor"} 
			continue 
		    }
		    
		    if {[regexp {^Homo} $GenreP3]} {
			if {$Ac4!=""} {
			    set ListeAc4 [split $Ac4 ","]
			    foreach ChaqueAc4 $ListeAc4 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc4]
				if {$AccDna!=""} {  
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc4]
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach T $ListeDesAcs {LConcat LesAcsDna $T} 
				    }
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set genenamefait 1
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
			if {$genenamefait == 0 && $LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }

		    if {[regexp {^Mus} $GenreP3]} {
			if {$Ac4!=""} {
			    set AccsProt "$Ac3,$Ac4"
			    set ListeAccsProt [split $AccsProt ","]
			    foreach ChaqueAccProt $ListeAccsProt {
				set AccDna [AttriDesAcDnaParProt $ChaqueAccProt]
				if {$AccDna!=""} {
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAccProt] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach S $ListeDesAcs {LConcat LesAcsDna $S} 
				    }
				}
			    } 
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set ListeAc3 [split $Ac3 ","]
			    foreach ChaqueAc3 $ListeAc3 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc3]
				if {$AccDna!=""} { 
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				} 
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc3] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "] 
					foreach S $ListeDesAcs {LConcat LesAcsDna $S}
				    }  
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]
			}
			if {$LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }
		}
	    }

	    if {$Ac2!=""} {

		if { $Ac1==$Ac2 } {
		    set LesAcsDeLaLigne $Ac2
		    set jaitrouve 1
		}
		if { $jaitrouve == 0 && [regexp {.\,.} $Ac2] } {
		    set LesNMs [split $Ac2 ","]
		    foreach LeNM $LesNMs { 
			if { $LeNM==$Ac1 } { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne $Ac2
			    set jaitrouve 1
			    break
			}
		    }
		}

		if { $jaitrouve==0 } {

		    set Genre [OrgDuNmOuGb $Ac1]

		    if {[regexp {^Mus$} $Genre]} {
			if { ![regexp {^NM_} $Ac1] } {
			    set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			    if { $NM != "" } {
				set ListeAc1 [split $Ac1 ","]
				set ListeAc2 [split $Ac2 ","]
				set ListeNM [split $NM " "]
				set Tout [concat $ListeAc1 $ListeAc2 $ListeNM]
				set Tout [ListeSansDoublon $Tout]
				set LesAcsDeLaLigne [join $Tout " "]
			    } else { 
				regsub -all "," $Ac2 " " Ac2
				set LesAcsDeLaLigne "$Ac1 $Ac2"
			    }
			} else { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne "$Ac1 $Ac2"
			}
		    }

		    if {[regexp {^Homo$} $Genre]} {
			regsub -all "," $Ac2 " " Ac2
			set LesAcsDeLaLigne $Ac2
		    }
		}
		#jaitrouve
	    }
	    #refseqpiqorpasvide
	}
	#dnaaccpas vide

	if { $Ac1=="" && $Ac2=="" && ($Ac3!="" || $Ac4!="")} {
	    #Ac3=prot_acc Ac4=prot_acc_piqor
	    incr D
	    set jaitrouveprot 1
	   Espionne "ligne $I Ac3=$Ac3 Ac4=$Ac4"
	    
	    if { [regexp "," $Ac3] || [regexp "," $Ac4] } {
		set pls 1 
	    }
	    
	    set LesAcs3 [split $Ac3 ","]
	    set LesAcs4 [split $Ac4 ","]
	    set LesAcs3et4 [concat $LesAcs3 $LesAcs4]
	    set SesAcs [split $LesAcs3et4 " "]
	    foreach Ac $SesAcs {
		set GenreLu ""
		set IdLu ""
		set NM ""
		set mRNA ""
		set AcGb ""
		set mRNAGb ""
		
		set GenreLu [OrgDuProt $Ac]
		
		if { $GenreLu == "" } { 
		    set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
		    LConcat LesIdsDeLaLigne $IdLu
		    LConcat LesNmsDeLaLigne $NM 
		    LConcat LesmRNADeLaLigne $mRNA
		    LConcat LesAcsGbDeLaLigne $AcGb	
		    LConcat LesmRNAGbDeLaLigne $mRNAGb
		    continue
		}
		if { $GenreLu != "" && ![regexp -nocase {^Mus} $GenreLu]} {
		    if {! $pls} { 
			incr PasSouris
			set cont 1; break
		    }
		    if {$pls} { 
			incr PasSouris
			continue 
		    }
		}
		    
		set IdLu [IdDuProt $Ac]
		LConcat LesIdsDeLaLigne $IdLu
		set NM [LocUcsc $IdLu]

		if {$NM!=""} {
		    set ListNM [split $NM " "]
		    foreach ChaqNM $ListNM {
			LConcat LesNmsDeLaLigne $ChaqNM 
			if { ![regexp {^NM_} $ChaqNM] } { 
			    set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
			    if {$mRNA != ""} { 
				set ListemRNA [split $mRNA " "]
				foreach ChaqmRNA $ListemRNA {
				    LConcat LesmRNADeLaLigne $ChaqmRNA
				}	
			    }
			}
		    }
		} 
		if {$NM==""} {
		    set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut != ""} {
			set LesLignesDeGetzOut [split $GetzOut "\n"]
			foreach LigneDeGetzOut $LesLignesDeGetzOut {
			    set Ref ""
			    set AcGb ""
			    scan $LigneDeGetzOut "%s %s" Ref AcGb
			    LConcat LesAcsGbDeLaLigne $AcGb	
			    set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
			    if {$mRNAGb != ""} { 
				set ListemRNAGb [split $mRNAGb " "]
				foreach ChaqmRNAGb $ListemRNAGb {
				    LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				}
			    } 
			}
		    }
		} 
		if { $NM=="" && $AcGb=="" } {
		    if {$pls} {incr vide}
		}
	    }

	    if { [llength $SesAcs] == $PasSouris } {
		set LigneQueSouris 1
	    }
	    if { [expr [llength $SesAcs] - $PasSouris] != [llength $LesIdsDeLaLigne] } { 
		set SsFicheProt 1
	    }

	    set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
	    set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
	    set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
	    set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
	    set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]

	    if { ($cont || $LigneQueSouris) || ($LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={}) || ($SsFicheProt) || ($vide>0) } {
		set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne $LesAcsParGNDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    }

	    if { $LesNmsDeLaLigne != {} || $LesAcsGbDeLaLigne != {} || ($LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {}) } {
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    } 
		
	}

	if {($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && ($Ac3=="" || [regexp {\?} $Ac3]) && $Ac4==""} {
	   Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    set jaitrouvegn 1
	    incr E
	    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
	}

	if {$jaitrouvednaacc || $jaitrouveprot || $jaitrouvegn} {
	    if {$LesAcsDeLaLigne != ""} {
		Espionne "LesAcsDeLaLigne= $LesAcsDeLaLigne"
	    }
	    if {$LesAcsDeLaLigne == ""} {Espionne "LesAcsDeLaLigne= vide"}
	}
    }
    #foreach
    Espionne "$A =nb de RA"
    Espionne "$B =nb ac refseq_piqor ms pas dna_acc"
    Espionne "$C =nb ac dna_acc"
    Espionne "$D =nb ac prot"
    Espionne "$E =nb ac rien"


}

proc AttriToutAccess_AEffacer {} {

 
    set A 0
    set B 0 
    set C 0
    set D 0
    set E 0
    set LesLignesPauvres {}

    foreach I [RetChip2 ListOf Index] {  
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "DNA_acc"]
	set Ac2 [RetChip2 $I "refseq_PIQOR"]
	set Ac3 [RetChip2 $I "prot_acc"]
	set Ac4 [RetChip2 $I "prot_acc_PIQOR"]


	set jaitrouvednaacc 0
	set jaitrouve 0
	set jaitrouveRA 0
	set jaitrouvegn 0
	set genenamefait 0
	set jaitrouveprot 0
	set LesGenresP3 {}
	set AccDna ""
	set ListeDesAcs {}
	set LesAcsDna {}

	set LesAcsDeLaLigne ""

	set pls 0
	set PasSouris 0
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set LesAcsParGNDeLaLigne ""
	set LesAcsDeLaLigneList {}
	set cont 0
	set LigneQueSouris 0
	set SsFicheProt 0
	set vide 0

	if { [regexp {^RA[0-9]+} $Des1] } {
	    puts "ligne $I Des1=$Des1 Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    incr A
	    set RA1324 ""; set AccmRNA1 ""; set Genre1 ""; set AccmRNA2 ""; set Genre2 ""

	    set Fichier "/genomics/link/Ret1324/fiches/Orf2Cluster2Access2Def2Expression"
	    set LesLignes [LesLignesDuFichier $Fichier]

	    foreach Ligne $LesLignes {
		scan $Ligne "%s %s %s %s" RA1324 x y RA2717
		if {$Des1==$RA2717} {
		    set JaiTrouveCorresEntre1324Et2717 1
		    puts "RA1324=$RA1324"

		    if {[file exists "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]} {
			set LAcRa1 [ContenuDuFichier "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]
			scan $LAcRa1 "%s %s %s %s %s" x y AccmRNA1 z Genre1
		    }

		    set Fichier2 "/genomics/link/Ret1324/fiches/AccessDesProteinesEtDesmRNAsChoisis"
		    set LesLignes2 [LesLignesDuFichier $Fichier2]

		    foreach Ligne2 $LesLignes2 {
			scan $Ligne2 "%s %s %s %s" NumRA AccProt AccmRNA Genre
			if {$RA1324==$NumRA} {
			    set jaitrouvecorres 1
			    set AccmRNA2 $AccmRNA
			    set Genre2 $Genre
			    if {[string equal $AccmRNA2 "NomRNA"]} {
				set AccmRNA2 "" 
			    }
			    if {[string equal $Genre2 "NoOrganism"]} {
				set Genre2 "" 
			    }
			}
		    }
		    Espionne "AccmRNA1=$AccmRNA1 Genre1=$Genre1 AccmRNA2=$AccmRNA2 Genre2=$Genre2\n"
		}
	    }
	    if {!$JaiTrouveCorresEntre1324Et2717} { 
		puts "pas de corresp"
		Espionne "AccmRNA1=$AccmRNA1 Genre1=$Genre1 AccmRNA2=$AccmRNA2 Genre2=$Genre2\n"
	    }
	    continue
	}

	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	    puts "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	    puts "LesAcsDeLaLigne= $Ac2"
	    continue
	}
	
	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	    set jaitrouvednaacc 1
	    incr C
	    puts "ligne $I Ac1=$Ac1 Ac2=$Ac2"

	    if {$Ac2==""} {
		
		set Genre [OrgDuNmOuGb $Ac1]
		
		if {[regexp {^Mus$} $Genre]} {
		    if { ![regexp {^NM_} $Ac1] } {
			set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			if { $NM != "" } {
			    set LesAcsDeLaLigne "$Ac1 $NM"
			} else { 
			    set LesAcsDeLaLigne $Ac1
			}
		    } else { 
			set LesAcsDeLaLigne $Ac1
		    }
		}
		
		if {[regexp {^Homo$} $Genre]} {
		    #travail sur prot Ac3=$Ac3 Ac4=$Ac4
		    
		    set LesAcs3 [split $Ac3 ","]
		    foreach ChaqAc3 $LesAcs3 {
			set GenreAc3 [OrgDuProt $ChaqAc3]
			lappend LesGenresP3 $GenreAc3
		    }
		    set LesGenresP3 [lsort -unique $LesGenresP3]
		    if { [llength $LesGenresP3] > 1 } { puts "attention ilya pls genres pour cette ligne" }
		    set GenreP3 [join $LesGenresP3 " "]

		    if { $GenreP3 == "" } { 
			#jamais ce cas; je ne le traite pas
			#puts "pls=>ligne=$I Acc=$Ac3 Id=attention PAS FICHESpls\n"
			if {$Ac4 == ""} { puts "dois prendre la def" }
			if {$Ac4 != ""} { puts "dois prendre prot_acc_piqor"} 
			continue 
		    }
		    
		    if {[regexp {^Homo} $GenreP3]} {
			if {$Ac4!=""} {
			    set ListeAc4 [split $Ac4 ","]
			    foreach ChaqueAc4 $ListeAc4 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc4]
				if {$AccDna!=""} {  
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc4]
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach T $ListeDesAcs {LConcat LesAcsDna $T} 
				    }
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set genenamefait 1
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
			if {$genenamefait == 0 && $LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }

		    if {[regexp {^Mus} $GenreP3]} {
			if {$Ac4!=""} {
			    set AccsProt "$Ac3,$Ac4"
			    set ListeAccsProt [split $AccsProt ","]
			    foreach ChaqueAccProt $ListeAccsProt {
				set AccDna [AttriDesAcDnaParProt $ChaqueAccProt]
				if {$AccDna!=""} {
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAccProt] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach S $ListeDesAcs {LConcat LesAcsDna $S} 
				    }
				}
			    } 
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set ListeAc3 [split $Ac3 ","]
			    foreach ChaqueAc3 $ListeAc3 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc3]
				if {$AccDna!=""} { 
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				} 
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc3] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "] 
					foreach S $ListeDesAcs {LConcat LesAcsDna $S}
				    }  
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]
			}
			if {$LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }
		}
	    }

	    if {$Ac2!=""} {

		if { $Ac1==$Ac2 } {
		    set LesAcsDeLaLigne $Ac2
		    set jaitrouve 1
		}
		if { $jaitrouve == 0 && [regexp {.\,.} $Ac2] } {
		    set LesNMs [split $Ac2 ","]
		    foreach LeNM $LesNMs { 
			if { $LeNM==$Ac1 } { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne $Ac2
			    set jaitrouve 1
			    break
			}
		    }
		}

		if { $jaitrouve==0 } {

		    set Genre [OrgDuNmOuGb $Ac1]

		    if {[regexp {^Mus$} $Genre]} {
			if { ![regexp {^NM_} $Ac1] } {
			    set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			    if { $NM != "" } {
				set ListeAc1 [split $Ac1 ","]
				set ListeAc2 [split $Ac2 ","]
				set ListeNM [split $NM " "]
				set Tout [concat $ListeAc1 $ListeAc2 $ListeNM]
				set Tout [ListeSansDoublon $Tout]
				set LesAcsDeLaLigne [join $Tout " "]
			    } else { 
				regsub -all "," $Ac2 " " Ac2
				set LesAcsDeLaLigne "$Ac1 $Ac2"
			    }
			} else { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne "$Ac1 $Ac2"
			}
		    }

		    if {[regexp {^Homo$} $Genre]} {
			regsub -all "," $Ac2 " " Ac2
			set LesAcsDeLaLigne $Ac2
		    }
		}
		#jaitrouve
	    }
	    #refseqpiqorpasvide
	}
	#dnaaccpas vide

	if { $Ac1=="" && $Ac2=="" && ($Ac3!="" || $Ac4!="")} {
	    #Ac3=prot_acc Ac4=prot_acc_piqor
	    incr D
	    set jaitrouveprot 1
	    puts "ligne $I Ac3=$Ac3 Ac4=$Ac4"
	    
	    if { [regexp "," $Ac3] || [regexp "," $Ac4] } {
		set pls 1 
	    }
	    
	    set LesAcs3 [split $Ac3 ","]
	    set LesAcs4 [split $Ac4 ","]
	    set LesAcs3et4 [concat $LesAcs3 $LesAcs4]
	    set SesAcs [split $LesAcs3et4 " "]
	    foreach Ac $SesAcs {
		set GenreLu ""
		set IdLu ""
		set NM ""
		set mRNA ""
		set AcGb ""
		set mRNAGb ""
		
		set GenreLu [OrgDuProt $Ac]
		
		if { $GenreLu == "" } { 
		    set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
		    LConcat LesIdsDeLaLigne $IdLu
		    LConcat LesNmsDeLaLigne $NM 
		    LConcat LesmRNADeLaLigne $mRNA
		    LConcat LesAcsGbDeLaLigne $AcGb	
		    LConcat LesmRNAGbDeLaLigne $mRNAGb
		    continue
		}
		if { $GenreLu != "" && ![regexp -nocase {^Mus} $GenreLu]} {
		    if {! $pls} { 
			incr PasSouris
			set cont 1; break
		    }
		    if {$pls} { 
			incr PasSouris
			continue 
		    }
		}
		    
		set IdLu [IdDuProt $Ac]
		LConcat LesIdsDeLaLigne $IdLu
		set NM [LocUcsc $IdLu]

		if {$NM!=""} {
		    set ListNM [split $NM " "]
		    foreach ChaqNM $ListNM {
			LConcat LesNmsDeLaLigne $ChaqNM 
			if { ![regexp {^NM_} $ChaqNM] } { 
			    set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
			    if {$mRNA != ""} { 
				set ListemRNA [split $mRNA " "]
				foreach ChaqmRNA $ListemRNA {
				    LConcat LesmRNADeLaLigne $ChaqmRNA
				}	
			    }
			}
		    }
		} 
		if {$NM==""} {
		    set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut != ""} {
			set LesLignesDeGetzOut [split $GetzOut "\n"]
			foreach LigneDeGetzOut $LesLignesDeGetzOut {
			    set Ref ""
			    set AcGb ""
			    scan $LigneDeGetzOut "%s %s" Ref AcGb
			    LConcat LesAcsGbDeLaLigne $AcGb	
			    set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
			    if {$mRNAGb != ""} { 
				set ListemRNAGb [split $mRNAGb " "]
				foreach ChaqmRNAGb $ListemRNAGb {
				    LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				}
			    } 
			}
		    }
		} 
		if { $NM=="" && $AcGb=="" } {
		    if {$pls} {incr vide}
		}
	    }

	    if { [llength $SesAcs] == $PasSouris } {
		set LigneQueSouris 1
	    }
	    if { [expr [llength $SesAcs] - $PasSouris] != [llength $LesIdsDeLaLigne] } { 
		set SsFicheProt 1
	    }

	    set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
	    set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
	    set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
	    set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
	    set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]

	    if { ($cont || $LigneQueSouris) || ($LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={}) || ($SsFicheProt) || ($vide>0) } {
		set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne $LesAcsParGNDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    }

	    if { $LesNmsDeLaLigne != {} || $LesAcsGbDeLaLigne != {} || ($LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {}) } {
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    } 
		
	}

	if {($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && ($Ac3=="" || [regexp {\?} $Ac3]) && $Ac4==""} {
	    puts "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    set jaitrouvegn 1
	    incr E
	    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
	}

	if {$jaitrouvednaacc || $jaitrouveprot || $jaitrouvegn} {
	    if {$LesAcsDeLaLigne != ""} {
		puts "LesAcsDeLaLigne= $LesAcsDeLaLigne"
	    }
	    if {$LesAcsDeLaLigne == ""} {puts "LesAcsDeLaLigne= vide"}
	}
    }
    #foreach
    Espionne "$A =nb de RA"
    Espionne "$B =nb ac refseq_piqor ms pas dna_acc"
    Espionne "$C =nb ac dna_acc"
    Espionne "$D =nb ac prot"
    Espionne "$E =nb ac rien"


}

proc AttriToutLesBidonAcAccNonExistant {} {


    set total 0; set B 0; set C 0; set W 0; set X 0; set D 0; set M 0; set N 0; set O 0; set P 0
    set cas1 0; set cas1a 0; set cas1b 0; set cas1c 0 
    set cas2 0; set cas2a 0; set cas2b 0; set cas2c 0; set cas2d 0
    set cas3 0; set cas4 0; set cas5 0; set cas6 0
    set cas7 0; set cas7a 0; set cas7b 0; 
    set cas8 0; set cas9 0; set cas10 0; set cas11 0
    set LesLignesPauvres {}
    set ListeI {87 178 200 220 1197 1289 1367 1431 1602 1702 1949}
    foreach I $ListeI {
	incr total
	Espionne $I
	set Des1 [RetChip5 $I "description_customer"]
	Espionne $Des1
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1 [RetChip5 $I "DNA_acc"]
	set Ac2 [RetChip5 $I "refseq_PIQOR"]
	set Ac3 [RetChip5 $I "prot_acc"]
	set Ac4 [RetChip5 $I "prot_acc_PIQOR"]
	set LesNMs {}

	set LesAc {}
	set Genre ""
	set TousLesGenres {}
	array unset LesGenres
	set onasouris 0
	set LesAcsDna {} 

	set LesAcProt {} 
	set TousLesGenresProt {} 
	array unset LesGenreAcProt 
	set onasourisprot 0 

	set genenamefait 0
	set ListAcsParGn {}; set BigList {}
	set LesAcsDeLaLigne ""

	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	    set Ac1 [string trim $Ac1]
	    regsub -all " " $Ac1 "" Ac1
	    incr C
	   Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"

	    incr W
	    set LesAc [split $Ac1 ","]

	    set LesAc [ListeSansDoublon $LesAc]
	    set LesAc [ListeSsElmtVide $LesAc]

	    foreach Ac $LesAc {
		set Genre [OrgDuNmOuGb $Ac]
		Espionne "Ac $Ac Genre $Genre"
		#if {$Genre == ""} {Espionne "attention pas fiches"}
		LConcat TousLesGenres $Genre
		set LesGenres($Ac) $Genre
	    }
	    set TousLesGenres [ListeSansDoublon $TousLesGenres]
	    foreach ChaqueGenre $TousLesGenres {
		if {[regexp {^Mus} $ChaqueGenre]} {
		    set onasouris 1
		}
	    }
	    if {$onasouris} {
		Espionne "cas1"
		incr cas1
		foreach Ac $LesAc {
		    set LesNmRefSeq {}; set LesNvxNm {}
		    if {[regexp {^Mus} $LesGenres($Ac)]} {
			#Espionne "Ac $Ac"
			if { ![regexp {^NM_} $Ac] && ![regexp {^XM_} $Ac] && ![regexp {^NR_} $Ac]} {
			    set NM [MrnaRefseqUcscMouse $Ac "Nm"]
			    #Espionne "NM $NM"
			    if { $NM != "" } {
				Espionne "cas1a"
				incr cas1a
				set LesNmRefSeq [split $NM " "]
				foreach NmRefSeq $LesNmRefSeq {
				    set GenreNmRefSeq [OrgDuNmOuGb $NmRefSeq]
				    #Espionne "$NmRefSeq $GenreNmRefSeq"
				    if {[regexp {^Mus} $GenreNmRefSeq]} {
					LConcat LesNvxNm $NmRefSeq
				    } 
				}
				set LesNvxNm [ListeSansDoublon $LesNvxNm]
				set NMjoint [join $LesNvxNm " "]
				Espionne "NMjoint $NMjoint"
				LConcat LesAcsDna "$Ac $NMjoint"
			    } else { 
				Espionne "cas1b"
				incr cas1b
				LConcat LesAcsDna $Ac
			    }
			} else { 
			   Espionne "cas1c"
		    incr cas1c
			    LConcat LesAcsDna $Ac
			}
		    }
		}
	    }
	    #Espionne "cas2"
	    incr cas2
	    #travail sur prot Ac3=$Ac3 Ac4=$Ac4
	    if {$Ac3!="" || $Ac4!=""} {
		Espionne "cas2a"
		incr cas2a
		if {$Ac3!="" && $Ac4!=""} {
		   Espionne "cas2b"
		    incr cas2b
		    set Ac3 [string trim $Ac3]
		    regsub -all " " $Ac3 "" Ac3
		    set Ac4 [string trim $Ac4]
		    regsub -all " " $Ac4 "" Ac4
		    set Ac3Ac4 "$Ac3,$Ac4"
		    set LesAcProt [split $Ac3Ac4 ","]
		} elseif {$Ac3!=""} {
		    set Ac3 [string trim $Ac3]
		    regsub -all " " $Ac3 "" Ac3
		   Espionne "cas2c"
		    incr cas2c
		    set LesAcProt [split $Ac3 ","]
		} elseif {$Ac4!=""} {
		    set Ac4 [string trim $Ac4]
		    regsub -all " " $Ac4 "" Ac4
		   Espionne "cas2d"
		    incr cas2d 
		    set LesAcProt [split $Ac4 ","]
		}
		set LesAcProt [ListeSansDoublon $LesAcProt]
		set LesAcProt [ListeSsElmtVide $LesAcProt]
		foreach AcProt $LesAcProt {
		    set GenreAcProt [OrgDuProt $AcProt]
		   Espionne "$AcProt $GenreAcProt"
		    #if {$GenreAcProt==""} {Espionne "attention pas fiches" }
		    LConcat TousLesGenresProt $GenreAcProt
		    set LesGenreAcProt($AcProt) $GenreAcProt
		}
		set TousLesGenresProt [ListeSansDoublon $TousLesGenresProt]
		foreach ChaqueGenreProt $TousLesGenresProt {
		    if {[regexp {^Mus} $ChaqueGenreProt]} {
			set onasourisprot 1
		    }
		}
		if {$onasourisprot} {
		   Espionne "cas3"
		    incr cas3
		    foreach AcProt $LesAcProt {
			set ListeDesAcs1 {}; set ListeDesAcs2 {}; set LesAcsDnaProv {}
			if {[regexp {^Mus} $LesGenreAcProt($AcProt)]} {
			    set ResultParProt [AttriDesAcDnaParProt $AcProt]
			   Espionne "ResultParProt $ResultParProt"
			    set ResultParGb   [AttriDesAcDnaParGb $AcProt]
			   Espionne "ResultParGb $ResultParGb"
			    if {$ResultParProt != ""} {
				set ListeDesAcs1 [split $ResultParProt " "]
			    }
			    if {$ResultParGb != ""} {
				set ListeDesAcs2 [split $ResultParGb " "]
			    }
			    set LesAcsDnaProv [concat $ListeDesAcs1 $ListeDesAcs2]
			    foreach elmt $LesAcsDnaProv {
				LConcat LesAcsDna $elmt
			    }
			}
		    }
		}
		if {!$onasourisprot} {
		    set LesAcsDna [ListeSansDoublon $LesAcsDna]
		   Espionne "cas4"
		    incr cas4
		    set genenamefait 1
		    set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
		}
	    }
	
	    if {!$genenamefait && ($ListAcsParGn == {} && $LesAcsDna == {})} {
		Espionne "cas6"
		incr cas6
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    set BigList [concat $LesAcsDna $ListAcsParGn]
	    set BigList [ListeSansDoublon $BigList]
	    if {$BigList == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set BigList [ListeSsElmtVide $BigList]
		set LesAcsDeLaLigne [join $BigList " "]
	    }
	   Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}

	if { ($Ac1=="" || [regexp {\?} $Ac1]) && (($Ac3!="" && ![regexp {\?} $Ac3]) || $Ac4!="")} {
	    #Ac3=prot_acc Ac4=prot_acc_piqor
	    incr D
	   Espionne "ligne $I Ac3=$Ac3 Ac4=$Ac4"
	    set Ac3 [string trim $Ac3]
	    regsub -all " " $Ac3 "" Ac3
	    set Ac4 [string trim $Ac4]
	    regsub -all " " $Ac4 "" Ac4
	    
	    if {$Ac3!="" && $Ac4!=""} {
		incr M
		set Ac3Ac4 "$Ac3,$Ac4"
		set LesAcProt [split $Ac3Ac4 ","]
	    } elseif {$Ac3!="" && ![regexp {\?} $Ac3]} {
		incr N
		set LesAcProt [split $Ac3 ","]
	    } elseif {$Ac4!=""} {
		incr O
		set LesAcProt [split $Ac4 ","]
	    } 
	    set LesAcProt [ListeSansDoublon $LesAcProt]
	    
	    foreach AcProt $LesAcProt {
		set GenreProt [OrgDuProt $AcProt]
		Espionne "AcProt $AcProt GenreProt $GenreProt"
		#if {$GenreProt==""} {Espionne "attention pas fiche"}
		LConcat TousLesGenresProt $GenreProt
		set LesGenresProt($AcProt) $GenreProt
	    }
	    set TousLesGenresProt [ListeSansDoublon $TousLesGenresProt]
	    
	    foreach ChaqueGenreProt $TousLesGenresProt {
		if {[regexp {^Mus} $ChaqueGenreProt]} {
		    set onasourisprot 1
		}
	    }
	    if {$onasourisprot} {
		Espionne "cas7"
		incr cas7
		foreach AcProt $LesAcProt {
		    set ListeDesAcs1 {}; set ListeDesAcs2 {}; set LesAcsDnaProv {}
		    if {[regexp {^Mus} $LesGenresProt($AcProt)]} {
			set ResultParProt [AttriDesAcDnaParProt $AcProt]
			Espionne "ResultParProt $ResultParProt"
			set ResultParGb   [AttriDesAcDnaParGb $AcProt]
			Espionne "ResultParGb $ResultParGb"
			if {$ResultParProt != ""} {
			   Espionne "cas7a"
			    incr cas7a
			    set ListeDesAcs1 [split $ResultParProt " "]
			}
			if {$ResultParGb != ""} {
			   Espionne "cas7b"
			    incr cas7b
			    set ListeDesAcs2 [split $ResultParGb " "]
			}
			set LesAcsDnaProv [concat $ListeDesAcs1 $ListeDesAcs2]
			foreach elmt $LesAcsDnaProv {
			    LConcat LesAcsDna $elmt
			}
		    }
		}
		set LesAcsDna [ListeSansDoublon $LesAcsDna]
	    }
	    if {!$onasourisprot} {
		Espionne "cas8"
		incr cas8
		set genenamefait 1
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    if {!$genenamefait && ($ListAcsParGn=={} && $LesAcsDna=={})} {
		Espionne "cas9"
		incr cas9
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    set BigList [concat $LesAcsDna $ListAcsParGn]
	    set BigList [ListeSansDoublon $BigList]
	    if {$BigList == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set BigList [ListeSsElmtVide $BigList]
		set LesAcsDeLaLigne [join $BigList " "]
	    }
	   Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}

	if {($Ac1=="" || [regexp {\?} $Ac1]) && ($Ac3=="" || [regexp {\?} $Ac3])  && $Ac4==""} {
	    incr P
	   Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	   Espionne "cas10"
	    incr cas10
	    set genenamefait 1
	   Espionne "$Des1 $Des2"
	    set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    if {$ListAcsParGn == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set ListAcsParGn [ListeSansDoublon $ListAcsParGn]
		set ListAcsParGn [ListeSsElmtVide $ListAcsParGn]
		set LesAcsDeLaLigne [join $ListAcsParGn " "]
	    }
	   Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}

	if {$genenamefait == 0 && $LesAcsDeLaLigne == ""} {
	   Espionne "cas11"
	    incr cas11
	    set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    if {$ListAcsParGn == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set ListAcsParGn [ListeSansDoublon $ListAcsParGn]
		set ListAcsParGn [ListeSsElmtVide $ListAcsParGn]
		set LesAcsDeLaLigne [join $ListAcsParGn " "]
	    }
	   Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}
        

	if {$LesAcsDeLaLigne == ""} {
	    set LignePauvre "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    lappend LesLignesPauvres $LignePauvre
	   Espionne ">bidon trouve pas \natgc"
	} else {
	    foreach Acs $LesAcsDeLaLigne {
		if { [regexp "^NM_" $Acs] || [regexp "^XM_" $Acs] || [regexp "^NR_" $Acs] } {
		    set GetzOut ""
		    set Commande "getz \"\\\[refseq-acc:$Acs\\\]\" \-view FastaSeqs" 
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut == ""} {Espionne ">bidon fiche n'existe plus\natgc" }
		    if {$GetzOut != ""} { 
			if { [regexp {^>ref.+>ref} $GetzOut] } {
			    if {$I==178 || $I==1197} {set GetzOut [string range $GetzOut [string first ">" $GetzOut] [expr [string last ">" $GetzOut] - 1]] }
			   Espionne "ATTENTION AU - 2 SEQ FASTA"
			} else {
			    set GetzOut [string range $GetzOut [string last ">" $GetzOut] end]
			}
			Espionne $GetzOut
		    }
		} else {
		    set GetzOut ""
		    set Commande "getz \"\\\[genbankfull-acc:$Acs\\\]\" \-view FastaSeqs" 
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut == ""} {Espionne ">bidon fiche n'existe plus\natgc" }
		    if {$GetzOut != ""} { 
			set GetzOut [string range $GetzOut [string last ">" $GetzOut] end]
			if { [regexp {^>ref.+>ref} $GetzOut] } {
			   Espionne "ATTENTION AU - 2 SEQ FASTA"
			}
			Espionne $GetzOut
		    }
		}
	    }
	}
    }
    set longdespauvres [llength $LesLignesPauvres]
    SauveLesLignes $LesLignesPauvres dans [RepertoireDuGenome]/fiches/LesLignesPauvres.txt
    Espionne "nombre de lignes= $total"
    Espionne "B=$B";Espionne "C $C";Espionne "W $W";Espionne "X $X"
    Espionne "D $D";Espionne "M $M";Espionne "N $N";Espionne "O $O";Espionne "P $P"
    Espionne "cas1 $cas1";Espionne "cas1a $cas1a";Espionne "cas1b $cas1b";Espionne "cas1c $cas1c" 
    Espionne "cas2 $cas2";Espionne "cas2a $cas2a";Espionne "cas2b $cas2b";Espionne "cas2c $cas2c";Espionne "cas2d $cas2d"
    Espionne "cas3 $cas3";Espionne "cas4 $cas4";Espionne "cas5 $cas5";Espionne "cas6 $cas6"
    Espionne "cas7 $cas7";Espionne "cas7a $cas7a";Espionne "cas7b $cas7b" 
    Espionne "cas8 $cas8";Espionne "cas9 $cas9";Espionne "cas10 $cas10";Espionne "cas11 $cas11"
    Espionne "nombre de lignes pauvres = $longdespauvres"


}

proc AttriToutRA {} {

 
    set A 0
    set Z 0
    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set jaitrouveRA 0

	if { [regexp {^RA[0-9]+} $Des1] } {
	    incr A
	    puts "ligne $I Des1=$Des1"

	    set Fichier "/genomics/link/Ret1324/fiches/Orf2Cluster2Access2Def2Expression"
	    set LesLignes [LesLignesDuFichier $Fichier]

	    set Fichier2 "/genomics/link/Ret1324/fiches/AccessDesProteinesEtDesmRNAsChoisis"
	    set LesLignes2 [LesLignesDuFichier $Fichier2]
	    
	    
	    foreach Ligne $LesLignes {
		scan $Ligne "%s %s %s %s" RA1324 x y RA2717
		if {$Des1==$RA2717} {
		    set jaitrouveRA 1
		    puts  "=>Des1=$Des1 == Ret1324=$RA1324" 
		    if {[file exists "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]} { 
			set LeTfaDeRa [ContenuDuFichier "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]
			scan $LeTfaDeRa "%s %s %s" x y AccmRNA 
			if {$LeTfaDeRa==""} { puts "UN FICHIER MS PAS DE SEQ" }
			if {$LeTfaDeRa!=""} { 
			    puts "OK1=>$AccmRNA"			
			    #puts $LeTfaDeRa
			}
		    } else { 
			incr Z			
			puts "PAS DE FICHIER"
			lappend LesSsFiches "ligne $I Des1=$Des1 Ret1324=$RA1324"
		    }
		    foreach Ligne2 $LesLignes {
			scan $Ligne2 "%s %s %s" RA1324b AccmRNA2 
			if {$RA1324b == $RA1324} {
			    puts "OK2=>$AccmRNA2"
			} else { puts "pas d'access trouve ac blastx" }
		    }
		} 
	    } 
	    if {!$jaitrouveRA} { puts "PAS DE CORRES" }
	}
    }
    
    Espionne "$A =nb de ligne RA"
    Espionne "$Z =nb de lignes sans fichier"
    foreach X $LesSsFiches { puts $X } 


}

proc AttriToutRA_AEffacer {} {

 
    set A 0
    set Z 0
    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set jaitrouveRA 0

	if { [regexp {^RA[0-9]+} $Des1] } {
	    incr A
	    puts "ligne $I Des1=$Des1"

	    set Fichier "/genomics/link/Ret1324/fiches/Orf2Cluster2Access2Def2Expression"
	    set LesLignes [LesLignesDuFichier $Fichier]

	    set Fichier2 "/genomics/link/Ret1324/fiches/AccessDesProteinesEtDesmRNAsChoisis"
	    set LesLignes2 [LesLignesDuFichier $Fichier2]

	    foreach Ligne $LesLignes {
		scan $Ligne "%s %s %s %s" RA1324 x y RA2717
		if {$Des1==$RA2717} {
		    set jaitrouveRA 1
		    puts  "=>Des1=$Des1 == Ret1324=$RA1324" 
		    if {[file exists "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]} { 
			set LeTfaDeRa [ContenuDuFichier "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$RA1324"]
			scan $LeTfaDeRa "%s %s %s" x y AccmRNA 
			if {$LeTfaDeRa==""} { puts "UN FICHIER MS PAS DE SEQ" }
			if {$LeTfaDeRa!=""} { 
			    puts "OK1=>$AccmRNA"			
			    #puts $LeTfaDeRa
			}
		    } else { 
			incr Z
			puts "PAS DE FICHIER"
			lappend LesSsFiches "ligne $I Des1=$Des1 Ret1324=$RA1324"
		    }
		    foreach Ligne2 $LesLignes {
			scan $Ligne2 "%s %s %s" RA1324b AccmRNA2 
			if {$RA1324b == $RA1324} {
			    puts "OK2=>$AccmRNA2"
			} else { puts "pas d'access trouve ac blastx" }
		    }
		} 
	    } 
	    if {!$jaitrouveRA} { puts "PAS DE CORRES" }
	}
    }
    Espionne "$A =nb de ligne RA"
    Espionne "$Z =nb de lignes sans fichier"
    foreach X $LesSsFiches { puts $X } 


}

proc AttriToutRefseqPiqor {} {

 
    set B 0 
    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "DNA_acc"]
	set Ac2 [RetChip2 $I "refseq_PIQOR"]
	set Ac3 [RetChip2 $I "prot_acc"]
	set Ac4 [RetChip2 $I "prot_acc_PIQOR"]

	if { [regexp {^RA[0-9]+} $Des1] } {continue}
	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	    puts "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	    set LesNMs [split $Ac2 ","]
	    foreach NM $LesNMs { 
		set Commande "getz \"\(\\\[refseqrelease-acc:$NM\\\]\|\\\[refseqnew-acc:$NM\\\]\)\!\(\\\[refseqnew-acc:$NM\\\]>\\\[refseqrelease-acc:$NM\\\]\)\" \-view FastaSeqs"
		#set Commande "getz \"\\\[refseq-acc:$NM\\\]\" \-view FastaSeqs" 
		set GetzOut [eval exec $Commande]	
		if {$GetzOut == ""} { puts "attention fiche n'existe plus" }
		if {$GetzOut != ""} { 
		    set GetzOut [string range $GetzOut [string last ">" $GetzOut] end]
		    if { [regexp {^>ref.+>ref} $GetzOut] } {
			puts "ATTENTION AU - 2 SEQ FASTA"
		    }
		    puts $GetzOut
		}
	    }
	}
    }
    Espionne "$B = nb de ligne ac refseqpiqor et ss dnaacc"


}

proc AttriToutRefseqPiqor_AEffacer {} {

 
    set B 0 
    foreach I [RetChip2 ListOf Index] {
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "DNA_acc"]
	set Ac2 [RetChip2 $I "refseq_PIQOR"]
	set Ac3 [RetChip2 $I "prot_acc"]
	set Ac4 [RetChip2 $I "prot_acc_PIQOR"]

	if { [regexp {^RA[0-9]+} $Des1] } {continue}

	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	    puts "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	    set LesNMs [split $Ac2 ","]
	    foreach NM $LesNMs { 
		set Commande "getz \"\(\\\[refseqrelease-acc:$NM\\\]\|\\\[refseqnew-acc:$NM\\\]\)\!\(\\\[refseqnew-acc:$NM\\\]>\\\[refseqrelease-acc:$NM\\\]\)\" \-view FastaSeqs"
		#set Commande "getz \"\\\[refseq-acc:$NM\\\]\" \-view FastaSeqs" 
		set GetzOut [eval exec $Commande]
		if {$GetzOut == ""} { puts "attention fiche n'existe plus" }
		if {$GetzOut != ""} { 
		    set GetzOut [string range $GetzOut [string last ">" $GetzOut] end]
		    if { [regexp {^>ref.+>ref} $GetzOut] } {
			puts "ATTENTION AU - 2 SEQ FASTA"
		    }
		    puts $GetzOut
		}
	    }
	}
    }
    Espionne "$B = nb de ligne ac refseqpiqor et ss dnaacc"


}

proc AttriToutStat {} {


    set total 0; set A 0; set B 0; set C 0; set D 0; set E 0; set F 0; set G 0; set H 0
    set J 0; set K 0; set L 0; set M 0
    foreach I [RetChip5 ListOf Index] { 
	incr total
	set Des1 [RetChip5 $I "description_customer"]
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1 [RetChip5 $I "DNA_acc"]
	set Ac2 [RetChip5 $I "refseq_PIQOR"]
	set Ac3 [RetChip5 $I "prot_acc"]
	set Ac4 [RetChip5 $I "prot_acc_PIQOR"]
	if { $Ac1=="" && $Ac2!="" } { incr A } 
	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	    incr B
	    if {$Ac2==""} {
		incr C
		if {$Ac3 == "" && $Ac4 == ""} {incr D}
		if {$Ac3 == "" && $Ac4 != ""} {incr E}
		if {$Ac3 != "" && $Ac4 == ""} {incr F}
		if {$Ac3 != "" && $Ac4 != ""} {incr G}
	    }
	    if {$Ac2!=""} {incr H}
	} 
	if { ($Ac1 == "" || [regexp {\?} $Ac1]) && $Ac2 == "" } {
	    incr J
	    if { ($Ac3!="" && ![regexp {\?} $Ac3]) || $Ac4!="" } {
		incr K
	    }
	    if { ($Ac3=="" || [regexp {\?} $Ac3]) && $Ac4=="" } {
		incr L
	    }
	}
    }
    Espionne "total $total"
    Espionne "A $A";Espionne "B $B";Espionne "C $C";Espionne "D $D";Espionne "E $E";Espionne "F $F"
    Espionne "G $G";Espionne "H $H";Espionne "J $J";Espionne "K $K";Espionne "L $L";Espionne "M $M"


}

proc AttriToutVf {} {


    set total 0; set B 0; set C 0; set W 0; set X 0; set D 0; set M 0; set N 0; set O 0; set P 0
    set cas1 0; set cas1a 0; set cas1b 0; set cas1c 0 
    set cas2 0; set cas2a 0; set cas2b 0; set cas2c 0; set cas2d 0
    set cas3 0; set cas4 0; set cas5 0; set cas6 0
    set cas7 0; set cas7a 0; set cas7b 0; 
    set cas8 0; set cas9 0; set cas10 0; set cas11 0
    set LesLignesPauvres {}
    foreach I [RetChip5 ListOf Index] {
	#if {$I>=11} {continue}
	if {$I!=87} {continue}
	incr total
	set Des1 [RetChip5 $I "description_customer"]
	set Des2 [RetChip5 $I "description_memorec"]
	set Ac1  [RetChip5 $I "DNA_acc"]
	set Ac2  [RetChip5 $I "refseq_PIQOR"]
	set Ac3  [RetChip5 $I "prot_acc"]
	set Ac4  [RetChip5 $I "prot_acc_PIQOR"]

	set LesNMs {}

	set LesAc {}
	set Genre ""
	set TousLesGenres {}
	array unset LesGenres
	set onasouris 0
	set LesAcsDna {} 

	set LesAcProt {} 
	set TousLesGenresProt {} 
	array unset LesGenreAcProt 
	set onasourisprot 0 

	set genenamefait 0
	set ListAcsParGn {}; set BigList {}
	set LesAcsDeLaLigne ""

	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	    Espionne "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	    set Ac2 [string trim $Ac2]
	    regsub -all " " $Ac2 "" Ac2
	    set LesNMs [split $Ac2 ","]
	    set LesNMs [ListeSansDoublon $LesNMs]
	    set LesNMs [ListeSsElmtVide $LesNMs]
	    set LesAcsDeLaLigne [join $LesNMs " "]
	}

	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	    set Ac1 [string trim $Ac1]
	    regsub -all " " $Ac1 "" Ac1
	    incr C
	    Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"

	    if {$Ac2==""} {
		incr W
		set LesAc [split $Ac1 ","]
	    }
	    if {$Ac2!=""} {
		set Ac2 [string trim $Ac2]
		regsub -all " " $Ac2 "" Ac2
		incr X
		set Ac1Ac2 "$Ac1,$Ac2"
		set LesAc [split $Ac1Ac2 ","]
	    }
	    set LesAc [ListeSansDoublon $LesAc]
	    set LesAc [ListeSsElmtVide $LesAc]

	    foreach Ac $LesAc {
		set Genre [OrgDuNmOuGb $Ac]
		#Espionne "Ac $Ac Genre $Genre"
		#if {$Genre == ""} {Espionne "attention pas fiches"}
		LConcat TousLesGenres $Genre
		set LesGenres($Ac) $Genre
	    }
	    set TousLesGenres [ListeSansDoublon $TousLesGenres]
	    foreach ChaqueGenre $TousLesGenres {
		if {[regexp {^Mus} $ChaqueGenre]} {
		    set onasouris 1
		}
	    }
	    if {$onasouris} {
		#Espionne "cas1"
		incr cas1
		foreach Ac $LesAc {
		    set LesNmRefSeq {}; set LesNvxNm {}
		    if {[regexp {^Mus} $LesGenres($Ac)]} {
			#Espionne "Ac $Ac"
			if { ![regexp {^NM_} $Ac] && ![regexp {^XM_} $Ac] && ![regexp {^NR_} $Ac]} {
			    set NM [MrnaRefseqUcscMouse $Ac "Nm"]
			    #Espionne "NM $NM"
			    if { $NM != "" } {
				#Espionne "cas1a"
				incr cas1a
				set LesNmRefSeq [split $NM " "]
				foreach NmRefSeq $LesNmRefSeq {
				    set GenreNmRefSeq [OrgDuNmOuGb $NmRefSeq]
				    #Espionne "$NmRefSeq $GenreNmRefSeq"
				    if {[regexp {^Mus} $GenreNmRefSeq]} {
					LConcat LesNvxNm $NmRefSeq
				    } 
				}
				set LesNvxNm [ListeSansDoublon $LesNvxNm]
				set NMjoint [join $LesNvxNm " "]
				#Espionne "NMjoint $NMjoint"
				LConcat LesAcsDna "$Ac $NMjoint"
			    } else { 
				#Espionne "cas1b"
				incr cas1b
				LConcat LesAcsDna $Ac
			    }
			} else { 
			    #Espionne "cas1c"
			    incr cas1c
			    LConcat LesAcsDna $Ac
			}
		    }
		}
	    }
	    #Espionne "cas2"
	    incr cas2
	    #travail sur prot Ac3=$Ac3 Ac4=$Ac4
	    if {$Ac3!="" || $Ac4!=""} {
		#Espionne "cas2a"
		incr cas2a
		if {$Ac3!="" && $Ac4!=""} {
		    #Espionne "cas2b"
		    incr cas2b
		    set Ac3 [string trim $Ac3]
		    regsub -all " " $Ac3 "" Ac3
		    set Ac4 [string trim $Ac4]
		    regsub -all " " $Ac4 "" Ac4
		    set Ac3Ac4 "$Ac3,$Ac4"
		    set LesAcProt [split $Ac3Ac4 ","]
		} elseif {$Ac3!=""} {
		    set Ac3 [string trim $Ac3]
		    regsub -all " " $Ac3 "" Ac3
		    #Espionne "cas2c"
		    incr cas2c
		    set LesAcProt [split $Ac3 ","]
		} elseif {$Ac4!=""} {
		    set Ac4 [string trim $Ac4]
		    regsub -all " " $Ac4 "" Ac4
		    #Espionne "cas2d"
		    incr cas2d 
		    set LesAcProt [split $Ac4 ","]
		}
		set LesAcProt [ListeSansDoublon $LesAcProt]
		set LesAcProt [ListeSsElmtVide $LesAcProt]
		foreach AcProt $LesAcProt {
		    set GenreAcProt [OrgDuProt $AcProt]
		    #Espionne "$AcProt $GenreAcProt"
		    #if {$GenreAcProt==""} {Espionne "attention pas fiches" }
		    LConcat TousLesGenresProt $GenreAcProt
		    set LesGenreAcProt($AcProt) $GenreAcProt
		}
		set TousLesGenresProt [ListeSansDoublon $TousLesGenresProt]
		foreach ChaqueGenreProt $TousLesGenresProt {
		    if {[regexp {^Mus} $ChaqueGenreProt]} {
			set onasourisprot 1
		    }
		}
		if {$onasourisprot} {
		    #Espionne "cas3"
		    incr cas3
		    foreach AcProt $LesAcProt {
			set ListeDesAcs1 {}; set ListeDesAcs2 {}; set LesAcsDnaProv {}
			if {[regexp {^Mus} $LesGenreAcProt($AcProt)]} {
			    set ResultParProt [AttriDesAcDnaParProt $AcProt]
			    #Espionne "ResultParProt $ResultParProt"
			    set ResultParGb   [AttriDesAcDnaParGb $AcProt]
			    #Espionne "ResultParGb $ResultParGb"
			    if {$ResultParProt != ""} {
				set ListeDesAcs1 [split $ResultParProt " "]
			    }
			    if {$ResultParGb != ""} {
				set ListeDesAcs2 [split $ResultParGb " "]
			    }
			    set LesAcsDnaProv [concat $ListeDesAcs1 $ListeDesAcs2]
			    foreach elmt $LesAcsDnaProv {
				LConcat LesAcsDna $elmt
			    }
			}
		    }
		}
		if {!$onasourisprot} {
		    set LesAcsDna [ListeSansDoublon $LesAcsDna]
		    #Espionne "cas4"
		    incr cas4
		    set genenamefait 1
		    set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
		}
	    }
	
	    if {!$genenamefait && ($ListAcsParGn == {} && $LesAcsDna == {})} {
		#Espionne "cas6"
		incr cas6
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    set BigList [concat $LesAcsDna $ListAcsParGn]
	    set BigList [ListeSansDoublon $BigList]
	    if {$BigList == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set BigList [ListeSsElmtVide $BigList]
		set LesAcsDeLaLigne [join $BigList " "]
	    }
	    #Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}

	if { ($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && (($Ac3!="" && ![regexp {\?} $Ac3]) || $Ac4!="")} {
	    #Espionne Ac3=prot_acc Ac4=prot_acc_piqor
	    incr D
	    Espionne "ligne $I Ac3=$Ac3 Ac4=$Ac4"
	    set Ac3 [string trim $Ac3]
	    regsub -all " " $Ac3 "" Ac3
	    set Ac4 [string trim $Ac4]
	    regsub -all " " $Ac4 "" Ac4
	    
	    if {$Ac3!="" && $Ac4!=""} {
		incr M
		set Ac3Ac4 "$Ac3,$Ac4"
		set LesAcProt [split $Ac3Ac4 ","]
	    } elseif {$Ac3!="" && ![regexp {\?} $Ac3]} {
		incr N
		set LesAcProt [split $Ac3 ","]
	    } elseif {$Ac4!=""} {
		incr O
		set LesAcProt [split $Ac4 ","]
	    } 
	    set LesAcProt [ListeSansDoublon $LesAcProt]
	    
	    foreach AcProt $LesAcProt {
		set GenreProt [OrgDuProt $AcProt]
		#Espionne "AcProt $AcProt GenreProt $GenreProt"
		#if {$GenreProt==""} {Espionne "attention pas fiche"}
		LConcat TousLesGenresProt $GenreProt
		set LesGenresProt($AcProt) $GenreProt
	    }
	    set TousLesGenresProt [ListeSansDoublon $TousLesGenresProt]
	    
	    foreach ChaqueGenreProt $TousLesGenresProt {
		if {[regexp {^Mus} $ChaqueGenreProt]} {
		    set onasourisprot 1
		}
	    }
	    if {$onasourisprot} {
		#Espionne "cas7"
		incr cas7
		foreach AcProt $LesAcProt {
		    set ListeDesAcs1 {}; set ListeDesAcs2 {}; set LesAcsDnaProv {}
		    if {[regexp {^Mus} $LesGenresProt($AcProt)]} {
			set ResultParProt [AttriDesAcDnaParProt $AcProt]
			#Espionne "ResultParProt $ResultParProt"
			set ResultParGb   [AttriDesAcDnaParGb $AcProt]
			#Espionne "ResultParGb $ResultParGb"
			if {$ResultParProt != ""} {
			    #Espionne "cas7a"
			    incr cas7a
			    set ListeDesAcs1 [split $ResultParProt " "]
			}
			if {$ResultParGb != ""} {
			    #Espionne "cas7b"
			    incr cas7b
			    set ListeDesAcs2 [split $ResultParGb " "]
			}
			set LesAcsDnaProv [concat $ListeDesAcs1 $ListeDesAcs2]
			foreach elmt $LesAcsDnaProv {
			    LConcat LesAcsDna $elmt
			}
		    }
		}
		set LesAcsDna [ListeSansDoublon $LesAcsDna]
	    }
	    if {!$onasourisprot} {
		#Espionne "cas8"
		incr cas8
		set genenamefait 1
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    }
	    if {!$genenamefait && ($ListAcsParGn=={} && $LesAcsDna=={})} {
		#Espionne "cas9"
		incr cas9
		set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
		set genenamefait 1
	    }
	    set BigList [concat $LesAcsDna $ListAcsParGn]
	    set BigList [ListeSansDoublon $BigList]
	    if {$BigList == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set BigList [ListeSsElmtVide $BigList]
		set LesAcsDeLaLigne [join $BigList " "]
	    }
	    #Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}

	if {($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && ($Ac3=="" || [regexp {\?} $Ac3])  && $Ac4==""} {
	    incr P
	    Espionne "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    #Espionne "cas10"
	    incr cas10
	    set genenamefait 1
	    #Espionne "$Des1 $Des2"
	    set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    if {$ListAcsParGn == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set ListAcsParGn [ListeSansDoublon $ListAcsParGn]
		set ListAcsParGn [ListeSsElmtVide $ListAcsParGn]
		set LesAcsDeLaLigne [join $ListAcsParGn " "]
	    }
	    #Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}

	if {$genenamefait == 0 && $LesAcsDeLaLigne == ""} {
	    #Espionne "cas11"
	    incr cas11
	    set ListAcsParGn [AttriDesAcDnaParGeneName $Des1 $Des2]
	    if {$ListAcsParGn == {}} {
		set LesAcsDeLaLigne ""
	    } else {
		set ListAcsParGn [ListeSansDoublon $ListAcsParGn]
		set ListAcsParGn [ListeSsElmtVide $ListAcsParGn]
		set LesAcsDeLaLigne [join $ListAcsParGn " "]
	    }
	    #Espionne "LesAcsDeLaLigne $LesAcsDeLaLigne"
	}
	#temporaire 
	if {$LesAcsDeLaLigne == ""} {
	    set LignePauvre "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    lappend LesLignesPauvres $LignePauvre
	    Espionne "bidon trouve pas"
	} else {
	    Espionne "$LesAcsDeLaLigne"
	    foreach Acs $LesAcsDeLaLigne {
		if { [regexp "^NM_" $Acs] || [regexp "^XM_" $Acs] || [regexp "^NR_" $Acs] } {
		    set GetzOut ""
		    set Commande "getz \"\\\[refseq-acc:$Acs\\\]\" \-view FastaSeqs" 
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut == ""} {Espionne "$Acs bidon fiche n'existe plus" }
		    if {$GetzOut != ""} {Espionne "$Acs ok"} 
		} else {
		    set GetzOut ""
		    set Commande "getz \"\\\[genbankfull-acc:$Acs\\\]\" \-view FastaSeqs" 
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut == ""} {Espionne "$Acs bidon fiche n'existe plus" }
		    if {$GetzOut != ""} {Espionne "$Acs ok"} 
		}
	    }
	}
	#temporaire        
    } 
    set longdespauvres [llength $LesLignesPauvres]
    SauveLesLignes $LesLignesPauvres dans [RepertoireDuGenome]/fiches/NewLesLignesPauvres.txt
    Espionne "nombre de lignes= $total"
    Espionne "B=$B";Espionne "C $C";Espionne "W $W";Espionne "X $X"
    Espionne "D $D";Espionne "M $M";Espionne "N $N";Espionne "O $O";Espionne "P $P"
    Espionne "cas1 $cas1";Espionne "cas1a $cas1a";Espionne "cas1b $cas1b";Espionne "cas1c $cas1c" 
    Espionne "cas2 $cas2";Espionne "cas2a $cas2a";Espionne "cas2b $cas2b";Espionne "cas2c $cas2c";Espionne "cas2d $cas2d"
    Espionne "cas3 $cas3";Espionne "cas4 $cas4";Espionne "cas5 $cas5";Espionne "cas6 $cas6"
    Espionne "cas7 $cas7";Espionne "cas7a $cas7a";Espionne "cas7b $cas7b" 
    Espionne "cas8 $cas8";Espionne "cas9 $cas9";Espionne "cas10 $cas10";Espionne "cas11 $cas11"
    Espionne "nombre de lignes pauvres = $longdespauvres"


}

proc AttriTout_AEffacer {} {

 
    set A 0
    set B 0 
    set C 0
    set D 0
    set E 0
    set LesLignesPauvres {}

    foreach I [RetChip2 ListOf Index] {  
	set Des1 [RetChip2 $I "description_customer"]
	set Des2 [RetChip2 $I "description_memorec"]
	set Ac1 [RetChip2 $I "DNA_acc"]
	set Ac2 [RetChip2 $I "refseq_PIQOR"]
	set Ac3 [RetChip2 $I "prot_acc"]
	set Ac4 [RetChip2 $I "prot_acc_PIQOR"]


	set jaitrouvednaacc 0
	set jaitrouve 0
	set jaitrouveRA 0
	set jaitrouvegn 0
	set genenamefait 0
	set jaitrouveprot 0
	set LesGenresP3 {}
	set AccDna ""
	set ListeDesAcs {}
	set LesAcsDna {}

	set LesAcsDeLaLigne ""

	set pls 0
	set PasSouris 0
	set LesIdsDeLaLigne {}
	set LesNmsDeLaLigne {}
	set LesmRNADeLaLigne {}
	set LesAcsGbDeLaLigne {}
	set LesmRNAGbDeLaLigne {}
	set LesAcsParGNDeLaLigne ""
	set LesAcsDeLaLigneList {}
	set cont 0
	set LigneQueSouris 0
	set SsFicheProt 0
	set vide 0


	if { [regexp {^RA[0-9]+} $Des1] } {
	    incr A
	    puts ">bidon raligne $I Des1=$Des1\natcg"
	    # if {[file exists "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$Des1"]} {set LeTfaDeRa [ContenuDuFichier "/genomics/link/Ret1324/mrnatfa_Mus_musculus/$Des1"]; puts $LeTfaDeRa} else {puts "attention fichera n'existe plus" }
	    continue 
	}

	if {$Ac1=="" && $Ac2!=""} {
	    incr B
	    puts "ligne $I Ac1=$Ac1 et Ac2=$Ac2"
	    set LesNMs [split $Ac2 ","]
	    foreach NM $LesNMs { 
		set Commande "getz \"\(\\\[refseqrelease-acc:$NM\\\]\|\\\[refseqnew-acc:$NM\\\]\)\!\(\\\[refseqnew-acc:$NM\\\]>\\\[refseqrelease-acc:$NM\\\]\)\" \-view FastaSeqs"
		#set Commande "getz \"\\\[refseq-acc:$NM\\\]\" \-view FastaSeqs" 
		set GetzOut [eval exec $Commande]
		if {$GetzOut == ""} { puts ">bidon ficherefseqpiqor n'existe plus\natgc" }
		if {$GetzOut != ""} { 
		    set GetzOut [string range $GetzOut [string last ">" $GetzOut] end]
		    if { [regexp {^>ref.+>ref} $GetzOut] } {
			puts "ATTENTION AU - 2 SEQ FASTA"
		    }
		    puts $GetzOut
		}
	    }
	    continue
	}
	
	if { $Ac1!="" && ![regexp {\?} $Ac1] } {
	    set jaitrouvednaacc 1
	    incr C
	    puts "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"

	    if {$Ac2==""} {
		
		set Genre [OrgDuNmOuGb $Ac1]
		
		if {[regexp {^Mus$} $Genre]} {
		    if { ![regexp {^NM_} $Ac1] } {
			set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			if { $NM != "" } {
			    set LesAcsDeLaLigne "$Ac1 $NM"
			} else { 
			    set LesAcsDeLaLigne $Ac1
			}
		    } else { 
			set LesAcsDeLaLigne $Ac1
		    }
		}
		
		if {[regexp {^Homo$} $Genre]} {
		    #travail sur prot Ac3=$Ac3 Ac4=$Ac4
		    
		    set LesAcs3 [split $Ac3 ","]
		    foreach ChaqAc3 $LesAcs3 {
			set GenreAc3 [OrgDuProt $ChaqAc3]
			lappend LesGenresP3 $GenreAc3
		    }
		    set LesGenresP3 [lsort -unique $LesGenresP3]
		    if { [llength $LesGenresP3] > 1 } { puts "attention ilya pls genres pour cette ligne" }
		    set GenreP3 [join $LesGenresP3 " "]

		    if { $GenreP3 == "" } { 
			#jamais ce cas; je ne le traite pas
			#puts "pls=>ligne=$I Acc=$Ac3 Id=attention PAS FICHESpls\n"
			if {$Ac4 == ""} { puts "dois prendre la def" }
			if {$Ac4 != ""} { puts "dois prendre prot_acc_piqor"} 
			continue 
		    }
		    
		    if {[regexp {^Homo} $GenreP3]} {
			if {$Ac4!=""} {
			    set ListeAc4 [split $Ac4 ","]
			    foreach ChaqueAc4 $ListeAc4 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc4]
				if {$AccDna!=""} {  
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc4]
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach T $ListeDesAcs {LConcat LesAcsDna $T} 
				    }
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set genenamefait 1
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
			if {$genenamefait == 0 && $LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }

		    if {[regexp {^Mus} $GenreP3]} {
			if {$Ac4!=""} {
			    set AccsProt "$Ac3,$Ac4"
			    set ListeAccsProt [split $AccsProt ","]
			    foreach ChaqueAccProt $ListeAccsProt {
				set AccDna [AttriDesAcDnaParProt $ChaqueAccProt]
				if {$AccDna!=""} {
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q} 
				}
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAccProt] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "]
					foreach S $ListeDesAcs {LConcat LesAcsDna $S} 
				    }
				}
			    } 
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]

			} else {
			    set ListeAc3 [split $Ac3 ","]
			    foreach ChaqueAc3 $ListeAc3 {
				set AccDna [AttriDesAcDnaParProt $ChaqueAc3]
				if {$AccDna!=""} { 
				    set ListeDesAcs [split $AccDna " "]
				    foreach Q $ListeDesAcs {LConcat LesAcsDna $Q}
				} 
				if {$AccDna==""} {  
				    set AccDna [AttriDesAcDnaParGb $ChaqueAc3] 
				    if {$AccDna!=""} { 
					set ListeDesAcs [split $AccDna " "] 
					foreach S $ListeDesAcs {LConcat LesAcsDna $S}
				    }  
				}
			    }
			    set LesAcsDna [ListeSansDoublon $LesAcsDna]
			    set LesAcsDeLaLigne [join $LesAcsDna " "]
			}
			if {$LesAcsDeLaLigne == ""} {
			    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
			}
		    }
		}
	    }

	    if {$Ac2!=""} {

		if { $Ac1==$Ac2 } {
		    set LesAcsDeLaLigne $Ac2
		    set jaitrouve 1
		}
		if { $jaitrouve == 0 && [regexp {.\,.} $Ac2] } {
		    set LesNMs [split $Ac2 ","]
		    foreach LeNM $LesNMs { 
			if { $LeNM==$Ac1 } { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne $Ac2
			    set jaitrouve 1
			    break
			}
		    }
		}

		if { $jaitrouve==0 } {

		    set Genre [OrgDuNmOuGb $Ac1]

		    if {[regexp {^Mus$} $Genre]} {
			if { ![regexp {^NM_} $Ac1] } {
			    set NM [MrnaRefseqUcscMouse $Ac1 "Nm"]
			    if { $NM != "" } {
				set ListeAc1 [split $Ac1 ","]
				set ListeAc2 [split $Ac2 ","]
				set ListeNM [split $NM " "]
				set Tout [concat $ListeAc1 $ListeAc2 $ListeNM]
				set Tout [ListeSansDoublon $Tout]
				set LesAcsDeLaLigne [join $Tout " "]
			    } else { 
				regsub -all "," $Ac2 " " Ac2
				set LesAcsDeLaLigne "$Ac1 $Ac2"
			    }
			} else { 
			    regsub -all "," $Ac2 " " Ac2
			    set LesAcsDeLaLigne "$Ac1 $Ac2"
			}
		    }

		    if {[regexp {^Homo$} $Genre]} {
			regsub -all "," $Ac2 " " Ac2
			set LesAcsDeLaLigne $Ac2
		    }
		}
		#jaitrouve
	    }
	    #refseqpiqorpasvide
	}
	#dnaaccpas vide

	if { $Ac1=="" && $Ac2=="" && ($Ac3!="" || $Ac4!="")} {
	    #Ac3=prot_acc Ac4=prot_acc_piqor
	    incr D
	    set jaitrouveprot 1
	    puts "ligne $I Ac3=$Ac3 Ac4=$Ac4"
	    
	    if { [regexp "," $Ac3] || [regexp "," $Ac4] } {
		set pls 1 
	    }
	    
	    set LesAcs3 [split $Ac3 ","]
	    set LesAcs4 [split $Ac4 ","]
	    set LesAcs3et4 [concat $LesAcs3 $LesAcs4]
	    set SesAcs [split $LesAcs3et4 " "]
	    foreach Ac $SesAcs {
		set GenreLu ""
		set IdLu ""
		set NM ""
		set mRNA ""
		set AcGb ""
		set mRNAGb ""
		
		set GenreLu [OrgDuProt $Ac]
		
		if { $GenreLu == "" } { 
		    set IdLu ""; set NM ""; set mRNA ""; set AcGb ""; set mRNAGb ""
		    LConcat LesIdsDeLaLigne $IdLu
		    LConcat LesNmsDeLaLigne $NM 
		    LConcat LesmRNADeLaLigne $mRNA
		    LConcat LesAcsGbDeLaLigne $AcGb	
		    LConcat LesmRNAGbDeLaLigne $mRNAGb
		    continue
		}
		if { $GenreLu != "" && ![regexp -nocase {^Mus} $GenreLu]} {
		    if {! $pls} { 
			incr PasSouris
			set cont 1; break
		    }
		    if {$pls} { 
			incr PasSouris
			continue 
		    }
		}
		    
		set IdLu [IdDuProt $Ac]
		LConcat LesIdsDeLaLigne $IdLu
		set NM [LocUcsc $IdLu]

		if {$NM!=""} {
		    set ListNM [split $NM " "]
		    foreach ChaqNM $ListNM {
			LConcat LesNmsDeLaLigne $ChaqNM 
			if { ![regexp {^NM_} $ChaqNM] } { 
			    set mRNA [MrnaRefseqUcscMouse $ChaqNM "Nm"]
			    if {$mRNA != ""} { 
				set ListemRNA [split $mRNA " "]
				foreach ChaqmRNA $ListemRNA {
				    LConcat LesmRNADeLaLigne $ChaqmRNA
				}	
			    }
			}
		    }
		} 
		if {$NM==""} {
		    set Commande "getz \"\\\[protein-acc:$Ac\\\] > \\\[genbankfull-mol:mRNA\\\]\" \-vf acc"
		    set GetzOut [eval exec $Commande]
		    if {$GetzOut != ""} {
			set LesLignesDeGetzOut [split $GetzOut "\n"]
			foreach LigneDeGetzOut $LesLignesDeGetzOut {
			    set Ref ""
			    set AcGb ""
			    scan $LigneDeGetzOut "%s %s" Ref AcGb
			    LConcat LesAcsGbDeLaLigne $AcGb	
			    set mRNAGb [MrnaRefseqUcscMouse $AcGb "Nm"]
			    if {$mRNAGb != ""} { 
				set ListemRNAGb [split $mRNAGb " "]
				foreach ChaqmRNAGb $ListemRNAGb {
				    LConcat LesmRNAGbDeLaLigne $ChaqmRNAGb
				}
			    } 
			}
		    }
		} 
		if { $NM=="" && $AcGb=="" } {
		    if {$pls} {incr vide}
		}
	    }

	    if { [llength $SesAcs] == $PasSouris } {
		set LigneQueSouris 1
	    }
	    if { [expr [llength $SesAcs] - $PasSouris] != [llength $LesIdsDeLaLigne] } { 
		set SsFicheProt 1
	    }

	    set LesIdsDeLaLigne [lsort -unique $LesIdsDeLaLigne]
	    set LesNmsDeLaLigne [lsort -unique $LesNmsDeLaLigne]
	    set LesmRNADeLaLigne [lsort -unique $LesmRNADeLaLigne]
	    set LesAcsGbDeLaLigne [lsort -unique $LesAcsGbDeLaLigne]
	    set LesmRNAGbDeLaLigne [lsort -unique $LesmRNAGbDeLaLigne]

	    if { ($cont || $LigneQueSouris) || ($LesNmsDeLaLigne=={} && $LesAcsGbDeLaLigne=={}) || ($SsFicheProt) || ($vide>0) } {
		set LesAcsParGNDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne $LesAcsParGNDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    }

	    if { $LesNmsDeLaLigne != {} || $LesAcsGbDeLaLigne != {} || ($LesNmsDeLaLigne != {} && $LesAcsGbDeLaLigne != {}) } {
		set LesAcsDeLaLigneList [concat $LesNmsDeLaLigne $LesmRNADeLaLigne $LesAcsGbDeLaLigne $LesmRNAGbDeLaLigne]
		set LesAcsDeLaLigneList [ListeSansDoublon $LesAcsDeLaLigneList]
		set LesAcsDeLaLigne [join $LesAcsDeLaLigneList " "]
	    } 
		
	}

	if {($Ac1=="" || [regexp {\?} $Ac1]) && $Ac2=="" && ($Ac3=="" || [regexp {\?} $Ac3]) && $Ac4==""} {
	    puts "ligne $I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    set jaitrouvegn 1
	    incr E
	    set LesAcsDeLaLigne [AttriDesAcDnaParGeneName $Des1 $Des2]
	}

	if {$jaitrouvednaacc || $jaitrouveprot || $jaitrouvegn} {
	    if {$LesAcsDeLaLigne != ""} {
		set ListeFinal [split $LesAcsDeLaLigne " "]
		foreach ChaqueFinal $ListeFinal {
		    set GetzOut ""
		    if { [regexp {^NM_} $ChaqueFinal] || [regexp {^NR_} $ChaqueFinal] } {
			set Commande "getz \"\(\\\[refseqrelease-acc:$ChaqueFinal\\\]\|\\\[refseqnew-acc:$ChaqueFinal\\\]\)\!\(\\\[refseqnew-acc:$ChaqueFinal\\\]>\\\[refseqrelease-acc:$ChaqueFinal\\\]\)\" \-view FastaSeqs"
			#set Commande "getz \"\\\[refseq-acc:$ChaqueFinal\\\]\" \-view FastaSeqs" 
			set GetzOut [eval exec $Commande]
			set GetzOut [string range $GetzOut [string last ">r" $GetzOut] end]
			if { [regexp {^>ref.+>ref} $GetzOut] } {
			    puts "ATTENTION AU - 2 SEQ FASTA"
			}
		    }  
		    if { ![regexp {^NM_} $ChaqueFinal] && ![regexp {^NR_} $ChaqueFinal] } {
			set Commande "getz \"\\\[genbankfull-acc:$ChaqueFinal\\\]\" \-view FastaSeqs" 
			set GetzOut [eval exec $Commande]
			if { [regexp {^>gen.+>gen} $GetzOut] } {
			    puts "ATTENTION AU - 2 SEQ FASTA"
			}
		    }
		    if {$GetzOut == ""} { puts ">bidon fichedna n'existe plus\natcg" }
		    if {$GetzOut != ""} { puts $GetzOut }
		}
	    }
	    if {$LesAcsDeLaLigne == ""} {
		puts ">bidon pas d'access\natcg"
		lappend LesLignesPauvres "$I Ac1=$Ac1 Ac2=$Ac2 Ac3=$Ac3 Ac4=$Ac4"
	    }
	}
    }
    #foreach
    set NbPauvres [llength $LesLignesPauvres]
    set f [open LesLignesPauvres.txt w]
    puts $f "$NbPauvres = nb de ligne Pauvres"
    foreach Ligne $LesLignesPauvres {
	puts $f $Ligne
    }
    close $f

    Espionne "$A =nb de RA"
    Espionne "$B =nb ac refseq_piqor ms pas dna_acc"
    Espionne "$C =nb ac dna_acc"
    Espionne "$D =nb ac prot"
    Espionne "$E =nb ac rien"


}

proc AttributeNodeFromKEGG {} {


    #Les pathways doivent provenir du meme orga
    
    set ListPathway [list "hsa04210" "hsa04610" "hsa04660" "hsa04662" "hsa04062"]
    lappend LesLignes "Pn\tQueryColor"
    lappend LesLignesTest "Pn\tQueryColor"
    foreach Path $ListPathway {
	set LesGns {}
	regexp {([a-z]+)([0-9]+)} $Path tmp Org Id
	set File "/home/poidevin/ordi/bilbault/FromKegg/${Path}.gene"
	Espionne "$File"
	foreach Ligne [LesLignesDuFichier $File] {
	    LConcat LesGns [split [lindex [split $Ligne "\t\["] 1] " ,"]
	}
	set LesGns [ListeSansDoublon $LesGns]
	foreach Gn $LesGns {
	    set Gn [string trim $Gn]
	    if {$Gn==""} {continue}
	    lappend LesLignesTest "$Gn\t$Path"
	    lappend DejaVu($Gn) $Path
	}
    }
    foreach Clef [array names DejaVu] {
	if {[llength $DejaVu($Clef)]>1} {
	    set Id [join $DejaVu($Clef) "_"]
	    lappend LesLignes "$Clef\t$Id"
	    lappend LesCombi $DejaVu($Clef)
	} else {
	    lappend LesLignes "$Clef\t$DejaVu($Clef)"
	}
    }
    set LesCombi [ListeSansDoublon $LesCombi]
    EspionneL $LesCombi
    SauveLesLignes $LesLignesTest dans "/home/poidevin/ordi/bilbault/AttributeNodeFromKEGGTest2"
    SauveLesLignes $LesLignes dans "/home/poidevin/ordi/bilbault/AttributeNodeFromKEGG"


}

proc AttributsDeLaBalise {Item aTexte {Rogner NePasRogner}} {


    upvar $aTexte Texte
    ValeurDeLaBalise $Item $aTexte $Rogner A
    return $A


}

proc AuChoixDuBlast {NomDuFichier {FichierSortie ""}} {


    if {$FichierSortie==""} { set FichierSortie "GetText" }
    set f $NomDuFichier
    set nomori [file join [RepertoireDuGenome] "tfasdescopains_nature" $NomDuFichier]
    set Nom [file tail $NomDuFichier]
    if {[EstUnPAB $NomDuFichier]} {
	set Fichier "[RepertoireDuGenome]/blastp/$Nom"
    } else {
	set Fichier $NomDuFichier
    }
    if {! [file exists $Fichier]} {return ""}
    set LBlast [LesLignesDuFichier $Fichier]

    set lsm {}
    set lPN {}
    set LDPN {}
    set LDDPN {}

    set MaxListe 5000
    set SeuilExpect 0.001
    DecortiqueBlast $LBlast $SeuilExpect $MaxListe Query lBanqueId lAccess lDE lProfil lPN

    if {[llength $lPN] < 5} {
	set LesElus $lBanqueId
	if {$FichierSortie=="GetList"} { return $LesElus }
	if {$FichierSortie=="GetText"} {
	    set LeBlast [join $LBlast "\n"]
	    return $LeBlast
	}
	if {$FichierSortie=="Show"} {
	    return [AfficheVariable $LeBlast "AvecSegAlignement" "MounirReducedOf_/$Nom"]
	}
	return [Sauve $LeBlast dans $FichierSortie]
    }

    # Transformation E-values

    #    set lPN [LisseCourbe $lPN]
    foreach e $lPN {
	if {$e == 0.0} {set e "1.0e-300"}
	set e [expr log($e)]
	lappend llogPN $e
    }
    set Eder [lindex $lPN end]

    # Calcul des derivee premiere, seconde et tierce

    set LDPN  [Derivee $llogPN]
    #    set LDPN [LisseCourbe $LDPN]
    set LDPN  [linsert $LDPN  0 -300.]
    set LD2PN [Derivee $LDPN]
    set LD2PN [linsert $LD2PN 0 300.]
    #    set LD2PN [linsert $LD2PN end 300.]
    set LD3PN [Derivee $LD2PN]
    set LD3PN [linsert $LD3PN 0 300.]
    #    set LD3PN [linsert $LD3PN end 300. 300.]

    # fait tri
    # Met toujours le Premier

    lappend LesElus [lindex $lBanqueId 0]
    set nelus 0
    set i 0
    set LDt [lrange $LD3PN     0 end]
    set LBt [lrange $lBanqueId 0 end]
    foreach e $LDt {
	if {$i == 0 || $i == 1} {
	    incr i
	    continue
	}
	set icou [expr $i-1]
	set Flag 0
	if {$e < 0.0} {
	    set prev [lindex $LDt ${icou}]
	    if {$prev > 0.0} {
		lappend LesElus [lindex $LBt $icou]
		lappend Lid $icou
		set Flag 1
		incr nelus
	    }
	}
	if {$nelus >= 500} {break}
	incr i
    }
    foreach i $LesElus {
	if {$i == ""} {continue}
	lappend res $i
    }
    set LesElus $res

    if {$FichierSortie=="GetList"} { return $LesElus }
    if {$FichierSortie=="GetText"} {
	set LeReduit [BlastReduit $Fichier $LesElus]
	set Reduit [join $LeReduit "\n"]
	return $Reduit
    }
    if {$FichierSortie=="Show"} {
	return [AfficheVariable $Reduit "AvecSegAlignement" "MounirReducedOf_/$Nom"]
    }
    return [Sauve $Reduit dans $FichierSortie]

}

proc AuCongelo {{Action ""}} {


    set LesAvaries {}
    set LesAvariesAFaire {}
    set LesAFaire {}
    foreach Nom [ListeDesPABs] {
	set P [DernierePoele $Nom]
	set C [DernierCongelo $Nom]
	if {$P==""} { continue }
	Espionne "$Nom = $P = $C ="
	if {$C==""} {
	    Espionne "$P"
	    lappend LesAFaire $P
	}
	if {$C!="" && ([set TC [file mtime $C]] < [set TP [file mtime $P]])} {
	    lappend LesAFaire $P
	    lappend LesAvaries "$Nom [Date Nice $TC] [Date Nice $TP]"
	    lappend LesAvariesAFaire $C
	}
    }
    Espionne ".............................. LesAvaries"
    EspionneL $LesAvaries
    Espionne ".............................. LesAFaire"
    EspionneL $LesAFaire
    if { ! [OuiOuNon "Je congele effectivement ?"]} { return "" }
    set LesFaits {}
    foreach A $LesAvariesAFaire {
	exec mv $A /tempor/grid/poubelle/
    }
    foreach P $LesAFaire {
	exec mv $P /tempor/grid/congelo/
	lappend LesFaits "/tempor/grid/congelo/[file tail $P]"
    }
    return $LesFaits


}

proc AuLog {{args ""}} {

    global TexteDuLog Toggle NomFenetreOrdali wtlog Defauts

    switch [lindex $args 0] {
	"-nonewline" {
	    set bn ""
	    set txt [lindex $args 1]
	}
	"LClean" {
	    set TexteDuLog ""
	    return
	}
	"LOutput" {
	    set what [lindex $args 1]
	    if {$what eq ""} {set what HTML}
	    set fout [lindex $args 2]
	    set add  [lindex $args 3]
	    OutputTLog $what "$TexteDuLog" $fout $add
	    return
	}
	default {
	    set bn "\n"
	    set txt "$args"
	}
    }
    
    # voir ordali_tlog ....
    if {$::Defauts(OnlyTLog) && ! [regexp {^@} $txt]} {
	set txt "@text $txt"
    }
    if {[regexp {^\@text} $txt]} {
	regsub -all "\n" $txt "AlALiGNe" txt
    } 
    append TexteDuLog "${txt}$bn"

    return

}

proc AuLogOld {args} {

    global TexteDuLog Toggle NomFenetreOrdali wtlog Defauts

    if {![info exists TexteDuLog]} {set TexteDuLog ""}

    if {[lindex $args 0] eq "-nonewline"} {
	set bn ""
	set txt [lindex $args 1]
    } else {
	set bn "\n"
	set txt [join $args " "]
    }

    if {! [ModeI] || ! [info exists Toggle]} {
	# Dans tous les cas on ajoute au texte
	append TexteDuLog "$txt${bn}"
	return
    }

    if {$Toggle(AuLog)} {
	if {! [info exists wtlog]} {
	    set wlog ".wlog"
	    toplevel $wlog
	    wm title $wlog "Ordalie Log Console"
	    wm iconname $wlog "ordali log"
	    wm protocol $wlog WM_DELETE_WINDOW KillParLaCroix
	    lower $wlog $NomFenetreOrdali

	    set wtlog "$wlog.frmt.text"
	    frame $wlog.frmt
	    scrollbar $wlog.frmt.scroll  -width 8  -command "$wlog.frmt.text yview "
	    text $wlog.frmt.text  -height 25 -width 80  -yscrollcommand "$wlog.frmt.scroll set"  -font "Courier 10"  -bg white
	    pack $wlog.frmt.text -fill both -side left -expand 1
	    pack $wlog.frmt.scroll -side left -fill y
	    pack $wlog.frmt -side top

	    frame $wlog.frmb
	    pack $wlog.frmb -side bottom -fill x -padx 5 -pady 10

	    button $wlog.frmb.save -text " Save " -background green1 -command "SauveLeLog"
	    button $wlog.frmb.clear -text " Close " -background red -command "DetruitLogConsole"
	    pack $wlog.frmb.clear $wlog.frmb.save -side left -expand 1

	    set y [expr {[winfo screenheight $wlog] - 2*[winfo reqheight $wlog]}]

	    wm geom $wlog +0+$y

	    $wtlog insert end "$TexteDuLog${bn}"
	    $wtlog see end
	}

	$wtlog insert end "$txt${bn}"
	$wtlog see end
    }

    # Dans tous les cas on ajoute au texte
    append TexteDuLog "$txt${bn}"

    return

}

proc AuLogWindow {{args JSuisBidon}} {

    global TexteDuLog Toggle NomFenetreOrdali wtlog Defauts LogTampon inBeginLog

    switch [lindex $args 0] {
	"-nonewline" {
	    set bn ""
	    set txt [lindex $args 1]
	}
	"LOutput" {
	    set what [lindex $args 1]
	    OutputTLog $what "$TexteDuLog"
	    return
	}
	default {
	    set bn "\n"
	    set txt [join $args " "]
	}
    }
    
    # voir ordali_tlog ....
    if {[regexp {^\@text} $txt]} {
	regsub -all "\n" $txt "AlALiGNe" txt
    }

    if {! [info exists wtlog]} {
	set inBeginLog 0
	set wlog ".wlog"
	toplevel $wlog
	wm title $wlog "Ordalie Log Console"
	wm iconname $wlog "ordali log"
	wm protocol $wlog WM_DELETE_WINDOW KillParLaCroix
	lower $wlog $NomFenetreOrdali
	
	set wtlog "$wlog.frmt.text"
	frame $wlog.frmt
	scrollbar $wlog.frmt.scroll  -width 8  -command "$wlog.frmt.text yview "
	text $wlog.frmt.text  -height 25 -width 80  -yscrollcommand "$wlog.frmt.scroll set"  -font "Courier 10"  -bg white
	pack $wlog.frmt.text -fill both -side left -expand 1
	pack $wlog.frmt.scroll -side left -fill y
	pack $wlog.frmt -side top
	if {$::tcl_platform(platform) ne "unix"} {
	    bind $wlog.frmt.text <MouseWheel> {%W yview scroll [expr {-%D/120}] units ; break}
	} else {
	    bind $wlog.frmt.text <4> {%W yview scroll -[set Defauts(DeltaYScroll)] units ; break}
	    bind $wlog.frmt.text <5> {%W yview scroll  [set Defauts(DeltaYScroll)] units ; break}
	}
	
	frame $wlog.frmb
	pack $wlog.frmb -side bottom -fill x -padx 5 -pady 10
	
	button $wlog.frmb.save  -text " Save "  -background green1  -command "SauveLeLog"
	button $wlog.frmb.clear  -text " Clear "  -background white  -command {DetruitLogConsole clear}
	button $wlog.frmb.destroy  -text " Close "  -background red  -command [list ToggleAuLog]
	pack $wlog.frmb.destroy $wlog.frmb.clear $wlog.frmb.save -side left -expand 1
	
	set y [expr {[winfo screenheight $wlog] - 2*[winfo reqheight $wlog]}]
	
	wm geom $wlog +0+$y
	
	
	if {[set toPrint [OutputTLog Text $TexteDuLog]] ne ""} {
	    $wtlog insert end $toPrint
	    $wtlog see end
	}
    }
    
    if {$txt ne "JSuisBidon"} {
	append TexteDuLog "${txt}$bn"
	if {[set toPrint [TraiteLogTampon "${txt}$bn"]] ne ""} {
	    $wtlog insert end $toPrint
	    $wtlog see end
	}
    }

    return

}

proc AuPif {{Min 0} {Max 1} {Type Int}} {



    if {![EstCeUnNombre $Min] || ![EstCeUnNombre $Max]} {return ""}
    if {$Max <= $Min} {return ""}
    
    set Diff [expr $Max - $Min]
    set Nombre [expr rand() * $Diff + $Min]
    
    if {$Type == "Int"} {
	set Nombre [expr round($Nombre)]
    }
    return $Nombre


}

proc AuSecours {{quoi ""}} {


if {$quoi != ""} {
demo help-$quoi
return
}

set w .help
toplevel $w
wm title $w "Help on Ordali"
set widgetDemo 1

set font {Helvetica 14}

frame  $w.buttons
pack   $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.ok -background green1 -text "OK" -command "destroy $w"
pack   $w.buttons.ok -anchor s -expand 1

frame $w.statusBar
label $w.statusBar.lab -text "   "  -relief sunken -bd 1  -font $font -anchor w
label $w.statusBar.foo -width 8  -relief sunken -bd 1  -font $font -anchor w
pack $w.statusBar.lab -side left -padx 2 -expand yes -fill both
pack $w.statusBar.foo -side left -padx 2
pack $w.statusBar -side bottom -fill x -pady 2

frame     $w.textFrame
pack      $w.textFrame   -expand 1 -fill both
text      $w.textFrame.t  -yscroll "$w.textFrame.s set"  -wrap word  -width 60 -height 30  -font $font -setgrid 1  -highlightthickness 0  -padx 4 -pady 2  -takefocus 0
scrollbar $w.textFrame.s  -orient vertical  -command "$w.textFrame.t yview"  -highlightthickness 0 -takefocus 0
pack      $w.textFrame.s -side right -fill y
pack      $w.textFrame.t -expand 1 -fill both -padx 1


# Create a bunch of tags to use in the text widget, such as those for
# section titles and demo descriptions.  Also define the bindings for
# tags.

$w.textFrame.t tag configure title -font {Helvetica 24 bold}

# We put some "space" characters to the left and right of each demo description
# so that the descriptions are highlighted only when the mouse cursor
# is right over them (but not when the cursor is to their left or right)
#
$w.textFrame.t tag configure demospace  -lmargin1 1c -lmargin2 1c
$w.textFrame.t tag configure center -justify center


if {[winfo depth $w] == 1} {
$w.textFrame.t tag configure demo  -lmargin1 1c -lmargin2 1c  -underline 1
$w.textFrame.t tag configure visited -lmargin1 1c -lmargin2 1c  -underline 1
$w.textFrame.t tag configure hot  -background black -foreground white
} else {
$w.textFrame.t tag configure demo  -lmargin1 1c -lmargin2 1c  -foreground blue -underline 1
$w.textFrame.t tag configure visited -lmargin1 1c -lmargin2 1c  -foreground "#303080" -underline 1
$w.textFrame.t tag configure hot  -foreground red -underline 1
}

$w.textFrame.t tag bind demo <ButtonRelease-1> {Appel .help.textFrame.t [.help.textFrame.t index {@%x,%y}]}

set lastLine ""

$w.textFrame.t tag bind demo <Enter> {
set lastLine [.help.textFrame.t index {@%x,%y linestart}]
.help.textFrame.t tag add hot "$lastLine +1 chars" "$lastLine lineend -1 chars"
.help.textFrame.t config -cursor hand2
showStatus .help.textFrame.t [.help.textFrame.t index {@%x,%y}]
}

$w.textFrame.t tag bind demo <Leave> {
.help.textFrame.t tag remove hot 1.0 end
.help.textFrame.t config -cursor xterm
.help.statusBar.lab config -text ""
}

$w.textFrame.t tag bind demo <Motion> {
set newLine [.help.textFrame.t index {@%x,%y linestart}]
if {[string compare $newLine $lastLine] != 0} {
.help.textFrame.t tag remove hot 1.0 end
set lastLine $newLine

set tags [.help.textFrame.t tag names {@%x,%y}]
set i [lsearch -glob $tags help-*]
if {$i >= 0} {
.help.textFrame.t tag add hot "$lastLine +1 chars" "$lastLine lineend -1 chars"
}
}
}

# Create the text for the text widget.

$w.textFrame.t insert end "Ordali help" {title center}

$w.textFrame.t insert end {

This is the Ordali help. It is organize in a hierarchical manner. You can at any time remove the help pages open in clicking the Dismiss All button.

}

$w.textFrame.t insert end "General" title
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "1. What is Ordali ?" {demo help-general}
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "2. Main principles" {demo help-principes}
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "3. Further Developments" {demo help-whatnext}
$w.textFrame.t insert end " \n " {demospace}

$w.textFrame.t insert end \n {} "File Menu" title
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "1. Open ..." {demo help-open}
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "2. Close ..." {demo help-close}
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "3. Change Preferences" {demo help-preferences}
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "3. Save Database" {demo help-savedb}
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "3. Load Database" {demo help-loaddb}
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end \n {} "Groups" title
$w.textFrame.t insert end " \n " {demospace}
$w.textFrame.t insert end "1. Without scrollbars." {demo help-entry1}
$w.textFrame.t insert end " \n " {demospace}

$w.textFrame.t configure -state disabled
focus $w.textFrame.s

$w.textFrame.t configure -state disabled



}

proc Aujourdhui {} {


    scan [Today] "%s %s %s %s" S J M A
    set Aujourdhui "[Traduction $S francais] $J [Traduction $M francais] $A"
    return $Aujourdhui


}

proc AutoPathes {} {


    set RivetBob [list /usr/lib/tcltk/rivet2.1 /usr/lib/tcltk/rivet2.1/rivet-tcl /usr/lib/tcltk/rivet2.1/packages /usr/lib/tcltk/rivet2.1/packages-local /usr/lib/tcltk/rivet2.1 /usr/share/tcltk/tcl8.5 /usr/share/tcltk /usr/lib /usr/local/lib/tcltk /usr/local/share/tcltk /usr/lib/tcltk/x86_64-linux-gnu /usr/lib/tcltk /usr/share/tcltk/tcllib1.15 . /usr
/local/ActiveTcl/lib /usr/local/ActiveTcl/lib/tcllib1.14 /usr/local/ActiveTcl/lib/tcl3d0.4.1 /usr/local/ActiveTcl/lib/tklib0.4 /usr/local/ActiveTcl/lib/tclx8.4]
    set RivetEna [list /usr/lib/tcltk/rivet2.1 /usr/lib/tcltk/rivet2.1/rivet-tcl /usr/lib/tcltk/rivet2.1/packages /usr/lib/tcltk/rivet2.1/packages-local /usr/lib/tcltk/rivet2.1 /usr/share/tcltk/tcl8.5 /usr/share/tcltk /usr/lib /usr/local/lib/tcltk /usr/local/share/tcltk /usr/lib/tcltk/x86_64-linux-gnu /usr/lib/tcltk /usr/share/tcltk/tcllib1.15 . /usr/local/ActiveTcl/lib /usr/lib/tclx8.4 /usr/local/ActiveTcl/lib/tcl3d0.4.1 /usr/local/ActiveTcl/lib/tcllib1.14 /usr/local/ActiveTcl/lib/tklib0.4]

    EspionneL [ListsComplement $RivetEna $RivetBob]
    exit


}

proc AutorisationPourPsy {} {



    global AutorisationPourPsy
    if { ! [info exists AutorisationPourPsy]} {
	set AutorisationPourPsy -3
    }

    if { $AutorisationPourPsy==1 } { return 1 }
    if { $AutorisationPourPsy==0 } { return 0 }
    set Cou [Entre "Donnez la plus belle couleur pour une 2cv : "]   
    incr AutorisationPourPsy
    if { ! [regexp -nocase "rouge" $Cou] } { return 0 }
    set AutorisationPourPsy 1
    return 1


}

proc AutreAccessDansGM {X} {


    global LesAccessBanqueDeDecrypthon LesAccessDecrypthonDeBanque

    if {[info exists LesAccessBanqueDeDecrypthon($X)]} { return [set LesAccessBanqueDeDecrypthon($X)] }
    if {[info exists LesAccessDecrypthonDeBanque($X)]} { return [set LesAccessDecrypthonDeBanque($X)] }
    if {[info exists LesAccessDecrypthonDeBanque("EstCharge")]} { return "" }
    set LesAccessDecrypthonDeBanque("EstCharge") 1

    set file2 "/decrypthon/XRefs/GM_REFS";

    foreach Ligne [LesLignesDuFichier $file2] {
        scan $Ligne "%s %s" AD AB
        lappend LesAccessBanqueDeDecrypthon($AD) $AB
        lappend LesAccessDecrypthonDeBanque($AB) $AD
    }
    return [AutreAccessDansGM $X]


}

proc AutreAccessDansXref {X} {


    global LesAccessProtDeDecrypthon LesAccessDecrypthonDeProt

    if {[info exists LesAccessProtDeDecrypthon($X)]} { return [set LesAccessProtDeDecrypthon($X)] }
    if {[info exists LesAccessDecrypthonDeProt($X)]} { return [set LesAccessDecrypthonDeProt($X)] }
    if {[info exists LesAccessDecrypthonDeProt("EstCharge")]} { return "" }
    set LesAccessDecrypthonDeProt("EstCharge") 1

    set file1 "/decrypthon/XRefs/xrefs_red.dump";         

    foreach Ligne [LesLignesDuFichier $file1] {
        scan $Ligne "%s %s" AD AP
        lappend LesAccessProtDeDecrypthon($AD) $AP
        lappend LesAccessDecrypthonDeProt($AP) $AD
    }
    return [AutreAccessDansXref $X]


}

proc AutreCode {X} {


    global RepertoireDuGenome
    global AutreCode

    if { ! [info exists AutreCode]} {
	foreach Ligne [LesLignesDuFichier "$RepertoireDuGenome/fiches/lookup"] {
	    scan $Ligne "%s %s" Nom AA
	    set AutreCode($Nom) $AA
	    set AutreCode($AA)  $Nom
	}
    }
    return [set AutreCode($X)]


}

proc AutreCodeLuc {X} {

    if {! [info exists ::AutreCodeLuc]} {
	InitCode3l1l
    }

    if {[info exists ::AutreCodeLuc($X)]} {
	return [set ::AutreCodeLuc($X)]
    } else {
	set n [string length $X]
	switch $n {
	    1 {return "XXX"}
	    3 {return "X"}
	}
    }

}

proc AutreTest {CodeGscope} {


    
    set RepertoireDeDomaines "[RepertoireDuGenome]/PDBParDomaine/$CodeGscope"
    #faut que je test Si y a un fichier MSF pour ne pas avoir de message d'erreur!!
    set r [glob -directory $RepertoireDeDomaines *.msf]
    foreach fichier $r {
	Espionne "R: $r"
    }


}

proc AutreTest2 {CodeGscope} {


    Espionne $CodeGscope


}

proc AutresNomsAff {quoi} {

    ChangeNomsAff $quoi

    set WdtNom [expr {[PlusLongEltDe $::NomsAffiches]+1}]
    if {$WdtNom < $::Defauts(LongNom)} {
	set currWN [$::NomNomSeq cget -width]
	set diff [expr {$currWN - $WdtNom}]
	set currWT [$::NomTextSeq cget -width]
	
	# update width of widgets
	$::NomNomSeq configure -width $WdtNom
	$::NomTextSeq configure -width [expr {$currWT + $diff}]
	update idletasks
    }

    AfficheNomsEtSeqs
    RepeintNoms

    return

}

proc AvecKegg {Nom} {


    global AvecKegg
    if {[info exists AvecKegg($Nom)]} { return $AvecKegg($Nom) }
    if {[info exists AvecKegg("EstCharge")]} { return "NotAvailable" }
    set AvecKegg("EstCharge") 1
    set FK [Fiches "Kegg"]
    if {[FileAbsent $FK]} { return 0 }
    foreach Ligne [LesLignesDuFichier $FK] {
	set NomLu ""
	scan $Ligne "%s" NomLu
	if {[regexp "Nothing" $Ligne]} {
	    set AvecKegg($NomLu) "Nothing"
	} else {
	    set AvecKegg($NomLu) "Yes"
	}
    }
    return [AvecKegg $Nom]


}

proc AvecPkTable {Table} {


    if {[regexp -nocase "RetinoBase" $Table]} { return 1 }
    if {[WithinGenoret] || [WithinFed]} { return 0 }
    if {[regexp -nocase "^LN_" $Table]} { return 0 }
    return 0
    return 1


}

proc AverageEntropy {LesNbDesClustersDesBranches {NbTotDesBranches ""}} {


    if {$NbTotDesBranches == ""} {
	foreach LesNbDesClustersDeLaBranche $LesNbDesClustersDesBranches {
	    foreach Nb $LesNbDesClustersDeLaBranche {
		set NbTotDesBranches [expr $NbTotDesBranches + $Nb]
	    }
	}
    }
    set AverageEntropy 0
    foreach LesNbDesClustersDeLaBranche $LesNbDesClustersDesBranches {
	set NbDeLaBranche 0
	foreach Nb $LesNbDesClustersDeLaBranche {set NbDeLaBranche [expr $NbDeLaBranche + $Nb]}
	set Entropy        [Entropy $LesNbDesClustersDeLaBranche]
	set PBranche       [expr $NbDeLaBranche * 1.0 / $NbTotDesBranches]

	set AverageEntropy [expr $AverageEntropy + $PBranche * $Entropy]
    }
    return $AverageEntropy


}

proc Axe_R {R} {


    return [lrange $R 1 end]


}

proc BAIOX {Ligne {AcceptIdOnly ""}} {


    set AcceptIdOnly [string equal -nocase "AcceptIdOnly" $AcceptIdOnly]
    scan $Ligne "%s" BAI
    set B ""; set Ac "" ; set Id ""; set OX "" 
    lassign [split $BAI "|"] B Ac Id
    set OX [IntegerApres "OX=" dans $Ligne]

    
    if {$B eq "" || $Ac eq "" || $Id eq "" || $OX eq ""} {
	if {$AcceptIdOnly} {
	    set Ac "Access$BAI"
	    set Id $BAI
	} else {
	    FaireLire "$Ligne\nsomething is wrong"
	}
    }
    return [list $B $Ac $Id $OX]


}

proc BBox3D {L} {

    set xm  9999. ; set ym  9999. ; set zm  9999.
    set xx -9999. ; set yx -9999. ; set zx -9999.
    foreach v $L {
	lassign $v x y z
	if {$x < $xm} {set xm $x}
	if {$y < $ym} {set ym $y}
	if {$z < $zm} {set zm $z}

	if {$x > $xx} {set xx $x}
	if {$y > $yx} {set yx $y}
	if {$z > $zx} {set zx $z}
    }

    return [list $xm $xx $ym $yx $zm $zx]

}

proc BCMT {} {


    global PfamDir

    BCM_setup

    #cd $PfamDir
    LitLeTFA PF01405.12 LNOrdali Sequences
    #DecortiqueUnTFA PF00001.16 LNOrdali Sequences
    puts "len ori [string length [set Sequences([lindex $LNOrdali 0])]]"
    BCM_SamplePfam PF01405.12 LNOrdali Sequences
    foreach n $LNOrdali {
	lappend Ls [set Sequences($n)]
    }
    puts "len avant [string length [lindex $Ls 0]]"
    #set Ls [lrange $Ls 0 15]
    #set LNOrdali [lrange $LNOrdali 0 15]
    set Lso [EnleveColonnesGaps $LNOrdali $Ls]
    puts "len apres [set ap [string length [lindex $Lso 0]]]"
    if {$ap == 0} {
	foreach n $LNOrdali s $Ls {
	    puts "$n $s"
	}
    }
    exit


}

proc BCM_AnalyseRes {} {


    global db GR Lrm
    
    set db root
    sqlite3 $db bench.sql
    $db eval {begin transaction}
    
    set GR(vis) [list]
    set Lgap [lsort -real [$db eval {select distinct gapthr from results}]]
    puts "Number of gap thresholds [llength $Lgap]"
    set GR(Lgap) $Lgap
    set Lmeth [list]
    set Largs [$db eval "select args from results where gapthr=[lindex $Lgap 0]"]
    foreach a $Largs {
	lassign [lindex $a 0] id file meth cm
	lappend Lmeth $meth
    }
    set Lmeth [lsort -unique $Lmeth]
    set GR(Lmeth) $Lmeth
    puts "Number of scoring methods [llength $Lmeth]"
    set Lcm [$db eval {select distinct cm from results}]
    set GR(Lcm) $Lcm
    puts "Number of clustering methods [llength $Lcm]"
    puts "List of parameters done ..."
    
    # Decoupage d'analyse
    set Llim [list 0. 100. 0. 30. 30. 50. 50. 100.]
    foreach {a b} $Llim {
	lappend GR(Llim) "$a $b"
    }
    # pfam stats
    set Lplni [$db eval {select pfamid,lgt,nseqs,idm from pfam}]
    foreach {pfid lgt nseqs idm} $Lplni {
	lappend Lpfamid $pfid
	lappend Llgt $lgt
	lappend Lnseqs $nseqs
	lappend Lidm $idm
    }

    puts ""
    puts "---------------------------------------"
    puts "# Brut Pfam stats "
    puts "---------------------------------------"
    puts ""
    foreach {deb fin} $Llim {
	set midm 0.0 ; set mseqs 0.0 ; set mlgt 0.0
	set midm2 0.0 ; set mseqs2 0.0 ; set mlgt2 0.0
	set count 0
	foreach idm $Lidm nseqs $Lnseqs lgt $Llgt {
	    if {! ($idm >= $deb && $idm < $fin)} {
		continue
	    }
	    
	    set midm [expr {$midm + $idm}]
	    set mlgt [expr {$mlgt + $lgt}]
	    set mseqs [expr {$mseqs + $nseqs}]
	    
	    set midm2  [expr {$midm2 + $idm*$idm}]
	    set mlgt2  [expr {$mlgt2 + $lgt*$lgt}]
	    set mseqs2 [expr {$mseqs2 +$nseqs*$nseqs}]

	    incr count
	}
	puts "# $deb - $fin "
	puts "Number of elements ..  $count"
	set midm [expr {$midm / $count}]
	set sdidm [expr {sqrt($midm2/double($count) - $midm*$midm)}]
	puts [format "mean/sd identity ....  %6.2f/%6.2f" $midm $sdidm]
	set mlgt [expr {double($mlgt) / $count}]
	set sdlgt [expr {sqrt(double($mlgt2)/$count - $mlgt*$mlgt)}]
	puts [format "mean/sd length ......  %6.2f/%6.2f" $mlgt $sdlgt]
	set mseqs [expr {double($mseqs) / $count}]
	set sdseqs [expr {sqrt(double($mseqs2)/$count - $mseqs*$mseqs)}]
	puts [format "mean/sd nbr seqs ....  %6.2f/%6.2f" $mseqs $sdseqs]
    }

    # global stats
    foreach pfid $Lpfamid {
	set LSA [$db eval {select r.posAl from residues as r, pfam as p where  r.pk_pfam=p.pk_pfam and  p.pfamid=$pfid and  (r.type='CSA' or r.type='Prosite')  }]
	
	set tmp [list]
	foreach e $LSA {
	    if {[string is list -strict $e]} {
		lappend tmp {*}$e
	    } elseif {$e eq "" || $e == {} || $e eq "{}"} {
		continue
	    } else {
		lappend tmp $e
	    }
	}
	set LSA [lsort -unique -integer $tmp]
	set TLSA($pfid) $LSA
    }
    puts "List of Pfam done ..."
    puts ""

    if {0} {
	GAR
	$db eval {commit}
	$db close
	return
    }

    array set Lrm [list]
    foreach {pcmin pcmax} $Llim {
	# take pfam under consideration
	set Lpfamid [lsort -unique -dictionary [$db eval {select pfamid from pfam where idm > $pcmin and idm <= $pcmax}]]
	set LSpfamid [list]
	set nLSA 0
	foreach z $Lpfamid {
	    lappend LSpfamid "'$z'"
	    incr nLSA [llength [set TLSA($z)]]
	}
	
	# gap threshold
	foreach gt $Lgap {
	    # methodes clustering
	    foreach cm $Lcm {
		unset -nocomplain T
		set Lpkresag [$db eval "select pk_results,job,args from results where job in ([join $LSpfamid ,]) and cm=''$cm'' and gapthr=$gt"]
		set Lpkres [list]
		foreach {pk job ar} $Lpkresag {
		    lassign [lindex $ar 0] tmp tmp mth tmp
		    lappend T($mth,pkr) $pk
		    set T($pk) $job
		}
		
		# par methode de scoring 
		set nTot 0
		foreach meth $Lmeth {
		    set Lpkres [set T($meth,pkr)]
		    if {$Lpkres == {}} {
			puts "Aucune valeur !\n"
			continue
		    }
		    
		    set npkr [llength $Lpkres]
		    set nTP 0 ; set nFP 0
		    set nTN 0 ; set nFN 0
		    set nFind 0
		    foreach pkr $Lpkres {
			set Lfl [$db eval {select pos,lgt from results where pk_results=$pkr}]
			lassign $Lfl Lfind lgt
			set Lfind [lsort -unique -integer $Lfind]
			incr nFind [llength $Lfind]
			set pfid [set T($pkr)]
			set LSA  [set TLSA($pfid)]
			incr nTot $lgt

			set TP [ListsIntersection $Lfind $LSA]
			set nbTP [llength $TP]
			set FN [lor $LSA $Lfind from1]
			set nbFN [llength $FN]
			set FP [lor $LSA $Lfind from2]
			set nbFP [llength $FP]
			set nbTN [expr {$lgt - [llength $LSA] - $nbFN}]
			
			foreach v {TP FP TN FN} {
			    incr n$v [set nb$v]
			}
		    }
		    # Sens= VraiPos / (VraiPos + FauxNeg)
		    set sens [expr {1.0*$nTP/($nTP+$nFN)}]
		    # Spec= VraiNeg / (VraiNeg +FauxPos)
		    set spec [expr {1.0*$nTN/($nTN+$nFP)}]
		    # Power
		    set power [expr {$sens+$spec-1.}]
		    lappend Lrm($pcmin,$pcmax,$gt,$cm) [list $meth $sens $spec $power $nTot $nLSA $nFind $npkr]
		}
	    }
	}
    }

    GAR
    $db eval {commit}
    $db close
    return

    #
    # Create output
    foreach {pcmin pcmax} $Llim {
	set Ltot [list]
	puts "\n=================="
	puts "# $pcmin - $pcmax"
	puts "------------------\n"
	foreach gt $Lgap {
	    set tmp [lindex [array names Lrm "$pcmin,$pcmax,$gt,*"] 0]
	    lassign [lindex $Lrm($tmp) 0] x y z k nTot nLSA nFind nres
	    puts ""
	    puts "Gap Threshold ..........: $gt"
	    puts "Nbr total colonnes .....: $nTot"
	    puts "Nbr sites vrais ........: $nLSA"
	    foreach cm $Lcm {
		puts "Clustering method ......: $cm\n"
		
		set Lval [list]
		foreach v [lsort [set Lrm($pcmin,$pcmax,$gt,$cm)]] {
		    lassign $v meth sens spec power nTot nLSA nFind npkr
		    lappend Lval $v
		    lappend Ltot [list {*}$v $gt $cm]
		    puts [format "%6.4f %6.4f %6.4f | %4d | %s" $sens $spec $power $npkr $meth]
		}

		# 10 meilleurs sens
		foreach {titre idx} [list Sensibility 1 Specificity 2 Power 3] {
		    puts "\n$titre"
		    set Lval [lsort -decreasing -real -index $idx $Lval]
		    set i 1
		    puts "   | sensib specif power  | sco. meth."
		    foreach v [lrange $Lval 0 9] {
			lassign $v me ss sp pw nf
			puts [format "%2d | %6.4f %6.4f %6.4f | %5d | %s" $i $ss $sp $pw $nf $me]
			incr i
		    }
		}
		puts ""
	    }
	}
	# stats globales
	puts "\n======================"
	puts "| Best of "
	puts "======================\n"
	foreach {titre idx} [list Sensibility 1 Specificity 2 Power 3] {
	    puts "\n$titre"
	    set Ltot [lsort -decreasing -real -index $idx $Ltot]
	    set i 1
	    puts "   | sensib specif power  | gapT ClusM "
	    foreach v [lrange $Ltot 0 9] {
		lassign $v me ss sp pw tmp tmp tmp gt cm
		puts [format "%2d | %6.4f %6.4f %6.4f | %4.2f %s %s" $i $ss $sp $pw $gt $cm $me]
		incr i
	    }
	}
    }
    
    $db eval {commit}
    $db close
    
    exit


}

proc BCM_CheckIDs {Lpdb2id pfamid} {


    global LNOrdali Sequences LSOrdali

    # cree id "propres"
    set tmp [list]
    foreach n $LNOrdali {
	lappend tmp [lindex [split $n "/"] 0]
    }

    set Ldel [list]
    foreach {pk id} $Lpdb2id {
	if {$id ni $tmp} {
	    lappend Ldel $pk
	    puts "  !! $id not present !!"
	}
    }

    # enleve de Lpdbid
    if {$Ldel != {}} {
	set nl [list]
	foreach {pk id} $Lpdb2id {
	    if {$pk in $Ldel} {continue}
	    lappend nl $pk $id
	}
	set Lpdb2id $nl
    }

    return $Lpdb2id


}

proc BCM_CreateJobs2Do {} {


    global Dbcm dres

    # - liste pfam2do
    set Lpkpfam [lsort -integer [$::db eval {select pk_pfam from pfam}]]
    #set Lpkpfam [lrange $Lpkpfam 0 50]
    puts "nbr pfam a faire : [llength $Lpkpfam]"
    
    $dres eval {begin transaction}
    foreach pk $Lpkpfam {
	$dres eval {insert into tests values (NULL,$pk,NULL,'-1',0)}
	lappend Lj2d [list $pk ""]
    }
    $dres eval {commit}
    puts "Nbr jobs a faire [llength $Lpkpfam]"

    return $Lj2d


}

proc BCM_CreateJobs2Do_Tests {{PTest ""}} {


    global Dbcm db

    if {$PTest eq ""} {
	# - liste pfam2do
	set Lpkpfam [BCM_TriePfam2Do]
    } else {
	set Lpkpfam [$db eval {select pk_pfam from pfam where pfamid=$PTest}]
    }
    puts "nbr pfam a faire : [llength $Lpkpfam]"

    # liste des fonction scoring
    #   -> 5 paquets (cf Valdar) :
    #       - symbol frequency
    #       - symbol entropy
    #       - stereochemical
    #       - stereochemically sensitive entropy SSE
    #       - substitution matrix
    #
    
    #set Lmeth [list Liu Dist Liu2 VolPol RPCA Williamson Kabat Entrop1]
    #set Lmeth [list Thompson Liu2 RPCA Williamson Kabat Entrop1]
    set Lmeth [list BILD Thompson Entrop1 Liu2 Williamson Kabat RPCA Norm SanderSP Peivar Karlin Valdar Capra Wang Caffrey]

    set LGrMeth [list  [list Kabat]  [list Norm RPCA]  [list Wang Capra]  [list Entrop1 Williamson Caffrey]  [list Karlin BILD Thompson SanderSP Valdar Peivar Liu2]]
    
    #  -> faire les paires entre categories
    set Lmdbl [list]
    if {1} {
	set i 1 ; set tmp [list]
	foreach g1 [lrange $LGrMeth 0 end-1] {
	    foreach g2 [lrange $LGrMeth $i end] {
		foreach m1 $g1 {
		    foreach m2 $g2 {
			lappend tmp [list $m1 $m2]
		    }
		}
	    }
	    incr i
	}
	set Lmdbl $tmp
    }

    # -> faire les triplets
    set Lmtpl [list]
    if {0 && [llength $Lmeth] > 2} {
	set i 1; set j 2; set tmp [list]
	foreach m1 [lrange $Lmeth 0 end-2] {
	    foreach m2 [lrange $Lmeth $i end-1] {
		foreach m3 [lrange $Lmeth $j end] {
		    lappend tmp [list $m1 $m2 $m3]
		}
		incr j
	    }
	    incr i
	}
	set Lmtpl $tmp
    }

    if {$Lmdbl != {} } {
	lappend Lmeth {*}$Lmdbl
    }
    if {$Lmtpl != {} } {
	lappend Lmeth {*}$Lmtpl
    }

    # clustering methods
    set Lmclus [list mixturemodel secator dpc]

    set Lj2d [list]
    foreach pk $Lpkpfam {
	set pfamid [$db eval {select pfamid from pfam where pk_pfam=$pk}]
	set fpfam [lindex [lsort [glob -nocomplain [file join /genomics/link/Pfam "${pfamid}*"]]] end]

	foreach m $Lmeth {
	    foreach cm $Lmclus {
		lappend Lj2d [list $pfamid [list $pk $fpfam $m $cm]]
	    }
	}
    }
    puts "Nbr jobs [llength $Lj2d]"

    return $Lj2d


}

proc BCM_CreeBenchmarkPfam {} {


    global db dps ConsRef PfamDir ListePDB LNOrdali Sequences T

    BCM_setup

    set dps rpros
    sqlite3 $dps Prosite.sql
    set db root
    sqlite3 $db bench.sql

    # Inits
    set ListePDB [list]

    # CSA
    BCM_LoadCSADB

    # - pdbmap : lien pfam <-> pdb
    # -> prend id pdb et id pfam
    
    $db eval {begin transaction}

    set Lpf [lsort -unique -dictionary [$db eval {select pfamid from pdbmap}]]
    puts "nbr of pfam .... : [llength $Lpf]"

    #set fin 10
    set fin end
    foreach pfamid [lrange $Lpf 0 $fin] {
	puts "\n$pfamid"
	puts "----------"
	set pfile [lindex [lsort [glob -nocomplain [file join $PfamDir "${pfamid}*_smp"]]] end]
	
	set pk [lindex [$db eval {select pk_pfam from pfam where pfamid=$pfamid}] 0]

	# Read alignment
	puts "reading [file join $PfamDir $pfile]"
	DecortiqueUnTFA [file join $PfamDir $pfile] LNOrdali Sequences
	foreach n $LNOrdali {
	    set nid [lindex [split $n "/"] 0]
	    set T($nid) $n
	}

	# -> cherche pdb du pfam
	set Lpdbv [$db eval {select pdbid,chn,acc,id,pdeb,pfin,sdeb,sfin from pdbmap where pfamid=$pfamid}]
	puts "Nbr potentials PDB .....: [expr {[llength $Lpdbv]/8}]"

	# -> dans CSA	
# -> corespondance res CSA -> ali pfam
	BCM_MapCSA2Pfam $Lpdbv $pfile

	# -> residues interface
	# -> correspondance res interface -> ali pfam
	BCM_MapInterface2Pfam $Lpdbv $pfile

	# -> residues PROSITE
	BCM_MapProsite2Pfam $Lpdbv $pfile

	unset -nocomplain LNOrdali Sequences T LSOrdali
	update
    }

    $db eval {commit}
    $db close
    $dps close

    exit


}

proc BCM_CreeThread {} {


    global TDT 

    thread::errorproc BCM_ThreadError
    set Id [thread::create]
    set TDT($Id) $Id
    thread::configure $Id -unwindonerror 1
    thread::send $Id {
	set GscopeDir $env(GSCOPEDIR)
	set OrdaliDejaSource 1
	source [file join $GscopeDir gscope_source.tcl]    
	
	set OrdaliDir $env(ORDALIDIR)
	set OrdaliDejaSource 0
	source [file join $OrdaliDir src ordali_source.tcl]
	
	InitLesDefauts
	LesDefauts Mode batch
	
	package require Thread
	#LoadTclPackages
	#package require tclcluspack
	package require tclordalie
	#package require sqlite3
	set VariablesAuDepart [info globals]
	
	source /home/moumou/gscopublic/bcm.tcl
	source /home/moumou/gscopublic/bcm_setup.tcl
	source /home/moumou/gscopublic/bcm_run.tcl

	BCM_setup
    }
    puts "thread $Id created ([llength [thread::names]]) ...\n"
    flush stdout

    trace add variable TDT($Id) write BCM_RecupResults
    update

    return $Id


}

proc BCM_DoTests {} {


    global db dres CestFini TDT nThreads TMaster nDone Dbcm

    package require Thread

    puts "[DonneDateEtHeure]"
    set TMaster [thread::id]
    puts "\nThread Master : $TMaster\n"

    BCM_setup

    set nDone 0
    # old table 
    set db root
    sqlite3 $db bench.sql
    file delete -force dres.sql
    set dres [FabriqueDeTables $Dbcm(TableRes) dres dres.sql]

    # creation des jobs
    #set dres dres
    #sqlite3 $dres dres2.sql
    BCM_CreateJobs2Do

    set CestFini 0
    # Creation des threads et preserved
    set nThreads 20
    #set nThreads 135

    set listeID [list]
    thread::errorproc BCM_ThreadError
    for {set i 1} {$i < $nThreads} {incr i} {
	set Id [BCM_CreeThread]
	lappend ListeID $Id
    }
    foreach Id $ListeID {
	BCM_DonneUnJob $Id
    }

    # lance l'event loop du master
    vwait CestFini

    foreach a [array names TDT "tid*"] {
	if {[regexp {,} $a]} {continue}
	
	puts "trace $a [join [trace info variable $a] \n]"
    }
	
    $db close

    # Creation des Index
    $dres eval {begin transaction}
    $dres eval {create index idx_results on results (pk_tests,cm, gapthr, TP, FP, TN, FN)}
    $dres eval {commit}
    $dres close

    puts "[DonneDateEtHeure]"

    exit


}

proc BCM_DonneUnJob {lId} {


    global CestFini nDone TDT dres db
    
    set pkmin [$dres eval {select min(pk_tests) from tests where thread='-1'}]
    if {! [string is integer -strict $pkmin]} {
	puts "\nAll done !\nReleasing threads $lId ...\nNbr threads [llength [thread::names]]\n"
	set CestFini 1
	update

	return
    }
    
    set pkpfmeth [$dres eval {select pk_tests,pk_pfam,smeth from tests where pk_tests=$pkmin}]
    lassign $pkpfmeth pktest pkpfam Lmeth
    $dres eval {update tests set thread=$lId where pk_tests=$pkmin}
    set pfamid [$db eval {select pfamid from pfam where pk_pfam=$pkpfam}]

    set fpfam [glob [file join /home/moumou/work/moumou/BenchPfam "${pfamid}*"]]

    # cherche Vrai Positifs
    #set LVP [lsort -unique [$db eval {select posAl from residues where pk_pfam=$pkpfam}]]

    #pdbid 
    set Lpdb2id [$db eval {select pk_pdbmap,id from pdbmap where pfamid=$pfamid}]
    
    #set TDT($lId,Data) [list $pkpfam $pfam $Lmeth]
    set TDT($lId,Data) [list $pkpfam $fpfam]
    #thread::send -async $lId [list ::BCM_ThreadExe $pkpfam $pfam $Lmeth $LVP] TDT($lId)
    thread::send -async $lId [list ::BCM_ThreadExe $pkpfam $fpfam $Lpdb2id] TDT($lId)

    #puts "pkpfmeth $pkmin $pkpfmeth pour $lId"
    incr nDone
    if {! ($nDone % 1000)} {
	puts "... $nDone done ([llength [thread::names]]) [DonneDateEtHeure]"
	flush stdout
	update idletasks
    }
    update

    return


}

proc BCM_Init {} {


    global db PfamDir Dbcm Tsite

    # Init variables
    BCM_setup

    # cree db pour :
    # -> CSA
    #file delete -force bench.sql
    set db [FabriqueDeTables $Dbcm(tables) "" bench2.sql]
    puts "tables crees ..."

    # traite pdb mapped to pfam
    set Ll [LesLignesDuFichier [file join $PfamDir pdbmap]]
    puts "Nbr pdb mappes..... : [llength $Ll]"

    set badnum 0
    foreach l $Ll {
	set l [string map [list ";" ""] $l]
	set Lv [split $l "\t"]
	lassign $Lv idpdb chn pdf nmpfam idpfam acc adf
	lassign [split $pdf -] pd pf

	if {! [string is integer -strict $pd] || ! [string is integer -strict $pf]} {
	    incr badnum

	    continue
	}

	lassign [split $adf -] ad af

	if {! [info exists Psite($idpdb,$chn)]} {
	    set Psite($idpdb,$chn) [list]
	}
	lappend Psite($idpdb,$chn) [list $pd $pf $idpfam $acc $ad $af]
    }
    puts "bad numbering ..... : $badnum" 
    puts ""
    puts "Cross-check with CSA"

    set Lcsa [lsort -unique [BCM_LoadCSADB]]
    set nsite 0
    set Lpdb [list] ; set Lacc [list]
    $db eval {begin transaction}
    foreach k [array names Psite] {
	lassign [split $k ,] pdbid chn
	lappend Lpdb $pdbid
	set Ls [list]

	foreach kt [array names Tsite "$k,*"] {
	    lappend Ls {*}[set Tsite($kt)]
	}
	foreach Ldf [set Psite($k)] {
	    lassign $Ldf deb fin pfamid acc ad af
	    lappend Lacc $acc
	    foreach v $Ls {
		lassign $v nm nb
		if {$nb >= $deb && $nb <= $fin} {
		    $db eval {insert into pdbmap values (NULL,$pfamid,$pdbid,$chn,$deb,$fin,$acc,NULL,$ad,$af)}
		    incr nsite
		}
	    }
	}
    }
    $db eval {commit}
    puts "bad numbering ..... : $badnum" 
    puts "Nbr sites ......... : $nsite"
    puts "Nbr pdbs .......... : [llength [lsort -unique $Lpdb]]"

    set Lacin [lsort -unique $Lacc]
    set Lid [IDMapping "ACC+ID" ID $Lacin]
    puts ""
    puts "doublons access :"
    puts " in     [llength $Lacc]"
    puts " unique [llength $Lacin]"

    $db eval {begin transaction}
    set i 0
    foreach acc $Lacin id $Lid {
	if {$id eq ""} {
	    lappend Ldel $acc
	} else {
	    $db eval {update pdbmap set id=$id where acc=$acc}
	    incr i
	}
    }
    puts "Nbr UNmapped Access : [llength $Ldel]"
    puts "Nbr mappend........ : $i"
    foreach acc $Ldel {
	$db eval {delete from pdbmap where acc=$acc}
    }
    puts "-> reste en db..... : [$db eval {select count(pk_pdbmap) from pdbmap}]"
    $db eval {commit}

    if {0} {
	# doublons PFAM/ID pdb
	$db eval {begin transaction}
	set Lv [$db eval {select pfamid,id from pdbmap}]
	set Lpi [list]
	foreach {p i} $Lv {
	    lappend Lpi [list $p $i]
	}
	set Lpi [lsort -unique $Lpi]
	set Ldel [list]
	foreach e $Lpi {
	    lassign $e p i
	    set Lv [$db eval {select pk_pdbmap,sdeb,sfin from pdbmap where pfamid=$p and id=$i}]
	    set Ltpl [list]
	    foreach {a b c} $Lv {
		lappend Ltpl [list $a $b $c]
	    }
	    set Ltpl [lsort -unique -index 1 -integer  $Ltpl]
	    # is here only once
	    if {[llength $Ltpl] == 1} {
		continue
	    }
	    
	    set Lv [list]
	    foreach e $Ltpl {
		lappend Lv {*}$e
	    }
	    set Lv [lassign $Lv pkm sd0 sf0]
	    set lmax [expr {$sf0-$sd0+1}]
	    foreach {pk sd sf} $Lv {
		if {$sd >= $sf0} {
		    # new range
		    set sd0 $sd
		    set sf0 $sf
		    set pkm $pk
		    set lmax [expr {$sf0-$sd0+1}]
		    continue
		}
		
		if {($sf - $sd + 1) > $lmax} {
		    # don't keep old max
		    lappend Ldel $pkm
		    # define new max
		    set pkm $pk
		    set sd0 $sd
		    set sf0 $sf
		    set lmax [expr {$sf0-$sd0+1}]
		} else {
		    # not a max, delete
		    lappend Ldel $pk
		}
	    }
	}
	puts "doublon ID deb/fin par Pfam : [llength $Ldel]"
	if {[llength $Ldel] > 0} {
	    $db eval "delete from pdbmap where pk_pdbmap in ([join $Ldel ,])"
	}
	$db eval {commit}
	$db eval {vacuum}
	
	puts ""
	puts "TOTAL ENTRIES...... : [$db eval {select count(pk_pdbmap) from pdbmap}]" 
    }	

    # udate pfam table
    set Lv [lsort -unique [$db eval {select pfamid from pdbmap}]]
    $db eval {begin transaction}
    foreach pfamid $Lv {
	$db eval {insert into pfam values(NULL,$pfamid,NULL,NULL,NULL,NULL,NULL)}
    }
    $db eval {commit}
    $db eval {vacuum}

    # indexes
    $db eval {create index idx_pdbmap on pdbmap (pfamid, pdbid, chn, pdeb, pfin, acc, id, sdeb, sfin)}
    $db eval {create index idx_pfam on pfam (pfamid, nseqs, lgt)}
    $db close

    exit
    return


}

proc BCM_LoadCSA {} {


    global Tsite
    
    set Ll [LesLignesDuFichier [file join /home moumou ordali typify csa CSA_2_2_12.dat]]
    set nris 0
    foreach e [lrange $Ll 1 end] {
	# PDB ID,SITE NUMBER,RESIDUE TYPE,CHAIN ID,RESIDUE NUMBER,CHEMICAL FUNCTION,EVIDENCE TYPE,LITERATURE ENTRY
	lassign [split $e ,] pdbid snb rtype chn rnmr tmp tmp tmp

	set pdbid [string toupper $pdbid]
	if {[set res [AutreCodeLuc $rtype]] eq "XXX"} {
	    continue
	}

	if {! [info exists Tsite($pdbid,$chn,$snb)]} {
	    set Tsite($pdbid,$chn,$snb) [list]
	}
	lappend Tsite($pdbid,$chn,$snb) [list $res $rnmr]
	lappend Lpdb $pdbid
	incr nris
    }
    set Lpdb [lsort -unique $Lpdb]
    puts "CSA :"
    puts "-----"
    puts "Nombre pdbId .......... :[llength $Lpdb]"
    puts "Nombre res in sites ... : $nris"
    puts ""

    return $Lpdb


}

proc BCM_LoadCSADB {} {


    global Tsite

    if {[file exists sites_csa_data.tcl]} {
	source [file join /home moumou ordali typify sites_csa_data.tcl]
	foreach k [array names Tsite] {
	    incr nris [llength $Tsite($k)]
	}
	puts "CSA :"
	puts "-----"
	puts " ==> from file >sites_csa_data.tcl<"
	puts "Nombre pdbId .......... : [llength $Lpdb]"
	puts "Nombre res in sites ... : $nris"
	puts ""

	return $Lpdb
    }

    sqlite3 d [file join /home moumou ordali typify CSA_TABLES.db]
    d eval {begin transaction}
    
    # recupere sites annotes
    set La [d eval {select pdbId,type,number,chain,siteNumber from CSA_catalyticResidues}]
    # prend les homologues
    set Lh [d eval {select pdbId,residue,number,chain,siteNumber from CSA_homologueResidues}]
    set Lsites [concat $La $Lh]
    d eval {commit}
    d close
 
    # traitement
    set Lpdb [list]
    foreach {pdbid type nbr chn snb} $Lsites {
	set pdbid [string toupper $pdbid]
	set type [string toupper $type]
	if {[AutreCodeLuc $type] eq "X"} {
	    continue
	}

	if {$pdbid ni $Lpdb} {
	    lappend Lpdb $pdbid
	}

	if {! [info exists Tsite($pdbid,$chn,$snb)]} {
	    set Tsite($pdbid,$chn,$snb) [list]
	}
	set add [list $type $nbr]
	if {$add ni [set Tsite($pdbid,$chn,$snb)]} {
	    lappend Tsite($pdbid,$chn,$snb) $add
	    incr nris
	}
    }

    puts "CSA :"
    puts "-----"
    puts "Nombre pdbId .......... : [llength $Lpdb]"
    puts "Nombre res in sites ... : $nris"
    puts ""

    return $Lpdb


}

proc BCM_MapCSA2Pfam {Lpdbv pfam} {


    global db PfamDir Tsite ConsRef LNOrdali Sequences T

    set pfamid [lindex [split [file tail $pfam] .] 0]
    set pk [lindex [$db eval {select pk_pfam from pfam where pfamid=$pfamid}] 0]

    set nsf 0
    foreach {pdb chn acc id pd pf sd sf} $Lpdbv {
	if {! [info exists T($id)]} {
	    puts "error !"
	    puts "no T for $id (pdb $pdb acc $acc"
	    #exit
	    continue
	}
	set idn [set T($id)]

	# are there some CSA sites ?
	set La [array names Tsite "$pdb,$chn,*"]
	if {$La == {}} {
	    puts "No CSA sites found in $pdb $chn !"
	    continue
	}

	# take correspondance
	set nsf 0
	foreach a $La {
	    set Lres [set Tsite($a)] 
	    foreach rtn $Lres {
		lassign $rtn res rnb
		set rnm [AutreCodeLuc $res]
		# out from alignment
		if {$rnb < $pd || $rnb > $pf} {
		    continue
		}
		
		# Correspondance
		# 
		# PDB : 11  14        18
		# Seq : 15  18        22
		#     : A.DEF...GF...IL
		# Ali : 1   4         8
		# Mem : 0   3         7
		# 
		set x [expr {$rnb+($sd-$pd)-$sd}]
		set c [DonnePosSG $idn $x]
		lappend ConsRef($pf,CSA) $c
		$db eval {insert into residues values(NULL,$pk,$x,$c,'CSA')}
		incr nsf
	    }
	}
    }
    puts "Nombre site CSA ...... : $nsf"

    return


}

proc BCM_MapInterface2Pfam {Lpdbv pfam} {


    global PfamDir ConsRef db LNOrdali Sequences T

    # pdb list to retreive
    set Lpdb [list]
    foreach {pdb chn acc id pd pf sd sf} $Lpdbv {
	lappend Lpdb $pdb
    }
    set nri 0
    set pk [lindex [$db eval {select pk_pfam from pfam where pfamid=$pfamid}] 0]
    foreach {pdb chn acc id pd pf sd sf} $Lpdbv {
	if {! [info exists T($id)]} {
	    puts "$id not present !"
	    continue
	}
	set n [set T($id)]

	# -> search PDBe interface ID pdb
	set xml [PDBeInterface $pdb]
	if {[string range $xml 0 5] ne "<pisa_"} {
	    puts "  !! PB retrieving pdb interface files !!"
	    continue
	}

	# -> retrieve interface residues for chain
	set Lres [ResiduesInterface $xml $pdb $chn]
	if {$Lres == {}} {
	    puts "Pas de residue interface in $pdb $chn !"

	    continue
	}
	
	# take correspondance
	set nri 0
	foreach r $Lres {
	    lassign $r rnb res
	    set rnm [AutreCodeLuc $res]
	    # out from alignment
	    if {$rnb < $pd || $rnb > $pf} {
		continue
	    }
	    # Correspondance
	    # 
	    # 15  18        22
	    # A.DEF...GF...IL
	    # 1   4         8
	    # 0   3         7
	    # 
	    set x [expr {$rnb+($sd-$pd)-$sd}]
	    set c [DonnePosSG $n $x]
	    lappend ConsRef($pf,Int) $c
	    $db eval {insert into residues values(NULL,$pk,$x,$c,'Interface')}

	    incr nri
	}
    }
    puts "Nombre residue Interface .. : $nri"

    return


}

proc BCM_Pdb2Pfam {pfamid Lpdb2id} {


    # checking if PDB IDs are present
    set Lpdb2id [BCM_CheckIDs $Lpdb2id $pfamid]

    # -> stats de pfam ID :
    # nseq, lg, min-max gaps, pci m - sd
    set Lout [BCM_PfamStats $pfamid $Lpdb2id]

    return $Lout


}

proc BCM_PfamStats {pfamid Lpdb2id} {


    global PfamDir LPCI LNOrdali Sequences LSOrdali

    set Nseq [llength $LNOrdali]
    puts "    Nombre sequences ..... : $Nseq"
    set Lgt  [string length [set Sequences([lindex $LNOrdali 0])]]
    puts "    Longueur initiale .... : $Lgt"

    # Nbr pdb dans le pfam
    puts "    IDs mapped to pdb .... : [expr {[llength $Lpdb2id]/2}]"

    # 1st sampling if more than 5000 seqs
    if {$Nseq > 5000} {
	puts "==> too many seqs -> samplling 3000"
	BCM_SamplePfam $Lpdb2id $pfamid LNOrdali Sequences 5000
	set Nseq [llength $LNOrdali]
	set LSOrdali [list]
	foreach n $LNOrdali {
	    lappend LSOrdali [set Sequences($n)]
	}
    }
    
    # remove seqs with 100% identity
    BCM_RemoveIdentities $Lpdb2id $pfamid LNOrdali Sequences 
    set LSOrdali [list]
    foreach n $LNOrdali {
	lappend LSOrdali [set Sequences($n)]
    }
    
    # PROSITE filter
    set fname "[TmpFile toto /tmp].[thread::id]"
    EcritLeTfa $fname $LNOrdali $LSOrdali
    set Lps [LesPrositesDuTFA $fname]
    file delete -force $fname
    file delete -force "${fname}.out"
    set Lnp [list]
    if {$Lps != {} } {
	foreach {acc Lv} $Lps {
	    foreach {p Lp} $Lv {
		lappend TP($p) $acc
	    }
	}
	set Lpat [array names TP]
	puts "    Patterns PROSITES ..... : $Lpat"
	set Lnp [list] ; set Lpf [list]
	# align final  < 500 seqs, so
	set ThrProsite 500 
	foreach p $Lpat {
	    set nocc [llength [set TP($p)]]
	    puts "    $p $nocc"
	    if {$nocc > $ThrProsite} {
		lappend Lnp $p
	    }
	}

	# prosite patterns have been choosen
	if {[llength $Lnp] > 1} {
	    set Lpf [set TP([lindex $Lnp 0])]
	    foreach p [lrange $Lnp 1 end] {
		set Lpf [land $Lpf [set TP($p)]]
	    }
	} elseif {[llength $Lnp] == 1} {
	    set Lpf [set TP($Lnp)]
	}

	if {[llength $Lpf] > 0} {
	    puts "    Nbr seq prosite ... : [llength $Lpf]"
	    set LNOrdali $Lpf
	    # 
	    # ATTENTION !
	    # ici on ENLEVE les pdb qui n'ont pas le
	    # motif prosite !!
	    set Lidn [list]
	    foreach n $LNOrdali {
		lappend Lidn [lindex [split $n /] 0]
	    }
	    set Ldel [list]
	    foreach {pk id} $Lpdb2id {
		if {$id ni $Lidn} {
		    lappend Ldel $pk
		}
	    }
	    if {$Ldel != {} } {
		set nl [list]
		foreach {pk id} $Lpdb2id {
		    if {$pk in $Ldel} {continue}
		    lappend nl $pk $id
		}
		set Lpdb2id $nl
	    }
	}
	set LSOrdali [list]
	foreach n $LNOrdali {
	    lappend LSOrdali [set Sequences($n)]
	}
    }
    puts ""

    # final sampling
    set Nseq [llength $LNOrdali]
    if {$Nseq > 500} {
	puts "==> too many seqs -> 1000"
	BCM_SamplePfam $Lpdb2id $pfamid LNOrdali Sequences
	set Nseq [llength $LNOrdali]
	set LSOrdali [list]
	foreach n $LNOrdali {
	    lappend LSOrdali [set Sequences($n)]
	}
    }
    
    # final round of gap removal
    set LSOrdali [EnleveColonnesGaps]
    unset -nocomplain Sequences
    foreach n $LNOrdali s $LSOrdali {
	set Sequences($n) $s
    }
    set Lgt [string length [set Sequences([lindex $LNOrdali 0])]]
    puts "    Longueur actuelle .... : $Lgt"

    # compute identities
    set SAli [list]
    foreach n $LNOrdali {
	lappend SAli $n [set Sequences($n)]
    }
    set LPCI [CalculeLesPCIGenerique $SAli]
    array set TPCI $LPCI
    
    # write stats ...
    set pf $pfamid
    set Nseq [llength $LNOrdali]
    set Lgt  [string length [set Sequences([lindex $LNOrdali 0])]]
    puts "    Nbr sequences ........ : $Nseq"
    puts "    Longueur ............. : $Lgt"

    # moyenne et ecart-type
    set Lv [list]
    foreach a $LNOrdali {
	foreach b $LNOrdali {
	    lappend Lv "$a,$b" [set TPCI($a,$b)]
	}
    }
    lassign [SM_StatPCI $Lv] m sd tmp tmp
    set PCIm $m
    set PCIsd $sd

    puts "    Identite moyenne ..... : [format %6.2f $m]"
    puts "    Identite ecart-type .. : [format %6.2f $sd]"
    set Lout [list $Nseq $Lgt $m $sd $Lnp]

    return $Lout


}

proc BCM_Puts {txt} {


    global PTxt

    if {! [info exists PTxt]} {set PTxt ""}
    if {$txt eq "decharge"} {return $PTxt}
    append PTxt "$txt\n"

    return


}

proc BCM_RecupResults {a b op} {


    global TDT db dres
    
    set Lres [set TDT($b)]
    if {[string range $Lres 0 4] ne "tid0x" || ! [string is list -strict $Lres]} {
	# on est en train de traiter une erreur !!
	puts "==> $b : $Lres\n$::errorInfo"

	after 1000
	set tid $b
	trace remove variable TDT($tid) write BCM_RecupResults
	
	set Larg [set TDT(${tid},Data)]
	if {[thread::exists $tid]} {
	    catch {thread::release $tid}
	}
	array unset TDT "${tid}*"
	update
	
	set pkt [$dres eval {select pk_tests from tests where thread=$tid}]

	# met le job du thread à -1
	$dres eval {update tests set res=-1,thread=0 where pk_tests=$pkt}
	
	puts "sort error\n$pkt $Larg [llength [thread::names]]"
	set b [BCM_CreeThread]
	after 1000
	BCM_DonneUnJob $b
	update

	return
    }

    lassign $Lres Id pkpfam smeth Lval
    if {$b ne $Id} {
	puts "\nProblem\n$b ne $Id !"
	flush stdout
	set b $Id
    }
    update idletasks
    
    set pkt [$dres eval {select pk_tests from tests where thread=$tid}]
    $dres eval {update tests set res=$ires,thread='0' where pk_tests=$pkt}
    set pfamid [$db eval {select pfamid from pfam where pk_pfam=$pkpfam}]

    lassign $Lval Nseq Lgt m sd Lpro

    $db eval {insert into pfam values(NULL,'$pfamid',NULL,$Nseq,$Lgt,$m,$sd)}
    foreach p $Lpro {
	$db eval {insert into propfam values(NULL,'$p','$pfamid')}
    }
    
    update

    BCM_DonneUnJob $b

    return

    if {0} {
	set YaErr 0
	set LErr [list]
	if {[llength $Lval] == 0} {
	    set YaErr 1
	    lappend LErr "Aucune valeurs !"
	}
	set Lcm [list "'dpc'" "'mm'" "'secator'"]
	foreach res $Lval {
	    lassign $res cm gap Lpos
	    if {$cm ni $Lcm} {set YaErr 1}
	    if {! [string is double $gap]} {set YaErr 1}
	    if {! [string is list -strict $Lpos]} {set YaErr 1}
	    
	    if {$YaErr} {
		lappend LErr $res
	    } else {
		if {[catch {$dres eval "insert into results values(NULL,$pkt,[join $res ,])"} Msg]} {
		    set YaErr 1
		    lappend LErr $res
		    lappend LErr $Msg
		}
	    }
	}
	
	set ires 1
	if {$YaErr} {
	    puts "\nProblem $b!\npkt $pkt smeth $smeth pfam $pkpfam\n[join $LErr \n]\n"
	    flush stdout
	    set ires -1
	}
	
	$dres eval {update tests set res=$ires,thread='0' where pk_tests=$pkt}
	
	update
	
	BCM_DonneUnJob $b
    }

    return


}

proc BCM_RemoveIdentities {Lpdb2id pfamid aL aS} {


    upvar $aL L $aS S

    foreach n $L {
	set sq [set S($n)]
	if {[info exists TDes3000($sq)]} {continue}
	set TDes3000($sq) 1
	set pn [lindex [split $n / ] 0]
	set NDes3000($pn) 1
	lappend Lsd $n
    }

    #
    # ACHTUNG !
    # a same pdbid can be present several times !
    # as several zones can match the current pfam !
    set Lpdbid [list]
    foreach {pk id} $Lpdb2id {
	lappend Lpdbid $id
    }
    set add 0 ; set prs 0
    foreach n $L {
	set idn [lindex [split $n "/"] 0]
	if {$idn in $Lpdbid} {
	    if {$n ni $Lsd} {
		lappend Lsd $n
		incr add
	    } else {
		incr prs
	    }
	    update
	}
    }
    puts "    PDB in db ....... : [llength $Lpdbid]"
    puts "    PDB presents .... : $prs"
    puts "    PDB rajoutes .... : $add"

    update
    
    return


}

proc BCM_SamplePfam {Lpdb2id pfamid aL aS {Nsmp 500}} {


    upvar $aL L $aS S

    set Lpris [list] ; set Lres [list]
    set lg [llength $L]
    set n 0
    while {$n < $Nsmp} {
	set i [expr {int(rand()*$lg)}]
	if {$i in $Lpris} {continue}

	lappend Lres [lindex $L $i]
	lappend Lpris $i
	incr n
    }

    # check if we have corresponding pdbs in sample
    #
    # ACHTUNG !
    # a same pdbid can be present several times !
    # as several zones can match the current pfam !
    set Lpdbid [list]
    foreach {pk id} $Lpdb2id {
	lappend Lpdbid $id
    }
    set add 0 ; set prs 0
    foreach n $L {
	set idn [lindex [split $n "/"] 0]
	if {$idn in $Lpdbid} {
	    if {$n ni $Lres} {
		lappend Lres $n
		incr add
	    } else {
		incr prs
	    }
	    update
	}
    }
    puts "    PDB in db ....... : [llength $Lpdbid]"
    puts "    PDB presents .... : $prs"
    puts "    PDB rajoutes .... : $add"

    # cree le nouveau pfam
    set Lseq [list]
    foreach n $Lres {
	lappend Lseq [set S($n)]
	set A($n) [set S($n)]
    }

    unset S
    set L $Lres
    array set S [array get A]
    update

    return


}

proc BCM_SplitPfamBrut {} {


    # take the fasta pfam file from ftp
    # split it into PFxxxxx files
    cd /genomics/link/Pfam
    set f [open Pfam-A.fasta r]
    set open 0 ; set pf "" ; set Lpf [list]
    while {[gets $f l] >= 0} {
	if {[string index $l 0] eq ">"} {
	    # nouvelle seq
	    set lori $l
	    regsub -all { +} [string trim $l] " " l
	    set l [string map [list " " ";"] $l]
	    set pf [lindex [split $l ";"] 2]
	    lappend Tpf($pf) $lori
	} else {
	    lappend Tpf($pf) $l
	}
    }
    foreach pf [array names Tpf] {
	set o [open $pf w]
	puts $o [join [set Tpf($pf)] \n]
	close $o
    }

    exit


}

proc BCM_StatDB {} {


    global db

    BCM_setup

    set db root
    sqlite3 $db bench.sql
    $db eval {begin transaction}

    set nZero 0
    set nColCSA 0 ; set nColInt 0 ; set nCol 0
    set lgtCSA 0  ; set lgtInt 0  ; set lgtT 0
    set npCSA 0   ; set npInt 0   ; set npT 0

    set Lpkpfam [$db eval {select pk_pfam,pfamid from pfam}]
    foreach {pkpfam pfam} $Lpkpfam {
	set nInt [$db eval {select count(pk_residues) from residues where pk_pfam=$pkpfam and type='Interface'}]
	set nCSA [$db eval {select count(pk_residues) from residues where pk_pfam=$pkpfam and type='CSA'}]
	set nPro [$db eval {select count(pk_residues) from residues where pk_pfam=$pkpfam and type='Prosite'}]
	if {$nInt == 0 && $nCSA == 0 && $nPro == 0} {
	    incr nZero
	    continue
	}
	
	set lgt [$db eval {select lgt from pfam where pk_pfam=$pkpfam}]

	if {$nInt != 0 && $nCSA != 0 && $nPro != 0} {
	    incr npT
	    incr nCol $nInt
	    incr nCol $nCSA
	    incr nCol $nPro
	    incr lgtT $lgt
	} elseif {$nCSA == 0} {
	    incr npInt
	    incr nColInt $nInt
	    incr lgtInt $lgt
	} else {
	    incr npCSA
	    incr nColCSA $nCSA
	    incr lgtCSA $lgt
	}
    }
    $db eval {commit}
    $db close

    set fmt "%3d %5d %6d %5.2f"
    puts "Zero $nZero"
    puts "CSA+Int : [format $fmt $npT $nCol $lgtT [expr {100.*$nCol/$lgtT}]]"
    puts "que Int : [format $fmt $npInt $nColInt $lgtInt [expr {100.*$nColInt/$lgtInt}]]"
    puts "que CSA : [format $fmt $npCSA $nColCSA $lgtCSA [expr {100.*$nColCSA/$lgtCSA}]]"
    
    exit


}

proc BCM_ThreadError {tid stack} {


    global TDT nThreads dres TMaster

    if {$tid eq $TMaster} {
	puts "\nMASTER Error\n$stack\n"
	flush stdout
	
	return
    }

    puts stdout "\nError dans le thread $tid\n$stack"
    flush stdout

    trace remove variable TDT($tid) write BCM_RecupResults

    set Larg [set TDT($tid,Data)]
    after 100
    if {[thread::exists $tid]} {
	puts "... deleting thread $tid"
	flush stdout
	thread::release $tid
    }
    array unset TDT "${tid}*"
    update

    set pkt [$dres eval {select pk_tests from tests where thread=$tid}]
    # met le job du thread à -1
    $dres eval {update tests set res=-1,thread=0 where pk_tests=$pkt}

    if {[llength [thread::names]] < $nThreads} {
	set Id [BCM_CreeThread]
	after 1000
	BCM_DonneUnJob $Id
    }
    update
    
    return


}

proc BCM_ThreadExe {pkpfam fpfam Lpdb2id} {


    global Sequences LNOrdali LSOrdali 

    set tid [thread::id]
    set t1 [clock milliseconds]

    unset -nocomplain Sequences LNOrdali LSOrdali

    set pfamid [lindex [split [file tail $fpfam] .] 0]

    # lit le fichier
    DecortiqueUnTFA $fpfam LNOrdali Sequences
    
    set Lout [BCM_Pdb2Pfam $pfamid $Lpdb2id]

    # finish
    EcritLeTfa "${fpfam}_smp" $::LNOrdali $::LSOrdali

    #FermeFichier

    set LRT [list $tid $pkpfam "" $Lout]

    return $LRT


}

proc BCM_ThreadExe_Tests {pkpfam pfam Lmscore LVP} {


    global Sequences LNOrdali LSOrdali ListeDesPiliersDuGroupe LNDG SDG TbScores ListeScore LongueurTotale ConsMeth
    
    # use executable -> exe or library -> lib
    set how "exe"
    #set how "lib"

    #puts "[thread::id] start job ..."
    #flush stdout

    set tid [thread::id]
    set t1 [clock milliseconds]

    unset -nocomplain Sequences LNOrdali LSOrdali
    unset -nocomplain SDG LNDG TbScores ListeDesPiliersDuGroupe

    set pfamid [lindex [split [file tail $pfam] .] 0]

    # lit le fichier
    DecortiqueUnTFA $pfam LNOrdali Sequences
    set LongueurTotale [string length [set Sequences([lindex [array names Sequences] 0])]]
    
    # calcule score
    set LNDG GroupeToutLeMonde
    set SDG(GroupeToutLeMonde) $LNOrdali    

    CreeLesPiliers

    # prepare pour scores
    set TbScores(Lcols) $Lmscore
    if {[llength $Lmscore] > 1} {
	set Scale 1
    } else {
	set Scale 0
    }
    set LRT [list $tid $pkpfam $Lmscore]
    set Lrcm [list]
    set Lthrgap [list 0.005 0.1 0.25 0.5 0.7]
    #set Lthrgap [list 0.01]
    foreach pcgap $Lthrgap {
	LesDefauts PCThrGap $pcgap

	unset -nocomplain ListeScore
	array unset TbScores "Score,*"
	update

	foreach mscore $Lmscore {
	    set sco [ScoreDe$mscore [set ListeDesPiliersDuGroupe(GroupeToutLeMonde)]] 
	    if {$Scale} {
		set sco [CentreData $sco -999.0]
	    }
	    set TbScores(Score,$mscore) $sco
	}

	CreeListeScore

	set Lori $ListeScore
	set LgS [llength $ListeScore]
	if {$LgS < 2} {
	    # Probleme : nb cols < 2
	    puts "\nListeScore=0\n$Lmscore $pcgap $pfamid"
	    flush stdout

	    continue
	}

	if {$how eq "exe"} {
	    set o [file tempfile fdat]
	    foreach l $Lori {
		puts $o [join $l \t]
	    }
	    close $o
	    update idletasks
	    catch {file copy $fdat [file tail $fdat]}
	}

	# pour chaque meth clustering
	set Lres [list]
	foreach cm [list dpc mixturemodel secator] {
	    set Lval $Lori

	    # Fait clusters
	    switch $cm {
		"dpc" {
		    if {$how eq "lib"} {
			set Lgr [Tclcluspack $Lval -dt coordinates -cm kmeans -nbc dpc -wc]
		    } else {
			set cmd [list /biolo/cluspack/binNew/cluspack $fdat -dt=coordinates -cm=kmeans -nbc=dpc -wc]
		    }
		    set lab dpc
		}
		"secator" {
		    if {$how eq "lib"} {
			set Lgr [Tclcluspack $Lval -dt coordinates -cm hierar -nbc secator -wc]
		    } else {
			set cmd [list /biolo/cluspack/binNew/cluspack $fdat -dt=coordinates -cm=hierar -nbc=secator -wc]
		    }
		    set lab secator
		}
		"mixturemodel" {
		    if {$how eq "lib"} {
			set Lgr [Tclcluspack $Lval -dt coordinates -cm mm -nbc aic -wc]
		    } else {
			set cmd [list /biolo/cluspack/binNew/cluspack $fdat -dt=coordinates -cm=mm -nbc=aic -wc]
		    }
		    set lab mm
		}
	    }
	    if {$how eq "exe"} {
		if {[catch {exec {*}$cmd >& ${tid}.log} Msg]} {
		    puts stderr "Pb Cluspack\n$Msg"
		    puts stderr "[ContenuDuFichier ${tid}.log]"
		    flush stderr
		}
		
		# lit clusters
		if {[file exists "${fdat}.clu"]} {
		    set Lres [TraiteResultatClustering "${fdat}.clu" ""]
		} else {
		    puts "log cluspack :\n[ContenuDuFichier ${tid}.log]"
		    flush stdout
		
		    continue
		}
		file delete -force ${tid}.log ${fdat}.clu
	    } else {
		set fdeb [open deb.txt w]
		puts $fdeb [join $Lval \n]
		puts $fdeb "------------"
		puts $fdeb [join $Lgr \n]
		close $fdeb
		set Lres [TraiteResultatClusteringTcl $Lgr ""]
	    }
	    
	    set Ltrouve [lindex $Lres 1]
	    set res [list "'$lab'" $pcgap $Ltrouve $LgS]
	    lappend Lrcm $res
	}
	if {$how eq "exe"} {
	    file delete -force [file tail $fdat] $fdat
	}
    }
    
    FermeFichier
    lappend LRT $Lrcm

    return $LRT


}

proc BCM_TriePfam2Do {} {


    global db

    BCM_setup

    set Lbonpk [list]
    set Lpk [$db eval {select pk_pfam from pfam where nseqs > 5}]
    puts "Lpk [llength $Lpk]"
    foreach pk $Lpk {
	set nres [$db eval {select count(pk_residues) from residues where pk_pfam=$pk}]
	if {$nres > 0} {
	    lappend Lbonpk $pk
	}
    }

    return [lsort -integer -unique $Lbonpk]


}

proc BCM_UploadPfam {} {


    global TPfam

    # take the fasta pfam file from ftp
    # split it into PFxxxxx files
    cd /genomics/link/Pfam
    set f [open Pfam-A.fasta r]
    set open 0 ; set pf "" ; set Lpf [list]
    while {[gets $f l] >= 0} {
	if {[string index $l 0] eq ">"} {
	    # nouvelle seq
	    set lori $l
	    regsub -all { +} [string trim $l] " " l
	    set l [string map [list " " ";"] $l]
	    set pf [lindex [split $l ";"] 2]
	    lappend TPfam($pf) $lori
	} else {
	    lappend TPfam($pf) $l
	}
    }

    return


}

proc BCM_corrDB {} {


    BCM_setup

    set db root
    sqlite3 $db bench.sql
    
    $db eval {begin transaction}
    set Lpkpfs [$db eval {select pk_pfam,pfamid from pfam}]
    set chm [file join /home moumou work moumou BenchPfam]
    foreach {pk pf} $Lpkpfs {
	set f [glob [file join $chm "${pf}*_smp"]]
	LitLeTFA $f Ln Sq
	set lg [string length [set Sq([lindex $Ln 0])]]
	$db eval {update pfam set lgt=$lg where pk_pfam=$pk}
	unset -nocomplain Sq
	set Ln {}
    }
    $db eval {commit}
    $db close
	    
    exit


}

proc BCM_setup {} {


    global Dbcm PfamDir
    
    set PfamDir "/genomics/link/Pfam/"
    set Dbcm(tables) "
    - pdbmap : mapping pdb pfam {
	. pk_pdbmap P
	. pfamid V7
	. pdbid V4
	. chn V1
	. pdeb I
	. pfin I
	. acc V20
	. id V20
	. sdeb I
	. sfin I
    }
    - propfam : lien prosite - pfam {
	. pk_propfam P
	. prosite V7 nom du prosite (PS00118)
	. pfamid V7 nom pfam (PF00068)
    }
    - pfam : info sur le pfam {
	. pk_pfam P
	. pfamid V7
	. name V128
	. nseqs I
	. lgt I
	. idm R identite moyenne
	. idsd R sd de identite
    }
    - residues : residues conserves dans les pfam {
	. pk_residues P
	. pk_pfam I
	. posSq I
	. posAl I
	. type V3
    }
    - results : resultat de test {
	. pk_results P
	. pk_tests I
	. job V128
	. args T
	. cm V12 clustering method
	. gapthr R threshold pour gap
	. pos T positions list
	. lgt I length of alignment with gapthr
    }
    "
    
    set Dbcm(TableRes) "
    - tests : tests a faire {
	. pk_tests P 
	. job T
	. args T methodes scoring
	. thread V32
	. res I -1 error, 0 pas fait, 1 ok
    }
    "

    return


}

proc BLASTDatabase_ICDS {{FichierIn ""} {FichierOut ""}} {



    Wup "Permet de creer une banque blast a partir du fichier TFA"
   
    if {$FichierIn == ""} {
	set RepBanque "[RepertoireDuGenome]"
	set FichierIn    [glob -nocomplain -directory "$RepBanque" "*.fasta"]
    }
    if {! [file exists $FichierIn]} {return ""}

    if {$FichierOut == ""} {
	regsub {\.[a-z]+$} $FichierIn "" FichierOut
    }
    
    set Title "ICDS_[file tail $FichierIn]"

    set Cmdformadb "formatdb  -i $FichierIn  -o T  -t $Title  -p F  -n $FichierOut"

    if {[catch {eval exec $Cmdformadb} Message]} {Warne "Error in Formatdb command:\n>>>>$Message"}
    return ""


}

proc BLAT {{query ""} {output ""} {Databases ""} {Outstyle BLAST}} {



    Wup "BLAT program is BLAST Like Alignment Tool"
    Wup "It is optimised to align mRNA or DNA fragment onto genomes"
    Wup "BLAT can be run in Server way with complete database indexes loaded in memory."
    Wup "gfServer permits to load and start a server."
    Wup "gfClient permits to submit sequences to the server."
    Wup "Output can be set to looks like blast output"

    if {$Databases=="" || $query=="" || $output==""} {
	Espionne "BLAT use is database (or file containing list of database) query and output."
	Espionne "BLAT database can be fasta or pultiple fasta files or .nib (BLAT own Format)"
	return ""
    }

    if {! [file exists $query] || ! [file exists $Databases]} {
	Espionne "Problem with own of query and Databases files do not exists."
	return ""
    }

    if {[regexp -nocase "blast" $Outstyle]} {
	set Outstyle [string tolower $Outstyle]
    }

    #/biolo/blatSrc/bin/blat mouse.tfa human.tfa /genomics/g1/Actin/nuctfa/ACT0001 -q=rna -out=blast ACT0001.blat

    set BLAT "[BLATDIR]/blat"

    set Option "-out=$Outstyle"

    set CommandeBlat "eval exec $BLAT $Databases $query $Option $output"

    if {[catch {eval $CommandeBlat} Message]} {
	Espionne "Problem with $output"
	Espionne $Message
    }
    return $output


}

proc BLATDIR {} {

 

    Wup "BLAT bin or source directory"

    global BLATSourceDir
    if {[info exists BLATSourceDir] && [file exists $BLATSourceDir]} {return $BLATSourceDir}
    set BLATSourceDir "/biolo/blatSrc/bin/x86_64"

    return $BLATSourceDir


}

proc BLATGenomeDir {Genome} {

 

    Wup "Genome directory"
    
    return "[UCSCGenomeDir $Genome]"


}

proc BLATGenomePort {Genome} {

 

    Wup "Genome associated Port for BLAT"

    global BLATGenomePort
    if {[info exists BLATGenomePort($Genome)]} {return [set BLATGenomePort($Genome)]}

    switch -exact -- $Genome {
	"human"   {set BLATGenomePort($Genome) 50000}
	"mouse"   {set BLATGenomePort($Genome) 51000}
	"mstigr"  {set BLATGenomePort($Genome) 52000}
	"default" {return ""}
    }
 
    if {[info exists BLATGenomePort($Genome)]} {return [set BLATGenomePort($Genome)]}

    return ""


}

proc BLATPourTous {DirIn DirOut Databases {Outstyle BLAST}} {




    if {! [file exists "[RepertoireDuGenome]/${DirIn}"]} {
	Espionne "Problem input directory do not exists."
	return ""
    }

    if {![file exists "[RepertoireDuGenome]/${DirOut}"]} {
	file mkdir "[RepertoireDuGenome]/${DirOut}"
    }

    if {! [file exists $Databases]} {
	Espionne "Problem with Databases files do not exists."
	return ""
    }


    if {[regexp -nocase "blast" $Outstyle]} {
	set Outstyle [string tolower $Outstyle]
    }

    set LesPABs [ListeDesPABs]

    foreach PAB $LesPABs {
	set input  "[RepertoireDuGenome]/$DirIn/${PAB}"
	set output "[RepertoireDuGenome]/$DirOut/${PAB}"

	#Espionne "BLAT $PAB $output $Databases $Outstyle"
	BLAT $input $output $Databases $Outstyle
    }
    return ""


}

proc BLATServerName {} {

 

    Wup "Server Name associated for BLAT"

    global BLATServerName
    if {[info exists BLATServerName(Server)]} {return [set BLATServerName(Server)]}

    set BLATServerName(Server) "star6"

    if {[info exists BLATServerName(Server)]} {return [set BLATServerName(Server)]}

    return ""


}

proc BLAT_client {{Input ""} {Output ""} {DirOuGenome ""} {Outstyle ""} {Host ""} {Port ""} {OptionSup ""}} {



    Wup "BLAT program is BLAST Like Alignment Tool"
    Wup "It is optimised to align mRNA or DNA fragment onto genomes"
    Wup "BLAT can be run in Server way with complete database indexes loaded in memory."
    Wup "gfServer permits to load and start a server."
    Wup "gfClient permits to submit sequences to the server."
    Wup "Output can be set to looks like blast output"

    if {$Input  == ""} {
	Espionne "BLAT_client Usage is: Input \[complete file path\] Output \[same\] Organism \[human mouse\] (optional Outstyle \[blast\] Host \[star6\] Port \[linked to Organism\])"
	return ""
    }
    if {$Output == ""} {
	set  FileExt [file extension $Input]
	if {$FileExt != ""} {
	    regsub "$FileExt" $Input ".blat" Output
	} else {
	    set Output "${Input}.blat"
	}
    }

    if {$Port     == ""} {set Port     [BLATGenomePort $DirOuGenome]}
    if {$Host     == ""} {set Host     [BLATServerName]}
    if {$Outstyle == ""} {set Outstyle "blast"}

    if {[regexp -nocase "blast" $Outstyle]} {
	set Outstyle [string tolower $Outstyle]
    }
    set OptionsClient "-out=$Outstyle"
    if {$OptionSup!=""} { append OptionsClient " $OptionSup" }

    #/biolo/blatSrc/bin/gfClient [BLATServerName] 50000 ACT0015 ACT0015.blat -out=blast

    set BLAT "[BLATDIR]/gfClient"

    #Le "" dans la commande correspond a l option nibDir qui est le chemin relatif ou sont situe les fichier .nib"
    set CommandeBlat "$BLAT $Host $Port \"\" $Input $Output $OptionsClient"
    Espionne "$CommandeBlat"

    if {[catch {eval exec $CommandeBlat} Message]} {
	Espionne "Problem with $Output"
	Espionne $Message
    }
    return ""


}

proc BLAT_clientPourTous {{DirIn ""} {DirOut ""} {DirOuGenome ""} {Outstyle ""} {Host ""} {Port ""} {OptionSup ""}} {



    Wup "BLAT program is BLAST Like Alignment Tool"
    Wup "It is optimised to align mRNA or DNA fragment onto genomes"
    Wup "BLAT can be run in Server way with complete database indexes loaded in memory."
    Wup "gfServer permits to load and start a server."
    Wup "gfClient permits to submit sequences to the server."
    Wup "Output can be set to looks like blast output"

    #DirIn  directory where to find queries tfa files 
    #DirOut directory where to store results

    if {$DirIn=="" && $DirOut==""} {
	#Espionne "BLAT_clientPourTous Usage is: DirIn \[Input complete dir path\] DirOut \[same for output\] Organism \[human mouse\] (optional Outstyle \[blast\] Host \[star6\] Port \[linked to Organism\])"
	return ""
    }

    if {! [file exist