#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <tcl.h>

#ifndef DLLEXPORT
#define DLLEXPORT __declspec(dllexport)
#endif 

/*
 * Prototypes
 */
int Ccode_DoBootstrap (ClientData cdata,
		       Tcl_Interp *interp,
		       int objc,
		       Tcl_Obj * CONST objv[]);
int Ccode_Pairwise (ClientData cdata, 
		    Tcl_Interp *interp, 
		    int objc, 
		    Tcl_Obj * CONST objv[]);
int Ccode_Pairwise2 (ClientData cdata, 
		     Tcl_Interp *interp, 
		     int objc, 
		     Tcl_Obj * CONST objv[]);

double SeqMatch(char *seq1, 
		char *seq2, 
		int l);
double SeqMatch2(char *seq1,
		 char *seq2,
		 int l);
/*
 * fin Prototypes
 */

double SeqMatch(char *seq1, 
		char *seq2, 
		int l) 
{
  int r, i;
  
  r = 0;
  for (i=0;i<l;i++) {
    if (seq1[i] != '.' && seq1[i] == seq2[i]) r++;
  }
  
  return (double)r;
}


double SeqMatch2(char *seq1,
		 char *seq2,
		 int l)
{
  int r, i, total;
  double score;
  
  r = total = 0;
  for (i=0;i<l;i++) {
    if (seq1[i] != '.' && seq2[i] != '.') {
      total++;
      if (seq1[i] == seq2[i]) r++;
    }
  }
  
  if (total==0) 
    score=0.0;
  else 
    score = 100.0*(double)r/(double)total;

  return score;
}


int Ccode_DoBootstrap (ClientData cdata,
		       Tcl_Interp *interp,
		       int objc,
		       Tcl_Obj * CONST objv[]) 
{
  char *pil, **tseq;
  int ip, nseq, i, j, lgSeq;
  double dist, rd, **tres, l1, l2, *tlg;
  time_t t;
  Tcl_Obj *seqObj, *Mres;	
  
  if (Tcl_ListObjLength(interp,objv[1],&lgSeq) != TCL_OK) 
    return TCL_ERROR;
  if (lgSeq == 0) {
    Mres = Tcl_NewListObj(0,NULL);
    Tcl_SetObjResult(interp,Mres);
    return TCL_OK;
  }

  Tcl_ListObjIndex(interp,objv[1],0,&seqObj);
  Tcl_GetStringFromObj(seqObj,&nseq);
  //fprintf(stderr,"nseq %d lseq %d\n",nseq,lgSeq);

  /* initialise random number generator */
  srand((unsigned) time(&t));

  /* Allocate memory */
  tseq = (char **)ckalloc(nseq*sizeof(char *));
  tres = (double **)ckalloc(nseq*sizeof(double *));
  tlg = (double *)ckalloc(nseq*sizeof(double));
  for (i=0; i<nseq; i++) { 
    tseq[i] = (char *)ckalloc(lgSeq*sizeof(char));
    tres[i] = (double *)ckalloc(nseq*sizeof(double));
    tlg[i] = 0.0;
  }
  /* end memory allocation */
  
  /* create random sequence from pilars */
  for (i=0; i<lgSeq; i++) {
    rd = ((double)rand()/((double)(RAND_MAX)+(double)(1)));
    ip = (int)(rd*(double)lgSeq);
    //fprintf(stderr,"%d %f ",ip,rd);
    
    Tcl_ListObjIndex(interp,objv[1],ip,&seqObj);
    pil = Tcl_GetString(seqObj);
    for (j=0; j<nseq; j++) {
      tseq[j][i]=pil[j];
      if (pil[j] != '.') 
	tlg[j] += 1.;
    }
  }
  //fprintf(stderr,"\n");

  /*
    for (i=0; i<nseq; i++) {
    fprintf(stderr,"%d ",i);
    for (j=0; j<lgSeq; j++)
    fprintf(stderr,"%c",tseq[i][j]);
    fprintf(stderr,"\n");
    }
  */

  /* compute distance matrix */
  for (i=0; i<nseq; i++) {
    tres[i][i] = 0.0;
    l1=tlg[i];
    for (j=i+1; j<nseq; j++) {
      l2=tlg[j];
      if (l1 == 0 || l2 == 0) 
	dist = 1.0;
      else 
	dist = 1. - (SeqMatch(tseq[i],tseq[j],lgSeq)/(l1<l2?l1:l2));
      tres[i][j] = tres[j][i] = dist;
    }
  }
  
  /* output distance matrix */
  Mres = Tcl_NewListObj(0,NULL);
  for (i=0; i<nseq; i++) {
    for (j=0; j<nseq; j++) {
      Tcl_ListObjAppendElement(interp,Mres,Tcl_NewDoubleObj(tres[i][j]));
    }
  }
  
  Tcl_SetObjResult(interp,Mres);

  /* Desallocate memory */
  ckfree((char *)tlg);
  for (i=0;i<nseq;i++) {
    ckfree((char *)tseq[i]);
    ckfree((char *)tres[i]);
  }
  ckfree((char *)tres);
  ckfree((char *)tseq);

  return TCL_OK;
}


int Ccode_Pairwise (ClientData cdata, 
		    Tcl_Interp *interp, 
		    int objc, 
		    Tcl_Obj * CONST objv[]) 
{
  char **tseq;
  int nseq, i, j, strLen, l;
  Tcl_Obj *seqObj, *Tpci, *pair;
  double **tres, *tlg, dist, l1, l2;
  
  if (Tcl_ListObjLength(interp,objv[1],&nseq) != TCL_OK) {
    return TCL_ERROR;
  }
  Tcl_ListObjIndex(interp,objv[1],0,&seqObj);
  Tcl_GetStringFromObj(seqObj,&strLen);
  
  /* allocation */
  tseq = (char **)ckalloc(nseq*sizeof(char *));
  tres = (double **)ckalloc(nseq*sizeof(double *));
  for (i=0; i<nseq; i++) { 
    tseq[i] = (char *)ckalloc((strLen+1)*sizeof(char));
    tres[i] = (double *)ckalloc(nseq*sizeof(double));
  }
  tlg =(double *)ckalloc(nseq*sizeof(double));  
  /* end allocation */
  
  /* fill in sequence and lengths arrays */
  for (i=0;i<nseq;i++) {
    Tcl_ListObjIndex(interp,objv[1],i,&seqObj);
    strcpy(tseq[i],Tcl_GetString(seqObj));
    l=0;
    for (j=0;j<strLen;j++) {
      if (tseq[i][j] != '.') l++;
    }
    tlg[i]=(double)l;
  }
  
  /* compute all pairwise identities */
  for (i=0; i<nseq-1; i++) {
    for (j=i+1; j<nseq; j++) {
      tres[i][j] = tres[j][i] = SeqMatch(tseq[i],tseq[j],strLen);
    }
  }
  
  /* create outpout list */
  Tpci = Tcl_NewListObj(0,NULL);
  for (i=0; i<nseq; i++) {
    l1=tlg[i];
    tres[i][i]=(double)l1;
    for (j=0; j<nseq; j++) {
      l2=tlg[j];
      pair = Tcl_NewListObj(0,NULL);
      
      if (l1 == 0 || l2 == 0) {
	dist = 0.0;
      } else {
	dist = tres[i][j]/(l1<=l2?l1:l2);
      }
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewDoubleObj(dist));
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewIntObj(l1));
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewIntObj(l2));
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewDoubleObj((l1<l2?(double)(l1)/l2:(double)(l2)/l1)));
      Tcl_ListObjAppendElement(interp,Tpci,pair);
    }
  }
  
  Tcl_SetObjResult(interp,Tpci);

  /* desallocation */
  ckfree((char *)tlg);
  for (i=0; i<nseq; i++) { 
    ckfree((char *)tres[i]);
    ckfree((char *)tseq[i]);
  }
  ckfree((char *)tres);
  ckfree((char *)tseq);
  /* fin desallocation */

  return TCL_OK;
}


int Ccode_Pairwise2 (ClientData cdata, 
		     Tcl_Interp *interp, 
		     int objc, 
		     Tcl_Obj * CONST objv[]) 
{
  char **tseq;
  int nseq, i, j, strLen;
  Tcl_Obj *Tpci, *seqObj;
  double **tres;
  
  if (Tcl_ListObjLength(interp,objv[1],&nseq) != TCL_OK) {
    return TCL_ERROR;
  }
  
  Tcl_ListObjIndex(interp,objv[1],0,&seqObj);
  Tcl_GetStringFromObj(seqObj,&strLen);
  
  /* Memory allocation */
  tseq = (char **)ckalloc(nseq*sizeof(char *));
  tres = (double **)ckalloc(nseq*sizeof(double *));
  for (i=0; i<nseq; i++) { 
    tseq[i] = (char *)ckalloc((strLen+1)*sizeof(char));
    tres[i] = (double *)ckalloc(nseq*sizeof(double));
  }
  
  for (i=0; i<nseq; i++) { 
    Tcl_ListObjIndex(interp,objv[1],i,&seqObj);
    strcpy(tseq[i],Tcl_GetString(seqObj));
  }

  /* fill results array */
  for (i=0; i<nseq-1; i++) {
    for (j=i+1; j<nseq; j++) {
      tres[i][j] = tres[j][i] = SeqMatch2(tseq[i],tseq[j],strLen);
    }
  }

  /* fill in tcl output list */
  Tpci = Tcl_NewListObj(0,NULL);
  for (i=0; i<nseq; i++) {
    tres[i][i]=100.0;
    for (j=0; j<nseq; j++)
      Tcl_ListObjAppendElement(interp,Tpci,Tcl_NewDoubleObj(tres[i][j]));
  }
  
  Tcl_SetObjResult(interp,Tpci);

  /* desallocate memory */
  for (i=0;i<nseq;i++) {
    ckfree((char *)tseq[i]);
    ckfree((char *)tres[i]);
  }
  ckfree((char *)tseq);
  ckfree((char *)tres);
  
  return TCL_OK;
}


int DLLEXPORT Tclordalie_Init(Tcl_Interp *interp) 
{
  if (Tcl_InitStubs(interp, "8.4" , 0) == 0L) {
    return TCL_ERROR;
  }
    
  Tcl_CreateObjCommand(interp,"Ccode_DoBootstrap",Ccode_DoBootstrap,NULL,NULL);
  Tcl_CreateObjCommand(interp,"Ccode_Pairwise",Ccode_Pairwise,NULL,NULL);
  Tcl_CreateObjCommand(interp,"Ccode_Pairwise2",Ccode_Pairwise2,NULL,NULL);

  Tcl_PkgProvide(interp,"tclordalie","0.1");

  return TCL_OK;
}

/*

  Bonjour Alexandre !

  Merci pour ta rponse sur c.l.t ! Ca semble marcher !
  Je me permets de t'crire pour que , si tu as 5 minutes, tu m'claires afin que je sois un peu plus efficace dans mes debuggages.

  Je travaille avec valgrind pour reprer les fuites de mmoires de mes extensions. 


*/


