ID   Q3UG34_MOUSE            Unreviewed;       207 AA.
AC   Q3UG34;
DT   11-OCT-2005, integrated into UniProtKB/TrEMBL.
DT   11-OCT-2005, sequence version 1.
DT   02-MAR-2010, entry version 31.
DE   SubName: Full=Putative uncharacterized protein;
GN   Name=Fxn;
OS   Mus musculus (Mouse).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi;
OC   Muroidea; Muridae; Murinae; Mus.
OX   NCBI_TaxID=10090;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   STRAIN=C57BL/6J;
RX   PubMed=16141072; DOI=10.1126/science.1112014;
RA   Carninci P., Kasukawa T., Katayama S., Gough J., Frith M.C., Maeda N.,
RA   Oyama R., Ravasi T., Lenhard B., Wells C., Kodzius R., Shimokawa K.,
RA   Bajic V.B., Brenner S.E., Batalov S., Forrest A.R., Zavolan M.,
RA   Davis M.J., Wilming L.G., Aidinis V., Allen J.E.,
RA   Ambesi-Impiombato A., Apweiler R., Aturaliya R.N., Bailey T.L.,
RA   Bansal M., Baxter L., Beisel K.W., Bersano T., Bono H., Chalk A.M.,
RA   Chiu K.P., Choudhary V., Christoffels A., Clutterbuck D.R.,
RA   Crowe M.L., Dalla E., Dalrymple B.P., de Bono B., Della Gatta G.,
RA   di Bernardo D., Down T., Engstrom P., Fagiolini M., Faulkner G.,
RA   Fletcher C.F., Fukushima T., Furuno M., Futaki S., Gariboldi M.,
RA   Georgii-Hemming P., Gingeras T.R., Gojobori T., Green R.E.,
RA   Gustincich S., Harbers M., Hayashi Y., Hensch T.K., Hirokawa N.,
RA   Hill D., Huminiecki L., Iacono M., Ikeo K., Iwama A., Ishikawa T.,
RA   Jakt M., Kanapin A., Katoh M., Kawasawa Y., Kelso J., Kitamura H.,
RA   Kitano H., Kollias G., Krishnan S.P., Kruger A., Kummerfeld S.K.,
RA   Kurochkin I.V., Lareau L.F., Lazarevic D., Lipovich L., Liu J.,
RA   Liuni S., McWilliam S., Madan Babu M., Madera M., Marchionni L.,
RA   Matsuda H., Matsuzawa S., Miki H., Mignone F., Miyake S., Morris K.,
RA   Mottagui-Tabar S., Mulder N., Nakano N., Nakauchi H., Ng P.,
RA   Nilsson R., Nishiguchi S., Nishikawa S., Nori F., Ohara O.,
RA   Okazaki Y., Orlando V., Pang K.C., Pavan W.J., Pavesi G., Pesole G.,
RA   Petrovsky N., Piazza S., Reed J., Reid J.F., Ring B.Z., Ringwald M.,
RA   Rost B., Ruan Y., Salzberg S.L., Sandelin A., Schneider C.,
RA   Schoenbach C., Sekiguchi K., Semple C.A., Seno S., Sessa L., Sheng Y.,
RA   Shibata Y., Shimada H., Shimada K., Silva D., Sinclair B.,
RA   Sperling S., Stupka E., Sugiura K., Sultana R., Takenaka Y., Taki K.,
RA   Tammoja K., Tan S.L., Tang S., Taylor M.S., Tegner J., Teichmann S.A.,
RA   Ueda H.R., van Nimwegen E., Verardo R., Wei C.L., Yagi K.,
RA   Yamanishi H., Zabarovsky E., Zhu S., Zimmer A., Hide W., Bult C.,
RA   Grimmond S.M., Teasdale R.D., Liu E.T., Brusic V., Quackenbush J.,
RA   Wahlestedt C., Mattick J.S., Hume D.A., Kai C., Sasaki D., Tomaru Y.,
RA   Fukuda S., Kanamori-Katayama M., Suzuki M., Aoki J., Arakawa T.,
RA   Iida J., Imamura K., Itoh M., Kato T., Kawaji H., Kawagashira N.,
RA   Kawashima T., Kojima M., Kondo S., Konno H., Nakano K., Ninomiya N.,
RA   Nishio T., Okada M., Plessy C., Shibata K., Shiraki T., Suzuki S.,
RA   Tagami M., Waki K., Watahiki A., Okamura-Oho Y., Suzuki H., Kawai J.,
RA   Hayashizaki Y.;
RT   "The transcriptional landscape of the mammalian genome.";
RL   Science 309:1559-1563(2005).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AK148147; BAE28375.1; -; mRNA.
DR   IPI; IPI00136201; -.
DR   UniGene; Mm.7319; -.
DR   SMR; Q3UG34; 87-205.
DR   STRING; Q3UG34; -.
DR   Ensembl; ENSMUST00000081333; ENSMUSP00000080081; ENSMUSG00000059363; Mus musculus.
DR   MGI; MGI:1096879; Fxn.
DR   HOVERGEN; HBG005745; -.
DR   InParanoid; Q3UG34; -.
DR   ArrayExpress; Q3UG34; -.
DR   Bgee; Q3UG34; -.
DR   Genevestigator; Q3UG34; -.
DR   GO; GO:0005739; C:mitochondrion; IDA:MGI.
DR   GO; GO:0007628; P:adult walking behavior; IMP:MGI.
DR   GO; GO:0009060; P:aerobic respiration; IMP:MGI.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IMP:MGI.
DR   GO; GO:0009792; P:embryonic development ending in birth or eg...; IMP:MGI.
DR   GO; GO:0007005; P:mitochondrion organization; IMP:MGI.
DR   GO; GO:0040015; P:negative regulation of multicellular organi...; IMP:MGI.
DR   GO; GO:0046621; P:negative regulation of organ growth; IMP:MGI.
DR   GO; GO:0006119; P:oxidative phosphorylation; IMP:MGI.
DR   GO; GO:0019230; P:proprioception; IMP:MGI.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
SQ   SEQUENCE   207 AA;  23023 MW;  30C4D8BBFEE09C02 CRC64;
     MWAFRGRAAV GLLPRTASRA SAWVGNPRWR EPIVTCGRRG LHVTVNAGAT RHAHLNLHYL
     QILNIKKQSV CVVHLRNLGT LDNPSSLDET AYERLAEETL DSLAEFFEDL ADKPYTLEDY
     DVSFGDGVLT IKLGGDLGTY VINKQTPNKQ IWLSSPSSGP KRYDWTGKNW VYSHDGVSLH
     ELLARELTKA LNTKLDLSSL AYSGKGT
//


ID   FRDA_HUMAN              Reviewed;         210 AA.
AC   Q16595; O15545; O95656; Q15294; Q5VZ01;
DT   15-JUL-1999, integrated into UniProtKB/Swiss-Prot.
DT   15-JUL-1999, sequence version 2.
DT   10-AUG-2010, entry version 115.
DE   RecName: Full=Frataxin, mitochondrial;
DE   AltName: Full=Friedreich ataxia protein;
DE            Short=Fxn;
DE   Contains:
DE     RecName: Full=Frataxin intermediate form;
DE   Contains:
DE     RecName: Full=Frataxin(56-210);
DE   Contains:
DE     RecName: Full=Frataxin(81-210);
DE   Flags: Precursor;
GN   Name=FXN; Synonyms=FRDA, X25;
OS   Homo sapiens (Human).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
OC   Catarrhini; Hominidae; Homo.
OX   NCBI_TaxID=9606;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA / MRNA], ALTERNATIVE SPLICING, AND
RP   VARIANT PHE-154.
RX   MEDLINE=96173952; PubMed=8596916; DOI=10.1126/science.271.5254.1423;
RA   Campuzano V., Montermini L., Molto M.D., Pianese L., Cossee M.,
RA   Cavalcanti F., Monros E., Rodius F., Duclos F., Monticelli A.,
RA   Zara F., Canizares J., Koutnikova H., Bidichandani S., Gellera C.,
RA   Brice A., Trouillas P., de Michele G., Filla A., de Frutos R.,
RA   Palau F., Patel P.I., di Donato S., Mandel J.-L., Cocozza S.,
RA   Koenig M., Pandolfo M.;
RT   "Friedreich's ataxia: autosomal recessive disease caused by an
RT   intronic GAA triplet repeat expansion.";
RL   Science 271:1423-1427(1996).
RN   [2]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RX   PubMed=15164053; DOI=10.1038/nature02465;
RA   Humphray S.J., Oliver K., Hunt A.R., Plumb R.W., Loveland J.E.,
RA   Howe K.L., Andrews T.D., Searle S., Hunt S.E., Scott C.E., Jones M.C.,
RA   Ainscough R., Almeida J.P., Ambrose K.D., Ashwell R.I.S.,
RA   Babbage A.K., Babbage S., Bagguley C.L., Bailey J., Banerjee R.,
RA   Barker D.J., Barlow K.F., Bates K., Beasley H., Beasley O., Bird C.P.,
RA   Bray-Allen S., Brown A.J., Brown J.Y., Burford D., Burrill W.,
RA   Burton J., Carder C., Carter N.P., Chapman J.C., Chen Y., Clarke G.,
RA   Clark S.Y., Clee C.M., Clegg S., Collier R.E., Corby N., Crosier M.,
RA   Cummings A.T., Davies J., Dhami P., Dunn M., Dutta I., Dyer L.W.,
RA   Earthrowl M.E., Faulkner L., Fleming C.J., Frankish A.,
RA   Frankland J.A., French L., Fricker D.G., Garner P., Garnett J.,
RA   Ghori J., Gilbert J.G.R., Glison C., Grafham D.V., Gribble S.,
RA   Griffiths C., Griffiths-Jones S., Grocock R., Guy J., Hall R.E.,
RA   Hammond S., Harley J.L., Harrison E.S.I., Hart E.A., Heath P.D.,
RA   Henderson C.D., Hopkins B.L., Howard P.J., Howden P.J., Huckle E.,
RA   Johnson C., Johnson D., Joy A.A., Kay M., Keenan S., Kershaw J.K.,
RA   Kimberley A.M., King A., Knights A., Laird G.K., Langford C.,
RA   Lawlor S., Leongamornlert D.A., Leversha M., Lloyd C., Lloyd D.M.,
RA   Lovell J., Martin S., Mashreghi-Mohammadi M., Matthews L., McLaren S.,
RA   McLay K.E., McMurray A., Milne S., Nickerson T., Nisbett J.,
RA   Nordsiek G., Pearce A.V., Peck A.I., Porter K.M., Pandian R.,
RA   Pelan S., Phillimore B., Povey S., Ramsey Y., Rand V., Scharfe M.,
RA   Sehra H.K., Shownkeen R., Sims S.K., Skuce C.D., Smith M.,
RA   Steward C.A., Swarbreck D., Sycamore N., Tester J., Thorpe A.,
RA   Tracey A., Tromans A., Thomas D.W., Wall M., Wallis J.M., West A.P.,
RA   Whitehead S.L., Willey D.L., Williams S.A., Wilming L., Wray P.W.,
RA   Young L., Ashurst J.L., Coulson A., Blocker H., Durbin R.M.,
RA   Sulston J.E., Hubbard T., Jackson M.J., Bentley D.R., Beck S.,
RA   Rogers J., Dunham I.;
RT   "DNA sequence and analysis of human chromosome 9.";
RL   Nature 429:369-374(2004).
RN   [3]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] (ISOFORM 1).
RC   TISSUE=Brain, and Eye;
RX   PubMed=15489334; DOI=10.1101/gr.2596504;
RG   The MGC Project Team;
RT   "The status, quality, and expansion of the NIH full-length cDNA
RT   project: the Mammalian Gene Collection (MGC).";
RL   Genome Res. 14:2121-2127(2004).
RN   [4]
RP   PROTEIN SEQUENCE OF 81-86, PROTEOLYTIC PROCESSING, MUTAGENESIS OF
RP   ARG-53; ARG-54; ARG-79 AND LYS-80, AND TISSUE SPECIFICITY.
RX   PubMed=17468497; DOI=10.1093/hmg/ddm102;
RA   Condo I., Ventura N., Malisan F., Rufini A., Tomassini B., Testi R.;
RT   "In vivo maturation of human frataxin.";
RL   Hum. Mol. Genet. 16:1534-1540(2007).
RN   [5]
RP   PROTEIN SEQUENCE OF 81-86, FUNCTION, INTERACTION WITH ACO1, AND
RP   SUBCELLULAR LOCATION.
RX   PubMed=20053667; DOI=10.1093/hmg/ddp592;
RA   Condo I., Malisan F., Guccini I., Serio D., Rufini A., Testi R.;
RT   "Molecular control of the cytosolic aconitase/IRP1 switch by
RT   extramitochondrial frataxin.";
RL   Hum. Mol. Genet. 19:1221-1229(2010).
RN   [6]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 89-128, AND VARIANT FA TYR-122.
RA   Kostrzewa M.;
RL   Submitted (JUN-1997) to the EMBL/GenBank/DDBJ databases.
RN   [7]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 89-128, AND VARIANT FA TYR-122.
RA   Doudney J.D., Pook M.A., Al-Mahdawi S., Carvajal J.J., Hillerman R.,
RA   Chamberlain S.;
RT   "A novel splice site mutation (384+1G-A) in the Friedreich's ataxia
RT   gene.";
RL   Submitted (NOV-1997) to the EMBL/GenBank/DDBJ databases.
RN   [8]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 162-210.
RA   Laccone F., Schloesser M.;
RT   "Correct sequence in exon 5a of x25: human frataxin (FRDA),
RT   F175(TTC)-->Y175(TAC) and W202(TGG)-->S202(TCC).";
RL   Submitted (MAR-1997) to the EMBL/GenBank/DDBJ databases.
RN   [9]
RP   SUBCELLULAR LOCATION.
RX   MEDLINE=98027047; PubMed=9302253; DOI=10.1093/hmg/6.11.1771;
RA   Campuzano V., Montermini L., Lutz Y., Cova L., Hindelang C.,
RA   Jiralerspong S., Trottier Y., Kish S.J., Faucheux B., Trouillas P.,
RA   Authier F.J., Duerr A., Mandel J.-L., Vescovi A., Pandolfo M.,
RA   Koenig M.;
RT   "Frataxin is reduced in Friedreich ataxia patients and is associated
RT   with mitochondrial membranes.";
RL   Hum. Mol. Genet. 6:1771-1780(1997).
RN   [10]
RP   SUBCELLULAR LOCATION.
RX   MEDLINE=97385237; PubMed=9241270; DOI=10.1038/ng0897-345;
RA   Koutnikova H., Campuzano V., Foury F., Dolle P., Cazzalini O.,
RA   Koenig M.;
RT   "Studies of human, mouse and yeast homologues indicate a mitochondrial
RT   function for frataxin.";
RL   Nat. Genet. 16:345-351(1997).
RN   [11]
RP   PROTEOLYTIC PROCESSING.
RX   MEDLINE=20014717; PubMed=10545606; DOI=10.1093/hmg/8.12.2255;
RA   Gordon D.M., Shi Q., Dancis A., Pain D.;
RT   "Maturation of frataxin within mammalian and yeast mitochondria: one-
RT   step processing by matrix processing peptidase.";
RL   Hum. Mol. Genet. 8:2255-2262(1999).
RN   [12]
RP   PROTEOLYTIC PROCESSING.
RX   MEDLINE=99357816; PubMed=10428860; DOI=10.1074/jbc.274.32.22763;
RA   Branda S.S., Cavadini P., Adamec J., Kalousek F., Taroni F., Isaya G.;
RT   "Yeast and human frataxin are processed to mature form in two
RT   sequential steps by the mitochondrial processing peptidase.";
RL   J. Biol. Chem. 274:22763-22769(1999).
RN   [13]
RP   PROTEOLYTIC PROCESSING.
RX   MEDLINE=20576316; PubMed=11020385; DOI=10.1074/jbc.M006539200;
RA   Cavadini P., Adamec J., Taroni F., Gakh O., Isaya G.;
RT   "Two-step processing of human frataxin by mitochondrial processing
RT   peptidase. Precursor and intermediate forms are cleaved at different
RT   rates.";
RL   J. Biol. Chem. 275:41469-41475(2000).
RN   [14]
RP   FUNCTION, AND INVOLVMENT IN HEME BIOSYNTHESIS.
RX   PubMed=16239244; DOI=10.1093/hmg/ddi393;
RA   Schoenfeld R.A., Napoli E., Wong A., Zhan S., Reutenauer L., Morin D.,
RA   Buckpitt A.R., Taroni F., Lonnerdal B., Ristow M., Puccio H.,
RA   Cortopassi G.A.;
RT   "Frataxin deficiency alters heme pathway transcripts and decreases
RT   mitochondrial heme metabolites in mammalian cells.";
RL   Hum. Mol. Genet. 14:3787-3799(2005).
RN   [15]
RP   FUNCTION, AND SUBCELLULAR LOCATION.
RX   PubMed=16608849; DOI=10.1074/jbc.M511960200;
RA   Condo I., Ventura N., Malisan F., Tomassini B., Testi R.;
RT   "A pool of extramitochondrial frataxin that promotes cell survival.";
RL   J. Biol. Chem. 281:16750-16756(2006).
RN   [16]
RP   INTERACTION WITH LYRM4 AND HSPA9, AND CHARACTERIZATION OF VARIANTS
RP   PHE-154 AND ARG-155.
RX   PubMed=17331979; DOI=10.1093/hmg/ddm038;
RA   Shan Y., Napoli E., Cortopassi G.;
RT   "Mitochondrial frataxin interacts with ISD11 of the NFS1/ISCU complex
RT   and multiple mitochondrial chaperones.";
RL   Hum. Mol. Genet. 16:929-941(2007).
RN   [17]
RP   IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
RA   Colinge J., Superti-Furga G., Bennett K.L.;
RL   Submitted (OCT-2008) to UniProtKB.
RN   [18]
RP   X-RAY CRYSTALLOGRAPHY (1.8 ANGSTROMS) OF 88-210.
RX   MEDLINE=20469418; PubMed=10900192; DOI=10.1074/jbc.C000407200;
RA   Dhe-Paganon S., Shigeta R., Chi Y.-I., Ristow M., Shoelson S.E.;
RT   "Crystal structure of human frataxin.";
RL   J. Biol. Chem. 275:30753-30756(2000).
RN   [19]
RP   STRUCTURE BY NMR OF 91-210.
RX   MEDLINE=20366579; PubMed=10903947; DOI=10.1016/S0969-2126(00)00158-1;
RA   Musco G., Stier G., Kolmerer B., Adinolfi S., Martin S., Frenkiel T.,
RA   Gibson T., Pastore A.;
RT   "Towards a structural understanding of Friedreich's ataxia: the
RT   solution structure of frataxin.";
RL   Structure 8:695-707(2000).
RN   [20]
RP   VARIANTS FA VAL-130 AND PHE-154.
RX   MEDLINE=97294420; PubMed=9150176;
RA   Bidichandani S.I., Ashizawa T., Patel P.I.;
RT   "Atypical Friedreich ataxia caused by compound heterozygosity for a
RT   novel missense mutation and the GAA triplet-repeat expansion.";
RL   Am. J. Hum. Genet. 60:1251-1256(1997).
RN   [21]
RP   VARIANT FA SER-106.
RX   MEDLINE=98451089; PubMed=9779809;
RX   DOI=10.1002/(SICI)1096-8628(19981012)79:5<396::AID-AJMG13>3.3.CO;2-B;
RA   Bartolo C., Mendell J.R., Prior T.W.;
RT   "Identification of a missense mutation in a Friedreich's ataxia
RT   patient: implications for diagnosis and carrier studies.";
RL   Am. J. Med. Genet. 79:396-399(1998).
RN   [22]
RP   VARIANTS FA VAL-130; CYS-165 AND PHE-182.
RX   MEDLINE=20194937; PubMed=10732799; DOI=10.1007/s100480050037;
RA   Forrest S.M., Knight M., Delatycki M.B., Paris D., Williamson R.,
RA   King J., Yeung L., Nassif N., Nicholson G.A.;
RT   "The correlation of clinical phenotype in Friedreich ataxia with the
RT   site of point mutations in the FRDA gene.";
RL   Neurogenetics 1:253-257(1998).
RN   [23]
RP   VARIANTS FA TYR-122 AND VAL-130.
RX   MEDLINE=99142728; PubMed=9989622;
RX   DOI=10.1002/1531-8249(199902)45:2<200::AID-ANA10>3.0.CO;2-U;
RA   Cossee M., Duerr A., Schmitt M., Dahl N., Trouillas P., Allinson P.,
RA   Kostrzewa M., Nivelon-Chevallier A., Gustavson K.-H.,
RA   Kohlschuetter A., Mueller U., Mandel J.-L., Brice A., Koenig M.,
RA   Cavalcanti F., Tammaro A., de Michele G., Filla A., Cocozza S.,
RA   Labuda M., Montermini L., Poirier J., Pandolfo M.;
RT   "Friedreich's ataxia: point mutations and clinical presentation of
RT   compound heterozygotes.";
RL   Ann. Neurol. 45:200-206(1999).
RN   [24]
RP   VARIANT FA ARG-155.
RA   Labuda M., Poirier J., Pandolfo M.;
RT   "A missense mutation (W155R) in an American patient with Friedreich's
RT   ataxia.";
RL   Hum. Mutat. 13:506-506(1999).
RN   [25]
RP   VARIANT FA ARG-198.
RX   MEDLINE=20334957; PubMed=10874325;
RX   DOI=10.1002/1098-1004(200007)16:1<95::AID-HUMU29>3.0.CO;2-E;
RA   Al-Mahdawi S., Pook M., Chamberlain S.;
RT   "A novel missense mutation (L198R) in the Friedreich's ataxia gene.";
RL   Hum. Mutat. 16:95-95(2000).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral.
CC   -!- FUNCTION: Frataxin(81-210) modulates the RNA-binding activity of
CC       ACO1.
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity). Interacts with LYRM4 AND HSPA9. Frataxin(81-210)
CC       interacts with ACO1.
CC   -!- SUBCELLULAR LOCATION: Mitochondrion. Note=Mitochondrial and
CC       extramitochondrial.
CC   -!- SUBCELLULAR LOCATION: Frataxin(81-210): Cytoplasm.
CC       Note=Extramitochondrial.
CC   -!- ALTERNATIVE PRODUCTS:
CC       Event=Alternative splicing; Named isoforms=2;
CC       Name=1;
CC         IsoId=Q16595-1; Sequence=Displayed;
CC       Name=2;
CC         IsoId=Q16595-2; Sequence=VSP_001576;
CC         Note=Not highly expressed and may be artifactual;
CC   -!- TISSUE SPECIFICITY: Frataxin(81-210) is expressed in the heart,
CC       peripheral blood lymphocytes and dermal fibroblasts.
CC   -!- PTM: Processed in two steps by mitochondrial processing peptidase
CC       (MPP). MPP first cleaves the precursor to intermediate form and
CC       subsequently converts the intermediate to mature size protein. Two
CC       forms exist, frataxin(56-210) and frataxin(81-210) which is the
CC       main form of mature frataxin.
CC   -!- DISEASE: Defects in FXN are the cause of Friedreich ataxia (FA)
CC       [MIM:229300]. FA is an autosomal recessive, progressive
CC       degenerative disease characterized by neurodegeneration and
CC       cardiomyopathy it is the most common inherited ataxia. The
CC       disorder is usually manifest before adolescence and is generally
CC       characterized by incoordination of limb movements, dysarthria,
CC       nystagmus, diminished or absent tendon reflexes, Babinski sign,
CC       impairment of position and vibratory senses, scoliosis, pes cavus,
CC       and hammer toe. In most patients, FA is due to GAA triplet repeat
CC       expansions in the first intron of the frataxin gene. But in some
CC       cases the disease is due to mutations in the coding region.
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -!- WEB RESOURCE: Name=GeneReviews;
CC       URL="http://www.ncbi.nlm.nih.gov/sites/GeneTests/lab/gene/FXN";
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; U43747; AAA98510.1; -; mRNA.
DR   EMBL; U43752; AAA98508.1; -; Genomic_DNA.
DR   EMBL; U43748; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43749; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43750; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43751; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43753; AAA98509.1; -; Genomic_DNA.
DR   EMBL; U43748; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; U43749; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; U43750; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; U43751; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; AL162730; CAH71829.1; -; Genomic_DNA.
DR   EMBL; BC023633; AAH23633.1; -; mRNA.
DR   EMBL; BC048097; AAH48097.1; -; mRNA.
DR   EMBL; Y13751; CAA74077.1; -; Genomic_DNA.
DR   EMBL; AF028240; AAB84047.1; -; Genomic_DNA.
DR   EMBL; U93173; AAD00734.1; -; Genomic_DNA.
DR   IPI; IPI00217745; -.
DR   IPI; IPI00293425; -.
DR   RefSeq; NP_000135.2; -.
DR   RefSeq; NP_001155178.1; -.
DR   RefSeq; NP_852090.1; -.
DR   UniGene; Hs.20685; -.
DR   PDB; 1EKG; X-ray; 1.80 A; A=88-210.
DR   PDB; 1LY7; NMR; -; A=91-210.
DR   PDBsum; 1EKG; -.
DR   PDBsum; 1LY7; -.
DR   ProteinModelPortal; Q16595; -.
DR   IntAct; Q16595; 2.
DR   MINT; MINT-2856590; -.
DR   STRING; Q16595; -.
DR   TCDB; 9.B.21.1.1; frataxin family.
DR   OGP; Q16595; -.
DR   PeptideAtlas; Q16595; -.
DR   PRIDE; Q16595; -.
DR   Ensembl; ENST00000377270; ENSP00000366482; ENSG00000165060; Homo sapiens.
DR   GeneID; 2395; -.
DR   KEGG; hsa:2395; -.
DR   NMPDR; fig|9606.3.peg.31391; -.
DR   UCSC; uc004aha.1; human.
DR   CTD; 2395; -.
DR   GeneCards; GC09P071650; -.
DR   H-InvDB; HIX0025740; -.
DR   HGNC; HGNC:3951; FXN.
DR   HPA; CAB022164; -.
DR   MIM; 229300; phenotype.
DR   MIM; 606829; gene.
DR   Orphanet; 95; Friedreich ataxia.
DR   PharmGKB; PA28369; -.
DR   eggNOG; prNOG11242; -.
DR   HOGENOM; HBG125781; -.
DR   HOVERGEN; HBG005745; -.
DR   InParanoid; Q16595; -.
DR   OMA; AYSGKGT; -.
DR   OrthoDB; EOG9C5G4B; -.
DR   PhylomeDB; Q16595; -.
DR   NextBio; 9641; -.
DR   ArrayExpress; Q16595; -.
DR   Bgee; Q16595; -.
DR   CleanEx; HS_FXN; -.
DR   Genevestigator; Q16595; -.
DR   GermOnline; ENSG00000165060; Homo sapiens.
DR   GO; GO:0005829; C:cytosol; IDA:BHF-UCL.
DR   GO; GO:0005759; C:mitochondrial matrix; NAS:BHF-UCL.
DR   GO; GO:0051537; F:2 iron, 2 sulfur cluster binding; IDA:BHF-UCL.
DR   GO; GO:0008199; F:ferric iron binding; IDA:BHF-UCL.
DR   GO; GO:0008198; F:ferrous iron binding; IDA:BHF-UCL.
DR   GO; GO:0034986; F:iron chaperone activity; IDA:BHF-UCL.
DR   GO; GO:0005515; F:protein binding; IPI:UniProtKB.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IMP:BHF-UCL.
DR   GO; GO:0006783; P:heme biosynthetic process; NAS:BHF-UCL.
DR   GO; GO:0018283; P:iron incorporation into metallo-sulfur cluster; IDA:BHF-UCL.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   GO; GO:0030307; P:positive regulation of cell growth; IMP:BHF-UCL.
DR   GO; GO:0008284; P:positive regulation of cell proliferation; IMP:BHF-UCL.
DR   GO; GO:0051349; P:positive regulation of lyase activity; IMP:BHF-UCL.
DR   GO; GO:0048554; P:positive regulation of metalloenzyme activity; IMP:BHF-UCL.
DR   GO; GO:0051353; P:positive regulation of oxidoreductase activity; IMP:BHF-UCL.
DR   GO; GO:0051347; P:positive regulation of transferase activity; IMP:BHF-UCL.
DR   GO; GO:0016540; P:protein autoprocessing; IDA:BHF-UCL.
DR   GO; GO:0010722; P:regulation of ferrochelatase activity; IDA:BHF-UCL.
DR   GO; GO:0010039; P:response to iron ion; IMP:BHF-UCL.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   1: Evidence at protein level;
KW   3D-structure; Alternative splicing; Complete proteome; Cytoplasm;
KW   Direct protein sequencing; Disease mutation; Ion transport; Iron;
KW   Iron transport; Mitochondrion; Polymorphism; Transit peptide;
KW   Transport; Triplet repeat expansion.
FT   TRANSIT       1     41       Mitochondrion.
FT   CHAIN        42    210       Frataxin intermediate form.
FT                                /FTId=PRO_0000010129.
FT   CHAIN        56    210       Frataxin(56-210).
FT                                /FTId=PRO_0000010130.
FT   CHAIN        81    210       Frataxin(81-210).
FT                                /FTId=PRO_0000289331.
FT   VAR_SEQ     161    210       SGPKRYDWTGKNWVYSHDGVSLHELLAAELTKALKTKLDLS
FT                                SLAYSGKDA -> RLTWLLWLFHP (in isoform 2).
FT                                /FTId=VSP_001576.
FT   VARIANT     106    106       L -> S (in FA).
FT                                /FTId=VAR_016065.
FT   VARIANT     122    122       D -> Y (in FA).
FT                                /FTId=VAR_002428.
FT   VARIANT     130    130       G -> V (in FA).
FT                                /FTId=VAR_002429.
FT   VARIANT     154    154       I -> F (in FA; reduces interaction with
FT                                LYRM4. Interaction is rescued by nickel).
FT                                /FTId=VAR_002430.
FT   VARIANT     155    155       W -> R (in FA; reduces interaction with
FT                                LYRM4. Interaction is rescued by nickel).
FT                                /FTId=VAR_002431.
FT   VARIANT     165    165       R -> C (in FA; mild form).
FT                                /FTId=VAR_008139.
FT   VARIANT     182    182       L -> F (in FA).
FT                                /FTId=VAR_008140.
FT   VARIANT     198    198       L -> R (in FA).
FT                                /FTId=VAR_016066.
FT   VARIANT     202    202       S -> C (in dbSNP:rs1052195).
FT                                /FTId=VAR_049100.
FT   MUTAGEN      53     53       R->G: Abolished cleavage of frataxin(81-
FT                                210); when associated with G-54.
FT   MUTAGEN      54     54       R->G: Abolished cleavage of frataxin(81-
FT                                210) and allows the accumulation of
FT                                frataxin(56-210); when associated with G-
FT                                53.
FT   MUTAGEN      79     79       R->G: Abolished cleavage of frataxin(81-
FT                                210) and allows the accumulation of
FT                                frataxin(56-210); when associated with G-
FT                                80.
FT   MUTAGEN      80     80       K->G: Abolished cleavage of frataxin(81-
FT                                210); when associated with G-79.
FT   CONFLICT    175    175       Y -> F (in Ref. 1; AAA98508/AAA98510).
FT   CONFLICT    202    202       S -> W (in Ref. 1; AAA98508/AAA98510).
FT   HELIX        92    113
FT   STRAND      124    128
FT   STRAND      131    135
FT   STRAND      142    148
FT   TURN        149    152
FT   STRAND      153    158
FT   TURN        159    161
FT   STRAND      162    168
FT   STRAND      170    175
FT   TURN        176    178
FT   HELIX       182    194
SQ   SEQUENCE   210 AA;  23135 MW;  ECC81738779308CF CRC64;
     MWTLGRRAVA GLLASPSPAQ AQTLTRVPRP AELAPLCGRR GLRTDIDATC TPRRASSNQR
     GLNQIWNVKK QSVYLMNLRK SGTLGHPGSL DETTYERLAE ETLDSLAEFF EDLADKPYTF
     EDYDVSFGSG VLTVKLGGDL GTYVINKQTP NKQIWLSSPS SGPKRYDWTG KNWVYSHDGV
     SLHELLAAEL TKALKTKLDL SSLAYSGKDA
//


ID   Q3TV21_MOUSE            Unreviewed;       207 AA.
AC   Q3TV21;
DT   11-OCT-2005, integrated into UniProtKB/TrEMBL.
DT   11-OCT-2005, sequence version 1.
DT   02-MAR-2010, entry version 42.
DE   SubName: Full=Frataxin;
DE   SubName: Full=Putative uncharacterized protein;
GN   Name=Fxn;
OS   Mus musculus (Mouse).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi;
OC   Muroidea; Muridae; Murinae; Mus.
OX   NCBI_TaxID=10090;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   STRAIN=C57BL/6J; TISSUE=Pancreas;
RX   PubMed=16141072; DOI=10.1126/science.1112014;
RA   Carninci P., Kasukawa T., Katayama S., Gough J., Frith M.C., Maeda N.,
RA   Oyama R., Ravasi T., Lenhard B., Wells C., Kodzius R., Shimokawa K.,
RA   Bajic V.B., Brenner S.E., Batalov S., Forrest A.R., Zavolan M.,
RA   Davis M.J., Wilming L.G., Aidinis V., Allen J.E.,
RA   Ambesi-Impiombato A., Apweiler R., Aturaliya R.N., Bailey T.L.,
RA   Bansal M., Baxter L., Beisel K.W., Bersano T., Bono H., Chalk A.M.,
RA   Chiu K.P., Choudhary V., Christoffels A., Clutterbuck D.R.,
RA   Crowe M.L., Dalla E., Dalrymple B.P., de Bono B., Della Gatta G.,
RA   di Bernardo D., Down T., Engstrom P., Fagiolini M., Faulkner G.,
RA   Fletcher C.F., Fukushima T., Furuno M., Futaki S., Gariboldi M.,
RA   Georgii-Hemming P., Gingeras T.R., Gojobori T., Green R.E.,
RA   Gustincich S., Harbers M., Hayashi Y., Hensch T.K., Hirokawa N.,
RA   Hill D., Huminiecki L., Iacono M., Ikeo K., Iwama A., Ishikawa T.,
RA   Jakt M., Kanapin A., Katoh M., Kawasawa Y., Kelso J., Kitamura H.,
RA   Kitano H., Kollias G., Krishnan S.P., Kruger A., Kummerfeld S.K.,
RA   Kurochkin I.V., Lareau L.F., Lazarevic D., Lipovich L., Liu J.,
RA   Liuni S., McWilliam S., Madan Babu M., Madera M., Marchionni L.,
RA   Matsuda H., Matsuzawa S., Miki H., Mignone F., Miyake S., Morris K.,
RA   Mottagui-Tabar S., Mulder N., Nakano N., Nakauchi H., Ng P.,
RA   Nilsson R., Nishiguchi S., Nishikawa S., Nori F., Ohara O.,
RA   Okazaki Y., Orlando V., Pang K.C., Pavan W.J., Pavesi G., Pesole G.,
RA   Petrovsky N., Piazza S., Reed J., Reid J.F., Ring B.Z., Ringwald M.,
RA   Rost B., Ruan Y., Salzberg S.L., Sandelin A., Schneider C.,
RA   Schoenbach C., Sekiguchi K., Semple C.A., Seno S., Sessa L., Sheng Y.,
RA   Shibata Y., Shimada H., Shimada K., Silva D., Sinclair B.,
RA   Sperling S., Stupka E., Sugiura K., Sultana R., Takenaka Y., Taki K.,
RA   Tammoja K., Tan S.L., Tang S., Taylor M.S., Tegner J., Teichmann S.A.,
RA   Ueda H.R., van Nimwegen E., Verardo R., Wei C.L., Yagi K.,
RA   Yamanishi H., Zabarovsky E., Zhu S., Zimmer A., Hide W., Bult C.,
RA   Grimmond S.M., Teasdale R.D., Liu E.T., Brusic V., Quackenbush J.,
RA   Wahlestedt C., Mattick J.S., Hume D.A., Kai C., Sasaki D., Tomaru Y.,
RA   Fukuda S., Kanamori-Katayama M., Suzuki M., Aoki J., Arakawa T.,
RA   Iida J., Imamura K., Itoh M., Kato T., Kawaji H., Kawagashira N.,
RA   Kawashima T., Kojima M., Kondo S., Konno H., Nakano K., Ninomiya N.,
RA   Nishio T., Okada M., Plessy C., Shibata K., Shiraki T., Suzuki S.,
RA   Tagami M., Waki K., Watahiki A., Okamura-Oho Y., Suzuki H., Kawai J.,
RA   Hayashizaki Y.;
RT   "The transcriptional landscape of the mammalian genome.";
RL   Science 309:1559-1563(2005).
RN   [2]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   TISSUE=Brain;
RX   PubMed=15489334; DOI=10.1101/gr.2596504;
RG   The MGC Project Team;
RT   "The status, quality, and expansion of the NIH full-length cDNA
RT   project: the Mammalian Gene Collection (MGC).";
RL   Genome Res. 14:2121-2127(2004).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; BC125337; AAI25338.1; -; mRNA.
DR   EMBL; BC132337; AAI32338.1; -; mRNA.
DR   EMBL; AK160458; BAE35799.1; -; mRNA.
DR   IPI; IPI00136201; -.
DR   RefSeq; NP_032070.1; -.
DR   UniGene; Mm.7319; -.
DR   SMR; Q3TV21; 87-205.
DR   STRING; Q3TV21; -.
DR   PRIDE; Q3TV21; -.
DR   Ensembl; ENSMUST00000081333; ENSMUSP00000080081; ENSMUSG00000059363; Mus musculus.
DR   GeneID; 14297; -.
DR   KEGG; mmu:14297; -.
DR   NMPDR; fig|10090.3.peg.4862; -.
DR   CTD; 14297; -.
DR   MGI; MGI:1096879; Fxn.
DR   HOVERGEN; HBG005745; -.
DR   InParanoid; Q3TV21; -.
DR   OMA; DETAYER; -.
DR   PhylomeDB; Q3TV21; -.
DR   NextBio; 285709; -.
DR   ArrayExpress; Q3TV21; -.
DR   Bgee; Q3TV21; -.
DR   Genevestigator; Q3TV21; -.
DR   GO; GO:0005739; C:mitochondrion; IDA:MGI.
DR   GO; GO:0007628; P:adult walking behavior; IMP:MGI.
DR   GO; GO:0009060; P:aerobic respiration; IMP:MGI.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IMP:MGI.
DR   GO; GO:0009792; P:embryonic development ending in birth or eg...; IMP:MGI.
DR   GO; GO:0007005; P:mitochondrion organization; IMP:MGI.
DR   GO; GO:0040015; P:negative regulation of multicellular organi...; IMP:MGI.
DR   GO; GO:0046621; P:negative regulation of organ growth; IMP:MGI.
DR   GO; GO:0006119; P:oxidative phosphorylation; IMP:MGI.
DR   GO; GO:0019230; P:proprioception; IMP:MGI.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
SQ   SEQUENCE   207 AA;  22924 MW;  C46FD21B44FB26A2 CRC64;
     MWAFGGRAAV GLLPRTASRA SAWVGNPRWR EPIVTCGRRG LHVTVNAGAT RHAHLNLHYL
     QILNIKKQSV CVVHLRNLGT LDNPSSLDET AYERLAEETL DSLAEFFEDL ADKPYTLEDY
     DVSFGDGVLT IKLGGDLGTY VINKQTPNKQ IWLSSPSSGP KRYDWTGKNW VYSHDGVSLH
     ELLARELTKA LNTKLDLSSL AYSGKGT
//


ID   FRDA_MOUSE              Reviewed;         207 AA.
AC   O35943;
DT   15-JUL-1999, integrated into UniProtKB/Swiss-Prot.
DT   01-JAN-1998, sequence version 1.
DT   10-AUG-2010, entry version 77.
DE   RecName: Full=Frataxin, mitochondrial;
DE            Short=Fxn;
DE   Flags: Precursor;
GN   Name=Fxn; Synonyms=Frda;
OS   Mus musculus (Mouse).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi;
OC   Muroidea; Muridae; Murinae; Mus.
OX   NCBI_TaxID=10090;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [MRNA], SUBCELLULAR LOCATION, TISSUE SPECIFICITY,
RP   AND DEVELOPMENTAL STAGE.
RC   TISSUE=Embryo;
RX   MEDLINE=97385237; PubMed=9241270; DOI=10.1038/ng0897-345;
RA   Koutnikova H., Campuzano V., Foury F., Dolle P., Cazzalini O.,
RA   Koenig M.;
RT   "Studies of human, mouse and yeast homologues indicate a mitochondrial
RT   function for frataxin.";
RL   Nat. Genet. 16:345-351(1997).
RN   [2]
RP   FUNCTION.
RX   PubMed=19805308; DOI=10.1073/pnas.0906784106;
RA   Huang M.L., Becker E.M., Whitnall M., Rahmanto Y.S., Ponka P.,
RA   Richardson D.R.;
RT   "Elucidation of the mechanism of mitochondrial iron loading in
RT   Friedreich's ataxia by analysis of a mouse mutant.";
RL   Proc. Natl. Acad. Sci. U.S.A. 106:16381-16386(2009).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral.
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers.
CC       Interacts with LYRM4 AND HSPA9 (By similarity).
CC   -!- SUBCELLULAR LOCATION: Mitochondrion (By similarity).
CC       Note=Mitochondrial and extramitochondrial (By similarity).
CC   -!- TISSUE SPECIFICITY: Heart, liver, skeletal muscle, kidney, spleen
CC       and thymus. Weakly expressed in the brain and lung.
CC   -!- DEVELOPMENTAL STAGE: Expression in the ventricular zone which
CC       corresponds to dividing neuronal precursors begins at day 12.5,
CC       increases during embryonic development and persists at postnatal
CC       day 7 (P7) in the ependymal layer, which is the remenant of the
CC       ventricular zone. Weak expression seen in the spinal cord and
CC       medulla oblongata, starting at embryonic day 14.5 (E14.5) and
CC       expression also observed in dorsal root ganglia, starting at
CC       E14.5. At P14, expression in the dorsal root ganglia is restricted
CC       to the cortical region where the sensory neuron cell bodies are
CC       located. In non-neural tissues strong expression seen in the
CC       developing liver from E10.5. Expression detected in the heart and
CC       in the cortex of the developing kidney at E12.5 and later. Very
CC       high expression observed in the brown adipose tissue. Expression
CC       seen in small islands around the neck and back at E14.5, then in
CC       large masses at E16.5 and E18.5 and at P14 is absent in brown
CC       adipose tissue. Expression also seen in the thymus and developing
CC       gut at E14.5 and until postnatal life. At P14, expression in
CC       thymus is restricted to the proliferating cells in the cortical
CC       zone and is also prominent in the spleen. Found in the lung at
CC       E14.5.
CC   -!- PTM: Processed by mitochondrial processing peptidase (MPP).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; U95736; AAB67778.1; -; mRNA.
DR   IPI; IPI00136201; -.
DR   RefSeq; NP_032070.1; -.
DR   UniGene; Mm.7319; -.
DR   ProteinModelPortal; O35943; -.
DR   SMR; O35943; 87-205.
DR   STRING; O35943; -.
DR   PRIDE; O35943; -.
DR   Ensembl; ENSMUST00000081333; ENSMUSP00000080081; ENSMUSG00000059363; Mus musculus.
DR   GeneID; 14297; -.
DR   KEGG; mmu:14297; -.
DR   UCSC; uc008hao.1; mouse.
DR   CTD; 14297; -.
DR   MGI; MGI:1096879; Fxn.
DR   eggNOG; roNOG14548; -.
DR   HOGENOM; HBG125781; -.
DR   HOVERGEN; HBG005745; -.
DR   InParanoid; O35943; -.
DR   OMA; AYSGKGT; -.
DR   OrthoDB; EOG9C5G4B; -.
DR   PhylomeDB; O35943; -.
DR   NextBio; 285709; -.
DR   ArrayExpress; O35943; -.
DR   Bgee; O35943; -.
DR   CleanEx; MM_FXN; -.
DR   Genevestigator; O35943; -.
DR   GermOnline; ENSMUSG00000059363; Mus musculus.
DR   GO; GO:0005739; C:mitochondrion; IDA:MGI.
DR   GO; GO:0007628; P:adult walking behavior; IMP:MGI.
DR   GO; GO:0009060; P:aerobic respiration; IMP:MGI.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IMP:MGI.
DR   GO; GO:0009792; P:embryonic development ending in birth or eg...; IMP:MGI.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   GO; GO:0007005; P:mitochondrion organization; IMP:MGI.
DR   GO; GO:0040015; P:negative regulation of multicellular organi...; IMP:MGI.
DR   GO; GO:0046621; P:negative regulation of organ growth; IMP:MGI.
DR   GO; GO:0006119; P:oxidative phosphorylation; IMP:MGI.
DR   GO; GO:0019230; P:proprioception; IMP:MGI.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
KW   Ion transport; Iron; Iron transport; Mitochondrion; Transit peptide;
KW   Transport.
FT   TRANSIT       1     40       Mitochondrion (By similarity).
FT   CHAIN        41    207       Frataxin, mitochondrial.
FT                                /FTId=PRO_0000010132.
SQ   SEQUENCE   207 AA;  22924 MW;  C46FD21B44FB26A2 CRC64;
     MWAFGGRAAV GLLPRTASRA SAWVGNPRWR EPIVTCGRRG LHVTVNAGAT RHAHLNLHYL
     QILNIKKQSV CVVHLRNLGT LDNPSSLDET AYERLAEETL DSLAEFFEDL ADKPYTLEDY
     DVSFGDGVLT IKLGGDLGTY VINKQTPNKQ IWLSSPSSGP KRYDWTGKNW VYSHDGVSLH
     ELLARELTKA LNTKLDLSSL AYSGKGT
//


ID   FRDA_MACFA              Reviewed;         210 AA.
AC   Q8HXX9;
DT   12-APR-2005, integrated into UniProtKB/Swiss-Prot.
DT   01-MAR-2003, sequence version 1.
DT   10-AUG-2010, entry version 38.
DE   RecName: Full=Frataxin, mitochondrial;
DE            Short=Fxn;
DE   Flags: Precursor;
GN   Name=FXN; Synonyms=FRDA1; ORFNames=QnpA-13971;
OS   Macaca fascicularis (Crab eating macaque) (Cynomolgus monkey).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
OC   Catarrhini; Cercopithecidae; Cercopithecinae; Macaca.
OX   NCBI_TaxID=9541;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   TISSUE=Parietal cortex;
RA   Kusuda J., Osada N., Hida M., Sugano S., Hashimoto K.;
RT   "Isolation and characterization of cDNA for macaque neurological
RT   disease genes.";
RL   Submitted (APR-2002) to the EMBL/GenBank/DDBJ databases.
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral
CC       (By similarity).
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers.
CC       Interacts with LYRM4 AND HSPA9 (By similarity).
CC   -!- SUBCELLULAR LOCATION: Mitochondrion (By similarity).
CC       Note=Mitochondrial and extramitochondrial (By similarity).
CC   -!- PTM: Processed by mitochondrial processing peptidase (MPP).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AB083310; BAC20589.1; -; mRNA.
DR   ProteinModelPortal; Q8HXX9; -.
DR   SMR; Q8HXX9; 90-210.
DR   HOVERGEN; HBG005745; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:UniProtKB-SubCell.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
KW   Ion transport; Iron; Iron transport; Mitochondrion; Transit peptide;
KW   Transport.
FT   TRANSIT       1     41       Mitochondrion (By similarity).
FT   CHAIN        42    210       Frataxin, mitochondrial.
FT                                /FTId=PRO_0000010131.
SQ   SEQUENCE   210 AA;  23133 MW;  C90A50A3F3E7D581 CRC64;
     MWTFGRRAVA GLLASPSPAQ AQTLTRAPRL AELAQLCSRR GLRTGINATR TTHHTSSNLR
     GLNQIRNVKR QSVYLMNLRK SGTLGHPGSL DDTTYERLAE ETLDSLAEFF EDLADKPYTF
     EDYDVSFGSG VLTVKLGGDL GTYVINKQTP NKQIWLSSPS SGPKRYDRTG KNWVYSHDGV
     SLHELLGAEL TKALKTKLDL SSLAYSGKDA
//


ID   FRDA_HUMAN              Reviewed;         210 AA.
AC   Q16595; O15545; O95656; Q15294; Q5VZ01;
DT   15-JUL-1999, integrated into UniProtKB/Swiss-Prot.
DT   15-JUL-1999, sequence version 2.
DT   10-AUG-2010, entry version 115.
DE   RecName: Full=Frataxin, mitochondrial;
DE   AltName: Full=Friedreich ataxia protein;
DE            Short=Fxn;
DE   Contains:
DE     RecName: Full=Frataxin intermediate form;
DE   Contains:
DE     RecName: Full=Frataxin(56-210);
DE   Contains:
DE     RecName: Full=Frataxin(81-210);
DE   Flags: Precursor;
GN   Name=FXN; Synonyms=FRDA, X25;
OS   Homo sapiens (Human).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
OC   Catarrhini; Hominidae; Homo.
OX   NCBI_TaxID=9606;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA / MRNA], ALTERNATIVE SPLICING, AND
RP   VARIANT PHE-154.
RX   MEDLINE=96173952; PubMed=8596916; DOI=10.1126/science.271.5254.1423;
RA   Campuzano V., Montermini L., Molto M.D., Pianese L., Cossee M.,
RA   Cavalcanti F., Monros E., Rodius F., Duclos F., Monticelli A.,
RA   Zara F., Canizares J., Koutnikova H., Bidichandani S., Gellera C.,
RA   Brice A., Trouillas P., de Michele G., Filla A., de Frutos R.,
RA   Palau F., Patel P.I., di Donato S., Mandel J.-L., Cocozza S.,
RA   Koenig M., Pandolfo M.;
RT   "Friedreich's ataxia: autosomal recessive disease caused by an
RT   intronic GAA triplet repeat expansion.";
RL   Science 271:1423-1427(1996).
RN   [2]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RX   PubMed=15164053; DOI=10.1038/nature02465;
RA   Humphray S.J., Oliver K., Hunt A.R., Plumb R.W., Loveland J.E.,
RA   Howe K.L., Andrews T.D., Searle S., Hunt S.E., Scott C.E., Jones M.C.,
RA   Ainscough R., Almeida J.P., Ambrose K.D., Ashwell R.I.S.,
RA   Babbage A.K., Babbage S., Bagguley C.L., Bailey J., Banerjee R.,
RA   Barker D.J., Barlow K.F., Bates K., Beasley H., Beasley O., Bird C.P.,
RA   Bray-Allen S., Brown A.J., Brown J.Y., Burford D., Burrill W.,
RA   Burton J., Carder C., Carter N.P., Chapman J.C., Chen Y., Clarke G.,
RA   Clark S.Y., Clee C.M., Clegg S., Collier R.E., Corby N., Crosier M.,
RA   Cummings A.T., Davies J., Dhami P., Dunn M., Dutta I., Dyer L.W.,
RA   Earthrowl M.E., Faulkner L., Fleming C.J., Frankish A.,
RA   Frankland J.A., French L., Fricker D.G., Garner P., Garnett J.,
RA   Ghori J., Gilbert J.G.R., Glison C., Grafham D.V., Gribble S.,
RA   Griffiths C., Griffiths-Jones S., Grocock R., Guy J., Hall R.E.,
RA   Hammond S., Harley J.L., Harrison E.S.I., Hart E.A., Heath P.D.,
RA   Henderson C.D., Hopkins B.L., Howard P.J., Howden P.J., Huckle E.,
RA   Johnson C., Johnson D., Joy A.A., Kay M., Keenan S., Kershaw J.K.,
RA   Kimberley A.M., King A., Knights A., Laird G.K., Langford C.,
RA   Lawlor S., Leongamornlert D.A., Leversha M., Lloyd C., Lloyd D.M.,
RA   Lovell J., Martin S., Mashreghi-Mohammadi M., Matthews L., McLaren S.,
RA   McLay K.E., McMurray A., Milne S., Nickerson T., Nisbett J.,
RA   Nordsiek G., Pearce A.V., Peck A.I., Porter K.M., Pandian R.,
RA   Pelan S., Phillimore B., Povey S., Ramsey Y., Rand V., Scharfe M.,
RA   Sehra H.K., Shownkeen R., Sims S.K., Skuce C.D., Smith M.,
RA   Steward C.A., Swarbreck D., Sycamore N., Tester J., Thorpe A.,
RA   Tracey A., Tromans A., Thomas D.W., Wall M., Wallis J.M., West A.P.,
RA   Whitehead S.L., Willey D.L., Williams S.A., Wilming L., Wray P.W.,
RA   Young L., Ashurst J.L., Coulson A., Blocker H., Durbin R.M.,
RA   Sulston J.E., Hubbard T., Jackson M.J., Bentley D.R., Beck S.,
RA   Rogers J., Dunham I.;
RT   "DNA sequence and analysis of human chromosome 9.";
RL   Nature 429:369-374(2004).
RN   [3]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] (ISOFORM 1).
RC   TISSUE=Brain, and Eye;
RX   PubMed=15489334; DOI=10.1101/gr.2596504;
RG   The MGC Project Team;
RT   "The status, quality, and expansion of the NIH full-length cDNA
RT   project: the Mammalian Gene Collection (MGC).";
RL   Genome Res. 14:2121-2127(2004).
RN   [4]
RP   PROTEIN SEQUENCE OF 81-86, PROTEOLYTIC PROCESSING, MUTAGENESIS OF
RP   ARG-53; ARG-54; ARG-79 AND LYS-80, AND TISSUE SPECIFICITY.
RX   PubMed=17468497; DOI=10.1093/hmg/ddm102;
RA   Condo I., Ventura N., Malisan F., Rufini A., Tomassini B., Testi R.;
RT   "In vivo maturation of human frataxin.";
RL   Hum. Mol. Genet. 16:1534-1540(2007).
RN   [5]
RP   PROTEIN SEQUENCE OF 81-86, FUNCTION, INTERACTION WITH ACO1, AND
RP   SUBCELLULAR LOCATION.
RX   PubMed=20053667; DOI=10.1093/hmg/ddp592;
RA   Condo I., Malisan F., Guccini I., Serio D., Rufini A., Testi R.;
RT   "Molecular control of the cytosolic aconitase/IRP1 switch by
RT   extramitochondrial frataxin.";
RL   Hum. Mol. Genet. 19:1221-1229(2010).
RN   [6]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 89-128, AND VARIANT FA TYR-122.
RA   Kostrzewa M.;
RL   Submitted (JUN-1997) to the EMBL/GenBank/DDBJ databases.
RN   [7]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 89-128, AND VARIANT FA TYR-122.
RA   Doudney J.D., Pook M.A., Al-Mahdawi S., Carvajal J.J., Hillerman R.,
RA   Chamberlain S.;
RT   "A novel splice site mutation (384+1G-A) in the Friedreich's ataxia
RT   gene.";
RL   Submitted (NOV-1997) to the EMBL/GenBank/DDBJ databases.
RN   [8]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 162-210.
RA   Laccone F., Schloesser M.;
RT   "Correct sequence in exon 5a of x25: human frataxin (FRDA),
RT   F175(TTC)-->Y175(TAC) and W202(TGG)-->S202(TCC).";
RL   Submitted (MAR-1997) to the EMBL/GenBank/DDBJ databases.
RN   [9]
RP   SUBCELLULAR LOCATION.
RX   MEDLINE=98027047; PubMed=9302253; DOI=10.1093/hmg/6.11.1771;
RA   Campuzano V., Montermini L., Lutz Y., Cova L., Hindelang C.,
RA   Jiralerspong S., Trottier Y., Kish S.J., Faucheux B., Trouillas P.,
RA   Authier F.J., Duerr A., Mandel J.-L., Vescovi A., Pandolfo M.,
RA   Koenig M.;
RT   "Frataxin is reduced in Friedreich ataxia patients and is associated
RT   with mitochondrial membranes.";
RL   Hum. Mol. Genet. 6:1771-1780(1997).
RN   [10]
RP   SUBCELLULAR LOCATION.
RX   MEDLINE=97385237; PubMed=9241270; DOI=10.1038/ng0897-345;
RA   Koutnikova H., Campuzano V., Foury F., Dolle P., Cazzalini O.,
RA   Koenig M.;
RT   "Studies of human, mouse and yeast homologues indicate a mitochondrial
RT   function for frataxin.";
RL   Nat. Genet. 16:345-351(1997).
RN   [11]
RP   PROTEOLYTIC PROCESSING.
RX   MEDLINE=20014717; PubMed=10545606; DOI=10.1093/hmg/8.12.2255;
RA   Gordon D.M., Shi Q., Dancis A., Pain D.;
RT   "Maturation of frataxin within mammalian and yeast mitochondria: one-
RT   step processing by matrix processing peptidase.";
RL   Hum. Mol. Genet. 8:2255-2262(1999).
RN   [12]
RP   PROTEOLYTIC PROCESSING.
RX   MEDLINE=99357816; PubMed=10428860; DOI=10.1074/jbc.274.32.22763;
RA   Branda S.S., Cavadini P., Adamec J., Kalousek F., Taroni F., Isaya G.;
RT   "Yeast and human frataxin are processed to mature form in two
RT   sequential steps by the mitochondrial processing peptidase.";
RL   J. Biol. Chem. 274:22763-22769(1999).
RN   [13]
RP   PROTEOLYTIC PROCESSING.
RX   MEDLINE=20576316; PubMed=11020385; DOI=10.1074/jbc.M006539200;
RA   Cavadini P., Adamec J., Taroni F., Gakh O., Isaya G.;
RT   "Two-step processing of human frataxin by mitochondrial processing
RT   peptidase. Precursor and intermediate forms are cleaved at different
RT   rates.";
RL   J. Biol. Chem. 275:41469-41475(2000).
RN   [14]
RP   FUNCTION, AND INVOLVMENT IN HEME BIOSYNTHESIS.
RX   PubMed=16239244; DOI=10.1093/hmg/ddi393;
RA   Schoenfeld R.A., Napoli E., Wong A., Zhan S., Reutenauer L., Morin D.,
RA   Buckpitt A.R., Taroni F., Lonnerdal B., Ristow M., Puccio H.,
RA   Cortopassi G.A.;
RT   "Frataxin deficiency alters heme pathway transcripts and decreases
RT   mitochondrial heme metabolites in mammalian cells.";
RL   Hum. Mol. Genet. 14:3787-3799(2005).
RN   [15]
RP   FUNCTION, AND SUBCELLULAR LOCATION.
RX   PubMed=16608849; DOI=10.1074/jbc.M511960200;
RA   Condo I., Ventura N., Malisan F., Tomassini B., Testi R.;
RT   "A pool of extramitochondrial frataxin that promotes cell survival.";
RL   J. Biol. Chem. 281:16750-16756(2006).
RN   [16]
RP   INTERACTION WITH LYRM4 AND HSPA9, AND CHARACTERIZATION OF VARIANTS
RP   PHE-154 AND ARG-155.
RX   PubMed=17331979; DOI=10.1093/hmg/ddm038;
RA   Shan Y., Napoli E., Cortopassi G.;
RT   "Mitochondrial frataxin interacts with ISD11 of the NFS1/ISCU complex
RT   and multiple mitochondrial chaperones.";
RL   Hum. Mol. Genet. 16:929-941(2007).
RN   [17]
RP   IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
RA   Colinge J., Superti-Furga G., Bennett K.L.;
RL   Submitted (OCT-2008) to UniProtKB.
RN   [18]
RP   X-RAY CRYSTALLOGRAPHY (1.8 ANGSTROMS) OF 88-210.
RX   MEDLINE=20469418; PubMed=10900192; DOI=10.1074/jbc.C000407200;
RA   Dhe-Paganon S., Shigeta R., Chi Y.-I., Ristow M., Shoelson S.E.;
RT   "Crystal structure of human frataxin.";
RL   J. Biol. Chem. 275:30753-30756(2000).
RN   [19]
RP   STRUCTURE BY NMR OF 91-210.
RX   MEDLINE=20366579; PubMed=10903947; DOI=10.1016/S0969-2126(00)00158-1;
RA   Musco G., Stier G., Kolmerer B., Adinolfi S., Martin S., Frenkiel T.,
RA   Gibson T., Pastore A.;
RT   "Towards a structural understanding of Friedreich's ataxia: the
RT   solution structure of frataxin.";
RL   Structure 8:695-707(2000).
RN   [20]
RP   VARIANTS FA VAL-130 AND PHE-154.
RX   MEDLINE=97294420; PubMed=9150176;
RA   Bidichandani S.I., Ashizawa T., Patel P.I.;
RT   "Atypical Friedreich ataxia caused by compound heterozygosity for a
RT   novel missense mutation and the GAA triplet-repeat expansion.";
RL   Am. J. Hum. Genet. 60:1251-1256(1997).
RN   [21]
RP   VARIANT FA SER-106.
RX   MEDLINE=98451089; PubMed=9779809;
RX   DOI=10.1002/(SICI)1096-8628(19981012)79:5<396::AID-AJMG13>3.3.CO;2-B;
RA   Bartolo C., Mendell J.R., Prior T.W.;
RT   "Identification of a missense mutation in a Friedreich's ataxia
RT   patient: implications for diagnosis and carrier studies.";
RL   Am. J. Med. Genet. 79:396-399(1998).
RN   [22]
RP   VARIANTS FA VAL-130; CYS-165 AND PHE-182.
RX   MEDLINE=20194937; PubMed=10732799; DOI=10.1007/s100480050037;
RA   Forrest S.M., Knight M., Delatycki M.B., Paris D., Williamson R.,
RA   King J., Yeung L., Nassif N., Nicholson G.A.;
RT   "The correlation of clinical phenotype in Friedreich ataxia with the
RT   site of point mutations in the FRDA gene.";
RL   Neurogenetics 1:253-257(1998).
RN   [23]
RP   VARIANTS FA TYR-122 AND VAL-130.
RX   MEDLINE=99142728; PubMed=9989622;
RX   DOI=10.1002/1531-8249(199902)45:2<200::AID-ANA10>3.0.CO;2-U;
RA   Cossee M., Duerr A., Schmitt M., Dahl N., Trouillas P., Allinson P.,
RA   Kostrzewa M., Nivelon-Chevallier A., Gustavson K.-H.,
RA   Kohlschuetter A., Mueller U., Mandel J.-L., Brice A., Koenig M.,
RA   Cavalcanti F., Tammaro A., de Michele G., Filla A., Cocozza S.,
RA   Labuda M., Montermini L., Poirier J., Pandolfo M.;
RT   "Friedreich's ataxia: point mutations and clinical presentation of
RT   compound heterozygotes.";
RL   Ann. Neurol. 45:200-206(1999).
RN   [24]
RP   VARIANT FA ARG-155.
RA   Labuda M., Poirier J., Pandolfo M.;
RT   "A missense mutation (W155R) in an American patient with Friedreich's
RT   ataxia.";
RL   Hum. Mutat. 13:506-506(1999).
RN   [25]
RP   VARIANT FA ARG-198.
RX   MEDLINE=20334957; PubMed=10874325;
RX   DOI=10.1002/1098-1004(200007)16:1<95::AID-HUMU29>3.0.CO;2-E;
RA   Al-Mahdawi S., Pook M., Chamberlain S.;
RT   "A novel missense mutation (L198R) in the Friedreich's ataxia gene.";
RL   Hum. Mutat. 16:95-95(2000).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral.
CC   -!- FUNCTION: Frataxin(81-210) modulates the RNA-binding activity of
CC       ACO1.
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity). Interacts with LYRM4 AND HSPA9. Frataxin(81-210)
CC       interacts with ACO1.
CC   -!- SUBCELLULAR LOCATION: Mitochondrion. Note=Mitochondrial and
CC       extramitochondrial.
CC   -!- SUBCELLULAR LOCATION: Frataxin(81-210): Cytoplasm.
CC       Note=Extramitochondrial.
CC   -!- ALTERNATIVE PRODUCTS:
CC       Event=Alternative splicing; Named isoforms=2;
CC       Name=1;
CC         IsoId=Q16595-1; Sequence=Displayed;
CC       Name=2;
CC         IsoId=Q16595-2; Sequence=VSP_001576;
CC         Note=Not highly expressed and may be artifactual;
CC   -!- TISSUE SPECIFICITY: Frataxin(81-210) is expressed in the heart,
CC       peripheral blood lymphocytes and dermal fibroblasts.
CC   -!- PTM: Processed in two steps by mitochondrial processing peptidase
CC       (MPP). MPP first cleaves the precursor to intermediate form and
CC       subsequently converts the intermediate to mature size protein. Two
CC       forms exist, frataxin(56-210) and frataxin(81-210) which is the
CC       main form of mature frataxin.
CC   -!- DISEASE: Defects in FXN are the cause of Friedreich ataxia (FA)
CC       [MIM:229300]. FA is an autosomal recessive, progressive
CC       degenerative disease characterized by neurodegeneration and
CC       cardiomyopathy it is the most common inherited ataxia. The
CC       disorder is usually manifest before adolescence and is generally
CC       characterized by incoordination of limb movements, dysarthria,
CC       nystagmus, diminished or absent tendon reflexes, Babinski sign,
CC       impairment of position and vibratory senses, scoliosis, pes cavus,
CC       and hammer toe. In most patients, FA is due to GAA triplet repeat
CC       expansions in the first intron of the frataxin gene. But in some
CC       cases the disease is due to mutations in the coding region.
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -!- WEB RESOURCE: Name=GeneReviews;
CC       URL="http://www.ncbi.nlm.nih.gov/sites/GeneTests/lab/gene/FXN";
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; U43747; AAA98510.1; -; mRNA.
DR   EMBL; U43752; AAA98508.1; -; Genomic_DNA.
DR   EMBL; U43748; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43749; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43750; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43751; AAA98508.1; JOINED; Genomic_DNA.
DR   EMBL; U43753; AAA98509.1; -; Genomic_DNA.
DR   EMBL; U43748; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; U43749; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; U43750; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; U43751; AAA98509.1; JOINED; Genomic_DNA.
DR   EMBL; AL162730; CAH71829.1; -; Genomic_DNA.
DR   EMBL; BC023633; AAH23633.1; -; mRNA.
DR   EMBL; BC048097; AAH48097.1; -; mRNA.
DR   EMBL; Y13751; CAA74077.1; -; Genomic_DNA.
DR   EMBL; AF028240; AAB84047.1; -; Genomic_DNA.
DR   EMBL; U93173; AAD00734.1; -; Genomic_DNA.
DR   IPI; IPI00217745; -.
DR   IPI; IPI00293425; -.
DR   RefSeq; NP_000135.2; -.
DR   RefSeq; NP_001155178.1; -.
DR   RefSeq; NP_852090.1; -.
DR   UniGene; Hs.20685; -.
DR   PDB; 1EKG; X-ray; 1.80 A; A=88-210.
DR   PDB; 1LY7; NMR; -; A=91-210.
DR   PDBsum; 1EKG; -.
DR   PDBsum; 1LY7; -.
DR   ProteinModelPortal; Q16595; -.
DR   IntAct; Q16595; 2.
DR   MINT; MINT-2856590; -.
DR   STRING; Q16595; -.
DR   TCDB; 9.B.21.1.1; frataxin family.
DR   OGP; Q16595; -.
DR   PeptideAtlas; Q16595; -.
DR   PRIDE; Q16595; -.
DR   Ensembl; ENST00000377270; ENSP00000366482; ENSG00000165060; Homo sapiens.
DR   GeneID; 2395; -.
DR   KEGG; hsa:2395; -.
DR   NMPDR; fig|9606.3.peg.31391; -.
DR   UCSC; uc004aha.1; human.
DR   CTD; 2395; -.
DR   GeneCards; GC09P071650; -.
DR   H-InvDB; HIX0025740; -.
DR   HGNC; HGNC:3951; FXN.
DR   HPA; CAB022164; -.
DR   MIM; 229300; phenotype.
DR   MIM; 606829; gene.
DR   Orphanet; 95; Friedreich ataxia.
DR   PharmGKB; PA28369; -.
DR   eggNOG; prNOG11242; -.
DR   HOGENOM; HBG125781; -.
DR   HOVERGEN; HBG005745; -.
DR   InParanoid; Q16595; -.
DR   OMA; AYSGKGT; -.
DR   OrthoDB; EOG9C5G4B; -.
DR   PhylomeDB; Q16595; -.
DR   NextBio; 9641; -.
DR   ArrayExpress; Q16595; -.
DR   Bgee; Q16595; -.
DR   CleanEx; HS_FXN; -.
DR   Genevestigator; Q16595; -.
DR   GermOnline; ENSG00000165060; Homo sapiens.
DR   GO; GO:0005829; C:cytosol; IDA:BHF-UCL.
DR   GO; GO:0005759; C:mitochondrial matrix; NAS:BHF-UCL.
DR   GO; GO:0051537; F:2 iron, 2 sulfur cluster binding; IDA:BHF-UCL.
DR   GO; GO:0008199; F:ferric iron binding; IDA:BHF-UCL.
DR   GO; GO:0008198; F:ferrous iron binding; IDA:BHF-UCL.
DR   GO; GO:0034986; F:iron chaperone activity; IDA:BHF-UCL.
DR   GO; GO:0005515; F:protein binding; IPI:UniProtKB.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IMP:BHF-UCL.
DR   GO; GO:0006783; P:heme biosynthetic process; NAS:BHF-UCL.
DR   GO; GO:0018283; P:iron incorporation into metallo-sulfur cluster; IDA:BHF-UCL.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   GO; GO:0030307; P:positive regulation of cell growth; IMP:BHF-UCL.
DR   GO; GO:0008284; P:positive regulation of cell proliferation; IMP:BHF-UCL.
DR   GO; GO:0051349; P:positive regulation of lyase activity; IMP:BHF-UCL.
DR   GO; GO:0048554; P:positive regulation of metalloenzyme activity; IMP:BHF-UCL.
DR   GO; GO:0051353; P:positive regulation of oxidoreductase activity; IMP:BHF-UCL.
DR   GO; GO:0051347; P:positive regulation of transferase activity; IMP:BHF-UCL.
DR   GO; GO:0016540; P:protein autoprocessing; IDA:BHF-UCL.
DR   GO; GO:0010722; P:regulation of ferrochelatase activity; IDA:BHF-UCL.
DR   GO; GO:0010039; P:response to iron ion; IMP:BHF-UCL.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   1: Evidence at protein level;
KW   3D-structure; Alternative splicing; Complete proteome; Cytoplasm;
KW   Direct protein sequencing; Disease mutation; Ion transport; Iron;
KW   Iron transport; Mitochondrion; Polymorphism; Transit peptide;
KW   Transport; Triplet repeat expansion.
FT   TRANSIT       1     41       Mitochondrion.
FT   CHAIN        42    210       Frataxin intermediate form.
FT                                /FTId=PRO_0000010129.
FT   CHAIN        56    210       Frataxin(56-210).
FT                                /FTId=PRO_0000010130.
FT   CHAIN        81    210       Frataxin(81-210).
FT                                /FTId=PRO_0000289331.
FT   VAR_SEQ     161    210       SGPKRYDWTGKNWVYSHDGVSLHELLAAELTKALKTKLDLS
FT                                SLAYSGKDA -> RLTWLLWLFHP (in isoform 2).
FT                                /FTId=VSP_001576.
FT   VARIANT     106    106       L -> S (in FA).
FT                                /FTId=VAR_016065.
FT   VARIANT     122    122       D -> Y (in FA).
FT                                /FTId=VAR_002428.
FT   VARIANT     130    130       G -> V (in FA).
FT                                /FTId=VAR_002429.
FT   VARIANT     154    154       I -> F (in FA; reduces interaction with
FT                                LYRM4. Interaction is rescued by nickel).
FT                                /FTId=VAR_002430.
FT   VARIANT     155    155       W -> R (in FA; reduces interaction with
FT                                LYRM4. Interaction is rescued by nickel).
FT                                /FTId=VAR_002431.
FT   VARIANT     165    165       R -> C (in FA; mild form).
FT                                /FTId=VAR_008139.
FT   VARIANT     182    182       L -> F (in FA).
FT                                /FTId=VAR_008140.
FT   VARIANT     198    198       L -> R (in FA).
FT                                /FTId=VAR_016066.
FT   VARIANT     202    202       S -> C (in dbSNP:rs1052195).
FT                                /FTId=VAR_049100.
FT   MUTAGEN      53     53       R->G: Abolished cleavage of frataxin(81-
FT                                210); when associated with G-54.
FT   MUTAGEN      54     54       R->G: Abolished cleavage of frataxin(81-
FT                                210) and allows the accumulation of
FT                                frataxin(56-210); when associated with G-
FT                                53.
FT   MUTAGEN      79     79       R->G: Abolished cleavage of frataxin(81-
FT                                210) and allows the accumulation of
FT                                frataxin(56-210); when associated with G-
FT                                80.
FT   MUTAGEN      80     80       K->G: Abolished cleavage of frataxin(81-
FT                                210); when associated with G-79.
FT   CONFLICT    175    175       Y -> F (in Ref. 1; AAA98508/AAA98510).
FT   CONFLICT    202    202       S -> W (in Ref. 1; AAA98508/AAA98510).
FT   HELIX        92    113
FT   STRAND      124    128
FT   STRAND      131    135
FT   STRAND      142    148
FT   TURN        149    152
FT   STRAND      153    158
FT   TURN        159    161
FT   STRAND      162    168
FT   STRAND      170    175
FT   TURN        176    178
FT   HELIX       182    194
SQ   SEQUENCE   210 AA;  23135 MW;  ECC81738779308CF CRC64;
     MWTLGRRAVA GLLASPSPAQ AQTLTRVPRP AELAPLCGRR GLRTDIDATC TPRRASSNQR
     GLNQIWNVKK QSVYLMNLRK SGTLGHPGSL DETTYERLAE ETLDSLAEFF EDLADKPYTF
     EDYDVSFGSG VLTVKLGGDL GTYVINKQTP NKQIWLSSPS SGPKRYDWTG KNWVYSHDGV
     SLHELLAAEL TKALKTKLDL SSLAYSGKDA
//


ID   FRDA_DROME              Reviewed;         190 AA.
AC   Q9W385; Q9GQQ7;
DT   01-DEC-2000, integrated into UniProtKB/Swiss-Prot.
DT   01-MAY-2000, sequence version 1.
DT   10-AUG-2010, entry version 77.
DE   RecName: Full=Frataxin homolog, mitochondrial;
DE            Short=Dfh;
DE   Flags: Precursor;
GN   Name=fh; ORFNames=CG8971;
OS   Drosophila melanogaster (Fruit fly).
OC   Eukaryota; Metazoa; Arthropoda; Hexapoda; Insecta; Pterygota;
OC   Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha;
OC   Ephydroidea; Drosophilidae; Drosophila; Sophophora.
OX   NCBI_TaxID=7227;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA / MRNA], AND DEVELOPMENTAL STAGE.
RX   MEDLINE=20509989; PubMed=11054533; DOI=10.1016/S0378-1119(00)00343-7;
RA   Canizares-Sales J., Blanca-Postigo J.M., Navarro J.A., Monros E.,
RA   Palau-Martinez F., Molto-Ruiz M.D.;
RT   "dfh is a Drosophila homolog of the Friedreich's ataxia disease
RT   gene.";
RL   Gene 256:35-42(2000).
RN   [2]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=Berkeley;
RX   MEDLINE=20196006; PubMed=10731132; DOI=10.1126/science.287.5461.2185;
RA   Adams M.D., Celniker S.E., Holt R.A., Evans C.A., Gocayne J.D.,
RA   Amanatides P.G., Scherer S.E., Li P.W., Hoskins R.A., Galle R.F.,
RA   George R.A., Lewis S.E., Richards S., Ashburner M., Henderson S.N.,
RA   Sutton G.G., Wortman J.R., Yandell M.D., Zhang Q., Chen L.X.,
RA   Brandon R.C., Rogers Y.-H.C., Blazej R.G., Champe M., Pfeiffer B.D.,
RA   Wan K.H., Doyle C., Baxter E.G., Helt G., Nelson C.R., Miklos G.L.G.,
RA   Abril J.F., Agbayani A., An H.-J., Andrews-Pfannkoch C., Baldwin D.,
RA   Ballew R.M., Basu A., Baxendale J., Bayraktaroglu L., Beasley E.M.,
RA   Beeson K.Y., Benos P.V., Berman B.P., Bhandari D., Bolshakov S.,
RA   Borkova D., Botchan M.R., Bouck J., Brokstein P., Brottier P.,
RA   Burtis K.C., Busam D.A., Butler H., Cadieu E., Center A., Chandra I.,
RA   Cherry J.M., Cawley S., Dahlke C., Davenport L.B., Davies P.,
RA   de Pablos B., Delcher A., Deng Z., Mays A.D., Dew I., Dietz S.M.,
RA   Dodson K., Doup L.E., Downes M., Dugan-Rocha S., Dunkov B.C., Dunn P.,
RA   Durbin K.J., Evangelista C.C., Ferraz C., Ferriera S., Fleischmann W.,
RA   Fosler C., Gabrielian A.E., Garg N.S., Gelbart W.M., Glasser K.,
RA   Glodek A., Gong F., Gorrell J.H., Gu Z., Guan P., Harris M.,
RA   Harris N.L., Harvey D.A., Heiman T.J., Hernandez J.R., Houck J.,
RA   Hostin D., Houston K.A., Howland T.J., Wei M.-H., Ibegwam C.,
RA   Jalali M., Kalush F., Karpen G.H., Ke Z., Kennison J.A., Ketchum K.A.,
RA   Kimmel B.E., Kodira C.D., Kraft C.L., Kravitz S., Kulp D., Lai Z.,
RA   Lasko P., Lei Y., Levitsky A.A., Li J.H., Li Z., Liang Y., Lin X.,
RA   Liu X., Mattei B., McIntosh T.C., McLeod M.P., McPherson D.,
RA   Merkulov G., Milshina N.V., Mobarry C., Morris J., Moshrefi A.,
RA   Mount S.M., Moy M., Murphy B., Murphy L., Muzny D.M., Nelson D.L.,
RA   Nelson D.R., Nelson K.A., Nixon K., Nusskern D.R., Pacleb J.M.,
RA   Palazzolo M., Pittman G.S., Pan S., Pollard J., Puri V., Reese M.G.,
RA   Reinert K., Remington K., Saunders R.D.C., Scheeler F., Shen H.,
RA   Shue B.C., Siden-Kiamos I., Simpson M., Skupski M.P., Smith T.J.,
RA   Spier E., Spradling A.C., Stapleton M., Strong R., Sun E.,
RA   Svirskas R., Tector C., Turner R., Venter E., Wang A.H., Wang X.,
RA   Wang Z.-Y., Wassarman D.A., Weinstock G.M., Weissenbach J.,
RA   Williams S.M., Woodage T., Worley K.C., Wu D., Yang S., Yao Q.A.,
RA   Ye J., Yeh R.-F., Zaveri J.S., Zhan M., Zhang G., Zhao Q., Zheng L.,
RA   Zheng X.H., Zhong F.N., Zhong W., Zhou X., Zhu S.C., Zhu X.,
RA   Smith H.O., Gibbs R.A., Myers E.W., Rubin G.M., Venter J.C.;
RT   "The genome sequence of Drosophila melanogaster.";
RL   Science 287:2185-2195(2000).
RN   [3]
RP   GENOME REANNOTATION.
RX   MEDLINE=22426069; PubMed=12537572;
RA   Misra S., Crosby M.A., Mungall C.J., Matthews B.B., Campbell K.S.,
RA   Hradecky P., Huang Y., Kaminker J.S., Millburn G.H., Prochnik S.E.,
RA   Smith C.D., Tupy J.L., Whitfield E.J., Bayraktaroglu L., Berman B.P.,
RA   Bettencourt B.R., Celniker S.E., de Grey A.D.N.J., Drysdale R.A.,
RA   Harris N.L., Richter J., Russo S., Schroeder A.J., Shu S.Q.,
RA   Stapleton M., Yamada C., Ashburner M., Gelbart W.M., Rubin G.M.,
RA   Lewis S.E.;
RT   "Annotation of the Drosophila melanogaster euchromatic genome: a
RT   systematic review.";
RL   Genome Biol. 3:RESEARCH0083.1-RESEARCH0083.22(2002).
RN   [4]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   STRAIN=Berkeley; TISSUE=Testis;
RX   MEDLINE=22426066; PubMed=12537569;
RA   Stapleton M., Carlson J.W., Brokstein P., Yu C., Champe M.,
RA   George R.A., Guarin H., Kronmiller B., Pacleb J.M., Park S., Wan K.H.,
RA   Rubin G.M., Celniker S.E.;
RT   "A Drosophila full-length cDNA resource.";
RL   Genome Biol. 3:RESEARCH0080.1-RESEARCH0080.8(2002).
RN   [5]
RP   FUNCTION.
RX   PubMed=18540637; DOI=10.1021/bi800366d;
RA   Kondapalli K.C., Kok N.M., Dancis A., Stemmler T.L.;
RT   "Drosophila frataxin: an iron chaperone during cellular Fe-S cluster
RT   bioassembly.";
RL   Biochemistry 47:6917-6927(2008).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral.
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity).
CC   -!- SUBCELLULAR LOCATION: Mitochondrion (By similarity).
CC   -!- DEVELOPMENTAL STAGE: Expressed throughout development, levels are
CC       high during embryogenesis but low in following stages.
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AJ002208; CAC20098.1; -; mRNA.
DR   EMBL; AF208491; AAG35732.1; -; mRNA.
DR   EMBL; AF208492; AAG35733.1; -; Genomic_DNA.
DR   EMBL; AE014298; AAF46449.1; -; Genomic_DNA.
DR   EMBL; AY094649; AAM11002.1; -; mRNA.
DR   RefSeq; NP_511094.1; -.
DR   UniGene; Dm.2903; -.
DR   ProteinModelPortal; Q9W385; -.
DR   SMR; Q9W385; 68-190.
DR   IntAct; Q9W385; 1.
DR   STRING; Q9W385; -.
DR   PRIDE; Q9W385; -.
DR   EnsemblMetazoa; FBtr0071348; FBpp0071283; FBgn0030092.
DR   GeneID; 31845; -.
DR   KEGG; dme:Dmel_CG8971; -.
DR   NMPDR; fig|7227.3.peg.17097; -.
DR   CTD; 31845; -.
DR   FlyBase; FBgn0030092; fh.
DR   eggNOG; inNOG10940; -.
DR   InParanoid; Q9W385; -.
DR   OMA; DALCDYF; -.
DR   OrthoDB; EOG9JHCN6; -.
DR   PhylomeDB; Q9W385; -.
DR   NextBio; 775622; -.
DR   Bgee; Q9W385; -.
DR   GermOnline; CG8971; Drosophila melanogaster.
DR   GO; GO:0005739; C:mitochondrion; IEA:UniProtKB-SubCell.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   GO; GO:0042542; P:response to hydrogen peroxide; IMP:FlyBase.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
KW   Complete proteome; Ion transport; Iron; Iron transport; Mitochondrion;
KW   Transit peptide; Transport.
FT   TRANSIT       1      ?       Mitochondrion.
FT   CHAIN         ?    190       Frataxin homolog, mitochondrial.
FT                                /FTId=PRO_0000010133.
SQ   SEQUENCE   190 AA;  20922 MW;  8C48332C239F3036 CRC64;
     MFAGRLMVRS IVGRACLATM GRWSKPQAHA SQVILPSTPA IAAVAIQCEE FTANRRLFSS
     QIETESTLDG ATYERVCSDT LDALCDYFEE LTENASELQG TDVAYSDGVL TVNLGGQHGT
     YVINRQTPNK QIWLSSPTSG PKRYDFVGTV AAGRWIYKHS GQSLHELLQQ EIPGILKSQS
     VDFLRLPYCS
//


ID   Q9GQQ5_DROSU            Unreviewed;       185 AA.
AC   Q9GQQ5;
DT   01-MAR-2001, integrated into UniProtKB/TrEMBL.
DT   01-MAR-2001, sequence version 1.
DT   02-MAR-2010, entry version 28.
DE   SubName: Full=Frataxin-like protein;
GN   Name=fh;
OS   Drosophila subobscura (Fruit fly).
OC   Eukaryota; Metazoa; Arthropoda; Hexapoda; Insecta; Pterygota;
OC   Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha;
OC   Ephydroidea; Drosophilidae; Drosophila; Sophophora.
OX   NCBI_TaxID=7241;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RA   Canizares-Sales J., Blanca-Postigo J.M., Navarro-Langa J.A.,
RA   Monros-Marin E., Palau-Martinez F., Molto-Ruiz M.D.;
RT   "dfh, A Drosophila homolog of the Friedreich's ataxia disease gene.";
RL   Submitted (NOV-1999) to the EMBL/GenBank/DDBJ databases.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AF209098; AAG37996.1; -; Genomic_DNA.
DR   HSSP; Q16595; 1EKG.
DR   SMR; Q9GQQ5; 63-185.
DR   FlyBase; FBgn0043392; Dsub\fh.
DR   GO; GO:0005739; C:mitochondrion; IEA:InterPro.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   185 AA;  20766 MW;  3C06D9085FBA6A0C CRC64;
     MFTRRLLTRL SRLNIRSATT AGYQSSWYSR LPTVTTASES LSQNNGPLNK RLFSNQIETE
     SALDTATYER LCSETLDGLC DYFEELTENA TDLIGTDVAY GDGVLTVNLG KSHGTYVINR
     QTPNKQIWLS SPTSGPKRFD FVGTPKAGKW IYRHTGQSLH QLLQLEIPTI VKSQTVDFMR
     LPHCS
//


ID   FRDA_CAEEL              Reviewed;         136 AA.
AC   Q9TY03;
DT   01-DEC-2000, integrated into UniProtKB/Swiss-Prot.
DT   01-MAY-2000, sequence version 1.
DT   10-AUG-2010, entry version 59.
DE   RecName: Full=Frataxin, mitochondrial;
DE            Short=Fxn;
DE   Flags: Precursor;
GN   Name=frh-1; ORFNames=F59G1.7;
OS   Caenorhabditis elegans.
OC   Eukaryota; Metazoa; Nematoda; Chromadorea; Rhabditida; Rhabditoidea;
OC   Rhabditidae; Peloderinae; Caenorhabditis.
OX   NCBI_TaxID=6239;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [MRNA].
RC   STRAIN=Bristol N2;
RA   Vazquez-Manrique R.P., Baylis H.A., Palau F.;
RT   "Characterization of the Caenorhabditis elegans ortholog of the
RT   frataxin.";
RL   Submitted (JUL-2001) to the EMBL/GenBank/DDBJ databases.
RN   [2]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=Bristol N2;
RX   MEDLINE=99069613; PubMed=9851916; DOI=10.1126/science.282.5396.2012;
RG   The C. elegans sequencing consortium;
RT   "Genome sequence of the nematode C. elegans: a platform for
RT   investigating biology.";
RL   Science 282:2012-2018(1998).
RN   [3]
RP   FUNCTION.
RX   PubMed=16293572; DOI=10.1096/fj.05-4212fje;
RA   Vazquez-Manrique R.P., Gonzalez-Cabo P., Ros S., Aziz H., Baylis H.A.,
RA   Palau F.;
RT   "Reduction of Caenorhabditis elegans frataxin increases sensitivity to
RT   oxidative stress, reduces lifespan, and causes lethality in a
RT   mitochondrial complex II mutant.";
RL   FASEB J. 20:172-174(2006).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral.
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity).
CC   -!- SUBCELLULAR LOCATION: Mitochondrion (By similarity).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AY048153; AAL05950.1; -; mRNA.
DR   EMBL; U53332; AAK31530.1; -; Genomic_DNA.
DR   PIR; T34316; T34316.
DR   RefSeq; NP_495183.1; -.
DR   UniGene; Cel.20708; -.
DR   ProteinModelPortal; Q9TY03; -.
DR   SMR; Q9TY03; 21-134.
DR   IntAct; Q9TY03; 2.
DR   STRING; Q9TY03; -.
DR   EnsemblMetazoa; F59G1.7.1; F59G1.7.1; F59G1.7.
DR   EnsemblMetazoa; F59G1.7.2; F59G1.7.2; F59G1.7.
DR   GeneID; 174002; -.
DR   KEGG; cel:F59G1.7; -.
DR   UCSC; F59G1.7.1; c. elegans.
DR   CTD; 174002; -.
DR   WormBase; F59G1.7; CE19476; WBGene00001486; frh-1.
DR   eggNOG; meNOG17198; -.
DR   HOGENOM; HBG396998; -.
DR   InParanoid; Q9TY03; -.
DR   OMA; YFDQIAD; -.
DR   PhylomeDB; Q9TY03; -.
DR   NextBio; 882063; -.
DR   ArrayExpress; Q9TY03; -.
DR   GO; GO:0005739; C:mitochondrion; IDA:WormBase.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   GO; GO:0008340; P:determination of adult lifespan; IMP:WormBase.
DR   GO; GO:0009792; P:embryonic development ending in birth or eg...; IMP:WormBase.
DR   GO; GO:0040007; P:growth; IMP:WormBase.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   GO; GO:0040011; P:locomotion; IMP:WormBase.
DR   GO; GO:0002119; P:nematode larval development; IMP:WormBase.
DR   GO; GO:0040010; P:positive regulation of growth rate; IMP:WormBase.
DR   GO; GO:0040018; P:positive regulation of multicellular organi...; IMP:WormBase.
DR   GO; GO:0042542; P:response to hydrogen peroxide; IMP:WormBase.
DR   GO; GO:0000303; P:response to superoxide; IMP:WormBase.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
KW   Complete proteome; Ion transport; Iron; Iron transport; Mitochondrion;
KW   Transit peptide; Transport.
FT   TRANSIT       1      ?       Mitochondrion (Potential).
FT   CHAIN         ?    136       Frataxin, mitochondrial.
FT                                /FTId=PRO_0000193925.
SQ   SEQUENCE   136 AA;  15718 MW;  0ACB254346E38272 CRC64;
     MLSTILRNNF VRRSFSSRIF SQNEYETAAD STLERLSDYF DQIADSFPVS EQFDVSHAMG
     VLTVNVSKSV GTYVINKQSP NKQIWLSSPM SGPKRYDLEE EGKWTYAHDG EQLDSLLNRE
     FRKILADDRI DFSRHV
//


ID   Q6PDS4_MOUSE            Unreviewed;       101 AA.
AC   Q6PDS4;
DT   05-JUL-2004, integrated into UniProtKB/TrEMBL.
DT   05-JUL-2004, sequence version 1.
DT   13-JUL-2010, entry version 32.
DE   SubName: Full=Fxn protein;
GN   Name=Fxn;
OS   Mus musculus (Mouse).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Mammalia; Eutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi;
OC   Muroidea; Muridae; Murinae; Mus.
OX   NCBI_TaxID=10090;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   STRAIN=C57BL/6; TISSUE=Brain;
RX   PubMed=15489334; DOI=10.1101/gr.2596504;
RG   The MGC Project Team;
RT   "The status, quality, and expansion of the NIH full-length cDNA
RT   project: the Mammalian Gene Collection (MGC).";
RL   Genome Res. 14:2121-2127(2004).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; BC058533; AAH58533.1; -; mRNA.
DR   IPI; IPI00461629; -.
DR   UniGene; Mm.7319; -.
DR   SMR; Q6PDS4; 21-99.
DR   STRING; Q6PDS4; -.
DR   PRIDE; Q6PDS4; -.
DR   Genevestigator; Q6PDS4; -.
DR   GO; GO:0005739; C:mitochondrion; IDA:MGI.
DR   GO; GO:0007628; P:adult walking behavior; IMP:MGI.
DR   GO; GO:0009060; P:aerobic respiration; IMP:MGI.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IMP:MGI.
DR   GO; GO:0009792; P:embryonic development ending in birth or eg...; IMP:MGI.
DR   GO; GO:0016226; P:iron-sulfur cluster assembly; IMP:MGI.
DR   GO; GO:0007005; P:mitochondrion organization; IMP:MGI.
DR   GO; GO:0040015; P:negative regulation of multicellular organi...; IMP:MGI.
DR   GO; GO:0046621; P:negative regulation of organ growth; IMP:MGI.
DR   GO; GO:0006119; P:oxidative phosphorylation; IMP:MGI.
DR   GO; GO:0019230; P:proprioception; IMP:MGI.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   101 AA;  11084 MW;  32F0208E7BB33372 CRC64;
     MSLLGYLLAL LRSVFSLITD GVLTIKLGGD LGTYVINKQT PNKQIWLSSP SSGPKRYDWT
     GKNWVYSHDG VSLHELLARE LTKALNTKLD LSSLAYSGKG T
//


ID   Q74Z19_ASHGO            Unreviewed;       119 AA.
AC   Q74Z19;
DT   05-JUL-2004, integrated into UniProtKB/TrEMBL.
DT   11-OCT-2004, sequence version 2.
DT   18-MAY-2010, entry version 40.
DE   SubName: Full=AGR387Cp;
GN   OrderedLocusNames=AGR387C; ORFNames=AGOS_AGR387C;
OS   Ashbya gossypii (Yeast) (Eremothecium gossypii).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta;
OC   Saccharomycotina; Saccharomycetes; Saccharomycetales;
OC   Saccharomycetaceae; Eremothecium.
OX   NCBI_TaxID=33169;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC 10895 / CBS 109.51 / FGSC 9923 / NRRL Y-1056;
RX   PubMed=15001715; DOI=10.1126/science.1095781;
RA   Dietrich F.S., Voegeli S., Brachat S., Lerch A., Gates K., Steiner S.,
RA   Mohr C., Poehlmann R., Luedi P., Choi S., Wing R.A., Flavier A.,
RA   Gaffney T.D., Philippsen P.;
RT   "The Ashbya gossypii genome as a tool for mapping the ancient
RT   Saccharomyces cerevisiae genome.";
RL   Science 304:304-307(2004).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AE016820; AAS54877.2; -; Genomic_DNA.
DR   RefSeq; NP_987053.2; -.
DR   SMR; Q74Z19; 3-113.
DR   STRING; Q74Z19; -.
DR   GeneID; 4623357; -.
DR   GenomeReviews; AE016820_GR; AGR387C.
DR   KEGG; ago:AGOS_AGR387C; -.
DR   AGD; AGR387C; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG396998; -.
DR   OMA; HIPEVEY; -.
DR   OrthoDB; EOG98963R; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:InterPro.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   119 AA;  13262 MW;  325E397EF471AD83 CRC64;
     MRAPPELAQL TPQAYHKQAD EFLNDLLDRL EALGDERPDI IADSEYSQGV LTLSVPALGT
     YVINKQPPNK QIWLSSPVSG PNRYDLIDGE WVSLRDGSRL MAVLSRELGR ALDNPDYAL
//


ID   Q5ZAV6_ORYSJ            Unreviewed;       198 AA.
AC   Q5ZAV6;
DT   23-NOV-2004, integrated into UniProtKB/TrEMBL.
DT   23-NOV-2004, sequence version 1.
DT   13-JUL-2010, entry version 24.
DE   SubName: Full=Putative frataxin;
DE   SubName: Full=Putative uncharacterized protein;
DE   SubName: Full=cDNA, clone: J053063D20, full insert sequence;
GN   Name=B1100D10.41; ORFNames=OsJ_03697;
OS   Oryza sativa subsp. japonica (Rice).
OC   Eukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta;
OC   Spermatophyta; Magnoliophyta; Liliopsida; Poales; Poaceae; BEP clade;
OC   Ehrhartoideae; Oryzeae; Oryza.
OX   NCBI_TaxID=39947;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RX   MEDLINE=22337376; PubMed=12447438; DOI=10.1038/nature01184;
RA   Sasaki T., Matsumoto T., Yamamoto K., Sakata K., Baba T., Katayose Y.,
RA   Wu J., Niimura Y., Cheng Z., Nagamura Y., Antonio B.A., Kanamori H.,
RA   Hosokawa S., Masukawa M., Arikawa K., Chiden Y., Hayashi M.,
RA   Okamoto M., Ando T., Aoki H., Arita K., Hamada M., Harada C.,
RA   Hijishita S., Honda M., Ichikawa Y., Idonuma A., Iijima M., Ikeda M.,
RA   Ikeno M., Ito S., Ito T., Ito Y., Ito Y., Iwabuchi A., Kamiya K.,
RA   Karasawa W., Katagiri S., Kikuta A., Kobayashi N., Kono I.,
RA   Machita K., Maehara T., Mizuno H., Mizubayashi T., Mukai Y.,
RA   Nagasaki H., Nakashima M., Nakama Y., Nakamichi Y., Nakamura M.,
RA   Namiki N., Negishi M., Ohta I., Ono N., Saji S., Sakai K., Shibata M.,
RA   Shimokawa T., Shomura A., Song J., Takazaki Y., Terasawa K., Tsuji K.,
RA   Waki K., Yamagata H., Yamane H., Yoshiki S., Yoshihara R., Yukawa K.,
RA   Zhong H., Iwama H., Endo T., Ito H., Hahn J.H., Kim H.-I., Eun M.-Y.,
RA   Yano M., Jiang J., Gojobori T.;
RT   "The genome sequence and structure of rice chromosome 1.";
RL   Nature 420:312-316(2002).
RN   [2]
RP   NUCLEOTIDE SEQUENCE.
RC   TISSUE=Callus;
RA   Kikuchi S.;
RT   "Oryza sativa full length cDNA.";
RL   Submitted (OCT-2006) to the EMBL/GenBank/DDBJ databases.
RN   [3]
RP   NUCLEOTIDE SEQUENCE.
RX   PubMed=15685292; DOI=10.1371/journal.pbio.0030038;
RA   Yu J., Wang J., Lin W., Li S., Li H., Zhou J., Ni P., Dong W., Hu S.,
RA   Zeng C., Zhang J., Zhang Y., Li R., Xu Z., Li S., Li X., Zheng H.,
RA   Cong L., Lin L., Yin J., Geng J., Li G., Shi J., Liu J., Lv H., Li J.,
RA   Wang J., Deng Y., Ran L., Shi X., Wang X., Wu Q., Li C., Ren X.,
RA   Wang J., Wang X., Li D., Liu D., Zhang X., Ji Z., Zhao W., Sun Y.,
RA   Zhang Z., Bao J., Han Y., Dong L., Ji J., Chen P., Wu S., Liu J.,
RA   Xiao Y., Bu D., Tan J., Yang L., Ye C., Zhang J., Xu J., Zhou Y.,
RA   Yu Y., Zhang B., Zhuang S., Wei H., Liu B., Lei M., Yu H., Li Y.,
RA   Xu H., Wei S., He X., Fang L., Zhang Z., Zhang Y., Huang X., Su Z.,
RA   Tong W., Li J., Tong Z., Li S., Ye J., Wang L., Fang L., Lei T.,
RA   Chen C.-S., Chen H.-C., Xu Z., Li H., Huang H., Zhang F., Xu H.,
RA   Li N., Zhao C., Li S., Dong L., Huang Y., Li L., Xi Y., Qi Q., Li W.,
RA   Zhang B., Hu W., Zhang Y., Tian X., Jiao Y., Liang X., Jin J., Gao L.,
RA   Zheng W., Hao B., Liu S.-M., Wang W., Yuan L., Cao M., McDermott J.,
RA   Samudrala R., Wang J., Wong G.K.-S., Yang H.;
RT   "The genomes of Oryza sativa: a history of duplications.";
RL   PLoS Biol. 3:266-281(2005).
RN   [4]
RP   NUCLEOTIDE SEQUENCE.
RA   Wang J., Li R., Fan W., Huang Q., Zhang J., Zhou Y., Hu Y., Zi S.,
RA   Li J., Ni P., Zheng H., Zhang Y., Zhao M., Hao Q., McDermott J.,
RA   Samudrala R., Kristiansen K., Wong G.K.-S.;
RT   "Improved gene annotation of the rice (Oryza sativa) genomes.";
RL   Submitted (SEP-2006) to the EMBL/GenBank/DDBJ databases.
RN   [5]
RP   NUCLEOTIDE SEQUENCE.
RA   Wang J., Li R., Fan W., Huang Q., Zhang J., Zhou Y., Hu Y., Zi S.,
RA   Li J., Ni P., Zheng H., Zhang Y., Zhao M., Hao Q., McDermott J.,
RA   Samudrala R., Kristiansen K., Wong G.K.-S.;
RL   Submitted (DEC-2008) to the EMBL/GenBank/DDBJ databases.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AP003368; BAD53291.1; -; Genomic_DNA.
DR   EMBL; AK240768; BAH00860.1; -; mRNA.
DR   EMBL; CM000138; EEE55502.1; -; Genomic_DNA.
DR   EnsemblPlants; LOC_Os01g57460.1; LOC_Os01g57460.1; LOC_Os01g57460.
DR   Gramene; Q5ZAV6; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:InterPro.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
SQ   SEQUENCE   198 AA;  21408 MW;  A1020709787FA874 CRC64;
     MASRKLVLGL TAARRLRSRA PVLVSSSPFL EASTSTSDAT AATATRGSGL GPWGLFLSSR
     ALSSTRPVSL SAGDAPGSSA ADHRSILPED EYHKLADETI HDLLEKLEEY GDSLQMDGFD
     IDYGNQVLTL RLGELGTYVV NKQAPNRQIW LSSPVSGPSR FDWDAPTNCW IYRRTGANLV
     ELLEKEIGEL CGTPVELS
//


ID   FRDA_ARATH              Reviewed;         187 AA.
AC   Q9ZR07; Q6GKV0;
DT   01-DEC-2000, integrated into UniProtKB/Swiss-Prot.
DT   06-DEC-2005, sequence version 2.
DT   10-AUG-2010, entry version 65.
DE   RecName: Full=Frataxin, mitochondrial;
DE            Short=Fxn;
DE   Flags: Precursor;
GN   Name=FH; OrderedLocusNames=At4g03240; ORFNames=F4C21.17;
OS   Arabidopsis thaliana (Mouse-ear cress).
OC   Eukaryota; Viridiplantae; Streptophyta; Embryophyta; Tracheophyta;
OC   Spermatophyta; Magnoliophyta; eudicotyledons; core eudicotyledons;
OC   rosids; malvids; Brassicales; Brassicaceae; Arabidopsis.
OX   NCBI_TaxID=3702;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [MRNA].
RX   PubMed=15474026; DOI=10.1016/j.febslet.2004.09.003;
RA   Busi M.V., Zabaleta E.J., Araya A., Gomez-Casati D.F.;
RT   "Functional and molecular characterization of the frataxin homolog
RT   from Arabidopsis thaliana.";
RL   FEBS Lett. 576:141-144(2004).
RN   [2]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=cv. Columbia;
RX   MEDLINE=20083488; PubMed=10617198; DOI=10.1038/47134;
RA   Mayer K.F.X., Schueller C., Wambutt R., Murphy G., Volckaert G.,
RA   Pohl T., Duesterhoeft A., Stiekema W., Entian K.-D., Terryn N.,
RA   Harris B., Ansorge W., Brandt P., Grivell L.A., Rieger M.,
RA   Weichselgartner M., de Simone V., Obermaier B., Mache R., Mueller M.,
RA   Kreis M., Delseny M., Puigdomenech P., Watson M., Schmidtheini T.,
RA   Reichert B., Portetelle D., Perez-Alonso M., Boutry M., Bancroft I.,
RA   Vos P., Hoheisel J., Zimmermann W., Wedler H., Ridley P.,
RA   Langham S.-A., McCullagh B., Bilham L., Robben J.,
RA   van der Schueren J., Grymonprez B., Chuang Y.-J., Vandenbussche F.,
RA   Braeken M., Weltjens I., Voet M., Bastiaens I., Aert R., Defoor E.,
RA   Weitzenegger T., Bothe G., Ramsperger U., Hilbert H., Braun M.,
RA   Holzer E., Brandt A., Peters S., van Staveren M., Dirkse W.,
RA   Mooijman P., Klein Lankhorst R., Rose M., Hauf J., Koetter P.,
RA   Berneiser S., Hempel S., Feldpausch M., Lamberth S., Van den Daele H.,
RA   De Keyser A., Buysshaert C., Gielen J., Villarroel R., De Clercq R.,
RA   van Montagu M., Rogers J., Cronin A., Quail M.A., Bray-Allen S.,
RA   Clark L., Doggett J., Hall S., Kay M., Lennard N., McLay K., Mayes R.,
RA   Pettett A., Rajandream M.A., Lyne M., Benes V., Rechmann S.,
RA   Borkova D., Bloecker H., Scharfe M., Grimm M., Loehnert T.-H.,
RA   Dose S., de Haan M., Maarse A.C., Schaefer M., Mueller-Auer S.,
RA   Gabel C., Fuchs M., Fartmann B., Granderath K., Dauner D., Herzl A.,
RA   Neumann S., Argiriou A., Vitale D., Liguori R., Piravandi E.,
RA   Massenet O., Quigley F., Clabauld G., Muendlein A., Felber R.,
RA   Schnabl S., Hiller R., Schmidt W., Lecharny A., Aubourg S.,
RA   Chefdor F., Cooke R., Berger C., Monfort A., Casacuberta E.,
RA   Gibbons T., Weber N., Vandenbol M., Bargues M., Terol J., Torres A.,
RA   Perez-Perez A., Purnelle B., Bent E., Johnson S., Tacon D., Jesse T.,
RA   Heijnen L., Schwarz S., Scholler P., Heber S., Francs P., Bielke C.,
RA   Frishman D., Haase D., Lemcke K., Mewes H.-W., Stocker S.,
RA   Zaccaria P., Bevan M., Wilson R.K., de la Bastide M., Habermann K.,
RA   Parnell L., Dedhia N., Gnoj L., Schutz K., Huang E., Spiegel L.,
RA   Sekhon M., Murray J., Sheet P., Cordes M., Abu-Threideh J.,
RA   Stoneking T., Kalicki J., Graves T., Harmon G., Edwards J.,
RA   Latreille P., Courtney L., Cloud J., Abbott A., Scott K., Johnson D.,
RA   Minx P., Bentley D., Fulton B., Miller N., Greco T., Kemp K.,
RA   Kramer J., Fulton L., Mardis E., Dante M., Pepin K., Hillier L.W.,
RA   Nelson J., Spieth J., Ryan E., Andrews S., Geisel C., Layman D.,
RA   Du H., Ali J., Berghoff A., Jones K., Drone K., Cotton M., Joshu C.,
RA   Antonoiu B., Zidanic M., Strong C., Sun H., Lamar B., Yordan C.,
RA   Ma P., Zhong J., Preston R., Vil D., Shekher M., Matero A., Shah R.,
RA   Swaby I.K., O'Shaughnessy A., Rodriguez M., Hoffman J., Till S.,
RA   Granat S., Shohdy N., Hasegawa A., Hameed A., Lodhi M., Johnson A.,
RA   Chen E., Marra M.A., Martienssen R., McCombie W.R.;
RT   "Sequence and analysis of chromosome 4 of the plant Arabidopsis
RT   thaliana.";
RL   Nature 402:769-777(1999).
RN   [3]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   STRAIN=cv. Columbia;
RA   Cheuk R.F., Chen H., Kim C.J., Shinn P., Ecker J.R.;
RT   "Arabidopsis ORF clones.";
RL   Submitted (JUN-2004) to the EMBL/GenBank/DDBJ databases.
RN   [4]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
RC   STRAIN=cv. Columbia;
RA   Totoki Y., Seki M., Ishida J., Nakajima M., Enju A., Kamiya A.,
RA   Narusaka M., Shin-i T., Nakagawa M., Sakamoto N., Oishi K., Kohara Y.,
RA   Kobayashi M., Toyoda A., Sakaki Y., Sakurai T., Iida K., Akiyama K.,
RA   Satou M., Toyoda T., Konagaya A., Carninci P., Kawai J.,
RA   Hayashizaki Y., Shinozaki K.;
RT   "Large-scale analysis of RIKEN Arabidopsis full-length (RAFL) cDNAs.";
RL   Submitted (SEP-2004) to the EMBL/GenBank/DDBJ databases.
RN   [5]
RP   FUNCTION, AND SUBCELLULAR LOCATION.
RX   PubMed=17092311; DOI=10.1111/j.1365-313X.2006.02923.x;
RA   Busi M.V., Maliandi M.V., Valdez H., Clemente M., Zabaleta E.J.,
RA   Araya A., Gomez-Casati D.F.;
RT   "Deficiency of Arabidopsis thaliana frataxin alters activity of
RT   mitochondrial Fe-S proteins and induces oxidative stress.";
RL   Plant J. 48:873-882(2006).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral.
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity).
CC   -!- SUBCELLULAR LOCATION: Mitochondrion.
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -!- SEQUENCE CAUTION:
CC       Sequence=AAD14452.1; Type=Erroneous gene model prediction;
CC       Sequence=CAB77809.1; Type=Erroneous gene model prediction;
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AY649366; AAU11485.1; -; mRNA.
DR   EMBL; AC005275; AAD14452.1; ALT_SEQ; Genomic_DNA.
DR   EMBL; AL161496; CAB77809.1; ALT_SEQ; Genomic_DNA.
DR   EMBL; BT014964; AAT47815.1; -; mRNA.
DR   EMBL; AK176448; BAD44211.1; -; mRNA.
DR   EMBL; AK176831; BAD44594.1; -; mRNA.
DR   IPI; IPI00527007; -.
DR   PIR; B85041; B85041.
DR   RefSeq; NP_192233.2; -.
DR   UniGene; At.50317; -.
DR   ProteinModelPortal; Q9ZR07; -.
DR   SMR; Q9ZR07; 76-187.
DR   STRING; Q9ZR07; -.
DR   PRIDE; Q9ZR07; -.
DR   EnsemblPlants; AT4G03240.1-TAIR; AT4G03240.1-P; AT4G03240-TAIR-G.
DR   GeneID; 828013; -.
DR   GenomeReviews; CT486007_GR; AT4G03240.
DR   KEGG; ath:AT4G03240; -.
DR   NMPDR; fig|3702.1.peg.18153; -.
DR   TAIR; At4g03240; -.
DR   eggNOG; KOG3413; -.
DR   HOGENOM; HBG591377; -.
DR   InParanoid; Q9ZR07; -.
DR   OMA; DANAWIY; -.
DR   PhylomeDB; Q9ZR07; -.
DR   Genevestigator; Q9ZR07; -.
DR   GermOnline; AT4G03240; Arabidopsis thaliana.
DR   GO; GO:0005739; C:mitochondrion; IEA:UniProtKB-SubCell.
DR   GO; GO:0009060; P:aerobic respiration; IMP:TAIR.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   GO; GO:0042542; P:response to hydrogen peroxide; IMP:TAIR.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
KW   Complete proteome; Ion transport; Iron; Iron transport; Mitochondrion;
KW   Transit peptide; Transport.
FT   TRANSIT       1      ?       Mitochondrion (Potential).
FT   CHAIN         ?    187       Frataxin, mitochondrial.
FT                                /FTId=PRO_0000193926.
SQ   SEQUENCE   187 AA;  21430 MW;  FAFA6A8AF7FD7534 CRC64;
     MATASRFLLR KLPRFLKLSP TLLRSNGVRV SSNLIQDSIE PLDSFWRIGS RIRHDSLTTR
     SFSSQGPASV DYSSVLQEEE FHKLANFTIN HLLEKIEDYG DNVQIDGFDI DYGNEVLTLK
     LGSLGTYVLN KQTPNRQIWM SSPVSGPSRF DWDRDANAWI YRRTEAKLHK LLEEELENLC
     GEPIQLS
//


ID   Q7S0W3_NEUCR            Unreviewed;       206 AA.
AC   Q7S0W3;
DT   15-DEC-2003, integrated into UniProtKB/TrEMBL.
DT   15-DEC-2003, sequence version 1.
DT   15-JUN-2010, entry version 35.
DE   SubName: Full=Putative uncharacterized protein;
GN   ORFNames=NCU09754, NCU09754.1;
OS   Neurospora crassa.
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta; Pezizomycotina;
OC   Leotiomyceta; Sordariomyceta; Sordariomycetes; Sordariomycetidae;
OC   Sordariales; Sordariaceae; Neurospora.
OX   NCBI_TaxID=5141;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC 24698 / 74-OR23-1A / CBS 708.71 / DSM 1257 / FGSC 987;
RX   MEDLINE=22598136; PubMed=12712197; DOI=10.1038/nature01554;
RA   Galagan J.E., Calvo S.E., Borkovich K.A., Selker E.U., Read N.D.,
RA   Jaffe D.B., FitzHugh W., Ma L.-J., Smirnov S., Purcell S., Rehman B.,
RA   Elkins T., Engels R., Wang S., Nielsen C.B., Butler J., Endrizzi M.,
RA   Qui D., Ianakiev P., Bell-Pedersen D., Nelson M.A.,
RA   Werner-Washburne M., Selitrennikoff C.P., Kinsey J.A., Braun E.L.,
RA   Zelter A., Schulte U., Kothe G.O., Jedd G., Mewes H.-W., Staben C.,
RA   Marcotte E., Greenberg D., Roy A., Foley K., Naylor J.,
RA   Stange-Thomann N., Barrett R., Gnerre S., Kamal M., Kamvysselis M.,
RA   Mauceli E.W., Bielke C., Rudd S., Frishman D., Krystofova S.,
RA   Rasmussen C., Metzenberg R.L., Perkins D.D., Kroken S., Cogoni C.,
RA   Macino G., Catcheside D.E.A., Li W., Pratt R.J., Osmani S.A.,
RA   DeSouza C.P.C., Glass N.L., Orbach M.J., Berglund J.A., Voelker R.,
RA   Yarden O., Plamann M., Seiler S., Dunlap J.C., Radford A., Aramayo R.,
RA   Natvig D.O., Alex L.A., Mannhaupt G., Ebbole D.J., Freitag M.,
RA   Paulsen I., Sachs M.S., Lander E.S., Nusbaum C., Birren B.W.;
RT   "The genome sequence of the filamentous fungus Neurospora crassa.";
RL   Nature 422:859-868(2003).
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AABX02000087; EAA28958.1; -; Genomic_DNA.
DR   RefSeq; XP_958194.1; -.
DR   HSSP; Q16595; 1EKG.
DR   SMR; Q7S0W3; 76-195.
DR   STRING; Q7S0W3; -.
DR   EnsemblFungi; EFNCRT00000009614; EFNCRP00000009596; EFNCRG00000009595.
DR   GeneID; 3874341; -.
DR   KEGG; ncr:NCU09754; -.
DR   NMPDR; fig|5141.1.peg.8337; -.
DR   eggNOG; fuNOG11011; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q7S0W3; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:InterPro.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   206 AA;  22947 MW;  217B95076AAEA68F CRC64;
     MSRAIVTKVA RATLRSLQGT SRNTRITSTP FAAAALLPRA TVPRFYSTAG PNGNMITPDK
     QPVQPKEEAA PTVVRAATEL TDDEYHKLAD QYMDRLVTHL EELQDEREDI DVEYSAGVLT
     VSFDDGIGTY VINKQPPNKQ IWLSSPKSGP KRYDYVALGD GQNEKEGTAK GEWVYLRDNS
     TINQLFRDEL QIDLSMPVGH YGEEEA
//


ID   Q5K8D9_CRYNE            Unreviewed;       187 AA.
AC   Q5K8D9;
DT   15-FEB-2005, integrated into UniProtKB/TrEMBL.
DT   15-FEB-2005, sequence version 1.
DT   02-MAR-2010, entry version 28.
DE   SubName: Full=Putative uncharacterized protein;
GN   OrderedLocusNames=CNL06050;
OS   Cryptococcus neoformans (Filobasidiella neoformans).
OC   Eukaryota; Fungi; Dikarya; Basidiomycota; Agaricomycotina;
OC   Tremellomycetes; Tremellales; Tremellaceae; Filobasidiella;
OC   Filobasidiella/Cryptococcus neoformans species complex.
OX   NCBI_TaxID=5207;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=JEC21;
RX   PubMed=15653466; DOI=10.1126/science.1103773;
RA   Loftus B.J., Fung E., Roncaglia P., Rowley D., Amedeo P., Bruno D.,
RA   Vamathevan J., Miranda M., Anderson I.J., Fraser J.A., Allen J.E.,
RA   Bosdet I.E., Brent M.R., Chiu R., Doering T.L., Donlin M.J.,
RA   D'Souza C.A., Fox D.S., Grinberg V., Fu J., Fukushima M., Haas B.J.,
RA   Huang J.C., Janbon G., Jones S.J.M., Koo H.L., Krzywinski M.I.,
RA   Kwon-Chung K.J., Lengeler K.B., Maiti R., Marra M.A., Marra R.E.,
RA   Mathewson C.A., Mitchell T.G., Pertea M., Riggs F.R., Salzberg S.L.,
RA   Schein J.E., Shvartsbeyn A., Shin H., Shumway M., Specht C.A.,
RA   Suh B.B., Tenney A., Utterback T.R., Wickes B.L., Wortman J.R.,
RA   Wye N.H., Kronstad J.W., Lodge J.K., Heitman J., Davis R.W.,
RA   Fraser C.M., Hyman R.W.;
RT   "The genome of the basidiomycetous yeast and human pathogen
RT   Cryptococcus neoformans.";
RL   Science 307:1321-1324(2005).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AE017352; AAW46617.1; -; Genomic_DNA.
DR   RefSeq; XP_568134.1; -.
DR   SMR; Q5K8D9; 61-171.
DR   STRING; Q5K8D9; -.
DR   GeneID; 3254773; -.
DR   GenomeReviews; AE017352_GR; CNL06050.
DR   KEGG; cne:CNL06050; -.
DR   HOGENOM; HBG068760; -.
DR   OMA; HITTHHE; -.
DR   OrthoDB; EOG98963R; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   187 AA;  20657 MW;  670D1EE548005CD6 CRC64;
     MLAAKNCLNK SLRALRPLTE RSASPVIARS ARASPLLRSR ATSARTFVTS LPRQSQPLPP
     PPTSTLSHDE YEHVSERDME TLNESLEIFC EDFGNGNWEI EYSSGVLNLT LPPYGTYVLN
     KQPPNLQIWM SSPVSGPSRF EYINGSWVHH RKEGVKLGEL LSGELKEILE KSGNEAAAGV
     WEGVGLP
//


ID   Q55MD4_CRYNE            Unreviewed;       187 AA.
AC   Q55MD4;
DT   24-MAY-2005, integrated into UniProtKB/TrEMBL.
DT   24-MAY-2005, sequence version 1.
DT   02-MAR-2010, entry version 24.
DE   SubName: Full=Putative uncharacterized protein;
GN   OrderedLocusNames=CNBI0780;
OS   Cryptococcus neoformans (Filobasidiella neoformans).
OC   Eukaryota; Fungi; Dikarya; Basidiomycota; Agaricomycotina;
OC   Tremellomycetes; Tremellales; Tremellaceae; Filobasidiella;
OC   Filobasidiella/Cryptococcus neoformans species complex.
OX   NCBI_TaxID=5207;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=B-3501A;
RA   Fung E., Hyman R.W., Rowley D., Bruno D., Miranda M., Fukushima M.,
RA   Wickes B.L., Fu J., Davis R.W.;
RT   "Cryptococcus neoformans serotype D sequencing.";
RL   Submitted (JUL-2004) to the EMBL/GenBank/DDBJ databases.
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AAEY01000044; EAL18817.1; -; Genomic_DNA.
DR   RefSeq; XP_773464.1; -.
DR   SMR; Q55MD4; 61-171.
DR   STRING; Q55MD4; -.
DR   GeneID; 4938031; -.
DR   GenomeReviews; CM000048_GR; CNBI0780.
DR   KEGG; cnb:CNBI0780; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG068760; -.
DR   PhylomeDB; Q55MD4; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   187 AA;  20643 MW;  670D1EE54801ECD6 CRC64;
     MLAAKNCLNK SLRALRPLTE RSASPVIARS ARASPLLRSR ATSARTFVTS LPRQSQPLPP
     PPTSTLSHDE YEHVSERDME TLNESLEIFC EDFGNGNWEI EYSSGVLNLT LPPYGTYVLN
     KQPPNLQIWM SSPVSGPSRF EYINGSWVHH RKEGVKLGEL LSGELKEILE KSGNEAAAGV
     WDGVGLP
//


ID   Q6TXW0_CRYNE            Unreviewed;       173 AA.
AC   Q6TXW0;
DT   05-JUL-2004, integrated into UniProtKB/TrEMBL.
DT   05-JUL-2004, sequence version 1.
DT   02-MAR-2010, entry version 22.
DE   SubName: Full=Frataxin-like protein;
GN   Name=FRR4;
OS   Cryptococcus neoformans var. neoformans.
OC   Eukaryota; Fungi; Dikarya; Basidiomycota; Agaricomycotina;
OC   Tremellomycetes; Tremellales; Tremellaceae; Filobasidiella;
OC   Filobasidiella/Cryptococcus neoformans species complex.
OX   NCBI_TaxID=40410;
RN   [1]
RP   NUCLEOTIDE SEQUENCE OF 33-33.
RC   STRAIN=ATCC MYA-422;
RX   MEDLINE=99242820; PubMed=10225895;
RA   Nyhus K.J., Jacobson E.S.;
RT   "Genetic and physiologic characterization of ferric/cupric reductase
RT   constitutive mutants of Cryptococcus neoformans.";
RL   Infect. Immun. 67:2357-2365(1999).
RN   [2]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=ATCC MYA-422;
RX   PubMed=15750726; DOI=10.1007/s11046-004-2223-8;
RA   Jacobson E.S., Troy A.J., Nyhus K.J.;
RT   "Mitochondrial functioning of constitutive iron uptake mutations in
RT   Cryptococcus neoformans.";
RL   Mycopathologia 159:1-6(2005).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AY383088; AAQ88214.1; -; Genomic_DNA.
DR   SMR; Q6TXW0; 50-157.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   173 AA;  19095 MW;  983AB8C4BA1DEBA2 CRC64;
     MLAAKNCLNK SLRALRPLTE RSASPVIARS ARASPLLRSR ATSARTPPTS TLSHDEYEHV
     SERDMETLNE SLEIFCEDFG NGNWEIEYSS GVLNLTLPPY GTYVLNKQPP NLQIWMSSPV
     SGPSRFEYIN GSWVHHRKEG VKLGELLSGE LKEILEKSGN EAAAGVWDGV GLP
//


ID   Q6C5T7_YARLI            Unreviewed;       176 AA.
AC   Q6C5T7;
DT   16-AUG-2004, integrated into UniProtKB/TrEMBL.
DT   16-AUG-2004, sequence version 1.
DT   23-MAR-2010, entry version 33.
DE   SubName: Full=YALI0E15268p;
GN   OrderedLocusNames=YALI0E15268g;
OS   Yarrowia lipolytica (Candida lipolytica).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta;
OC   Saccharomycotina; Saccharomycetes; Saccharomycetales; Dipodascaceae;
OC   Yarrowia.
OX   NCBI_TaxID=4952;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=CLIB 122 / E 150;
RX   PubMed=15229592; DOI=10.1038/nature02579;
RA   Dujon B., Sherman D., Fischer G., Durrens P., Casaregola S.,
RA   Lafontaine I., de Montigny J., Marck C., Neuveglise C., Talla E.,
RA   Goffard N., Frangeul L., Aigle M., Anthouard V., Babour A., Barbe V.,
RA   Barnay S., Blanchin S., Beckerich J.-M., Beyne E., Bleykasten C.,
RA   Boisrame A., Boyer J., Cattolico L., Confanioleri F., de Daruvar A.,
RA   Despons L., Fabre E., Fairhead C., Ferry-Dumazet H., Groppi A.,
RA   Hantraye F., Hennequin C., Jauniaux N., Joyet P., Kachouri R.,
RA   Kerrest A., Koszul R., Lemaire M., Lesur I., Ma L., Muller H.,
RA   Nicaud J.-M., Nikolski M., Oztas S., Ozier-Kalogeropoulos O.,
RA   Pellenz S., Potier S., Richard G.-F., Straub M.-L., Suleau A.,
RA   Swennen D., Tekaia F., Wesolowski-Louvel M., Westhof E., Wirth B.,
RA   Zeniou-Meyer M., Zivanovic Y., Bolotin-Fukuhara M., Thierry A.,
RA   Bouchier C., Caudron B., Scarpelli C., Gaillardin C., Weissenbach J.,
RA   Wincker P., Souciet J.-L.;
RT   "Genome evolution in yeasts.";
RL   Nature 430:35-44(2004).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CR382131; CAG79568.1; -; Genomic_DNA.
DR   RefSeq; XP_503975.1; -.
DR   SMR; Q6C5T7; 60-168.
DR   STRING; Q6C5T7; -.
DR   GeneID; 2911992; -.
DR   GenomeReviews; CR382131_GR; YALI0E15268g.
DR   KEGG; yli:YALI0E15268g; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG396998; -.
DR   OMA; HITTHHE; -.
DR   OrthoDB; EOG98963R; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   176 AA;  19817 MW;  C204B82A11550749 CRC64;
     MSLIRSLRTV PRIALATRVA TGVASLPLRR PLTTGVRRAT RTITLPHITT HHETLRLYSL
     QATELELEDY HIQADEYLES ILIAYEEYAE EVDSNELDVD LAQGVMSLEI PGAGSYVINK
     QPPNKQIWLS SPISGPKRYD YVDGEWVYLR DGTTLTELLE TETSEAFAST GKKFHL
//


ID   Q6BUH5_DEBHA            Unreviewed;       168 AA.
AC   Q6BUH5;
DT   16-AUG-2004, integrated into UniProtKB/TrEMBL.
DT   16-AUG-2004, sequence version 1.
DT   13-JUL-2010, entry version 30.
DE   SubName: Full=DEHA2C10604p;
GN   OrderedLocusNames=DEHA2C10604g;
OS   Debaryomyces hansenii (Yeast) (Torulaspora hansenii).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta;
OC   Saccharomycotina; Saccharomycetes; Saccharomycetales;
OC   Debaryomycetaceae; Debaryomyces.
OX   NCBI_TaxID=4959;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC 36239 / CBS 767 / IFO 0083 / IGC 2968 / JCM 1990;
RX   PubMed=15229592; DOI=10.1038/nature02579;
RA   Dujon B., Sherman D., Fischer G., Durrens P., Casaregola S.,
RA   Lafontaine I., de Montigny J., Marck C., Neuveglise C., Talla E.,
RA   Goffard N., Frangeul L., Aigle M., Anthouard V., Babour A., Barbe V.,
RA   Barnay S., Blanchin S., Beckerich J.-M., Beyne E., Bleykasten C.,
RA   Boisrame A., Boyer J., Cattolico L., Confanioleri F., de Daruvar A.,
RA   Despons L., Fabre E., Fairhead C., Ferry-Dumazet H., Groppi A.,
RA   Hantraye F., Hennequin C., Jauniaux N., Joyet P., Kachouri R.,
RA   Kerrest A., Koszul R., Lemaire M., Lesur I., Ma L., Muller H.,
RA   Nicaud J.-M., Nikolski M., Oztas S., Ozier-Kalogeropoulos O.,
RA   Pellenz S., Potier S., Richard G.-F., Straub M.-L., Suleau A.,
RA   Swennen D., Tekaia F., Wesolowski-Louvel M., Westhof E., Wirth B.,
RA   Zeniou-Meyer M., Zivanovic Y., Bolotin-Fukuhara M., Thierry A.,
RA   Bouchier C., Caudron B., Scarpelli C., Gaillardin C., Weissenbach J.,
RA   Wincker P., Souciet J.-L.;
RT   "Genome evolution in yeasts.";
RL   Nature 430:35-44(2004).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CR382135; CAG86215.1; -; Genomic_DNA.
DR   SMR; Q6BUH5; 51-158.
DR   STRING; Q6BUH5; -.
DR   GenomeReviews; CR382135_GR; DEHA2C10604g.
DR   KEGG; dha:DEHA0C11616g; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG396998; -.
DR   OMA; KRYDLIG; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q6BUH5; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   168 AA;  18847 MW;  485E164A538F6D51 CRC64;
     MFRQVLKVSH RRVVPSIART TRLVPVLRRP SPNLCISTRS YAFSTEGEAF DDKVDSLSLG
     QYNNISNEYL ETLADELEML SEDYPQIDCE LTQGVMTLSV PPNGTYVINK QPPNKQIWLS
     SPISGPKRYD LIGGKWITLR DGSALTTLLE EEISVALEGA FHFEGIEN
//


ID   Q6CNZ1_KLULA            Unreviewed;       190 AA.
AC   Q6CNZ1;
DT   16-AUG-2004, integrated into UniProtKB/TrEMBL.
DT   16-AUG-2004, sequence version 1.
DT   23-MAR-2010, entry version 31.
DE   SubName: Full=KLLA0E08845p;
GN   OrderedLocusNames=KLLA0E08845g;
OS   Kluyveromyces lactis (Yeast) (Candida sphaerica).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta;
OC   Saccharomycotina; Saccharomycetes; Saccharomycetales;
OC   Saccharomycetaceae; Kluyveromyces.
OX   NCBI_TaxID=28985;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC 8585 / CBS 2359 / DSM 70799 / NRRL Y-1140 / WM37;
RX   PubMed=15229592; DOI=10.1038/nature02579;
RA   Dujon B., Sherman D., Fischer G., Durrens P., Casaregola S.,
RA   Lafontaine I., de Montigny J., Marck C., Neuveglise C., Talla E.,
RA   Goffard N., Frangeul L., Aigle M., Anthouard V., Babour A., Barbe V.,
RA   Barnay S., Blanchin S., Beckerich J.-M., Beyne E., Bleykasten C.,
RA   Boisrame A., Boyer J., Cattolico L., Confanioleri F., de Daruvar A.,
RA   Despons L., Fabre E., Fairhead C., Ferry-Dumazet H., Groppi A.,
RA   Hantraye F., Hennequin C., Jauniaux N., Joyet P., Kachouri R.,
RA   Kerrest A., Koszul R., Lemaire M., Lesur I., Ma L., Muller H.,
RA   Nicaud J.-M., Nikolski M., Oztas S., Ozier-Kalogeropoulos O.,
RA   Pellenz S., Potier S., Richard G.-F., Straub M.-L., Suleau A.,
RA   Swennen D., Tekaia F., Wesolowski-Louvel M., Westhof E., Wirth B.,
RA   Zeniou-Meyer M., Zivanovic Y., Bolotin-Fukuhara M., Thierry A.,
RA   Bouchier C., Caudron B., Scarpelli C., Gaillardin C., Weissenbach J.,
RA   Wincker P., Souciet J.-L.;
RT   "Genome evolution in yeasts.";
RL   Nature 430:35-44(2004).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CR382125; CAG99435.1; -; Genomic_DNA.
DR   RefSeq; XP_454348.1; -.
DR   SMR; Q6CNZ1; 63-177.
DR   STRING; Q6CNZ1; -.
DR   GeneID; 2894481; -.
DR   GenomeReviews; CR382125_GR; KLLA0E08845g.
DR   KEGG; kla:KLLA0E08811g; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG396998; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q6CNZ1; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:InterPro.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   190 AA;  21470 MW;  6B318122DE407B1D CRC64;
     MLVKNSSRVI RSVISRRSIV TKAIPSIGLA RTAPTRAPVL SKLGILNQHN LPFVTVQRMH
     NSIAASTDGK TIPEEILDMP IEVYHEISDE FMDSLLDQLE ILCDYHPEVV QDVEMSQGVM
     SIEVPSVGTY VINKQPPNKQ IWLASPVSGP NRFDYYQKEW VSLRDGTKLL DILNKELSDR
     LEGDEIDLHY
//


ID   FRDA_SCHPO              Reviewed;         158 AA.
AC   O74831;
DT   15-JUL-1999, integrated into UniProtKB/Swiss-Prot.
DT   01-NOV-1998, sequence version 1.
DT   10-AUG-2010, entry version 61.
DE   RecName: Full=Frataxin homolog, mitochondrial;
DE   Flags: Precursor;
GN   ORFNames=SPCC1183.03c;
OS   Schizosaccharomyces pombe (Fission yeast).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Taphrinomycotina;
OC   Schizosaccharomycetes; Schizosaccharomycetales;
OC   Schizosaccharomycetaceae; Schizosaccharomyces.
OX   NCBI_TaxID=4896;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC 38366 / 972;
RX   MEDLINE=21848401; PubMed=11859360; DOI=10.1038/nature724;
RA   Wood V., Gwilliam R., Rajandream M.A., Lyne M.H., Lyne R., Stewart A.,
RA   Sgouros J.G., Peat N., Hayles J., Baker S.G., Basham D., Bowman S.,
RA   Brooks K., Brown D., Brown S., Chillingworth T., Churcher C.M.,
RA   Collins M., Connor R., Cronin A., Davis P., Feltwell T., Fraser A.,
RA   Gentles S., Goble A., Hamlin N., Harris D.E., Hidalgo J., Hodgson G.,
RA   Holroyd S., Hornsby T., Howarth S., Huckle E.J., Hunt S., Jagels K.,
RA   James K.D., Jones L., Jones M., Leather S., McDonald S., McLean J.,
RA   Mooney P., Moule S., Mungall K.L., Murphy L.D., Niblett D., Odell C.,
RA   Oliver K., O'Neil S., Pearson D., Quail M.A., Rabbinowitsch E.,
RA   Rutherford K.M., Rutter S., Saunders D., Seeger K., Sharp S.,
RA   Skelton J., Simmonds M.N., Squares R., Squares S., Stevens K.,
RA   Taylor K., Taylor R.G., Tivey A., Walsh S.V., Warren T., Whitehead S.,
RA   Woodward J.R., Volckaert G., Aert R., Robben J., Grymonprez B.,
RA   Weltjens I., Vanstreels E., Rieger M., Schaefer M., Mueller-Auer S.,
RA   Gabel C., Fuchs M., Duesterhoeft A., Fritzc C., Holzer E., Moestl D.,
RA   Hilbert H., Borzym K., Langer I., Beck A., Lehrach H., Reinhardt R.,
RA   Pohl T.M., Eger P., Zimmermann W., Wedler H., Wambutt R., Purnelle B.,
RA   Goffeau A., Cadieu E., Dreano S., Gloux S., Lelaure V., Mottier S.,
RA   Galibert F., Aves S.J., Xiang Z., Hunt C., Moore K., Hurst S.M.,
RA   Lucas M., Rochet M., Gaillardin C., Tallada V.A., Garzon A., Thode G.,
RA   Daga R.R., Cruzado L., Jimenez J., Sanchez M., del Rey F., Benito J.,
RA   Dominguez A., Revuelta J.L., Moreno S., Armstrong J., Forsburg S.L.,
RA   Cerutti L., Lowe T., McCombie W.R., Paulsen I., Potashkin J.,
RA   Shpakovski G.V., Ussery D., Barrell B.G., Nurse P.;
RT   "The genome sequence of Schizosaccharomyces pombe.";
RL   Nature 415:871-880(2002).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral
CC       (By similarity).
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity).
CC   -!- SUBCELLULAR LOCATION: Mitochondrion (By similarity).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CU329672; CAA21083.1; -; Genomic_DNA.
DR   PIR; T40843; T40843.
DR   RefSeq; NP_587886.1; -.
DR   ProteinModelPortal; O74831; -.
DR   SMR; O74831; 42-154.
DR   STRING; O74831; -.
DR   EnsemblFungi; SPCC1183.03c-1; SPCC1183.03c-1; SPCC1183.03c.
DR   GeneID; 2539143; -.
DR   KEGG; spo:SPCC1183.03c; -.
DR   NMPDR; fig|4896.1.peg.224; -.
DR   GeneDB_Spombe; SPCC1183.03c; -.
DR   eggNOG; fuNOG11011; -.
DR   OMA; DERDHAR; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; O74831; -.
DR   BioCyc; SPOM-XXX-01:SPOM-XXX-01-002230-MONOMER; -.
DR   ArrayExpress; O74831; -.
DR   GO; GO:0005739; C:mitochondrion; IDA:GeneDB_Spombe.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   2: Evidence at transcript level;
KW   Complete proteome; Ion transport; Iron; Iron transport; Mitochondrion;
KW   Transit peptide; Transport.
FT   TRANSIT       1      ?       Mitochondrion.
FT   CHAIN         ?    158       Frataxin homolog, mitochondrial.
FT                                /FTId=PRO_0000010134.
SQ   SEQUENCE   158 AA;  18387 MW;  F5018ECAB617573E CRC64;
     MQSLRAAFRR RTPIFLKPYE FSTNVFGLRC RYYSQVRHNG ALTDLEYHRV ADDTLDVLND
     TFEDLLEEVG KKDYDIQYAN GVITLMLGEK GTYVINKQPP AHQIWLSSPV SGPKHYEYSL
     KSKTWCSTRD EGTLLGILSS EFSKWFSRPI EFKKSEDF
//


ID   FRDA_YEAST              Reviewed;         174 AA.
AC   Q07540;
DT   15-JUL-1999, integrated into UniProtKB/Swiss-Prot.
DT   01-NOV-1996, sequence version 1.
DT   10-AUG-2010, entry version 100.
DE   RecName: Full=Frataxin homolog, mitochondrial;
DE   Contains:
DE     RecName: Full=Frataxin homolog intermediate form;
DE   Flags: Precursor;
GN   Name=YFH1; OrderedLocusNames=YDL120W;
OS   Saccharomyces cerevisiae (Baker's yeast).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta;
OC   Saccharomycotina; Saccharomycetes; Saccharomycetales;
OC   Saccharomycetaceae; Saccharomyces.
OX   NCBI_TaxID=4932;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC 204508 / S288c;
RX   MEDLINE=97313263; PubMed=9169867;
RA   Jacq C., Alt-Moerbe J., Andre B., Arnold W., Bahr A., Ballesta J.P.G.,
RA   Bargues M., Baron L., Becker A., Biteau N., Bloecker H., Blugeon C.,
RA   Boskovic J., Brandt P., Brueckner M., Buitrago M.J., Coster F.,
RA   Delaveau T., del Rey F., Dujon B., Eide L.G., Garcia-Cantalejo J.M.,
RA   Goffeau A., Gomez-Peris A., Granotier C., Hanemann V., Hankeln T.,
RA   Hoheisel J.D., Jaeger W., Jimenez A., Jonniaux J.-L., Kraemer C.,
RA   Kuester H., Laamanen P., Legros Y., Louis E.J., Moeller-Rieker S.,
RA   Monnet A., Moro M., Mueller-Auer S., Nussbaumer B., Paricio N.,
RA   Paulin L., Perea J., Perez-Alonso M., Perez-Ortin J.E., Pohl T.M.,
RA   Prydz H., Purnelle B., Rasmussen S.W., Remacha M.A., Revuelta J.L.,
RA   Rieger M., Salom D., Saluz H.P., Saiz J.E., Saren A.-M., Schaefer M.,
RA   Scharfe M., Schmidt E.R., Schneider C., Scholler P., Schwarz S.,
RA   Soler-Mira A., Urrestarazu L.A., Verhasselt P., Vissers S., Voet M.,
RA   Volckaert G., Wagner G., Wambutt R., Wedler E., Wedler H., Woelfl S.,
RA   Harris D.E., Bowman S., Brown D., Churcher C.M., Connor R., Dedman K.,
RA   Gentles S., Hamlin N., Hunt S., Jones L., McDonald S., Murphy L.D.,
RA   Niblett D., Odell C., Oliver K., Rajandream M.A., Richards C.,
RA   Shore L., Walsh S.V., Barrell B.G., Dietrich F.S., Mulligan J.T.,
RA   Allen E., Araujo R., Aviles E., Berno A., Carpenter J., Chen E.,
RA   Cherry J.M., Chung E., Duncan M., Hunicke-Smith S., Hyman R.W.,
RA   Komp C., Lashkari D., Lew H., Lin D., Mosedale D., Nakahara K.,
RA   Namath A., Oefner P., Oh C., Petel F.X., Roberts D., Schramm S.,
RA   Schroeder M., Shogren T., Shroff N., Winant A., Yelton M.A.,
RA   Botstein D., Davis R.W., Johnston M., Andrews S., Brinkman R.,
RA   Cooper J., Ding H., Du Z., Favello A., Fulton L., Gattung S.,
RA   Greco T., Hallsworth K., Hawkins J., Hillier L.W., Jier M.,
RA   Johnson D., Johnston L., Kirsten J., Kucaba T., Langston Y.,
RA   Latreille P., Le T., Mardis E., Menezes S., Miller N., Nhan M.,
RA   Pauley A., Peluso D., Rifkin L., Riles L., Taich A., Trevaskis E.,
RA   Vignati D., Wilcox L., Wohldman P., Vaudin M., Wilson R.,
RA   Waterston R., Albermann K., Hani J., Heumann K., Kleine K.,
RA   Mewes H.-W., Zollner A., Zaccaria P.;
RT   "The nucleotide sequence of Saccharomyces cerevisiae chromosome IV.";
RL   Nature 387:75-78(1997).
RN   [2]
RP   NUCLEOTIDE SEQUENCE [GENOMIC DNA].
RC   STRAIN=ATCC 204508 / S288c;
RX   PubMed=17322287; DOI=10.1101/gr.6037607;
RA   Hu Y., Rolfs A., Bhullar B., Murthy T.V.S., Zhu C., Berger M.F.,
RA   Camargo A.A., Kelley F., McCarron S., Jepson D., Richardson A.,
RA   Raphael J., Moreira D., Taycher E., Zuo D., Mohr S., Kane M.F.,
RA   Williamson J., Simpson A.J.G., Bulyk M.L., Harlow E., Marsischky G.,
RA   Kolodner R.D., LaBaer J.;
RT   "Approaching a complete repository of sequence-verified protein-
RT   encoding clones for Saccharomyces cerevisiae.";
RL   Genome Res. 17:536-543(2007).
RN   [3]
RP   FUNCTION, AND SUBCELLULAR LOCATION.
RX   MEDLINE=97324273; PubMed=9180083; DOI=10.1126/science.276.5319.1709;
RA   Babcock M., de Silva D., Oaks R., Davis-Kaplan S., Jiralerspong S.,
RA   Montermini L., Pandolfo M., Kaplan J.;
RT   "Regulation of mitochondrial iron accumulation by Yfh1p, a putative
RT   homolog of frataxin.";
RL   Science 276:1709-1712(1997).
RN   [4]
RP   FUNCTION, AND SUBCELLULAR LOCATION.
RX   MEDLINE=99143100; PubMed=9988680; DOI=10.1074/jbc.274.8.4497;
RA   Radisky D.C., Babcock M.C., Kaplan J.;
RT   "The yeast frataxin homologue mediates mitochondrial iron efflux.
RT   Evidence for a mitochondrial iron cycle.";
RL   J. Biol. Chem. 274:4497-4499(1999).
RN   [5]
RP   PROCESSING.
RX   MEDLINE=20014717; PubMed=10545606; DOI=10.1093/hmg/8.12.2255;
RA   Gordon D.M., Shi Q., Dancis A., Pain D.;
RT   "Maturation of frataxin within mammalian and yeast mitochondria: one-
RT   step processing by matrix processing peptidase.";
RL   Hum. Mol. Genet. 8:2255-2262(1999).
RN   [6]
RP   PROCESSING.
RX   MEDLINE=99357816; PubMed=10428860; DOI=10.1074/jbc.274.32.22763;
RA   Branda S.S., Cavadini P., Adamec J., Kalousek F., Taroni F., Isaya G.;
RT   "Yeast and human frataxin are processed to mature form in two
RT   sequential steps by the mitochondrial processing peptidase.";
RL   J. Biol. Chem. 274:22763-22769(1999).
RN   [7]
RP   INTERACTION WITH ISU1.
RX   PubMed=10588895; DOI=10.1006/jmbi.1999.3294;
RA   Garland S.A., Hoff K., Vickery L.E., Culotta V.C.;
RT   "Saccharomyces cerevisiae ISU1 and ISU2: members of a well-conserved
RT   gene family for iron-sulfur cluster assembly.";
RL   J. Mol. Biol. 294:897-907(1999).
RN   [8]
RP   INTERACTION WITH ISU1.
RX   PubMed=12947415; DOI=10.1038/sj.embor.embor918;
RA   Gerber J., Muhlenhoff U., Lill R.;
RT   "An interaction between frataxin and Isu1/Nfs1 that is crucial for
RT   Fe/S cluster synthesis on Isu1.";
RL   EMBO Rep. 4:906-911(2003).
RN   [9]
RP   LEVEL OF PROTEIN EXPRESSION [LARGE SCALE ANALYSIS].
RX   MEDLINE=22923965; PubMed=14562106; DOI=10.1038/nature02046;
RA   Ghaemmaghami S., Huh W.-K., Bower K., Howson R.W., Belle A.,
RA   Dephoure N., O'Shea E.K., Weissman J.S.;
RT   "Global analysis of protein expression in yeast.";
RL   Nature 425:737-741(2003).
RN   [10]
RP   X-RAY CRYSTALLOGRAPHY (3.01 ANGSTROMS) OF 52-174 ALONE AND IN COMPLEX
RP   WITH IRON, ELECTRON MICROSCOPY OF MUTANT ALA-73, FUNCTION, AND
RP   SUBUNIT.
RX   PubMed=17027502; DOI=10.1016/j.str.2006.08.010;
RA   Karlberg T., Schagerlof U., Gakh O., Park S., Ryde U., Lindahl M.,
RA   Leath K., Garman E., Isaya G., Al-Karadaghi S.;
RT   "The structures of frataxin oligomers reveal the mechanism for the
RT   delivery and detoxification of iron.";
RL   Structure 14:1535-1546(2006).
RN   [11]
RP   ELECTRON MICROSCOPY OF MUTANT ALA-73 (13 ANGSTROMS), AND SUBUNIT.
RX   PubMed=18393441; DOI=10.1021/bi800052m;
RA   Schagerlof U., Elmlund H., Gakh O., Nordlund G., Hebert H.,
RA   Lindahl M., Isaya G., Al-Karadaghi S.;
RT   "Structural basis of the iron storage function of frataxin from
RT   single-particle reconstruction of the iron-loaded oligomer.";
RL   Biochemistry 47:4948-4954(2008).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral.
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers.
CC       Interacts with ISU1.
CC   -!- SUBCELLULAR LOCATION: Mitochondrion matrix.
CC   -!- PTM: Processed in two steps by mitochondrial processing peptidase
CC       (MPP). MPP first cleaves the precursor to intermediate form and
CC       subsequently converts the intermediate to mature size protein.
CC   -!- MISCELLANEOUS: Present with 1560 molecules/cell in log phase SD
CC       medium.
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; Z74168; CAA98688.1; -; Genomic_DNA.
DR   EMBL; AY558160; AAS56486.1; -; Genomic_DNA.
DR   PIR; S67663; S67663.
DR   PDB; 2FQL; X-ray; 3.01 A; A=52-174.
DR   PDB; 2GA5; NMR; -; A=53-174.
DR   PDBsum; 2FQL; -.
DR   PDBsum; 2GA5; -.
DR   ProteinModelPortal; Q07540; -.
DR   DIP; DIP-7485N; -.
DR   IntAct; Q07540; 8.
DR   MINT; MINT-4300743; -.
DR   STRING; Q07540; -.
DR   EnsemblFungi; YDL120W; YDL120W; YDL120W.
DR   GenomeReviews; Z71256_GR; YDL120W.
DR   KEGG; sce:YDL120W; -.
DR   NMPDR; fig|4932.3.peg.900; -.
DR   CYGD; YDL120w; -.
DR   SGD; S000002278; YFH1.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG396998; -.
DR   OMA; HIPEVEY; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q07540; -.
DR   NextBio; 968672; -.
DR   ArrayExpress; Q07540; -.
DR   Genevestigator; Q07540; -.
DR   GermOnline; YDL120W; Saccharomyces cerevisiae.
DR   GO; GO:0005759; C:mitochondrial matrix; IDA:SGD.
DR   GO; GO:0008198; F:ferrous iron binding; IDA:SGD.
DR   GO; GO:0004322; F:ferroxidase activity; IDA:SGD.
DR   GO; GO:0034986; F:iron chaperone activity; IDA:SGD.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IDA:SGD.
DR   GO; GO:0006749; P:glutathione metabolic process; IMP:SGD.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   GO; GO:0016226; P:iron-sulfur cluster assembly; IDA:SGD.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   1: Evidence at protein level;
KW   3D-structure; Complete proteome; Ion transport; Iron; Iron transport;
KW   Mitochondrion; Transit peptide; Transport.
FT   TRANSIT       1     21       Mitochondrion (Probable).
FT   CHAIN        22    174       Frataxin homolog intermediate form.
FT                                /FTId=PRO_0000010135.
FT   CHAIN        52    174       Frataxin homolog, mitochondrial.
FT                                /FTId=PRO_0000010136.
FT   TURN         63     67
FT   HELIX        76     89
FT   STRAND       92     94
FT   STRAND       96     99
FT   STRAND      101    103
FT   STRAND      106    113
FT   TURN        114    116
FT   STRAND      117    123
FT   STRAND      126    134
FT   TURN        135    137
FT   STRAND      138    147
FT   STRAND      149    151
FT   TURN        152    154
FT   HELIX       158    171
SQ   SEQUENCE   174 AA;  19490 MW;  AB1FF7478EF0E5D6 CRC64;
     MIKRSLASLV RVSSVMGRRY MIAAAGGERA RFCPAVTNKK NHTVNTFQKR FVESSTDGQV
     VPQEVLNLPL EKYHEEADDY LDHLLDSLEE LSEAHPDCIP DVELSHGVMT LEIPAFGTYV
     INKQPPNKQI WLASPLSGPN RFDLLNGEWV SLRNGTKLTD ILTEEVEKAI SKSQ
//


ID   Q4P635_USTMA            Unreviewed;       218 AA.
AC   Q4P635;
DT   19-JUL-2005, integrated into UniProtKB/TrEMBL.
DT   19-JUL-2005, sequence version 1.
DT   02-MAR-2010, entry version 21.
DE   SubName: Full=Putative uncharacterized protein;
GN   ORFNames=UM04428.1;
OS   Ustilago maydis (Smut fungus).
OC   Eukaryota; Fungi; Dikarya; Basidiomycota; Ustilaginomycotina;
OC   Ustilaginomycetes; Ustilaginales; Ustilaginaceae; Ustilago.
OX   NCBI_TaxID=5270;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=521;
RX   PubMed=17080091; DOI=10.1038/nature05248;
RA   Kaemper J., Kahmann R., Boelker M., Ma L.-J., Brefort T.,
RA   Saville B.J., Banuett F., Kronstad J.W., Gold S.E., Mueller O.,
RA   Perlin M.H., Woesten H.A.B., de Vries R., Ruiz-Herrera J.,
RA   Reynaga-Pena C.G., Snetselaar K., McCann M., Perez-Martin J.,
RA   Feldbruegge M., Basse C.W., Steinberg G., Ibeas J.I., Holloman W.,
RA   Guzman P., Farman M.L., Stajich J.E., Sentandreu R.,
RA   Gonzalez-Prieto J.M., Kennell J.C., Molina L., Schirawski J.,
RA   Mendoza-Mendoza A., Greilinger D., Muench K., Roessel N., Scherer M.,
RA   Vranes M., Ladendorf O., Vincon V., Fuchs U., Sandrock B., Meng S.,
RA   Ho E.C.H., Cahill M.J., Boyce K.J., Klose J., Klosterman S.J.,
RA   Deelstra H.J., Ortiz-Castellanos L., Li W., Sanchez-Alonso P.,
RA   Schreier P.H., Haeuser-Hahn I., Vaupel M., Koopmann E., Friedrich G.,
RA   Voss H., Schlueter T., Margolis J., Platt D., Swimmer C., Gnirke A.,
RA   Chen F., Vysotskaia V., Mannhaupt G., Gueldener U.,
RA   Muensterkoetter M., Haase D., Oesterheld M., Mewes H.-W.,
RA   Mauceli E.W., DeCaprio D., Wade C.M., Butler J., Young S.K.,
RA   Jaffe D.B., Calvo S.E., Nusbaum C., Galagan J.E., Birren B.W.;
RT   "Insights from the genome of the biotrophic fungal plant pathogen
RT   Ustilago maydis.";
RL   Nature 444:97-101(2006).
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AACP01000157; EAK85696.1; -; Genomic_DNA.
DR   RefSeq; XP_760575.1; -.
DR   SMR; Q4P635; 81-214.
DR   STRING; Q4P635; -.
DR   GeneID; 3632575; -.
DR   KEGG; uma:UM04428.1; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG396998; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q4P635; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:InterPro.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   218 AA;  24420 MW;  3F468EB61578441C CRC64;
     MKLPMMLRTT TQRGLRTTAT IRTISTRSAL TATIRKNVSA LPTKIIVTRA FSQRTPMVSS
     RWFSMSQKMA QPTAKYTASP LTDSQYHKLS NNVLDSLQET FETLLEEADV EALEEEARAK
     QQSATRAAPA SEWDIECASG VMNLRCGAHG TWVINKQPPN KQIWLSSPKS GPKRFDFDAD
     SNTWFCLKEG ETSTLDQLLQ DELSLVFGTE VQVLLEDE
//


ID   Q59PA3_CANAL            Unreviewed;       177 AA.
AC   Q59PA3;
DT   26-APR-2005, integrated into UniProtKB/TrEMBL.
DT   26-APR-2005, sequence version 1.
DT   23-MAR-2010, entry version 31.
DE   SubName: Full=Putative uncharacterized protein YFH1;
GN   Name=YFH1; ORFNames=CaO19.1413, CaO19.8989;
OS   Candida albicans (Yeast).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta;
OC   Saccharomycotina; Saccharomycetes; Saccharomycetales;
OC   mitosporic Saccharomycetales; Candida.
OX   NCBI_TaxID=5476;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=SC5314;
RX   PubMed=15123810; DOI=10.1073/pnas.0401648101;
RA   Jones T., Federspiel N.A., Chibana H., Dungan J., Kalman S.,
RA   Magee B.B., Newport G., Thorstenson Y.R., Agabian N., Magee P.T.,
RA   Davis R.W., Scherer S.;
RT   "The diploid genome sequence of Candida albicans.";
RL   Proc. Natl. Acad. Sci. U.S.A. 101:7329-7334(2004).
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AACQ01000194; EAK92294.1; -; Genomic_DNA.
DR   EMBL; AACQ01000193; EAK92316.1; -; Genomic_DNA.
DR   RefSeq; XP_711520.1; -.
DR   RefSeq; XP_711541.1; -.
DR   SMR; Q59PA3; 66-174.
DR   GeneID; 3646853; -.
DR   GeneID; 3646874; -.
DR   KEGG; cal:CaO19.1413; -.
DR   KEGG; cal:CaO19.8989; -.
DR   CGD; CAL0004482; YFH1.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q59PA3; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   177 AA;  19796 MW;  357807AEFADB03A2 CRC64;
     MFKRFALNSA KCLSKPACTR QLIYPQTRFI TKTLPTVASA LRPIGSIRAY SLSTEGEAID
     DKIDKLTDNE YAKVSNEYLE NLSDSLEELN EDFEQVDSEL SQGVLTLTLP PNGTYVINKQ
     PPNKQIWLSS PISGPKRYDL IGGKWVTLRD GSSLTSLLEE EISTAIGQEF KFETVEQ
//


ID   Q6FJK3_CANGA            Unreviewed;       176 AA.
AC   Q6FJK3;
DT   19-JUL-2004, integrated into UniProtKB/TrEMBL.
DT   19-JUL-2004, sequence version 1.
DT   23-MAR-2010, entry version 30.
DE   SubName: Full=Strain CBS138 chromosome M complete sequence;
GN   OrderedLocusNames=CAGL0M05643g;
OS   Candida glabrata (Yeast) (Torulopsis glabrata).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta;
OC   Saccharomycotina; Saccharomycetes; Saccharomycetales;
OC   Saccharomycetaceae; Nakaseomyces; mitosporic Nakaseomyces.
OX   NCBI_TaxID=5478;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC 2001 / CBS 138 / IFO 0622 / NRRL Y-65;
RX   PubMed=15229592; DOI=10.1038/nature02579;
RA   Dujon B., Sherman D., Fischer G., Durrens P., Casaregola S.,
RA   Lafontaine I., de Montigny J., Marck C., Neuveglise C., Talla E.,
RA   Goffard N., Frangeul L., Aigle M., Anthouard V., Babour A., Barbe V.,
RA   Barnay S., Blanchin S., Beckerich J.-M., Beyne E., Bleykasten C.,
RA   Boisrame A., Boyer J., Cattolico L., Confanioleri F., de Daruvar A.,
RA   Despons L., Fabre E., Fairhead C., Ferry-Dumazet H., Groppi A.,
RA   Hantraye F., Hennequin C., Jauniaux N., Joyet P., Kachouri R.,
RA   Kerrest A., Koszul R., Lemaire M., Lesur I., Ma L., Muller H.,
RA   Nicaud J.-M., Nikolski M., Oztas S., Ozier-Kalogeropoulos O.,
RA   Pellenz S., Potier S., Richard G.-F., Straub M.-L., Suleau A.,
RA   Swennen D., Tekaia F., Wesolowski-Louvel M., Westhof E., Wirth B.,
RA   Zeniou-Meyer M., Zivanovic Y., Bolotin-Fukuhara M., Thierry A.,
RA   Bouchier C., Caudron B., Scarpelli C., Gaillardin C., Weissenbach J.,
RA   Wincker P., Souciet J.-L.;
RT   "Genome evolution in yeasts.";
RL   Nature 430:35-44(2004).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CR380959; CAG62567.1; -; Genomic_DNA.
DR   RefSeq; XP_449591.1; -.
DR   SMR; Q6FJK3; 55-165.
DR   STRING; Q6FJK3; -.
DR   GeneID; 2891639; -.
DR   GenomeReviews; CR380959_GR; CAGL0M05643g.
DR   KEGG; cgr:CAGL0M05643g; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG396998; -.
DR   OMA; HIPEVEY; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q6FJK3; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   176 AA;  19827 MW;  938CB0FEC988514F CRC64;
     MIRNILRRSA ARVRIPVTSA TCASRLVMSI RLATSTRYYS NGNEGGPAMT NGVQIPKEVL
     ELPLQQYHQH SESFLEGLFD NLEELSENYP QHIPEVEYSH GVMSLTVAGV GTYVINKQPP
     NKQIWLSSPN SGPNRFDLYK GEWISLRNNE TLLSVLDKEL HDALPNDAEF KVESDQ
//


ID   Q57WY3_9TRYP            Unreviewed;       180 AA.
AC   Q57WY3;
DT   10-MAY-2005, integrated into UniProtKB/TrEMBL.
DT   10-MAY-2005, sequence version 1.
DT   02-MAR-2010, entry version 15.
DE   SubName: Full=Frataxin-like, mitochondrial, putative;
GN   ORFNames=Tb927.3.1000;
OS   Trypanosoma brucei.
OC   Eukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Trypanosoma.
OX   NCBI_TaxID=5691;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=GUTat10.1;
RA   Ghedin E., Blandin G., Bartholomeu D., Caler E., Haas B., Hannick L.,
RA   Shallom J., Hou L., Djikeng A., Feldblyum T., Hostetler J.,
RA   Johnson J., Jones K., Koo H.L., Larkin C., Pai G., Peterson J.,
RA   Khalak H.G., Salzberg S., Simpson A.J., Tallon L., Van Aken S.,
RA   Wanless D., White O., Wortman J., Fraser C.M., El-Sayed N.M.A.;
RL   Submitted (APR-2005) to the EMBL/GenBank/DDBJ databases.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AC159425; AAX69885.1; -; Genomic_DNA.
DR   SMR; Q57WY3; 61-175.
DR   STRING; Q57WY3; -.
DR   eggNOG; KOG3413; -.
DR   HOGENOM; HBG522909; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   180 AA;  19407 MW;  5ADC97248C1A312A CRC64;
     MRRTCCATTS AVLRSLVYLR PHGRAKPTTS GSGRKERQFS TTTARCESKG WHPAKLGMDG
     FTDVAYNTAA DTFLERVESA LETIGDTDTL EDVNLAGGVL VIETTSRGTF VLNKQAPNVQ
     LWLSSPLSGP HHYDMTTSAT GSVEWRADAD GHSLEERLEK ELSDVVGTEV SLSSGAGETE
//


ID   Q4Q9Y8_LEIMA            Unreviewed;       189 AA.
AC   Q4Q9Y8;
DT   19-JUL-2005, integrated into UniProtKB/TrEMBL.
DT   19-JUL-2005, sequence version 1.
DT   02-MAR-2010, entry version 18.
DE   SubName: Full=Frataxin-like protein;
GN   ORFNames=LmjF25.1050;
OS   Leishmania major.
OC   Eukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Leishmania.
OX   NCBI_TaxID=5664;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=Friedlin;
RX   PubMed=16020728; DOI=10.1126/science.1112680;
RA   Ivens A.C., Peacock C.S., Worthey E.A., Murphy L., Aggarwal G.,
RA   Berriman M., Sisk E., Rajandream M.A., Adlem E., Aert R., Anupama A.,
RA   Apostolou Z., Attipoe P., Bason N., Bauser C., Beck A., Beverley S.M.,
RA   Bianchettin G., Borzym K., Bothe G., Bruschi C.V., Collins M.,
RA   Cadag E., Ciarloni L., Clayton C., Coulson R.M.R., Cronin A.,
RA   Cruz A.K., Davies R.M., De Gaudenzi J., Dobson D.E., Duesterhoeft A.,
RA   Fazelina G., Fosker N., Frasch A.C., Fraser A., Fuchs M., Gabel C.,
RA   Goble A., Goffeau A., Harris D., Hertz-Fowler C., Hilbert H., Horn D.,
RA   Huang Y., Klages S., Knights A., Kube M., Larke N., Litvin L.,
RA   Lord A., Louie T., Marra M., Masuy D., Matthews K., Michaeli S.,
RA   Mottram J.C., Mueller-Auer S., Munden H., Nelson S., Norbertczak H.,
RA   Oliver K., O'neil S., Pentony M., Pohl T.M., Price C., Purnelle B.,
RA   Quail M.A., Rabbinowitsch E., Reinhardt R., Rieger M., Rinta J.,
RA   Robben J., Robertson L., Ruiz J.C., Rutter S., Saunders D.,
RA   Schaefer M., Schein J., Schwartz D.C., Seeger K., Seyler A., Sharp S.,
RA   Shin H., Sivam D., Squares R., Squares S., Tosato V., Vogt C.,
RA   Volckaert G., Wambutt R., Warren T., Wedler H., Woodward J., Zhou S.,
RA   Zimmermann W., Smith D.F., Blackwell J.M., Stuart K.D., Barrell B.G.,
RA   Myler P.J.;
RT   "The genome of the kinetoplastid parasite, Leishmania major.";
RL   Science 309:436-442(2005).
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CT005264; CAJ05122.1; -; Genomic_DNA.
DR   RefSeq; XP_001683860.1; -.
DR   SMR; Q4Q9Y8; 74-185.
DR   GeneID; 5652516; -.
DR   KEGG; lma:LmjF25.1050; -.
DR   EuPathDB; TritrypDB:LmjF25.1050; -.
DR   HOGENOM; HBG522909; -.
DR   OMA; SGPHHYD; -.
DR   PhylomeDB; Q4Q9Y8; -.
DR   ProtClustDB; CLSZ2439753; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   189 AA;  20244 MW;  9ED61C09312E969C CRC64;
     MNCARLHQRI PLRAMALATT GYPALASSHS FANASTSVMT ASAMAVVRRA ATTTGASAAT
     TTPQVVHYSK LGMDGFTDIK FNTAADELLE LVETKVDALD SAAVEDVSCN GGVLTLETTD
     RGTFILNKQA PNVQLWLSSP ISGPHHYDMI TVTQGGHEKV SWKSDHDGHD LVKKLEEELT
     EVLGTDFKV
//


ID   Q4DK61_TRYCR            Unreviewed;       190 AA.
AC   Q4DK61;
DT   13-SEP-2005, integrated into UniProtKB/TrEMBL.
DT   13-SEP-2005, sequence version 1.
DT   02-MAR-2010, entry version 16.
DE   SubName: Full=Frataxin-like, mitochondrial, putative;
GN   ORFNames=Tc00.1047053511871.80;
OS   Trypanosoma cruzi.
OC   Eukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Trypanosoma;
OC   Schizotrypanum.
OX   NCBI_TaxID=5693;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=CL Brener;
RA   El-Sayed N.M.A., Myler P.J., Bartholomeu D.C., Nilsson D.,
RA   Aggarwal G., Tran A.-N., Ghedin E., Worthey E.A., Delcher A.L.,
RA   Blandin G., Westenberger S.J., Caler E., Cerqueira G.C., Branche C.,
RA   Haas B., Anapuma A., Arner E., Aslund L., Attipoe P., Bontempi E.,
RA   Bringaud F., Burton P., Cadag E., Campbell D.A., Carrington M.,
RA   Crabtree J., Darban H., da Silveira J.F., de Jong P., Edwards K.,
RA   Englund P.T., Fazelina G., Feldblyum T., Ferella M., Frasch A.C.,
RA   Gull K., Horn D., Hou L., Huang Y., Kindlund E., Klingbeil M.,
RA   Kluge S., Koo H., Lacerda D., Levin M.J., Lorenzi H., Louie T.,
RA   Machado C.R., McCulloch R., McKenna A., Mizuno Y., Mottram J.C.,
RA   Nelson S., Ochaya S., Osoegawa K., Pai G., Parsons M., Pentony M.,
RA   Pettersson U., Pop M., Ramirez J.L., Rinta J., Robertson L.,
RA   Salzberg S.L., Sanchez D.O., Seyler A., Sharma R., Shetty J.,
RA   Simpson A.J., Sisk E., Tammi M.T., Tarleton R., Teixeira S.,
RA   Van Aken S., Vogt C., Ward P.N., Wickstead B., Wortman J., White O.,
RA   Fraser C.M., Stuart K.D., Andersson B.;
RT   "The Genome Sequence of Trypanosoma cruzi, Etiologic Agent of Chagas'
RT   Disease.";
RL   Science 0:0-0(2005).
RN   [2]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=CL Brener;
RA   El-Sayed N.M.A., Myler P.J., Blandin G., Berriman M., Crabtree J.,
RA   Aggarwal G., Caler E., Renauld H., Worthey E.A., Hertz-Fowler C.,
RA   Ghedin E., Peacock C., Bartholomeu D.C., Haas B.J., Tran A.-N.,
RA   Wortman J.R., Alsmark U.C.M., Angiuoli S., Anupama A., Badger J.,
RA   Bringaud F., Cadag E., Carlton J.M., Cerqueira G.C., Creasy T.,
RA   Delcher A.L., Djikeng A., Embley T.M., Hauser C., Ivens A.C.,
RA   Kummerfeld S.K., Pereira-Leal J.B., Nilsson D., Peterson J.,
RA   Salzberg S.L., Shallom J., Silva J.C., Sundaram J., Westenberger S.,
RA   White O., Melville S.E., Donelson J.E., Andersson B., Stuart K.D.,
RA   Hall N.;
RT   "Comparative Genomics of Trypanosomatid Parasitic Protozoa.";
RL   Science 0:0-0(2005).
RN   [3]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=CL Brener;
RA   El-Sayed N., Bartholomeu D., Haas B.;
RL   Submitted (JUN-2005) to the EMBL/GenBank/DDBJ databases.
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AAHK01000394; EAN92913.1; -; Genomic_DNA.
DR   RefSeq; XP_814764.1; -.
DR   SMR; Q4DK61; 71-185.
DR   GeneID; 3546357; -.
DR   KEGG; tcr:511871.80; -.
DR   EuPathDB; TritrypDB:Tc00.1047053511871.80; -.
DR   ProtClustDB; CLSZ2439753; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   190 AA;  20361 MW;  5DF87A14056D49C5 CRC64;
     MLSLTMRRVA ATTTTTTTTK TAAAIIMPSC LGTRARGMNA TSLKTICRCG TTTRVALAGV
     KGQTYSRLGM DGFTDVTYNT AADLFLEHVE NVLESVDSSA IEEVNLLSGV LSVETVSSGT
     FVLNKQAPNV QLWLSSPVSG PHHYDMVLPA GKDKVEGVND VQWLADSDGH SLKEKLEREL
     TETLGVEVKL
//


ID   Q4D403_TRYCR            Unreviewed;       186 AA.
AC   Q4D403;
DT   13-SEP-2005, integrated into UniProtKB/TrEMBL.
DT   13-SEP-2005, sequence version 1.
DT   02-MAR-2010, entry version 16.
DE   SubName: Full=Frataxin-like, mitochondrial, putative;
GN   ORFNames=Tc00.1047053511865.19;
OS   Trypanosoma cruzi.
OC   Eukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Trypanosoma;
OC   Schizotrypanum.
OX   NCBI_TaxID=5693;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=CL Brener;
RA   El-Sayed N.M.A., Myler P.J., Bartholomeu D.C., Nilsson D.,
RA   Aggarwal G., Tran A.-N., Ghedin E., Worthey E.A., Delcher A.L.,
RA   Blandin G., Westenberger S.J., Caler E., Cerqueira G.C., Branche C.,
RA   Haas B., Anapuma A., Arner E., Aslund L., Attipoe P., Bontempi E.,
RA   Bringaud F., Burton P., Cadag E., Campbell D.A., Carrington M.,
RA   Crabtree J., Darban H., da Silveira J.F., de Jong P., Edwards K.,
RA   Englund P.T., Fazelina G., Feldblyum T., Ferella M., Frasch A.C.,
RA   Gull K., Horn D., Hou L., Huang Y., Kindlund E., Klingbeil M.,
RA   Kluge S., Koo H., Lacerda D., Levin M.J., Lorenzi H., Louie T.,
RA   Machado C.R., McCulloch R., McKenna A., Mizuno Y., Mottram J.C.,
RA   Nelson S., Ochaya S., Osoegawa K., Pai G., Parsons M., Pentony M.,
RA   Pettersson U., Pop M., Ramirez J.L., Rinta J., Robertson L.,
RA   Salzberg S.L., Sanchez D.O., Seyler A., Sharma R., Shetty J.,
RA   Simpson A.J., Sisk E., Tammi M.T., Tarleton R., Teixeira S.,
RA   Van Aken S., Vogt C., Ward P.N., Wickstead B., Wortman J., White O.,
RA   Fraser C.M., Stuart K.D., Andersson B.;
RT   "The Genome Sequence of Trypanosoma cruzi, Etiologic Agent of Chagas'
RT   Disease.";
RL   Science 0:0-0(2005).
RN   [2]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=CL Brener;
RA   El-Sayed N.M.A., Myler P.J., Blandin G., Berriman M., Crabtree J.,
RA   Aggarwal G., Caler E., Renauld H., Worthey E.A., Hertz-Fowler C.,
RA   Ghedin E., Peacock C., Bartholomeu D.C., Haas B.J., Tran A.-N.,
RA   Wortman J.R., Alsmark U.C.M., Angiuoli S., Anupama A., Badger J.,
RA   Bringaud F., Cadag E., Carlton J.M., Cerqueira G.C., Creasy T.,
RA   Delcher A.L., Djikeng A., Embley T.M., Hauser C., Ivens A.C.,
RA   Kummerfeld S.K., Pereira-Leal J.B., Nilsson D., Peterson J.,
RA   Salzberg S.L., Shallom J., Silva J.C., Sundaram J., Westenberger S.,
RA   White O., Melville S.E., Donelson J.E., Andersson B., Stuart K.D.,
RA   Hall N.;
RT   "Comparative Genomics of Trypanosomatid Parasitic Protozoa.";
RL   Science 0:0-0(2005).
RN   [3]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=CL Brener;
RA   El-Sayed N., Bartholomeu D., Haas B.;
RL   Submitted (JUN-2005) to the EMBL/GenBank/DDBJ databases.
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AAHK01001064; EAN87256.1; -; Genomic_DNA.
DR   RefSeq; XP_809107.1; -.
DR   SMR; Q4D403; 67-181.
DR   GeneID; 3539672; -.
DR   KEGG; tcr:511865.19; -.
DR   EuPathDB; TritrypDB:Tc00.1047053511865.19; -.
DR   ProtClustDB; CLSZ2439753; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   186 AA;  20023 MW;  AC9D4D5F67BB7872 CRC64;
     MLSLTMRRVA ATTTTKTAAA IIMPSCLGTR VRGMNATSLK TICRCGTTTR VALAGVKGQT
     YSRLGMDGFT DVKYNNAADL FLEHVENVLE SVDSSAIEEV NLLGGVLSVE TVSSGTFVLN
     KQAPNVQLWL SSPVSGPHHY DMVLPAGKDR VEGVNDVQWL ADSDGHSLKE KLERELTETL
     GVEVKL
//


ID   Q4WPU7_ASPFU            Unreviewed;       217 AA.
AC   Q4WPU7;
DT   05-JUL-2005, integrated into UniProtKB/TrEMBL.
DT   17-APR-2007, sequence version 2.
DT   18-MAY-2010, entry version 25.
DE   SubName: Full=Mitochondrial chaperone Frataxin, putative;
GN   ORFNames=AFUA_4G10510;
OS   Aspergillus fumigatus (Sartorya fumigata).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta; Pezizomycotina;
OC   Leotiomyceta; Eurotiomycetes; Eurotiomycetidae; Eurotiales;
OC   Trichocomaceae; Neosartorya.
OX   NCBI_TaxID=5085;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=Af293 / CBS 101355 / FGSC A1100;
RX   PubMed=16372009; DOI=10.1038/nature04332;
RA   Nierman W.C., Pain A., Anderson M.J., Wortman J.R., Kim H.S.,
RA   Arroyo J., Berriman M., Abe K., Archer D.B., Bermejo C., Bennett J.W.,
RA   Bowyer P., Chen D., Collins M., Coulsen R., Davies R., Dyer P.S.,
RA   Farman M.L., Fedorova N., Fedorova N.D., Feldblyum T.V., Fischer R.,
RA   Fosker N., Fraser A., Garcia J.L., Garcia M.J., Goble A.,
RA   Goldman G.H., Gomi K., Griffith-Jones S., Gwilliam R., Haas B.J.,
RA   Haas H., Harris D.E., Horiuchi H., Huang J., Humphray S., Jimenez J.,
RA   Keller N., Khouri H., Kitamoto K., Kobayashi T., Konzack S.,
RA   Kulkarni R., Kumagai T., Lafton A., Latge J.-P., Li W., Lord A.,
RA   Lu C., Majoros W.H., May G.S., Miller B.L., Mohamoud Y., Molina M.,
RA   Monod M., Mouyna I., Mulligan S., Murphy L.D., O'Neil S., Paulsen I.,
RA   Penalva M.A., Pertea M., Price C., Pritchard B.L., Quail M.A.,
RA   Rabbinowitsch E., Rawlins N., Rajandream M.A., Reichard U.,
RA   Renauld H., Robson G.D., Rodriguez de Cordoba S., Rodriguez-Pena J.M.,
RA   Ronning C.M., Rutter S., Salzberg S.L., Sanchez M.,
RA   Sanchez-Ferrero J.C., Saunders D., Seeger K., Squares R., Squares S.,
RA   Takeuchi M., Tekaia F., Turner G., Vazquez de Aldana C.R., Weidman J.,
RA   White O., Woodward J.R., Yu J.-H., Fraser C.M., Galagan J.E., Asai K.,
RA   Machida M., Hall N., Barrell B.G., Denning D.W.;
RT   "Genomic sequence of the pathogenic and allergenic filamentous fungus
RT   Aspergillus fumigatus.";
RL   Nature 438:1151-1156(2005).
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AAHF01000005; EAL89737.2; -; Genomic_DNA.
DR   RefSeq; XP_751775.2; -.
DR   SMR; Q4WPU7; 88-209.
DR   STRING; Q4WPU7; -.
DR   GeneID; 3509356; -.
DR   KEGG; afm:AFUA_4G10510; -.
DR   eggNOG; fuNOG11011; -.
DR   HOGENOM; HBG324748; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q4WPU7; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   217 AA;  23802 MW;  37BCAD3DDE876C4B CRC64;
     MLSRISRSAA SSAARPSLRV GRISATAPAA IHLQPRLNGV NNSAQAPRRG FQCTSCIRKG
     IFPDSADPPA PKPQSNNVAG ASTHVTEPSP LTDVQYHEFA EHYLNVIQNE VEKAQEEGSD
     IEAEYSAGVM NISVPGVGTY VLNKQPPNKQ IWLSSPISGP KRYDWVLEGD QMHEKQDTRP
     FGNGQWIYLR DGSNLTDLLN AELSLNIAKD VYSEFEK
//


ID   FRDA_DICDI              Reviewed;         193 AA.
AC   Q54C45;
DT   08-APR-2008, integrated into UniProtKB/Swiss-Prot.
DT   24-MAY-2005, sequence version 1.
DT   10-AUG-2010, entry version 35.
DE   RecName: Full=Frataxin, mitochondrial;
DE            Short=Fxn;
DE   Flags: Precursor;
GN   Name=fxn; ORFNames=DDB_G0293246;
OS   Dictyostelium discoideum (Slime mold).
OC   Eukaryota; Amoebozoa; Mycetozoa; Dictyosteliida; Dictyostelium.
OX   NCBI_TaxID=44689;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=AX4;
RX   PubMed=15875012; DOI=10.1038/nature03481;
RA   Eichinger L., Pachebat J.A., Gloeckner G., Rajandream M.A.,
RA   Sucgang R., Berriman M., Song J., Olsen R., Szafranski K., Xu Q.,
RA   Tunggal B., Kummerfeld S., Madera M., Konfortov B.A., Rivero F.,
RA   Bankier A.T., Lehmann R., Hamlin N., Davies R., Gaudet P., Fey P.,
RA   Pilcher K., Chen G., Saunders D., Sodergren E.J., Davis P.,
RA   Kerhornou A., Nie X., Hall N., Anjard C., Hemphill L., Bason N.,
RA   Farbrother P., Desany B., Just E., Morio T., Rost R., Churcher C.M.,
RA   Cooper J., Haydock S., van Driessche N., Cronin A., Goodhead I.,
RA   Muzny D.M., Mourier T., Pain A., Lu M., Harper D., Lindsay R.,
RA   Hauser H., James K.D., Quiles M., Madan Babu M., Saito T.,
RA   Buchrieser C., Wardroper A., Felder M., Thangavelu M., Johnson D.,
RA   Knights A., Loulseged H., Mungall K.L., Oliver K., Price C.,
RA   Quail M.A., Urushihara H., Hernandez J., Rabbinowitsch E., Steffen D.,
RA   Sanders M., Ma J., Kohara Y., Sharp S., Simmonds M.N., Spiegler S.,
RA   Tivey A., Sugano S., White B., Walker D., Woodward J.R., Winckler T.,
RA   Tanaka Y., Shaulsky G., Schleicher M., Weinstock G.M., Rosenthal A.,
RA   Cox E.C., Chisholm R.L., Gibbs R.A., Loomis W.F., Platzer M.,
RA   Kay R.R., Williams J.G., Dear P.H., Noegel A.A., Barrell B.G.,
RA   Kuspa A.;
RT   "The genome of the social amoeba Dictyostelium discoideum.";
RL   Nature 435:43-57(2005).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral
CC       (By similarity).
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity).
CC   -!- SUBCELLULAR LOCATION: Mitochondrion (By similarity).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AAFI02000200; EAL60822.1; -; Genomic_DNA.
DR   RefSeq; XP_629221.1; -.
DR   HSSP; Q07540; 2GA5.
DR   ProteinModelPortal; Q54C45; -.
DR   SMR; Q54C45; 86-186.
DR   STRING; Q54C45; -.
DR   EnsemblProtists; DDB0266646; DDB0266646; DDB_G0293246.
DR   GeneID; 8629103; -.
DR   GenomeReviews; CM000155_GR; fxn.
DR   KEGG; ddi:DDB_G0293246; -.
DR   dictyBase; DDB_G0293246; fxn.
DR   eggNOG; KOG3413; -.
DR   HOGENOM; HBG396998; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:UniProtKB-SubCell.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   3: Inferred from homology;
KW   Complete proteome; Ion transport; Iron; Iron transport; Mitochondrion;
KW   Transit peptide; Transport.
FT   TRANSIT       1     72       Mitochondrion (Potential).
FT   CHAIN        73    193       Frataxin, mitochondrial.
FT                                /FTId=PRO_0000328230.
FT   COMPBIAS     42     45       Poly-Asn.
FT   COMPBIAS     64     67       Poly-Gln.
SQ   SEQUENCE   193 AA;  22206 MW;  0B21618EE5DFAC71 CRC64;
     MIFNFLNKAS NKTHTKLLLF SSIRNRILIN NISSTSKWSS INNNNKQSSV SKTNIFIITT
     HNKQQQQLSK SFSTINNNTK PISDVNLFHD IVDEEFELFV DRLEILSEAN TCEGFEVEGN
     DGVLTIIVGN KGTYVINKQT PNRQIWWSSP LSGPKRFDYD SVEKRWVDNR DGTPLRQLLN
     SEINTLCKYD MEI
//


ID   CYAY_RICTY              Reviewed;         104 AA.
AC   Q68X49;
DT   20-FEB-2007, integrated into UniProtKB/Swiss-Prot.
DT   20-FEB-2007, sequence version 2.
DT   10-AUG-2010, entry version 28.
DE   RecName: Full=Protein cyaY;
GN   Name=cyaY; OrderedLocusNames=RT0313;
OS   Rickettsia typhi.
OC   Bacteria; Proteobacteria; Alphaproteobacteria; Rickettsiales;
OC   Rickettsiaceae; Rickettsieae; Rickettsia; typhus group.
OX   NCBI_TaxID=785;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC VR-144 / Wilmington;
RX   PubMed=15317790; DOI=10.1128/JB.186.17.5842-5855.2004;
RA   McLeod M.P., Qin X., Karpathy S.E., Gioia J., Highlander S.K.,
RA   Fox G.E., McNeill T.Z., Jiang H., Muzny D., Jacob L.S., Hawes A.C.,
RA   Sodergren E., Gill R., Hume J., Morgan M., Fan G., Amin A.G.,
RA   Gibbs R.A., Hong C., Yu X.-J., Walker D.H., Weinstock G.M.;
RT   "Complete genome sequence of Rickettsia typhi and comparison with
RT   sequences of other Rickettsiae.";
RL   J. Bacteriol. 186:5842-5855(2004).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AE017197; AAU03793.1; -; Genomic_DNA.
DR   RefSeq; YP_067275.1; -.
DR   HSSP; Q16595; 1EKG.
DR   ProteinModelPortal; Q68X49; -.
DR   SMR; Q68X49; 1-100.
DR   GeneID; 2958797; -.
DR   GenomeReviews; AE017197_GR; RT0313.
DR   KEGG; rty:RT0313; -.
DR   HOGENOM; HBG687517; -.
DR   OMA; ILYITIS; -.
DR   ProtClustDB; PRK01379; -.
DR   BioCyc; RTYP257363:RT0313-MONOMER; -.
DR   HAMAP; MF_00142; CyaY; 1; -.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   3: Inferred from homology;
KW   Complete proteome.
FT   CHAIN         1    104       Protein cyaY.
FT                                /FTId=PRO_0000277896.
SQ   SEQUENCE   104 AA;  11924 MW;  B3CC58DBCCDC72C5 CRC64;
     MNNTAFSKLA ETTIVYIVDK IEEQDIEGII DVDLHGDILN LDTENGIYVI NTQSASKEIW
     LSSPVSGPHH FFYEQGKWKS RIGFELMILL TEELGIRFDK CEIF
//


ID   CYAY_RICFE              Reviewed;         101 AA.
AC   Q4UM50;
DT   13-SEP-2005, integrated into UniProtKB/Swiss-Prot.
DT   05-JUL-2005, sequence version 1.
DT   10-AUG-2010, entry version 31.
DE   RecName: Full=Protein cyaY;
GN   Name=cyaY; OrderedLocusNames=RF_0522;
OS   Rickettsia felis (Rickettsia azadi).
OC   Bacteria; Proteobacteria; Alphaproteobacteria; Rickettsiales;
OC   Rickettsiaceae; Rickettsieae; Rickettsia; spotted fever group.
OX   NCBI_TaxID=42862;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC VR-1525 / URRWXCal2;
RX   PubMed=15984913; DOI=10.1371/journal.pbio.0030248;
RA   Ogata H., Renesto P., Audic S., Robert C., Blanc G., Fournier P.-E.,
RA   Parinello H., Claverie J.-M., Raoult D.;
RT   "The genome sequence of Rickettsia felis identifies the first putative
RT   conjugative plasmid in an obligate intracellular parasite.";
RL   PLoS Biol. 3:1-12(2005).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CP000053; AAY61373.1; -; Genomic_DNA.
DR   RefSeq; YP_246538.1; -.
DR   ProteinModelPortal; Q4UM50; -.
DR   SMR; Q4UM50; 1-99.
DR   GeneID; 3401184; -.
DR   GenomeReviews; CP000053_GR; RF_0522.
DR   KEGG; rfe:RF_0522; -.
DR   NMPDR; fig|315456.3.peg.356; -.
DR   HOGENOM; HBG687517; -.
DR   OMA; ILYITIS; -.
DR   ProtClustDB; PRK01379; -.
DR   BioCyc; RFEL315456:RF_0522-MONOMER; -.
DR   GO; GO:0005739; C:mitochondrion; IEA:InterPro.
DR   GO; GO:0006879; P:cellular iron ion homeostasis; IEA:InterPro.
DR   HAMAP; MF_00142; CyaY; 1; -.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   InterPro; IPR001794; Frataxin_sub.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   PRINTS; PR00904; FRATAXIN.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   3: Inferred from homology;
KW   Complete proteome.
FT   CHAIN         1    101       Protein cyaY.
FT                                /FTId=PRO_0000193956.
SQ   SEQUENCE   101 AA;  11515 MW;  680DA7BF970E7BED CRC64;
     MNNTEFSKIA ETTIAYIADK IEEQDKEASI DVDLQGDILN LDTDKGIYVI NKQSAAKEIW
     LSSPVSGPYH FFYEQGKWKN KIGLELMAIL TEELNIKFDN I
//


ID   CYAY_RICPR              Reviewed;         104 AA.
AC   Q9ZDK5;
DT   30-MAY-2000, integrated into UniProtKB/Swiss-Prot.
DT   01-MAY-1999, sequence version 1.
DT   10-AUG-2010, entry version 55.
DE   RecName: Full=Protein cyaY;
GN   Name=cyaY; OrderedLocusNames=RP323;
OS   Rickettsia prowazekii.
OC   Bacteria; Proteobacteria; Alphaproteobacteria; Rickettsiales;
OC   Rickettsiaceae; Rickettsieae; Rickettsia; typhus group.
OX   NCBI_TaxID=782;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=Madrid E;
RX   MEDLINE=99039499; PubMed=9823893; DOI=10.1038/24094;
RA   Andersson S.G.E., Zomorodipour A., Andersson J.O.,
RA   Sicheritz-Ponten T., Alsmark U.C.M., Podowski R.M., Naeslund A.K.,
RA   Eriksson A.-S., Winkler H.H., Kurland C.G.;
RT   "The genome sequence of Rickettsia prowazekii and the origin of
RT   mitochondria.";
RL   Nature 396:133-140(1998).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AJ235271; CAA14783.1; -; Genomic_DNA.
DR   PIR; E71688; E71688.
DR   RefSeq; NP_220706.1; -.
DR   ProteinModelPortal; Q9ZDK5; -.
DR   SMR; Q9ZDK5; 1-99.
DR   GeneID; 883375; -.
DR   GenomeReviews; AJ235269_GR; RP323.
DR   KEGG; rpr:RP323; -.
DR   HOGENOM; HBG687517; -.
DR   OMA; ILYITIS; -.
DR   ProtClustDB; PRK01379; -.
DR   BioCyc; RPRO272947:RP323-MONOMER; -.
DR   HAMAP; MF_00142; CyaY; 1; -.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   3: Inferred from homology;
KW   Complete proteome.
FT   CHAIN         1    104       Protein cyaY.
FT                                /FTId=PRO_0000193957.
SQ   SEQUENCE   104 AA;  11961 MW;  CC3405C89CCB51A0 CRC64;
     MNNTAFSKLA ETTIVYIVDK IEEQDLEGII DVDLQGDILN LDTENGIYVI NTQSASKEIW
     LSSPVSGPHH FFYEQGKWKS RIGFELMVLL TEELGIRFDK YEIF
//


ID   CYAY_RICCN              Reviewed;         103 AA.
AC   Q92IH7;
DT   27-MAR-2002, integrated into UniProtKB/Swiss-Prot.
DT   01-DEC-2001, sequence version 1.
DT   10-AUG-2010, entry version 45.
DE   RecName: Full=Protein cyaY;
GN   Name=cyaY; OrderedLocusNames=RC0443;
OS   Rickettsia conorii.
OC   Bacteria; Proteobacteria; Alphaproteobacteria; Rickettsiales;
OC   Rickettsiaceae; Rickettsieae; Rickettsia; spotted fever group.
OX   NCBI_TaxID=781;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=ATCC VR-613 / Malish 7;
RX   MEDLINE=21442074; PubMed=11557893; DOI=10.1126/science.1061471;
RA   Ogata H., Audic S., Renesto-Audiffren P., Fournier P.-E., Barbe V.,
RA   Samson D., Roux V., Cossart P., Weissenbach J., Claverie J.-M.,
RA   Raoult D.;
RT   "Mechanisms of evolution in Rickettsia conorii and R. prowazekii.";
RL   Science 293:2093-2098(2001).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AE006914; AAL02981.1; -; Genomic_DNA.
DR   PIR; C97755; C97755.
DR   RefSeq; NP_360080.1; -.
DR   ProteinModelPortal; Q92IH7; -.
DR   SMR; Q92IH7; 1-100.
DR   GeneID; 928680; -.
DR   GenomeReviews; AE006914_GR; RC0443.
DR   KEGG; rco:RC0443; -.
DR   NMPDR; fig|272944.1.peg.443; -.
DR   OMA; ILYITIS; -.
DR   ProtClustDB; PRK01379; -.
DR   BioCyc; RCON272944:RC0443-MONOMER; -.
DR   HAMAP; MF_00142; CyaY; 1; -.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   3: Inferred from homology;
KW   Complete proteome.
FT   CHAIN         1    103       Protein cyaY.
FT                                /FTId=PRO_0000193955.
SQ   SEQUENCE   103 AA;  11689 MW;  1B3017B3E27FA40D CRC64;
     MNNSEFSKIA ETTIAYIAEK IEEQDKEASI DVDLQGDILN LDTDKGVYVI NKQSAAKEIW
     LSSPVSGPYH FFYEQGEWTN RAGLELMAIL TEELNIKFDT RPT
//


ID   Q7PBG4_RICSI            Unreviewed;       103 AA.
AC   Q7PBG4;
DT   15-DEC-2003, integrated into UniProtKB/TrEMBL.
DT   15-DEC-2003, sequence version 1.
DT   02-MAR-2010, entry version 23.
DE   SubName: Full=CyaY protein;
GN   Name=rsib_orf.266;
OS   Rickettsia sibirica 246.
OC   Bacteria; Proteobacteria; Alphaproteobacteria; Rickettsiales;
OC   Rickettsiaceae; Rickettsieae; Rickettsia; spotted fever group;
OC   Rickettsia sibirica subgroup.
OX   NCBI_TaxID=272951;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RC   STRAIN=246;
RA   Malek J.A., Eremeeva M.E., Dasch G.A.;
RL   Submitted (FEB-2003) to the EMBL/GenBank/DDBJ databases.
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AABW01000001; EAA25519.1; -; Genomic_DNA.
DR   HSSP; Q16595; 1EKG.
DR   SMR; Q7PBG4; 1-100.
DR   NMPDR; fig|35793.1.peg.231; -.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
SQ   SEQUENCE   103 AA;  11620 MW;  5A3017B3E27FA5D6 CRC64;
     MNNSEFSKIA ETTIAYIAEK IEEQDKEASI DVDLQGDILN LDTDKGVYVI NKQSAAKEIW
     LSSPVSGPYH FFYEQGEWTN SAGLELMAIL TEELNIKFDT RPT
//


ID   Q5BBU4_EMENI            Unreviewed;       211 AA.
AC   Q5BBU4;
DT   26-APR-2005, integrated into UniProtKB/TrEMBL.
DT   26-APR-2005, sequence version 1.
DT   23-MAR-2010, entry version 27.
DE   SubName: Full=Putative uncharacterized protein;
GN   ORFNames=AN1986.2;
OS   Emericella nidulans (Aspergillus nidulans).
OC   Eukaryota; Fungi; Dikarya; Ascomycota; Saccharomyceta; Pezizomycotina;
OC   Leotiomyceta; Eurotiomycetes; Eurotiomycetidae; Eurotiales;
OC   Trichocomaceae; Emericella.
OX   NCBI_TaxID=162425;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=FGSC A4 / M139;
RX   PubMed=16372000; DOI=10.1038/nature04341;
RA   Galagan J.E., Calvo S.E., Cuomo C., Ma L.-J., Wortman J.R.,
RA   Batzoglou S., Lee S.-I., Bastuerkmen M., Spevak C.C., Clutterbuck J.,
RA   Kapitonov V., Jurka J., Scazzocchio C., Farman M.L., Butler J.,
RA   Purcell S., Harris S., Braus G.H., Draht O., Busch S., D'Enfert C.,
RA   Bouchier C., Goldman G.H., Bell-Pedersen D., Griffiths-Jones S.,
RA   Doonan J.H., Yu J., Vienken K., Pain A., Freitag M., Selker E.U.,
RA   Archer D.B., Penalva M.A., Oakley B.R., Momany M., Tanaka T.,
RA   Kumagai T., Asai K., Machida M., Nierman W.C., Denning D.W.,
RA   Caddick M.X., Hynes M., Paoletti M., Fischer R., Miller B.L.,
RA   Dyer P.S., Sachs M.S., Osmani S.A., Birren B.W.;
RT   "Sequencing of Aspergillus nidulans and comparative analysis with A.
RT   fumigatus and A. oryzae.";
RL   Nature 438:1105-1115(2005).
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AACD01000030; EAA63887.1; -; Genomic_DNA.
DR   RefSeq; XP_659590.1; -.
DR   SMR; Q5BBU4; 82-203.
DR   GeneID; 2875084; -.
DR   KEGG; ani:AN1986.2; -.
DR   PhylomeDB; Q5BBU4; -.
DR   InterPro; IPR017789; Frataxin.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   TIGRFAMs; TIGR03422; mito_frataxin; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   4: Predicted;
KW   Complete proteome.
SQ   SEQUENCE   211 AA;  23705 MW;  F1984D161836F7BD CRC64;
     MLTSRAARAL LSSFPSTFGL RRLAIAASAA STFRFPNSTK LVAKYQHRNG FHSTPQIQKG
     ITPGSPDPPA PQPESSVRVS EPSPLSNHQY HEYSDHYLHV VQAKIEEMEE DRSDLETDLS
     AGILHINVAN VGTYVLNKQP PIKQLWLSSP VSGPRQYDWV VEGDQMHEKQ ETRPFTNGQW
     VCLRDNSNLT ELLNKELGLN LPRDVYSEVD E
//


ID   FRDA_ENCCU              Reviewed;         118 AA.
AC   Q8SWI3;
DT   01-SEP-2009, integrated into UniProtKB/Swiss-Prot.
DT   01-JUN-2002, sequence version 1.
DT   10-AUG-2010, entry version 36.
DE   RecName: Full=Frataxin, mitosomal;
DE            Short=Fxn;
GN   Name=YFH1; OrderedLocusNames=ECU01_1310;
OS   Encephalitozoon cuniculi (Microsporidian parasite).
OC   Eukaryota; Fungi; Microsporidia; Unikaryonidae; Encephalitozoon.
OX   NCBI_TaxID=6035;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=GB-M1;
RX   MEDLINE=21109930; PubMed=11157783; DOI=10.1101/gr.164301;
RA   Peyret P., Katinka M.D., Duprat S., Duffieux F., Barbe V.,
RA   Barbazanges M., Weissenbach J., Saurin W., Vivares C.P.;
RT   "Sequence and analysis of chromosome I of the amitochondriate
RT   intracellular parasite Encephalitozoon cuniculi (Microspora).";
RL   Genome Res. 11:198-207(2001).
RN   [2]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=GB-M1;
RX   MEDLINE=21576510; PubMed=11719806; DOI=10.1038/35106579;
RA   Katinka M.D., Duprat S., Cornillot E., Metenier G., Thomarat F.,
RA   Prensier G., Barbe V., Peyretaillade E., Brottier P., Wincker P.,
RA   Delbac F., El Alaoui H., Peyret P., Saurin W., Gouy M.,
RA   Weissenbach J., Vivares C.P.;
RT   "Genome sequence and gene compaction of the eukaryote parasite
RT   Encephalitozoon cuniculi.";
RL   Nature 414:450-453(2001).
RN   [3]
RP   SUBCELLULAR LOCATION, AND FUNCTION.
RX   PubMed=18311129; DOI=10.1038/nature06606;
RA   Goldberg A.V., Molik S., Tsaousis A.D., Neumann K., Kuhnke G.,
RA   Delbac F., Vivares C.P., Hirt R.P., Lill R., Embley T.M.;
RT   "Localization and functionality of microsporidian iron-sulphur cluster
RT   assembly proteins.";
RL   Nature 452:624-628(2008).
CC   -!- FUNCTION: Promotes the biosynthesis of heme as well as the
CC       assembly and repair of iron-sulfur clusters by delivering Fe(2+)
CC       to proteins involved in these pathways. It also plays a primary
CC       role in the protection against oxidative stress through its
CC       ability to catalyze the oxidation of Fe(2+) to Fe(3+) and to store
CC       large amounts of the metal in the form of a ferrihydrite mineral
CC       (By similarity).
CC   -!- SUBUNIT: Monomer; increments in mitochondrial iron uptake induce
CC       stepwise assembly of species ranging from trimers to 24-mers (By
CC       similarity).
CC   -!- SUBCELLULAR LOCATION: Mitosome.
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AL391737; CAD25004.1; -; Genomic_DNA.
DR   RefSeq; XP_965969.1; -.
DR   HSSP; Q07540; 2GA5.
DR   ProteinModelPortal; Q8SWI3; -.
DR   SMR; Q8SWI3; 7-111.
DR   STRING; Q8SWI3; -.
DR   GeneID; 860310; -.
DR   GenomeReviews; AL391737_GR; ECU01_1310.
DR   KEGG; ecu:ECU01_1310; -.
DR   NMPDR; fig|6035.1.peg.1969; -.
DR   eggNOG; fuNOG11011; -.
DR   OrthoDB; EOG98963R; -.
DR   PhylomeDB; Q8SWI3; -.
DR   GO; GO:0032047; C:mitosome; IEA:UniProtKB-SubCell.
DR   GO; GO:0006826; P:iron ion transport; IEA:UniProtKB-KW.
DR   InterPro; IPR002908; Frataxin-like.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   3: Inferred from homology;
KW   Complete proteome; Ion transport; Iron; Iron transport; Mitosome;
KW   Transport.
FT   CHAIN         1    118       Frataxin, mitosomal.
FT                                /FTId=PRO_0000382930.
SQ   SEQUENCE   118 AA;  13906 MW;  4CDABCE55628FD4E CRC64;
     MLHKQTPEDV ITRQLYHKLA DETLTDLSEQ LDKELDGGYA DYKDGNLQIK IDNVGEYMFN
     KQPASMQIWA SSPITGPRKF DICRRHEWID LKSNTSFSRY IEEELRRMRS KMAGKHKK
//


ID   CYAY_NEIMB              Reviewed;         107 AA.
AC   P56977;
DT   01-DEC-2000, integrated into UniProtKB/Swiss-Prot.
DT   01-DEC-2000, sequence version 1.
DT   10-AUG-2010, entry version 48.
DE   RecName: Full=Protein cyaY;
GN   Name=cyaY; OrderedLocusNames=NMB1978;
OS   Neisseria meningitidis serogroup B.
OC   Bacteria; Proteobacteria; Betaproteobacteria; Neisseriales;
OC   Neisseriaceae; Neisseria.
OX   NCBI_TaxID=491;
RN   [1]
RP   NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
RC   STRAIN=MC58 / Serogroup B;
RX   MEDLINE=20175755; PubMed=10710307; DOI=10.1126/science.287.5459.1809;
RA   Tettelin H., Saunders N.J., Heidelberg J.F., Jeffries A.C.,
RA   Nelson K.E., Eisen J.A., Ketchum K.A., Hood D.W., Peden J.F.,
RA   Dodson R.J., Nelson W.C., Gwinn M.L., DeBoy R.T., Peterson J.D.,
RA   Hickey E.K., Haft D.H., Salzberg S.L., White O., Fleischmann R.D.,
RA   Dougherty B.A., Mason T.M., Ciecko A., Parksey D.S., Blair E.,
RA   Cittone H., Clark E.B., Cotton M.D., Utterback T.R., Khouri H.M.,
RA   Qin H., Vamathevan J.J., Gill J., Scarlato V., Masignani V., Pizza M.,
RA   Grandi G., Sun L., Smith H.O., Fraser C.M., Moxon E.R., Rappuoli R.,
RA   Venter J.C.;
RT   "Complete genome sequence of Neisseria meningitidis serogroup B strain
RT   MC58.";
RL   Science 287:1809-1815(2000).
CC   -!- SIMILARITY: Belongs to the frataxin family.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; AE002098; AAF42306.1; -; Genomic_DNA.
DR   PIR; C81020; C81020.
DR   RefSeq; NP_274971.1; -.
DR   ProteinModelPortal; P56977; -.
DR   SMR; P56977; 2-104.
DR   EnsemblBacteria; EBNEIT00000010483; EBNEIP00000010103; EBNEIG00000010483.
DR   GeneID; 904161; -.
DR   GenomeReviews; AE002098_GR; NMB1978.
DR   KEGG; nme:NMB1978; -.
DR   NMPDR; fig|122586.1.peg.1905; -.
DR   TIGR; NMB1978; -.
DR   HOGENOM; HBG687517; -.
DR   OMA; EPLHQIW; -.
DR   ProtClustDB; PRK00446; -.
DR   BioCyc; NMEN122586:NMB_1978-MONOMER; -.
DR   HAMAP; MF_00142; CyaY; 1; -.
DR   InterPro; IPR002908; Frataxin-like.
DR   InterPro; IPR020895; Frataxin_CS.
DR   Gene3D; G3DSA:3.30.920.10; Frataxin_like; 1.
DR   Pfam; PF01491; Frataxin_Cyay; 1.
DR   SUPFAM; SSF55387; Frataxin_like; 1.
DR   TIGRFAMs; TIGR03421; FeS_CyaY; 1.
DR   PROSITE; PS01344; FRATAXIN_1; 1.
DR   PROSITE; PS50810; FRATAXIN_2; 1.
PE   3: Inferred from homology;
KW   Complete proteome.
FT   CHAIN         1    107       Protein cyaY.
FT                                /FTId=PRO_0000193946.
SQ   SEQUENCE   107 AA;  11936 MW;  1107C77D2459C881 CRC64;
     MMTESEFIRA SEALFEHIED QIDENGWDFD CRFAGNVLTI EAGDGAQIIV NRHTPNQELW
     IAAKSGGYHF AEQNGKWLAT RDGRDFYDVL NEALSAASGE AVEIAEL
//


ID   Q4T4P6_TETNG            Unreviewed;       196 AA.
AC   Q4T4P6;
DT   19-JUL-2005, integrated into UniProtKB/TrEMBL.
DT   19-JUL-2005, sequence version 1.
DT   02-MAR-2010, entry version 14.
DE   SubName: Full=Chromosome undetermined SCAF9568, whole genome shotgun sequence;
GN   ORFNames=GSTENG00007212001;
OS   Tetraodon nigroviridis (Green puffer).
OC   Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
OC   Actinopterygii; Neopterygii; Teleostei; Euteleostei; Neoteleostei;
OC   Acanthomorpha; Acanthopterygii; Percomorpha; Tetraodontiformes;
OC   Tetradontoidea; Tetraodontidae; Tetraodon.
OX   NCBI_TaxID=99883;
RN   [1]
RP   NUCLEOTIDE SEQUENCE.
RX   PubMed=15496914; DOI=10.1038/nature03025;
RA   Jaillon O., Aury J.-M., Brunet F., Petit J.-L., Stange-Thomann N.,
RA   Mauceli E., Bouneau L., Fischer C., Ozouf-Costaz C., Bernot A.,
RA   Nicaud S., Jaffe D., Fisher S., Lutfalla G., Dossat C., Segurens B.,
RA   Dasilva C., Salanoubat M., Levy M., Boudet N., Castellano S.,
RA   Anthouard V., Jubin C., Castelli V., Katinka M., Vacherie B.,
RA   Biemont C., Skalli Z., Cattolico L., Poulain J., De Berardinis V.,
RA   Cruaud C., Duprat S., Brottier P., Coutanceau J.-P., Gouzy J.,
RA   Parra G., Lardier G., Chapple C., McKernan K.J., McEwan P., Bosak S.,
RA   Kellis M., Volff J.-N., Guigo R., Zody M.C., Mesirov J.,
RA   Lindblad-Toh K., Birren B., Nusbaum C., Kahn D., Robinson-Rechavi M.,
RA   Laudet V., Schachter V., Quetier F., Saurin W., Scarpelli C.,
RA   Wincker P., Lander E.S., Weissenbach J., Roest Crollius H.;
RT   "Genome duplication in the teleost fish Tetraodon nigroviridis reveals
RT   the early vertebrate proto-karyotype.";
RL   Nature 431:946-957(2004).
RN   [2]
RP   NUCLEOTIDE SEQUENCE.
RG   Genoscope; Whitehead Institute Centre for Genome Research;
RL   Submitted (FEB-2004) to the EMBL/GenBank/DDBJ databases.
CC   -!- CAUTION: The sequence shown here is derived from an
CC       EMBL/GenBank/DDBJ whole genome shotgun (WGS) entry which is
CC       preliminary data.
CC   -----------------------------------------------------------------------
CC   Copyrighted by the UniProt Consortium, see http://www.uniprot.org/terms
CC   Distributed under the Creative Commons Attribution-NoDerivs License
CC   -----------------------------------------------------------------------
DR   EMBL; CAAE01009568; CAF92136.1; -; Genomic_DNA.
DR   SMR; Q4T4P6; 66-112.
DR   eggNOG; fiNOG16043; -.
PE   4: Predicted;
SQ   SEQUENCE   196 AA;  21975 MW;  E554F9698BC13D5B CRC64;
     MASLQKIGNL SKQVRNLSHV VGARPHTKHW LHPTYLLPNR PLGTRVDADV WRRNMHLSLH
     RRRSAPVQIS ELSEAAYEKL VDETLDALAE YFEDLTDAAF TGADYDVVFS VSSLPARSLT
     TVTPDPXXXX XXXXXXXXXX XXXXXXXXXX XXXLSSSLQW PEALRLERRA LGVHSRRREP
     PPAALPGVFS HLQQGH
//


