proc QuitteViandox {} {
    global Mol3dCou pgl StrucAVoir

    trace remove variable Mol3dCou write UpdateMol3dObjets
    trace remove variable AtomePique write FinCentreAtome
    trace remove variable ListeTypesDeFeatures write MetAJourFeaturesViandox

    foreach mold $StrucAVoir {
	set nom [DonneIdDeAccessPDB $mold]
	$nom _DeleteObjects
    }

    destroy [winfo toplevel $pgl(wogl)]

    unset pgl

    return
}


proc AfficheDansViandox {} {
    global pgl Rad OrdaliDir StrucAVoir

    # On y va !
    Initialisation

    AfficheFenetreOpengl

    set LFPDB {}
    
    AddFObj $::nom
    lappend LFPDB $::nom
    
    lassign [CenterVec] cx cy cz ZeRad
    set Rad $ZeRad

#    ToggleAllOff

    set pgl(xCen) $cx
    set pgl(yCen) $cy
    set pgl(zCen) $cz

    set ratio     $pgl(ratio)
    set zoom      $pgl(zoom)
    set Rad       $ZeRad
    set imgRad    $Rad
    set frontclip [expr {-1.0*$Rad}]
    set backclip  [expr { 1.0*$Rad}]
    set pgl(frontclip) $frontclip
    set pgl(backclip)  $backclip

    glMatrixMode GL_PROJECTION
    glLoadIdentity

    glOrtho [expr {-1.0*$zoom*$ratio*$imgRad}] \
	    [expr {     $ratio*$zoom*$imgRad}] \
	    [expr {-1.0*$zoom*$imgRad}] \
	    [expr {     $zoom*$imgRad}] \
	    [expr {$frontclip+$pgl(zCen)}] \
	    [expr {$backclip+$pgl(zCen)}]

    glMatrixMode GL_MODELVIEW

    glFogf GL_FOG_START 1.0
    glFogf GL_FOG_END   [expr {abs($backclip-$frontclip)}]

    $pgl(wogl) postredisplay

    return
}


proc Initialisation {} {
    global frontclip backclip cx cy Rad pgl Defauts
    global BUFSIZE selectBuffer AtmPick AtomePique
    global TypeRep Transform TransformList
    global ArcBall ThisRot LastRot ThisQuat
    global TransformAB TransformListAB

    set TypeRep ""

    # Pour texte
    set Transform [tcl3dVector GLfloat 16]
    tcl3dMatfIdentity $Transform
    set TransformList [tcl3dVectorToList $Transform 16]

    set BUFSIZE 512
    set selectBuffer [tcl3dVector GLuint $BUFSIZE]
    set AtmPick {}
    set AtomePique ""
    set Rad 0.
    set cx 0
    set cy 0

    set pgl(showframe) 1
    set pgl(appName) "Tcl3D demo: Molecules benchmark"
    set pgl(width)   500
    set pgl(height)  400
    set pgl(ratio)   1.0
    set pgl(zoom)    1.0
    set pgl(frontclip) -1.0
    set pgl(backclip)   1.0
    set pgl(Created) 0
    set pgl(fscreen) 0
    set pgl(Label3DColor) [set Defauts(Label3DColor)]
    set pgl(GLMode)  "render"

    set pgl(no_mat)            { 0.0 0.0 0.0 1.0 }

    set pgl(mat_ambient)       { 0.5 0.5 0.5 1.0 }
    set pgl(mat_diffuse)       { 0.5 0.5 0.5 1.0 }
    set pgl(mat_specular)      { 1.0 1.0 1.0 1.0 }
    set pgl(mat_emission)      { 0.3 0.5 0.5 1.0 }

    set pgl(light_ambient)     { 0.0 0.0 0.0 1.0 }
    # set pgl(light_ambient)     { 0.4 0.4 0.4 1.0 }
    set pgl(light_amb_lin)     { 0.7 0.7 0.7 1.0 }
    set pgl(light_diffuse)     { 1.0 1.0 1.0 1.0 }
#    set pgl(light_diffuse)     { 0.4 0.4 0.4 1.0 }
    set pgl(light_specular)    { 1.0 1.0 1.0 1.0 }
    set pgl(position)          { 0.0 0.0 -1000.}

    set pgl(no_shininess)        0.0
    set pgl(low_shininess)      15.0
    set pgl(high_shininess)    128.0
    set pgl(shadeModel)        $::GL_SMOOTH
    set pgl(lineMode)            0

    set pgl(coeff_ambient)       0.4
    set pgl(coeff_diffuse)       0.4
    set pgl(coeff_specular)      0.4

    set pgl(frameCount)          0

    set pgl(xCen) 0.0
    set pgl(yCen) 0.0
    set pgl(zCen) 0.0
    set pgl(xTra) 0.0
    set pgl(yTra) 0.0
    set pgl(zTra) 0.0
    set pgl(xRot) 0.0
    set pgl(yRot) 0.0

    set pgl(TextOgl) ""

    # init ArcBall
    set ArcBall     [tcl3dNewArcBall $pgl(width) $pgl(height)]
    set TransformAB [tcl3dVector GLfloat 16]
    set TransformListAB [tcl3dVectorToList $TransformAB 16]
    set ThisRot     [tcl3dVector GLfloat 16]
    set LastRot     [tcl3dVector GLfloat 16]
    set ThisQuat    [tcl3dVector GLfloat  4]

    return
}


proc printString { str } {
    global pgl

    #    glPushAttrib GL_LIST_BIT
    glListBase $pgl(FontBase)
    set len [string length $str]
    set sa [tcl3dVectorFromString GLubyte $str]
    glCallLists $len GL_UNSIGNED_BYTE $sa
    $sa delete

    return
}


proc ClearIDs {} {
    global pgl StrucAVoir

    foreach mold $StrucAVoir {
	set idx [lsearch [ExtraitListeDeListe $ListePDB 0] $mold]
	lassign [lindex $ListePDB $idx] mol fpdb
	set nom [DonneIdDeAccessPDB $mol]

	$nom _ClearPicked
    }

    $pgl(wogl) postredisplay

    return
}


proc AfficheLabels {Lx Ltxt} {
    global pgl

    # recup de la matrice de modelisation
    set mvmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
    set modmat [tcl3dVectorToList $mvmatrix 16]

    # recup de la matrice de projection
    set pjmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_PROJECTION_MATRIX $pjmatrix
    set projmat [tcl3dVectorToList $pjmatrix 16]

    # Recup du viewport
    set viewmat [tcl3dVector GLint 4]
    glGetIntegerv GL_VIEWPORT $viewmat
    set viewport [tcl3dVectorToList $viewmat 4]

    # print the string
    glMatrixMode GL_MODELVIEW
    glPushMatrix
    glLoadIdentity

    foreach v $Lx text $Ltxt {
	lassign $v x y z

	set xa [expr {[lindex $modmat 0]*$x + [lindex $modmat 4]*$y + [lindex $modmat 8]*$z + [lindex $modmat 12]}]
	set ya [expr {[lindex $modmat 1]*$x + [lindex $modmat 5]*$y + [lindex $modmat 9]*$z + [lindex $modmat 13]}]
	set za [expr {[lindex $modmat 2]*$x + [lindex $modmat 6]*$y + [lindex $modmat 10]*$z + [lindex $modmat 14]}]

	dont_use_light

	#	glColor3f {*}$pgl(Label3DColor)
	nolight_color3fv $pgl(Label3DColor)
	glRasterPos3f $xa $ya $za

	printString $text
    }

    glPopMatrix
    glFlush

    return
}



proc disp_string {} {
    global AtmPick AtomePique
    global mol
    global PDB_[set mol]_Labels
    global TypeRep Pck Cor

    #    dont_use_light

    foreach a $AtmPick {
	if {$TypeRep eq "fildefer"} {
	    lassign [set PDB_[set mol]_Labels($a)] text Lx 
	}
	if {$TypeRep eq "benjilamalice"} {
	    lassign [set Cor($a)] text Lx 
	}

	lassign $Lx x y z

	# recup de la matrice de modelisation
	set mvmatrix [tcl3dVector GLdouble 16]
	glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
	set modmat [tcl3dVectorToList $mvmatrix 16]

	# recup de la matrice de projection
	set pjmatrix [tcl3dVector GLdouble 16]
	glGetDoublev GL_PROJECTION_MATRIX $pjmatrix
	set projmat [tcl3dVectorToList $pjmatrix 16]

	# Recup du viewport
	set viewmat [tcl3dVector GLint 4]
	glGetIntegerv GL_VIEWPORT $viewmat
	set viewport [tcl3dVectorToList $viewmat 4]

	# print the string
	glMatrixMode GL_MODELVIEW
	glPushMatrix
	glLoadIdentity

	set xa [expr {[lindex $modmat 0]*$x + [lindex $modmat 4]*$y + [lindex $modmat 8]*$z + [lindex $modmat 12]}]
	set ya [expr {[lindex $modmat 1]*$x + [lindex $modmat 5]*$y + [lindex $modmat 9]*$z + [lindex $modmat 13]}]
	set za [expr {[lindex $modmat 2]*$x + [lindex $modmat 6]*$y + [lindex $modmat 10]*$z + [lindex $modmat 14]}]

	glColor3f 0.0 1.0 0.0
	glRasterPos3f $xa $ya $za

	printString $text

	glPopMatrix

	glFlush
    }

    return
}


proc processHits { hits } {
    global AtomePique
    puts "hits $hits"
    set AtomePique ""
    set AtmPick {}
    set count 0
    for {set i 0} {$i < $hits} {incr i} {
	# 1st rec : Nnames
	set names [$::selectBuffer get $count]
	puts "name $names"
	incr count
	# 2nd rec : min z-depth div par 0x7fffffff
	set minz [$::selectBuffer get $count]
	puts "minz $minz"
	incr count
	# 3rd rec : max z
	set maxz [$::selectBuffer get $count]
	puts "maxz $maxz"
	incr count
	# 4th rec : noms
	for {set j 0} {$j < $names} { incr j } {
	    set unom [$::selectBuffer get $count]
	    puts "unom $unom"
	    lappend AtmPick $unom
	    incr count
	}
    }

    puts "list AtmPick $AtmPick"
    set AtomePique [lindex $AtmPick end]
    puts "AtomPique $AtomePique"

    lassign [Tag2MolObjAtm $AtomePique] mol obj atm

    set db "::${mol}DB"
    set ra [$::db eval {select r.rnom, a.anom from atomes as a , residues as r where a.pk_atomes=$atm and r.pk_residues=a.pk_residues}]
    puts "pick -> $mol $obj $ra"

    $mol AddPicked $obj $atm

    return
}



proc XYZCenterAtom {} {
    global pgl TypeRep AtomePique

    if {$AtomePique eq ""} {return}

    lassign [Tag2MolObjAtm $AtomePique] mol obj atm
    set Lx [$mol AtomXYZ $atm]

    lassign $Lx x y z
    set pgl(xCen) $x
    set pgl(yCen) $y
    set pgl(zCen) $z

    set AtomePique ""

    return
}



proc FinCentreAtome {args} {
    global pgl

    trace remove variable AtomePique write FinCentreAtome

    $pgl(BoutonCenter) configure -fg cyan

    #    bind $pgl(wogl) <1> {set cx %x ; set cy %y}
    bind $pgl(wogl) <1> "LClick %x %y"

    return
}



proc CentreOnAtome {w} {
    global AtomePique pgl

#    trace add variable AtomePique write FinCentreAtome
    bind $pgl(wogl) <1> [list CenterAtom %x %y %W]

    $w configure -fg yellow

    return
}


proc CenterAtom {x y win} {
    global cx cy AtomePique pgl Rad

    set hits [DonneAtomePique $x $y]

    if {$hits <= 0} {return}

    processHits $hits
    XYZCenterAtom

    set pgl(xTra) 0.0
    set pgl(yTra) 0.0
    set pgl(zTra) 0.0

    set ratio     $pgl(ratio)
    set zoom      $pgl(zoom)
    set imgRad    $Rad
    set frontclip $pgl(frontclip)
    set backclip  $pgl(backclip)

    glMatrixMode GL_PROJECTION
    glLoadIdentity

    glOrtho [expr {-1.0*$zoom*$ratio*$imgRad}] \
	    [expr {     $ratio*$zoom*$imgRad}] \
	    [expr {-1.0*$zoom*$imgRad}] \
	    [expr {     $zoom*$imgRad}] \
	    [expr {$frontclip+$pgl(zCen)}] \
	    [expr {$backclip+$pgl(zCen)}]

    glMatrixMode GL_MODELVIEW

    set cx 0.0
    set cy 0.0

    $win postredisplay

    return
}



proc DonneAtomePique {x y} {
    global pgl Rad

    glSelectBuffer $::BUFSIZE $::selectBuffer
    glRenderMode GL_SELECT
    set pgl(GLMode) "select"

    set viewport  [tcl3dVector GLint 4]
    glGetIntegerv GL_VIEWPORT $viewport
    set w [$viewport get 2]
    set h [$viewport get 3]

    glMatrixMode GL_PROJECTION
    glPushMatrix
    glLoadIdentity
    # create 5x5 pixel picking region near cursor location
    gluPickMatrix $x [expr {$h-$y}] 5.0 5.0 $viewport

    set ratio     $pgl(ratio)
    set zoom      $pgl(zoom)
    set frontclip $pgl(frontclip)
    set backclip  $pgl(backclip)
    glOrtho \
	    [expr {-$ratio*$zoom*($Rad+$pgl(xTra))}]\
	    [expr { $ratio*$zoom*($Rad-$pgl(xTra))}] \
	    [expr {-       $zoom*($Rad+$pgl(yTra))}] \
	    [expr {        $zoom*($Rad-$pgl(yTra))}] \
	    [expr {$frontclip+$pgl(zCen)}] \
	    [expr {$backclip+$pgl(zCen)}]

    #    glPopMatrix

    # MODELVIEW
    glMatrixMode GL_MODELVIEW
    glLoadIdentity
    glPushMatrix
    glMultMatrixf $::TransformAO
    glTranslatef [expr {-1.0*$pgl(xCen)}] [expr {-1.0*$pgl(yCen)}] [expr {-1.0*$pgl(zCen)}]

    EnvoieLesObjets

    glFlush
    glPopMatrix

    glMatrixMode GL_PROJECTION
    glPopMatrix

    set hits [glRenderMode GL_RENDER]
    set pgl(GLMode) "render"

    return $hits
}


proc PickAtom {x y win} {
    global cx cy

    set hits [DonneAtomePique $x $y]

    if {! $hits} {return}

    processHits $hits

    set cx $x
    set cy $y

    $win postredisplay

    return
}



proc dont_use_light {} {
    global pgl

    glMaterialfv GL_FRONT_AND_BACK GL_SPECULAR [list 0.0 0.0 0.0 1.0]
    glMaterialfv GL_FRONT_AND_BACK GL_DIFFUSE  [list 0.0 0.0 0.0 1.0]
    #    glMaterialfv GL_FRONT_AND_BACK GL_SPECULAR [list 0.0 0.0 0.0 1.0]
    #    glMaterialfv GL_FRONT_AND_BACK GL_AMBIENT  [list 0.0 0.0 0.0 1.0]

    # next calls to glColor will affect GL_AMBIENT composante
    glColorMaterial GL_FRONT_AND_BACK GL_AMBIENT

    return
}



proc use_light {} {
#    global pgl
    #    return
    #    glEnable      GL_LIGHTING
    #    glEnable      GL_COLOR_MATERIAL

    # glLightfv GL_LIGHT0 GL_AMBIENT $pgl(light_ambient)

    # glMaterialfv GL_FRONT_AND_BACK GL_SPECULAR  $pgl(mat_specular)
#    glMaterialf  GL_FRONT_AND_BACK GL_SHININESS $pgl(high_shininess)

    return
}


proc light_color3f {a b c} {
    set le [list $a $b $c 1.0]

    glMaterialfv GL_FRONT_AND_BACK GL_AMBIENT_AND_DIFFUSE $le
    glMaterialfv GL_FRONT_AND_BACK GL_SPECULAR [list 1.0 1.0 1.0 1.0]
    glMaterialfv GL_FRONT_AND_BACK GL_EMISSION [list 0.0 0.0 0.0 1.0]
    glMaterialfv GL_FRONT_AND_BACK GL_SHININESS 128.

    return
}


proc light_color3fv {a} {
    lappend a 1.0
    glMaterialfv GL_FRONT_AND_BACK GL_AMBIENT_AND_DIFFUSE $a
    glMaterialfv GL_FRONT_AND_BACK GL_SPECULAR [list 1.0 1.0 1.0 1.0]
    glMaterialfv GL_FRONT_AND_BACK GL_EMISSION [list 0.0 0.0 0.0 1.0]
    glMaterialfv GL_FRONT_AND_BACK GL_SHININESS 128.

    return
}


proc nolight_color3f {r g b} {
    global pgl

    set c $pgl(coeff_ambient)

    glColor3f [expr {$r/$c}] [expr {$g/$c}] [expr {$b/$c}]

    return
}



proc nolight_color3fv {col} {
    global pgl

    lassign $col r g b a
    set c $pgl(coeff_ambient)

    glColor3f [expr {$r/$c}] [expr {$g/$c}] [expr {$b/$c}]

    return
}



proc SetWindowMode {} {
    global pgl

    set win [winfo toplevel $pgl(wogl)]
    set h           $pgl(Oldh)
    set w           $pgl(Oldw)
    set sh          [winfo screenheight $win]
    set sw          [winfo screenwidth  $win]

    wm minsize $win 10 10
    wm maxsize $win $sw $sh

    set fmtStr [format "%dx%d+0+25" $w $h]
    wm geometry $win $fmtStr
    wm overrideredirect $win 0
    focus $win

    return
}



proc SetFullScreenMode {} {
    global pgl

    set win [winfo toplevel $pgl(wogl)]
    set pgl(Oldw) [winfo width  $win]
    set pgl(Oldh) [winfo height $win]
    set sh        [winfo screenheight $win]
    set sw        [winfo screenwidth  $win]

    wm minsize $win $sw $sh
    wm maxsize $win $sw $sh
    wm overrideredirect $win 1
    wm attributes $win -fullscreen 1

    update idletasks

    focus $win

    return
}


proc ToggleShowFrame {} {
    global pgl

    if {$pgl(showframe)} {
	grid forget $pgl(frObjc)
	grid forget $pgl(frBann)
	grid forget $pgl(frCtrl)
	grid forget $pgl(frFonc)
	
	set pgl(showframe) 0
    } else {
	grid $pgl(frBann) -row 0 -column 0 -columnspan 3 -sticky ew
	grid $pgl(frCtrl) -row 1 -column 0 -columnspan 3 -sticky ew
	grid $pgl(frObjc) -row 2 -column 0 -sticky ns   -pady 15
	grid $pgl(frFonc) -row 2 -column 2 -sticky ns -pady 15
	set pgl(showframe) 1
    }

#    FenetreAuCentre [winfo toplevel $pgl(wogl)]

    update idletasks
#lulu
    return
}


proc ToggleWindowMode {} {
    global pgl

    if {! $pgl(fscreen) } {
	SetFullScreenMode
	set pgl(fscreen) 1
    } else {
	SetWindowMode
	set pgl(fscreen) 0
    }

#    FenetreAuCentre [winfo toplevel $pgl(wogl)]

    return
}



proc EnvoieLesObjets {} {
    global StrucAVoir

    foreach i $StrucAVoir {
	set nom [DonneIdDeAccessPDB $i]

	$nom _Display
    }

    return
}


proc Togl_CreateFonct {w} {
    global BUFSIZE selectBuffer pgl Rad

    set BUFSIZE 512
    set selectBuffer [tcl3dVector GLuint $BUFSIZE]

    set pgl(FontBase) [$w loadbitmapfont]
    set pgl(FontBase) [$w loadbitmapfont]

    glShadeModel GL_SMOOTH

    glClearColor 0.0 0.0 0.0 1.0

    # The Type Of Depth Testing To Do
    glClearDepth 0.0
    glEnable     GL_DEPTH_TEST
    glDepthFunc  GL_GREATER

    # Parametres lumiere anmbiante
    glLightfv GL_LIGHT0 GL_AMBIENT $pgl(light_ambient)
    glLightfv GL_LIGHT0 GL_DIFFUSE $pgl(light_diffuse)

    glLightModeli  GL_LIGHT_MODEL_TWO_SIDE $::GL_TRUE

    glMaterialfv GL_FRONT_AND_BACK GL_DIFFUSE {1.0 1.0 1.0 1.0}
    glMaterialfv GL_FRONT_AND_BACK GL_SPECULAR {1.0 1.0 1.0 1.0}
    glMaterialfv GL_FRONT_AND_BACK GL_SHININESS 128.



    glEnable GL_LIGHT0
    glEnable GL_LIGHTING

    glEnable GL_COLOR_MATERIAL

    # Definition FOG
#    glEnable GL_FOG

    set fogColor {0.0 0.0 0.0 1.0}
    glFogi  GL_FOG_MODE $::GL_EXP2
    glFogfv GL_FOG_COLOR $fogColor
    glFogf  GL_FOG_DENSITY 0.1
    glHint  GL_FOG_HINT GL_DONT_CARE
    glFogf  GL_FOG_START 1.
    glFogf  GL_FOG_END   10.

    return
}


proc Togl_ReshapeFonct {toglwin w h} {
    global pgl Rad

    if { $h == 0 }  {set h 1}
    if { $w == 0 }  {set w 1}
    set pgl(width)  $w
    set pgl(height) $h
    set pgl(ratio)  [expr {double($w)/$h}]

    glViewport 0 0 $w $h

    set ratio     $pgl(ratio)
    set zoom      $pgl(zoom)
    set frontclip $pgl(frontclip)
    set backclip  $pgl(backclip)

    glMatrixMode GL_PROJECTION
    glLoadIdentity

    glOrtho \
	    [expr {-$ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xTra)}]\
	    [expr { $ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xTra)}] \
	    [expr {-$zoom*$Rad -$zoom*$pgl(yTra)}] \
	    [expr { $zoom*$Rad -$zoom*$pgl(yTra)}] \
	    [expr {$pgl(frontclip)+$pgl(zCen)}] \
	    [expr {$pgl(backclip)+$pgl(zCen)}]

    glMatrixMode GL_MODELVIEW
    glLoadIdentity

    glFogf GL_FOG_START 1.0
    glFogf GL_FOG_END   [expr {abs($backclip-$frontclip)}]

    # *NEW* Update mouse bounds for arcball
    tcl3dSetArcBallBounds $::ArcBall $w $h

    $toglwin postredisplay

    return
}


proc Togl_DisplayFonct {w} {
    glClearColor 0.0 0.0 0.0 1.0
    glClear [expr $::GL_COLOR_BUFFER_BIT | $::GL_DEPTH_BUFFER_BIT]

    glMatrixMode GL_MODELVIEW
    glLoadIdentity

    glPushMatrix

    glMultMatrixf $::TransformAO

    glTranslatef [expr {-1.0*$::pgl(xCen)}] [expr {-1.0*$::pgl(yCen)}] [expr {-1.0*$::pgl(zCen)}]

    CheckNormals ribbon
    CheckNormals check

    glPopMatrix

    glFlush

    $w swapbuffers

    return
}


proc ResetRotations {} {
    global pgl

    tcl3dMatfIdentity $::TransformAB
    tcl3dMatfIdentity $::ThisRot
    tcl3dMatfIdentity $::LastRot
    set ::TransformListAB [tcl3dVectorToList $::TransformAB 16]
    $pgl(wogl) postredisplay

    return
}



proc InitArcBall { w x y } {
    #    global pgl

    # Set Last Static Rotation To Last Dynamic One
    tcl3dMatfCopy $::ThisRot $::LastRot
    # Update Start Vector And Prepare For Dragging
    tcl3dArcBallClick $::ArcBall $x $y

    #    $w postredisplay
}


proc DragArcBall { w x y } {
    global TransformAB TransformListAB ArcBall ThisQuat ThisRot LastRot

    # Update End Vector And Get Rotation As Quaternion
    tcl3dArcBallDrag $::ArcBall $x $y $ThisQuat

    # Convert Quaternion Into Matrix
    tcl3dTrackballBuildRotMatrix $ThisRot $ThisQuat

    # Accumulate Last Rotation Into This One
    tcl3dMatfMult $ThisRot $LastRot $TransformAB
    tcl3dMatfCopy $TransformAB $ThisRot

    set TransformListAB [tcl3dVectorToList $TransformAB 16]

    #    glMatrixMode GL_MODELVIEW
    #    glLoadIdentity
    #   glPushMatrix
    #    glMultMatrixf $::TransformListAB
    # glPopMatrix

    #    $w postredisplay
}


proc Mouse {quoi x y win} {
    global pgl cx cy

    switch $quoi {
	"ArcBall" {
	    DragArcBall $win $x $y

	    #	    glMatrixMode GL_MODELVIEW
	    #	    glLoadIdentity
	    #	    glPushMatrix
	    #	    glMultMatrixf $::TransformListAB
	    #	    glPopMatrix
	}
	"RotXY" {
	    # rotation X et Y
	    if { abs($cx-$x) < 5 && abs($cy-$y) < 5 } {return}

	    glMatrixMode GL_MODELVIEW

	    set mvm      [tcl3dVector GLdouble 16]
	    glGetDoublev GL_MODELVIEW_MATRIX $mvm
	    #	    set mvList   [tcl3dVectorToList $mvmatrix 16]

	    #	    glRotatef [expr {$cy-$y}] [lindex $mvList 0] [lindex $mvList 4] [lindex $mvList 8]
	    glRotatef [expr {$cy-$y}] [$mvm get 0] [$mvm get 4] [$mvm get 8]

	    glGetDoublev GL_MODELVIEW_MATRIX $mvm
	    #	    set mvList   [tcl3dVectorToList $mvmatrix 16]
	    #	    glRotatef [expr {$cx-$x}] [lindex $mvList 1] [lindex $mvList 5] [lindex $mvList 9]
	    glRotatef [expr {$cx-$x}] [$mvm get 1] [$mvm get 5] [$mvm get 9]
	}
	"TraXY" {
	    if { $cx == $x && $cy == $y } {return}

	    # empiric constant 1.5
	    global Rad pgl
	    set rx [expr {1.5*$Rad*($x-$cx)/$pgl(width)}]
	    set ry [expr {1.5*$Rad*($y-$cy)/$pgl(height)}]

	    set pgl(yTra) [expr {$pgl(yTra) - $ry}]
	    set pgl(xTra) [expr {$pgl(xTra) + $rx}]

	    glMatrixMode GL_PROJECTION
	    glLoadIdentity

	    set ratio     $pgl(ratio)
	    set zoom      $pgl(zoom)
	    set frontclip $pgl(frontclip)
	    set backclip  $pgl(backclip)

	    glOrtho \
		    [expr {-$ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xTra)}]\
		    [expr { $ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xTra)}] \
		    [expr {-$zoom*$Rad -$zoom*$pgl(yTra)}] \
		    [expr { $zoom*$Rad -$zoom*$pgl(yTra)}] \
		    [expr {$pgl(frontclip)+$pgl(zCen)}] \
		    [expr {$pgl(backclip)+$pgl(zCen)}]


	    glMatrixMode GL_MODELVIEW
	}
    }

    set cx $x
    set cy $y

    $win postredisplay

    return
}


proc HandleZoom {n win} {
    global pgl cx cy Rad

    set pgl(zoom) [expr {$pgl(zoom) + $n}]

    if {$pgl(zoom) < 0.0001} {set pgl(zoom) 0.0001}

    set ratio     $pgl(ratio)
    set zoom      $pgl(zoom)
    set imgRad    $Rad
    set frontclip $pgl(frontclip)
    set backclip  $pgl(backclip)

    glMatrixMode GL_PROJECTION
    glLoadIdentity

    glOrtho \
	    [expr {-$ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xTra)}]\
	    [expr { $ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xTra)}] \
	    [expr {-$zoom*$Rad -$zoom*$pgl(yTra)}] \
	    [expr { $zoom*$Rad -$zoom*$pgl(yTra)}] \
	    [expr {$pgl(frontclip)+$pgl(zCen)}] \
	    [expr {$pgl(backclip)+$pgl(zCen)}]

    glMatrixMode GL_MODELVIEW

    $win postredisplay

    return
}


proc RotTrans {} {
    global pgl

    glMatrixMode GL_MODELVIEW
    #    glLoadIdentity

    glTranslatef [expr {-1.*$pgl(xdist)}] [expr {-1.0*$pgl(ydist)}] 0.0
    #    glTranslatef $pgl(xdist) $pgl(ydist) 0.0

    set mvmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
    set mvList   [tcl3dVectorToList $mvmatrix 16]

    glRotatef $pgl(yRot) [lindex $mvList 0] [lindex $mvList 4] [lindex $mvList 8]

    glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
    set mvList   [tcl3dVectorToList $mvmatrix 16]
    glRotatef $pgl(yRot) [lindex $mvList 1] [lindex $mvList 5] [lindex $mvList 9]

    glTranslatef $pgl(xdist) $pgl(ydist) 0.0

    return
}


proc RotTrans1 {} {
    global pgl

    glMatrixMode GL_MODELVIEW
    #    glLoadIdentity

    #    glTranslatef $pgl(xdist) $pgl(ydist) 0.0

    set mvmatrix [tcl3dVector GLdouble 16]
    glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
    set mvList   [tcl3dVectorToList $mvmatrix 16]

    glRotatef $pgl(yRot) [lindex $mvList 0] [lindex $mvList 4] [lindex $mvList 8]

    glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
    set mvList   [tcl3dVectorToList $mvmatrix 16]
    glRotatef $pgl(yRot) [lindex $mvList 1] [lindex $mvList 5] [lindex $mvList 9]

    glTranslatef [expr {-1.*$pgl(xdist)}] [expr {-1.0*$pgl(ydist)}] 0.0
    return
}


proc RotTrans2 {} {
    global pgl

    glTranslatef $pgl(xdist) $pgl(ydist) 0.0

    return
}


proc HandleTrans {axis x y win} {
    global pgl cx cy Rad

    if { $cx == $x && $cy == $y } {return}

    # empiric constant 1.5
    set rx [expr {1.5*$Rad*($x-$cx)/$pgl(width)}]
    set ry [expr {1.5*$Rad*($y-$cy)/$pgl(height)}]

    set ratio $pgl(ratio)
    set zoom  $pgl(zoom)

    if {0} {
	set pgl(ydist) [expr {$pgl(ydist) - $ry}]
	set pgl(xdist) [expr {$pgl(xdist) + $rx}]

	glMatrixMode GL_PROJECTION
	glLoadIdentity
	glOrtho \
		[expr {-$ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xdist)}]\
		[expr { $ratio*$zoom*$Rad -$ratio*$zoom*$pgl(xdist)}] \
		[expr {-$zoom*$Rad -$zoom*$pgl(ydist)}] \
		[expr { $zoom*$Rad -$zoom*$pgl(ydist)}] \
		$pgl(frontclip) \
		$pgl(backclip)

	glMatrixMode GL_MODELVIEW
    } else {
	#	set pgl(ydist) [expr {$pgl(ydist) - $ry}]
	#	set pgl(xdist) [expr {$pgl(xdist) + $rx}]
	set pgl(ydist) $ry
	set pgl(xdist) $rx

	if {1} {
	    #	glMatrixMode GL_MODELVIEW
	    glMatrixMode GL_PROJECTION

	    glPushMatrix
	    #	    glLoadIdentity
	    glTranslatef $rx $ry 0.0
	    glTranslatef $pgl(xdist) $pgl(ydist) 0.0

	    #	    glPopMatrix
	}
    }

    set cx $x
    set cy $y

    $win postredisplay

    return
}


proc HandleRot {x y win} {
    global cx cy pgl

    if { abs($cx-$x) < 5 && abs($cy-$y) < 5} {return}
    set dx [expr {double($cx-$x)}]
    set dy [expr {double($cy-$y)}]

    if {1} {
	set pgl(xRot) $dx
	set pgl(yRot) $dy

	set cx $x
	set cy $y

	$win postredisplay

	return
    }

    if {0} {
	RotY $win [expr {180. * ($x - $cx) / [winfo width $win]}]
	RotX $win [expr {180. * ($y - $cy) / [winfo height $win]}]
    } else {
	set mvmatrix [tcl3dVector GLdouble 16]
	glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
	set mvList   [tcl3dVectorToList $mvmatrix 16]

	#	glTranslatef [expr {-1.*$pgl(xdist)}] [expr {-1.0*$pgl(ydist)}] 0.0

	glMatrixMode GL_MODELVIEW
	glRotatef $dy [lindex $mvList 0] [lindex $mvList 4] [lindex $mvList 8]

	glGetDoublev GL_MODELVIEW_MATRIX $mvmatrix
	set mvList   [tcl3dVectorToList $mvmatrix 16]
	glRotatef $dx [lindex $mvList 1] [lindex $mvList 5] [lindex $mvList 9]
	glTranslatef [expr {-1.*$pgl(xdist)}] [expr {-1.0*$pgl(ydist)}] 0.0
	glTranslatef $pgl(xdist) $pgl(ydist) 0.0

	set cx $x
	set cy $y

	$win postredisplay

	return
    }

    set cx $x
    set cy $y

    return
}


proc RotX { w angle } {
    global pgl

    set pgl(xRotate) [expr {$pgl(xRotate) + $angle}]
    $w postredisplay

    return
}


proc RotY { w angle } {
    global pgl

    set pgl(yRotate) [expr {$pgl(yRotate) + $angle}]
    $w postredisplay

    return
}


proc RotZ { w angle } {
    set ::pgl(zRotate) [expr {$::pgl(zRotate) + $angle}]
    $w postredisplay

    return
}


proc ToggleTabBouton w {
    set Lw [split $w .]
    set mol [string range [lindex $Lw end-1] 1 4]
    set sea [join [lrange $Lw 0 end-1] .]
    set Lwm [lsearch -regexp -all -inline [winfo children $sea] ".bto"]

    if {[string index [$w cget -text] 0] eq "-"} {
	$w configure -text "+ $mol" -foreground green
	grid forget {*}$Lwm
    } else {
	$w configure -text "- $mol" -foreground yellow
	foreach e $Lwm {
	    set Le [split $e .]
	    set last [lindex $Le end]
	    set no [string range $last 3 end]
	    grid $e -row $no -pady 0 -ipady 0 
	}
    }

    return
}


proc AfficheObjet {w nom obj} {
    global OOn pgl

    if {[$w cget -foreground] eq "green"} {
	set OOn($obj) 0
	#$nom ObjetOff $obj
	$w configure -foreground red
    } else {
	set OOn($obj) 1
	#$nom ObjetOn $obj
	$w configure -foreground green
    }

    $pgl(wogl) postredisplay

    return
}


proc TousObjetsOn {} {
    global pgl StrucAVoir
    set fobj $pgl(frObjc)
    set Lf [winfo children $fobj]
    foreach w $Lf {
	set c [lindex [split $w .] end]
	if {[string index $c 0] ne "f"} {continue}
	set nom [string range $c 1 end]
	foreach e [winfo children $w] {
	    set b [lindex [split $e .] end]
	    if {[string range $b 0 2] ne "bto"} {continue}
	    set o [string trim [$e cget -text]]
	    if {[$nom _EtatDeObjet $o]} {continue}
	    $nom ObjetOn $o
	    $e configure -foreground green
	}
    }

    update idletasks
    $pgl(wogl) postredisplay

    return
}


proc TousObjetsOff {} {
    global pgl StrucAVoir

    set fobj $pgl(frObjc)
    set Lf [winfo children $fobj]
    foreach w $Lf {
	set c [lindex [split $w .] end]
	if {[string index $c 0] ne "f"} {continue}
	set nom [string range $c 1 end]
	foreach e [winfo children $w] {
	    set b [lindex [split $e .] end]
	    if {[string range $b 0 2] ne "bto"} {continue}
	    set o [string trim [$e cget -text]]
	    if {! [$nom _EtatDeObjet $o]} {continue}
	    $nom ObjetOff $o
	    $e configure -foreground red
	}
    }

    update idletasks
    $pgl(wogl) postredisplay

    return
}


proc ToggleAllOff {} {
    global StrucAVoir pgl

    set fobj $pgl(frObjc)
    foreach e $StrucAVoir {
	lassign $e nc f
	set nom [DonneIdDeAccessPDB $nc]
	set t [$fobj.f${nom}.b0 cget -text]
	if {[string index $t 0] eq "-"} {
	    $fobj.f${nom}.b0 invoke
	}
    }

    return
}


proc AddFObj {nom} {
    global pgl

    set frObjc $pgl(frObjc)
    set i [lindex [grid size $frObjc] 1]
    frame $frObjc.f${nom} -bg black -relief flat -bd 0 -highlightthickness 0

    set c 0
    button $frObjc.f${nom}.b$c \
	    -text "- $nom" -font FontOgTitle \
	    -bg black -fg white \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -pady 0 -padx 0 -highlightthickness 0 \
	    -anchor w -justify left \
	    -command [list ToggleTabBouton $frObjc.f${nom}.b$c]

    button $frObjc.f${nom}.n$c \
	    -text "New" -font FontOg \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -pady 0 -padx 0 -highlightthickness 0 \
	    -anchor w -justify left \
	    -command [list NYI]
    grid $frObjc.f${nom}.b$c \
	    -row $c -column 0 -sticky w \
	    -ipady 0 -pady 0 -padx 0
    grid $frObjc.f${nom}.n$c \
	    -row $c -column 1 -sticky e \
	    -ipady 0 -pady 0 -padx 0
    incr c

    # objets
    foreach obj {check ribbon} {
	button $frObjc.f${nom}.bto$c \
		-text "$obj" -font FontOg \
		-bg black -fg green \
		-activeforeground red \
		-activebackground black \
		-bd 0 -relief flat \
		-highlightthickness 0 \
		-padx 0 -pady 0 \
		-anchor e -justify right \
		-command [list AfficheObjet $frObjc.f${nom}.bto$c $nom $obj]
	grid $frObjc.f${nom}.bto$c \
		-row $c -column 0 -sticky "" \
		-columnspan 2 \
		-pady 0 -ipady 0 -padx 0
	incr c
    }
    grid $frObjc.f${nom} \
	    -row $i -column 0 -sticky nwe \
	    -pady 0 -ipady 0 -padx {20 1}
    grid columnconfig $frObjc.f${nom} all -weight 1

    return
}


proc UpdateMolObjFeat {args} {
    global pgl Mol3dCou Obj3dCou Feat3dCou Feat3dCou2

    update
    if {$Obj3dCou eq ""}  {return}
    if {$Feat3dCou eq ""} {return}

    $Mol3dCou _mapfeat $Obj3dCou $Feat3dCou  0
    $Mol3dCou _mapfeat $Obj3dCou $Feat3dCou2 1
    $Mol3dCou _dellist $Obj3dCou
    $Mol3dCou _render  $Obj3dCou

    $pgl(wogl) postredisplay

    return
}


proc MetAJourFeaturesViandox {{n1 ""} {n2 ""} {op ""}} {
    global ListeTypesDeFeatures ListeFeat43d

    set Lt $ListeTypesDeFeatures
    set ListeFeat43d [linsert $Lt 0 "None"]
    update

    return $ListeFeat43d
}


proc UpdateMol3dObjets {n1 n2 op} {
    global ListeMol3dObjets Obj3dCou Mol3dCou
    set ListeMol3dObjets [[set $n1] _ListeObjets]
    set Obj3dCou ""

    return
}


proc RetourAlignement {} {
    global NomFenetreOrdali

    focus $NomFenetreOrdali
    puts "$NomFenetreOrdali [winfo toplevel $NomFenetreOrdali]"
    #    raise [winfo toplevel $NomFenetreOrdali]
    raise .

    update idletasks

    return
}


proc AfficheFenetreOpengl {} {
    global OrdEtcDir pgl

    if {"FontOg" ni [font names]} {font create FontOg -family Helvetica -size 10 -weight normal}
    if {"FontOgTitle" ni [font names]} {font create FontOgTitle -family Helvetica -size 10 -weight bold}

    toplevel .lulu
    wm title .lulu $pgl(appName)
    wm protocol .lulu WM_DELETE_WINDOW KillParLaCroix

    .lulu configure -background black

    set frBann [frame .lulu.f1 -bg black -bd 0 -relief flat -highlightthickness 0]
    set frCtrl [frame .lulu.f2 -bg black -bd 0 -relief flat -highlightthickness 0]
    set frObjc [frame .lulu.f3 -bg black -bd 0 -relief flat -highlightthickness 0]
    set frTogl [frame .lulu.f4 -bg black -bd 0 -relief flat -highlightthickness 0]
    set frFonc [frame .lulu.f5 -bg black -bd 0 -relief flat -highlightthickness 0]
    
    set pgl(frBann) $frBann
    set pgl(frCtrl) $frCtrl
    set pgl(frTogl) $frTogl
    set pgl(frObjc) $frObjc
    set pgl(frFonc) $frFonc

    # frame Banniere
    set fmacsim [file join $OrdEtcDir "MACSIM_30px_cut_transparent.gif"]
    image create photo macsim
    #    macsim read $fmacsim -shrink
    macsim read $fmacsim
    label $frBann.imgm \
	    -image macsim -anchor w \
	    -bd 0 -bg black -padx 30 -pady 10

    set ftitre [file join $OrdEtcDir "ordalieToutePetite.gif"]
    image create photo titre
    #    titre read $ftitre -shrink
    titre read $ftitre
    label $frBann.imgt \
	    -image titre -anchor n \
	    -bd 0 -bg black -padx 10

    label $frBann.txt \
	    -anchor w \
	    -bd 0 -highlightthickness 0 \
	    -bg black -fg magenta \
	    -textvariable pgl(TextOgl)

    button $frBann.ral \
	    -text "Back to\nalignment" \
	    -bg cyan \
	    -command [list RetourAlignement]

    #    canvas $frBann.c -bg black -highlightthickness 0

    grid $frBann.imgm -row 0 -column 0 -padx {20 10}
    grid $frBann.imgt -row 0 -column 1 -sticky w
    grid $frBann.ral  -row 0 -column 2 -sticky e -padx 10 -pady 10
    #    grid $frBann.c    -row 0 -column 2 -padx 10
    grid $frBann.txt  -row 1 -column 0 -columnspan 3 -sticky w -pady {5 10} -padx 20
    grid columnconfig $frBann 1 -weight 1
    #    DessineUneMontre $frBann.c
    set pgl(TextOgl) "Ordalie Structure Visualizer"

    # frame Control
    global Mol3dCou Obj3dCou Feat3dCou
    global ListeTypesDeFeatures ListeFeat43d

    set Mol3dCou ""
    set Obj3dCou ""
    set Feat3dCou "None"
    set ListeFeat43d [MetAJourFeaturesViandox]

#    trace add variable ListeTypesDeFeatures write MetAJourFeaturesViandox

    global StrucAVoir Liste3dMol
    foreach e $StrucAVoir {
	lappend Liste3dMol $e
    }

    frame $frCtrl.f1 -bd 0 -highlightthickness 0 -relief flat -bg black
    label $frCtrl.f1.txt1 \
	    -relief flat -bd 0 \
	    -bg black -fg white \
	    -text "Molecule :" \
	    -anchor w -justify left \
	    -highlightthickness 0

    combobox $frCtrl.f1.co1 \
	    -background black \
	    -foreground white \
	    -width 6 \
	    -editable false \
	    -textvariable Mol3dCou \
	    -listvar Liste3dMol
    grid $frCtrl.f1.txt1 -row 0 -column 0 -sticky ""
    grid $frCtrl.f1.co1  -row 0 -column 1 -sticky ew
#    trace add variable Mol3dCou write UpdateMol3dObjets
    
    frame $frCtrl.f2 -bd 0 -highlightthickness 0 -relief flat -bg black
    label $frCtrl.f2.txt2 \
	    -anchor e -bg black -fg white \
	    -text "Objet :" \
	    -relief flat -bd 0 \
	    -anchor w -justify left \
	    -highlightthickness 0
    global ListeMol3dObjets
    combobox $frCtrl.f2.co2 \
	    -background black -foreground white \
	    -width 6 \
	    -editable false \
	    -textvariable Obj3dCou \
	    -listvar ListeMol3dObjets
    grid $frCtrl.f2.txt2 -row 0 -column 0 -sticky ""
    grid $frCtrl.f2.co2  -row 0 -column 1 -sticky ew

    frame $frCtrl.f3 -bd 0 -highlightthickness 0 -relief flat -bg black
    label $frCtrl.f3.txt3 \
	    -bg black -fg white \
	    -text "Feature 1 :" \
	    -anchor w -justify left \
	    -highlightthickness 0
    combobox $frCtrl.f3.co3 \
	    -background black -foreground white \
	    -width 6 \
	    -editable false \
	    -textvariable Feat3dCou \
	    -command [list UpdateMolObjFeat] \
	    -listvar ListeFeat43d
    grid $frCtrl.f3.txt3 -row 0 -column 0 -sticky ""
    grid $frCtrl.f3.co3  -row 0 -column 1 -sticky ew
    bind $frCtrl.f3.co3 <<ComboboxSelected>> [list UpdateMolObjFeat]

    frame $frCtrl.f4 -bd 0 -highlightthickness 0 -relief flat -bg black
    label $frCtrl.f4.txt4 \
	    -bg black -fg white \
	    -anchor w -justify left \
	    -highlightthickness 0 \
	    -text "Feature 2 :"
    combobox $frCtrl.f4.co4 \
	    -background black -foreground white \
	    -width 6 \
	    -editable false \
	    -textvariable Feat3dCou2 \
	    -command [list UpdateMolObjFeat] \
	    -listvar ListeFeat43d
    grid $frCtrl.f4.txt4 -row 0 -column 0 -sticky ""
    grid $frCtrl.f4.co4  -row 0 -column 1 -sticky ew
    bind $frCtrl.f4.co4 <<ComboboxSelected>> [list UpdateMolObjFeat]

    grid $frCtrl.f1 -row 0 -column 0 \
	    -sticky w -padx 20
    grid $frCtrl.f2 -row 0 -column 1 \
	    -sticky "" -padx 20
    grid $frCtrl.f3 -row 0 -column 2 \
	    -sticky "" -padx 20
    grid $frCtrl.f4 -row 0 -column 3 \
	    -sticky e -padx 20
    grid columnconfig $frCtrl all -weight 1

    # frame OpenGL
    # Fenetre Togl
    togl $frTogl.c \
	    -width $pgl(width) -height $pgl(height) \
	    -double true \
	    -depth true \
	    -reshapeproc [list Togl_ReshapeFonct] \
	    -createproc  [list Togl_CreateFonct] \
	    -displayproc [list Togl_DisplayFonct]
    grid $frTogl.c -row 0 -column 0 -sticky news

    # Frame Fonctions
    button $frFonc.ci -text "\u2022Clear Ids" \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -highlightthickness 0 -anchor w \
	    -command [list ClearIds]

    button $frFonc.ca -text "\u2022Clear All" \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -highlightthickness 0 -anchor w \
	    -command {ClearIDs}

    set pgl(BoutonCenter) "$frFonc.ct"
    button $frFonc.ct -text "\u2022Center On Atom" \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -highlightthickness 0 -anchor w \
	    -command [list CentreOnAtome $frFonc.ct]

    button $frFonc.pr -text "\u2022Print" \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -highlightthickness 0 -anchor w \
	    -command {FaitTracage ribbon}

    button $frFonc.fs -text "\u2022Full Screen" \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -highlightthickness 0 -anchor w \
	    -command {ToggleWindowMode}

    button $frFonc.st -text "\u2022Stereo" \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -bd 0 -relief flat \
	    -highlightthickness 0 -anchor w \
	    -command [list NYI]

    button $frFonc.cl -text "\u2022Close" \
	    -bg forestgreen -fg white \
	    -activeforeground red \
	    -activebackground forestgreen \
	    -highlightthickness 0 -anchor w \
	    -command [list QuitteViandox]

    grid $frFonc.ci -row 0 -column 0 -pady 0 -sticky nwe
    grid $frFonc.ca -row 1 -column 0 -pady 0 -sticky nwe
    grid $frFonc.ct -row 2 -column 0 -pady 0 -sticky nwe
    grid $frFonc.pr -row 3 -column 0 -pady 0 -sticky nwe
    grid $frFonc.fs -row 4 -column 0 -pady 0 -sticky nwe
    grid $frFonc.st -row 5 -column 0 -pady 0 -sticky nwe
    grid $frFonc.cl -row 6 -column 0 -pady 20 -sticky swe
    grid rowconfig $frFonc 6 -weight 1

    # Frame Objects
    frame $frObjc.onoff -bg black -relief flat -bd 0 -highlightthickness 0

    button $frObjc.onoff.allon \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -text "All On" \
	    -font FontOg \
	    -bd 0 -highlightthickness 0 \
	    -anchor w -justify left \
	    -padx 0 -relief flat \
	    -command [list TousObjetsOn]

    button $frObjc.onoff.alloff \
	    -bg black -fg cyan \
	    -activeforeground yellow \
	    -activebackground black \
	    -font FontOg \
	    -text "All Off" \
	    -anchor e -justify right \
	    -padx 0 -relief flat \
	    -bd 0 -highlightthickness 0 \
	    -command [list TousObjetsOff]

    grid $frObjc.onoff.allon  -row 0 -column 0 -sticky w -ipadx 10
    grid $frObjc.onoff.alloff -row 0 -column 1 -sticky e -ipadx 10
    grid columnconfig $frObjc.onoff all -weight 1
    grid $frObjc.onoff -row 0 -column 0 -sticky we -pady 0 -ipady 0 -padx {20 1}

    grid columnconfig $frObjc 0 -weight 1

    # Grille Generale
    grid $frBann -row 0 -column 0 -columnspan 3 -sticky ew
    grid $frCtrl -row 1 -column 0 -columnspan 3 -sticky ew
    grid $frObjc -row 2 -column 0 -sticky news -pady 15
    grid $frTogl -row 2 -column 1 -sticky news -pady 15
    grid $frFonc -row 2 -column 2 -sticky news -pady 15

    grid rowconfigure .lulu 2 -weight 1
    grid columnconfig .lulu {0 1} -weight 1

    set pgl(wogl) "$frTogl.c"

    # Init de ArcBall
    #    ResetRotations
    Arcball

    bind $frTogl.c <Control-1> {PickAtom   %x %y %W}
    #    bind $frFonc.c.c <Shift-1>   {CenterAtom %x %y %W}

    bind $frTogl.c <1>         "LClick %x %y"
    #    bind $frFonc.c.c <1>         "InitArcBall %W %x %y"
    #bind $frFonc.c.c <B1-Motion> "DragArcBall %W %x %y"
    #bind $frFonc.c.c <B1-Motion> "Mouse ArcBall %x %y %W"
    bind $frTogl.c <B1-Motion> "LDrag %x %y %W"

    #    bind $frFonc.c.c <1> {set cx %x; set cy %y}
    bind $frTogl.c <2> {set cx %x; set cy %y}
    bind $frTogl.c <3> {set cx %x; set cy %y}

    #    bind $frFonc.c.c <B1-Motion> {Mouse RotXY %x %y %W}
    bind $frTogl.c <B3-Motion> {Mouse TraXY %x %y %W}

    bind $frTogl.c <4> {HandleZoom  0.05 %W}
    bind $frTogl.c <5> {HandleZoom -0.05 %W}

    #    bind $frfonc.c.c <B2-Motion> [list Togl_Translation %x %y %W]
    #    bind $frfonc.c.c <B3-Motion> [list Togl_Grossation %x %y %W]

    bind .lulu <Escape> {AdieuOrdali}
    bind .lulu <Key-F1> [list ToggleWindowMode]
    bind .lulu <Key-F2> [list ToggleShowFrame]

#    FenetreAuCentre .lulu

    update idletasks

    return
}


proc SProut {} {
    global pgl
    global LesVecs
    global Rad
    global mol
    global ListePDB

    set ListePDB {}

    package require tcl3d
    #    package require tcl3dogl
    #    package require tcl3dtogl

    set LesVecs {}
    #    set mol "1c0a"
    set mol "1ile"
    #    set mol "1a11"
    #    set mol "1a2l"

    CalculeRibbon $mol
    Initialisation

    set pgl(xCen) $pgl(xc)
    set pgl(yCen) $pgl(yc)
    set pgl(zCen) $pgl(zc)

    AfficheFenetreOpengl

    return
}


proc FaitTracage {what} {
    global TypeRep DListCou pgl TSList Rad RadMol Rc LesVecs mol

    set TypeRep $what
    set w $pgl(wogl)

    if {[info exists TSList($what)]} {
	set DListCou [set TSList($what)]
	set Rad [set Rc($what)]
    } else {
	switch $what {
	    "ribbon" {
		if {$LesVecs == {} } {return}
		set TSList($what) [glGenLists 1]
		set DListCou [set TSList($what)]
		glNewList [set TSList($what)] GL_COMPILE

		use_light

		glBegin GL_TRIANGLES

		set k 0
		foreach {v1 v2 v3} $LesVecs {
		    glNormal3fv $v1
		    light_color3f {*}$v2
		    glVertex3fv $v3
		    if {$k < 3} {
			puts [format "v1 %8.3f %8.3f %8.3f" {*}$v1]
			puts [format "v3 %8.3f %8.3f %8.3f" {*}$v3]
			puts ""
			incr k
		    }
		}
		glEnd
		set Rad $RadMol
		set Rc($what) $RadMol
	    }
	    "stick" {
		set TSList($what) [glGenLists 1]
		set DListCou [set TSList($what)]
		glNewList [set TSList($what)] GL_COMPILE

		CalculeStick [set TSList($what)] $mol
		set Rad $RadMol
		set Rc($what) $RadMol
	    }
	    "fildefer" {
		set TSList($what) [glGenLists 1]
		set DListCou [set TSList($what)]
		glNewList [set TSList($what)] GL_COMPILE

		CalculeFilDeFer [set TSList($what)] $mol
		set Rad $RadMol
		set Rc($what) $RadMol
	    }
	    "benjilamalice" {
		use_light

		set pgl(xCen) 0.0
		set pgl(yCen) 0.0
		set pgl(zCen) 0.0

		set Rc($what) 2.
		set Rad 2.
		set TSList($what) [glGenLists 1]
		set DListCou [set TSList($what)]
		glNewList [set TSList($what)] GL_COMPILE_AND_EXECUTE

		BenjiLaMalice trace
		puts "j'ai fait la benji experience !"
	    }
	}

	glEndList
    }

    set ratio     $pgl(ratio)
    set zoom      $pgl(zoom)
    set imgRad    $Rad
    set frontclip [expr {-1.1*$Rad}]
    set backclip  [expr { 1.1*$Rad}]
    set pgl(frontclip) $frontclip
    set pgl(backclip)  $backclip

    glMatrixMode GL_PROJECTION
    glLoadIdentity

    glOrtho [expr {-1.0*$zoom*$ratio*$imgRad}] \
	    [expr {     $ratio*$zoom*$imgRad}] \
	    [expr {-1.0*$zoom*$imgRad}] \
	    [expr {     $zoom*$imgRad}] \
	    $frontclip \
	    $backclip

    glMatrixMode GL_MODELVIEW

    glFogf GL_FOG_START 1.0
    glFogf GL_FOG_END   [expr {abs($backclip-$frontclip)}]

    $w postredisplay

    return
}


proc ColorieMol3dSelonFeatures {f} {
    global StrucAVoir TabSF ListePDB
    global pgl Mol3dCou Obj3dCou Feat3dCou Feat3dCou2

    AfficheDansViandox

    set Feat3dCou $f
    foreach mold $StrucAVoir {
	set nom [DonneIdDeAccessPDB $mold]
	set chn [DonneChainDeAccessPDB $mold]

	set Obj3dCou "CA${nom}${chn}"	
	set Mol3dCou $nom

	UpdateMolObjFeat
    }

    return
}

proc light_color3fv {a} {
    lappend a 1.0
    glMaterialfv GL_FRONT_AND_BACK GL_AMBIENT_AND_DIFFUSE $a
    glMaterialfv GL_FRONT_AND_BACK GL_SPECULAR [list 1.0 1.0 1.0 1.0]
    glMaterialfv GL_FRONT_AND_BACK GL_EMISSION [list 0.0 0.0 0.0 1.0]
    glMaterialfv GL_FRONT_AND_BACK GL_SHININESS 128.

    return
}


proc CenterVec {} {
    set f [open "check.vec" r]
    set l [read -nonewline $f]
    close $f
    set Ll [split $l \n]

    set cxm  999. ; set cym  999. ; set czm  999.
    set cxx -999. ; set cyx -999. ; set czx -999.
    foreach {c1 c2 c3} $Ll {
	# c1 is the normal
	# c2 is the color
	# c3 is the vertex
	lassign $c3 cx cy cz
	set cxm [expr {min($cxm,$cx)}]
	set cym [expr {min($cym,$cy)}]
	set czm [expr {min($czm,$cz)}]
	set cxx [expr {max($cxx,$cx)}]
	set cyx [expr {max($cyx,$cy)}]
	set czx [expr {max($czx,$cz)}]
    }

    set cx [expr {($cxx+$cxm)/2.}]
    set cy [expr {($cyx+$cym)/2.}]
    set cz [expr {($czx+$czm)/2.}]

    set rad [expr {sqrt(($cxx-$cxm)**2 + ($cyx-$cym)**2 + ($czx-$czm)**2)}]

    return [list $cx $cy $cz $rad]
}


proc CheckNormals {quoi} {
    global OOn

    if {! [set OOn($quoi)]} {return}

    if {[info exists "::L$quoi"]} {
        glCallList [set ::L$quoi]
    } else {
	set f [open "check.vec" r]
	set l [read -nonewline $f]
	close $f
	set Ll [split $l \n]

	if {$quoi eq "check"} {
	    set ::L$quoi [glGenLists 1]
	    glNewList [set "::L$quoi"] GL_COMPILE
	    
	    foreach {a1 a2 a3 b1 b2 b3 c1 c2 c3} $Ll {
		#x1 is the NORMAL vector
		#x2 is the COLOR
		#x3 is the VERTEX vector
		#
		# a, b, c constitue the triangle
		
		# triangle
		glBegin GL_LINES
		glVertex3fv $a3
		glVertex3fv $b3
		glEnd
		
		glBegin GL_LINES
		glVertex3fv $b3
		glVertex3fv $c3
		glEnd
		
		glBegin GL_LINES
		glVertex3fv $a3
		glVertex3fv $c3
		glEnd	
		
		# Normals
		set a1 [Rescale $a1 $a3]
		set b1 [Rescale $b1 $b3]
		set c1 [Rescale $c1 $c3]
		glBegin GL_LINES
		glVertex3fv $a3
		glVertex3fv $a1
		glEnd
		
		glBegin GL_LINES
		glVertex3fv $b3
		glVertex3fv $b1
		glEnd
		
		glBegin GL_LINES
		glVertex3fv $c3
		glVertex3fv $c1
		glEnd
	    }
	    
	    glEndList
	} else {
	    set ::L$quoi [glGenLists 1]
	    glNewList [set ::L$quoi] GL_COMPILE

	    glBegin GL_TRIANGLES
	    foreach {v1 v2 v3} $Ll {
		light_color3fv $v2
		
		glColor3fv  $v2
		glNormal3fv $v1
		glVertex3fv $v3
	    }
	    glEnd
	    glEndList
	}

    }

    return
}

    
proc Rescale {a1 a3} {
    lassign $a1 nx ny nz
    lassign $a3 vx vy vz

    set rx [expr {$vx+2.*$nx}]
    set ry [expr {$vy+2.*$ny}]
    set rz [expr {$vz+2.*$nz}]

    return [list $rx $ry $rz]
}

###############################
###############################

package require tcl3d
package require combobox
namespace import combobox::*
source ordali_arcball.tcl
source vecteurs.tcl
set OrdEtcDir .
set StrucAVoir 1ile
set mold 1ile_A
set nom 1ile
set chn A
set Defauts(Label3DColor) green
set ListeTypesDeFeatures {}
set OOn(ribbon) 1
set OOn(check)  1


AfficheDansViandox

