

proc IsScalar_V V {
    return [expr {[llength $V]==1}]
}

proc Nice_V {V {Format "%6.2f"} {Baratin ""}} {
    if {$Baratin=="" && ! [regexp {^\%} $Format]} {
	set Baratin $Format
	set Format ""
    }
    if {$Format==""} { set Format "%6.2f" }

    if {$Baratin==""} {
	set Nice ""
    } else {
	set Nice "$Baratin\n"
    }

    foreach x $V {
	append Nice [format "$Format" $x] 
    }
    return $Nice
}

proc T_V {aT V {StartIndex 0}} {
    upvar $aT T
    set I $StartIndex
    foreach X $V {
	set T($I) $X
	incr I
    }
}

proc V_T aT {
    upvar $aT T

    set Zero 0
    foreach Bornes [array names T] {
	set I "undefined"
	scan $Bornes "%d" I
	if {$I=="undefined"} { continue }
	set Valeur [set T($Bornes)]
	if {[regexp "\." $Valeur]} { set Zero 0.0 }
	set BonT($I) $Valeur
	lappend LesIs $I
    }
    set LesIs [lsort $LesIs]
    set DebI [lindex $LesIs 0]
    set FinI [lindex $LesIs end]
    set V {}
    for {set I $DebI} {$I<=$FinI} {incr I} {
	if {[info exists BonT($I)]} {
	    lappend V [set BonT($I)]
	} else {
	    lappend V $Zero
	}
    }
    return $V
}

proc V_create args {
    return $args
}

proc S_fromV {V i} {
    return [lindex $V $i]
}

proc V_Vwithout {V i} {
    return [lreplace $V $i $i]
}

proc V_fromV {V d f} {
    return [lrange $V $d $f]    
}

proc V_unit {{i 0} {n 3} {Valeur 1.0}} {
    set V {}
    set Zero [expr $Valeur - $Valeur]
    for {set j 0} {$j<$n} {incr j} {
	if {$i!=$j} {
	    lappend V $Zero
	} else {
	    lappend V $Valeur
	}
    }
    return $V
}

proc Vectoriel {u v} {
    set xu [xTriplet $u]
    set yu [yTriplet $u]
    set zu [zTriplet $u]
    set xv [xTriplet $v]
    set yv [yTriplet $v]
    set zv [zTriplet $v]

    set xw [expr {$yu*$zv - $zu*$yv}]
    set yw [expr {$zu*$xv - $xu*$zv}]
    set zw [expr {$xu*$yv - $yu*$xv}]

    return [Triplet $xw $yw $zw]
}

#lm Prdt Vectoriel definit pour 3d.
#lm On va plus vite ....
proc Vectoriel {u v} {
    lassign $u xu yu zu
    lassign $v xv yv zv

    set xw [expr {$yu*$zv - $zu*$yv}]
    set yw [expr {$zu*$xv - $xu*$zv}]
    set zw [expr {$xu*$yv - $yu*$xv}]

    return [list $xw $yw $zw]
}

proc Scalaire {u v} {
    set s [expr {[S_nV $u]*[S_nV $v]/[S_VV $u "*" $v]}]

    return $s
}

proc V_lVV {s opu u op t opv v} {
    set w {}
    foreach e $u f $v {
	lappend $w [expr ($s $opu $e) $op ($t $opv $f)]
    }
    return $w
}

proc V_VV {u op v} {
    set w {}
    foreach e $u f $v {
	lappend w [expr $e $op $f]
    }
    return $w
}

proc V_VV {u op v} {
    set w {}
    switch $op {
	"+" {
	    foreach e $u f $v {
		lappend w [expr {$e + $f}]
	    }
	}
	"-" {
	    foreach e $u f $v {
		lappend w [expr {$e - $f}]
	    }
	}
	"*" {
	    foreach e $u f $v {
		lappend w [expr {$e * $f}]
	    }
	}
	"/" {
	    foreach e $u f $v {
		lappend w [expr {$e / $f}]
	    }
	}
    }

    return $w
}

proc V_VS {u op s} {
    set w {}
    switch $op {
	"+" {
	    foreach e $u {lappend w [expr {$e+$s}]}
	}
	"-" {
	    foreach e $u {lappend w [expr {$e-$s}]}
	}
	"*" {	    
	    foreach e $u {lappend w [expr {$e*$s}]}
	}
	"/" {
	    foreach e $u {lappend w [expr {$e/$s}]}
	}
    }

    return $w
}

proc V_SV {s op u} {
    set w {}
    foreach f $u {
	lappend w [expr $s $op $f]
    }
    return $w
}

proc V_SV {s op u} {
    set w {}
    switch $op {
	"+" {
	    foreach e $u {lappend w [expr {$e+$s}]}
	}
	"-" {
	    foreach e $u {lappend w [expr {$e-$s}]}
	}
	"*" {	    
	    foreach e $u {lappend w [expr {$e*$s}]}
	}
	"/" {
	    foreach e $u {lappend w [expr {$e/$s}]}
	}
    }

    return $w
}

proc S_VV {u op v {Init 0}} {
    set w $Init
    switch $op {
	"+" {
	    foreach e $u f $v {
		set w [expr {$w + ($e + $f)}]
	    }
	}
	"-" {
	    foreach e $u f $v {
		set w [expr {$w + ($e-$f)}]
	    }
	}
	"*" {
	    foreach e $u f $v {
		set w [expr {$w + ($e * $f)}]
	    }
	}
	"/" {
	    foreach e $u f $v {
		set w [expr {$w + ($e/$f)}]
	    }
	}
    }
    
    return $w
}

proc S_nV u {
    return [expr {sqrt([S_VV $u * $u])}]
}

proc V_nV u {
    set N [S_nV $u]
    if {$N<1.e-20} {
	return [V_VS $u * 0]
    }
    return [V_VS $u / $N]
}






