proc mapToSphere {x y} {
    global pgl

    set px [expr {($x * (1./(($pgl(width)-1.)*0.5)))-1.}]
    set py [expr {1.-($y * (1./(($pgl(height)-1.)*0.5)))}]
    set l [expr {$px*$px + $py*$py}]
    if {$l > 1.} {
	set norm [expr {1./sqrt($l)}]
	set px [expr {$px*$norm}]
	set py [expr {$py*$norm}]
	set pz 0.0
    } else {
	set pz [expr {sqrt(1.-$l)}]
    }

    return [list $px $py $pz]
}


proc Arcball {} {
    global deb fin OldRot LaRot QuatOri
    global isClicked isDragging TransformAO

    set deb [list 0.0 0.0 0.0]
    set fin [list 0.0 0.0 0.0]
    set OldRot [list 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0]
    set LaRot [list 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0]
    set TransformAO [list 1.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 1.0]

    set isClicked 0
    set isDragging 0

    return
}

proc Click {x y} {
    global deb

    set deb [mapToSphere $x $y]

    return
}

proc Drag {x y} {
    global deb fin rot

    set fin [mapToSphere $x $y]

    set axe [Vectoriel $deb $fin]

    if {[S_nV $axe] > 1.0e-5} {
	set qx [lindex $axe 0]
	set qy [lindex $axe 1]
	set qz [lindex $axe 2]
	set qw [Scalaire $deb $fin]
    } else {
	set qx 0.0
	set qy 0.0
	set qz 0.0
	set qw 0.0
    }

    return [list $qx $qy $qz $qw]
}


proc LClick {x y} {
    global LaRot OldRot isDragging

    set OldRot $LaRot
    set isDragging 1
    Click $x $y

    return
}


proc LDrag {x y w} {
    global QuatOri LaRot OldRot TransformAO

    set QuatOri [Drag $x $y]
    set LaRot [Quat2Mat $QuatOri]
    #    set LaRot [MatMul $LaRot $OldRot]
    set LaRot [MatMul $OldRot $LaRot]
    set TransformAO [Mat32Mat4 $TransformAO $LaRot]
    #    set TransformAO [Transpose $TransformAO]

    #    puts [format "%6.3f %6.3f %6.3f %6.3f" {*}[lrange $TransformAO 0 3]]
    #    puts [format "%6.3f %6.3f %6.3f %6.3f" {*}[lrange $TransformAO 4 7]]
    #    puts [format "%6.3f %6.3f %6.3f %6.3f" {*}[lrange $TransformAO 8 11]]
    #    puts [format "%6.3f %6.3f %6.3f %6.3f" {*}[lrange $TransformAO 12 15]]
    #    puts ""

    $w postredisplay

    return
}


proc Quat2Mat {q} {
    lassign $q qX qY qZ qW

    set n [expr {$qX*$qX + $qY*$qY + $qZ*$qZ + $qW*$qW}]
    set s [expr {$n > 0 ? (2.0/$n) : 0.}]

    set xs [expr {$qX * $s}]
    set ys [expr {$qY * $s}]
    set zs [expr {$qZ * $s}]
    set wx [expr {$qW * $xs}]
    set wy [expr {$qW * $ys}]
    set wz [expr {$qW * $zs}]
    set xx [expr {$qX * $xs}]
    set xy [expr {$qX * $ys}]
    set xz [expr {$qX * $zs}]
    set yy [expr {$qY * $ys}]
    set yz [expr {$qY * $zs}]
    set zz [expr {$qZ * $zs}]

    set nXX [expr {1.0 - ($yy + $zz)}]
    set nYX [expr {       $xy - $wz}]
    set nZX [expr {       $xz + $wy}]
    set nXY [expr {       $xy + $wz}]
    set nYY [expr {1.0 - ($xx + $zz)}]
    set nZY [expr {       $yz - $wx}]
    set nXZ [expr {       $xz - $wy}]
    set nYZ [expr {       $yz + $wx}]
    set nZZ [expr {1.0 - ($xx + $yy)}]

    set n [list $nXX $nYX $nZX $nXY $nYY $nZY $nXZ $nYZ $nZZ]
    #    set n [list $nXX $nXY $nXZ $nYX $nYY $nYZ $nZX $nZY $nZZ]

    return $n
}


proc Mat32Mat4 {m1 m2} {

    set s 0.
    foreach e {0 1 2 4 5 6 8 9 10} {
	set s [expr {$s + [lindex $m1 $e]*[lindex $m1 $e]}]
    }
    set s [expr {sqrt($s/3.)}]

    foreach e {0 1 2 4 5 6 8 9 10} f $m2 {
	lset m1 $e $f
    }

    foreach e {0 1 2 4 5 6 8 9 10} {
	lset m1 $e [expr {[lindex $m1 $e] * $s}]
    }

    return $m1
}


proc MatMul {a b} {
    lassign $a a00 a01 a02 a10 a11 a12 a20 a21 a22
    lassign $b b00 b01 b02 b10 b11 b12 b20 b21 b22

    set m00 [expr {($a00 * $b00) + ($a01 * $b10) + ($a02 * $b20)}]
    set m01 [expr {($a00 * $b01) + ($a01 * $b11) + ($a02 * $b21)}]
    set m02 [expr {($a00 * $b02) + ($a01 * $b12) + ($a02 * $b22)}]

    set m10 [expr {($a10 * $b00) + ($a11 * $b10) + ($a12 * $b20)}]
    set m11 [expr {($a10 * $b01) + ($a11 * $b11) + ($a12 * $b21)}]
    set m12 [expr {($a10 * $b02) + ($a11 * $b12) + ($a12 * $b22)}]

    set m20 [expr {($a20 * $b00) + ($a21 * $b10) + ($a22 * $b20)}]
    set m21 [expr {($a20 * $b01) + ($a21 * $b11) + ($a22 * $b21)}]
    set m22 [expr {($a20 * $b02) + ($a21 * $b12) + ($a22 * $b22)}]

    set m [list $m00 $m01 $m02 $m10 $m11 $m12 $m20 $m21 $m22]

    return $m
}


proc Transpose m {
    for {set i 0} {$i < 4} {incr i} {
	for {set j 0} {$j < 16} {incr j 4} {
	    lappend n [lindex $m [expr {$i+$j}]]
	}
    }

    return $n

    set c 0
    set fmt "%5.3f %5.3f %5.3f %5.3f | %5.3f %5.3f %5.3f %5.3f"
    for {set i 0} {$i < 16} {incr i 4} {
	puts [format $fmt {*}[lrange $m $i [expr {$i+3}]] {*}[lrange $n $i [expr {$i+3}]]]
    }
    puts ""

    return $n
}






