#!/usr/local/bin/wish

set DefTags "\>Protein
I white magenta
L white magenta
M white magenta
V white magenta
ILMV white magenta
R white blue
K white blue
RK white blue
F white red
Y white red
W white red
FYW white red
D white forestgreen
E white forestgreen
DE white forestgreen
Q black green
P white black
G black orange
H black cyan
N black cyan
HN black cyan
S white darkviolet
T white darkviolet
A white darkviolet
C white darkviolet
STAC white darkviolet
SPC black DimGray
"

proc Data {{n 100} {l 1000}} {
    set ll [list A C D E F G H I K L M N P Q R S T V W Y . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .]

    set Lseq [list]
    for {set s 0} {$s < $n} {incr s} {
        set seq ""
        for {set i 0} {$i < $l} {incr i} {
            append seq "[lindex $ll [expr {int(50*rand())}]]"
        }
        lappend Lseq $seq
    }

    return $Lseq
}

proc LesLignesDuFichier {f} {
    return [split [ContenuDuFichier $f] \n]
}

proc ContenuDuFichier {f} {
    set c [open $f r]
    set r [read -nonewline $c]
    close $c

    return $r
}

proc LitLeTFA {file aNom aSeq} {
    upvar $aNom Nom
    upvar $aSeq Seq

    set Lignes [LesLignesDuFichier $file]
    lappend Lignes ">"
    set n 0
    set laseq ""
    foreach l $Lignes {
	set l [string trim $l]
	if {$l eq ""} {continue}
	if {[string index $l 0] eq ">"} {
	    if {$laseq ne ""} {
		set laseq [string map [list " " "" "-" "." "\n" ""] $laseq]
		lappend Nom $lenom
		set Seq($lenom) $laseq
		set laseq ""
		incr n
	    }

	    set l [string trim [string range $l 1 end]]
	    set ib [string first " " $l]
	    if {$ib == -1} {
		set ib end
	    } else {
		incr ib -1
	    }
	    set lenom [string range $l 0 $ib]
	} else {
	    append laseq $l
	}
    }

    return $n
}

proc ConfTag {} {
    set Ll [split $::DefTags \n]
    foreach l [lrange $Ll 1 end] {
	lassign $l aa fg bg
	::.t tag configure Tag$aa -foreground $fg -background $bg
    }

    return
}

###########################

proc TagText3 {args} {
    set Lgaa  [list STAC DE ILMV FYW P RK Q G HN SPC]
    set Lfreg [list "S|T|A|C" "D|E" "I|L|M|V" "F|Y|W" "P" "R|K" "Q" "G" "H|N"]

    lassign [split [::.t index @0,0] .] ym xm
    set xx [expr {$xm+$::tw+1}]
    set yx [expr {$ym+$::th+1}]

    foreach a $Lgaa freg $Lfreg {
	::.t tag remove Tag$a 1.0 end
	set lt {}
	for {set y $ym} {$y <= $yx} {incr y} {
	    set yt [expr {$y-1}]
	    set t [string range [lindex $::Lseq $yt] $xm $xx]
	    set lv [regexp -all -inline -indices -- $freg $t]
	    foreach e $lv {
		lassign $e d f 
		lappend lt $y.[expr {$d+$xm}] $y.[expr {$f+$xm+1}]
	    }
	}
	if {$lt != {}} {::.t tag add Tag$a {*}$lt}
    }
    update idletasks

    return
}

proc CreateDisplay {Lseq} {
    global tw th

    set tw 60 ; set th 20
    text .t \
	    -font "Courier 12" \
	    -background DimGray \
	    -xscrollcommand ".sx set" \
	    -yscrollcommand ".sy set" \
	    -state normal \
	    -width $tw -height $th \
	    -wrap none \
	    -highlightthickness 0
    scrollbar .sx -orient horiz -command [list .t xview]
    scrollbar .sy -command ".t yview"
    
    grid .t  -row 0 -column 0 -sticky news
    grid .sy -row 0 -column 1 -sticky ns
    grid .sx -row 1 -column 0 -sticky ew
    
    update idletasks
    
    ConfTag
    .t insert end [join $Lseq \n]

    bind .sx <ButtonRelease-1> [list TagText3]
    bind .sy <ButtonRelease-1> [list TagText3]

    TagText3

    return
}

#--- Test:
set nseq 300
set lgs  5000

if {[llength $argv] > 0} {
    LitLeTFA $argv Noms Seqs
    foreach e [array names Seqs] {
	lappend Lseq [set Seqs($e)]
    }
    CreateDisplay $Lseq
} else {
    set Lseq [Data $nseq $lgs] 
    CreateDisplay $Lseq
}











