proc InitLesDefauts {} {
    global OrdaliDir OrdTmpDir OrdEtcDir OrdHlpDir OrdLibDir OrdBinDir OuiOuNonToujoursParDefaut GenomeOuCollection

    if {[info exists env(ORDALITMP)]} {
	set OrdTmpDir $env(ORDALITMP)
    } else {
	if {[info exists env(TEMP)]} {
	    set OrdTmpDir $env(TEMP)
	} elseif {[info exists env(TMP)]} {
	    set OrdTmpDir $env(TMP)
	} else {
	    set OrdTmpDir "."
	}
    }
    
    set OrdHlpDir [file join $OrdaliDir help]
    set OrdEtcDir [file join $OrdaliDir etc]
    set OrdBinDir [file join $OrdaliDir bin]
    
    set OuiOuNonToujoursParDefaut 0
    set GenomeOuCollection "Collection"

    LesDefauts

    return
}


proc LesDefauts {args} {
    global env OrdEtcDir Defauts

    if {[llength $args] == 2} {
	lassign $args Type Valeur 
	set Defauts($Type) $Valeur
	if {$Type == "Mode" && [string equal -nocase $Valeur "batch"]} {
	    global FaireLireNon
	    set FaireLireNon 1
	}

	return
    }

    set ::VueEditee 0
    ValsDesDefauts

    if {[UtiliseCCode]} {
	set Defauts(UseSpeedCode) "C"
    } else {
	set Defauts(UseSpeedCode) "tcl"
    }

    if {$args ne "OldDef"} {
	if {[file exists [file join $env(HOME) ".ordalierc"]]} {
	    source [file join $env(HOME) ".ordalierc"]
	} elseif {[file exists [file join $OrdEtcDir ".ordalierc"]]} {
	    source [file join $OrdEtcDir ".ordalierc"]
	}
    }

    if {$args eq "CreeDef"} {
	SauveOrdalieDefauts
    }

    InitComparaison
    InitChemicals
    InitHydroAA

    if {"Structure" ni [info commands]} {
	SetupPDBObject
    }
    ToggleAuLog $Defauts(LogAtStartup)

    return
}


proc ValsDesDefauts {} {
    global Defauts
    set Defauts(Mode)                Interactive
    set Defauts(InProject)           0
    set Defauts(Project)             ""
    set Defauts(dispmode)            "ordali"
    set Defauts(Devlpt)              0
    set Defauts(FirstPass)           1
    set Defauts(MacsimDone)          0

    set Defauts(ToggleAllSeqs)       1
    set Defauts(ToggleToolBar)       1
    set Defauts(ToggleFeature)       1
    set Defauts(ToggleScores)        0
    set Defauts(ToggleColRes)        0
    set Defauts(ToggleAuLog)         0

    set Defauts(NmMacCourant)        ""
    set Defauts(LogAtStartup)        0
    set Defauts(ShowFrame)           0
    set Defauts(FullScreen)          0
    set Defauts(TypeAli)             "pasdali"
    set Defauts(LongNom)             20
    set Defauts(NomsAffiches)        "seqname"
    set Defauts(PreCompute)          0
    set Defauts(PrecomputeSrf)       0
    set Defauts(CheckSeq)            0
    set Defauts(Poids)               0
    set Defauts(Poids2)              0
    set Defauts(Poids3)              0
    set Defauts(SelectionNom)        0
    set Defauts(SelectionLong)       0
    set Defauts(CutLong)             2
    set Defauts(TypeDeGroupesACreer) "User"
    set Defauts(FichierClu)          ""
    set Defauts(Run)                 0
    set Defauts(PDB)                 0
    set Defauts(PDBDansPilier)       1
    set Defauts(SeqAssocie)          0
    set Defauts(FichierMSF)          ""
    set Defauts(FichierRSF)          ""
    set Defauts(FichierTFA)          ""
    set Defauts(FichierXML)          ""
    set Defauts(FichierORD)          ""
    set Defauts(FichierOBK)          ""
    set Defauts(FichierALN)          ""
    set Defauts(FichierPDB)          ""
    set Defauts(FichierOMAC)         ""
    set Defauts(Visualize)           0
    set Defauts(ConsNGrp)            1
    set Defauts(AffSS)               1
    set Defauts(AffPhy)              0
    set Defauts(SphPts)              1
    set Defauts(RunScript)           0

    set Defauts(FgEukaryota)         black
    set Defauts(BgEukaryota)         PaleVioletRed1
    set Defauts(FgArchaea)           black
    set Defauts(BgArchaea)           LightBlue
    set Defauts(FgBacteria)          black
    set Defauts(BgBacteria)          LightYellow
    set Defauts(FgViruses)           white
    set Defauts(BgViruses)           black
    set Defauts(LifeDomains)         [list Eukaryota Archaea Bacteria Viruses]

    set Defauts(PrefixesBank)        {SPT SW PDB VARSPLIC UniRef90 PQS ENS sp unp tr}
    set Defauts(RemoveBankPrefix)    1

    set Defauts(Background)          "white"
    set Defauts(BackAppli)           "#ffffffffd0d0"
    set Defauts(BackAppliOri)        ""
    set Defauts(DeltaYScroll)        1

    set Defauts(PCThrGap)            0.5
    set Defauts(SeqFontFaml)         "Courier"
    set Defauts(SeqFontSize)         8
    set Defauts(SeqFontWght)         normal
    set Defauts(DeltaXScroll)        10
    set Defauts(Mapping)             [EditorMappingData]

    set Defauts(UrlPdbHoan)         "http://d1.crihan.fr:8080/bird/bsearch?db=pdb&accession=XXXX"
    set Defauts(UrlPdbHome)         "http://bird:8080/bird/bsearch?db=pdb&accession=XXXX"
    set Defauts(UrlPdbWorld)          "http://www.rcsb.org/pdb/cgi/export.cgi/XXXX.pdb?format=PDB&pdbId=XXXX&compression=None"
    set Defauts(UrlSRSHome)         "http://bips.u-strasbg.fr/srsbin/cgi-bin/wgetz?-e+\[\{sptrembl_SP_swissprot\}-acc:XXXX\]|\[swissprot-id:XXXX\]+-vn+2"
    set Defauts(UrlSRSWorld)         "http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-e+%5b%7bsptrembl_SP_swissprot%7d-acc:XXXX%5d%7c%5bswissprot-id:XXXX%5d+-vn+2"
    set Defauts(UrlSRSHoan)         "http://d1.crihan.fr:8080/bird/bsearch?db=YYYY&accession=XXXX"

    set Defauts(Threshold)           80
    set Defauts(ThresholdIden)       100
    set Defauts(MethodeOrdali)       "Threshold"
    set Defauts(SimiGris)            1

    set Defauts(LockSeqs)            1

    set Defauts(CanvasHTree)         2000
    set Defauts(CanvasWTree)         2000
    set Defauts(FWidthTree)          400
    set Defauts(FHeightTree)         400
    set Defauts(TreeBoot)            0
    set Defauts(TreeNBoot)           100
    set Defauts(ThresBootPC)         80
    set Defauts(TypeGapTree)         "pairwise"
    set Defauts(TypeTree)            "dendrogram"
    set Defauts(PDBTree)             0
    set Defauts(CollapseTree)        0
    set Defauts(FontSizeTree)        10
    set Defauts(FontSizeTreeBoot)    8
    set Defauts(FontWghtTree)        normal

    set Defauts(CanvasHSFeat)        2000
    set Defauts(CanvasWSFeat)        2000
    set Defauts(FWidthSFeat)         600
    set Defauts(FHeightSFeat)        400

    set i 0
    foreach c [GammeDeCouleursRVB 10] g [GammeDeCouleursDeGris 10] {
	set Defauts(GammeCoul$i) $c
	set Defauts(GammeGris$i) $g
	incr i
    }
    #    set Defauts(CoulVariable)        "ForestGreen"
    set Defauts(Sampling)            3
    set Defauts(CoulVariable)        "LightSlateGray"
    set Defauts(Viewer)              "Viandox"
    set Defauts(Label3DColor)        [list 0.0 1.0 0.0]

    set Defauts(MethodeSuper)        "ordali"
    set Defauts(Super)               "CA"
    set Defauts(DownloadPDB)         "internet"

    set Defauts(juju)                0
    set Defauts(SaveLog)             0
    set Defauts(clusdeb)             0
    set Defauts(Balibase)            0
    set Defauts(RemoveQuery)         0
    set Defauts(Dump)                0
    set Defauts(Exit)                0
    set Defauts(Debug)               0
    #set Defauts(UrlPdbHoan)         "http://star4:8080/bird/getproduct?db=pdb&id=XXXX"

    set Defauts(UserDef) [list \
	    Background \
	    BackAppli \
	    BackAppliOri \
	    SeqFontFaml \
	    SeqFontSize \
	    SeqFontWght \
	    DeltaXScroll \
	    DeltaYScroll \
	    UrlPdbHoan \
	    UrlPdbWorld \
	    UrlPdbHome \
	    UrlSRSHome \
	    UrlSRSWorld \
	    UrlSRSHoan \
	    Threshold \
	    MethodeOrdali \
	    TreeBoot \
	    TreeNBoot \
	    ThresBootPC \
	    TypeGapTree \
	    TypeTree \
	    PDBTree \
	    FontSizeTree \
	    FontWghtTree \
	    CoulVariable \
	    Label3DColor
    ]
    set Defauts(TablesDB) "
    - ordalie : parametres generaux d'ordalie {
	. key T (nom du parametre)
	. val T (valeur du parametre)
    }
    - seqinfo : les infos des sequences {
	. pk_seqinfo P
	. seqname T (nickname de sequence)
	. access T
	. bid T
	. description T
	. organism T
	. taxid I
	. fragment I
	. cgroup I
	. ec T
	. complex I
	. phylum T
	. go T
	. lineage T
	. hydrophobicity R
	. isoelectric R
	. seqori T
    }
    - seqfeat : les features des sequences {
	. pk_seqfeat P
	. ftype T (de feature (PFAM, secstr, ...))
	. fstart I
	. fstop I 
	. fcolor T
	. fscore R
	. fnote T
	. fcsys T (systeme coords, local ou global)
    }
    - ln_seqinfo_seqfeat : {
	. pk_seqinfo I
	. pk_seqfeat I
    }
    - seqali : une instance d'un seqinfo dans le contexte d'un alignement, et possede : {
	. pk_seqali P (pk pour chaque sequence)
	. pk_seqinfo I (de l'info de la sequence)
	. seqname T (nom affiche)
	. seq T (aminoacid + gap)
    }
    - mac : est un macsim  {
	. pk_mac P
	. name T
	. description T
    }
    - ln_mac_seqali {
	. pk_mac I
	. pk_seqali I
	. pos I
    }
    - featali : les features des sequences DANS LE CONTEXT DE L ALIGNEMENT {
	. pk_featali P
	. ftype T (de feature (PFAM, secstr, ...))
	. fstart I
	. fstop I 
	. fcolor T
	. fscore R
	. fnote T
	. fcsys T (systeme coords, local ou global)
    }
    - ln_seqali_featali : {
	. pk_seqali I
	. pk_featali I
    }
    - clustering : definition generale du clustering {
	. pk_clustering P
	. pk_mac I
	. name T
	. methode T
	. zone T
    }
    - cluster : sont les paquets de sequences d'un clustering donne. {
	. pk_cluster P
	. pk_clustering I
	. name T
    }
    - ln_seqali_cluster : {
	. pk_seqali I
	. pk_cluster I
	. pos
    }
    - ln_mac_clustering : {
	. pk_mac I
	. pk_clustering I
	. pos I
    }
    - colmeasure : un calcul par colonne {
	. pk_colmeasure P
	. name T
    }
    - ln_mac_colmeasure {
	. pk_mac I
	. pk_colmeasure I
    }
    - colscore : conservation {
	. pk_colscore P
	. pk_colmeasure I
	. name T
	. owner T
	. type T
	. data T
    }
    - ln_cluster_colscore {
	. pk_cluster I
	. pk_colscore I
    }
    - ln_seqali_colscore {
	. pk_seqali I
	- pk_colscore I
    }
    - anno : anotations d'un mac donne {
	. pk_anno P
	. annotation T
	. zone T
    }
    - ln_mac_anno {
	. pk_mac I
	. pk_anno I
    }
    - pdb : stockage des PDB {
	. pk_pdb P
	. nom T
	. source T
	. header T
    }
    - chaines : contient info sur chaines {
	. pk_chaines P
	. pk_pdb I
	. nom T
	. type T
    }
    - residues : residues de chaine {
	. pk_residues P
	. pk_pdb I
	. pk_chaines I
	. rnom1l T
	. rnom3l T
	. rnmr T
	. type T
    }
    - atomes : info sur atome. na = numero atomique {
	. pk_atomes P
	. pk_pdb I
	. pk_chaines I
	. pk_residues I	
	. anom T
	. x R
	. y R
	. z R
	. b R
	. q R
	. na I
    }
    - objetinit : template objet {
	. pk_obj P
	. pk_pdb I
	. pk_chaines I
	. pk_residues I
	. currsel I
	. surface I
	. ribbon I
	. ribcol T
	. catrace I
	. cacol T
	. atomes I
	. atmcol T
	. cpk I
	. pearl I
	. picked I
	. label T
    }
    "
    set Defauts(TablesDB1.1) "
    - ordalie : tableaux generaux d'ordalie {
	. var T (nom du tableau)
	. key T (nom du parametre)
	. val T (valeur du parametre)
    }
    - seqinfo : les infos des sequences {
	. pk_seqinfo P
	. seqname T (nickname de sequence)
	. access T
	. bid T
	. description T
	. organism T
	. taxid I
	. fragment I
	. cgroup I
	. ec T
	. complex I
	. phylum T
	. go T
	. lineage T
	. hydrophobicity R
	. isoelectric R
	. seqori T
    }
    - seqfeat : les features des sequences {
	. pk_seqfeat P
	. pk_seqinfo F
	. ftype T (de feature (PFAM, secstr, ...))
	. fstart I
	. fstop I 
	. fcolor T
	. fscore R
	. fnote T
	. fcsys T (systeme coords, local ou global)
    }
    - ln_seqinfo_seqfeat : {
	. pk_seqinfo I
	. pk_seqfeat I
    }
    - seqali : une instance d'un seqinfo dans le contexte d'un alignement, et possede : {
	. pk_seqali P (pk pour chaque sequence)
	. pk_seqinfo F (de l'info de la sequence)
	. pk_mac F
	. seqname T (nom affiche)
	. seq T (aminoacid + gap)
    }
    - mac : est un macsim  {
	. pk_mac P
	. name T
	. description T
    }
    - featali : les features des sequences DANS LE CONTEXT DE L ALIGNEMENT {
	. pk_featali P
	. pk_seqali F
	. ftype T (de feature (PFAM, secstr, ...))
	. fstart I
	. fstop I 
	. fcolor T
	. fscore R
	. fnote T
	. fcsys T (systeme coords, local ou global)
    }
    - clustering : definition generale du clustering {
	. pk_clustering P
	. pk_mac F
	. name T
	. methode T
	. zone T
    }
    - cluster : sont les paquets de sequences d'un clustering donne. {
	. pk_cluster P
	. pk_clustering F
	. name T
    }
    - ln_seqali_cluster : {
	. pk_seqali F
	. pk_cluster F
	. pos
    }
    - colmeasure : un calcul par colonne {
	. pk_colmeasure P
	. name T
	. method T
    }
    - ln_mac_colmeasure {
	. pk_mac F
	. pk_colmeasure F
    }
    - colscore : conservation {
	. pk_colscore P
	. pk_colmeasure I
	. name T
	. owner T
	. type T
	. data T
    }
    - ln_cluster_colscore {
	. pk_cluster F
	. pk_colscore F
    }
    - ln_seqali_colscore {
	. pk_seqali F
	- pk_colscore F
    }
    - anno : anotations d'un mac donne {
	. pk_anno P
	. pk_mac F
	. annotation T
	. zone T
    }
    - pdb : stockage des PDB {
	. pk_pdb P
	. nom T
	. source T
	. header T
    }
    - chaines : contient info sur chaines {
	. pk_chaines P
	. pk_pdb F
	. nom T
	. type T
    }
    - residues : residues de chaine {
	. pk_residues P
	. pk_pdb F
	. pk_chaines F
	. rnom1l T
	. rnom3l T
	. rnmr T
	. type T
    }
    - atomes : info sur atome. na = numero atomique {
	. pk_atomes P
	. pk_pdb F
	. pk_chaines F
	. pk_residues F	
	. anom T
	. x R
	. y R
	. z R
	. b R
	. q R
	. na I
    }
    - objetinit : template objet {
	. pk_obj P
	. pk_pdb F
	. pk_chaines F
	. pk_residues F
	. currsel I
	. surface I
	. ribbon I
	. ribcol T
	. catrace I
	. cacol T
	. atomes I
	. atmcol T
	. cpk I
	. pearl I
	. picked I
	. label T
    }
    "

    return
}


proc InitialiseCouleurs {} {
    global OrdEtcDir
    global Lookup_Couleurs

    set frgb [file join $OrdEtcDir "color_rgb.dat"]
    set fnms [file join $OrdEtcDir "color_names.dat"]

    set LesRGB [LesLignesDuFichier $frgb]
    set LesRGB [lrange $LesRGB 1 end]
    set LesRGB [string trim [join $LesRGB ""]]
    set LesRGB [split $LesRGB]

    set LesNms [LesLignesDuFichier $fnms]
    set LesNms [lrange $LesNms 1 end]
    set NbV    [expr {3*[llength $LesNms]}]

    foreach {r g b} $LesRGB lacol $LesNms {
	set lacol  [string trim $lacol]
	set lacolo [CouleurO2Ordali $lacol]

	set r [expr {int(floor($r * 255))}]
	set g [expr {int(floor($g * 255))}]
	set b [expr {int(floor($b * 255))}]

	set Lookup_Couleurs(${lacolo}) [list $r $g $b]
	set Lookup_Couleurs(${lacol})  [list $r $g $b]
    }

    return
}


proc DefinitionPreferences {} {
    global SeqChangeDansSeqlab Defauts SeqlabMode SphDef TypeCons TypeText Couleurs OrdEtcDir

    set SphDef "Mean"
    set SeqlabMode 0
    set SeqChangeDansSeqlab 0

    if {! [catch {package present Tk}]} {
	if {"SeqFont" ni [font names]} {
	    font create SeqFont -family [set Defauts(SeqFontFaml)] -size [set Defauts(SeqFontSize)] -weight [set Defauts(SeqFontWght)]
	}
	if {"EdtTitre" ni [font names]} {
	    font create EdtTitre {*}[font configure TkDefaultFont] -size 14 -weight bold
	}
	if {"EdtItem" ni [font names]} {
	    font create EdtItem {*}[font configure TkDefaultFont] -weight bold
	}
	if {"BtnFeatFont" ni [font names]} {
	    font create BtnFeatFont -family Helvetica -size 10 -weight normal
	}
    }

    if {! [info exists TypeCons]} {set TypeCons {} }

    set TypeText(IdenGlob)     "Global identity"
    set TypeText(ConsGlob)     "Global conservation"
    set TypeText(SimiGlob)     "Global similarity"
    set TypeText(IdenGrp1)     "Identity Group 1"
    set TypeText(IdenGrp2)     "Identity Group 2"
    set TypeText(IdenGrp3)     "Identity Group 3"
    set TypeText(IdenGrp1Gris) "Group 1 similarity"
    set TypeText(IdenGrp2Gris) "Group 2 similarity"
    set TypeText(IdenGrp3Gris) "Group 3 similarity"
    set TypeText(InterG12)     "Inter-group 1-2"
    set TypeText(InterG13)     "Inter-group 1-3"
    set TypeText(InterG23)     "Inter-group 2-3"
    set TypeText(InterG12Gris) "Inter-group 1-2 sim."
    set TypeText(InterG13Gris) "Inter-group 1-3 sim."
    set TypeText(InterG23Gris) "Inter-group 2-3 sim."
    set TypeText(PoinGrp1)     "Points group 1"
    set TypeText(PoinGrp2)     "Points group 2"
    set TypeText(PoinGrp3)     "Points group 3"

    lappend TypeCons IdenGlob
    lappend TypeCons ConsGlob
    lappend TypeCons SimiGlob
    lappend TypeCons IdenGrp1
    lappend TypeCons IdenGrp2
    lappend TypeCons IdenGrp3
    lappend TypeCons IdenGrp1Gris
    lappend TypeCons IdenGrp2Gris
    lappend TypeCons IdenGrp3Gris
    lappend TypeCons InterG12
    lappend TypeCons InterG13
    lappend TypeCons InterG23
    lappend TypeCons InterG12Gris
    lappend TypeCons InterG13Gris
    lappend TypeCons InterG23Gris
    lappend TypeCons PoinGrp1
    lappend TypeCons PoinGrp2
    lappend TypeCons PoinGrp3

    ValsDeCouleurs

    set Couleurs(Stock) {red blue yellow green magenta orange cyan brown forest_green pink goldenrod sea_green coral violet khaki navy_blue salmon sienna turquoise lime_green maroon spring_green medium_blue indian_red dim_gray light_gray gray}

    return
}



proc ValsDeCouleurs {} {
    global Couleurs
    set Couleurs(IdenGlob) "white black"
    set Couleurs(ConsGlob) "white DimGray"
    set Couleurs(SimiGlob) "black LightGray"
    set Couleurs(IdenGrp1) "black red"
    set Couleurs(IdenGrp2) "black blue"
    set Couleurs(IdenGrp3) "black yellow"
    set Couleurs(IdenGrp1Gris) "red LightGray"
    set Couleurs(IdenGrp2Gris) "blue LightGray"
    set Couleurs(IdenGrp3Gris) "yellow LightGray"
    set Couleurs(InterG12) "black magenta"
    set Couleurs(InterG13) "black coral"
    set Couleurs(InterG23) "black green"
    set Couleurs(InterG12Gris) "magenta LightGray"
    set Couleurs(InterG13Gris) "coral LightGray"
    set Couleurs(InterG23Gris) "green LightGray"
    set Couleurs(PoinGrp1) "red white"
    set Couleurs(PoinGrp2) "blue white"
    set Couleurs(PoinGrp3) "yellow white"
}



proc ChangeTkOptions {} {
    global Defauts

    set ba [set Defauts(BackAppli)]
    set ac "#0083ffff0000"
    set bk "#000000000000"

    option add *tearOff                        0
    option add *Toplevel.background            $ba

    option add *Button.background            $ba

    option add *Scale.background             $ba
    option add *Scale.Relief                 flat

    option add *Menubutton.background        $ba
    option add *Menubutton.activeBackground  $ac

    option add *Menu.background              $ba
    option add *Menu.activeBackground        $ac
    option add *Menu.activeForeground        $bk

    option add *Checkbutton.background       $ba
    option add *Checkbutton.activeBackground $ac
    option add *Checkbutton.activeForeground $bk
    option add *Checkbutton.highlightThickness 0
    option add *Checkbutton.Relief flat

    option add *Radiobutton.background       $ba
    option add *Radiobutton.activeBackground $ac
    option add *Radiobutton.activeForeground $bk
    option add *Radiobutton.highlightThickness 0
    option add *Radiobutton.Relief flat

    option add *Frame.background             $ba
    option add *Labelframe.background        $ba
    option add *Label.background             $ba
    option add *Grid.background              $ba
    option add *Scrollbar.background         $ba

    option add *Dialog.msg.background yellow
    
    option add *TCombobox.background "#ffffffffffff"
    option add *TCombobox.disabledBackground "#ffffffffffff"
    option add *TCombobox.selectBackground "#ffffffffffff"

    # define styles
    # Pour button
    ttk::style configure vdx.TButton \
	    -background black 
    ttk::style map vdx.TButton \
	    -background [list disabled #d9d9d9  active #ececec] \
	    -foreground [list disabled #a3a3a3] \
	    -relief [list {pressed !disabled} sunken]
    
    # Pour combobox
    ttk::style configure vdx.TCombobox \
	    -background black \
	    -foreground white \
	    -arrowcolor white \
	    -fieldbackground black \
	    -fieldforeground white
    ttk::style map vdx.TCombobox \
	    -background [list [list readonly disabled] black] \
	    -foreground [list [list readonly disabled] white] \
	    -disabledbackground [list [list readonly disabled] black] \
	    -disabledforeground [list [list readonly disabled] white] \
	    -fieldbackground [list [list readonly disabled] black] \
	    -fieldforeground [list [list readonly disabled] white]
    option add *vdx.TCombobox*Listbox.background black
    option add *vdx.TCombobox*Listbox.foreground white

    ttk::style configure vdx.TRadiobutton \
	    -background black \
	    -foreground white \
	    -relief flat \
	    -activebackground black \
	    -anchor w -justify left

    option add *nwoj.f.fsel.ctyp*Listbox.foreground white
    option add *nwoj.f.fsel.ctyp*Listbox.background black 
    option add *nwoj.f.fpai.ctyp*Listbox.foreground white
    option add *nwoj.f.fpai.ctyp*Listbox.background black 
    option add *nwoj.f.fsel.cfea*Listbox.foreground white
    option add *nwoj.f.fsel.cfea*Listbox.background black 
    option add *nwoj.f.fpai.cfea*Listbox.foreground white
    option add *nwoj.f.fpai.cfea*Listbox.background black 
    option add *vdx.TCombobox.background "#ffffffffffff"
    option add *vdx.TCombobox.disabledBackground "#ffffffffffff"
    option add *vdx.TCombobox.selectBackground "#ffffffffffff"

    return
}


proc SauveOrdalieDefauts {{f ""}} {
    global Defauts OrdEtcDir

    if {$f eq ""} {
	set f [file join $OrdEtcDir ".ordalierc"]
    }
    set foo [open $f w]
    foreach e [set Defauts(UserDef)] {
	set v [set Defauts($e)]
	regsub -all -- {\{} $v "\\\{" v
	regsub -all -- {\}} $v "\\\}" v
	regsub -all -- {\[} $v "\\\[" v
	regsub -all -- {\]} $v "\\\]" v
	regsub -all -- {\(} $v "\\\(" v
	regsub -all -- {\)} $v "\\\)" v
	regsub -all -- {\"} $v ""     v
	puts $foo "set Defauts($e) \"$v\""
    }
    close $foo

    return
}



