


package require Tk
#package require biotext
load ./libbiotext0.1.dylib
source ../biotext.tcl

### DATA ###############
# Create mapping
set Lignes "I white magenta
J white magenta
L white magenta
M white magenta
V white magenta
R white blue
K white blue
F white red
Y white red
W white red
D white forestgreen
B white forestgreen
E white forestgreen
Z black green
Q black green
P white black
G black orange
H black cyan
N black cyan
S white darkviolet
T white darkviolet
A white darkviolet
U white darkviolet
C white darkviolet
X black dimgrey
. black dimgrey
0 black white
1 black white
2 black white
3 black white
4 black white
5 black white
6 black white
7 black white
8 black white
9 black white
Space white white"
set Lmap [list]
foreach l [split $Lignes \n] {
    lassign [split [string trim $l] " "] n f b
    if {$n eq "Space"} {set n " "}
    lappend Lmap [list $n $f $b]
}

# Create random data
set a ".A.CDEFGH.I.KLMN.PQRST.VW.Y.A.CDEFGH.I.KLMN.PQRST.VW.Y..........."
set la [string length $a]
set nlines 300
set len    2000
for {set i 0} {$i < $nlines} {incr i} {
    set s ""
    for {set j 0} {$j < $len} {incr j} {
	set x [expr {int($la*rand())}]
	append s [string index $a $x]
    }
    lappend Ltmp $s
}
#set Ltmp     "..ACD.EFG.IHPP.ACD.EFG.IH."
#lappend Ltmp ".LPCD.EMGRIHI.LPCD.EMGRIKI"
#lappend Ltmp "..GCD.EYG.IH...GCD.EYG.IH."
#lappend Ltmp "..TCN.EFG.IH.KG.CN.EFG.IR."

# DATA DONE #######################
###################################

puts "create widget"
frame .f
grid .f -row 0 -column 0 -sticky news
grid columnconfig . 0 -weight 1
grid rowconfig    . 0 -weight 1

puts "avant BIOTEXT cmd"
# add/remove -borderwidth 0
biotext .f.b \
	-yscrollcommand ".f.sv set" \
	-xscrollcommand ".f.sh set" \
	-width 10 \
	-height 4 \
	-class Biotext

puts "APRES BIOTEXT cmd"
puts "config est :"
puts [join [lsort [.f.b configure]] \n] 
puts ""
scrollbar .f.sh \
	-orient horiz \
	-command ".f.b xview "
scrollbar .f.sv \
	-command ".f.b yview "
button .f.bti \
	-text "Index" \
	-bg blue -fg white \
	-command {puts [.f.b xview]}

set do 0
if {$do} {
    .f.b font family Courier size 18 weight normal
    .f.b sequences $Ltmp
    .f.b mapping $Lmap
    .f.b map on
    .f.b configure -state normal
    .f.b group 1 [list 0 1 2]
}
puts "avant gridification"
grid columnconfig .f 0 -weight 1
grid rowconfig    .f 0 -weight 1
grid .f.b  -row 0 -column 0 -sticky news
grid .f.sv -row 0 -column 1 -sticky ns
grid .f.sh -row 1 -column 0 -sticky ew
grid .f.bti -row 2 -column 0 -sticky w
update idletasks
puts "APRES gridification"
if {! $do} {
    puts ".f.b font family Courier size 8 weight normal"
    .f.b font family Courier size 8 weight normal
    puts ".f.b configure -width 123 -height 23"
    .f.b configure -width 123 -height 23
    puts ".f.b sequences Ltmp"
    .f.b sequences $Ltmp
    puts ".f.b mapping Lmap"
    .f.b mapping $Lmap
    .f.b map on
    puts ".f.b configure -state normal"
    .f.b configure -state normal
}
puts "TERMINE"

