#include "tkBiotext.h"
#include <tkMacOSXInt.h>
#include "tkFont.h"
#include <X11/Xft/Xft.h>


/* Taken from Tk8.6.0b1/macosx/tkMacOSXFont.c */

/*
 * The following structure represents our Macintosh-specific implementation
 * of a font object.
 */

typedef struct {
  TkFont font;		/* Stuff used by generic font package. Must
			 * be first in structure. */
  
  /*
   * The ATSU view of the font and other text properties. Used for drawing
   * and measuring.
   */
  
  ATSUFontID atsuFontId;	/* == FMFont. */
  ATSUTextLayout atsuLayout;	/* ATSU layout object, representing the whole
				 * text that ATSU sees with some option
				 * bits. */
  ATSUStyle atsuStyle;	/* ATSU style object, representing a run of
			 * text with the same properties. */
  
  /*
   * The QuickDraw view of the font. Used to configure controls.
   */
  
  FMFontFamily qdFont;	/* == FMFontFamilyId, Carbon replacement for
			 * QD face numbers. */
  short qdSize;		/* Font size in points. */
  short qdStyle;		/* QuickDraw style bits. */
} MacFont;

/*
 * Information about font families, initialized at startup time. Font
 * families are described by a mapping from UTF-8 names to MacOS font family
 * IDs. The whole list is kept as the sorted array "familyList", allocated
 * with ckrealloc().
 *
 * Note: This would have been easier, if we could just have used Tcl hash
 * arrays. Unfortunately there seems to be no pre-packaged
 * non-case-sensitive version of that available.
 */

typedef struct {
  const char * name;
  FMFontFamily familyId;
} MacFontFamily;

void BiotextDrawAlignment(register Biotext *BiotextPtr, Drawable d) 
{
  int hc, wc, LinesPerPage, ResPerPage, startXC;
  int startYC, yP, xP, i, j, k;
  Display *display = BiotextPtr->display;
  Tk_Window tkwin = BiotextPtr->tkwin;
  XftFont *ftFont = NULL;
  XftDraw *ftDraw = NULL;
  XftColor Cbg, Cfg;
  Visual *vis;
  Colormap cmap;
  int depth;
  
  if (BiotextPtr->xft) {
    vis = Tk_GetVisual(BiotextPtr->interp, tkwin, "default", &depth, &cmap);    
    ftDraw = XftDrawCreate(display, d, vis, cmap);
    ftFont = BiotextPtr->xftFont;
  }
  
  LinesPerPage = MIN(BiotextPtr->nbSeqs,BiotextPtr->heightChar);
  ResPerPage   = MIN(BiotextPtr->lgSeqs,BiotextPtr->widthChar);
  Tag *TM = BiotextPtr->TagMap;
  char **SM = BiotextPtr->SeqMat;
  int k0, lg, xP0, **ST = BiotextPtr->SeqT;
  char *Str = NULL;
  Str = ckalloc(ResPerPage+1);
  unsigned long fg;

  wc = BiotextPtr->charWidth;
  hc = BiotextPtr->charHeight;
  startXC = BiotextPtr->leftIndex;
  startYC = BiotextPtr->topIndex;

  yP = BiotextPtr->borderWidth + BiotextPtr->inset + BiotextPtr->ascent;

  /* Draw the chars matrix */
  if (BiotextPtr->xft) {
    for (i=startYC;i<startYC+LinesPerPage;i++) {
      xP0 = xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      lg  = 0;
      k0  = ST[i][startXC];
      /*
	fprintf(stderr,"%d %d %d s=>>",i,(int)BiotextPtr->SeqMat[i][0],(int)SM[i][0]);
	for (x=0;x<BiotextPtr->lgSeqs;x++) {
	fprintf(stderr,"%c",BiotextPtr->SeqMat[i][x]);
	}
	fprintf(stderr, "<<\n");
	if (k0 > BiotextPtr->nbMapping) {
	fprintf(stderr,"k0 %d i= %d startYC %d\n",k0, i, startYC);
	}
	fflush(stderr);
      */
      fg  = TM[k0].fg;
      Cfg = TM[k0].Cfg;
      Str[0]='\0';
      for (j=startXC;j<startXC+ResPerPage;j++) {
	k = ST[i][j];
	Cbg = TM[k].Cbg;
	XftDrawRect(ftDraw, &Cbg, xP, yP-BiotextPtr->ascent, wc, hc);
	
	if (TM[k].fg != fg) {
	  XftDrawString8(ftDraw, &Cfg, ftFont, xP0, yP, (XftChar8 *) Str, lg);
	  lg=0;
	  xP0 = xP;
	}
	Str[lg] = SM[i][j];
	fg = TM[k].fg;
	Cfg = TM[k].Cfg;
	lg++;
	
	xP += wc;
      }
      XftDrawString8(ftDraw, &Cfg, ftFont, xP0, yP, (XftChar8 *) Str, lg);
      yP += hc;
    } 
    XftDrawDestroy(ftDraw);
    //XftFontClose(display, ftFont);
  } else {
    for (i=startYC;i<startYC+LinesPerPage;i++) {
      xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      for (j=startXC;j<startXC+ResPerPage;j++) {
	k = ST[i][j];
	XDrawImageString(display, d, TM[k].gc, xP, yP, SM[i]+j, 1);
	xP += wc;
      }
      yP += hc;
    } 
  }

  return;
}


