#include "tkBiotext.h"
#include "tkUnixInt.h"
#include "tkFont.h"
#include <X11/Xft/Xft.h>

typedef struct UnixFtFace {
  XftFont *ftFont;
  XftFont *ft0Font;
  FcPattern *source;
  FcCharSet *charset;
  double angle;
} UnixFtFace;

typedef struct UnixFtFont {
  TkFont *font;
  UnixFtFace *faces;
  int nfaces;
  FcFontSet *fontset;
  FcPattern *pattern;
  
  Display *display;
  int screen;
  XftDraw *ftDraw;
  XftColor color;
} UnixFtFont;




void BiotextDrawAlignment(register Biotext *BiotextPtr, Drawable d) 
{
  int hc, wc, LinesPerPage, ResPerPage, startXC;
  int startYC, yP, xP, i, j, k;
  Display *display = BiotextPtr->display;
  Tk_Window tkwin = BiotextPtr->tkwin;
  XftFont *ftFont = NULL;
  XftDraw *ftDraw = NULL;
  XftColor Cbg, Cfg;
  Visual *vis;
  Colormap cmap;
  int depth;

  if (BiotextPtr->xft) {
    vis = Tk_GetVisual(BiotextPtr->interp, tkwin, "default", &depth, &cmap);    
    ftDraw = XftDrawCreate(display, d, vis, cmap);
    ftFont = BiotextPtr->xftFont;

    if (0) {
      ftFont = XftFontOpenName(display, Tk_ScreenNumber(tkwin), BiotextPtr->FontXft);
      if (! ftFont) {
	exit(1);
      }
    }
  }

  LinesPerPage = MIN(BiotextPtr->nbSeqs,BiotextPtr->heightChar);
  ResPerPage   = MIN(BiotextPtr->lgSeqs,BiotextPtr->widthChar);
  Tag *TM = BiotextPtr->TagMap;
  char **SM = BiotextPtr->SeqMat;
  int x, k0, lg, xP0, **ST = BiotextPtr->SeqT;
  //char Str[ResPerPage+1];
  char *Str = NULL;
  Str = ckalloc(ResPerPage+1);
  unsigned long fg;

  wc = BiotextPtr->charWidth;
  hc = BiotextPtr->charHeight;
  startXC = BiotextPtr->leftIndex;
  startYC = BiotextPtr->topIndex;

  yP = BiotextPtr->borderWidth + BiotextPtr->inset + BiotextPtr->ascent;
  if (BiotextPtr->xft) {
    for (i=startYC;i<startYC+LinesPerPage;i++) {
      xP0 = xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      lg  = 0;
      k0  = ST[i][startXC];
      /*
	fprintf(stderr,"%d %d %d s=>>",i,(int)BiotextPtr->SeqMat[i][0],(int)SM[i][0]);
	for (x=0;x<BiotextPtr->lgSeqs;x++) {
	fprintf(stderr,"%c",BiotextPtr->SeqMat[i][x]);
	}
	fprintf(stderr, "<<\n");
	if (k0 > BiotextPtr->nbMapping) {
	fprintf(stderr,"k0 %d i= %d startYC %d\n",k0, i, startYC);
	}
	fflush(stderr);
      */
      fg  = TM[k0].fg;
      Cfg = TM[k0].Cfg;
      Str[0]='\0';
      for (j=startXC;j<startXC+ResPerPage;j++) {
	k = ST[i][j];
	Cbg = TM[k].Cbg;
	XftDrawRect(ftDraw, &Cbg, xP, yP-BiotextPtr->ascent, wc, hc);
	
	if (TM[k].fg != fg) {
	  XftDrawString8(ftDraw, &Cfg, ftFont, xP0, yP, (XftChar8 *) Str, lg);
	  lg=0;
	  xP0 = xP;
	}
	Str[lg] = SM[i][j];
	fg = TM[k].fg;
	Cfg = TM[k].Cfg;
	lg++;
	
	xP += wc;
      }
      XftDrawString8(ftDraw, &Cfg, ftFont, xP0, yP, (XftChar8 *) Str, lg);
      yP += hc;
    } 
    XftDrawDestroy(ftDraw);
    //XftFontClose(display, ftFont);
  } else {
    for (i=startYC;i<startYC+LinesPerPage;i++) {
      xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      for (j=startXC;j<startXC+ResPerPage;j++) {
	k = ST[i][j];
	XDrawImageString(display, d, TM[k].gc, xP, yP, SM[i]+j, 1);
	xP += wc;
      }
      yP += hc;
    } 
  }

  return;
}

/*
 *--------------------------------------------------------------
 *
 * Tk_DrawImageString --
 *	Draw a character with a given color, and
 *      draws the underlying background of the bbox 
 *      containing those characters with a given 
 *      color.
 *
 * Results:
 *      None. 
 *
 * Side effects:
 *      None.      
 *
 *--------------------------------------------------------------
 */
void
Tk_DrawImageString(Display *display,
		   Drawable d,
		   Tk_Font tkfont,
		   GC gc,
		   int x, int y, 
		   char *string,
		   int length)
{
    XDrawImageString(display, d, gc, x, y, string, length);

  return;
}


