#include "tkBiotext.h"
#include "tkUnixInt.h"
#include "tkFont.h"

#ifdef USE_XFT
#include <X11/Xft/Xft.h>

typedef struct UnixFtFace {
  XftFont *ftFont;
  XftFont *ft0Font;
  FcPattern *source;
  FcCharSet *charset;
  double angle;
} UnixFtFace;

typedef struct UnixFtFont {
  TkFont *font;
  UnixFtFace *faces;
  int nfaces;
  FcFontSet *fontset;
  FcPattern *pattern;
  
  Display *display;
  int screen;
  XftDraw *ftDraw;
  XftColor color;
} UnixFtFont;
#else

#define FONTMAP_SHIFT		10

#define FONTMAP_PAGES		(1 << (sizeof(Tcl_UniChar)*8 - FONTMAP_SHIFT))
#define FONTMAP_BITSPERPAGE	(1 << FONTMAP_SHIFT)

typedef struct FontFamily {
  struct FontFamily *nextPtr;	/* Next in list of all known font families. */
  int refCount;		/* How many SubFonts are referring to this
			 * FontFamily. When the refCount drops to
			 * zero, this FontFamily may be freed. */
  /*
   * Key.
   */
  
  Tk_Uid foundry;		/* Foundry key for this FontFamily. */
  Tk_Uid faceName;		/* Face name key for this FontFamily. */
  Tcl_Encoding encoding;	/* Encoding key for this FontFamily. */
  
  /*
   * Derived properties.
   */
  
  int isTwoByteFont;		/* 1 if this is a double-byte font, 0
				 * otherwise. */
  char *fontMap[FONTMAP_PAGES];
				/* Two-level sparse table used to determine
				 * quickly if the specified character exists.
				 * As characters are encountered, more pages
				 * in this table are dynamically alloced. The
				 * contents of each page is a bitmask
				 * consisting of FONTMAP_BITSPERPAGE bits,
				 * representing whether this font can be used
				 * to display the given character at the
				 * corresponding bit position. The high bits
				 * of the character are used to pick which
				 * page of the table is used. */
} FontFamily;

typedef struct SubFont {
  char **fontMap;		/* Pointer to font map from the FontFamily,
				 * cached here to save a dereference. */
  XFontStruct *fontStructPtr;	/* The specific screen font that will be used
				 * when displaying/measuring chars belonging
				 * to the FontFamily. */
  FontFamily *familyPtr;	/* The FontFamily for this SubFont. */
} SubFont;

#define SUBFONT_SPACE		3
#define BASE_CHARS		256

typedef struct UnixFont {
  TkFont font;		/* Stuff used by generic font package. Must be
			 * first in structure. */
  SubFont staticSubFonts[SUBFONT_SPACE];
				/* Builtin space for a limited number of
				 * SubFonts. */
  int numSubFonts;		/* Length of following array. */
  SubFont *subFontArray;	/* Array of SubFonts that have been loaded in
				 * order to draw/measure all the characters
				 * encountered by this font so far. All fonts
				 * start off with one SubFont initialized by
				 * AllocFont() from the original set of font
				 * attributes. Usually points to
				 * staticSubFonts, but may point to malloced
				 * space if there are lots of SubFonts. */
  SubFont controlSubFont;	/* Font to use to display control-character
				 * expansions. */
  
  Display *display;		/* Display that owns font. */
  int pixelSize;		/* Original pixel size used when font was
				 * constructed. */
  TkXLFDAttributes xa;	/* Additional attributes that specify the
			 * preferred foundry and encoding to use when
			 * constructing additional SubFonts. */
  int widths[BASE_CHARS];	/* Widths of first 256 chars in the base font,
				 * for handling common case. */
  int underlinePos;		/* Offset from baseline to origin of underline
				 * bar (used when drawing underlined font)
				 * (pixels). */
  int barHeight;		/* Height of underline or overstrike bar (used
				 * when drawing underlined or strikeout font)
				 * (pixels). */
} UnixFont;

typedef struct EncodingAlias {
  const char *realName;	/* The real name of the encoding to load if
			 * the provided name matched the pattern. */
  const char *aliasPattern;	/* Pattern for encoding name, of the form that
				 * is acceptable to Tcl_StringMatch. */
} EncodingAlias;

typedef struct FontAttributes {
  TkFontAttributes fa;
  TkXLFDAttributes xa;
} FontAttributes;

typedef struct ThreadSpecificData {
    FontFamily *fontFamilyList; /* The list of font families that are
				 * currently loaded. As screen fonts are
				 * loaded, this list grows to hold information
				 * about what characters exist in each font
				 * family. */
  FontFamily controlFamily;	/* FontFamily used to handle control character
				 * expansions. The encoding of this FontFamily
				 * converts UTF-8 to backslashed escape
				 * sequences. */
} ThreadSpecificData;

#endif

void BiotextDrawAlignment(register Biotext *BiotextPtr, Drawable d) 
{
  int hc, wc, LinesPerPage, ResPerPage, startXC;
  int startYC, yP, xP, i, j, k;
  Display *display = BiotextPtr->display;
  Tk_Window tkwin = BiotextPtr->tkwin;
  int depth;

#ifdef USE_XFT
  XftColor Cbg, Cfg;
  Visual *vis;
  Colormap cmap;
  XftFont *ftFont = NULL;
  XftDraw *ftDraw = NULL;
  if (BiotextPtr->xft) {
    
    vis = Tk_GetVisual(BiotextPtr->interp, tkwin, "default", &depth, &cmap);    
    ftDraw = XftDrawCreate(display, d, vis, cmap);
    ftFont = BiotextPtr->xftFont;
    
    if (0) {
      ftFont = XftFontOpenName(display, Tk_ScreenNumber(tkwin), BiotextPtr->FontXft);
      if (! ftFont) {
	exit(1);
      }
    }
  }
#endif  

  LinesPerPage = MIN(BiotextPtr->nbSeqs,BiotextPtr->heightChar);
  ResPerPage   = MIN(BiotextPtr->lgSeqs,BiotextPtr->widthChar);
  Tag *TM = BiotextPtr->TagMap;
  char **SM = BiotextPtr->SeqMat;
  int x, k0, lg, xP0, **ST = BiotextPtr->SeqT;
  //char Str[ResPerPage+1];
  char *Str = NULL;
  Str = ckalloc(ResPerPage+1);
  unsigned long fg;

  wc = BiotextPtr->charWidth;
  hc = BiotextPtr->charHeight;
  startXC = BiotextPtr->leftIndex;
  startYC = BiotextPtr->topIndex;

  yP = BiotextPtr->borderWidth + BiotextPtr->inset + BiotextPtr->ascent;

  //if (BiotextPtr->xft == 1) {
#ifdef USE_XFT
    for (i=startYC;i<startYC+LinesPerPage;i++) {
      xP0 = xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      lg  = 0;
      k0  = ST[i][startXC];
      /*
	fprintf(stderr,"%d %d %d s=>>",i,(int)BiotextPtr->SeqMat[i][0],(int)SM[i][0]);
	for (x=0;x<BiotextPtr->lgSeqs;x++) {
	fprintf(stderr,"%c",BiotextPtr->SeqMat[i][x]);
	}
	fprintf(stderr, "<<\n");
	if (k0 > BiotextPtr->nbMapping) {
	fprintf(stderr,"k0 %d i= %d startYC %d\n",k0, i, startYC);
	}
	fflush(stderr);
      */
      fg  = TM[k0].fg;
      Cfg = TM[k0].Cfg;
      Str[0]='\0';
      for (j=startXC;j<startXC+ResPerPage;j++) {
	k = ST[i][j];
	Cbg = TM[k].Cbg;
	XftDrawRect(ftDraw, &Cbg, xP, yP-BiotextPtr->ascent, wc, hc);
	
	if (TM[k].fg != fg) {
	  XftDrawString8(ftDraw, &Cfg, ftFont, xP0, yP, (XftChar8 *) Str, lg);
	  lg=0;
	  xP0 = xP;
	}
	Str[lg] = SM[i][j];
	fg = TM[k].fg;
	Cfg = TM[k].Cfg;
	lg++;
	
	xP += wc;
      }
      XftDrawString8(ftDraw, &Cfg, ftFont, xP0, yP, (XftChar8 *) Str, lg);
      yP += hc;
    } 
    XftDrawDestroy(ftDraw);
    //XftFontClose(display, ftFont);
    //} else {
#else
    for (i=startYC;i<startYC+LinesPerPage;i++) {
      xP = BiotextPtr->borderWidth+BiotextPtr->inset;
      for (j=startXC;j<startXC+ResPerPage;j++) {
	k = ST[i][j];
	XDrawImageString(display, d, TM[k].gc, xP, yP, SM[i]+j, 1);
	xP += wc;
      }
      yP += hc;
    } 
    //}
#endif

  return;
}

/*
 *--------------------------------------------------------------
 *
 * Tk_DrawImageString --
 *	Draw a character with a given color, and
 *      draws the underlying background of the bbox 
 *      containing those characters with a given 
 *      color.
 *
 * Results:
 *      None. 
 *
 * Side effects:
 *      None.      
 *
 *--------------------------------------------------------------
 */
void
Tk_DrawImageString(Display *display,
		   Drawable d,
		   Tk_Font tkfont,
		   GC gc,
		   int x, int y, 
		   char *string,
		   int length)
{
    XDrawImageString(display, d, gc, x, y, string, length);

  return;
}


