#include "tkBiotext.h"
#include "tkFont.h"

/*
 * The following structure represents a font family. It is assumed that all
 * screen fonts constructed from the same "font family" share certain
 * properties; all screen fonts with the same "font family" point to a shared
 * instance of this structure. The most important shared property is the
 * character existence metrics, used to determine if a screen font can display
 * a given Unicode character.
 *
 * Under Windows, a "font family" is uniquely identified by its face name.
 */

#define FONTMAP_SHIFT	    10
#define FONTMAP_PAGES	    (1 << (sizeof(Tcl_UniChar)*8 - FONTMAP_SHIFT))
#define FONTMAP_BITSPERPAGE (1 << FONTMAP_SHIFT)

typedef struct FontFamily {
  struct FontFamily *nextPtr;
  /* Next in list of all known font families. */
  int refCount;
  /* How many SubFonts are referring to this
   * FontFamily. When the refCount drops to
   * zero, this FontFamily may be freed. */

  /*
   * Key.
   */
  
  Tk_Uid faceName;
  /* Face name key for this FontFamily. */
  
  /*
   * Derived properties.
   */
  
  Tcl_Encoding encoding;
  /* Encoding for this font family. */
  int isSymbolFont;
  /* Non-zero if this is a symbol font. */
  int isWideFont;
  /* 1 if this is a double-byte font, 0
   * otherwise. */
  BOOL (WINAPI *textOutProc)(HDC, int, int, TCHAR *, int);
  
  /* The procedure to use to draw text after it
   * has been converted from UTF-8 to the
   * encoding of this font. */
  BOOL (WINAPI *getTextExtentPoint32Proc)(HDC, TCHAR *, int, LPSIZE);
  
  /* The procedure to use to measure text after
   * it has been converted from UTF-8 to the
   * encoding of this font. */
  
  char *fontMap[FONTMAP_PAGES];
  /* Two-level sparse table used to determine
   * quickly if the specified character exists.
   * As characters are encountered, more pages
   * in this table are dynamically added. The
   * contents of each page is a bitmask
   * consisting of FONTMAP_BITSPERPAGE bits,
   * representing whether this font can be used
   * to display the given character at the
   * corresponding bit position. The high bits
   * of the character are used to pick which
   * page of the table is used. */
  
  /*
   * Cached Truetype font info.
   */
  
  int segCount;
  /* The length of the following arrays. */
  USHORT *startCount;
  /* Truetype information about the font, */
  USHORT *endCount;
  /* indicating which characters this font can
   * display (malloced). The format of this
   * information is (relatively) compact, but
   * would take longer to search than indexing
   * into the fontMap[][] table. */
} FontFamily;

#define SUBFONT_SPACE		3
#define BASE_CHARS		128

typedef struct SubFont {
  char **fontMap;
  /* Pointer to font map from the FontFamily,
   * cached here to save a dereference. */
  HFONT hFont;
  /* The specific screen font that will be used
   * when displaying/measuring chars belonging
   * to the FontFamily. */
  FontFamily *familyPtr;	/* The FontFamily for this SubFont. */
} SubFont;


typedef struct WinFont {
  TkFont font;
  /* Stuff used by generic font package. Must be
   * first in structure. */
  SubFont staticSubFonts[SUBFONT_SPACE];
  /* Builtin space for a limited number of
   * SubFonts. */
  int numSubFonts; 
  /* Length of following array. */
  SubFont *subFontArray; 
  /* Array of SubFonts that have been loaded in
   * order to draw/measure all the characters
   * encountered by this font so far. All fonts
   * start off with one SubFont initialized by
   * AllocFont() from the original set of font
   * attributes. Usually points to
   * staticSubFonts, but may point to malloced
   * space if there are lots of SubFonts. */
  
  HWND hwnd;
  /* Toplevel window of application that owns
   * this font, used for getting HDC for
   * offscreen measurements. */
  int pixelSize;
  /* Original pixel size used when font was
   * constructed. */
  int widths[BASE_CHARS];
  /* Widths of first 128 chars in the base font,
   * for handling common case. The base font is
   * always used to draw characters between
   * 0x0000 and 0x007f. */
} WinFont;


/*
 *--------------------------------------------------------------
 *
 * squarePtrDrawImageString --
 *	Draw a character with a given color, and
 *      draws the underlying background of the bbox 
 *      containing those characters with a given 
 *      color.
 *
 * Results:
 *      None. 
 *
 * Side effects:
 *      None.      
 *
 *--------------------------------------------------------------
 */
void
squareDrawImageString(Square *squarePtr,
		       Display *display,
		       Drawable d,
		       GC gc,
		       int x, int y, 
		       char *string,
		       int length)
{
  if (d == None) {
    return;
  }

  HDC hdc;
  LPTSTR lpchText;
  RECT rc;
  TkWinDCState dcState;
  WinFont *fontPtr;
  SubFont *lastSubFontPtr;
  int width, height;
  
  hdc        = TkWinGetDrawableDC(display,d,&dcState);
  lpchText = string;
  fontPtr = (WinFont *) gc->font;
  lastSubFontPtr = &fontPtr->subFontArray[0];
  SelectObject(hdc, lastSubFontPtr->hFont);
  display->request++;
  
  width      = squarePtr->charWidth;
  height     = squarePtr->charHeight;
  rc.left   = x;
  rc.top    = y;
  rc.right  = x + width;
  rc.bottom = y + height;

  SetBkMode(hdc, OPAQUE);
  SetBkColor(hdc, gc->background);
  SetTextColor(hdc, gc->foreground);
 
  DrawText(hdc, lpchText, length, &rc, DT_CENTER);

  return;
}

/*
 *--------------------------------------------------------------
 *
 * MyFontInfo --
 *      Gives font information. Only use non-Xft fonts
 *
 * Results:
 *      None. 
 *
 * Side effects:
 *      None.      
 *
 *--------------------------------------------------------------
 */
void
MyFontInfo(Square *squarePtr) 
{
  Tk_FontMetrics fm;
  Tk_Font tkfont = squarePtr->tkfont;

  Tk_GetFontMetrics(tkfont, &fm);
  squarePtr->charWidth = Tk_TextWidth(tkfont,"0", 1);
  squarePtr->charHeight  = fm.ascent+fm.descent;
  squarePtr->ascent = fm.ascent;
  squarePtr->descent = fm.descent;

  fprintf(stderr, "%s %d %d\n", Tk_NameOfFont(squarePtr->tkfont), squarePtr->charWidth, squarePtr->charHeight);
  fflush(stderr);

  return;
}



