#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>

#ifndef DLLEXPORT
#define DLLEXPORT __declspec(dllexport)
#endif 


static double SeqMatch(char *seq1, char *seq2, int l)	{
  int r, i;
  
  r = 0;
  for (i=0;i<l;i++) {
    if (seq1[i] != '.' && seq1[i] == seq2[i]) r++;
  }
  
  return (double)r;
}


static int Ccode_DoBootstrap (ClientData cdata, Tcl_Interp *interp, int objc, Tcl_Obj * CONST objv[]) {
  char *pil0, *pil;
  char **tseq=NULL;
  int seed, ip, nseq, i, j, alen;
  int l,l1,l2, *tlg;
  Tcl_Obj *Mres;	
  double dist, rd;
  double **tres=NULL;
  
  int pobjc;
  Tcl_Obj **pobjv;
  
  if (Tcl_ListObjGetElements(interp,objv[1],&pobjc,&pobjv) != TCL_OK) {
    return TCL_ERROR;
  }
  alen = pobjc;
  
  Tcl_GetIntFromObj(interp,objv[2],&seed);
  srand(seed);
  
  pil0 =Tcl_GetByteArrayFromObj(pobjv[1],&nseq);
  tseq =(char **)calloc(nseq+1,sizeof(char *));
  for (i=0; i<nseq; i++) { 
    tseq[i] = (char *)calloc(alen+1, sizeof(char));
  }
  tseq[nseq] = NULL;
  
  tres = (double **)calloc(nseq+1,sizeof(double *));
  for (i=0; i<nseq; i++) { 
    tres[i] = (double *)calloc(nseq+1, sizeof(double));
  }
  tres[nseq] = NULL;
  
  tlg = (int *)calloc(nseq+1, sizeof(int));
  
  for (i=0; i<alen; i++) {
    rd = ((double)rand()/((double)(RAND_MAX)+(double)(1)));
    ip = (int)(rd*(double)alen);
    
    pil=Tcl_GetByteArrayFromObj(pobjv[ip],&nseq);
    for (j=0; j<nseq; j++) {
      tseq[j][i]=pil[j];
    }
  }
  
  for (i=0; i<nseq; i++) {
    l=0;
    for (j=0;j<alen;j++) {
      if (tseq[i][j] != '.') l++;
    }
    tlg[i] = l;
  }
  
  for (i=0; i<nseq; i++) {
    tres[i][i] = 0.0;
    l1=tlg[i];
    for (j=i+1; j<nseq; j++) {
      l2=tlg[j];
      dist = 1. - (SeqMatch(tseq[i],tseq[j],alen)/(double)(l1<l2?l1:l2));
      tres[i][j] = tres[j][i] = dist;
    }
  }

  Mres = Tcl_NewListObj(0,NULL);
  for (i=0; i<nseq; i++) {
    for (j=0; j<nseq; j++) {
      Tcl_ListObjAppendElement(interp,Mres,Tcl_NewDoubleObj(tres[i][j]));
    }
  }
  
  Tcl_SetObjResult(interp,Mres);

  return TCL_OK;
}


static int Ccode_Pairwise (ClientData cdata, 
			   Tcl_Interp *interp, 
			   int objc, 
			   Tcl_Obj * CONST objv[]) {
  char *seq0, **tseq=NULL;
  int nseq, i, j, alen;
  int l,l1,l2;
  Tcl_Obj **Lseq, *Tpci, *pair;
  double **tres, *tlg, dist;
  
  if (Tcl_ListObjGetElements(interp,objv[1],&nseq,&Lseq) != TCL_OK) {
    return TCL_ERROR;
  }
  
  seq0 = Tcl_GetByteArrayFromObj(Lseq[1],&alen);
  tseq = (char **)ckalloc((nseq+1)*sizeof(char *));
  for (i=0; i<nseq; i++) { 
    tseq[i] = (char *)ckalloc((alen+1)*sizeof(char));
  }
  tseq[nseq] = NULL;
  tres = (double **)ckalloc((nseq+1)*sizeof(double *));
  for (i=0; i<nseq; i++) { 
    tres[i] = (double *)ckalloc((nseq+1)*sizeof(double));
  }
  tres[nseq] = NULL;
  tlg =(double *)ckalloc((nseq+1)*sizeof(double));
  
  for (i=0;i<nseq;i++) {
    tseq[i] = Tcl_GetByteArrayFromObj(Lseq[i],&alen);
    l=0;
    for (j=0;j<alen;j++) {
      if (tseq[i][j] != '.') l++;
    }
    tlg[i]=(double)l;
  }
  
  for (i=0; i<nseq-1; i++) {
    for (j=i+1; j<nseq; j++) {
      dist = SeqMatch(tseq[i],tseq[j],alen);
      tres[i][j] = tres[j][i] = dist;
    }
  }
  
  Tpci = Tcl_NewListObj(0,NULL);
  for (i=0; i<nseq; i++) {
    l1=tlg[i];
    tres[i][i]=(double)l1;
    for (j=0; j<nseq; j++) {
      l2=tlg[j];
      pair = Tcl_NewListObj(0,NULL);

      if (l1 == 0 || l2 == 0) {
	dist = 0.0;
      } else {
	dist = tres[i][j]/(double)(l1<=l2?l1:l2);
      }
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewDoubleObj(dist));
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewIntObj(l1));
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewIntObj(l2));
      Tcl_ListObjAppendElement(interp,pair,Tcl_NewDoubleObj((l1<l2?(double)(l1)/l2:(double)(l2)/l1)));
      Tcl_ListObjAppendElement(interp,Tpci,pair);
    }
  }
  
  Tcl_SetObjResult(interp,Tpci);

  ckfree((char *)tseq);
  ckfree((char *)tres);

  return TCL_OK;
}


static int Ccode_InitPosSGGS (ClientData cdata, 
			      Tcl_Interp *interp, 
			      int objc, 
			      Tcl_Obj * CONST objv[]) {
  // Routine pour calculer equivalences position
  // generale <--> posittion sequence
  // Argument : list (k v) k=nom v=seq

  char *seq, *sq0;
  int nseq, x, i, j, s, g;
  unsigned int slen;
  Tcl_Obj *Os0, *Res, *LSG, *LGS, *ONom, *Og, *Os;

  LSG = Tcl_NewListObj(0,NULL);
  LGS = Tcl_NewListObj(0,NULL);

  /* catch the sequence length */
  sq0 = Tcl_GetByteArrayFromObj(objv[1],&slen);
  seq = (char *)ckalloc((slen+1) * sizeof(char));

  for (x=0,i=0;i<nseq;i+=2,x+=2) {
    ONom= Tcl_NewStringObj(Tcl_GetString(objv[x]),-1);
    seq = Tcl_GetByteArrayFromObj(objv[x+1],&slen);
    
    g = s = -1;
    Os0 = Tcl_NewIntObj(0);
    Tcl_IncrRefCount(Os0); // # 1
    Os = Os0;
    /* loop over the seq g is general, s is seq pos */
    for (j=0;j<slen;j++) {
      g++;
      Og = Tcl_NewIntObj(g);
      if (seq[j] != '.') {
	s++;
	Os = Tcl_NewIntObj(s);
	Tcl_ListObjAppendElement(interp, LSG, ONom);
	Tcl_ListObjAppendElement(interp, LSG, Os);
	Tcl_ListObjAppendElement(interp, LSG, Og);
      }
      Tcl_ListObjAppendElement(interp, LGS, ONom);
      Tcl_ListObjAppendElement(interp, LGS, Og);
      Tcl_ListObjAppendElement(interp, LGS, Os);
    }
    /* output sequence length */
    s++;
    Tcl_ListObjAppendElement(interp, LSG, ONom);
    Tcl_ListObjAppendElement(interp, LSG, Tcl_NewIntObj(-1));
    Tcl_ListObjAppendElement(interp, LSG, Tcl_NewIntObj(s));
    Tcl_ListObjAppendElement(interp, LGS, ONom);
    Tcl_ListObjAppendElement(interp, LGS, Tcl_NewIntObj(-1));
    Tcl_ListObjAppendElement(interp, LGS, Tcl_NewIntObj(s));
  }

  Tcl_DecrRefCount(Os0); // # 0
  Res = Tcl_NewListObj(0,NULL);
  Tcl_ListObjAppendElement(interp,Res,LGS);
  Tcl_ListObjAppendElement(interp,Res,LSG);
  
  Tcl_SetObjResult(interp,Res);

  //ckfree(seq);

  return TCL_OK;
}


char **SV=NULL;
int Ccode_InitSeqView (ClientData cdata, Tcl_Interp *interp, int objc, Tcl_Obj * CONST objv[]) {

  char *sq0;
  int i, nseq,slen;
  Tcl_Obj **Lseq;

  if (Tcl_ListObjGetElements(interp,objv[1],&nseq,&Lseq) != TCL_OK) {
    return TCL_ERROR;
  }

  sq0 = Tcl_GetByteArrayFromObj(Lseq[1],&slen);
  SV =(char **)calloc(nseq+1,sizeof(char *));
  for (i=0; i<nseq; i++) { 
    SV[i] = (char *)calloc(slen+1, sizeof(char));
  }
  SV[nseq] = NULL;

  for (i=0;i<nseq;i++) {
    SV[i] = Tcl_GetByteArrayFromObj(Lseq[i],&slen);
    fprintf(stderr,"len %d\n",strlen(SV[i]));
    fprintf(stderr,"%s\n",SV[i]);
    fflush(stderr);
  }

  return TCL_OK;
}


int Ccode_AskSeqView (ClientData cdata, Tcl_Interp *interp, int objc, Tcl_Obj * CONST objv[]) {

  int x1,x2,y1,y2,i,j;
  Tcl_Obj *Res, *Os, *Vide, *SlashN;

  Tcl_GetIntFromObj(interp,objv[1],&x1);
  Tcl_GetIntFromObj(interp,objv[2],&x2);
  Tcl_GetIntFromObj(interp,objv[3],&y1);
  Tcl_GetIntFromObj(interp,objv[4],&y2);

  Res  = Tcl_NewListObj(0,NULL);
  Vide = Tcl_NewStringObj("",0);
  SlashN = Tcl_NewStringObj("\n",1);
  for (i=y1;i<=y2;i++) {
    for (j=x1;j<=x2;j++) {
      Os = Tcl_NewStringObj(SV[i]+j,1);
      Tcl_ListObjAppendElement(interp,Res,Os);
      Tcl_ListObjAppendElement(interp,Res,Os);
    }
    Tcl_ListObjAppendElement(interp,Res,SlashN);
    Tcl_ListObjAppendElement(interp,Res,Vide);
  }

  Tcl_SetObjResult(interp,Res);

  return TCL_OK;
}


int DLLEXPORT Tclordalie_Init(Tcl_Interp *interp) {
  if (Tcl_InitStubs(interp, "8.4" , 0) == 0L) {
    return TCL_ERROR;
  }
    
  Tcl_CreateObjCommand(interp,"Ccode_DoBootstrap",Ccode_DoBootstrap,NULL,NULL);
  Tcl_CreateObjCommand(interp,"Ccode_Pairwise",Ccode_Pairwise,NULL,NULL);
  Tcl_CreateObjCommand(interp,"Ccode_InitPosSGGS",Ccode_InitPosSGGS,NULL,NULL);
  Tcl_CreateObjCommand(interp,"Ccode_InitSeqView",Ccode_InitSeqView,NULL,NULL);
  Tcl_CreateObjCommand(interp,"Ccode_AskSeqView",Ccode_AskSeqView,NULL,NULL);

  Tcl_PkgProvide(interp,"tclordalie","0.1");

  return TCL_OK;
}

