#include <stdio.h>
#include "polyr.h"
#include <tcl.h>



/* parses the command line options */
int 
parse_options(Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]) 
{
  int i;
  int found;
  int founddowns=0,foundfilter=0;
  int atoi();
  double atof();
  
  fprintf(stderr, "objc %d\n", objc);
  i = 1;
  while (i < (objc - 1)) {
    found = 0;
    
    if (! strcmp(Tcl_GetString(objv[i]), "-sample")) {
      i++;
      if (Tcl_GetIntFromObj(interp,objv[i],&SAMPLE) != TCL_OK) {
	Tcl_WrongNumArgs(interp, 1, objv, "should be integer");
	return TCL_ERROR;
      }
      found = 1;
      fprintf(stderr, "==> sample %d\n", SAMPLE);
      i++;
    }

    if (! strcmp(Tcl_GetString(objv[i]), "-smooth")) {
      i++;
      SMOOTH = 1;
      found = 1;
      fprintf(stderr, "==> smoothing enabled\n");
    }

    if (! strcmp(Tcl_GetString(objv[i]), "-connolly")) {
      i++;
      CONNOLLY = 1;
      found = 1;
      fprintf(stderr, "==> connolly surface\n");
    }

    if (! strcmp(Tcl_GetString(objv[i]), "-expand")) {
      i++;
      if (Tcl_GetIntFromObj(interp,objv[i],&NEXPAND) != TCL_OK) {
	Tcl_WrongNumArgs(interp, 1, objv, "should be integer");
	return TCL_ERROR;
      }
      found = 1;
      fprintf(stderr, "==> expand %d times\n", NEXPAND);
      i++;
    }

    if (! strcmp(Tcl_GetString(objv[i]), "-contract")) {
      i++;
      if (Tcl_GetIntFromObj(interp,objv[i],&NCONTRACT) != TCL_OK) {
	Tcl_WrongNumArgs(interp, 1, objv, "should be integer");
	return TCL_ERROR;
      }
      found = 1;
      fprintf(stderr, "==> contract %d times\n", NCONTRACT);
      i++;
    }

    double rpol;
    if (!strcmp(Tcl_GetString(objv[i]), "-request")) {
      if (i >= (objc - 3)) {
	Tcl_WrongNumArgs(interp,1,objv, "not enough arguments for -request\n");
	return TCL_ERROR;
      }
      i++;
      found = 1;
      Tcl_GetDoubleFromObj(interp, objv[i++], &rpol);
      REQPOLS = (float)rpol;
      if ((REQPOLS<=0 || REQPOLS>=1000000)) {
	fprintf(stderr, "%s: number of pols out of bounds\n",MY_NAME);
	return TCL_ERROR;
      }
    }

    if (!strcmp(Tcl_GetString(objv[i]), "-d")) {
      if (i >= (objc - 5)) {
	fprintf(stderr, "%s: not enough arguments for -d\n",MY_NAME);
	return TCL_ERROR;
      }
      i++;
      found = 1;
      founddowns=1;
      DOWNSAMPL[0]=(float)atof(objv[i++]);
      DOWNSAMPL[1]=(float)atof(objv[i++]);
      DOWNSAMPL[2]=(float)atof(objv[i++]);
      if ((DOWNSAMPL[0]<1.0) || (DOWNSAMPL[1]<1.0) || (DOWNSAMPL[2]<1.0)) {
	fprintf(stderr, "%s: downsampling ratio out of bounds\n",MY_NAME);
	return TCL_ERROR;
      }
    }

    if (!strcmp(objv[i], "-D")) {
      if (founddowns) {
	fprintf(stderr, "%s: both -d and -D specified\n",MY_NAME);
	return TCL_ERROR;
      }
      if (i >= (objc - 3)) {
	fprintf(stderr, "%s: not enough arguments for -D\n",MY_NAME);
	return TCL_ERROR;
      }
      i++;
      found = 1;
    
      DOWNSAMPL[0]=DOWNSAMPL[1]=DOWNSAMPL[2]=(float)atof(objv[i++]);
      if ((DOWNSAMPL[0]<1.0)) {
	fprintf(stderr, "%s: downsampling ratio out of bounds\n",MY_NAME);
	return TCL_ERROR;
      }
    }

    if (! strcmp(Tcl_GetString(objv[i]), "-filter")) {
      i++;
      int filter;
      if ((Tcl_GetIntFromObj(interp, objv[i], &filter)) != TCL_OK) {
	Tcl_WrongNumArgs(interp, i, objv, "<filter> should be an integer");
	return TCL_ERROR;
      }
      FILTER[0]=FILTER[1]=FILTER[2]=(float)filter;
      if ((FILTER[0]<3.0)) {
	fprintf(stderr, "%s: filter ratio out of bounds\n",MY_NAME);
	return TCL_ERROR;
      }
      fprintf(stderr, "==> filtering [%d,%d,%d]\n",filter, filter, filter);
      i++;
    }
    if (!strcmp(objv[i], "-m")) {
      if (i >= (objc - 3)) {
	fprintf(stderr, "%s: not enough arguments for -d\n",MY_NAME);
	return TCL_ERROR;
      }
      i++;
      found = 1;
      
      MAXPOLS=atof(objv[i++]);
      if (MAXPOLS<0) {
	fprintf(stderr, "%s: maxpols must be positive\n",MY_NAME);
	return TCL_ERROR;
      }
    }
    if (!strcmp(Tcl_GetString(objv[i]), "-p")) {
      i++;
      found = 1;
      VERBOSE = 1;
      fprintf(stderr, "==> verbose\n");
    }
  }

  return TCL_OK;
}


/* writes the usage if no options given */
void 
usage()
{
  fprintf(stderr,"\nusage: %s [options] <filetype> <infile> <threshold>\n\n",MY_NAME);
  fprintf(stderr,"options:   -r <n>               Request number of polygons\n");
  fprintf(stderr,"           -f <x y z>           Mean filter using a boxfilter [x,y,z]\n");
  fprintf(stderr,"           -F <n>               Mean filter using a boxfilter [n,n,n]\n");
  fprintf(stderr,"           -d <x y z>           Downsample array by x, y and z\n");
  fprintf(stderr,"           -D <n>               Downsample array by n in all directions\n");
  fprintf(stderr,"           -m                   Min. number of connected tris (default 150)\n");
  fprintf(stderr,"           -o <name>            Geomview '.off' output name\n");
  fprintf(stderr,"           -n <name>            WTK '.nff' output name\n");
  fprintf(stderr,"           -i <name>            Inventor '.iv' output name\n");
  fprintf(stderr,"           -p                   Verbose operation\n");
  fprintf(stderr,"filetype:  -ana                 Analyze file\n");
  fprintf(stderr,"           -ms                  Multistruct file\n");
  fprintf(stderr,"           -hdf                 NCSA HDF file\n");
  fprintf(stderr,"           -raw <x y z>         Raw input file with dims\n");
  fprintf(stderr,"\n");
  fprintf(stderr,"default extensions are assumed for all filetypes except 'raw'.\n");
  fprintf(stderr,"\n");
  fprintf(stderr,"This program generates polygonal isosurfaces, for a given\n");
  fprintf(stderr,"threshold, contained in the input file.  The isosurface\n");
  fprintf(stderr,"is then saved to a polygon file. The input file can be an\n");
  fprintf(stderr,"analyze, multistruct or ncsa HDF file containing a three\n");
  fprintf(stderr,"dimensional Scientific Data Set.\n");
  fprintf(stderr,"Additionally you can specify the -raw input option for a file\n");
  fprintf(stderr,"of 8 bit fixed point data arranged with the x dimension\n");
  fprintf(stderr,"varying most rapidly, followed by y, and z varying most slowly.\n\n");
  fprintf(stderr,"The operations on are preformed in the following order:\n");
  fprintf(stderr,"  Filtering, Downsampling, Isosurfacing, Mesh decimation.\n");
  fprintf(stderr,"\n");
}
