/* reads hdf, analyze, ms and raw files! */

#include <stdio.h>
#include <malloc.h>
#include "ms.h"
#include "polyr.h"

/* is there HDF support? */
#ifdef HDF
#include "df.h"
#endif

extern float *VERTICES;
extern int NUM_VERTICES;

/* Converts little/big endian */
void 
convert2(char *ind)
{
  char tmp;
 
  tmp=ind[0];
  ind[0]=ind[1];
  ind[1]=tmp;
}

void 
convert4(char *ind)
{
  char tmp;

  tmp=ind[0];
  ind[0]=ind[3];
  ind[3]=tmp;
  tmp=ind[1];
  ind[1]=ind[2];
  ind[2]=tmp;
}

/* This subroutine will read in a HDF data file. */
int
get_hdf_data(filename, data, xdim, ydim, zdim, max, min)
char *filename;
float **data;
int *xdim, *ydim, *zdim;
float *max, *min;
{
#ifdef HDF
    int rank;
    int shape[3];
    int size;
    int ret;
    int maxmin;
    void get_max_min();		/* searches for max and min */
 
    sprintf(filename,"%s.hdf",filename);

    ret = DFSDgetdims(filename, &rank, shape, 3);
    if (ret != 0) {
	fprintf(stderr, "%s: error from DFSDgetdims, returns %d for %s\n",
		MY_NAME, ret, filename);
	return -1;
    }
    if (rank != 3) {
	fprintf(stderr, "%s: error, %s is rank %d; must be 3\n",
		MY_NAME, filename, rank);
	return -1;
    }
    *xdim = shape[2];
    *ydim = shape[1];
    *zdim = shape[0];

    printf("%s: reading HDF file '%s' [%dx%dx%d]\n",MY_NAME,
	   filename, *xdim, *ydim, *zdim);
    
    size = (*xdim) * (*ydim) * (*zdim) * sizeof(float);
    if ((*data = (float *) malloc(size)) == NULL) {
	fprintf(stderr, "%s: error, not enough memory for the data set\n",
		MY_NAME);
	return -1;
    }
    maxmin = DFSDgetrange(max, min);
    ret = DFSDgetdata(filename, rank, shape, *data);
    if (ret != 0) {
	fprintf(stderr, "%s: error from DFSDgetdata %d file %s\n",
		MY_NAME, ret, filename);
	return -1;
    }
    if (maxmin == -1)
	get_max_min(*data, *xdim, *ydim, *zdim, max, min);
    return 0;
#else
    fprintf(stderr,"%s: hdf support not installed\n",MY_NAME);
    exit(1);
#endif
}


/* Reads in a analyze header file */
int 
ReadAnalyzeHeader(char *name, unsigned short *pre, unsigned short *dim,
		  float *siz, int *lim, float *offset, float *scale) 
{
#ifdef CONVERT
  int i;
#endif
  char filename[80],dummy[80];
  FILE *pid;
  
  sprintf(filename,"%s.hdr",name);
  if(pid=fopen(filename,"r")) {
    fread(dummy,sizeof(unsigned char),42,pid);
    fread(dim,sizeof(unsigned short),3,pid);
    fread(dummy,sizeof(unsigned short),12,pid);
    fread(pre,sizeof(unsigned short),1,pid);
    fread(dummy,sizeof(unsigned short),3,pid);
    fread(siz,sizeof(float),3,pid);
    fread(dummy,sizeof(float),4,pid);
    fread(offset,sizeof(float),1,pid);
    fread(scale,sizeof(float),1,pid);
    fread(dummy,sizeof(float),6,pid);
    fread(lim,sizeof(int),2,pid);
#ifdef CONVERT
    for(i=0; i<3; i++){ 
      convert2((char *)&dim[i]);
      convert4((char *)&siz[i]);
    }
    convert2((char *)pre);
    convert4((char *)offset);
    convert4((char *)scale);
    convert4((char *)&lim[0]);
    convert4((char *)&lim[1]);
#endif

    fclose(pid);
    return(0);
  } else return(1);
}


/* Gets data from a analyze file */
int 
get_analyze(char *name, float **data,
	    int *dimxp, int *dimyp, int *dimzp,
	    float* delta, float *maxp, float *minp)
{
  unsigned short int pre,dim[3];
  float siz[3],offset=0,scale=1;
  int lim[2],i;     
  unsigned char *data8;
  unsigned short *data16;
  float *temp;
  char filename[80];
  FILE *pid;  
  void get_max_min();


  ReadAnalyzeHeader(name,&pre,&dim[0],&siz[0],&lim[0],&offset,&scale);
  if (scale==0) scale=1.;

/*
  printf(" %d %d %d\n",dim[0],dim[1],dim[2]);
  printf(" %f %f %f\n",siz[0],siz[1],siz[2]);
  printf(" %d %d \n",lim[0],lim[1]);
  printf(" %d %f %f \n",pre,offset,scale);
  fflush(stdout);
*/

  *dimxp=dim[0]; *dimyp=dim[1]; *dimzp=dim[2];
  delta[0]=siz[0]; delta[1]=siz[1]; delta[2]=siz[2];

  sprintf(filename,"%s.img",name);
  if(!(pid=fopen(filename,"r"))) {
    printf("could not open file...\n");
    return -1;
  }
  if (pre==8) {
    if ((data8 = (unsigned char *) malloc(dim[0]*dim[1]*dim[2]*sizeof(unsigned char))) == NULL) {
      fprintf(stderr, "%s: error, not enough memory for the data set\n",MY_NAME);
      return -1;
    }
  }
  else {
    if ((data16 = (unsigned short *) malloc(dim[0]*dim[1]*dim[2]*sizeof(unsigned short int))) == NULL) {
      fprintf(stderr, "%s: error, not enough memory for the data set %d\n",MY_NAME,
	      dim[0]*dim[1]*dim[2]*sizeof(unsigned short int));
      return -1;
    }
  }
  printf("%s: reading analyze file '%s' [%dx%dx%d]\n",MY_NAME,
	 filename, dim[0],dim[1],dim[2]);
  
  if (pre==8)
    fread(data8,sizeof(unsigned char),dim[0]*dim[1]*dim[2],pid);
  else
    fread(data16,sizeof(unsigned short),dim[0]*dim[1]*dim[2],pid);
  
#ifdef CONVERT
  if (pre==16)
    for (i=0;i<dim[0]*dim[1]*dim[2];i++) 
      convert2((char *)&(data16[i]));
#endif

  if ((*data = (float *) malloc(dim[0]*dim[1]*dim[2]*sizeof(float))) == NULL) {
    fprintf(stderr, "%s:error, not enough memory for the data set\n",MY_NAME);
    return -1;
  }
  temp=*data;
  if (pre==8) {
    for(i=0;i<dim[0]*dim[1]*dim[2];i++) {
      temp[i]=((float)data8[i]-offset)*scale;
    } 
    free(data8);
  }
  else {
    for(i=0;i<dim[0]*dim[1]*dim[2];i++) {
      if(lim[1]<0) temp[i]=
	((float)((signed short)data16[i])-offset)*scale;
      else temp[i]=((float)((unsigned short)data16[i])-offset)*scale;
    }      
    free(data16);
  }  
  get_max_min(*data, (int)*dimxp, (int)*dimyp, (int)*dimzp, maxp, minp);
  return 0;
}


/* Reads raw data with specified dimensions */
int
get_raw_data(filename, data, xdim, ydim, zdim, maxp, minp)
char *filename;
float **data;
int xdim, ydim, zdim;
float *maxp, *minp;
{
    int size,i;
    int ret;
    FILE *fd;
    float *temp;
    unsigned char *indata;
    void get_max_min();	       

    /* reads a simple raw unsigned char data array with a specified size ... */
    printf("%s: reading raw file '%s' [%dx%dx%d]\n",MY_NAME,
	   filename, xdim,ydim,zdim);

    size = xdim*ydim*zdim*sizeof(float);
    if ((*data = (float *) malloc(size)) == NULL) {
	fprintf(stderr, "%s: not enough memory for the data set\n",MY_NAME);
	return -1;
    }
    if ((indata = (unsigned char *)malloc(xdim*ydim*zdim)) == NULL) {
	fprintf(stderr, "%s: not enough memory for the data set\n",MY_NAME);
	return -1;
    }
    if ((fd = fopen(filename, "r")) == NULL) {
	fprintf(stderr, "%s: can't open file '%s'\n",MY_NAME,filename);
	return -1;
    }
    if (fread(indata, xdim*ydim*zdim*sizeof(unsigned char), 1, fd) != 1) {
	fprintf(stderr, "%s: short read from file %s (%d)\n",MY_NAME, filename, xdim*ydim*zdim);
	return -1;
    }
    fclose(fd);
    temp=*data;
    for (i=0; i<xdim*ydim*zdim; i++)
      temp[i]=(float)indata[i];
    free(indata);

    get_max_min(*data, xdim, ydim, zdim, maxp, minp);
    return 0;
}



/* Reads data from ptoft's multistruct format */
int
get_ms_data(filename, data, xdimp, ydimp, zdimp, d, maxp, minp)
char *filename;
float **data;
int *xdimp, *ydimp, *zdimp;
float *d, *maxp, *minp;
{
  int m,dim[3];
  int DoConvert=FALSE;
  float min[3];
  float delta[3];
  FILE *infile;
  MultiStruct ms;
  void get_max_min();	       
#define _00ND 20036

  /* append extension and open file */
  sprintf(filename,"%s.f3f",filename);
  if(!(infile=fopen(filename,"r"))) {
    fprintf(stderr, "%s: could not open file...\n",MY_NAME);
    return -1;
  }
  /* read the header */
  if (fread(&ms,sizeof(MultiStruct),1,infile)!=1) {
    fprintf(stderr,"%s: error reading file\n",MY_NAME);
    return -1;
  }
    if(ms.Id!=_00ND) {
    DoConvert=TRUE;
    convert4((char *)&ms.Id);
    if(ms.Id!=_00ND) 
      fprintf(stderr,"%s: Error reading MultiStruct (Converting)\n",MY_NAME); 
  }

  /* Converting MultiStruct header.*/
  if(DoConvert) {
    convert4((char *)&ms.LengthOfHeader);
    convert4((char *)&ms.Dim);
    convert4((char *)&ms.NoOfSamples);
    convert4((char *)&ms.Type);
    convert4((char *)&ms.ArrayType);
  }

  /* We do not display complex or other than 3D arrays! */
  if (ms.Dim!=3) {
    fprintf(stderr,"%s: only 3 dimensions supported\n",MY_NAME);
    return -1;
  }
  if (ms.ArrayType!=1) {
    fprintf(stderr,"%s: only real arrays supported\n",MY_NAME);
    return -1;
  }
  
  /* read sampling parameters */
  fread(dim,sizeof(int),3,infile);
  fread(min,sizeof(float),3,infile);
  fread(delta,sizeof(float),3,infile);

  if(DoConvert) 
    for (m=0;m<ms.Dim;m++) {
      convert4((char *)&(dim[m]));
      convert4((char *)&(min[m]));
      convert4((char *)&(delta[m]));
    }

  printf("%s: reading multistruct file '%s' [%dx%dx%d]\n",MY_NAME,
	 filename, dim[0],dim[1],dim[2]);
  
  /* allocate memory for the data */
  if ((*data = (float *) malloc(dim[0]*dim[1]*dim[2]*sizeof(float))) == NULL) {
    fprintf(stderr, "%s:error, not enough memory for the data set\n",MY_NAME);
    return -1;
  }
  
  /* reads the data in one gulf */
  if (!fread(*data,sizeof(float),ms.NoOfSamples,infile)) {
    fprintf(stderr, "%s: error reading file\n",MY_NAME);
    return -1;
  }


  /* update dimensions */
  *xdimp=dim[0]; *ydimp=dim[1]; *zdimp=dim[2];
  d[0]=delta[0]; d[1]=delta[1]; d[2]=delta[2];
 
  if(DoConvert) 
    for (m=0;m<ms.NoOfSamples;m++) 
      convert4((char *)&((*data)[m]));
 
  get_max_min(*data, (int)*xdimp, (int)*ydimp, (int)*zdimp, maxp, minp);
  return 0;
}

