#include <stdio.h>
#include "polyr.h"
#include <tcl.h>


static int NVDW = 110;
static float vdw[110];
static int sps[110][10000];

/* prototype functions */
int fill_grid_sides(int ***tmp, int nx, int ny, int nz);
int ***alloc_grid(int nx, int ny, int nz);
int dealloc_grid(int ***tmp, int nx, int ny, int nz);
int ***expand_mask(int ***grid);
int ***smooth_mask(int ***grid);
int ***contract_mask(int ***grid);

void 
show_grid(int ***grid) 
{
  int i, j, k;
  char c;

  fprintf(stderr, "\nDump of Grid [%d,%d,%d] :\n", XDIM, YDIM, ZDIM);
  for(i=0;i<ZDIM;i++) {
    for(j=0;j<YDIM;j++) {
      for(k=0;k<XDIM;k++) {
	if(grid[i][j][k] == 0) 
	  c='.';
	else if (grid[i][j][k] == 1)
	  c='O';
	else 
	  fprintf(stderr, "error : %d %d %d\n", i, j, k);
	fprintf(stderr, "%c",c);
      }
      fprintf(stderr,"\n");
    }
    fprintf(stderr,"\n\n");
  }

  return;
}


int init_vdw() 
{
  vdw[109]=0.;
  vdw[108]=0.; vdw[107]=0.; vdw[106]=0.;
  vdw[105]=0.; vdw[104]=0.; vdw[103]=0.;
  vdw[102]=0.; vdw[101]=0.; vdw[100]=0.;
  vdw[99]=0.; vdw[98]=0.; vdw[97]=0.;
 vdw[96]=0.; vdw[95]=0.; vdw[94]=0.;
 vdw[93]=0.; vdw[92]=1.86; vdw[91]=0.;
 vdw[90]=0.; vdw[89]=0.; vdw[88]=0.;
 vdw[87]=0.; vdw[86]=0.; vdw[85]=0.;
 vdw[84]=0.; vdw[83]=0.; vdw[82]=2.02;
 vdw[81]=1.96; vdw[80]=1.55; vdw[79]=1.66;
 vdw[78]=1.75; vdw[77]=0.; vdw[76]=0.;
 vdw[75]=0.; vdw[74]=0.; vdw[73]=0.;
 vdw[72]=0.; vdw[71]=0.; vdw[70]=0.;
 vdw[69]=0.; vdw[68]=0.; vdw[67]=0.;
 vdw[66]=0.; vdw[65]=0.; vdw[64]=0.;
 vdw[63]=0.; vdw[62]=0.; vdw[61]=0.;
 vdw[60]=0.; vdw[59]=0.; vdw[58]=0.;
 vdw[57]=0.; vdw[56]=0.; vdw[55]=0.;
 vdw[54]=2.16; vdw[53]=1.98; vdw[52]=2.06;
 vdw[51]=0.; vdw[50]=2.17; vdw[49]=1.93;
 vdw[48]=1.58; vdw[47]=1.72; vdw[46]=1.63;
 vdw[45]=0.; vdw[44]=0.; vdw[43]=0.;
 vdw[42]=0.; vdw[41]=0.; vdw[40]=0.;
 vdw[39]=0.; vdw[38]=0.; vdw[37]=0.;
 vdw[36]=2.02; vdw[35]=1.85; vdw[34]=1.9;
 vdw[33]=1.85; vdw[32]=0.; vdw[31]=1.87;
 vdw[30]=1.39; vdw[29]=1.4; vdw[28]=1.63;
 vdw[27]=2.23; vdw[26]=2.23; vdw[25]=2.23;
 vdw[24]=2.23; vdw[23]=2.23; vdw[22]=2.23;
 vdw[21]=2.23; vdw[20]=2.23; vdw[19]=2.75;
 vdw[18]=1.88; vdw[17]=1.75; vdw[16]=1.8;
 vdw[15]=1.8; vdw[14]=2.1; vdw[13]=1.7;
 vdw[12]=1.73; vdw[11]=2.27; vdw[10]=0.;
 vdw[9]=1.47; vdw[8]=1.52; vdw[7]=1.55;
 vdw[6]=1.70; vdw[5]=1.7; vdw[4]=1.7;
 vdw[3]=1.82; vdw[2]=1.4; vdw[1]=1.2;

 return TCL_OK;
}


int 
sample_vdw(int nmax) 
{
  int offset, r, i, j, k, n, v;

  fprintf(stderr, "sample_vdw %d\n",nmax);
  
  for (n=1; n<NVDW;n++) {
    if (vdw[n] == 0.) continue;
    
    r = (int)(vdw[n]*(float)SAMPLE+0.5);
    v = 1;
    /* fprintf(stderr, "natomic %d r %d\n", n, r);  */
    for (i=-r;i<=r;i++) {
      for (j=-r;j<=r;j++) {
	for (k=-r;k<=r;k++) {
	  if ((i*i + j*j + k*k) <= r*r) {
	    /* fprintf(stderr, "  r %2d | i %2d j %2d k %2d | v %d\n", r, i, j, k, v);  */
	    sps[n][v] = i;
	    v++;
	    sps[n][v] = j;
	    v++;
	    sps[n][v] = k;
	    v++;
	    /* v+=3; */
	  }
	}
      }
    }
    
    /* fprintf(stderr, "na %d vdw %4.2f r %d v %d\n", n, vdw[n], r, v-1); */
    sps[n][0] = v-1;
  }
  
  offset = (int)(vdw[nmax]*(float)SAMPLE+0.5);
  /* fprintf(stderr, "offset sphere %d nmax %d vdw %f\n", offset, nmax, vdw[nmax]); */

  return offset;
}

/* get min and max of atom set coordinates */
int
get_xmin_xmax(double **xyz, int ndata, float xxm[2][3]) 
{
  int i,j;
  float val;
  
  /* initialise min et max */
  for (i=0;i<2;i++) {
    if (i==0) 
      val = 999.;
    else 
      val = -999.;
    
    for (j=0;j<3;j++)
      xxm[i][j] = val;
  }

  /* [0] = min ; [1] = max */
  for (i=0;i<ndata;i++) {
    for (j=0;j<3;j++) {
      xxm[0][j] = xyz[i][j]<xxm[0][j]?xyz[i][j]:xxm[0][j];
      xxm[1][j] = xyz[i][j]>xxm[1][j]?xyz[i][j]:xxm[1][j];
    }
  }

  fprintf(stderr, "xmin %6.3f ymin %6.3f zmin %6.3f\n", xxm[0][0],xxm[0][1],xxm[0][2]);
  fprintf(stderr, "xmax %6.3f ymax %6.3f zmax %6.3f\n", xxm[1][0],xxm[1][1],xxm[1][2]);

  return TCL_OK;
}


/* define the grid */
int 
define_grid(int offset, float xxm[2][3], int *sx, int *sy, int *sz) 
{
  int i, j, gr[3];

  for (i=0;i<3;i++) {
    gr[i] = (int)(0.5+((float)xxm[1][i]-xxm[0][i])*(float)SAMPLE) + 3 + 2*offset;
    
    if(! (gr[i] % 2)) gr[i]++;
  }

  *sx = gr[0];
  *sy = gr[1];
  *sz = gr[2];

  return TCL_OK;
}


/* initialize and grid */
int 
init_grid(int ****tmp) 
{
  int i, j, k;

  for (i=0; i < ZDIM; i++) 
    for (j=0; j < YDIM; j++) 
      for (k=0; k < XDIM; k++) 
	*tmp[i][j][k] = 0;

  return;
}


/* setup parameters from data */
int 
setup_data(double **xyz, int *na, int ndata, float xxm[2][3], int *offset) 
{
  int a, i, j, k;
  int sx, sy, sz, maxna;

  maxna = -1;
  for (i=0; i<ndata; i++)
    maxna = na[i]>maxna?na[i]:maxna;

  get_xmin_xmax(xyz, ndata, xxm);
  init_vdw();
  *offset = sample_vdw(maxna);

  return TCL_OK;
}


int 
***do_connolly(int ***grid) 
{
  int n, i;

  /* water radius = 1.4 A */
  n = (int)(1.4*(float)SAMPLE+0.5);
  for(i=0; i <= n; i++)
    grid = expand_mask(grid);

  return grid;
}


int 
count_neighbours(int ***grid, int i, int j, int k, int val)
{
  int nbc;

  nbc = 
    grid[i-1][j  ][k  ] + grid[i+1][j  ][k  ] + 
    grid[i  ][j-1][k  ] + grid[i  ][j+1][k  ] + 
    grid[i  ][j  ][k-1] + grid[i  ][j  ][k+1] + 
    grid[i-1][j-1][k  ] + grid[i-1][j+1][k  ] + 
    grid[i+1][j-1][k  ] + grid[i+1][j+1][k  ] + 
    grid[i-1][j  ][k-1] + grid[i-1][j  ][k+1] + 
    grid[i+1][j  ][k-1] + grid[i+1][j  ][k+1] + 
    grid[i  ][j-1][k-1] + grid[i  ][j-1][k+1] + 
    grid[i  ][j+1][k-1] + grid[i  ][j+1][k+1] + 
    grid[i-1][j-1][k-1] + grid[i-1][j-1][k+1] + 
    grid[i-1][j+1][k-1] + grid[i-1][j+1][k+1] + 
    grid[i+1][j-1][k-1] + grid[i+1][j-1][k+1] + 
    grid[i+1][j+1][k-1] + grid[i+1][j+1][k+1];
  
  /* if we count the O's */
  if(val == 0) nbc = 26 - nbc;

  return nbc;
}


int 
***smooth_mask(int ***grid)
{
  int i, j, k, nbn, factor, ***tmp, nchg;

  fprintf(stderr, "smoothing mask ....\n");
  tmp = alloc_grid(XDIM, YDIM, ZDIM);
  fill_grid_sides(tmp, XDIM, YDIM, ZDIM);

  /* Mask Smoothing :
     For every non-mask point, the number of 
     neighbours which ARE IN the mask are counted; 
     if this number (0-26) is greater than or equal 
     to the parameter "FACTOR", the point is included
     in the mask 
  */

  factor = 15;
  nchg = 0;
  for(i=1; i<ZDIM-1; i++) {
    for(j=1; j<YDIM-1; j++) {
      for(k=1; k<XDIM-1; k++) {
	if(! grid[i][j][k]) {
	  nbn = count_neighbours(grid, i, j, k, 1);
	  if(nbn >= factor) {
	    tmp[i][j][k] = 1;
	    nchg++;
	  }
	  else tmp[i][j][k] = 0;
	} else {
	  tmp[i][j][k] = 1;
	}
      }
    }
  }

  dealloc_grid(grid, XDIM, YDIM, ZDIM);

  return tmp;
}


int 
***expand_mask(int ***grid) 
{
  int i, j, k, nbn;
  int ***tmp, ***tmp2, newx, newy, newz;
  
  /* create a new extended grid */
  newx = XDIM+2; newy = YDIM+2; newz = ZDIM+2;
  fprintf(stderr, "expanding to [%d,%d,%d] ....\n", newx, newy, newz);

  tmp  = alloc_grid(newx, newy, newz);
  tmp2 = alloc_grid(newx, newy, newz);

  fill_grid_sides(tmp , newx, newy, newz);
  fill_grid_sides(tmp2, newx, newy, newz);

  /* copy grid to tmp */
  for(i=1; i<newz-1; i++)
    for(j=1; j<newy-1; j++)
      for(k=1; k<newx-1; k++)
	tmp[i][j][k] = tmp2[i][j][k] = grid[i-1][j-1][k-1];

  /* do the expansion :
     For every non-mask point, the number of 
     neighbours (nbn) which ARE IN the mask are 
     counted; 
     If nbn >= 1, the point is included in the 
     mask.
  */
  for(i=1; i<newz-1; i++) {
    for(j=1; j<newy-1; j++) {
      for(k=1; k<newx-1; k++) {
	if(! tmp[i][j][k]) {
	  nbn = count_neighbours(tmp, i, j, k, 1);
	  if(nbn >= 1) tmp2[i][j][k] = 1;
	}
      }
    }
  }

  /* dealloc memory */
  dealloc_grid(grid, XDIM, YDIM, ZDIM);
  dealloc_grid(tmp, newx, newy, newz);

  XDIM = newx ; YDIM = newy; ZDIM = newz;

  return tmp2;
}


int 
***contract_mask(int ***grid) 
{
  int i, j, k, nbn, ***tmp, newx, newy, newz;

  /* create a new extended grid */
  newz = ZDIM-2; newy=YDIM-2; newx=XDIM-2;
  fprintf(stderr, "contracting to [%d,%d,%d] ....\n", newx, newy, newz);

  tmp = alloc_grid(newx, newy, newz);
  fill_grid_sides(tmp, newx, newy, newz);

  /* 
     for each point IN the mask, remove it from the 
     mask if there is ONE neighbour which is NOT in 
     the mask
  */
  for(i=1; i<ZDIM-1; i++) {
    for(j=1; j<YDIM-1; j++) {
      for(k=1; k<XDIM-1; k++) {
	if(grid[i][j][k]) {
	  nbn = count_neighbours(grid, i, j, k, 0);
	  if(nbn) tmp[i-1][j-1][k-1] = 0;
	  else tmp[i-1][j-1][k-1] = 1;
	} else {
	  tmp[i-1][j-1][k-1] = 0;
	}
      }
    }
  }
	 
  /* dealloc memory */
  dealloc_grid(grid , XDIM, YDIM, ZDIM);
  XDIM = newx ; YDIM = newy; ZDIM = newz;

  return tmp;
}


/* fills the grid with atoms with their vdw radius */
float 
*fill_data(double **xyz, int *na, int ndata, int offset, float xxm[2][3]) 
{
  int size, i, j, k, n, s, a, b, c, ***grid, ai[3];
  float *tmp;
  char p;

  grid = alloc_grid(XDIM, YDIM, ZDIM);

  for (i=0; i < ZDIM; i++) 
    for (j=0; j < YDIM; j++) 
      for (k=0; k < XDIM; k++) 
	grid[i][j][k] = 0;
  
  for(i=0; i<ndata; i++) {
    for(j=0; j<3; j++) {
      ai[j] = (int)(0.5+((float)xyz[i][j]-xxm[0][j])*(float)SAMPLE) + 1 + offset;
    }
    
    n = na[i];
    for (s=1; s <= sps[n][0]; s+=3) {
      a = ai[0] + sps[n][s];
      b = ai[1] + sps[n][s+1];
      c = ai[2] + sps[n][s+2];

      grid[c][b][a] = 1;
    }
  }
  /* show_grid(grid); */

  /* expand if required */
  for(i=0; i<NEXPAND; i++) 
    grid = expand_mask(grid);
  /* show_grid(grid); */

  if(SMOOTH) 
    grid = smooth_mask(grid);
  /* show_grid(grid); */
  
  /* contract if required */
  for(i=0; i<NCONTRACT; i++) 
    grid = contract_mask(grid);
  /* show_grid(grid); */

  if(CONNOLLY)
    grid = do_connolly(grid);

  /* fill the data array */
  tmp =(float *)ckalloc(XDIM*YDIM*ZDIM*sizeof(float));
  n = 0;
  for(i=0 ; i < ZDIM ; i++) {
    for(j=0 ; j < YDIM ; j++) { 
      for(k=0 ; k < XDIM ; k++) {
	tmp[n++] = (float)grid[i][j][k] + 48.;
      }
    }
  }

  /* dealloc memory */
  dealloc_grid(grid, XDIM, YDIM, ZDIM);

  return tmp;
}


/* parses the input data */
int 
parse_input(Tcl_Interp *interp, 
	    int ndata, 
	    Tcl_Obj **OData, 
	    double **xyz, 
	    int *na, 
	    int *tag) 
{
  int i, nval;
  Tcl_Obj **Oxyz;

  for(i=0;i<ndata;i++) {
    Tcl_ListObjGetElements(interp,OData[i],&nval,&Oxyz);
  
    Tcl_GetDoubleFromObj(interp,Oxyz[0],&xyz[i][0]);
    Tcl_GetDoubleFromObj(interp,Oxyz[1],&xyz[i][1]);
    Tcl_GetDoubleFromObj(interp,Oxyz[2],&xyz[i][2]);

    Tcl_GetIntFromObj(interp,Oxyz[3],&na[i]);
    Tcl_GetIntFromObj(interp,Oxyz[4],&tag[i]);
  }

  return TCL_OK;
}
  
/* jmw 06 63 20 13 28 */
