#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include "polyr.h"
#include <tcl.h>

int
fill_grid_sides(int ***tmp, int newx, int newy, int newz)
{
  int i, j, k;

  /* add points at 0 and newXX-1 */
  for (i=0; i < newz; i++) 
    for (j=0; j < newy; j++) 
      tmp[i][j][0] = tmp[i][j][newx-1] = 0;

  for (i=0; i < newz; i++) 
    for (k=0; k < newx; k++) 
      tmp[i][0][k] = tmp[i][newy-1][k] = 0;

  for (j=0; j < newy; j++) 
    for (k=0; k < newx; k++) 
      tmp[0][j][k] = tmp[newz-1][j][k] = 0;

  return;
}


int 
dealloc_grid(int ***tmp, int nx, int ny, int nz) 
{
  int i, j;
  
  for (i=0; i<nz; i++) {
    for (j=0; j<ny; j++) {
      ckfree((char *)tmp[i][j]);
    }
    ckfree((char *)tmp[i]);
  }
  ckfree((char *)tmp);

  return 1;
}


int 
***alloc_grid(int nx, int ny, int nz) 
{
  int i, j, ***tmp;
  
  tmp = (int ***)ckalloc(nz*sizeof(int **));
  for (i=0; i<nz; i++) {
    tmp[i] = (int **)ckalloc(ny*sizeof(int *));
    for (j=0; j<ny; j++) {
      tmp[i][j] = (int *)ckalloc(nx*sizeof(int));
    }
  }

  return tmp;
}


void
get_max_min(register float *data, int xdim, int ydim, int zdim, float *maxp, float *minp) 
{
  float *enddata;
  float max, min;
  
  enddata = data + (xdim * ydim * zdim);
  max = min = *(data++);
  
  for (; data < enddata; data++) {
    if (*data > max) max = *data;
    if (*data < min) min = *data;
  }
  *maxp = max; *minp = min;
}

void
calc_normal(p1, p2, p3, n)
float p1[3], p2[3], p3[3];
float n[3];
/* This subroutine calculates a normal from three vertices */
{
  float u[3], v[3];
  float sum, mag;
  
  u[0] = p3[0] - p2[0];
  u[1] = p3[1] - p2[1];
  u[2] = p3[2] - p2[2];
  
  v[0] = p1[0] - p2[0];
  v[1] = p1[1] - p2[1];
  v[2] = p1[2] - p2[2];
  
  n[0] = u[1] * v[2] - u[2] * v[1];
  n[1] = u[2] * v[0] - u[0] * v[2];
  n[2] = u[0] * v[1] - u[1] * v[0];
  
  sum = n[0] * n[0] + n[1] * n[1] + n[2] * n[2];
#ifdef mips
  mag = fsqrt(sum);
#else
  mag = (float) sqrt((double) sum);
#endif
  
  if (mag == 0.0)
    mag = 1.0;
  
  n[0] = n[0] / mag;
  n[1] = n[1] / mag;
  n[2] = n[2] / mag;
}


add_polygon(p1, p2, p3, n1, n2, n3)
     float *p1, *p2, *p3, *n1, *n2, *n3;
     /* This subroutine stores a polygon (triangle) in a list of vertices */
     /* and connectivity.  This list can then be written out in different */
     /* file formats. */
{
  unsigned size, offset;
  float *ptr;
  int vert_alloc();		/* allocates space for the vertices */
  
  /* see if we have enough space to store the vertices */
  if (NUM_VERTICES >= (VERT_LIMIT - 3)) {
    /* get more space */
    VERT_LIMIT += VERT_INCR;/* This is the space we need */
    size = VERT_LIMIT * sizeof(float);	/* size for malloc/realloc */
    if (vert_alloc(size) == -1) {
      fprintf(stderr, "error from vert_alloc\n");
      return -1;
    }
  }
  /* store the vertices */
  ptr = VERTICES + NUM_VERTICES * 3;
  *ptr++ = *p1++;		/* x of first vertex */
  *ptr++ = *p1++;		/* y of first vertex */
  *ptr++ = *p1++;		/* z of first vertex */
  *ptr++ = *p2++;		/* x of second vertex */
  *ptr++ = *p2++;		/* y of second vertex */
  *ptr++ = *p2++;		/* z of second vertex */
  *ptr++ = *p3++;		/* x of third vertex */
  *ptr++ = *p3++;		/* y of third vertex */
  *ptr++ = *p3++;		/* z of third vertex */
  
  ptr = NORMALS + NUM_VERTICES * 3;
  *ptr++ = *n1++; *ptr++ = *n1++; *ptr++ = *n1++;
  *ptr++ = *n2++; *ptr++ = *n2++; *ptr++ = *n2++;
  *ptr++ = *n3++; *ptr++ = *n3++; *ptr++ = *n3++;
  
  NUM_VERTICES += 3;
  
  return 0;
}


int 
vert_alloc(size)
int size;
/* This subroutine is for allocating memory for the vertex lists */
{
  
  /* flag to allocate memory from 'malloc' first time through */
  
  if (first_alloc) {
    /* use 'malloc' for the first time */
    if ((VERTICES = (float *) ckalloc(size * 3)) == NULL) {
      fprintf(stderr, "error, not enough memory to store vertices\n");
      return -1;
    }
    if ((NORMALS = (float *) ckalloc(size * 3)) == NULL) {
      fprintf(stderr, "error, not enough memory to store normals\n");
      return -1;
    }
    first_alloc = 0;	/* use 'realloc' from now on */
  } else {
    /* use 'realloc' from now on */
    if ((VERTICES = (float *) ckrealloc((char *) VERTICES, size * 3)) == NULL) {
      fprintf(stderr, "error, not enough memory to store vertices\n");
      return -1;
    }
    if ((NORMALS = (float *) ckrealloc((char *) NORMALS, size * 3)) == NULL) {
      fprintf(stderr, "error, not enough memory to store normals\n");
      return -1;
    }
  }
  
  return 0;
}


void
release_memory()
{
  first_alloc = 1;
  /* return; */

  if (VERTICES != NULL) {
    ckfree((char *) VERTICES);
    VERTICES = NULL;
  }
  if (NORMALS != NULL) {
    ckfree((char *) NORMALS);
    NORMALS = NULL;
  }
  NUM_VERTICES=0;
  VERT_LIMIT=0;
}


void
normvertices(float *delta)
{
  int i,y,z;
  float deltay,deltaz;

  /* normalizing in comparision to x! */
  y=((deltay=delta[1]/delta[0])!=1.0); 
  z=((deltaz=delta[2]/delta[0])!=1.0); 

  /* only run if there is something to adjust! */
  if (y||z) { 
    for(i=0; i<NUM_VERTICES; i++) {
      if (y)
	VERTICES[i*3+1]*=deltay;
      if (z)
	VERTICES[i*3+2]*=deltaz;
    }
  }
}

/*
smooth_norms() {
    printf("smoothing ...\n");
    smooth(VERTICES, NORMALS, NUM_VERTICES);
}
*/



