#define MAIN
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "polyr.h"
#include <tcl.h>


#ifndef DLLEXPORT
#define DLLEXPORT __declspec(dllexport)
#endif 


extern int NUM_VERTICES;
extern float *VERTICES;
extern float *NORMALS;

float 
*fill_data(double **xyz, int *na, int ndata, int offset, float xxm[2][3]);
Tcl_Obj 
*reduce(Tcl_Interp *interp, int offset, float xxm[2][3]);

void 
show_data(float *data) 
{
  int x, i, j, k;
  char c;

  fprintf(stderr, "\nDump of Data Array [%d,%d,%d]:\n", XDIM, YDIM, ZDIM);
  for(i=0;i<ZDIM;i++) {
    for(j=0;j<YDIM;j++) {
      for(k=0;k<XDIM;k++) {
	x= k + j*XDIM + i*XDIM*YDIM;
	if(data[x] == 48.) 
	  c='.';
	else if (data[x] == 49.) 
	  c='O';
	else 
	  fprintf(stderr, "error : %d %d %d\n", i, j, k);
	fprintf(stderr, "%c",c);
      }
      fprintf(stderr,"\n");
    }
    fprintf(stderr,"\n\n");
  }

  return;
}


int
TSurfObjCmd(ClientData clientData,
	    Tcl_Interp *interp,
	    int objc,
	    Tcl_Obj *const objv[]) 
{
  int i;
  int xdim, ydim, zdim;	/* the dimensions of the data */
  float min, max;
  float *data, *newdata;
  double **xyz;
  int offset, *na, *tag;
  int size[3], ndata;
  int newsize[3];
  float threshold, dsfactor;	      
  float *downsample(float *, int *, int *);  
  float xxm[2][3];
  Tcl_Obj **OData;
  
  /* get rutime name */
  strcpy(MY_NAME, Tcl_GetString(objv[0]));
  fprintf(stderr,"\n%s: <Jesper James Jensen 1995>\n",MY_NAME);
  
  /* initialisations */
  first_alloc  = 1;
  NUM_VERTICES = 0;
  VERT_LIMIT   = 0;
  VERTICES     = NULL;
  NORMALS      = NULL;
  NEXPAND      = 0;
  CONNOLLY     = 0;
  NCONTRACT    = 0;
  SMOOTH       = 0;
  
  /* get command line args */
  parse_options(interp, objc, objv);
  
  /* last arg are input data */
  Tcl_ListObjGetElements(interp, objv[(objc - 1)], &ndata, &OData);
  threshold = 48.5;
  
  /* parse data and fill table */
  na  = (int *)ckalloc(ndata*sizeof(int));
  tag = (int *)ckalloc(ndata*sizeof(int));
  xyz = (double **)ckalloc(ndata*sizeof(double *));
  for (i=0;i<ndata;i++)
    xyz[i] = (double *)ckalloc(3*sizeof(double));
  parse_input(interp, ndata, OData, xyz, na, tag);
  setup_data(xyz, na, ndata, xxm, &offset);
  define_grid(offset, xxm, &xdim, &ydim, &zdim);
  XDIM = size[0] = xdim;
  YDIM = size[1] = ydim;
  ZDIM = size[2] = zdim;
    
  data = fill_data(xyz, na, ndata, offset, xxm);
  /* show_data(data); */

  /* as grid size may have change ... */
  xdim = size[0] = XDIM;
  ydim = size[1] = YDIM;
  zdim = size[2] = ZDIM;
  
  tid1=clock();
  
  /* filtering of the input array */
  if (FILTER[1]) {
    fprintf(stderr,"%s: Mean filtering the array with a filter [%dx%dx%d]\n",
	   MY_NAME,FILTER[0],FILTER[1],FILTER[2]);
    boxfilter(&data,size,FILTER);
  }

  tid2=clock();

  /* Ok both downsampling and isosurfacing! */
  if ((DOWNSAMPL[0]!=1.0) ||(DOWNSAMPL[1]!=1.0) ||(DOWNSAMPL[2]!=1.0)) {
    if (VERBOSE)
      fprintf(stderr,"%s: Downsampling array with x:%.2f y:%.2f z:%.2f\n",
	      MY_NAME,DOWNSAMPL[0],DOWNSAMPL[1],DOWNSAMPL[2]);
    delta[0]*=DOWNSAMPL[0]; delta[1]*=DOWNSAMPL[1]; delta[2]*=DOWNSAMPL[2];
    xdim=(newsize[0]=xdim/DOWNSAMPL[0]);
    ydim=(newsize[1]=ydim/DOWNSAMPL[1]);
    zdim=(newsize[2]=zdim/DOWNSAMPL[2]);
    newdata=downsample(data,size,newsize);  
    ckfree((char *)data);
    fprintf(stderr,"%s: Doing isosurfacing\n",MY_NAME);
    if (iso_surface(newdata, xdim, ydim, zdim, threshold) == -1) {
      fprintf(stderr,"%s: error from iso_surface\n", MY_NAME);
      exit(1);
    }
  } else {
    /* just plain isosurfacing! */
    fprintf(stderr,"%s: Doing isosurfacing\n",MY_NAME);
    if (iso_surface(data, xdim, ydim, zdim, threshold) == -1) {
	fprintf(stderr,"%s: error from iso_surface\n", MY_NAME);
    }
  }
  
  /* polygon reduction */
  reduce(interp, offset, xxm);
  
  fflush(stderr);
  fflush(stdout);
  
  /* deallocation */
  release_memory();
  for (i=0;i<ndata;i++)
    ckfree((char *)xyz[i]);
  ckfree((char *)xyz);
  ckfree((char *)tag);
  ckfree((char *)na);
  ckfree((char *)data);
  
  return TCL_OK;
}


int DLLEXPORT Tsurf_Init (Tcl_Interp *interp) 
{
  if (Tcl_InitStubs(interp, "8.0" , 0) == NULL) {
    return TCL_ERROR;
  }
  
  Tcl_CreateObjCommand(interp, "tsurf", TSurfObjCmd, (ClientData) NULL, (Tcl_CmdDeleteProc *)NULL);

  Tcl_PkgProvide(interp,"tsurf","0.1");

  return TCL_OK;
}


/* --tool=memcheck --leak-check=full --show-reachable=yes */















