#!/usr/local/bin/tclsh

#package require tsurf
load Linux-x86_64/libtsurf0.1.so

set rad 10.
set step 10
set Lxyz [list]
for {set i 0} {$i <= 180} {incr i $step} {
    set phi [expr {1.0*$i*acos(-1.)/180.}]
    set z [expr {$rad*cos($phi)}]
    set r [expr {$rad*sin($phi)}]
    if {! ($i % 90)} {set na 16} {set na 6}
    for {set j -180} {$j < 180} {incr j $step} {
	set psi [expr {1.0*$j*acos(-1.)/180.}]
	
	set y [expr {$r*sin($psi)}]
	set x [expr {$r*cos($psi)}]

	if {$na == 16 && ! ($j % 90)} {set na 16} {set na 6}
	lappend Lxyz [list $x $y $z $na 1]
	#if {$i == 0 || $i == 180.} {break}
    }
}
lassign [tsurf -expand 2 -contract 2 -smooth -connolly $Lxyz] Lv Ln

set o [open "Lv.xyz" w]
puts $o [join $Lv \n]
foreach {x y z} $Lv {
    #puts $o "$x $y $z"
}
close $o
set o [open "Ln.xyz" w]
puts $o [join $Ln \n]
foreach {x y z} $Ln {
    #puts $o "$x $y $z"
}
close $o

exit


