/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package javaapplication1;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

/**
 *
 * @author legrand
 */
/**
 * Ouvre un fichier contenant une liste de dirichlet*
 */
public class DirichletMixture {

    String file;
    String[] ArrayOfResidu;
    ArrayList<DirichletDistribution> ArrayOfDirichlet;

    public DirichletMixture(String file) {
        this.file = file;
        ArrayOfDirichlet = new ArrayList();
        fileToSequence();
    }

    /**
     * convertie fichier contenant des distribution en un arraylist de dirchletdistribution*
     */
    void fileToSequence() {
        boolean endOfFile = false;
        try {
            FileReader fileAlignement = new FileReader(file);
            BufferedReader fileBuffer = new BufferedReader(fileAlignement);
            while (!endOfFile) {
                String fileLine = fileBuffer.readLine();
                String[] fileLineArray = fileLine.split(" ");

                if (fileLine == null) {
                    endOfFile = true;
                } else {

                    if (("Order").equals(fileLineArray[0])) {
                        ArrayOfResidu = new String[fileLineArray.length - 3];
                        for (int i = 3; i < fileLineArray.length; i++) {
                            ArrayOfResidu[i - 3] = fileLineArray[i];
                        }
                    } else if ("Mixture=".equals(fileLineArray[0])) {
                        DirichletDistribution dirichletDistribution = new DirichletDistribution(Double.parseDouble(fileLineArray[1]), ArrayOfResidu);

                        ArrayOfDirichlet.add(dirichletDistribution);
                    } else if ("Alpha=".equals(fileLineArray[0])) {
                        DirichletDistribution dirichletDistribution = ArrayOfDirichlet.get(ArrayOfDirichlet.size() - 1);
                        double[] ArrayOfScore = new double[ArrayOfResidu.length];
                        //System.out.println("");
                        for (int i = 1; i < ArrayOfResidu.length + 1; i++) {

                            ArrayOfScore[i - 1] = Double.parseDouble(fileLineArray[i]);
                            // System.out.println(Double.parseDouble(fileLineArray[i]));
                        }
                        //System.out.println("");
                        dirichletDistribution.setArrayOfScore(ArrayOfScore);
                    }
                }
            }
            fileBuffer.close();
        } catch (Exception e) {
            //System.out.println("ERREUR");
        }
    }

    /**
     * Calcul la probabilité de trouver un acide aminé grace aux ditsributions
     * de dirichlet
     *
     * @param AminoAcid
     * @return
     */
    double Prob(String AminoAcid) {
        //cas des gaps
        if (("-".equals(AminoAcid)) || (".".equals(AminoAcid))) {

            return 0.05;

        }
        double[] scorem1 = new double[ArrayOfDirichlet.size()];
        double sumscorem1 = 0;
        // on parcours les distribution et on obtient la probabilité pour un résidu  
        for (int distribution = 0; distribution < ArrayOfDirichlet.size(); distribution++) {
            scorem1[distribution] = ArrayOfDirichlet.get(distribution).probabilityOfAminoAcidCorrected(AminoAcid);
            //System.out.println(scorem1[distribution]);
            sumscorem1 += scorem1[distribution];
        }
        //System.out.println(" score m1:"+scorem1[5]);
        double prob = 0;
        for (int distribution = 0; distribution < ArrayOfDirichlet.size(); distribution++) {
            //on  calcule la probabilite d'un aa
            prob += (scorem1[distribution] / sumscorem1) * ((ArrayOfDirichlet.get(distribution).scoreOfAminoAcid(AminoAcid)) / (ArrayOfDirichlet.get(distribution).sum));
            //puis on ajoute le residu dans la distribution
            ArrayOfDirichlet.get(distribution).addResidu(AminoAcid);
        }
        //System.out.println(prob);
        return prob;
    }
}
