/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package javaapplication1;

/**
 *
 * @author legrand
 */
public class DirichletDistribution {

    double sum;
    String[] ArrayOfResidu;
    double[] ArrayOfScore;
    int NumberOfResidu;
    double Mixture;//poid de la distribution

    public DirichletDistribution(double Mixture, String[] ArrayOfResidu) {
        this.Mixture = Mixture;
        this.ArrayOfResidu = ArrayOfResidu;

    }

    /**
     * Ajoute 1 au residu obtenu et met a jour la somme de la distribution *
     */
    void addResidu(String residu) {
        for (int i = 0; i < ArrayOfResidu.length; i++) {
            //System.out.println(ArrayOfResidu[i]);
            if (ArrayOfResidu[i].equals(residu)) {
                ArrayOfScore[i] += 1;
                sum += 1;
            }
        }

    }

    /**
     * Modifier la liste de score et on met a jours la somme des scores
     *
     * @param ArrayOfScore
     */
    public void setArrayOfScore(double[] ArrayOfScore) {
        this.ArrayOfScore = ArrayOfScore;
        calculSum();//on met a jours le score
    }

    /**
     * Renvois la probabilité du residu multiplier par le coefficient de la
     * distribution/sum,0.000000001 si il n'existe pas*
     */
    double probabilityOfAminoAcidCorrected(String residu) {

        for (int i = 0; i < ArrayOfResidu.length; i++) {
            if (ArrayOfResidu[i].equals(residu)) {
                return Mixture * (ArrayOfScore[i] / sum);
            }
        }

        return 0.1;
    }

    /**
     * Renvois la probabilité de l'acide aminé envoyé
     *
     * @param AminoAcid
     * @return score amino Acid
     */
    double scoreOfAminoAcid(String AminoAcid) {
        for (int i = 0; i < ArrayOfResidu.length; i++) {
            if (ArrayOfResidu[i].equals(AminoAcid)) {
                return ArrayOfScore[i];
            }
        }

        return 0.1;
    }

    /**
     * met a jour la somme de la frequence de tous les residu
     */
    private void calculSum() {
        sum = 0;
        for (int i = 0; i < ArrayOfScore.length; i++) {
            sum += ArrayOfScore[i];

        }
    }

    /**
     * Affiche la distribution
     */
    void printdirichlet() {
        for (String R : ArrayOfResidu) {
            System.out.print(R);
        }
        System.out.println("");
        for (Double d : ArrayOfScore) {
            System.out.print(d);

        }
        System.out.println("");
    }

}
