##########################################################################
# VaRank 1.0                                                             #
#                                                                        #
# VaRank: a simple and powerful tool for ranking genetic variants        #
#                                                                        #
# Copyright (C) 2014 Veronique Geoffroy (veronique.geoffroy@inserm.fr)   # 
#                    Jean Muller (jeanmuller@unistra.fr)                 # 
#                                                                        #
# Please cite the following article:                                     #
#    XXX                                                                 #
#                                                                        #
# This is part of VaRank source code.                                    #
#                                                                        #
# This program is free software; you can redistribute it and/or          #
# modify it under the terms of the GNU General Public License            # 
# as published by the Free Software Foundation; either version 3         # 
# of the License, or (at your option) any later version.                 #
#                                                                        #
# This program is distributed in the hope that it will be useful,        # 
# but WITHOUT ANY WARRANTY; without even the implied warranty of         #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          #
# GNU General Public License for more details.                           #
#                                                                        #
# You should have received a copy of the GNU General Public License      #
# along with this program; If not, see <http://www.gnu.org/licenses/>.   #
##########################################################################

proc DescendingSortOnElement1 {X Y {N 1}} {
    return [expr {[lindex $X $N]<[lindex $Y $N]}]
}

##############################################################################
#                          WORKING WITH FILES
##############################################################################
proc FirstLineFromFile {{File ""}} {

    if {[regexp ".gz$" $File]} {
	set F [open "|gzip -cd $File"] 
    } else {
	set F [open "$File"]
    }

    set L_Lines {}
    set First 1

    while {[gets $F Line]>=0} {
	if {$First} {set First 0;break}
    }
    close $F

    return $Line
}

proc ContentFromFile {{File ""}} {
    if {[string equal $File ""]} {return ""}
    set f     [open $File r]
    set Text [read -nonewline $f]
    close $f
    return $Text
}

proc LinesFromFile {{File ""}} {
    return [split [ContentFromFile $File] "\n"]
}

proc ReplaceTextInFile {NewText fichier} {
    set    fifi [open $fichier w]
    puts  $fifi $NewText
    close $fifi 
    return 1
}


proc WriteTextInFile {text fichier} {
    set    fifi [open $fichier a]
    puts  $fifi $text
    close $fifi 
    return 1
}





##############################################################################
#                          WORKING WITH rsID
##############################################################################

proc isNotAnRS {rs} {
        if {[regexp "^rs\[0-9\]+$" $rs]} {return 0} else {return 1}
}

