#!/usr/bin/env tclsh

##########################################################################
# VaRank 1.0                                                             #
#                                                                        #
# VaRank: a simple and powerful tool for ranking genetic variants        #
#                                                                        #
# Copyright (C) 2014 Veronique Geoffroy (veronique.geoffroy@inserm.fr)   # 
#                    Jean Muller (jeanmuller@unistra.fr)                 # 
#                                                                        #
# Please cite the following article:                                     #
#    XXX                                                                 #
#                                                                        #
# This is part of VaRank source code.                                    #
#                                                                        #
# This program is free software; you can redistribute it and/or          #
# modify it under the terms of the GNU General Public License            # 
# as published by the Free Software Foundation; either version 3         # 
# of the License, or (at your option) any later version.                 #
#                                                                        #
# This program is distributed in the hope that it will be useful,        # 
# but WITHOUT ANY WARRANTY; without even the implied warranty of         #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          #
# GNU General Public License for more details.                           #
#                                                                        #
# You should have received a copy of the GNU General Public License      #
# along with this program; If not, see <http://www.gnu.org/licenses/>.   #
##########################################################################

global g_VaRank
global g_allPatients
global g_lPatientsOf
global g_vcfINFOS
global g_ALAMUT
global g_lScore
global g_deltaSSF
global g_deltaMES
global g_deltaNNS
global g_Statistics

## Checking for environment variables needed (if all are defined).
foreach var "VARANK ALAMUT" {
    if {![info exists env($var)]} {
	puts "\"$var\" environment variable not specified. Please defined it before running VaRank. Exit"; exit
    }
}
set g_VaRank(sourcesDir) "$env(VARANK)/sources"
set g_VaRank(DB)         "$env(VARANK)/Databases"
set g_VaRank(alamutDir)  "$env(ALAMUT)"
if {[info exists env(PPH)] && $env(PPH)!=""} {
    set g_VaRank(pph2Dir) "$env(PPH)"
} else {set g_VaRank(pph2Dir) ""}

puts "Tcl/Tk version: [info tclversion]"

source $g_VaRank(sourcesDir)/VaRank-alamut.tcl
source $g_VaRank(sourcesDir)/VaRank-config.tcl
source $g_VaRank(sourcesDir)/VaRank-filters.tcl
source $g_VaRank(sourcesDir)/VaRank-general.tcl
source $g_VaRank(sourcesDir)/VaRank-help.tcl
source $g_VaRank(sourcesDir)/VaRank-pph2.tcl
source $g_VaRank(sourcesDir)/VaRank-ranking.tcl
source $g_VaRank(sourcesDir)/VaRank-scoring.tcl
source $g_VaRank(sourcesDir)/VaRank-stats.tcl
source $g_VaRank(sourcesDir)/VaRank-vcf.tcl


#To activate the debug mode and see
#set g_VaRank(DEBUG) 1

## Initialisation of the statistics
if {![info exists g_Statistics]} {
    set g_Statistics(all,Null) 0
    set g_Statistics(all,Het)  0
    set g_Statistics(all,Hom)  0
    set g_Statistics(all,Both) 0
    set g_Statistics(all)      0
}
    

## No argument given:
if {$argv == ""} {
    puts "Arguments are missing see help below\n"
    showHelp; exit
}

## Needing help?
if {[regexp -nocase "help" $argv]} {showHelp; exit}

## Downloading configuration:
configureVaRank $argv 
ExternalAnnotations

## Downloading VCF files data:
parseVCFfiles 

## Creation of the alamut input file (1 for all patients)
createAlamutInputFile 

## Running alamut:
runAlamut 

## Downloading alamut data:
parseAlamutFile 

## Creation of the PolyPhen-2 input file:
## If no missense to be analyzed we skip this step
if {[createPPH2Input]!=0} {
    ## Runnning PPH2:
    runPPH2-1by1 
} 
## Updating alamut data with PPH2 data:
integratePPH2dataIntoAlamut

## Scoring genetic variants:
scoreAllTheID

## Creation of the output files:
writeAllVariantsRankingByVar
writeAllVariantsRankingByGene

## Filtering the output files:
executeFilters

# Statistics
writeAllStatistics

puts "...VaRank Statistics: [set g_Statistics(all)] variation(s): [set g_Statistics(all,Hom)] homozygous, [set g_Statistics(all,Het)] heterozygous, [set g_Statistics(all,Both)] both and [set g_Statistics(all,Null)] empty"
puts ""
puts "...VaRank is done with the analysis ([clock format [clock seconds] -format "%B %d %Y - %H:%M"])"


